Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: i.mpi_wrapper.F90
PROGRAM NAME: mpi_wrapper
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   976  vec  (   4): Vectorized array expression.
   976  vec  (  29): ADB is used for array.: aa_localmax
   976  vec  (  29): ADB is used for array.: a_localmax
   978  vec  (   3): Unvectorized loop.
   980  opt  (1017): Subroutine call prevents optimization.
   980  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperirecv_dble_1d
   985  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
   991  vec  (   1): Vectorized loop.
   991  vec  (  29): ADB is used for array.: aa_localmax
   992  opt  (1019): Feedback of scalar value from one loop pass to another.
   992  vec  (  26): Macro operation Max/Min.
   998  vec  (   4): Vectorized array expression.
   998  vec  (  29): ADB is used for array.: a_buf
   998  vec  (  29): ADB is used for array.: a_globalmax
   999  vec  (   3): Unvectorized loop.
  1001  opt  (1017): Subroutine call prevents optimization.
  1001  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperisend_dble_1d
  1006  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
  1014  vec  (   4): Vectorized array expression.
  1014  vec  (  29): ADB is used for array.: a_buf
  1014  vec  (  29): ADB is used for array.: a_localmax
  1030  vec  (   4): Vectorized array expression.
  1030  vec  (  29): ADB is used for array.: a_globalmax
  1030  vec  (  29): ADB is used for array.: a_buf
  1080  vec  (   4): Vectorized array expression.
  1080  vec  (  29): ADB is used for array.: aa_locallogical
  1080  vec  (  29): ADB is used for array.: a_locallogical
  1082  vec  (   3): Unvectorized loop.
  1084  opt  (1017): Subroutine call prevents optimization.
  1084  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperirecv_logical_1d
  1089  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
  1095  vec  (   1): Vectorized loop.
  1095  vec  (  29): ADB is used for array.: aa_locallogical
  1102  vec  (   4): Vectorized array expression.
  1102  vec  (  29): ADB is used for array.: a_buf
  1102  vec  (  29): ADB is used for array.: a_globallogical
  1103  vec  (   3): Unvectorized loop.
  1105  opt  (1017): Subroutine call prevents optimization.
  1105  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperisend_logical_1d
  1110  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
  1118  vec  (   4): Vectorized array expression.
  1118  vec  (  29): ADB is used for array.: a_buf
  1118  vec  (  29): ADB is used for array.: a_locallogical
  1134  vec  (   4): Vectorized array expression.
  1134  vec  (  29): ADB is used for array.: a_globallogical
  1134  vec  (  29): ADB is used for array.: a_buf
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: i.mpi_wrapper.F90
PROGRAM NAME: mpi_wrapper
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != MPI 関連ルーチン
     2  !
     3  != MPI related routines
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: mpi_wrapper.F90,v 1.7 2013/09/16 12:07:39 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module mpi_wrapper
    13    !
    14    != MPI 関連ルーチン
    15    !
    16    != MPI related routines
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! MPI 関係の変数の管理と MPI 関係ラッパールーチンのモジュール.
    21    !
    22    ! This is a module containing MPI-related variables and wrapper routines.
    23    !
    24    !== Procedures List
    25    !
    26  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    27  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    28  !!$  ! ------------            :: ------------
    29  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    31    !
    32    !== NAMELIST
    33    !
    34  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    35    !
    36  
    37    ! モジュール引用 ; USE statements
    38    !
    39  
    40    ! 種別型パラメタ
    41    ! Kind type parameter
    42    !
    43    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    44      &                 STRING, &  ! 文字列.       Strings.
    45      &                 TOKEN      ! キーワード.   Keywords.
    46  
    47  
    48    ! MPI
    49    !
    50    use mpi
    51  
    52  
    53    ! 宣言文 ; Declaration statements
    54    !
    55    implicit none
    56    private
    57  
    58    ! 公開手続き
    59    ! Public procedure
    60    !
    61    public :: MPIWrapperInit
    62    public :: MPIWrapperFinalize
    63    public :: MPIWrapperISend
    64    public :: MPIWrapperIRecv
    65    public :: MPIWrapperWait
    66    public :: MPIWrapperFindMaxVal
    67    public :: MPIWrapperChkTrue
    68  
    69    ! 公開変数
    70    ! Public variables
    71    !
    72    integer, save, public :: nprocs
    73                             ! Number of MPI processes
    74    integer, save, public :: myrank
    75                             ! My rank
    76  
    77    ! 非公開変数
    78    ! Private variables
    79    !
    80  
    81  
    82    interface MPIWrapperISend
    83      module procedure &
    84        MPIWrapperISend_logical_1d, &
    85        MPIWrapperISend_int_1d    , &
    86        MPIWrapperISend_dble_1d   , &
    87        MPIWrapperISend_dble_2d   , &
    88        MPIWrapperISend_dble_3d   , &
    89        MPIWrapperISend_dble_4d
    90    end interface
    91  
    92    interface MPIWrapperIRecv
    93      module procedure &
    94        MPIWrapperIRecv_logical_1d, &
    95        MPIWrapperIRecv_int_1d    , &
    96        MPIWrapperIRecv_dble_1d   , &
    97        MPIWrapperIRecv_dble_2d   , &
    98        MPIWrapperIRecv_dble_3d   , &
    99        MPIWrapperIRecv_dble_4d
   100    end interface
   101  
   102    interface MPIWrapperFindMaxVal
   103      module procedure &
   104        MPIWrapperFindMaxVal_dble_1d
   105    end interface
   106  
   107    interface MPIWrapperChkTrue
   108      module procedure &
   109        MPIWrapperChkTrue_1d
   110    end interface
   111  
   112    interface MPIWrapperAbort
   113      module procedure &
   114        MPIWrapperStop
   115    end interface
   116  
   117  
   118  contains
   119  
   120    !--------------------------------------------------------------------------------------
   121  
   122    subroutine MPIWrapperInit
   123      !
   124      ! MPI の初期化
   125      !
   126      ! Initialization of MPI
   127      !
   128  
   129      ! モジュール引用 ; USE statements
   130      !
   131  
   132  
   133  
   134  
   135      ! 作業変数
   136      ! Work variables
   137      !
   138      integer :: ierr
   139  
   140  
   141  
   142      nprocs = 1
   143      myrank = 0
   144  
   145  
   146  
   147      call mpi_init( ierr )
   148      call mpi_comm_size( mpi_comm_world, nprocs, ierr )
   149      call mpi_comm_rank( mpi_comm_world, myrank, ierr )
   150  
   151  
   152  
   153    end subroutine MPIWrapperInit
   154  
   155    !--------------------------------------------------------------------------------------
   156  
   157    subroutine MPIWrapperFinalize
   158      !
   159      ! MPI の終了処理
   160      !
   161      ! Finalization of MPI
   162      !
   163  
   164      ! モジュール引用 ; USE statements
   165      !
   166  
   167  
   168  
   169  
   170      ! 作業変数
   171      ! Work variables
   172      !
   173      integer :: ierr
   174  
   175  
   176      call mpi_finalize( ierr )
   177  
   178  
   179  
   180    end subroutine MPIWrapperFinalize
   181  
   182    !--------------------------------------------------------------------------------------
   183  
   184    subroutine MPIWrapperStop
   185      !
   186      ! MPI の異常終了処理
   187      !
   188      ! Abort of MPI
   189      !
   190  
   191      ! モジュール引用 ; USE statements
   192      !
   193  
   194  
   195  
   196      ! 作業変数
   197      ! Work variables
   198      !
   199      integer :: errorcode = 9
   200      integer :: ierr
   201  
   202  
   203      call mpi_abort( mpi_comm_world, errorcode, ierr )
   204      call MPIWrapperFinalize
   205      stop
   206  
   207  
   208  
   209    end subroutine MPIWrapperstop
   210  
   211    !--------------------------------------------------------------------------------------
   212  
   213    subroutine MPIWrapperWait( ireq )
   214      !
   215      ! MPI 通信終了まで待機
   216      !
   217      ! Wait finishing MPI transfer
   218      !
   219  
   220      ! モジュール引用 ; USE statements
   221      !
   222  
   223  
   224      integer, intent(inout) :: ireq
   225                                 ! request number
   226  
   227  
   228  
   229  
   230      ! 作業変数
   231      ! Work variables
   232      !
   233      integer :: ierr
   234      integer :: istatus( MPI_STATUS_SIZE )
   235  
   236  
   237      call mpi_wait( ireq, istatus, ierr )
   238  
   239  
   240  
   241    end subroutine MPIWrapperWait
   242  
   243    !--------------------------------------------------------------------------------------
   244  
   245    subroutine MPIWrapperISend_logical_1d(  &
   246      & idest, im,                      & ! (in)
   247      & buf,                            & ! (in)
   248      & ireq,                           & ! (out)
   249      & itag                            & ! (in) optional
   250      & )
   251      !
   252      ! 1D 倍精度配列の非ブロッキング通信(送信)
   253      !
   254      ! Non-blocking transfer (send) of real(8) 1D array
   255      !
   256  
   257      ! モジュール引用 ; USE statements
   258      !
   259  
   260  
   261      integer , intent(in ) :: idest
   262                                ! Process number of destination
   263      integer , intent(in ) :: im
   264                                ! Size of 1st dimension of sent data
   265      logical , intent(in ) :: buf( im )
   266                                ! Array to be sent
   267      integer , intent(out) :: ireq
   268                                ! Request number
   269      integer , intent(in ), optional :: itag
   270                                ! Size of 1st dimension of sent data
   271  
   272  
   273  
   274  
   275      ! 作業変数
   276      ! Work variables
   277      !
   278      integer :: ierr
   279      integer :: isize
   280      integer :: tag
   281  
   282      isize = size( buf )
   283  
   284      if ( present( itag ) ) then
   285        tag = itag
   286      else
   287        tag = 1
   288      end if
   289  
   290      call mpi_isend( buf, isize, &
   291        mpi_logical, idest, tag, mpi_comm_world, &
   292        ireq, ierr )
   293  
   294  
   295  
   296    end subroutine MPIWrapperISend_logical_1d
   297  
   298    !--------------------------------------------------------------------------------------
   299  
   300    subroutine MPIWrapperIRecv_logical_1d(  &
   301      & idep, im,                       & ! (in)
   302      & buf,                            & ! (out)
   303      & ireq,                           & ! (out)
   304      & itag                            & ! (in) optional
   305      & )
   306      !
   307      ! 1D 倍精度配列の非ブロッキング通信(受信)
   308      !
   309      ! Non-blocking transfer (receive) of real(8) 1D array
   310      !
   311  
   312      ! モジュール引用 ; USE statements
   313      !
   314  
   315  
   316      integer , intent(in ) :: idep
   317                                ! Process number of departure
   318      integer , intent(in ) :: im
   319                                ! Size of 1st dimension of received data
   320      logical , intent(out) :: buf( im )
   321                                ! Array to be received
   322      integer , intent(out) :: ireq
   323                                ! Request number
   324      integer , intent(in ), optional :: itag
   325                                ! Size of 1st dimension of sent data
   326  
   327  
   328  
   329  
   330      ! 作業変数
   331      ! Work variables
   332      !
   333      integer :: ierr
   334      integer :: isize
   335      integer :: tag
   336  
   337  
   338      isize = size( buf )
   339  
   340      if ( present( itag ) ) then
   341        tag = itag
   342      else
   343        tag = 1
   344      end if
   345  
   346      call mpi_irecv( buf, isize, &
   347        mpi_logical, idep, tag, mpi_comm_world, &
   348        ireq, ierr )
   349  
   350  
   351  
   352    end subroutine MPIWrapperIRecv_logical_1d
   353  
   354    !--------------------------------------------------------------------------------------
   355  
   356    subroutine MPIWrapperISend_int_1d(  &
   357      & idest, im,                      & ! (in)
   358      & buf,                            & ! (in)
   359      & ireq,                           & ! (out)
   360      & itag                            & ! (in) optional
   361      & )
   362      !
   363      ! 1D 倍精度配列の非ブロッキング通信(送信)
   364      !
   365      ! Non-blocking transfer (send) of real(8) 1D array
   366      !
   367  
   368      ! モジュール引用 ; USE statements
   369      !
   370  
   371  
   372      integer , intent(in ) :: idest
   373                                ! Process number of destination
   374      integer , intent(in ) :: im
   375                                ! Size of 1st dimension of sent data
   376      integer , intent(in ) :: buf( im )
   377                                ! Array to be sent
   378      integer , intent(out) :: ireq
   379                                ! Request number
   380      integer , intent(in ), optional :: itag
   381                                ! Size of 1st dimension of sent data
   382  
   383  
   384  
   385  
   386      ! 作業変数
   387      ! Work variables
   388      !
   389      integer :: ierr
   390      integer :: isize
   391      integer :: tag
   392  
   393  
   394      isize = size( buf )
   395  
   396      if ( present( itag ) ) then
   397        tag = itag
   398      else
   399        tag = 1
   400      end if
   401  
   402      call mpi_isend( buf, isize, &
   403        mpi_integer, idest, tag, mpi_comm_world, &
   404        ireq, ierr )
   405  
   406  
   407  
   408    end subroutine MPIWrapperISend_int_1d
   409  
   410    !--------------------------------------------------------------------------------------
   411  
   412    subroutine MPIWrapperIRecv_int_1d(  &
   413      & idep, im,                       & ! (in)
   414      & buf,                            & ! (out)
   415      & ireq,                           & ! (out)
   416      & itag                            & ! (in) optional
   417      & )
   418      !
   419      ! 1D 倍精度配列の非ブロッキング通信(受信)
   420      !
   421      ! Non-blocking transfer (receive) of real(8) 1D array
   422      !
   423  
   424      ! モジュール引用 ; USE statements
   425      !
   426  
   427  
   428      integer , intent(in ) :: idep
   429                                ! Process number of departure
   430      integer , intent(in ) :: im
   431                                ! Size of 1st dimension of received data
   432      integer , intent(out) :: buf( im )
   433                                ! Array to be received
   434      integer , intent(out) :: ireq
   435                                ! Request number
   436      integer , intent(in ), optional :: itag
   437                                ! Size of 1st dimension of sent data
   438  
   439  
   440  
   441  
   442      ! 作業変数
   443      ! Work variables
   444      !
   445      integer :: ierr
   446      integer :: isize
   447      integer :: tag
   448  
   449  
   450      isize = size( buf )
   451  
   452      if ( present( itag ) ) then
   453        tag = itag
   454      else
   455        tag = 1
   456      end if
   457  
   458      call mpi_irecv( buf, isize, &
   459        mpi_integer, idep, tag, mpi_comm_world, &
   460        ireq, ierr )
   461  
   462  
   463  
   464    end subroutine MPIWrapperIRecv_int_1d
   465  
   466    !--------------------------------------------------------------------------------------
   467  
   468    subroutine MPIWrapperISend_dble_1d( &
   469      & idest, im,                      & ! (in)
   470      & buf,                            & ! (in)
   471      & ireq,                           & ! (out)
   472      & itag                            & ! (in) optional
   473      & )
   474      !
   475      ! 1D 倍精度配列の非ブロッキング通信(送信)
   476      !
   477      ! Non-blocking transfer (send) of real(8) 1D array
   478      !
   479  
   480      ! モジュール引用 ; USE statements
   481      !
   482  
   483  
   484      integer , intent(in ) :: idest
   485                                ! Process number of destination
   486      integer , intent(in ) :: im
   487                                ! Size of 1st dimension of sent data
   488      real(DP), intent(in ) :: buf( im )
   489                                ! Array to be sent
   490      integer , intent(out) :: ireq
   491                                ! Request number
   492      integer , intent(in ), optional :: itag
   493                                ! Size of 1st dimension of sent data
   494  
   495  
   496  
   497  
   498      ! 作業変数
   499      ! Work variables
   500      !
   501      integer :: ierr
   502      integer :: isize
   503      integer :: tag
   504  
   505  
   506      isize = size( buf )
   507  
   508      if ( present( itag ) ) then
   509        tag = itag
   510      else
   511        tag = 1
   512      end if
   513  
   514      call mpi_isend( buf, isize, &
   515        mpi_double_precision, idest, tag, mpi_comm_world, &
   516        ireq, ierr )
   517  
   518  
   519  
   520    end subroutine MPIWrapperISend_dble_1d
   521  
   522    !--------------------------------------------------------------------------------------
   523  
   524    subroutine MPIWrapperIRecv_dble_1d( &
   525      & idep, im,                       & ! (in)
   526      & buf,                            & ! (out)
   527      & ireq,                           & ! (out)
   528      & itag                            & ! (in) optional
   529      & )
   530      !
   531      ! 1D 倍精度配列の非ブロッキング通信(受信)
   532      !
   533      ! Non-blocking transfer (receive) of real(8) 1D array
   534      !
   535  
   536      ! モジュール引用 ; USE statements
   537      !
   538  
   539  
   540      integer , intent(in ) :: idep
   541                                ! Process number of departure
   542      integer , intent(in ) :: im
   543                                ! Size of 1st dimension of received data
   544      real(DP), intent(out) :: buf( im )
   545                                ! Array to be received
   546      integer , intent(out) :: ireq
   547                                ! Request number
   548      integer , intent(in ), optional :: itag
   549                                ! Size of 1st dimension of sent data
   550  
   551  
   552  
   553  
   554      ! 作業変数
   555      ! Work variables
   556      !
   557      integer :: ierr
   558      integer :: isize
   559      integer :: tag
   560  
   561  
   562      isize = size( buf )
   563  
   564      if ( present( itag ) ) then
   565        tag = itag
   566      else
   567        tag = 1
   568      end if
   569  
   570      call mpi_irecv( buf, isize, &
   571        mpi_double_precision, idep, tag, mpi_comm_world, &
   572        ireq, ierr )
   573  
   574  
   575  
   576    end subroutine MPIWrapperIRecv_dble_1d
   577  
   578    !--------------------------------------------------------------------------------------
   579  
   580    subroutine MPIWrapperISend_dble_2d( &
   581      & idest, im, jm,                  & ! (in)
   582      & buf,                            & ! (in)
   583      & ireq,                           & ! (out)
   584      & itag                            & ! (in) optional
   585      & )
   586      !
   587      ! 2D 倍精度配列の非ブロッキング通信(送信)
   588      !
   589      ! Non-blocking transfer (send) of real(8) 2D array
   590      !
   591  
   592      ! モジュール引用 ; USE statements
   593      !
   594  
   595  
   596      integer , intent(in ) :: idest
   597                                ! Process number of destination
   598      integer , intent(in ) :: im
   599                                ! Size of 1st dimension of sent data
   600      integer , intent(in ) :: jm
   601                                ! Size of 2nd dimension of sent data
   602      real(DP), intent(in ) :: buf( im, jm )
   603                                ! Array to be sent
   604      integer , intent(out) :: ireq
   605                                ! Request number
   606      integer , intent(in ), optional :: itag
   607                                ! Size of 1st dimension of sent data
   608  
   609  
   610  
   611  
   612      ! 作業変数
   613      ! Work variables
   614      !
   615      integer :: ierr
   616      integer :: isize
   617      integer :: tag
   618  
   619  
   620      isize = size( buf )
   621  
   622      if ( present( itag ) ) then
   623        tag = itag
   624      else
   625        tag = 1
   626      end if
   627  
   628      call mpi_isend( buf, isize, &
   629        mpi_double_precision, idest, tag, mpi_comm_world, &
   630        ireq, ierr )
   631  
   632  
   633  
   634    end subroutine MPIWrapperISend_dble_2d
   635  
   636    !--------------------------------------------------------------------------------------
   637  
   638    subroutine MPIWrapperIRecv_dble_2d( &
   639      & idep, im, jm,                   & ! (in)
   640      & buf,                            & ! (out)
   641      & ireq,                           & ! (out)
   642      & itag                            & ! (in) optional
   643      & )
   644      !
   645      ! 2D 倍精度配列の非ブロッキング通信(受信)
   646      !
   647      ! Non-blocking transfer (receive) of real(8) 2D array
   648      !
   649  
   650      ! モジュール引用 ; USE statements
   651      !
   652  
   653  
   654      integer , intent(in ) :: idep
   655                                ! Process number of destination
   656      integer , intent(in ) :: im
   657                                ! Size of 1st dimension of received data
   658      integer , intent(in ) :: jm
   659                                ! Size of 2nd dimension of received data
   660      real(DP), intent(out) :: buf( im, jm )
   661                                ! Array to be received
   662      integer , intent(out) :: ireq
   663                                ! Request number
   664      integer , intent(in ), optional :: itag
   665                                ! Size of 1st dimension of sent data
   666  
   667  
   668  
   669  
   670      ! 作業変数
   671      ! Work variables
   672      !
   673      integer :: ierr
   674      integer :: isize
   675      integer :: tag
   676  
   677  
   678      isize = size( buf )
   679  
   680      if ( present( itag ) ) then
   681        tag = itag
   682      else
   683        tag = 1
   684      end if
   685  
   686      call mpi_irecv( buf, isize, &
   687        mpi_double_precision, idep, tag, mpi_comm_world, &
   688        ireq, ierr )
   689  
   690  
   691  
   692    end subroutine MPIWrapperIRecv_dble_2d
   693  
   694    !--------------------------------------------------------------------------------------
   695  
   696    subroutine MPIWrapperISend_dble_3d( &
   697      & idest, im, jm, km,              & ! (in)
   698      & buf,                            & ! (in)
   699      & ireq,                           & ! (out)
   700      & itag                            & ! (in) optional
   701      & )
   702      !
   703      ! 3D 倍精度配列の非ブロッキング通信(送信)
   704      !
   705      ! Non-blocking transfer (send) of real(8) 3D array
   706      !
   707  
   708      ! モジュール引用 ; USE statements
   709      !
   710  
   711  
   712      integer , intent(in ) :: idest
   713                                ! Process number of destination
   714      integer , intent(in ) :: im
   715                                ! Size of 1st dimension of sent data
   716      integer , intent(in ) :: jm
   717                                ! Size of 2nd dimension of sent data
   718      integer , intent(in ) :: km
   719                                ! Size of 3rd dimension of sent data
   720      real(DP), intent(in ) :: buf( im, jm, km )
   721                                ! Array to be sent
   722      integer , intent(out) :: ireq
   723                                ! Request number
   724      integer , intent(in ), optional :: itag
   725                                ! Size of 1st dimension of sent data
   726  
   727  
   728  
   729  
   730      ! 作業変数
   731      ! Work variables
   732      !
   733      integer :: ierr
   734      integer :: isize
   735      integer :: tag
   736  
   737  
   738      isize = size( buf )
   739  
   740      if ( present( itag ) ) then
   741        tag = itag
   742      else
   743        tag = 1
   744      end if
   745  
   746      call mpi_isend( buf, isize, &
   747        mpi_double_precision, idest, tag, mpi_comm_world, &
   748        ireq, ierr )
   749  
   750  
   751  
   752    end subroutine MPIWrapperISend_dble_3d
   753  
   754    !--------------------------------------------------------------------------------------
   755  
   756    subroutine MPIWrapperIRecv_dble_3d( &
   757      & idep, im, jm, km,               & ! (in)
   758      & buf,                            & ! (out)
   759      & ireq,                           & ! (out)
   760      & itag                            & ! (in) optional
   761      & )
   762      !
   763      ! 3D 倍精度配列の非ブロッキング通信(受信)
   764      !
   765      ! Non-blocking transfer (receive) of real(8) 3D array
   766      !
   767  
   768      ! モジュール引用 ; USE statements
   769      !
   770  
   771      integer , intent(in ) :: idep
   772                                ! Process number of departure
   773      integer , intent(in ) :: im
   774                                ! Size of 1st dimension of received data
   775      integer , intent(in ) :: jm
   776                                ! Size of 2nd dimension of received data
   777      integer , intent(in ) :: km
   778                                ! Size of 3rd dimension of received data
   779      real(DP), intent(out) :: buf( im, jm, km )
   780                                ! Array to be received
   781      integer , intent(out) :: ireq
   782                                ! Request number
   783      integer , intent(in ), optional :: itag
   784                                ! Size of 1st dimension of sent data
   785  
   786  
   787  
   788  
   789      ! 作業変数
   790      ! Work variables
   791      !
   792      integer :: ierr
   793      integer :: isize
   794      integer :: tag
   795  
   796  
   797      isize = size( buf )
   798  
   799      if ( present( itag ) ) then
   800        tag = itag
   801      else
   802        tag = 1
   803      end if
   804  
   805      call mpi_irecv( buf, isize, &
   806        mpi_double_precision, idep, tag, mpi_comm_world, &
   807        ireq, ierr )
   808  
   809  
   810  
   811    end subroutine MPIWrapperIRecv_dble_3d
   812  
   813    !--------------------------------------------------------------------------------------
   814  
   815    subroutine MPIWrapperISend_dble_4d( &
   816      & idest, im, jm, km, lm,          & ! (in)
   817      & buf,                            & ! (in)
   818      & ireq,                           & ! (out)
   819      & itag                            & ! (in) optional
   820      & )
   821      !
   822      ! 4D 倍精度配列の非ブロッキング通信(送信)
   823      !
   824      ! Non-blocking transfer (send) of real(8) 4D array
   825      !
   826  
   827      ! モジュール引用 ; USE statements
   828      !
   829  
   830  
   831      integer , intent(in ) :: idest
   832                                ! Process number of destination
   833      integer , intent(in ) :: im
   834                                ! Size of 1st dimension of sent data
   835      integer , intent(in ) :: jm
   836                                ! Size of 2nd dimension of sent data
   837      integer , intent(in ) :: km
   838                                ! Size of 3rd dimension of sent data
   839      integer , intent(in ) :: lm
   840                                ! Size of 4th dimension of sent data
   841      real(DP), intent(in ) :: buf( im, jm, km, lm )
   842                                ! Array to be sent
   843      integer , intent(out) :: ireq
   844                                ! Request number
   845      integer , intent(in ), optional :: itag
   846                                ! Size of 1st dimension of sent data
   847  
   848  
   849  
   850  
   851      ! 作業変数
   852      ! Work variables
   853      !
   854      integer :: ierr
   855      integer :: isize
   856      integer :: tag
   857  
   858  
   859      isize = size( buf )
   860  
   861      if ( present( itag ) ) then
   862        tag = itag
   863      else
   864        tag = 1
   865      end if
   866  
   867      call mpi_isend( buf, isize, &
   868        mpi_double_precision, idest, tag, mpi_comm_world, &
   869        ireq, ierr )
   870  
   871  
   872  
   873    end subroutine MPIWrapperISend_dble_4d
   874  
   875    !--------------------------------------------------------------------------------------
   876  
   877    subroutine MPIWrapperIRecv_dble_4d( &
   878      & idep, im, jm, km, lm,           & ! (in)
   879      & buf,                            & ! (out)
   880      & ireq,                           & ! (out)
   881      & itag                            & ! (in) optional
   882      & )
   883      !
   884      ! 4D 倍精度配列の非ブロッキング通信(受信)
   885      !
   886      ! Non-blocking transfer (receive) of real(8) 4D array
   887      !
   888  
   889      ! モジュール引用 ; USE statements
   890      !
   891  
   892  
   893      integer , intent(in ) :: idep
   894                                ! Process number of departure
   895      integer , intent(in ) :: im
   896                                ! Size of 1st dimension of received data
   897      integer , intent(in ) :: jm
   898                                ! Size of 2nd dimension of received data
   899      integer , intent(in ) :: km
   900                                ! Size of 3rd dimension of received data
   901      integer , intent(in ) :: lm
   902                                ! Size of 4th dimension of received data
   903      real(DP), intent(out) :: buf( im, jm, km, lm )
   904                                ! Array to be received
   905      integer , intent(out) :: ireq
   906                                ! Request number
   907      integer , intent(in ), optional :: itag
   908                                ! Size of 1st dimension of sent data
   909  
   910  
   911  
   912  
   913      ! 作業変数
   914      ! Work variables
   915      !
   916      integer :: ierr
   917      integer :: isize
   918      integer :: tag
   919  
   920  
   921      isize = size( buf )
   922  
   923      if ( present( itag ) ) then
   924        tag = itag
   925      else
   926        tag = 1
   927      end if
   928  
   929      call mpi_irecv( buf, isize, &
   930        mpi_double_precision, idep, tag, mpi_comm_world, &
   931        ireq, ierr )
   932  
   933  
   934  
   935  
   936    end subroutine MPIWrapperIRecv_dble_4d
   937  
   938    !--------------------------------------------------------------------------------------
   939  
   940    subroutine MPIWrapperFindMaxVal_dble_1d( &
   941      & lmax, a_LocalMax,                    & ! (in)
   942      & a_GlobalMax                          & ! (out)
   943      & )
   944      !
   945      ! 全球の最大値を探す
   946      !
   947      ! Find the maximum of the globe
   948      !
   949  
   950      ! モジュール引用 ; USE statements
   951      !
   952  
   953      integer , intent(in ) :: lmax
   954      real(DP), intent(in ) :: a_LocalMax (1:lmax)
   955      real(DP), intent(out) :: a_GlobalMax(1:lmax)
   956  
   957  
   958  
   959  
   960      ! 作業変数
   961      ! Work variables
   962      !
   963      integer  :: idep          ! Process number of departure
   964      integer  :: idest         ! Process number of destination
   965      real(DP) :: a_Buf(1:lmax) ! Array to be received
   966      integer  :: ireq          ! Request number
   967      real(DP), allocatable :: aa_LocalMax(:,:)
   968      integer               :: l
   969      integer               :: n
   970  
   971  
   972      if ( myrank == 0 ) then
   973  
   974        allocate( aa_LocalMax( 1:lmax, 0:nprocs-1 ) )
   975  
   976        aa_LocalMax(:,0) = a_LocalMax
   977  
   978        do n = 1, nprocs-1
   979          idep = n
   980          call MPIWrapperIRecv(  &
   981            & idep, lmax,        & ! (in)
   982            & aa_LocalMax(:,n),  & ! (out)
   983            & ireq               & ! (out)
   984            & )
   985          call MPIWrapperWait( ireq )
   986        end do
   987  
   988        do l = 1, lmax
   989          n = 0
   990          a_GlobalMax(l) = aa_LocalMax(l,n)
   991          do n = 1, nprocs-1
   992            if ( a_GlobalMax(l) < aa_LocalMax(l,n) ) then
   993              a_GlobalMax(l) = aa_LocalMax(l,n)
   994            end if
   995          end do
   996        end do
   997  
   998        a_Buf = a_GlobalMax
   999        do n = 1, nprocs-1
  1000          idest = n
  1001          call MPIWrapperISend(  &
  1002            & idest, lmax,       & ! (in)
  1003            & a_Buf,             & ! (in)
  1004            & ireq               & ! (out)
  1005            & )
  1006          call MPIWrapperWait( ireq )
  1007        end do
  1008  
  1009        deallocate( aa_LocalMax )
  1010  
  1011      else
  1012  
  1013        idest = 0
  1014        a_Buf = a_LocalMax
  1015        call MPIWrapperISend(  &
  1016          & idest, lmax,       & ! (in)
  1017          & a_Buf,             & ! (in)
  1018          & ireq               & ! (out)
  1019          & )
  1020        call MPIWrapperWait( ireq )
  1021  
  1022        idep = 0
  1023        call MPIWrapperIRecv(  &
  1024          & idep, lmax,        & ! (in)
  1025          & a_Buf,             & ! (out)
  1026          & ireq               & ! (out)
  1027          & )
  1028        call MPIWrapperWait( ireq )
  1029  
  1030        a_GlobalMax = a_Buf
  1031  
  1032      end if
  1033  
  1034  
  1035  
  1036  
  1037    end subroutine MPIWrapperFindMaxVal_dble_1d
  1038  
  1039    !--------------------------------------------------------------------------------------
  1040    !
  1041    ! A value of a_GlobalLogical(k) is true, if a_LocalLogical(k) is true
  1042    ! at least in a process.
  1043    !
  1044    subroutine MPIWrapperChkTrue_1d( &
  1045      & lmax, a_LocalLogical,        & ! (in)
  1046      & a_GlobalLogical              & ! (out)
  1047      & )
  1048      !
  1049      ! 全球の最大値を探す
  1050      !
  1051      ! Find the maximum of the globe
  1052      !
  1053  
  1054      ! モジュール引用 ; USE statements
  1055      !
  1056  
  1057      integer, intent(in ) :: lmax
  1058      logical, intent(in ) :: a_LocalLogical (1:lmax)
  1059      logical, intent(out) :: a_GlobalLogical(1:lmax)
  1060  
  1061  
  1062  
  1063  
  1064      ! 作業変数
  1065      ! Work variables
  1066      !
  1067      integer  :: idep          ! Process number of departure
  1068      integer  :: idest         ! Process number of destination
  1069      logical  :: a_Buf(1:lmax) ! Array to be received
  1070      integer  :: ireq          ! Request number
  1071      logical, allocatable :: aa_LocalLogical(:,:)
  1072      integer               :: l
  1073      integer               :: n
  1074  
  1075  
  1076      if ( myrank == 0 ) then
  1077  
  1078        allocate( aa_LocalLogical( 1:lmax, 0:nprocs-1 ) )
  1079  
  1080        aa_LocalLogical(:,0) = a_LocalLogical
  1081  
  1082        do n = 1, nprocs-1
  1083          idep = n
  1084          call MPIWrapperIRecv(     &
  1085            & idep, lmax,           & ! (in)
  1086            & aa_LocalLogical(:,n), & ! (out)
  1087            & ireq                  & ! (out)
  1088            & )
  1089          call MPIWrapperWait( ireq )
  1090        end do
  1091  
  1092        do l = 1, lmax
  1093          n = 0
  1094          a_GlobalLogical(l) = aa_LocalLogical(l,n)
  1095          do n = 1, nprocs-1
  1096            if (  aa_LocalLogical(l,n) ) then
  1097              a_GlobalLogical(l) = aa_LocalLogical(l,n)
  1098            end if
  1099          end do
     .           if (nprocs - 1 .gt. 0) then                                    
     .           a_globallogical1 = a_globallogical(l)                          
     .  !cdir    nodep                                                          
     .           do n = 1, nprocs - 1                                           
     .              if (aa_locallogical(l,n) .ne. 0) then                       
     .                 a_globallogical1 = aa_locallogical(l,n)                  
     .              endif                                                       
     .           enddo                                                          
     .           a_globallogical(l) = a_globallogical1                          
     .        endif                                                             
  1100        end do
  1101  
  1102        a_Buf = a_GlobalLogical
  1103        do n = 1, nprocs-1
  1104          idest = n
  1105          call MPIWrapperISend(  &
  1106            & idest, lmax,       & ! (in)
  1107            & a_Buf,             & ! (in)
  1108            & ireq               & ! (out)
  1109            & )
  1110          call MPIWrapperWait( ireq )
  1111        end do
  1112  
  1113        deallocate( aa_LocalLogical )
  1114  
  1115      else
  1116  
  1117        idest = 0
  1118        a_Buf = a_LocalLogical
  1119        call MPIWrapperISend(  &
  1120          & idest, lmax,       & ! (in)
  1121          & a_Buf,             & ! (in)
  1122          & ireq               & ! (out)
  1123          & )
  1124        call MPIWrapperWait( ireq )
  1125  
  1126        idep = 0
  1127        call MPIWrapperIRecv(  &
  1128          & idep, lmax,        & ! (in)
  1129          & a_Buf,             & ! (out)
  1130          & ireq               & ! (out)
  1131          & )
  1132        call MPIWrapperWait( ireq )
  1133  
  1134        a_GlobalLogical = a_Buf
  1135  
  1136      end if
  1137  
  1138  
  1139  
  1140  
  1141    end subroutine MPIWrapperChkTrue_1d
  1142  
  1143    !--------------------------------------------------------------------------------------
  1144  
  1145  end module mpi_wrapper
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: i.mpi_wrapper.F90
PROGRAM NAME: mpi_wrapper
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != MPI 関連ルーチン
     2:             !
     3:             != MPI related routines
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: mpi_wrapper.F90,v 1.7 2013/09/16 12:07:39 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module mpi_wrapper
    13:               !
    14:               != MPI 関連ルーチン
    15:               !
    16:               != MPI related routines
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! MPI 関係の変数の管理と MPI 関係ラッパールーチンのモジュール. 
    21:               !
    22:               ! This is a module containing MPI-related variables and wrapper routines. 
    23:               !
    24:               !== Procedures List
    25:               !
    26:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    27:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    28:             !!$  ! ------------            :: ------------
    29:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    31:               !
    32:               !== NAMELIST
    33:               !
    34:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    35:               !
    36:             
    37:               ! モジュール引用 ; USE statements
    38:               !
    39:             
    40:               ! 種別型パラメタ
    41:               ! Kind type parameter
    42:               !
    43:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    44:                 &                 STRING, &  ! 文字列.       Strings.
    45:                 &                 TOKEN      ! キーワード.   Keywords.
    46:             
    47:             
    48:               ! MPI
    49:               !
    50:               use mpi
    51:             
    52:             
    53:               ! 宣言文 ; Declaration statements
    54:               !
    55:               implicit none
    56:               private
    57:             
    58:               ! 公開手続き
    59:               ! Public procedure
    60:               !
    61:               public :: MPIWrapperInit
    62:               public :: MPIWrapperFinalize
    63:               public :: MPIWrapperISend
    64:               public :: MPIWrapperIRecv
    65:               public :: MPIWrapperWait
    66:               public :: MPIWrapperFindMaxVal
    67:               public :: MPIWrapperChkTrue
    68:             
    69:               ! 公開変数
    70:               ! Public variables
    71:               !
    72:               integer, save, public :: nprocs
    73:                                        ! Number of MPI processes
    74:               integer, save, public :: myrank
    75:                                        ! My rank
    76:             
    77:               ! 非公開変数
    78:               ! Private variables
    79:               !
    80:             
    81:             
    82:               interface MPIWrapperISend
    83:                 module procedure &
    84:                   MPIWrapperISend_logical_1d, &
    85:                   MPIWrapperISend_int_1d    , &
    86:                   MPIWrapperISend_dble_1d   , &
    87:                   MPIWrapperISend_dble_2d   , &
    88:                   MPIWrapperISend_dble_3d   , &
    89:                   MPIWrapperISend_dble_4d
    90:               end interface
    91:             
    92:               interface MPIWrapperIRecv
    93:                 module procedure &
    94:                   MPIWrapperIRecv_logical_1d, &
    95:                   MPIWrapperIRecv_int_1d    , &
    96:                   MPIWrapperIRecv_dble_1d   , &
    97:                   MPIWrapperIRecv_dble_2d   , &
    98:                   MPIWrapperIRecv_dble_3d   , &
    99:                   MPIWrapperIRecv_dble_4d
   100:               end interface
   101:             
   102:               interface MPIWrapperFindMaxVal
   103:                 module procedure &
   104:                   MPIWrapperFindMaxVal_dble_1d
   105:               end interface
   106:             
   107:               interface MPIWrapperChkTrue
   108:                 module procedure &
   109:                   MPIWrapperChkTrue_1d
   110:               end interface
   111:             
   112:               interface MPIWrapperAbort
   113:                 module procedure &
   114:                   MPIWrapperStop
   115:               end interface
   116:             
   117:             
   118:             contains
   119:             
   120:               !--------------------------------------------------------------------------------------
   121:             
   122:               subroutine MPIWrapperInit
   123:                 !
   124:                 ! MPI の初期化
   125:                 !
   126:                 ! Initialization of MPI
   127:                 !
   128:             
   129:                 ! モジュール引用 ; USE statements
   130:                 !
   131:             
   132:             
   133:             
   134:             
   135:                 ! 作業変数
   136:                 ! Work variables
   137:                 !
   138:                 integer :: ierr
   139:             
   140:             
   141:             
   142:                 nprocs = 1
   143:                 myrank = 0
   144:             
   145:             
   146:             
   147:                 call mpi_init( ierr )
   148:                 call mpi_comm_size( mpi_comm_world, nprocs, ierr )
   149:                 call mpi_comm_rank( mpi_comm_world, myrank, ierr )
   150:             
   151:             
   152:             
   153:               end subroutine MPIWrapperInit
   154:             
   155:               !--------------------------------------------------------------------------------------
   156:             
   157:               subroutine MPIWrapperFinalize
   158:                 !
   159:                 ! MPI の終了処理
   160:                 !
   161:                 ! Finalization of MPI
   162:                 !
   163:             
   164:                 ! モジュール引用 ; USE statements
   165:                 !
   166:             
   167:             
   168:             
   169:             
   170:                 ! 作業変数
   171:                 ! Work variables
   172:                 !
   173:                 integer :: ierr
   174:             
   175:             
   176:                 call mpi_finalize( ierr )
   177:             
   178:             
   179:             
   180:               end subroutine MPIWrapperFinalize
   181:             
   182:               !--------------------------------------------------------------------------------------
   183:             
   184:               subroutine MPIWrapperStop
   185:                 !
   186:                 ! MPI の異常終了処理
   187:                 !
   188:                 ! Abort of MPI
   189:                 !
   190:             
   191:                 ! モジュール引用 ; USE statements
   192:                 !
   193:             
   194:             
   195:             
   196:                 ! 作業変数
   197:                 ! Work variables
   198:                 !
   199:                 integer :: errorcode = 9
   200:                 integer :: ierr
   201:             
   202:             
   203:                 call mpi_abort( mpi_comm_world, errorcode, ierr )
   204:                 call MPIWrapperFinalize
   205:                 stop
   206:             
   207:             
   208:             
   209:               end subroutine MPIWrapperstop
   210:             
   211:               !--------------------------------------------------------------------------------------
   212:             
   213:               subroutine MPIWrapperWait( ireq )
   214:                 !
   215:                 ! MPI 通信終了まで待機
   216:                 !
   217:                 ! Wait finishing MPI transfer
   218:                 !
   219:             
   220:                 ! モジュール引用 ; USE statements
   221:                 !
   222:             
   223:             
   224:                 integer, intent(inout) :: ireq
   225:                                            ! request number
   226:             
   227:             
   228:             
   229:             
   230:                 ! 作業変数
   231:                 ! Work variables
   232:                 !
   233:                 integer :: ierr
   234:                 integer :: istatus( MPI_STATUS_SIZE )
   235:             
   236:             
   237:                 call mpi_wait( ireq, istatus, ierr )
   238:             
   239:             
   240:             
   241:               end subroutine MPIWrapperWait
   242:             
   243:               !--------------------------------------------------------------------------------------
   244:             
   245:               subroutine MPIWrapperISend_logical_1d(  &
   246:                 & idest, im,                      & ! (in)
   247:                 & buf,                            & ! (in)
   248:                 & ireq,                           & ! (out)
   249:                 & itag                            & ! (in) optional
   250:                 & )
   251:                 !
   252:                 ! 1D 倍精度配列の非ブロッキング通信(送信)
   253:                 !
   254:                 ! Non-blocking transfer (send) of real(8) 1D array
   255:                 !
   256:             
   257:                 ! モジュール引用 ; USE statements
   258:                 !
   259:             
   260:             
   261:                 integer , intent(in ) :: idest
   262:                                           ! Process number of destination
   263:                 integer , intent(in ) :: im
   264:                                           ! Size of 1st dimension of sent data
   265:                 logical , intent(in ) :: buf( im )
   266:                                           ! Array to be sent
   267:                 integer , intent(out) :: ireq
   268:                                           ! Request number
   269:                 integer , intent(in ), optional :: itag
   270:                                           ! Size of 1st dimension of sent data
   271:             
   272:             
   273:             
   274:             
   275:                 ! 作業変数
   276:                 ! Work variables
   277:                 !
   278:                 integer :: ierr
   279:                 integer :: isize
   280:                 integer :: tag
   281:             
   282:                 isize = size( buf )
   283:             
   284:                 if ( present( itag ) ) then
   285:                   tag = itag
   286:                 else
   287:                   tag = 1
   288:                 end if
   289:             
   290:                 call mpi_isend( buf, isize, &
   291:                   mpi_logical, idest, tag, mpi_comm_world, &
   292:                   ireq, ierr )
   293:             
   294:             
   295:             
   296:               end subroutine MPIWrapperISend_logical_1d
   297:             
   298:               !--------------------------------------------------------------------------------------
   299:             
   300:               subroutine MPIWrapperIRecv_logical_1d(  &
   301:                 & idep, im,                       & ! (in)
   302:                 & buf,                            & ! (out)
   303:                 & ireq,                           & ! (out)
   304:                 & itag                            & ! (in) optional
   305:                 & )
   306:                 !
   307:                 ! 1D 倍精度配列の非ブロッキング通信(受信)
   308:                 !
   309:                 ! Non-blocking transfer (receive) of real(8) 1D array
   310:                 !
   311:             
   312:                 ! モジュール引用 ; USE statements
   313:                 !
   314:             
   315:             
   316:                 integer , intent(in ) :: idep
   317:                                           ! Process number of departure
   318:                 integer , intent(in ) :: im
   319:                                           ! Size of 1st dimension of received data
   320:                 logical , intent(out) :: buf( im )
   321:                                           ! Array to be received
   322:                 integer , intent(out) :: ireq
   323:                                           ! Request number
   324:                 integer , intent(in ), optional :: itag
   325:                                           ! Size of 1st dimension of sent data
   326:             
   327:             
   328:             
   329:             
   330:                 ! 作業変数
   331:                 ! Work variables
   332:                 !
   333:                 integer :: ierr
   334:                 integer :: isize
   335:                 integer :: tag
   336:             
   337:             
   338:                 isize = size( buf )
   339:             
   340:                 if ( present( itag ) ) then
   341:                   tag = itag
   342:                 else
   343:                   tag = 1
   344:                 end if
   345:             
   346:                 call mpi_irecv( buf, isize, &
   347:                   mpi_logical, idep, tag, mpi_comm_world, &
   348:                   ireq, ierr )
   349:             
   350:             
   351:             
   352:               end subroutine MPIWrapperIRecv_logical_1d
   353:             
   354:               !--------------------------------------------------------------------------------------
   355:             
   356:               subroutine MPIWrapperISend_int_1d(  &
   357:                 & idest, im,                      & ! (in)
   358:                 & buf,                            & ! (in)
   359:                 & ireq,                           & ! (out)
   360:                 & itag                            & ! (in) optional
   361:                 & )
   362:                 !
   363:                 ! 1D 倍精度配列の非ブロッキング通信(送信)
   364:                 !
   365:                 ! Non-blocking transfer (send) of real(8) 1D array
   366:                 !
   367:             
   368:                 ! モジュール引用 ; USE statements
   369:                 !
   370:             
   371:             
   372:                 integer , intent(in ) :: idest
   373:                                           ! Process number of destination
   374:                 integer , intent(in ) :: im
   375:                                           ! Size of 1st dimension of sent data
   376:                 integer , intent(in ) :: buf( im )
   377:                                           ! Array to be sent
   378:                 integer , intent(out) :: ireq
   379:                                           ! Request number
   380:                 integer , intent(in ), optional :: itag
   381:                                           ! Size of 1st dimension of sent data
   382:             
   383:             
   384:             
   385:             
   386:                 ! 作業変数
   387:                 ! Work variables
   388:                 !
   389:                 integer :: ierr
   390:                 integer :: isize
   391:                 integer :: tag
   392:             
   393:             
   394:                 isize = size( buf )
   395:             
   396:                 if ( present( itag ) ) then
   397:                   tag = itag
   398:                 else
   399:                   tag = 1
   400:                 end if
   401:             
   402:                 call mpi_isend( buf, isize, &
   403:                   mpi_integer, idest, tag, mpi_comm_world, &
   404:                   ireq, ierr )
   405:             
   406:             
   407:             
   408:               end subroutine MPIWrapperISend_int_1d
   409:             
   410:               !--------------------------------------------------------------------------------------
   411:             
   412:               subroutine MPIWrapperIRecv_int_1d(  &
   413:                 & idep, im,                       & ! (in)
   414:                 & buf,                            & ! (out)
   415:                 & ireq,                           & ! (out)
   416:                 & itag                            & ! (in) optional
   417:                 & )
   418:                 !
   419:                 ! 1D 倍精度配列の非ブロッキング通信(受信)
   420:                 !
   421:                 ! Non-blocking transfer (receive) of real(8) 1D array
   422:                 !
   423:             
   424:                 ! モジュール引用 ; USE statements
   425:                 !
   426:             
   427:             
   428:                 integer , intent(in ) :: idep
   429:                                           ! Process number of departure
   430:                 integer , intent(in ) :: im
   431:                                           ! Size of 1st dimension of received data
   432:                 integer , intent(out) :: buf( im )
   433:                                           ! Array to be received
   434:                 integer , intent(out) :: ireq
   435:                                           ! Request number
   436:                 integer , intent(in ), optional :: itag
   437:                                           ! Size of 1st dimension of sent data
   438:             
   439:             
   440:             
   441:             
   442:                 ! 作業変数
   443:                 ! Work variables
   444:                 !
   445:                 integer :: ierr
   446:                 integer :: isize
   447:                 integer :: tag
   448:             
   449:             
   450:                 isize = size( buf )
   451:             
   452:                 if ( present( itag ) ) then
   453:                   tag = itag
   454:                 else
   455:                   tag = 1
   456:                 end if
   457:             
   458:                 call mpi_irecv( buf, isize, &
   459:                   mpi_integer, idep, tag, mpi_comm_world, &
   460:                   ireq, ierr )
   461:             
   462:             
   463:             
   464:               end subroutine MPIWrapperIRecv_int_1d
   465:             
   466:               !--------------------------------------------------------------------------------------
   467:             
   468:               subroutine MPIWrapperISend_dble_1d( &
   469:                 & idest, im,                      & ! (in)
   470:                 & buf,                            & ! (in)
   471:                 & ireq,                           & ! (out)
   472:                 & itag                            & ! (in) optional
   473:                 & )
   474:                 !
   475:                 ! 1D 倍精度配列の非ブロッキング通信(送信)
   476:                 !
   477:                 ! Non-blocking transfer (send) of real(8) 1D array
   478:                 !
   479:             
   480:                 ! モジュール引用 ; USE statements
   481:                 !
   482:             
   483:             
   484:                 integer , intent(in ) :: idest
   485:                                           ! Process number of destination
   486:                 integer , intent(in ) :: im
   487:                                           ! Size of 1st dimension of sent data
   488:                 real(DP), intent(in ) :: buf( im )
   489:                                           ! Array to be sent
   490:                 integer , intent(out) :: ireq
   491:                                           ! Request number
   492:                 integer , intent(in ), optional :: itag
   493:                                           ! Size of 1st dimension of sent data
   494:             
   495:             
   496:             
   497:             
   498:                 ! 作業変数
   499:                 ! Work variables
   500:                 !
   501:                 integer :: ierr
   502:                 integer :: isize
   503:                 integer :: tag
   504:             
   505:             
   506:                 isize = size( buf )
   507:             
   508:                 if ( present( itag ) ) then
   509:                   tag = itag
   510:                 else
   511:                   tag = 1
   512:                 end if
   513:             
   514:                 call mpi_isend( buf, isize, &
   515:                   mpi_double_precision, idest, tag, mpi_comm_world, &
   516:                   ireq, ierr )
   517:             
   518:             
   519:             
   520:               end subroutine MPIWrapperISend_dble_1d
   521:             
   522:               !--------------------------------------------------------------------------------------
   523:             
   524:               subroutine MPIWrapperIRecv_dble_1d( &
   525:                 & idep, im,                       & ! (in)
   526:                 & buf,                            & ! (out)
   527:                 & ireq,                           & ! (out)
   528:                 & itag                            & ! (in) optional
   529:                 & )
   530:                 !
   531:                 ! 1D 倍精度配列の非ブロッキング通信(受信)
   532:                 !
   533:                 ! Non-blocking transfer (receive) of real(8) 1D array
   534:                 !
   535:             
   536:                 ! モジュール引用 ; USE statements
   537:                 !
   538:             
   539:             
   540:                 integer , intent(in ) :: idep
   541:                                           ! Process number of departure
   542:                 integer , intent(in ) :: im
   543:                                           ! Size of 1st dimension of received data
   544:                 real(DP), intent(out) :: buf( im )
   545:                                           ! Array to be received
   546:                 integer , intent(out) :: ireq
   547:                                           ! Request number
   548:                 integer , intent(in ), optional :: itag
   549:                                           ! Size of 1st dimension of sent data
   550:             
   551:             
   552:             
   553:             
   554:                 ! 作業変数
   555:                 ! Work variables
   556:                 !
   557:                 integer :: ierr
   558:                 integer :: isize
   559:                 integer :: tag
   560:             
   561:             
   562:                 isize = size( buf )
   563:             
   564:                 if ( present( itag ) ) then
   565:                   tag = itag
   566:                 else
   567:                   tag = 1
   568:                 end if
   569:             
   570:                 call mpi_irecv( buf, isize, &
   571:                   mpi_double_precision, idep, tag, mpi_comm_world, &
   572:                   ireq, ierr )
   573:             
   574:             
   575:             
   576:               end subroutine MPIWrapperIRecv_dble_1d
   577:             
   578:               !--------------------------------------------------------------------------------------
   579:             
   580:               subroutine MPIWrapperISend_dble_2d( &
   581:                 & idest, im, jm,                  & ! (in)
   582:                 & buf,                            & ! (in)
   583:                 & ireq,                           & ! (out)
   584:                 & itag                            & ! (in) optional
   585:                 & )
   586:                 !
   587:                 ! 2D 倍精度配列の非ブロッキング通信(送信)
   588:                 !
   589:                 ! Non-blocking transfer (send) of real(8) 2D array
   590:                 !
   591:             
   592:                 ! モジュール引用 ; USE statements
   593:                 !
   594:             
   595:             
   596:                 integer , intent(in ) :: idest
   597:                                           ! Process number of destination
   598:                 integer , intent(in ) :: im
   599:                                           ! Size of 1st dimension of sent data
   600:                 integer , intent(in ) :: jm
   601:                                           ! Size of 2nd dimension of sent data
   602:                 real(DP), intent(in ) :: buf( im, jm )
   603:                                           ! Array to be sent
   604:                 integer , intent(out) :: ireq
   605:                                           ! Request number
   606:                 integer , intent(in ), optional :: itag
   607:                                           ! Size of 1st dimension of sent data
   608:             
   609:             
   610:             
   611:             
   612:                 ! 作業変数
   613:                 ! Work variables
   614:                 !
   615:                 integer :: ierr
   616:                 integer :: isize
   617:                 integer :: tag
   618:             
   619:             
   620:                 isize = size( buf )
   621:             
   622:                 if ( present( itag ) ) then
   623:                   tag = itag
   624:                 else
   625:                   tag = 1
   626:                 end if
   627:             
   628:                 call mpi_isend( buf, isize, &
   629:                   mpi_double_precision, idest, tag, mpi_comm_world, &
   630:                   ireq, ierr )
   631:             
   632:             
   633:             
   634:               end subroutine MPIWrapperISend_dble_2d
   635:             
   636:               !--------------------------------------------------------------------------------------
   637:             
   638:               subroutine MPIWrapperIRecv_dble_2d( &
   639:                 & idep, im, jm,                   & ! (in)
   640:                 & buf,                            & ! (out)
   641:                 & ireq,                           & ! (out)
   642:                 & itag                            & ! (in) optional
   643:                 & )
   644:                 !
   645:                 ! 2D 倍精度配列の非ブロッキング通信(受信)
   646:                 !
   647:                 ! Non-blocking transfer (receive) of real(8) 2D array
   648:                 !
   649:             
   650:                 ! モジュール引用 ; USE statements
   651:                 !
   652:             
   653:             
   654:                 integer , intent(in ) :: idep
   655:                                           ! Process number of destination
   656:                 integer , intent(in ) :: im
   657:                                           ! Size of 1st dimension of received data
   658:                 integer , intent(in ) :: jm
   659:                                           ! Size of 2nd dimension of received data
   660:                 real(DP), intent(out) :: buf( im, jm )
   661:                                           ! Array to be received
   662:                 integer , intent(out) :: ireq
   663:                                           ! Request number
   664:                 integer , intent(in ), optional :: itag
   665:                                           ! Size of 1st dimension of sent data
   666:             
   667:             
   668:             
   669:             
   670:                 ! 作業変数
   671:                 ! Work variables
   672:                 !
   673:                 integer :: ierr
   674:                 integer :: isize
   675:                 integer :: tag
   676:             
   677:             
   678:                 isize = size( buf )
   679:             
   680:                 if ( present( itag ) ) then
   681:                   tag = itag
   682:                 else
   683:                   tag = 1
   684:                 end if
   685:             
   686:                 call mpi_irecv( buf, isize, &
   687:                   mpi_double_precision, idep, tag, mpi_comm_world, &
   688:                   ireq, ierr )
   689:             
   690:             
   691:             
   692:               end subroutine MPIWrapperIRecv_dble_2d
   693:             
   694:               !--------------------------------------------------------------------------------------
   695:             
   696:               subroutine MPIWrapperISend_dble_3d( &
   697:                 & idest, im, jm, km,              & ! (in)
   698:                 & buf,                            & ! (in)
   699:                 & ireq,                           & ! (out)
   700:                 & itag                            & ! (in) optional
   701:                 & )
   702:                 !
   703:                 ! 3D 倍精度配列の非ブロッキング通信(送信)
   704:                 !
   705:                 ! Non-blocking transfer (send) of real(8) 3D array
   706:                 !
   707:             
   708:                 ! モジュール引用 ; USE statements
   709:                 !
   710:             
   711:             
   712:                 integer , intent(in ) :: idest
   713:                                           ! Process number of destination
   714:                 integer , intent(in ) :: im
   715:                                           ! Size of 1st dimension of sent data
   716:                 integer , intent(in ) :: jm
   717:                                           ! Size of 2nd dimension of sent data
   718:                 integer , intent(in ) :: km
   719:                                           ! Size of 3rd dimension of sent data
   720:                 real(DP), intent(in ) :: buf( im, jm, km )
   721:                                           ! Array to be sent
   722:                 integer , intent(out) :: ireq
   723:                                           ! Request number
   724:                 integer , intent(in ), optional :: itag
   725:                                           ! Size of 1st dimension of sent data
   726:             
   727:             
   728:             
   729:             
   730:                 ! 作業変数
   731:                 ! Work variables
   732:                 !
   733:                 integer :: ierr
   734:                 integer :: isize
   735:                 integer :: tag
   736:             
   737:             
   738:                 isize = size( buf )
   739:             
   740:                 if ( present( itag ) ) then
   741:                   tag = itag
   742:                 else
   743:                   tag = 1
   744:                 end if
   745:             
   746:                 call mpi_isend( buf, isize, &
   747:                   mpi_double_precision, idest, tag, mpi_comm_world, &
   748:                   ireq, ierr )
   749:             
   750:             
   751:             
   752:               end subroutine MPIWrapperISend_dble_3d
   753:             
   754:               !--------------------------------------------------------------------------------------
   755:             
   756:               subroutine MPIWrapperIRecv_dble_3d( &
   757:                 & idep, im, jm, km,               & ! (in)
   758:                 & buf,                            & ! (out)
   759:                 & ireq,                           & ! (out)
   760:                 & itag                            & ! (in) optional
   761:                 & )
   762:                 !
   763:                 ! 3D 倍精度配列の非ブロッキング通信(受信)
   764:                 !
   765:                 ! Non-blocking transfer (receive) of real(8) 3D array
   766:                 !
   767:             
   768:                 ! モジュール引用 ; USE statements
   769:                 !
   770:             
   771:                 integer , intent(in ) :: idep
   772:                                           ! Process number of departure
   773:                 integer , intent(in ) :: im
   774:                                           ! Size of 1st dimension of received data
   775:                 integer , intent(in ) :: jm
   776:                                           ! Size of 2nd dimension of received data
   777:                 integer , intent(in ) :: km
   778:                                           ! Size of 3rd dimension of received data
   779:                 real(DP), intent(out) :: buf( im, jm, km )
   780:                                           ! Array to be received
   781:                 integer , intent(out) :: ireq
   782:                                           ! Request number
   783:                 integer , intent(in ), optional :: itag
   784:                                           ! Size of 1st dimension of sent data
   785:             
   786:             
   787:             
   788:             
   789:                 ! 作業変数
   790:                 ! Work variables
   791:                 !
   792:                 integer :: ierr
   793:                 integer :: isize
   794:                 integer :: tag
   795:             
   796:             
   797:                 isize = size( buf )
   798:             
   799:                 if ( present( itag ) ) then
   800:                   tag = itag
   801:                 else
   802:                   tag = 1
   803:                 end if
   804:             
   805:                 call mpi_irecv( buf, isize, &
   806:                   mpi_double_precision, idep, tag, mpi_comm_world, &
   807:                   ireq, ierr )
   808:             
   809:             
   810:             
   811:               end subroutine MPIWrapperIRecv_dble_3d
   812:             
   813:               !--------------------------------------------------------------------------------------
   814:             
   815:               subroutine MPIWrapperISend_dble_4d( &
   816:                 & idest, im, jm, km, lm,          & ! (in)
   817:                 & buf,                            & ! (in)
   818:                 & ireq,                           & ! (out)
   819:                 & itag                            & ! (in) optional
   820:                 & )
   821:                 !
   822:                 ! 4D 倍精度配列の非ブロッキング通信(送信)
   823:                 !
   824:                 ! Non-blocking transfer (send) of real(8) 4D array
   825:                 !
   826:             
   827:                 ! モジュール引用 ; USE statements
   828:                 !
   829:             
   830:             
   831:                 integer , intent(in ) :: idest
   832:                                           ! Process number of destination
   833:                 integer , intent(in ) :: im
   834:                                           ! Size of 1st dimension of sent data
   835:                 integer , intent(in ) :: jm
   836:                                           ! Size of 2nd dimension of sent data
   837:                 integer , intent(in ) :: km
   838:                                           ! Size of 3rd dimension of sent data
   839:                 integer , intent(in ) :: lm
   840:                                           ! Size of 4th dimension of sent data
   841:                 real(DP), intent(in ) :: buf( im, jm, km, lm )
   842:                                           ! Array to be sent
   843:                 integer , intent(out) :: ireq
   844:                                           ! Request number
   845:                 integer , intent(in ), optional :: itag
   846:                                           ! Size of 1st dimension of sent data
   847:             
   848:             
   849:             
   850:             
   851:                 ! 作業変数
   852:                 ! Work variables
   853:                 !
   854:                 integer :: ierr
   855:                 integer :: isize
   856:                 integer :: tag
   857:             
   858:             
   859:                 isize = size( buf )
   860:             
   861:                 if ( present( itag ) ) then
   862:                   tag = itag
   863:                 else
   864:                   tag = 1
   865:                 end if
   866:             
   867:                 call mpi_isend( buf, isize, &
   868:                   mpi_double_precision, idest, tag, mpi_comm_world, &
   869:                   ireq, ierr )
   870:             
   871:             
   872:             
   873:               end subroutine MPIWrapperISend_dble_4d
   874:             
   875:               !--------------------------------------------------------------------------------------
   876:             
   877:               subroutine MPIWrapperIRecv_dble_4d( &
   878:                 & idep, im, jm, km, lm,           & ! (in)
   879:                 & buf,                            & ! (out)
   880:                 & ireq,                           & ! (out)
   881:                 & itag                            & ! (in) optional
   882:                 & )
   883:                 !
   884:                 ! 4D 倍精度配列の非ブロッキング通信(受信)
   885:                 !
   886:                 ! Non-blocking transfer (receive) of real(8) 4D array
   887:                 !
   888:             
   889:                 ! モジュール引用 ; USE statements
   890:                 !
   891:             
   892:             
   893:                 integer , intent(in ) :: idep
   894:                                           ! Process number of departure
   895:                 integer , intent(in ) :: im
   896:                                           ! Size of 1st dimension of received data
   897:                 integer , intent(in ) :: jm
   898:                                           ! Size of 2nd dimension of received data
   899:                 integer , intent(in ) :: km
   900:                                           ! Size of 3rd dimension of received data
   901:                 integer , intent(in ) :: lm
   902:                                           ! Size of 4th dimension of received data
   903:                 real(DP), intent(out) :: buf( im, jm, km, lm )
   904:                                           ! Array to be received
   905:                 integer , intent(out) :: ireq
   906:                                           ! Request number
   907:                 integer , intent(in ), optional :: itag
   908:                                           ! Size of 1st dimension of sent data
   909:             
   910:             
   911:             
   912:             
   913:                 ! 作業変数
   914:                 ! Work variables
   915:                 !
   916:                 integer :: ierr
   917:                 integer :: isize
   918:                 integer :: tag
   919:             
   920:             
   921:                 isize = size( buf )
   922:             
   923:                 if ( present( itag ) ) then
   924:                   tag = itag
   925:                 else
   926:                   tag = 1
   927:                 end if
   928:             
   929:                 call mpi_irecv( buf, isize, &
   930:                   mpi_double_precision, idep, tag, mpi_comm_world, &
   931:                   ireq, ierr )
   932:             
   933:             
   934:             
   935:             
   936:               end subroutine MPIWrapperIRecv_dble_4d
   937:             
   938:               !--------------------------------------------------------------------------------------
   939:             
   940:               subroutine MPIWrapperFindMaxVal_dble_1d( &
   941:                 & lmax, a_LocalMax,                    & ! (in)
   942:                 & a_GlobalMax                          & ! (out)
   943:                 & )
   944:                 !
   945:                 ! 全球の最大値を探す
   946:                 !
   947:                 ! Find the maximum of the globe
   948:                 !
   949:             
   950:                 ! モジュール引用 ; USE statements
   951:                 !
   952:             
   953:                 integer , intent(in ) :: lmax
   954:                 real(DP), intent(in ) :: a_LocalMax (1:lmax)
   955:                 real(DP), intent(out) :: a_GlobalMax(1:lmax)
   956:             
   957:             
   958:             
   959:             
   960:                 ! 作業変数
   961:                 ! Work variables
   962:                 !
   963:                 integer  :: idep          ! Process number of departure
   964:                 integer  :: idest         ! Process number of destination
   965:                 real(DP) :: a_Buf(1:lmax) ! Array to be received
   966:                 integer  :: ireq          ! Request number
   967:                 real(DP), allocatable :: aa_LocalMax(:,:)
   968:                 integer               :: l
   969:                 integer               :: n
   970:             
   971:             
   972:                 if ( myrank == 0 ) then
   973:             
   974:                   allocate( aa_LocalMax( 1:lmax, 0:nprocs-1 ) )
   975:             
   976: V====== A         aa_LocalMax(:,0) = a_LocalMax
   977:             
   978: +------>          do n = 1, nprocs-1
   979: |                   idep = n
   980: |                   call MPIWrapperIRecv(  &
   981: |                     & idep, lmax,        & ! (in)
   982: |                     & aa_LocalMax(:,n),  & ! (out)
   983: |                     & ireq               & ! (out)
   984: |                     & )
   985: |                   call MPIWrapperWait( ireq )
   986: +------           end do
   987:             
   988: +------>          do l = 1, lmax
   989: |                   n = 0
   990: |                   a_GlobalMax(l) = aa_LocalMax(l,n)
   991: |V----->            do n = 1, nprocs-1
   992: ||      A             if ( a_GlobalMax(l) < aa_LocalMax(l,n) ) then
   993: ||                      a_GlobalMax(l) = aa_LocalMax(l,n)
   994: ||                    end if
   995: |V-----             end do
   996: +------           end do
   997:             
   998: V====== A         a_Buf = a_GlobalMax
   999: +------>          do n = 1, nprocs-1
  1000: |                   idest = n
  1001: |                   call MPIWrapperISend(  &
  1002: |                     & idest, lmax,       & ! (in)
  1003: |                     & a_Buf,             & ! (in)
  1004: |                     & ireq               & ! (out)
  1005: |                     & )
  1006: |                   call MPIWrapperWait( ireq )
  1007: +------           end do
  1008:             
  1009:                   deallocate( aa_LocalMax )
  1010:             
  1011:                 else
  1012:             
  1013:                   idest = 0
  1014: V====== A         a_Buf = a_LocalMax
  1015:                   call MPIWrapperISend(  &
  1016:                     & idest, lmax,       & ! (in)
  1017:                     & a_Buf,             & ! (in)
  1018:                     & ireq               & ! (out)
  1019:                     & )
  1020:                   call MPIWrapperWait( ireq )
  1021:             
  1022:                   idep = 0
  1023:                   call MPIWrapperIRecv(  &
  1024:                     & idep, lmax,        & ! (in)
  1025:                     & a_Buf,             & ! (out)
  1026:                     & ireq               & ! (out)
  1027:                     & )
  1028:                   call MPIWrapperWait( ireq )
  1029:             
  1030: V====== A         a_GlobalMax = a_Buf
  1031:             
  1032:                 end if
  1033:             
  1034:             
  1035:             
  1036:             
  1037:               end subroutine MPIWrapperFindMaxVal_dble_1d
  1038:             
  1039:               !--------------------------------------------------------------------------------------
  1040:               !
  1041:               ! A value of a_GlobalLogical(k) is true, if a_LocalLogical(k) is true 
  1042:               ! at least in a process.
  1043:               !
  1044:               subroutine MPIWrapperChkTrue_1d( &
  1045:                 & lmax, a_LocalLogical,        & ! (in)
  1046:                 & a_GlobalLogical              & ! (out)
  1047:                 & )
  1048:                 !
  1049:                 ! 全球の最大値を探す
  1050:                 !
  1051:                 ! Find the maximum of the globe
  1052:                 !
  1053:             
  1054:                 ! モジュール引用 ; USE statements
  1055:                 !
  1056:             
  1057:                 integer, intent(in ) :: lmax
  1058:                 logical, intent(in ) :: a_LocalLogical (1:lmax)
  1059:                 logical, intent(out) :: a_GlobalLogical(1:lmax)
  1060:             
  1061:             
  1062:             
  1063:             
  1064:                 ! 作業変数
  1065:                 ! Work variables
  1066:                 !
  1067:                 integer  :: idep          ! Process number of departure
  1068:                 integer  :: idest         ! Process number of destination
  1069:                 logical  :: a_Buf(1:lmax) ! Array to be received
  1070:                 integer  :: ireq          ! Request number
  1071:                 logical, allocatable :: aa_LocalLogical(:,:)
  1072:                 integer               :: l
  1073:                 integer               :: n
  1074:             
  1075:             
  1076:                 if ( myrank == 0 ) then
  1077:             
  1078:                   allocate( aa_LocalLogical( 1:lmax, 0:nprocs-1 ) )
  1079:             
  1080: V====== A         aa_LocalLogical(:,0) = a_LocalLogical
  1081:             
  1082: +------>          do n = 1, nprocs-1
  1083: |                   idep = n
  1084: |                   call MPIWrapperIRecv(     &
  1085: |                     & idep, lmax,           & ! (in)
  1086: |                     & aa_LocalLogical(:,n), & ! (out)
  1087: |                     & ireq                  & ! (out)
  1088: |                     & )
  1089: |                   call MPIWrapperWait( ireq )
  1090: +------           end do
  1091:             
  1092: +------>          do l = 1, lmax
  1093: |                   n = 0
  1094: |                   a_GlobalLogical(l) = aa_LocalLogical(l,n)
  1095: |V----->            do n = 1, nprocs-1
  1096: ||      A             if (  aa_LocalLogical(l,n) ) then
  1097: ||                      a_GlobalLogical(l) = aa_LocalLogical(l,n)
  1098: ||                    end if
  1099: |V-----             end do
  1100: +------           end do
  1101:             
  1102: V====== A         a_Buf = a_GlobalLogical
  1103: +------>          do n = 1, nprocs-1
  1104: |                   idest = n
  1105: |                   call MPIWrapperISend(  &
  1106: |                     & idest, lmax,       & ! (in)
  1107: |                     & a_Buf,             & ! (in)
  1108: |                     & ireq               & ! (out)
  1109: |                     & )
  1110: |                   call MPIWrapperWait( ireq )
  1111: +------           end do
  1112:             
  1113:                   deallocate( aa_LocalLogical )
  1114:             
  1115:                 else
  1116:             
  1117:                   idest = 0
  1118: V====== A         a_Buf = a_LocalLogical
  1119:                   call MPIWrapperISend(  &
  1120:                     & idest, lmax,       & ! (in)
  1121:                     & a_Buf,             & ! (in)
  1122:                     & ireq               & ! (out)
  1123:                     & )
  1124:                   call MPIWrapperWait( ireq )
  1125:             
  1126:                   idep = 0
  1127:                   call MPIWrapperIRecv(  &
  1128:                     & idep, lmax,        & ! (in)
  1129:                     & a_Buf,             & ! (out)
  1130:                     & ireq               & ! (out)
  1131:                     & )
  1132:                   call MPIWrapperWait( ireq )
  1133:             
  1134: V====== A         a_GlobalLogical = a_Buf
  1135:             
  1136:                 end if
  1137:             
  1138:             
  1139:             
  1140:             
  1141:               end subroutine MPIWrapperChkTrue_1d
  1142:             
  1143:               !--------------------------------------------------------------------------------------
  1144:             
  1145:             end module mpi_wrapper
