Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: namelist_util.f90
PROGRAM NAME: namelist_util
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   290  opt  (1084): Branch out of the loop inhibits optimization.
   290  vec  (   4): Vectorized array expression.
   290  vec  (  29): ADB is used for array.: array
   290  vec  (   4): Vectorized array expression.
   290  vec  (  26): Macro operation Search.
   291  vec  (   4): Vectorized array expression.
   291  vec  (  29): ADB is used for array.: array
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: namelist_util.f90
PROGRAM NAME: namelist_util
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != NAMELIST ファイル入力に関するユーティリティ
     2  !
     3  != Utilities for NAMELIST file input
     4  !
     5  ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: namelist_util.f90,v 1.4 2013/09/21 14:40:07 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module namelist_util
    13    !
    14    != NAMELIST ファイル入力に関するユーティリティ
    15    !
    16    != Utilities for NAMELIST file input
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Variables List
    21    !
    22    ! namelist_filename :: NAMELIST ファイルの名称.
    23    ! MaxNmlArySize     :: NAMELIST から読み込む配列の最大サイズ.
    24    ! ------------      :: ------------
    25    ! namelist_filename :: NAMELIST file name
    26    ! MaxNmlArySize     :: Maximum size of arrays loaded from NAMELIST
    27    !
    28    !== Procedures List
    29    !
    30    ! NmlutilInit      :: NAMELIST ファイル名の設定
    31    ! NmlutilMsg       :: NAMELIST ファイル入力に関するメッセージ表示
    32    ! NmlutilAryValid  :: NAMELIST ファイルから読み込んだ配列の有効性をチェック
    33    ! ------------  :: ------------
    34    ! NmlutilInit      :: Settings of NAMELIST file name
    35    ! NmlutilMsg       :: Print messages about NAMELIST file input
    36    ! NmlutilAryValid  :: Check validation of arrays loaded from NAMELIST file
    37  
    38    ! モジュール引用 ; USE statements
    39    !
    40  
    41    ! 種別型パラメタ
    42    ! Kind type parameter
    43    !
    44    use dc_types, only: STRING  ! 文字列. Strings.
    45  
    46    ! メッセージ出力
    47    ! Message output
    48    !
    49    use dc_message, only: MessageNotify
    50  
    51    ! 宣言文 ; Declaration statements
    52    !
    53    implicit none
    54    private
    55  
    56    ! 公開手続き
    57    ! Public procedure
    58    !
    59    public:: NmlutilInit, NmlutilMsg, NmlutilAryValid
    60  
    61    ! 公開変数
    62    ! Public variables
    63    !
    64    logical, save, public:: namelist_util_inited = .false.
    65                                ! 初期設定フラグ.
    66                                ! Initialization flag
    67    character(STRING), save, public:: namelist_filename = ''
    68                                ! NAMELIST ファイルの名称.
    69                                ! NAMELIST file name
    70  
    71    integer, parameter, public:: MaxNmlArySize = 256
    72                                ! NAMELIST から読み込む配列の最大サイズ.
    73                                ! Maximum size of arrays loaded from NAMELIST
    74  
    75    ! 非公開変数
    76    ! Private variables
    77    !
    78  
    79    !  NAMELIST 変数群
    80    !  NAMELIST group name
    81    !
    82  !!$  namelist /namelist_util_nml/ MaxNmlArySize
    83  
    84    character(*), parameter:: module_name = 'namelist_util'
    85                                ! モジュールの名称.
    86                                ! Module name
    87    character(*), parameter:: version = &
    88      & '$Name:  $' // &
    89      & '$Id: namelist_util.f90,v 1.4 2013/09/21 14:40:07 yot Exp $'
    90                                ! モジュールのバージョン
    91                                ! Module version
    92  
    93  contains
    94  
    95    subroutine NmlutilInit(  &
    96      & namelist_filename_in & ! (in)
    97      & )
    98      !
    99      ! namelist_util モジュールの初期設定を行います.
   100      !
   101      ! Initialize "namelist_util" module.
   102      !
   103  
   104      ! モジュール引用 ; USE statements
   105      !
   106  
   107      ! ファイル入出力補助
   108      ! File I/O support
   109      !
   110      use dc_iounit, only: FileOpen
   111  
   112      ! 宣言文 ; Declaration statements
   113      !
   114      implicit none
   115  
   116      character(*), intent(in ) :: namelist_filename_in
   117                                ! NAMELIST ファイルの名称.
   118                                ! NAMELIST file name
   119  
   120  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   121  !!$                              ! Unit number for NAMELIST file open
   122  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   123  !!$                              ! IOSTAT of NAMELIST read
   124  
   125      ! 実行文 ; Executable statement
   126      !
   127  
   128      if ( namelist_util_inited ) return
   129      namelist_filename = namelist_filename_in
   130  
   131      ! NAMELIST の読み込み
   132      ! NAMELIST is input
   133      !
   134  !!$    call FileOpen( unit_nml, &          ! (out)
   135  !!$      & namelist_filename, mode = 'r' ) ! (in)
   136  !!$
   137  !!$    rewind( unit_nml )
   138  !!$    read( unit_nml, &               ! (in)
   139  !!$      & nml = namelist_util_nml, &  ! (out)
   140  !!$      & iostat = iostat_nml )       ! (out)
   141  !!$    close( unit_nml )
   142  !!$
   143  !!$    call NmlutilMsg( iostat_nml, module_name ) ! (in)
   144  
   145      ! 印字 ; Print
   146      !
   147      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   148      call MessageNotify( 'M', module_name, '  MaxNmlArySize = %d', i = (/ MaxNmlArySize /) )
   149      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   150  
   151      namelist_util_inited = .true.
   152    end subroutine NmlutilInit
   153  
   154    subroutine NmlutilMsg( iostat, name & ! (in)
   155      & )
   156      !
   157      ! NAMELIST ファイル入力ステータスから
   158      ! 適切なメッセージを表示します.
   159      !
   160      ! Appropriate messages are output from
   161      ! status of NAMELIST file loading.
   162      !
   163  
   164      implicit none
   165      integer, intent(in):: iostat
   166                                ! NAMELIST 読み込み時のステータス.
   167                                ! Status of NAMELIST loading
   168      character(*), intent(in):: name
   169                                ! モジュールの名称.
   170                                ! Module name
   171  
   172      ! 実行文 ; Executable statement
   173      !
   174  
   175      if ( iostat == 0 ) then
   176        call MessageNotify( 'M', name, &
   177          & 'NAMELIST group "%c" is loaded from "%c".', &
   178          & c1 = trim(name) // '_nml', &
   179          & c2 = trim(namelist_filename) )
   180      else if ( iostat > 0 ) then
   181        call MessageNotify( 'E', name, &
   182          & 'NAMELIST group "%c" has something wrong in "%c" (iostat=%d).', &
   183          & c1 = trim(name) // '_nml', &
   184          & c2 = trim(namelist_filename), &
   185          & i = (/iostat/) )
   186      else
   187        call MessageNotify( 'W', name, &
   188          & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
   189          & c1 = trim(name) // '_nml', &
   190          & c2 = trim(namelist_filename), &
   191          & i = (/iostat/) )
   192      end if
   193  
   194    end subroutine NmlutilMsg
   195  
   196    subroutine NmlutilAryValid( name, &               ! (in)
   197      & array, array_name, need_num, need_num_name, & ! (in)
   198      & valid_limit &                                 ! (in) optional
   199      )
   200      !
   201      ! NAMELIST から読み込んだ配列型データの妥当性を
   202      ! チェックします.
   203      !
   204      ! デフォルトでは, 正の値を有効と扱います.
   205      ! 無効であると検証された場合には, エラーを発生させます.
   206      !
   207      ! Check validation of array data loaded from NAMELIST.
   208      !
   209      ! By defaut, positive values are treated as valid values.
   210      ! If invalidation is checked, an error is occurred.
   211      !
   212  
   213      ! モジュール引用 ; USE statements
   214      !
   215  
   216      ! 種別型パラメタ
   217      ! Kind type parameter
   218      !
   219      use dc_types, only: DP      ! 倍精度実数型. Double precision.
   220  
   221      ! 宣言文 ; Declaration statements
   222      !
   223      implicit none
   224      character(*), intent(in):: name
   225                                ! このサブルーチンを呼び出すモジュールの名称.
   226                                ! Module name calling this subroutine
   227      real(DP), intent(in):: array(:)
   228                                ! 検証すべき配列データ.
   229                                ! Checked array data
   230      character(*), intent(in):: array_name
   231                                ! 検証すべき配列データの名前.
   232                                ! Name of checked array data
   233      integer, intent(in):: need_num
   234                                ! 必要なデータ数.
   235                                ! 0 未満の数を与えるとエラーを生じます.
   236                                !
   237                                ! Number of needed data.
   238                                ! If number less than 0, an error is occurred.
   239      character(*), intent(in):: need_num_name
   240                                ! 必要なデータ数を示す変数の名前.
   241                                ! Name of a variable that indicates number of needed data
   242      real(DP), intent(in), optional:: valid_limit
   243                                ! 有効下限値 (デフォルトは 0.0).
   244                                ! Lower limit of validation (defalt is 0.0)
   245  
   246      ! 作業変数
   247      ! Work variables
   248      !
   249      real(DP):: valid_limit_work
   250                                ! 有効下限値 (デフォルトは 0.0).
   251                                ! Lower limit of validation (defalt is 0.0)
   252      integer:: valid_count     ! 配列データの有効値の数.
   253                                ! Number of valid values in an array
   254      integer:: size_array      ! 配列データのサイズ
   255                                ! Size of array data
   256  
   257      ! 実行文 ; Executable statement
   258      !
   259  
   260      ! need_num が負ではないことをチェック
   261      ! Check that "need_num" is not negative
   262      !
   263      if ( need_num < 0 ) then
   264        call MessageNotify( 'E', name, '%c=<%d> must not be negative.', &
   265          &                 c1 = trim(need_num_name), i = (/ need_num /) )
   266      end if
   267  
   268      ! array のサイズが十分であることをチェック
   269      ! Check that size of "array" is enough
   270      !
   271      size_array = size(array)
   272      if ( need_num > size_array ) then
   273        call MessageNotify( 'E', name, &
   274          &  'Maximum size=<%d> of "%c" is too smaller than %c=<%d>. ' // &
   275          &  'Please search for a statement "MaxNmlArySize = %d" in ' // &
   276          &  '"namelist_util.f90", and change it into "MaxNmlArySize = %d".', &
   277  !!$        &  'Please add a following phrase to NAMELIST file. ' // &
   278  !!$        &  ' "&namelist_util_nml  MaxNmlArySize=%d /"', &
   279          &  i = (/ size_array, need_num, MaxNmlArySize, need_num /), &
   280          &  c1 = trim(array_name), c2 = trim(need_num_name) )
   281      end if
   282  
   283      ! array をチェック
   284      ! Check "array"
   285      !
   286      if ( need_num > 0 ) then
   287        valid_limit_work = 0.0_DP
   288        if ( present( valid_limit ) ) valid_limit_work = valid_limit
   289  
   290        if ( any( array(1:need_num) < valid_limit_work ) ) then
   291          valid_count = count( .not. ( array(1:need_num) < valid_limit_work ) )
   292          if ( valid_count > 0 ) then
   293            call MessageNotify( 'E', name, &
   294              &   'Number of valid data of %c=<%*f> is %d. ' // &
   295              &   'Valid data is %c=<%d> necessary.', &
   296              &   c1 = trim( array_name ), c2 = trim( need_num_name ), &
   297              &   d = array(1:valid_count), n = (/ valid_count /), &
   298              &   i = (/ valid_count, need_num /) )
   299          else
   300            call MessageNotify( 'E', name, &
   301              &   'Valid data of %c is nothing. ' // &
   302              &   'Valid data is %c=<%d> necessary.', &
   303              &   c1 = trim( array_name ), c2 = trim( need_num_name ), &
   304              &   i = (/ need_num /) )
   305          end if
   306        end if
   307      end if
   308  
   309    end subroutine NmlutilAryValid
   310  
   311  end module namelist_util
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: namelist_util.f90
PROGRAM NAME: namelist_util
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != NAMELIST ファイル入力に関するユーティリティ
     2:             !
     3:             != Utilities for NAMELIST file input
     4:             !
     5:             ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: namelist_util.f90,v 1.4 2013/09/21 14:40:07 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module namelist_util
    13:               !
    14:               != NAMELIST ファイル入力に関するユーティリティ
    15:               !
    16:               != Utilities for NAMELIST file input
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Variables List
    21:               !
    22:               ! namelist_filename :: NAMELIST ファイルの名称. 
    23:               ! MaxNmlArySize     :: NAMELIST から読み込む配列の最大サイズ. 
    24:               ! ------------      :: ------------
    25:               ! namelist_filename :: NAMELIST file name
    26:               ! MaxNmlArySize     :: Maximum size of arrays loaded from NAMELIST
    27:               !
    28:               !== Procedures List
    29:               !
    30:               ! NmlutilInit      :: NAMELIST ファイル名の設定
    31:               ! NmlutilMsg       :: NAMELIST ファイル入力に関するメッセージ表示
    32:               ! NmlutilAryValid  :: NAMELIST ファイルから読み込んだ配列の有効性をチェック
    33:               ! ------------  :: ------------
    34:               ! NmlutilInit      :: Settings of NAMELIST file name
    35:               ! NmlutilMsg       :: Print messages about NAMELIST file input
    36:               ! NmlutilAryValid  :: Check validation of arrays loaded from NAMELIST file
    37:             
    38:               ! モジュール引用 ; USE statements
    39:               !
    40:             
    41:               ! 種別型パラメタ
    42:               ! Kind type parameter
    43:               !
    44:               use dc_types, only: STRING  ! 文字列. Strings. 
    45:             
    46:               ! メッセージ出力
    47:               ! Message output
    48:               !
    49:               use dc_message, only: MessageNotify
    50:             
    51:               ! 宣言文 ; Declaration statements
    52:               !
    53:               implicit none
    54:               private
    55:             
    56:               ! 公開手続き
    57:               ! Public procedure
    58:               !
    59:               public:: NmlutilInit, NmlutilMsg, NmlutilAryValid
    60:             
    61:               ! 公開変数
    62:               ! Public variables
    63:               !
    64:               logical, save, public:: namelist_util_inited = .false.
    65:                                           ! 初期設定フラグ. 
    66:                                           ! Initialization flag
    67:               character(STRING), save, public:: namelist_filename = ''
    68:                                           ! NAMELIST ファイルの名称. 
    69:                                           ! NAMELIST file name
    70:             
    71:               integer, parameter, public:: MaxNmlArySize = 256
    72:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    73:                                           ! Maximum size of arrays loaded from NAMELIST
    74:             
    75:               ! 非公開変数
    76:               ! Private variables
    77:               !
    78:             
    79:               !  NAMELIST 変数群
    80:               !  NAMELIST group name
    81:               !
    82:             !!$  namelist /namelist_util_nml/ MaxNmlArySize
    83:             
    84:               character(*), parameter:: module_name = 'namelist_util'
    85:                                           ! モジュールの名称. 
    86:                                           ! Module name
    87:               character(*), parameter:: version = &
    88:                 & '$Name:  $' // &
    89:                 & '$Id: namelist_util.f90,v 1.4 2013/09/21 14:40:07 yot Exp $'
    90:                                           ! モジュールのバージョン
    91:                                           ! Module version
    92:             
    93:             contains
    94:             
    95:               subroutine NmlutilInit(  &
    96:                 & namelist_filename_in & ! (in)
    97:                 & )
    98:                 !
    99:                 ! namelist_util モジュールの初期設定を行います. 
   100:                 !
   101:                 ! Initialize "namelist_util" module. 
   102:                 !
   103:             
   104:                 ! モジュール引用 ; USE statements
   105:                 !
   106:             
   107:                 ! ファイル入出力補助
   108:                 ! File I/O support
   109:                 !
   110:                 use dc_iounit, only: FileOpen
   111:             
   112:                 ! 宣言文 ; Declaration statements
   113:                 !
   114:                 implicit none
   115:             
   116:                 character(*), intent(in ) :: namelist_filename_in
   117:                                           ! NAMELIST ファイルの名称. 
   118:                                           ! NAMELIST file name
   119:             
   120:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   121:             !!$                              ! Unit number for NAMELIST file open
   122:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   123:             !!$                              ! IOSTAT of NAMELIST read
   124:             
   125:                 ! 実行文 ; Executable statement
   126:                 !
   127:             
   128:                 if ( namelist_util_inited ) return
   129:                 namelist_filename = namelist_filename_in
   130:             
   131:                 ! NAMELIST の読み込み
   132:                 ! NAMELIST is input
   133:                 !
   134:             !!$    call FileOpen( unit_nml, &          ! (out)
   135:             !!$      & namelist_filename, mode = 'r' ) ! (in)
   136:             !!$
   137:             !!$    rewind( unit_nml )
   138:             !!$    read( unit_nml, &               ! (in)
   139:             !!$      & nml = namelist_util_nml, &  ! (out)
   140:             !!$      & iostat = iostat_nml )       ! (out)
   141:             !!$    close( unit_nml )
   142:             !!$
   143:             !!$    call NmlutilMsg( iostat_nml, module_name ) ! (in)
   144:             
   145:                 ! 印字 ; Print
   146:                 !
   147:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   148:                 call MessageNotify( 'M', module_name, '  MaxNmlArySize = %d', i = (/ MaxNmlArySize /) )
   149:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   150:             
   151:                 namelist_util_inited = .true.
   152:               end subroutine NmlutilInit
   153:             
   154:               subroutine NmlutilMsg( iostat, name & ! (in)
   155:                 & )
   156:                 !
   157:                 ! NAMELIST ファイル入力ステータスから
   158:                 ! 適切なメッセージを表示します. 
   159:                 !
   160:                 ! Appropriate messages are output from 
   161:                 ! status of NAMELIST file loading. 
   162:                 !
   163:             
   164:                 implicit none
   165:                 integer, intent(in):: iostat
   166:                                           ! NAMELIST 読み込み時のステータス. 
   167:                                           ! Status of NAMELIST loading
   168:                 character(*), intent(in):: name
   169:                                           ! モジュールの名称. 
   170:                                           ! Module name
   171:             
   172:                 ! 実行文 ; Executable statement
   173:                 !
   174:             
   175:                 if ( iostat == 0 ) then
   176:                   call MessageNotify( 'M', name, &
   177:                     & 'NAMELIST group "%c" is loaded from "%c".', &
   178:                     & c1 = trim(name) // '_nml', &
   179:                     & c2 = trim(namelist_filename) )
   180:                 else if ( iostat > 0 ) then
   181:                   call MessageNotify( 'E', name, &
   182:                     & 'NAMELIST group "%c" has something wrong in "%c" (iostat=%d).', &
   183:                     & c1 = trim(name) // '_nml', &
   184:                     & c2 = trim(namelist_filename), &
   185:                     & i = (/iostat/) )
   186:                 else
   187:                   call MessageNotify( 'W', name, &
   188:                     & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
   189:                     & c1 = trim(name) // '_nml', &
   190:                     & c2 = trim(namelist_filename), &
   191:                     & i = (/iostat/) )
   192:                 end if
   193:             
   194:               end subroutine NmlutilMsg
   195:             
   196:               subroutine NmlutilAryValid( name, &               ! (in)
   197:                 & array, array_name, need_num, need_num_name, & ! (in)
   198:                 & valid_limit &                                 ! (in) optional
   199:                 )
   200:                 !
   201:                 ! NAMELIST から読み込んだ配列型データの妥当性を
   202:                 ! チェックします. 
   203:                 ! 
   204:                 ! デフォルトでは, 正の値を有効と扱います. 
   205:                 ! 無効であると検証された場合には, エラーを発生させます. 
   206:                 ! 
   207:                 ! Check validation of array data loaded from NAMELIST. 
   208:                 !
   209:                 ! By defaut, positive values are treated as valid values.
   210:                 ! If invalidation is checked, an error is occurred. 
   211:                 ! 
   212:             
   213:                 ! モジュール引用 ; USE statements
   214:                 !
   215:             
   216:                 ! 種別型パラメタ
   217:                 ! Kind type parameter
   218:                 !
   219:                 use dc_types, only: DP      ! 倍精度実数型. Double precision. 
   220:             
   221:                 ! 宣言文 ; Declaration statements
   222:                 !
   223:                 implicit none
   224:                 character(*), intent(in):: name
   225:                                           ! このサブルーチンを呼び出すモジュールの名称. 
   226:                                           ! Module name calling this subroutine
   227:                 real(DP), intent(in):: array(:)
   228:                                           ! 検証すべき配列データ. 
   229:                                           ! Checked array data 
   230:                 character(*), intent(in):: array_name
   231:                                           ! 検証すべき配列データの名前. 
   232:                                           ! Name of checked array data 
   233:                 integer, intent(in):: need_num
   234:                                           ! 必要なデータ数. 
   235:                                           ! 0 未満の数を与えるとエラーを生じます. 
   236:                                           ! 
   237:                                           ! Number of needed data. 
   238:                                           ! If number less than 0, an error is occurred. 
   239:                 character(*), intent(in):: need_num_name
   240:                                           ! 必要なデータ数を示す変数の名前. 
   241:                                           ! Name of a variable that indicates number of needed data
   242:                 real(DP), intent(in), optional:: valid_limit
   243:                                           ! 有効下限値 (デフォルトは 0.0). 
   244:                                           ! Lower limit of validation (defalt is 0.0) 
   245:             
   246:                 ! 作業変数
   247:                 ! Work variables
   248:                 !
   249:                 real(DP):: valid_limit_work
   250:                                           ! 有効下限値 (デフォルトは 0.0). 
   251:                                           ! Lower limit of validation (defalt is 0.0) 
   252:                 integer:: valid_count     ! 配列データの有効値の数. 
   253:                                           ! Number of valid values in an array
   254:                 integer:: size_array      ! 配列データのサイズ
   255:                                           ! Size of array data
   256:             
   257:                 ! 実行文 ; Executable statement
   258:                 !
   259:             
   260:                 ! need_num が負ではないことをチェック
   261:                 ! Check that "need_num" is not negative 
   262:                 !
   263:                 if ( need_num < 0 ) then
   264:                   call MessageNotify( 'E', name, '%c=<%d> must not be negative.', &
   265:                     &                 c1 = trim(need_num_name), i = (/ need_num /) )
   266:                 end if
   267:             
   268:                 ! array のサイズが十分であることをチェック
   269:                 ! Check that size of "array" is enough
   270:                 !
   271:                 size_array = size(array)
   272:                 if ( need_num > size_array ) then
   273:                   call MessageNotify( 'E', name, &
   274:                     &  'Maximum size=<%d> of "%c" is too smaller than %c=<%d>. ' // &
   275:                     &  'Please search for a statement "MaxNmlArySize = %d" in ' // &
   276:                     &  '"namelist_util.f90", and change it into "MaxNmlArySize = %d".', &
   277:             !!$        &  'Please add a following phrase to NAMELIST file. ' // &
   278:             !!$        &  ' "&namelist_util_nml  MaxNmlArySize=%d /"', &
   279:                     &  i = (/ size_array, need_num, MaxNmlArySize, need_num /), &
   280:                     &  c1 = trim(array_name), c2 = trim(need_num_name) )
   281:                 end if
   282:             
   283:                 ! array をチェック
   284:                 ! Check "array"
   285:                 !
   286:                 if ( need_num > 0 ) then
   287:                   valid_limit_work = 0.0_DP
   288:                   if ( present( valid_limit ) ) valid_limit_work = valid_limit
   289:             
   290: V====== A         if ( any( array(1:need_num) < valid_limit_work ) ) then
   291: V====== A           valid_count = count( .not. ( array(1:need_num) < valid_limit_work ) )
   292:                     if ( valid_count > 0 ) then
   293:                       call MessageNotify( 'E', name, &
   294:                         &   'Number of valid data of %c=<%*f> is %d. ' // &
   295:                         &   'Valid data is %c=<%d> necessary.', &
   296:                         &   c1 = trim( array_name ), c2 = trim( need_num_name ), &
   297:                         &   d = array(1:valid_count), n = (/ valid_count /), &
   298:                         &   i = (/ valid_count, need_num /) )
   299:                     else
   300:                       call MessageNotify( 'E', name, &
   301:                         &   'Valid data of %c is nothing. ' // &
   302:                         &   'Valid data is %c=<%d> necessary.', &
   303:                         &   c1 = trim( array_name ), c2 = trim( need_num_name ), &
   304:                         &   i = (/ need_num /) )
   305:                     end if
   306:                   end if
   307:                 end if
   308:             
   309:               end subroutine NmlutilAryValid
   310:             
   311:             end module namelist_util
