Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: option_parser.f90
PROGRAM NAME: option_parser
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != コマンドライン引数解析処理
     2  !
     3  != Command line option parser
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6  ! Version::   $Id: option_parser.f90,v 1.3 2010/08/30 01:54:45 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module option_parser
    13    !
    14    != コマンドライン引数解析処理
    15    !
    16    != Command line option parser
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! コマンドライン引数の解析処理を行います.
    21    !
    22    ! Command line options are parsed
    23    !
    24    !== Procedures List
    25    !
    26    ! OptParseInit  :: コマンドライン引数の解析処理
    27    ! ------------  :: ------------
    28    ! OptParseInit  :: Parse of command line options
    29  
    30    ! モジュール引用 ; USE statements
    31    !
    32  
    33    ! 種別型パラメタ
    34    ! Kind type parameter
    35    !
    36    use dc_types, only: STRING  ! 文字列. Strings.
    37  
    38    ! 宣言文 ; Declaration statements
    39    !
    40    implicit none
    41    private
    42  
    43    ! 公開手続き
    44    ! Public procedure
    45    !
    46    public:: OptParseInit
    47  
    48    ! 公開変数
    49    ! Public variables
    50    !
    51    logical, save, public:: option_parser_inited = .false.
    52                                ! 初期設定フラグ.
    53                                ! Initialization flag
    54    logical, save:: namelist_flag = .false.
    55                                ! NAMELIST ファイル指定の有無を示すフラグ.
    56                                ! Flag of NAMELIST file specification
    57  
    58    ! 非公開変数
    59    ! Private variables
    60    !
    61    character(*), parameter:: module_name = 'option_parser'
    62                                ! モジュールの名称.
    63                                ! Module name
    64    character(*), parameter:: version = &
    65      & '$Name:  $' // &
    66      & '$Id: option_parser.f90,v 1.3 2010/08/30 01:54:45 yot Exp $'
    67                                ! モジュールのバージョン
    68                                ! Module version
    69  
    70  contains
    71  
    72    subroutine OptParseInit( &
    73      & namelist_filename,   & ! (out)
    74      & exec_name, brief     & ! (in ) optional
    75      & )
    76      !
    77      ! option_parser モジュールの初期設定を行います.
    78      !
    79      ! Initialize "option_parser" module.
    80      !
    81  
    82      ! モジュール引用 ; USE statements
    83      !
    84  
    85      ! 文字列操作
    86      ! Character handling
    87      !
    88      use dc_string, only: StoA
    89  
    90      ! コマンドライン引数処理下請け
    91      ! Command line option parser subcontractor
    92      !
    93      use dc_args, only: ARGS, &
    94        & DCArgsOpen,  DCArgsHelpMsg, DCArgsOption, &
    95        & DCArgsDebug, DCArgsHelp,    DCArgsStrict, DCArgsClose
    96  
    97      ! 組み込み関数 PRESENT の拡張版関数
    98      ! Extended functions of intrinsic function "PRESENT"
    99      !
   100      use dc_present, only: present_and_not_empty
   101  
   102      ! 宣言文 ; Declaration statements
   103      !
   104      implicit none
   105      character(*), intent(out)          :: namelist_filename
   106                                ! NAMELIST ファイルの名称.
   107                                ! NAMELIST file name
   108      character(*), intent(in ), optional:: exec_name
   109                                ! 実行ファイル名.
   110                                ! Executable file name
   111      character(*), intent(in ), optional:: brief
   112                                ! 実行ファイルの簡潔な説明
   113                                ! Brief account of executable file
   114  
   115      character(STRING):: ename
   116                                ! 実行ファイル名.
   117                                ! Executable file name
   118      character(STRING):: brief_msg
   119                                ! 実行ファイルの簡潔な説明
   120                                ! Brief account of executable file
   121  
   122      type(ARGS):: arg          ! コマンドライン引数.
   123                                ! Command line options
   124  
   125      ! 実行文 ; Executable statement
   126      !
   127  
   128      if ( option_parser_inited ) return
   129      call InitCheck
   130  
   131      ! オプショナル引数の処理.
   132      ! Handling of optional arguments
   133      !
   134      if ( present_and_not_empty(exec_name) ) then
   135        ename = exec_name
   136      else
   137        ename = 'dcpam'
   138      end if
   139  
   140      if ( present_and_not_empty(brief) ) then
   141        brief_msg = brief
   142      else
   143        brief_msg = 'dcpam main program'
   144      end if
   145  
   146      ! コマンドライン引数の解析処理
   147      ! Parse command line arguments
   148      !
   149      call DCArgsOpen( arg )               ! (out)
   150  
   151      call DCArgsHelpMsg( arg, &                          ! (inout)
   152        & category = 'Title', &                           ! (in)
   153        & msg = trim(ename) // ': ' // trim(brief_msg) )  ! (in)
   154      call DCArgsHelpMsg( arg, &                      ! (inout)
   155        & category = 'Usage', &                       ! (in)
   156        & msg = './' // trim(ename) // ' [Options]' ) ! (in)
   157  
   158      call DCArgsOption( arg, &                 ! (inout)
   159        & options = StoA('-N', '--namelist'), & ! (in)
   160        & flag = namelist_flag, &               ! (out)
   161        & value = namelist_filename, &          ! (out)
   162        & help = "Namelist filename")           ! (in)
   163  
   164      call DCArgsDebug( arg )  ! (inout)
   165      call DCArgsHelp( arg )   ! (inout)
   166      call DCArgsStrict( arg ) ! (inout)
   167  
   168      call DCArgsClose( arg )  ! (inout)
   169  
   170      option_parser_inited = .true.
   171    end subroutine OptParseInit
   172  
   173    subroutine InitCheck
   174      !
   175      ! 依存モジュールの初期化チェック
   176      !
   177      ! Check initialization of dependency modules
   178  
   179      ! 実行文 ; Executable statement
   180      !
   181  
   182  
   183    end subroutine InitCheck
   184  
   185  
   186  end module option_parser
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: option_parser.f90
PROGRAM NAME: option_parser
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != コマンドライン引数解析処理
     2:             !
     3:             != Command line option parser
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6:             ! Version::   $Id: option_parser.f90,v 1.3 2010/08/30 01:54:45 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module option_parser
    13:               !
    14:               != コマンドライン引数解析処理
    15:               !
    16:               != Command line option parser
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! コマンドライン引数の解析処理を行います. 
    21:               !
    22:               ! Command line options are parsed
    23:               !
    24:               !== Procedures List
    25:               !
    26:               ! OptParseInit  :: コマンドライン引数の解析処理
    27:               ! ------------  :: ------------
    28:               ! OptParseInit  :: Parse of command line options
    29:             
    30:               ! モジュール引用 ; USE statements
    31:               !
    32:             
    33:               ! 種別型パラメタ
    34:               ! Kind type parameter
    35:               !
    36:               use dc_types, only: STRING  ! 文字列. Strings. 
    37:             
    38:               ! 宣言文 ; Declaration statements
    39:               !
    40:               implicit none
    41:               private
    42:             
    43:               ! 公開手続き
    44:               ! Public procedure
    45:               !
    46:               public:: OptParseInit
    47:             
    48:               ! 公開変数
    49:               ! Public variables
    50:               !
    51:               logical, save, public:: option_parser_inited = .false.
    52:                                           ! 初期設定フラグ. 
    53:                                           ! Initialization flag
    54:               logical, save:: namelist_flag = .false.
    55:                                           ! NAMELIST ファイル指定の有無を示すフラグ. 
    56:                                           ! Flag of NAMELIST file specification
    57:             
    58:               ! 非公開変数
    59:               ! Private variables
    60:               !
    61:               character(*), parameter:: module_name = 'option_parser'
    62:                                           ! モジュールの名称. 
    63:                                           ! Module name
    64:               character(*), parameter:: version = &
    65:                 & '$Name:  $' // &
    66:                 & '$Id: option_parser.f90,v 1.3 2010/08/30 01:54:45 yot Exp $'
    67:                                           ! モジュールのバージョン
    68:                                           ! Module version
    69:             
    70:             contains
    71:             
    72:               subroutine OptParseInit( &
    73:                 & namelist_filename,   & ! (out)
    74:                 & exec_name, brief     & ! (in ) optional
    75:                 & )
    76:                 !
    77:                 ! option_parser モジュールの初期設定を行います. 
    78:                 !
    79:                 ! Initialize "option_parser" module. 
    80:                 !
    81:             
    82:                 ! モジュール引用 ; USE statements
    83:                 !
    84:             
    85:                 ! 文字列操作
    86:                 ! Character handling
    87:                 !
    88:                 use dc_string, only: StoA
    89:             
    90:                 ! コマンドライン引数処理下請け
    91:                 ! Command line option parser subcontractor
    92:                 !
    93:                 use dc_args, only: ARGS, &
    94:                   & DCArgsOpen,  DCArgsHelpMsg, DCArgsOption, &
    95:                   & DCArgsDebug, DCArgsHelp,    DCArgsStrict, DCArgsClose
    96:             
    97:                 ! 組み込み関数 PRESENT の拡張版関数
    98:                 ! Extended functions of intrinsic function "PRESENT"
    99:                 !
   100:                 use dc_present, only: present_and_not_empty
   101:             
   102:                 ! 宣言文 ; Declaration statements
   103:                 !
   104:                 implicit none
   105:                 character(*), intent(out)          :: namelist_filename
   106:                                           ! NAMELIST ファイルの名称. 
   107:                                           ! NAMELIST file name
   108:                 character(*), intent(in ), optional:: exec_name
   109:                                           ! 実行ファイル名. 
   110:                                           ! Executable file name
   111:                 character(*), intent(in ), optional:: brief
   112:                                           ! 実行ファイルの簡潔な説明
   113:                                           ! Brief account of executable file
   114:             
   115:                 character(STRING):: ename
   116:                                           ! 実行ファイル名. 
   117:                                           ! Executable file name
   118:                 character(STRING):: brief_msg
   119:                                           ! 実行ファイルの簡潔な説明
   120:                                           ! Brief account of executable file
   121:             
   122:                 type(ARGS):: arg          ! コマンドライン引数. 
   123:                                           ! Command line options
   124:             
   125:                 ! 実行文 ; Executable statement
   126:                 !
   127:             
   128:                 if ( option_parser_inited ) return
   129:                 call InitCheck
   130:             
   131:                 ! オプショナル引数の処理. 
   132:                 ! Handling of optional arguments 
   133:                 !
   134:                 if ( present_and_not_empty(exec_name) ) then
   135:                   ename = exec_name
   136:                 else
   137:                   ename = 'dcpam'
   138:                 end if
   139:             
   140:                 if ( present_and_not_empty(brief) ) then
   141:                   brief_msg = brief
   142:                 else
   143:                   brief_msg = 'dcpam main program'
   144:                 end if
   145:             
   146:                 ! コマンドライン引数の解析処理
   147:                 ! Parse command line arguments
   148:                 !
   149:                 call DCArgsOpen( arg )               ! (out)
   150:             
   151:                 call DCArgsHelpMsg( arg, &                          ! (inout)
   152:                   & category = 'Title', &                           ! (in)
   153:                   & msg = trim(ename) // ': ' // trim(brief_msg) )  ! (in)
   154:                 call DCArgsHelpMsg( arg, &                      ! (inout)
   155:                   & category = 'Usage', &                       ! (in)
   156:                   & msg = './' // trim(ename) // ' [Options]' ) ! (in)
   157:             
   158:                 call DCArgsOption( arg, &                 ! (inout)
   159:                   & options = StoA('-N', '--namelist'), & ! (in)
   160:                   & flag = namelist_flag, &               ! (out)
   161:                   & value = namelist_filename, &          ! (out)
   162:                   & help = "Namelist filename")           ! (in)
   163:             
   164:                 call DCArgsDebug( arg )  ! (inout)
   165:                 call DCArgsHelp( arg )   ! (inout)
   166:                 call DCArgsStrict( arg ) ! (inout)
   167:             
   168:                 call DCArgsClose( arg )  ! (inout)
   169:             
   170:                 option_parser_inited = .true.
   171:               end subroutine OptParseInit
   172:             
   173:               subroutine InitCheck
   174:                 !
   175:                 ! 依存モジュールの初期化チェック
   176:                 !
   177:                 ! Check initialization of dependency modules
   178:             
   179:                 ! 実行文 ; Executable statement
   180:                 !
   181:             
   182:             
   183:               end subroutine InitCheck
   184:             
   185:             
   186:             end module option_parser
