Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: sigma_data.f90
PROGRAM NAME: sigma_data
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   126  vec  (   4): Vectorized array expression.
   126  vec  (  29): ADB is used for array.: r_sigma
   130  vec  (   4): Vectorized array expression.
   130  vec  (  29): ADB is used for array.: r_sigma
   135  vec  (   4): Vectorized array expression.
   135  vec  (  29): ADB is used for array.: r_sigma
   141  vec  (   4): Vectorized array expression.
   141  vec  (  29): ADB is used for array.: r_sigma
   148  vec  (   4): Vectorized array expression.
   148  vec  (  29): ADB is used for array.: r_sigma
   155  vec  (   4): Vectorized array expression.
   155  vec  (  29): ADB is used for array.: r_sigma
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: sigma_data.f90
PROGRAM NAME: sigma_data
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 鉛直σ半整数レベル提供
     2  !
     3  != Prepare vertical sigma half level
     4  !
     5  ! Authors::   Yasuhiro MORIKAWA
     6  ! Version::   $Id: sigma_data.f90,v 1.2 2008/08/11 21:50:23 morikawa Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module sigma_data
    13    !
    14    != 鉛直σ半整数レベル提供
    15    !
    16    != Prepare vertical sigma half level
    17    !
    18    ! 鉛直σ半整数レベルのサンプルデータを提供します.
    19    !
    20    ! Prepare sample data of vertical sigma half level.
    21    !
    22    !== Procedures List
    23    !
    24    ! SigmaDataGetHalf   :: 鉛直σ半整数レベル取得.
    25    ! ------------  :: ------------
    26    ! SigmaDataGetHalf   :: Get vertical sigma half level.
    27  
    28    ! モジュール引用 ; USE statements
    29    !
    30  
    31    ! 種別型パラメタ
    32    ! Kind type parameter
    33    !
    34    use dc_types, only: DP     ! 倍精度実数型. Double precision.
    35  
    36    ! メッセージ出力
    37    ! Message output
    38    !
    39    use dc_message, only: MessageNotify
    40  
    41    ! 宣言文 ; Declaration statements
    42    !
    43    implicit none
    44    private
    45  
    46    ! 公開手続き
    47    ! Public procedure
    48    !
    49    public:: SigmaDataGetHalf
    50  
    51    ! 公開変数
    52    ! Public variables
    53    !
    54    logical, save, public:: sigma_data_inited = .false.
    55                                ! 初期設定フラグ.
    56                                ! Initialization flag
    57  
    58    ! 非公開変数
    59    ! Private variables
    60    !
    61  
    62    character(*), parameter:: module_name = 'sigma_data'
    63                                ! モジュールの名称.
    64                                ! Module name
    65    character(*), parameter:: version = &
    66      & '$Name:  $' // &
    67      & '$Id: sigma_data.f90,v 1.2 2008/08/11 21:50:23 morikawa Exp $'
    68                                ! モジュールのバージョン
    69                                ! Module version
    70  
    71    ! INTERFACE 文 ; INTERFACE statements
    72    !
    73    interface SigmaDataGetHalf
    74      module procedure SigmaDataGetHalf
    75    end interface
    76  
    77  contains
    78  
    79    subroutine SigmaDataGetHalf( r_Sigma &  ! (out)
    80      & )
    81      !
    82      ! 鉛直σ半整数レベルのサンプルデータを提供します.
    83      ! 鉛直層の数は与えた配列 r_Sigma のデータサイズから
    84      ! 自動的に検出されます.
    85      !
    86      ! Prepare sample data of vertical sigma half level.
    87      ! Number of vertical level is detected automatically from
    88      ! size of a given array "r_Sigma".
    89      !
    90  
    91      ! モジュール引用 ; USE statements
    92      !
    93  
    94      ! 宣言文 ; Declaration statements
    95      !
    96      implicit none
    97      real(DP), intent(out):: r_Sigma (:)
    98                                ! $ \sigma $ レベル (半整数).
    99                                ! Half $ \sigma $ level
   100  
   101      ! 作業変数
   102      ! Work variables
   103      !
   104      integer:: kmax           ! 鉛直層数.
   105                               ! Number of vertical level
   106  
   107      ! 実行文 ; Executable statement
   108  
   109      if ( .not. sigma_data_inited ) call SigmaDataInit
   110  
   111      ! kmax の設定 (r_Sigma のサイズから設定)
   112      ! Setting "kmax" (set from size of "r_Sigma")
   113      !
   114      kmax = size(r_Sigma) - 1
   115      if ( kmax < 1 ) &
   116        call MessageNotify('E', module_name, 'size of "r_Sigma" is too small. ' )
   117  
   118      ! r_Sigma (半整数レベルσ) の自動設定
   119      ! Automation setting of "r_Sigma" (half level sigma)
   120      !
   121      select case (kmax)
   122      case (2)
   123        r_Sigma(1:kmax+1) = (/ &
     .        r_sigma(1) = %IG0(1)                                              
     .        r_sigma(2) = %IG0(2)                                              
     .        r_sigma(3) = %IG0(3)                                              
     .        goto 10010                                                        
   124          & 1.0_DP, 0.63_DP, 0.0_DP /)
   125      case (5)
   126        r_Sigma(1:kmax+1) = (/ &
   127          & 1.00_DP, 0.80_DP, 0.60_DP, 0.30_DP, 0.15_DP, &
   128          & 0.00_DP /)
   129      case (12)
   130        r_Sigma(1:kmax+1) = (/ &
   131          & 1.00_DP, 0.99_DP, 0.97_DP, 0.93_DP, 0.85_DP, &
   132          & 0.75_DP, 0.63_DP, 0.50_DP, 0.36_DP, 0.22_DP, &
   133          & 0.10_DP, 0.05_DP, 0.00_DP /)
   134      case (16)
   135        r_Sigma(1:kmax+1) = (/ &
   136          & 1.00_DP, 0.99_DP, 0.97_DP, 0.93_DP, 0.87_DP, &
   137          & 0.79_DP, 0.70_DP, 0.60_DP, 0.50_DP, 0.41_DP, &
   138          & 0.33_DP, 0.26_DP, 0.20_DP, 0.15_DP, 0.10_DP, &
   139          & 0.05_DP, 0.00_DP /)
   140      case (20)
   141        r_Sigma(1:kmax+1) = (/ &
   142          & 1.00_DP, 0.95_DP, 0.90_DP, 0.85_DP, 0.80_DP, &
   143          & 0.75_DP, 0.70_DP, 0.65_DP, 0.60_DP, 0.55_DP, &
   144          & 0.50_DP, 0.45_DP, 0.40_DP, 0.35_DP, 0.30_DP, &
   145          & 0.25_DP, 0.20_DP, 0.15_DP, 0.10_DP, 0.05_DP, &
   146          & 0.0_DP /)
   147      case (23)
   148        r_Sigma(1:kmax+1) = (/ &
   149          & 1.000_DP, 0.990_DP, 0.980_DP, 0.965_DP, 0.945_DP, &
   150          & 0.920_DP, 0.890_DP, 0.850_DP, 0.800_DP, 0.740_DP, &
   151          & 0.650_DP, 0.550_DP, 0.450_DP, 0.360_DP, 0.300_DP, &
   152          & 0.260_DP, 0.220_DP, 0.180_DP, 0.150_DP, 0.120_DP, &
   153          & 0.090_DP, 0.060_DP, 0.030_DP, 0.000_DP /)
   154      case (45)
   155        r_Sigma(1:kmax+1) = (/ &
   156          & 1.00000_DP, 0.99000_DP, 0.97000_DP, 0.93000_DP, 0.87000_DP, &
   157          & 0.79000_DP, 0.70000_DP, 0.60000_DP, 0.50000_DP, 0.41000_DP, &
   158          & 0.33000_DP, 0.26000_DP, 0.20000_DP, 0.15000_DP, 0.10000_DP, &
   159          & 0.08610_DP, 0.07410_DP, 0.06380_DP, 0.05490_DP, 0.04720_DP, &
   160          & 0.04070_DP, 0.03500_DP, 0.03010_DP, 0.02590_DP, 0.02230_DP, &
   161          & 0.01920_DP, 0.01650_DP, 0.01420_DP, 0.01220_DP, 0.01050_DP, &
   162          & 0.00907_DP, 0.00781_DP, 0.00672_DP, 0.00578_DP, 0.00498_DP, &
   163          & 0.00429_DP, 0.00369_DP, 0.00317_DP, 0.00273_DP, 0.00235_DP, &
   164          & 0.00202_DP, 0.00174_DP, 0.00150_DP, 0.00129_DP, 0.00111_DP, &
   165          & 0.00000_DP /)
   166      case default
   167        call MessageNotify( 'E', module_name, &
   168          & 'vertical sigma half level data auto-setting is valid ' // &
   169          & 'only when kmax=<%*d>. ( now kmax=<%d> )', &
   170          & i = (/2,5,12,16,20,23,45,kmax/), n = (/ 7 /) )
   171      end select
   172  
   173    end subroutine SigmaDataGetHalf
   174  
   175    !-------------------------------------------------------------------
   176  
   177    subroutine SigmaDataInit
   178  
   179      implicit none
   180  
   181  !!$  namelist /sigma_data_nml/
   182  
   183      ! 実行文 ; Executable statement
   184  
   185      if ( sigma_data_inited ) return
   186      call InitCheck
   187  
   188  !!$    ! NAMELIST の読み込み
   189  !!$    ! NAMELIST is input
   190  !!$    !
   191  !!$    if ( trim(namelist_filename) /= '' ) then
   192  !!$      call FileOpen( unit_nml, &          ! (out)
   193  !!$        & namelist_filename, mode = 'r' ) ! (in)
   194  !!$
   195  !!$      rewind( unit_nml )
   196  !!$      read( unit_nml, &           ! (in)
   197  !!$        & nml = sigma_data_nml, & ! (out)
   198  !!$        & iostat = iostat_nml )   ! (out)
   199  !!$      close( unit_nml )
   200  !!$
   201  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   202  !!$    end if
   203  
   204      ! 印字 ; Print
   205      !
   206  
   207      sigma_data_inited = .true.
   208    end subroutine SigmaDataInit
   209  
   210    !-------------------------------------------------------------------
   211  
   212    subroutine InitCheck
   213      !
   214      ! 依存モジュールの初期化チェック
   215      !
   216      ! Check initialization of dependency modules
   217  
   218      ! モジュール引用 ; USE statements
   219      !
   220  
   221      ! 実行文 ; Executable statement
   222  
   223    end subroutine InitCheck
   224  
   225  end module sigma_data
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: sigma_data.f90
PROGRAM NAME: sigma_data
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 鉛直σ半整数レベル提供
     2:             !
     3:             != Prepare vertical sigma half level
     4:             !
     5:             ! Authors::   Yasuhiro MORIKAWA
     6:             ! Version::   $Id: sigma_data.f90,v 1.2 2008/08/11 21:50:23 morikawa Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module sigma_data
    13:               !
    14:               != 鉛直σ半整数レベル提供
    15:               !
    16:               != Prepare vertical sigma half level
    17:               !
    18:               ! 鉛直σ半整数レベルのサンプルデータを提供します. 
    19:               ! 
    20:               ! Prepare sample data of vertical sigma half level. 
    21:               !
    22:               !== Procedures List
    23:               !
    24:               ! SigmaDataGetHalf   :: 鉛直σ半整数レベル取得. 
    25:               ! ------------  :: ------------
    26:               ! SigmaDataGetHalf   :: Get vertical sigma half level. 
    27:             
    28:               ! モジュール引用 ; USE statements
    29:               !
    30:             
    31:               ! 種別型パラメタ
    32:               ! Kind type parameter
    33:               !
    34:               use dc_types, only: DP     ! 倍精度実数型. Double precision. 
    35:             
    36:               ! メッセージ出力
    37:               ! Message output
    38:               !
    39:               use dc_message, only: MessageNotify
    40:             
    41:               ! 宣言文 ; Declaration statements
    42:               !
    43:               implicit none
    44:               private
    45:             
    46:               ! 公開手続き
    47:               ! Public procedure
    48:               !
    49:               public:: SigmaDataGetHalf
    50:             
    51:               ! 公開変数
    52:               ! Public variables
    53:               !
    54:               logical, save, public:: sigma_data_inited = .false.
    55:                                           ! 初期設定フラグ. 
    56:                                           ! Initialization flag
    57:             
    58:               ! 非公開変数
    59:               ! Private variables
    60:               !
    61:             
    62:               character(*), parameter:: module_name = 'sigma_data'
    63:                                           ! モジュールの名称. 
    64:                                           ! Module name
    65:               character(*), parameter:: version = &
    66:                 & '$Name:  $' // &
    67:                 & '$Id: sigma_data.f90,v 1.2 2008/08/11 21:50:23 morikawa Exp $'
    68:                                           ! モジュールのバージョン
    69:                                           ! Module version
    70:             
    71:               ! INTERFACE 文 ; INTERFACE statements
    72:               !
    73:               interface SigmaDataGetHalf
    74:                 module procedure SigmaDataGetHalf
    75:               end interface
    76:             
    77:             contains
    78:             
    79:               subroutine SigmaDataGetHalf( r_Sigma &  ! (out)
    80:                 & )
    81:                 !
    82:                 ! 鉛直σ半整数レベルのサンプルデータを提供します. 
    83:                 ! 鉛直層の数は与えた配列 r_Sigma のデータサイズから
    84:                 ! 自動的に検出されます. 
    85:                 ! 
    86:                 ! Prepare sample data of vertical sigma half level. 
    87:                 ! Number of vertical level is detected automatically from
    88:                 ! size of a given array "r_Sigma". 
    89:                 !
    90:             
    91:                 ! モジュール引用 ; USE statements
    92:                 !
    93:             
    94:                 ! 宣言文 ; Declaration statements
    95:                 !
    96:                 implicit none
    97:                 real(DP), intent(out):: r_Sigma (:)
    98:                                           ! $ \sigma $ レベル (半整数). 
    99:                                           ! Half $ \sigma $ level
   100:             
   101:                 ! 作業変数
   102:                 ! Work variables
   103:                 !
   104:                 integer:: kmax           ! 鉛直層数. 
   105:                                          ! Number of vertical level
   106:             
   107:                 ! 実行文 ; Executable statement
   108:             
   109:                 if ( .not. sigma_data_inited ) call SigmaDataInit
   110:             
   111:                 ! kmax の設定 (r_Sigma のサイズから設定)
   112:                 ! Setting "kmax" (set from size of "r_Sigma")
   113:                 !
   114:                 kmax = size(r_Sigma) - 1
   115:                 if ( kmax < 1 ) &
   116:                   call MessageNotify('E', module_name, 'size of "r_Sigma" is too small. ' )
   117:             
   118:                 ! r_Sigma (半整数レベルσ) の自動設定
   119:                 ! Automation setting of "r_Sigma" (half level sigma)
   120:                 !
   121:                 select case (kmax)
   122:                 case (2)
   123: *======           r_Sigma(1:kmax+1) = (/ &
   124:                     & 1.0_DP, 0.63_DP, 0.0_DP /)
   125:                 case (5)
   126: V====== A         r_Sigma(1:kmax+1) = (/ &
   127:                     & 1.00_DP, 0.80_DP, 0.60_DP, 0.30_DP, 0.15_DP, &
   128:                     & 0.00_DP /)
   129:                 case (12)
   130: V====== A         r_Sigma(1:kmax+1) = (/ &
   131:                     & 1.00_DP, 0.99_DP, 0.97_DP, 0.93_DP, 0.85_DP, &
   132:                     & 0.75_DP, 0.63_DP, 0.50_DP, 0.36_DP, 0.22_DP, &
   133:                     & 0.10_DP, 0.05_DP, 0.00_DP /)
   134:                 case (16)
   135: V====== A         r_Sigma(1:kmax+1) = (/ &
   136:                     & 1.00_DP, 0.99_DP, 0.97_DP, 0.93_DP, 0.87_DP, &
   137:                     & 0.79_DP, 0.70_DP, 0.60_DP, 0.50_DP, 0.41_DP, &
   138:                     & 0.33_DP, 0.26_DP, 0.20_DP, 0.15_DP, 0.10_DP, &
   139:                     & 0.05_DP, 0.00_DP /)
   140:                 case (20)
   141: V====== A         r_Sigma(1:kmax+1) = (/ &
   142:                     & 1.00_DP, 0.95_DP, 0.90_DP, 0.85_DP, 0.80_DP, &
   143:                     & 0.75_DP, 0.70_DP, 0.65_DP, 0.60_DP, 0.55_DP, &
   144:                     & 0.50_DP, 0.45_DP, 0.40_DP, 0.35_DP, 0.30_DP, &
   145:                     & 0.25_DP, 0.20_DP, 0.15_DP, 0.10_DP, 0.05_DP, &
   146:                     & 0.0_DP /)
   147:                 case (23)
   148: V====== A         r_Sigma(1:kmax+1) = (/ &
   149:                     & 1.000_DP, 0.990_DP, 0.980_DP, 0.965_DP, 0.945_DP, &
   150:                     & 0.920_DP, 0.890_DP, 0.850_DP, 0.800_DP, 0.740_DP, &
   151:                     & 0.650_DP, 0.550_DP, 0.450_DP, 0.360_DP, 0.300_DP, &
   152:                     & 0.260_DP, 0.220_DP, 0.180_DP, 0.150_DP, 0.120_DP, &
   153:                     & 0.090_DP, 0.060_DP, 0.030_DP, 0.000_DP /)
   154:                 case (45)
   155: V====== A         r_Sigma(1:kmax+1) = (/ &
   156:                     & 1.00000_DP, 0.99000_DP, 0.97000_DP, 0.93000_DP, 0.87000_DP, &
   157:                     & 0.79000_DP, 0.70000_DP, 0.60000_DP, 0.50000_DP, 0.41000_DP, &
   158:                     & 0.33000_DP, 0.26000_DP, 0.20000_DP, 0.15000_DP, 0.10000_DP, &
   159:                     & 0.08610_DP, 0.07410_DP, 0.06380_DP, 0.05490_DP, 0.04720_DP, &
   160:                     & 0.04070_DP, 0.03500_DP, 0.03010_DP, 0.02590_DP, 0.02230_DP, &
   161:                     & 0.01920_DP, 0.01650_DP, 0.01420_DP, 0.01220_DP, 0.01050_DP, &
   162:                     & 0.00907_DP, 0.00781_DP, 0.00672_DP, 0.00578_DP, 0.00498_DP, &
   163:                     & 0.00429_DP, 0.00369_DP, 0.00317_DP, 0.00273_DP, 0.00235_DP, &
   164:                     & 0.00202_DP, 0.00174_DP, 0.00150_DP, 0.00129_DP, 0.00111_DP, &
   165:                     & 0.00000_DP /)
   166:                 case default
   167:                   call MessageNotify( 'E', module_name, &
   168:                     & 'vertical sigma half level data auto-setting is valid ' // &
   169:                     & 'only when kmax=<%*d>. ( now kmax=<%d> )', &
   170:                     & i = (/2,5,12,16,20,23,45,kmax/), n = (/ 7 /) )
   171:                 end select
   172:             
   173:               end subroutine SigmaDataGetHalf
   174:             
   175:               !-------------------------------------------------------------------
   176:             
   177:               subroutine SigmaDataInit
   178:             
   179:                 implicit none
   180:             
   181:             !!$  namelist /sigma_data_nml/ 
   182:             
   183:                 ! 実行文 ; Executable statement
   184:             
   185:                 if ( sigma_data_inited ) return
   186:                 call InitCheck
   187:             
   188:             !!$    ! NAMELIST の読み込み
   189:             !!$    ! NAMELIST is input
   190:             !!$    !
   191:             !!$    if ( trim(namelist_filename) /= '' ) then
   192:             !!$      call FileOpen( unit_nml, &          ! (out)
   193:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   194:             !!$
   195:             !!$      rewind( unit_nml )
   196:             !!$      read( unit_nml, &           ! (in)
   197:             !!$        & nml = sigma_data_nml, & ! (out)
   198:             !!$        & iostat = iostat_nml )   ! (out)
   199:             !!$      close( unit_nml )
   200:             !!$
   201:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   202:             !!$    end if
   203:             
   204:                 ! 印字 ; Print
   205:                 !
   206:             
   207:                 sigma_data_inited = .true.
   208:               end subroutine SigmaDataInit
   209:             
   210:               !-------------------------------------------------------------------
   211:             
   212:               subroutine InitCheck
   213:                 !
   214:                 ! 依存モジュールの初期化チェック
   215:                 !
   216:                 ! Check initialization of dependency modules
   217:             
   218:                 ! モジュール引用 ; USE statements
   219:                 !
   220:             
   221:                 ! 実行文 ; Executable statement
   222:             
   223:               end subroutine InitCheck
   224:             
   225:             end module sigma_data
