Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: timeset.f90
PROGRAM NAME: timeset
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   378  vec  (   4): Vectorized array expression.
   378  vec  (  29): ADB is used for array.: day_in_month
   513  warn (   7): Characters in a line over this form limitation.
   688  vec  (   4): Vectorized array expression.
   688  vec  (  29): ADB is used for array.: sec_ary
   688  vec  (   4): Vectorized array expression.
   688  vec  (  29): ADB is used for array.: sec_ary
   688  vec  (   4): Vectorized array expression.
   688  vec  (  29): ADB is used for array.: sec_ary
   791  vec  (   3): Unvectorized loop.
   792  opt  (1017): Subroutine call prevents optimization.
   792  vec  (  10): Vectorization obstructive procedure reference.:dcclocksubtract
  1106  vec  (   3): Unvectorized loop.
  1107  opt  (1017): Subroutine call prevents optimization.
  1107  vec  (   9): Vectorization obstructive statement.
  1155  vec  (   3): Unvectorized loop.
  1156  opt  (1017): Subroutine call prevents optimization.
  1156  vec  (   9): Vectorization obstructive statement.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: timeset.f90
PROGRAM NAME: timeset
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 時刻管理
     2  !
     3  != Time control
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6  ! Version::   $Id: timeset.f90,v 1.24 2012/01/20 00:17:14 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module timeset
    13    !
    14    != 時刻管理
    15    !
    16    != Time control
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 時刻情報の管理を行います.
    21    !
    22    ! Information of time is controlled.
    23    !
    24    !== Variables List
    25    !
    26    ! TimeB                  :: ステップ $ t - \Delta t $ の時刻
    27    ! TimeN                  :: ステップ $ t $ の時刻
    28    ! TimeA                  :: ステップ $ t + \Delta t $ の時刻
    29    ! DelTime                :: $ \Delta t $ [s] (実数型の数値)
    30    ! RestartTime            :: リスタート開始時刻
    31    ! EndTime                :: 計算終了時刻
    32    ! InitialDate            :: 計算開始日時
    33    ! ------------           :: ------------
    34    ! TimeB                  :: Time of step $ t - \Delta t $
    35    ! TimeN                  :: Time of step $ t $
    36    ! TimeA                  :: Time of step $ t + \Delta t $
    37    ! DelTime                :: $ \Delta t $ [s] (numerical value of float type)
    38    ! RestartTime            :: Restart time of calculation
    39    ! EndTime                :: End time of calculation
    40    ! InitialDate            :: Start date of calculation
    41    !
    42    !== Procedures List
    43    !
    44    ! TimesetInit           :: timeset モジュールの初期化
    45    ! TimesetDelTimeHalf    :: Δt を一時的に半分に
    46    ! TimesetProgress       :: 時刻の進行
    47    ! TimesetSetTimeN       :: TimeN の設定
    48    ! TimesetSetInitialDate :: 計算開始日時の設定
    49    ! TimesetClockStart     :: 計算時間計測開始
    50    ! TimesetClockStop      :: 計算時間計一時停止
    51    ! TimesetClose          :: timeset モジュールの終了処理
    52    ! ------------          :: ------------
    53    ! TimesetInit           :: Initialize "timeset" module
    54    ! TimesetDelTimeHalf    :: Reduce delta t to half temporarily
    55    ! TimesetProgress       :: Progress time
    56    ! TimesetSetTimeN       :: Set TimeN
    57    ! TimesetSetInitialDate :: Set start date
    58    ! TimesetClockStart     :: Start measurement of computation time
    59    ! TimesetClockStop      :: Pause measurement of computation time
    60    ! TimesetClose          :: Terminate "timeset" module
    61    !
    62    !== NAMELIST
    63    !
    64    ! NAMELIST#timeset_nml
    65    !
    66  
    67    ! モジュール引用 ; USE statements
    68    !
    69  
    70    ! 種別型パラメタ
    71    ! Kind type parameter
    72    !
    73    use dc_types, only: DP, &  ! 倍精度実数型. Double precision.
    74      &                 TOKEN  ! キーワード.   Keywords.
    75  
    76    ! メッセージ出力
    77    ! Message output
    78    !
    79    use dc_message, only: MessageNotify
    80  
    81    ! CPU 時間計測
    82    ! CPU time monitor
    83    !
    84    use dc_clock, only: CLOCK
    85  
    86    ! 暦と日時の取り扱い
    87    ! Calendar and Date handler
    88    !
    89    use dc_calendar, only: &
    90      & DC_CAL, &               ! 暦を表現するデータ型.
    91                                ! Data type for calendar
    92      & DC_CAL_DATE             ! 日時を表現するデータ型.
    93                                ! Data type for date and time
    94  
    95    ! NAMELIST ファイル入力に関するユーティリティ
    96    ! Utilities for NAMELIST file input
    97    !
    98    use namelist_util, only: MaxNmlArySize
    99                                ! NAMELIST から読み込む配列の最大サイズ.
   100                                ! Maximum size of arrays loaded from NAMELIST
   101  
   102    ! 宣言文 ; Declaration statements
   103    !
   104    implicit none
   105    private
   106  
   107    ! 公開手続き
   108    ! Public procedure
   109    !
   110    public:: TimesetInit, TimesetClose, TimesetProgress, TimesetDelTimeHalf
   111    public:: TimesetClockStart, TimesetClockStop
   112    public:: TimesetSetTimeN, TimesetSetInitialDate, TimesetSetCalendar
   113  
   114    ! 公開変数
   115    ! Public variables
   116    !
   117    logical, save, public:: timeset_inited = .false.
   118                                ! 初期設定フラグ.
   119                                ! Initialization flag
   120    real(DP), save, public:: TimeB
   121                                ! ステップ $ t - \Delta t $ の時刻.
   122                                ! Time of step $ t - \Delta t $.
   123    real(DP), save, public:: TimeN
   124                                ! ステップ $ t $ の時刻.
   125                                ! Time of step $ t $.
   126    real(DP), save, public:: TimeA
   127                                ! ステップ $ t + \Delta t $ の時刻.
   128                                ! Time of step $ t + \Delta t $.
   129    real(DP), save, public:: DelTime
   130                                ! $ \Delta t $ [s]
   131    real(DP), save:: IntegPeriod
   132                                ! 積分時間. 単位は秒.
   133                                ! Unit is second.
   134    real(DP), save, public:: RestartTime
   135                                ! リスタート開始時刻.
   136                                ! Restart time of calculation
   137                                !--
   138                                ! 備考:
   139                                !
   140                                ! 実質的な計算開始時刻は初期値データ使用時ならば
   141                                ! 0, リスタートデータ使用時であればリスタート
   142                                ! データに格納されたものが使用される.
   143                                ! （DelTime の値によって時刻が必ずしも切りの）
   144                                ! 良い数字にならないことを想定している）。
   145                                !
   146                                ! この値はモデルを動かすユーザが計算開始を
   147                                ! 期待している時刻であり、この値を元に
   148                                ! 計算終了時刻が設定され, またこの値がリスタート
   149                                ! ファイルの出力開始時刻としても用いられる.
   150                                !++
   151    real(DP), save, public:: EndTime
   152                                ! 計算終了時刻.
   153                                ! End time of calculation
   154  
   155    type(DC_CAL_DATE), save, public:: InitialDate
   156                                ! 計算開始日時.
   157                                ! Start date of calculation
   158    type(DC_CAL_DATE), save, public:: EndDate
   159                                ! 計算終了の日時
   160  
   161    ! 非公開変数
   162    ! Private variables
   163    !
   164    character(TOKEN), save:: cal_type
   165                                ! 暦情報.
   166                                ! Type of calendar used for an experiment
   167  
   168    integer         , save:: month_in_year
   169                                ! Number of months in a year which is used
   170                                ! when cal_type = "user_defined"
   171    integer         , save:: day_in_month(1:MaxNmlArySize)
   172                                ! Number of days in a month which is used
   173                                ! when cal_type = "user_defined"
   174    integer         , save:: hour_in_day
   175                                ! Number of hours in a day which is used
   176                                ! when cal_type = "user_defined"
   177    integer         , save:: min_in_hour
   178                                ! Number of minutes in a hour which is used
   179                                ! when cal_type = "user_defined"
   180    real(DP)        , save:: sec_in_min
   181                                ! Number of seconds in a minute which is used
   182                                ! when cal_type = "user_defined"
   183  
   184    real(DP)        , save:: RestartTimeValue
   185                                ! リスタート開始時刻.
   186                                ! Restart time of calculation
   187    character(TOKEN), save:: RestartTimeUnit
   188                                ! リスタート開始時刻の単位.
   189                                ! Unit of restart time of calculation
   190    real(DP)        , save:: DelTimeValue
   191                                ! $ \Delta t $ .  単位は DelTimeUnit にて指定.
   192                                ! Unit is specified by "DelTimeUnit".
   193    character(TOKEN), save:: DelTimeUnit
   194                                ! $ \Delta t $ の単位.
   195                                ! Unit of $ \Delta t $
   196  
   197    logical         , save:: flag_half
   198                                ! TimesetDelTimeHalf によって $ \Delta t $ が
   199                                ! 半分になっていることを示すフラグ.
   200                                !
   201                                ! Flag that shows $ \Delta t $ is reduced to
   202                                ! half by "TimesetDelTimeHalf"
   203    real(DP)        , save:: DelTimeSave
   204                                ! $ \Delta t $ [s] のデフォルト値.
   205                                ! ("TimesetDelTimeHalf" で使用される)
   206                                !
   207                                ! Default value of $ \Delta t $ [s].
   208                                ! (for "TimesetDelTimeHalf")
   209  
   210    real(DP)        , save:: PredictIntTime
   211                                ! 終了予測日時表示時間間隔.
   212                                ! Interval time of predicted end time output
   213    real(DP)        , save:: PredictPrevTime
   214                                ! 前回の終了予測日時表示時間.
   215                                ! Time when predicted end time is output previously
   216    real(DP)        , save:: PredictIntValue
   217                                ! 終了予測日時表示間隔.
   218                                ! Interval of predicted end time output
   219    character(TOKEN), save:: PredictIntUnit
   220                                ! 終了予測日時表示間隔 (単位).
   221                                ! Unit for interval of predicted end time output
   222  
   223    logical         , save:: CpuTimeMoniter
   224                                ! CPU 時間計測のオンオフ
   225                                ! On/off of CPU time monitoring
   226  
   227    integer         , parameter:: clkmax = 64
   228                                ! CPU 時間計測を行うプロセスの最大数.
   229                                ! Maximum number of processes monitored CPU time
   230    integer         , save:: clk_proc_num = 0
   231                                ! CPU 時間計測を行っているプロセスの数.
   232                                ! Number of processes monitored CPU time
   233    type(CLOCK)     , save:: clocks(1:clkmax)
   234                                ! CPU 時間計測用構造体
   235                                ! Derived type for monitoring CPU time
   236    character(TOKEN), save:: clocks_name(1:clkmax) = ''
   237                                ! CPU 時間計測を行っているプロセスの名称
   238                                ! Names of processes monitored CPU time
   239  
   240  
   241    character(*), parameter:: module_name = 'timeset'
   242                                ! モジュールの名称.
   243                                ! Module name
   244    character(*), parameter:: version = &
   245      & '$Name:  $' // &
   246      & '$Id: timeset.f90,v 1.24 2012/01/20 00:17:14 yot Exp $'
   247                                ! モジュールのバージョン
   248                                ! Module version
   249  
   250  
   251  contains
   252  
   253    !-------------------------------------------------------------------
   254  
   255    subroutine TimesetInit
   256      !
   257      ! timeset モジュールの初期化を行います.
   258      ! NAMELIST#timeset_nml の読み込みはこの手続きで行われます.
   259      !
   260      ! "timeset" module is initialized.
   261      ! NAMELIST#timeset_nml is loaded in this procedure.
   262      !
   263  
   264      ! モジュール引用 ; USE statements
   265      !
   266  
   267      ! NAMELIST ファイル入力に関するユーティリティ
   268      ! Utilities for NAMELIST file input
   269      !
   270      use namelist_util, only: namelist_filename, NmlutilMsg
   271  
   272      ! ファイル入出力補助
   273      ! File I/O support
   274      !
   275      use dc_iounit, only: FileOpen
   276  
   277      ! 種別型パラメタ
   278      ! Kind type parameter
   279      !
   280      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   281  
   282      ! 暦と日時の取り扱い
   283      ! Calendar and Date handler
   284      !
   285      use dc_calendar, only: DCCalCreate, DCCalConvertByUnit, DCCalToChar, DCCalInquire, &
   286        & DCCalDateCreate, DCCalDateDifference, DCCalDateToChar, DCCalDateInquire, &
   287        & DCCalDefault
   288  
   289      ! CPU 時間計測
   290      ! CPU time monitor
   291      !
   292      use dc_clock, only: DCClockCreate, DCClockStart
   293  
   294      ! 文字列操作
   295      ! Character handling
   296      !
   297      use dc_string, only: toChar
   298  
   299  
   300      ! 宣言文 ; Declaration statements
   301      !
   302  
   303      integer:: InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin
   304                                ! 計算開始日時 (年月日時分)
   305                                ! Start date of calculation (year, month, day, hour, minute)
   306      real(DP):: InitialSec
   307                                ! 計算開始日時 (秒)
   308                                ! Start date of calculation (second)
   309      real(DP):: IntegPeriodValue
   310                                ! 積分時間.
   311                                ! Integral time.
   312      character(TOKEN):: IntegPeriodUnit
   313                                ! "IntegPeriodValue" の単位.
   314                                ! Unit of "IntegPeriodValue".
   315      integer:: EndYear, EndMonth, EndDay, EndHour, EndMin
   316                                ! 計算終了日時 (年月日時分).
   317                                ! "IntegPeriodValue" が負の場合にこちらが使用される.
   318                                !
   319                                ! End date of calculation (year, month, day, hour, minute)
   320                                ! These are used when "IntegPeriodValue" is negative
   321      real(DP):: EndSec
   322                                ! 計算終了日時 (秒).
   323                                ! "IntegPeriodValue" が負の場合にこちらが使用される.
   324                                !
   325                                ! End date of calculation (second)
   326                                ! These are used when "IntegPeriodValue" is negative
   327  
   328      ! 印字用作業変数
   329      ! Work variables for print
   330      !
   331      type(DC_CAL):: cal_print
   332      real(DP):: EndTimeValue_print
   333      character(TOKEN):: date_print
   334  
   335      ! 作業変数
   336      ! Work variables
   337      !
   338      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   339                                ! Unit number for NAMELIST file open
   340      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   341                                ! IOSTAT of NAMELIST read
   342  
   343      ! NAMELIST 変数群
   344      ! NAMELIST group name
   345      !
   346      namelist /timeset_nml/ &
   347        & cal_type, &
   348        & month_in_year, day_in_month, hour_in_day, min_in_hour, sec_in_min, &
   349        !
   350        & DelTimeValue,    DelTimeUnit, &
   351        & RestartTimeValue,  RestartTimeUnit, &
   352        & InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin, InitialSec, &
   353        & EndYear, EndMonth, EndDay, EndHour, EndMin, EndSec, &
   354        & IntegPeriodValue, IntegPeriodUnit, &
   355        !
   356        & PredictIntValue,  PredictIntUnit, &
   357        & CpuTimeMoniter
   358            !
   359            ! デフォルト値については初期化手続 "timeset#TimesetInit"
   360            ! のソースコードを参照のこと.
   361            !
   362            ! Refer to source codes in the initialization procedure
   363            ! "timeset#TimesetInit" for the default values.
   364            !
   365  
   366      ! 実行文 ; Executable statement
   367      !
   368  
   369      if ( timeset_inited ) return
   370      call InitCheck
   371  
   372  
   373      ! デフォルト値の設定
   374      ! Default values settings
   375      !
   376      cal_type                      = 'noleap'
   377      month_in_year                 =   -1
   378      day_in_month(1:MaxNmlArySize) =   -1
   379      hour_in_day                   =   -1
   380      min_in_hour                   =   -1
   381      sec_in_min                    =   -1.0_DP
   382  
   383      ! Sample value for the Earth
   384      !
   385  !!$    cal_type                      = 'gregorian'
   386  !!$    month_in_year                 =   -1
   387  !!$    day_in_month(1:MaxNmlArySize) =   -1
   388  !!$    hour_in_day                   =   -1
   389  !!$    min_in_hour                   =   -1
   390  !!$    sec_in_min                    =   -1.0_DP
   391  
   392      ! Sample value for the Mars
   393      !   Number of days in a year and Mars solar day in second are obtained from
   394      !   Allison (1997).
   395      !   Allison, M, Geophys. Res. Lett., 24, 1967-1970, 1997.
   396      !
   397  !!$    cal_type                      = 'user_defined'
   398  !!$    month_in_year                 =    1
   399  !!$    day_in_month(1:MaxNmlArySize) =  669
   400  !!$    hour_in_day                   =   24
   401  !!$    min_in_hour                   =    1
   402  !!$    sec_in_min                    = 3700.0_DP    ! 3699.0_DP
   403  
   404  
   405      DelTimeValue                  =   30.0_DP
   406      DelTimeUnit                   = 'min'
   407      flag_half                     = .false.
   408  
   409      RestartTimeValue              =    0.0_DP
   410      RestartTimeUnit               = 'sec'
   411  
   412      InitialYear                   = 2000
   413      InitialMonth                  =    1
   414      InitialDay                    =    1
   415      InitialHour                   =    0
   416      InitialMin                    =    0
   417      InitialSec                    =    0.0
   418  
   419      IntegPeriodValue              =   -1.0
   420                                     ! If IntegPeriodValue is negative, EndXXX are used.
   421      IntegPeriodUnit               = 'sec'
   422  
   423      EndYear                       = 2000
   424      EndMonth                      =    1
   425      EndDay                        =    2
   426      EndHour                       =    0
   427      EndMin                        =    0
   428      EndSec                        =    0.0
   429  
   430      PredictIntValue               =    1.0_DP
   431      PredictIntUnit                = 'day'
   432  
   433      CpuTimeMoniter                 = .true.
   434  
   435  
   436      ! NAMELIST の読み込み
   437      ! NAMELIST is input
   438      !
   439      if ( trim(namelist_filename) /= '' ) then
   440        call FileOpen( unit_nml, &          ! (out)
   441          & namelist_filename, mode = 'r' ) ! (in)
   442  
   443        rewind( unit_nml )
   444        read( unit_nml, &         ! (in)
   445          & nml = timeset_nml, &  ! (out)
   446          & iostat = iostat_nml ) ! (out)
   447        close( unit_nml )
   448  
   449        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   450        if ( iostat_nml == 0 ) write( STDOUT, nml = timeset_nml )
   451      end if
   452  
   453  
   454      ! 暦の情報を設定
   455      ! Set calendar
   456      !
   457      if ( cal_type == "user_defined" ) then
   458        call DCCalCreate(                                                &
   459          &               month_in_year = month_in_year                , & ! (in)
   460          &               day_in_month  = day_in_month(1:month_in_year), & ! (in)
   461          &               hour_in_day   = hour_in_day                  , & ! (in)
   462          &               min_in_hour   = min_in_hour                  , & ! (in)
   463          &               sec_in_min    = sec_in_min                     & ! (in)
   464          & )
   465      else
   466        call DCCalCreate( cal_type = cal_type ) ! (in)
   467      end if
   468  
   469  
   470      ! Lines below will be deleted. (yot, 2010/08/12)
   471      !
   472  
   473      ! 暦の情報を設定 (サンプルとしていくつかの case を記載)
   474      !
   475      ! case 1:
   476      ! dc_calendar で用意される典型的な暦をデフォルトの暦として設定
   477      !
   478  !!$    call DCCalCreate( cal_type = 'gregorian' ) ! (in)  ! グレゴリオ暦
   479  !!$    call DCCalCreate( cal_type = 'julian'    ) ! (in)  ! ユリウス暦
   480  !!$    call DCCalCreate( cal_type = 'noleap'    ) ! (in)  ! 閏年無しの暦
   481  !!$    call DCCalCreate( cal_type = '360day'    ) ! (in)  ! 1ヶ月が 30 日の暦
   482  !!$    call DCCalCreate( cal_type = 'cyclic'    ) ! (in)  ! ある月の日数を 「30.6 × 月数 − 前月までの総日数」の小数点以下切捨とする暦
   483  
   484  !!$    ! case 2:
   485  !!$    ! 決まり切った暦 (以下はユリウス暦) を設定
   486  !!$    !
   487  !!$    call DCCalCreate( cal_type = 'Julian' ) ! (in)
   488  !!$
   489  !!$    ! case 3:
   490  !!$    ! 地球っぽい暦を利用者が明示的に指定
   491  !!$    !
   492  !!$    call DCCalCreate( month_in_year = 12 , &   ! (in)
   493  !!$      &               day_in_month  = (/31, 28, 31, 30, 31, 30,   &
   494  !!$      &                                 31, 31, 30, 31, 30, 31/), & ! (in)
   495  !!$      &               hour_in_day = 24,     &  ! (in)
   496  !!$      &               min_in_hour = 60 ,    &  ! (in)
   497  !!$      &               sec_in_min  = 60.0d0 )   ! (in)
   498  !!$
   499  !!$    ! case 3:
   500  !!$    ! 火星っぽい暦を利用者が明示的に指定.
   501  !!$    ! ※ 「暦に月がない」場合には, month_in_year = 1 とする.
   502  !!$    !
   503  !!$    call DCCalCreate( month_in_year = 1 , &      ! (in)
   504  !!$      &               day_in_month  = (/669/), & ! (in)
   505  !!$      &               hour_in_day = 24, &        ! (in)
   506  !!$      &               min_in_hour = 1 , &        ! (in)
   507  !!$      &               sec_in_min  = 3694.0d0  )  ! (in)
   508  
   509  
   510      ! 時間変数 (秒) の設定
   511      ! Calculate time variable (sec)
   512      !
   513      DelTime        = DCCalConvertByUnit( DelTimeValue,     DelTimeUnit,     'sec' ) !(in)
   514      RestartTime    = DCCalConvertByUnit( RestartTimeValue, RestartTimeUnit, 'sec' ) !(in)
   515  
   516  
   517      ! 開始日時の情報を設定
   518      !
   519      ! 再計算時には restart_file_io モジュールによる TimesetSetInitialDate
   520      ! 呼び出しによって上書きされることを想定.
   521      !
   522      if ( ( .not. ( InitialMonth < 0      ) ) .and. &
   523        &  ( .not. ( InitialDay   < 0      ) ) .and. &
   524        &  ( .not. ( InitialHour  < 0      ) ) .and. &
   525        &  ( .not. ( InitialMin   < 0      ) ) .and. &
   526        &  ( .not. ( InitialSec   < 0.0_DP ) ) ) then
   527  
   528        call DCCalDateCreate( &
   529          & year  = InitialYear,   & ! (in)
   530          & month = InitialMonth,  & ! (in)
   531          & day   = InitialDay,    & ! (in)
   532          & hour  = InitialHour,   & ! (in)
   533          & min   = InitialMin,    & ! (in)
   534          & sec   = InitialSec,    & ! (in)
   535          & date  = InitialDate )  ! (out) optional
   536      else
   537        call MessageNotify('W', module_name, 'InitialMonth/Day/Hour/Min/Sec is negative.' )
   538      end if
   539  
   540  
   541      ! 終了日時 (開始日時からの経過時間で表現) を設定
   542      !
   543      if ( IntegPeriodValue < 0.0 ) then
   544  
   545        IntegPeriod = IntegPeriodValue
   546  
   547        ! case 1
   548        ! 終了日時を使う場合
   549        !
   550        call DCCalDateCreate( &
   551          & year  = EndYear,   & ! (in)
   552          & month = EndMonth,  & ! (in)
   553          & day   = EndDay,    & ! (in)
   554          & hour  = EndHour,   & ! (in)
   555          & min   = EndMin,    & ! (in)
   556          & sec   = EndSec,    & ! (in)
   557          & date  = EndDate )    ! (out) optional
   558  
   559        EndTime = DCCalDateDifference( &
   560          &         start_date = InitialDate, &  ! (in)
   561          &         end_date   = EndDate )       ! (in)
   562  
   563        if ( .not. EndTime > 0.0 ) then
   564          call DCCalDateInquire( date_print, date = InitialDate )
   565          call MessageNotify('W', module_name, 'InitialDate=<%c>', c1 = trim(date_print) )
   566          call DCCalDateInquire( date_print, date = EndDate )
   567          call MessageNotify('W', module_name, 'EndDate=<%c>', c1 = trim(date_print) )
   568          call MessageNotify('E', module_name, '"EndTime" must be positive.')
   569        end if
   570  
   571      else
   572        ! case 2
   573        ! 積分時間を使う場合
   574        !
   575        IntegPeriod = DCCalConvertByUnit( IntegPeriodValue, IntegPeriodUnit, 'sec' ) !(in)
   576  
   577        EndTime = RestartTime + IntegPeriod
   578      end if
   579  
   580  
   581      ! 終了予測日時表示時間の初期設定
   582      ! Initialize Time when predicted end time is output
   583      !
   584      PredictIntTime  = DCCalConvertByUnit( PredictIntValue, PredictIntUnit, 'sec' ) !(in)
   585      PredictPrevTime = RestartTime - DelTime
   586  
   587  
   588      ! 時刻の正当性のチェック
   589      ! Check validation of time
   590      !
   591      call TimeValidCheck( RestartTime, EndTime, DelTime, PredictIntTime ) ! (in)
   592  
   593  
   594      ! 各タイムステップの時刻の設定
   595      ! Configure time on each time step
   596      !
   597      ! 再計算時には restart_file_io モジュールによる TimesetSetTimeN
   598      ! 呼び出しによって上書きされることを想定.
   599      !
   600      TimeN = RestartTime
   601      TimeB = TimeN - DelTime
   602      TimeA = TimeN + DelTime
   603  
   604  
   605      ! $ \Delta t $ [s] を保存
   606      ! Save $ \Delta t $ [s]
   607      !
   608      DelTimeSave = DelTime
   609  
   610  
   611      ! CPU 時間計測開始 (モデル全体)
   612      ! Start CPU time monitoring (for entire model)
   613      !
   614      if ( CpuTimeMoniter ) then
   615        call DCClockCreate( clocks(clk_proc_num + 1), 'total' ) ! (in)
   616        call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
   617        clocks_name(clk_proc_num + 1) = 'total'
   618        clk_proc_num = clk_proc_num + 1
   619      end if
   620  
   621      ! 印字 ; Print
   622      !
   623      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   624      call MessageNotify( 'M', module_name, '  RestartTime  = %f [%c]', &
   625        & d = (/ RestartTimeValue /), c1 = trim(RestartTimeUnit) )
   626      call DCCalDateInquire( date_print, date = InitialDate )
   627      call MessageNotify( 'M', module_name, '  InitialDate  = %c', &
   628        & c1 = trim(date_print) )
   629      if ( IntegPeriodValue < 0.0 ) then
   630        call DCCalDateInquire( date_print, date = EndDate )
   631        call MessageNotify( 'M', module_name, '  EndDate      = %c', &
   632          & c1 = trim(date_print) )
   633      end if
   634      EndTimeValue_print = DCCalConvertByUnit( EndTime, 'sec', RestartTimeUnit ) ! (in)
   635      call MessageNotify( 'M', module_name, '  EndTime      = %f [%c]', &
   636        & d = (/ EndTimeValue_print /), c1 = trim(RestartTimeUnit) )
   637      call MessageNotify( 'M', module_name, '  DelTime      = %f [%c]', &
   638        & d = (/ DelTimeValue /), c1 = trim(DelTimeUnit) )
   639      call MessageNotify( 'M', module_name, '               = %f [%c]', &
   640        & d = (/ DelTime /), c1 = 'sec' )
   641      if ( cal_type /= 'user_defined' ) then
   642        call MessageNotify( 'M', module_name, '  Calendar     = %c', &
   643          & c1 = trim(cal_type) )
   644      else
   645        call DCCalDefault( cal_print ) ! (out)
   646        call MessageNotify( 'M', module_name, '  Calendar     = %c', &
   647          & c1 = trim(DCCalToChar(cal_print)) )
   648      end if
   649      call MessageNotify( 'M', module_name, '  PredictInt = %f [%c]', &
   650        & d = (/ PredictIntValue /), c1 = trim(PredictIntUnit) )
   651      call MessageNotify( 'M', module_name, '  CpuTimeMoniter = %b', &
   652        & l = (/ CpuTimeMoniter /) )
   653      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   654  
   655      timeset_inited = .true.
   656    end subroutine TimesetInit
   657  
   658    !-------------------------------------------------------------------
   659  
   660    subroutine TimesetDelTimeHalf
   661      !
   662      ! 計算の初回だけはオイラー法を用いるため,
   663      ! 一時的に Δt を半分にします.
   664      ! TimesetProgress が呼ばれた段階で Δt は元に戻ります.
   665      !
   666      ! Delta t is reduced to half temporarily
   667      ! in order to use Euler method at initial step.
   668      ! Delta t is returned to default, when "TimesetProgress" is called.
   669      !
   670  
   671      ! 宣言文 ; Declaration statements
   672      !
   673  
   674      ! 作業変数
   675      ! Work variables
   676      !
   677  
   678      ! 実行文 ; Executable statement
   679      !
   680      if ( flag_half ) return
   681      DelTime = DelTime / 2.0_DP
   682      flag_half = .true.
   683  
   684    end subroutine TimesetDelTimeHalf
   685  
   686    !-------------------------------------------------------------------
   687  
   688    subroutine TimesetProgress
   689      !
   690      ! timeset モジュール内の時刻を進めます.
   691      ! また, TimesetProgress#PredictIntStep で設定された値に応じて,
   692      ! 現在までの計算時間と計算終了予測時刻を表示します.
   693      !
   694      ! Progress time configured in "timeset" module.
   695      ! And, computation time until now and
   696      ! predicted end of computation time are printed
   697      ! according to configured "TimesetProgress#PredictIntStep"
   698      !
   699  
   700      ! モジュール引用 ; USE statements
   701      !
   702  
   703      ! CPU 時間計測
   704      ! CPU time monitor
   705      !
   706      use dc_clock, only: DCClockPredict, DCClockStop, DCClockClose, &
   707        & operator(+), operator(-)
   708  
   709      ! 宣言文 ; Declaration statements
   710      !
   711  
   712      ! 作業変数
   713      ! Work variables
   714      !
   715      type(CLOCK):: clock_tmp
   716  
   717      ! 実行文 ; Executable statement
   718      !
   719  
   720      ! Δt を元に戻す.
   721      ! Delta t is returned to default
   722      !
   723      if ( flag_half ) then
   724        DelTime = DelTimeSave
   725        flag_half = .false.
   726      end if
   727  
   728      ! 終了予測日時表示
   729      ! Print predicted end time
   730      !
   731      if ( .not. TimeA - PredictPrevTime < PredictIntTime ) then
   732        PredictPrevTime = PredictPrevTime + PredictIntTime
   733        if ( CpuTimeMoniter ) then
   734          clock_tmp = clocks(1)
   735          call DCClockStop( clock_tmp ) ! (in)
   736          call DCClockPredict( &
   737            & clock_tmp, &
   738            & real( ( TimeA - RestartTime ) / ( ( EndTime + DelTimeSave ) - RestartTime ) ) ) ! (in)
   739          call DCClockClose( clock_tmp ) ! (in)
   740        end if
   741      end if
   742  
   743      ! 時刻の進行
   744      ! Progress time
   745      !
   746      TimeB = TimeB + DelTime
   747      TimeN = TimeN + DelTime
   748      TimeA = TimeA + DelTime
   749    end subroutine TimesetProgress
   750  
   751    !-------------------------------------------------------------------
   752  
   753    subroutine TimesetClose
   754      !
   755      ! 計算時間の総計を表示します.
   756      !
   757      ! Total computation time is printed.
   758  
   759      ! モジュール引用 ; USE statements
   760      !
   761  
   762      ! CPU 時間計測
   763      ! CPU time monitor
   764      !
   765      use dc_clock, only: DCClockStop, DCClockResult, DCClockSetName, &
   766        & operator(+), operator(-)
   767  
   768      ! 宣言文 ; Declaration statements
   769      !
   770      integer:: i               ! clocks, clocks_name 用 DO ループ用作業変数
   771                                ! Work variables for DO loop for "clocks", "clocks_name"
   772  
   773      ! 作業変数
   774      ! Work variables
   775      !
   776  
   777      ! 実行文 ; Executable statement
   778      !
   779  
   780      if ( .not. CpuTimeMoniter ) return
   781  
   782      ! CPU 時間計測終了 (モデル全体)
   783      ! Stop CPU time monitoring (for entire model)
   784      !
   785      call DCClockStop( clocks(1) ) ! (in)
   786  
   787      ! 「その他」の CPU 時間を算出
   788      ! Calculate CPU time of "Others"
   789      !
   790      clocks(clk_proc_num + 1) = clocks(1)
   791      do i = 2, clk_proc_num
   792        clocks(clk_proc_num + 1) = clocks(clk_proc_num + 1) - clocks(i)
   793      end do
   794      call DCClockSetName( clocks(clk_proc_num + 1), 'others' )
   795  
   796      ! CPU 時間の総計を表示
   797      ! Print total CPU time
   798      !
   799      call DCClockResult( &
   800        & clocks(2:clk_proc_num + 1), total_auto = .true. ) ! (in)
   801  
   802    end subroutine TimesetClose
   803  
   804    !-------------------------------------------------------------------
   805  
   806    subroutine TimesetSetTimeN(TimeNSet)
   807      !
   808      ! TimeN の再設定を行います.
   809      ! 自動的に TimeB, TimeA, EndTime についても
   810      ! 再設定を行います.
   811      !
   812      ! TimesetInit が既に呼ばれることが前提です.
   813      ! TimesetInit が呼ばれる前にこのサブルーチンが呼ばれた場合,
   814      ! 何もせずにこのサブルーチンは終了します.
   815      !
   816      ! "TimeN" is reconfigured.
   817      ! "TimeB", "TimeA", "EndTime" are reconfigured automatically.
   818      !
   819      ! "TimesetInit" must be called before this subroutine is called.
   820      ! If "TimesetInit" is not called previously, this subroutine
   821      ! is finished with no changes.
   822      !
   823  
   824      ! モジュール引用 ; USE statements
   825      !
   826  
   827      ! 暦と日時の取り扱い
   828      ! Calendar and Date handler
   829      !
   830      use dc_calendar, only: DCCalConvertByUnit
   831  
   832      ! 文字列操作
   833      ! Character handling
   834      !
   835      use dc_string, only: toChar
   836  
   837      ! 宣言文 ; Declaration statements
   838      !
   839  
   840      real(DP), intent(in):: TimeNSet
   841                                ! ステップ $ t $ の時刻.
   842                                ! Time of step $ t $.
   843  
   844      ! 作業変数
   845      ! Work variables
   846      !
   847      real(DP):: EndTimeValue_print
   848  
   849      ! 実行文 ; Executable statement
   850      !
   851  
   852      if ( .not. timeset_inited ) return
   853  
   854      ! TimeN が負の場合、エラーを発生
   855      ! Cause an error, if TimeN is negative
   856      !
   857      if ( TimeN < 0.0 ) then
   858        call MessageNotify( 'E', module_name, &
   859          & 'TimeN=<%f [sec]> must be positive', &
   860          & d = (/ TimeNSet /) )
   861      end if
   862  
   863      ! 各タイムステップの時刻の設定
   864      ! Reconfigure time on each time step
   865      !
   866      TimeN = TimeNSet
   867      TimeB = TimeN - DelTime
   868      TimeA = TimeN + DelTime
   869  
   870      ! 前回の終了予測日時表示時間の再設定
   871      ! Reconfigure Time when predicted end time is output previously
   872      !
   873      PredictPrevTime = TimeN - DelTime
   874  
   875      ! 印字 ; Print
   876      !
   877      call MessageNotify( 'M', module_name, '----- Reconfigure Time Messages -----' )
   878      call MessageNotify( 'M', module_name, '  TimeB  = %f [sec]', &
   879        & d = (/ TimeB /) )
   880      call MessageNotify( 'M', module_name, '  TimeN  = %f [sec]', &
   881        & d = (/ TimeN /) )
   882      call MessageNotify( 'M', module_name, '  TimeA  = %f [sec]', &
   883        & d = (/ TimeA /) )
   884      if ( IntegPeriod > 0.0 ) then
   885        EndTimeValue_print = DCCalConvertByUnit( EndTime, 'sec', RestartTimeUnit ) ! (in)
   886        call MessageNotify( 'M', module_name, '  EndTime    = %f [%c]', &
   887          & d = (/ EndTimeValue_print /), c1 = trim(RestartTimeUnit) )
   888      end if
   889  
   890    end subroutine TimesetSetTimeN
   891  
   892    !-------------------------------------------------------------------
   893  
   894    subroutine TimesetSetInitialDate( &
   895      & InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin, InitialSec )
   896      !
   897      ! 開始日時の再設定を行います.
   898      !
   899      ! TimesetInit が既に呼ばれることが前提です.
   900      ! TimesetInit が呼ばれる前にこのサブルーチンが呼ばれた場合,
   901      ! 何もせずにこのサブルーチンは終了します.
   902      !
   903      ! Start date is reconfigured.
   904      !
   905      ! "TimesetInit" must be called before this subroutine is called.
   906      ! If "TimesetInit" is not called previously, this subroutine
   907      ! is finished with no changes.
   908      !
   909  
   910      ! モジュール引用 ; USE statements
   911      !
   912  
   913      ! 暦と日時の取り扱い
   914      ! Calendar and Date handler
   915      !
   916      use dc_calendar, only: DCCalCreate, DCCalConvertByUnit, DCCalToChar, DCCalInquire, &
   917        & DCCalDateCreate, DCCalDateDifference, DCCalDateToChar, DCCalDateInquire
   918  
   919      ! 文字列操作
   920      ! Character handling
   921      !
   922      use dc_string, only: toChar
   923  
   924      ! 宣言文 ; Declaration statements
   925      !
   926  
   927      integer, intent(in):: InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin
   928                                ! 計算開始の年月日時分
   929      real(DP), intent(in):: InitialSec
   930                                ! 計算開始の秒
   931  
   932      ! 作業変数
   933      ! Work variables
   934      !
   935      real(DP):: EndTimeValue_print
   936      character(TOKEN):: date_print
   937  
   938      ! 実行文 ; Executable statement
   939      !
   940  
   941      if ( .not. timeset_inited ) return
   942  
   943      ! "InitialDate" を再設定
   944      ! Reconfigure "InitialDate"
   945      !
   946      call DCCalDateCreate( &
   947        & year  = InitialYear,   & ! (in)
   948        & month = InitialMonth,  & ! (in)
   949        & day   = InitialDay,    & ! (in)
   950        & hour  = InitialHour,   & ! (in)
   951        & min   = InitialMin,    & ! (in)
   952        & sec   = InitialSec,    & ! (in)
   953        & date  = InitialDate )  ! (out) optional
   954  
   955      ! "EndTime" の再設定
   956      ! Reconfigure "EndTime"
   957      !
   958      if ( IntegPeriod < 0.0 ) then
   959        EndTime = DCCalDateDifference( &
   960          &         start_date = InitialDate, &  ! (in)
   961          &         end_date = EndDate )         ! (in)
   962  
   963        if ( .not. EndTime > 0.0 ) then
   964          call DCCalDateInquire( date_print, date = InitialDate )
   965          call MessageNotify('W', module_name, 'InitialDate=<%c>', c1 = trim(date_print) )
   966          call DCCalDateInquire( date_print, date = EndDate )
   967          call MessageNotify('W', module_name, 'EndDate=<%c>', c1 = trim(date_print) )
   968          call MessageNotify('E', module_name, '"EndTime" must be positive.')
   969        end if
   970  
   971      end if
   972  
   973      ! 印字 ; Print
   974      !
   975      call MessageNotify( 'M', module_name, '----- Reconfigure InitialDate Messages -----' )
   976      call DCCalDateInquire( date_print, date = InitialDate )
   977      call MessageNotify( 'M', module_name, '  InitialDate  = %c', &
   978        & c1 = trim(date_print) )
   979      if ( IntegPeriod < 0.0 ) then
   980        call DCCalDateInquire( date_print, date = EndDate )
   981        call MessageNotify( 'M', module_name, '  EndDate    = %c', &
   982          & c1 = trim(date_print) )
   983  
   984        EndTimeValue_print = DCCalConvertByUnit( EndTime, 'sec', RestartTimeUnit ) ! (in)
   985        call MessageNotify( 'M', module_name, '  EndTime    = %f [%c]', &
   986          & d = (/ EndTimeValue_print /), c1 = trim(RestartTimeUnit) )
   987      end if
   988  
   989    end subroutine TimesetSetInitialDate
   990  
   991    !-------------------------------------------------------------------
   992  
   993    subroutine TimesetSetCalendar( cal_type, &       ! (in)
   994      & month_in_year, day_in_month, &               ! (in)
   995      & hour_in_day, min_in_hour, sec_in_min )       ! (in)
   996      !
   997      ! 暦の再設定を行います.
   998      !
   999      ! TimesetInit が既に呼ばれることが前提です.
  1000      ! TimesetInit が呼ばれる前にこのサブルーチンが呼ばれた場合,
  1001      ! 何もせずにこのサブルーチンは終了します.
  1002      !
  1003      ! Calendar is reconfigured.
  1004      !
  1005      ! "TimesetInit" must be called before this subroutine is called.
  1006      ! If "TimesetInit" is not called previously, this subroutine
  1007      ! is finished with no changes.
  1008      !
  1009  
  1010      ! モジュール引用 ; USE statements
  1011      !
  1012  
  1013      ! 暦と日時の取り扱い
  1014      ! Calendar and Date handler
  1015      !
  1016      use dc_calendar, only: DCCalCreate, DCCalInquire, DCCalDefault, DCCalToChar
  1017  
  1018      ! 文字列操作
  1019      ! Character handling
  1020      !
  1021      use dc_string, only: toChar
  1022  
  1023      ! 宣言文 ; Declaration statements
  1024      !
  1025  
  1026      character(*), intent(in):: cal_type
  1027                                ! 暦のタイプ.
  1028      integer, intent(in):: month_in_year, day_in_month(:), hour_in_day, min_in_hour
  1029      real(DP), intent(in):: sec_in_min
  1030                                ! 暦情報.
  1031                                ! Information of Calendar.
  1032  
  1033      ! 作業変数
  1034      ! Work variables
  1035      !
  1036      character(TOKEN):: cal_type_print
  1037      type(DC_CAL):: cal_print
  1038  
  1039      ! 実行文 ; Executable statement
  1040      !
  1041  
  1042      if ( .not. timeset_inited ) return
  1043  
  1044      ! 開始日時の情報を設定
  1045      !
  1046      if ( cal_type /= 'user_defined' ) then
  1047        call DCCalCreate( cal_type = cal_type )  ! (in)
  1048      else
  1049        call DCCalCreate( month_in_year, & ! (in)
  1050          &               day_in_month , & ! (in)
  1051          &               hour_in_day,   & ! (in)
  1052          &               min_in_hour ,  & ! (in)
  1053          &               sec_in_min )     ! (in)
  1054      end if
  1055  
  1056      ! 印字 ; Print
  1057      !
  1058      call MessageNotify( 'M', module_name, '----- Reconfigure Calendar Messages -----' )
  1059      call DCCalInquire( cal_type = cal_type_print ) ! (out) optional
  1060      if ( cal_type_print /= 'user_defined' ) then
  1061        call MessageNotify( 'M', module_name, '  Calendar   = %c', &
  1062          & c1 = trim(cal_type_print) )
  1063      else
  1064        call DCCalDefault( cal_print ) ! (out)
  1065        call MessageNotify( 'M', module_name, '  Calendar   = %c', &
  1066          & c1 = trim(DCCalToChar(cal_print)) )
  1067      end if
  1068  
  1069    end subroutine TimesetSetCalendar
  1070  
  1071    !-------------------------------------------------------------------
  1072  
  1073    subroutine TimesetClockStart( name & ! (in)
  1074      & )
  1075      !
  1076      ! プログラム単位 (主にモジュールを想定) ごとの時間計測を開始します.
  1077      !
  1078      ! Start measurement of computation time by program unit
  1079      ! (expected modules).
  1080  
  1081      ! モジュール引用 ; USE statements
  1082      !
  1083  
  1084      ! CPU 時間計測
  1085      ! CPU time monitor
  1086      !
  1087      use dc_clock, only: DCClockCreate, DCClockStart
  1088  
  1089      ! 宣言文 ; Declaration statements
  1090      !
  1091      character(*), intent(in):: name
  1092                                ! モジュールの名称.
  1093                                ! Name of module
  1094  
  1095      ! 作業変数
  1096      ! Work variables
  1097      !
  1098      integer:: i               ! clocks, clocks_name 用 DO ループ用作業変数
  1099                                ! Work variables for DO loop for "clocks", "clocks_name"
  1100  
  1101      ! 実行文 ; Executable statement
  1102      !
  1103  
  1104      if ( .not. CpuTimeMoniter ) return
  1105  
  1106      do i = 1, clk_proc_num
  1107        if ( trim(clocks_name(i)) == trim(name) ) then
  1108          call DCClockStart( clocks(i) ) ! (in)
  1109          return
  1110        end if
  1111      end do
  1112  
  1113      call DCClockCreate( clocks(clk_proc_num + 1), name ) ! (in)
  1114      call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
  1115      clocks_name(clk_proc_num + 1) = name
  1116      clk_proc_num = clk_proc_num + 1
  1117  
  1118    end subroutine TimesetClockStart
  1119  
  1120    !-------------------------------------------------------------------
  1121  
  1122    subroutine TimesetClockStop( name & ! (in)
  1123      & )
  1124      !
  1125      ! プログラム単位 (主にモジュールを想定) ごとの時間計測を一時停止します.
  1126      !
  1127      ! Pause measurement of computation time by program unit
  1128      ! (expected modules).
  1129  
  1130      ! モジュール引用 ; USE statements
  1131      !
  1132  
  1133      ! CPU 時間計測
  1134      ! CPU time monitor
  1135      !
  1136      use dc_clock, only: DCClockStop
  1137  
  1138      ! 宣言文 ; Declaration statements
  1139      !
  1140      character(*), intent(in):: name
  1141                                ! モジュールの名称.
  1142                                ! Name of module
  1143  
  1144      ! 作業変数
  1145      ! Work variables
  1146      !
  1147      integer:: i               ! clocks, clocks_name 用 DO ループ用作業変数
  1148                                ! Work variables for DO loop for "clocks", "clocks_name"
  1149  
  1150      ! 実行文 ; Executable statement
  1151      !
  1152  
  1153      if ( .not. CpuTimeMoniter ) return
  1154  
  1155      do i = 1, clk_proc_num
  1156        if ( trim(clocks_name(i)) == trim(name) ) then
  1157          call DCClockStop( clocks(i) ) ! (in)
  1158          return
  1159        end if
  1160      end do
  1161  
  1162      call MessageNotify( 'W', module_name, ' name "%c" is not found in "TimesetClockStop"', c1 = trim(name) )
  1163  
  1164    end subroutine TimesetClockStop
  1165  
  1166    !-------------------------------------------------------------------
  1167  
  1168    subroutine TimeValidCheck( &
  1169      & RestartTimeChk, EndTimeChk, DelTimeChk, PredictIntTimeChk & ! (in)
  1170      & )
  1171      !
  1172      ! 時刻情報についての有効性をチェックします.
  1173      !
  1174      ! Check validation about infomation time
  1175      !
  1176  
  1177      ! モジュール引用 ; USE statements
  1178      !
  1179  
  1180      ! 暦と日時の取り扱い
  1181      ! Calendar and Date handler
  1182      !
  1183      use dc_calendar, only: DCCalConvertByUnit
  1184  
  1185      real(DP), intent(in):: RestartTimeChk
  1186                                ! リスタート開始時刻.
  1187                                ! Restart time of calculation
  1188      real(DP), intent(in):: EndTimeChk
  1189                                ! 計算終了時刻.
  1190                                ! End time of calculation
  1191      real(DP), intent(in):: DelTimeChk
  1192                                ! $ \Delta t $ [s]
  1193      real(DP), intent(in):: PredictIntTimeChk
  1194                                ! 終了予測日時表示間隔.
  1195                                ! Interval of predicted end time output
  1196  
  1197      ! 印字用作業変数
  1198      ! Work variables for print
  1199      !
  1200      real(DP):: RestartTimeValue_print
  1201      real(DP):: EndTimeValue_print
  1202      real(DP):: DelTimeValue_print
  1203      real(DP):: PredictIntValue_print
  1204  
  1205      ! 作業変数
  1206      ! Work variables
  1207      !
  1208  
  1209      ! 実行文 ; Executable statement
  1210      !
  1211  
  1212      if ( .not. 0.0_DP < ( EndTimeChk - RestartTimeChk ) ) then
  1213        RestartTimeValue_print = DCCalConvertByUnit( RestartTimeChk, 'sec', RestartTimeUnit ) ! (in)
  1214        EndTimeValue_print = DCCalConvertByUnit( EndTimeChk, 'sec', RestartTimeUnit ) ! (in)
  1215  
  1216        call MessageNotify( 'E', module_name, &
  1217          & 'RestartTime=<%f[%c]> is later than EndTime=<%f[%c]>', &
  1218          & d = (/ RestartTimeValue_print, EndTimeValue_print /), &
  1219          & c1 = trim(RestartTimeUnit), c2 = trim(RestartTimeUnit) )
  1220      end if
  1221  
  1222      if ( DelTimeChk > ( EndTimeChk - RestartTimeChk ) ) then
  1223        RestartTimeValue_print = DCCalConvertByUnit( RestartTimeChk, 'sec', RestartTimeUnit ) ! (in)
  1224        EndTimeValue_print = DCCalConvertByUnit( EndTimeChk, 'sec', RestartTimeUnit ) ! (in)
  1225        DelTimeValue_print = DCCalConvertByUnit( DelTimeChk, 'sec', DelTimeUnit ) ! (in)
  1226        call MessageNotify( 'E', module_name, &
  1227          & 'DelTime=<%f[%c]> is larger than ' // &
  1228          & 'EndTime=<%f[%c]> - RestartTime=<%f[%c]>.', &
  1229          & d = (/ DelTimeValue_print, EndTimeValue_print, RestartTimeValue_print /), &
  1230          & c1 = trim(DelTimeUnit), &
  1231          & c2 = trim(RestartTimeUnit), c3 = trim(RestartTimeUnit) )
  1232      end if
  1233  
  1234      if ( .not. DelTimeChk > 0.0_DP ) then
  1235        DelTimeValue_print = DCCalConvertByUnit( DelTimeChk, 'sec', DelTimeUnit ) ! (in)
  1236        call MessageNotify( 'E', module_name, &
  1237          & 'DelTime=<%f[%c]> must be more than 0.', &
  1238          & d = (/ DelTimeValue_print /), &
  1239          & c1 = trim(DelTimeUnit) )
  1240      end if
  1241  
  1242      if ( .not. PredictIntTimeChk > 0.0_DP ) then
  1243        PredictIntValue_print = DCCalConvertByUnit( PredictIntTimeChk, 'sec', PredictIntUnit ) ! (in)
  1244        call MessageNotify( 'E', module_name, &
  1245          & 'PredictInt=<%f[%c]> must be more than 0.', &
  1246          & d = (/ PredictIntValue_print /), &
  1247          & c1 = trim(PredictIntUnit) )
  1248      end if
  1249  
  1250    end subroutine TimeValidCheck
  1251  
  1252    !-------------------------------------------------------------------
  1253  
  1254    subroutine InitCheck
  1255      !
  1256      ! 依存モジュールの初期化チェック
  1257      !
  1258      ! Check initialization of dependency modules
  1259  
  1260      ! モジュール引用 ; USE statements
  1261      !
  1262  
  1263      ! NAMELIST ファイル入力に関するユーティリティ
  1264      ! Utilities for NAMELIST file input
  1265      !
  1266      use namelist_util, only: namelist_util_inited
  1267  
  1268      ! 実行文 ; Executable statement
  1269      !
  1270  
  1271      if ( .not. namelist_util_inited ) &
  1272        & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
  1273  
  1274    end subroutine InitCheck
  1275  
  1276  end module timeset
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: timeset.f90
PROGRAM NAME: timeset
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 時刻管理
     2:             !
     3:             != Time control
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6:             ! Version::   $Id: timeset.f90,v 1.24 2012/01/20 00:17:14 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved. 
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module timeset
    13:               !
    14:               != 時刻管理
    15:               !
    16:               != Time control
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 時刻情報の管理を行います. 
    21:               !
    22:               ! Information of time is controlled. 
    23:               !
    24:               !== Variables List
    25:               !
    26:               ! TimeB                  :: ステップ $ t - \Delta t $ の時刻
    27:               ! TimeN                  :: ステップ $ t $ の時刻
    28:               ! TimeA                  :: ステップ $ t + \Delta t $ の時刻
    29:               ! DelTime                :: $ \Delta t $ [s] (実数型の数値)
    30:               ! RestartTime            :: リスタート開始時刻
    31:               ! EndTime                :: 計算終了時刻
    32:               ! InitialDate            :: 計算開始日時
    33:               ! ------------           :: ------------
    34:               ! TimeB                  :: Time of step $ t - \Delta t $
    35:               ! TimeN                  :: Time of step $ t $
    36:               ! TimeA                  :: Time of step $ t + \Delta t $
    37:               ! DelTime                :: $ \Delta t $ [s] (numerical value of float type)
    38:               ! RestartTime            :: Restart time of calculation
    39:               ! EndTime                :: End time of calculation
    40:               ! InitialDate            :: Start date of calculation
    41:               !
    42:               !== Procedures List
    43:               !
    44:               ! TimesetInit           :: timeset モジュールの初期化
    45:               ! TimesetDelTimeHalf    :: Δt を一時的に半分に
    46:               ! TimesetProgress       :: 時刻の進行
    47:               ! TimesetSetTimeN       :: TimeN の設定
    48:               ! TimesetSetInitialDate :: 計算開始日時の設定
    49:               ! TimesetClockStart     :: 計算時間計測開始
    50:               ! TimesetClockStop      :: 計算時間計一時停止
    51:               ! TimesetClose          :: timeset モジュールの終了処理
    52:               ! ------------          :: ------------
    53:               ! TimesetInit           :: Initialize "timeset" module
    54:               ! TimesetDelTimeHalf    :: Reduce delta t to half temporarily
    55:               ! TimesetProgress       :: Progress time
    56:               ! TimesetSetTimeN       :: Set TimeN
    57:               ! TimesetSetInitialDate :: Set start date
    58:               ! TimesetClockStart     :: Start measurement of computation time
    59:               ! TimesetClockStop      :: Pause measurement of computation time
    60:               ! TimesetClose          :: Terminate "timeset" module
    61:               !
    62:               !== NAMELIST
    63:               !
    64:               ! NAMELIST#timeset_nml
    65:               !
    66:             
    67:               ! モジュール引用 ; USE statements
    68:               !
    69:             
    70:               ! 種別型パラメタ
    71:               ! Kind type parameter
    72:               !
    73:               use dc_types, only: DP, &  ! 倍精度実数型. Double precision. 
    74:                 &                 TOKEN  ! キーワード.   Keywords. 
    75:             
    76:               ! メッセージ出力
    77:               ! Message output
    78:               !
    79:               use dc_message, only: MessageNotify
    80:             
    81:               ! CPU 時間計測
    82:               ! CPU time monitor
    83:               !
    84:               use dc_clock, only: CLOCK
    85:             
    86:               ! 暦と日時の取り扱い
    87:               ! Calendar and Date handler
    88:               !
    89:               use dc_calendar, only: &
    90:                 & DC_CAL, &               ! 暦を表現するデータ型. 
    91:                                           ! Data type for calendar 
    92:                 & DC_CAL_DATE             ! 日時を表現するデータ型. 
    93:                                           ! Data type for date and time
    94:             
    95:               ! NAMELIST ファイル入力に関するユーティリティ
    96:               ! Utilities for NAMELIST file input
    97:               !
    98:               use namelist_util, only: MaxNmlArySize
    99:                                           ! NAMELIST から読み込む配列の最大サイズ.
   100:                                           ! Maximum size of arrays loaded from NAMELIST
   101:             
   102:               ! 宣言文 ; Declaration statements
   103:               !
   104:               implicit none
   105:               private
   106:             
   107:               ! 公開手続き
   108:               ! Public procedure
   109:               !
   110:               public:: TimesetInit, TimesetClose, TimesetProgress, TimesetDelTimeHalf
   111:               public:: TimesetClockStart, TimesetClockStop
   112:               public:: TimesetSetTimeN, TimesetSetInitialDate, TimesetSetCalendar
   113:             
   114:               ! 公開変数
   115:               ! Public variables
   116:               !
   117:               logical, save, public:: timeset_inited = .false.
   118:                                           ! 初期設定フラグ. 
   119:                                           ! Initialization flag
   120:               real(DP), save, public:: TimeB
   121:                                           ! ステップ $ t - \Delta t $ の時刻. 
   122:                                           ! Time of step $ t - \Delta t $. 
   123:               real(DP), save, public:: TimeN
   124:                                           ! ステップ $ t $ の時刻. 
   125:                                           ! Time of step $ t $. 
   126:               real(DP), save, public:: TimeA
   127:                                           ! ステップ $ t + \Delta t $ の時刻. 
   128:                                           ! Time of step $ t + \Delta t $. 
   129:               real(DP), save, public:: DelTime
   130:                                           ! $ \Delta t $ [s]
   131:               real(DP), save:: IntegPeriod
   132:                                           ! 積分時間. 単位は秒. 
   133:                                           ! Unit is second. 
   134:               real(DP), save, public:: RestartTime
   135:                                           ! リスタート開始時刻. 
   136:                                           ! Restart time of calculation
   137:                                           !--
   138:                                           ! 備考: 
   139:                                           ! 
   140:                                           ! 実質的な計算開始時刻は初期値データ使用時ならば
   141:                                           ! 0, リスタートデータ使用時であればリスタート
   142:                                           ! データに格納されたものが使用される. 
   143:                                           ! （DelTime の値によって時刻が必ずしも切りの）
   144:                                           ! 良い数字にならないことを想定している）。
   145:                                           ! 
   146:                                           ! この値はモデルを動かすユーザが計算開始を
   147:                                           ! 期待している時刻であり、この値を元に
   148:                                           ! 計算終了時刻が設定され, またこの値がリスタート
   149:                                           ! ファイルの出力開始時刻としても用いられる. 
   150:                                           !++
   151:               real(DP), save, public:: EndTime
   152:                                           ! 計算終了時刻. 
   153:                                           ! End time of calculation
   154:             
   155:               type(DC_CAL_DATE), save, public:: InitialDate
   156:                                           ! 計算開始日時. 
   157:                                           ! Start date of calculation
   158:               type(DC_CAL_DATE), save, public:: EndDate
   159:                                           ! 計算終了の日時
   160:             
   161:               ! 非公開変数
   162:               ! Private variables
   163:               !
   164:               character(TOKEN), save:: cal_type
   165:                                           ! 暦情報. 
   166:                                           ! Type of calendar used for an experiment
   167:             
   168:               integer         , save:: month_in_year
   169:                                           ! Number of months in a year which is used
   170:                                           ! when cal_type = "user_defined"
   171:               integer         , save:: day_in_month(1:MaxNmlArySize)
   172:                                           ! Number of days in a month which is used
   173:                                           ! when cal_type = "user_defined"
   174:               integer         , save:: hour_in_day
   175:                                           ! Number of hours in a day which is used
   176:                                           ! when cal_type = "user_defined"
   177:               integer         , save:: min_in_hour
   178:                                           ! Number of minutes in a hour which is used
   179:                                           ! when cal_type = "user_defined"
   180:               real(DP)        , save:: sec_in_min
   181:                                           ! Number of seconds in a minute which is used
   182:                                           ! when cal_type = "user_defined"
   183:             
   184:               real(DP)        , save:: RestartTimeValue
   185:                                           ! リスタート開始時刻. 
   186:                                           ! Restart time of calculation
   187:               character(TOKEN), save:: RestartTimeUnit
   188:                                           ! リスタート開始時刻の単位. 
   189:                                           ! Unit of restart time of calculation
   190:               real(DP)        , save:: DelTimeValue
   191:                                           ! $ \Delta t $ .  単位は DelTimeUnit にて指定.
   192:                                           ! Unit is specified by "DelTimeUnit". 
   193:               character(TOKEN), save:: DelTimeUnit
   194:                                           ! $ \Delta t $ の単位. 
   195:                                           ! Unit of $ \Delta t $ 
   196:             
   197:               logical         , save:: flag_half
   198:                                           ! TimesetDelTimeHalf によって $ \Delta t $ が
   199:                                           ! 半分になっていることを示すフラグ. 
   200:                                           ! 
   201:                                           ! Flag that shows $ \Delta t $ is reduced to 
   202:                                           ! half by "TimesetDelTimeHalf"
   203:               real(DP)        , save:: DelTimeSave
   204:                                           ! $ \Delta t $ [s] のデフォルト値. 
   205:                                           ! ("TimesetDelTimeHalf" で使用される)
   206:                                           ! 
   207:                                           ! Default value of $ \Delta t $ [s]. 
   208:                                           ! (for "TimesetDelTimeHalf")
   209:             
   210:               real(DP)        , save:: PredictIntTime
   211:                                           ! 終了予測日時表示時間間隔. 
   212:                                           ! Interval time of predicted end time output
   213:               real(DP)        , save:: PredictPrevTime
   214:                                           ! 前回の終了予測日時表示時間. 
   215:                                           ! Time when predicted end time is output previously
   216:               real(DP)        , save:: PredictIntValue
   217:                                           ! 終了予測日時表示間隔. 
   218:                                           ! Interval of predicted end time output
   219:               character(TOKEN), save:: PredictIntUnit
   220:                                           ! 終了予測日時表示間隔 (単位). 
   221:                                           ! Unit for interval of predicted end time output
   222:             
   223:               logical         , save:: CpuTimeMoniter
   224:                                           ! CPU 時間計測のオンオフ
   225:                                           ! On/off of CPU time monitoring
   226:             
   227:               integer         , parameter:: clkmax = 64
   228:                                           ! CPU 時間計測を行うプロセスの最大数. 
   229:                                           ! Maximum number of processes monitored CPU time
   230:               integer         , save:: clk_proc_num = 0
   231:                                           ! CPU 時間計測を行っているプロセスの数. 
   232:                                           ! Number of processes monitored CPU time
   233:               type(CLOCK)     , save:: clocks(1:clkmax)
   234:                                           ! CPU 時間計測用構造体
   235:                                           ! Derived type for monitoring CPU time
   236:               character(TOKEN), save:: clocks_name(1:clkmax) = ''
   237:                                           ! CPU 時間計測を行っているプロセスの名称
   238:                                           ! Names of processes monitored CPU time
   239:             
   240:             
   241:               character(*), parameter:: module_name = 'timeset'
   242:                                           ! モジュールの名称. 
   243:                                           ! Module name
   244:               character(*), parameter:: version = &
   245:                 & '$Name:  $' // &
   246:                 & '$Id: timeset.f90,v 1.24 2012/01/20 00:17:14 yot Exp $'
   247:                                           ! モジュールのバージョン
   248:                                           ! Module version
   249:             
   250:             
   251:             contains
   252:             
   253:               !-------------------------------------------------------------------
   254:             
   255:               subroutine TimesetInit
   256:                 !
   257:                 ! timeset モジュールの初期化を行います. 
   258:                 ! NAMELIST#timeset_nml の読み込みはこの手続きで行われます. 
   259:                 !
   260:                 ! "timeset" module is initialized. 
   261:                 ! NAMELIST#timeset_nml is loaded in this procedure. 
   262:                 !
   263:             
   264:                 ! モジュール引用 ; USE statements
   265:                 !
   266:             
   267:                 ! NAMELIST ファイル入力に関するユーティリティ
   268:                 ! Utilities for NAMELIST file input
   269:                 !
   270:                 use namelist_util, only: namelist_filename, NmlutilMsg
   271:             
   272:                 ! ファイル入出力補助
   273:                 ! File I/O support
   274:                 !
   275:                 use dc_iounit, only: FileOpen
   276:             
   277:                 ! 種別型パラメタ
   278:                 ! Kind type parameter
   279:                 !
   280:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   281:             
   282:                 ! 暦と日時の取り扱い
   283:                 ! Calendar and Date handler
   284:                 !
   285:                 use dc_calendar, only: DCCalCreate, DCCalConvertByUnit, DCCalToChar, DCCalInquire, &
   286:                   & DCCalDateCreate, DCCalDateDifference, DCCalDateToChar, DCCalDateInquire, &
   287:                   & DCCalDefault
   288:             
   289:                 ! CPU 時間計測
   290:                 ! CPU time monitor
   291:                 !
   292:                 use dc_clock, only: DCClockCreate, DCClockStart
   293:             
   294:                 ! 文字列操作
   295:                 ! Character handling
   296:                 !
   297:                 use dc_string, only: toChar
   298:             
   299:             
   300:                 ! 宣言文 ; Declaration statements
   301:                 !
   302:             
   303:                 integer:: InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin
   304:                                           ! 計算開始日時 (年月日時分)
   305:                                           ! Start date of calculation (year, month, day, hour, minute)
   306:                 real(DP):: InitialSec
   307:                                           ! 計算開始日時 (秒)
   308:                                           ! Start date of calculation (second)
   309:                 real(DP):: IntegPeriodValue
   310:                                           ! 積分時間. 
   311:                                           ! Integral time. 
   312:                 character(TOKEN):: IntegPeriodUnit
   313:                                           ! "IntegPeriodValue" の単位. 
   314:                                           ! Unit of "IntegPeriodValue". 
   315:                 integer:: EndYear, EndMonth, EndDay, EndHour, EndMin
   316:                                           ! 計算終了日時 (年月日時分). 
   317:                                           ! "IntegPeriodValue" が負の場合にこちらが使用される. 
   318:                                           ! 
   319:                                           ! End date of calculation (year, month, day, hour, minute)
   320:                                           ! These are used when "IntegPeriodValue" is negative
   321:                 real(DP):: EndSec
   322:                                           ! 計算終了日時 (秒). 
   323:                                           ! "IntegPeriodValue" が負の場合にこちらが使用される. 
   324:                                           ! 
   325:                                           ! End date of calculation (second)
   326:                                           ! These are used when "IntegPeriodValue" is negative
   327:             
   328:                 ! 印字用作業変数
   329:                 ! Work variables for print
   330:                 !
   331:                 type(DC_CAL):: cal_print
   332:                 real(DP):: EndTimeValue_print
   333:                 character(TOKEN):: date_print
   334:             
   335:                 ! 作業変数
   336:                 ! Work variables
   337:                 !
   338:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   339:                                           ! Unit number for NAMELIST file open
   340:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   341:                                           ! IOSTAT of NAMELIST read
   342:             
   343:                 ! NAMELIST 変数群
   344:                 ! NAMELIST group name
   345:                 !
   346:                 namelist /timeset_nml/ &
   347:                   & cal_type, &
   348:                   & month_in_year, day_in_month, hour_in_day, min_in_hour, sec_in_min, &
   349:                   !
   350:                   & DelTimeValue,    DelTimeUnit, &
   351:                   & RestartTimeValue,  RestartTimeUnit, &
   352:                   & InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin, InitialSec, &
   353:                   & EndYear, EndMonth, EndDay, EndHour, EndMin, EndSec, &
   354:                   & IntegPeriodValue, IntegPeriodUnit, &
   355:                   !
   356:                   & PredictIntValue,  PredictIntUnit, &
   357:                   & CpuTimeMoniter
   358:                       !
   359:                       ! デフォルト値については初期化手続 "timeset#TimesetInit" 
   360:                       ! のソースコードを参照のこと. 
   361:                       !
   362:                       ! Refer to source codes in the initialization procedure
   363:                       ! "timeset#TimesetInit" for the default values. 
   364:                       !
   365:             
   366:                 ! 実行文 ; Executable statement
   367:                 !
   368:             
   369:                 if ( timeset_inited ) return
   370:                 call InitCheck
   371:             
   372:             
   373:                 ! デフォルト値の設定
   374:                 ! Default values settings
   375:                 !
   376:                 cal_type                      = 'noleap'
   377:                 month_in_year                 =   -1
   378: V====== A       day_in_month(1:MaxNmlArySize) =   -1
   379:                 hour_in_day                   =   -1
   380:                 min_in_hour                   =   -1
   381:                 sec_in_min                    =   -1.0_DP
   382:             
   383:                 ! Sample value for the Earth
   384:                 !
   385:             !!$    cal_type                      = 'gregorian'
   386:             !!$    month_in_year                 =   -1
   387:             !!$    day_in_month(1:MaxNmlArySize) =   -1
   388:             !!$    hour_in_day                   =   -1
   389:             !!$    min_in_hour                   =   -1
   390:             !!$    sec_in_min                    =   -1.0_DP
   391:             
   392:                 ! Sample value for the Mars
   393:                 !   Number of days in a year and Mars solar day in second are obtained from 
   394:                 !   Allison (1997). 
   395:                 !   Allison, M, Geophys. Res. Lett., 24, 1967-1970, 1997.
   396:                 !
   397:             !!$    cal_type                      = 'user_defined'
   398:             !!$    month_in_year                 =    1
   399:             !!$    day_in_month(1:MaxNmlArySize) =  669
   400:             !!$    hour_in_day                   =   24
   401:             !!$    min_in_hour                   =    1
   402:             !!$    sec_in_min                    = 3700.0_DP    ! 3699.0_DP
   403:             
   404:             
   405:                 DelTimeValue                  =   30.0_DP
   406:                 DelTimeUnit                   = 'min'
   407:                 flag_half                     = .false.
   408:             
   409:                 RestartTimeValue              =    0.0_DP
   410:                 RestartTimeUnit               = 'sec'
   411:             
   412:                 InitialYear                   = 2000
   413:                 InitialMonth                  =    1
   414:                 InitialDay                    =    1
   415:                 InitialHour                   =    0
   416:                 InitialMin                    =    0
   417:                 InitialSec                    =    0.0
   418:             
   419:                 IntegPeriodValue              =   -1.0
   420:                                                ! If IntegPeriodValue is negative, EndXXX are used.
   421:                 IntegPeriodUnit               = 'sec'
   422:             
   423:                 EndYear                       = 2000
   424:                 EndMonth                      =    1
   425:                 EndDay                        =    2
   426:                 EndHour                       =    0
   427:                 EndMin                        =    0
   428:                 EndSec                        =    0.0
   429:             
   430:                 PredictIntValue               =    1.0_DP
   431:                 PredictIntUnit                = 'day'
   432:             
   433:                 CpuTimeMoniter                 = .true.
   434:             
   435:             
   436:                 ! NAMELIST の読み込み
   437:                 ! NAMELIST is input
   438:                 !
   439:                 if ( trim(namelist_filename) /= '' ) then
   440:                   call FileOpen( unit_nml, &          ! (out)
   441:                     & namelist_filename, mode = 'r' ) ! (in)
   442:             
   443:                   rewind( unit_nml )
   444:                   read( unit_nml, &         ! (in)
   445:                     & nml = timeset_nml, &  ! (out)
   446:                     & iostat = iostat_nml ) ! (out)
   447:                   close( unit_nml )
   448:             
   449:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   450:                   if ( iostat_nml == 0 ) write( STDOUT, nml = timeset_nml )
   451:                 end if
   452:             
   453:             
   454:                 ! 暦の情報を設定
   455:                 ! Set calendar
   456:                 !
   457:                 if ( cal_type == "user_defined" ) then
   458:                   call DCCalCreate(                                                &
   459:                     &               month_in_year = month_in_year                , & ! (in)
   460:                     &               day_in_month  = day_in_month(1:month_in_year), & ! (in)
   461:                     &               hour_in_day   = hour_in_day                  , & ! (in)
   462:                     &               min_in_hour   = min_in_hour                  , & ! (in)
   463:                     &               sec_in_min    = sec_in_min                     & ! (in)
   464:                     & )
   465:                 else
   466:                   call DCCalCreate( cal_type = cal_type ) ! (in)
   467:                 end if
   468:             
   469:             
   470:                 ! Lines below will be deleted. (yot, 2010/08/12)
   471:                 !
   472:             
   473:                 ! 暦の情報を設定 (サンプルとしていくつかの case を記載)
   474:                 !
   475:                 ! case 1:
   476:                 ! dc_calendar で用意される典型的な暦をデフォルトの暦として設定
   477:                 !
   478:             !!$    call DCCalCreate( cal_type = 'gregorian' ) ! (in)  ! グレゴリオ暦
   479:             !!$    call DCCalCreate( cal_type = 'julian'    ) ! (in)  ! ユリウス暦
   480:             !!$    call DCCalCreate( cal_type = 'noleap'    ) ! (in)  ! 閏年無しの暦
   481:             !!$    call DCCalCreate( cal_type = '360day'    ) ! (in)  ! 1ヶ月が 30 日の暦
   482:             !!$    call DCCalCreate( cal_type = 'cyclic'    ) ! (in)  ! ある月の日数を 「30.6 × 月数 − 前月までの総日数」の小数点以下切捨とする暦 
   483:             
   484:             !!$    ! case 2:
   485:             !!$    ! 決まり切った暦 (以下はユリウス暦) を設定
   486:             !!$    !
   487:             !!$    call DCCalCreate( cal_type = 'Julian' ) ! (in)
   488:             !!$
   489:             !!$    ! case 3:
   490:             !!$    ! 地球っぽい暦を利用者が明示的に指定
   491:             !!$    !
   492:             !!$    call DCCalCreate( month_in_year = 12 , &   ! (in)
   493:             !!$      &               day_in_month  = (/31, 28, 31, 30, 31, 30,   &
   494:             !!$      &                                 31, 31, 30, 31, 30, 31/), & ! (in) 
   495:             !!$      &               hour_in_day = 24,     &  ! (in) 
   496:             !!$      &               min_in_hour = 60 ,    &  ! (in) 
   497:             !!$      &               sec_in_min  = 60.0d0 )   ! (in) 
   498:             !!$
   499:             !!$    ! case 3:
   500:             !!$    ! 火星っぽい暦を利用者が明示的に指定. 
   501:             !!$    ! ※ 「暦に月がない」場合には, month_in_year = 1 とする. 
   502:             !!$    !
   503:             !!$    call DCCalCreate( month_in_year = 1 , &      ! (in)
   504:             !!$      &               day_in_month  = (/669/), & ! (in)
   505:             !!$      &               hour_in_day = 24, &        ! (in)
   506:             !!$      &               min_in_hour = 1 , &        ! (in)
   507:             !!$      &               sec_in_min  = 3694.0d0  )  ! (in)
   508:             
   509:             
   510:                 ! 時間変数 (秒) の設定
   511:                 ! Calculate time variable (sec)
   512:                 !
   513:                 DelTime        = DCCalConvertByUnit( DelTimeValue,     DelTimeUnit,     'sec' ) !(in)
   514:                 RestartTime    = DCCalConvertByUnit( RestartTimeValue, RestartTimeUnit, 'sec' ) !(in)
   515:             
   516:             
   517:                 ! 開始日時の情報を設定
   518:                 !
   519:                 ! 再計算時には restart_file_io モジュールによる TimesetSetInitialDate 
   520:                 ! 呼び出しによって上書きされることを想定. 
   521:                 !
   522:                 if ( ( .not. ( InitialMonth < 0      ) ) .and. &
   523:                   &  ( .not. ( InitialDay   < 0      ) ) .and. &
   524:                   &  ( .not. ( InitialHour  < 0      ) ) .and. &
   525:                   &  ( .not. ( InitialMin   < 0      ) ) .and. &
   526:                   &  ( .not. ( InitialSec   < 0.0_DP ) ) ) then
   527:             
   528:                   call DCCalDateCreate( &
   529:                     & year  = InitialYear,   & ! (in)
   530:                     & month = InitialMonth,  & ! (in)
   531:                     & day   = InitialDay,    & ! (in)
   532:                     & hour  = InitialHour,   & ! (in)
   533:                     & min   = InitialMin,    & ! (in)
   534:                     & sec   = InitialSec,    & ! (in)
   535:                     & date  = InitialDate )  ! (out) optional
   536:                 else
   537:                   call MessageNotify('W', module_name, 'InitialMonth/Day/Hour/Min/Sec is negative.' )
   538:                 end if
   539:             
   540:             
   541:                 ! 終了日時 (開始日時からの経過時間で表現) を設定
   542:                 !
   543:                 if ( IntegPeriodValue < 0.0 ) then
   544:             
   545:                   IntegPeriod = IntegPeriodValue
   546:             
   547:                   ! case 1
   548:                   ! 終了日時を使う場合
   549:                   !
   550:                   call DCCalDateCreate( &
   551:                     & year  = EndYear,   & ! (in)
   552:                     & month = EndMonth,  & ! (in)
   553:                     & day   = EndDay,    & ! (in)
   554:                     & hour  = EndHour,   & ! (in)
   555:                     & min   = EndMin,    & ! (in)
   556:                     & sec   = EndSec,    & ! (in)
   557:                     & date  = EndDate )    ! (out) optional
   558:             
   559:                   EndTime = DCCalDateDifference( &
   560:                     &         start_date = InitialDate, &  ! (in)
   561:                     &         end_date   = EndDate )       ! (in)
   562:             
   563:                   if ( .not. EndTime > 0.0 ) then
   564:                     call DCCalDateInquire( date_print, date = InitialDate )
   565:                     call MessageNotify('W', module_name, 'InitialDate=<%c>', c1 = trim(date_print) )
   566:                     call DCCalDateInquire( date_print, date = EndDate )
   567:                     call MessageNotify('W', module_name, 'EndDate=<%c>', c1 = trim(date_print) )
   568:                     call MessageNotify('E', module_name, '"EndTime" must be positive.')
   569:                   end if
   570:             
   571:                 else
   572:                   ! case 2
   573:                   ! 積分時間を使う場合
   574:                   !
   575:                   IntegPeriod = DCCalConvertByUnit( IntegPeriodValue, IntegPeriodUnit, 'sec' ) !(in)
   576:             
   577:                   EndTime = RestartTime + IntegPeriod
   578:                 end if
   579:             
   580:             
   581:                 ! 終了予測日時表示時間の初期設定
   582:                 ! Initialize Time when predicted end time is output
   583:                 !
   584:                 PredictIntTime  = DCCalConvertByUnit( PredictIntValue, PredictIntUnit, 'sec' ) !(in)
   585:                 PredictPrevTime = RestartTime - DelTime
   586:             
   587:             
   588:                 ! 時刻の正当性のチェック
   589:                 ! Check validation of time
   590:                 !
   591:                 call TimeValidCheck( RestartTime, EndTime, DelTime, PredictIntTime ) ! (in)
   592:             
   593:             
   594:                 ! 各タイムステップの時刻の設定
   595:                 ! Configure time on each time step
   596:                 !
   597:                 ! 再計算時には restart_file_io モジュールによる TimesetSetTimeN
   598:                 ! 呼び出しによって上書きされることを想定. 
   599:                 ! 
   600:                 TimeN = RestartTime
   601:                 TimeB = TimeN - DelTime
   602:                 TimeA = TimeN + DelTime
   603:             
   604:             
   605:                 ! $ \Delta t $ [s] を保存
   606:                 ! Save $ \Delta t $ [s]
   607:                 !
   608:                 DelTimeSave = DelTime
   609:             
   610:             
   611:                 ! CPU 時間計測開始 (モデル全体)
   612:                 ! Start CPU time monitoring (for entire model)
   613:                 !
   614:                 if ( CpuTimeMoniter ) then
   615:                   call DCClockCreate( clocks(clk_proc_num + 1), 'total' ) ! (in)
   616:                   call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
   617:                   clocks_name(clk_proc_num + 1) = 'total'
   618:                   clk_proc_num = clk_proc_num + 1
   619:                 end if
   620:             
   621:                 ! 印字 ; Print
   622:                 !
   623:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   624:                 call MessageNotify( 'M', module_name, '  RestartTime  = %f [%c]', &
   625:                   & d = (/ RestartTimeValue /), c1 = trim(RestartTimeUnit) )
   626:                 call DCCalDateInquire( date_print, date = InitialDate )
   627:                 call MessageNotify( 'M', module_name, '  InitialDate  = %c', &
   628:                   & c1 = trim(date_print) )
   629:                 if ( IntegPeriodValue < 0.0 ) then
   630:                   call DCCalDateInquire( date_print, date = EndDate )
   631:                   call MessageNotify( 'M', module_name, '  EndDate      = %c', &
   632:                     & c1 = trim(date_print) )
   633:                 end if
   634:                 EndTimeValue_print = DCCalConvertByUnit( EndTime, 'sec', RestartTimeUnit ) ! (in)
   635:                 call MessageNotify( 'M', module_name, '  EndTime      = %f [%c]', &
   636:                   & d = (/ EndTimeValue_print /), c1 = trim(RestartTimeUnit) )
   637:                 call MessageNotify( 'M', module_name, '  DelTime      = %f [%c]', &
   638:                   & d = (/ DelTimeValue /), c1 = trim(DelTimeUnit) )
   639:                 call MessageNotify( 'M', module_name, '               = %f [%c]', &
   640:                   & d = (/ DelTime /), c1 = 'sec' )
   641:                 if ( cal_type /= 'user_defined' ) then
   642:                   call MessageNotify( 'M', module_name, '  Calendar     = %c', &
   643:                     & c1 = trim(cal_type) )
   644:                 else
   645:                   call DCCalDefault( cal_print ) ! (out) 
   646:                   call MessageNotify( 'M', module_name, '  Calendar     = %c', &
   647:                     & c1 = trim(DCCalToChar(cal_print)) )
   648:                 end if
   649:                 call MessageNotify( 'M', module_name, '  PredictInt = %f [%c]', &
   650:                   & d = (/ PredictIntValue /), c1 = trim(PredictIntUnit) )
   651:                 call MessageNotify( 'M', module_name, '  CpuTimeMoniter = %b', &
   652:                   & l = (/ CpuTimeMoniter /) )
   653:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   654:             
   655:                 timeset_inited = .true.
   656:               end subroutine TimesetInit
   657:             
   658:               !-------------------------------------------------------------------
   659:             
   660:               subroutine TimesetDelTimeHalf
   661:                 ! 
   662:                 ! 計算の初回だけはオイラー法を用いるため, 
   663:                 ! 一時的に Δt を半分にします. 
   664:                 ! TimesetProgress が呼ばれた段階で Δt は元に戻ります. 
   665:                 ! 
   666:                 ! Delta t is reduced to half temporarily 
   667:                 ! in order to use Euler method at initial step. 
   668:                 ! Delta t is returned to default, when "TimesetProgress" is called. 
   669:                 !
   670:             
   671:                 ! 宣言文 ; Declaration statements
   672:                 !
   673:             
   674:                 ! 作業変数
   675:                 ! Work variables
   676:                 !
   677:             
   678:                 ! 実行文 ; Executable statement
   679:                 !
   680:                 if ( flag_half ) return
   681:                 DelTime = DelTime / 2.0_DP
   682:                 flag_half = .true.
   683:             
   684:               end subroutine TimesetDelTimeHalf
   685:             
   686:               !-------------------------------------------------------------------
   687:             
   688: V====== A     subroutine TimesetProgress
   689:                 !
   690:                 ! timeset モジュール内の時刻を進めます. 
   691:                 ! また, TimesetProgress#PredictIntStep で設定された値に応じて, 
   692:                 ! 現在までの計算時間と計算終了予測時刻を表示します. 
   693:                 !
   694:                 ! Progress time configured in "timeset" module. 
   695:                 ! And, computation time until now and 
   696:                 ! predicted end of computation time are printed 
   697:                 ! according to configured "TimesetProgress#PredictIntStep"
   698:                 !
   699:             
   700:                 ! モジュール引用 ; USE statements
   701:                 !
   702:             
   703:                 ! CPU 時間計測
   704:                 ! CPU time monitor
   705:                 !
   706:                 use dc_clock, only: DCClockPredict, DCClockStop, DCClockClose, &
   707:                   & operator(+), operator(-)
   708:             
   709:                 ! 宣言文 ; Declaration statements
   710:                 !
   711:             
   712:                 ! 作業変数
   713:                 ! Work variables
   714:                 !
   715:                 type(CLOCK):: clock_tmp
   716:             
   717:                 ! 実行文 ; Executable statement
   718:                 !
   719:             
   720:                 ! Δt を元に戻す. 
   721:                 ! Delta t is returned to default
   722:                 !
   723:                 if ( flag_half ) then
   724:                   DelTime = DelTimeSave
   725:                   flag_half = .false.
   726:                 end if
   727:             
   728:                 ! 終了予測日時表示
   729:                 ! Print predicted end time
   730:                 !
   731:                 if ( .not. TimeA - PredictPrevTime < PredictIntTime ) then
   732:                   PredictPrevTime = PredictPrevTime + PredictIntTime
   733:                   if ( CpuTimeMoniter ) then
   734:                     clock_tmp = clocks(1)
   735:                     call DCClockStop( clock_tmp ) ! (in)
   736:                     call DCClockPredict( &
   737:                       & clock_tmp, &
   738:                       & real( ( TimeA - RestartTime ) / ( ( EndTime + DelTimeSave ) - RestartTime ) ) ) ! (in)
   739:                     call DCClockClose( clock_tmp ) ! (in)
   740:                   end if
   741:                 end if
   742:             
   743:                 ! 時刻の進行
   744:                 ! Progress time
   745:                 !
   746:                 TimeB = TimeB + DelTime
   747:                 TimeN = TimeN + DelTime
   748:                 TimeA = TimeA + DelTime
   749:               end subroutine TimesetProgress
   750:             
   751:               !-------------------------------------------------------------------
   752:             
   753:               subroutine TimesetClose
   754:                 !
   755:                 ! 計算時間の総計を表示します. 
   756:                 !
   757:                 ! Total computation time is printed. 
   758:             
   759:                 ! モジュール引用 ; USE statements
   760:                 !
   761:             
   762:                 ! CPU 時間計測
   763:                 ! CPU time monitor
   764:                 !
   765:                 use dc_clock, only: DCClockStop, DCClockResult, DCClockSetName, &
   766:                   & operator(+), operator(-)
   767:             
   768:                 ! 宣言文 ; Declaration statements
   769:                 !
   770:                 integer:: i               ! clocks, clocks_name 用 DO ループ用作業変数
   771:                                           ! Work variables for DO loop for "clocks", "clocks_name"
   772:             
   773:                 ! 作業変数
   774:                 ! Work variables
   775:                 !
   776:             
   777:                 ! 実行文 ; Executable statement
   778:                 !
   779:             
   780:                 if ( .not. CpuTimeMoniter ) return
   781:             
   782:                 ! CPU 時間計測終了 (モデル全体)
   783:                 ! Stop CPU time monitoring (for entire model)
   784:                 !
   785:                 call DCClockStop( clocks(1) ) ! (in)
   786:             
   787:                 ! 「その他」の CPU 時間を算出
   788:                 ! Calculate CPU time of "Others"
   789:                 !
   790:                 clocks(clk_proc_num + 1) = clocks(1)
   791: +------>        do i = 2, clk_proc_num
   792: |                 clocks(clk_proc_num + 1) = clocks(clk_proc_num + 1) - clocks(i)
   793: +------         end do
   794:                 call DCClockSetName( clocks(clk_proc_num + 1), 'others' )
   795:             
   796:                 ! CPU 時間の総計を表示
   797:                 ! Print total CPU time
   798:                 !
   799:                 call DCClockResult( &
   800:                   & clocks(2:clk_proc_num + 1), total_auto = .true. ) ! (in)
   801:             
   802:               end subroutine TimesetClose
   803:             
   804:               !-------------------------------------------------------------------
   805:             
   806:               subroutine TimesetSetTimeN(TimeNSet)
   807:                 !
   808:                 ! TimeN の再設定を行います. 
   809:                 ! 自動的に TimeB, TimeA, EndTime についても
   810:                 ! 再設定を行います. 
   811:                 !
   812:                 ! TimesetInit が既に呼ばれることが前提です. 
   813:                 ! TimesetInit が呼ばれる前にこのサブルーチンが呼ばれた場合,
   814:                 ! 何もせずにこのサブルーチンは終了します. 
   815:                 !
   816:                 ! "TimeN" is reconfigured. 
   817:                 ! "TimeB", "TimeA", "EndTime" are reconfigured automatically. 
   818:                 !
   819:                 ! "TimesetInit" must be called before this subroutine is called. 
   820:                 ! If "TimesetInit" is not called previously, this subroutine 
   821:                 ! is finished with no changes. 
   822:                 !
   823:             
   824:                 ! モジュール引用 ; USE statements
   825:                 !
   826:             
   827:                 ! 暦と日時の取り扱い
   828:                 ! Calendar and Date handler
   829:                 !
   830:                 use dc_calendar, only: DCCalConvertByUnit
   831:             
   832:                 ! 文字列操作
   833:                 ! Character handling
   834:                 !
   835:                 use dc_string, only: toChar
   836:             
   837:                 ! 宣言文 ; Declaration statements
   838:                 !
   839:             
   840:                 real(DP), intent(in):: TimeNSet
   841:                                           ! ステップ $ t $ の時刻. 
   842:                                           ! Time of step $ t $. 
   843:                 
   844:                 ! 作業変数
   845:                 ! Work variables
   846:                 !
   847:                 real(DP):: EndTimeValue_print
   848:             
   849:                 ! 実行文 ; Executable statement
   850:                 !
   851:             
   852:                 if ( .not. timeset_inited ) return
   853:             
   854:                 ! TimeN が負の場合、エラーを発生
   855:                 ! Cause an error, if TimeN is negative
   856:                 !
   857:                 if ( TimeN < 0.0 ) then
   858:                   call MessageNotify( 'E', module_name, &
   859:                     & 'TimeN=<%f [sec]> must be positive', &
   860:                     & d = (/ TimeNSet /) )
   861:                 end if
   862:             
   863:                 ! 各タイムステップの時刻の設定
   864:                 ! Reconfigure time on each time step
   865:                 !
   866:                 TimeN = TimeNSet
   867:                 TimeB = TimeN - DelTime
   868:                 TimeA = TimeN + DelTime
   869:             
   870:                 ! 前回の終了予測日時表示時間の再設定
   871:                 ! Reconfigure Time when predicted end time is output previously
   872:                 !
   873:                 PredictPrevTime = TimeN - DelTime
   874:             
   875:                 ! 印字 ; Print
   876:                 !
   877:                 call MessageNotify( 'M', module_name, '----- Reconfigure Time Messages -----' )
   878:                 call MessageNotify( 'M', module_name, '  TimeB  = %f [sec]', &
   879:                   & d = (/ TimeB /) )
   880:                 call MessageNotify( 'M', module_name, '  TimeN  = %f [sec]', &
   881:                   & d = (/ TimeN /) )
   882:                 call MessageNotify( 'M', module_name, '  TimeA  = %f [sec]', &
   883:                   & d = (/ TimeA /) )
   884:                 if ( IntegPeriod > 0.0 ) then
   885:                   EndTimeValue_print = DCCalConvertByUnit( EndTime, 'sec', RestartTimeUnit ) ! (in)
   886:                   call MessageNotify( 'M', module_name, '  EndTime    = %f [%c]', &
   887:                     & d = (/ EndTimeValue_print /), c1 = trim(RestartTimeUnit) )
   888:                 end if
   889:             
   890:               end subroutine TimesetSetTimeN
   891:             
   892:               !-------------------------------------------------------------------
   893:             
   894:               subroutine TimesetSetInitialDate( &
   895:                 & InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin, InitialSec )
   896:                 !
   897:                 ! 開始日時の再設定を行います. 
   898:                 !
   899:                 ! TimesetInit が既に呼ばれることが前提です. 
   900:                 ! TimesetInit が呼ばれる前にこのサブルーチンが呼ばれた場合,
   901:                 ! 何もせずにこのサブルーチンは終了します. 
   902:                 !
   903:                 ! Start date is reconfigured. 
   904:                 !
   905:                 ! "TimesetInit" must be called before this subroutine is called. 
   906:                 ! If "TimesetInit" is not called previously, this subroutine 
   907:                 ! is finished with no changes. 
   908:                 !
   909:             
   910:                 ! モジュール引用 ; USE statements
   911:                 !
   912:             
   913:                 ! 暦と日時の取り扱い
   914:                 ! Calendar and Date handler
   915:                 !
   916:                 use dc_calendar, only: DCCalCreate, DCCalConvertByUnit, DCCalToChar, DCCalInquire, &
   917:                   & DCCalDateCreate, DCCalDateDifference, DCCalDateToChar, DCCalDateInquire
   918:             
   919:                 ! 文字列操作
   920:                 ! Character handling
   921:                 !
   922:                 use dc_string, only: toChar
   923:             
   924:                 ! 宣言文 ; Declaration statements
   925:                 !
   926:             
   927:                 integer, intent(in):: InitialYear, InitialMonth, InitialDay, InitialHour, InitialMin
   928:                                           ! 計算開始の年月日時分
   929:                 real(DP), intent(in):: InitialSec
   930:                                           ! 計算開始の秒
   931:             
   932:                 ! 作業変数
   933:                 ! Work variables
   934:                 !
   935:                 real(DP):: EndTimeValue_print
   936:                 character(TOKEN):: date_print
   937:             
   938:                 ! 実行文 ; Executable statement
   939:                 !
   940:             
   941:                 if ( .not. timeset_inited ) return
   942:             
   943:                 ! "InitialDate" を再設定
   944:                 ! Reconfigure "InitialDate"
   945:                 !
   946:                 call DCCalDateCreate( &
   947:                   & year  = InitialYear,   & ! (in)
   948:                   & month = InitialMonth,  & ! (in)
   949:                   & day   = InitialDay,    & ! (in)
   950:                   & hour  = InitialHour,   & ! (in)
   951:                   & min   = InitialMin,    & ! (in)
   952:                   & sec   = InitialSec,    & ! (in)
   953:                   & date  = InitialDate )  ! (out) optional
   954:             
   955:                 ! "EndTime" の再設定
   956:                 ! Reconfigure "EndTime"
   957:                 !
   958:                 if ( IntegPeriod < 0.0 ) then
   959:                   EndTime = DCCalDateDifference( &
   960:                     &         start_date = InitialDate, &  ! (in)
   961:                     &         end_date = EndDate )         ! (in)
   962:             
   963:                   if ( .not. EndTime > 0.0 ) then
   964:                     call DCCalDateInquire( date_print, date = InitialDate )
   965:                     call MessageNotify('W', module_name, 'InitialDate=<%c>', c1 = trim(date_print) )
   966:                     call DCCalDateInquire( date_print, date = EndDate )
   967:                     call MessageNotify('W', module_name, 'EndDate=<%c>', c1 = trim(date_print) )
   968:                     call MessageNotify('E', module_name, '"EndTime" must be positive.')
   969:                   end if
   970:             
   971:                 end if
   972:             
   973:                 ! 印字 ; Print
   974:                 !
   975:                 call MessageNotify( 'M', module_name, '----- Reconfigure InitialDate Messages -----' )
   976:                 call DCCalDateInquire( date_print, date = InitialDate )
   977:                 call MessageNotify( 'M', module_name, '  InitialDate  = %c', &
   978:                   & c1 = trim(date_print) )
   979:                 if ( IntegPeriod < 0.0 ) then
   980:                   call DCCalDateInquire( date_print, date = EndDate )
   981:                   call MessageNotify( 'M', module_name, '  EndDate    = %c', &
   982:                     & c1 = trim(date_print) )
   983:             
   984:                   EndTimeValue_print = DCCalConvertByUnit( EndTime, 'sec', RestartTimeUnit ) ! (in)
   985:                   call MessageNotify( 'M', module_name, '  EndTime    = %f [%c]', &
   986:                     & d = (/ EndTimeValue_print /), c1 = trim(RestartTimeUnit) )
   987:                 end if
   988:             
   989:               end subroutine TimesetSetInitialDate
   990:             
   991:               !-------------------------------------------------------------------
   992:             
   993:               subroutine TimesetSetCalendar( cal_type, &       ! (in)
   994:                 & month_in_year, day_in_month, &               ! (in)
   995:                 & hour_in_day, min_in_hour, sec_in_min )       ! (in)
   996:                 !
   997:                 ! 暦の再設定を行います. 
   998:                 !
   999:                 ! TimesetInit が既に呼ばれることが前提です. 
  1000:                 ! TimesetInit が呼ばれる前にこのサブルーチンが呼ばれた場合,
  1001:                 ! 何もせずにこのサブルーチンは終了します. 
  1002:                 !
  1003:                 ! Calendar is reconfigured. 
  1004:                 !
  1005:                 ! "TimesetInit" must be called before this subroutine is called. 
  1006:                 ! If "TimesetInit" is not called previously, this subroutine 
  1007:                 ! is finished with no changes. 
  1008:                 !
  1009:             
  1010:                 ! モジュール引用 ; USE statements
  1011:                 !
  1012:             
  1013:                 ! 暦と日時の取り扱い
  1014:                 ! Calendar and Date handler
  1015:                 !
  1016:                 use dc_calendar, only: DCCalCreate, DCCalInquire, DCCalDefault, DCCalToChar
  1017:             
  1018:                 ! 文字列操作
  1019:                 ! Character handling
  1020:                 !
  1021:                 use dc_string, only: toChar
  1022:             
  1023:                 ! 宣言文 ; Declaration statements
  1024:                 !
  1025:             
  1026:                 character(*), intent(in):: cal_type
  1027:                                           ! 暦のタイプ. 
  1028:                 integer, intent(in):: month_in_year, day_in_month(:), hour_in_day, min_in_hour
  1029:                 real(DP), intent(in):: sec_in_min
  1030:                                           ! 暦情報. 
  1031:                                           ! Information of Calendar. 
  1032:             
  1033:                 ! 作業変数
  1034:                 ! Work variables
  1035:                 !
  1036:                 character(TOKEN):: cal_type_print
  1037:                 type(DC_CAL):: cal_print
  1038:             
  1039:                 ! 実行文 ; Executable statement
  1040:                 !
  1041:             
  1042:                 if ( .not. timeset_inited ) return
  1043:             
  1044:                 ! 開始日時の情報を設定
  1045:                 !
  1046:                 if ( cal_type /= 'user_defined' ) then
  1047:                   call DCCalCreate( cal_type = cal_type )  ! (in)
  1048:                 else
  1049:                   call DCCalCreate( month_in_year, & ! (in)
  1050:                     &               day_in_month , & ! (in) 
  1051:                     &               hour_in_day,   & ! (in) 
  1052:                     &               min_in_hour ,  & ! (in) 
  1053:                     &               sec_in_min )     ! (in) 
  1054:                 end if
  1055:             
  1056:                 ! 印字 ; Print
  1057:                 !
  1058:                 call MessageNotify( 'M', module_name, '----- Reconfigure Calendar Messages -----' )
  1059:                 call DCCalInquire( cal_type = cal_type_print ) ! (out) optional
  1060:                 if ( cal_type_print /= 'user_defined' ) then
  1061:                   call MessageNotify( 'M', module_name, '  Calendar   = %c', &
  1062:                     & c1 = trim(cal_type_print) )
  1063:                 else
  1064:                   call DCCalDefault( cal_print ) ! (out) 
  1065:                   call MessageNotify( 'M', module_name, '  Calendar   = %c', &
  1066:                     & c1 = trim(DCCalToChar(cal_print)) )
  1067:                 end if
  1068:             
  1069:               end subroutine TimesetSetCalendar
  1070:             
  1071:               !-------------------------------------------------------------------
  1072:             
  1073:               subroutine TimesetClockStart( name & ! (in)
  1074:                 & )
  1075:                 !
  1076:                 ! プログラム単位 (主にモジュールを想定) ごとの時間計測を開始します. 
  1077:                 !
  1078:                 ! Start measurement of computation time by program unit
  1079:                 ! (expected modules). 
  1080:             
  1081:                 ! モジュール引用 ; USE statements
  1082:                 !
  1083:             
  1084:                 ! CPU 時間計測
  1085:                 ! CPU time monitor
  1086:                 !
  1087:                 use dc_clock, only: DCClockCreate, DCClockStart
  1088:             
  1089:                 ! 宣言文 ; Declaration statements
  1090:                 !
  1091:                 character(*), intent(in):: name
  1092:                                           ! モジュールの名称. 
  1093:                                           ! Name of module
  1094:             
  1095:                 ! 作業変数
  1096:                 ! Work variables
  1097:                 !
  1098:                 integer:: i               ! clocks, clocks_name 用 DO ループ用作業変数
  1099:                                           ! Work variables for DO loop for "clocks", "clocks_name"
  1100:             
  1101:                 ! 実行文 ; Executable statement
  1102:                 !
  1103:             
  1104:                 if ( .not. CpuTimeMoniter ) return
  1105:             
  1106: +------>        do i = 1, clk_proc_num
  1107: |                 if ( trim(clocks_name(i)) == trim(name) ) then
  1108: |                   call DCClockStart( clocks(i) ) ! (in)
  1109: |                   return
  1110: |                 end if
  1111: +------         end do
  1112:             
  1113:                 call DCClockCreate( clocks(clk_proc_num + 1), name ) ! (in)
  1114:                 call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
  1115:                 clocks_name(clk_proc_num + 1) = name
  1116:                 clk_proc_num = clk_proc_num + 1
  1117:             
  1118:               end subroutine TimesetClockStart
  1119:             
  1120:               !-------------------------------------------------------------------
  1121:             
  1122:               subroutine TimesetClockStop( name & ! (in)
  1123:                 & )
  1124:                 !
  1125:                 ! プログラム単位 (主にモジュールを想定) ごとの時間計測を一時停止します.
  1126:                 !
  1127:                 ! Pause measurement of computation time by program unit
  1128:                 ! (expected modules). 
  1129:             
  1130:                 ! モジュール引用 ; USE statements
  1131:                 !
  1132:             
  1133:                 ! CPU 時間計測
  1134:                 ! CPU time monitor
  1135:                 !
  1136:                 use dc_clock, only: DCClockStop
  1137:             
  1138:                 ! 宣言文 ; Declaration statements
  1139:                 !
  1140:                 character(*), intent(in):: name
  1141:                                           ! モジュールの名称. 
  1142:                                           ! Name of module
  1143:             
  1144:                 ! 作業変数
  1145:                 ! Work variables
  1146:                 !
  1147:                 integer:: i               ! clocks, clocks_name 用 DO ループ用作業変数
  1148:                                           ! Work variables for DO loop for "clocks", "clocks_name"
  1149:             
  1150:                 ! 実行文 ; Executable statement
  1151:                 !
  1152:             
  1153:                 if ( .not. CpuTimeMoniter ) return
  1154:             
  1155: +------>        do i = 1, clk_proc_num
  1156: |                 if ( trim(clocks_name(i)) == trim(name) ) then
  1157: |                   call DCClockStop( clocks(i) ) ! (in)
  1158: |                   return
  1159: |                 end if
  1160: +------         end do
  1161:             
  1162:                 call MessageNotify( 'W', module_name, ' name "%c" is not found in "TimesetClockStop"', c1 = trim(name) )
  1163:             
  1164:               end subroutine TimesetClockStop
  1165:             
  1166:               !-------------------------------------------------------------------
  1167:             
  1168:               subroutine TimeValidCheck( &
  1169:                 & RestartTimeChk, EndTimeChk, DelTimeChk, PredictIntTimeChk & ! (in)
  1170:                 & )
  1171:                 !
  1172:                 ! 時刻情報についての有効性をチェックします. 
  1173:                 !
  1174:                 ! Check validation about infomation time
  1175:                 !
  1176:             
  1177:                 ! モジュール引用 ; USE statements
  1178:                 !
  1179:             
  1180:                 ! 暦と日時の取り扱い
  1181:                 ! Calendar and Date handler
  1182:                 !
  1183:                 use dc_calendar, only: DCCalConvertByUnit
  1184:             
  1185:                 real(DP), intent(in):: RestartTimeChk
  1186:                                           ! リスタート開始時刻. 
  1187:                                           ! Restart time of calculation
  1188:                 real(DP), intent(in):: EndTimeChk
  1189:                                           ! 計算終了時刻. 
  1190:                                           ! End time of calculation
  1191:                 real(DP), intent(in):: DelTimeChk
  1192:                                           ! $ \Delta t $ [s]
  1193:                 real(DP), intent(in):: PredictIntTimeChk
  1194:                                           ! 終了予測日時表示間隔. 
  1195:                                           ! Interval of predicted end time output
  1196:             
  1197:                 ! 印字用作業変数
  1198:                 ! Work variables for print
  1199:                 !
  1200:                 real(DP):: RestartTimeValue_print
  1201:                 real(DP):: EndTimeValue_print
  1202:                 real(DP):: DelTimeValue_print
  1203:                 real(DP):: PredictIntValue_print
  1204:             
  1205:                 ! 作業変数
  1206:                 ! Work variables
  1207:                 !
  1208:             
  1209:                 ! 実行文 ; Executable statement
  1210:                 !
  1211:             
  1212:                 if ( .not. 0.0_DP < ( EndTimeChk - RestartTimeChk ) ) then
  1213:                   RestartTimeValue_print = DCCalConvertByUnit( RestartTimeChk, 'sec', RestartTimeUnit ) ! (in)
  1214:                   EndTimeValue_print = DCCalConvertByUnit( EndTimeChk, 'sec', RestartTimeUnit ) ! (in)
  1215:                   
  1216:                   call MessageNotify( 'E', module_name, &
  1217:                     & 'RestartTime=<%f[%c]> is later than EndTime=<%f[%c]>', &
  1218:                     & d = (/ RestartTimeValue_print, EndTimeValue_print /), &
  1219:                     & c1 = trim(RestartTimeUnit), c2 = trim(RestartTimeUnit) )
  1220:                 end if
  1221:             
  1222:                 if ( DelTimeChk > ( EndTimeChk - RestartTimeChk ) ) then
  1223:                   RestartTimeValue_print = DCCalConvertByUnit( RestartTimeChk, 'sec', RestartTimeUnit ) ! (in)
  1224:                   EndTimeValue_print = DCCalConvertByUnit( EndTimeChk, 'sec', RestartTimeUnit ) ! (in)
  1225:                   DelTimeValue_print = DCCalConvertByUnit( DelTimeChk, 'sec', DelTimeUnit ) ! (in)
  1226:                   call MessageNotify( 'E', module_name, &
  1227:                     & 'DelTime=<%f[%c]> is larger than ' // &
  1228:                     & 'EndTime=<%f[%c]> - RestartTime=<%f[%c]>.', &
  1229:                     & d = (/ DelTimeValue_print, EndTimeValue_print, RestartTimeValue_print /), &
  1230:                     & c1 = trim(DelTimeUnit), &
  1231:                     & c2 = trim(RestartTimeUnit), c3 = trim(RestartTimeUnit) )
  1232:                 end if
  1233:             
  1234:                 if ( .not. DelTimeChk > 0.0_DP ) then
  1235:                   DelTimeValue_print = DCCalConvertByUnit( DelTimeChk, 'sec', DelTimeUnit ) ! (in)
  1236:                   call MessageNotify( 'E', module_name, &
  1237:                     & 'DelTime=<%f[%c]> must be more than 0.', &
  1238:                     & d = (/ DelTimeValue_print /), &
  1239:                     & c1 = trim(DelTimeUnit) )
  1240:                 end if
  1241:             
  1242:                 if ( .not. PredictIntTimeChk > 0.0_DP ) then
  1243:                   PredictIntValue_print = DCCalConvertByUnit( PredictIntTimeChk, 'sec', PredictIntUnit ) ! (in)
  1244:                   call MessageNotify( 'E', module_name, &
  1245:                     & 'PredictInt=<%f[%c]> must be more than 0.', &
  1246:                     & d = (/ PredictIntValue_print /), &
  1247:                     & c1 = trim(PredictIntUnit) )
  1248:                 end if
  1249:             
  1250:               end subroutine TimeValidCheck
  1251:             
  1252:               !-------------------------------------------------------------------
  1253:             
  1254:               subroutine InitCheck
  1255:                 !
  1256:                 ! 依存モジュールの初期化チェック
  1257:                 !
  1258:                 ! Check initialization of dependency modules
  1259:             
  1260:                 ! モジュール引用 ; USE statements
  1261:                 !
  1262:             
  1263:                 ! NAMELIST ファイル入力に関するユーティリティ
  1264:                 ! Utilities for NAMELIST file input
  1265:                 !
  1266:                 use namelist_util, only: namelist_util_inited
  1267:             
  1268:                 ! 実行文 ; Executable statement
  1269:                 !
  1270:             
  1271:                 if ( .not. namelist_util_inited ) &
  1272:                   & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
  1273:             
  1274:               end subroutine InitCheck
  1275:             
  1276:             end module timeset
