Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:38 2016
FILE NAME: i.sltt.F90
PROGRAM NAME: sltt
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   324  opt  (  11): Fused array assignments. :line 324 - 328
   324  opt  (1593): Loop nest collapsed into one loop.
   324  vec  (   4): Vectorized array expression.
   324  vec  (  29): ADB is used for array.: xyzf_qmixsave
   324  vec  (  29): ADB is used for array.: xyzf_qmixa
   324  vec  (  29): ADB is used for array.: xyzf_dqmixdtphy
   324  vec  (  29): ADB is used for array.: xyzf_qmixb
   355  opt  (  11): Fused array assignments. :line 355 - 358
   355  opt  (1593): Loop nest collapsed into one loop.
   355  vec  (   4): Vectorized array expression.
   355  vec  (  29): ADB is used for array.: xyzf_qmixlina
   355  vec  (  29): ADB is used for array.: xyzf_qmixsave
   355  vec  (  29): ADB is used for array.: xyzf_qmixa
   365  vec  (   3): Unvectorized loop.
   365  vec  (  13): Overhead of loop division is too large.
   366  opt  (1593): Loop nest collapsed into one loop.
   366  vec  (   4): Vectorized array expression.
   366  vec  (  26): Macro operation Max/Min.
   366  vec  (  29): ADB is used for array.: xyzf_qmixa
   372  vec  (   4): Vectorized array expression.
   372  vec  (  29): ADB is used for array.: f_qmixmax
   373  vec  (   3): Unvectorized loop.
   373  vec  (  13): Overhead of loop division is too large.
   374  opt  (1593): Loop nest collapsed into one loop.
   374  vec  (   4): Vectorized array expression.
   374  vec  (  29): ADB is used for array.: xyzf_qmixa
   379  opt  (1593): Loop nest collapsed into one loop.
   379  vec  (   4): Vectorized array expression.
   379  vec  (  29): ADB is used for array.: xyzf_qmixlina
   379  vec  (  29): ADB is used for array.: xyzf_qmixa
   380  opt  (  11): Fused array assignments. :line 380 - 381
   380  vec  (   4): Vectorized array expression.
   380  vec  (  29): ADB is used for array.: f_qmixlinmax
   380  vec  (  29): ADB is used for array.: f_qmixmax
   380  vec  (  29): ADB is used for array.: f_qmixlinprocmax
   380  vec  (  29): ADB is used for array.: f_qmixprocmax
   387  opt  (  11): Fused array assignments. :line 387 - 396
   387  opt  (1592): Outer loop unrolled inside inner loop.
   387  vec  (   4): Vectorized array expression.
   387  vec  (  29): ADB is used for array.: xyzf_qmixa
   387  vec  (  29): ADB is used for array.: xyzf_qmixmina
   387  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
   387  vec  (   4): Vectorized array expression.
   387  vec  (  29): ADB is used for array.: xyzf_qmixa
   387  vec  (  29): ADB is used for array.: xyzf_qmixmina
   387  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
   460  vec  (   3): Unvectorized loop.
   460  vec  (  13): Overhead of loop division is too large.
   461  opt  (1593): Loop nest collapsed into one loop.
   461  vec  (   4): Vectorized array expression.
   461  vec  (  26): Macro operation Max/Min.
   461  vec  (  29): ADB is used for array.: xyzf_qmixa
   467  vec  (   4): Vectorized array expression.
   467  vec  (  29): ADB is used for array.: f_qmixmax
   468  vec  (   3): Unvectorized loop.
   468  vec  (  13): Overhead of loop division is too large.
   469  opt  (1593): Loop nest collapsed into one loop.
   469  vec  (   4): Vectorized array expression.
   469  vec  (  29): ADB is used for array.: xyzf_qmixa
   473  vec  (   3): Unvectorized loop.
   473  vec  (  13): Overhead of loop division is too large.
   474  opt  (1593): Loop nest collapsed into one loop.
   474  vec  (   4): Vectorized array expression.
   474  vec  (  26): Macro operation Max/Min.
   474  vec  (  29): ADB is used for array.: xyzf_qmixlina
   480  vec  (   4): Vectorized array expression.
   480  vec  (  29): ADB is used for array.: f_qmixlinmax
   481  vec  (   3): Unvectorized loop.
   481  vec  (  13): Overhead of loop division is too large.
   482  opt  (1593): Loop nest collapsed into one loop.
   482  vec  (   4): Vectorized array expression.
   482  vec  (  29): ADB is used for array.: xyzf_qmixlina
   490  vec  (   3): Unvectorized loop.
   490  vec  (  13): Overhead of loop division is too large.
   491  opt  (1593): Loop nest collapsed into one loop.
   491  vec  (   4): Vectorized array expression.
   491  vec  (  29): ADB is used for array.: xyzf_qmixa
   494  vec  (   3): Unvectorized loop.
   494  vec  (  13): Overhead of loop division is too large.
   495  opt  (1593): Loop nest collapsed into one loop.
   495  vec  (   4): Vectorized array expression.
   495  vec  (  29): ADB is used for array.: xyzf_qmixlina
   500  opt  (  11): Fused array assignments. :line 500 - 501
   500  opt  (1593): Loop nest collapsed into one loop.
   500  vec  (   4): Vectorized array expression.
   500  vec  (  29): ADB is used for array.: xyzf_qmixlinatentative
   500  vec  (  29): ADB is used for array.: xyzf_qmixlina
   500  vec  (  29): ADB is used for array.: xyzf_dqmixdthormassfix
   508  opt  (  11): Fused array assignments. :line 508 - 519
   508  opt  (1592): Outer loop unrolled inside inner loop.
   508  vec  (   4): Vectorized array expression.
   508  vec  (  29): ADB is used for array.: xyzf_qmixa
   508  vec  (  29): ADB is used for array.: xyzf_qmixmina
   508  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
   508  vec  (   4): Vectorized array expression.
   508  vec  (  29): ADB is used for array.: xyzf_qmixa
   508  vec  (  29): ADB is used for array.: xyzf_qmixmina
   508  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
   558  vec  (   3): Unvectorized loop.
   558  vec  (  13): Overhead of loop division is too large.
   559  opt  (1593): Loop nest collapsed into one loop.
   559  vec  (   4): Vectorized array expression.
   559  vec  (  29): ADB is used for array.: xyzf_qmixa
   562  vec  (   3): Unvectorized loop.
   562  vec  (  13): Overhead of loop division is too large.
   563  opt  (1593): Loop nest collapsed into one loop.
   563  vec  (   4): Vectorized array expression.
   563  vec  (  29): ADB is used for array.: xyzf_qmixlina
   620  opt  (1593): Loop nest collapsed into one loop.
   620  vec  (   4): Vectorized array expression.
   620  vec  (  29): ADB is used for array.: xyzf_qmixa
   630  opt  (  11): Fused array assignments. :line 630 - 633
   630  opt  (1593): Loop nest collapsed into one loop.
   630  vec  (   4): Vectorized array expression.
   630  vec  (  29): ADB is used for array.: xyzf_dqmixdttotmassfix
   630  vec  (  29): ADB is used for array.: xyzf_qmixa
   630  vec  (  29): ADB is used for array.: xyzf_dqmixdtvermassfix
   637  vec  (   3): Unvectorized loop.
   638  opt  (1017): Subroutine call prevents optimization.
   638  vec  (   9): Vectorization obstructive statement.
   638  vec  (  10): Vectorization obstructive procedure reference.:historyautoputdouble3
   640  vec  (   9): Vectorization obstructive statement.
   640  vec  (  10): Vectorization obstructive procedure reference.:historyautoputdouble3
   642  vec  (   9): Vectorization obstructive statement.
   642  vec  (  10): Vectorization obstructive procedure reference.:historyautoputdouble3
   647  warn (  82): Name "xyz_utest" is not used.
   647  warn (  82): Name "xyz_vtest" is not used.
   647  warn (  82): Name "xyr_sigdottest" is not used.
   804  warn (   7): Characters in a line over this form limitation.
   842  vec  (   3): Unvectorized loop.
   843  opt  (1017): Subroutine call prevents optimization.
   843  opt  (1592): Outer loop unrolled inside inner loop.
   843  vec  (   4): Vectorized array expression.
   843  vec  (  29): ADB is used for array.: wzf_qmix
   843  vec  (   4): Vectorized array expression.
   843  vec  (  29): ADB is used for array.: wzf_qmix
   845  opt  (1592): Outer loop unrolled inside inner loop.
   845  vec  (   4): Vectorized array expression.
   845  vec  (  29): ADB is used for array.: xyzf_qmix_dlat
   845  vec  (   4): Vectorized array expression.
   845  vec  (  29): ADB is used for array.: xyzf_qmix_dlat
   847  opt  (1592): Outer loop unrolled inside inner loop.
   847  vec  (   4): Vectorized array expression.
   847  vec  (  29): ADB is used for array.: wzf_qmix_dlon
   847  vec  (   4): Vectorized array expression.
   847  vec  (  29): ADB is used for array.: wzf_qmix_dlon
   849  opt  (  11): Fused array assignments. :line 849 - 851
   849  vec  (   4): Vectorized array expression.
   849  vec  (  29): ADB is used for array.: xyzf_qmix_dlonlat
   849  vec  (  29): ADB is used for array.: xyzf_qmix_dlon
   851  warn (   7): Characters in a line over this form limitation.
   869  warn (   7): Characters in a line over this form limitation.
   887  warn (   7): Characters in a line over this form limitation.
   905  warn (   7): Characters in a line over this form limitation.
   963  warn (   7): Characters in a line over this form limitation.
   963  warn (   7): Characters in a line over this form limitation.
   963  warn (   7): Characters in a line over this form limitation.
   963  warn (   7): Characters in a line over this form limitation.
   963  warn (   7): Characters in a line over this form limitation.
  1037  opt  (1592): Outer loop unrolled inside inner loop.
  1037  vec  (   4): Vectorized array expression.
  1037  vec  (  29): ADB is used for array.: xyzf_qmixas
  1037  vec  (   4): Vectorized array expression.
  1037  vec  (  29): ADB is used for array.: xyzf_qmixas
  1038  opt  (1592): Outer loop unrolled inside inner loop.
  1038  vec  (   4): Vectorized array expression.
  1038  vec  (  29): ADB is used for array.: xyzf_qmixan
  1038  vec  (   4): Vectorized array expression.
  1038  vec  (  29): ADB is used for array.: xyzf_qmixan
  1054  opt  (1593): Loop nest collapsed into one loop.
  1054  vec  (   4): Vectorized array expression.
  1054  vec  (  29): ADB is used for array.: xyzf_qmixlina
  1054  vec  (  29): ADB is used for array.: xyzf_qmixas
  1055  opt  (1593): Loop nest collapsed into one loop.
  1055  vec  (   4): Vectorized array expression.
  1055  vec  (  29): ADB is used for array.: xyzf_qmixlina
  1055  vec  (  29): ADB is used for array.: xyzf_qmixan
  1078  opt  (1593): Loop nest collapsed into one loop.
  1078  vec  (   4): Vectorized array expression.
  1078  vec  (  29): ADB is used for array.: xyzf_qmixmina
  1078  vec  (  29): ADB is used for array.: xyzf_qmixminas
  1079  opt  (  11): Fused array assignments. :line 1079 - 1080
  1079  opt  (1593): Loop nest collapsed into one loop.
  1079  vec  (   4): Vectorized array expression.
  1079  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
  1079  vec  (  29): ADB is used for array.: xyzf_qmixmaxas
  1079  vec  (  29): ADB is used for array.: xyzf_qmixmina
  1079  vec  (  29): ADB is used for array.: xyzf_qmixminan
  1081  opt  (1593): Loop nest collapsed into one loop.
  1081  vec  (   4): Vectorized array expression.
  1081  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
  1081  vec  (  29): ADB is used for array.: xyzf_qmixmaxan
  1086  warn (  82): Name "ii" is not used.
  1086  warn (  82): Name "i" is not used.
  1086  warn (  82): Name "j" is not used.
  1086  warn (  82): Name "k" is not used.
  1192  opt  (1592): Outer loop unrolled inside inner loop.
  1192  vec  (   4): Vectorized array expression.
  1192  vec  (  29): ADB is used for array.: xyzf_qmixlin
  1192  vec  (   4): Vectorized array expression.
  1192  vec  (  29): ADB is used for array.: xyzf_qmixlin
  1194  opt  (1593): Loop nest collapsed into one loop.
  1194  vec  (   4): Vectorized array expression.
  1194  vec  (  29): ADB is used for array.: xyzf_qmix
  1211  vec  (   4): Vectorized array expression.
  1211  vec  (  29): ADB is used for array.: z_sigma
  1217  opt  (  11): Fused array assignments. :line 1217 - 1218
  1217  opt  (1593): Loop nest collapsed into one loop.
  1217  vec  (   4): Vectorized array expression.
  1217  vec  (  29): ADB is used for array.: xyzf_extqmix
  1217  vec  (  29): ADB is used for array.: xyzf_qmix
  1219  opt  (1593): Loop nest collapsed into one loop.
  1219  vec  (   4): Vectorized array expression.
  1219  vec  (  29): ADB is used for array.: xyzf_extqmix
  1219  vec  (  29): ADB is used for array.: xyzf_qmix
  1220  opt  (  11): Fused array assignments. :line 1220 - 1224
  1220  opt  (1593): Loop nest collapsed into one loop.
  1220  vec  (   4): Vectorized array expression.
  1220  vec  (  29): ADB is used for array.: xyzf_extqmix
  1220  vec  (  29): ADB is used for array.: xyzf_qmix
  1225  opt  (1593): Loop nest collapsed into one loop.
  1225  vec  (   4): Vectorized array expression.
  1226  opt  (  11): Fused array assignments. :line 1226 - 1227
  1226  opt  (1593): Loop nest collapsed into one loop.
  1226  vec  (   4): Vectorized array expression.
  1232  vec  (   3): Unvectorized loop.
  1232  vec  (  13): Overhead of loop division is too large.
  1244  opt  (1592): Outer loop unrolled inside inner loop.
  1244  vec  (   4): Vectorized array expression.
  1244  vec  (  29): ADB is used for array.: xyzf_qmix_dz
  1244  vec  (  29): ADB is used for array.: xyzf_extqmix
  1244  vec  (   4): Vectorized array expression.
  1244  vec  (  29): ADB is used for array.: xyzf_qmix_dz
  1244  vec  (  29): ADB is used for array.: xyzf_extqmix
  1249  opt  (  11): Fused array assignments. :line 1249 - 1255
  1249  opt  (1037): Feedback of array elements.
  1249  opt  (1593): Loop nest collapsed into one loop.
  1249  vec  (   4): Vectorized array expression.
  1249  vec  (  29): ADB is used for array.: xyf_f12
  1249  vec  (  29): ADB is used for array.: xyf_f21
  1249  vec  (  29): ADB is used for array.: xyf_f22
  1249  vec  (  29): ADB is used for array.: xyzf_extqmix
  1249  vec  (  29): ADB is used for array.: xyf_f11
  1251  opt  (1037): Feedback of array elements.
  1253  opt  (1037): Feedback of array elements.
  1255  opt  (1037): Feedback of array elements.
  1262  opt  (1593): Loop nest collapsed into one loop.
  1262  vec  (   4): Vectorized array expression.
  1262  vec  (  29): ADB is used for array.: xyzf_qmix_dz
  1262  vec  (  29): ADB is used for array.: xyf_f12
  1262  vec  (  29): ADB is used for array.: xyf_f21
  1262  vec  (  29): ADB is used for array.: xyf_f22
  1262  vec  (  29): ADB is used for array.: xyf_f11
  1278  opt  (1593): Loop nest collapsed into one loop.
  1278  vec  (   4): Vectorized array expression.
  1284  vec  (   4): Vectorized array expression.
  1284  vec  (  29): ADB is used for array.: xyzf_qmixa
  1284  vec  (  29): ADB is used for array.: xyzf_qmix
  1288  vec  (   4): Vectorized array expression.
  1288  vec  (  29): ADB is used for array.: xyzf_qmixlina
  1288  vec  (  29): ADB is used for array.: xyzf_qmixlinlv
  1292  opt  (  11): Fused array assignments. :line 1292 - 1293
  1292  vec  (   4): Vectorized array expression.
  1292  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
  1292  vec  (  29): ADB is used for array.: xyzf_qmix
  1292  vec  (  29): ADB is used for array.: xyzf_qmixmina
  1298  vec  (   4): Vectorized array expression.
  1298  vec  (  29): ADB is used for array.: xyzf_qmixa
  1298  vec  (  29): ADB is used for array.: xyzf_qmix
  1302  vec  (   4): Vectorized array expression.
  1302  vec  (  29): ADB is used for array.: xyzf_qmixlina
  1302  vec  (  29): ADB is used for array.: xyzf_qmixlinlv
  1306  opt  (  11): Fused array assignments. :line 1306 - 1307
  1306  vec  (   4): Vectorized array expression.
  1306  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
  1306  vec  (  29): ADB is used for array.: xyzf_qmix
  1306  vec  (  29): ADB is used for array.: xyzf_qmixmina
  1311  vec  (   1): Vectorized loop.
  1311  vec  (  29): ADB is used for array.: z_sigma
  1312  vec  (  26): Macro operation Search.
  1315  vec  (   3): Unvectorized loop.
  1316  opt  (1025): Reference to this function inhibits optimization.
  1316  vec  (  10): Vectorization obstructive procedure reference.:slttirrherintqui1dnonuni
  1324  vec  (   3): Unvectorized loop.
  1325  opt  (1025): Reference to this function inhibits optimization.
  1325  vec  (  10): Vectorization obstructive procedure reference.:slttherintcub1d
  1337  vec  (   1): Vectorized loop.
  1337  vec  (  29): ADB is used for array.: xyzf_qmixlina
  1337  vec  (  29): ADB is used for array.: xyzf_extqmixlinlv
  1347  vec  (   1): Vectorized loop.
  1347  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
  1347  vec  (  29): ADB is used for array.: xyzf_qmixmina
  1347  vec  (  29): ADB is used for array.: xyzf_qmix
  1494  vec  (   1): Vectorized loop.
  1494  vec  (  29): ADB is used for array.: x_sinlons
  1494  vec  (  29): ADB is used for array.: x_coslons
  1494  vec  (  29): ADB is used for array.: x_lons
  1494  vec  (  29): ADB is used for array.: x_lon
  1499  vec  (   1): Vectorized loop.
  1499  vec  (  29): ADB is used for array.: y_sinlats
  1499  vec  (  29): ADB is used for array.: y_coslats
  1499  vec  (  29): ADB is used for array.: y_lats
  1499  vec  (  29): ADB is used for array.: y_lat
  1511  vec  (   1): Vectorized loop.
  1511  vec  (  29): ADB is used for array.: x_sinlonn
  1511  vec  (  29): ADB is used for array.: x_coslonn
  1511  vec  (  29): ADB is used for array.: x_lonn
  1511  vec  (  29): ADB is used for array.: x_lon
  1516  vec  (   1): Vectorized loop.
  1516  vec  (  29): ADB is used for array.: y_sinlatn
  1516  vec  (  29): ADB is used for array.: y_coslatn
  1516  vec  (  29): ADB is used for array.: y_latn
  1516  vec  (  29): ADB is used for array.: y_lat
  1538  vec  (   3): Unvectorized loop.
  1539  opt  (1017): Subroutine call prevents optimization.
  1539  vec  (   9): Vectorization obstructive statement.
  1539  vec  (  10): Vectorization obstructive procedure reference.:historyautoaddvariable1
  1542  vec  (   9): Vectorization obstructive statement.
  1542  vec  (  10): Vectorization obstructive procedure reference.:historyautoaddvariable1
  1545  vec  (   9): Vectorization obstructive statement.
  1545  vec  (  10): Vectorization obstructive procedure reference.:historyautoaddvariable1
  1563  warn (  82): Name "k" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:38 2016
FILE NAME: i.sltt.F90
PROGRAM NAME: sltt
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 物質移流過程 (セミラグランジュ法)
     2  !
     3  != Semi-Lagrangian Tracer Transport scheme
     4  !
     5  ! Authors::   Hiroki KASHIMURA, Yoshiyuki O. TAKAHASHI
     6  ! Version::
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2013. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module sltt
    13    !
    14    != 物質移流 (セミラグランジュ法, Enomoto (2008) modified)
    15    !
    16    != Tracer Transport (Semi-Lagrangian method, Enomoto (2008) modified)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 物質移流を非保存型のセミラグランジュ法で演算するモジュールです.
    21    ! 上流点探索には Williamson and Rasch (1989, MWR) を
    22    ! 補間には Enomoto (2008) を応用した方法を用いています。
    23    ! すなわちスペクトルから求めた１階微分の値を利用した５次精度の変則エルミート補間です。
    24    ! 非負を保証するために arcsine 変換フィルタを用いています。
    25    ! スペクトル変換・高精度補間に由来する人工的な短波を除去するために Sun et al. (1996) の
    26    ! 単調フィルタを応用したものを部分的に用いている。
    27    !
    28    ! This is a tracer transport module. Semi-Lagrangian method (Enomoto 2008 modified)
    29    ! Arcsine transformation filter is used to avoid negative values.
    30    ! Monotonicity filter (Sun et al 1996) is partly used.
    31    !
    32    !== Procedures List
    33    !
    34    ! SLTTMain     :: 移流計算
    35    ! SLTTInit     :: 初期化
    36    ! SLTTTest     :: 移流テスト用
    37    ! ---------------------     :: ------------
    38    ! SLTTMain     :: Main subroutine for SLTT
    39    ! SLTTInit     :: Initialization for SLTT
    40    ! SLTTTest     :: Generate velocity for SLTT Test
    41    !
    42    !== NAMELIST
    43    !
    44    ! NAMELIST#
    45    !
    46    !== References
    47    !
    48    ! * Kashimura, H., T. Enomoto, Y. O. Takahashi, 2013:
    49    !   Non-negative filter using arcsine transformation for tracer advection with semi-Lagrangian scheme.
    50    !   <i>NCTAM</i>, <b>62</b>.
    51    !
    52    ! * Enomoto, T., 2008:
    53    !   Bicubic Interpolation with Spectral Derivatives.
    54    !   <i>SOLA</i>, <b>4</b>, 5-8. doi:10.2151/sola.2008-002
    55    !
    56    ! * Williamson, D. L., and Rasch, P. J., 1989:
    57    !   Two-dimensional semi-Lagrangian transport with shape-preserving interpolation.
    58    !   <i> Mon. Wea. Rev.</i>, <b>117</b>, 102-129.
    59    !
    60    ! * Sun, W.-Y., Yeh, K.-S., and Sun, R.-Y., 1996:
    61    !   A simple semi-Lagrangian scheme for advection equations.
    62    !   <i>Quarterly Journal of the Royal Meteorological Society</i>,
    63    !   <b>122(533)</b>, 1211-1226. doi:10.1002/qj.49712253310
    64  
    65    ! モジュール引用 ; USE statements
    66    !
    67    ! 種別型パラメタ
    68    ! Kind type parameter
    69    !
    70    use dc_types, only: DP,  & ! 倍精度実数型. Double precision.
    71      &                 TOKEN  ! キーワード.   Keywords.
    72  
    73    ! メッセージ出力
    74    ! Message output
    75    !
    76    use dc_message, only: MessageNotify
    77  
    78    !
    79    ! MPI
    80    !
    81    use mpi_wrapper, only : MPIWrapperFindMaxVal
    82  
    83    ! 時刻管理
    84    ! Time control
    85    !
    86    use timeset, only: &
    87      & DelTime
    88  
    89    ! 格子点設定
    90    ! Grid points settings
    91    !
    92    use gridset, only:       &
    93      &                imax, & ! 経度格子点数.
    94                               ! Number of grid points in longitude
    95      &                jmax, & ! 緯度格子点数.
    96                               ! Number of grid points in latitude
    97      &                kmax, & ! 鉛直層数.
    98                               ! Number of vertical level
    99      &                lmax    ! スペクトルデータの配列サイズ
   100                               ! Size of array for spectral data
   101  
   102    ! 組成に関わる配列の設定
   103    ! Settings of array for atmospheric composition
   104    !
   105    use composition, only:                              &
   106      &                    ncmax,                       &
   107                               ! 成分の数
   108                               ! Number of composition
   109      &                    CompositionInqFlagAdv
   110  
   111    ! 質量の補正
   112    ! Mass fixer
   113    !
   114    use mass_fixer, only: &
   115      & MassFixerBC02, MassFixerBC02Layer, MassFixerBC02Column, &
   116      & MassFixer, MassFixerR95, MassFixerWO94, MassFixerColumn!, MassFixerLayer
   117  
   118  
   119    ! 宣言文 ; Declaration statements
   120    !
   121    implicit none
   122    private
   123  
   124    ! 公開手続き
   125    ! Public procedure
   126    !
   127    public :: SLTTInit
   128    public :: SLTTMain
   129  
   130  
   131  
   132    ! 公開変数
   133    ! Public variables
   134    !
   135  
   136    ! 非公開変数
   137    ! Private variables
   138    !
   139    logical, save :: sltt_inited = .false.
   140                                ! 初期設定フラグ.
   141                                ! Initialization flag
   142  
   143    real(DP)    , save, allocatable :: x_LonS   (:)
   144                                ! $\lambda_S$ 南半球の経度。
   145                                ! longitude in SH.
   146    real(DP)    , save, allocatable :: x_SinLonS(:)
   147                                ! $\sin\lambda_S$
   148    real(DP)    , save, allocatable :: x_CosLonS(:)
   149                                ! $\cos\lambda_S$
   150    real(DP)    , save, allocatable :: y_LatS   (:)
   151                                ! $\varphi_S$ 南半球の緯度。
   152                                ! latitude in SH.
   153    real(DP)    , save, allocatable :: y_SinLatS(:)
   154                                ! $\sin\varphai_S$
   155    real(DP)    , save, allocatable :: y_CosLatS(:)
   156                                ! $\cos\varphai_S$
   157    real(DP)    , save, allocatable :: x_ExtLonS(:)
   158                                ! $ x_LonSの拡張配列。
   159                                !Extended array of x_LonS.
   160    real(DP)    , save, allocatable :: y_ExtLatS(:)
   161                                ! $ x_LatSの拡張配列。
   162                                !Extended array of x_LatS.
   163  
   164    real(DP)    , save, allocatable :: x_LonN   (:)
   165                                ! $\lambda_N$ 北半球の経度。
   166                                ! longitude in NH.
   167    real(DP)    , save, allocatable :: x_SinLonN(:)
   168                                ! $\sin\lambda_N$
   169    real(DP)    , save, allocatable :: x_CosLonN(:)
   170                                ! $\cos\lambda_N$
   171    real(DP)    , save, allocatable :: y_LatN   (:)
   172                                ! $\varphi_N$ 北半球の緯度。
   173                                ! latitude in NH.
   174    real(DP)    , save, allocatable :: y_SinLatN(:)
   175                                ! $\sin\varphai_N$
   176    real(DP)    , save, allocatable :: y_CosLatN(:)
   177                                ! $\cos\varphai_N$
   178    real(DP)    , save, allocatable :: x_ExtLonN(:)
   179                                ! $ x_LonNの拡張配列。
   180                                !Extended array of x_LonN.
   181    real(DP)    , save, allocatable :: y_ExtLatN(:)
   182                                ! $ x_LatNの拡張配列。
   183                                !Extended array of x_LatN.
   184    logical, save                   :: FlagSLTTArcsineHor
   185    logical, save                   :: FlagSLTTArcsineVer
   186                               ! Arcsine変換の非負フィルタフラグ
   187                               ! Flag for non-negative filter using arcsine trasformation
   188    real(DP), save                  :: SLTTArcSineFactor
   189  
   190    character(TOKEN), save          :: SLTTIntHor
   191                               ! 水平方向の補間方法を指定するキーワード
   192                               ! Keyword for Interpolation Method for Horizontal direction
   193    character(TOKEN), save          :: SLTTIntVer
   194                               ! 鉛直方向の補間方法を指定するキーワード
   195                               ! Keyword for Interpolation Method for Vertical direction
   196  
   197  
   198    character(*), parameter:: module_name = 'sltt'
   199                                ! モジュールの名称.
   200                                ! Module name
   201    character(*), parameter:: version = &
   202      & '$Name:  $' // &
   203      & '$Id: sltt.F90,v 1.8 2014/06/29 07:21:28 yot Exp $'
   204                                ! モジュールのバージョン
   205                                ! Module version
   206  
   207  
   208    !--------------------------------------------------------------------------------------
   209  
   210  contains
   211  
   212    !--------------------------------------------------------------------------------------
   213  
   214    subroutine SLTTMain(             &
   215      & xyr_PressB, xyr_PressA,      & !(in )
   216      & xyz_UN, xyz_VN, xyr_SigDotN, & !(in )
   217      & xyzf_DQMixDtPhy,             & !(in )
   218      & xyzf_QMixB,                  & !(in )
   219      & xyzf_QMixA                   & !(out)
   220      & )
   221      ! セミラグランジュ法による物質移流計算を行う。
   222      ! Calculates tracer transports by Semi-Lagrangian method
   223  
   224      ! ヒストリデータ出力
   225      ! History data output
   226      !
   227      use gtool_historyauto, only: HistoryAutoPut
   228  
   229      use timeset    , only : &
   230        & TimeN, &
   231        & DelTime
   232                                ! $\Delta t$
   233  
   234      ! 組成に関わる配列の設定
   235      ! Settings of array for atmospheric composition
   236      !
   237      use composition, only:                              &
   238        &                    ncmax,                       &
   239                               ! 成分の数
   240                               ! Number of composition
   241        &                    a_QMixName,                  &
   242                               ! 成分の変数名
   243                               ! Name of variables for composition
   244        &                    CompositionInqFlagAdv
   245  
   246  !!$    ! 座標データ設定
   247  !!$    ! Axes data settings
   248  !!$    !
   249  !!$    use axesset, only: &
   250  !!$      & z_DelSigma            ! $ \Delta \sigma $ (整数).
   251  !!$                              ! $ \Delta \sigma $ (Full)
   252  
   253      real(DP), intent(in ) :: xyr_PressB(0:imax-1, 1:jmax, 0:kmax)
   254                                !
   255                                ! Pressure at current time step
   256      real(DP), intent(in ) :: xyr_PressA(0:imax-1, 1:jmax, 0:kmax)
   257                                !
   258                                ! Pressure at next time step
   259      real(DP), intent(in ) :: xyz_UN    (0:imax-1, 1:jmax, 1:kmax)
   260                                ! 東西風速
   261                                ! Zonal Wind
   262      real(DP), intent(in ) :: xyz_VN    (0:imax-1, 1:jmax, 1:kmax)
   263                                ! 南北風速
   264                                ! Meridional Wind
   265      real(DP), intent(in ) :: xyr_SigDotN(0:imax-1, 1:jmax, 0:kmax)
   266                                ! 鉛直流速（SigmaDot）
   267      real(DP), intent(in ):: xyzf_DQMixDtPhy(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   268                                ! $ \left(\DP{q}{t}\right)^{phy} $ .
   269                                ! 外力項 (物理過程) による比湿変化.
   270                                ! Temperature tendency by external force terms (physical processes)
   271      real(DP), intent(in ) :: xyzf_QMixB(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   272                                ! 物質混合比
   273                                ! Mix ratio of the tracers
   274      real(DP), intent(out) :: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   275                                ! 物質混合比
   276                                ! Mix ratio of the tracers
   277  
   278      ! 作業変数
   279      ! Work variables
   280      !
   281      real(DP) :: f_QMixMax(1:ncmax)
   282                                ! 各物質混合比の最大値
   283                                ! Maximum of each mix ratio of the tracers
   284      real(DP) :: f_QMixProcMax(1:ncmax)
   285                                ! 各物質混合比のプロセス内最大値
   286                                ! Maximum of each mix ratio of the tracers in each process
   287      real(DP) :: f_QMixLinMax(1:ncmax)
   288      real(DP) :: f_QMixLinProcMax(1:ncmax)
   289  
   290      integer:: n               ! 組成方向に回る DO ループ用作業変数
   291                                ! Work variables for DO loop in dimension of constituents
   292  
   293      real(DP) :: xyz_UTest    (0:imax-1, 1:jmax, 1:kmax)
   294                                ! 東西風速（テスト用）
   295                                ! Zonal Wind (for test)
   296      real(DP) :: xyz_VTest    (0:imax-1, 1:jmax, 1:kmax)
   297                                ! 南北風速（テスト用）
   298                                ! Meridional Wind (for test)
   299      real(DP) :: xyr_SigDotTest(0:imax-1, 1:jmax, 0:kmax)
   300                                ! 鉛直流速（テスト用）;SigmaDot (for test)
   301      real(DP) :: xyzf_QMixSave(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   302  
   303      real(DP) :: xyzf_QMixLinATentative(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   304      real(DP) :: xyzf_QMixLinA         (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   305  
   306      ! Variables for monotone limiter
   307      real(DP) :: xyzf_QMixMinA         (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   308      real(DP) :: xyzf_QMixMaxA         (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   309  
   310      real(DP) :: xyzf_QMixSaveMassFix  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   311      real(DP) :: xyzf_DQMixDtHorMassFix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   312      real(DP) :: xyzf_DQMixDtVerMassFix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   313      real(DP) :: xyzf_DQMixDtTotMassFix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   314  
   315  !!$    real(DP) :: xyrf_QMixA(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   316  !!$
   317  !!$    integer :: k
   318  
   319  
   320      ! セミラグランジュ法による物質移流計算
   321      ! Semi-Lagrangian method for tracer transport
   322  !!$!      xyzf_QMixA = xyzf_QMixB !テスト用
   323  !!$      xyzf_QMixA = xyzf_QMixB + xyzf_DQMixDtPhy * DelTime
   324      xyzf_QMixA = xyzf_QMixB + xyzf_DQMixDtPhy * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t817 = 1, ncmax*kmax*jmax*imax                                 
     .           xyzf_qmixa(t817-1,1,1,1) = xyzf_qmixb(t817-1,1,1,1) +          
     .       1      xyzf_dqmixdtphy(t817-1,1,1,1)*2.00000000000000e+000*deltime 
     .           xyzf_qmixsave(t817-1,1,1,1) = xyzf_qmixa(t817-1,1,1,1)         
     .        enddo                                                             
   325  
   326  
   327      ! Save a variable for mass fixer
   328      xyzf_QMixSave = xyzf_QMixA
   329  
   330  
   331      ! Mass fixer
   332      !   Constituents
   333      !
   334  !!$!        call MassFixer(                  &
   335  !!$    call MassFixerColumn(                  &
   336  !!$!          & xyr_PressA,                  & ! (in)
   337  !!$      & xyr_PressB,                  & ! (in)
   338  !!$      & xyzf_QMixA,                  & ! (inout)
   339  !!$      & xyr_PressRef = xyr_PressB,   & ! (in) optional
   340  !!$!          & xyzf_QMixRef = ( xyzf_QMixB+xyzf_DQMixDtPhy*DelTime ) & ! (in) optional
   341  !!$!      & xyzf_QMixRef = ( xyzf_QMixB+xyzf_DQMixDtPhy*2.0_DP*DelTime ) & ! (in) optional
   342  !!$      & xyzf_QMixRef = xyzf_QMixSave & ! (in) optional
   343  !!$      & )
   344      !
   345  !!$      call MassFixer(                   &
   346        call MassFixerColumn(             &
   347          & xyr_PressB,                   & ! (in)
   348          & xyzf_QMixA,                   & ! (inout)
   349          & xyr_PressRef = xyr_PressB,    & ! (in) optional
   350          & xyzf_QMixRef = xyzf_QMixSave  & ! (in) optional
   351          & )
   352  
   353  
   354      ! Save a variable for mass fixer
   355      xyzf_QMixSave = xyzf_QMixA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t845 = 1, xyzf_qmixsave.DSC.U4*xyzf_qmixsave.DSC.U3*           
     .       1   xyzf_qmixsave.DSC.U2*(xyzf_qmixsave.DSC.U1 + 1)                
     .           xyzf_qmixsave(t845-1,1,1,1) = xyzf_qmixa(t845-1,1,1,1)         
     .           xyzf_qmixlina(t845-1,1,1,1) = xyzf_qmixa(t845-1,1,1,1)         
     .        enddo                                                             
   356  
   357      ! Variable for linear interpolation
   358      xyzf_QMixLinA = xyzf_QMixA
   359  
   360  
   361      if ( FlagSLTTArcsineHor ) then
   362        ! 非負を保証するための arcsine変換フィルタ
   363        ! Arcsine transformation for non-negative filter
   364  
   365        do n = 1, ncmax
   366          f_QMixProcMax(n) = maxval( xyzf_QMixA(:,:,:,n) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t428 = 1, kmax*jmax*imax                                       
     .           t426 = max(xyzf_qmixa(t428-1,1,1,n),t426)                      
     .        enddo                                                             
   367        end do
   368        call MPIWrapperFindMaxVal( &
   369          & ncmax, f_QMixProcMax,  & ! (in)
   370          & f_QMixMax              & ! (out)
   371          & )
   372        f_QMixMax = f_QMixMax * SLTTArcSineFactor + 1.0e-14_DP
   373        do n = 1, ncmax
   374          xyzf_QMixA(:,:,:,n) = &
     .           d1 = 2.00000000000000e+000/f_qmixmax(n)                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1077 = 1, kmax*jmax*imax                                      
     .           xyzf_qmixa(t1077-1,1,1,n) = 5.00000000000000e-001*dasin(       
     .       1      xyzf_qmixa(t1077-1,1,1,n)*d1-1.00000000000000e+000)         
     .        enddo                                                             
   375            & 0.5_DP*(asin(2.0_DP*xyzf_QMixA(:,:,:,n)/f_QMixMax(n) - 1.0_DP))
   376        end do
   377  
   378        ! arcsine transformed variable is used for linear interpolation too
   379        xyzf_QMixLinA    = xyzf_QMixA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1089 = 1, xyzf_qmixlina.DSC.U4*xyzf_qmixlina.DSC.U3*          
     .       1   xyzf_qmixlina.DSC.U2*(xyzf_qmixlina.DSC.U1 + 1)                
     .           xyzf_qmixlina(t1089-1,1,1,1) = xyzf_qmixa(t1089-1,1,1,1)       
     .        enddo                                                             
   380        f_QMixLinProcMax = f_QMixProcMax
   381        f_QMixLinMax     = f_QMixMax
   382      end if
   383  
   384      ! 水平セミラグ
   385      ! Horizontal
   386  !!$    xyzf_QMixA = SLTTHorAdv( xyzf_QMixA, xyz_UN, xyz_VN )
   387      xyzf_QMixA = SLTTHorAdv( xyzf_QMixA, xyz_UN, xyz_VN,    & ! (in)
     .           if (jmax .gt. 0) then                                          
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t873 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t875 = 1, imax                                           
     .                 xyzf_qmixa1 = %000389(t875-1,t873,t871+1,t869+1)         
     .                 xyzf_qmixa(t875-1,t873,t871+1,t869+1) = max(min(         
     .       1            xyzf_qmixa1,xyzf_qmixmaxa(t875-1,t873,t871+1,t869+1)),
     .       2            xyzf_qmixmina(t875-1,t873,t871+1,t869+1))             
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t873 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t875 = 1, imax                                           
     .                 xyzf_qmixa(t875-1,t873,t871+1,t869+1) = %000389(t875-1,  
     .       1            t873,t871+1,t869+1)                                   
     .                 xyzf_qmixa(t875-1,t873+1,t871+1,t869+1) = %000389(t875-1,
     .       1            t873+1,t871+1,t869+1)                                 
     .                 xyzf_qmixa(t875-1,t873+2,t871+1,t869+1) = %000389(t875-1,
     .       1            t873+2,t871+1,t869+1)                                 
     .                 xyzf_qmixa(t875-1,t873+3,t871+1,t869+1) = %000389(t875-1,
     .       1            t873+3,t871+1,t869+1)                                 
     .                 xyzf_qmixa(t875-1,t873,t871+1,t869+1) = max(min(         
     .       1            xyzf_qmixa(t875-1,t873,t871+1,t869+1),xyzf_qmixmaxa(  
     .       2            t875-1,t873,t871+1,t869+1)),xyzf_qmixmina(t875-1,t873,
     .       3            t871+1,t869+1))                                       
     .                 xyzf_qmixa(t875-1,t873+1,t871+1,t869+1) = max(min(       
     .       1            xyzf_qmixa(t875-1,t873+1,t871+1,t869+1),xyzf_qmixmaxa(
     .       2            t875-1,t873+1,t871+1,t869+1)),xyzf_qmixmina(t875-1,   
     .       3            t873+1,t871+1,t869+1))                                
     .                 xyzf_qmixa(t875-1,t873+2,t871+1,t869+1) = max(min(       
     .       1            xyzf_qmixa(t875-1,t873+2,t871+1,t869+1),xyzf_qmixmaxa(
     .       2            t875-1,t873+2,t871+1,t869+1)),xyzf_qmixmina(t875-1,   
     .       3            t873+2,t871+1,t869+1))                                
     .                 xyzf_qmixa(t875-1,t873+3,t871+1,t869+1) = max(min(       
     .       1            xyzf_qmixa(t875-1,t873+3,t871+1,t869+1),xyzf_qmixmaxa(
     .       2            t875-1,t873+3,t871+1,t869+1)),xyzf_qmixmina(t875-1,   
     .       3            t873+3,t871+1,t869+1))                                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   388        &                      xyzf_QMixLinA = xyzf_QMixLinA, & ! (inout) optional
   389        &                      xyzf_QMixMinA = xyzf_QMixMinA, & ! (out) optional
   390        &                      xyzf_QMixMaxA = xyzf_QMixMaxA  ) ! (out) optional
   391  
   392      ! Monotonic filter
   393      ! see Diamantakis and Flemming (2014) for BS limiter
   394      ! but limiter is applied separately in horizontal and vertical directions
   395  
   396      xyzf_QMixA = max( min( xyzf_QMixA, xyzf_QMixMaxA ), xyzf_QMixMinA )
   397  
   398  
   399  
   400      !==================================================
   401      ! Calculation in a case in which mass fixer applied in horizontal and
   402      ! vertical directions separately
   403      !
   404  !!$    if (FlagSLTTArcsine) then
   405  !!$      ! 非負を保証するための arcsine変換フィルタ（逆変換）
   406  !!$      ! Arcsine transformation for non-negative filter
   407  !!$      do n = 1, ncmax
   408  !!$        xyzf_QMixA(:,:,:,n) = &
   409  !!$          & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixA(:,:,:,n))+1.0_DP)
   410  !!$!        xyzf_QMixLinA(:,:,:,n) = &
   411  !!$!          & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixLinA(:,:,:,n))+1.0_DP)
   412  !!$      enddo
   413  !!$    endif
   414  !!$    !
   415  !!$    xyzf_QMixSaveMassFix = xyzf_QMixA
   416  !!$    !
   417  !!$    call MassFixerBC02Layer(   &
   418  !!$      & xyr_PressA,            & ! (in)
   419  !!$      & xyzf_QMixA,            & ! (inout)
   420  !!$      & xyzf_QMixLinA,         & ! (in)
   421  !!$      & xyr_PressB,            & ! (in)
   422  !!$      & xyzf_QMixSave          & ! (in)
   423  !!$      & )
   424  !!$    !
   425  !!$    xyzf_DQMixDtHorMassFix = &
   426  !!$      & ( xyzf_QMixA - xyzf_QMixSaveMassFix ) / ( 2.0_DP * DelTime )
   427  !!$    !
   428  !!$    ! Save a variable for mass fixer
   429  !!$    xyzf_QMixSave = xyzf_QMixA
   430  !!$    !
   431  !!$    ! Variable for linear interpolation
   432  !!$    xyzf_QMixLinATentative = xyzf_QMixA
   433  !!$    !
   434  !!$    if (FlagSLTTArcsine) then
   435  !!$      ! 非負を保証するための arcsine変換フィルタ
   436  !!$      ! Arcsine transformation for non-negative filter
   437  !!$      !
   438  !!$      do n = 1, ncmax
   439  !!$        f_QMixProcMax(n) = maxval( xyzf_QMixA(:,:,:,n) )
   440  !!$      end do
   441  !!$      call MPIWrapperFindMaxVal( &
   442  !!$        & ncmax, f_QMixProcMax,  & ! (in)
   443  !!$        & f_QMixMax              & ! (out)
   444  !!$        & )
   445  !!$      f_QMixMax = f_QMixMax * SLTTArcSineFactor + 1.0e-14_DP
   446  !!$      do n = 1, ncmax
   447  !!$        xyzf_QMixA(:,:,:,n) = &
   448  !!$          & 0.5_DP*(asin(2.0_DP*xyzf_QMixA(:,:,:,n)/f_QMixMax(n) - 1.0_DP))
   449  !!$      end do
   450  !!$    end if
   451      !==================================================
   452      ! Calculation in a case in which mass fixer applied in horizontal and
   453      ! vertical directions in a same time
   454      !
   455  
   456      if ( ( .not. FlagSLTTArcsineHor ) .and. ( FlagSLTTArcsineVer ) ) then
   457        ! 非負を保証するための arcsine変換フィルタ
   458        ! Arcsine transformation for non-negative filter
   459  
   460        do n = 1, ncmax
   461          f_QMixProcMax(n) = maxval( xyzf_QMixA(:,:,:,n) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t510 = 1, kmax*jmax*imax                                       
     .           t508 = max(xyzf_qmixa(t510-1,1,1,n),t508)                      
     .        enddo                                                             
   462        end do
   463        call MPIWrapperFindMaxVal( &
   464          & ncmax, f_QMixProcMax,  & ! (in)
   465          & f_QMixMax              & ! (out)
   466          & )
   467        f_QMixMax = f_QMixMax * SLTTArcSineFactor + 1.0e-14_DP
   468        do n = 1, ncmax
   469          xyzf_QMixA(:,:,:,n) = &
     .           d3 = 2.00000000000000e+000/f_qmixmax(n)                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1045 = 1, kmax*jmax*imax                                      
     .           xyzf_qmixa(t1045-1,1,1,n) = 5.00000000000000e-001*dasin(       
     .       1      xyzf_qmixa(t1045-1,1,1,n)*d3-1.00000000000000e+000)         
     .        enddo                                                             
   470            & 0.5_DP*(asin(2.0_DP*xyzf_QMixA(:,:,:,n)/f_QMixMax(n) - 1.0_DP))
   471        end do
   472  
   473        do n = 1, ncmax
   474          f_QMixLinProcMax(n) = maxval( xyzf_QMixLinA(:,:,:,n) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t558 = 1, xyzf_qmixlina.DSC.U3*(xyzf_qmixlina.DSC.U2*          
     .       1   xyzf_qmixlina.DSC.U1 + xyzf_qmixlina.DSC.U2)                   
     .           t556 = max(xyzf_qmixlina(t558-1,1,1,n),t556)                   
     .        enddo                                                             
   475        end do
   476        call MPIWrapperFindMaxVal( &
   477          & ncmax, f_QMixLinProcMax,  & ! (in)
   478          & f_QMixLinMax              & ! (out)
   479          & )
   480        f_QMixLinMax = f_QMixLinMax * SLTTArcSineFactor + 1.0e-14_DP
   481        do n = 1, ncmax
   482          xyzf_QMixLinA(:,:,:,n) = &
     .           d4 = 2.00000000000000e+000/f_qmixlinmax(n)                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1061 = 1, xyzf_qmixlina.DSC.U3*(xyzf_qmixlina.DSC.U2*         
     .       1   xyzf_qmixlina.DSC.U1 + xyzf_qmixlina.DSC.U2)                   
     .           xyzf_qmixlina(t1061-1,1,1,n) = 5.00000000000000e-001*dasin(    
     .       1      xyzf_qmixlina(t1061-1,1,1,n)*d4-1.00000000000000e+000)      
     .        enddo                                                             
   483            & 0.5_DP*(asin(2.0_DP*xyzf_QMixLinA(:,:,:,n)/f_QMixLinMax(n) - 1.0_DP))
   484        end do
   485  
   486      else if ( ( FlagSLTTArcsineHor ) .and. ( .not. FlagSLTTArcsineVer ) ) then
   487        ! 非負を保証するための arcsine変換フィルタ（逆変換）
   488        ! Arcsine transformation for non-negative filter
   489  
   490        do n = 1, ncmax
   491          xyzf_QMixA(:,:,:,n) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1017 = 1, kmax*jmax*imax                                      
     .           xyzf_qmixa(t1017-1,1,1,n) = f_qmixmax(n)*5.00000000000000e-001*
     .       1      (dsin(2.00000000000000e+000*xyzf_qmixa(t1017-1,1,1,n))+     
     .       2      1.00000000000000e+000)                                      
     .        enddo                                                             
   492            & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixA(:,:,:,n))+1.0_DP)
   493        end do
   494        do n = 1, ncmax
   495          xyzf_QMixLinA(:,:,:,n) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1029 = 1, xyzf_qmixlina.DSC.U3*(xyzf_qmixlina.DSC.U2*         
     .       1   xyzf_qmixlina.DSC.U1 + xyzf_qmixlina.DSC.U2)                   
     .           xyzf_qmixlina(t1029-1,1,1,n) = f_qmixlinmax(n)*                
     .       1      5.00000000000000e-001*(dsin(2.00000000000000e+000*          
     .       2      xyzf_qmixlina(t1029-1,1,1,n))+1.00000000000000e+000)        
     .        enddo                                                             
   496            & f_QMixLinMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixLinA(:,:,:,n))+1.0_DP)
   497        end do
   498      end if
   499  
   500      xyzf_DQMixDtHorMassFix = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t901 = 1, xyzf_dqmixdthormassfix.DSC.U4*                       
     .       1   xyzf_dqmixdthormassfix.DSC.U3*xyzf_dqmixdthormassfix.DSC.U2*(  
     .       2   xyzf_dqmixdthormassfix.DSC.U1 + 1)                             
     .           xyzf_dqmixdthormassfix(t901-1,1,1,1) = 0.0000000000000000e+000 
     .           xyzf_qmixlinatentative(t901-1,1,1,1) = xyzf_qmixlina(t901-1,1,1
     .       1      ,1)                                                         
     .        enddo                                                             
   501      xyzf_QMixLinATentative = xyzf_QMixLinA
   502      !==================================================
   503  
   504  
   505      ! 鉛直セミラグ
   506      ! Vertical
   507  !!$    xyzf_QMixA = SLTTVerAdv( xyr_SigDotN, xyzf_QMixA )
   508      xyzf_QMixA = SLTTVerAdv( xyr_SigDotN, xyzf_QMixA,                &
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t925 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t927 = 1, imax                                           
     .                 xyzf_qmixa2 = %000406(t927-1,t925,t923+1,t921+1)         
     .                 xyzf_qmixa(t927-1,t925,t923+1,t921+1) = max(min(         
     .       1            xyzf_qmixa2,xyzf_qmixmaxa(t927-1,t925,t923+1,t921+1)),
     .       2            xyzf_qmixmina(t927-1,t925,t923+1,t921+1))             
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t925 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t927 = 1, imax                                           
     .                 xyzf_qmixa(t927-1,t925,t923+1,t921+1) = %000406(t927-1,  
     .       1            t925,t923+1,t921+1)                                   
     .                 xyzf_qmixa(t927-1,t925+1,t923+1,t921+1) = %000406(t927-1,
     .       1            t925+1,t923+1,t921+1)                                 
     .                 xyzf_qmixa(t927-1,t925+2,t923+1,t921+1) = %000406(t927-1,
     .       1            t925+2,t923+1,t921+1)                                 
     .                 xyzf_qmixa(t927-1,t925+3,t923+1,t921+1) = %000406(t927-1,
     .       1            t925+3,t923+1,t921+1)                                 
     .                 xyzf_qmixa(t927-1,t925,t923+1,t921+1) = max(min(         
     .       1            xyzf_qmixa(t927-1,t925,t923+1,t921+1),xyzf_qmixmaxa(  
     .       2            t927-1,t925,t923+1,t921+1)),xyzf_qmixmina(t927-1,t925,
     .       3            t923+1,t921+1))                                       
     .                 xyzf_qmixa(t927-1,t925+1,t923+1,t921+1) = max(min(       
     .       1            xyzf_qmixa(t927-1,t925+1,t923+1,t921+1),xyzf_qmixmaxa(
     .       2            t927-1,t925+1,t923+1,t921+1)),xyzf_qmixmina(t927-1,   
     .       3            t925+1,t923+1,t921+1))                                
     .                 xyzf_qmixa(t927-1,t925+2,t923+1,t921+1) = max(min(       
     .       1            xyzf_qmixa(t927-1,t925+2,t923+1,t921+1),xyzf_qmixmaxa(
     .       2            t927-1,t925+2,t923+1,t921+1)),xyzf_qmixmina(t927-1,   
     .       3            t925+2,t923+1,t921+1))                                
     .                 xyzf_qmixa(t927-1,t925+3,t923+1,t921+1) = max(min(       
     .       1            xyzf_qmixa(t927-1,t925+3,t923+1,t921+1),xyzf_qmixmaxa(
     .       2            t927-1,t925+3,t923+1,t921+1)),xyzf_qmixmina(t927-1,   
     .       3            t925+3,t923+1,t921+1))                                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   509        &                      xyzf_QMixLin  = xyzf_QMixLinATentative, & ! (in   ) optional
   510        &                      xyzf_QMixLinA = xyzf_QMixLinA,          & ! (out  ) optional
   511        &                      xyzf_QMixMinA = xyzf_QMixMinA,          & ! (inout) optional
   512        &                      xyzf_QMixMaxA = xyzf_QMixMaxA  )          ! (inout) optional
   513  
   514  
   515      ! Monotonic filter
   516      ! see Diamantakis and Flemming (2014) for BS limiter
   517      ! but limiter is applied separately in horizontal and vertical directions
   518  
   519      xyzf_QMixA = max( min( xyzf_QMixA, xyzf_QMixMaxA ), xyzf_QMixMinA )
   520  
   521  
   522      ! Vertical advection by finite difference method
   523      !
   524  !!$    do n = 1, ncmax
   525  !!$      k = 1
   526  !!$      xyrf_QMixA(:,:,k,n) = 1.0e100_DP
   527  !!$      do k = 1, kmax-1
   528  !!$        xyrf_QMixA(:,:,k,n) = &
   529  !!$          & ( xyzf_QMixA(:,:,k,n) + xyzf_QMixA(:,:,k+1,n) ) / 2.0_DP
   530  !!$      end do
   531  !!$      k = kmax
   532  !!$      xyrf_QMixA(:,:,k,n) = 1.0e100_DP
   533  !!$    end do
   534  !!$    do n = 1, ncmax
   535  !!$      do k = 1, kmax
   536  !!$        xyzf_QMixA(:,:,k,n) = xyzf_QMixA(:,:,k,n)                     &
   537  !!$          & + (                                                       &
   538  !!$          &     - (   xyr_SigDotN(:,:,k-1) * xyrf_QMixA(:,:,k-1,n)    &
   539  !!$          &         - xyr_SigDotN(:,:,k  ) * xyrf_QMixA(:,:,k  ,n) )  &
   540  !!$          &       / z_DelSigma(k)                                     &
   541  !!$          &     + xyzf_QMixA(:,:,k,n)                                 &
   542  !!$          &       * ( xyr_SigDotN(:,:,k-1) - xyr_SigDotN(:,:,k  ) )   &
   543  !!$          &       / z_DelSigma(k)                                     &
   544  !!$          &   ) * 2.0_DP * DelTime
   545  !!$      end do
   546  !!$    end do
   547  
   548  
   549      ! 移流テスト
   550  !    call SLTTTest(xyz_UTest, xyz_VTest, xyr_SigDotTest)
   551  !    xyzf_QMixA = SLTTHorAdv( xyzf_QMixA, xyz_UTest, xyz_VTest )           ! 水平セミラグ
   552  !    xyzf_QMixA = SLTTVerAdv( xyr_SigDotTest, xyzf_QMixA )              ! 鉛直セミラグ
   553  
   554      if ( FlagSLTTArcsineVer ) then
   555        ! 非負を保証するための arcsine変換フィルタ（逆変換）
   556        ! Arcsine transformation for non-negative filter
   557  
   558        do n = 1, ncmax
   559          xyzf_QMixA(:,:,:,n) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t993 = 1, kmax*jmax*imax                                       
     .           xyzf_qmixa(t993-1,1,1,n) = f_qmixmax(n)*5.00000000000000e-001*(
     .       1      dsin(2.00000000000000e+000*xyzf_qmixa(t993-1,1,1,n))+       
     .       2      1.00000000000000e+000)                                      
     .        enddo                                                             
   560            & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixA(:,:,:,n))+1.0_DP)
   561        end do
   562        do n = 1, ncmax
   563          xyzf_QMixLinA(:,:,:,n) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1005 = 1, xyzf_qmixlina.DSC.U3*(xyzf_qmixlina.DSC.U2*         
     .       1   xyzf_qmixlina.DSC.U1 + xyzf_qmixlina.DSC.U2)                   
     .           xyzf_qmixlina(t1005-1,1,1,n) = f_qmixlinmax(n)*                
     .       1      5.00000000000000e-001*(dsin(2.00000000000000e+000*          
     .       2      xyzf_qmixlina(t1005-1,1,1,n))+1.00000000000000e+000)        
     .        enddo                                                             
   564            & f_QMixLinMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixLinA(:,:,:,n))+1.0_DP)
   565        end do
   566      end if
   567  
   568  
   569  !!$!      xyzf_QMixA = xyzf_QMixB !テスト用
   570  !!$      xyzf_QMixA = xyzf_QMixA + xyzf_DQMixDtPhy * DelTime
   571  
   572  
   573      ! Mass fixer
   574  !!$    call MassFixerColumn(               &
   575  !!$      & xyr_PressA,                     & ! (in)
   576  !!$      & xyzf_QMixA,                     & ! (inout)
   577  !!$!      & xyr_PressRef = xyr_PressB,  & ! (in) optional
   578  !!$      & xyr_PressRef = xyr_PressA,      & ! (in) optional
   579  !!$      & xyzf_QMixRef = xyzf_QMixSave    & ! (in) optional
   580  !!$      & )
   581  
   582      !==================================================
   583      ! Calculation in a case in which other type of mass fixer is applied
   584      !
   585  !!$    xyzf_QMixSaveMassFix = xyzf_QMixA
   586  !!$    !
   587  !!$!    call MassFixer(                   &
   588  !!$!    call MassFixerWO94(               &
   589  !!$    call MassFixerR95(                &
   590  !!$      & xyr_PressA,                   & ! (in)
   591  !!$      & xyzf_QMixA,                   & ! (inout)
   592  !!$      & xyr_PressRef = xyr_PressB,    & ! (in) optional
   593  !!$      & xyzf_QMixRef = xyzf_QMixSave  & ! (in) optional
   594  !!$      & )
   595  !!$    !
   596  !!$    xyzf_DQMixDtVerMassFix = 0.0_DP
   597      !==================================================
   598      ! Calculation in a case in which mass fixer applied in horizontal and
   599      ! vertical directions separately
   600      !
   601  !!$    xyzf_QMixSaveMassFix = xyzf_QMixA
   602  !!$    !
   603  !!$    call MassFixerBC02Column(        &
   604  !!$      & xyr_PressA,            & ! (in)
   605  !!$      & xyzf_QMixA,            & ! (inout)
   606  !!$      & xyzf_QMixLinA,         & ! (in)
   607  !!$      & xyr_PressA,            & ! (in)
   608  !!$      & xyzf_QMixSave          & ! (in)
   609  !!$      & )
   610  !!$    !
   611  !!$    xyzf_DQMixDtVerMassFix = &
   612  !!$      & ( xyzf_QMixA - xyzf_QMixSaveMassFix ) / ( 2.0_DP * DelTime )
   613  !!$    !
   614  !!$    xyzf_DQMixDtTotMassFix = &
   615  !!$      & xyzf_DQMixDtHorMassFix + xyzf_DQMixDtVerMassFix
   616      !==================================================
   617      ! Calculation in a case in which mass fixer applied in horizontal and
   618      ! vertical directions in a same time
   619      !
   620      xyzf_QMixSaveMassFix = xyzf_QMixA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t953 = 1, xyzf_qmixsavemassfix.DSC.U4*                         
     .       1   xyzf_qmixsavemassfix.DSC.U3*xyzf_qmixsavemassfix.DSC.U2*(      
     .       2   xyzf_qmixsavemassfix.DSC.U1 + 1)                               
     .           xyzf_qmixsavemassfix(t953-1,1,1,1) = xyzf_qmixa(t953-1,1,1,1)  
     .        enddo                                                             
   621      !
   622      call MassFixerBC02(        &
   623        & xyr_PressA,            & ! (in)
   624        & xyzf_QMixA,            & ! (inout)
   625        & xyzf_QMixLinA,         & ! (in)
   626        & xyr_PressB,            & ! (in)
   627        & xyzf_QMixSave          & ! (in)
   628        & )
   629      !
   630      xyzf_DQMixDtVerMassFix = 0.0_DP
     .        d6 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t969 = 1, xyzf_dqmixdtvermassfix.DSC.U4*                       
     .       1   xyzf_dqmixdtvermassfix.DSC.U3*xyzf_dqmixdtvermassfix.DSC.U2*(  
     .       2   xyzf_dqmixdtvermassfix.DSC.U1 + 1)                             
     .           xyzf_dqmixdtvermassfix(t969-1,1,1,1) = 0.0000000000000000e+000 
     .           xyzf_dqmixdttotmassfix(t969-1,1,1,1) = (xyzf_qmixa(t969-1,1,1,1
     .       1      )-xyzf_qmixsavemassfix(t969-1,1,1,1))*d6                    
     .        enddo                                                             
   631      !==================================================
   632  
   633      xyzf_DQMixDtTotMassFix = &
   634        & + ( xyzf_QMixA - xyzf_QMixSaveMassFix ) / ( 2.0_DP * DelTime )
   635  
   636  
   637      do n = 1, ncmax
   638        call HistoryAutoPut( TimeN, 'SLD'//trim(a_QMixName(n))//'DtHorMassFix', &
   639          & xyzf_DQMixDtHorMassFix(:,:,:,n) )
   640        call HistoryAutoPut( TimeN, 'SLD'//trim(a_QMixName(n))//'DtVerMassFix', &
   641          & xyzf_DQMixDtVerMassFix(:,:,:,n) )
   642        call HistoryAutoPut( TimeN, 'SLD'//trim(a_QMixName(n))//'DtTotMassFix', &
   643          & xyzf_DQMixDtTotMassFix(:,:,:,n) )
   644      end do
   645  
   646  
   647    end subroutine SLTTMain
   648  
   649    !----------------------------------------------------------------------------
   650  
   651    function SLTTHorAdv( xyzf_QMix, xyz_U, xyz_V,      & ! (in)
   652      &                  xyzf_QMixLinA,                & ! (inout) optional
   653      &                  xyzf_QMixMinA, xyzf_QMixMaxA  & ! (out) optional
   654      & ) result( xyzf_QMixA )
   655      ! セミラグランジュ法による水平移流の計算
   656      ! Calculates tracer transports by Semi-Lagrangian method for horizontal direction
   657  
   658      use timeset    , only : DelTime
   659                                ! $\Delta t$
   660      use axesset    , only : x_Lon, y_Lat
   661                                ! $\lambda, \varphai$ lon and lat
   662      use sltt_const , only : dtjw, iexmin, iexmax, jexmin, jexmax
   663      use sltt_extarr, only : SLTTExtArrExt, SLTTExtArrExt2
   664                                ! 配列拡張ルーチン
   665                                ! Expansion of arrays
   666      use sltt_dp    , only : SLTTDPHor
   667                                ! 水平上流点探索
   668                                ! Finding departure point in horizontal
   669      use sltt_lagint, only : SLTTIrrHerIntK13, SLTTIrrLinInt, SLTTLagIntHorMaxMin
   670                                ! 水平２次元の補間
   671                                ! 2D Interpolation in horizontal
   672  
   673      ! SPMODEL ライブラリ, 球面上の問題を球面調和函数変換により解く(多層対応)
   674      ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
   675      !
   676  
   677  
   678      use wa_mpi_module, only:                     &
   679        & wa_xya            => wa_xva,             &
   680        & xya_wa            => xva_wa, &
   681        & wa_DLon_wa, &
   682        & xya_GradLat_wa => xva_GradLat_wa
   683  
   684  
   685  
   686  
   687      real(DP), intent(in ) :: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   688                                ! 現在時刻の物質混合比
   689                                ! Present mix ratio of the tracers
   690      real(DP), intent(in ) :: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   691                                ! 東西風速
   692                                ! Zonal Wind
   693      real(DP), intent(in ) :: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   694                                ! 南北風速
   695                                ! Meridional Wind
   696      real(DP), intent(inout), optional :: xyzf_QMixLinA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   697                                ! 次ステップの物質混合比
   698                                ! Next mix ratio of the tracers estimated by linear interpolation
   699      real(DP), intent(out), optional :: xyzf_QMixMinA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   700      real(DP), intent(out), optional :: xyzf_QMixMaxA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   701  
   702      real(DP) :: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   703                                ! 次ステップの物質混合比
   704                                ! Next mix ratio of the tracers
   705      !
   706      ! local variables
   707      !
   708      real(DP) :: xyzf_ExtQMixS(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   709                                ! 現在時刻の物質混合比の拡張配列（南半球）
   710                                ! Extended array (SH) of present mix ratio of the tracers.
   711      real(DP) :: xyzf_ExtQMixN(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   712                                ! 現在時刻の物質混合比の拡張配列（北半球）
   713                                ! Extended array (NH) of present mix ratio of the tracers.
   714  
   715      real(DP) :: xyzf_ExtQMixLinAS(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   716                                ! 現在時刻の物質混合比の拡張配列（南半球）
   717                                ! Extended array (SH) of present mix ratio of the tracers.
   718      real(DP) :: xyzf_ExtQMixLinAN(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   719                                ! 現在時刻の物質混合比の拡張配列（北半球）
   720                                ! Extended array (NH) of present mix ratio of the tracers.
   721  
   722  
   723      real(DP) :: xyz_ExtUS    (iexmin:iexmax, jexmin:jexmax, 1:kmax)
   724                                ! 東西風速の拡張配列（南半球）
   725                                ! Extended array (SH) of Zonal Wind
   726      real(DP) :: xyz_ExtUN    (iexmin:iexmax, jexmin:jexmax, 1:kmax)
   727                                ! 東西風速の拡張配列（北半球）
   728                                ! Extended array (NH) of Zonal Wind
   729      real(DP) :: xyz_ExtVS    (iexmin:iexmax, jexmin:jexmax, 1:kmax)
   730                                ! 南北風速の拡張配列（南半球）
   731                                ! Extended array (SH) of Meridional Wind
   732      real(DP) :: xyz_ExtVN    (iexmin:iexmax, jexmin:jexmax, 1:kmax)
   733                                ! 南北風速の拡張配列（北半球）
   734                                ! Extended array (NH) of Meridional Wind
   735  
   736      integer:: i, ii           ! 東西方向に回る DO ループ用作業変数
   737                                ! Work variables for DO loop in zonal direction
   738      integer:: j               ! 南北方向に回る DO ループ用作業変数
   739                                ! Work variables for DO loop in meridional direction
   740      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   741                                ! Work variables for DO loop in vertical direction
   742      integer:: n               ! 組成方向に回る DO ループ用作業変数
   743                                ! Work variables for DO loop in dimension of constituents
   744  
   745      real(DP) :: xyz_DPLonS(0:imax-1, 1:jmax/2, 1:kmax)
   746                                ! 上流点経度（南半球）
   747                                ! Lon of the departure point (SH)
   748      real(DP) :: xyz_DPLonN(0:imax-1, 1:jmax/2, 1:kmax)
   749                                ! 上流点経度（北半球）
   750                                ! Lon of the departure point (NH)
   751      real(DP) :: xyz_DPLatS(0:imax-1, 1:jmax/2, 1:kmax)
   752                                ! 上流点緯度（南半球）
   753                                ! Lat of the departure point (SH)
   754      real(DP) :: xyz_DPLatN(0:imax-1, 1:jmax/2, 1:kmax)
   755                                ! 上流点緯度（北半球）
   756                                ! Lat of the departure point (NH)
   757  
   758      real(DP) :: xyzf_QMixAS(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   759                                ! 次ステップの物質混合比（南半球）
   760                                ! Next mix ratio of the tracers (SH)
   761      real(DP) :: xyzf_QMixAN(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   762                                ! 次ステップの物質混合比（北半球）
   763                                ! Next mix ratio of the tracers (NH)
   764  
   765      real(DP) :: xyzf_QMixMinAS(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   766      real(DP) :: xyzf_QMixMaxAS(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   767      real(DP) :: xyzf_QMixMinAN(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   768      real(DP) :: xyzf_QMixMaxAN(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   769  
   770  !---fx, fy, fxy
   771      real(DP) :: xyzf_QMix_dlon(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   772                                ! 物質混合比の経度微分（グリッド）
   773                                ! Zonal derivative of the mix ratio (on grid)
   774      real(DP) :: xyzf_QMix_dlat(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   775                                ! 物質混合比の緯度微分（グリッド）
   776                                ! Meridional derivative of the mix ratio (on grid)
   777      real(DP) :: xyzf_QMix_dlonlat(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   778                                ! 物質混合比の緯度経度微分（グリッド）
   779                                ! Zonal and meridional derivative of the mix ratio (on grid)
   780      real(DP) :: xyzf_ExtQMixS_dlon(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   781                                ! 物質混合比の経度微分の拡張配列（南半球）
   782                                ! Extended array (SH) of zonal derivative of the mix ratio
   783      real(DP) :: xyzf_ExtQMixN_dlon(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   784                                ! 物質混合比の経度微分の拡張配列（北半球）
   785                                ! Extended array (NH) of zonal derivative of the mix ratio
   786      real(DP) :: xyzf_ExtQMixS_dlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   787                                ! 物質混合比の緯度微分の拡張配列（南半球）
   788                                ! Extended array (SH) of meridional derivative of the mix ratio
   789      real(DP) :: xyzf_ExtQMixN_dlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   790                                ! 物質混合比の緯度微分の拡張配列（北半球）
   791                                ! Extended array (NH) of meridional derivative of the mix ratio
   792      real(DP) :: xyzf_ExtQMixS_dlonlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   793                                ! 物質混合比の緯度経度微分の拡張配列（南半球）
   794                                ! Extended array (SH) of zonal and meridional derivative of the mix ratio
   795      real(DP) :: xyzf_ExtQMixN_dlonlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   796                                ! 物質混合比の緯度経度微分の拡張配列（北半球）
   797                                ! Extended array (NH) of zonal and meridional derivative of the mix ratio
   798      real(DP) :: wzf_QMix(1:lmax, 1:kmax, 1:ncmax)
   799                                ! 物質混合比の経度微分（スペクトル）
   800                                ! Zonal derivative of the mix ratio (on grid)
   801      real(DP) :: wzf_QMix_dlon(1:lmax, 1:kmax, 1:ncmax)
   802                                ! 物質混合比の経度微分（スペクトル）
   803                                ! Zonal derivative of the mix ratio (on grid)
   804      real(DP) :: PM            ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   805                                ! Sign change flag for array extension; -1.0 for sign change over the pole, 1.0 for no sign change
   806  
   807  !---fxx, fyy, fxxyy
   808  !    real(DP) :: xyzf_QMix_dlon2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   809  !    real(DP) :: xyzf_QMix_dlat2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   810  !    real(DP) :: xyzf_QMix_dlon2lat2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   811  !    real(DP) :: xyzf_ExtQMixS_dlon2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   812  !    real(DP) :: xyzf_ExtQMixN_dlon2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   813  !    real(DP) :: xyzf_ExtQMixS_dlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   814  !    real(DP) :: xyzf_ExtQMixN_dlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   815  !    real(DP) :: xyzf_ExtQMixS_dlon2lat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   816  !    real(DP) :: xyzf_ExtQMixN_dlon2lat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   817  !----fxxy
   818  !    real(DP) :: xyzf_QMix_dlon2lat(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   819  !    real(DP) :: xyzf_ExtQMixS_dlon2lat(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   820  !    real(DP) :: xyzf_ExtQMixN_dlon2lat(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   821  !----fxyy
   822  !    real(DP) :: xyzf_QMix_dlonlat2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   823  !    real(DP) :: xyzf_ExtQMixS_dlonlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   824  !    real(DP) :: xyzf_ExtQMixN_dlonlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   825  !----
   826  !    real(DP) :: wzf_QMix_dlon2(1:lmax, 1:kmax, 1:ncmax)
   827  
   828  
   829      ! 実行文 ; Executable statement
   830      !
   831  
   832      ! 初期化確認
   833      ! Initialization check
   834      !
   835      if ( .not. sltt_inited ) then
   836        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   837      end if
   838  
   839  
   840      ! QMixの微分計算（スペクトル変換利用）
   841      ! Derivatives of QMix
   842      do n = 1, ncmax
   843          wzf_QMix(:,:,n) = wa_xya(xyzf_QMix(:,:,:,n))                     ! グリッド→スペクトル
     .        if (wzf_qmix.DSC.U2 .gt. 0) then                                  
     .           j1 = and(wzf_qmix.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t1077 = 1, j1                                               
     .  !cdir       nodep                                                       
     .              do t1079 = 1, wzf_qmix.DSC.U1                               
     .                 wzf_qmix(t1079,t1077,n) = %00047b(t1079,t1077)           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1077 = j1 + 1, wzf_qmix.DSC.U2, 4                          
     .  !cdir       nodep                                                       
     .              do t1079 = 1, wzf_qmix.DSC.U1                               
     .                 wzf_qmix(t1079,t1077,n) = %00047b(t1079,t1077)           
     .                 wzf_qmix(t1079,t1077+1,n) = %00047b(t1079,t1077+1)       
     .                 wzf_qmix(t1079,t1077+2,n) = %00047b(t1079,t1077+2)       
     .                 wzf_qmix(t1079,t1077+3,n) = %00047b(t1079,t1077+3)       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   844                                                                           ! grid -> spectrum
   845          xyzf_QMix_dlat(:,:,:,n) = xya_GradLat_wa(wzf_QMix(:,:,n))        ! スペクトル→グリッド緯度微分
     .        if (xyzf_qmix_dlat.DSC.U2 .gt. 0) then                            
     .           j2 = and(xyzf_qmix_dlat.DSC.U2,3)                              
     .  !cdir    nodep                                                          
     .           do t1087 = 1, j2                                               
     .  !cdir       nodep                                                       
     .              do t1089 = 1, xyzf_qmix_dlat.DSC.U1 + 1                     
     .                 xyzf_qmix_dlat(t1089-1,t1087,t1085+1,n) = %000486(t1089, 
     .       1            t1087,t1085+1)                                        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1087 = j2 + 1, xyzf_qmix_dlat.DSC.U2, 4                    
     .  !cdir       nodep                                                       
     .              do t1089 = 1, xyzf_qmix_dlat.DSC.U1 + 1                     
     .                 xyzf_qmix_dlat(t1089-1,t1087,t1085+1,n) = %000486(t1089, 
     .       1            t1087,t1085+1)                                        
     .                 xyzf_qmix_dlat(t1089-1,t1087+1,t1085+1,n) = %000486(t1089
     .       1            ,t1087+1,t1085+1)                                     
     .                 xyzf_qmix_dlat(t1089-1,t1087+2,t1085+1,n) = %000486(t1089
     .       1            ,t1087+2,t1085+1)                                     
     .                 xyzf_qmix_dlat(t1089-1,t1087+3,t1085+1,n) = %000486(t1089
     .       1            ,t1087+3,t1085+1)                                     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   846                                                                           ! spectrum -> grid (dQ/dlat)
   847          wzf_QMix_dlon(:,:,n) = wa_Dlon_wa(wzf_QMix(:,:,n))               ! スペクトル→スペクトル経度微分
     .        if (wzf_qmix_dlon.DSC.U2 .gt. 0) then                             
     .           j3 = and(wzf_qmix_dlon.DSC.U2,3)                               
     .  !cdir    nodep                                                          
     .           do t1097 = 1, j3                                               
     .  !cdir       nodep                                                       
     .              do t1099 = 1, wzf_qmix_dlon.DSC.U1                          
     .                 wzf_qmix_dlon(t1099,t1097,n) = %000493(t1099,t1097)      
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1097 = j3 + 1, wzf_qmix_dlon.DSC.U2, 4                     
     .  !cdir       nodep                                                       
     .              do t1099 = 1, wzf_qmix_dlon.DSC.U1                          
     .                 wzf_qmix_dlon(t1099,t1097,n) = %000493(t1099,t1097)      
     .                 wzf_qmix_dlon(t1099,t1097+1,n) = %000493(t1099,t1097+1)  
     .                 wzf_qmix_dlon(t1099,t1097+2,n) = %000493(t1099,t1097+2)  
     .                 wzf_qmix_dlon(t1099,t1097+3,n) = %000493(t1099,t1097+3)  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   848                                                                           ! spectrum -> spectrum (dQ/dlon)
   849          xyzf_QMix_dlon(:,:,:,n) = xya_wa(wzf_QMix_dlon(:,:,n))           ! スペクトル経度微分→グリッド経度微分
     .  !cdir nodep                                                             
     .        do t1109 = 0, 1 + xyzf_qmix_dlon.DSC.U1 - min0(1,                 
     .       1   xyzf_qmix_dlon.DSC.U1 + 1)                                     
   850                                                                           ! spectrum (dQ/dlon) -> grid (dQ/dlon)
   851          xyzf_QMix_dlonlat(:,:,:,n) = xya_GradLat_wa(wzf_QMix_dlon(:,:,n))! スペクトル経度微分→グリッド緯度経度微分
   852                                                                           ! spectrum (dQ/dlon) -> grid (d^2Q/dlon dlat)
   853  
   854          !---fxx, fyy, fxxy, fxyy, fxxyy を計算
   855          !xyzf_QMix_dlon2(:,:,:,n) = xya_wa(wa_Dlon_wa(wzf_QMix_dlon(:,:,n)))
   856          !xyzf_QMix_dlat2(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlat(:,:,:,n)))
   857          !xyzf_QMix_dlon2lat(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlon2(:,:,:,n)))
   858          !xyzf_QMix_dlonlat2(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlonlat(:,:,:,n)))
   859          !xyzf_QMix_dlon2lat2(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlon2lat(:,:,:,n)))
   860      enddo
   861  
   862  
   863      ! 配列の分割と拡張
   864      ! Division and extension of arrays
   865      !
   866      ! 配列の分割と拡張
   867      ! Division and extension of arrays
   868  
   869      pm = -1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   870                   ! -1.0 if the sign of value changes over the poles; if not 1.0.
   871  !!$    call SLTTExtArrExt2(                             &
   872  !!$      & xyzf_QMix_dlon,  pm,                         & ! (in)
   873  !!$      & xyzf_ExtQMixS_dlon, xyzf_ExtQMixN_dlon       & ! (out)
   874  !!$      & )
   875  !!$    call SLTTExtArrExt2(                            &
   876  !!$      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   877  !!$      & xyzf_QMix_dlon,  pm,                        & ! (in)
   878  !!$      & xyzf_ExtQMixS_dlon, xyzf_ExtQMixN_dlon,     & ! (out)
   879  !!$      & "Wave1"                                     & ! (in)
   880  !!$      & )
   881      call SLTTExtArrExt2(                            &
   882        & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   883        & xyzf_QMix_dlon,  pm,                        & ! (in)
   884        & xyzf_ExtQMixS_dlon, xyzf_ExtQMixN_dlon      & ! (out)
   885        & )
   886  
   887      pm = -1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   888                   ! -1.0 if the sign of value changes over the poles; if not 1.0.
   889  !!$    call SLTTExtArrExt2(                             &
   890  !!$      & xyzf_QMix_dlat,  pm,                         & ! (in)
   891  !!$      & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat       & ! (out)
   892  !!$      & )
   893  !!$    call SLTTExtArrExt2(                            &
   894  !!$      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   895  !!$      & xyzf_QMix_dlat,  pm,                        & ! (in)
   896  !!$      & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat,     & ! (out)
   897  !!$      & "Wave1"                                     & ! (in)
   898  !!$      & )
   899      call SLTTExtArrExt2(                            &
   900        & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   901        & xyzf_QMix_dlat,  pm,                        & ! (in)
   902        & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat      & ! (out)
   903        & )
   904  
   905      pm = +1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   906                   ! -1.0 if the sign of value changes over the poles; if not 1.0.
   907  !!$    call SLTTExtArrExt2(                             &
   908  !!$      & xyzf_QMix_dlonlat, pm,                       & ! (in)
   909  !!$      & xyzf_ExtQMixS_dlonlat, xyzf_ExtQMixN_dlonlat & ! (out)
   910  !!$      & )
   911  !!$    call SLTTExtArrExt2(                              &
   912  !!$      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN,   & ! (in)
   913  !!$      & xyzf_QMix_dlonlat, pm,                        & ! (in)
   914  !!$      & xyzf_ExtQMixS_dlonlat, xyzf_ExtQMixN_dlonlat, & ! (out)
   915  !!$      & "Wave1"                                       & ! (in)
   916  !!$      & )
   917      call SLTTExtArrExt2(                              &
   918        & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN,   & ! (in)
   919        & xyzf_QMix_dlonlat, pm,                        & ! (in)
   920        & xyzf_ExtQMixS_dlonlat, xyzf_ExtQMixN_dlonlat  & ! (out)
   921        & )
   922  
   923  !-----fxx, fyy, fxxy, fxyy, fxxyy の配列拡張
   924  !    pm = +1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   925                    ! -1.0 if the sign of value changes over the poles; if not 1.0.
   926  !    call SLTTExtArrExt2(                             &
   927  !      & xyzf_QMix_dlon2,  pm,                        & ! (in)
   928  !      & xyzf_ExtQMixS_dlon2, xyzf_ExtQMixN_dlon2     & ! (out)
   929  !      & )
   930  !    pm = +1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   931                    ! -1.0 if the sign of value changes over the poles; if not 1.0.
   932  !    call SLTTExtArrExt2(                             &
   933  !      & xyzf_QMix_dlat2,  pm,                        & ! (in)
   934  !      & xyzf_ExtQMixS_dlat2, xyzf_ExtQMixN_dlat2     & ! (out)
   935  !      & )
   936  !    pm = -1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   937                    ! -1.0 if the sign of value changes over the poles; if not 1.0.
   938  !    call SLTTExtArrExt2(                               &
   939  !      & xyzf_QMix_dlon2lat,  pm,                       & ! (in)
   940  !      & xyzf_ExtQMixS_dlon2lat, xyzf_ExtQMixN_dlon2lat & ! (out)
   941  !      & )
   942  !    pm = -1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   943                    ! -1.0 if the sign of value changes over the poles; if not 1.0.
   944  !    call SLTTExtArrExt2(                               &
   945  !      & xyzf_QMix_dlonlat2,  pm,                       & ! (in)
   946  !      & xyzf_ExtQMixS_dlonlat2, xyzf_ExtQMixN_dlonlat2 & ! (out)
   947  !      & )
   948  !    pm = +1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   949                    ! -1.0 if the sign of value changes over the poles; if not 1.0.
   950  !    call SLTTExtArrExt2(                                 &
   951  !      & xyzf_QMix_dlon2lat2,  pm,                        & ! (in)
   952  !      & xyzf_ExtQMixS_dlon2lat2, xyzf_ExtQMixN_dlon2lat2 & ! (out)
   953  !      & )
   954  
   955  
   956  !!$    call SLTTExtArrExt(                             &
   957  !!$      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   958  !!$      & xyzf_QMix, xyz_U, xyz_V,                    & ! (in)
   959  !!$      & xyzf_ExtQMixS, xyzf_ExtQMixN,               & ! (out)
   960  !!$      & xyz_ExtUS, xyz_ExtUN,                       & ! (out)
   961  !!$      & xyz_ExtVS, xyz_ExtVN                        & ! (out)
   962  !!$      & )
   963      call SLTTExtArrExt(                             &
   964        & y_ExtLatS, y_ExtLatN,                       & ! (in)
   965        & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   966        & xyzf_QMix, xyz_U, xyz_V,                    & ! (in)
   967  !      & xyzf_ExtDQMixDLatS, xyzf_ExtDQMixDLatN,     & ! (in)
   968        & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat,     & ! (in)
   969        & xyzf_ExtQMixS, xyzf_ExtQMixN,               & ! (out)
   970        & xyz_ExtUS, xyz_ExtUN,                       & ! (out)
   971        & xyz_ExtVS, xyz_ExtVN                        & ! (out)
   972        & )
   973  
   974  
   975      if ( present( xyzf_QMixLinA ) ) then
   976        ! Extention of array for linear interpolation
   977        PM = 1.0_DP
   978        call SLTTExtArrExt2(                            &
   979          & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   980          & xyzf_QMixLinA, PM,                          & ! (in)
   981          & xyzf_ExtQMixLinAS, xyzf_ExtQMixLinAN        & ! (out)
   982          & )
   983      end if
   984  
   985  
   986      ! 上流点の計算
   987      ! estimation of departure point
   988      ! 南半球
   989      ! south array
   990      call SLTTDPHor(                                     &
   991        & DelTime, x_LonS, y_LatS, y_SinLatS, y_CosLatS,  & ! (in)
   992        & iexmin, iexmax, jexmin, jexmax,                 & ! (in)
   993        & x_ExtLonS, y_ExtLatS, xyz_ExtUS, xyz_ExtVS,     & ! (in)
   994        & xyz_DPLonS, xyz_DPLatS                          & ! (out)
   995        & )
   996      ! 北半球
   997      ! north array
   998      call SLTTDPHor(                                     &
   999        & DelTime, x_LonN, y_LatN, y_SinLatN, y_CosLatN,  & ! (in)
  1000        & iexmin, iexmax, jexmin, jexmax,                 & ! (in)
  1001        & x_ExtLonN, y_ExtLatN, xyz_ExtUN, xyz_ExtVN,     & ! (in)
  1002        & xyz_DPLonN, xyz_DPLatN                          & ! (out)
  1003        & )
  1004  
  1005  
  1006  
  1007      ! 補間
  1008      ! Interpolation
  1009  !    do n = 1, ncmax
  1010      call SLTTIrrHerIntK13(                                                &
  1011        & iexmin, iexmax, jexmin, jexmax,                                     & ! (in)
  1012         & x_ExtLonS, y_ExtLatS, xyz_DPLonS, xyz_DPLatS,                      & ! (in)
  1013         & xyzf_ExtQMixS(:,:,:,:), xyzf_ExtQMixS_dlon(:,:,:,:),               & ! (in)
  1014         & xyzf_ExtQMixS_dlat(:,:,:,:), xyzf_ExtQMixS_dlonlat(:,:,:,:),       & ! (in)
  1015  !      & xyzf_ExtQMixS_dlon2(:,:,:,n), xyzf_ExtQMixS_dlat2(:,:,:,n),        & ! (in) fxx, fyy
  1016  !      & xyzf_ExtQMixS_dlon2lat(:,:,:,n), xyzf_ExtQMixS_dlonlat2(:,:,:,n),  & ! (in) fxxy, fxyy
  1017  !      & xyzf_ExtQMixS_dlon2lat2(:,:,:,n),                                  & ! (in) fxxyy
  1018         & SLTTIntHor,                                                        & ! (in)
  1019         & xyzf_QMixAS(:,:,:,:)                                               & ! (out)
  1020         & )
  1021  
  1022      call SLTTIrrHerIntK13(                                                &
  1023        & iexmin, iexmax, jexmin, jexmax,                                     & ! (in)
  1024         & x_ExtLonN, y_ExtLatN, xyz_DPLonN, xyz_DPLatN,                      & ! (in)
  1025         & xyzf_ExtQMixN(:,:,:,:), xyzf_ExtQMixN_dlon(:,:,:,:),               & ! (in)
  1026         & xyzf_ExtQMixN_dlat(:,:,:,:), xyzf_ExtQMixN_dlonlat(:,:,:,:),       & ! (in)
  1027  !      & xyzf_ExtQMixN_dlon2(:,:,:,n), xyzf_ExtQMixN_dlat2(:,:,:,n),        & ! (in) fxx, fyy
  1028  !      & xyzf_ExtQMixN_dlon2lat(:,:,:,n), xyzf_ExtQMixN_dlonlat2(:,:,:,n),  & ! (in) fxxy, fxyy
  1029  !      & xyzf_ExtQMixN_dlon2lat2(:,:,:,n),                                  & ! (in) fxxyy
  1030         & SLTTIntHor,                                                        & ! (in)
  1031         & xyzf_QMixAN(:,:,:,:)                                               & ! (out)
  1032         & )
  1033  !    enddo
  1034  
  1035      ! 南北半球の配列の結合
  1036      ! joint of each array
  1037       xyzf_QMixA(:,1:jmax/2,:,:)      = xyzf_QMixAS(:,1:jmax/2,:,:)
     .           if (jmax/2 .gt. 0) then                                        
     .           j4 = and(jmax/2,3)                                             
     .  !cdir    nodep                                                          
     .           do t1127 = 1, j4                                               
     .  !cdir       nodep                                                       
     .              do t1129 = 1, xyzf_qmixa.DESCRIPT.RETVAL.DSC.U1 + 1         
     .                 xyzf_qmixa(t1129-1,t1127,t1125+1,t1123+1) = xyzf_qmixas( 
     .       1            t1129-1,t1127,t1125+1,t1123+1)                        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1127 = j4 + 1, jmax/2, 4                                   
     .  !cdir       nodep                                                       
     .              do t1129 = 1, xyzf_qmixa.DESCRIPT.RETVAL.DSC.U1 + 1         
     .                 xyzf_qmixa(t1129-1,t1127,t1125+1,t1123+1) = xyzf_qmixas( 
     .       1            t1129-1,t1127,t1125+1,t1123+1)                        
     .                 xyzf_qmixa(t1129-1,t1127+1,t1125+1,t1123+1) = xyzf_qmixas
     .       1            (t1129-1,t1127+1,t1125+1,t1123+1)                     
     .                 xyzf_qmixa(t1129-1,t1127+2,t1125+1,t1123+1) = xyzf_qmixas
     .       1            (t1129-1,t1127+2,t1125+1,t1123+1)                     
     .                 xyzf_qmixa(t1129-1,t1127+3,t1125+1,t1123+1) = xyzf_qmixas
     .       1            (t1129-1,t1127+3,t1125+1,t1123+1)                     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1038       xyzf_QMixA(:,jmax/2+1:jmax,:,:) = xyzf_QMixAN(:,1:jmax/2,:,:)
     .        if (jmax - jmax/2 .gt. 0) then                                    
     .           j5 = and(jmax - jmax/2,3)                                      
     .  !cdir    nodep                                                          
     .           do t1143 = 1, j5                                               
     .  !cdir       nodep                                                       
     .              do t1145 = 1, xyzf_qmixa.DESCRIPT.RETVAL.DSC.U1 + 1         
     .                 xyzf_qmixa(t1145-1,t1143+jmax/2,t1141+1,t1139+1) =       
     .       1            xyzf_qmixan(t1145-1,t1143,t1141+1,t1139+1)            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1143 = j5 + 1, jmax - jmax/2, 4                            
     .  !cdir       nodep                                                       
     .              do t1145 = 1, xyzf_qmixa.DESCRIPT.RETVAL.DSC.U1 + 1         
     .                 xyzf_qmixa(t1145-1,t1143+jmax/2,t1141+1,t1139+1) =       
     .       1            xyzf_qmixan(t1145-1,t1143,t1141+1,t1139+1)            
     .                 xyzf_qmixa(t1145-1,t1143+1+jmax/2,t1141+1,t1139+1) =     
     .       1            xyzf_qmixan(t1145-1,t1143+1,t1141+1,t1139+1)          
     .                 xyzf_qmixa(t1145-1,t1143+2+jmax/2,t1141+1,t1139+1) =     
     .       1            xyzf_qmixan(t1145-1,t1143+2,t1141+1,t1139+1)          
     .                 xyzf_qmixa(t1145-1,t1143+3+jmax/2,t1141+1,t1139+1) =     
     .       1            xyzf_qmixan(t1145-1,t1143+3,t1141+1,t1139+1)          
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1039  
  1040  
  1041       if ( present( xyzf_QMixLinA ) ) then
  1042  
  1043         call SLTTIrrLinInt(                                                  &
  1044           & iexmin, iexmax, jexmin, jexmax,                                  & ! (in)
  1045           & x_ExtLonS, y_ExtLatS, xyz_DPLonS, xyz_DPLatS, xyzf_ExtQMixLinAS, & ! (in)
  1046           & xyzf_QMixAS                                                      & ! (out)
  1047           & )
  1048         call SLTTIrrLinInt(                                                  &
  1049           & iexmin, iexmax, jexmin, jexmax,                                  & ! (in)
  1050           & x_ExtLonN, y_ExtLatN, xyz_DPLonN, xyz_DPLatN, xyzf_ExtQMixLinAN, & ! (in)
  1051           & xyzf_QMixAN                                                      & ! (out)
  1052           & )
  1053  
  1054         xyzf_QMixLinA(:,1:jmax/2,:,:)      = xyzf_QMixAS(:,1:jmax/2,:,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1215 = 1, (jmax/2)*imax                                       
     .           xyzf_qmixlina(t1215-1,1,t1213+1,t1211+1) = xyzf_qmixas(t1215-1,
     .       1      1,t1213+1,t1211+1)                                          
     .        enddo                                                             
  1055         xyzf_QMixLinA(:,jmax/2+1:jmax,:,:) = xyzf_QMixAN(:,1:jmax/2,:,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1231 = 1, (jmax - jmax/2)*imax                                
     .           xyzf_qmixlina(t1231-1,1+jmax/2,t1229+1,t1227+1) = xyzf_qmixan( 
     .       1      t1231-1,1,t1229+1,t1227+1)                                  
     .        enddo                                                             
  1056       end if
  1057  
  1058  
  1059       if ( ( (       present( xyzf_QMixMinA ) ) .and. &
  1060         &    ( .not. present( xyzf_QMixMaxA ) ) ) .or. &
  1061         &  ( ( .not. present( xyzf_QMixMinA ) ) .and. &
  1062         &    (       present( xyzf_QMixMaxA ) ) ) ) then
  1063         call MessageNotify( 'E', module_name, &
  1064           & 'QMixMinA has to be present when QMixMaxA is present, and vice versa.' )
  1065       end if
  1066  
  1067       if ( present( xyzf_QMixMinA ) ) then
  1068         call SLTTLagIntHorMaxMin(                                        &
  1069           & iexmin, iexmax, jexmin, jexmax,                              & ! (in)
  1070           & x_ExtLonS, y_ExtLatS, xyz_DPLonS, xyz_DPLatS, xyzf_ExtQMixS, & ! (in)
  1071           & xyzf_QMixMinAS, xyzf_QMixMaxAS                               & ! (out)
  1072           & )
  1073         call SLTTLagIntHorMaxMin(                                        &
  1074           & iexmin, iexmax, jexmin, jexmax,                              & ! (in)
  1075           & x_ExtLonN, y_ExtLatN, xyz_DPLonN, xyz_DPLatN, xyzf_ExtQMixN, & ! (in)
  1076           & xyzf_QMixMinAN, xyzf_QMixMaxAN                               & ! (out)
  1077           & )
  1078         xyzf_QMixMinA(:,1:jmax/2,:,:)      = xyzf_QMixMinAS(:,1:jmax/2,:,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1159 = 1, (jmax/2)*imax                                       
     .           xyzf_qmixmina(t1159-1,1,t1157+1,t1155+1) = xyzf_qmixminas(t1159
     .       1      -1,1,t1157+1,t1155+1)                                       
     .        enddo                                                             
  1079         xyzf_QMixMinA(:,jmax/2+1:jmax,:,:) = xyzf_QMixMinAN(:,1:jmax/2,:,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1175 = 1, (jmax - jmax/2)*imax                                
     .           xyzf_qmixmina(t1175-1,1+jmax/2,t1173+1,t1171+1) =              
     .       1      xyzf_qmixminan(t1175-1,1,t1173+1,t1171+1)                   
     .           xyzf_qmixmaxa(t1175-1,1,t1173+1,t1171+1) = xyzf_qmixmaxas(t1175
     .       1      -1,1,t1173+1,t1171+1)                                       
     .        enddo                                                             
  1080         xyzf_QMixMaxA(:,1:jmax/2,:,:)      = xyzf_QMixMaxAS(:,1:jmax/2,:,:)
  1081         xyzf_QMixMaxA(:,jmax/2+1:jmax,:,:) = xyzf_QMixMaxAN(:,1:jmax/2,:,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1199 = 1, (jmax - jmax/2)*imax                                
     .           xyzf_qmixmaxa(t1199-1,1+jmax/2,t1197+1,t1195+1) =              
     .       1      xyzf_qmixmaxan(t1199-1,1,t1197+1,t1195+1)                   
     .        enddo                                                             
  1082  
  1083       end if
  1084  
  1085  
  1086    end function SLTTHorAdv
  1087  
  1088    !--------------------------------------------------------------------------------------
  1089  
  1090    function SLTTVerAdv( xyr_SigmaDot, xyzf_QMix,     &
  1091      &                  xyzf_QMixLin,                & ! (in ) optional
  1092      &                  xyzf_QMixLinA,               & ! (out) optional
  1093      &                  xyzf_QMixMinA, xyzf_QMixMaxA & ! (out) optional
  1094      & ) result( xyzf_QMixA )
  1095      ! セミラグランジュ法による鉛直移流の計算
  1096      ! Calculates tracer transports by Semi-Lagrangian method for vertical direction
  1097  
  1098      use axesset, only : z_Sigma           ! 鉛直座標; Sigma coordinate
  1099      use timeset, only : DelTime           ! $\Delta t$
  1100      use sltt_dp, only : SLTTDPVer         ! 鉛直上流点探索; Finding departure point in vertical
  1101      use sltt_lagint, only : &
  1102        & SLTTIrrHerIntQui1DNonUni, &       ! 不当間隔格子の五次補間; Quintic Interpolation for non-uniform grids
  1103        & SLTTHerIntCub1D
  1104  
  1105      real(DP), intent(in ) :: xyr_SigmaDot(0:imax-1, 1:jmax, 0:kmax)
  1106                                ! 鉛直流速（SigmaDot）
  1107      real(DP), intent(in ) :: xyzf_QMix   (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1108                                ! 現在時刻の物質混合比
  1109                                ! Present mix ratio of the tracers
  1110      real(DP), intent(in ), optional :: xyzf_QMixLin (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1111      real(DP), intent(out), optional :: xyzf_QMixLinA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1112  
  1113      real(DP), intent(out), optional :: xyzf_QMixMinA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1114      real(DP), intent(out), optional :: xyzf_QMixMaxA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1115  
  1116      real(DP)              :: xyzf_QMixA  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1117                                ! 次ステップの物質混合比
  1118                                ! Next mix ratio of the tracers
  1119  
  1120      !
  1121      ! local variables
  1122      !
  1123      real(DP) :: xyz_DPSigma(0:imax-1, 1:jmax, 1:kmax)
  1124                                ! 上流点高度
  1125                                ! Sigma of the departure point
  1126      integer:: i               ! 東西方向に回る DO ループ用作業変数
  1127                                ! Work variables for DO loop in zonal direction
  1128      integer:: j               ! 南北方向に回る DO ループ用作業変数
  1129                                ! Work variables for DO loop in meridional direction
  1130      integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
  1131                                ! Work variables for DO loop in vertical direction
  1132      integer:: n               ! 組成方向に回る DO ループ用作業変数
  1133                                ! Work variables for DO loop in dimension of constituents
  1134      integer:: xy_kk(0:imax-1, 1:jmax)
  1135                                ! 上流点の上下のグリッドを探索するための作業変数
  1136                                ! Work variable for finding the grid just above the departure point
  1137  
  1138      real(DP) :: xyzf_QMix_dz(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1139                                ! 物質混合比の鉛直微分
  1140                                ! Vertical derivative of the mix ratio
  1141      real(DP) :: xyzf_ExtQMix(0:imax-1, 1:jmax, 1-2:kmax+2, 1:ncmax)
  1142                                ! 物質混合比の拡張配列
  1143                                ! Extended array of the mix ratio
  1144      real(DP) :: z_ExtSigma(1-2:kmax+2)
  1145                                ! σ座標の拡張配列
  1146                                ! Extended array of the sigma coordinate
  1147      real(DP) :: xyf_F11(0:imax-1, 1:jmax, 1:ncmax)
  1148                                ! 微分計算時に用いる作業変数
  1149                                ! work variable for the derivative calculation
  1150      real(DP) :: xyf_F22(0:imax-1, 1:jmax, 1:ncmax)
  1151                                ! 微分計算時に用いる作業変数
  1152                                ! work variable for the derivative calculation
  1153      real(DP) :: xyf_F12(0:imax-1, 1:jmax, 1:ncmax)
  1154                                ! 微分計算時に用いる作業変数
  1155                                ! work variable for the derivative calculation
  1156      real(DP) :: xyf_F21(0:imax-1, 1:jmax, 1:ncmax)
  1157                                ! 微分計算時に用いる作業変数
  1158                                ! work variable for the derivative calculation
  1159      real(DP) :: s1, t1, s2, t2, r1, r2
  1160                                ! 微分計算時に用いる作業変数
  1161                                ! work variable for the derivative calculation
  1162  
  1163      real(DP) :: xyzf_QMixLinLV   (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1164      real(DP) :: xyzf_ExtQMixLinLV(0:imax-1, 1:jmax, 1-2:kmax+2, 1:ncmax)
  1165  
  1166  
  1167      ! 実行文 ; Executable statement
  1168      !
  1169  
  1170      ! 初期化確認
  1171      ! Initialization check
  1172      !
  1173      if ( .not. sltt_inited ) then
  1174        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1175      end if
  1176  
  1177  
  1178      if ( ( present( xyzf_QMixLin ) ) .and. ( .not. present( xyzf_QMixLinA ) ) ) then
  1179        call MessageNotify( 'E', module_name, &
  1180          & 'If xyzf_QMixLinA has to be present when xyzf_QMixLin ise present.' )
  1181      end if
  1182      if ( ( (       present( xyzf_QMixMinA ) ) .and. &
  1183        &    ( .not. present( xyzf_QMixMaxA ) ) ) .or. &
  1184        &  ( ( .not. present( xyzf_QMixMinA ) ) .and. &
  1185        &    (       present( xyzf_QMixMaxA ) ) ) ) then
  1186        call MessageNotify( 'E', module_name, &
  1187          & 'QMixMinA has to be present when QMixMaxA is present, and vice versa.' )
  1188      end if
  1189  
  1190  
  1191      if ( present( xyzf_QMixLin ) ) then
  1192        xyzf_QMixLinLV = xyzf_QMixLin
     .        if (1 + xyzf_qmixlinlv.DSC.U2 - min0(1,xyzf_qmixlinlv.DSC.U2) .gt.
     .       1    0) then                                                       
     .           j1 = and(1 + xyzf_qmixlinlv.DSC.U2 - min0(1,                   
     .       1      xyzf_qmixlinlv.DSC.U2),3)                                   
     .  !cdir    nodep                                                          
     .           do t1279 = 1, j1                                               
     .  !cdir       nodep                                                       
     .              do t1281 = 1, xyzf_qmixlinlv.DSC.U1 + 2 - min0(1,           
     .       1         xyzf_qmixlinlv.DSC.U1 + 1)                               
     .                 xyzf_qmixlinlv(t1281-1,t1279,t1277+1,t1275+1) =          
     .       1            xyzf_qmixlin(t1281-1,t1279,t1277+1,t1275+1)           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1279 = j1 + 1, 1 + xyzf_qmixlinlv.DSC.U2 - min0(1,         
     .       1      xyzf_qmixlinlv.DSC.U2), 4                                   
     .  !cdir       nodep                                                       
     .              do t1281 = 1, xyzf_qmixlinlv.DSC.U1 + 2 - min0(1,           
     .       1         xyzf_qmixlinlv.DSC.U1 + 1)                               
     .                 xyzf_qmixlinlv(t1281-1,t1279,t1277+1,t1275+1) =          
     .       1            xyzf_qmixlin(t1281-1,t1279,t1277+1,t1275+1)           
     .                 xyzf_qmixlinlv(t1281-1,t1279+1,t1277+1,t1275+1) =        
     .       1            xyzf_qmixlin(t1281-1,t1279+1,t1277+1,t1275+1)         
     .                 xyzf_qmixlinlv(t1281-1,t1279+2,t1277+1,t1275+1) =        
     .       1            xyzf_qmixlin(t1281-1,t1279+2,t1277+1,t1275+1)         
     .                 xyzf_qmixlinlv(t1281-1,t1279+3,t1277+1,t1275+1) =        
     .       1            xyzf_qmixlin(t1281-1,t1279+3,t1277+1,t1275+1)         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1193      else
  1194        xyzf_QMixLinLV = xyzf_QMix
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1027 = 1, xyzf_qmixlinlv.DSC.U4*xyzf_qmixlinlv.DSC.U3*        
     .       1   xyzf_qmixlinlv.DSC.U2*(xyzf_qmixlinlv.DSC.U1 + 1)              
     .           xyzf_qmixlinlv(t1027-1,1,1,1) = xyzf_qmix(t1027-1,1,1,1)       
     .        enddo                                                             
  1195      end if
  1196  
  1197  
  1198      ! 上流点探索
  1199      ! estimation of departure point
  1200      !
  1201      call SLTTDPVer(            &
  1202        & DelTime, xyr_SigmaDot, & ! (in )
  1203        & xyz_DPSigma            & ! (out)
  1204        & )
  1205  
  1206  
  1207      ! 配列拡張（z_Sigma）
  1208      ! Array extension for z_Sigma
  1209      z_ExtSigma(-1) = 2.0_DP - z_Sigma(2)
  1210      z_ExtSigma(0) = 2.0_DP - z_Sigma(1)
  1211      z_ExtSigma(1:kmax) = z_Sigma(1:kmax)
  1212      z_ExtSigma(kmax+1) = -z_Sigma(kmax)
  1213      z_ExtSigma(kmax+2) = -z_Sigma(kmax-1)
  1214  
  1215      ! 配列拡張（xyzf_QMix）
  1216      ! Array extension for Q_Mix
  1217      xyzf_ExtQMix(:,:,-1,:)     = xyzf_QMix(:,:,2,:)
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t1049 = 1, xyzf_extqmix.DSC.U2*xyzf_extqmix.DSC.U1 +           
     .       1   xyzf_extqmix.DSC.U2                                            
     .           xyzf_extqmix(t1049-1,1,-1,t1047+1) = xyzf_qmix(t1049-1,1,2,    
     .       1      t1047+1)                                                    
     .           xyzf_extqmix(t1049-1,1,0,t1047+1) = xyzf_qmix(t1049-1,1,1,t1047
     .       1      +1)                                                         
     .        enddo                                                             
  1218      xyzf_ExtQMix(:,:,0,:)      = xyzf_QMix(:,:,1,:)
  1219      xyzf_ExtQMix(:,:,1:kmax,:) = xyzf_QMix(:,:,1:kmax,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1067 = 1, kmax*(xyzf_extqmix.DSC.U2*xyzf_extqmix.DSC.U1 +     
     .       1   xyzf_extqmix.DSC.U2)                                           
     .           xyzf_extqmix(t1067-1,1,1,t1065+1) = xyzf_qmix(t1067-1,1,1,t1065
     .       1      +1)                                                         
     .        enddo                                                             
  1220      xyzf_ExtQMix(:,:,kmax+1,:) = xyzf_QMix(:,:,kmax,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1083 = 1, xyzf_extqmix.DSC.U2*xyzf_extqmix.DSC.U1 +           
     .       1   xyzf_extqmix.DSC.U2                                            
     .           xyzf_extqmix(t1083-1,1,kmax+1,t1081+1) = xyzf_qmix(t1083-1,1,  
     .       1      kmax,t1081+1)                                               
     .           xyzf_extqmix(t1083-1,1,kmax+2,t1081+1) = xyzf_qmix(t1083-1,1,  
     .       1      kmax-1,t1081+1)                                             
     .           xyzf_extqmixlinlv(t1083-1,1,-1,t1081+1) = xyzf_qmixlinlv(t1083-
     .       1      1,1,2,t1081+1)                                              
     .           xyzf_extqmixlinlv(t1083-1,1,0,t1081+1) = xyzf_qmixlinlv(t1083-1
     .       1      ,1,1,t1081+1)                                               
     .        enddo                                                             
  1221      xyzf_ExtQMix(:,:,kmax+2,:) = xyzf_QMix(:,:,kmax-1,:)
  1222  
  1223      xyzf_ExtQMixLinLV(:,:,-1,:)     = xyzf_QMixLinLV(:,:,2,:)
  1224      xyzf_ExtQMixLinLV(:,:,0,:)      = xyzf_QMixLinLV(:,:,1,:)
  1225      xyzf_ExtQMixLinLV(:,:,1:kmax,:) = xyzf_QMixLinLV(:,:,1:kmax,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1113 = 1, kmax*(xyzf_extqmixlinlv.DSC.U2*                     
     .       1   xyzf_extqmixlinlv.DSC.U1 + xyzf_extqmixlinlv.DSC.U2)           
     .           xyzf_extqmixlinlv(t1113-1,1,1,t1111+1) = xyzf_qmixlinlv(t1113-1
     .       1      ,1,1,t1111+1)                                               
     .        enddo                                                             
  1226      xyzf_ExtQMixLinLV(:,:,kmax+1,:) = xyzf_QMixLinLV(:,:,kmax,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1129 = 1, xyzf_extqmixlinlv.DSC.U2*xyzf_extqmixlinlv.DSC.U1 + 
     .       1   xyzf_extqmixlinlv.DSC.U2                                       
     .           xyzf_extqmixlinlv(t1129-1,1,kmax+1,t1127+1) = xyzf_qmixlinlv(  
     .       1      t1129-1,1,kmax,t1127+1)                                     
     .           xyzf_extqmixlinlv(t1129-1,1,kmax+2,t1127+1) = xyzf_qmixlinlv(  
     .       1      t1129-1,1,kmax-1,t1127+1)                                   
     .        enddo                                                             
  1227      xyzf_ExtQMixLinLV(:,:,kmax+2,:) = xyzf_QMixLinLV(:,:,kmax-1,:)
  1228  
  1229  
  1230      ! xyzf_QMix_dz（微分）を求める
  1231      ! calculate xyzf_QMix_dz
  1232      do k = 1 , kmax
  1233        s1 = z_ExtSigma(k) - z_ExtSigma(k-1)
  1234        t1 = z_ExtSigma(k+1) - z_ExtSigma(k)
  1235        s2 = z_ExtSigma(k) - z_ExtSigma(k-2)
  1236        t2 = z_ExtSigma(k+2) - z_ExtSigma(k)
  1237  
  1238        if (s1 == t1 .and. s2 == t2 .and. s1 + s1 == s2) then
  1239          ! 格子が等間隔の場合
  1240          ! Uniform depth
  1241          ! 4次精度
  1242          ! 4th order
  1243  
  1244          xyzf_QMix_dz(:,:,k,:) = ( 8.0_DP*( xyzf_ExtQMix(:,:,k+1,:) - xyzf_ExtQMix(:,:,k-1,:)) &
     .        if(1+xyzf_extqmix.DSC.U2-min0(1,xyzf_extqmix.DSC.U2).gt.0)then    
     .           j2=and(1+xyzf_extqmix.DSC.U2-min0(1,xyzf_extqmix.DSC.U2),3)    
     .  !cdir    nodep                                                          
     .           do t1256 = 1, j2                                               
     .              d1 = 1.D0/1.20000000000000e+001                             
     .  !cdir       nodep                                                       
     .              do t1258 = 1, xyzf_extqmix.DSC.U1 + 2 - min0(1,             
     .       1         xyzf_extqmix.DSC.U1 + 1)                                 
     .                 xyzf_qmix_dz(t1258-1,t1256,k,t1254+1) = (                
     .       1            8.00000000000000e+000*(xyzf_extqmix(t1258-1,t1256,k+1,
     .       2            t1254+1)-xyzf_extqmix(t1258-1,t1256,k-1,t1254+1))-(   
     .       3            xyzf_extqmix(t1258-1,t1256,k+2,t1254+1)-xyzf_extqmix( 
     .       4            t1258-1,t1256,k-2,t1254+1)))*d1                       
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1256 = j2 + 1, 1 + xyzf_extqmix.DSC.U2 - min0(1,           
     .       1      xyzf_extqmix.DSC.U2), 4                                     
     .              d2 = 1.D0/1.20000000000000e+001                             
     .              d3 = 1.D0/1.20000000000000e+001                             
     .              d4 = 1.D0/1.20000000000000e+001                             
     .              d5 = 1.D0/1.20000000000000e+001                             
     .  !cdir       nodep                                                       
     .              do t1258 = 1, xyzf_extqmix.DSC.U1 + 2 - min0(1,             
     .       1         xyzf_extqmix.DSC.U1 + 1)                                 
     .                 xyzf_qmix_dz(t1258-1,t1256,k,t1254+1) = (                
     .       1            8.00000000000000e+000*(xyzf_extqmix(t1258-1,t1256,k+1,
     .       2            t1254+1)-xyzf_extqmix(t1258-1,t1256,k-1,t1254+1))-(   
     .       3            xyzf_extqmix(t1258-1,t1256,k+2,t1254+1)-xyzf_extqmix( 
     .       4            t1258-1,t1256,k-2,t1254+1)))*d2                       
     .                 xyzf_qmix_dz(t1258-1,t1256+1,k,t1254+1) = (              
     .       1            8.00000000000000e+000*(xyzf_extqmix(t1258-1,t1256+1,k+
     .       2            1,t1254+1)-xyzf_extqmix(t1258-1,t1256+1,k-1,t1254+1))-
     .       3            (xyzf_extqmix(t1258-1,t1256+1,k+2,t1254+1)-           
     .       4            xyzf_extqmix(t1258-1,t1256+1,k-2,t1254+1)))*d3        
     .                 xyzf_qmix_dz(t1258-1,t1256+2,k,t1254+1) = (              
     .       1            8.00000000000000e+000*(xyzf_extqmix(t1258-1,t1256+2,k+
     .       2            1,t1254+1)-xyzf_extqmix(t1258-1,t1256+2,k-1,t1254+1))-
     .       3            (xyzf_extqmix(t1258-1,t1256+2,k+2,t1254+1)-           
     .       4            xyzf_extqmix(t1258-1,t1256+2,k-2,t1254+1)))*d4        
     .                 xyzf_qmix_dz(t1258-1,t1256+3,k,t1254+1) = (              
     .       1            8.00000000000000e+000*(xyzf_extqmix(t1258-1,t1256+3,k+
     .       2            1,t1254+1)-xyzf_extqmix(t1258-1,t1256+3,k-1,t1254+1))-
     .       3            (xyzf_extqmix(t1258-1,t1256+3,k+2,t1254+1)-           
     .       4            xyzf_extqmix(t1258-1,t1256+3,k-2,t1254+1)))*d5        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1245            &                         - ( xyzf_ExtQMix(:,:,k+2,:) - xyzf_ExtQMix(:,:,k-2,:) ) )/12.0_DP
  1246        else
  1247          ! 格子が不当間隔の場合
  1248          ! Non-uniform depth
  1249          xyf_F11 = (s1*s1*xyzf_ExtQMix(:,:,k+1,:) +(t1*t1 - s1*s1)*xyzf_ExtQMix(:,:,k,:) - t1*t1*xyzf_ExtQMix(:,:,k-1,:))&
     .        d6 = 1.D0/(s1*t1*(s1 + t1))                                       
     .        d7 = 1.D0/(s2*t2*(s2 + t2))                                       
     .        d8 = 1.D0/(s2*t1*(s2 + t1))                                       
     .        d9 = 1.D0/(s1*t2*(s1 + t2))                                       
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyf_f11,xyf_f22,xyf_f21,xyf_f12)                           
     .        do t1147 = 1, xyzf_extqmix.DSC.U2*xyzf_extqmix.DSC.U1 +           
     .       1   xyzf_extqmix.DSC.U2                                            
     .           xyf_f11(t1147-1,1,t1145+1) = ((s1*s1)*xyzf_extqmix(t1147-1,1,k+
     .       1      1,t1145+1)+((t1*t1)-(s1*s1))*xyzf_extqmix(t1147-1,1,k,t1145+
     .       2      1)-(t1*t1)*xyzf_extqmix(t1147-1,1,k-1,t1145+1))*d6          
     .           xyf_f22(t1147-1,1,t1145+1) = ((s2*s2)*xyzf_extqmix(t1147-1,1,k+
     .       1      2,t1145+1)+((t2*t2)-(s2*s2))*xyzf_extqmix(t1147-1,1,k,t1145+
     .       2      1)-(t2*t2)*xyzf_extqmix(t1147-1,1,k-2,t1145+1))*d7          
     .           xyf_f21(t1147-1,1,t1145+1) = ((s2*s2)*xyzf_extqmix(t1147-1,1,k+
     .       1      1,t1145+1)+((t1*t1)-(s2*s2))*xyzf_extqmix(t1147-1,1,k,t1145+
     .       2      1)-(t1*t1)*xyzf_extqmix(t1147-1,1,k-2,t1145+1))*d8          
     .           xyf_f12(t1147-1,1,t1145+1) = ((s1*s1)*xyzf_extqmix(t1147-1,1,k+
     .       1      2,t1145+1)+((t2*t2)-(s1*s1))*xyzf_extqmix(t1147-1,1,k,t1145+
     .       2      1)-(t2*t2)*xyzf_extqmix(t1147-1,1,k-1,t1145+1))*d9          
     .        enddo                                                             
  1250            &         /(s1*t1*(s1+t1))
  1251          xyf_F22 = (s2*s2*xyzf_ExtQMix(:,:,k+2,:) +(t2*t2 - s2*s2)*xyzf_ExtQMix(:,:,k,:) - t2*t2*xyzf_ExtQMix(:,:,k-2,:))&
  1252            &         /(s2*t2*(s2+t2))
  1253          xyf_F21 = (s2*s2*xyzf_ExtQMix(:,:,k+1,:) +(t1*t1 - s2*s2)*xyzf_ExtQMix(:,:,k,:) - t1*t1*xyzf_ExtQMix(:,:,k-2,:))&
  1254            &         /(s2*t1*(s2+t1))
  1255          xyf_F12 = (s1*s1*xyzf_ExtQMix(:,:,k+2,:) +(t2*t2 - s1*s1)*xyzf_ExtQMix(:,:,k,:) - t2*t2*xyzf_ExtQMix(:,:,k-1,:))&
  1256            &         /(s1*t2*(s1+t2))
  1257  
  1258          r1 = t1 - s1 - t2 + s2
  1259          r2 = t1 - s2 - t2 + s1
  1260          !４次精度
  1261          ! 4th order
  1262          xyzf_QMix_dz(:,:,k,:) = ( (xyf_F11*s2*t2 - xyf_F22*s1*t1)*r2 - (xyf_F21*s1*t2 - xyf_F12*s2*t1)*r1 ) &
     .        d10 = 1.D0/(((s2*t2) - (s1*t1))*r2 - ((s1*t2) - (s2*t1))*r1)      
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyf_f11,xyf_f22,xyf_f21,xyf_f12)                           
     .        do t1201 = 1, xyf_f11.DSC.U2*xyf_f11.DSC.U1 + xyf_f11.DSC.U2      
     .           xyzf_qmix_dz(t1201-1,1,k,t1199+1) = (((s2*t2)*xyf_f11(t1201-1,1
     .       1      ,t1199+1)-(s1*t1)*xyf_f22(t1201-1,1,t1199+1))*r2-((s1*t2)*  
     .       2      xyf_f21(t1201-1,1,t1199+1)-(s2*t1)*xyf_f12(t1201-1,1,t1199+1
     .       3      ))*r1)*d10                                                  
     .        enddo                                                             
  1263            &                       / ( (s2*t2-s1*t1)*r2 - (s1*t2-s2*t1)*r1 )
  1264  
  1265          !3次精度
  1266          ! 3rd order
  1267    !        xyzf_QMix_dz(:,:,k,:) = (xyf_F11*s2*t2 - xyf_F22(:,:,:)*s1*t1)/(s2*t2 - s1*t1)
  1268  
  1269          !2次精度
  1270          ! 2nd order
  1271    !        xyzf_QMix_dz(:,:,k,:) = xyf_F11
  1272        end if
  1273  
  1274  
  1275      end do
  1276  
  1277  
  1278      xy_kk = 2
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1220 = 1, xy_kk.DSC.U2*xy_kk.DSC.U1 + xy_kk.DSC.U2            
     .           xy_kk(t1220-1,1) = 2                                           
     .        enddo                                                             
  1279      do k = 1, kmax
  1280        do j = 1, jmax
  1281          do i = 0, imax-1
  1282            if ( xyz_DPSigma(i,j,k) >= z_Sigma(1) ) then     ! DPが z_Sigma(1) と 地表面(sigma = 1.0)の間の場合
  1283                                                             ! if DP is between z_Sigma(1) and the ground (sigma = 1.0)
  1284              xyzf_QMixA(i,j,k,:) = xyzf_QMix(i,j,1,:)     ! Q_1で一定とする。
  1285                                                           ! use Q_1 for interpolated value
  1286  
  1287              if ( present( xyzf_QMixLinA ) ) then
  1288                xyzf_QMixLinA(i,j,k,:) = xyzf_QMixLinLV(i,j,1,:)
  1289              end if
  1290  
  1291              if ( present( xyzf_QMixMinA ) ) then
  1292                xyzf_QMixMinA(i,j,k,:) = xyzf_QMix(i,j,1,:)
  1293                xyzf_QMixMaxA(i,j,k,:) = xyzf_QMix(i,j,1,:)
  1294              end if
  1295  
  1296            elseif (xyz_DPSigma(i,j,k) <= z_Sigma(kmax)) then! DPが z_Sigma(kmax) と 大気上端(sigma = 0.0)の間
  1297                                                             ! if DP is between z_Sigma(kmax) and the upper boundary (sigma = 0.0)
  1298              xyzf_QMixA(i,j,k,:) = xyzf_QMix(i,j,kmax,:)  ! Q_kmaxで一定とする。
  1299                                                           ! use Q_kmax for interpolated value
  1300  
  1301              if ( present( xyzf_QMixLinA ) ) then
  1302                xyzf_QMixLinA(i,j,k,:) = xyzf_QMixLinLV(i,j,kmax,:)
  1303              end if
  1304  
  1305              if ( present( xyzf_QMixMinA ) ) then
  1306                xyzf_QMixMinA(i,j,k,:) = xyzf_QMix(i,j,kmax,:)
  1307                xyzf_QMixMaxA(i,j,k,:) = xyzf_QMix(i,j,kmax,:)
  1308              end if
  1309  
  1310            else
  1311              do kk = xy_kk(i,j), kmax
  1312                if ( xyz_DPSigma(i,j,k) > z_Sigma(kk) ) then
  1313                  select case (SLTTIntVer)
  1314                  case("HQ")    ! 変則エルミート５次補間; Irregular Hermite Quintic interpolation
  1315                    do n = 1, ncmax
  1316                      xyzf_QMixA(i,j,k,n) = SLTTIrrHerIntQui1DNonUni(xyzf_ExtQMix(i,j,kk-2,n), xyzf_ExtQMix(i,j,kk-1,n), &
  1317                        &                               xyzf_ExtQMix(i,j,kk,n),   xyzf_ExtQMix(i,j,kk+1,n), &
  1318                        &                               xyzf_QMix_dz(i,j,kk-1,n), xyzf_QMix_dz(i,j,kk,n),   &
  1319                        &                               z_ExtSigma(kk-2)-z_ExtSigma(kk-1), z_ExtSigma(kk)-z_ExtSigma(kk-1), &
  1320                        &                               z_ExtSigma(kk+1)-z_ExtSigma(kk-1), xyz_DPSigma(i,j,k)-z_ExtSigma(kk-1))
  1321                    end do
  1322  
  1323                  case("HC")    ! エルミート３次補間; Hermitian Cubic interpolation
  1324                    do n = 1, ncmax
  1325                      xyzf_QMixA(i,j,k,n) = SLTTHerIntCub1D( xyzf_ExtQMix(i,j,kk-1,n), xyzf_ExtQMix(i,j,kk,n),&
  1326                        &                                      xyzf_QMix_dz(i,j,kk-1,n), xyzf_QMix_dz(i,j,kk,n),&
  1327                        &                                      z_ExtSigma(kk)-z_ExtSigma(kk-1),                 &
  1328                        &                                      xyz_DPSigma(i,j,k)-z_ExtSigma(kk-1))
  1329                    end do
  1330  
  1331                  case default
  1332                    call MessageNotify( 'E', module_name, 'GIVE CORRECT KEYWORD FOR <SLTTIntVer> IN NAMELIST.' )
  1333                  end select
  1334  
  1335                  if ( present( xyzf_QMixLinA ) ) then
  1336                    ! Linear interporation
  1337                    do n = 1, ncmax
  1338                      xyzf_QMixLinA(i,j,k,n) =                                              &
  1339                        &   ( xyzf_ExtQMixLinLV(i,j,kk,n) - xyzf_ExtQMixLinLV(i,j,kk-1,n) ) &
  1340                        &   / ( z_ExtSigma(kk)            - z_ExtSigma(kk-1)              ) &
  1341                        &   * ( xyz_DPSigma(i,j,k)        - z_ExtSigma(kk-1)              ) &
  1342                        & + xyzf_ExtQMixLinLV(i,j,kk-1,n)
  1343                    end do
     .           d11 = 1.D0/(z_extsigma(kk)-z_extsigma(kk-1))                   
     .  !cdir nodep                                                             
     .        do n = 1, ncmax                                                   
     .           xyzf_qmixlina(i,j,k,n) = (xyzf_extqmixlinlv(i,j,kk,n)-         
     .       1      xyzf_extqmixlinlv(i,j,kk-1,n))*d11*(xyz_dpsigma(i,j,k)-     
     .       2      z_extsigma(kk-1)) + xyzf_extqmixlinlv(i,j,kk-1,n)           
     .        enddo                                                             
  1344                  end if
  1345  
  1346                  if ( present( xyzf_QMixMinA ) ) then
  1347                    do n = 1, ncmax
  1348                      xyzf_QMixMinA(i,j,k,n) = &
  1349                        & min( xyzf_QMix(i,j,kk-1,n), &
  1350                        &      xyzf_QMix(i,j,kk,n) )
  1351                      xyzf_QMixMaxA(i,j,k,n) = &
  1352                        & max( xyzf_QMix(i,j,kk-1,n), &
  1353                        &      xyzf_QMix(i,j,kk,n) )
  1354                    end do
  1355                  end if
  1356  
  1357                  xy_kk(i,j) = kk
  1358                  exit
  1359                end if
  1360              end do
  1361            end if
  1362          end do
  1363        end do
  1364      end do
  1365  
  1366  
  1367    end function SLTTVerAdv
  1368  
  1369    !-------------------------------------------------
  1370  
  1371    subroutine SLTTInit
  1372      ! セミラグランジュ法の初期化処理
  1373      ! Initialization for Semi-Lagrangian method
  1374  
  1375  
  1376      ! ヒストリデータ出力
  1377      ! History data output
  1378      !
  1379      use gtool_historyauto, only: HistoryAutoAddVariable
  1380  
  1381      ! 組成に関わる配列の設定
  1382      ! Settings of array for atmospheric composition
  1383      !
  1384      use composition, only:                              &
  1385        &                    ncmax,                       &
  1386                               ! 成分の数
  1387                               ! Number of composition
  1388        &                    a_QMixName
  1389                               ! 成分の変数名
  1390                               ! Name of variables for composition
  1391  
  1392      ! 座標データ設定
  1393      ! Axes data settings
  1394      !
  1395      use axesset, only: &
  1396        & r_Sigma, &
  1397                                ! $ \sigma $ レベル (半整数).
  1398                                ! Half $ \sigma $ level
  1399        & z_Sigma, &            ! $ \sigma $ レベル (整数).
  1400                                ! Full $ \sigma $ level
  1401        & x_Lon, y_Lat, &
  1402        & AxNameX, AxNameY, AxNameZ, AxNameT
  1403  
  1404      use sltt_const , only : SLTTConstInit
  1405      use sltt_extarr, only : SLTTExtArrInit
  1406  
  1407  
  1408      ! NAMELIST ファイル入力に関するユーティリティ
  1409      ! Utilities for NAMELIST file input
  1410      !
  1411      use namelist_util, only: namelist_filename, NmlutilMsg
  1412  
  1413      ! 種別型パラメタ
  1414      ! Kind type parameter
  1415      !
  1416      use dc_types, only: &
  1417        & STDOUT, &             ! 標準出力の装置番号. Unit number of standard output
  1418        & STRING                ! 文字列.       Strings.
  1419      ! ファイル入出力補助
  1420      ! File I/O support
  1421      !
  1422      use dc_iounit, only: FileOpen
  1423  
  1424      use sltt_const , only : iexmin, iexmax, jexmin, jexmax
  1425  
  1426      !
  1427      ! local variables
  1428      !
  1429      integer:: i               ! 東西方向に回る DO ループ用作業変数
  1430                                ! Work variables for DO loop in zonal direction
  1431      integer:: j               ! 南北方向に回る DO ループ用作業変数
  1432                                ! Work variables for DO loop in meridional direction
  1433      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1434                                ! Work variables for DO loop in vertical direction
  1435      integer:: n
  1436  
  1437      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1438                                ! Unit number for NAMELIST file open
  1439      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1440                                ! IOSTAT of NAMELIST read
  1441      ! NAMELIST 変数群
  1442      ! NAMELIST group name
  1443      !
  1444      namelist /sltt_nml/                                        &
  1445        & FlagSLTTArcsineHor, FlagSLTTArcsineVer, SLTTIntHor, SLTTIntVer, SLTTArcSineFactor
  1446  
  1447      ! 実行文 ; Executable statement
  1448      !
  1449  
  1450      if ( sltt_inited ) return
  1451  
  1452      if ( mod( jmax, 2 ) /= 0 ) then
  1453        stop 'jmax cannot be divided by 2.'
  1454      end if
  1455  
  1456      call SLTTConstInit
  1457  
  1458  
  1459      ! デフォルト値の設定
  1460      ! Default values settings
  1461      !
  1462      FlagSLTTArcsineHor          = .true.
  1463      FlagSLTTArcsineVer          = .true.
  1464      SLTTArcSineFactor           = 1.05_DP
  1465      SLTTIntHor                  = "HQ"
  1466      SLTTIntVer                  = "HQ"
  1467  
  1468  
  1469      ! NAMELIST の読み込み
  1470      ! NAMELIST is input
  1471      !
  1472      if ( trim(namelist_filename) /= '' ) then
  1473        call FileOpen( unit_nml, &          ! (out)
  1474          & namelist_filename, mode = 'r' ) ! (in)
  1475  
  1476        rewind( unit_nml )
  1477        read( unit_nml, &                ! (in)
  1478          & nml = sltt_nml, &  ! (out)
  1479          & iostat = iostat_nml )        ! (out)
  1480        close( unit_nml )
  1481  
  1482        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1483        if ( iostat_nml == 0 ) write( STDOUT, nml = sltt_nml )
  1484      end if
  1485  
  1486  
  1487  
  1488      allocate( x_LonS   (0:imax-1) )
  1489      allocate( x_SinLonS(0:imax-1) )
  1490      allocate( x_CosLonS(0:imax-1) )
  1491      allocate( y_latS   (1:jmax/2) )
  1492      allocate( y_SinLatS(1:jmax/2) )
  1493      allocate( y_CosLatS(1:jmax/2) )
  1494      do i = 0, imax-1
  1495        x_LonS   (i) = x_Lon(i)
  1496        x_SinLonS(i) = sin( x_LonS(i) )
  1497        x_CosLonS(i) = cos( x_LonS(i) )
  1498      end do
  1499      do j = 1, jmax/2
  1500        y_LatS   (j) = y_Lat(j)
  1501        y_SinLatS(j) = sin( y_LatS(j) )
  1502        y_CosLatS(j) = cos( y_LatS(j) )
  1503      end do
  1504  
  1505      allocate( x_LonN   (0:imax-1) )
  1506      allocate( x_SinLonN(0:imax-1) )
  1507      allocate( x_CosLonN(0:imax-1) )
  1508      allocate( y_latN   (1:jmax/2) )
  1509      allocate( y_SinLatN(1:jmax/2) )
  1510      allocate( y_CosLatN(1:jmax/2) )
  1511      do i = 0, imax-1
  1512        x_LonN   (i) = x_Lon(i)
  1513        x_SinLonN(i) = sin( x_LonN(i) )
  1514        x_CosLonN(i) = cos( x_LonN(i) )
  1515      end do
  1516      do j = 1, jmax/2
  1517        y_LatN   (j) = y_Lat(j+jmax/2)
  1518        y_SinLatN(j) = sin( y_LatN(j) )
  1519        y_CosLatN(j) = cos( y_LatN(j) )
  1520      end do
  1521  
  1522      allocate( x_ExtLonS( iexmin:iexmax ) )
  1523      allocate( x_ExtLonN( iexmin:iexmax ) )
  1524  
  1525      allocate( y_ExtLatS( jexmin:jexmax ) )
  1526      allocate( y_ExtLatN( jexmin:jexmax ) )
  1527  
  1528  
  1529      call SLTTExtArrInit(                            &
  1530        & x_LonS, y_LatS, x_LonN, y_LatN,             & ! (in )
  1531        & x_ExtLonS, y_ExtLatS, x_ExtLonN, y_ExtLatN  & ! (out)
  1532        & )
  1533  
  1534  
  1535      ! ヒストリデータ出力のためのへの変数登録
  1536      ! Register of variables for history data output
  1537      !
  1538      do n = 1, ncmax
  1539        call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtHorMassFix', &
  1540          & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  1541          & 'tendency of horizontal mass fix of '//trim(a_QMixName(n)), 's-1' )
  1542        call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtVerMassFix', &
  1543          & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  1544          & 'tendency of vertical mass fix of '//trim(a_QMixName(n)), 's-1' )
  1545        call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtTotMassFix', &
  1546          & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  1547          & 'tendency of mass fix of '//trim(a_QMixName(n)), 's-1' )
  1548      end do
  1549  
  1550  
  1551      ! 印字 ; Print
  1552      !
  1553      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1554      call MessageNotify( 'M', module_name, '  FlagSLTTArcsineHor       = %b', l = (/ FlagSLTTArcsineHor /) )
  1555      call MessageNotify( 'M', module_name, '  FlagSLTTArcsineVer       = %b', l = (/ FlagSLTTArcsineVer /) )
  1556      call MessageNotify( 'M', module_name, '  SLTTArcsineFactor        = %f', d = (/ SLTTArcsineFactor /) )
  1557      call MessageNotify( 'M', module_name, '  SLTTIntHor               = %c', c1 = trim( SLTTIntHor ) )
  1558      call MessageNotify( 'M', module_name, '  SLTTIntVer               = %c', c1 = trim( SLTTIntVer ) )
  1559      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1560  
  1561      sltt_inited = .true.
  1562  
  1563    end subroutine SLTTInit
  1564  
  1565    !--------------------------------------------------------------------------------------
  1566  
  1567  end module sltt
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:38 2016
FILE NAME: i.sltt.F90
PROGRAM NAME: sltt
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 物質移流過程 (セミラグランジュ法)
     2:             !
     3:             != Semi-Lagrangian Tracer Transport scheme
     4:             !
     5:             ! Authors::   Hiroki KASHIMURA, Yoshiyuki O. TAKAHASHI
     6:             ! Version::
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2013. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module sltt
    13:               !
    14:               != 物質移流 (セミラグランジュ法, Enomoto (2008) modified)
    15:               !
    16:               != Tracer Transport (Semi-Lagrangian method, Enomoto (2008) modified)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 物質移流を非保存型のセミラグランジュ法で演算するモジュールです. 
    21:               ! 上流点探索には Williamson and Rasch (1989, MWR) を
    22:               ! 補間には Enomoto (2008) を応用した方法を用いています。
    23:               ! すなわちスペクトルから求めた１階微分の値を利用した５次精度の変則エルミート補間です。
    24:               ! 非負を保証するために arcsine 変換フィルタを用いています。
    25:               ! スペクトル変換・高精度補間に由来する人工的な短波を除去するために Sun et al. (1996) の
    26:               ! 単調フィルタを応用したものを部分的に用いている。 
    27:               !
    28:               ! This is a tracer transport module. Semi-Lagrangian method (Enomoto 2008 modified)
    29:               ! Arcsine transformation filter is used to avoid negative values.
    30:               ! Monotonicity filter (Sun et al 1996) is partly used.
    31:               !
    32:               !== Procedures List
    33:               !
    34:               ! SLTTMain     :: 移流計算
    35:               ! SLTTInit     :: 初期化
    36:               ! SLTTTest     :: 移流テスト用
    37:               ! ---------------------     :: ------------
    38:               ! SLTTMain     :: Main subroutine for SLTT
    39:               ! SLTTInit     :: Initialization for SLTT
    40:               ! SLTTTest     :: Generate velocity for SLTT Test 
    41:               !
    42:               !== NAMELIST
    43:               !
    44:               ! NAMELIST#
    45:               !
    46:               !== References
    47:               !
    48:               ! * Kashimura, H., T. Enomoto, Y. O. Takahashi, 2013: 
    49:               !   Non-negative filter using arcsine transformation for tracer advection with semi-Lagrangian scheme.
    50:               !   <i>NCTAM</i>, <b>62</b>.
    51:               !
    52:               ! * Enomoto, T., 2008: 
    53:               !   Bicubic Interpolation with Spectral Derivatives. 
    54:               !   <i>SOLA</i>, <b>4</b>, 5-8. doi:10.2151/sola.2008-002
    55:               !
    56:               ! * Williamson, D. L., and Rasch, P. J., 1989:
    57:               !   Two-dimensional semi-Lagrangian transport with shape-preserving interpolation.
    58:               !   <i> Mon. Wea. Rev.</i>, <b>117</b>, 102-129.
    59:               !
    60:               ! * Sun, W.-Y., Yeh, K.-S., and Sun, R.-Y., 1996: 
    61:               !   A simple semi-Lagrangian scheme for advection equations. 
    62:               !   <i>Quarterly Journal of the Royal Meteorological Society</i>, 
    63:               !   <b>122(533)</b>, 1211-1226. doi:10.1002/qj.49712253310
    64:               
    65:               ! モジュール引用 ; USE statements
    66:               !
    67:               ! 種別型パラメタ
    68:               ! Kind type parameter
    69:               !
    70:               use dc_types, only: DP,  & ! 倍精度実数型. Double precision.
    71:                 &                 TOKEN  ! キーワード.   Keywords. 
    72:             
    73:               ! メッセージ出力
    74:               ! Message output
    75:               !
    76:               use dc_message, only: MessageNotify
    77:             
    78:               !
    79:               ! MPI
    80:               !
    81:               use mpi_wrapper, only : MPIWrapperFindMaxVal
    82:             
    83:               ! 時刻管理
    84:               ! Time control
    85:               !
    86:               use timeset, only: &
    87:                 & DelTime
    88:             
    89:               ! 格子点設定
    90:               ! Grid points settings
    91:               !
    92:               use gridset, only:       &
    93:                 &                imax, & ! 経度格子点数.
    94:                                          ! Number of grid points in longitude
    95:                 &                jmax, & ! 緯度格子点数.
    96:                                          ! Number of grid points in latitude
    97:                 &                kmax, & ! 鉛直層数.
    98:                                          ! Number of vertical level
    99:                 &                lmax    ! スペクトルデータの配列サイズ
   100:                                          ! Size of array for spectral data
   101:             
   102:               ! 組成に関わる配列の設定
   103:               ! Settings of array for atmospheric composition
   104:               !
   105:               use composition, only:                              &
   106:                 &                    ncmax,                       &
   107:                                          ! 成分の数
   108:                                          ! Number of composition
   109:                 &                    CompositionInqFlagAdv
   110:             
   111:               ! 質量の補正
   112:               ! Mass fixer
   113:               !
   114:               use mass_fixer, only: &
   115:                 & MassFixerBC02, MassFixerBC02Layer, MassFixerBC02Column, &
   116:                 & MassFixer, MassFixerR95, MassFixerWO94, MassFixerColumn!, MassFixerLayer
   117:             
   118:             
   119:               ! 宣言文 ; Declaration statements
   120:               !
   121:               implicit none
   122:               private
   123:             
   124:               ! 公開手続き
   125:               ! Public procedure
   126:               !
   127:               public :: SLTTInit
   128:               public :: SLTTMain
   129:             
   130:             
   131:             
   132:               ! 公開変数
   133:               ! Public variables
   134:               !
   135:             
   136:               ! 非公開変数
   137:               ! Private variables
   138:               !
   139:               logical, save :: sltt_inited = .false.
   140:                                           ! 初期設定フラグ.
   141:                                           ! Initialization flag
   142:             
   143:               real(DP)    , save, allocatable :: x_LonS   (:)
   144:                                           ! $\lambda_S$ 南半球の経度。
   145:                                           ! longitude in SH.
   146:               real(DP)    , save, allocatable :: x_SinLonS(:)
   147:                                           ! $\sin\lambda_S$
   148:               real(DP)    , save, allocatable :: x_CosLonS(:)
   149:                                           ! $\cos\lambda_S$
   150:               real(DP)    , save, allocatable :: y_LatS   (:)
   151:                                           ! $\varphi_S$ 南半球の緯度。
   152:                                           ! latitude in SH.
   153:               real(DP)    , save, allocatable :: y_SinLatS(:)
   154:                                           ! $\sin\varphai_S$
   155:               real(DP)    , save, allocatable :: y_CosLatS(:)
   156:                                           ! $\cos\varphai_S$
   157:               real(DP)    , save, allocatable :: x_ExtLonS(:)
   158:                                           ! $ x_LonSの拡張配列。
   159:                                           !Extended array of x_LonS.
   160:               real(DP)    , save, allocatable :: y_ExtLatS(:)
   161:                                           ! $ x_LatSの拡張配列。
   162:                                           !Extended array of x_LatS.
   163:             
   164:               real(DP)    , save, allocatable :: x_LonN   (:)
   165:                                           ! $\lambda_N$ 北半球の経度。
   166:                                           ! longitude in NH.
   167:               real(DP)    , save, allocatable :: x_SinLonN(:)
   168:                                           ! $\sin\lambda_N$
   169:               real(DP)    , save, allocatable :: x_CosLonN(:)
   170:                                           ! $\cos\lambda_N$
   171:               real(DP)    , save, allocatable :: y_LatN   (:)
   172:                                           ! $\varphi_N$ 北半球の緯度。
   173:                                           ! latitude in NH.
   174:               real(DP)    , save, allocatable :: y_SinLatN(:)
   175:                                           ! $\sin\varphai_N$
   176:               real(DP)    , save, allocatable :: y_CosLatN(:)
   177:                                           ! $\cos\varphai_N$
   178:               real(DP)    , save, allocatable :: x_ExtLonN(:)
   179:                                           ! $ x_LonNの拡張配列。
   180:                                           !Extended array of x_LonN.
   181:               real(DP)    , save, allocatable :: y_ExtLatN(:)
   182:                                           ! $ x_LatNの拡張配列。
   183:                                           !Extended array of x_LatN.
   184:               logical, save                   :: FlagSLTTArcsineHor
   185:               logical, save                   :: FlagSLTTArcsineVer
   186:                                          ! Arcsine変換の非負フィルタフラグ
   187:                                          ! Flag for non-negative filter using arcsine trasformation
   188:               real(DP), save                  :: SLTTArcSineFactor
   189:             
   190:               character(TOKEN), save          :: SLTTIntHor
   191:                                          ! 水平方向の補間方法を指定するキーワード
   192:                                          ! Keyword for Interpolation Method for Horizontal direction
   193:               character(TOKEN), save          :: SLTTIntVer
   194:                                          ! 鉛直方向の補間方法を指定するキーワード
   195:                                          ! Keyword for Interpolation Method for Vertical direction
   196:             
   197:             
   198:               character(*), parameter:: module_name = 'sltt'
   199:                                           ! モジュールの名称.
   200:                                           ! Module name
   201:               character(*), parameter:: version = &
   202:                 & '$Name:  $' // &
   203:                 & '$Id: sltt.F90,v 1.8 2014/06/29 07:21:28 yot Exp $'
   204:                                           ! モジュールのバージョン
   205:                                           ! Module version
   206:             
   207:             
   208:               !--------------------------------------------------------------------------------------
   209:             
   210:             contains
   211:             
   212:               !--------------------------------------------------------------------------------------
   213:             
   214:               subroutine SLTTMain(             &
   215:                 & xyr_PressB, xyr_PressA,      & !(in )
   216:                 & xyz_UN, xyz_VN, xyr_SigDotN, & !(in )
   217:                 & xyzf_DQMixDtPhy,             & !(in )
   218:                 & xyzf_QMixB,                  & !(in )
   219:                 & xyzf_QMixA                   & !(out)
   220:                 & )
   221:                 ! セミラグランジュ法による物質移流計算を行う。
   222:                 ! Calculates tracer transports by Semi-Lagrangian method
   223:             
   224:                 ! ヒストリデータ出力
   225:                 ! History data output
   226:                 !
   227:                 use gtool_historyauto, only: HistoryAutoPut
   228:             
   229:                 use timeset    , only : &
   230:                   & TimeN, &
   231:                   & DelTime
   232:                                           ! $\Delta t$
   233:             
   234:                 ! 組成に関わる配列の設定
   235:                 ! Settings of array for atmospheric composition
   236:                 !
   237:                 use composition, only:                              &
   238:                   &                    ncmax,                       &
   239:                                          ! 成分の数
   240:                                          ! Number of composition
   241:                   &                    a_QMixName,                  &
   242:                                          ! 成分の変数名
   243:                                          ! Name of variables for composition
   244:                   &                    CompositionInqFlagAdv
   245:             
   246:             !!$    ! 座標データ設定
   247:             !!$    ! Axes data settings
   248:             !!$    !
   249:             !!$    use axesset, only: &
   250:             !!$      & z_DelSigma            ! $ \Delta \sigma $ (整数).
   251:             !!$                              ! $ \Delta \sigma $ (Full)
   252:             
   253:                 real(DP), intent(in ) :: xyr_PressB(0:imax-1, 1:jmax, 0:kmax)
   254:                                           !
   255:                                           ! Pressure at current time step
   256:                 real(DP), intent(in ) :: xyr_PressA(0:imax-1, 1:jmax, 0:kmax)
   257:                                           !
   258:                                           ! Pressure at next time step
   259:                 real(DP), intent(in ) :: xyz_UN    (0:imax-1, 1:jmax, 1:kmax)
   260:                                           ! 東西風速
   261:                                           ! Zonal Wind
   262:                 real(DP), intent(in ) :: xyz_VN    (0:imax-1, 1:jmax, 1:kmax)
   263:                                           ! 南北風速
   264:                                           ! Meridional Wind
   265:                 real(DP), intent(in ) :: xyr_SigDotN(0:imax-1, 1:jmax, 0:kmax)
   266:                                           ! 鉛直流速（SigmaDot）
   267:                 real(DP), intent(in ):: xyzf_DQMixDtPhy(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   268:                                           ! $ \left(\DP{q}{t}\right)^{phy} $ . 
   269:                                           ! 外力項 (物理過程) による比湿変化. 
   270:                                           ! Temperature tendency by external force terms (physical processes)
   271:                 real(DP), intent(in ) :: xyzf_QMixB(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   272:                                           ! 物質混合比
   273:                                           ! Mix ratio of the tracers
   274:                 real(DP), intent(out) :: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   275:                                           ! 物質混合比
   276:                                           ! Mix ratio of the tracers
   277:             
   278:                 ! 作業変数
   279:                 ! Work variables
   280:                 !
   281:                 real(DP) :: f_QMixMax(1:ncmax)
   282:                                           ! 各物質混合比の最大値
   283:                                           ! Maximum of each mix ratio of the tracers
   284:                 real(DP) :: f_QMixProcMax(1:ncmax)
   285:                                           ! 各物質混合比のプロセス内最大値
   286:                                           ! Maximum of each mix ratio of the tracers in each process
   287:                 real(DP) :: f_QMixLinMax(1:ncmax)
   288:                 real(DP) :: f_QMixLinProcMax(1:ncmax)
   289:             
   290:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   291:                                           ! Work variables for DO loop in dimension of constituents
   292:             
   293:                 real(DP) :: xyz_UTest    (0:imax-1, 1:jmax, 1:kmax)
   294:                                           ! 東西風速（テスト用）
   295:                                           ! Zonal Wind (for test)  
   296:                 real(DP) :: xyz_VTest    (0:imax-1, 1:jmax, 1:kmax)
   297:                                           ! 南北風速（テスト用）
   298:                                           ! Meridional Wind (for test) 
   299:                 real(DP) :: xyr_SigDotTest(0:imax-1, 1:jmax, 0:kmax)
   300:                                           ! 鉛直流速（テスト用）;SigmaDot (for test) 
   301:                 real(DP) :: xyzf_QMixSave(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   302:             
   303:                 real(DP) :: xyzf_QMixLinATentative(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   304:                 real(DP) :: xyzf_QMixLinA         (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   305:             
   306:                 ! Variables for monotone limiter
   307:                 real(DP) :: xyzf_QMixMinA         (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   308:                 real(DP) :: xyzf_QMixMaxA         (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   309:             
   310:                 real(DP) :: xyzf_QMixSaveMassFix  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   311:                 real(DP) :: xyzf_DQMixDtHorMassFix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   312:                 real(DP) :: xyzf_DQMixDtVerMassFix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   313:                 real(DP) :: xyzf_DQMixDtTotMassFix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   314:             
   315:             !!$    real(DP) :: xyrf_QMixA(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   316:             !!$
   317:             !!$    integer :: k
   318:             
   319:             
   320:                 ! セミラグランジュ法による物質移流計算
   321:                 ! Semi-Lagrangian method for tracer transport      
   322:             !!$!      xyzf_QMixA = xyzf_QMixB !テスト用
   323:             !!$      xyzf_QMixA = xyzf_QMixB + xyzf_DQMixDtPhy * DelTime
   324: ***W--->A       xyzf_QMixA = xyzf_QMixB + xyzf_DQMixDtPhy * 2.0_DP * DelTime
   325: ||||        
   326: ||||        
   327: ||||            ! Save a variable for mass fixer
   328: ***W--- A       xyzf_QMixSave = xyzf_QMixA
   329:             
   330:             
   331:                 ! Mass fixer
   332:                 !   Constituents
   333:                 !
   334:             !!$!        call MassFixer(                  &
   335:             !!$    call MassFixerColumn(                  &
   336:             !!$!          & xyr_PressA,                  & ! (in)
   337:             !!$      & xyr_PressB,                  & ! (in)
   338:             !!$      & xyzf_QMixA,                  & ! (inout)
   339:             !!$      & xyr_PressRef = xyr_PressB,   & ! (in) optional
   340:             !!$!          & xyzf_QMixRef = ( xyzf_QMixB+xyzf_DQMixDtPhy*DelTime ) & ! (in) optional
   341:             !!$!      & xyzf_QMixRef = ( xyzf_QMixB+xyzf_DQMixDtPhy*2.0_DP*DelTime ) & ! (in) optional
   342:             !!$      & xyzf_QMixRef = xyzf_QMixSave & ! (in) optional
   343:             !!$      & )
   344:                 !
   345:             !!$      call MassFixer(                   &
   346:                   call MassFixerColumn(             &
   347:                     & xyr_PressB,                   & ! (in)
   348:                     & xyzf_QMixA,                   & ! (inout)
   349:                     & xyr_PressRef = xyr_PressB,    & ! (in) optional
   350:                     & xyzf_QMixRef = xyzf_QMixSave  & ! (in) optional
   351:                     & )
   352:             
   353:             
   354:                 ! Save a variable for mass fixer
   355: ***W--->A       xyzf_QMixSave = xyzf_QMixA
   356: ||||        
   357: ||||            ! Variable for linear interpolation
   358: ***W--- A       xyzf_QMixLinA = xyzf_QMixA
   359:             
   360:             
   361:                 if ( FlagSLTTArcsineHor ) then
   362:                   ! 非負を保証するための arcsine変換フィルタ
   363:                   ! Arcsine transformation for non-negative filter 
   364:             
   365: +------>          do n = 1, ncmax
   366: |W**=== A           f_QMixProcMax(n) = maxval( xyzf_QMixA(:,:,:,n) )
   367: +------           end do
   368:                   call MPIWrapperFindMaxVal( &
   369:                     & ncmax, f_QMixProcMax,  & ! (in)
   370:                     & f_QMixMax              & ! (out)
   371:                     & )
   372: V====== A         f_QMixMax = f_QMixMax * SLTTArcSineFactor + 1.0e-14_DP
   373: +------>          do n = 1, ncmax
   374: |W**=== A           xyzf_QMixA(:,:,:,n) = &
   375: |                     & 0.5_DP*(asin(2.0_DP*xyzf_QMixA(:,:,:,n)/f_QMixMax(n) - 1.0_DP))
   376: +------           end do
   377:             
   378:                   ! arcsine transformed variable is used for linear interpolation too
   379: W***=== A         xyzf_QMixLinA    = xyzf_QMixA
   380: V------>A         f_QMixLinProcMax = f_QMixProcMax
   381: V------ A         f_QMixLinMax     = f_QMixMax
   382:                 end if
   383:             
   384:                 ! 水平セミラグ
   385:                 ! Horizontal
   386:             !!$    xyzf_QMixA = SLTTHorAdv( xyzf_QMixA, xyz_UN, xyz_VN )
   387: ***V--->        xyzf_QMixA = SLTTHorAdv( xyzf_QMixA, xyz_UN, xyz_VN,    & ! (in)
   388: ||||              &                      xyzf_QMixLinA = xyzf_QMixLinA, & ! (inout) optional
   389: ||||              &                      xyzf_QMixMinA = xyzf_QMixMinA, & ! (out) optional
   390: ||||              &                      xyzf_QMixMaxA = xyzf_QMixMaxA  ) ! (out) optional
   391: ||||        
   392: ||||            ! Monotonic filter
   393: ||||            ! see Diamantakis and Flemming (2014) for BS limiter 
   394: ||||            ! but limiter is applied separately in horizontal and vertical directions
   395: ||||        
   396: ***V--- A       xyzf_QMixA = max( min( xyzf_QMixA, xyzf_QMixMaxA ), xyzf_QMixMinA )
   397:             
   398:             
   399:             
   400:                 !==================================================
   401:                 ! Calculation in a case in which mass fixer applied in horizontal and 
   402:                 ! vertical directions separately
   403:                 !
   404:             !!$    if (FlagSLTTArcsine) then
   405:             !!$      ! 非負を保証するための arcsine変換フィルタ（逆変換）
   406:             !!$      ! Arcsine transformation for non-negative filter
   407:             !!$      do n = 1, ncmax
   408:             !!$        xyzf_QMixA(:,:,:,n) = &
   409:             !!$          & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixA(:,:,:,n))+1.0_DP) 
   410:             !!$!        xyzf_QMixLinA(:,:,:,n) = &
   411:             !!$!          & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixLinA(:,:,:,n))+1.0_DP) 
   412:             !!$      enddo
   413:             !!$    endif
   414:             !!$    !
   415:             !!$    xyzf_QMixSaveMassFix = xyzf_QMixA
   416:             !!$    !
   417:             !!$    call MassFixerBC02Layer(   &
   418:             !!$      & xyr_PressA,            & ! (in)
   419:             !!$      & xyzf_QMixA,            & ! (inout)
   420:             !!$      & xyzf_QMixLinA,         & ! (in)
   421:             !!$      & xyr_PressB,            & ! (in)
   422:             !!$      & xyzf_QMixSave          & ! (in)
   423:             !!$      & )
   424:             !!$    !
   425:             !!$    xyzf_DQMixDtHorMassFix = &
   426:             !!$      & ( xyzf_QMixA - xyzf_QMixSaveMassFix ) / ( 2.0_DP * DelTime )
   427:             !!$    !
   428:             !!$    ! Save a variable for mass fixer
   429:             !!$    xyzf_QMixSave = xyzf_QMixA
   430:             !!$    !
   431:             !!$    ! Variable for linear interpolation
   432:             !!$    xyzf_QMixLinATentative = xyzf_QMixA
   433:             !!$    !
   434:             !!$    if (FlagSLTTArcsine) then
   435:             !!$      ! 非負を保証するための arcsine変換フィルタ
   436:             !!$      ! Arcsine transformation for non-negative filter
   437:             !!$      !
   438:             !!$      do n = 1, ncmax
   439:             !!$        f_QMixProcMax(n) = maxval( xyzf_QMixA(:,:,:,n) )
   440:             !!$      end do
   441:             !!$      call MPIWrapperFindMaxVal( &
   442:             !!$        & ncmax, f_QMixProcMax,  & ! (in)
   443:             !!$        & f_QMixMax              & ! (out)
   444:             !!$        & )
   445:             !!$      f_QMixMax = f_QMixMax * SLTTArcSineFactor + 1.0e-14_DP
   446:             !!$      do n = 1, ncmax
   447:             !!$        xyzf_QMixA(:,:,:,n) = &
   448:             !!$          & 0.5_DP*(asin(2.0_DP*xyzf_QMixA(:,:,:,n)/f_QMixMax(n) - 1.0_DP))
   449:             !!$      end do
   450:             !!$    end if
   451:                 !==================================================
   452:                 ! Calculation in a case in which mass fixer applied in horizontal and 
   453:                 ! vertical directions in a same time
   454:                 !
   455:             
   456:                 if ( ( .not. FlagSLTTArcsineHor ) .and. ( FlagSLTTArcsineVer ) ) then
   457:                   ! 非負を保証するための arcsine変換フィルタ
   458:                   ! Arcsine transformation for non-negative filter 
   459:             
   460: +------>          do n = 1, ncmax
   461: |W**=== A           f_QMixProcMax(n) = maxval( xyzf_QMixA(:,:,:,n) )
   462: +------           end do
   463:                   call MPIWrapperFindMaxVal( &
   464:                     & ncmax, f_QMixProcMax,  & ! (in)
   465:                     & f_QMixMax              & ! (out)
   466:                     & )
   467: V====== A         f_QMixMax = f_QMixMax * SLTTArcSineFactor + 1.0e-14_DP
   468: +------>          do n = 1, ncmax
   469: |W**=== A           xyzf_QMixA(:,:,:,n) = &
   470: |                     & 0.5_DP*(asin(2.0_DP*xyzf_QMixA(:,:,:,n)/f_QMixMax(n) - 1.0_DP))
   471: +------           end do
   472:             
   473: +------>          do n = 1, ncmax
   474: |W**=== A           f_QMixLinProcMax(n) = maxval( xyzf_QMixLinA(:,:,:,n) )
   475: +------           end do
   476:                   call MPIWrapperFindMaxVal( &
   477:                     & ncmax, f_QMixLinProcMax,  & ! (in)
   478:                     & f_QMixLinMax              & ! (out)
   479:                     & )
   480: V====== A         f_QMixLinMax = f_QMixLinMax * SLTTArcSineFactor + 1.0e-14_DP
   481: +------>          do n = 1, ncmax
   482: |W**=== A           xyzf_QMixLinA(:,:,:,n) = &
   483: |                     & 0.5_DP*(asin(2.0_DP*xyzf_QMixLinA(:,:,:,n)/f_QMixLinMax(n) - 1.0_DP))
   484: +------           end do
   485:             
   486:                 else if ( ( FlagSLTTArcsineHor ) .and. ( .not. FlagSLTTArcsineVer ) ) then
   487:                   ! 非負を保証するための arcsine変換フィルタ（逆変換）
   488:                   ! Arcsine transformation for non-negative filter
   489:             
   490: +------>          do n = 1, ncmax
   491: |W**=== A           xyzf_QMixA(:,:,:,n) = &
   492: |                     & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixA(:,:,:,n))+1.0_DP)
   493: +------           end do
   494: +------>          do n = 1, ncmax
   495: |W**=== A           xyzf_QMixLinA(:,:,:,n) = &
   496: |                     & f_QMixLinMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixLinA(:,:,:,n))+1.0_DP)
   497: +------           end do
   498:                 end if
   499:             
   500: ***W--->A       xyzf_DQMixDtHorMassFix = 0.0_DP
   501: ***W--- A       xyzf_QMixLinATentative = xyzf_QMixLinA
   502:                 !==================================================
   503:             
   504:             
   505:                 ! 鉛直セミラグ
   506:                 ! Vertical 
   507:             !!$    xyzf_QMixA = SLTTVerAdv( xyr_SigDotN, xyzf_QMixA )
   508: ***V--->        xyzf_QMixA = SLTTVerAdv( xyr_SigDotN, xyzf_QMixA,                &
   509: ||||              &                      xyzf_QMixLin  = xyzf_QMixLinATentative, & ! (in   ) optional
   510: ||||              &                      xyzf_QMixLinA = xyzf_QMixLinA,          & ! (out  ) optional
   511: ||||              &                      xyzf_QMixMinA = xyzf_QMixMinA,          & ! (inout) optional
   512: ||||              &                      xyzf_QMixMaxA = xyzf_QMixMaxA  )          ! (inout) optional
   513: ||||        
   514: ||||        
   515: ||||            ! Monotonic filter
   516: ||||            ! see Diamantakis and Flemming (2014) for BS limiter 
   517: ||||            ! but limiter is applied separately in horizontal and vertical directions
   518: ||||        
   519: ***V--- A       xyzf_QMixA = max( min( xyzf_QMixA, xyzf_QMixMaxA ), xyzf_QMixMinA )
   520:             
   521:             
   522:                 ! Vertical advection by finite difference method
   523:                 !
   524:             !!$    do n = 1, ncmax
   525:             !!$      k = 1
   526:             !!$      xyrf_QMixA(:,:,k,n) = 1.0e100_DP
   527:             !!$      do k = 1, kmax-1
   528:             !!$        xyrf_QMixA(:,:,k,n) = &
   529:             !!$          & ( xyzf_QMixA(:,:,k,n) + xyzf_QMixA(:,:,k+1,n) ) / 2.0_DP
   530:             !!$      end do
   531:             !!$      k = kmax
   532:             !!$      xyrf_QMixA(:,:,k,n) = 1.0e100_DP
   533:             !!$    end do
   534:             !!$    do n = 1, ncmax
   535:             !!$      do k = 1, kmax
   536:             !!$        xyzf_QMixA(:,:,k,n) = xyzf_QMixA(:,:,k,n)                     &
   537:             !!$          & + (                                                       &
   538:             !!$          &     - (   xyr_SigDotN(:,:,k-1) * xyrf_QMixA(:,:,k-1,n)    &
   539:             !!$          &         - xyr_SigDotN(:,:,k  ) * xyrf_QMixA(:,:,k  ,n) )  &
   540:             !!$          &       / z_DelSigma(k)                                     &
   541:             !!$          &     + xyzf_QMixA(:,:,k,n)                                 &
   542:             !!$          &       * ( xyr_SigDotN(:,:,k-1) - xyr_SigDotN(:,:,k  ) )   &
   543:             !!$          &       / z_DelSigma(k)                                     &
   544:             !!$          &   ) * 2.0_DP * DelTime
   545:             !!$      end do
   546:             !!$    end do
   547:             
   548:             
   549:                 ! 移流テスト
   550:             !    call SLTTTest(xyz_UTest, xyz_VTest, xyr_SigDotTest)
   551:             !    xyzf_QMixA = SLTTHorAdv( xyzf_QMixA, xyz_UTest, xyz_VTest )           ! 水平セミラグ
   552:             !    xyzf_QMixA = SLTTVerAdv( xyr_SigDotTest, xyzf_QMixA )              ! 鉛直セミラグ
   553:             
   554:                 if ( FlagSLTTArcsineVer ) then
   555:                   ! 非負を保証するための arcsine変換フィルタ（逆変換）
   556:                   ! Arcsine transformation for non-negative filter
   557:             
   558: +------>          do n = 1, ncmax
   559: |W**=== A           xyzf_QMixA(:,:,:,n) = &
   560: |                     & f_QMixMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixA(:,:,:,n))+1.0_DP)
   561: +------           end do
   562: +------>          do n = 1, ncmax
   563: |W**=== A           xyzf_QMixLinA(:,:,:,n) = &
   564: |                     & f_QMixLinMax(n)*(0.5_DP)*(sin(2.0_DP*xyzf_QMixLinA(:,:,:,n))+1.0_DP)
   565: +------           end do
   566:                 end if
   567:             
   568:             
   569:             !!$!      xyzf_QMixA = xyzf_QMixB !テスト用
   570:             !!$      xyzf_QMixA = xyzf_QMixA + xyzf_DQMixDtPhy * DelTime
   571:             
   572:             
   573:                 ! Mass fixer
   574:             !!$    call MassFixerColumn(               &
   575:             !!$      & xyr_PressA,                     & ! (in)
   576:             !!$      & xyzf_QMixA,                     & ! (inout)
   577:             !!$!      & xyr_PressRef = xyr_PressB,  & ! (in) optional
   578:             !!$      & xyr_PressRef = xyr_PressA,      & ! (in) optional
   579:             !!$      & xyzf_QMixRef = xyzf_QMixSave    & ! (in) optional
   580:             !!$      & )
   581:             
   582:                 !==================================================
   583:                 ! Calculation in a case in which other type of mass fixer is applied
   584:                 !
   585:             !!$    xyzf_QMixSaveMassFix = xyzf_QMixA
   586:             !!$    !
   587:             !!$!    call MassFixer(                   &
   588:             !!$!    call MassFixerWO94(               &
   589:             !!$    call MassFixerR95(                &
   590:             !!$      & xyr_PressA,                   & ! (in)
   591:             !!$      & xyzf_QMixA,                   & ! (inout)
   592:             !!$      & xyr_PressRef = xyr_PressB,    & ! (in) optional
   593:             !!$      & xyzf_QMixRef = xyzf_QMixSave  & ! (in) optional
   594:             !!$      & )
   595:             !!$    !
   596:             !!$    xyzf_DQMixDtVerMassFix = 0.0_DP
   597:                 !==================================================
   598:                 ! Calculation in a case in which mass fixer applied in horizontal and 
   599:                 ! vertical directions separately
   600:                 !
   601:             !!$    xyzf_QMixSaveMassFix = xyzf_QMixA
   602:             !!$    !
   603:             !!$    call MassFixerBC02Column(        &
   604:             !!$      & xyr_PressA,            & ! (in)
   605:             !!$      & xyzf_QMixA,            & ! (inout)
   606:             !!$      & xyzf_QMixLinA,         & ! (in)
   607:             !!$      & xyr_PressA,            & ! (in)
   608:             !!$      & xyzf_QMixSave          & ! (in)
   609:             !!$      & )
   610:             !!$    !
   611:             !!$    xyzf_DQMixDtVerMassFix = &
   612:             !!$      & ( xyzf_QMixA - xyzf_QMixSaveMassFix ) / ( 2.0_DP * DelTime )
   613:             !!$    !
   614:             !!$    xyzf_DQMixDtTotMassFix = &
   615:             !!$      & xyzf_DQMixDtHorMassFix + xyzf_DQMixDtVerMassFix
   616:                 !==================================================
   617:                 ! Calculation in a case in which mass fixer applied in horizontal and 
   618:                 ! vertical directions in a same time
   619:                 !
   620: W***=== A       xyzf_QMixSaveMassFix = xyzf_QMixA
   621:                 !
   622:                 call MassFixerBC02(        &
   623:                   & xyr_PressA,            & ! (in)
   624:                   & xyzf_QMixA,            & ! (inout)
   625:                   & xyzf_QMixLinA,         & ! (in)
   626:                   & xyr_PressB,            & ! (in)
   627:                   & xyzf_QMixSave          & ! (in)
   628:                   & )
   629:                 !
   630: ***W--->A       xyzf_DQMixDtVerMassFix = 0.0_DP
   631: ||||            !==================================================
   632: ||||        
   633: ***W--- A       xyzf_DQMixDtTotMassFix = &
   634:                   & + ( xyzf_QMixA - xyzf_QMixSaveMassFix ) / ( 2.0_DP * DelTime )
   635:             
   636:             
   637: +------>        do n = 1, ncmax
   638: |                 call HistoryAutoPut( TimeN, 'SLD'//trim(a_QMixName(n))//'DtHorMassFix', &
   639: |                   & xyzf_DQMixDtHorMassFix(:,:,:,n) )
   640: |                 call HistoryAutoPut( TimeN, 'SLD'//trim(a_QMixName(n))//'DtVerMassFix', &
   641: |                   & xyzf_DQMixDtVerMassFix(:,:,:,n) )
   642: |                 call HistoryAutoPut( TimeN, 'SLD'//trim(a_QMixName(n))//'DtTotMassFix', &
   643: |                   & xyzf_DQMixDtTotMassFix(:,:,:,n) )
   644: +------         end do
   645:             
   646:             
   647:               end subroutine SLTTMain
   648:             
   649:               !----------------------------------------------------------------------------
   650:             
   651:               function SLTTHorAdv( xyzf_QMix, xyz_U, xyz_V,      & ! (in)
   652:                 &                  xyzf_QMixLinA,                & ! (inout) optional
   653:                 &                  xyzf_QMixMinA, xyzf_QMixMaxA  & ! (out) optional
   654:                 & ) result( xyzf_QMixA )
   655:                 ! セミラグランジュ法による水平移流の計算
   656:                 ! Calculates tracer transports by Semi-Lagrangian method for horizontal direction
   657:             
   658:                 use timeset    , only : DelTime
   659:                                           ! $\Delta t$
   660:                 use axesset    , only : x_Lon, y_Lat
   661:                                           ! $\lambda, \varphai$ lon and lat
   662:                 use sltt_const , only : dtjw, iexmin, iexmax, jexmin, jexmax
   663:                 use sltt_extarr, only : SLTTExtArrExt, SLTTExtArrExt2
   664:                                           ! 配列拡張ルーチン
   665:                                           ! Expansion of arrays
   666:                 use sltt_dp    , only : SLTTDPHor
   667:                                           ! 水平上流点探索
   668:                                           ! Finding departure point in horizontal
   669:                 use sltt_lagint, only : SLTTIrrHerIntK13, SLTTIrrLinInt, SLTTLagIntHorMaxMin
   670:                                           ! 水平２次元の補間
   671:                                           ! 2D Interpolation in horizontal 
   672:             
   673:                 ! SPMODEL ライブラリ, 球面上の問題を球面調和函数変換により解く(多層対応) 
   674:                 ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
   675:                 !
   676:             
   677:             
   678:                 use wa_mpi_module, only:                     &
   679:                   & wa_xya            => wa_xva,             &
   680:                   & xya_wa            => xva_wa, &
   681:                   & wa_DLon_wa, &
   682:                   & xya_GradLat_wa => xva_GradLat_wa
   683:             
   684:             
   685:             
   686:             
   687:                 real(DP), intent(in ) :: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   688:                                           ! 現在時刻の物質混合比
   689:                                           ! Present mix ratio of the tracers
   690:                 real(DP), intent(in ) :: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
   691:                                           ! 東西風速
   692:                                           ! Zonal Wind
   693:                 real(DP), intent(in ) :: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
   694:                                           ! 南北風速
   695:                                           ! Meridional Wind
   696:                 real(DP), intent(inout), optional :: xyzf_QMixLinA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   697:                                           ! 次ステップの物質混合比
   698:                                           ! Next mix ratio of the tracers estimated by linear interpolation
   699:                 real(DP), intent(out), optional :: xyzf_QMixMinA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   700:                 real(DP), intent(out), optional :: xyzf_QMixMaxA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   701:             
   702:                 real(DP) :: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   703:                                           ! 次ステップの物質混合比
   704:                                           ! Next mix ratio of the tracers
   705:                 !
   706:                 ! local variables
   707:                 !
   708:                 real(DP) :: xyzf_ExtQMixS(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   709:                                           ! 現在時刻の物質混合比の拡張配列（南半球）
   710:                                           ! Extended array (SH) of present mix ratio of the tracers.
   711:                 real(DP) :: xyzf_ExtQMixN(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   712:                                           ! 現在時刻の物質混合比の拡張配列（北半球）
   713:                                           ! Extended array (NH) of present mix ratio of the tracers.
   714:             
   715:                 real(DP) :: xyzf_ExtQMixLinAS(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   716:                                           ! 現在時刻の物質混合比の拡張配列（南半球）
   717:                                           ! Extended array (SH) of present mix ratio of the tracers.
   718:                 real(DP) :: xyzf_ExtQMixLinAN(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   719:                                           ! 現在時刻の物質混合比の拡張配列（北半球）
   720:                                           ! Extended array (NH) of present mix ratio of the tracers.
   721:             
   722:             
   723:                 real(DP) :: xyz_ExtUS    (iexmin:iexmax, jexmin:jexmax, 1:kmax)
   724:                                           ! 東西風速の拡張配列（南半球）
   725:                                           ! Extended array (SH) of Zonal Wind        
   726:                 real(DP) :: xyz_ExtUN    (iexmin:iexmax, jexmin:jexmax, 1:kmax)
   727:                                           ! 東西風速の拡張配列（北半球）
   728:                                           ! Extended array (NH) of Zonal Wind        
   729:                 real(DP) :: xyz_ExtVS    (iexmin:iexmax, jexmin:jexmax, 1:kmax)
   730:                                           ! 南北風速の拡張配列（南半球）
   731:                                           ! Extended array (SH) of Meridional Wind
   732:                 real(DP) :: xyz_ExtVN    (iexmin:iexmax, jexmin:jexmax, 1:kmax)
   733:                                           ! 南北風速の拡張配列（北半球）
   734:                                           ! Extended array (NH) of Meridional Wind
   735:             
   736:                 integer:: i, ii           ! 東西方向に回る DO ループ用作業変数
   737:                                           ! Work variables for DO loop in zonal direction
   738:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   739:                                           ! Work variables for DO loop in meridional direction
   740:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   741:                                           ! Work variables for DO loop in vertical direction
   742:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   743:                                           ! Work variables for DO loop in dimension of constituents
   744:             
   745:                 real(DP) :: xyz_DPLonS(0:imax-1, 1:jmax/2, 1:kmax)
   746:                                           ! 上流点経度（南半球）
   747:                                           ! Lon of the departure point (SH)
   748:                 real(DP) :: xyz_DPLonN(0:imax-1, 1:jmax/2, 1:kmax)
   749:                                           ! 上流点経度（北半球）
   750:                                           ! Lon of the departure point (NH)    
   751:                 real(DP) :: xyz_DPLatS(0:imax-1, 1:jmax/2, 1:kmax)
   752:                                           ! 上流点緯度（南半球）
   753:                                           ! Lat of the departure point (SH)    
   754:                 real(DP) :: xyz_DPLatN(0:imax-1, 1:jmax/2, 1:kmax)
   755:                                           ! 上流点緯度（北半球）
   756:                                           ! Lat of the departure point (NH)    
   757:             
   758:                 real(DP) :: xyzf_QMixAS(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   759:                                           ! 次ステップの物質混合比（南半球）
   760:                                           ! Next mix ratio of the tracers (SH)
   761:                 real(DP) :: xyzf_QMixAN(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   762:                                           ! 次ステップの物質混合比（北半球）
   763:                                           ! Next mix ratio of the tracers (NH)
   764:             
   765:                 real(DP) :: xyzf_QMixMinAS(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   766:                 real(DP) :: xyzf_QMixMaxAS(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   767:                 real(DP) :: xyzf_QMixMinAN(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   768:                 real(DP) :: xyzf_QMixMaxAN(0:imax-1, 1:jmax/2, 1:kmax, 1:ncmax)
   769:             
   770:             !---fx, fy, fxy
   771:                 real(DP) :: xyzf_QMix_dlon(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   772:                                           ! 物質混合比の経度微分（グリッド）
   773:                                           ! Zonal derivative of the mix ratio (on grid)
   774:                 real(DP) :: xyzf_QMix_dlat(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   775:                                           ! 物質混合比の緯度微分（グリッド）
   776:                                           ! Meridional derivative of the mix ratio (on grid)
   777:                 real(DP) :: xyzf_QMix_dlonlat(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   778:                                           ! 物質混合比の緯度経度微分（グリッド）
   779:                                           ! Zonal and meridional derivative of the mix ratio (on grid)    
   780:                 real(DP) :: xyzf_ExtQMixS_dlon(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   781:                                           ! 物質混合比の経度微分の拡張配列（南半球）
   782:                                           ! Extended array (SH) of zonal derivative of the mix ratio
   783:                 real(DP) :: xyzf_ExtQMixN_dlon(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   784:                                           ! 物質混合比の経度微分の拡張配列（北半球）
   785:                                           ! Extended array (NH) of zonal derivative of the mix ratio
   786:                 real(DP) :: xyzf_ExtQMixS_dlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   787:                                           ! 物質混合比の緯度微分の拡張配列（南半球）
   788:                                           ! Extended array (SH) of meridional derivative of the mix ratio
   789:                 real(DP) :: xyzf_ExtQMixN_dlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)                              
   790:                                           ! 物質混合比の緯度微分の拡張配列（北半球）
   791:                                           ! Extended array (NH) of meridional derivative of the mix ratio
   792:                 real(DP) :: xyzf_ExtQMixS_dlonlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   793:                                           ! 物質混合比の緯度経度微分の拡張配列（南半球）
   794:                                           ! Extended array (SH) of zonal and meridional derivative of the mix ratio
   795:                 real(DP) :: xyzf_ExtQMixN_dlonlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   796:                                           ! 物質混合比の緯度経度微分の拡張配列（北半球）
   797:                                           ! Extended array (NH) of zonal and meridional derivative of the mix ratio
   798:                 real(DP) :: wzf_QMix(1:lmax, 1:kmax, 1:ncmax)
   799:                                           ! 物質混合比の経度微分（スペクトル）
   800:                                           ! Zonal derivative of the mix ratio (on grid)    
   801:                 real(DP) :: wzf_QMix_dlon(1:lmax, 1:kmax, 1:ncmax)        
   802:                                           ! 物質混合比の経度微分（スペクトル）
   803:                                           ! Zonal derivative of the mix ratio (on grid)
   804:                 real(DP) :: PM            ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   805:                                           ! Sign change flag for array extension; -1.0 for sign change over the pole, 1.0 for no sign change
   806:             
   807:             !---fxx, fyy, fxxyy
   808:             !    real(DP) :: xyzf_QMix_dlon2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   809:             !    real(DP) :: xyzf_QMix_dlat2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   810:             !    real(DP) :: xyzf_QMix_dlon2lat2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   811:             !    real(DP) :: xyzf_ExtQMixS_dlon2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   812:             !    real(DP) :: xyzf_ExtQMixN_dlon2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   813:             !    real(DP) :: xyzf_ExtQMixS_dlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   814:             !    real(DP) :: xyzf_ExtQMixN_dlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   815:             !    real(DP) :: xyzf_ExtQMixS_dlon2lat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   816:             !    real(DP) :: xyzf_ExtQMixN_dlon2lat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   817:             !----fxxy
   818:             !    real(DP) :: xyzf_QMix_dlon2lat(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   819:             !    real(DP) :: xyzf_ExtQMixS_dlon2lat(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   820:             !    real(DP) :: xyzf_ExtQMixN_dlon2lat(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   821:             !----fxyy
   822:             !    real(DP) :: xyzf_QMix_dlonlat2(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   823:             !    real(DP) :: xyzf_ExtQMixS_dlonlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   824:             !    real(DP) :: xyzf_ExtQMixN_dlonlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax, 1:ncmax)
   825:             !----
   826:             !    real(DP) :: wzf_QMix_dlon2(1:lmax, 1:kmax, 1:ncmax)        
   827:             
   828:             
   829:                 ! 実行文 ; Executable statement
   830:                 !
   831:             
   832:                 ! 初期化確認
   833:                 ! Initialization check
   834:                 !
   835:                 if ( .not. sltt_inited ) then
   836:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   837:                 end if
   838:             
   839:             
   840:                 ! QMixの微分計算（スペクトル変換利用）
   841:                 ! Derivatives of QMix
   842: +------>        do n = 1, ncmax
   843: |+V==== A           wzf_QMix(:,:,n) = wa_xya(xyzf_QMix(:,:,:,n))                     ! グリッド→スペクトル
   844: |                                                                                    ! grid -> spectrum
   845: |++V=== A           xyzf_QMix_dlat(:,:,:,n) = xya_GradLat_wa(wzf_QMix(:,:,n))        ! スペクトル→グリッド緯度微分
   846: |                                                                                    ! spectrum -> grid (dQ/dlat)
   847: |+V==== A           wzf_QMix_dlon(:,:,n) = wa_Dlon_wa(wzf_QMix(:,:,n))               ! スペクトル→スペクトル経度微分
   848: |                                                                                    ! spectrum -> spectrum (dQ/dlon)        
   849: |**V--->A           xyzf_QMix_dlon(:,:,:,n) = xya_wa(wzf_QMix_dlon(:,:,n))           ! スペクトル経度微分→グリッド経度微分
   850: ||||                                                                                 ! spectrum (dQ/dlon) -> grid (dQ/dlon)
   851: |**V--- A           xyzf_QMix_dlonlat(:,:,:,n) = xya_GradLat_wa(wzf_QMix_dlon(:,:,n))! スペクトル経度微分→グリッド緯度経度微分
   852: |                                                                                    ! spectrum (dQ/dlon) -> grid (d^2Q/dlon dlat)        
   853: |           
   854: |                   !---fxx, fyy, fxxy, fxyy, fxxyy を計算
   855: |                   !xyzf_QMix_dlon2(:,:,:,n) = xya_wa(wa_Dlon_wa(wzf_QMix_dlon(:,:,n)))
   856: |                   !xyzf_QMix_dlat2(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlat(:,:,:,n)))
   857: |                   !xyzf_QMix_dlon2lat(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlon2(:,:,:,n)))
   858: |                   !xyzf_QMix_dlonlat2(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlonlat(:,:,:,n)))
   859: |                   !xyzf_QMix_dlon2lat2(:,:,:,n) = xya_GradLat_wa(wa_xya(xyzf_QMix_dlon2lat(:,:,:,n)))
   860: +------         enddo
   861:             
   862:             
   863:                 ! 配列の分割と拡張
   864:                 ! Division and extension of arrays
   865:                 !
   866:                 ! 配列の分割と拡張
   867:                 ! Division and extension of arrays
   868:             
   869:                 pm = -1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   870:                              ! -1.0 if the sign of value changes over the poles; if not 1.0. 
   871:             !!$    call SLTTExtArrExt2(                             &
   872:             !!$      & xyzf_QMix_dlon,  pm,                         & ! (in)
   873:             !!$      & xyzf_ExtQMixS_dlon, xyzf_ExtQMixN_dlon       & ! (out)
   874:             !!$      & )
   875:             !!$    call SLTTExtArrExt2(                            &
   876:             !!$      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   877:             !!$      & xyzf_QMix_dlon,  pm,                        & ! (in)
   878:             !!$      & xyzf_ExtQMixS_dlon, xyzf_ExtQMixN_dlon,     & ! (out)
   879:             !!$      & "Wave1"                                     & ! (in)
   880:             !!$      & )
   881:                 call SLTTExtArrExt2(                            &
   882:                   & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   883:                   & xyzf_QMix_dlon,  pm,                        & ! (in)
   884:                   & xyzf_ExtQMixS_dlon, xyzf_ExtQMixN_dlon      & ! (out)
   885:                   & )
   886:             
   887:                 pm = -1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   888:                              ! -1.0 if the sign of value changes over the poles; if not 1.0.
   889:             !!$    call SLTTExtArrExt2(                             &
   890:             !!$      & xyzf_QMix_dlat,  pm,                         & ! (in)
   891:             !!$      & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat       & ! (out)
   892:             !!$      & )
   893:             !!$    call SLTTExtArrExt2(                            &
   894:             !!$      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   895:             !!$      & xyzf_QMix_dlat,  pm,                        & ! (in)
   896:             !!$      & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat,     & ! (out)
   897:             !!$      & "Wave1"                                     & ! (in)
   898:             !!$      & )
   899:                 call SLTTExtArrExt2(                            &
   900:                   & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   901:                   & xyzf_QMix_dlat,  pm,                        & ! (in)
   902:                   & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat      & ! (out)
   903:                   & )
   904:             
   905:                 pm = +1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   906:                              ! -1.0 if the sign of value changes over the poles; if not 1.0.
   907:             !!$    call SLTTExtArrExt2(                             &
   908:             !!$      & xyzf_QMix_dlonlat, pm,                       & ! (in)
   909:             !!$      & xyzf_ExtQMixS_dlonlat, xyzf_ExtQMixN_dlonlat & ! (out)
   910:             !!$      & )
   911:             !!$    call SLTTExtArrExt2(                              &
   912:             !!$      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN,   & ! (in)
   913:             !!$      & xyzf_QMix_dlonlat, pm,                        & ! (in)
   914:             !!$      & xyzf_ExtQMixS_dlonlat, xyzf_ExtQMixN_dlonlat, & ! (out)
   915:             !!$      & "Wave1"                                       & ! (in)
   916:             !!$      & )
   917:                 call SLTTExtArrExt2(                              &
   918:                   & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN,   & ! (in)
   919:                   & xyzf_QMix_dlonlat, pm,                        & ! (in)
   920:                   & xyzf_ExtQMixS_dlonlat, xyzf_ExtQMixN_dlonlat  & ! (out)
   921:                   & )
   922:             
   923:             !-----fxx, fyy, fxxy, fxyy, fxxyy の配列拡張
   924:             !    pm = +1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   925:                               ! -1.0 if the sign of value changes over the poles; if not 1.0. 
   926:             !    call SLTTExtArrExt2(                             &
   927:             !      & xyzf_QMix_dlon2,  pm,                        & ! (in)
   928:             !      & xyzf_ExtQMixS_dlon2, xyzf_ExtQMixN_dlon2     & ! (out)
   929:             !      & )
   930:             !    pm = +1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   931:                               ! -1.0 if the sign of value changes over the poles; if not 1.0. 
   932:             !    call SLTTExtArrExt2(                             &
   933:             !      & xyzf_QMix_dlat2,  pm,                        & ! (in)
   934:             !      & xyzf_ExtQMixS_dlat2, xyzf_ExtQMixN_dlat2     & ! (out)
   935:             !      & )      
   936:             !    pm = -1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   937:                               ! -1.0 if the sign of value changes over the poles; if not 1.0. 
   938:             !    call SLTTExtArrExt2(                               &
   939:             !      & xyzf_QMix_dlon2lat,  pm,                       & ! (in)
   940:             !      & xyzf_ExtQMixS_dlon2lat, xyzf_ExtQMixN_dlon2lat & ! (out)
   941:             !      & )      
   942:             !    pm = -1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   943:                               ! -1.0 if the sign of value changes over the poles; if not 1.0. 
   944:             !    call SLTTExtArrExt2(                               &
   945:             !      & xyzf_QMix_dlonlat2,  pm,                       & ! (in)
   946:             !      & xyzf_ExtQMixS_dlonlat2, xyzf_ExtQMixN_dlonlat2 & ! (out)
   947:             !      & )
   948:             !    pm = +1.0_DP ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。そうでない場合は1.0を与える。
   949:                               ! -1.0 if the sign of value changes over the poles; if not 1.0. 
   950:             !    call SLTTExtArrExt2(                                 &
   951:             !      & xyzf_QMix_dlon2lat2,  pm,                        & ! (in)
   952:             !      & xyzf_ExtQMixS_dlon2lat2, xyzf_ExtQMixN_dlon2lat2 & ! (out)
   953:             !      & )
   954:             
   955:             
   956:             !!$    call SLTTExtArrExt(                             &
   957:             !!$      & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   958:             !!$      & xyzf_QMix, xyz_U, xyz_V,                    & ! (in)
   959:             !!$      & xyzf_ExtQMixS, xyzf_ExtQMixN,               & ! (out)
   960:             !!$      & xyz_ExtUS, xyz_ExtUN,                       & ! (out)
   961:             !!$      & xyz_ExtVS, xyz_ExtVN                        & ! (out)
   962:             !!$      & )
   963:                 call SLTTExtArrExt(                             &
   964:                   & y_ExtLatS, y_ExtLatN,                       & ! (in)
   965:                   & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   966:                   & xyzf_QMix, xyz_U, xyz_V,                    & ! (in)
   967:             !      & xyzf_ExtDQMixDLatS, xyzf_ExtDQMixDLatN,     & ! (in)
   968:                   & xyzf_ExtQMixS_dlat, xyzf_ExtQMixN_dlat,     & ! (in)
   969:                   & xyzf_ExtQMixS, xyzf_ExtQMixN,               & ! (out)
   970:                   & xyz_ExtUS, xyz_ExtUN,                       & ! (out)
   971:                   & xyz_ExtVS, xyz_ExtVN                        & ! (out)
   972:                   & )
   973:             
   974:             
   975:                 if ( present( xyzf_QMixLinA ) ) then
   976:                   ! Extention of array for linear interpolation
   977:                   PM = 1.0_DP
   978:                   call SLTTExtArrExt2(                            &
   979:                     & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   980:                     & xyzf_QMixLinA, PM,                          & ! (in)
   981:                     & xyzf_ExtQMixLinAS, xyzf_ExtQMixLinAN        & ! (out)
   982:                     & )
   983:                 end if
   984:             
   985:             
   986:                 ! 上流点の計算
   987:                 ! estimation of departure point
   988:                 ! 南半球
   989:                 ! south array
   990:                 call SLTTDPHor(                                     &
   991:                   & DelTime, x_LonS, y_LatS, y_SinLatS, y_CosLatS,  & ! (in)
   992:                   & iexmin, iexmax, jexmin, jexmax,                 & ! (in)
   993:                   & x_ExtLonS, y_ExtLatS, xyz_ExtUS, xyz_ExtVS,     & ! (in)
   994:                   & xyz_DPLonS, xyz_DPLatS                          & ! (out)
   995:                   & )
   996:                 ! 北半球
   997:                 ! north array
   998:                 call SLTTDPHor(                                     &
   999:                   & DelTime, x_LonN, y_LatN, y_SinLatN, y_CosLatN,  & ! (in)
  1000:                   & iexmin, iexmax, jexmin, jexmax,                 & ! (in)
  1001:                   & x_ExtLonN, y_ExtLatN, xyz_ExtUN, xyz_ExtVN,     & ! (in)
  1002:                   & xyz_DPLonN, xyz_DPLatN                          & ! (out)
  1003:                   & )
  1004:             
  1005:             
  1006:             
  1007:                 ! 補間
  1008:                 ! Interpolation
  1009:             !    do n = 1, ncmax
  1010:                 call SLTTIrrHerIntK13(                                                &
  1011:                   & iexmin, iexmax, jexmin, jexmax,                                     & ! (in)
  1012:                    & x_ExtLonS, y_ExtLatS, xyz_DPLonS, xyz_DPLatS,                      & ! (in)
  1013:                    & xyzf_ExtQMixS(:,:,:,:), xyzf_ExtQMixS_dlon(:,:,:,:),               & ! (in)
  1014:                    & xyzf_ExtQMixS_dlat(:,:,:,:), xyzf_ExtQMixS_dlonlat(:,:,:,:),       & ! (in)
  1015:             !      & xyzf_ExtQMixS_dlon2(:,:,:,n), xyzf_ExtQMixS_dlat2(:,:,:,n),        & ! (in) fxx, fyy
  1016:             !      & xyzf_ExtQMixS_dlon2lat(:,:,:,n), xyzf_ExtQMixS_dlonlat2(:,:,:,n),  & ! (in) fxxy, fxyy
  1017:             !      & xyzf_ExtQMixS_dlon2lat2(:,:,:,n),                                  & ! (in) fxxyy 
  1018:                    & SLTTIntHor,                                                        & ! (in)
  1019:                    & xyzf_QMixAS(:,:,:,:)                                               & ! (out)
  1020:                    & )
  1021:             
  1022:                 call SLTTIrrHerIntK13(                                                &
  1023:                   & iexmin, iexmax, jexmin, jexmax,                                     & ! (in)
  1024:                    & x_ExtLonN, y_ExtLatN, xyz_DPLonN, xyz_DPLatN,                      & ! (in)
  1025:                    & xyzf_ExtQMixN(:,:,:,:), xyzf_ExtQMixN_dlon(:,:,:,:),               & ! (in)
  1026:                    & xyzf_ExtQMixN_dlat(:,:,:,:), xyzf_ExtQMixN_dlonlat(:,:,:,:),       & ! (in)
  1027:             !      & xyzf_ExtQMixN_dlon2(:,:,:,n), xyzf_ExtQMixN_dlat2(:,:,:,n),        & ! (in) fxx, fyy
  1028:             !      & xyzf_ExtQMixN_dlon2lat(:,:,:,n), xyzf_ExtQMixN_dlonlat2(:,:,:,n),  & ! (in) fxxy, fxyy
  1029:             !      & xyzf_ExtQMixN_dlon2lat2(:,:,:,n),                                  & ! (in) fxxyy
  1030:                    & SLTTIntHor,                                                        & ! (in)
  1031:                    & xyzf_QMixAN(:,:,:,:)                                               & ! (out)
  1032:                    & )
  1033:             !    enddo
  1034:             
  1035:                 ! 南北半球の配列の結合
  1036:                 ! joint of each array
  1037: +++V=== A        xyzf_QMixA(:,1:jmax/2,:,:)      = xyzf_QMixAS(:,1:jmax/2,:,:)
  1038: +++V=== A        xyzf_QMixA(:,jmax/2+1:jmax,:,:) = xyzf_QMixAN(:,1:jmax/2,:,:)
  1039:             
  1040:             
  1041:                  if ( present( xyzf_QMixLinA ) ) then
  1042:             
  1043:                    call SLTTIrrLinInt(                                                  &
  1044:                      & iexmin, iexmax, jexmin, jexmax,                                  & ! (in)
  1045:                      & x_ExtLonS, y_ExtLatS, xyz_DPLonS, xyz_DPLatS, xyzf_ExtQMixLinAS, & ! (in)
  1046:                      & xyzf_QMixAS                                                      & ! (out)
  1047:                      & )
  1048:                    call SLTTIrrLinInt(                                                  &
  1049:                      & iexmin, iexmax, jexmin, jexmax,                                  & ! (in)
  1050:                      & x_ExtLonN, y_ExtLatN, xyz_DPLonN, xyz_DPLatN, xyzf_ExtQMixLinAN, & ! (in)
  1051:                      & xyzf_QMixAN                                                      & ! (out)
  1052:                      & )
  1053:             
  1054: W***=== A          xyzf_QMixLinA(:,1:jmax/2,:,:)      = xyzf_QMixAS(:,1:jmax/2,:,:)
  1055: W***=== A          xyzf_QMixLinA(:,jmax/2+1:jmax,:,:) = xyzf_QMixAN(:,1:jmax/2,:,:)
  1056:                  end if
  1057:             
  1058:             
  1059:                  if ( ( (       present( xyzf_QMixMinA ) ) .and. &
  1060:                    &    ( .not. present( xyzf_QMixMaxA ) ) ) .or. &
  1061:                    &  ( ( .not. present( xyzf_QMixMinA ) ) .and. &
  1062:                    &    (       present( xyzf_QMixMaxA ) ) ) ) then
  1063:                    call MessageNotify( 'E', module_name, &
  1064:                      & 'QMixMinA has to be present when QMixMaxA is present, and vice versa.' )
  1065:                  end if
  1066:             
  1067:                  if ( present( xyzf_QMixMinA ) ) then
  1068:                    call SLTTLagIntHorMaxMin(                                        &
  1069:                      & iexmin, iexmax, jexmin, jexmax,                              & ! (in)
  1070:                      & x_ExtLonS, y_ExtLatS, xyz_DPLonS, xyz_DPLatS, xyzf_ExtQMixS, & ! (in)
  1071:                      & xyzf_QMixMinAS, xyzf_QMixMaxAS                               & ! (out)
  1072:                      & )
  1073:                    call SLTTLagIntHorMaxMin(                                        &
  1074:                      & iexmin, iexmax, jexmin, jexmax,                              & ! (in)
  1075:                      & x_ExtLonN, y_ExtLatN, xyz_DPLonN, xyz_DPLatN, xyzf_ExtQMixN, & ! (in)
  1076:                      & xyzf_QMixMinAN, xyzf_QMixMaxAN                               & ! (out)
  1077:                      & )
  1078: W***=== A          xyzf_QMixMinA(:,1:jmax/2,:,:)      = xyzf_QMixMinAS(:,1:jmax/2,:,:)
  1079: ***W--->A          xyzf_QMixMinA(:,jmax/2+1:jmax,:,:) = xyzf_QMixMinAN(:,1:jmax/2,:,:)
  1080: ***W--- A          xyzf_QMixMaxA(:,1:jmax/2,:,:)      = xyzf_QMixMaxAS(:,1:jmax/2,:,:)
  1081: W***=== A          xyzf_QMixMaxA(:,jmax/2+1:jmax,:,:) = xyzf_QMixMaxAN(:,1:jmax/2,:,:)
  1082:             
  1083:                  end if
  1084:             
  1085:             
  1086:               end function SLTTHorAdv
  1087:             
  1088:               !--------------------------------------------------------------------------------------
  1089:             
  1090:               function SLTTVerAdv( xyr_SigmaDot, xyzf_QMix,     &
  1091:                 &                  xyzf_QMixLin,                & ! (in ) optional
  1092:                 &                  xyzf_QMixLinA,               & ! (out) optional
  1093:                 &                  xyzf_QMixMinA, xyzf_QMixMaxA & ! (out) optional
  1094:                 & ) result( xyzf_QMixA )
  1095:                 ! セミラグランジュ法による鉛直移流の計算
  1096:                 ! Calculates tracer transports by Semi-Lagrangian method for vertical direction
  1097:             
  1098:                 use axesset, only : z_Sigma           ! 鉛直座標; Sigma coordinate
  1099:                 use timeset, only : DelTime           ! $\Delta t$
  1100:                 use sltt_dp, only : SLTTDPVer         ! 鉛直上流点探索; Finding departure point in vertical 
  1101:                 use sltt_lagint, only : & 
  1102:                   & SLTTIrrHerIntQui1DNonUni, &       ! 不当間隔格子の五次補間; Quintic Interpolation for non-uniform grids
  1103:                   & SLTTHerIntCub1D
  1104:             
  1105:                 real(DP), intent(in ) :: xyr_SigmaDot(0:imax-1, 1:jmax, 0:kmax)
  1106:                                           ! 鉛直流速（SigmaDot）
  1107:                 real(DP), intent(in ) :: xyzf_QMix   (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1108:                                           ! 現在時刻の物質混合比
  1109:                                           ! Present mix ratio of the tracers
  1110:                 real(DP), intent(in ), optional :: xyzf_QMixLin (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1111:                 real(DP), intent(out), optional :: xyzf_QMixLinA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1112:             
  1113:                 real(DP), intent(out), optional :: xyzf_QMixMinA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1114:                 real(DP), intent(out), optional :: xyzf_QMixMaxA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1115:             
  1116:                 real(DP)              :: xyzf_QMixA  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1117:                                           ! 次ステップの物質混合比
  1118:                                           ! Next mix ratio of the tracers
  1119:             
  1120:                 !
  1121:                 ! local variables
  1122:                 !
  1123:                 real(DP) :: xyz_DPSigma(0:imax-1, 1:jmax, 1:kmax)
  1124:                                           ! 上流点高度
  1125:                                           ! Sigma of the departure point
  1126:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
  1127:                                           ! Work variables for DO loop in zonal direction
  1128:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
  1129:                                           ! Work variables for DO loop in meridional direction
  1130:                 integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
  1131:                                           ! Work variables for DO loop in vertical direction
  1132:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
  1133:                                           ! Work variables for DO loop in dimension of constituents
  1134:                 integer:: xy_kk(0:imax-1, 1:jmax)
  1135:                                           ! 上流点の上下のグリッドを探索するための作業変数
  1136:                                           ! Work variable for finding the grid just above the departure point
  1137:             
  1138:                 real(DP) :: xyzf_QMix_dz(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1139:                                           ! 物質混合比の鉛直微分
  1140:                                           ! Vertical derivative of the mix ratio
  1141:                 real(DP) :: xyzf_ExtQMix(0:imax-1, 1:jmax, 1-2:kmax+2, 1:ncmax)
  1142:                                           ! 物質混合比の拡張配列
  1143:                                           ! Extended array of the mix ratio
  1144:                 real(DP) :: z_ExtSigma(1-2:kmax+2)
  1145:                                           ! σ座標の拡張配列
  1146:                                           ! Extended array of the sigma coordinate
  1147:                 real(DP) :: xyf_F11(0:imax-1, 1:jmax, 1:ncmax)
  1148:                                           ! 微分計算時に用いる作業変数
  1149:                                           ! work variable for the derivative calculation
  1150:                 real(DP) :: xyf_F22(0:imax-1, 1:jmax, 1:ncmax)
  1151:                                           ! 微分計算時に用いる作業変数
  1152:                                           ! work variable for the derivative calculation
  1153:                 real(DP) :: xyf_F12(0:imax-1, 1:jmax, 1:ncmax)
  1154:                                           ! 微分計算時に用いる作業変数
  1155:                                           ! work variable for the derivative calculation
  1156:                 real(DP) :: xyf_F21(0:imax-1, 1:jmax, 1:ncmax)
  1157:                                           ! 微分計算時に用いる作業変数
  1158:                                           ! work variable for the derivative calculation
  1159:                 real(DP) :: s1, t1, s2, t2, r1, r2
  1160:                                           ! 微分計算時に用いる作業変数
  1161:                                           ! work variable for the derivative calculation
  1162:             
  1163:                 real(DP) :: xyzf_QMixLinLV   (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1164:                 real(DP) :: xyzf_ExtQMixLinLV(0:imax-1, 1:jmax, 1-2:kmax+2, 1:ncmax)
  1165:             
  1166:             
  1167:                 ! 実行文 ; Executable statement
  1168:                 !
  1169:             
  1170:                 ! 初期化確認
  1171:                 ! Initialization check
  1172:                 !
  1173:                 if ( .not. sltt_inited ) then
  1174:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1175:                 end if
  1176:             
  1177:             
  1178:                 if ( ( present( xyzf_QMixLin ) ) .and. ( .not. present( xyzf_QMixLinA ) ) ) then
  1179:                   call MessageNotify( 'E', module_name, &
  1180:                     & 'If xyzf_QMixLinA has to be present when xyzf_QMixLin ise present.' )
  1181:                 end if
  1182:                 if ( ( (       present( xyzf_QMixMinA ) ) .and. &
  1183:                   &    ( .not. present( xyzf_QMixMaxA ) ) ) .or. &
  1184:                   &  ( ( .not. present( xyzf_QMixMinA ) ) .and. &
  1185:                   &    (       present( xyzf_QMixMaxA ) ) ) ) then
  1186:                   call MessageNotify( 'E', module_name, &
  1187:                     & 'QMixMinA has to be present when QMixMaxA is present, and vice versa.' )
  1188:                 end if
  1189:             
  1190:             
  1191:                 if ( present( xyzf_QMixLin ) ) then
  1192: +++V=== A         xyzf_QMixLinLV = xyzf_QMixLin
  1193:                 else
  1194: W***=== A         xyzf_QMixLinLV = xyzf_QMix
  1195:                 end if
  1196:             
  1197:             
  1198:                 ! 上流点探索
  1199:                 ! estimation of departure point
  1200:                 !
  1201:                 call SLTTDPVer(            &
  1202:                   & DelTime, xyr_SigmaDot, & ! (in )
  1203:                   & xyz_DPSigma            & ! (out)
  1204:                   & )
  1205:             
  1206:             
  1207:                 ! 配列拡張（z_Sigma）
  1208:                 ! Array extension for z_Sigma
  1209:                 z_ExtSigma(-1) = 2.0_DP - z_Sigma(2)
  1210:                 z_ExtSigma(0) = 2.0_DP - z_Sigma(1)
  1211: V====== A       z_ExtSigma(1:kmax) = z_Sigma(1:kmax)
  1212:                 z_ExtSigma(kmax+1) = -z_Sigma(kmax)
  1213:                 z_ExtSigma(kmax+2) = -z_Sigma(kmax-1)
  1214:             
  1215:                 ! 配列拡張（xyzf_QMix）
  1216:                 ! Array extension for Q_Mix
  1217: **W---->A       xyzf_ExtQMix(:,:,-1,:)     = xyzf_QMix(:,:,2,:)
  1218: **W---- A       xyzf_ExtQMix(:,:,0,:)      = xyzf_QMix(:,:,1,:)
  1219: W***=== A       xyzf_ExtQMix(:,:,1:kmax,:) = xyzf_QMix(:,:,1:kmax,:)
  1220: **W---->A       xyzf_ExtQMix(:,:,kmax+1,:) = xyzf_QMix(:,:,kmax,:)
  1221: |||     A       xyzf_ExtQMix(:,:,kmax+2,:) = xyzf_QMix(:,:,kmax-1,:)
  1222: |||         
  1223: |||             xyzf_ExtQMixLinLV(:,:,-1,:)     = xyzf_QMixLinLV(:,:,2,:)
  1224: **W----         xyzf_ExtQMixLinLV(:,:,0,:)      = xyzf_QMixLinLV(:,:,1,:)
  1225: W***===         xyzf_ExtQMixLinLV(:,:,1:kmax,:) = xyzf_QMixLinLV(:,:,1:kmax,:)
  1226: **W---->        xyzf_ExtQMixLinLV(:,:,kmax+1,:) = xyzf_QMixLinLV(:,:,kmax,:)
  1227: **W----         xyzf_ExtQMixLinLV(:,:,kmax+2,:) = xyzf_QMixLinLV(:,:,kmax-1,:)
  1228:             
  1229:             
  1230:                 ! xyzf_QMix_dz（微分）を求める 
  1231:                 ! calculate xyzf_QMix_dz
  1232: +------>        do k = 1 , kmax
  1233: |                 s1 = z_ExtSigma(k) - z_ExtSigma(k-1)
  1234: |                 t1 = z_ExtSigma(k+1) - z_ExtSigma(k)
  1235: |                 s2 = z_ExtSigma(k) - z_ExtSigma(k-2)
  1236: |                 t2 = z_ExtSigma(k+2) - z_ExtSigma(k)
  1237: |           
  1238: |                 if (s1 == t1 .and. s2 == t2 .and. s1 + s1 == s2) then 
  1239: |                   ! 格子が等間隔の場合
  1240: |                   ! Uniform depth
  1241: |                   ! 4次精度
  1242: |                   ! 4th order
  1243: |           
  1244: |++V=== A           xyzf_QMix_dz(:,:,k,:) = ( 8.0_DP*( xyzf_ExtQMix(:,:,k+1,:) - xyzf_ExtQMix(:,:,k-1,:)) &
  1245: |                     &                         - ( xyzf_ExtQMix(:,:,k+2,:) - xyzf_ExtQMix(:,:,k-2,:) ) )/12.0_DP
  1246: |                 else
  1247: |                   ! 格子が不当間隔の場合
  1248: |                   ! Non-uniform depth
  1249: |**W--->A           xyf_F11 = (s1*s1*xyzf_ExtQMix(:,:,k+1,:) +(t1*t1 - s1*s1)*xyzf_ExtQMix(:,:,k,:) - t1*t1*xyzf_ExtQMix(:,:,k-1,:))&
  1250: ||||                  &         /(s1*t1*(s1+t1))
  1251: ||||    A           xyf_F22 = (s2*s2*xyzf_ExtQMix(:,:,k+2,:) +(t2*t2 - s2*s2)*xyzf_ExtQMix(:,:,k,:) - t2*t2*xyzf_ExtQMix(:,:,k-2,:))&
  1252: ||||                  &         /(s2*t2*(s2+t2))
  1253: ||||    A           xyf_F21 = (s2*s2*xyzf_ExtQMix(:,:,k+1,:) +(t1*t1 - s2*s2)*xyzf_ExtQMix(:,:,k,:) - t1*t1*xyzf_ExtQMix(:,:,k-2,:))&
  1254: ||||                  &         /(s2*t1*(s2+t1))
  1255: |**W--- A           xyf_F12 = (s1*s1*xyzf_ExtQMix(:,:,k+2,:) +(t2*t2 - s1*s1)*xyzf_ExtQMix(:,:,k,:) - t2*t2*xyzf_ExtQMix(:,:,k-1,:))&
  1256: |                     &         /(s1*t2*(s1+t2))
  1257: |           
  1258: |                   r1 = t1 - s1 - t2 + s2
  1259: |                   r2 = t1 - s2 - t2 + s1
  1260: |                   !４次精度
  1261: |                   ! 4th order
  1262: |W**=== A           xyzf_QMix_dz(:,:,k,:) = ( (xyf_F11*s2*t2 - xyf_F22*s1*t1)*r2 - (xyf_F21*s1*t2 - xyf_F12*s2*t1)*r1 ) &
  1263: |                     &                       / ( (s2*t2-s1*t1)*r2 - (s1*t2-s2*t1)*r1 )
  1264: |           
  1265: |                   !3次精度
  1266: |                   ! 3rd order
  1267: |             !        xyzf_QMix_dz(:,:,k,:) = (xyf_F11*s2*t2 - xyf_F22(:,:,:)*s1*t1)/(s2*t2 - s1*t1) 
  1268: |           
  1269: |                   !2次精度
  1270: |                   ! 2nd order
  1271: |             !        xyzf_QMix_dz(:,:,k,:) = xyf_F11
  1272: |                 end if
  1273: |           
  1274: |           
  1275: +------         end do
  1276:             
  1277:             
  1278: W*=====         xy_kk = 2
  1279: +------>        do k = 1, kmax
  1280: |+----->          do j = 1, jmax
  1281: ||+---->            do i = 0, imax-1
  1282: |||                   if ( xyz_DPSigma(i,j,k) >= z_Sigma(1) ) then     ! DPが z_Sigma(1) と 地表面(sigma = 1.0)の間の場合
  1283: |||                                                                    ! if DP is between z_Sigma(1) and the ground (sigma = 1.0)
  1284: |||V=== A               xyzf_QMixA(i,j,k,:) = xyzf_QMix(i,j,1,:)     ! Q_1で一定とする。
  1285: |||                                                                  ! use Q_1 for interpolated value
  1286: |||         
  1287: |||                     if ( present( xyzf_QMixLinA ) ) then
  1288: |||V=== A                 xyzf_QMixLinA(i,j,k,:) = xyzf_QMixLinLV(i,j,1,:)
  1289: |||                     end if
  1290: |||         
  1291: |||                     if ( present( xyzf_QMixMinA ) ) then
  1292: |||V--->A                 xyzf_QMixMinA(i,j,k,:) = xyzf_QMix(i,j,1,:)
  1293: |||V--- A                 xyzf_QMixMaxA(i,j,k,:) = xyzf_QMix(i,j,1,:)
  1294: |||                     end if
  1295: |||         
  1296: |||                   elseif (xyz_DPSigma(i,j,k) <= z_Sigma(kmax)) then! DPが z_Sigma(kmax) と 大気上端(sigma = 0.0)の間
  1297: |||                                                                    ! if DP is between z_Sigma(kmax) and the upper boundary (sigma = 0.0)
  1298: |||V=== A               xyzf_QMixA(i,j,k,:) = xyzf_QMix(i,j,kmax,:)  ! Q_kmaxで一定とする。
  1299: |||                                                                  ! use Q_kmax for interpolated value
  1300: |||         
  1301: |||                     if ( present( xyzf_QMixLinA ) ) then
  1302: |||V=== A                 xyzf_QMixLinA(i,j,k,:) = xyzf_QMixLinLV(i,j,kmax,:)
  1303: |||                     end if
  1304: |||         
  1305: |||                     if ( present( xyzf_QMixMinA ) ) then
  1306: |||V--->A                 xyzf_QMixMinA(i,j,k,:) = xyzf_QMix(i,j,kmax,:)
  1307: |||V--- A                 xyzf_QMixMaxA(i,j,k,:) = xyzf_QMix(i,j,kmax,:)
  1308: |||                     end if
  1309: |||         
  1310: |||                   else
  1311: |||V--->                do kk = xy_kk(i,j), kmax 
  1312: ||||    A                 if ( xyz_DPSigma(i,j,k) > z_Sigma(kk) ) then 
  1313: ||||                        select case (SLTTIntVer)
  1314: ||||                        case("HQ")    ! 変則エルミート５次補間; Irregular Hermite Quintic interpolation
  1315: ||||+-->                      do n = 1, ncmax 
  1316: |||||                           xyzf_QMixA(i,j,k,n) = SLTTIrrHerIntQui1DNonUni(xyzf_ExtQMix(i,j,kk-2,n), xyzf_ExtQMix(i,j,kk-1,n), & 
  1317: |||||                             &                               xyzf_ExtQMix(i,j,kk,n),   xyzf_ExtQMix(i,j,kk+1,n), & 
  1318: |||||                             &                               xyzf_QMix_dz(i,j,kk-1,n), xyzf_QMix_dz(i,j,kk,n),   &
  1319: |||||                             &                               z_ExtSigma(kk-2)-z_ExtSigma(kk-1), z_ExtSigma(kk)-z_ExtSigma(kk-1), & 
  1320: |||||                             &                               z_ExtSigma(kk+1)-z_ExtSigma(kk-1), xyz_DPSigma(i,j,k)-z_ExtSigma(kk-1))
  1321: ||||+--                       end do
  1322: ||||        
  1323: ||||                        case("HC")    ! エルミート３次補間; Hermitian Cubic interpolation
  1324: ||||+-->                      do n = 1, ncmax
  1325: |||||                           xyzf_QMixA(i,j,k,n) = SLTTHerIntCub1D( xyzf_ExtQMix(i,j,kk-1,n), xyzf_ExtQMix(i,j,kk,n),&
  1326: |||||                             &                                      xyzf_QMix_dz(i,j,kk-1,n), xyzf_QMix_dz(i,j,kk,n),&
  1327: |||||                             &                                      z_ExtSigma(kk)-z_ExtSigma(kk-1),                 &
  1328: |||||                             &                                      xyz_DPSigma(i,j,k)-z_ExtSigma(kk-1))
  1329: ||||+--                       end do
  1330: ||||        
  1331: ||||                        case default
  1332: ||||                          call MessageNotify( 'E', module_name, 'GIVE CORRECT KEYWORD FOR <SLTTIntVer> IN NAMELIST.' )
  1333: ||||                        end select
  1334: ||||        
  1335: ||||                        if ( present( xyzf_QMixLinA ) ) then
  1336: ||||                          ! Linear interporation
  1337: ||||V-->                      do n = 1, ncmax
  1338: |||||   A                       xyzf_QMixLinA(i,j,k,n) =                                              &
  1339: |||||                             &   ( xyzf_ExtQMixLinLV(i,j,kk,n) - xyzf_ExtQMixLinLV(i,j,kk-1,n) ) &
  1340: |||||                             &   / ( z_ExtSigma(kk)            - z_ExtSigma(kk-1)              ) &
  1341: |||||                             &   * ( xyz_DPSigma(i,j,k)        - z_ExtSigma(kk-1)              ) &
  1342: |||||                             & + xyzf_ExtQMixLinLV(i,j,kk-1,n)
  1343: ||||V--                       end do
  1344: ||||                        end if
  1345: ||||        
  1346: ||||                        if ( present( xyzf_QMixMinA ) ) then
  1347: ||||V-->                      do n = 1, ncmax
  1348: |||||   A                       xyzf_QMixMinA(i,j,k,n) = &
  1349: |||||                             & min( xyzf_QMix(i,j,kk-1,n), &
  1350: |||||                             &      xyzf_QMix(i,j,kk,n) )
  1351: |||||   A                       xyzf_QMixMaxA(i,j,k,n) = &
  1352: |||||                             & max( xyzf_QMix(i,j,kk-1,n), &
  1353: |||||                             &      xyzf_QMix(i,j,kk,n) )
  1354: ||||V--                       end do
  1355: ||||                        end if
  1356: ||||        
  1357: ||||                        xy_kk(i,j) = kk
  1358: ||||                        exit
  1359: ||||                      end if
  1360: |||V---                 end do
  1361: |||                   end if
  1362: ||+----             end do
  1363: |+-----           end do
  1364: +------         end do
  1365:             
  1366:             
  1367:               end function SLTTVerAdv
  1368:             
  1369:               !-------------------------------------------------
  1370:             
  1371:               subroutine SLTTInit
  1372:                 ! セミラグランジュ法の初期化処理
  1373:                 ! Initialization for Semi-Lagrangian method
  1374:             
  1375:             
  1376:                 ! ヒストリデータ出力
  1377:                 ! History data output
  1378:                 !
  1379:                 use gtool_historyauto, only: HistoryAutoAddVariable
  1380:             
  1381:                 ! 組成に関わる配列の設定
  1382:                 ! Settings of array for atmospheric composition
  1383:                 !
  1384:                 use composition, only:                              &
  1385:                   &                    ncmax,                       &
  1386:                                          ! 成分の数
  1387:                                          ! Number of composition
  1388:                   &                    a_QMixName
  1389:                                          ! 成分の変数名
  1390:                                          ! Name of variables for composition
  1391:             
  1392:                 ! 座標データ設定
  1393:                 ! Axes data settings
  1394:                 !
  1395:                 use axesset, only: &
  1396:                   & r_Sigma, &
  1397:                                           ! $ \sigma $ レベル (半整数).
  1398:                                           ! Half $ \sigma $ level
  1399:                   & z_Sigma, &            ! $ \sigma $ レベル (整数).
  1400:                                           ! Full $ \sigma $ level
  1401:                   & x_Lon, y_Lat, &
  1402:                   & AxNameX, AxNameY, AxNameZ, AxNameT
  1403:             
  1404:                 use sltt_const , only : SLTTConstInit
  1405:                 use sltt_extarr, only : SLTTExtArrInit
  1406:             
  1407:             
  1408:                 ! NAMELIST ファイル入力に関するユーティリティ
  1409:                 ! Utilities for NAMELIST file input
  1410:                 !
  1411:                 use namelist_util, only: namelist_filename, NmlutilMsg
  1412:             
  1413:                 ! 種別型パラメタ
  1414:                 ! Kind type parameter
  1415:                 !
  1416:                 use dc_types, only: &
  1417:                   & STDOUT, &             ! 標準出力の装置番号. Unit number of standard output
  1418:                   & STRING                ! 文字列.       Strings. 
  1419:                 ! ファイル入出力補助
  1420:                 ! File I/O support
  1421:                 !
  1422:                 use dc_iounit, only: FileOpen
  1423:             
  1424:                 use sltt_const , only : iexmin, iexmax, jexmin, jexmax
  1425:             
  1426:                 !
  1427:                 ! local variables
  1428:                 !
  1429:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
  1430:                                           ! Work variables for DO loop in zonal direction
  1431:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
  1432:                                           ! Work variables for DO loop in meridional direction
  1433:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1434:                                           ! Work variables for DO loop in vertical direction
  1435:                 integer:: n
  1436:             
  1437:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1438:                                           ! Unit number for NAMELIST file open
  1439:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1440:                                           ! IOSTAT of NAMELIST read
  1441:                 ! NAMELIST 変数群
  1442:                 ! NAMELIST group name
  1443:                 !
  1444:                 namelist /sltt_nml/                                        &
  1445:                   & FlagSLTTArcsineHor, FlagSLTTArcsineVer, SLTTIntHor, SLTTIntVer, SLTTArcSineFactor
  1446:             
  1447:                 ! 実行文 ; Executable statement
  1448:                 !
  1449:             
  1450:                 if ( sltt_inited ) return
  1451:             
  1452:                 if ( mod( jmax, 2 ) /= 0 ) then
  1453:                   stop 'jmax cannot be divided by 2.'
  1454:                 end if
  1455:             
  1456:                 call SLTTConstInit
  1457:             
  1458:             
  1459:                 ! デフォルト値の設定
  1460:                 ! Default values settings
  1461:                 !
  1462:                 FlagSLTTArcsineHor          = .true.
  1463:                 FlagSLTTArcsineVer          = .true.
  1464:                 SLTTArcSineFactor           = 1.05_DP
  1465:                 SLTTIntHor                  = "HQ"
  1466:                 SLTTIntVer                  = "HQ"
  1467:             
  1468:             
  1469:                 ! NAMELIST の読み込み
  1470:                 ! NAMELIST is input
  1471:                 !
  1472:                 if ( trim(namelist_filename) /= '' ) then
  1473:                   call FileOpen( unit_nml, &          ! (out)
  1474:                     & namelist_filename, mode = 'r' ) ! (in)
  1475:             
  1476:                   rewind( unit_nml )
  1477:                   read( unit_nml, &                ! (in)
  1478:                     & nml = sltt_nml, &  ! (out)
  1479:                     & iostat = iostat_nml )        ! (out)
  1480:                   close( unit_nml )
  1481:             
  1482:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1483:                   if ( iostat_nml == 0 ) write( STDOUT, nml = sltt_nml )
  1484:                 end if
  1485:             
  1486:             
  1487:             
  1488:                 allocate( x_LonS   (0:imax-1) )
  1489:                 allocate( x_SinLonS(0:imax-1) )
  1490:                 allocate( x_CosLonS(0:imax-1) )
  1491:                 allocate( y_latS   (1:jmax/2) )
  1492:                 allocate( y_SinLatS(1:jmax/2) )
  1493:                 allocate( y_CosLatS(1:jmax/2) )
  1494: V------>        do i = 0, imax-1
  1495: |       A         x_LonS   (i) = x_Lon(i)
  1496: |       A         x_SinLonS(i) = sin( x_LonS(i) )
  1497: |       A         x_CosLonS(i) = cos( x_LonS(i) )
  1498: V------         end do
  1499: V------>        do j = 1, jmax/2
  1500: |       A         y_LatS   (j) = y_Lat(j)
  1501: |       A         y_SinLatS(j) = sin( y_LatS(j) )
  1502: |       A         y_CosLatS(j) = cos( y_LatS(j) )
  1503: V------         end do
  1504:             
  1505:                 allocate( x_LonN   (0:imax-1) )
  1506:                 allocate( x_SinLonN(0:imax-1) )
  1507:                 allocate( x_CosLonN(0:imax-1) )
  1508:                 allocate( y_latN   (1:jmax/2) )
  1509:                 allocate( y_SinLatN(1:jmax/2) )
  1510:                 allocate( y_CosLatN(1:jmax/2) )
  1511: V------>        do i = 0, imax-1
  1512: |       A         x_LonN   (i) = x_Lon(i)
  1513: |       A         x_SinLonN(i) = sin( x_LonN(i) )
  1514: |       A         x_CosLonN(i) = cos( x_LonN(i) )
  1515: V------         end do
  1516: V------>        do j = 1, jmax/2
  1517: |       A         y_LatN   (j) = y_Lat(j+jmax/2)
  1518: |       A         y_SinLatN(j) = sin( y_LatN(j) )
  1519: |       A         y_CosLatN(j) = cos( y_LatN(j) )
  1520: V------         end do
  1521:             
  1522:                 allocate( x_ExtLonS( iexmin:iexmax ) )
  1523:                 allocate( x_ExtLonN( iexmin:iexmax ) )
  1524:             
  1525:                 allocate( y_ExtLatS( jexmin:jexmax ) )
  1526:                 allocate( y_ExtLatN( jexmin:jexmax ) )
  1527:             
  1528:             
  1529:                 call SLTTExtArrInit(                            &
  1530:                   & x_LonS, y_LatS, x_LonN, y_LatN,             & ! (in )
  1531:                   & x_ExtLonS, y_ExtLatS, x_ExtLonN, y_ExtLatN  & ! (out)
  1532:                   & )
  1533:             
  1534:             
  1535:                 ! ヒストリデータ出力のためのへの変数登録
  1536:                 ! Register of variables for history data output
  1537:                 !
  1538: +------>        do n = 1, ncmax
  1539: |                 call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtHorMassFix', &
  1540: |                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  1541: |                   & 'tendency of horizontal mass fix of '//trim(a_QMixName(n)), 's-1' )
  1542: |                 call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtVerMassFix', &
  1543: |                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  1544: |                   & 'tendency of vertical mass fix of '//trim(a_QMixName(n)), 's-1' )
  1545: |                 call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtTotMassFix', &
  1546: |                   & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  1547: |                   & 'tendency of mass fix of '//trim(a_QMixName(n)), 's-1' )
  1548: +------         end do
  1549:             
  1550:             
  1551:                 ! 印字 ; Print
  1552:                 !
  1553:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1554:                 call MessageNotify( 'M', module_name, '  FlagSLTTArcsineHor       = %b', l = (/ FlagSLTTArcsineHor /) )
  1555:                 call MessageNotify( 'M', module_name, '  FlagSLTTArcsineVer       = %b', l = (/ FlagSLTTArcsineVer /) )
  1556:                 call MessageNotify( 'M', module_name, '  SLTTArcsineFactor        = %f', d = (/ SLTTArcsineFactor /) )
  1557:                 call MessageNotify( 'M', module_name, '  SLTTIntHor               = %c', c1 = trim( SLTTIntHor ) )
  1558:                 call MessageNotify( 'M', module_name, '  SLTTIntVer               = %c', c1 = trim( SLTTIntVer ) )
  1559:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1560:             
  1561:                 sltt_inited = .true.
  1562:             
  1563:               end subroutine SLTTInit
  1564:             
  1565:               !--------------------------------------------------------------------------------------
  1566:             
  1567:             end module sltt
