Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:36 2016
FILE NAME: i.sltt_lagint.F90
PROGRAM NAME: sltt_lagint
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   475  opt  (1593): Loop nest collapsed into one loop.
   475  vec  (   4): Vectorized array expression.
   475  vec  (  29): ADB is used for array.: xyz_ii
   475  vec  (  29): ADB is used for array.: xyz_mplon
   497  vec  (   1): Vectorized loop.
   497  vec  (  29): ADB is used for array.: y_extlat
   498  opt  (1084): Branch out of the loop inhibits optimization.
   498  vec  (  26): Macro operation Search.
   502  vec  (   1): Vectorized loop.
   502  vec  (  29): ADB is used for array.: y_extlat
   503  opt  (1084): Branch out of the loop inhibits optimization.
   503  vec  (  26): Macro operation Search.
   521  vec  (   3): Unvectorized loop.
   524  opt  (1017): Subroutine call prevents optimization.
   524  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   530  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   537  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   543  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   556  opt  (1593): Loop nest collapsed into one loop.
   556  vec  (   1): Vectorized loop.
   556  vec  (  29): ADB is used for array.: xyza_lcify
   556  vec  (  29): ADB is used for array.: y_extlat
   556  vec  (  29): ADB is used for array.: xyz_mplat
   556  vec  (  29): ADB is used for array.: xyza_lcifx
   556  vec  (  29): ADB is used for array.: x_extlon
   556  vec  (  29): ADB is used for array.: xyz_mplon
   556  vec  (  29): ADB is used for array.: xyz_jj
   556  vec  (  29): ADB is used for array.: xyz_ii
   663  opt  (1593): Loop nest collapsed into one loop.
   663  vec  (   1): Vectorized loop.
   663  vec  (  29): ADB is used for array.: xyz_mparr
   663  vec  (  29): ADB is used for array.: xyz_extarr
   663  vec  (  29): ADB is used for array.: xyza_lcifx
   663  vec  (  29): ADB is used for array.: xyza_lcify
   663  vec  (  29): ADB is used for array.: xyz_jj
   663  vec  (  29): ADB is used for array.: xyz_ii
   743  vec  (   1): Vectorized loop.
   743  vec  (  29): ADB is used for array.: z_sigma
   744  opt  (1084): Branch out of the loop inhibits optimization.
   744  vec  (  26): Macro operation Search.
   748  vec  (   1): Vectorized loop.
   748  vec  (  29): ADB is used for array.: z_sigma
   749  opt  (1084): Branch out of the loop inhibits optimization.
   749  vec  (  26): Macro operation Search.
   761  opt  (1593): Loop nest collapsed into one loop.
   761  vec  (   1): Vectorized loop.
   761  vec  (  29): ADB is used for array.: xyza_lcifz
   761  vec  (  29): ADB is used for array.: z_sigma
   761  vec  (  29): ADB is used for array.: xyz_dpsigma
   761  vec  (  29): ADB is used for array.: xyz_kk
   826  opt  (1592): Outer loop unrolled inside inner loop.
   827  vec  (   1): Vectorized loop.
   827  vec  (  29): ADB is used for array.: xyz_arra
   827  vec  (  29): ADB is used for array.: xyz_arr
   827  vec  (  29): ADB is used for array.: xyz_kk
   827  vec  (  29): ADB is used for array.: xyza_lcifz
   827  vec  (   1): Vectorized loop.
   827  vec  (  29): ADB is used for array.: xyz_arra
   827  vec  (  29): ADB is used for array.: xyz_arr
   827  vec  (  29): ADB is used for array.: xyz_kk
   827  vec  (  29): ADB is used for array.: xyza_lcifz
   910  vec  (   1): Vectorized loop.
   910  vec  (  29): ADB is used for array.: y_extlat
   911  vec  (  26): Macro operation Search.
   912  opt  (1084): Branch out of the loop inhibits optimization.
   924  opt  (1017): Subroutine call prevents optimization.
   936  vec  (   1): Vectorized loop.
   936  vec  (  29): ADB is used for array.: xyzf_qmixmaxa
   936  vec  (  29): ADB is used for array.: xyzf_qmixmina
   936  vec  (  29): ADB is used for array.: xyzf_extqmixb
   953  warn (  83): Dummy argument "x_extlon" is not used.
   953  warn (  82): Name "deltalat" is not used.
  1020  vec  (   1): Vectorized loop.
  1020  vec  (  29): ADB is used for array.: y_extlat
  1021  vec  (  26): Macro operation Search.
  1022  opt  (1084): Branch out of the loop inhibits optimization.
  1034  opt  (1017): Subroutine call prevents optimization.
  1046  vec  (   1): Vectorized loop.
  1046  vec  (  29): ADB is used for array.: xyzf_qmixa
  1046  vec  (  29): ADB is used for array.: xyzf_extqmixb
  1091  warn (   7): Characters in a line over this form limitation.
  1091  warn (   7): Characters in a line over this form limitation.
  1187  vec  (   1): Vectorized loop.
  1187  vec  (  29): ADB is used for array.: y_extlat
  1188  vec  (  26): Macro operation Search.
  1189  opt  (1084): Branch out of the loop inhibits optimization.
  1207  vec  (   3): Unvectorized loop.
  1207  vec  (   7): Iteration count is too small.
  1219  opt  (1025): Reference to this function inhibits optimization.
  1226  vec  (   3): Unvectorized loop.
  1274  opt  (1025): Reference to this function inhibits optimization.
  1274  vec  (  10): Vectorization obstructive procedure reference.:slttherintcub2d
  1423  warn (   7): Characters in a line over this form limitation.
  1471  warn (  82): Name "lmin" is not used.
  1471  warn (  82): Name "lmax" is not used.
  1471  warn (  82): Name "fyd" is not used.
  1471  warn (  82): Name "fya" is not used.
  1656  warn (  82): Name "n" is not used.
  1656  warn (  82): Name "indx" is not used.
  1725  vec  (   3): Unvectorized loop.
  1728  opt  (1017): Subroutine call prevents optimization.
  1728  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1735  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1747  warn (  83): Dummy argument "jexmax" is not used.
  1747  warn (  83): Dummy argument "jexmin" is not used.
  1793  vec  (   3): Unvectorized loop.
  1796  opt  (1017): Subroutine call prevents optimization.
  1796  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1803  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1815  warn (  83): Dummy argument "iexmax" is not used.
  1815  warn (  83): Dummy argument "iexmin" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:36 2016
FILE NAME: i.sltt_lagint.F90
PROGRAM NAME: sltt_lagint
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 物質移流計算 (セミラグランジュ法）で用いる補間法
     2  !
     3  != Interpolation methods for Semi-Lagrangian method
     4  !
     5  ! Authors::   Hiroki KASHIMURA, Yoshiyuki O. TAKAHASHI
     6  ! Version::
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2013. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module sltt_lagint
    13    !
    14    != セミラグランジュ法 で用いる補間法
    15    !
    16    != Interpolation methods for Semi-Lagrangian method
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! セミラグランジュ法で用いる補間を演算するモジュールです.
    21    ! スペクトル変換・高精度補間に由来する人工的な短波を除去するために Sun et al. (1996) の
    22    ! 単調フィルタを応用したものを部分的に用いている。
    23    !
    24    ! This is a Interpolation module. Semi-Lagrangian method (Enomoto 2008 modified)
    25    ! Monotonicity filter (Sun et al 1996) is partly used.
    26    !
    27    !== Procedures List
    28    !
    29    ! SLTTLagIntCubCalcFactHor :: 水平２次元ラグランジュ３次補間用の係数計算
    30    ! SLTTLagIntCubIntHor      :: 水平２次元ラグランジュ３次補間（上流点探索で用いる）
    31    ! SLTTLagIntCubCalcFactVer :: 鉛直１次元ラグランジュ３次補間用の係数計算
    32    ! SLTTLagIntCubIntVer      :: 鉛直１次元ラグランジュ３次補間（上流点探索で用いる）
    33    ! SLTTIrrHerIntK13         :: 水平２次元変則エルミート５次補間
    34    ! SLTTIrrHerIntQui2DHor    :: 水平２次元変則エルミート５次補間（コア部分）
    35    ! SLTTIrrHerIntQui1DUni    :: １次元変則エルミート５次補間（等間隔格子）
    36    ! SLTTIrrHerIntQui1DNonUni :: １次元変則エルミート５次補間（不等間隔格子）
    37    ! SLTTIrrHerIntQui1DUniLon :: １次元変則エルミート５次補間（等間隔：経度方向専用）
    38    ! SLTTHerIntCub1D          :: １次元エルミート３次補間
    39    ! SLTTHerIntCub2D          :: ２次元エルミート３次補間
    40    ! ---------------------    :: ------------
    41    ! SLTTLagIntCubCalcFactHor :: Calculation of factors for 2D Lagrangian Cubic Interpolation
    42    ! SLTTLagIntCubIntHor      :: 2D Lagrangian Cubic Interpolation used in finding DP in horizontal
    43    ! SLTTLagIntCubCalcFactVer :: Calculation of factors for 1D Lagrangian Cubic Interpolation
    44    ! SLTTLagIntCubIntVer      :: 1D Lagrangian Cubic Interpolation used in finding DP in vertical
    45    ! SLTTHerIntK13            :: Horizontal 2D Irregular Hermite Quintic Interpolation
    46    ! SLTTIrrHerIntQui2DHor    :: Horizontal 2D Irregular Hermite Quintic Interpolation (Core)
    47    ! SLTTIrrHerIntQui1DUni    :: 1D Irregular Hermite Quintic Interpolation for uniform grids
    48    ! SLTTIrrHerIntQui1DNonUni :: 1D Irregular Hermite Quintic Interpolation for non-uniform grids
    49    ! SLTTIrrHerIntQui1DUniLon :: 1D Irregular Hermite Quintic Interpolation for uniform longitude grids
    50    ! SLTTHerIntCub1D          :: 1D Hermite Cubic Interpolation
    51    ! SLTTHerIntCub2D          :: 2D Hermite Cubic Interpolation
    52    !
    53    !== NAMELIST
    54    !
    55    ! NAMELIST#
    56    !
    57    !== References
    58    ! * Enomoto, T., 2008:
    59    !   Bicubic Interpolation with Spectral Derivatives.
    60    !   <i>SOLA</i>, <b>4</b>, 5-8. doi:10.2151/sola.2008-002
    61    !
    62    ! * Sun, W.-Y., Yeh, K.-S., and Sun, R.-Y., 1996:
    63    !   A simple semi-Lagrangian scheme for advection equations.
    64    !   <i>Quarterly Journal of the Royal Meteorological Society</i>,
    65    !   <b>122(533)</b>, 1211-1226. doi:10.1002/qj.49712253310
    66    ! 種別型パラメタ
    67    ! Kind type parameter
    68    !
    69    use dc_types, only: DP,  & ! 倍精度実数型. Double precision.
    70      &                 TOKEN  ! キーワード.   Keywords.
    71  
    72    ! メッセージ出力
    73    ! Message output
    74    !
    75    use dc_message, only: MessageNotify
    76  
    77    ! 格子点設定
    78    ! Grid points settings
    79    !
    80    use gridset, only:       &
    81      &                imax, & ! 経度格子点数.
    82                               ! Number of grid points in longitude
    83      &                jmax, & ! 緯度格子点数.
    84                               ! Number of grid points in latitude
    85      &                kmax    ! 鉛直層数.
    86                               ! Number of vertical level
    87    use composition, only:                              &
    88      &                    ncmax,                       &
    89                               ! 成分の数
    90                               ! Number of composition
    91      &                    CompositionInqFlagAdv
    92  
    93    ! 座標データ設定
    94    ! Axes data settings
    95    !
    96    use axesset, only: &
    97        & DeltaLon, InvDeltaLon ! 経度格子点間隔とその逆数
    98                                ! Interval of Longitude grids and its inverse
    99  
   100    implicit none
   101  
   102    private
   103  
   104  !  public :: SLTTLagIntQuadCalcFactHor
   105  !  public :: SLTTLagIntQuadIntHor
   106  !  public :: SLTTLagIntQuadCalcFactVer
   107  !  public :: SLTTLagIntQuadIntVer
   108    public :: SLTTLagIntCubCalcFactHor
   109    public :: SLTTLagIntHorMaxMin
   110    public :: SLTTLagIntCubIntHor
   111    public :: SLTTLagIntCubCalcFactVer
   112    public :: SLTTLagIntCubIntVer
   113    public :: SLTTIrrHerIntK13
   114    public :: SLTTIrrLinInt
   115    public :: SLTTHerIntCub1D
   116    public :: SLTTHerIntCub2D
   117    public :: SLTTIrrHerIntQui1DUni
   118    public :: SLTTIrrHerIntQui1DNonUni
   119  !  public :: SLTTHerIntQui1D
   120  !  public :: judgeSun1996
   121  
   122  
   123    character(*), parameter:: module_name = 'sltt_lagint'
   124                                ! モジュールの名称.
   125                                ! Module name
   126    character(*), parameter:: version = &
   127      & '$Name:  $' // &
   128      & '$Id: sltt_lagint.F90,v 1.4 2013/09/21 14:42:08 yot Exp $'
   129                                ! モジュールのバージョン
   130                                ! Module version
   131  
   132  contains
   133  
   134    !--------------------------------------------------------------------------------------
   135  
   136  !  subroutine SLTTLagIntQuadCalcFactHor(             &
   137  !    & x_ExtLon, y_ExtLat, xyz_MPLon, xyz_MPLat,     & ! (in)
   138  !    & xyz_ii, xyz_jj, xyza_lqifx, xyza_lqify        & ! (out)
   139  !    & )
   140  !
   141  !    use sltt_const , only : PIx2, jew
   142  !    use mpi_wrapper, only : myrank
   143  !
   144  !    real(DP), intent(in ) :: x_ExtLon(-2+0:imax-1+3)
   145  !    real(DP), intent(in ) :: y_ExtLat(-jew+1:jmax/2+jew)
   146  !    real(DP), intent(in ) :: xyz_MPLon(0:imax-1, 1:jmax/2, 1:kmax)
   147  !    real(DP), intent(in ) :: xyz_MPLat(0:imax-1, 1:jmax/2, 1:kmax)
   148  !    integer , intent(out) :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   149  !    integer , intent(out) :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   150  !    real(DP), intent(out) :: xyza_lqifx(0:imax-1, 1:jmax/2, 1:kmax, 0:2)
   151  !    real(DP), intent(out) :: xyza_lqify(0:imax-1, 1:jmax/2, 1:kmax, 0:2)
   152  !
   153  !    !
   154  !    ! local variables
   155  !    !
   156  !    integer :: ii
   157  !    integer :: jj
   158  !
   159  !    integer :: i, j, k, j2
   160  !
   161  !
   162  !    xyz_ii = int( xyz_MPLon / ( PIx2 / imax ) )
   163  !
   164  !    do k = 1, kmax
   165  !      do j = 1, jmax/2
   166  !        do i = 0, imax-1
   167  !
   168  !          if( xyz_MPLat(i,j,k) > y_ExtLat(j) ) then
   169  !            j_search_1 : do j2 = j+1, jmax/2+jew
   170  !              if( y_ExtLat(j2) > xyz_MPLat(i,j,k) ) exit j_search_1
   171  !            end do j_search_1
   172  !            xyz_jj(i,j,k) = j2 - 1
   173  !            if ( xyz_jj(i,j,k) > jmax/2+jew-2 ) xyz_jj(i,j,k) = jmax/2+jew-2
   174  !          else
   175  !            j_search_2 : do j2 = j-1, -jew+1, -1
   176  !              if( y_ExtLat(j2) < xyz_MPLat(i,j,k) ) exit j_search_2
   177  !            end do j_search_2
   178  !            xyz_jj(i,j,k) = j2
   179  !            if ( xyz_jj(i,j,k) < -jew+1 ) xyz_jj(i,j,k) = -jew+1
   180  !          end if
   181  !
   182  !        end do
   183  !      end do
   184  !    end do
   185  !
   186  !#ifdef SLTT_CHECK
   187  !    do k = 1, kmax
   188  !      do j = 1, jmax/2
   189  !        do i = 0, imax-1
   190  !          if( ( xyz_jj(i,j,k) < 0 ) .or. ( xyz_jj(i,j,k) > (jmax+1) ) ) then
   191  !            write( 6, * ) 'Error: in sltt_dp_h0 : ', &
   192  !              'Latitudinal array size is not enough.'
   193  !            write( 6, * ) ' myrank = ', myrank, ' i = ', i, ' j = ', j, ' k = ', k
   194  !            write( 6, * ) 'jj = ', xyz_jj(i,j,k), ' jmax = ', jmax
   195  !            stop
   196  !          end if
   197  !        end do
   198  !      end do
   199  !    end do
   200  !#endif
   201  !
   202  !    !
   203  !    ! calculation of Lagrange cubic interpolation factor
   204  !    ! for longitudinal direction
   205  !    !
   206  !    do k = 1, kmax
   207  !      do j = 1, jmax/2
   208  !        do i = 0, imax-1
   209  !          ii = xyz_ii(i,j,k)
   210  !          jj = xyz_jj(i,j,k)
   211  !          xyza_lqifx(i,j,k,0) =                             &
   212  !            &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   213  !            &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   214  !            & / ( ( x_ExtLon(ii  )   - x_ExtLon(ii+1) )     &
   215  !            &   * ( x_ExtLon(ii  )   - x_ExtLon(ii+2) ) )
   216  !          xyza_lqifx(i,j,k,1) =                             &
   217  !            &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   218  !            &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   219  !            & / ( ( x_ExtLon(ii+1)   - x_ExtLon(ii  ) )     &
   220  !            &   * ( x_ExtLon(ii+1)   - x_ExtLon(ii+2) ) )
   221  !          xyza_lqifx(i,j,k,2) =                             &
   222  !            &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   223  !            &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   224  !            & / ( ( x_ExtLon(ii+2)   - x_ExtLon(ii  ) )     &
   225  !            &   * ( x_ExtLon(ii+2)   - x_ExtLon(ii+1) ) )
   226  !
   227  !          xyza_lqify(i,j,k,0) =                             &
   228  !            &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   229  !            &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   230  !            & / ( ( y_ExtLat(jj  )   - y_ExtLat(jj+1) )     &
   231  !            &   * ( y_ExtLat(jj  )   - y_ExtLat(jj+2) ) )
   232  !          xyza_lqify(i,j,k,1) =                             &
   233  !            &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   234  !            &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   235  !            & / ( ( y_ExtLat(jj+1)   - y_ExtLat(jj  ) )     &
   236  !            &   * ( y_ExtLat(jj+1)   - y_ExtLat(jj+2) ) )
   237  !          xyza_lqify(i,j,k,2) =                             &
   238  !            &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   239  !            &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   240  !            & / ( ( y_ExtLat(jj+2)   - y_ExtLat(jj) )       &
   241  !            &   * ( y_ExtLat(jj+2)   - y_ExtLat(jj+1) ) )
   242  !        end do
   243  !      end do
   244  !    end do
   245  !
   246  !
   247  !  end subroutine SLTTLagIntQuadCalcFactHor
   248  
   249    !--------------------------------------------------------------------------------------
   250  
   251  !  subroutine SLTTLagIntQuadIntHor(                        &
   252  !    & xyz_ii, xyz_jj, xyza_lqifx, xyza_lqify, xyz_ExtArr, & ! (in)
   253  !    & xyz_MPArr                                           & ! (out)
   254  !    & )
   255  !
   256  !    use sltt_const , only : jew
   257  !
   258  !    integer , intent(in ) :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   259  !    integer , intent(in ) :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   260  !    real(DP), intent(in ) :: xyza_lqifx(   0:imax-1  ,      1:jmax/2    , 1:kmax, 0:2)
   261  !    real(DP), intent(in ) :: xyza_lqify(   0:imax-1  ,      1:jmax/2    , 1:kmax, 0:2)
   262  !    real(DP), intent(in ) :: xyz_ExtArr(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)
   263  !    real(DP), intent(out) :: xyz_MPArr (   0:imax-1  ,      1:jmax/2    , 1:kmax)
   264  !
   265  !
   266  !    !
   267  !    ! local variables
   268  !    !
   269  !    integer :: ii
   270  !    integer :: jj
   271  !    integer :: kk
   272  !
   273  !    integer :: i, j, k
   274  !
   275  !
   276  !    do k = 1, kmax
   277  !      do j = 1, jmax/2
   278  !        do i = 0, imax-1
   279  !          ii = xyz_ii(i,j,k)
   280  !          jj = xyz_jj(i,j,k)
   281  !          kk = k
   282  !          xyz_MPArr(i,j,k) =                                      &
   283  !            &   xyza_lqify(i,j,k,0)                               &
   284  !            & * ( xyza_lqifx(i,j,k,0) * xyz_ExtArr(ii  ,jj  ,kk)  &
   285  !            &   + xyza_lqifx(i,j,k,1) * xyz_ExtArr(ii+1,jj  ,kk)  &
   286  !            &   + xyza_lqifx(i,j,k,2) * xyz_ExtArr(ii+2,jj  ,kk) )&
   287  !            & + xyza_lqify(i,j,k,1)                               &
   288  !            & * ( xyza_lqifx(i,j,k,0) * xyz_ExtArr(ii  ,jj+1,kk)  &
   289  !            &   + xyza_lqifx(i,j,k,1) * xyz_ExtArr(ii+1,jj+1,kk)  &
   290  !            &   + xyza_lqifx(i,j,k,2) * xyz_ExtArr(ii+2,jj+1,kk) )&
   291  !            & + xyza_lqify(i,j,k,2)                               &
   292  !            & * ( xyza_lqifx(i,j,k,0) * xyz_ExtArr(ii  ,jj+2,kk)  &
   293  !            &   + xyza_lqifx(i,j,k,1) * xyz_ExtArr(ii+1,jj+2,kk)  &
   294  !            &   + xyza_lqifx(i,j,k,2) * xyz_ExtArr(ii+2,jj+2,kk) )
   295  !        end do
   296  !      end do
   297  !    end do
   298  !
   299  !
   300  !  end subroutine SLTTLagIntQuadIntHor
   301  !
   302  !  !--------------------------------------------------------------------------------------
   303  !
   304  !  subroutine SLTTLagIntQuadCalcFactVer(  &
   305  !    & xyz_DPSigma,                & ! (in)
   306  !    & xyza_lqifz, xyz_kk          & ! (out)
   307  !    & )
   308  !
   309  !    ! 座標データ設定
   310  !    ! Axes data settings
   311  !    !
   312  !    use axesset, only : z_Sigma
   313  !
   314  !
   315  !    real(DP), intent(in ) :: xyz_DPSigma (0:imax-1, 1:jmax, 1:kmax)
   316  !    real(DP), intent(out) :: xyza_lqifa_z(0:imax-1, 1:jmax, 1:kmax, 0:2)
   317  !    integer , intent(out) :: xyz_kk    (0:imax-1, 1:jmax, 1:kmax)
   318  !
   319  !
   320  !    !
   321  !    ! local variables
   322  !    !
   323  !
   324  !    integer :: i
   325  !    integer :: j
   326  !    integer :: k
   327  !    integer :: kk
   328  !    integer :: k2
   329  !
   330  !
   331  !    do k = 1, kmax
   332  !      do j = 1, jmax
   333  !        do i = 0, imax-1
   334  !
   335  !          !
   336  !          ! Routine for dcpam
   337  !          !
   338  !          ! Departure points, xyz_DPSigma(:,:,k), must be located between
   339  !          ! z_Sigma(kk) > xyz_DPSigma(k) > z_Sigma(kk+1).
   340  !          ! Further, 1 <= kk <= kmax-2.
   341  !          !
   342  !
   343  !          !
   344  !          ! economical method
   345  !          !
   346  !          if( xyz_DPSigma(i,j,k) > z_Sigma(k) ) then
   347  !            k_search_1 : do k2 = k, 1, -1
   348  !              if( z_Sigma(k2) > xyz_DPSigma(i,j,k) ) exit k_search_1
   349  !            end do k_search_1
   350  !            xyz_kk(i,j,k) = k2
   351  !          else
   352  !            k_search_2 : do k2 = min( k+1, kmax ), kmax
   353  !              if( z_Sigma(k2) < xyz_DPSigma(i,j,k) ) exit k_search_2
   354  !            end do k_search_2
   355  !            xyz_kk(i,j,k) = k2 - 1
   356  !          end if
   357  !          xyz_kk(i,j,k) = min( max( xyz_kk(i,j,k), 1 ), kmax-2 )
   358  !
   359  !        end do
   360  !      end do
   361  !    end do
   362  !
   363  !
   364  !    do k = 1, kmax
   365  !      do j = 1, jmax
   366  !        do i = 0, imax-1
   367  !          kk = xyz_kk(i,j,k)
   368  !          xyza_lqifa_z(i,j,k,0) =                          &
   369  !            &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   370  !            &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   371  !            & / ( ( z_Sigma(kk  )      - z_Sigma(kk+1) ) &
   372  !            &   * ( z_Sigma(kk  )      - z_Sigma(kk+2) ) )
   373  !          xyza_lqifa_z(i,j,k,1) =                          &
   374  !            &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   375  !            &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   376  !            & / ( ( z_Sigma(kk+1)      - z_Sigma(kk  ) ) &
   377  !            &   * ( z_Sigma(kk+1)      - z_Sigma(kk+2) ) )
   378  !          xyza_lqifa_z(i,j,k,2) =                          &
   379  !            &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   380  !            &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   381  !            & / ( ( z_Sigma(kk+2)      - z_Sigma(kk  ) ) &
   382  !            &   * ( z_Sigma(kk+2)      - z_Sigma(kk+1) ) )
   383  !        end do
   384  !      end do
   385  !    end do
   386  !
   387  !
   388  !  end subroutine SLTTLagIntQuadCalcFactVer
   389  !
   390  !  !--------------------------------------------------------------------------------------
   391  !
   392  !  subroutine SLTTLagIntQuadIntVer( &
   393  !    & xyz_Arr, xyza_lqifz, xyz_kk, & ! (in)
   394  !    & xyz_ArrA                     & ! (out)
   395  !    & )
   396  !
   397  !
   398  !    real(DP), intent(in ) :: xyz_Arr   (0:imax-1, 1:jmax, 1:kmax)
   399  !    real(DP), intent(in ) :: xyza_lqifa_z(0:imax-1, 1:jmax, 1:kmax, 0:2)
   400  !    integer , intent(in ) :: xyz_kk    (0:imax-1, 1:jmax, 1:kmax)
   401  !    real(DP), intent(out) :: xyz_ArrA  (0:imax-1, 1:jmax, 1:kmax)
   402  !
   403  !
   404  !    !
   405  !    ! local variables
   406  !    !
   407  !
   408  !    integer :: i
   409  !    integer :: j
   410  !    integer :: k
   411  !    integer :: kk
   412  !
   413  !
   414  !    do k = 1, kmax
   415  !      do j = 1, jmax
   416  !        do i = 0, imax-1
   417  !          kk = xyz_kk(i,j,k)
   418  !          xyz_ArrA(i,j,k) =                             &
   419  !            &   xyza_lqifa_z(i,j,k,0) * xyz_Arr(i,j,kk  ) &
   420  !            & + xyza_lqifa_z(i,j,k,1) * xyz_Arr(i,j,kk+1) &
   421  !            & + xyza_lqifa_z(i,j,k,2) * xyz_Arr(i,j,kk+2)
   422  !        end do
   423  !      end do
   424  !    end do
   425  !
   426  !
   427  !  end subroutine SLTTLagIntQuadIntVer
   428  
   429    !--------------------------------------------------------------------------------------
   430  
   431    subroutine SLTTLagIntCubCalcFactHor(              &
   432      & iexmin, iexmax, jexmin, jexmax,               & ! (in)
   433      & x_ExtLon, y_ExtLat, xyz_MPLon, xyz_MPLat,     & ! (in)
   434      & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify        & ! (out)
   435      & )
   436    ! 水平２次元ラグランジュ３次補間の係数計算
   437    ! Calculation of factors for 2D Lagrangian cubic interpolation
   438  
   439      use sltt_const , only : PIx2
   440      use mpi_wrapper, only : myrank
   441  
   442      integer , intent(in ) :: iexmin
   443      integer , intent(in ) :: iexmax
   444      integer , intent(in ) :: jexmin
   445      integer , intent(in ) :: jexmax
   446      real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
   447      real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
   448      real(DP), intent(in ) :: xyz_MPLon(0:imax-1, 1:jmax/2, 1:kmax)
   449      real(DP), intent(in ) :: xyz_MPLat(0:imax-1, 1:jmax/2, 1:kmax)
   450      integer , intent(out) :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   451      integer , intent(out) :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   452      real(DP), intent(out) :: xyza_lcifx(0:imax-1, 1:jmax/2, 1:kmax, -1:2)
   453      real(DP), intent(out) :: xyza_lcify(0:imax-1, 1:jmax/2, 1:kmax, -1:2)
   454  
   455      !
   456      ! local variables
   457      !
   458      integer :: ii
   459      integer :: jj
   460  
   461      integer :: i, j, k, j2
   462  
   463  !    integer  :: ns            ! 南北半球の違いに対応するための変数
   464  !    real(DP) :: in_deltalat
   465  !
   466  !if (y_ExtLat(jmax/4) > 0) then
   467  !    ns = 0
   468  !else
   469  !    ns = jmax/2 - 1
   470  !endif
   471  !in_deltalat = 1.0_DP/(y_ExtLat(jmax/4) - y_ExtLat(jmax/4-1))
   472  
   473  
   474  
   475      xyz_ii = int( xyz_MPLon / ( PIx2 / imax ) )
     .        d1 = 1.D0/(pix2/dfloat(imax))                                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t658 = 1, kmax*(jmax/2)*imax                                   
     .           xyz_ii(t658-1,1,1) = ifix(xyz_mplon(t658-1,1,1)*d1)            
     .        enddo                                                             
   476  
   477      do k = 1, kmax
   478        do j = 1, jmax/2
   479          do i = 0, imax-1
   480  
   481            ! comment out 2015/04/10
   482  !!$          if( xyz_MPLat(i,j,k) > y_ExtLat(j) ) then
   483  !!$            j_search_1 : do j2 = j+1, jexmax
   484  !!$              if( y_ExtLat(j2) > xyz_MPLat(i,j,k) ) exit j_search_1
   485  !!$            end do j_search_1
   486  !!$            xyz_jj(i,j,k) = j2 - 1
   487  !!$            if ( xyz_jj(i,j,k) > jexmax-2 ) xyz_jj(i,j,k) = jexmax-2
   488  !!$          else
   489  !!$            j_search_2 : do j2 = j-1, jexmin, -1
   490  !!$              if( y_ExtLat(j2) < xyz_MPLat(i,j,k) ) exit j_search_2
   491  !!$            end do j_search_2
   492  !!$            xyz_jj(i,j,k) = j2
   493  !!$            if ( xyz_jj(i,j,k) < jexmin+1 ) xyz_jj(i,j,k) = jexmin+1
   494  !!$          end if
   495            ! trial
   496            if( xyz_MPLat(i,j,k) > y_ExtLat(j) ) then
   497              j_search_1 : do j2 = j+1, jexmax
   498                if( y_ExtLat(j2) > xyz_MPLat(i,j,k) ) exit j_search_1
   499              end do j_search_1
   500              xyz_jj(i,j,k) = j2 - 1
   501            else
   502              j_search_2 : do j2 = j-1, jexmin, -1
   503                if( y_ExtLat(j2) < xyz_MPLat(i,j,k) ) exit j_search_2
   504              end do j_search_2
   505              xyz_jj(i,j,k) = j2
   506            end if
   507  
   508  
   509  !             xyz_jj(i,j,k) = int(xyz_MPLat(i,j,k)*in_deltalat) + ns + 1
   510  !             if (y_ExtLat(xyz_jj(i,j,k)) > xyz_MPLat(i, j, k)) then
   511  !                xyz_jj(i,j,k) = xyz_jj(i,j,k) - 1
   512  !             endif
   513  
   514  
   515          end do
   516        end do
   517      end do
   518  
   519      do k = 1, kmax
   520        do j = 1, jmax/2
   521          do i = 0, imax-1
   522            ii = xyz_ii(i,j,k)
   523            if ( ii-1 < iexmin ) then
   524              call MessageNotify( 'E', module_name, &
   525                & 'Longitudinal point for interporation factor calculation ' &
   526                & // 'is is out of range of an extended array : Rank %d, (i,j,k) = (%d,%d,%d).', &
   527                & i = (/ myrank, i, j, k /) )
   528            end if
   529            if ( ii+2 > iexmax ) then
   530              call MessageNotify( 'E', module_name, &
   531                & 'Longitudinal point for interporation factor calculation ' &
   532                & // 'is is out of range of an extended array : Rank %d, (i,j,k) = (%d,%d,%d).', &
   533                & i = (/ myrank, i, j, k /) )
   534            end if
   535            jj = xyz_jj(i,j,k)
   536            if ( jj-1 < jexmin ) then
   537              call MessageNotify( 'E', module_name, &
   538                & 'Latitudinal point for interporation factor calculation ' &
   539                & // 'is is out of range of an extended array : Rank %d, (i,j,k) = (%d,%d,%d).', &
   540                & i = (/ myrank, i, j, k /) )
   541            end if
   542            if ( jj+2 > jexmax ) then
   543              call MessageNotify( 'E', module_name, &
   544                & 'Latitudinal point for interporation factor calculation ' &
   545                & // 'is is out of range of an extended array : Rank %d, (i,j,k) = (%d,%d,%d).', &
   546                & i = (/ myrank, i, j, k /) )
   547            end if
   548          end do
   549        end do
   550      end do
   551  
   552      !
   553      ! calculation of Lagrange cubic interpolation factor
   554      ! for longitudinal direction
   555      !
   556      do k = 1, kmax
   557        do j = 1, jmax/2
   558          do i = 0, imax-1
   559            ii = xyz_ii(i,j,k)
   560            jj = xyz_jj(i,j,k)
   561            xyza_lcifx(i,j,k,-1) =                            &
   562              &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   563              &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   564              &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   565              &   * (-InvDeltaLon**3)/6.0_DP                  ! economical
   566  !            & / ( ( x_ExtLon(ii-1)   - x_ExtLon(ii  ) )     &
   567  !            &   * ( x_ExtLon(ii-1)   - x_ExtLon(ii+1) )     &
   568  !            &   * ( x_ExtLon(ii-1)   - x_ExtLon(ii+2) ) )
   569            xyza_lcifx(i,j,k, 0) =                            &
   570              &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii-1) )     &
   571              &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   572              &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   573              &   * (0.5_DP*InvDeltaLon**3)                   ! economical
   574  !            & / ( ( x_ExtLon(ii  )   - x_ExtLon(ii-1) )     &
   575  !            &   * ( x_ExtLon(ii  )   - x_ExtLon(ii+1) )     &
   576  !            &   * ( x_ExtLon(ii  )   - x_ExtLon(ii+2) ) )
   577            xyza_lcifx(i,j,k, 1) =                            &
   578              &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii-1) )     &
   579              &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   580              &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   581              &   * (-0.5_DP*InvDeltaLon**3)                  ! economical
   582  !            & / ( ( x_ExtLon(ii+1)   - x_ExtLon(ii-1) )     &
   583  !            &   * ( x_ExtLon(ii+1)   - x_ExtLon(ii  ) )     &
   584  !            &   * ( x_ExtLon(ii+1)   - x_ExtLon(ii+2) ) )
   585            xyza_lcifx(i,j,k, 2) =                            &
   586              &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii-1) )     &
   587              &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   588              &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   589              &   * (InvDeltaLon**3)/6.0_DP                   ! economical
   590  !            & / ( ( x_ExtLon(ii+2)   - x_ExtLon(ii-1) )     &
   591  !            &   * ( x_ExtLon(ii+2)   - x_ExtLon(ii  ) )     &
   592  !            &   * ( x_ExtLon(ii+2)   - x_ExtLon(ii+1) ) )
   593  
   594            xyza_lcify(i,j,k,-1) =                            &
   595              &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   596              &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   597              &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   598              & / ( ( y_ExtLat(jj-1)   - y_ExtLat(jj  ) )     &
   599              &   * ( y_ExtLat(jj-1)   - y_ExtLat(jj+1) )     &
   600              &   * ( y_ExtLat(jj-1)   - y_ExtLat(jj+2) ) )
   601            xyza_lcify(i,j,k, 0) =                            &
   602              &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj-1) )     &
   603              &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   604              &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   605              & / ( ( y_ExtLat(jj  )   - y_ExtLat(jj-1) )     &
   606              &   * ( y_ExtLat(jj  )   - y_ExtLat(jj+1) )     &
   607              &   * ( y_ExtLat(jj  )   - y_ExtLat(jj+2) ) )
   608            xyza_lcify(i,j,k, 1) =                            &
   609              &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj-1) )     &
   610              &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   611              &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   612              & / ( ( y_ExtLat(jj+1)   - y_ExtLat(jj-1) )     &
   613              &   * ( y_ExtLat(jj+1)   - y_ExtLat(jj  ) )     &
   614              &   * ( y_ExtLat(jj+1)   - y_ExtLat(jj+2) ) )
   615            xyza_lcify(i,j,k, 2) =                            &
   616              &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj-1) )     &
   617              &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   618              &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   619              & / ( ( y_ExtLat(jj+2)   - y_ExtLat(jj-1) )     &
   620              &   * ( y_ExtLat(jj+2)   - y_ExtLat(jj  ) )     &
   621              &   * ( y_ExtLat(jj+2)   - y_ExtLat(jj+1) ) )
   622          end do
   623        end do
   624      end do
     .        d2 = (-(invdeltalon**3))/6.00000000000000e+000                    
     .        d3 = (invdeltalon**3)/6.00000000000000e+000                       
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*(jmax/2)*imax                                      
     .           ii = xyz_ii(k-1,1,1)                                           
     .           jj = xyz_jj(k-1,1,1)                                           
     .           xyza_lcifx(k-1,1,1,-1) = (xyz_mplon(k-1,1,1)-(x_extlon(ii)))*( 
     .       1      xyz_mplon(k-1,1,1)-x_extlon(ii+1))*(xyz_mplon(k-1,1,1)-     
     .       2      x_extlon(ii+2))*d2                                          
     .           xyza_lcifx(k-1,1,1,0) = (xyz_mplon(k-1,1,1)-x_extlon(ii-1))*(  
     .       1      xyz_mplon(k-1,1,1)-x_extlon(ii+1))*(xyz_mplon(k-1,1,1)-     
     .       2      x_extlon(ii+2))*(5.00000000000000e-001*(invdeltalon**3))    
     .           xyza_lcifx(k-1,1,1,1) = (xyz_mplon(k-1,1,1)-x_extlon(ii-1))*(  
     .       1      xyz_mplon(k-1,1,1)-(x_extlon(ii)))*(xyz_mplon(k-1,1,1)-     
     .       2      x_extlon(ii+2))*(-(5.00000000000000e-001*(invdeltalon**3))) 
     .           xyza_lcifx(k-1,1,1,2) = (xyz_mplon(k-1,1,1)-x_extlon(ii-1))*(  
     .       1      xyz_mplon(k-1,1,1)-(x_extlon(ii)))*(xyz_mplon(k-1,1,1)-     
     .       2      x_extlon(ii+1))*d3                                          
     .           xyza_lcify(k-1,1,1,-1) = (xyz_mplat(k-1,1,1)-(y_extlat(jj)))*( 
     .       1      xyz_mplat(k-1,1,1)-y_extlat(jj+1))*(xyz_mplat(k-1,1,1)-     
     .       2      y_extlat(jj+2))/((y_extlat(jj-1)-(y_extlat(jj)))*(y_extlat( 
     .       3      jj-1)-y_extlat(jj+1))*(y_extlat(jj-1)-y_extlat(jj+2)))      
     .           xyza_lcify(k-1,1,1,0) = (xyz_mplat(k-1,1,1)-y_extlat(jj-1))*(  
     .       1      xyz_mplat(k-1,1,1)-y_extlat(jj+1))*(xyz_mplat(k-1,1,1)-     
     .       2      y_extlat(jj+2))/(((y_extlat(jj))-y_extlat(jj-1))*((y_extlat(
     .       3      jj))-y_extlat(jj+1))*((y_extlat(jj))-y_extlat(jj+2)))       
     .           xyza_lcify(k-1,1,1,1) = (xyz_mplat(k-1,1,1)-y_extlat(jj-1))*(  
     .       1      xyz_mplat(k-1,1,1)-(y_extlat(jj)))*(xyz_mplat(k-1,1,1)-     
     .       2      y_extlat(jj+2))/((y_extlat(jj+1)-y_extlat(jj-1))*(y_extlat( 
     .       3      jj+1)-(y_extlat(jj)))*(y_extlat(jj+1)-y_extlat(jj+2)))      
     .           xyza_lcify(k-1,1,1,2) = (xyz_mplat(k-1,1,1)-y_extlat(jj-1))*(  
     .       1      xyz_mplat(k-1,1,1)-(y_extlat(jj)))*(xyz_mplat(k-1,1,1)-     
     .       2      y_extlat(jj+1))/((y_extlat(jj+2)-y_extlat(jj-1))*(y_extlat( 
     .       3      jj+2)-(y_extlat(jj)))*(y_extlat(jj+2)-y_extlat(jj+1)))      
     .        enddo                                                             
   625  
   626  
   627    end subroutine SLTTLagIntCubCalcFactHor
   628  
   629    !--------------------------------------------------------------------------------------
   630  
   631    subroutine SLTTLagIntCubIntHor(                         &
   632      & iexmin, iexmax, jexmin, jexmax,                     & ! (in)
   633      & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify, xyz_ExtArr, & ! (in)
   634      & xyz_MPArr                                           & ! (out)
   635      & )
   636      ! 水平２次元ラグランジュ３次補間
   637      ! 2D Lagrangian cubic interpolation
   638  
   639  
   640      integer , intent(in ) :: iexmin
   641      integer , intent(in ) :: iexmax
   642      integer , intent(in ) :: jexmin
   643      integer , intent(in ) :: jexmax
   644      integer , intent(in ) :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   645      integer , intent(in ) :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   646      real(DP), intent(in ) :: xyza_lcifx(     0:imax-1,      1:jmax/2, 1:kmax, -1:2)
   647      real(DP), intent(in ) :: xyza_lcify(     0:imax-1,      1:jmax/2, 1:kmax, -1:2)
   648      real(DP), intent(in ) :: xyz_ExtArr(iexmin:iexmax, jexmin:jexmax, 1:kmax)
   649      real(DP), intent(out) :: xyz_MPArr (     0:imax-1,      1:jmax/2, 1:kmax)
   650  
   651  
   652      !
   653      ! local variables
   654      !
   655      integer :: ii
   656      integer :: jj
   657      integer :: kk
   658  
   659      integer :: i, j, k
   660  
   661  
   662      do k = 1, kmax
   663        do j = 1, jmax/2
   664          do i = 0, imax-1
   665            ii = xyz_ii(i,j,k)
   666            jj = xyz_jj(i,j,k)
   667            kk = k
   668            xyz_MPArr(i,j,k) =                                       &
   669              &   xyza_lcify(i,j,k,-1)                               &
   670              & * ( xyza_lcifx(i,j,k,-1) * xyz_ExtArr(ii-1,jj-1,kk)  &
   671              &   + xyza_lcifx(i,j,k, 0) * xyz_ExtArr(ii  ,jj-1,kk)  &
   672              &   + xyza_lcifx(i,j,k, 1) * xyz_ExtArr(ii+1,jj-1,kk)  &
   673              &   + xyza_lcifx(i,j,k, 2) * xyz_ExtArr(ii+2,jj-1,kk) )&
   674              & + xyza_lcify(i,j,k, 0)                               &
   675              & * ( xyza_lcifx(i,j,k,-1) * xyz_ExtArr(ii-1,jj  ,kk)  &
   676              &   + xyza_lcifx(i,j,k, 0) * xyz_ExtArr(ii  ,jj  ,kk)  &
   677              &   + xyza_lcifx(i,j,k, 1) * xyz_ExtArr(ii+1,jj  ,kk)  &
   678              &   + xyza_lcifx(i,j,k, 2) * xyz_ExtArr(ii+2,jj  ,kk) )&
   679              & + xyza_lcify(i,j,k, 1)                               &
   680              & * ( xyza_lcifx(i,j,k,-1) * xyz_ExtArr(ii-1,jj+1,kk)  &
   681              &   + xyza_lcifx(i,j,k, 0) * xyz_ExtArr(ii  ,jj+1,kk)  &
   682              &   + xyza_lcifx(i,j,k, 1) * xyz_ExtArr(ii+1,jj+1,kk)  &
   683              &   + xyza_lcifx(i,j,k, 2) * xyz_ExtArr(ii+2,jj+1,kk) )&
   684              & + xyza_lcify(i,j,k, 2)                               &
   685              & * ( xyza_lcifx(i,j,k,-1) * xyz_ExtArr(ii-1,jj+2,kk)  &
   686              &   + xyza_lcifx(i,j,k, 0) * xyz_ExtArr(ii  ,jj+2,kk)  &
   687              &   + xyza_lcifx(i,j,k, 1) * xyz_ExtArr(ii+1,jj+2,kk)  &
   688              &   + xyza_lcifx(i,j,k, 2) * xyz_ExtArr(ii+2,jj+2,kk) )
   689          end do
   690        end do
     .        kk = k                                                            
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, (jmax/2)*imax                                           
     .           ii = xyz_ii(j-1,1,k)                                           
     .           jj = xyz_jj(j-1,1,k)                                           
     .           xyz_mparr(j-1,1,k) = xyza_lcify(j-1,1,k,-1)*(xyza_lcifx(j-1,1,k
     .       1      ,-1)*xyz_extarr(ii-1,jj-1,kk)+xyza_lcifx(j-1,1,k,0)*        
     .       2      xyz_extarr(ii,jj-1,kk)+xyza_lcifx(j-1,1,k,1)*xyz_extarr(ii+1
     .       3      ,jj-1,kk)+xyza_lcifx(j-1,1,k,2)*xyz_extarr(ii+2,jj-1,kk)) + 
     .       4      xyza_lcify(j-1,1,k,0)*(xyza_lcifx(j-1,1,k,-1)*xyz_extarr(ii-
     .       5      1,jj,kk)+xyza_lcifx(j-1,1,k,0)*xyz_extarr(ii,jj,kk)+        
     .       6      xyza_lcifx(j-1,1,k,1)*xyz_extarr(ii+1,jj,kk)+xyza_lcifx(j-1,
     .       7      1,k,2)*xyz_extarr(ii+2,jj,kk)) + xyza_lcify(j-1,1,k,1)*(    
     .       8      xyza_lcifx(j-1,1,k,-1)*xyz_extarr(ii-1,jj+1,kk)+xyza_lcifx(j
     .       9      -1,1,k,0)*xyz_extarr(ii,jj+1,kk)+xyza_lcifx(j-1,1,k,1)*     
     .       .      xyz_extarr(ii+1,jj+1,kk)+xyza_lcifx(j-1,1,k,2)*xyz_extarr(ii
     .       1      +2,jj+1,kk)) + xyza_lcify(j-1,1,k,2)*(xyza_lcifx(j-1,1,k,-1)
     .       2      *xyz_extarr(ii-1,jj+2,kk)+xyza_lcifx(j-1,1,k,0)*xyz_extarr( 
     .       3      ii,jj+2,kk)+xyza_lcifx(j-1,1,k,1)*xyz_extarr(ii+1,jj+2,kk)+ 
     .       4      xyza_lcifx(j-1,1,k,2)*xyz_extarr(ii+2,jj+2,kk))             
     .        enddo                                                             
   691      end do
   692  
   693  
   694    end subroutine SLTTLagIntCubIntHor
   695  
   696    !--------------------------------------------------------------------------------------
   697  
   698    subroutine SLTTLagIntCubCalcFactVer(  &
   699      & xyz_DPSigma,                & ! (in)
   700      & xyza_lcifz, xyz_kk          & ! (out)
   701      & )
   702    ! 鉛直１次元ラグランジュ３次補間のための係数計算
   703    ! Calculation of factors for 1D Lagrangian cubic interpolation
   704  
   705      ! 座標データ設定
   706      ! Axes data settings
   707      !
   708      use axesset, only : z_Sigma
   709  
   710  
   711      real(DP), intent(in ) :: xyz_DPSigma (0:imax-1, 1:jmax, 1:kmax)
   712      real(DP), intent(out) :: xyza_lcifz(0:imax-1, 1:jmax, 1:kmax, -1:2)
   713      integer , intent(out) :: xyz_kk    (0:imax-1, 1:jmax, 1:kmax)
   714  
   715  
   716      !
   717      ! local variables
   718      !
   719  
   720      integer :: i
   721      integer :: j
   722      integer :: k
   723      integer :: kk
   724      integer :: k2
   725  
   726  
   727      do k = 1, kmax
   728        do j = 1, jmax
   729          do i = 0, imax-1
   730  
   731            !
   732            ! Routine for dcpam
   733            !
   734            ! Departure points, xyz_DPSigma(:,:,k), must be located between
   735            ! z_Sigma(kk) > xyz_DPSigma(k) > z_Sigma(kk+1).
   736            ! Further, 2 <= kk <= kmax-2.
   737            !
   738  
   739            !
   740            ! economical method
   741            !
   742            if( xyz_DPSigma(i,j,k) > z_Sigma(k) ) then
   743              k_search_1 : do k2 = k, 2, -1
   744                if( z_Sigma(k2) > xyz_DPSigma(i,j,k) ) exit k_search_1
   745              end do k_search_1
   746              xyz_kk(i,j,k) = k2
   747            else
   748              k_search_2 : do k2 = min( k+1, kmax ), kmax
   749                if( z_Sigma(k2) < xyz_DPSigma(i,j,k) ) exit k_search_2
   750              end do k_search_2
   751              xyz_kk(i,j,k) = k2 - 1
   752            end if
   753            xyz_kk(i,j,k) = min( max( xyz_kk(i,j,k), 2 ), kmax-2 )
   754  !          xyz_kk(i,j,k) = min( max( xyz_kk(i,j,k), 1 ), kmax-1 )
   755  
   756          end do
   757        end do
   758      end do
   759  
   760  
   761      do k = 1, kmax
   762        do j = 1, jmax
   763          do i = 0, imax-1
   764            kk = xyz_kk(i,j,k)
   765            xyza_lcifz(i,j,k,-1) =                         &
   766              &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   767              &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   768              &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   769              & / ( ( z_Sigma(kk-1)      - z_Sigma(kk  ) ) &
   770              &   * ( z_Sigma(kk-1)      - z_Sigma(kk+1) ) &
   771              &   * ( z_Sigma(kk-1)      - z_Sigma(kk+2) ) )
   772            xyza_lcifz(i,j,k, 0) =                         &
   773              &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk-1) ) &
   774              &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   775              &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   776              & / ( ( z_Sigma(kk  )      - z_Sigma(kk-1) ) &
   777              &   * ( z_Sigma(kk  )      - z_Sigma(kk+1) ) &
   778              &   * ( z_Sigma(kk  )      - z_Sigma(kk+2) ) )
   779            xyza_lcifz(i,j,k, 1) =                         &
   780              &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk-1) ) &
   781              &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   782              &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   783              & / ( ( z_Sigma(kk+1)      - z_Sigma(kk-1) ) &
   784              &   * ( z_Sigma(kk+1)      - z_Sigma(kk  ) ) &
   785              &   * ( z_Sigma(kk+1)      - z_Sigma(kk+2) ) )
   786            xyza_lcifz(i,j,k, 2) =                         &
   787              &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk-1) ) &
   788              &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   789              &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   790              & / ( ( z_Sigma(kk+2)      - z_Sigma(kk-1) ) &
   791              &   * ( z_Sigma(kk+2)      - z_Sigma(kk  ) ) &
   792              &   * ( z_Sigma(kk+2)      - z_Sigma(kk+1) ) )
   793          end do
   794        end do
   795      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           kk = xyz_kk(k-1,1,1)                                           
     .           xyza_lcifz(k-1,1,1,-1) = (xyz_dpsigma(k-1,1,1)-(z_sigma(kk)))*(
     .       1      xyz_dpsigma(k-1,1,1)-z_sigma(kk+1))*(xyz_dpsigma(k-1,1,1)-  
     .       2      z_sigma(kk+2))/((z_sigma(kk-1)-(z_sigma(kk)))*(z_sigma(kk-1)
     .       3      -z_sigma(kk+1))*(z_sigma(kk-1)-z_sigma(kk+2)))              
     .           xyza_lcifz(k-1,1,1,0) = (xyz_dpsigma(k-1,1,1)-z_sigma(kk-1))*( 
     .       1      xyz_dpsigma(k-1,1,1)-z_sigma(kk+1))*(xyz_dpsigma(k-1,1,1)-  
     .       2      z_sigma(kk+2))/(((z_sigma(kk))-z_sigma(kk-1))*((z_sigma(kk))
     .       3      -z_sigma(kk+1))*((z_sigma(kk))-z_sigma(kk+2)))              
     .           xyza_lcifz(k-1,1,1,1) = (xyz_dpsigma(k-1,1,1)-z_sigma(kk-1))*( 
     .       1      xyz_dpsigma(k-1,1,1)-(z_sigma(kk)))*(xyz_dpsigma(k-1,1,1)-  
     .       2      z_sigma(kk+2))/((z_sigma(kk+1)-z_sigma(kk-1))*(z_sigma(kk+1)
     .       3      -(z_sigma(kk)))*(z_sigma(kk+1)-z_sigma(kk+2)))              
     .           xyza_lcifz(k-1,1,1,2) = (xyz_dpsigma(k-1,1,1)-z_sigma(kk-1))*( 
     .       1      xyz_dpsigma(k-1,1,1)-(z_sigma(kk)))*(xyz_dpsigma(k-1,1,1)-  
     .       2      z_sigma(kk+1))/((z_sigma(kk+2)-z_sigma(kk-1))*(z_sigma(kk+2)
     .       3      -(z_sigma(kk)))*(z_sigma(kk+2)-z_sigma(kk+1)))              
     .        enddo                                                             
   796  
   797  
   798    end subroutine SLTTLagIntCubCalcFactVer
   799  
   800    !--------------------------------------------------------------------------------------
   801  
   802    subroutine SLTTLagIntCubIntVer(  &
   803      & xyz_Arr, xyza_lcifz, xyz_kk, & ! (in)
   804      & xyz_ArrA                     & ! (out)
   805      & )
   806    ! 鉛直１次元ラグランジュ３次補間
   807    ! 1D Lagrangian cubic interpolation
   808  
   809      real(DP), intent(in ) :: xyz_Arr   (0:imax-1, 1:jmax, 1:kmax)
   810      real(DP), intent(in ) :: xyza_lcifz(0:imax-1, 1:jmax, 1:kmax, -1:2)
   811      integer , intent(in ) :: xyz_kk    (0:imax-1, 1:jmax, 1:kmax)
   812      real(DP), intent(out) :: xyz_ArrA  (0:imax-1, 1:jmax, 1:kmax)
   813  
   814  
   815      !
   816      ! local variables
   817      !
   818  
   819      integer :: i
   820      integer :: j
   821      integer :: k
   822      integer :: kk
   823  
   824  
   825      do k = 1, kmax
   826        do j = 1, jmax
   827          do i = 0, imax-1
   828            kk = xyz_kk(i,j,k)
   829            xyz_ArrA(i,j,k) =                              &
   830              &   xyza_lcifz(i,j,k,-1) * xyz_Arr(i,j,kk-1) &
   831              & + xyza_lcifz(i,j,k, 0) * xyz_Arr(i,j,kk  ) &
   832              & + xyza_lcifz(i,j,k, 1) * xyz_Arr(i,j,kk+1) &
   833              & + xyza_lcifz(i,j,k, 2) * xyz_Arr(i,j,kk+2)
   834          end do
   835        end do
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyz_arra(i-1,j,k) = xyza_lcifz(i-1,j,k,-1)*xyz_arr(i-1,j,
     .       1            xyz_kk(i-1,j,k)-1) + xyza_lcifz(i-1,j,k,0)*xyz_arr(i-1
     .       2            ,j,xyz_kk(i-1,j,k)) + xyza_lcifz(i-1,j,k,1)*xyz_arr(i-
     .       3            1,j,xyz_kk(i-1,j,k)+1) + xyza_lcifz(i-1,j,k,2)*xyz_arr
     .       4            (i-1,j,xyz_kk(i-1,j,k)+2)                             
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyz_arra(i-1,j,k) = xyza_lcifz(i-1,j,k,-1)*xyz_arr(i-1,j,
     .       1            xyz_kk(i-1,j,k)-1) + xyza_lcifz(i-1,j,k,0)*xyz_arr(i-1
     .       2            ,j,xyz_kk(i-1,j,k)) + xyza_lcifz(i-1,j,k,1)*xyz_arr(i-
     .       3            1,j,xyz_kk(i-1,j,k)+1) + xyza_lcifz(i-1,j,k,2)*xyz_arr
     .       4            (i-1,j,xyz_kk(i-1,j,k)+2)                             
     .                 xyz_arra(i-1,j+1,k) = xyza_lcifz(i-1,j+1,k,-1)*xyz_arr(i-
     .       1            1,1+j,xyz_kk(i-1,j+1,k)-1) + xyza_lcifz(i-1,j+1,k,0)* 
     .       2            xyz_arr(i-1,1+j,xyz_kk(i-1,j+1,k)) + xyza_lcifz(i-1,j+
     .       3            1,k,1)*xyz_arr(i-1,1+j,xyz_kk(i-1,j+1,k)+1) +         
     .       4            xyza_lcifz(i-1,j+1,k,2)*xyz_arr(i-1,1+j,xyz_kk(i-1,j+1
     .       5            ,k)+2)                                                
     .                 xyz_arra(i-1,j+2,k) = xyza_lcifz(i-1,j+2,k,-1)*xyz_arr(i-
     .       1            1,2+j,xyz_kk(i-1,j+2,k)-1) + xyza_lcifz(i-1,j+2,k,0)* 
     .       2            xyz_arr(i-1,2+j,xyz_kk(i-1,j+2,k)) + xyza_lcifz(i-1,j+
     .       3            2,k,1)*xyz_arr(i-1,2+j,xyz_kk(i-1,j+2,k)+1) +         
     .       4            xyza_lcifz(i-1,j+2,k,2)*xyz_arr(i-1,2+j,xyz_kk(i-1,j+2
     .       5            ,k)+2)                                                
     .                 xyz_arra(i-1,j+3,k) = xyza_lcifz(i-1,j+3,k,-1)*xyz_arr(i-
     .       1            1,3+j,xyz_kk(i-1,j+3,k)-1) + xyza_lcifz(i-1,j+3,k,0)* 
     .       2            xyz_arr(i-1,3+j,xyz_kk(i-1,j+3,k)) + xyza_lcifz(i-1,j+
     .       3            3,k,1)*xyz_arr(i-1,3+j,xyz_kk(i-1,j+3,k)+1) +         
     .       4            xyza_lcifz(i-1,j+3,k,2)*xyz_arr(i-1,3+j,xyz_kk(i-1,j+3
     .       5            ,k)+2)                                                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   836      end do
   837  
   838  
   839    end subroutine SLTTLagIntCubIntVer
   840  
   841    !--------------------------------------------------------------------------------------
   842  
   843    subroutine SLTTLagIntHorMaxMin(                                &
   844      & iexmin, iexmax, jexmin, jexmax,                            & ! (in)
   845      & x_ExtLon, y_ExtLat, xyz_DPLon, xyz_DPLat, xyzf_ExtQMixB,   & ! (in)
   846      & xyzf_QMixMinA, xyzf_QMixMaxA                               & ! (out)
   847      & )
   848      ! 水平方向の２次元補間。
   849      ! 2D linear interpolation
   850  
   851      use mpi_wrapper, only : myrank
   852  
   853      integer , intent(in ) :: iexmin
   854      integer , intent(in ) :: iexmax
   855      integer , intent(in ) :: jexmin
   856      integer , intent(in ) :: jexmax
   857      real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
   858                                 ! 経度の拡張配列
   859                                 ! Extended array of Lon
   860      real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
   861                                 ! 緯度の拡張配列
   862                                 ! Extended array of Lat
   863      real(DP), intent(in ) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
   864                                 ! 上流点の経度
   865                                 ! Lon at departure point
   866      real(DP), intent(in ) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
   867                                 ! 上流点の緯度
   868                                 ! Lat at departure point
   869      real(DP), intent(in ) :: xyzf_ExtQMixB(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   870                                 ! 物質混合比の拡張配列
   871                                 ! Extended array of mix ration of tracers
   872      real(DP), intent(out) :: xyzf_QMixMinA(     0:imax-1,      1:jmax/2, 1:kmax, 1:ncmax)
   873                                 ! 上流点を囲む 4 格子点の最小値
   874                                 ! Minimum mixing ratio of tracers at 4 grid points
   875                                 ! surrounding a departure point
   876      real(DP), intent(out) :: xyzf_QMixMaxA(     0:imax-1,      1:jmax/2, 1:kmax, 1:ncmax)
   877                                 ! 上流点を囲む 4 格子点の最大値
   878                                 ! Maximum mixing ratio of tracers at 4 grid points
   879                                 ! surrounding a departure point
   880  
   881  
   882      real(DP) :: DeltaLat      ! 緯度グリッド幅; grid width in meridional direction
   883      integer:: i               ! 東西方向に回る DO ループ用作業変数
   884                                ! Work variables for DO loop in zonal direction
   885      integer:: j               ! 南北方向に回る DO ループ用作業変数
   886                                ! Work variables for DO loop in meridional direction
   887      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   888                                ! Work variables for DO loop in vertical direction
   889      integer:: n               ! 組成方向に回る DO ループ用作業変数
   890                                ! Work variables for DO loop in number of composition
   891  
   892      integer:: ii
   893      integer:: jj
   894  
   895      integer :: isten          ! 上流点を囲む4格子点の南西の点の座標番号（東西方向）
   896  	                          ! Youngest index of grid points around the departure point (i-direction)
   897      integer :: jsten          ! 上流点を囲む4格子点の南西の点の座標番号（南北方向）
   898  	                          ! Youngest index of grid points around the departure point (j-direction)
   899      real(DP) :: xy_Z(0:1,0:1)     ! 上流点を囲む 4 格子点上の混合比を格納する作業変数
   900                                    ! Work variable containing mixing ratio at 4 grid points around DP
   901  
   902  
   903  
   904      do k = 1, kmax
   905        do j = 1, jmax/2
   906          do i = 0, imax-1
   907            ! 上流点を囲む4点を探す
   908            ! Determine four grid points around the departure point
   909            isten = int(xyz_DPLon(i,j,k)*InvDeltaLon)
   910            do jj = jexmin, jexmax
   911              if (y_ExtLat(jj) > xyz_DPLat(i, j, k)) then
   912                jsten = jj-1
   913                exit
   914              endif
   915            enddo
   916            !MPIに対応できない↓
   917  !      jsten = int(xyz_DPLat(i,j,k)*in_deltalat) + ns + 1
   918  !      if (y_ExtLat(jsten) > xyz_DPLat(i, j, k)) then
   919  !        jsten = jsten - 1
   920  !      endif
   921  
   922            ! Check indices
   923            if ( ( isten < iexmin ) .or. ( isten > iexmax ) ) then
   924              call MessageNotify( 'E', module_name, &
   925                & 'Departure point is out of range of an extended array for linear interporation ' &
   926                & // 'in longitudinal direction : Rank %d, i = %d.', &
   927                & i = (/ myrank, isten /) )
   928            end if
   929            if ( ( jsten < jexmin ) .or. ( jsten > jexmax ) ) then
   930              call MessageNotify( 'E', module_name, &
   931                & 'Departure point is out of range of an extended array for linear interporation ' &
   932                & // 'in latitudinal direction : Rank %d, j = %d.', &
   933                & i = (/ myrank, jsten /) )
   934            end if
   935  
   936            do n = 1, ncmax
   937  
   938              do jj = 0, 1
   939                do ii = 0, 1
   940                  xy_Z(ii,jj) = xyzf_ExtQMixB(isten+ii,jsten+jj,k,n)
   941                end do
   942              end do
     .           xy_z(0,0) = xyzf_extqmixb(isten,jsten,k,n)                     
     .        xy_z(1,0) = xyzf_extqmixb(isten+1,jsten,k,n)                      
     .        xy_z(0,1) = xyzf_extqmixb(isten,jsten+1,k,n)                      
     .        xy_z(1,1) = xyzf_extqmixb(isten+1,jsten+1,k,n)                    
   943  
   944              xyzf_QMixMinA(i,j,k,n) = min( xy_Z(0,0), xy_Z(1,0), xy_Z(0,1), xy_Z(1,1) )
   945              xyzf_QMixMaxA(i,j,k,n) = max( xy_Z(0,0), xy_Z(1,0), xy_Z(0,1), xy_Z(1,1) )
   946  
   947            end do
   948  
   949          end do
   950        end do
   951      end do
   952  
   953    end subroutine SLTTLagIntHorMaxMin
   954  
   955    !--------------------------------------------------------------------------------------
   956  
   957    subroutine SLTTIrrLinInt(                                      &
   958      & iexmin, iexmax, jexmin, jexmax,                            & ! (in)
   959      & x_ExtLon, y_ExtLat, xyz_DPLon, xyz_DPLat, xyzf_ExtQMixB,   & ! (in)
   960      & xyzf_QMixA                                                 & ! (out)
   961      & )
   962      ! 水平方向の２次元補間。
   963      ! 2D linear interpolation
   964  
   965      use mpi_wrapper, only : myrank
   966  
   967      integer , intent(in ) :: iexmin
   968      integer , intent(in ) :: iexmax
   969      integer , intent(in ) :: jexmin
   970      integer , intent(in ) :: jexmax
   971      real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
   972                                 ! 経度の拡張配列
   973                                 ! Extended array of Lon
   974      real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
   975                                 ! 緯度の拡張配列
   976                                 ! Extended array of Lat
   977      real(DP), intent(in ) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
   978                                 ! 上流点の経度
   979                                 ! Lon at departure point
   980      real(DP), intent(in ) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
   981                                 ! 上流点の緯度
   982                                 ! Lat at departure point
   983      real(DP), intent(in ) :: xyzf_ExtQMixB(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   984                                 ! 物質混合比の拡張配列
   985                                 ! Extended array of mix ration of tracers
   986      real(DP), intent(out) :: xyzf_QMixA (   0:imax-1  ,      1:jmax/2    , 1:kmax, 1:ncmax)
   987                                 ! 次ステップの物質混合比
   988                                 ! Mix ration of tracers at next time-step
   989  
   990  
   991      real(DP) :: DeltaLat      ! 緯度グリッド幅; grid width in meridional direction
   992      integer:: i               ! 東西方向に回る DO ループ用作業変数
   993                                ! Work variables for DO loop in zonal direction
   994      integer:: j               ! 南北方向に回る DO ループ用作業変数
   995                                ! Work variables for DO loop in meridional direction
   996      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   997                                ! Work variables for DO loop in vertical direction
   998      integer:: n               ! 組成方向に回る DO ループ用作業変数
   999                                ! Work variables for DO loop in number of composition
  1000  
  1001      integer:: ii
  1002      integer:: jj
  1003  
  1004      integer :: isten          ! 上流点を囲む4格子点の南西の点の座標番号（東西方向）
  1005  	                          ! Youngest index of grid points around the departure point (i-direction)
  1006      integer :: jsten          ! 上流点を囲む4格子点の南西の点の座標番号（南北方向）
  1007  	                          ! Youngest index of grid points around the departure point (j-direction)
  1008      real(DP) :: xy_Z(0:1,0:1)     ! 上流点を囲む 4 格子点上の混合比を格納する作業変数
  1009                                    ! Work variable containing mixing ratio at 4 grid points around DP
  1010      real(DP) :: y_Z(0:1)          ! 上流点を囲む 2 格子点上の混合比を格納する作業変数
  1011                                    ! Work variable containing mixing ratio at 2 grid points in latitudinal direction
  1012  
  1013  
  1014      do k = 1, kmax
  1015        do j = 1, jmax/2
  1016          do i = 0, imax-1
  1017            ! 上流点を囲む4点を探す
  1018            ! Determine four grid points around the departure point
  1019            isten = int(xyz_DPLon(i,j,k)*InvDeltaLon)
  1020            do jj = jexmin, jexmax
  1021              if (y_ExtLat(jj) > xyz_DPLat(i, j, k)) then
  1022                jsten = jj-1
  1023                exit
  1024              endif
  1025            enddo
  1026            !MPIに対応できない↓
  1027  !      jsten = int(xyz_DPLat(i,j,k)*in_deltalat) + ns + 1
  1028  !      if (y_ExtLat(jsten) > xyz_DPLat(i, j, k)) then
  1029  !        jsten = jsten - 1
  1030  !      endif
  1031  
  1032            ! Check indices
  1033            if ( ( isten < iexmin ) .or. ( isten > iexmax ) ) then
  1034              call MessageNotify( 'E', module_name, &
  1035                & 'Departure point is out of range of an extended array for linear interporation ' &
  1036                & // 'in longitudinal direction : Rank %d, i = %d.', &
  1037                & i = (/ myrank, isten /) )
  1038            end if
  1039            if ( ( jsten < jexmin ) .or. ( jsten > jexmax ) ) then
  1040              call MessageNotify( 'E', module_name, &
  1041                & 'Departure point is out of range of an extended array for linear interporation ' &
  1042                & // 'in latitudinal direction : Rank %d, j = %d.', &
  1043                & i = (/ myrank, jsten /) )
  1044            end if
  1045  
  1046            do n = 1, ncmax
  1047  
  1048              do jj = 0, 1
  1049                do ii = 0, 1
  1050                  xy_Z(ii,jj) = xyzf_ExtQMixB(isten+ii,jsten+jj,k,n)
  1051                end do
  1052              end do
  1053              DeltaLat = y_ExtLat(jsten+1) - y_ExtLat(jsten)
  1054  
  1055              do jj = 0, 1
  1056                y_Z(jj) =   ( xy_Z(1,jj) - xy_Z(0,jj) ) / DeltaLon   &
  1057                  &         * ( xyz_DPLon(i,j,k) - x_ExtLon(isten) ) + xy_Z(0,jj)
  1058              end do
  1059              xyzf_QMixA(i,j,k,n) =   ( y_Z(1) - y_Z(0) ) / DeltaLat           &
  1060                &                     * ( xyz_DPLat(i,j,k) - y_ExtLat(jsten) ) &
  1061                &                   + y_Z(0)
  1062  
  1063            end do
     .        deltalat = y_extlat(jsten+1) - y_extlat(jsten)                    
     .        d7 = 1.D0/deltalon                                                
     .        d8 = 1.D0/deltalon                                                
     .        d9 = 1.D0/deltalat                                                
     .  !cdir nodep                                                             
     .        do n = 1, ncmax                                                   
     .           xy_z1 = xyzf_extqmixb(isten,jsten,k,n)                         
     .           xy_z2 = xyzf_extqmixb(isten+1,jsten,k,n)                       
     .           xy_z3 = xyzf_extqmixb(isten,jsten+1,k,n)                       
     .           xy_z4 = xyzf_extqmixb(isten+1,jsten+1,k,n)                     
     .           y_z5=(xy_z2-xy_z1)*d7*(xyz_dplon(i,j,k)-x_extlon(isten))+xy_z1 
     .           y_z6=(xy_z4-xy_z3)*d8*(xyz_dplon(i,j,k)-x_extlon(isten))+xy_z3 
     .           xyzf_qmixa(i,j,k,n) = (y_z6 - y_z5)*d9*(xyz_dplat(i,j,k)-      
     .       1      y_extlat(jsten)) + y_z5                                     
     .        enddo                                                             
  1064  
  1065          end do
  1066        end do
  1067      end do
  1068  
  1069    end subroutine SLTTIrrLinInt
  1070  
  1071    !--------------------------------------------------------------------------------------
  1072  
  1073    subroutine SLTTIrrHerIntK13(              &
  1074     & iexmin, iexmax, jexmin, jexmax,                            & ! (in)
  1075     & x_ExtLon, y_ExtLat, xyz_DPLon, xyz_DPLat, xyz_ExtQMixB,    & ! (in)
  1076     & xyz_ExtQMixB_dlon, xyz_ExtQMixB_dlat, xyz_ExtQMixB_dlonlat,& ! (in)
  1077  !    & xyz_ExtQMixB_dlon2, xyz_ExtQMixB_dlat2,        & ! (in) fxx, fyy
  1078  !    & xyz_ExtQMixB_dlon2lat, xyz_ExtQMixB_dlonlat2,  & ! (in) fxxy, fxyy
  1079  !    & xyz_ExtQMixB_dlon2lat2,                                  & ! (in) fxxyy       	
  1080     & SLTTIntHor,                                                        & ! (in)
  1081     & xyz_QMixA        & ! (out)
  1082     & )
  1083      ! 水平方向の２次元補間。Enomoto (2008, SOLA)で提案された「スペクトルで計算した微分値を用いた双３次補間」を
  1084      ! 発展させた方法、スペクトル微分を用いた変則エルミート５次補間を方向分離して行う。５次補間のたびに Sun et al. (1996, MWR)
  1085      ! の単調フィルタを修正したものを適用する。
  1086      ! 2D Interpolation. Spectral transformation is used for calculation of derivatives, which are used
  1087      ! for Irregular Hermite quintic interpolation. The original idea of using Spectral transformation for derivatives
  1088      ! is presented by Enomoto (2008, SOLA).
  1089      ! Monotonicity filter presented by Sun et al. (1996, MWR) is partly modified and used after each interpolation.
  1090  
  1091      use sltt_const , only : PIx2
  1092      use mpi_wrapper, only : myrank
  1093      use gridset, only: lmax    ! スペクトルデータの配列サイズ
  1094                                 ! Size of array for spectral data
  1095  
  1096      integer , intent(in ) :: iexmin
  1097      integer , intent(in ) :: iexmax
  1098      integer , intent(in ) :: jexmin
  1099      integer , intent(in ) :: jexmax
  1100      real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
  1101                                 ! 経度の拡張配列
  1102                                 ! Extended array of Lon
  1103      real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
  1104                                 ! 緯度の拡張配列
  1105                                 ! Extended array of Lat
  1106      real(DP), intent(in ) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
  1107                                 ! 上流点の経度
  1108                                 ! Lon at departure point
  1109      real(DP), intent(in ) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
  1110                                 ! 上流点の緯度
  1111                                 ! Lat at departure point
  1112      real(DP), intent(in ) :: xyz_ExtQMixB(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1113                                 ! 物質混合比の拡張配列
  1114                                 ! Extended array of mix ration of tracers
  1115      real(DP), intent(in) :: xyz_ExtQMixB_dlon(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1116                                 ! 物質混合比の経度微分の拡張配列
  1117                                 ! Extended array of zonal derivative of the mix ration
  1118      real(DP), intent(in) :: xyz_ExtQMixB_dlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1119                                 ! 物質混合比の緯度微分の拡張配列
  1120                                 ! Extended array of meridional derivative of the mix ration
  1121      real(DP), intent(in) :: xyz_ExtQMixB_dlonlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1122                                 ! 物質混合比の緯度経度微分の拡張配列
  1123                                 ! Extended array of zonal and meridional derivative of the mix ration
  1124      character(TOKEN), intent(in):: SLTTIntHor
  1125                                 ! 水平方向の補間方法を指定するキーワード
  1126                                 ! Keyword for Interpolation Method for Horizontal direction
  1127      real(DP), intent(out) :: xyz_QMixA (   0:imax-1  ,      1:jmax/2    , 1:kmax, 1:ncmax)
  1128                                 ! 次ステップの物質混合比
  1129                                 ! Mix ration of tracers at next time-step
  1130  
  1131  !---fxx, fyy, fxxy, fxyy, fxxyy
  1132  !    real(DP), intent(inout) :: xyz_ExtQMixB_dlon2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)
  1133  !    real(DP), intent(inout) :: xyz_ExtQMixB_dlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)
  1134  !    real(DP), intent(inout) :: xyz_ExtQMixB_dlon2lat(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)
  1135  !    real(DP), intent(inout) :: xyz_ExtQMixB_dlonlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)
  1136  !    real(DP), intent(inout) :: xyz_ExtQMixB_dlon2lat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)
  1137  
  1138  
  1139  
  1140      real(DP) :: DeltaLat      ! 緯度グリッド幅; grid width in meridional direction
  1141      integer:: i, ii           ! 東西方向に回る DO ループ用作業変数
  1142                                ! Work variables for DO loop in zonal direction
  1143      integer:: j, jj           ! 南北方向に回る DO ループ用作業変数
  1144                                ! Work variables for DO loop in meridional direction
  1145      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1146                                ! Work variables for DO loop in vertical direction
  1147      integer:: n               ! 組成方向に回る DO ループ用作業変数
  1148                                ! Work variables for DO loop in number of composition
  1149  
  1150      integer :: isten          ! 上流点を囲む4格子点の南西の点の座標番号（東西方向）
  1151  	                          ! Youngest index of grid points around the departure point (i-direction)
  1152      integer :: jsten          ! 上流点を囲む4格子点の南西の点の座標番号（南北方向）
  1153  	                          ! Youngest index of grid points around the departure point (j-direction)
  1154      integer  :: num           ! 配列配置のための作業変数
  1155  	                          ! Work variable for array packing
  1156      real(DP) :: a_z(16)       ! 上流点を囲む16格子点上の混合比を格納する作業変数
  1157                                ! Work variable containing mixing ratio at 16 grid points around DP
  1158      real(DP) :: a_zx(16)      ! 上流点を囲む16格子点上の混合比の経度微分を格納する作業変数
  1159                                ! Work variable containing zonal derivative of mixing ratio at 16 grid points around DP
  1160      real(DP) :: a_zy(16)      ! 上流点を囲む16格子点上の混合比の緯度微分を格納する作業変数
  1161                                ! Work variable containing meridional derivative of mixing ratio at 16 grid points around DP
  1162      real(DP) :: a_zxy(16)     ! 上流点を囲む16格子点上の混合比の緯度経度微分を格納する作業変数
  1163                                ! Work variable containing zonal and meridional derivative of mixing ratio at 16 grid points around DP
  1164  !    real(DP):: a_zxx(16), a_zyy(16), a_zxxy(16), a_zxyy(16), a_zxxyy(16)
  1165  
  1166  
  1167      ! Check whether a longitude of departure point is within an extended array
  1168      call SLTTLagIntChkDPLon(       &
  1169        & SLTTIntHor,                      & ! (in)
  1170        & iexmin, iexmax, jexmin, jexmax,  & ! (in)
  1171        & x_ExtLon, xyz_DPLon              & ! (in)
  1172        & )
  1173      ! Check whether a latitude of departure point is within an extended array
  1174      call SLTTLagIntChkDPLat(             &
  1175        & SLTTIntHor,                      & ! (in)
  1176        & iexmin, iexmax, jexmin, jexmax,  & ! (in)
  1177        & y_ExtLat, xyz_DPLat              & ! (in)
  1178        & )
  1179  
  1180  
  1181   do k = 1, kmax
  1182     do j = 1, jmax/2
  1183       do i = 0, imax-1
  1184         ! 上流点を囲む4点を探す
  1185         ! Determine four grid points around the departure point
  1186         isten = int(xyz_DPLon(i,j,k)*InvDeltaLon)
  1187         do jj = jexmin, jexmax
  1188           if (y_ExtLat(jj) > xyz_DPLat(i, j, k)) then
  1189             jsten = jj-1
  1190             exit
  1191           endif
  1192         enddo
  1193        !MPIに対応できない↓
  1194  !      jsten = int(xyz_DPLat(i,j,k)*in_deltalat) + ns + 1
  1195  !      if (y_ExtLat(jsten) > xyz_DPLat(i, j, k)) then
  1196  !        jsten = jsten - 1
  1197  !      endif
  1198  
  1199  
  1200          ! 水平方向の補間方法の選択
  1201          select case (SLTTIntHor)
  1202  
  1203          case ("HQ") ! 方向分離型2次元変則エルミート5次補間;  2D Hermite quintic interpolation
  1204            do n = 1, ncmax
  1205              ! ２次元補間のための配列配置（ワイド）
  1206              ! Array packing for 2D interpolation
  1207              do jj = -1, 2
  1208                num = (jj+1)*4 + 2
  1209                do ii = -1, 2
  1210                  a_z(ii+num) = xyz_ExtQMixB(isten+ii, jsten+jj, k, n)
  1211                  a_zx(ii+num) = xyz_ExtQMixB_dlon(isten+ii, jsten+jj, k, n)
  1212                  a_zy(ii+num) = xyz_ExtQMixB_dlat(isten+ii, jsten+jj, k, n)
  1213                  a_zxy(ii+num) = xyz_ExtQMixB_dlonlat(isten+ii, jsten+jj, k, n)
  1214                enddo
     .        a_z(num-1) = xyz_extqmixb(isten-1,jsten+jj,k,n)                   
     .        a_zx(num-1) = xyz_extqmixb_dlon(isten-1,jsten+jj,k,n)             
     .        a_zy(num-1) = xyz_extqmixb_dlat(isten-1,jsten+jj,k,n)             
     .        a_zxy(num-1) = xyz_extqmixb_dlonlat(isten-1,jsten+jj,k,n)         
     .        a_z(num) = xyz_extqmixb(isten,jsten+jj,k,n)                       
     .        a_zx(num) = xyz_extqmixb_dlon(isten,jsten+jj,k,n)                 
     .        a_zy(num) = xyz_extqmixb_dlat(isten,jsten+jj,k,n)                 
     .        a_zxy(num) = xyz_extqmixb_dlonlat(isten,jsten+jj,k,n)             
     .        a_z(1+num) = xyz_extqmixb(isten+1,jsten+jj,k,n)                   
     .        a_zx(1+num) = xyz_extqmixb_dlon(isten+1,jsten+jj,k,n)             
     .        a_zy(1+num) = xyz_extqmixb_dlat(isten+1,jsten+jj,k,n)             
     .        a_zxy(1+num) = xyz_extqmixb_dlonlat(isten+1,jsten+jj,k,n)         
     .        a_z(2+num) = xyz_extqmixb(isten+2,jsten+jj,k,n)                   
     .        a_zx(2+num) = xyz_extqmixb_dlon(isten+2,jsten+jj,k,n)             
     .        a_zy(2+num) = xyz_extqmixb_dlat(isten+2,jsten+jj,k,n)             
     .        a_zxy(2+num) = xyz_extqmixb_dlonlat(isten+2,jsten+jj,k,n)         
  1215              enddo
  1216  
  1217              ! 方向分離型2次元変則エルミート5次補間
  1218              ! 2D Hermite quintic interpolation
  1219              xyz_QMixA(i,j,k,n) = SLTTIrrHerIntQui2DHor(a_z, a_zx, a_zy, a_zxy, &
  1220                & y_ExtLat(jsten-1)-y_ExtLat(jsten), y_ExtLat(jsten+1)-y_ExtLat(jsten), y_ExtLat(jsten+2)-y_ExtLat(jsten),&
  1221                &   xyz_DPLon(i, j, k)-x_ExtLon(isten),  xyz_DPLat(i, j, k)-y_ExtLat(jsten) )
  1222            enddo
  1223  
  1224  
  1225          case("HC") !方向分離型2次元エルミート３次補間; 2D Hermite Cubic Interpolation
  1226            do n = 1, ncmax
  1227            ! ２次元補間のための配列配置
  1228            !    4           3
  1229            !         x
  1230            !    1           2
  1231              a_z(1) = xyz_ExtQMixB(isten, jsten, k, n)
  1232              a_zx(1) = xyz_ExtQMixB_dlon(isten, jsten, k, n)
  1233              a_zy(1) = xyz_ExtQMixB_dlat(isten, jsten, k, n)
  1234              a_zxy(1) = xyz_ExtQMixB_dlonlat(isten, jsten, k, n)
  1235  !               a_zxx(1) = xyz_ExtQMixB_dlon2(isten, jsten, k, n)
  1236  !               a_zyy(1) = xyz_ExtQMixB_dlat2(isten, jsten, k, n)
  1237  !               a_zxxy(1) = xyz_ExtQMixB_dlon2lat(isten, jsten, k, n)
  1238  !               a_zxyy(1) = xyz_ExtQMixB_dlonlat2(isten, jsten, k, n)
  1239  !               a_zxxyy(1) = xyz_ExtQMixB_dlon2lat2(isten, jsten, k, n)
  1240  
  1241              a_z(2) = xyz_ExtQMixB(isten+1, jsten, k, n)
  1242              a_zx(2) = xyz_ExtQMixB_dlon(isten+1, jsten, k, n)
  1243              a_zy(2) = xyz_ExtQMixB_dlat(isten+1, jsten, k, n)
  1244              a_zxy(2) = xyz_ExtQMixB_dlonlat(isten+1, jsten, k, n)
  1245  !               a_zxx(2) = xyz_ExtQMixB_dlon2(isten+1, jsten, k, n)
  1246  !               a_zyy(2) = xyz_ExtQMixB_dlat2(isten+1, jsten, k, n)
  1247  !               a_zxxy(2) = xyz_ExtQMixB_dlon2lat(isten+1, jsten, k, n)
  1248  !               a_zxyy(2) = xyz_ExtQMixB_dlonlat2(isten+1, jsten, k, n)
  1249  !               a_zxxyy(2) = xyz_ExtQMixB_dlon2lat2(isten+1, jsten, k, n)
  1250  
  1251              a_z(3) = xyz_ExtQMixB(isten+1, jsten+1, k, n)
  1252              a_zx(3) = xyz_ExtQMixB_dlon(isten+1, jsten+1, k, n)
  1253              a_zy(3) = xyz_ExtQMixB_dlat(isten+1, jsten+1, k, n)
  1254              a_zxy(3) = xyz_ExtQMixB_dlonlat(isten+1, jsten+1, k, n)
  1255  !               a_zxx(3) = xyz_ExtQMixB_dlon2(isten+1, jsten+1, k, n)
  1256  !               a_zyy(3) = xyz_ExtQMixB_dlat2(isten+1, jsten+1, k, n)
  1257  !               a_zxxy(3) = xyz_ExtQMixB_dlon2lat(isten+1, jsten+1, k, n)
  1258  !               a_zxyy(3) = xyz_ExtQMixB_dlonlat2(isten+1, jsten+1, k, n)
  1259  !               a_zxxyy(3) = xyz_ExtQMixB_dlon2lat2(isten+1, jsten+1, k, n)
  1260  
  1261              a_z(4) = xyz_ExtQMixB(isten, jsten+1, k, n)
  1262              a_zx(4) = xyz_ExtQMixB_dlon(isten, jsten+1, k, n)
  1263              a_zy(4) = xyz_ExtQMixB_dlat(isten, jsten+1, k, n)
  1264              a_zxy(4) = xyz_ExtQMixB_dlonlat(isten, jsten+1, k, n)
  1265  !               a_zxx(4) = xyz_ExtQMixB_dlon2(isten, jsten+1, k, n)
  1266  !               a_zyy(4) = xyz_ExtQMixB_dlat2(isten, jsten+1, k, n)
  1267  !               a_zxxy(4) = xyz_ExtQMixB_dlon2lat(isten, jsten+1, k, n)
  1268  !               a_zxyy(4) = xyz_ExtQMixB_dlonlat2(isten, jsten+1, k, n)
  1269  !               a_zxxyy(4) = xyz_ExtQMixB_dlon2lat2(isten, jsten+1, k, n)
  1270  
  1271              DeltaLat = y_ExtLat(jsten+1) - y_ExtLat(jsten)
  1272  
  1273              !方向分離型2次元エルミート３次補間
  1274              xyz_QMixA(i,j,k,n) = SLTTHerIntCub2D(a_z(1:4), a_zx(1:4), a_zy(1:5), a_zxy(1:4), DeltaLon, DeltaLat,&
  1275                                  &  xyz_DPLon(i, j, k)-x_ExtLon(isten), xyz_DPLat(i, j, k)-y_ExtLat(jsten) )
  1276  
  1277  !方向分離型2次元エルミート5次補間
  1278  !    	xyz_QMixA(i,j,k) = hqint2D(a_z, a_zx, a_zy, a_zxy, a_zxx, a_zyy, a_zxxy, a_zxyy, a_zxxyy, deltalon, deltalat, &
  1279  !		&   xyz_DPLon(i, j, k)-x_ExtLon(isten),  xyz_DPLat(i, j, k)-y_ExtLat(jsten) )
  1280           enddo
  1281  
  1282          case DEFAULT
  1283            call MessageNotify( 'E', module_name, &
  1284              & 'GIVE CORRECT KEYWORD FOR <SLTTIntHor> IN NAMELIST.' )
  1285        end select
  1286  
  1287  
  1288  
  1289      enddo
  1290    enddo
  1291  enddo
  1292  
  1293  end subroutine SLTTIrrHerIntK13
  1294  
  1295  
  1296    function SLTTHerIntCub2D(f, fx, fy, fxy, dx, dy, Xix, Xiy) result (fout)
  1297      !２次元エルミート３次補間
  1298      ! 2D Hermite Cubic Interpolation
  1299      !    4----b------3
  1300      !         |
  1301      !         X
  1302      !         |
  1303      !    1----a------2
  1304      ! Xix:点1と点aとの間隔、Xiy:点aと点Xとの間隔
  1305      ! Xix:distance between 1 and a, Xiy:distance between a and X
  1306  
  1307      implicit none
  1308      real(DP), dimension(4), intent(in) :: f, fx, fy, fxy
  1309      real(DP), intent(in) :: dx, dy, Xix, Xiy
  1310      real(DP) :: fout
  1311  
  1312      !------Internal variables-------
  1313      real(DP) :: fa, fb, fya, fyb
  1314  
  1315  
  1316      ! 点1と点2から点aでの値を求める
  1317      ! interpolate a from 1 and 2
  1318      fa = SLTTHerIntCub1D(f(1), f(2), fx(1), fx(2), dx, Xix)
  1319      fya = SLTTHerIntCub1D(fy(1), fy(2), fxy(1), fxy(2), dx, Xix)
  1320  
  1321      ! 点4と点3から点bでの値を求める
  1322      ! interpolate b from 4 and 3
  1323      fb = SLTTHerIntCub1D(f(4), f(3), fx(4), fx(3), dx, Xix)
  1324      fyb = SLTTHerIntCub1D(fy(4), fy(3), fxy(4), fxy(3), dx, Xix)
  1325  
  1326      ! 点aと点bから点Xをでの値を求める
  1327      ! interpolate X from a and b
  1328      fout = SLTTHerIntCub1D(fa, fb, fya, fyb, dy, Xiy)
  1329  
  1330    end function SLTTHerIntCub2D
  1331  
  1332  
  1333    function SLTTHerIntCub1D(f1, f2, g1, g2, dx, Xi) result (fout)
  1334      !エルミート３次補間
  1335      ! 1D Hermite Cubic Interpolation
  1336      !    1-----x------2
  1337      ! f:関数値、g:微分値、dx:点１と点２の間隔、Xi:点１と補間する点xとの間隔
  1338      ! f:function value, g:derivative, dx:distance between 1 and 2, Xi:distance between 1 and x
  1339      implicit none
  1340      real(DP), intent(in) :: f1, f2, g1, g2
  1341      real(DP), intent(in) :: dx, Xi
  1342      real(DP) :: fout
  1343      !------Internal variables-------
  1344      real(DP):: a, b
  1345      real(DP):: indx
  1346  
  1347      indx = 1.0_DP/dx
  1348  
  1349      a = (g1 + g2)*indx*indx + 2.0_DP*(f1 - f2)*indx*indx*indx
  1350      b = 3.0_DP*(f2 - f1)*indx*indx - (2.0_DP*g1 + g2)*indx
  1351      fout = a*Xi*Xi*Xi + b*Xi*Xi + g1*Xi + f1
  1352  
  1353    end function SLTTHerIntCub1D
  1354  
  1355  
  1356  
  1357  !function centdif4(f,x) result (g3out)
  1358  !! 不等間隔格子での4次精度の中心差分。
  1359  !! 関数値 f1, f2, f3, f4, f5 から 点3の x微分 g3 をもとめる。
  1360  !real(DP), intent(in) :: f(5), x(5)
  1361  !real(DP) :: g3out
  1362  !
  1363  !!---内部変数---
  1364  !real(DP) :: s1, s2, t1, t2, gtmp1, gtmp2
  1365  !
  1366  !s1 = x(3) - x(2)
  1367  !t1 = x(4) - x(3)
  1368  !s2 = x(3) - x(1)
  1369  !t2 = x(5) - x(3)
  1370  !!準備｜不等間隔格子での2次精度中心差分(http://ruby.gfd-dennou.org/products/numru-derivative/derivative/doc/document.pdf)
  1371  !gtmp1 = (s1*s1*f(4) + (t1*t1 - s1*s1)*f(3) - t1*t1*f(2))/(s1*t1*(s1 + t1))
  1372  !gtmp2 = (s2*s2*f(5) + (t2*t2 - s2*s2)*f(3) - t2*t2*f(1))/(s2*t2*(s2 + t2))
  1373  !
  1374  !if (gtmp1 == 0.0) then !2次精度中心差分で傾きゼロの点は、そのまま出力する
  1375  !g3out = 0.0_DP
  1376  !else
  1377  !g3out = (gtmp1*s2*t2 - gtmp2*s1*t1)/(s2*t2 - s1*t1)
  1378  !endif
  1379  !
  1380  !end function centdif4
  1381  
  1382  
  1383  !  function hqint2D(f, fx, fy, fxy, fxx, fyy, fxxy, fxyy, fxxyy, dx, dy, Xix, Xiy) result (fout)
  1384  !!２次元エルミート５次補間（２階微分使用）
  1385  !! 2D Hermite Quintic Interpolation (using 2nd derivatives)
  1386  !!    4----b------3
  1387  !!         |
  1388  !!         X
  1389  !!         |
  1390  !!    1----a------2
  1391  !! Xix:点1と点aとの間隔、Xiy:点aと点Xとの間隔
  1392  !! Xix:distance between 1 and a, Xiy:distance between a and X
  1393  !
  1394  !    implicit none
  1395  !    real(DP), dimension(4), intent(in) :: f, fx, fy, fxy, fxx, fyy, fxxy, fxyy, fxxyy
  1396  !    real(DP), intent(in) :: dx, dy, Xix, Xiy
  1397  !    real(DP) :: fout
  1398  !!------interlan variables-------
  1399  !    real(DP) :: fa, fb, fya, fyb, fyya, fyyb
  1400  !
  1401  !
  1402  !! 点1と点2から点aでの値を求める
  1403  !! interpolate a from 1 and 2
  1404  !fa = SLTTHerIntQui1D(f(1), f(2), fx(1), fx(2), fxx(1), fxx(2), dx, Xix)
  1405  !fya = SLTTHerIntQui1D(fy(1), fy(2), fxy(1), fxy(2), fxxy(1), fxxy(2), dx, Xix)
  1406  !fyya = SLTTHerIntQui1D(fyy(1), fyy(2), fxyy(1), fxyy(2), fxxyy(1), fxxyy(2), dx, Xix)
  1407  !
  1408  !
  1409  !! 点4と点3から点bでの値を求める
  1410  !! interpolate b from 4 and 3
  1411  !fb = SLTTHerIntQui1D(f(4), f(3), fx(4), fx(3), fxx(4), fxx(3), dx, Xix)
  1412  !fyb = SLTTHerIntQui1D(fy(4), fy(3), fxy(4), fxy(3), fxxy(4), fxxy(3), dx, Xix)
  1413  !fyyb = SLTTHerIntQui1D(fyy(4), fyy(3), fxyy(4), fxyy(3), fxxyy(4), fxxyy(3), dx, Xix)
  1414  !
  1415  !! 点aと点bから点Xをでの値を求める
  1416  !! interpolate X from a and b
  1417  !fout = SLTTHerIntQui1D(fa, fb, fya, fyb, fyya, fyyb, dy, Xiy)
  1418  !
  1419  !    end function hqint2D
  1420  
  1421  
  1422  
  1423    function SLTTIrrHerIntQui2DHor(f, fx, fy, fxy, dy21, dy23, dy24, Xix, Xiy) result (fout)
  1424      ! ２次元変則エルミート５次補間（２階微分不使用）
  1425      ! 2D Hermite Quintic Interpolation (without 2nd derivatives)
  1426      !
  1427      ! 13-14-d-15--16
  1428      ! |   | | |   |
  1429      ! 9--10-c-11--12
  1430      ! |   | x |   |
  1431      ! 5---6-b-7---8
  1432      ! |   | | |   |
  1433      ! 1---2-a-3---4
  1434      !
  1435      ! Xix:点6と点aとの間隔、Xiy:点aと点Xとの間隔
  1436      ! dy21=lat(5)-lat(1), dy23=lat(5)-lat(9), dy24=lat(5)-lat(13)
  1437      ! Xix:distance between 6 and a, Xiy:distance between b and x
  1438      ! dy21=lat(5)-lat(1), dy23=lat(5)-lat(9), dy24=lat(5)-lat(13)
  1439  
  1440      implicit none
  1441      real(DP), dimension(16), intent(in) :: f, fx, fy, fxy
  1442      real(DP), intent(in) :: dy21, dy23, dy24, Xix, Xiy
  1443      real(DP) :: fout
  1444      !------internal variables-------
  1445      real(DP) :: fa, fb, fc, fd, fyb, fyc, fya, fyd, lmin, lmax
  1446  
  1447      ! 点1-4から点aでの値を求める
  1448      ! interpolate a from points 1-4
  1449      fa = SLTTIrrHerIntQui1DUniLon(f(1), f(2), f(3), f(4), fx(2), fx(3),  Xix)
  1450  
  1451      ! 点5-8から点bでの値を求める
  1452      ! interpolate b from points 5-8
  1453      fb = SLTTIrrHerIntQui1DUniLon(f(5), f(6), f(7), f(8), fx(6), fx(7),  Xix)
  1454      fyb = SLTTIrrHerIntQui1DUniLon(fy(5), fy(6), fy(7), fy(8), fxy(6), fxy(7),  Xix)
  1455  
  1456      ! 点9-12から点cでの値を求める
  1457      ! interpolate c from points 9-12
  1458      fc = SLTTIrrHerIntQui1DUniLon(f(9), f(10), f(11), f(12), fx(10), fx(11),  Xix)
  1459      fyc = SLTTIrrHerIntQui1DUniLon(fy(9), fy(10), fy(11), fy(12), fxy(10), fxy(11),  Xix)
  1460  
  1461      ! 点13-16から点dでの値を求める
  1462      ! interpolate d from points 13-16
  1463      fd = SLTTIrrHerIntQui1DUniLon(f(13), f(14), f(15), f(16), fx(14), fx(15),  Xix)
  1464  
  1465      ! 点a-dから点Xをでの値を求める
  1466      ! interpolate X from points a-d
  1467      fout = SLTTIrrHerIntQui1DNonUni(fa, fb, fc, fd, fyb, fyc, dy21, dy23, dy24, Xiy)
  1468      !等間隔格子に近似しても、精度はほとんど落ちない。計算は軽くなる。
  1469      !fout = SLTTIrrHerIntQui1DUni(fa, fb, fc, fd, fyb, fyc, dy23, Xiy)
  1470  
  1471    end function SLTTIrrHerIntQui2DHor
  1472  
  1473  
  1474  
  1475  !  function SLTTHerIntQui1D(f1, f2, g1, g2, h1, h2, dx, Xi) result (fout)
  1476  !! エルミート５次補間（２階微分使用）
  1477  !! 1D Hermite Quintic Interpolation (using 2nd derivatives)
  1478  !!    1-----x------2
  1479  !! f:関数値、g:微分値、h:2階微分、dx:点１と点２の間隔、Xi:点１と補間する点xとの間隔
  1480  !! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0 で補間する
  1481  !! f:function value, g:derivative, h:2nd derivative,
  1482  !! dx:distance between 1 and 2, Xi:distance between 1 and x
  1483  !! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0
  1484  !
  1485  !    implicit none
  1486  !    real(DP), intent(in) :: f1, f2, g1, g2, h1, h2
  1487  !    real(DP), intent(in) :: dx, Xi
  1488  !    real(DP) :: fout
  1489  !!------内部変数-------
  1490  !    real(DP):: a(0:5)
  1491  !    real(DP):: indx
  1492  !
  1493  !indx = 1.0_DP/dx
  1494  !
  1495  !a(0) = f1
  1496  !a(1) = g1
  1497  !a(2) = 0.5_DP*h1
  1498  !a(3) = 10.0_DP*(-f1+f2)*indx*indx*indx + (-6.0_DP*g1-4.0_DP*g2)*indx*indx + (-1.5_DP*h1+0.5_DP*h2)*indx
  1499  !a(4) = 15.0_DP*(f1-f2)*indx*indx*indx*indx + (8.0_DP*g1+7.0_DP*g2)*indx*indx*indx + (1.5_DP*h1-h2)*indx*indx
  1500  !a(5) = 6.0_DP*(-f1+f2)*indx*indx*indx*indx*indx + 3.0_DP*(-g1-g2)*indx*indx*indx*indx + 0.5_DP*(-h1+h2)*indx*indx*indx
  1501  !
  1502  !fout = a(5)*Xi*Xi*Xi*Xi*Xi + a(4)*Xi*Xi*Xi*Xi + a(3)*Xi*Xi*Xi + a(2)*Xi*Xi + a(1)*Xi + a(0)
  1503  !
  1504  !    end function SLTTHerIntQui1D
  1505  
  1506  
  1507  
  1508    function SLTTIrrHerIntQui1DUni(f1, f2, f3, f4, g2, g3, dx, Xi) result (fout)
  1509      ! 変則エルミート５次補間（２階微分不使用）
  1510      ! 1D Hermite Quintic Interpolation (without 2nd derivatives)
  1511      ! 等間隔格子の場合
  1512      ! equal separation
  1513      !    1---2--x-3---4
  1514      ! f:関数値、g:微分値、、dx:点の間隔、Xi:点２と補間する点xとの間隔
  1515      ! f:function value, g:derivative,
  1516      ! dx:equal separation of each point, Xi:distance between 2 and x
  1517      ! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0
  1518      ! f1 = f(-X), f2 = f(0), f3 = f(X), f4 = f(2X)
  1519  
  1520      implicit none
  1521      real(DP), intent(in) :: f1, f2, f3, f4, g2, g3
  1522      real(DP), intent(in) :: dx, Xi
  1523      real(DP) :: fout
  1524      !------internal variables-------
  1525      real(DP):: a(0:5)
  1526      real(DP):: indx
  1527  
  1528      indx = 1.0_DP/dx
  1529  
  1530      a(0) = f2
  1531      a(1) = g2
  1532      a(5) = (0.75_DP*f3 - (f1 - f4)/12.0_DP -0.5_DP*( g3 + a(1))*dx -0.75_DP*a(0))*indx**5
  1533      a(3) = -a(5)*dx*dx - a(1)*indx*indx + (f3 - f1)*0.5_DP*indx**3
  1534      a(4) = ( (g3 + a(1))*0.5_DP*dx - f3 +a(0) )*indx**4 - 1.5_DP*a(5)*dx - 0.5_DP*a(3)*indx
  1535      a(2) = ( (f3 + f1)*0.5_DP -a(0))*indx*indx -a(4)*dx*dx
  1536  
  1537      !fout = a(5)*Xi*Xi*Xi*Xi*Xi + a(4)*Xi*Xi*Xi*Xi &
  1538      !&    + a(3)*Xi*Xi*Xi + a(2)*Xi*Xi + a(1)*Xi + a(0)
  1539      fout =   (((((a(5)*Xi + a(4))*Xi+ a(3))*Xi)+ a(2))*Xi + a(1))*Xi + a(0)
  1540  
  1541  
  1542      ! Monotonic filter
  1543  
  1544      ! Do nothing
  1545  
  1546  
  1547    end function SLTTIrrHerIntQui1DUni
  1548  
  1549    function SLTTIrrHerIntQui1DUniLon(f1, f2, f3, f4, g2, g3, Xi) result (fout)
  1550      ! 変則エルミート５次補間（２階微分不使用）
  1551      ! 1D Hermite Quintic Interpolation (without 2nd derivatives)
  1552      ! 経度方向（等間隔）専用
  1553      ! equal separation
  1554      !    1---2--x-3---4
  1555      ! f:関数値、g:微分値、、dx:点の間隔、Xi:点２と補間する点xとの間隔
  1556      ! f:function value, g:derivative,
  1557      ! dx:equal separation of each point, Xi:distance between 2 and x
  1558      ! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0
  1559      ! f1 = f(-X), f2 = f(0), f3 = f(X), f4 = f(2X)
  1560  
  1561      implicit none
  1562      real(DP), intent(in) :: f1, f2, f3, f4, g2, g3
  1563      real(DP), intent(in) :: Xi
  1564      real(DP) :: fout
  1565      !------internal variables-------
  1566      real(DP):: a(0:5)
  1567  
  1568  
  1569      a(0) = f2
  1570      a(1) = g2
  1571      a(5) = (0.75_DP*f3 - (f1 - f4)/12.0_DP -0.5_DP*( g3 + a(1))*DeltaLon -0.75_DP*a(0))*InvDeltaLon**5
  1572      a(3) = -a(5)*DeltaLon*DeltaLon - a(1)*InvDeltaLon*InvDeltaLon + (f3 - f1)*0.5_DP*InvDeltaLon**3
  1573      a(4) = ( (g3 + a(1))*0.5_DP*DeltaLon - f3 +a(0) )*InvDeltaLon**4 - 1.5_DP*a(5)*DeltaLon - 0.5_DP*a(3)*InvDeltaLon
  1574      a(2) = ( (f3 + f1)*0.5_DP -a(0))*InvDeltaLon*InvDeltaLon -a(4)*DeltaLon*DeltaLon
  1575  
  1576      !fout = a(5)*Xi*Xi*Xi*Xi*Xi + a(4)*Xi*Xi*Xi*Xi &
  1577      !&    + a(3)*Xi*Xi*Xi + a(2)*Xi*Xi + a(1)*Xi + a(0)
  1578      fout =   (((((a(5)*Xi + a(4))*Xi+ a(3))*Xi)+ a(2))*Xi + a(1))*Xi + a(0)
  1579  
  1580  
  1581      ! Monotonic filter
  1582  
  1583      ! Do nothing
  1584  
  1585  
  1586    end function SLTTIrrHerIntQui1DUniLon
  1587  
  1588  
  1589  
  1590    function SLTTIrrHerIntQui1DNonUni(f1, f2, f3, f4, g2, g3, dx21, dx23, dx24, Xi) result (fout)
  1591      ! 変則エルミート５次補間（２階微分不使用）
  1592      ! 1D Hermite Quintic Interpolation
  1593      ! 不等間隔格子の場合
  1594      ! non-equal separation
  1595      !    1---2--x-3---4
  1596      ! f:関数値、g:微分値、、dx:点の間隔、Xi:点２と補間する点xとの間隔
  1597      ! f:function value, g:derivative
  1598      ! dx21: lon(1)-lon(2), dx23: lon(3)-lon(2), dx24: lon(4)-lon(2),
  1599      ! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0
  1600      ! f1 = f(dx21), f2 = f(0), f3 = f(dx23), f4 = f(dx24)
  1601  
  1602      implicit none
  1603      real(8), intent(in) :: f1, f2, f3, f4, g2, g3
  1604      real(8), intent(in) :: dx21, dx23, dx24, Xi
  1605      real(8) :: fout, r, t
  1606      !------Internal variables-------
  1607      real(8):: a(0:5)
  1608      real(8):: indx
  1609      real(8):: Y1, Y3, Y4, Z3, Xi2
  1610      integer :: n
  1611  
  1612      ! 計算効率化のため、dx21, dx23, dx24 を dx23 で正規化する。
  1613      ! このとき、1階微分値は × dx23 する必要がある。
  1614      r = dx21/dx23
  1615      t = dx24/dx23
  1616  
  1617      a(0) = f2
  1618      a(1) = g2*dx23
  1619  
  1620      Y1 = f1 - a(0) -a(1)*r
  1621      Y3 = f3 - a(0) -a(1)
  1622      Y4 = f4 - a(0) -a(1)*t
  1623      Z3 = g3*dx23 - a(1)
  1624  
  1625      ! 連立方程式
  1626      ! a(5) + a(4) + a(3) + a(2) = Y3
  1627      ! a(5)r^5 + a(4)r^4 + a(3)r^3 + a(2)r^2 = Y1
  1628      ! a(5)t^5 + a(4)t^4 + a(3)t^3 + a(2)t^2 = Y4
  1629      ! 5a(5) + 4a(4) + 3a(3) + 2a(2) = Z3
  1630      ! の解は
  1631  
  1632      a(5) = Y1/( (r-1.0_DP)*(r-1.0_DP)*r*r*(r-t) ) - Y4 / ( (t-1.0_DP)*(t-1.0_DP)*t*t*(r-t) ) &
  1633      &     - (4.0_DP + 2.0_DP*r*t -3.0_DP*(r+t))*Y3 / ( (r-1.0_DP)*(r-1.0_DP)*(t-1.0_DP)*(t-1.0_DP) )&
  1634      &     + Z3 / ( (r-1.0_DP)*(t-1.0_DP) )
  1635  
  1636      a(4) = -(t+2.0_DP)*Y1 / ((r-1.0_DP)*(r-1.0_DP)*r*r*(r-t) ) &
  1637      &      +(r+2.0_DP)*Y4 / ((t-1.0_DP)*(t-1.0_DP)*t*t*(r-t) ) &
  1638      &      +(5.0_DP - 3.0_DP*(r*r + r*t + t*t) +2.0_DP*r*t*(r+t))*Y3 / ( (r-1.0_DP)*(r-1.0_DP)*(t-1.0_DP)*(t-1.0_DP) ) &
  1639      &      -(r+t+1.0_DP)*Z3/((r-1.0_DP)*(t-1.0_DP))
  1640  
  1641      a(3) = -2.0_DP*Y3 + Z3 -3.0_DP*a(5) - 2.0_DP*a(4)
  1642  
  1643      a(2) = Y3 - a(5) - a(4) - a(3)
  1644  
  1645      Xi2 = Xi/dx23
  1646  
  1647      !fout = a(5)*Xi2*Xi2*Xi2*Xi2*Xi2 + a(4)*Xi2*Xi2*Xi2*Xi2 &
  1648      !&    + a(3)*Xi2*Xi2*Xi2 + a(2)*Xi2*Xi2 + a(1)*Xi2 + a(0)
  1649      fout =   (((((a(5)*Xi2 + a(4))*Xi2+ a(3))*Xi2)+ a(2))*Xi2 + a(1))*Xi2 + a(0)
  1650  
  1651      ! Monotonic filter
  1652  
  1653      ! Do nothing
  1654  
  1655  
  1656      end function SLTTIrrHerIntQui1DNonUni
  1657  
  1658  
  1659  
  1660  !	function judgeSun1996(f1, f2, f3, f4) result(tf)
  1661  !	! Sun et al. (1996, MWR)の単調フィルタ条件の判定
  1662  !	! Judge the condition for Sun et al. (1996, MWR) monotonic filter
  1663  !	
  1664  !	real(8), intent(in) :: f1, f2, f3, f4
  1665  !	logical :: tf
  1666  !	
  1667  !	real(8) :: ineq1
  1668  !	
  1669  !	ineq1 = (f2 - f1)*(f4 - f3)
  1670  !	
  1671  !	if((ineq1>=0.0_8)) then
  1672  !	tf = .true.
  1673  !	else
  1674  !	tf = .false.
  1675  !	endif
  1676  !	
  1677  !	end function judgeSun1996
  1678  
  1679  
  1680    !--------------------------------------------------------------------------------------
  1681  
  1682    !
  1683    ! Checking latitude of departure point
  1684    !
  1685    subroutine SLTTLagIntChkDPLon(       &
  1686      & SLTTIntHor,                      & ! (in)
  1687      & iexmin, iexmax, jexmin, jexmax,  & ! (in)
  1688      & x_ExtLon, xyz_DPLon              & ! (in)
  1689      & )
  1690  
  1691      !
  1692      ! MPI
  1693      !
  1694      use mpi_wrapper, only : myrank
  1695                                ! Number of MPI rank
  1696  
  1697      character(*), intent(in ) :: SLTTIntHor
  1698      integer     , intent(in ) :: iexmin
  1699      integer     , intent(in ) :: iexmax
  1700      integer     , intent(in ) :: jexmin
  1701      integer     , intent(in ) :: jexmax
  1702      real(DP)    , intent(in ) :: x_ExtLon(iexmin:iexmax)
  1703                                ! 緯度の拡張配列
  1704                                ! Extended array of Lat
  1705      real(DP)    , intent(in ) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
  1706                                ! 上流点の緯度
  1707                                ! Lat of departure point
  1708  
  1709      !
  1710      ! local variables
  1711      !
  1712      integer :: iedge
  1713  
  1714      integer :: i
  1715      integer :: j
  1716      integer :: k
  1717  
  1718  
  1719      select case (SLTTIntHor)
  1720      case ("HQ")
  1721        ! 方向分離型2次元変則エルミート5次補間;  2D Hermite quintic interpolation
  1722  
  1723        do k = 1, kmax
  1724          do j = 1, jmax/2
  1725            do i = 0, imax-1
  1726              iedge = iexmin + 1
  1727              if ( xyz_DPLon(i,j,k) < x_ExtLon(iedge) ) then
  1728                call MessageNotify( 'E', module_name, &
  1729                  & 'Departure point is out of range of an extended array for longitudinal direction : Rank %d, %f < %f.', &
  1730                  & i = (/ myrank /), &
  1731                  & d = (/ xyz_DPLon(i,j,k), x_ExtLon(iedge) /) )
  1732              end if
  1733              iedge = iexmax - 1
  1734              if ( xyz_DPLon(i,j,k) > x_ExtLon(iedge) ) then
  1735                call MessageNotify( 'E', module_name, &
  1736                  & 'Departure point is out of range of an extended array for longitudinal direction : Rank %d, %f > %f.', &
  1737                  & i = (/ myrank /), &
  1738                  & d = (/ xyz_DPLon(i,j,k), x_ExtLon(iedge) /) )
  1739              end if
  1740            end do
  1741          end do
  1742        end do
  1743  
  1744      end select
  1745  
  1746  
  1747    end subroutine SLTTLagIntChkDPLon
  1748  
  1749    !----------------------------------------------------------------------------
  1750    !
  1751    ! Checking latitude of departure point
  1752    !
  1753    subroutine SLTTLagIntChkDPLat(       &
  1754      & SLTTIntHor,                      & ! (in)
  1755      & iexmin, iexmax, jexmin, jexmax,  & ! (in)
  1756      & y_ExtLat, xyz_DPLat              & ! (in)
  1757      & )
  1758  
  1759      !
  1760      ! MPI
  1761      !
  1762      use mpi_wrapper, only : myrank
  1763                                ! Number of MPI rank
  1764  
  1765      character(*), intent(in ) :: SLTTIntHor
  1766      integer     , intent(in ) :: iexmin
  1767      integer     , intent(in ) :: iexmax
  1768      integer     , intent(in ) :: jexmin
  1769      integer     , intent(in ) :: jexmax
  1770      real(DP)    , intent(in ) :: y_ExtLat(jexmin:jexmax)
  1771                                ! 緯度の拡張配列
  1772                                ! Extended array of Lat
  1773      real(DP)    , intent(in ) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
  1774                                ! 上流点の緯度
  1775                                ! Lat of departure point
  1776  
  1777      !
  1778      ! local variables
  1779      !
  1780      integer :: jedge
  1781  
  1782      integer :: i
  1783      integer :: j
  1784      integer :: k
  1785  
  1786  
  1787      select case (SLTTIntHor)
  1788      case ("HQ")
  1789        ! 方向分離型2次元変則エルミート5次補間;  2D Hermite quintic interpolation
  1790  
  1791        do k = 1, kmax
  1792          do j = 1, jmax/2
  1793            do i = 0, imax-1
  1794              jedge = jexmin + 1
  1795              if ( xyz_DPLat(i,j,k) < y_ExtLat(jedge) ) then
  1796                call MessageNotify( 'E', module_name, &
  1797                  & 'Departure point is out of range of an extended array for latitudinal direction : Rank %d, %f < %f.', &
  1798                  & i = (/ myrank /), &
  1799                  & d = (/ xyz_DPLat(i,j,k), y_ExtLat(jedge) /) )
  1800              end if
  1801              jedge = jexmax - 1
  1802              if ( xyz_DPLat(i,j,k) > y_ExtLat(jedge) ) then
  1803                call MessageNotify( 'E', module_name, &
  1804                  & 'Departure point is out of range of an extended array for latitudinal direction : Rank %d, %f > %f.', &
  1805                  & i = (/ myrank /), &
  1806                  & d = (/ xyz_DPLat(i,j,k), y_ExtLat(jedge) /) )
  1807              end if
  1808            end do
  1809          end do
  1810        end do
  1811  
  1812      end select
  1813  
  1814  
  1815    end subroutine SLTTLagIntChkDPLat
  1816  
  1817    !----------------------------------------------------------------------------
  1818  
  1819  end module sltt_lagint
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:36 2016
FILE NAME: i.sltt_lagint.F90
PROGRAM NAME: sltt_lagint
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 物質移流計算 (セミラグランジュ法）で用いる補間法
     2:             !
     3:             != Interpolation methods for Semi-Lagrangian method
     4:             !
     5:             ! Authors::   Hiroki KASHIMURA, Yoshiyuki O. TAKAHASHI
     6:             ! Version::   
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2013. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module sltt_lagint
    13:               !
    14:               != セミラグランジュ法 で用いる補間法
    15:               !
    16:               != Interpolation methods for Semi-Lagrangian method
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! セミラグランジュ法で用いる補間を演算するモジュールです. 
    21:               ! スペクトル変換・高精度補間に由来する人工的な短波を除去するために Sun et al. (1996) の
    22:               ! 単調フィルタを応用したものを部分的に用いている。 
    23:               !
    24:               ! This is a Interpolation module. Semi-Lagrangian method (Enomoto 2008 modified)
    25:               ! Monotonicity filter (Sun et al 1996) is partly used.
    26:               !
    27:               !== Procedures List
    28:               !
    29:               ! SLTTLagIntCubCalcFactHor :: 水平２次元ラグランジュ３次補間用の係数計算
    30:               ! SLTTLagIntCubIntHor      :: 水平２次元ラグランジュ３次補間（上流点探索で用いる）
    31:               ! SLTTLagIntCubCalcFactVer :: 鉛直１次元ラグランジュ３次補間用の係数計算
    32:               ! SLTTLagIntCubIntVer      :: 鉛直１次元ラグランジュ３次補間（上流点探索で用いる）
    33:               ! SLTTIrrHerIntK13         :: 水平２次元変則エルミート５次補間
    34:               ! SLTTIrrHerIntQui2DHor    :: 水平２次元変則エルミート５次補間（コア部分）
    35:               ! SLTTIrrHerIntQui1DUni    :: １次元変則エルミート５次補間（等間隔格子）
    36:               ! SLTTIrrHerIntQui1DNonUni :: １次元変則エルミート５次補間（不等間隔格子）  
    37:               ! SLTTIrrHerIntQui1DUniLon :: １次元変則エルミート５次補間（等間隔：経度方向専用）  
    38:               ! SLTTHerIntCub1D          :: １次元エルミート３次補間
    39:               ! SLTTHerIntCub2D          :: ２次元エルミート３次補間
    40:               ! ---------------------    :: ------------
    41:               ! SLTTLagIntCubCalcFactHor :: Calculation of factors for 2D Lagrangian Cubic Interpolation
    42:               ! SLTTLagIntCubIntHor      :: 2D Lagrangian Cubic Interpolation used in finding DP in horizontal
    43:               ! SLTTLagIntCubCalcFactVer :: Calculation of factors for 1D Lagrangian Cubic Interpolation
    44:               ! SLTTLagIntCubIntVer      :: 1D Lagrangian Cubic Interpolation used in finding DP in vertical
    45:               ! SLTTHerIntK13            :: Horizontal 2D Irregular Hermite Quintic Interpolation 
    46:               ! SLTTIrrHerIntQui2DHor    :: Horizontal 2D Irregular Hermite Quintic Interpolation (Core)
    47:               ! SLTTIrrHerIntQui1DUni    :: 1D Irregular Hermite Quintic Interpolation for uniform grids
    48:               ! SLTTIrrHerIntQui1DNonUni :: 1D Irregular Hermite Quintic Interpolation for non-uniform grids
    49:               ! SLTTIrrHerIntQui1DUniLon :: 1D Irregular Hermite Quintic Interpolation for uniform longitude grids
    50:               ! SLTTHerIntCub1D          :: 1D Hermite Cubic Interpolation
    51:               ! SLTTHerIntCub2D          :: 2D Hermite Cubic Interpolation
    52:               !
    53:               !== NAMELIST
    54:               !
    55:               ! NAMELIST#
    56:               !
    57:               !== References
    58:               ! * Enomoto, T., 2008: 
    59:               !   Bicubic Interpolation with Spectral Derivatives. 
    60:               !   <i>SOLA</i>, <b>4</b>, 5-8. doi:10.2151/sola.2008-002
    61:               !
    62:               ! * Sun, W.-Y., Yeh, K.-S., and Sun, R.-Y., 1996: 
    63:               !   A simple semi-Lagrangian scheme for advection equations. 
    64:               !   <i>Quarterly Journal of the Royal Meteorological Society</i>, 
    65:               !   <b>122(533)</b>, 1211-1226. doi:10.1002/qj.49712253310
    66:               ! 種別型パラメタ
    67:               ! Kind type parameter
    68:               !
    69:               use dc_types, only: DP,  & ! 倍精度実数型. Double precision.
    70:                 &                 TOKEN  ! キーワード.   Keywords. 
    71:             
    72:               ! メッセージ出力
    73:               ! Message output
    74:               !
    75:               use dc_message, only: MessageNotify
    76:             
    77:               ! 格子点設定
    78:               ! Grid points settings
    79:               !
    80:               use gridset, only:       &
    81:                 &                imax, & ! 経度格子点数.
    82:                                          ! Number of grid points in longitude
    83:                 &                jmax, & ! 緯度格子点数.
    84:                                          ! Number of grid points in latitude
    85:                 &                kmax    ! 鉛直層数.
    86:                                          ! Number of vertical level
    87:               use composition, only:                              &
    88:                 &                    ncmax,                       &
    89:                                          ! 成分の数
    90:                                          ! Number of composition
    91:                 &                    CompositionInqFlagAdv
    92:             
    93:               ! 座標データ設定
    94:               ! Axes data settings
    95:               !
    96:               use axesset, only: &
    97:                   & DeltaLon, InvDeltaLon ! 経度格子点間隔とその逆数
    98:                                           ! Interval of Longitude grids and its inverse
    99:             
   100:               implicit none
   101:             
   102:               private
   103:             
   104:             !  public :: SLTTLagIntQuadCalcFactHor
   105:             !  public :: SLTTLagIntQuadIntHor
   106:             !  public :: SLTTLagIntQuadCalcFactVer
   107:             !  public :: SLTTLagIntQuadIntVer
   108:               public :: SLTTLagIntCubCalcFactHor
   109:               public :: SLTTLagIntHorMaxMin
   110:               public :: SLTTLagIntCubIntHor
   111:               public :: SLTTLagIntCubCalcFactVer
   112:               public :: SLTTLagIntCubIntVer
   113:               public :: SLTTIrrHerIntK13
   114:               public :: SLTTIrrLinInt
   115:               public :: SLTTHerIntCub1D
   116:               public :: SLTTHerIntCub2D  
   117:               public :: SLTTIrrHerIntQui1DUni
   118:               public :: SLTTIrrHerIntQui1DNonUni
   119:             !  public :: SLTTHerIntQui1D  
   120:             !  public :: judgeSun1996
   121:             
   122:             
   123:               character(*), parameter:: module_name = 'sltt_lagint'
   124:                                           ! モジュールの名称.
   125:                                           ! Module name
   126:               character(*), parameter:: version = &
   127:                 & '$Name:  $' // &
   128:                 & '$Id: sltt_lagint.F90,v 1.4 2013/09/21 14:42:08 yot Exp $'
   129:                                           ! モジュールのバージョン
   130:                                           ! Module version
   131:             
   132:             contains
   133:             
   134:               !--------------------------------------------------------------------------------------
   135:             
   136:             !  subroutine SLTTLagIntQuadCalcFactHor(             &
   137:             !    & x_ExtLon, y_ExtLat, xyz_MPLon, xyz_MPLat,     & ! (in)
   138:             !    & xyz_ii, xyz_jj, xyza_lqifx, xyza_lqify        & ! (out)
   139:             !    & )
   140:             !
   141:             !    use sltt_const , only : PIx2, jew
   142:             !    use mpi_wrapper, only : myrank
   143:             !
   144:             !    real(DP), intent(in ) :: x_ExtLon(-2+0:imax-1+3)
   145:             !    real(DP), intent(in ) :: y_ExtLat(-jew+1:jmax/2+jew)
   146:             !    real(DP), intent(in ) :: xyz_MPLon(0:imax-1, 1:jmax/2, 1:kmax)
   147:             !    real(DP), intent(in ) :: xyz_MPLat(0:imax-1, 1:jmax/2, 1:kmax)
   148:             !    integer , intent(out) :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   149:             !    integer , intent(out) :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   150:             !    real(DP), intent(out) :: xyza_lqifx(0:imax-1, 1:jmax/2, 1:kmax, 0:2)
   151:             !    real(DP), intent(out) :: xyza_lqify(0:imax-1, 1:jmax/2, 1:kmax, 0:2)
   152:             !
   153:             !    !
   154:             !    ! local variables
   155:             !    !
   156:             !    integer :: ii
   157:             !    integer :: jj
   158:             !
   159:             !    integer :: i, j, k, j2
   160:             !
   161:             !
   162:             !    xyz_ii = int( xyz_MPLon / ( PIx2 / imax ) )
   163:             !
   164:             !    do k = 1, kmax
   165:             !      do j = 1, jmax/2
   166:             !        do i = 0, imax-1
   167:             !
   168:             !          if( xyz_MPLat(i,j,k) > y_ExtLat(j) ) then
   169:             !            j_search_1 : do j2 = j+1, jmax/2+jew
   170:             !              if( y_ExtLat(j2) > xyz_MPLat(i,j,k) ) exit j_search_1
   171:             !            end do j_search_1
   172:             !            xyz_jj(i,j,k) = j2 - 1
   173:             !            if ( xyz_jj(i,j,k) > jmax/2+jew-2 ) xyz_jj(i,j,k) = jmax/2+jew-2
   174:             !          else
   175:             !            j_search_2 : do j2 = j-1, -jew+1, -1
   176:             !              if( y_ExtLat(j2) < xyz_MPLat(i,j,k) ) exit j_search_2
   177:             !            end do j_search_2
   178:             !            xyz_jj(i,j,k) = j2
   179:             !            if ( xyz_jj(i,j,k) < -jew+1 ) xyz_jj(i,j,k) = -jew+1
   180:             !          end if
   181:             !
   182:             !        end do
   183:             !      end do
   184:             !    end do
   185:             !
   186:             !#ifdef SLTT_CHECK
   187:             !    do k = 1, kmax
   188:             !      do j = 1, jmax/2
   189:             !        do i = 0, imax-1
   190:             !          if( ( xyz_jj(i,j,k) < 0 ) .or. ( xyz_jj(i,j,k) > (jmax+1) ) ) then
   191:             !            write( 6, * ) 'Error: in sltt_dp_h0 : ', &
   192:             !              'Latitudinal array size is not enough.'
   193:             !            write( 6, * ) ' myrank = ', myrank, ' i = ', i, ' j = ', j, ' k = ', k
   194:             !            write( 6, * ) 'jj = ', xyz_jj(i,j,k), ' jmax = ', jmax
   195:             !            stop
   196:             !          end if
   197:             !        end do
   198:             !      end do
   199:             !    end do
   200:             !#endif
   201:             !
   202:             !    !
   203:             !    ! calculation of Lagrange cubic interpolation factor 
   204:             !    ! for longitudinal direction
   205:             !    !
   206:             !    do k = 1, kmax
   207:             !      do j = 1, jmax/2
   208:             !        do i = 0, imax-1
   209:             !          ii = xyz_ii(i,j,k)
   210:             !          jj = xyz_jj(i,j,k)
   211:             !          xyza_lqifx(i,j,k,0) =                             &
   212:             !            &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   213:             !            &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   214:             !            & / ( ( x_ExtLon(ii  )   - x_ExtLon(ii+1) )     &
   215:             !            &   * ( x_ExtLon(ii  )   - x_ExtLon(ii+2) ) )
   216:             !          xyza_lqifx(i,j,k,1) =                             &
   217:             !            &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   218:             !            &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   219:             !            & / ( ( x_ExtLon(ii+1)   - x_ExtLon(ii  ) )     &
   220:             !            &   * ( x_ExtLon(ii+1)   - x_ExtLon(ii+2) ) )
   221:             !          xyza_lqifx(i,j,k,2) =                             &
   222:             !            &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   223:             !            &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   224:             !            & / ( ( x_ExtLon(ii+2)   - x_ExtLon(ii  ) )     &
   225:             !            &   * ( x_ExtLon(ii+2)   - x_ExtLon(ii+1) ) )
   226:             !
   227:             !          xyza_lqify(i,j,k,0) =                             &
   228:             !            &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   229:             !            &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   230:             !            & / ( ( y_ExtLat(jj  )   - y_ExtLat(jj+1) )     &
   231:             !            &   * ( y_ExtLat(jj  )   - y_ExtLat(jj+2) ) )
   232:             !          xyza_lqify(i,j,k,1) =                             &
   233:             !            &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   234:             !            &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   235:             !            & / ( ( y_ExtLat(jj+1)   - y_ExtLat(jj  ) )     &
   236:             !            &   * ( y_ExtLat(jj+1)   - y_ExtLat(jj+2) ) )
   237:             !          xyza_lqify(i,j,k,2) =                             &
   238:             !            &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   239:             !            &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   240:             !            & / ( ( y_ExtLat(jj+2)   - y_ExtLat(jj) )       &
   241:             !            &   * ( y_ExtLat(jj+2)   - y_ExtLat(jj+1) ) )
   242:             !        end do
   243:             !      end do
   244:             !    end do
   245:             !
   246:             !
   247:             !  end subroutine SLTTLagIntQuadCalcFactHor
   248:             
   249:               !--------------------------------------------------------------------------------------
   250:             
   251:             !  subroutine SLTTLagIntQuadIntHor(                        &
   252:             !    & xyz_ii, xyz_jj, xyza_lqifx, xyza_lqify, xyz_ExtArr, & ! (in)
   253:             !    & xyz_MPArr                                           & ! (out)
   254:             !    & )
   255:             !
   256:             !    use sltt_const , only : jew
   257:             !
   258:             !    integer , intent(in ) :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   259:             !    integer , intent(in ) :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   260:             !    real(DP), intent(in ) :: xyza_lqifx(   0:imax-1  ,      1:jmax/2    , 1:kmax, 0:2)
   261:             !    real(DP), intent(in ) :: xyza_lqify(   0:imax-1  ,      1:jmax/2    , 1:kmax, 0:2)
   262:             !    real(DP), intent(in ) :: xyz_ExtArr(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)
   263:             !    real(DP), intent(out) :: xyz_MPArr (   0:imax-1  ,      1:jmax/2    , 1:kmax)
   264:             !
   265:             !
   266:             !    !
   267:             !    ! local variables
   268:             !    !
   269:             !    integer :: ii
   270:             !    integer :: jj
   271:             !    integer :: kk
   272:             !
   273:             !    integer :: i, j, k
   274:             !
   275:             !
   276:             !    do k = 1, kmax
   277:             !      do j = 1, jmax/2
   278:             !        do i = 0, imax-1
   279:             !          ii = xyz_ii(i,j,k)
   280:             !          jj = xyz_jj(i,j,k)
   281:             !          kk = k
   282:             !          xyz_MPArr(i,j,k) =                                      &
   283:             !            &   xyza_lqify(i,j,k,0)                               &
   284:             !            & * ( xyza_lqifx(i,j,k,0) * xyz_ExtArr(ii  ,jj  ,kk)  &
   285:             !            &   + xyza_lqifx(i,j,k,1) * xyz_ExtArr(ii+1,jj  ,kk)  &
   286:             !            &   + xyza_lqifx(i,j,k,2) * xyz_ExtArr(ii+2,jj  ,kk) )&
   287:             !            & + xyza_lqify(i,j,k,1)                               &
   288:             !            & * ( xyza_lqifx(i,j,k,0) * xyz_ExtArr(ii  ,jj+1,kk)  &
   289:             !            &   + xyza_lqifx(i,j,k,1) * xyz_ExtArr(ii+1,jj+1,kk)  &
   290:             !            &   + xyza_lqifx(i,j,k,2) * xyz_ExtArr(ii+2,jj+1,kk) )&
   291:             !            & + xyza_lqify(i,j,k,2)                               &
   292:             !            & * ( xyza_lqifx(i,j,k,0) * xyz_ExtArr(ii  ,jj+2,kk)  &
   293:             !            &   + xyza_lqifx(i,j,k,1) * xyz_ExtArr(ii+1,jj+2,kk)  &
   294:             !            &   + xyza_lqifx(i,j,k,2) * xyz_ExtArr(ii+2,jj+2,kk) )
   295:             !        end do
   296:             !      end do
   297:             !    end do
   298:             !
   299:             !
   300:             !  end subroutine SLTTLagIntQuadIntHor
   301:             !
   302:             !  !--------------------------------------------------------------------------------------
   303:             !
   304:             !  subroutine SLTTLagIntQuadCalcFactVer(  &
   305:             !    & xyz_DPSigma,                & ! (in)
   306:             !    & xyza_lqifz, xyz_kk          & ! (out)
   307:             !    & )
   308:             !
   309:             !    ! 座標データ設定
   310:             !    ! Axes data settings
   311:             !    !
   312:             !    use axesset, only : z_Sigma
   313:             !
   314:             !
   315:             !    real(DP), intent(in ) :: xyz_DPSigma (0:imax-1, 1:jmax, 1:kmax)
   316:             !    real(DP), intent(out) :: xyza_lqifa_z(0:imax-1, 1:jmax, 1:kmax, 0:2)
   317:             !    integer , intent(out) :: xyz_kk    (0:imax-1, 1:jmax, 1:kmax)
   318:             !
   319:             !
   320:             !    !
   321:             !    ! local variables
   322:             !    !
   323:             !
   324:             !    integer :: i
   325:             !    integer :: j
   326:             !    integer :: k
   327:             !    integer :: kk
   328:             !    integer :: k2
   329:             !
   330:             !
   331:             !    do k = 1, kmax
   332:             !      do j = 1, jmax
   333:             !        do i = 0, imax-1
   334:             !
   335:             !          !
   336:             !          ! Routine for dcpam
   337:             !          !
   338:             !          ! Departure points, xyz_DPSigma(:,:,k), must be located between 
   339:             !          ! z_Sigma(kk) > xyz_DPSigma(k) > z_Sigma(kk+1).
   340:             !          ! Further, 1 <= kk <= kmax-2.
   341:             !          !
   342:             !
   343:             !          !
   344:             !          ! economical method
   345:             !          !
   346:             !          if( xyz_DPSigma(i,j,k) > z_Sigma(k) ) then
   347:             !            k_search_1 : do k2 = k, 1, -1
   348:             !              if( z_Sigma(k2) > xyz_DPSigma(i,j,k) ) exit k_search_1
   349:             !            end do k_search_1
   350:             !            xyz_kk(i,j,k) = k2
   351:             !          else
   352:             !            k_search_2 : do k2 = min( k+1, kmax ), kmax
   353:             !              if( z_Sigma(k2) < xyz_DPSigma(i,j,k) ) exit k_search_2
   354:             !            end do k_search_2
   355:             !            xyz_kk(i,j,k) = k2 - 1
   356:             !          end if
   357:             !          xyz_kk(i,j,k) = min( max( xyz_kk(i,j,k), 1 ), kmax-2 )
   358:             !
   359:             !        end do
   360:             !      end do
   361:             !    end do
   362:             !
   363:             !
   364:             !    do k = 1, kmax
   365:             !      do j = 1, jmax
   366:             !        do i = 0, imax-1
   367:             !          kk = xyz_kk(i,j,k)
   368:             !          xyza_lqifa_z(i,j,k,0) =                          &
   369:             !            &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   370:             !            &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   371:             !            & / ( ( z_Sigma(kk  )      - z_Sigma(kk+1) ) &
   372:             !            &   * ( z_Sigma(kk  )      - z_Sigma(kk+2) ) )
   373:             !          xyza_lqifa_z(i,j,k,1) =                          &
   374:             !            &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   375:             !            &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   376:             !            & / ( ( z_Sigma(kk+1)      - z_Sigma(kk  ) ) &
   377:             !            &   * ( z_Sigma(kk+1)      - z_Sigma(kk+2) ) )
   378:             !          xyza_lqifa_z(i,j,k,2) =                          &
   379:             !            &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   380:             !            &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   381:             !            & / ( ( z_Sigma(kk+2)      - z_Sigma(kk  ) ) &
   382:             !            &   * ( z_Sigma(kk+2)      - z_Sigma(kk+1) ) )
   383:             !        end do
   384:             !      end do
   385:             !    end do
   386:             !
   387:             !
   388:             !  end subroutine SLTTLagIntQuadCalcFactVer
   389:             !
   390:             !  !--------------------------------------------------------------------------------------
   391:             !
   392:             !  subroutine SLTTLagIntQuadIntVer( &
   393:             !    & xyz_Arr, xyza_lqifz, xyz_kk, & ! (in)
   394:             !    & xyz_ArrA                     & ! (out)
   395:             !    & )
   396:             !
   397:             !
   398:             !    real(DP), intent(in ) :: xyz_Arr   (0:imax-1, 1:jmax, 1:kmax)
   399:             !    real(DP), intent(in ) :: xyza_lqifa_z(0:imax-1, 1:jmax, 1:kmax, 0:2)
   400:             !    integer , intent(in ) :: xyz_kk    (0:imax-1, 1:jmax, 1:kmax)
   401:             !    real(DP), intent(out) :: xyz_ArrA  (0:imax-1, 1:jmax, 1:kmax)
   402:             !
   403:             !
   404:             !    !
   405:             !    ! local variables
   406:             !    !
   407:             !
   408:             !    integer :: i
   409:             !    integer :: j
   410:             !    integer :: k
   411:             !    integer :: kk
   412:             !
   413:             !
   414:             !    do k = 1, kmax
   415:             !      do j = 1, jmax
   416:             !        do i = 0, imax-1
   417:             !          kk = xyz_kk(i,j,k)
   418:             !          xyz_ArrA(i,j,k) =                             &
   419:             !            &   xyza_lqifa_z(i,j,k,0) * xyz_Arr(i,j,kk  ) &
   420:             !            & + xyza_lqifa_z(i,j,k,1) * xyz_Arr(i,j,kk+1) &
   421:             !            & + xyza_lqifa_z(i,j,k,2) * xyz_Arr(i,j,kk+2)
   422:             !        end do
   423:             !      end do
   424:             !    end do
   425:             !
   426:             !
   427:             !  end subroutine SLTTLagIntQuadIntVer
   428:             
   429:               !--------------------------------------------------------------------------------------
   430:             
   431:               subroutine SLTTLagIntCubCalcFactHor(              &
   432:                 & iexmin, iexmax, jexmin, jexmax,               & ! (in)
   433:                 & x_ExtLon, y_ExtLat, xyz_MPLon, xyz_MPLat,     & ! (in)
   434:                 & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify        & ! (out)
   435:                 & )
   436:               ! 水平２次元ラグランジュ３次補間の係数計算
   437:               ! Calculation of factors for 2D Lagrangian cubic interpolation
   438:             
   439:                 use sltt_const , only : PIx2
   440:                 use mpi_wrapper, only : myrank
   441:             
   442:                 integer , intent(in ) :: iexmin
   443:                 integer , intent(in ) :: iexmax
   444:                 integer , intent(in ) :: jexmin
   445:                 integer , intent(in ) :: jexmax
   446:                 real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
   447:                 real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
   448:                 real(DP), intent(in ) :: xyz_MPLon(0:imax-1, 1:jmax/2, 1:kmax)
   449:                 real(DP), intent(in ) :: xyz_MPLat(0:imax-1, 1:jmax/2, 1:kmax)
   450:                 integer , intent(out) :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   451:                 integer , intent(out) :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   452:                 real(DP), intent(out) :: xyza_lcifx(0:imax-1, 1:jmax/2, 1:kmax, -1:2)
   453:                 real(DP), intent(out) :: xyza_lcify(0:imax-1, 1:jmax/2, 1:kmax, -1:2)
   454:             
   455:                 !
   456:                 ! local variables
   457:                 !
   458:                 integer :: ii
   459:                 integer :: jj
   460:             
   461:                 integer :: i, j, k, j2
   462:             
   463:             !    integer  :: ns            ! 南北半球の違いに対応するための変数
   464:             !    real(DP) :: in_deltalat
   465:             !    
   466:             !if (y_ExtLat(jmax/4) > 0) then
   467:             !    ns = 0
   468:             !else
   469:             !    ns = jmax/2 - 1
   470:             !endif
   471:             !in_deltalat = 1.0_DP/(y_ExtLat(jmax/4) - y_ExtLat(jmax/4-1))
   472:             
   473:             
   474:             
   475: W**==== A       xyz_ii = int( xyz_MPLon / ( PIx2 / imax ) )
   476:             
   477: +------>        do k = 1, kmax
   478: |+----->          do j = 1, jmax/2
   479: ||+---->            do i = 0, imax-1
   480: |||         
   481: |||                   ! comment out 2015/04/10
   482: |||         !!$          if( xyz_MPLat(i,j,k) > y_ExtLat(j) ) then
   483: |||         !!$            j_search_1 : do j2 = j+1, jexmax
   484: |||         !!$              if( y_ExtLat(j2) > xyz_MPLat(i,j,k) ) exit j_search_1
   485: |||         !!$            end do j_search_1
   486: |||         !!$            xyz_jj(i,j,k) = j2 - 1
   487: |||         !!$            if ( xyz_jj(i,j,k) > jexmax-2 ) xyz_jj(i,j,k) = jexmax-2
   488: |||         !!$          else
   489: |||         !!$            j_search_2 : do j2 = j-1, jexmin, -1
   490: |||         !!$              if( y_ExtLat(j2) < xyz_MPLat(i,j,k) ) exit j_search_2
   491: |||         !!$            end do j_search_2
   492: |||         !!$            xyz_jj(i,j,k) = j2
   493: |||         !!$            if ( xyz_jj(i,j,k) < jexmin+1 ) xyz_jj(i,j,k) = jexmin+1
   494: |||         !!$          end if
   495: |||                   ! trial
   496: |||                   if( xyz_MPLat(i,j,k) > y_ExtLat(j) ) then
   497: |||V--->                j_search_1 : do j2 = j+1, jexmax
   498: ||||    A                 if( y_ExtLat(j2) > xyz_MPLat(i,j,k) ) exit j_search_1
   499: |||V---                 end do j_search_1
   500: |||                     xyz_jj(i,j,k) = j2 - 1
   501: |||                   else
   502: |||V--->                j_search_2 : do j2 = j-1, jexmin, -1
   503: ||||    A                 if( y_ExtLat(j2) < xyz_MPLat(i,j,k) ) exit j_search_2
   504: |||V---                 end do j_search_2
   505: |||                     xyz_jj(i,j,k) = j2
   506: |||                   end if
   507: |||         
   508: |||         
   509: |||         !             xyz_jj(i,j,k) = int(xyz_MPLat(i,j,k)*in_deltalat) + ns + 1
   510: |||         !             if (y_ExtLat(xyz_jj(i,j,k)) > xyz_MPLat(i, j, k)) then 
   511: |||         !                xyz_jj(i,j,k) = xyz_jj(i,j,k) - 1
   512: |||         !             endif
   513: |||         
   514: |||         
   515: ||+----             end do
   516: |+-----           end do
   517: +------         end do
   518:             
   519: +------>        do k = 1, kmax
   520: |+----->          do j = 1, jmax/2
   521: ||+---->            do i = 0, imax-1
   522: |||                   ii = xyz_ii(i,j,k)
   523: |||                   if ( ii-1 < iexmin ) then
   524: |||                     call MessageNotify( 'E', module_name, &
   525: |||                       & 'Longitudinal point for interporation factor calculation ' &
   526: |||                       & // 'is is out of range of an extended array : Rank %d, (i,j,k) = (%d,%d,%d).', &
   527: |||                       & i = (/ myrank, i, j, k /) )
   528: |||                   end if
   529: |||                   if ( ii+2 > iexmax ) then
   530: |||                     call MessageNotify( 'E', module_name, &
   531: |||                       & 'Longitudinal point for interporation factor calculation ' &
   532: |||                       & // 'is is out of range of an extended array : Rank %d, (i,j,k) = (%d,%d,%d).', &
   533: |||                       & i = (/ myrank, i, j, k /) )
   534: |||                   end if
   535: |||                   jj = xyz_jj(i,j,k)
   536: |||                   if ( jj-1 < jexmin ) then
   537: |||                     call MessageNotify( 'E', module_name, &
   538: |||                       & 'Latitudinal point for interporation factor calculation ' &
   539: |||                       & // 'is is out of range of an extended array : Rank %d, (i,j,k) = (%d,%d,%d).', &
   540: |||                       & i = (/ myrank, i, j, k /) )
   541: |||                   end if
   542: |||                   if ( jj+2 > jexmax ) then
   543: |||                     call MessageNotify( 'E', module_name, &
   544: |||                       & 'Latitudinal point for interporation factor calculation ' &
   545: |||                       & // 'is is out of range of an extended array : Rank %d, (i,j,k) = (%d,%d,%d).', &
   546: |||                       & i = (/ myrank, i, j, k /) )
   547: |||                   end if
   548: ||+----             end do
   549: |+-----           end do
   550: +------         end do
   551:             
   552:                 !
   553:                 ! calculation of Lagrange cubic interpolation factor 
   554:                 ! for longitudinal direction
   555:                 !
   556: W------>        do k = 1, kmax
   557: |*----->          do j = 1, jmax/2
   558: ||*---->            do i = 0, imax-1
   559: |||     A             ii = xyz_ii(i,j,k)
   560: |||     A             jj = xyz_jj(i,j,k)
   561: |||     A             xyza_lcifx(i,j,k,-1) =                            &
   562: |||                     &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   563: |||                     &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   564: |||                     &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   565: |||                     &   * (-InvDeltaLon**3)/6.0_DP                  ! economical 
   566: |||         !            & / ( ( x_ExtLon(ii-1)   - x_ExtLon(ii  ) )     &
   567: |||         !            &   * ( x_ExtLon(ii-1)   - x_ExtLon(ii+1) )     &
   568: |||         !            &   * ( x_ExtLon(ii-1)   - x_ExtLon(ii+2) ) )
   569: |||     A             xyza_lcifx(i,j,k, 0) =                            &
   570: |||                     &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii-1) )     &
   571: |||                     &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   572: |||                     &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   573: |||                     &   * (0.5_DP*InvDeltaLon**3)                   ! economical 
   574: |||         !            & / ( ( x_ExtLon(ii  )   - x_ExtLon(ii-1) )     &
   575: |||         !            &   * ( x_ExtLon(ii  )   - x_ExtLon(ii+1) )     &
   576: |||         !            &   * ( x_ExtLon(ii  )   - x_ExtLon(ii+2) ) )
   577: |||     A             xyza_lcifx(i,j,k, 1) =                            &
   578: |||                     &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii-1) )     &
   579: |||                     &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   580: |||                     &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+2) )     &
   581: |||                     &   * (-0.5_DP*InvDeltaLon**3)                  ! economical 
   582: |||         !            & / ( ( x_ExtLon(ii+1)   - x_ExtLon(ii-1) )     &
   583: |||         !            &   * ( x_ExtLon(ii+1)   - x_ExtLon(ii  ) )     &
   584: |||         !            &   * ( x_ExtLon(ii+1)   - x_ExtLon(ii+2) ) )
   585: |||     A             xyza_lcifx(i,j,k, 2) =                            &
   586: |||                     &     ( xyz_MPLon(i,j,k) - x_ExtLon(ii-1) )     &
   587: |||                     &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii  ) )     &
   588: |||                     &   * ( xyz_MPLon(i,j,k) - x_ExtLon(ii+1) )     &
   589: |||                     &   * (InvDeltaLon**3)/6.0_DP                   ! economical 
   590: |||         !            & / ( ( x_ExtLon(ii+2)   - x_ExtLon(ii-1) )     &
   591: |||         !            &   * ( x_ExtLon(ii+2)   - x_ExtLon(ii  ) )     &
   592: |||         !            &   * ( x_ExtLon(ii+2)   - x_ExtLon(ii+1) ) )
   593: |||         
   594: |||     A             xyza_lcify(i,j,k,-1) =                            &
   595: |||                     &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   596: |||                     &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   597: |||                     &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   598: |||                     & / ( ( y_ExtLat(jj-1)   - y_ExtLat(jj  ) )     &
   599: |||                     &   * ( y_ExtLat(jj-1)   - y_ExtLat(jj+1) )     &
   600: |||                     &   * ( y_ExtLat(jj-1)   - y_ExtLat(jj+2) ) )
   601: |||     A             xyza_lcify(i,j,k, 0) =                            &
   602: |||                     &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj-1) )     &
   603: |||                     &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   604: |||                     &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   605: |||                     & / ( ( y_ExtLat(jj  )   - y_ExtLat(jj-1) )     &
   606: |||                     &   * ( y_ExtLat(jj  )   - y_ExtLat(jj+1) )     &
   607: |||                     &   * ( y_ExtLat(jj  )   - y_ExtLat(jj+2) ) )
   608: |||     A             xyza_lcify(i,j,k, 1) =                            &
   609: |||                     &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj-1) )     &
   610: |||                     &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   611: |||                     &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+2) )     &
   612: |||                     & / ( ( y_ExtLat(jj+1)   - y_ExtLat(jj-1) )     &
   613: |||                     &   * ( y_ExtLat(jj+1)   - y_ExtLat(jj  ) )     &
   614: |||                     &   * ( y_ExtLat(jj+1)   - y_ExtLat(jj+2) ) )
   615: |||     A             xyza_lcify(i,j,k, 2) =                            &
   616: |||                     &     ( xyz_MPLat(i,j,k) - y_ExtLat(jj-1) )     &
   617: |||                     &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj  ) )     &
   618: |||                     &   * ( xyz_MPLat(i,j,k) - y_ExtLat(jj+1) )     &
   619: |||                     & / ( ( y_ExtLat(jj+2)   - y_ExtLat(jj-1) )     &
   620: |||                     &   * ( y_ExtLat(jj+2)   - y_ExtLat(jj  ) )     &
   621: |||                     &   * ( y_ExtLat(jj+2)   - y_ExtLat(jj+1) ) )
   622: ||*----             end do
   623: |*-----           end do
   624: W------         end do
   625:             
   626:             
   627:               end subroutine SLTTLagIntCubCalcFactHor
   628:             
   629:               !--------------------------------------------------------------------------------------
   630:             
   631:               subroutine SLTTLagIntCubIntHor(                         &
   632:                 & iexmin, iexmax, jexmin, jexmax,                     & ! (in)
   633:                 & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify, xyz_ExtArr, & ! (in)
   634:                 & xyz_MPArr                                           & ! (out)
   635:                 & )
   636:                 ! 水平２次元ラグランジュ３次補間
   637:                 ! 2D Lagrangian cubic interpolation
   638:             
   639:             
   640:                 integer , intent(in ) :: iexmin
   641:                 integer , intent(in ) :: iexmax
   642:                 integer , intent(in ) :: jexmin
   643:                 integer , intent(in ) :: jexmax
   644:                 integer , intent(in ) :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   645:                 integer , intent(in ) :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   646:                 real(DP), intent(in ) :: xyza_lcifx(     0:imax-1,      1:jmax/2, 1:kmax, -1:2)
   647:                 real(DP), intent(in ) :: xyza_lcify(     0:imax-1,      1:jmax/2, 1:kmax, -1:2)
   648:                 real(DP), intent(in ) :: xyz_ExtArr(iexmin:iexmax, jexmin:jexmax, 1:kmax)
   649:                 real(DP), intent(out) :: xyz_MPArr (     0:imax-1,      1:jmax/2, 1:kmax)
   650:             
   651:             
   652:                 !
   653:                 ! local variables
   654:                 !
   655:                 integer :: ii
   656:                 integer :: jj
   657:                 integer :: kk
   658:             
   659:                 integer :: i, j, k
   660:             
   661:             
   662: +------>        do k = 1, kmax
   663: |W----->          do j = 1, jmax/2
   664: ||*---->            do i = 0, imax-1
   665: |||     A             ii = xyz_ii(i,j,k)
   666: |||     A             jj = xyz_jj(i,j,k)
   667: |||                   kk = k
   668: |||     A             xyz_MPArr(i,j,k) =                                       &
   669: |||                     &   xyza_lcify(i,j,k,-1)                               &
   670: |||                     & * ( xyza_lcifx(i,j,k,-1) * xyz_ExtArr(ii-1,jj-1,kk)  &
   671: |||                     &   + xyza_lcifx(i,j,k, 0) * xyz_ExtArr(ii  ,jj-1,kk)  &
   672: |||                     &   + xyza_lcifx(i,j,k, 1) * xyz_ExtArr(ii+1,jj-1,kk)  &
   673: |||                     &   + xyza_lcifx(i,j,k, 2) * xyz_ExtArr(ii+2,jj-1,kk) )&
   674: |||                     & + xyza_lcify(i,j,k, 0)                               &
   675: |||                     & * ( xyza_lcifx(i,j,k,-1) * xyz_ExtArr(ii-1,jj  ,kk)  &
   676: |||                     &   + xyza_lcifx(i,j,k, 0) * xyz_ExtArr(ii  ,jj  ,kk)  &
   677: |||                     &   + xyza_lcifx(i,j,k, 1) * xyz_ExtArr(ii+1,jj  ,kk)  &
   678: |||                     &   + xyza_lcifx(i,j,k, 2) * xyz_ExtArr(ii+2,jj  ,kk) )&
   679: |||                     & + xyza_lcify(i,j,k, 1)                               &
   680: |||                     & * ( xyza_lcifx(i,j,k,-1) * xyz_ExtArr(ii-1,jj+1,kk)  &
   681: |||                     &   + xyza_lcifx(i,j,k, 0) * xyz_ExtArr(ii  ,jj+1,kk)  &
   682: |||                     &   + xyza_lcifx(i,j,k, 1) * xyz_ExtArr(ii+1,jj+1,kk)  &
   683: |||                     &   + xyza_lcifx(i,j,k, 2) * xyz_ExtArr(ii+2,jj+1,kk) )&
   684: |||                     & + xyza_lcify(i,j,k, 2)                               &
   685: |||                     & * ( xyza_lcifx(i,j,k,-1) * xyz_ExtArr(ii-1,jj+2,kk)  &
   686: |||                     &   + xyza_lcifx(i,j,k, 0) * xyz_ExtArr(ii  ,jj+2,kk)  &
   687: |||                     &   + xyza_lcifx(i,j,k, 1) * xyz_ExtArr(ii+1,jj+2,kk)  &
   688: |||                     &   + xyza_lcifx(i,j,k, 2) * xyz_ExtArr(ii+2,jj+2,kk) )
   689: ||*----             end do
   690: |W-----           end do
   691: +------         end do
   692:             
   693:             
   694:               end subroutine SLTTLagIntCubIntHor
   695:             
   696:               !--------------------------------------------------------------------------------------
   697:             
   698:               subroutine SLTTLagIntCubCalcFactVer(  &
   699:                 & xyz_DPSigma,                & ! (in)
   700:                 & xyza_lcifz, xyz_kk          & ! (out)
   701:                 & )
   702:               ! 鉛直１次元ラグランジュ３次補間のための係数計算
   703:               ! Calculation of factors for 1D Lagrangian cubic interpolation
   704:               
   705:                 ! 座標データ設定
   706:                 ! Axes data settings
   707:                 !
   708:                 use axesset, only : z_Sigma
   709:             
   710:             
   711:                 real(DP), intent(in ) :: xyz_DPSigma (0:imax-1, 1:jmax, 1:kmax)
   712:                 real(DP), intent(out) :: xyza_lcifz(0:imax-1, 1:jmax, 1:kmax, -1:2)
   713:                 integer , intent(out) :: xyz_kk    (0:imax-1, 1:jmax, 1:kmax)
   714:             
   715:             
   716:                 !
   717:                 ! local variables
   718:                 !
   719:             
   720:                 integer :: i
   721:                 integer :: j
   722:                 integer :: k
   723:                 integer :: kk
   724:                 integer :: k2
   725:             
   726:             
   727: +------>        do k = 1, kmax
   728: |+----->          do j = 1, jmax
   729: ||+---->            do i = 0, imax-1
   730: |||         
   731: |||                   !
   732: |||                   ! Routine for dcpam
   733: |||                   !
   734: |||                   ! Departure points, xyz_DPSigma(:,:,k), must be located between 
   735: |||                   ! z_Sigma(kk) > xyz_DPSigma(k) > z_Sigma(kk+1).
   736: |||                   ! Further, 2 <= kk <= kmax-2.
   737: |||                   !
   738: |||         
   739: |||                   !
   740: |||                   ! economical method
   741: |||                   !
   742: |||                   if( xyz_DPSigma(i,j,k) > z_Sigma(k) ) then
   743: |||V--->                k_search_1 : do k2 = k, 2, -1
   744: ||||    A                 if( z_Sigma(k2) > xyz_DPSigma(i,j,k) ) exit k_search_1
   745: |||V---                 end do k_search_1
   746: |||                     xyz_kk(i,j,k) = k2
   747: |||                   else
   748: |||V--->                k_search_2 : do k2 = min( k+1, kmax ), kmax
   749: ||||    A                 if( z_Sigma(k2) < xyz_DPSigma(i,j,k) ) exit k_search_2
   750: |||V---                 end do k_search_2
   751: |||                     xyz_kk(i,j,k) = k2 - 1
   752: |||                   end if
   753: |||                   xyz_kk(i,j,k) = min( max( xyz_kk(i,j,k), 2 ), kmax-2 )
   754: |||         !          xyz_kk(i,j,k) = min( max( xyz_kk(i,j,k), 1 ), kmax-1 )
   755: |||         
   756: ||+----             end do
   757: |+-----           end do
   758: +------         end do
   759:             
   760:             
   761: W------>        do k = 1, kmax
   762: |*----->          do j = 1, jmax
   763: ||*---->            do i = 0, imax-1
   764: |||     A             kk = xyz_kk(i,j,k)
   765: |||     A             xyza_lcifz(i,j,k,-1) =                         &
   766: |||                     &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   767: |||                     &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   768: |||                     &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   769: |||                     & / ( ( z_Sigma(kk-1)      - z_Sigma(kk  ) ) &
   770: |||                     &   * ( z_Sigma(kk-1)      - z_Sigma(kk+1) ) &
   771: |||                     &   * ( z_Sigma(kk-1)      - z_Sigma(kk+2) ) )
   772: |||     A             xyza_lcifz(i,j,k, 0) =                         &
   773: |||                     &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk-1) ) &
   774: |||                     &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   775: |||                     &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   776: |||                     & / ( ( z_Sigma(kk  )      - z_Sigma(kk-1) ) &
   777: |||                     &   * ( z_Sigma(kk  )      - z_Sigma(kk+1) ) &
   778: |||                     &   * ( z_Sigma(kk  )      - z_Sigma(kk+2) ) )
   779: |||     A             xyza_lcifz(i,j,k, 1) =                         &
   780: |||                     &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk-1) ) &
   781: |||                     &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   782: |||                     &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+2) ) &
   783: |||                     & / ( ( z_Sigma(kk+1)      - z_Sigma(kk-1) ) &
   784: |||                     &   * ( z_Sigma(kk+1)      - z_Sigma(kk  ) ) &
   785: |||                     &   * ( z_Sigma(kk+1)      - z_Sigma(kk+2) ) )
   786: |||     A             xyza_lcifz(i,j,k, 2) =                         &
   787: |||                     &     ( xyz_DPSigma(i,j,k) - z_Sigma(kk-1) ) &
   788: |||                     &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk  ) ) &
   789: |||                     &   * ( xyz_DPSigma(i,j,k) - z_Sigma(kk+1) ) &
   790: |||                     & / ( ( z_Sigma(kk+2)      - z_Sigma(kk-1) ) &
   791: |||                     &   * ( z_Sigma(kk+2)      - z_Sigma(kk  ) ) &
   792: |||                     &   * ( z_Sigma(kk+2)      - z_Sigma(kk+1) ) )
   793: ||*----             end do
   794: |*-----           end do
   795: W------         end do
   796:             
   797:             
   798:               end subroutine SLTTLagIntCubCalcFactVer
   799:             
   800:               !--------------------------------------------------------------------------------------
   801:             
   802:               subroutine SLTTLagIntCubIntVer(  &
   803:                 & xyz_Arr, xyza_lcifz, xyz_kk, & ! (in)
   804:                 & xyz_ArrA                     & ! (out)
   805:                 & )
   806:               ! 鉛直１次元ラグランジュ３次補間
   807:               ! 1D Lagrangian cubic interpolation
   808:             
   809:                 real(DP), intent(in ) :: xyz_Arr   (0:imax-1, 1:jmax, 1:kmax)
   810:                 real(DP), intent(in ) :: xyza_lcifz(0:imax-1, 1:jmax, 1:kmax, -1:2)
   811:                 integer , intent(in ) :: xyz_kk    (0:imax-1, 1:jmax, 1:kmax)
   812:                 real(DP), intent(out) :: xyz_ArrA  (0:imax-1, 1:jmax, 1:kmax)
   813:             
   814:             
   815:                 !
   816:                 ! local variables
   817:                 !
   818:             
   819:                 integer :: i
   820:                 integer :: j
   821:                 integer :: k
   822:                 integer :: kk
   823:             
   824:             
   825: +------>        do k = 1, kmax
   826: |+----->          do j = 1, jmax
   827: ||V---->            do i = 0, imax-1
   828: |||                   kk = xyz_kk(i,j,k)
   829: |||     A             xyz_ArrA(i,j,k) =                              &
   830: |||                     &   xyza_lcifz(i,j,k,-1) * xyz_Arr(i,j,kk-1) &
   831: |||                     & + xyza_lcifz(i,j,k, 0) * xyz_Arr(i,j,kk  ) &
   832: |||                     & + xyza_lcifz(i,j,k, 1) * xyz_Arr(i,j,kk+1) &
   833: |||                     & + xyza_lcifz(i,j,k, 2) * xyz_Arr(i,j,kk+2)
   834: ||V----             end do
   835: |+-----           end do
   836: +------         end do
   837:             
   838:             
   839:               end subroutine SLTTLagIntCubIntVer
   840:             
   841:               !--------------------------------------------------------------------------------------
   842:             
   843:               subroutine SLTTLagIntHorMaxMin(                                &
   844:                 & iexmin, iexmax, jexmin, jexmax,                            & ! (in)
   845:                 & x_ExtLon, y_ExtLat, xyz_DPLon, xyz_DPLat, xyzf_ExtQMixB,   & ! (in)
   846:                 & xyzf_QMixMinA, xyzf_QMixMaxA                               & ! (out)
   847:                 & )
   848:                 ! 水平方向の２次元補間。
   849:                 ! 2D linear interpolation
   850:             
   851:                 use mpi_wrapper, only : myrank
   852:             
   853:                 integer , intent(in ) :: iexmin
   854:                 integer , intent(in ) :: iexmax
   855:                 integer , intent(in ) :: jexmin
   856:                 integer , intent(in ) :: jexmax
   857:                 real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
   858:                                            ! 経度の拡張配列
   859:                                            ! Extended array of Lon
   860:                 real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
   861:                                            ! 緯度の拡張配列
   862:                                            ! Extended array of Lat
   863:                 real(DP), intent(in ) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
   864:                                            ! 上流点の経度
   865:                                            ! Lon at departure point
   866:                 real(DP), intent(in ) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
   867:                                            ! 上流点の緯度
   868:                                            ! Lat at departure point
   869:                 real(DP), intent(in ) :: xyzf_ExtQMixB(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   870:                                            ! 物質混合比の拡張配列
   871:                                            ! Extended array of mix ration of tracers
   872:                 real(DP), intent(out) :: xyzf_QMixMinA(     0:imax-1,      1:jmax/2, 1:kmax, 1:ncmax)
   873:                                            ! 上流点を囲む 4 格子点の最小値
   874:                                            ! Minimum mixing ratio of tracers at 4 grid points 
   875:                                            ! surrounding a departure point
   876:                 real(DP), intent(out) :: xyzf_QMixMaxA(     0:imax-1,      1:jmax/2, 1:kmax, 1:ncmax)
   877:                                            ! 上流点を囲む 4 格子点の最大値
   878:                                            ! Maximum mixing ratio of tracers at 4 grid points 
   879:                                            ! surrounding a departure point
   880:             
   881:             
   882:                 real(DP) :: DeltaLat      ! 緯度グリッド幅; grid width in meridional direction
   883:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   884:                                           ! Work variables for DO loop in zonal direction
   885:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   886:                                           ! Work variables for DO loop in meridional direction
   887:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   888:                                           ! Work variables for DO loop in vertical direction
   889:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   890:                                           ! Work variables for DO loop in number of composition
   891:             
   892:                 integer:: ii
   893:                 integer:: jj
   894:             
   895:                 integer :: isten          ! 上流点を囲む4格子点の南西の点の座標番号（東西方向）
   896:             	                          ! Youngest index of grid points around the departure point (i-direction)
   897:                 integer :: jsten          ! 上流点を囲む4格子点の南西の点の座標番号（南北方向）
   898:             	                          ! Youngest index of grid points around the departure point (j-direction)
   899:                 real(DP) :: xy_Z(0:1,0:1)     ! 上流点を囲む 4 格子点上の混合比を格納する作業変数
   900:                                               ! Work variable containing mixing ratio at 4 grid points around DP
   901:             
   902:             
   903:             
   904: +------>        do k = 1, kmax
   905: |+----->          do j = 1, jmax/2
   906: ||+---->            do i = 0, imax-1
   907: |||                   ! 上流点を囲む4点を探す
   908: |||                   ! Determine four grid points around the departure point
   909: |||                   isten = int(xyz_DPLon(i,j,k)*InvDeltaLon)
   910: |||V--->              do jj = jexmin, jexmax
   911: ||||    A               if (y_ExtLat(jj) > xyz_DPLat(i, j, k)) then
   912: ||||                      jsten = jj-1
   913: ||||                      exit
   914: ||||                    endif
   915: |||V---               enddo
   916: |||                   !MPIに対応できない↓
   917: |||         !      jsten = int(xyz_DPLat(i,j,k)*in_deltalat) + ns + 1
   918: |||         !      if (y_ExtLat(jsten) > xyz_DPLat(i, j, k)) then 
   919: |||         !        jsten = jsten - 1
   920: |||         !      endif
   921: |||         
   922: |||                   ! Check indices
   923: |||                   if ( ( isten < iexmin ) .or. ( isten > iexmax ) ) then
   924: |||                     call MessageNotify( 'E', module_name, &
   925: |||                       & 'Departure point is out of range of an extended array for linear interporation ' &
   926: |||                       & // 'in longitudinal direction : Rank %d, i = %d.', &
   927: |||                       & i = (/ myrank, isten /) )
   928: |||                   end if
   929: |||                   if ( ( jsten < jexmin ) .or. ( jsten > jexmax ) ) then
   930: |||                     call MessageNotify( 'E', module_name, &
   931: |||                       & 'Departure point is out of range of an extended array for linear interporation ' &
   932: |||                       & // 'in latitudinal direction : Rank %d, j = %d.', &
   933: |||                       & i = (/ myrank, jsten /) )
   934: |||                   end if
   935: |||         
   936: |||V--->              do n = 1, ncmax
   937: ||||        
   938: ||||*-->                do jj = 0, 1
   939: |||||*->                  do ii = 0, 1
   940: ||||||  A                   xy_Z(ii,jj) = xyzf_ExtQMixB(isten+ii,jsten+jj,k,n)
   941: |||||*-                   end do
   942: ||||*--                 end do
   943: ||||        
   944: ||||    A               xyzf_QMixMinA(i,j,k,n) = min( xy_Z(0,0), xy_Z(1,0), xy_Z(0,1), xy_Z(1,1) )
   945: ||||    A               xyzf_QMixMaxA(i,j,k,n) = max( xy_Z(0,0), xy_Z(1,0), xy_Z(0,1), xy_Z(1,1) )
   946: ||||        
   947: |||V---               end do
   948: |||         
   949: ||+----             end do
   950: |+-----           end do
   951: +------         end do
   952:             
   953:               end subroutine SLTTLagIntHorMaxMin
   954:             
   955:               !--------------------------------------------------------------------------------------
   956:             
   957:               subroutine SLTTIrrLinInt(                                      &
   958:                 & iexmin, iexmax, jexmin, jexmax,                            & ! (in)
   959:                 & x_ExtLon, y_ExtLat, xyz_DPLon, xyz_DPLat, xyzf_ExtQMixB,   & ! (in)
   960:                 & xyzf_QMixA                                                 & ! (out)
   961:                 & )
   962:                 ! 水平方向の２次元補間。
   963:                 ! 2D linear interpolation
   964:             
   965:                 use mpi_wrapper, only : myrank
   966:             
   967:                 integer , intent(in ) :: iexmin
   968:                 integer , intent(in ) :: iexmax
   969:                 integer , intent(in ) :: jexmin
   970:                 integer , intent(in ) :: jexmax
   971:                 real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
   972:                                            ! 経度の拡張配列
   973:                                            ! Extended array of Lon
   974:                 real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
   975:                                            ! 緯度の拡張配列
   976:                                            ! Extended array of Lat
   977:                 real(DP), intent(in ) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
   978:                                            ! 上流点の経度
   979:                                            ! Lon at departure point
   980:                 real(DP), intent(in ) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
   981:                                            ! 上流点の緯度
   982:                                            ! Lat at departure point
   983:                 real(DP), intent(in ) :: xyzf_ExtQMixB(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   984:                                            ! 物質混合比の拡張配列
   985:                                            ! Extended array of mix ration of tracers
   986:                 real(DP), intent(out) :: xyzf_QMixA (   0:imax-1  ,      1:jmax/2    , 1:kmax, 1:ncmax)
   987:                                            ! 次ステップの物質混合比
   988:                                            ! Mix ration of tracers at next time-step
   989:             
   990:             
   991:                 real(DP) :: DeltaLat      ! 緯度グリッド幅; grid width in meridional direction
   992:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   993:                                           ! Work variables for DO loop in zonal direction
   994:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   995:                                           ! Work variables for DO loop in meridional direction
   996:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   997:                                           ! Work variables for DO loop in vertical direction
   998:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   999:                                           ! Work variables for DO loop in number of composition
  1000:             
  1001:                 integer:: ii
  1002:                 integer:: jj
  1003:             
  1004:                 integer :: isten          ! 上流点を囲む4格子点の南西の点の座標番号（東西方向）
  1005:             	                          ! Youngest index of grid points around the departure point (i-direction)
  1006:                 integer :: jsten          ! 上流点を囲む4格子点の南西の点の座標番号（南北方向）
  1007:             	                          ! Youngest index of grid points around the departure point (j-direction)
  1008:                 real(DP) :: xy_Z(0:1,0:1)     ! 上流点を囲む 4 格子点上の混合比を格納する作業変数
  1009:                                               ! Work variable containing mixing ratio at 4 grid points around DP
  1010:                 real(DP) :: y_Z(0:1)          ! 上流点を囲む 2 格子点上の混合比を格納する作業変数
  1011:                                               ! Work variable containing mixing ratio at 2 grid points in latitudinal direction
  1012:             
  1013:             
  1014: +------>        do k = 1, kmax
  1015: |+----->          do j = 1, jmax/2
  1016: ||+---->            do i = 0, imax-1
  1017: |||                   ! 上流点を囲む4点を探す
  1018: |||                   ! Determine four grid points around the departure point
  1019: |||                   isten = int(xyz_DPLon(i,j,k)*InvDeltaLon)
  1020: |||V--->              do jj = jexmin, jexmax
  1021: ||||    A               if (y_ExtLat(jj) > xyz_DPLat(i, j, k)) then
  1022: ||||                      jsten = jj-1
  1023: ||||                      exit
  1024: ||||                    endif
  1025: |||V---               enddo
  1026: |||                   !MPIに対応できない↓
  1027: |||         !      jsten = int(xyz_DPLat(i,j,k)*in_deltalat) + ns + 1
  1028: |||         !      if (y_ExtLat(jsten) > xyz_DPLat(i, j, k)) then 
  1029: |||         !        jsten = jsten - 1
  1030: |||         !      endif
  1031: |||         
  1032: |||                   ! Check indices
  1033: |||                   if ( ( isten < iexmin ) .or. ( isten > iexmax ) ) then
  1034: |||                     call MessageNotify( 'E', module_name, &
  1035: |||                       & 'Departure point is out of range of an extended array for linear interporation ' &
  1036: |||                       & // 'in longitudinal direction : Rank %d, i = %d.', &
  1037: |||                       & i = (/ myrank, isten /) )
  1038: |||                   end if
  1039: |||                   if ( ( jsten < jexmin ) .or. ( jsten > jexmax ) ) then
  1040: |||                     call MessageNotify( 'E', module_name, &
  1041: |||                       & 'Departure point is out of range of an extended array for linear interporation ' &
  1042: |||                       & // 'in latitudinal direction : Rank %d, j = %d.', &
  1043: |||                       & i = (/ myrank, jsten /) )
  1044: |||                   end if
  1045: |||         
  1046: |||V--->              do n = 1, ncmax
  1047: ||||        
  1048: ||||*-->                do jj = 0, 1
  1049: |||||*->                  do ii = 0, 1
  1050: ||||||  A                   xy_Z(ii,jj) = xyzf_ExtQMixB(isten+ii,jsten+jj,k,n)
  1051: |||||*-                   end do
  1052: ||||*--                 end do
  1053: ||||                    DeltaLat = y_ExtLat(jsten+1) - y_ExtLat(jsten)
  1054: ||||        
  1055: ||||*-->                do jj = 0, 1
  1056: |||||                     y_Z(jj) =   ( xy_Z(1,jj) - xy_Z(0,jj) ) / DeltaLon   &
  1057: |||||                       &         * ( xyz_DPLon(i,j,k) - x_ExtLon(isten) ) + xy_Z(0,jj)
  1058: ||||*--                 end do
  1059: ||||    A               xyzf_QMixA(i,j,k,n) =   ( y_Z(1) - y_Z(0) ) / DeltaLat           &
  1060: ||||                      &                     * ( xyz_DPLat(i,j,k) - y_ExtLat(jsten) ) &
  1061: ||||                      &                   + y_Z(0)
  1062: ||||        
  1063: |||V---               end do
  1064: |||         
  1065: ||+----             end do
  1066: |+-----           end do
  1067: +------         end do
  1068:             
  1069:               end subroutine SLTTIrrLinInt
  1070:             
  1071:               !--------------------------------------------------------------------------------------
  1072:             
  1073:               subroutine SLTTIrrHerIntK13(              &
  1074:                & iexmin, iexmax, jexmin, jexmax,                            & ! (in)
  1075:                & x_ExtLon, y_ExtLat, xyz_DPLon, xyz_DPLat, xyz_ExtQMixB,    & ! (in)
  1076:                & xyz_ExtQMixB_dlon, xyz_ExtQMixB_dlat, xyz_ExtQMixB_dlonlat,& ! (in) 
  1077:             !    & xyz_ExtQMixB_dlon2, xyz_ExtQMixB_dlat2,        & ! (in) fxx, fyy
  1078:             !    & xyz_ExtQMixB_dlon2lat, xyz_ExtQMixB_dlonlat2,  & ! (in) fxxy, fxyy
  1079:             !    & xyz_ExtQMixB_dlon2lat2,                                  & ! (in) fxxyy       	
  1080:                & SLTTIntHor,                                                        & ! (in) 
  1081:                & xyz_QMixA        & ! (out)
  1082:                & )
  1083:                 ! 水平方向の２次元補間。Enomoto (2008, SOLA)で提案された「スペクトルで計算した微分値を用いた双３次補間」を
  1084:                 ! 発展させた方法、スペクトル微分を用いた変則エルミート５次補間を方向分離して行う。５次補間のたびに Sun et al. (1996, MWR)
  1085:                 ! の単調フィルタを修正したものを適用する。
  1086:                 ! 2D Interpolation. Spectral transformation is used for calculation of derivatives, which are used
  1087:                 ! for Irregular Hermite quintic interpolation. The original idea of using Spectral transformation for derivatives
  1088:                 ! is presented by Enomoto (2008, SOLA).
  1089:                 ! Monotonicity filter presented by Sun et al. (1996, MWR) is partly modified and used after each interpolation.
  1090:             
  1091:                 use sltt_const , only : PIx2
  1092:                 use mpi_wrapper, only : myrank
  1093:                 use gridset, only: lmax    ! スペクトルデータの配列サイズ
  1094:                                            ! Size of array for spectral data
  1095:             
  1096:                 integer , intent(in ) :: iexmin
  1097:                 integer , intent(in ) :: iexmax
  1098:                 integer , intent(in ) :: jexmin
  1099:                 integer , intent(in ) :: jexmax
  1100:                 real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
  1101:                                            ! 経度の拡張配列
  1102:                                            ! Extended array of Lon
  1103:                 real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
  1104:                                            ! 緯度の拡張配列
  1105:                                            ! Extended array of Lat
  1106:                 real(DP), intent(in ) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
  1107:                                            ! 上流点の経度
  1108:                                            ! Lon at departure point
  1109:                 real(DP), intent(in ) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
  1110:                                            ! 上流点の緯度
  1111:                                            ! Lat at departure point
  1112:                 real(DP), intent(in ) :: xyz_ExtQMixB(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1113:                                            ! 物質混合比の拡張配列
  1114:                                            ! Extended array of mix ration of tracers
  1115:                 real(DP), intent(in) :: xyz_ExtQMixB_dlon(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1116:                                            ! 物質混合比の経度微分の拡張配列
  1117:                                            ! Extended array of zonal derivative of the mix ration
  1118:                 real(DP), intent(in) :: xyz_ExtQMixB_dlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1119:                                            ! 物質混合比の緯度微分の拡張配列
  1120:                                            ! Extended array of meridional derivative of the mix ration
  1121:                 real(DP), intent(in) :: xyz_ExtQMixB_dlonlat(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)            
  1122:                                            ! 物質混合比の緯度経度微分の拡張配列
  1123:                                            ! Extended array of zonal and meridional derivative of the mix ration
  1124:                 character(TOKEN), intent(in):: SLTTIntHor
  1125:                                            ! 水平方向の補間方法を指定するキーワード
  1126:                                            ! Keyword for Interpolation Method for Horizontal direction
  1127:                 real(DP), intent(out) :: xyz_QMixA (   0:imax-1  ,      1:jmax/2    , 1:kmax, 1:ncmax)
  1128:                                            ! 次ステップの物質混合比
  1129:                                            ! Mix ration of tracers at next time-step
  1130:             
  1131:             !---fxx, fyy, fxxy, fxyy, fxxyy
  1132:             !    real(DP), intent(inout) :: xyz_ExtQMixB_dlon2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)
  1133:             !    real(DP), intent(inout) :: xyz_ExtQMixB_dlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)
  1134:             !    real(DP), intent(inout) :: xyz_ExtQMixB_dlon2lat(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)            
  1135:             !    real(DP), intent(inout) :: xyz_ExtQMixB_dlonlat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)                
  1136:             !    real(DP), intent(inout) :: xyz_ExtQMixB_dlon2lat2(-2+0:imax-1+3, -jew+1:jmax/2+jew, 1:kmax)                
  1137:             
  1138:             
  1139:             
  1140:                 real(DP) :: DeltaLat      ! 緯度グリッド幅; grid width in meridional direction
  1141:                 integer:: i, ii           ! 東西方向に回る DO ループ用作業変数
  1142:                                           ! Work variables for DO loop in zonal direction
  1143:                 integer:: j, jj           ! 南北方向に回る DO ループ用作業変数
  1144:                                           ! Work variables for DO loop in meridional direction
  1145:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1146:                                           ! Work variables for DO loop in vertical direction
  1147:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
  1148:                                           ! Work variables for DO loop in number of composition
  1149:             
  1150:                 integer :: isten          ! 上流点を囲む4格子点の南西の点の座標番号（東西方向）
  1151:             	                          ! Youngest index of grid points around the departure point (i-direction)
  1152:                 integer :: jsten          ! 上流点を囲む4格子点の南西の点の座標番号（南北方向）
  1153:             	                          ! Youngest index of grid points around the departure point (j-direction)
  1154:                 integer  :: num           ! 配列配置のための作業変数
  1155:             	                          ! Work variable for array packing
  1156:                 real(DP) :: a_z(16)       ! 上流点を囲む16格子点上の混合比を格納する作業変数
  1157:                                           ! Work variable containing mixing ratio at 16 grid points around DP
  1158:                 real(DP) :: a_zx(16)      ! 上流点を囲む16格子点上の混合比の経度微分を格納する作業変数
  1159:                                           ! Work variable containing zonal derivative of mixing ratio at 16 grid points around DP
  1160:                 real(DP) :: a_zy(16)      ! 上流点を囲む16格子点上の混合比の緯度微分を格納する作業変数
  1161:                                           ! Work variable containing meridional derivative of mixing ratio at 16 grid points around DP
  1162:                 real(DP) :: a_zxy(16)     ! 上流点を囲む16格子点上の混合比の緯度経度微分を格納する作業変数
  1163:                                           ! Work variable containing zonal and meridional derivative of mixing ratio at 16 grid points around DP
  1164:             !    real(DP):: a_zxx(16), a_zyy(16), a_zxxy(16), a_zxyy(16), a_zxxyy(16)
  1165:             
  1166:             
  1167:                 ! Check whether a longitude of departure point is within an extended array
  1168:                 call SLTTLagIntChkDPLon(       &
  1169:                   & SLTTIntHor,                      & ! (in)
  1170:                   & iexmin, iexmax, jexmin, jexmax,  & ! (in)
  1171:                   & x_ExtLon, xyz_DPLon              & ! (in)
  1172:                   & )
  1173:                 ! Check whether a latitude of departure point is within an extended array
  1174:                 call SLTTLagIntChkDPLat(             &
  1175:                   & SLTTIntHor,                      & ! (in)
  1176:                   & iexmin, iexmax, jexmin, jexmax,  & ! (in)
  1177:                   & y_ExtLat, xyz_DPLat              & ! (in)
  1178:                   & )
  1179:             
  1180:             
  1181: +------>     do k = 1, kmax
  1182: |+----->       do j = 1, jmax/2
  1183: ||+---->         do i = 0, imax-1
  1184: |||                ! 上流点を囲む4点を探す
  1185: |||                ! Determine four grid points around the departure point
  1186: |||                isten = int(xyz_DPLon(i,j,k)*InvDeltaLon)
  1187: |||V--->           do jj = jexmin, jexmax
  1188: ||||    A            if (y_ExtLat(jj) > xyz_DPLat(i, j, k)) then
  1189: ||||                   jsten = jj-1
  1190: ||||                   exit
  1191: ||||                 endif
  1192: |||V---            enddo
  1193: |||               !MPIに対応できない↓
  1194: |||         !      jsten = int(xyz_DPLat(i,j,k)*in_deltalat) + ns + 1
  1195: |||         !      if (y_ExtLat(jsten) > xyz_DPLat(i, j, k)) then 
  1196: |||         !        jsten = jsten - 1
  1197: |||         !      endif
  1198: |||         
  1199: |||         
  1200: |||                 ! 水平方向の補間方法の選択
  1201: |||                 select case (SLTTIntHor)
  1202: |||         
  1203: |||                 case ("HQ") ! 方向分離型2次元変則エルミート5次補間;  2D Hermite quintic interpolation
  1204: |||+--->              do n = 1, ncmax
  1205: ||||                    ! ２次元補間のための配列配置（ワイド）
  1206: ||||                    ! Array packing for 2D interpolation
  1207: ||||+-->                do jj = -1, 2
  1208: |||||                     num = (jj+1)*4 + 2
  1209: |||||*->                  do ii = -1, 2
  1210: ||||||                      a_z(ii+num) = xyz_ExtQMixB(isten+ii, jsten+jj, k, n)
  1211: ||||||                      a_zx(ii+num) = xyz_ExtQMixB_dlon(isten+ii, jsten+jj, k, n)
  1212: ||||||                      a_zy(ii+num) = xyz_ExtQMixB_dlat(isten+ii, jsten+jj, k, n)
  1213: ||||||                      a_zxy(ii+num) = xyz_ExtQMixB_dlonlat(isten+ii, jsten+jj, k, n)
  1214: |||||*-                   enddo
  1215: ||||+--                 enddo
  1216: ||||        
  1217: ||||                    ! 方向分離型2次元変則エルミート5次補間 
  1218: ||||                    ! 2D Hermite quintic interpolation
  1219: ||||                    xyz_QMixA(i,j,k,n) = SLTTIrrHerIntQui2DHor(a_z, a_zx, a_zy, a_zxy, &
  1220: ||||                      & y_ExtLat(jsten-1)-y_ExtLat(jsten), y_ExtLat(jsten+1)-y_ExtLat(jsten), y_ExtLat(jsten+2)-y_ExtLat(jsten),&
  1221: ||||                      &   xyz_DPLon(i, j, k)-x_ExtLon(isten),  xyz_DPLat(i, j, k)-y_ExtLat(jsten) )
  1222: |||+---               enddo
  1223: |||         
  1224: |||         
  1225: |||                 case("HC") !方向分離型2次元エルミート３次補間; 2D Hermite Cubic Interpolation
  1226: |||+--->              do n = 1, ncmax
  1227: ||||                  ! ２次元補間のための配列配置
  1228: ||||                  !    4           3
  1229: ||||                  !         x
  1230: ||||                  !    1           2           
  1231: ||||                    a_z(1) = xyz_ExtQMixB(isten, jsten, k, n)
  1232: ||||                    a_zx(1) = xyz_ExtQMixB_dlon(isten, jsten, k, n)
  1233: ||||                    a_zy(1) = xyz_ExtQMixB_dlat(isten, jsten, k, n)
  1234: ||||                    a_zxy(1) = xyz_ExtQMixB_dlonlat(isten, jsten, k, n)
  1235: ||||        !               a_zxx(1) = xyz_ExtQMixB_dlon2(isten, jsten, k, n)
  1236: ||||        !               a_zyy(1) = xyz_ExtQMixB_dlat2(isten, jsten, k, n)
  1237: ||||        !               a_zxxy(1) = xyz_ExtQMixB_dlon2lat(isten, jsten, k, n)
  1238: ||||        !               a_zxyy(1) = xyz_ExtQMixB_dlonlat2(isten, jsten, k, n)
  1239: ||||        !               a_zxxyy(1) = xyz_ExtQMixB_dlon2lat2(isten, jsten, k, n)
  1240: ||||        
  1241: ||||                    a_z(2) = xyz_ExtQMixB(isten+1, jsten, k, n)
  1242: ||||                    a_zx(2) = xyz_ExtQMixB_dlon(isten+1, jsten, k, n)
  1243: ||||                    a_zy(2) = xyz_ExtQMixB_dlat(isten+1, jsten, k, n)
  1244: ||||                    a_zxy(2) = xyz_ExtQMixB_dlonlat(isten+1, jsten, k, n)
  1245: ||||        !               a_zxx(2) = xyz_ExtQMixB_dlon2(isten+1, jsten, k, n)
  1246: ||||        !               a_zyy(2) = xyz_ExtQMixB_dlat2(isten+1, jsten, k, n)
  1247: ||||        !               a_zxxy(2) = xyz_ExtQMixB_dlon2lat(isten+1, jsten, k, n)
  1248: ||||        !               a_zxyy(2) = xyz_ExtQMixB_dlonlat2(isten+1, jsten, k, n)
  1249: ||||        !               a_zxxyy(2) = xyz_ExtQMixB_dlon2lat2(isten+1, jsten, k, n)
  1250: ||||        
  1251: ||||                    a_z(3) = xyz_ExtQMixB(isten+1, jsten+1, k, n)
  1252: ||||                    a_zx(3) = xyz_ExtQMixB_dlon(isten+1, jsten+1, k, n)
  1253: ||||                    a_zy(3) = xyz_ExtQMixB_dlat(isten+1, jsten+1, k, n)
  1254: ||||                    a_zxy(3) = xyz_ExtQMixB_dlonlat(isten+1, jsten+1, k, n)
  1255: ||||        !               a_zxx(3) = xyz_ExtQMixB_dlon2(isten+1, jsten+1, k, n)
  1256: ||||        !               a_zyy(3) = xyz_ExtQMixB_dlat2(isten+1, jsten+1, k, n)
  1257: ||||        !               a_zxxy(3) = xyz_ExtQMixB_dlon2lat(isten+1, jsten+1, k, n)
  1258: ||||        !               a_zxyy(3) = xyz_ExtQMixB_dlonlat2(isten+1, jsten+1, k, n)
  1259: ||||        !               a_zxxyy(3) = xyz_ExtQMixB_dlon2lat2(isten+1, jsten+1, k, n)
  1260: ||||        
  1261: ||||                    a_z(4) = xyz_ExtQMixB(isten, jsten+1, k, n)
  1262: ||||                    a_zx(4) = xyz_ExtQMixB_dlon(isten, jsten+1, k, n)
  1263: ||||                    a_zy(4) = xyz_ExtQMixB_dlat(isten, jsten+1, k, n)
  1264: ||||                    a_zxy(4) = xyz_ExtQMixB_dlonlat(isten, jsten+1, k, n)
  1265: ||||        !               a_zxx(4) = xyz_ExtQMixB_dlon2(isten, jsten+1, k, n)
  1266: ||||        !               a_zyy(4) = xyz_ExtQMixB_dlat2(isten, jsten+1, k, n)
  1267: ||||        !               a_zxxy(4) = xyz_ExtQMixB_dlon2lat(isten, jsten+1, k, n)
  1268: ||||        !               a_zxyy(4) = xyz_ExtQMixB_dlonlat2(isten, jsten+1, k, n)
  1269: ||||        !               a_zxxyy(4) = xyz_ExtQMixB_dlon2lat2(isten, jsten+1, k, n)
  1270: ||||        
  1271: ||||                    DeltaLat = y_ExtLat(jsten+1) - y_ExtLat(jsten)
  1272: ||||        
  1273: ||||                    !方向分離型2次元エルミート３次補間
  1274: ||||                    xyz_QMixA(i,j,k,n) = SLTTHerIntCub2D(a_z(1:4), a_zx(1:4), a_zy(1:5), a_zxy(1:4), DeltaLon, DeltaLat,&
  1275: ||||                                        &  xyz_DPLon(i, j, k)-x_ExtLon(isten), xyz_DPLat(i, j, k)-y_ExtLat(jsten) )
  1276: ||||        
  1277: ||||        !方向分離型2次元エルミート5次補間
  1278: ||||        !    	xyz_QMixA(i,j,k) = hqint2D(a_z, a_zx, a_zy, a_zxy, a_zxx, a_zyy, a_zxxy, a_zxyy, a_zxxyy, deltalon, deltalat, &
  1279: ||||        !		&   xyz_DPLon(i, j, k)-x_ExtLon(isten),  xyz_DPLat(i, j, k)-y_ExtLat(jsten) )
  1280: |||+---              enddo
  1281: |||         
  1282: |||                 case DEFAULT
  1283: |||                   call MessageNotify( 'E', module_name, &
  1284: |||                     & 'GIVE CORRECT KEYWORD FOR <SLTTIntHor> IN NAMELIST.' )
  1285: |||               end select
  1286: |||         
  1287: |||         
  1288: |||         
  1289: ||+----         enddo
  1290: |+-----       enddo
  1291: +------     enddo
  1292:             
  1293:             end subroutine SLTTIrrHerIntK13
  1294:             
  1295:             
  1296:               function SLTTHerIntCub2D(f, fx, fy, fxy, dx, dy, Xix, Xiy) result (fout)
  1297:                 !２次元エルミート３次補間  
  1298:                 ! 2D Hermite Cubic Interpolation  
  1299:                 !    4----b------3
  1300:                 !         |
  1301:                 !         X
  1302:                 !         |
  1303:                 !    1----a------2
  1304:                 ! Xix:点1と点aとの間隔、Xiy:点aと点Xとの間隔
  1305:                 ! Xix:distance between 1 and a, Xiy:distance between a and X
  1306:             
  1307:                 implicit none
  1308:                 real(DP), dimension(4), intent(in) :: f, fx, fy, fxy
  1309:                 real(DP), intent(in) :: dx, dy, Xix, Xiy
  1310:                 real(DP) :: fout
  1311:             
  1312:                 !------Internal variables-------
  1313:                 real(DP) :: fa, fb, fya, fyb
  1314:             
  1315:             
  1316:                 ! 点1と点2から点aでの値を求める
  1317:                 ! interpolate a from 1 and 2 
  1318:                 fa = SLTTHerIntCub1D(f(1), f(2), fx(1), fx(2), dx, Xix)
  1319:                 fya = SLTTHerIntCub1D(fy(1), fy(2), fxy(1), fxy(2), dx, Xix)
  1320:             
  1321:                 ! 点4と点3から点bでの値を求める
  1322:                 ! interpolate b from 4 and 3 
  1323:                 fb = SLTTHerIntCub1D(f(4), f(3), fx(4), fx(3), dx, Xix)
  1324:                 fyb = SLTTHerIntCub1D(fy(4), fy(3), fxy(4), fxy(3), dx, Xix)
  1325:             
  1326:                 ! 点aと点bから点Xをでの値を求める
  1327:                 ! interpolate X from a and b
  1328:                 fout = SLTTHerIntCub1D(fa, fb, fya, fyb, dy, Xiy)
  1329:             
  1330:               end function SLTTHerIntCub2D
  1331:             
  1332:             
  1333:               function SLTTHerIntCub1D(f1, f2, g1, g2, dx, Xi) result (fout)
  1334:                 !エルミート３次補間
  1335:                 ! 1D Hermite Cubic Interpolation
  1336:                 !    1-----x------2
  1337:                 ! f:関数値、g:微分値、dx:点１と点２の間隔、Xi:点１と補間する点xとの間隔
  1338:                 ! f:function value, g:derivative, dx:distance between 1 and 2, Xi:distance between 1 and x
  1339:                 implicit none
  1340:                 real(DP), intent(in) :: f1, f2, g1, g2
  1341:                 real(DP), intent(in) :: dx, Xi
  1342:                 real(DP) :: fout
  1343:                 !------Internal variables-------
  1344:                 real(DP):: a, b
  1345:                 real(DP):: indx
  1346:             
  1347:                 indx = 1.0_DP/dx
  1348:             
  1349:                 a = (g1 + g2)*indx*indx + 2.0_DP*(f1 - f2)*indx*indx*indx
  1350:                 b = 3.0_DP*(f2 - f1)*indx*indx - (2.0_DP*g1 + g2)*indx
  1351:                 fout = a*Xi*Xi*Xi + b*Xi*Xi + g1*Xi + f1
  1352:             
  1353:               end function SLTTHerIntCub1D
  1354:             
  1355:             
  1356:             
  1357:             !function centdif4(f,x) result (g3out)
  1358:             !! 不等間隔格子での4次精度の中心差分。
  1359:             !! 関数値 f1, f2, f3, f4, f5 から 点3の x微分 g3 をもとめる。
  1360:             !real(DP), intent(in) :: f(5), x(5)
  1361:             !real(DP) :: g3out
  1362:             !
  1363:             !!---内部変数---
  1364:             !real(DP) :: s1, s2, t1, t2, gtmp1, gtmp2
  1365:             !
  1366:             !s1 = x(3) - x(2)
  1367:             !t1 = x(4) - x(3)
  1368:             !s2 = x(3) - x(1)
  1369:             !t2 = x(5) - x(3)
  1370:             !!準備｜不等間隔格子での2次精度中心差分(http://ruby.gfd-dennou.org/products/numru-derivative/derivative/doc/document.pdf)
  1371:             !gtmp1 = (s1*s1*f(4) + (t1*t1 - s1*s1)*f(3) - t1*t1*f(2))/(s1*t1*(s1 + t1))
  1372:             !gtmp2 = (s2*s2*f(5) + (t2*t2 - s2*s2)*f(3) - t2*t2*f(1))/(s2*t2*(s2 + t2))
  1373:             !
  1374:             !if (gtmp1 == 0.0) then !2次精度中心差分で傾きゼロの点は、そのまま出力する
  1375:             !g3out = 0.0_DP
  1376:             !else
  1377:             !g3out = (gtmp1*s2*t2 - gtmp2*s1*t1)/(s2*t2 - s1*t1) 
  1378:             !endif
  1379:             !
  1380:             !end function centdif4
  1381:             
  1382:             
  1383:             !  function hqint2D(f, fx, fy, fxy, fxx, fyy, fxxy, fxyy, fxxyy, dx, dy, Xix, Xiy) result (fout)
  1384:             !!２次元エルミート５次補間（２階微分使用）
  1385:             !! 2D Hermite Quintic Interpolation (using 2nd derivatives)
  1386:             !!    4----b------3
  1387:             !!         |
  1388:             !!         X
  1389:             !!         |
  1390:             !!    1----a------2
  1391:             !! Xix:点1と点aとの間隔、Xiy:点aと点Xとの間隔
  1392:             !! Xix:distance between 1 and a, Xiy:distance between a and X
  1393:             !
  1394:             !    implicit none
  1395:             !    real(DP), dimension(4), intent(in) :: f, fx, fy, fxy, fxx, fyy, fxxy, fxyy, fxxyy
  1396:             !    real(DP), intent(in) :: dx, dy, Xix, Xiy
  1397:             !    real(DP) :: fout
  1398:             !!------interlan variables-------
  1399:             !    real(DP) :: fa, fb, fya, fyb, fyya, fyyb
  1400:             !
  1401:             !
  1402:             !! 点1と点2から点aでの値を求める
  1403:             !! interpolate a from 1 and 2 
  1404:             !fa = SLTTHerIntQui1D(f(1), f(2), fx(1), fx(2), fxx(1), fxx(2), dx, Xix)
  1405:             !fya = SLTTHerIntQui1D(fy(1), fy(2), fxy(1), fxy(2), fxxy(1), fxxy(2), dx, Xix)
  1406:             !fyya = SLTTHerIntQui1D(fyy(1), fyy(2), fxyy(1), fxyy(2), fxxyy(1), fxxyy(2), dx, Xix)
  1407:             !
  1408:             !
  1409:             !! 点4と点3から点bでの値を求める
  1410:             !! interpolate b from 4 and 3 
  1411:             !fb = SLTTHerIntQui1D(f(4), f(3), fx(4), fx(3), fxx(4), fxx(3), dx, Xix)
  1412:             !fyb = SLTTHerIntQui1D(fy(4), fy(3), fxy(4), fxy(3), fxxy(4), fxxy(3), dx, Xix)
  1413:             !fyyb = SLTTHerIntQui1D(fyy(4), fyy(3), fxyy(4), fxyy(3), fxxyy(4), fxxyy(3), dx, Xix)
  1414:             !
  1415:             !! 点aと点bから点Xをでの値を求める
  1416:             !! interpolate X from a and b 
  1417:             !fout = SLTTHerIntQui1D(fa, fb, fya, fyb, fyya, fyyb, dy, Xiy)
  1418:             !
  1419:             !    end function hqint2D
  1420:             
  1421:             
  1422:             
  1423:               function SLTTIrrHerIntQui2DHor(f, fx, fy, fxy, dy21, dy23, dy24, Xix, Xiy) result (fout)
  1424:                 ! ２次元変則エルミート５次補間（２階微分不使用）
  1425:                 ! 2D Hermite Quintic Interpolation (without 2nd derivatives)
  1426:                 !
  1427:                 ! 13-14-d-15--16
  1428:                 ! |   | | |   |
  1429:                 ! 9--10-c-11--12
  1430:                 ! |   | x |   |
  1431:                 ! 5---6-b-7---8
  1432:                 ! |   | | |   |
  1433:                 ! 1---2-a-3---4
  1434:                 !
  1435:                 ! Xix:点6と点aとの間隔、Xiy:点aと点Xとの間隔
  1436:                 ! dy21=lat(5)-lat(1), dy23=lat(5)-lat(9), dy24=lat(5)-lat(13) 
  1437:                 ! Xix:distance between 6 and a, Xiy:distance between b and x
  1438:                 ! dy21=lat(5)-lat(1), dy23=lat(5)-lat(9), dy24=lat(5)-lat(13) 
  1439:             
  1440:                 implicit none
  1441:                 real(DP), dimension(16), intent(in) :: f, fx, fy, fxy
  1442:                 real(DP), intent(in) :: dy21, dy23, dy24, Xix, Xiy
  1443:                 real(DP) :: fout
  1444:                 !------internal variables-------
  1445:                 real(DP) :: fa, fb, fc, fd, fyb, fyc, fya, fyd, lmin, lmax
  1446:             
  1447:                 ! 点1-4から点aでの値を求める
  1448:                 ! interpolate a from points 1-4
  1449:                 fa = SLTTIrrHerIntQui1DUniLon(f(1), f(2), f(3), f(4), fx(2), fx(3),  Xix)
  1450:             
  1451:                 ! 点5-8から点bでの値を求める
  1452:                 ! interpolate b from points 5-8
  1453:                 fb = SLTTIrrHerIntQui1DUniLon(f(5), f(6), f(7), f(8), fx(6), fx(7),  Xix)
  1454:                 fyb = SLTTIrrHerIntQui1DUniLon(fy(5), fy(6), fy(7), fy(8), fxy(6), fxy(7),  Xix)
  1455:             
  1456:                 ! 点9-12から点cでの値を求める
  1457:                 ! interpolate c from points 9-12
  1458:                 fc = SLTTIrrHerIntQui1DUniLon(f(9), f(10), f(11), f(12), fx(10), fx(11),  Xix)
  1459:                 fyc = SLTTIrrHerIntQui1DUniLon(fy(9), fy(10), fy(11), fy(12), fxy(10), fxy(11),  Xix)
  1460:             
  1461:                 ! 点13-16から点dでの値を求める
  1462:                 ! interpolate d from points 13-16
  1463:                 fd = SLTTIrrHerIntQui1DUniLon(f(13), f(14), f(15), f(16), fx(14), fx(15),  Xix)
  1464:             
  1465:                 ! 点a-dから点Xをでの値を求める
  1466:                 ! interpolate X from points a-d
  1467:                 fout = SLTTIrrHerIntQui1DNonUni(fa, fb, fc, fd, fyb, fyc, dy21, dy23, dy24, Xiy)
  1468:                 !等間隔格子に近似しても、精度はほとんど落ちない。計算は軽くなる。
  1469:                 !fout = SLTTIrrHerIntQui1DUni(fa, fb, fc, fd, fyb, fyc, dy23, Xiy)
  1470:             
  1471:               end function SLTTIrrHerIntQui2DHor
  1472:             
  1473:             
  1474:             
  1475:             !  function SLTTHerIntQui1D(f1, f2, g1, g2, h1, h2, dx, Xi) result (fout)
  1476:             !! エルミート５次補間（２階微分使用）
  1477:             !! 1D Hermite Quintic Interpolation (using 2nd derivatives)
  1478:             !!    1-----x------2
  1479:             !! f:関数値、g:微分値、h:2階微分、dx:点１と点２の間隔、Xi:点１と補間する点xとの間隔
  1480:             !! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0 で補間する
  1481:             !! f:function value, g:derivative, h:2nd derivative, 
  1482:             !! dx:distance between 1 and 2, Xi:distance between 1 and x
  1483:             !! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0
  1484:             !
  1485:             !    implicit none
  1486:             !    real(DP), intent(in) :: f1, f2, g1, g2, h1, h2
  1487:             !    real(DP), intent(in) :: dx, Xi
  1488:             !    real(DP) :: fout
  1489:             !!------内部変数-------
  1490:             !    real(DP):: a(0:5)
  1491:             !    real(DP):: indx
  1492:             !
  1493:             !indx = 1.0_DP/dx
  1494:             !
  1495:             !a(0) = f1
  1496:             !a(1) = g1
  1497:             !a(2) = 0.5_DP*h1
  1498:             !a(3) = 10.0_DP*(-f1+f2)*indx*indx*indx + (-6.0_DP*g1-4.0_DP*g2)*indx*indx + (-1.5_DP*h1+0.5_DP*h2)*indx
  1499:             !a(4) = 15.0_DP*(f1-f2)*indx*indx*indx*indx + (8.0_DP*g1+7.0_DP*g2)*indx*indx*indx + (1.5_DP*h1-h2)*indx*indx
  1500:             !a(5) = 6.0_DP*(-f1+f2)*indx*indx*indx*indx*indx + 3.0_DP*(-g1-g2)*indx*indx*indx*indx + 0.5_DP*(-h1+h2)*indx*indx*indx
  1501:             !
  1502:             !fout = a(5)*Xi*Xi*Xi*Xi*Xi + a(4)*Xi*Xi*Xi*Xi + a(3)*Xi*Xi*Xi + a(2)*Xi*Xi + a(1)*Xi + a(0)
  1503:             !
  1504:             !    end function SLTTHerIntQui1D
  1505:             
  1506:             
  1507:             
  1508:               function SLTTIrrHerIntQui1DUni(f1, f2, f3, f4, g2, g3, dx, Xi) result (fout)
  1509:                 ! 変則エルミート５次補間（２階微分不使用）
  1510:                 ! 1D Hermite Quintic Interpolation (without 2nd derivatives)
  1511:                 ! 等間隔格子の場合
  1512:                 ! equal separation
  1513:                 !    1---2--x-3---4
  1514:                 ! f:関数値、g:微分値、、dx:点の間隔、Xi:点２と補間する点xとの間隔
  1515:                 ! f:function value, g:derivative,
  1516:                 ! dx:equal separation of each point, Xi:distance between 2 and x
  1517:                 ! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0 
  1518:                 ! f1 = f(-X), f2 = f(0), f3 = f(X), f4 = f(2X)
  1519:             
  1520:                 implicit none
  1521:                 real(DP), intent(in) :: f1, f2, f3, f4, g2, g3
  1522:                 real(DP), intent(in) :: dx, Xi
  1523:                 real(DP) :: fout
  1524:                 !------internal variables-------
  1525:                 real(DP):: a(0:5)
  1526:                 real(DP):: indx
  1527:             
  1528:                 indx = 1.0_DP/dx
  1529:             
  1530:                 a(0) = f2
  1531:                 a(1) = g2
  1532:                 a(5) = (0.75_DP*f3 - (f1 - f4)/12.0_DP -0.5_DP*( g3 + a(1))*dx -0.75_DP*a(0))*indx**5
  1533:                 a(3) = -a(5)*dx*dx - a(1)*indx*indx + (f3 - f1)*0.5_DP*indx**3
  1534:                 a(4) = ( (g3 + a(1))*0.5_DP*dx - f3 +a(0) )*indx**4 - 1.5_DP*a(5)*dx - 0.5_DP*a(3)*indx
  1535:                 a(2) = ( (f3 + f1)*0.5_DP -a(0))*indx*indx -a(4)*dx*dx 
  1536:             
  1537:                 !fout = a(5)*Xi*Xi*Xi*Xi*Xi + a(4)*Xi*Xi*Xi*Xi &
  1538:                 !&    + a(3)*Xi*Xi*Xi + a(2)*Xi*Xi + a(1)*Xi + a(0)
  1539:                 fout =   (((((a(5)*Xi + a(4))*Xi+ a(3))*Xi)+ a(2))*Xi + a(1))*Xi + a(0)
  1540:             
  1541:             
  1542:                 ! Monotonic filter
  1543:             
  1544:                 ! Do nothing
  1545:             
  1546:             
  1547:               end function SLTTIrrHerIntQui1DUni
  1548:             
  1549:               function SLTTIrrHerIntQui1DUniLon(f1, f2, f3, f4, g2, g3, Xi) result (fout)
  1550:                 ! 変則エルミート５次補間（２階微分不使用）
  1551:                 ! 1D Hermite Quintic Interpolation (without 2nd derivatives)
  1552:                 ! 経度方向（等間隔）専用
  1553:                 ! equal separation
  1554:                 !    1---2--x-3---4
  1555:                 ! f:関数値、g:微分値、、dx:点の間隔、Xi:点２と補間する点xとの間隔
  1556:                 ! f:function value, g:derivative,
  1557:                 ! dx:equal separation of each point, Xi:distance between 2 and x
  1558:                 ! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0 
  1559:                 ! f1 = f(-X), f2 = f(0), f3 = f(X), f4 = f(2X)
  1560:             
  1561:                 implicit none
  1562:                 real(DP), intent(in) :: f1, f2, f3, f4, g2, g3
  1563:                 real(DP), intent(in) :: Xi
  1564:                 real(DP) :: fout
  1565:                 !------internal variables-------
  1566:                 real(DP):: a(0:5)
  1567:             
  1568:             
  1569:                 a(0) = f2
  1570:                 a(1) = g2
  1571:                 a(5) = (0.75_DP*f3 - (f1 - f4)/12.0_DP -0.5_DP*( g3 + a(1))*DeltaLon -0.75_DP*a(0))*InvDeltaLon**5
  1572:                 a(3) = -a(5)*DeltaLon*DeltaLon - a(1)*InvDeltaLon*InvDeltaLon + (f3 - f1)*0.5_DP*InvDeltaLon**3
  1573:                 a(4) = ( (g3 + a(1))*0.5_DP*DeltaLon - f3 +a(0) )*InvDeltaLon**4 - 1.5_DP*a(5)*DeltaLon - 0.5_DP*a(3)*InvDeltaLon
  1574:                 a(2) = ( (f3 + f1)*0.5_DP -a(0))*InvDeltaLon*InvDeltaLon -a(4)*DeltaLon*DeltaLon 
  1575:             
  1576:                 !fout = a(5)*Xi*Xi*Xi*Xi*Xi + a(4)*Xi*Xi*Xi*Xi &
  1577:                 !&    + a(3)*Xi*Xi*Xi + a(2)*Xi*Xi + a(1)*Xi + a(0)
  1578:                 fout =   (((((a(5)*Xi + a(4))*Xi+ a(3))*Xi)+ a(2))*Xi + a(1))*Xi + a(0)
  1579:             
  1580:             
  1581:                 ! Monotonic filter
  1582:             
  1583:                 ! Do nothing
  1584:             
  1585:             
  1586:               end function SLTTIrrHerIntQui1DUniLon
  1587:             
  1588:             
  1589:             
  1590:               function SLTTIrrHerIntQui1DNonUni(f1, f2, f3, f4, g2, g3, dx21, dx23, dx24, Xi) result (fout)
  1591:                 ! 変則エルミート５次補間（２階微分不使用）
  1592:                 ! 1D Hermite Quintic Interpolation
  1593:                 ! 不等間隔格子の場合
  1594:                 ! non-equal separation
  1595:                 !    1---2--x-3---4
  1596:                 ! f:関数値、g:微分値、、dx:点の間隔、Xi:点２と補間する点xとの間隔
  1597:                 ! f:function value, g:derivative
  1598:                 ! dx21: lon(1)-lon(2), dx23: lon(3)-lon(2), dx24: lon(4)-lon(2), 
  1599:                 ! f(x) = a_5*x^5 + a_4*x^4 + a_3*x^3 + a_2*x^2 + a_1*x + a_0
  1600:                 ! f1 = f(dx21), f2 = f(0), f3 = f(dx23), f4 = f(dx24)
  1601:             
  1602:                 implicit none
  1603:                 real(8), intent(in) :: f1, f2, f3, f4, g2, g3
  1604:                 real(8), intent(in) :: dx21, dx23, dx24, Xi
  1605:                 real(8) :: fout, r, t
  1606:                 !------Internal variables-------
  1607:                 real(8):: a(0:5)
  1608:                 real(8):: indx
  1609:                 real(8):: Y1, Y3, Y4, Z3, Xi2
  1610:                 integer :: n
  1611:             
  1612:                 ! 計算効率化のため、dx21, dx23, dx24 を dx23 で正規化する。
  1613:                 ! このとき、1階微分値は × dx23 する必要がある。
  1614:                 r = dx21/dx23
  1615:                 t = dx24/dx23
  1616:             
  1617:                 a(0) = f2
  1618:                 a(1) = g2*dx23
  1619:             
  1620:                 Y1 = f1 - a(0) -a(1)*r
  1621:                 Y3 = f3 - a(0) -a(1)
  1622:                 Y4 = f4 - a(0) -a(1)*t
  1623:                 Z3 = g3*dx23 - a(1)
  1624:             
  1625:                 ! 連立方程式
  1626:                 ! a(5) + a(4) + a(3) + a(2) = Y3
  1627:                 ! a(5)r^5 + a(4)r^4 + a(3)r^3 + a(2)r^2 = Y1
  1628:                 ! a(5)t^5 + a(4)t^4 + a(3)t^3 + a(2)t^2 = Y4
  1629:                 ! 5a(5) + 4a(4) + 3a(3) + 2a(2) = Z3
  1630:                 ! の解は
  1631:             
  1632:                 a(5) = Y1/( (r-1.0_DP)*(r-1.0_DP)*r*r*(r-t) ) - Y4 / ( (t-1.0_DP)*(t-1.0_DP)*t*t*(r-t) ) &
  1633:                 &     - (4.0_DP + 2.0_DP*r*t -3.0_DP*(r+t))*Y3 / ( (r-1.0_DP)*(r-1.0_DP)*(t-1.0_DP)*(t-1.0_DP) )&
  1634:                 &     + Z3 / ( (r-1.0_DP)*(t-1.0_DP) )
  1635:             
  1636:                 a(4) = -(t+2.0_DP)*Y1 / ((r-1.0_DP)*(r-1.0_DP)*r*r*(r-t) ) &
  1637:                 &      +(r+2.0_DP)*Y4 / ((t-1.0_DP)*(t-1.0_DP)*t*t*(r-t) ) &
  1638:                 &      +(5.0_DP - 3.0_DP*(r*r + r*t + t*t) +2.0_DP*r*t*(r+t))*Y3 / ( (r-1.0_DP)*(r-1.0_DP)*(t-1.0_DP)*(t-1.0_DP) ) &
  1639:                 &      -(r+t+1.0_DP)*Z3/((r-1.0_DP)*(t-1.0_DP))
  1640:             
  1641:                 a(3) = -2.0_DP*Y3 + Z3 -3.0_DP*a(5) - 2.0_DP*a(4)
  1642:             
  1643:                 a(2) = Y3 - a(5) - a(4) - a(3)
  1644:             
  1645:                 Xi2 = Xi/dx23
  1646:             
  1647:                 !fout = a(5)*Xi2*Xi2*Xi2*Xi2*Xi2 + a(4)*Xi2*Xi2*Xi2*Xi2 &
  1648:                 !&    + a(3)*Xi2*Xi2*Xi2 + a(2)*Xi2*Xi2 + a(1)*Xi2 + a(0)
  1649:                 fout =   (((((a(5)*Xi2 + a(4))*Xi2+ a(3))*Xi2)+ a(2))*Xi2 + a(1))*Xi2 + a(0)
  1650:             
  1651:                 ! Monotonic filter 
  1652:             
  1653:                 ! Do nothing
  1654:             
  1655:             
  1656:                 end function SLTTIrrHerIntQui1DNonUni
  1657:             
  1658:             
  1659:                 
  1660:             !	function judgeSun1996(f1, f2, f3, f4) result(tf)
  1661:             !	! Sun et al. (1996, MWR)の単調フィルタ条件の判定
  1662:             !	! Judge the condition for Sun et al. (1996, MWR) monotonic filter
  1663:             !	
  1664:             !	real(8), intent(in) :: f1, f2, f3, f4
  1665:             !	logical :: tf
  1666:             !	
  1667:             !	real(8) :: ineq1
  1668:             !	
  1669:             !	ineq1 = (f2 - f1)*(f4 - f3)
  1670:             !	
  1671:             !	if((ineq1>=0.0_8)) then
  1672:             !	tf = .true.
  1673:             !	else
  1674:             !	tf = .false.
  1675:             !	endif
  1676:             !	
  1677:             !	end function judgeSun1996
  1678:             
  1679:             
  1680:               !--------------------------------------------------------------------------------------
  1681:             
  1682:               !
  1683:               ! Checking latitude of departure point
  1684:               !
  1685:               subroutine SLTTLagIntChkDPLon(       &
  1686:                 & SLTTIntHor,                      & ! (in)
  1687:                 & iexmin, iexmax, jexmin, jexmax,  & ! (in)
  1688:                 & x_ExtLon, xyz_DPLon              & ! (in)
  1689:                 & )
  1690:             
  1691:                 !
  1692:                 ! MPI
  1693:                 !
  1694:                 use mpi_wrapper, only : myrank
  1695:                                           ! Number of MPI rank
  1696:             
  1697:                 character(*), intent(in ) :: SLTTIntHor
  1698:                 integer     , intent(in ) :: iexmin
  1699:                 integer     , intent(in ) :: iexmax
  1700:                 integer     , intent(in ) :: jexmin
  1701:                 integer     , intent(in ) :: jexmax
  1702:                 real(DP)    , intent(in ) :: x_ExtLon(iexmin:iexmax)
  1703:                                           ! 緯度の拡張配列
  1704:                                           ! Extended array of Lat
  1705:                 real(DP)    , intent(in ) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
  1706:                                           ! 上流点の緯度
  1707:                                           ! Lat of departure point
  1708:             
  1709:                 !
  1710:                 ! local variables
  1711:                 !
  1712:                 integer :: iedge
  1713:             
  1714:                 integer :: i
  1715:                 integer :: j
  1716:                 integer :: k
  1717:             
  1718:             
  1719:                 select case (SLTTIntHor)
  1720:                 case ("HQ")
  1721:                   ! 方向分離型2次元変則エルミート5次補間;  2D Hermite quintic interpolation
  1722:             
  1723: +------>          do k = 1, kmax
  1724: |+----->            do j = 1, jmax/2
  1725: ||+---->              do i = 0, imax-1
  1726: |||                     iedge = iexmin + 1
  1727: |||                     if ( xyz_DPLon(i,j,k) < x_ExtLon(iedge) ) then
  1728: |||                       call MessageNotify( 'E', module_name, &
  1729: |||                         & 'Departure point is out of range of an extended array for longitudinal direction : Rank %d, %f < %f.', &
  1730: |||                         & i = (/ myrank /), &
  1731: |||                         & d = (/ xyz_DPLon(i,j,k), x_ExtLon(iedge) /) )
  1732: |||                     end if
  1733: |||                     iedge = iexmax - 1
  1734: |||                     if ( xyz_DPLon(i,j,k) > x_ExtLon(iedge) ) then
  1735: |||                       call MessageNotify( 'E', module_name, &
  1736: |||                         & 'Departure point is out of range of an extended array for longitudinal direction : Rank %d, %f > %f.', &
  1737: |||                         & i = (/ myrank /), &
  1738: |||                         & d = (/ xyz_DPLon(i,j,k), x_ExtLon(iedge) /) )
  1739: |||                     end if
  1740: ||+----               end do
  1741: |+-----             end do
  1742: +------           end do
  1743:             
  1744:                 end select
  1745:             
  1746:             
  1747:               end subroutine SLTTLagIntChkDPLon
  1748:             
  1749:               !----------------------------------------------------------------------------
  1750:               !
  1751:               ! Checking latitude of departure point
  1752:               !
  1753:               subroutine SLTTLagIntChkDPLat(       &
  1754:                 & SLTTIntHor,                      & ! (in)
  1755:                 & iexmin, iexmax, jexmin, jexmax,  & ! (in)
  1756:                 & y_ExtLat, xyz_DPLat              & ! (in)
  1757:                 & )
  1758:             
  1759:                 !
  1760:                 ! MPI
  1761:                 !
  1762:                 use mpi_wrapper, only : myrank
  1763:                                           ! Number of MPI rank
  1764:             
  1765:                 character(*), intent(in ) :: SLTTIntHor
  1766:                 integer     , intent(in ) :: iexmin
  1767:                 integer     , intent(in ) :: iexmax
  1768:                 integer     , intent(in ) :: jexmin
  1769:                 integer     , intent(in ) :: jexmax
  1770:                 real(DP)    , intent(in ) :: y_ExtLat(jexmin:jexmax)
  1771:                                           ! 緯度の拡張配列
  1772:                                           ! Extended array of Lat
  1773:                 real(DP)    , intent(in ) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
  1774:                                           ! 上流点の緯度
  1775:                                           ! Lat of departure point
  1776:             
  1777:                 !
  1778:                 ! local variables
  1779:                 !
  1780:                 integer :: jedge
  1781:             
  1782:                 integer :: i
  1783:                 integer :: j
  1784:                 integer :: k
  1785:             
  1786:             
  1787:                 select case (SLTTIntHor)
  1788:                 case ("HQ")
  1789:                   ! 方向分離型2次元変則エルミート5次補間;  2D Hermite quintic interpolation
  1790:             
  1791: +------>          do k = 1, kmax
  1792: |+----->            do j = 1, jmax/2
  1793: ||+---->              do i = 0, imax-1
  1794: |||                     jedge = jexmin + 1
  1795: |||                     if ( xyz_DPLat(i,j,k) < y_ExtLat(jedge) ) then
  1796: |||                       call MessageNotify( 'E', module_name, &
  1797: |||                         & 'Departure point is out of range of an extended array for latitudinal direction : Rank %d, %f < %f.', &
  1798: |||                         & i = (/ myrank /), &
  1799: |||                         & d = (/ xyz_DPLat(i,j,k), y_ExtLat(jedge) /) )
  1800: |||                     end if
  1801: |||                     jedge = jexmax - 1
  1802: |||                     if ( xyz_DPLat(i,j,k) > y_ExtLat(jedge) ) then
  1803: |||                       call MessageNotify( 'E', module_name, &
  1804: |||                         & 'Departure point is out of range of an extended array for latitudinal direction : Rank %d, %f > %f.', &
  1805: |||                         & i = (/ myrank /), &
  1806: |||                         & d = (/ xyz_DPLat(i,j,k), y_ExtLat(jedge) /) )
  1807: |||                     end if
  1808: ||+----               end do
  1809: |+-----             end do
  1810: +------           end do
  1811:             
  1812:                 end select
  1813:             
  1814:             
  1815:               end subroutine SLTTLagIntChkDPLat
  1816:             
  1817:               !----------------------------------------------------------------------------
  1818:             
  1819:             end module sltt_lagint
