Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:35 2016
FILE NAME: sltt_const.f90
PROGRAM NAME: sltt_const
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  module sltt_const
     2    !
     3    != セミラグランジュ法 で用いる定数
     4    !
     5    != Constants for Semi-Lagrangian method
     6    !
     7  
     8    ! 種別型パラメタ
     9    ! Kind type parameter
    10    !
    11    use dc_types, only: DP    ! 倍精度実数型. Double precision.
    12  
    13    ! メッセージ出力
    14    ! Message output
    15    !
    16    use dc_message, only: MessageNotify
    17  
    18    ! 格子点設定
    19    ! Grid points settings
    20    !
    21    use gridset, only:       &
    22      &                imax, & ! 経度格子点数.
    23                               ! Number of grid points in longitude
    24      &                jmax, & ! 緯度格子点数.
    25                               ! Number of grid points in latitude
    26      &                kmax, & ! 鉛直層数.
    27                               ! Number of vertical level
    28      &                jmax_global
    29  
    30    ! 宣言文 ; Declaration statements
    31    !
    32    implicit none
    33    private
    34  
    35    ! 公開手続き
    36    ! Public procedure
    37    !
    38    public :: SLTTConstInit
    39  
    40  
    41    ! 公開変数
    42    ! Public variables
    43    !
    44  !!$  public :: jew !, dtjw
    45    public :: dtjw
    46    public :: iexmin
    47    public :: iexmax
    48    public :: jexmin
    49    public :: jexmax
    50    public :: jmaxh
    51    public :: jexglobalmin
    52    public :: jexglobalmax
    53    public :: Pix2, PIH
    54    public :: nloop_dp_h, nloop_dp_v
    55  
    56  
    57    !
    58    ! local variables
    59    !
    60    ! Set minimum and maximu indices for south-north separate extended arrays
    61    !
    62    integer, save :: iexmin
    63    integer, save :: iexmax
    64    integer, save :: jexmin
    65    integer, save :: jexmax
    66    integer, save :: jmaxh
    67    integer, save :: jexglobalmin
    68    integer, save :: jexglobalmax
    69  
    70    !
    71    ! jew : latitudinal edge width
    72    !     : jew >= 4 and dtjw (dtjw is defined below)
    73    !     : In the current version of implimented semi-Lagrangian scheme,
    74    !     : the lower limit of jew is 4, which is restricted by the number of
    75    !     : latitudinal grids needed to estimate values at poles.
    76    !
    77  !!$  integer, parameter         :: jew = 3
    78    !
    79    ! dtiw : data transfer longitudinal grid width
    80    ! dtjw : data transfer latitudinal grid width
    81  !!$  !      : int( C * 2 ) + 3 <= mpjwidth <= jmax and jew
    82  !!$  !      : The mpjwidth must be less than jmax and jew, which is defined
    83  !!$  !      : above.
    84  !!$  !      : The lower limit of mpjwidth is 3, if the Courant number is
    85  !!$  !      :                      less than 0.5.
    86  !!$  !      : The lower limit of mpjwidth is 4, if the Courant number is
    87  !!$  !      : greater than 0.5 and less than 1.
    88  !!$  !      : The lower limit of mpjwidth is 5, if the Courant number is
    89  !!$  !      : greater than 1   and less than 1.5.
    90  !!$  !      : (But now, if the Courant number is greater than 0.5, this
    91  !!$  !      : routine would stop in sltt_dp_h and sltt_hiq routines.)
    92  !!$  !
    93  !!$  integer, parameter         :: dtiw = 2
    94  !!$  integer, parameter         :: dtjw = 2
    95  !!$  integer, parameter         :: dtiw = 3
    96  !!$  integer, parameter         :: dtjw = 3
    97    integer, save         :: dtiw
    98    integer, save         :: dtjw
    99  
   100    real(DP), save             :: PIx2, PIH
   101  
   102  
   103    integer, save              :: nloop_dp_h = 4
   104    integer, save              :: nloop_dp_v = 4
   105  
   106  
   107    ! 非公開変数
   108    ! Private variables
   109    !
   110    logical, save :: sltt_const_inited = .false.
   111                                ! 初期設定フラグ.
   112                                ! Initialization flag
   113  
   114  
   115  
   116    character(*), parameter:: module_name = 'sltt_const'
   117                                ! モジュールの名称.
   118                                ! Module name
   119    character(*), parameter:: version = &
   120      & '$Name:  $' // &
   121      & '$Id: sltt_const.f90,v 1.2 2013/01/27 11:26:14 yot Exp $'
   122                                ! モジュールのバージョン
   123                                ! Module version
   124  
   125  
   126    !--------------------------------------------------------------------------------------
   127  
   128  contains
   129  
   130    !--------------------------------------------------------------------------------------
   131  
   132    subroutine SLTTConstInit
   133  
   134      ! 種別型パラメタ
   135      ! Kind type parameter
   136      !
   137      use dc_types, only: &
   138        & STDOUT              ! 標準出力の装置番号. Unit number of standard output
   139  
   140      ! NAMELIST ファイル入力に関するユーティリティ
   141      ! Utilities for NAMELIST file input
   142      !
   143      use namelist_util, only: namelist_filename, NmlutilMsg
   144  
   145      ! ファイル入出力補助
   146      ! File I/O support
   147      !
   148      use dc_iounit, only: FileOpen
   149  
   150      use gridset    , only : jmax
   151      use mpi_wrapper, only : nprocs, myrank
   152      use constants0 , only : PI
   153  
   154      !
   155      ! local variables
   156      !
   157  
   158      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   159                                ! Unit number for NAMELIST file open
   160      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   161                                ! IOSTAT of NAMELIST read
   162  
   163      ! NAMELIST 変数群
   164      ! NAMELIST group name
   165      !
   166      namelist /sltt_const_nml/ &
   167        & dtiw, &
   168        & dtjw
   169            !
   170            ! デフォルト値については初期化手続 "sltt_const#SLTTConstInit"
   171            ! のソースコードを参照のこと.
   172            !
   173            ! Refer to source codes in the initialization procedure
   174            ! "sltt_const#SLTTConstInit" for the default values.
   175            !
   176  
   177  
   178      ! 実行文 ; Executable statement
   179      !
   180  
   181      if ( sltt_const_inited ) return
   182  
   183  
   184      ! デフォルト値の設定
   185      ! Default values settings
   186      !
   187      dtiw = 2
   188      dtjw = 2
   189  
   190  
   191      ! NAMELIST の読み込み
   192      ! NAMELIST is input
   193      !
   194      if ( trim(namelist_filename) /= '' ) then
   195        call FileOpen( unit_nml, &          ! (out)
   196          & namelist_filename, mode = 'r' ) ! (in)
   197  
   198        rewind( unit_nml )
   199        read( unit_nml, &            ! (in)
   200          & nml = sltt_const_nml, &  ! (out)
   201          & iostat = iostat_nml )    ! (out)
   202        close( unit_nml )
   203  
   204        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   205        if ( iostat_nml == 0 ) write( STDOUT, nml = sltt_const_nml )
   206      end if
   207  
   208  
   209      PIx2 = PI + PI
   210      PIH  = PI / 2.0_DP
   211  
   212  !!$    if( jew > jmax/2 ) then
   213  !!$      write( 6, * ) "SLTT ERROR : MYRANK = ", myrank, &
   214  !!$        " JEW = ", jew, " JMAX/2 = ", jmax/2
   215  !!$      write( 6, * ) "SLTT ERROR : JEW MUST BE LESS THAN JMAX."
   216  !!$      stop
   217  !!$    end if
   218  
   219  !!$    if( nprocs > 1 ) then
   220  !!$      if( jmax/2 < dtjw ) then
   221  !!$        write( 6, * ) "SLTT ERROR : MYRANK = ", myrank, &
   222  !!$          " JMAX/2 = ", jmax/2, " TRANSFERED J WIDTH = ", dtjw
   223  !!$        write( 6, * ) "SLTT ERROR : JMAX MUST BE GREATER THAN TRANSFERED J WIDTH."
   224  !!$        stop
   225  !!$      end if
   226  !!$    end if
   227  
   228  
   229      ! Set minimum and maximu indices for south-north separate extended arrays
   230  !!$    iexmin = -2          ! width of halo region of dtjw
   231  !!$    iexmax = imax-1+1+2  ! 1 for 360 longitude and width of halo region of dtjw
   232  !!$    if ( myrank == (nprocs-1) ) then
   233  !!$      jexmins = -dtjw          ! minimum j of southern array
   234  !!$      jexmaxs = jmax/2+dtjw    ! maximum j of southern array
   235  !!$      jexminn = -dtjw+1        ! maximum j of northern array
   236  !!$      jexmaxn = jmax/2+1+dtjw  ! maximum j of northern array
   237  !!$    else
   238  !!$      jexmins = -dtjw+1        ! minimum j of southern array
   239  !!$      jexmaxs = jmax/2+dtjw    ! maximum j of southern array
   240  !!$      jexminn = -dtjw+1        ! maximum j of northern array
   241  !!$      jexmaxn = jmax/2+dtjw    ! maximum j of northern array
   242  !!$    end if
   243  
   244      jmaxh = jmax/2
   245  
   246      iexmin = 0-dtiw         ! width of halo region of dtiw
   247      iexmax = imax-1+dtiw    ! 1 for 360 longitude and width of halo region of dtiw
   248      jexmin = -dtjw+1        ! minimum j of southern array
   249      jexmax = jmaxh+dtjw     ! maximum j of southern array
   250  
   251      jexglobalmin = -dtjw+1
   252      jexglobalmax = jmax_global+dtjw
   253  
   254  
   255      ! 印字 ; Print
   256      !
   257      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   258      call MessageNotify( 'M', module_name, '  dtiw = %d', i = (/ dtiw /) )
   259      call MessageNotify( 'M', module_name, '  dtjw = %d', i = (/ dtjw /) )
   260      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   261  
   262  
   263      sltt_const_inited = .true.
   264  
   265    end subroutine SLTTConstInit
   266  
   267    !--------------------------------------------------------------------------------------
   268  
   269  end module sltt_const
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:35 2016
FILE NAME: sltt_const.f90
PROGRAM NAME: sltt_const
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             module sltt_const
     2:               !
     3:               != セミラグランジュ法 で用いる定数
     4:               !
     5:               != Constants for Semi-Lagrangian method
     6:               !
     7:             
     8:               ! 種別型パラメタ
     9:               ! Kind type parameter
    10:               !
    11:               use dc_types, only: DP    ! 倍精度実数型. Double precision.
    12:             
    13:               ! メッセージ出力
    14:               ! Message output
    15:               !
    16:               use dc_message, only: MessageNotify
    17:             
    18:               ! 格子点設定
    19:               ! Grid points settings
    20:               !
    21:               use gridset, only:       &
    22:                 &                imax, & ! 経度格子点数.
    23:                                          ! Number of grid points in longitude
    24:                 &                jmax, & ! 緯度格子点数.
    25:                                          ! Number of grid points in latitude
    26:                 &                kmax, & ! 鉛直層数.
    27:                                          ! Number of vertical level
    28:                 &                jmax_global
    29:             
    30:               ! 宣言文 ; Declaration statements
    31:               !
    32:               implicit none
    33:               private
    34:             
    35:               ! 公開手続き
    36:               ! Public procedure
    37:               !
    38:               public :: SLTTConstInit
    39:             
    40:             
    41:               ! 公開変数
    42:               ! Public variables
    43:               !
    44:             !!$  public :: jew !, dtjw
    45:               public :: dtjw
    46:               public :: iexmin
    47:               public :: iexmax
    48:               public :: jexmin
    49:               public :: jexmax
    50:               public :: jmaxh
    51:               public :: jexglobalmin
    52:               public :: jexglobalmax
    53:               public :: Pix2, PIH
    54:               public :: nloop_dp_h, nloop_dp_v
    55:             
    56:             
    57:               !
    58:               ! local variables
    59:               !
    60:               ! Set minimum and maximu indices for south-north separate extended arrays
    61:               !
    62:               integer, save :: iexmin
    63:               integer, save :: iexmax
    64:               integer, save :: jexmin
    65:               integer, save :: jexmax
    66:               integer, save :: jmaxh
    67:               integer, save :: jexglobalmin
    68:               integer, save :: jexglobalmax
    69:             
    70:               !
    71:               ! jew : latitudinal edge width
    72:               !     : jew >= 4 and dtjw (dtjw is defined below)
    73:               !     : In the current version of implimented semi-Lagrangian scheme, 
    74:               !     : the lower limit of jew is 4, which is restricted by the number of
    75:               !     : latitudinal grids needed to estimate values at poles. 
    76:               !
    77:             !!$  integer, parameter         :: jew = 3
    78:               !
    79:               ! dtiw : data transfer longitudinal grid width
    80:               ! dtjw : data transfer latitudinal grid width
    81:             !!$  !      : int( C * 2 ) + 3 <= mpjwidth <= jmax and jew
    82:             !!$  !      : The mpjwidth must be less than jmax and jew, which is defined 
    83:             !!$  !      : above.
    84:             !!$  !      : The lower limit of mpjwidth is 3, if the Courant number is
    85:             !!$  !      :                      less than 0.5. 
    86:             !!$  !      : The lower limit of mpjwidth is 4, if the Courant number is
    87:             !!$  !      : greater than 0.5 and less than 1. 
    88:             !!$  !      : The lower limit of mpjwidth is 5, if the Courant number is
    89:             !!$  !      : greater than 1   and less than 1.5. 
    90:             !!$  !      : (But now, if the Courant number is greater than 0.5, this 
    91:             !!$  !      : routine would stop in sltt_dp_h and sltt_hiq routines.)
    92:             !!$  !
    93:             !!$  integer, parameter         :: dtiw = 2
    94:             !!$  integer, parameter         :: dtjw = 2
    95:             !!$  integer, parameter         :: dtiw = 3
    96:             !!$  integer, parameter         :: dtjw = 3
    97:               integer, save         :: dtiw
    98:               integer, save         :: dtjw
    99:             
   100:               real(DP), save             :: PIx2, PIH
   101:             
   102:             
   103:               integer, save              :: nloop_dp_h = 4
   104:               integer, save              :: nloop_dp_v = 4
   105:             
   106:             
   107:               ! 非公開変数
   108:               ! Private variables
   109:               !
   110:               logical, save :: sltt_const_inited = .false.
   111:                                           ! 初期設定フラグ.
   112:                                           ! Initialization flag
   113:             
   114:             
   115:             
   116:               character(*), parameter:: module_name = 'sltt_const'
   117:                                           ! モジュールの名称.
   118:                                           ! Module name
   119:               character(*), parameter:: version = &
   120:                 & '$Name:  $' // &
   121:                 & '$Id: sltt_const.f90,v 1.2 2013/01/27 11:26:14 yot Exp $'
   122:                                           ! モジュールのバージョン
   123:                                           ! Module version
   124:             
   125:             
   126:               !--------------------------------------------------------------------------------------
   127:             
   128:             contains
   129:             
   130:               !--------------------------------------------------------------------------------------
   131:             
   132:               subroutine SLTTConstInit
   133:             
   134:                 ! 種別型パラメタ
   135:                 ! Kind type parameter
   136:                 !
   137:                 use dc_types, only: &
   138:                   & STDOUT              ! 標準出力の装置番号. Unit number of standard output
   139:             
   140:                 ! NAMELIST ファイル入力に関するユーティリティ
   141:                 ! Utilities for NAMELIST file input
   142:                 !
   143:                 use namelist_util, only: namelist_filename, NmlutilMsg
   144:             
   145:                 ! ファイル入出力補助
   146:                 ! File I/O support
   147:                 !
   148:                 use dc_iounit, only: FileOpen
   149:             
   150:                 use gridset    , only : jmax
   151:                 use mpi_wrapper, only : nprocs, myrank
   152:                 use constants0 , only : PI
   153:             
   154:                 !
   155:                 ! local variables
   156:                 !
   157:             
   158:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   159:                                           ! Unit number for NAMELIST file open
   160:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   161:                                           ! IOSTAT of NAMELIST read
   162:             
   163:                 ! NAMELIST 変数群
   164:                 ! NAMELIST group name
   165:                 !
   166:                 namelist /sltt_const_nml/ &
   167:                   & dtiw, &
   168:                   & dtjw
   169:                       !
   170:                       ! デフォルト値については初期化手続 "sltt_const#SLTTConstInit"
   171:                       ! のソースコードを参照のこと.
   172:                       !
   173:                       ! Refer to source codes in the initialization procedure
   174:                       ! "sltt_const#SLTTConstInit" for the default values.
   175:                       !
   176:             
   177:             
   178:                 ! 実行文 ; Executable statement
   179:                 !
   180:             
   181:                 if ( sltt_const_inited ) return
   182:             
   183:             
   184:                 ! デフォルト値の設定
   185:                 ! Default values settings
   186:                 !
   187:                 dtiw = 2
   188:                 dtjw = 2
   189:             
   190:             
   191:                 ! NAMELIST の読み込み
   192:                 ! NAMELIST is input
   193:                 !
   194:                 if ( trim(namelist_filename) /= '' ) then
   195:                   call FileOpen( unit_nml, &          ! (out)
   196:                     & namelist_filename, mode = 'r' ) ! (in)
   197:             
   198:                   rewind( unit_nml )
   199:                   read( unit_nml, &            ! (in)
   200:                     & nml = sltt_const_nml, &  ! (out)
   201:                     & iostat = iostat_nml )    ! (out)
   202:                   close( unit_nml )
   203:             
   204:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   205:                   if ( iostat_nml == 0 ) write( STDOUT, nml = sltt_const_nml )
   206:                 end if
   207:             
   208:             
   209:                 PIx2 = PI + PI
   210:                 PIH  = PI / 2.0_DP
   211:             
   212:             !!$    if( jew > jmax/2 ) then
   213:             !!$      write( 6, * ) "SLTT ERROR : MYRANK = ", myrank, &
   214:             !!$        " JEW = ", jew, " JMAX/2 = ", jmax/2
   215:             !!$      write( 6, * ) "SLTT ERROR : JEW MUST BE LESS THAN JMAX."
   216:             !!$      stop
   217:             !!$    end if
   218:             
   219:             !!$    if( nprocs > 1 ) then
   220:             !!$      if( jmax/2 < dtjw ) then
   221:             !!$        write( 6, * ) "SLTT ERROR : MYRANK = ", myrank, &
   222:             !!$          " JMAX/2 = ", jmax/2, " TRANSFERED J WIDTH = ", dtjw
   223:             !!$        write( 6, * ) "SLTT ERROR : JMAX MUST BE GREATER THAN TRANSFERED J WIDTH."
   224:             !!$        stop
   225:             !!$      end if
   226:             !!$    end if
   227:             
   228:             
   229:                 ! Set minimum and maximu indices for south-north separate extended arrays
   230:             !!$    iexmin = -2          ! width of halo region of dtjw
   231:             !!$    iexmax = imax-1+1+2  ! 1 for 360 longitude and width of halo region of dtjw
   232:             !!$    if ( myrank == (nprocs-1) ) then
   233:             !!$      jexmins = -dtjw          ! minimum j of southern array
   234:             !!$      jexmaxs = jmax/2+dtjw    ! maximum j of southern array
   235:             !!$      jexminn = -dtjw+1        ! maximum j of northern array
   236:             !!$      jexmaxn = jmax/2+1+dtjw  ! maximum j of northern array
   237:             !!$    else
   238:             !!$      jexmins = -dtjw+1        ! minimum j of southern array
   239:             !!$      jexmaxs = jmax/2+dtjw    ! maximum j of southern array
   240:             !!$      jexminn = -dtjw+1        ! maximum j of northern array
   241:             !!$      jexmaxn = jmax/2+dtjw    ! maximum j of northern array
   242:             !!$    end if
   243:             
   244:                 jmaxh = jmax/2
   245:             
   246:                 iexmin = 0-dtiw         ! width of halo region of dtiw
   247:                 iexmax = imax-1+dtiw    ! 1 for 360 longitude and width of halo region of dtiw
   248:                 jexmin = -dtjw+1        ! minimum j of southern array
   249:                 jexmax = jmaxh+dtjw     ! maximum j of southern array
   250:             
   251:                 jexglobalmin = -dtjw+1
   252:                 jexglobalmax = jmax_global+dtjw
   253:             
   254:             
   255:                 ! 印字 ; Print
   256:                 !
   257:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   258:                 call MessageNotify( 'M', module_name, '  dtiw = %d', i = (/ dtiw /) )
   259:                 call MessageNotify( 'M', module_name, '  dtjw = %d', i = (/ dtjw /) )
   260:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   261:             
   262:             
   263:                 sltt_const_inited = .true.
   264:             
   265:               end subroutine SLTTConstInit
   266:             
   267:               !--------------------------------------------------------------------------------------
   268:             
   269:             end module sltt_const
