Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:37 2016
FILE NAME: sltt_dp.f90
PROGRAM NAME: sltt_dp
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   143  opt  (1593): Loop nest collapsed into one loop.
   143  vec  (   4): Vectorized array expression.
   143  vec  (  29): ADB is used for array.: xyz_flagestdp
   145  opt  (1592): Outer loop unrolled inside inner loop.
   146  vec  (   1): Vectorized loop.
   146  vec  (  29): ADB is used for array.: xyz_mplatn
   146  vec  (  29): ADB is used for array.: xyz_mplonn
   146  vec  (  29): ADB is used for array.: x_lon
   146  vec  (   1): Vectorized loop.
   146  vec  (  29): ADB is used for array.: xyz_mplatn
   146  vec  (  29): ADB is used for array.: xyz_mplonn
   146  vec  (  29): ADB is used for array.: x_lon
   155  vec  (   3): Unvectorized loop.
   156  opt  (1017): Subroutine call prevents optimization.
   160  opt  (  11): Fused array assignments. :line 160 - 161
   160  opt  (1593): Loop nest collapsed into one loop.
   160  vec  (   4): Vectorized array expression.
   160  vec  (  29): ADB is used for array.: xyz_mplat
   160  vec  (  29): ADB is used for array.: xyz_mplatn
   160  vec  (  29): ADB is used for array.: xyz_mplon
   160  vec  (  29): ADB is used for array.: xyz_mplonn
   176  opt  (1593): Loop nest collapsed into one loop.
   176  vec  (   4): Vectorized array expression.
   176  vec  (  29): ADB is used for array.: xyz_flagestdp
   179  warn (  80): Dummy argument "xyz_dplat" with INTENT(OUT) attribute may be referenced before it is defined.
   179  warn (  80): Dummy argument "xyz_dplon" with INTENT(OUT) attribute may be referenced before it is defined.
   318  opt  (  11): Fused array assignments. :line 318 - 319
   318  opt  (1592): Outer loop unrolled inside inner loop.
   318  vec  (   4): Vectorized array expression.
   318  vec  (  29): ADB is used for array.: xyz_mpv
   318  vec  (  29): ADB is used for array.: xyz_extv
   318  vec  (  29): ADB is used for array.: xyz_mpu
   318  vec  (  29): ADB is used for array.: xyz_extu
   318  vec  (   4): Vectorized array expression.
   318  vec  (  29): ADB is used for array.: xyz_mpv
   318  vec  (  29): ADB is used for array.: xyz_extv
   318  vec  (  29): ADB is used for array.: xyz_mpu
   318  vec  (  29): ADB is used for array.: xyz_extu
   324  opt  (1772): Loop nest fused with following nest(s).
   325  opt  (1590): Inner loop moved outside outer loop(s).
   326  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   326  vec  (   1): Vectorized loop.
   326  vec  (  29): ADB is used for array.: xyz_dplon
   326  vec  (  29): ADB is used for array.: xyz_dplat
   326  vec  (  29): ADB is used for array.: xyz_mpv
   326  vec  (  29): ADB is used for array.: xyz_mplat
   326  vec  (  29): ADB is used for array.: xyz_mpu
   326  vec  (  29): ADB is used for array.: x_aplon
   326  vec  (  29): ADB is used for array.: xyz_flagestdp
   359  warn (  83): Dummy argument "y_apsinlat" is not used.
   359  warn (  82): Name "mpcoslat" is not used.
   359  warn (  83): Dummy argument "y_apcoslat" is not used.
   420  vec  (   3): Unvectorized loop.
   420  vec  (  13): Overhead of loop division is too large.
   421  opt  (1593): Loop nest collapsed into one loop.
   421  vec  (   4): Vectorized array expression.
   429  opt  (1593): Loop nest collapsed into one loop.
   429  vec  (   4): Vectorized array expression.
   429  vec  (  29): ADB is used for array.: xyz_mpsigma
   429  vec  (  29): ADB is used for array.: xyz_mpsigman
   452  vec  (   1): Vectorized loop.
   452  vec  (  29): ADB is used for array.: r_sigma
   453  opt  (1084): Branch out of the loop inhibits optimization.
   453  vec  (  26): Macro operation Search.
   457  vec  (   1): Vectorized loop.
   457  vec  (  29): ADB is used for array.: r_sigma
   458  opt  (1084): Branch out of the loop inhibits optimization.
   458  vec  (  26): Macro operation Search.
   468  opt  (1772): Loop nest fused with following nest(s).
   470  vec  (   1): Vectorized loop.
   470  vec  (  29): ADB is used for array.: xyz_mpsigmadot
   470  vec  (  29): ADB is used for array.: xyr_sigmadot
   470  vec  (  29): ADB is used for array.: xyza_lcifz
   470  vec  (  29): ADB is used for array.: r_sigma
   470  vec  (  29): ADB is used for array.: xyz_mpsigma
   470  vec  (  29): ADB is used for array.: xyz_kk
   508  opt  (1057): Complicated use of variable inhibits loop optimization.
   519  vec  (   3): Unvectorized loop.
   519  vec  (  13): Overhead of loop division is too large.
   520  opt  (1593): Loop nest collapsed into one loop.
   520  vec  (   4): Vectorized array expression.
   520  vec  (  29): ADB is used for array.: xyz_mpsigmadot
   522  opt  (1593): Loop nest collapsed into one loop.
   522  vec  (   4): Vectorized array expression.
   522  vec  (  29): ADB is used for array.: xyz_mpsigman
   530  vec  (   3): Unvectorized loop.
   530  vec  (  13): Overhead of loop division is too large.
   531  opt  (1593): Loop nest collapsed into one loop.
   531  vec  (   4): Vectorized array expression.
   531  vec  (  29): ADB is used for array.: xyz_dpsigma
   531  vec  (  29): ADB is used for array.: xyz_mpsigmadot
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:37 2016
FILE NAME: sltt_dp.f90
PROGRAM NAME: sltt_dp
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 上流点探索
     2  !
     3  != Finding departure point
     4  !
     5  ! Authors::   Hiroki KASHIMURA, Yoshiyuki O. TAKAHASHI
     6  ! Version::
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2013. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  
    13  module sltt_dp
    14    !
    15    != 上流点探索
    16    !
    17    != Finding Departure Point
    18    !
    19    ! <b>Note that Japanese and English are described in parallel.</b>
    20    !
    21    !== Procedures List
    22    !
    23    ! SLTTDPHor     :: 水平方向の上流点探索
    24    ! SLTTDPVer     :: 鉛直方向の上流点探索
    25    ! ---------------------     :: ------------
    26    ! SLTTDPHor     :: Finding DP in Horizontal
    27    ! SLTTDPVer     :: Finding DP in Vertical
    28    !
    29    !== NAMELIST
    30    !
    31    ! NAMELIST#
    32    !
    33    !== References
    34    ! * Williamson, D. L., and Rasch, P. J., 1989:
    35    !   Two-dimensional semi-Lagrangian transport with shape-preserving interpolation.
    36    !   <i> Mon. Wea. Rev.</i>, <b>117</b>, 102-129.
    37  
    38  
    39    ! 種別型パラメタ
    40    ! Kind type parameter
    41    !
    42    use dc_types, only: DP    ! 倍精度実数型. Double precision.
    43  
    44    ! 格子点設定
    45    ! Grid points settings
    46    !
    47    use gridset, only:       &
    48      &                imax, & ! 経度格子点数.
    49                               ! Number of grid points in longitude
    50      &                jmax, & ! 緯度格子点数.
    51                               ! Number of grid points in latitude
    52      &                kmax !, & ! 鉛直層数.
    53                               ! Number of vertical level
    54  
    55    implicit none
    56  
    57    private
    58  
    59    public :: SLTTDPHor
    60    public :: SLTTDPVer
    61  
    62  contains
    63  
    64    !--------------------------------------------------------------------------------------
    65  
    66    subroutine SLTTDPHor(                           &
    67      & DelTime, x_Lon, y_Lat, y_SinLat, y_CosLat,  & ! (in)
    68      & iexmin, iexmax, jexmin, jexmax,             & ! (in)
    69      & x_ExtLon, y_ExtLat, xyz_ExtU, xyz_ExtV,     & ! (in)
    70      & xyz_DPLon, xyz_DPLat                        & ! (out)
    71      & )
    72      ! 水平方向の上流点探索
    73      ! Finding DP in Horizontal
    74  
    75      use sltt_const, only : PIx2, dtjw, nloop_dp_h
    76  
    77  
    78      real(DP), intent(in ) :: DelTime
    79                                ! $\Delta t$
    80      real(DP), intent(in ) :: x_Lon(0:imax-1)
    81                                ! $\lambda$ longitude
    82      real(DP), intent(in ) :: y_Lat(1:jmax/2)
    83                                ! $\varphi$ latitude
    84      real(DP), intent(in ) :: y_SinLat(1:jmax/2)
    85                                ! $\sin\varphi$
    86      real(DP), intent(in ) :: y_CosLat(1:jmax/2)
    87                                ! $\cos\varphi$
    88      integer , intent(in ) :: iexmin
    89      integer , intent(in ) :: iexmax
    90      integer , intent(in ) :: jexmin
    91      integer , intent(in ) :: jexmax
    92      real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
    93                                ! 経度の拡張配列
    94                                ! Extended array of Lon
    95      real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
    96                                ! 緯度の拡張配列
    97                                ! Extended array of Lat
    98      real(DP), intent(in ) :: xyz_ExtU(iexmin:iexmax, jexmin:jexmax, 1:kmax)
    99                                ! 東西風速の拡張配列
   100                                ! Extended array of zonal velocity
   101      real(DP), intent(in ) :: xyz_ExtV(iexmin:iexmax, jexmin:jexmax, 1:kmax)
   102                                ! 南北風速の拡張配列
   103                                ! Extended array of meridional velocity
   104      real(DP), intent(out) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
   105                                ! 上流点の経度
   106                                ! Lon of departure point
   107      real(DP), intent(out) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
   108                                ! 上流点の緯度
   109                                ! Lat of departure point
   110  
   111      !
   112      ! local variables
   113      !
   114      real(DP) :: xyz_MPLon (0:imax-1, 1:jmax/2, 1:kmax)
   115                                ! 中間点の経度
   116                                ! Lon of mid-point
   117      real(DP) :: xyz_MPLat (0:imax-1, 1:jmax/2, 1:kmax)
   118                                ! 中間点の緯度
   119                                ! Lat of mid-point
   120      real(DP) :: xyz_MPLonN(0:imax-1, 1:jmax/2, 1:kmax)
   121                                ! 中間点の経度（現在推定値）
   122                                ! Lon of mid-point (temporal estimation)
   123      real(DP) :: xyz_MPLatN(0:imax-1, 1:jmax/2, 1:kmax)
   124                                ! 中間点の緯度（現在推定値）
   125                                ! Lat of mid-point (now)
   126      logical  :: FlagWindInt   ! 初期化フラッグ
   127                                ! Flag for initialization
   128      logical  :: xyz_FlagEstDP(0:imax-1, 1:jmax/2, 1:kmax)
   129  
   130      integer:: i               ! 東西方向に回る DO ループ用作業変数
   131                                ! Work variables for DO loop in zonal direction
   132      integer:: j               ! 南北方向に回る DO ループ用作業変数
   133                                ! Work variables for DO loop in meridional direction
   134      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   135                                ! Work variables for DO loop in vertical direction
   136      integer :: t              ! 推定回数の DO ループ用作業変数
   137                                ! Work variables for DO loop for DP estimation
   138  
   139  
   140      ! 初期化処理
   141      ! initialization
   142      !
   143      xyz_FlagEstDP = .true.
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t269 = 1, xyz_flagestdp.DSC.U3*(xyz_flagestdp.DSC.U2*          
     .       1   xyz_flagestdp.DSC.U1 + xyz_flagestdp.DSC.U2)                   
     .           xyz_flagestdp(t269-1,1,1) = 1                                  
     .        enddo                                                             
   144      do k = 1, kmax
   145        do j = 1, jmax/2
   146          do i = 0, imax-1
   147            xyz_MPLonN(i,j,k) = x_Lon(i)
   148            xyz_MPLatN(i,j,k) = y_Lat(j)
   149          end do
   150        end do
     .        if (jmax/2 .gt. 0) then                                           
     .           j1 = and(jmax/2,3)                                             
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(x_lon)                                               
     .              do i = 1, imax                                              
     .                 xyz_mplonn(i-1,j,k) = x_lon(i-1)                         
     .                 xyz_mplatn(i-1,j,k) = y_lat(j)                           
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax/2, 4                                       
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(x_lon)                                               
     .              do i = 1, imax                                              
     .                 xyz_mplonn(i-1,j,k) = x_lon(i-1)                         
     .                 xyz_mplonn(i-1,j+1,k) = x_lon(i-1)                       
     .                 xyz_mplonn(i-1,j+2,k) = x_lon(i-1)                       
     .                 xyz_mplonn(i-1,j+3,k) = x_lon(i-1)                       
     .                 xyz_mplatn(i-1,j,k) = y_lat(j)                           
     .                 xyz_mplatn(i-1,j+1,k) = y_lat(j+1)                       
     .                 xyz_mplatn(i-1,j+2,k) = y_lat(j+2)                       
     .                 xyz_mplatn(i-1,j+3,k) = y_lat(j+3)                       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   151      end do
   152  
   153  
   154      FlagWindInt = .false.
   155      mp_search_loop : do t = 1, nloop_dp_h
   156        if( mod( t, 5 ) .eq. 0 ) &
   157          & write( 6, * ) "### Loop for searching departure points : ", t
   158  
   159  
   160        xyz_MPLon = xyz_MPLonN
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t278 = 1, xyz_mplon.DSC.U3*(xyz_mplon.DSC.U2*xyz_mplon.DSC.U1  
     .       1    + xyz_mplon.DSC.U2)                                           
     .           xyz_mplon(t278-1,1,1) = xyz_mplonn(t278-1,1,1)                 
     .           xyz_mplat(t278-1,1,1) = xyz_mplatn(t278-1,1,1)                 
     .        enddo                                                             
   161        xyz_MPLat = xyz_MPLatN
   162  
   163  
   164        call SLTTDPHorCore(                                                   &
   165          & DelTime, x_Lon, y_Lat, y_SinLat, y_CosLat,                        & ! (in)
   166          & iexmin, iexmax, jexmin, jexmax,                                   & ! (in)
   167          & x_ExtLon, y_ExtLat, xyz_ExtU, xyz_ExtV, xyz_MPLon, xyz_MPLat,     & ! (in)
   168          & xyz_MPLonN, xyz_MPLatN,                                           & ! (inout)
   169          & xyz_FlagEstDP, FlagWindInt                                        & ! (in)
   170          & )
   171        FlagWindInt = .true.
   172  
   173  
   174      end do mp_search_loop
   175  
   176      xyz_FlagEstDP = .true.
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t296 = 1, xyz_flagestdp.DSC.U3*(xyz_flagestdp.DSC.U2*          
     .       1   xyz_flagestdp.DSC.U1 + xyz_flagestdp.DSC.U2)                   
     .           xyz_flagestdp(t296-1,1,1) = 1                                  
     .        enddo                                                             
   177      FlagWindInt   = .true.
   178  
   179      call SLTTDPHorCore(                                                   &
   180        & 2.0_DP * DelTime, x_Lon, y_Lat, y_SinLat, y_CosLat,               & ! (in)
   181        & iexmin, iexmax, jexmin, jexmax,                                   & ! (in)
   182        & x_ExtLon, y_ExtLat, xyz_ExtU, xyz_ExtV, xyz_MPLon, xyz_MPLat,     & ! (in)
   183        & xyz_DPLon, xyz_DPLat,                                             & ! (inout)
   184        & xyz_FlagEstDP, FlagWindInt                                        & ! (in)
   185        & )
   186  
   187  
   188    end subroutine SLTTDPHor
   189  
   190    !--------------------------------------------------------------------------------------
   191  
   192    subroutine SLTTDPHorCore(                                             &
   193      & DelTime, x_APLon, y_APLat, y_APSinLat, y_APCosLat,                & ! (in)
   194      & iexmin, iexmax, jexmin, jexmax,                                   & ! (in)
   195      & x_ExtLon, y_ExtLat, xyz_ExtU, xyz_ExtV, xyz_MPLon, xyz_MPLat,     & ! (in)
   196      & xyz_DPLon, xyz_DPLat,                                             & ! (inout)
   197      & xyz_FlagEstDP, FlagWindInt                                        & ! (in)
   198      & )
   199      ! 水平方向の上流点探索のコア部分
   200      ! Finding DP in Horizontal (Core)
   201  
   202      use constants0 , only : PI
   203      use constants  , only : RPlanet
   204      use mpi_wrapper, only : myrank
   205      use sltt_const , only : PIx2, PIH
   206      use sltt_lagint, only : &
   207        & SLTTLagIntCubCalcFactHor , SLTTLagIntCubIntHor
   208  
   209  
   210      real(DP), intent(in   ) :: DelTime
   211                                ! $\Delta t$
   212      real(DP), intent(in   ) :: x_APLon(0:imax-1)
   213                                ! 到着点（グリッド上）の経度
   214                                ! Lon of arrival point (which is on grid)
   215      real(DP), intent(in   ) :: y_APLat(1:jmax/2 )
   216                                ! 到着点（グリッド上）の緯度
   217                                ! Lat of arrival point (which is on grid)
   218      real(DP), intent(in   ) :: y_APSinLat(1:jmax/2)
   219                                ! 到着点の sin(緯度)
   220                                ! sin(lat) of arrival point
   221      real(DP), intent(in   ) :: y_APCosLat(1:jmax/2)
   222                                ! 到着点の cos(緯度)
   223                                ! cos(lat) of arrival point
   224      integer , intent(in   ) :: iexmin
   225      integer , intent(in   ) :: iexmax
   226      integer , intent(in   ) :: jexmin
   227      integer , intent(in   ) :: jexmax
   228      real(DP), intent(in   ) :: x_ExtLon(iexmin:iexmax)
   229                                ! 経度の拡張配列
   230                                ! Extended array of Lon
   231      real(DP), intent(in   ) :: y_ExtLat(jexmin:jexmax)
   232                                ! 緯度の拡張配列
   233                                ! Extended array of Lat
   234      real(DP), intent(in   ) :: xyz_ExtU(iexmin:iexmax, jexmin:jexmax, 1:kmax)
   235                                ! 東西風速の拡張配列
   236                                ! Extended array of zonal wind
   237      real(DP), intent(in   ) :: xyz_ExtV(iexmin:iexmax, jexmin:jexmax, 1:kmax)
   238                                ! 南北風速の拡張配列
   239                                ! Extended array of meridional wind
   240      real(DP), intent(in   ) :: xyz_MPLon(0:imax-1, 1:jmax/2, 1:kmax)
   241                                ! 中間点の経度
   242                                ! Lon of mid-point
   243      real(DP), intent(in   ) :: xyz_MPLat(0:imax-1, 1:jmax/2, 1:kmax)
   244                                ! 中間点の緯度
   245                                ! Lat of mid-point
   246      real(DP), intent(inout) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
   247                                ! 上流点の経度
   248                                ! Lon of departure point
   249      real(DP), intent(inout) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
   250                                ! 上流点の緯度
   251                                ! Lat of departure point
   252      logical , intent(in   ) :: xyz_FlagEstDP(0:imax-1, 1:jmax/2, 1:kmax)
   253                                ! 上流点探索のフラグ
   254                                ! Flag for finding departure point
   255      logical , intent(in   ) :: FlagWindInt
   256                                ! 初回フラグ
   257                                ! Initial flag
   258  
   259      !
   260      ! local variables
   261      !
   262      real(DP) :: xyz_MPU(0:imax-1, 1:jmax/2, 1:kmax)
   263                                ! 中間点の東西風速
   264                                ! Zonal wind at mid-point
   265      real(DP) :: xyz_MPV(0:imax-1, 1:jmax/2, 1:kmax)
   266                                ! 中間点の南北風速
   267                                ! Meridional wind at mid-point
   268      real(DP) :: MPCosLat      ! 中間点のcos(lat)
   269                                ! cos(lat) at mid-point
   270  
   271      real(DP) :: xyza_lcifx(0:imax-1, 1:jmax/2, 1:kmax, -1:2)
   272      real(DP) :: xyza_lcify(0:imax-1, 1:jmax/2, 1:kmax, -1:2)
   273      integer :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   274      integer :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   275                                ! ラグランジュ補間のための作業変数
   276                                ! Working variables for Lagrange interpolation
   277  
   278  
   279      integer:: i               ! 東西方向に回る DO ループ用作業変数
   280                                ! Work variables for DO loop in zonal direction
   281      integer:: j               ! 南北方向に回る DO ループ用作業変数
   282                                ! Work variables for DO loop in meridional direction
   283      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   284  
   285      real(DP) :: InvRPlanet
   286  
   287  
   288      InvRPlanet = 1.0_DP/RPlanet
   289  
   290  
   291      if( FlagWindInt ) then
   292  
   293        ! ラグランジュ３次補間
   294        ! Cubic interpolation
   295        call SLTTLagIntCubCalcFactHor(                    &
   296          & iexmin, iexmax, jexmin, jexmax,               & ! (in)
   297          & x_ExtLon, y_ExtLat, xyz_MPLon, xyz_MPLat,     & ! (in)
   298          & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify        & ! (out)
   299          & )
   300        ! 中間点の風速推定
   301        ! estimating wind velocities at mid-point
   302        !
   303        call SLTTLagIntCubIntHor(                             &
   304          & iexmin, iexmax, jexmin, jexmax,                   & ! (in)
   305          & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify, xyz_ExtU, & ! (in)
   306          & xyz_MPU                                           & ! (out)
   307          & )
   308        call SLTTLagIntCubIntHor(                             &
   309          & iexmin, iexmax, jexmin, jexmax,                   & ! (in)
   310          & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify, xyz_ExtV, & ! (in)
   311          & xyz_MPV                                           & ! (out)
   312          & )
   313      else
   314  
   315        !
   316        ! 推定風速の更新
   317        !
   318        xyz_MPU(0:imax-1,1:jmax/2,:) = xyz_ExtU(0:imax-1,1:jmax/2,:)
     .        if (jmax/2 .gt. 0) then                                           
     .           j1 = and(jmax/2,3)                                             
     .  !cdir    nodep                                                          
     .           do t433 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t435 = 1, imax                                           
     .                 xyz_mpu(t435-1,t433,t431+1)=xyz_extu(t435-1,t433,t431+1) 
     .                 xyz_mpv(t435-1,t433,t431+1)=xyz_extv(t435-1,t433,t431+1) 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t433 = j1 + 1, jmax/2, 4                                    
     .  !cdir       nodep                                                       
     .              do t435 = 1, imax                                           
     .                 xyz_mpu(t435-1,t433,t431+1)=xyz_extu(t435-1,t433,t431+1) 
     .                 xyz_mpu(t435-1,t433+1,t431+1) = xyz_extu(t435-1,t433+1,  
     .       1            t431+1)                                               
     .                 xyz_mpu(t435-1,t433+2,t431+1) = xyz_extu(t435-1,t433+2,  
     .       1            t431+1)                                               
     .                 xyz_mpu(t435-1,t433+3,t431+1) = xyz_extu(t435-1,t433+3,  
     .       1            t431+1)                                               
     .                 xyz_mpv(t435-1,t433,t431+1)=xyz_extv(t435-1,t433,t431+1) 
     .                 xyz_mpv(t435-1,t433+1,t431+1) = xyz_extv(t435-1,t433+1,  
     .       1            t431+1)                                               
     .                 xyz_mpv(t435-1,t433+2,t431+1) = xyz_extv(t435-1,t433+2,  
     .       1            t431+1)                                               
     .                 xyz_mpv(t435-1,t433+3,t431+1) = xyz_extv(t435-1,t433+3,  
     .       1            t431+1)                                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   319        xyz_MPV(0:imax-1,1:jmax/2,:) = xyz_ExtV(0:imax-1,1:jmax/2,:)
   320  
   321      end if
   322  
   323  
   324      do k = 1, kmax
   325        do j = 1, jmax/2
   326          do i = 0, imax-1
   327  
   328            if( xyz_FlagEstDP(i,j,k) ) then
   329  
   330  !            MPCosLat = cos( xyz_MPLat(i,j,k) )
   331              xyz_DPLon(i,j,k) = x_APLon(i) &
   332                & - DelTime * xyz_MPU(i,j,k) / cos( xyz_MPLat(i,j,k) ) * InvRPlanet !/ RPlanet
   333              xyz_DPLat(i,j,k) = y_APLat(j) &
   334                & - DelTime * xyz_MPV(i,j,k)* InvRPlanet ! / RPlanet
   335  
   336            end if
   337  
   338          end do
   339        end do
   340      end do
   341  
   342      ! 普通の緯度経度の範囲に直す
   343      do k = 1, kmax
   344        do j = 1, jmax/2
   345          do i = 0, imax-1
   346            if( xyz_DPLat(i,j,k) < -PIH ) then
   347              xyz_DPLon(i,j,k) = xyz_DPLon(i,j,k) + PI
   348              xyz_DPLat(i,j,k) = -PIH + ( -PIH - xyz_DPLat(i,j,k) )
   349            else if( xyz_DPLat(i,j,k) > PIH ) then
   350              xyz_DPLon(i,j,k) = xyz_DPLon(i,j,k) + PI
   351              xyz_DPLat(i,j,k) = PIH - ( xyz_DPLat(i,j,k) - PIH )
   352            end if
   353            xyz_DPLon(i,j,k) = mod( xyz_DPLon(i,j,k) + PIx2, PIx2 )
   354          end do
   355        end do
   356      end do
     .  !cdir noassume                                                          
     .        do i1 = 0, imax - 1, maxvl()                                      
     .           i2 = min0(imax - i1,maxvl())                                   
     .           do j = 1, jmax/2                                               
     .              do k = 1, kmax                                              
     .                 d2 = 1.D0/pix2                                           
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(x_aplon)                                          
     .                 do i = 1, i2                                             
     .                    xyz_dplon1 = xyz_dplon(i1+i-1,j,k)                    
     .                    if (xyz_flagestdp(i1+i-1,j,k) .ne. 0) then            
     .                       xyz_dplon1 = x_aplon(i1+i-1) - deltime*xyz_mpu(i1+i
     .       1                  -1,j,k)/dcos(xyz_mplat(i1+i-1,j,k))*invrplanet  
     .                       xyz_dplat(i1+i-1,j,k) = y_aplat(j) - deltime*      
     .       1                  xyz_mpv(i1+i-1,j,k)*invrplanet                  
     .                    endif                                                 
     .                    if (xyz_dplat(i1+i-1,j,k) .lt. (-pih)) then           
     .                       xyz_dplon1 = xyz_dplon1 + 3.14159265358979e+000    
     .                       xyz_dplat(i1+i-1,j,k) = (-pih) - xyz_dplat(i1+i-1,j
     .       1                  ,k) - pih                                       
     .                    else                                                  
     .                       if (xyz_dplat(i1+i-1,j,k) .gt. pih) then           
     .                          xyz_dplon1 = xyz_dplon1 + 3.14159265358979e+000 
     .                          xyz_dplat(i1+i-1,j,k) = pih - (xyz_dplat(i1+i-1,
     .       1                     j,k)-pih)                                    
     .                       endif                                              
     .                    endif                                                 
     .                    t406 = cvmgt(dfloat(ifix(((xyz_dplon1 + pix2)/pix2))),
     .       1               ((xyz_dplon1 + pix2)/pix2),abs(((xyz_dplon1 + pix2)
     .       2               *d2)).lt.9.00719925474099e+015)                    
     .                    xyz_dplon(i1+i-1,j,k)=(xyz_dplon1+pix2)-t406*pix2     
     .                 enddo                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
   357  
   358  
   359    end subroutine SLTTDPHorCore
   360  
   361    !--------------------------------------------------------------------------------------
   362  
   363    subroutine SLTTDPVer(      &
   364      & DelTime, xyr_SigmaDot, &
   365      & xyz_DPSigma            &
   366      & )
   367      ! 鉛直方向の上流点探索
   368      ! Finding DP in Vertical
   369  
   370      ! 座標データ設定
   371      ! Axes data settings
   372      !
   373      use axesset, only : r_Sigma, z_Sigma
   374  
   375      use sltt_const, only : nloop_dp_v
   376  
   377  
   378      real(DP), intent(in ) :: DelTime
   379                                ! $\Delta t$
   380      real(DP), intent(in ) :: xyr_SigmaDot(0:imax-1, 1:jmax, 0:kmax)
   381                                ! 鉛直流速（SigmaDot）
   382      real(DP), intent(out) :: xyz_DPSigma (0:imax-1, 1:jmax, 1:kmax)
   383                                ! 上流点高度
   384                                ! Sigma of the departure point
   385  
   386  
   387      !
   388      ! local variables
   389      !
   390      real(DP) :: xyz_MPSigma   (0:imax-1, 1:jmax, 1:kmax)
   391                                ! 中間点の高度
   392                                ! Sigma of mid-point
   393      real(DP) :: xyz_MPSigmaN  (0:imax-1, 1:jmax, 1:kmax)
   394                                ! 中間点の高度（現在推定値）
   395                                ! Lat of mid-point (temporal estimation)
   396      real(DP) :: xyz_MPSigmaDot(0:imax-1, 1:jmax, 1:kmax)
   397                                ! 中間点のSigmaDot
   398                                ! SigmaDot of mid-point
   399      real(DP) :: xyza_lcifz(0:imax-1, 1:jmax, 1:kmax, -1:2)
   400                                ! ラグランジュ補間のための作業変数
   401                                ! Work variable for Lagrange interpolation
   402      integer :: xyz_kk(0:imax-1, 1:jmax, 1:kmax)
   403                                ! ラグランジュ補間のための作業変数
   404                                ! Work variable for Lagrange interpolation
   405  
   406  
   407      integer:: i               ! 東西方向に回る DO ループ用作業変数
   408                                ! Work variables for DO loop in zonal direction
   409      integer:: j               ! 南北方向に回る DO ループ用作業変数
   410                                ! Work variables for DO loop in meridional direction
   411      integer:: k, kk, k2       ! 鉛直方向に回る DO ループ用作業変数
   412                                ! Work variables for DO loop in vertical direction
   413      integer :: t              ! 推定回数の DO ループ用作業変数
   414                                ! Work variables for DO loop for DP estimation
   415  
   416  
   417      ! 初期化処理
   418      ! initialization
   419      !
   420      do k = 1, kmax
   421        xyz_MPSigmaN(:,:,k) = z_Sigma(k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t723 = 1, xyz_mpsigman.DSC.U2*xyz_mpsigman.DSC.U1 +            
     .       1   xyz_mpsigman.DSC.U2                                            
     .           xyz_mpsigman(t723-1,1,k) = z_sigma(k)                          
     .        enddo                                                             
   422      end do
   423  
   424      ! 上流点推定のループ
   425      ! Loop for finding departure point
   426      mp_search_loop : do t = 1, nloop_dp_v
   427  
   428  
   429        xyz_MPSigma = xyz_MPSigmaN
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_mpsigman,xyz_mpsigma)                                  
     .        do t729 = 1, xyz_mpsigma.DSC.U3*(xyz_mpsigma.DSC.U2*              
     .       1   xyz_mpsigma.DSC.U1 + xyz_mpsigma.DSC.U2)                       
     .           xyz_mpsigma(t729-1,1,1) = xyz_mpsigman(t729-1,1,1)             
     .        enddo                                                             
   430  
   431  
   432        ! 中間点の鉛直流速をラグランジュ３次補間で求める
   433        ! vertical wind velocity at mid-point is estimated by using Lagrange cubic
   434        ! interpolation
   435        !
   436        do k = 1, kmax
   437          do j = 1, jmax
   438            do i = 0, imax-1
   439  
   440              !
   441              ! Routine for dcpam
   442              !
   443              ! Departure points, xyz_MPSigma(:,:,k), must be located between
   444              ! r_Sigma(kk) > xyz_MPSigma(k) > r_Sigma(kk+1).
   445              ! Further, 1 <= kk <= kmax-2.
   446              !
   447  
   448              !
   449              ! economical method
   450              !
   451              if( xyz_MPSigma(i,j,k) > r_Sigma(k) ) then
   452                k_search_1 : do k2 = k, 1, -1
   453                  if( r_Sigma(k2) > xyz_MPSigma(i,j,k) ) exit k_search_1
   454                end do k_search_1
   455                xyz_kk(i,j,k) = k2
   456              else
   457                k_search_2 : do k2 = min( k+1, kmax ), kmax
   458                  if( r_Sigma(k2) < xyz_MPSigma(i,j,k) ) exit k_search_2
   459                end do k_search_2
   460                xyz_kk(i,j,k) = k2 - 1
   461              end if
   462              xyz_kk(i,j,k) = min( max( xyz_kk(i,j,k), 1 ), kmax-2 )
   463  
   464            end do
   465          end do
   466        end do
   467        !
   468        do k = 1, kmax
   469          do j = 1, jmax
   470            do i = 0, imax-1
   471              kk = xyz_kk(i,j,k)
   472              xyza_lcifz(i,j,k,-1) =                         &
   473                &     ( xyz_MPSigma(i,j,k) - r_Sigma(kk  ) ) &
   474                &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+1) ) &
   475                &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+2) ) &
   476                & / ( ( r_Sigma(kk-1) - r_Sigma(kk  ) )      &
   477                &   * ( r_Sigma(kk-1) - r_Sigma(kk+1) )      &
   478                &   * ( r_Sigma(kk-1) - r_Sigma(kk+2) ) )
   479              xyza_lcifz(i,j,k, 0) =                         &
   480                &     ( xyz_MPSigma(i,j,k) - r_Sigma(kk-1) ) &
   481                &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+1) ) &
   482                &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+2) ) &
   483                & / ( ( r_Sigma(kk  ) - r_Sigma(kk-1) )      &
   484                &   * ( r_Sigma(kk  ) - r_Sigma(kk+1) )      &
   485                &   * ( r_Sigma(kk  ) - r_Sigma(kk+2) ) )
   486              xyza_lcifz(i,j,k, 1) =                         &
   487                &     ( xyz_MPSigma(i,j,k) - r_Sigma(kk-1) ) &
   488                &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk  ) ) &
   489                &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+2) ) &
   490                & / ( ( r_Sigma(kk+1) - r_Sigma(kk-1) )      &
   491                &   * ( r_Sigma(kk+1) - r_Sigma(kk  ) )      &
   492                &   * ( r_Sigma(kk+1) - r_Sigma(kk+2) ) )
   493              xyza_lcifz(i,j,k, 2) =                         &
   494                &     ( xyz_MPSigma(i,j,k) - r_Sigma(kk-1) ) &
   495                &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk  ) ) &
   496                &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+1) ) &
   497                & / ( ( r_Sigma(kk+2) - r_Sigma(kk-1) )      &
   498                &   * ( r_Sigma(kk+2) - r_Sigma(kk  ) )      &
   499                &   * ( r_Sigma(kk+2) - r_Sigma(kk+1) ) )
   500            end do
   501          end do
   502        end do
   503        !
   504        do k = 1, kmax
   505          do j = 1, jmax
   506            do i = 0, imax-1
   507              kk = xyz_kk(i,j,k)
   508              xyz_MPSigmaDot(i,j,k) =                             &
   509                &   xyza_lcifz(i,j,k,-1) * xyr_SigmaDot(i,j,kk-1) &
   510                & + xyza_lcifz(i,j,k, 0) * xyr_SigmaDot(i,j,kk  ) &
   511                & + xyza_lcifz(i,j,k, 1) * xyr_SigmaDot(i,j,kk+1) &
   512                & + xyza_lcifz(i,j,k, 2) * xyr_SigmaDot(i,j,kk+2)
   513            end do
   514          end do
   515        end do
     .        do k = 1, kmax                                                    
     .           do j = 1, jmax                                                 
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_mpsigma,xyz_kk,xyza_lcifz,xyz_mpsigmadot)        
     .              do i = 1, imax                                              
     .                 kk = xyz_kk(i-1,j,k)                                     
     .                 xyza_lcifz(i-1,j,k,-1) = (xyz_mpsigma(i-1,j,k)-(r_sigma( 
     .       1            kk)))*(xyz_mpsigma(i-1,j,k)-r_sigma(kk+1))*(          
     .       2            xyz_mpsigma(i-1,j,k)-r_sigma(kk+2))/((r_sigma(kk-1)-( 
     .       3            r_sigma(kk)))*(r_sigma(kk-1)-r_sigma(kk+1))*(r_sigma( 
     .       4            kk-1)-r_sigma(kk+2)))                                 
     .                 xyza_lcifz(i-1,j,k,0) = (xyz_mpsigma(i-1,j,k)-r_sigma(kk-
     .       1            1))*(xyz_mpsigma(i-1,j,k)-r_sigma(kk+1))*(xyz_mpsigma(
     .       2            i-1,j,k)-r_sigma(kk+2))/(((r_sigma(kk))-r_sigma(kk-1))
     .       3            *((r_sigma(kk))-r_sigma(kk+1))*((r_sigma(kk))-r_sigma(
     .       4            kk+2)))                                               
     .                 xyza_lcifz(i-1,j,k,1) = (xyz_mpsigma(i-1,j,k)-r_sigma(kk-
     .       1            1))*(xyz_mpsigma(i-1,j,k)-(r_sigma(kk)))*(xyz_mpsigma(
     .       2            i-1,j,k)-r_sigma(kk+2))/((r_sigma(kk+1)-r_sigma(kk-1))
     .       3            *(r_sigma(kk+1)-(r_sigma(kk)))*(r_sigma(kk+1)-r_sigma(
     .       4            kk+2)))                                               
     .                 xyza_lcifz(i-1,j,k,2) = (xyz_mpsigma(i-1,j,k)-r_sigma(kk-
     .       1            1))*(xyz_mpsigma(i-1,j,k)-(r_sigma(kk)))*(xyz_mpsigma(
     .       2            i-1,j,k)-r_sigma(kk+1))/((r_sigma(kk+2)-r_sigma(kk-1))
     .       3            *(r_sigma(kk+2)-(r_sigma(kk)))*(r_sigma(kk+2)-r_sigma(
     .       4            kk+1)))                                               
     .                 xyz_mpsigmadot(i-1,j,k) = xyza_lcifz(i-1,j,k,-1)*        
     .       1            xyr_sigmadot(i-1,j,xyz_kk(i-1,j,k)-1) + xyza_lcifz(i-1
     .       2            ,j,k,0)*xyr_sigmadot(i-1,j,xyz_kk(i-1,j,k)) +         
     .       3            xyza_lcifz(i-1,j,k,1)*xyr_sigmadot(i-1,j,xyz_kk(i-1,j,
     .       4            k)+1) + xyza_lcifz(i-1,j,k,2)*xyr_sigmadot(i-1,j,     
     .       5            xyz_kk(i-1,j,k)+2)                                    
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
   516  
   517  
   518  
   519        do k = 1, kmax
   520          xyz_MPSigmaN(:,:,k) = z_Sigma(k) - xyz_MPSigmaDot(:,:,k) * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_mpsigmadot)                                            
     .        do t741 = 1, xyz_mpsigmadot.DSC.U2*xyz_mpsigmadot.DSC.U1 +        
     .       1   xyz_mpsigmadot.DSC.U2                                          
     .           xyz_mpsigman(t741-1,1,k) = z_sigma(k) - xyz_mpsigmadot(t741-1,1
     .       1      ,k)*deltime                                                 
     .        enddo                                                             
   521        end do
   522        xyz_MPSigmaN = min( max( xyz_MPSigmaN, r_Sigma(kmax) ), r_Sigma(0) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_mpsigman)                                              
     .        do t749 = 1, xyz_mpsigman.DSC.U3*(xyz_mpsigman.DSC.U2*            
     .       1   xyz_mpsigman.DSC.U1 + xyz_mpsigman.DSC.U2)                     
     .           xyz_mpsigman(t749-1,1,1) = min(max(xyz_mpsigman(t749-1,1,1),   
     .       1      r_sigma(kmax)),r_sigma(0))                                  
     .        enddo                                                             
   523  
   524  
   525      end do mp_search_loop
   526  
   527      ! 上流点高度の推定
   528      ! estimating departure point
   529      !
   530      do k = 1, kmax
   531        xyz_DPSigma(:,:,k) = z_Sigma(k) - xyz_MPSigmaDot(:,:,k) * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_mpsigmadot)                                            
     .        do t761 = 1, xyz_mpsigmadot.DSC.U2*xyz_mpsigmadot.DSC.U1 +        
     .       1   xyz_mpsigmadot.DSC.U2                                          
     .           xyz_dpsigma(t761-1,1,k) = z_sigma(k) - xyz_mpsigmadot(t761-1,1,
     .       1      k)*2.00000000000000e+000*deltime                            
     .        enddo                                                             
   532      end do
   533  
   534  
   535    end subroutine SLTTDPVer
   536  
   537  
   538  end module sltt_dp
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:37 2016
FILE NAME: sltt_dp.f90
PROGRAM NAME: sltt_dp
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 上流点探索
     2:             !
     3:             != Finding departure point
     4:             !
     5:             ! Authors::   Hiroki KASHIMURA, Yoshiyuki O. TAKAHASHI
     6:             ! Version::   
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2013. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             
    13:             module sltt_dp
    14:               !
    15:               != 上流点探索
    16:               !
    17:               != Finding Departure Point
    18:               !
    19:               ! <b>Note that Japanese and English are described in parallel.</b>
    20:               !
    21:               !== Procedures List
    22:               !
    23:               ! SLTTDPHor     :: 水平方向の上流点探索
    24:               ! SLTTDPVer     :: 鉛直方向の上流点探索
    25:               ! ---------------------     :: ------------
    26:               ! SLTTDPHor     :: Finding DP in Horizontal
    27:               ! SLTTDPVer     :: Finding DP in Vertical
    28:               !
    29:               !== NAMELIST
    30:               !
    31:               ! NAMELIST#
    32:               !
    33:               !== References
    34:               ! * Williamson, D. L., and Rasch, P. J., 1989:
    35:               !   Two-dimensional semi-Lagrangian transport with shape-preserving interpolation.
    36:               !   <i> Mon. Wea. Rev.</i>, <b>117</b>, 102-129.
    37:               
    38:             
    39:               ! 種別型パラメタ
    40:               ! Kind type parameter
    41:               !
    42:               use dc_types, only: DP    ! 倍精度実数型. Double precision.
    43:             
    44:               ! 格子点設定
    45:               ! Grid points settings
    46:               !
    47:               use gridset, only:       &
    48:                 &                imax, & ! 経度格子点数.
    49:                                          ! Number of grid points in longitude
    50:                 &                jmax, & ! 緯度格子点数.
    51:                                          ! Number of grid points in latitude
    52:                 &                kmax !, & ! 鉛直層数.
    53:                                          ! Number of vertical level
    54:             
    55:               implicit none
    56:             
    57:               private
    58:             
    59:               public :: SLTTDPHor
    60:               public :: SLTTDPVer
    61:             
    62:             contains
    63:             
    64:               !--------------------------------------------------------------------------------------
    65:             
    66:               subroutine SLTTDPHor(                           &
    67:                 & DelTime, x_Lon, y_Lat, y_SinLat, y_CosLat,  & ! (in)
    68:                 & iexmin, iexmax, jexmin, jexmax,             & ! (in)
    69:                 & x_ExtLon, y_ExtLat, xyz_ExtU, xyz_ExtV,     & ! (in)
    70:                 & xyz_DPLon, xyz_DPLat                        & ! (out)
    71:                 & )
    72:                 ! 水平方向の上流点探索
    73:                 ! Finding DP in Horizontal
    74:             
    75:                 use sltt_const, only : PIx2, dtjw, nloop_dp_h
    76:             
    77:             
    78:                 real(DP), intent(in ) :: DelTime
    79:                                           ! $\Delta t$         
    80:                 real(DP), intent(in ) :: x_Lon(0:imax-1)
    81:                                           ! $\lambda$ longitude 
    82:                 real(DP), intent(in ) :: y_Lat(1:jmax/2)
    83:                                           ! $\varphi$ latitude
    84:                 real(DP), intent(in ) :: y_SinLat(1:jmax/2)
    85:                                           ! $\sin\varphi$
    86:                 real(DP), intent(in ) :: y_CosLat(1:jmax/2)
    87:                                           ! $\cos\varphi$
    88:                 integer , intent(in ) :: iexmin
    89:                 integer , intent(in ) :: iexmax
    90:                 integer , intent(in ) :: jexmin
    91:                 integer , intent(in ) :: jexmax
    92:                 real(DP), intent(in ) :: x_ExtLon(iexmin:iexmax)
    93:                                           ! 経度の拡張配列
    94:                                           ! Extended array of Lon
    95:                 real(DP), intent(in ) :: y_ExtLat(jexmin:jexmax)
    96:                                           ! 緯度の拡張配列
    97:                                           ! Extended array of Lat    
    98:                 real(DP), intent(in ) :: xyz_ExtU(iexmin:iexmax, jexmin:jexmax, 1:kmax)    
    99:                                           ! 東西風速の拡張配列
   100:                                           ! Extended array of zonal velocity
   101:                 real(DP), intent(in ) :: xyz_ExtV(iexmin:iexmax, jexmin:jexmax, 1:kmax)
   102:                                           ! 南北風速の拡張配列
   103:                                           ! Extended array of meridional velocity
   104:                 real(DP), intent(out) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
   105:                                           ! 上流点の経度
   106:                                           ! Lon of departure point
   107:                 real(DP), intent(out) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
   108:                                           ! 上流点の緯度
   109:                                           ! Lat of departure point
   110:             
   111:                 !
   112:                 ! local variables
   113:                 !
   114:                 real(DP) :: xyz_MPLon (0:imax-1, 1:jmax/2, 1:kmax)
   115:                                           ! 中間点の経度
   116:                                           ! Lon of mid-point
   117:                 real(DP) :: xyz_MPLat (0:imax-1, 1:jmax/2, 1:kmax)
   118:                                           ! 中間点の緯度
   119:                                           ! Lat of mid-point
   120:                 real(DP) :: xyz_MPLonN(0:imax-1, 1:jmax/2, 1:kmax)
   121:                                           ! 中間点の経度（現在推定値）
   122:                                           ! Lon of mid-point (temporal estimation)
   123:                 real(DP) :: xyz_MPLatN(0:imax-1, 1:jmax/2, 1:kmax)
   124:                                           ! 中間点の緯度（現在推定値）
   125:                                           ! Lat of mid-point (now)
   126:                 logical  :: FlagWindInt   ! 初期化フラッグ
   127:                                           ! Flag for initialization
   128:                 logical  :: xyz_FlagEstDP(0:imax-1, 1:jmax/2, 1:kmax)
   129:             
   130:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   131:                                           ! Work variables for DO loop in zonal direction
   132:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   133:                                           ! Work variables for DO loop in meridional direction
   134:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   135:                                           ! Work variables for DO loop in vertical direction
   136:                 integer :: t              ! 推定回数の DO ループ用作業変数
   137:                                           ! Work variables for DO loop for DP estimation
   138:             
   139:             
   140:                 ! 初期化処理
   141:                 ! initialization
   142:                 !
   143: W**==== A       xyz_FlagEstDP = .true.
   144: +------>        do k = 1, kmax
   145: |+----->          do j = 1, jmax/2
   146: ||V---->            do i = 0, imax-1
   147: |||     A             xyz_MPLonN(i,j,k) = x_Lon(i)
   148: |||     A             xyz_MPLatN(i,j,k) = y_Lat(j)
   149: ||V----             end do
   150: |+-----           end do
   151: +------         end do
   152:             
   153:             
   154:                 FlagWindInt = .false.
   155: +------>        mp_search_loop : do t = 1, nloop_dp_h
   156: |                 if( mod( t, 5 ) .eq. 0 ) &
   157: |                   & write( 6, * ) "### Loop for searching departure points : ", t
   158: |           
   159: |           
   160: |**W--->A         xyz_MPLon = xyz_MPLonN
   161: |**W--- A         xyz_MPLat = xyz_MPLatN
   162: |           
   163: |           
   164: |                 call SLTTDPHorCore(                                                   &
   165: |                   & DelTime, x_Lon, y_Lat, y_SinLat, y_CosLat,                        & ! (in)
   166: |                   & iexmin, iexmax, jexmin, jexmax,                                   & ! (in)
   167: |                   & x_ExtLon, y_ExtLat, xyz_ExtU, xyz_ExtV, xyz_MPLon, xyz_MPLat,     & ! (in)
   168: |                   & xyz_MPLonN, xyz_MPLatN,                                           & ! (inout)
   169: |                   & xyz_FlagEstDP, FlagWindInt                                        & ! (in)
   170: |                   & )
   171: |                 FlagWindInt = .true.
   172: |           
   173: |           
   174: +------         end do mp_search_loop
   175:             
   176: W**==== A       xyz_FlagEstDP = .true.
   177:                 FlagWindInt   = .true.
   178:             
   179:                 call SLTTDPHorCore(                                                   &
   180:                   & 2.0_DP * DelTime, x_Lon, y_Lat, y_SinLat, y_CosLat,               & ! (in)
   181:                   & iexmin, iexmax, jexmin, jexmax,                                   & ! (in)
   182:                   & x_ExtLon, y_ExtLat, xyz_ExtU, xyz_ExtV, xyz_MPLon, xyz_MPLat,     & ! (in)
   183:                   & xyz_DPLon, xyz_DPLat,                                             & ! (inout)
   184:                   & xyz_FlagEstDP, FlagWindInt                                        & ! (in)
   185:                   & )
   186:             
   187:             
   188:               end subroutine SLTTDPHor
   189:             
   190:               !--------------------------------------------------------------------------------------
   191:             
   192:               subroutine SLTTDPHorCore(                                             &
   193:                 & DelTime, x_APLon, y_APLat, y_APSinLat, y_APCosLat,                & ! (in)
   194:                 & iexmin, iexmax, jexmin, jexmax,                                   & ! (in)
   195:                 & x_ExtLon, y_ExtLat, xyz_ExtU, xyz_ExtV, xyz_MPLon, xyz_MPLat,     & ! (in)
   196:                 & xyz_DPLon, xyz_DPLat,                                             & ! (inout)
   197:                 & xyz_FlagEstDP, FlagWindInt                                        & ! (in)
   198:                 & )
   199:                 ! 水平方向の上流点探索のコア部分
   200:                 ! Finding DP in Horizontal (Core)
   201:             
   202:                 use constants0 , only : PI
   203:                 use constants  , only : RPlanet
   204:                 use mpi_wrapper, only : myrank
   205:                 use sltt_const , only : PIx2, PIH
   206:                 use sltt_lagint, only : &
   207:                   & SLTTLagIntCubCalcFactHor , SLTTLagIntCubIntHor
   208:             
   209:             
   210:                 real(DP), intent(in   ) :: DelTime
   211:                                           ! $\Delta t$    
   212:                 real(DP), intent(in   ) :: x_APLon(0:imax-1)
   213:                                           ! 到着点（グリッド上）の経度
   214:                                           ! Lon of arrival point (which is on grid)
   215:                 real(DP), intent(in   ) :: y_APLat(1:jmax/2 )
   216:                                           ! 到着点（グリッド上）の緯度
   217:                                           ! Lat of arrival point (which is on grid)
   218:                 real(DP), intent(in   ) :: y_APSinLat(1:jmax/2)
   219:                                           ! 到着点の sin(緯度)
   220:                                           ! sin(lat) of arrival point
   221:                 real(DP), intent(in   ) :: y_APCosLat(1:jmax/2)
   222:                                           ! 到着点の cos(緯度)
   223:                                           ! cos(lat) of arrival point    
   224:                 integer , intent(in   ) :: iexmin
   225:                 integer , intent(in   ) :: iexmax
   226:                 integer , intent(in   ) :: jexmin
   227:                 integer , intent(in   ) :: jexmax
   228:                 real(DP), intent(in   ) :: x_ExtLon(iexmin:iexmax)
   229:                                           ! 経度の拡張配列
   230:                                           ! Extended array of Lon
   231:                 real(DP), intent(in   ) :: y_ExtLat(jexmin:jexmax)
   232:                                           ! 緯度の拡張配列
   233:                                           ! Extended array of Lat
   234:                 real(DP), intent(in   ) :: xyz_ExtU(iexmin:iexmax, jexmin:jexmax, 1:kmax)
   235:                                           ! 東西風速の拡張配列
   236:                                           ! Extended array of zonal wind
   237:                 real(DP), intent(in   ) :: xyz_ExtV(iexmin:iexmax, jexmin:jexmax, 1:kmax)
   238:                                           ! 南北風速の拡張配列
   239:                                           ! Extended array of meridional wind
   240:                 real(DP), intent(in   ) :: xyz_MPLon(0:imax-1, 1:jmax/2, 1:kmax)
   241:                                           ! 中間点の経度
   242:                                           ! Lon of mid-point
   243:                 real(DP), intent(in   ) :: xyz_MPLat(0:imax-1, 1:jmax/2, 1:kmax)
   244:                                           ! 中間点の緯度
   245:                                           ! Lat of mid-point
   246:                 real(DP), intent(inout) :: xyz_DPLon(0:imax-1, 1:jmax/2, 1:kmax)
   247:                                           ! 上流点の経度
   248:                                           ! Lon of departure point    
   249:                 real(DP), intent(inout) :: xyz_DPLat(0:imax-1, 1:jmax/2, 1:kmax)
   250:                                           ! 上流点の緯度
   251:                                           ! Lat of departure point    
   252:                 logical , intent(in   ) :: xyz_FlagEstDP(0:imax-1, 1:jmax/2, 1:kmax)
   253:                                           ! 上流点探索のフラグ
   254:                                           ! Flag for finding departure point
   255:                 logical , intent(in   ) :: FlagWindInt
   256:                                           ! 初回フラグ
   257:                                           ! Initial flag
   258:             
   259:                 !
   260:                 ! local variables
   261:                 !
   262:                 real(DP) :: xyz_MPU(0:imax-1, 1:jmax/2, 1:kmax)
   263:                                           ! 中間点の東西風速
   264:                                           ! Zonal wind at mid-point
   265:                 real(DP) :: xyz_MPV(0:imax-1, 1:jmax/2, 1:kmax)
   266:                                           ! 中間点の南北風速
   267:                                           ! Meridional wind at mid-point
   268:                 real(DP) :: MPCosLat      ! 中間点のcos(lat)
   269:                                           ! cos(lat) at mid-point
   270:             
   271:                 real(DP) :: xyza_lcifx(0:imax-1, 1:jmax/2, 1:kmax, -1:2)
   272:                 real(DP) :: xyza_lcify(0:imax-1, 1:jmax/2, 1:kmax, -1:2)
   273:                 integer :: xyz_ii(0:imax-1, 1:jmax/2, 1:kmax)
   274:                 integer :: xyz_jj(0:imax-1, 1:jmax/2, 1:kmax)
   275:                                           ! ラグランジュ補間のための作業変数
   276:                                           ! Working variables for Lagrange interpolation
   277:             
   278:             
   279:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   280:                                           ! Work variables for DO loop in zonal direction
   281:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   282:                                           ! Work variables for DO loop in meridional direction
   283:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   284:             
   285:                 real(DP) :: InvRPlanet 
   286:             
   287:             
   288:                 InvRPlanet = 1.0_DP/RPlanet
   289:             
   290:             
   291:                 if( FlagWindInt ) then
   292:             
   293:                   ! ラグランジュ３次補間
   294:                   ! Cubic interpolation
   295:                   call SLTTLagIntCubCalcFactHor(                    &
   296:                     & iexmin, iexmax, jexmin, jexmax,               & ! (in)
   297:                     & x_ExtLon, y_ExtLat, xyz_MPLon, xyz_MPLat,     & ! (in)
   298:                     & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify        & ! (out)
   299:                     & )
   300:                   ! 中間点の風速推定
   301:                   ! estimating wind velocities at mid-point
   302:                   !
   303:                   call SLTTLagIntCubIntHor(                             &
   304:                     & iexmin, iexmax, jexmin, jexmax,                   & ! (in)
   305:                     & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify, xyz_ExtU, & ! (in)
   306:                     & xyz_MPU                                           & ! (out)
   307:                     & )
   308:                   call SLTTLagIntCubIntHor(                             &
   309:                     & iexmin, iexmax, jexmin, jexmax,                   & ! (in)
   310:                     & xyz_ii, xyz_jj, xyza_lcifx, xyza_lcify, xyz_ExtV, & ! (in)
   311:                     & xyz_MPV                                           & ! (out)
   312:                     & )
   313:                 else
   314:             
   315:                   !
   316:                   ! 推定風速の更新
   317:                   !
   318: **V---->A         xyz_MPU(0:imax-1,1:jmax/2,:) = xyz_ExtU(0:imax-1,1:jmax/2,:)
   319: **V---- A         xyz_MPV(0:imax-1,1:jmax/2,:) = xyz_ExtV(0:imax-1,1:jmax/2,:)
   320:             
   321:                 end if
   322:             
   323:             
   324: +------>        do k = 1, kmax
   325: |+----->          do j = 1, jmax/2
   326: ||V---->A           do i = 0, imax-1
   327: |||         
   328: |||     A             if( xyz_FlagEstDP(i,j,k) ) then
   329: |||         
   330: |||         !            MPCosLat = cos( xyz_MPLat(i,j,k) )
   331: |||     A               xyz_DPLon(i,j,k) = x_APLon(i) &
   332: |||                       & - DelTime * xyz_MPU(i,j,k) / cos( xyz_MPLat(i,j,k) ) * InvRPlanet !/ RPlanet
   333: |||     A               xyz_DPLat(i,j,k) = y_APLat(j) &
   334: |||                       & - DelTime * xyz_MPV(i,j,k)* InvRPlanet ! / RPlanet
   335: |||         
   336: |||                   end if
   337: |||         
   338: |||                 end do
   339: |||               end do
   340: |||             end do
   341: |||         
   342: |||             ! 普通の緯度経度の範囲に直す
   343: |||             do k = 1, kmax
   344: |||               do j = 1, jmax/2
   345: |||                 do i = 0, imax-1
   346: |||                   if( xyz_DPLat(i,j,k) < -PIH ) then
   347: |||                     xyz_DPLon(i,j,k) = xyz_DPLon(i,j,k) + PI
   348: |||                     xyz_DPLat(i,j,k) = -PIH + ( -PIH - xyz_DPLat(i,j,k) )
   349: |||                   else if( xyz_DPLat(i,j,k) > PIH ) then
   350: |||                     xyz_DPLon(i,j,k) = xyz_DPLon(i,j,k) + PI
   351: |||                     xyz_DPLat(i,j,k) = PIH - ( xyz_DPLat(i,j,k) - PIH )
   352: |||                   end if
   353: |||                   xyz_DPLon(i,j,k) = mod( xyz_DPLon(i,j,k) + PIx2, PIx2 )
   354: ||V----             end do
   355: |+-----           end do
   356: +------         end do
   357:             
   358:             
   359:               end subroutine SLTTDPHorCore
   360:             
   361:               !--------------------------------------------------------------------------------------
   362:             
   363:               subroutine SLTTDPVer(      &
   364:                 & DelTime, xyr_SigmaDot, &
   365:                 & xyz_DPSigma            &
   366:                 & )
   367:                 ! 鉛直方向の上流点探索
   368:                 ! Finding DP in Vertical
   369:             
   370:                 ! 座標データ設定
   371:                 ! Axes data settings
   372:                 !
   373:                 use axesset, only : r_Sigma, z_Sigma
   374:             
   375:                 use sltt_const, only : nloop_dp_v
   376:             
   377:             
   378:                 real(DP), intent(in ) :: DelTime
   379:                                           ! $\Delta t$
   380:                 real(DP), intent(in ) :: xyr_SigmaDot(0:imax-1, 1:jmax, 0:kmax)
   381:                                           ! 鉛直流速（SigmaDot）    
   382:                 real(DP), intent(out) :: xyz_DPSigma (0:imax-1, 1:jmax, 1:kmax)
   383:                                           ! 上流点高度
   384:                                           ! Sigma of the departure point        
   385:             
   386:             
   387:                 !
   388:                 ! local variables
   389:                 !
   390:                 real(DP) :: xyz_MPSigma   (0:imax-1, 1:jmax, 1:kmax)
   391:                                           ! 中間点の高度
   392:                                           ! Sigma of mid-point
   393:                 real(DP) :: xyz_MPSigmaN  (0:imax-1, 1:jmax, 1:kmax)
   394:                                           ! 中間点の高度（現在推定値）
   395:                                           ! Lat of mid-point (temporal estimation)
   396:                 real(DP) :: xyz_MPSigmaDot(0:imax-1, 1:jmax, 1:kmax)
   397:                                           ! 中間点のSigmaDot
   398:                                           ! SigmaDot of mid-point
   399:                 real(DP) :: xyza_lcifz(0:imax-1, 1:jmax, 1:kmax, -1:2)
   400:                                           ! ラグランジュ補間のための作業変数
   401:                                           ! Work variable for Lagrange interpolation
   402:                 integer :: xyz_kk(0:imax-1, 1:jmax, 1:kmax)
   403:                                           ! ラグランジュ補間のための作業変数
   404:                                           ! Work variable for Lagrange interpolation
   405:                 
   406:             
   407:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   408:                                           ! Work variables for DO loop in zonal direction
   409:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   410:                                           ! Work variables for DO loop in meridional direction
   411:                 integer:: k, kk, k2       ! 鉛直方向に回る DO ループ用作業変数
   412:                                           ! Work variables for DO loop in vertical direction
   413:                 integer :: t              ! 推定回数の DO ループ用作業変数
   414:                                           ! Work variables for DO loop for DP estimation
   415:             
   416:             
   417:                 ! 初期化処理
   418:                 ! initialization
   419:                 !
   420: +------>        do k = 1, kmax
   421: |W*====           xyz_MPSigmaN(:,:,k) = z_Sigma(k)
   422: +------         end do
   423:             
   424:                 ! 上流点推定のループ
   425:                 ! Loop for finding departure point
   426: +------>        mp_search_loop : do t = 1, nloop_dp_v
   427: |           
   428: |           
   429: |W**=== A         xyz_MPSigma = xyz_MPSigmaN
   430: |           
   431: |           
   432: |                 ! 中間点の鉛直流速をラグランジュ３次補間で求める 
   433: |                 ! vertical wind velocity at mid-point is estimated by using Lagrange cubic 
   434: |                 ! interpolation
   435: |                 !
   436: |+----->          do k = 1, kmax
   437: ||+---->            do j = 1, jmax
   438: |||+--->              do i = 0, imax-1
   439: ||||        
   440: ||||                    !
   441: ||||                    ! Routine for dcpam
   442: ||||                    !
   443: ||||                    ! Departure points, xyz_MPSigma(:,:,k), must be located between 
   444: ||||                    ! r_Sigma(kk) > xyz_MPSigma(k) > r_Sigma(kk+1).
   445: ||||                    ! Further, 1 <= kk <= kmax-2.
   446: ||||                    !
   447: ||||        
   448: ||||                    !
   449: ||||                    ! economical method
   450: ||||                    !
   451: ||||                    if( xyz_MPSigma(i,j,k) > r_Sigma(k) ) then
   452: ||||V-->                  k_search_1 : do k2 = k, 1, -1
   453: |||||   A                   if( r_Sigma(k2) > xyz_MPSigma(i,j,k) ) exit k_search_1
   454: ||||V--                   end do k_search_1
   455: ||||                      xyz_kk(i,j,k) = k2
   456: ||||                    else
   457: ||||V-->                  k_search_2 : do k2 = min( k+1, kmax ), kmax
   458: |||||   A                   if( r_Sigma(k2) < xyz_MPSigma(i,j,k) ) exit k_search_2
   459: ||||V--                   end do k_search_2
   460: ||||                      xyz_kk(i,j,k) = k2 - 1
   461: ||||                    end if
   462: ||||                    xyz_kk(i,j,k) = min( max( xyz_kk(i,j,k), 1 ), kmax-2 )
   463: ||||        
   464: |||+---               end do
   465: ||+----             end do
   466: |+-----           end do
   467: |                 !
   468: |+----->          do k = 1, kmax
   469: ||+---->            do j = 1, jmax
   470: |||V--->              do i = 0, imax-1
   471: ||||    A               kk = xyz_kk(i,j,k)
   472: ||||    A               xyza_lcifz(i,j,k,-1) =                         &
   473: ||||                      &     ( xyz_MPSigma(i,j,k) - r_Sigma(kk  ) ) &
   474: ||||                      &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+1) ) &
   475: ||||                      &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+2) ) &
   476: ||||                      & / ( ( r_Sigma(kk-1) - r_Sigma(kk  ) )      &
   477: ||||                      &   * ( r_Sigma(kk-1) - r_Sigma(kk+1) )      &
   478: ||||                      &   * ( r_Sigma(kk-1) - r_Sigma(kk+2) ) )
   479: ||||    A               xyza_lcifz(i,j,k, 0) =                         &
   480: ||||                      &     ( xyz_MPSigma(i,j,k) - r_Sigma(kk-1) ) &
   481: ||||                      &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+1) ) &
   482: ||||                      &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+2) ) &
   483: ||||                      & / ( ( r_Sigma(kk  ) - r_Sigma(kk-1) )      &
   484: ||||                      &   * ( r_Sigma(kk  ) - r_Sigma(kk+1) )      &
   485: ||||                      &   * ( r_Sigma(kk  ) - r_Sigma(kk+2) ) )
   486: ||||    A               xyza_lcifz(i,j,k, 1) =                         &
   487: ||||                      &     ( xyz_MPSigma(i,j,k) - r_Sigma(kk-1) ) &
   488: ||||                      &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk  ) ) &
   489: ||||                      &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+2) ) &
   490: ||||                      & / ( ( r_Sigma(kk+1) - r_Sigma(kk-1) )      &
   491: ||||                      &   * ( r_Sigma(kk+1) - r_Sigma(kk  ) )      &
   492: ||||                      &   * ( r_Sigma(kk+1) - r_Sigma(kk+2) ) )
   493: ||||    A               xyza_lcifz(i,j,k, 2) =                         &
   494: ||||                      &     ( xyz_MPSigma(i,j,k) - r_Sigma(kk-1) ) &
   495: ||||                      &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk  ) ) &
   496: ||||                      &   * ( xyz_MPSigma(i,j,k) - r_Sigma(kk+1) ) &
   497: ||||                      & / ( ( r_Sigma(kk+2) - r_Sigma(kk-1) )      &
   498: ||||                      &   * ( r_Sigma(kk+2) - r_Sigma(kk  ) )      &
   499: ||||                      &   * ( r_Sigma(kk+2) - r_Sigma(kk+1) ) )
   500: ||||                  end do
   501: ||||                end do
   502: ||||              end do
   503: ||||              !
   504: ||||              do k = 1, kmax
   505: ||||                do j = 1, jmax
   506: ||||                  do i = 0, imax-1
   507: ||||                    kk = xyz_kk(i,j,k)
   508: ||||                    xyz_MPSigmaDot(i,j,k) =                             &
   509: ||||                      &   xyza_lcifz(i,j,k,-1) * xyr_SigmaDot(i,j,kk-1) &
   510: ||||                      & + xyza_lcifz(i,j,k, 0) * xyr_SigmaDot(i,j,kk  ) &
   511: ||||                      & + xyza_lcifz(i,j,k, 1) * xyr_SigmaDot(i,j,kk+1) &
   512: ||||                      & + xyza_lcifz(i,j,k, 2) * xyr_SigmaDot(i,j,kk+2)
   513: |||V---               end do
   514: ||+----             end do
   515: |+-----           end do
   516: |           
   517: |           
   518: |           
   519: |+----->          do k = 1, kmax
   520: ||W*=== A           xyz_MPSigmaN(:,:,k) = z_Sigma(k) - xyz_MPSigmaDot(:,:,k) * DelTime
   521: |+-----           end do
   522: |W**=== A         xyz_MPSigmaN = min( max( xyz_MPSigmaN, r_Sigma(kmax) ), r_Sigma(0) )
   523: |           
   524: |           
   525: +------         end do mp_search_loop
   526:             
   527:                 ! 上流点高度の推定
   528:                 ! estimating departure point
   529:                 !
   530: +------>        do k = 1, kmax
   531: |W*==== A         xyz_DPSigma(:,:,k) = z_Sigma(k) - xyz_MPSigmaDot(:,:,k) * 2.0_DP * DelTime
   532: +------         end do
   533:             
   534:             
   535:               end subroutine SLTTDPVer
   536:             
   537:             
   538:             end module sltt_dp
