Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:51 2016
FILE NAME: i.sosi_dynamics.F90
PROGRAM NAME: sosi_dynamics
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   425  opt  (1593): Loop nest collapsed into one loop.
   425  vec  (   4): Vectorized array expression.
   425  vec  (  29): ADB is used for array.: xy_flagslabocean
   428  opt  (1593): Loop nest collapsed into one loop.
   428  vec  (   1): Vectorized loop.
   428  vec  (  29): ADB is used for array.: xy_flagslabocean
   428  vec  (  29): ADB is used for array.: xy_surftype
   454  opt  (  11): Fused array assignments. :line 454 - 455
   454  opt  (1593): Loop nest collapsed into one loop.
   454  vec  (   4): Vectorized array expression.
   454  vec  (  29): ADB is used for array.: xy_soseaicemass
   456  opt  (1593): Loop nest collapsed into one loop.
   456  vec  (   4): Vectorized array expression.
   456  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   462  opt  (1593): Loop nest collapsed into one loop.
   462  vec  (   4): Vectorized array expression.
   462  vec  (  29): ADB is used for array.: xy_soseaicethickness
   462  vec  (  29): ADB is used for array.: xy_soseaicemass
   473  opt  (1593): Loop nest collapsed into one loop.
   473  vec  (   1): Vectorized loop.
   473  vec  (  29): ADB is used for array.: xy_surftemp
   473  vec  (  29): ADB is used for array.: xy_soseaicemass
   486  vec  (   1): Vectorized loop.
   486  vec  (  29): ADB is used for array.: xyz_soseaicetempadv
   486  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   486  vec  (  29): ADB is used for array.: xyz_soseaicethicknessadv
   486  vec  (  29): ADB is used for array.: xyr_sosilocaldepth
   491  vec  (   1): Vectorized loop.
   491  vec  (  29): ADB is used for array.: xyz_soseaicetempadv
   491  vec  (  29): ADB is used for array.: xyz_soseaicethicknessadv
   499  opt  (1593): Loop nest collapsed into one loop.
   499  vec  (   4): Vectorized array expression.
   499  vec  (  29): ADB is used for array.: xy_sotempadv
   518  opt  (  11): Fused array assignments. :line 518 - 519
   518  opt  (1593): Loop nest collapsed into one loop.
   518  vec  (   4): Vectorized array expression.
   518  vec  (  29): ADB is used for array.: xyz_soseaicetemp
   518  vec  (  29): ADB is used for array.: xyz_soseaicetempadv
   518  vec  (  29): ADB is used for array.: xyz_soseaicethicknessadv
   520  opt  (1593): Loop nest collapsed into one loop.
   520  vec  (   4): Vectorized array expression.
   520  vec  (  29): ADB is used for array.: xy_sotempadv
   523  opt  (  11): Fused array assignments. :line 523 - 525
   528  opt  (1593): Loop nest collapsed into one loop.
   528  vec  (   4): Vectorized array expression.
   528  vec  (  29): ADB is used for array.: xy_dsotempdt
   590  vec  (   1): Vectorized loop.
   590  vec  (  29): ADB is used for array.: xyz_sosimasseachlayer
   590  vec  (  29): ADB is used for array.: xyz_soseaicethickness
   593  vec  (   1): Vectorized loop.
   593  vec  (  29): ADB is used for array.: xyz_sosimasseachlayer
   599  opt  (1593): Loop nest collapsed into one loop.
   599  vec  (   4): Vectorized array expression.
   599  vec  (  29): ADB is used for array.: xy_soseaicemass
   602  vec  (   1): Vectorized loop.
   602  vec  (  29): ADB is used for array.: xyz_sosimasseachlayer
   603  vec  (  26): Macro operation Sum/InnerProd.
   612  vec  (   3): Unvectorized loop.
   612  vec  (  13): Overhead of loop division is too large.
   613  opt  (1019): Feedback of scalar value from one loop pass to another.
   615  opt  (1019): Feedback of scalar value from one loop pass to another.
   636  vec  (  20): Unvectorizable dependency.:xy_sotemp
   667  vec  (  20): Unvectorizable dependency.:xy_sotemp
   671  vec  (  20): Unvectorizable dependency.:xy_soseaicemass
   678  opt  (1593): Loop nest collapsed into one loop.
   678  vec  (   1): Vectorized loop.
   678  vec  (  29): ADB is used for array.: xy_surftemp
   678  vec  (  29): ADB is used for array.: xy_soseaicemass
   696  vec  (   3): Unvectorized loop.
   700  opt  (1017): Subroutine call prevents optimization.
   700  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   713  opt  (1593): Loop nest collapsed into one loop.
   713  vec  (   4): Vectorized array expression.
   713  vec  (  29): ADB is used for array.: xy_soseaicethickness
   713  vec  (  29): ADB is used for array.: xy_soseaicemass
   721  warn (  82): Name "kk" is not used.
   721  warn (  82): Name "xy_seaicethicknessa" is not used.
   721  warn (  82): Name "xyr_sosilocaldeptha" is not used.
   721  warn (  82): Name "xy_sosilocalkmaxa" is not used.
   721  warn (  82): Name "xyz_sosilocaldeptha" is not used.
   874  opt  (1593): Loop nest collapsed into one loop.
   874  vec  (   4): Vectorized array expression.
   875  vec  (   3): Unvectorized loop.
   875  vec  (  13): Overhead of loop division is too large.
   876  opt  (1593): Loop nest collapsed into one loop.
   876  vec  (   4): Vectorized array expression.
   876  vec  (  29): ADB is used for array.: xy_soseaicemassa
   876  vec  (  29): ADB is used for array.: xyz_soseaicethicknessa
   901  opt  (1593): Loop nest collapsed into one loop.
   901  vec  (   1): Vectorized loop.
   901  vec  (  29): ADB is used for array.: xyza_tmp4darray
   901  vec  (  29): ADB is used for array.: xyz_soseaicethicknessa
   904  opt  (1593): Loop nest collapsed into one loop.
   904  vec  (   1): Vectorized loop.
   904  vec  (  29): ADB is used for array.: xyza_tmp4darray
   909  opt  (1593): Loop nest collapsed into one loop.
   909  vec  (   1): Vectorized loop.
   909  vec  (  29): ADB is used for array.: xyza_tmp4darray
   909  vec  (  29): ADB is used for array.: xyz_soseaicetempa
   912  opt  (1593): Loop nest collapsed into one loop.
   912  vec  (   1): Vectorized loop.
   912  vec  (  29): ADB is used for array.: xyza_tmp4darray
   918  opt  (1593): Loop nest collapsed into one loop.
   918  vec  (   1): Vectorized loop.
   918  vec  (  29): ADB is used for array.: xyza_tmp4darray
   918  vec  (  29): ADB is used for array.: xy_flagslabocean
   928  opt  (1593): Loop nest collapsed into one loop.
   928  vec  (   4): Vectorized array expression.
   928  vec  (  29): ADB is used for array.: xyza_tmp4darray
   928  vec  (  29): ADB is used for array.: xy_surftempa
   930  opt  (1593): Loop nest collapsed into one loop.
   930  vec  (   4): Vectorized array expression.
   930  vec  (  29): ADB is used for array.: xyza_tmp4darray
   930  vec  (  29): ADB is used for array.: xy_soseaicemassa
   931  opt  (1593): Loop nest collapsed into one loop.
   931  vec  (   1): Vectorized loop.
   931  vec  (  29): ADB is used for array.: xyza_tmp4darray
   935  opt  (1593): Loop nest collapsed into one loop.
   935  vec  (   1): Vectorized loop.
   935  vec  (  29): ADB is used for array.: xyza_tmp4darray
   947  opt  (1593): Loop nest collapsed into one loop.
   947  vec  (   1): Vectorized loop.
   947  vec  (  29): ADB is used for array.: xyz_extsoseaicethicknessn
   947  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
   947  vec  (  29): ADB is used for array.: xyz_extsoseaicethicknesss
   947  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
   948  opt  (  11): Fused array assignments. :line 948 - 949
   952  opt  (1593): Loop nest collapsed into one loop.
   952  vec  (   1): Vectorized loop.
   952  vec  (  29): ADB is used for array.: xyz_extsoseaicetempn
   952  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
   952  vec  (  29): ADB is used for array.: xyz_extsoseaicetemps
   952  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
   953  opt  (  11): Fused array assignments. :line 953 - 954
   958  opt  (1593): Loop nest collapsed into one loop.
   958  vec  (   1): Vectorized loop.
   958  vec  (  29): ADB is used for array.: xy_extflagslaboceann
   958  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
   958  vec  (  29): ADB is used for array.: xy_extflagslaboceans
   958  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
   973  vec  (   3): Unvectorized loop.
   973  vec  (  13): Overhead of loop division is too large.
   974  opt  (  11): Fused array assignments. :line 974 - 975
   974  opt  (1593): Loop nest collapsed into one loop.
   974  vec  (   4): Vectorized array expression.
   974  vec  (  29): ADB is used for array.: xyz_extsurftempn
   974  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
   974  vec  (  29): ADB is used for array.: xyz_extsurftemps
   974  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
   978  vec  (   3): Unvectorized loop.
   978  vec  (  13): Overhead of loop division is too large.
   979  opt  (  11): Fused array assignments. :line 979 - 980
   979  opt  (1593): Loop nest collapsed into one loop.
   979  vec  (   4): Vectorized array expression.
   979  vec  (  29): ADB is used for array.: xy_extsoseaicemassn
   979  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
   979  vec  (  29): ADB is used for array.: xy_extsoseaicemasss
   979  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
  1038  opt  (1593): Loop nest collapsed into one loop.
  1038  vec  (   4): Vectorized array expression.
  1038  vec  (  29): ADB is used for array.: xyz_dsoseaicethicknessdt
  1038  vec  (  29): ADB is used for array.: xyz_dsoseaicethicknessdts
  1039  opt  (  11): Fused array assignments. :line 1039 - 1041
  1039  opt  (1593): Loop nest collapsed into one loop.
  1039  vec  (   4): Vectorized array expression.
  1039  vec  (  29): ADB is used for array.: xyz_dsoseaicetempdt
  1039  vec  (  29): ADB is used for array.: xyz_dsoseaicetempdts
  1039  vec  (  29): ADB is used for array.: xyz_dsoseaicethicknessdt
  1039  vec  (  29): ADB is used for array.: xyz_dsoseaicethicknessdtn
  1042  opt  (1593): Loop nest collapsed into one loop.
  1042  vec  (   4): Vectorized array expression.
  1042  vec  (  29): ADB is used for array.: xyz_dsoseaicetempdt
  1042  vec  (  29): ADB is used for array.: xyz_dsoseaicetempdtn
  1044  opt  (1593): Loop nest collapsed into one loop.
  1044  vec  (   4): Vectorized array expression.
  1044  vec  (  29): ADB is used for array.: xy_dsurftempdt
  1044  vec  (  29): ADB is used for array.: xya_dsurftempdts
  1045  opt  (1593): Loop nest collapsed into one loop.
  1045  vec  (   4): Vectorized array expression.
  1045  vec  (  29): ADB is used for array.: xy_dsurftempdt
  1045  vec  (  29): ADB is used for array.: xya_dsurftempdtn
  1378  opt  (1593): Loop nest collapsed into one loop.
  1378  vec  (   4): Vectorized array expression.
  1379  vec  (   3): Unvectorized loop.
  1379  vec  (  13): Overhead of loop division is too large.
  1380  opt  (1593): Loop nest collapsed into one loop.
  1380  vec  (   4): Vectorized array expression.
  1380  vec  (  29): ADB is used for array.: xy_soseaicemassa
  1380  vec  (  29): ADB is used for array.: xyz_soseaicethicknessa
  1405  opt  (1593): Loop nest collapsed into one loop.
  1405  vec  (   1): Vectorized loop.
  1405  vec  (  29): ADB is used for array.: xyza_tmp4darray
  1405  vec  (  29): ADB is used for array.: xyz_soseaicethicknessa
  1408  opt  (1593): Loop nest collapsed into one loop.
  1408  vec  (   1): Vectorized loop.
  1408  vec  (  29): ADB is used for array.: xyza_tmp4darray
  1413  opt  (1593): Loop nest collapsed into one loop.
  1413  vec  (   1): Vectorized loop.
  1413  vec  (  29): ADB is used for array.: xyza_tmp4darray
  1413  vec  (  29): ADB is used for array.: xyz_soseaicetempa
  1416  opt  (1593): Loop nest collapsed into one loop.
  1416  vec  (   1): Vectorized loop.
  1416  vec  (  29): ADB is used for array.: xyza_tmp4darray
  1422  opt  (1593): Loop nest collapsed into one loop.
  1422  vec  (   1): Vectorized loop.
  1422  vec  (  29): ADB is used for array.: xyza_tmp4darray
  1422  vec  (  29): ADB is used for array.: xy_flagslabocean
  1432  opt  (1593): Loop nest collapsed into one loop.
  1432  vec  (   4): Vectorized array expression.
  1432  vec  (  29): ADB is used for array.: xyza_tmp4darray
  1432  vec  (  29): ADB is used for array.: xy_surftempa
  1434  opt  (1593): Loop nest collapsed into one loop.
  1434  vec  (   4): Vectorized array expression.
  1434  vec  (  29): ADB is used for array.: xyza_tmp4darray
  1434  vec  (  29): ADB is used for array.: xy_soseaicemassa
  1435  opt  (1593): Loop nest collapsed into one loop.
  1435  vec  (   1): Vectorized loop.
  1435  vec  (  29): ADB is used for array.: xyza_tmp4darray
  1439  opt  (1593): Loop nest collapsed into one loop.
  1439  vec  (   1): Vectorized loop.
  1439  vec  (  29): ADB is used for array.: xyza_tmp4darray
  1451  opt  (1593): Loop nest collapsed into one loop.
  1451  vec  (   1): Vectorized loop.
  1451  vec  (  29): ADB is used for array.: xyz_extsoseaicethicknessn
  1451  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
  1451  vec  (  29): ADB is used for array.: xyz_extsoseaicethicknesss
  1451  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
  1452  opt  (  11): Fused array assignments. :line 1452 - 1453
  1456  opt  (1593): Loop nest collapsed into one loop.
  1456  vec  (   1): Vectorized loop.
  1456  vec  (  29): ADB is used for array.: xyz_extsoseaicetempn
  1456  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
  1456  vec  (  29): ADB is used for array.: xyz_extsoseaicetemps
  1456  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
  1457  opt  (  11): Fused array assignments. :line 1457 - 1458
  1462  opt  (1593): Loop nest collapsed into one loop.
  1462  vec  (   1): Vectorized loop.
  1462  vec  (  29): ADB is used for array.: xy_extflagslaboceann
  1462  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
  1462  vec  (  29): ADB is used for array.: xy_extflagslaboceans
  1462  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
  1477  vec  (   3): Unvectorized loop.
  1477  vec  (  13): Overhead of loop division is too large.
  1478  opt  (  11): Fused array assignments. :line 1478 - 1479
  1478  opt  (1593): Loop nest collapsed into one loop.
  1478  vec  (   4): Vectorized array expression.
  1478  vec  (  29): ADB is used for array.: xyz_extsurftempn
  1478  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
  1478  vec  (  29): ADB is used for array.: xyz_extsurftemps
  1478  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
  1482  vec  (   3): Unvectorized loop.
  1482  vec  (  13): Overhead of loop division is too large.
  1483  opt  (  11): Fused array assignments. :line 1483 - 1484
  1483  opt  (1593): Loop nest collapsed into one loop.
  1483  vec  (   4): Vectorized array expression.
  1483  vec  (  29): ADB is used for array.: xy_extsoseaicemassn
  1483  vec  (  29): ADB is used for array.: xyza_exttmp4darrayn
  1483  vec  (  29): ADB is used for array.: xy_extsoseaicemasss
  1483  vec  (  29): ADB is used for array.: xyza_exttmp4darrays
  1542  opt  (1593): Loop nest collapsed into one loop.
  1542  vec  (   4): Vectorized array expression.
  1542  vec  (  29): ADB is used for array.: xyz_dsoseaicethicknessdt
  1542  vec  (  29): ADB is used for array.: xyz_dsoseaicethicknessdts
  1543  opt  (  11): Fused array assignments. :line 1543 - 1545
  1543  opt  (1593): Loop nest collapsed into one loop.
  1543  vec  (   4): Vectorized array expression.
  1543  vec  (  29): ADB is used for array.: xyz_dsoseaicetempdt
  1543  vec  (  29): ADB is used for array.: xyz_dsoseaicetempdts
  1543  vec  (  29): ADB is used for array.: xyz_dsoseaicethicknessdt
  1543  vec  (  29): ADB is used for array.: xyz_dsoseaicethicknessdtn
  1546  opt  (1593): Loop nest collapsed into one loop.
  1546  vec  (   4): Vectorized array expression.
  1546  vec  (  29): ADB is used for array.: xyz_dsoseaicetempdt
  1546  vec  (  29): ADB is used for array.: xyz_dsoseaicetempdtn
  1548  opt  (1593): Loop nest collapsed into one loop.
  1548  vec  (   4): Vectorized array expression.
  1548  vec  (  29): ADB is used for array.: xy_dsurftempdt
  1548  vec  (  29): ADB is used for array.: xya_dsurftempdts
  1549  opt  (1593): Loop nest collapsed into one loop.
  1549  vec  (   4): Vectorized array expression.
  1549  vec  (  29): ADB is used for array.: xy_dsurftempdt
  1549  vec  (  29): ADB is used for array.: xya_dsurftempdtn
  1665  opt  (1593): Loop nest collapsed into one loop.
  1665  vec  (   4): Vectorized array expression.
  1666  opt  (1593): Loop nest collapsed into one loop.
  1666  vec  (   4): Vectorized array expression.
  1668  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
  1668  vec  (   1): Vectorized loop.
  1668  vec  (  29): ADB is used for array.: xy_extsoseaicemassh
  1668  vec  (  29): ADB is used for array.: xy_extflagslaboceanh
  1668  vec  (  29): ADB is used for array.: x_extlonh
  1695  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
  1695  vec  (   1): Vectorized loop.
  1695  vec  (  29): ADB is used for array.: xy_dsoseaicemassdth
  1695  vec  (  29): ADB is used for array.: xq_extsoseaicemassyflux
  1695  vec  (  29): ADB is used for array.: p_lonh
  1695  vec  (  29): ADB is used for array.: py_extsoseaicemassxflux
  1786  opt  (1592): Outer loop unrolled inside inner loop.
  1787  vec  (   1): Vectorized loop.
  1787  vec  (  29): ADB is used for array.: xy_extsoseaicemassh
  1787  vec  (  29): ADB is used for array.: xy_extflagslaboceanh
  1787  vec  (   1): Vectorized loop.
  1787  vec  (  29): ADB is used for array.: xy_extsoseaicemassh
  1787  vec  (  29): ADB is used for array.: xy_extflagslaboceanh
  1787  vec  (   1): Vectorized loop.
  1787  vec  (  29): ADB is used for array.: xy_extflagslaboceanh
  1787  vec  (   1): Vectorized loop.
  1787  vec  (  29): ADB is used for array.: xy_extflagslaboceanh
  1803  opt  (1592): Outer loop unrolled inside inner loop.
  1804  vec  (   1): Vectorized loop.
  1804  vec  (  29): ADB is used for array.: xyz_extsoseaicemassh
  1804  vec  (   1): Vectorized loop.
  1804  vec  (  29): ADB is used for array.: xyz_extsoseaicemassh
  1820  opt  (1592): Outer loop unrolled inside inner loop.
  1821  vec  (   1): Vectorized loop.
  1821  vec  (  29): ADB is used for array.: xyz_dsoseaicemassdth
  1821  vec  (  29): ADB is used for array.: xy_extsoseaicemassh
  1821  vec  (  29): ADB is used for array.: xqz_extsoseaicemassyflux
  1821  vec  (   1): Vectorized loop.
  1821  vec  (  29): ADB is used for array.: xyz_dsoseaicemassdth
  1821  vec  (  29): ADB is used for array.: xy_extsoseaicemassh
  1821  vec  (  29): ADB is used for array.: xqz_extsoseaicemassyflux
  1821  vec  (   1): Vectorized loop.
  1821  vec  (  29): ADB is used for array.: xyz_dsoseaicemassdth
  1821  vec  (  29): ADB is used for array.: xqz_extsoseaicemassyflux
  1821  vec  (   1): Vectorized loop.
  1821  vec  (  29): ADB is used for array.: xyz_dsoseaicemassdth
  1821  vec  (  29): ADB is used for array.: xqz_extsoseaicemassyflux
  1922  vec  (   4): Vectorized array expression.
  1922  vec  (  29): ADB is used for array.: y_coslat
  1926  vec  (   1): Vectorized loop.
  1926  vec  (  29): ADB is used for array.: xy_flagslabocean
  1943  opt  (1593): Loop nest collapsed into one loop.
  1943  vec  (   4): Vectorized array expression.
  1943  vec  (  29): ADB is used for array.: aax_lumat
  1945  opt  (1592): Outer loop unrolled inside inner loop.
  1961  vec  (   1): Vectorized loop.
  1961  vec  (  29): ADB is used for array.: aax_lumat
  1961  vec  (   1): Vectorized loop.
  1961  vec  (  29): ADB is used for array.: aax_lumat
  1996  opt  (1592): Outer loop unrolled inside inner loop.
  1998  vec  (   1): Vectorized loop.
  1998  vec  (  29): ADB is used for array.: aa_luvec
  1998  vec  (  29): ADB is used for array.: xyz_soseaicethickness
  1998  vec  (   1): Vectorized loop.
  1998  vec  (  29): ADB is used for array.: aa_luvec
  1998  vec  (  29): ADB is used for array.: xyz_soseaicethickness
  2006  opt  (1592): Outer loop unrolled inside inner loop.
  2008  vec  (   1): Vectorized loop.
  2008  vec  (  29): ADB is used for array.: xyz_soseaicethicknessa
  2008  vec  (  29): ADB is used for array.: aa_luvec
  2008  vec  (   1): Vectorized loop.
  2008  vec  (  29): ADB is used for array.: xyz_soseaicethicknessa
  2008  vec  (  29): ADB is used for array.: aa_luvec
  2016  opt  (1592): Outer loop unrolled inside inner loop.
  2018  vec  (   1): Vectorized loop.
  2018  vec  (  29): ADB is used for array.: aa_luvec
  2018  vec  (  29): ADB is used for array.: xyz_soseaicetemp
  2018  vec  (   1): Vectorized loop.
  2018  vec  (  29): ADB is used for array.: aa_luvec
  2018  vec  (  29): ADB is used for array.: xyz_soseaicetemp
  2026  opt  (1592): Outer loop unrolled inside inner loop.
  2028  vec  (   1): Vectorized loop.
  2028  vec  (  29): ADB is used for array.: xyz_soseaicetempa
  2028  vec  (  29): ADB is used for array.: aa_luvec
  2028  vec  (   1): Vectorized loop.
  2028  vec  (  29): ADB is used for array.: xyz_soseaicetempa
  2028  vec  (  29): ADB is used for array.: aa_luvec
  2040  vec  (   1): Vectorized loop.
  2040  vec  (  29): ADB is used for array.: xy_soseaicemass
  2040  vec  (  29): ADB is used for array.: xy_flagslabocean
  2059  opt  (1593): Loop nest collapsed into one loop.
  2059  vec  (   4): Vectorized array expression.
  2059  vec  (  29): ADB is used for array.: aax_lumat
  2061  opt  (1592): Outer loop unrolled inside inner loop.
  2078  vec  (   1): Vectorized loop.
  2078  vec  (  29): ADB is used for array.: aax_lumat
  2078  vec  (  29): ADB is used for array.: xy_soseaicemass
  2078  vec  (   1): Vectorized loop.
  2078  vec  (  29): ADB is used for array.: aax_lumat
  2078  vec  (  29): ADB is used for array.: xy_soseaicemass
  2114  vec  (   3): Unvectorized loop.
  2114  vec  (   7): Iteration count is too small.
  2122  vec  (   1): Vectorized loop.
  2122  vec  (  29): ADB is used for array.: aax_lumat
  2122  vec  (  29): ADB is used for array.: xy_soseaicemass
  2130  vec  (   3): Unvectorized loop.
  2130  vec  (   7): Iteration count is too small.
  2147  opt  (1592): Outer loop unrolled inside inner loop.
  2149  vec  (   1): Vectorized loop.
  2149  vec  (  29): ADB is used for array.: aa_luvec
  2149  vec  (  29): ADB is used for array.: xy_surftemp
  2149  vec  (  29): ADB is used for array.: xy_soseaicemass
  2149  vec  (   1): Vectorized loop.
  2149  vec  (  29): ADB is used for array.: aa_luvec
  2149  vec  (  29): ADB is used for array.: xy_surftemp
  2149  vec  (  29): ADB is used for array.: xy_soseaicemass
  2163  opt  (1592): Outer loop unrolled inside inner loop.
  2165  vec  (   1): Vectorized loop.
  2165  vec  (  29): ADB is used for array.: xy_surftempa
  2165  vec  (  29): ADB is used for array.: aa_luvec
  2165  vec  (   1): Vectorized loop.
  2165  vec  (  29): ADB is used for array.: xy_surftempa
  2165  vec  (  29): ADB is used for array.: aa_luvec
  2335  vec  (   4): Vectorized array expression.
  2335  vec  (  29): ADB is used for array.: y_coslat
  2335  vec  (  29): ADB is used for array.: y_lat
  2343  vec  (   1): Vectorized loop.
  2343  vec  (  29): ADB is used for array.: x_sinlons
  2343  vec  (  29): ADB is used for array.: x_coslons
  2343  vec  (  29): ADB is used for array.: x_lons
  2343  vec  (  29): ADB is used for array.: x_lon
  2348  vec  (   1): Vectorized loop.
  2348  vec  (  29): ADB is used for array.: y_sinlats
  2348  vec  (  29): ADB is used for array.: y_coslats
  2348  vec  (  29): ADB is used for array.: y_lats
  2348  vec  (  29): ADB is used for array.: y_lat
  2360  vec  (   1): Vectorized loop.
  2360  vec  (  29): ADB is used for array.: x_sinlonn
  2360  vec  (  29): ADB is used for array.: x_coslonn
  2360  vec  (  29): ADB is used for array.: x_lonn
  2360  vec  (  29): ADB is used for array.: x_lon
  2365  vec  (   1): Vectorized loop.
  2365  vec  (  29): ADB is used for array.: y_sinlatn
  2365  vec  (  29): ADB is used for array.: y_coslatn
  2365  vec  (  29): ADB is used for array.: y_latn
  2365  vec  (  29): ADB is used for array.: y_lat
  2386  vec  (   4): Vectorized array expression.
  2386  vec  (  29): ADB is used for array.: y_extcoslats
  2386  vec  (  29): ADB is used for array.: y_extlats
  2387  vec  (   4): Vectorized array expression.
  2387  vec  (  29): ADB is used for array.: y_extcoslatn
  2387  vec  (  29): ADB is used for array.: y_extlatn
  2397  vec  (   1): Vectorized loop.
  2397  vec  (  29): ADB is used for array.: p_lonn
  2397  vec  (  29): ADB is used for array.: x_extlonn
  2397  vec  (  29): ADB is used for array.: p_lons
  2397  vec  (  29): ADB is used for array.: x_extlons
  2401  vec  (   1): Vectorized loop.
  2401  vec  (  29): ADB is used for array.: q_latn
  2401  vec  (  29): ADB is used for array.: y_extlatn
  2401  vec  (  29): ADB is used for array.: q_lats
  2401  vec  (  29): ADB is used for array.: y_extlats
  2414  vec  (   4): Vectorized array expression.
  2414  vec  (  29): ADB is used for array.: q_coslats
  2414  vec  (  29): ADB is used for array.: q_lats
  2415  vec  (   4): Vectorized array expression.
  2415  vec  (  29): ADB is used for array.: q_coslatn
  2415  vec  (  29): ADB is used for array.: q_latn
  2447  warn (  82): Name "k" is not used.
  2447  warn (  82): Name "n" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:51 2016
FILE NAME: i.sosi_dynamics.F90
PROGRAM NAME: sosi_dynamics
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != Slab ocean sea ice horizontal transport
     4  !
     5  ! Authors::   Yoshiyuki O. TAKAHASHI
     6  ! Version::
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2013. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module sosi_dynamics
    13    !
    14    !=
    15    !
    16    != Slab sea ice horizontal transport
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! Horizontal transport of slab sea ice (sea ice on slab ocean) is calculated
    21    ! based on diffusion.
    22    !
    23    !== Procedures List
    24    !
    25  !!$  ! SLTTMain     :: 移流計算
    26  !!$  ! SLTTInit     :: 初期化
    27  !!$  ! SLTTTest     :: 移流テスト用
    28  !!$  ! ---------------------     :: ------------
    29  !!$  ! SLTTMain     :: Main subroutine for SLTT
    30  !!$  ! SLTTInit     :: Initialization for SLTT
    31  !!$  ! SLTTTest     :: Generate velocity for SLTT Test
    32    !
    33    !== NAMELIST
    34    !
    35    ! NAMELIST#
    36    !
    37    !== References
    38    !
    39    !
    40    ! モジュール引用 ; USE statements
    41    !
    42    ! 種別型パラメタ
    43    ! Kind type parameter
    44    !
    45    use dc_types, only: DP,  & ! 倍精度実数型. Double precision.
    46      &                 TOKEN  ! キーワード.   Keywords.
    47  
    48    ! メッセージ出力
    49    ! Message output
    50    !
    51    use dc_message, only: MessageNotify
    52  
    53    !
    54    ! MPI
    55    !
    56    use mpi_wrapper, only : MPIWrapperFindMaxVal
    57  
    58    ! 時刻管理
    59    ! Time control
    60    !
    61    use timeset, only: &
    62      & DelTime
    63  
    64    ! 格子点設定
    65    ! Grid points settings
    66    !
    67    use gridset, only:       &
    68      &                imax, & ! 経度格子点数.
    69                               ! Number of grid points in longitude
    70      &                jmax, & ! 緯度格子点数.
    71                               ! Number of grid points in latitude
    72      &                kmax, & ! 鉛直層数.
    73                               ! Number of vertical level
    74      &                ksimax  ! 海氷の鉛直層数.
    75                               ! Number of sea ice vertical level
    76  
    77    ! 組成に関わる配列の設定
    78    ! Settings of array for atmospheric composition
    79    !
    80    use composition, only:                              &
    81      &                    ncmax
    82                               ! 成分の数
    83                               ! Number of composition
    84  
    85    ! 質量の補正
    86    ! Mass fixer
    87    !
    88  !!$  use mass_fixer, only: &
    89  !!$    & MassFixerBC02, MassFixerBC02Layer, MassFixerBC02Column, &
    90  !!$    & MassFixer, MassFixerR95, MassFixerWO94, MassFixerColumn!, MassFixerLayer
    91  
    92  
    93    ! 宣言文 ; Declaration statements
    94    !
    95    implicit none
    96    private
    97  
    98    ! 公開手続き
    99    ! Public procedure
   100    !
   101    public :: SOSIDynamics
   102    public :: SOSIDynamicsInit
   103  
   104  
   105    ! 公開変数
   106    ! Public variables
   107    !
   108  
   109    ! 非公開変数
   110    ! Private variables
   111    !
   112    logical, save      :: FlagSlabOcean
   113    ! flag for use of slab ocean
   114  
   115    real(DP)    , save              :: SOSeaIceDiffCoef
   116  
   117    real(DP)    , save, allocatable :: y_CosLat(:)
   118                                ! $\cos\varphai$
   119  
   120    real(DP)    , save, allocatable :: x_LonS   (:)
   121                                ! $\lambda_S$ 南半球の経度。
   122                                ! longitude in SH.
   123    real(DP)    , save, allocatable :: x_SinLonS(:)
   124                                ! $\sin\lambda_S$
   125    real(DP)    , save, allocatable :: x_CosLonS(:)
   126                                ! $\cos\lambda_S$
   127    real(DP)    , save, allocatable :: y_LatS   (:)
   128                                ! $\varphi_S$ 南半球の緯度。
   129                                ! latitude in SH.
   130    real(DP)    , save, allocatable :: y_SinLatS(:)
   131                                ! $\sin\varphai_S$
   132    real(DP)    , save, allocatable :: y_CosLatS(:)
   133                                ! $\cos\varphai_S$
   134    real(DP)    , save, allocatable :: x_ExtLonS(:)
   135                                ! $ x_LonSの拡張配列。
   136                                !Extended array of x_LonS.
   137    real(DP)    , save, allocatable :: y_ExtLatS(:)
   138                                ! $ x_LatSの拡張配列。
   139                                !Extended array of x_LatS.
   140    real(DP)    , save, allocatable :: y_ExtCosLatS(:)
   141                                ! $ y_CosLatS の拡張配列。
   142                                !Extended array of y_CosLatS.
   143  
   144    real(DP)    , save, allocatable :: x_LonN   (:)
   145                                ! $\lambda_N$ 北半球の経度。
   146                                ! longitude in NH.
   147    real(DP)    , save, allocatable :: x_SinLonN(:)
   148                                ! $\sin\lambda_N$
   149    real(DP)    , save, allocatable :: x_CosLonN(:)
   150                                ! $\cos\lambda_N$
   151    real(DP)    , save, allocatable :: y_LatN   (:)
   152                                ! $\varphi_N$ 北半球の緯度。
   153                                ! latitude in NH.
   154    real(DP)    , save, allocatable :: y_SinLatN(:)
   155                                ! $\sin\varphai_N$
   156    real(DP)    , save, allocatable :: y_CosLatN(:)
   157                                ! $\cos\varphai_N$
   158    real(DP)    , save, allocatable :: x_ExtLonN(:)
   159                                ! $ x_LonNの拡張配列。
   160                                !Extended array of x_LonN.
   161    real(DP)    , save, allocatable :: y_ExtLatN(:)
   162                                ! $ x_LatNの拡張配列。
   163                                !Extended array of x_LatN.
   164    real(DP)    , save, allocatable :: y_ExtCosLatN(:)
   165                                ! $ y_CosLatNの拡張配列。
   166                                !Extended array of y_CosLatN.
   167  
   168    real(DP)    , save, allocatable :: p_LonS   (:)
   169    real(DP)    , save, allocatable :: q_LatS   (:)
   170    real(DP)    , save, allocatable :: q_CosLatS(:)
   171    real(DP)    , save, allocatable :: p_LonN   (:)
   172    real(DP)    , save, allocatable :: q_LatN   (:)
   173    real(DP)    , save, allocatable :: q_CosLatN(:)
   174  
   175  
   176    logical, save :: sosi_dynamics_inited = .false.
   177                                ! 初期設定フラグ.
   178                                ! Initialization flag
   179  
   180  
   181    character(*), parameter:: module_name = 'sosi_dynamics'
   182                                ! モジュールの名称.
   183                                ! Module name
   184    character(*), parameter:: version = &
   185      & '$Name:  $' // &
   186      & '$Id: sltt.F90,v 1.8 2014/06/29 07:21:28 yot Exp $'
   187                                ! モジュールのバージョン
   188                                ! Module version
   189  
   190  
   191    !--------------------------------------------------------------------------------------
   192  
   193  contains
   194  
   195    !--------------------------------------------------------------------------------------
   196  
   197    subroutine SOSIDynamics(                                &
   198      & xy_SurfType,                                        & !(in   )
   199      & xy_SurfTemp, xy_SOSeaIceMass, xyz_SOSeaIceTemp,     & !(inout)
   200      & xy_DSOSeaIceMassDtPhyTop, xy_DSOSeaIceMassDtPhyBot, & !(in   )
   201      & xyz_DSOSeaIceTempDtPhy                              & !(in   )
   202      & )
   203      !
   204      ! Calculates slab sea ice horizontal transports by diffusion
   205  
   206      ! ヒストリデータ出力
   207      ! History data output
   208      !
   209      use gtool_historyauto, only: HistoryAutoPut
   210  
   211      use timeset    , only : &
   212        & TimeN, &
   213        & DelTime
   214                                ! $\Delta t$
   215  
   216      ! 物理・数学定数設定
   217      ! Physical and mathematical constants settings
   218      !
   219      use constants0, only: &
   220        & WaterHeatCap
   221  
   222      ! 物理定数設定
   223      ! Physical constants settings
   224      !
   225      use constants, only: &
   226        & SOMass
   227                                ! Slab ocean mass
   228  
   229      ! 雪と海氷の定数の設定
   230      ! Setting constants of snow and sea ice
   231      !
   232      use constants_snowseaice, only: &
   233        & TempCondWater,              &
   234        & SeaIceDen,                  &
   235        & SeaIceHeatCap,              &
   236        & TempBelowSeaIce,            &
   237        & SOSeaIceThresholdMass,      &
   238        & LatentHeatFusionBelowSeaIce
   239  
   240      !
   241      ! Slab ocean sea ice utility module
   242      !
   243      use sosi_utils, only :             &
   244        & SOSIUtilsChkSOSeaIce,          &
   245        & SOSIUtilsSetSOSeaIceLevels,    &
   246        & SOSeaIceMassNegativeThreshold, &
   247        & SOSIUtilsAddPhysics
   248  
   249  
   250      ! 宣言文 ; Declaration statements
   251      !
   252      integer , intent(in ) :: xy_SurfType       (0:imax-1, 1:jmax)
   253                                ! 土地利用.
   254                                ! Surface index
   255      real(DP), intent(inout) :: xy_SurfTemp        (0:imax-1, 1:jmax)
   256      real(DP), intent(inout) :: xy_SOSeaIceMass    (0:imax-1, 1:jmax)
   257                                ! $ M_si $ . 海氷質量 (kg m-2)
   258                                ! Slab ocean sea ice mass (kg m-2)
   259  !!!! Modified by M.Ishiwatari (2016-12-10)
   260  !!!!    real(DP), intent(inout) :: xyz_SOSeaIceTemp   (0:imax-1, 1:jmax, 1:ksimax)
   261      real(DP), intent(inout) :: xyz_SOSeaIceTemp   (0:imax-1, 1:jmax, 0:ksimax)
   262      real(DP), intent(in   ) :: xy_DSOSeaIceMassDtPhyTop(0:imax-1, 1:jmax)
   263      real(DP), intent(in   ) :: xy_DSOSeaIceMassDtPhyBot(0:imax-1, 1:jmax)
   264                                !
   265                                ! Slab sea ice mass at next time step
   266  !!!! Modified by M.Ishiwatari (2016-12-10)
   267  !!!!    real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 1:ksimax)
   268      real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 0:ksimax)
   269  
   270  
   271      ! 作業変数
   272      ! Work variables
   273      !
   274      real(DP) :: xy_SurfTempSave     (0:imax-1, 1:jmax)
   275      real(DP) :: xy_SOSeaIceMassSave (0:imax-1, 1:jmax)
   276      real(DP) :: xyz_SOSeaIceTempSave(0:imax-1, 1:jmax, ksimax)
   277  
   278      real(DP) :: xy_SOSeaIceThickness(0:imax-1, 1:jmax)
   279  
   280  !!!! Modified by M.Ishiwatari (2016-12-10)
   281  !!!!    real(DP) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 1:ksimax)
   282      real(DP) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 0:ksimax)
   283                   !
   284                   ! Sea ice thickness
   285      integer  :: xy_SOSILocalKMax  (0:imax-1, 1:jmax)
   286      real(DP) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   287  !!!! Modified by M.Ishiwatari (2016-12-10)
   288  !!!!    real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   289      real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   290  
   291      real(DP) :: xy_SeaIceThicknessA(0:imax-1, 1:jmax)
   292                   !
   293                   ! Sea ice thickness
   294      integer  :: xy_SOSILocalKMaxA  (0:imax-1, 1:jmax)
   295      real(DP) :: xyr_SOSILocalDepthA(0:imax-1, 1:jmax, 0:ksimax)
   296  !!!! Modified by M.Ishiwatari (2016-12-10)
   297  !!!!    real(DP) :: xyz_SOSILocalDepthA(0:imax-1, 1:jmax, 1:ksimax)
   298      real(DP) :: xyz_SOSILocalDepthA(0:imax-1, 1:jmax, 0:ksimax)
   299  
   300      logical  :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
   301  
   302  !!!! Modified by M.Ishiwatari (2016-12-10)
   303  !!!!    real(DP) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 1:ksimax)
   304  !!!!    real(DP) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 1:ksimax)
   305      real(DP) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 0:ksimax)
   306      real(DP) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 0:ksimax)
   307      real(DP) :: xy_DSOTempDt            (0:imax-1, 1:jmax)
   308  
   309  !!$    real(DP) :: xy_DSOSeaIceMassDt(0:imax-1, 1:jmax)
   310  !!$                              !
   311  !!$                              ! Slab sea ice mass tendency
   312  
   313      real(DP) :: xy_SOTemp               (0:imax-1, 1:jmax)
   314  
   315  !!!! Modified by M.Ishiwatari (2016-12-10)
   316  !!!!    real(DP) :: xyz_SOSeaIceThicknessAdv(0:imax-1, 1:jmax, 1:ksimax)
   317  !!!!    real(DP) :: xyz_SOSeaIceTempAdv     (0:imax-1, 1:jmax, 1:ksimax)
   318      real(DP) :: xyz_SOSeaIceThicknessAdv(0:imax-1, 1:jmax, 0:ksimax)
   319      real(DP) :: xyz_SOSeaIceTempAdv     (0:imax-1, 1:jmax, 0:ksimax)
   320      real(DP) :: xy_SOTempAdv            (0:imax-1, 1:jmax)
   321  
   322  !!$    real(DP) :: xy_TempSlabOcean (0:imax-1, 1:jmax)
   323  !!$                              !
   324  !!$                              ! Slab ocean temperature
   325  !!$    real(DP) :: xy_TempSlabSeaIce(0:imax-1, 1:jmax)
   326  !!$                              !
   327  !!$                              ! Slab sea ice temperature
   328  
   329  !!!! Modified by M.Ishiwatari (2016-12-10)
   330  !!!!    real(DP) :: xyz_SOSIMassEachLayer(0:imax-1, 1:jmax, 1:ksimax)
   331      real(DP) :: xyz_SOSIMassEachLayer(0:imax-1, 1:jmax, 0:ksimax)
   332  
   333      real(DP) :: SOSIMass
   334      real(DP) :: SOSIMass1L
   335      real(DP) :: DelSOSIMass
   336  
   337  !!$    real(DP) :: SurfTempTent
   338      real(DP) :: SOTempTent
   339      real(DP) :: SOTempTent1st
   340  
   341      logical, parameter :: FlagSOSIAdv = .false.
   342  
   343      logical  :: FlagCalc
   344  
   345      integer:: i               ! 東西方向に回る DO ループ用作業変数
   346                                ! Work variables for DO loop in zonal direction
   347      integer:: j               ! 南北方向に回る DO ループ用作業変数
   348                                ! Work variables for DO loop in meridional direction
   349      integer:: k
   350      integer:: kk
   351  
   352  
   353      if ( .not. sosi_dynamics_inited ) then
   354        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   355      end if
   356  
   357  
   358      ! add physics tendency
   359      call SOSIUtilsAddPhysics(                         &
   360        & xy_SOSeaIceMass, xyz_SOSeaIceTemp,            & !(inout)
   361        & xy_DSOSeaIceMassDtPhyTop, xy_DSOSeaIceMassDtPhyBot, & !(in   )
   362        & xyz_DSOSeaIceTempDtPhy                           & !(in   )
   363        & )
   364  
   365  
   366  !!$    xy_SOSeaIceMassA = xy_SOSeaIceMassB &
   367  !!$      & + xy_DSOSeaIceMassDtPhy * ( 2.0_DP * DelTime )
   368  !!$
   369  !!$
   370  !!$    !
   371  !!$    ! Calcuate sea ice thickness
   372  !!$    !
   373  !!$    xy_SeaIceThickness = xy_SOSeaIceMassB / SeaIceDen
   374  !!$    !
   375  !!$    ! Set slab ocean sea ice levels
   376  !!$    !
   377  !!$    call SOSIUtilsSetSOSeaIceLevels(                     &
   378  !!$      & xy_SeaIceThickness,                                       & ! (in   )
   379  !!$      & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   380  !!$      & )
   381  !!$
   382  !!$    !
   383  !!$    ! Calcuate sea ice thickness
   384  !!$    !
   385  !!$    xy_SeaIceThicknessA = xy_SOSeaIceMassA / SeaIceDen
   386  !!$    !
   387  !!$    ! Set slab ocean sea ice levels
   388  !!$    !
   389  !!$    call SOSIUtilsSetSOSeaIceLevels(                     &
   390  !!$      & xy_SeaIceThicknessA,                                       & ! (in   )
   391  !!$      & xy_SOSILocalKMaxA, xyr_SOSILocalDepthA, xyz_SOSILocalDepthA  & ! (out)
   392  !!$      & )
   393  !!$
   394  !!$
   395  !!$    ! 海氷温度時間積分
   396  !!$    ! Time integration of sea ice temperature
   397  !!$    !
   398  !!$    xyz_SOSeaIceTemp = xyz_SOSeaIceTemp + xyz_DSOSeaIceTempDtPhy * DelTime
   399  !!$
   400  !!$
   401  !!$    ! Adjust levels
   402  !!$    !
   403  !!$    do j = 1, jmax
   404  !!$      do i = 0, imax-1
   405  !!$        if ( xy_SOSILocalKMaxA(i,j) > xy_SOSILocalKMax(i,j) ) then
   406  !!$          ! sea ice thickness increases
   407  !!$          do k = 1, xy_SOSILocalKMax(i,j)
   408  !!$            xyz_SOSeaIceTemp(i,j,k) = xyz_SOSeaIceTemp(i,j,k) &
   409  !!$              & + xyz_DSOSeaIceTempDtPhy(i,j,k) * DelTime
   410  !!$          end do
   411  !!$          do k = xy_SOSILocalKMax(i,j)+1, xy_SOSILocalKMaxA(i,j)
   412  !!$            kk = xy_SOSILocalKMax(i,j)
   413  !!$            xyz_SOSeaIceTemp(i,j,k) = xyz_SOSeaIceTemp(i,j,kk)
   414  !!$          end do
   415  !!$        else if ( xy_SOSILocalKMaxA(i,j) < xy_SOSILocalKMax(i,j) ) then
   416  !!$          ! sea ice thickness decreases
   417  !!$          !   Do nothing
   418  !!$          !   Melted sea ice had freezing temperature
   419  !!$        end if
   420  !!$      end do
   421  !!$    end do
   422  
   423  
   424  
   425      xy_FlagSlabOcean = .false.
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t890 = 1, xy_flagslabocean.DSC.U2*xy_flagslabocean.DSC.U1 +    
     .       1   xy_flagslabocean.DSC.U2                                        
     .           xy_flagslabocean(t890-1,1) = 0                                 
     .        enddo                                                             
   426      FlagCalc         = .false.
   427      if ( FlagSlabOcean ) then
   428        do j = 1, jmax
   429          do i = 0, imax-1
   430            if ( xy_SurfType(i,j) <= 0 ) then
   431              ! slab ocean
   432              xy_FlagSlabOcean(i,j) = .true.
   433              FlagCalc              = .true.
   434            end if
   435          end do
   436        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .le. 0) then                            
     .              xy_flagslabocean(j-1,1) = 1                                 
     .              flagcalc = 1                                                
     .           endif                                                          
     .        enddo                                                             
   437      end if
   438  
   439      if ( SOSeaIceDiffCoef <= 0.0_DP ) then
   440        FlagCalc = .false.
   441  !!$    else
   442  !!$      call MessageNotify( 'E', module_name, &
   443  !!$        & '  Now, SOSeaIceDiffCoef has to be zero.' )
   444      end if
   445  
   446      if ( .not. FlagCalc ) then
   447        return
   448      end if
   449  
   450  
   451  
   452      ! Save values
   453      !
   454      xy_SurfTempSave      = xy_SurfTemp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t896 = 1, xy_surftempsave.DSC.U2*xy_surftempsave.DSC.U1 +      
     .       1   xy_surftempsave.DSC.U2                                         
     .           xy_soseaicemasssave(t896-1,1) = xy_soseaicemass(t896-1,1)      
     .        enddo                                                             
   455      xy_SOSeaIceMassSave  = xy_SOSeaIceMass
   456      xyz_SOSeaIceTempSave = xyz_SOSeaIceTemp
   457  
   458  
   459      !
   460      ! Calcuate sea ice thickness
   461      !
   462      xy_SOSeaIceThickness = xy_SOSeaIceMass / SeaIceDen
     .        d1 = 1.D0/seaiceden                                               
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t920 = 1, jmax*imax                                            
     .           xy_soseaicethickness(t920-1,1) = xy_soseaicemass(t920-1,1)*d1  
     .        enddo                                                             
   463      !
   464      ! Set slab ocean sea ice levels
   465      !
   466      call SOSIUtilsSetSOSeaIceLevels(                     &
   467        & xy_SOSeaIceThickness,                                     & ! (in   )
   468        & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   469        & )
   470  
   471      ! Slab ocean temperature
   472      !
   473      do j = 1, jmax
   474        do i = 0, imax-1
   475  !!$        if ( xy_SOSILocalKMax(i,j) <= 0 ) then
   476          if ( xy_SOSeaIceMass(i,j) < SOSeaIceThresholdMass ) then
   477            xy_SOTemp(i,j) = xy_SurfTemp(i,j)
   478          else
   479            xy_SOTemp(i,j) = TempBelowSeaIce
   480          end if
   481        end do
   482      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_soseaicemass(j-1,1) .lt. soseaicethresholdmass) then    
     .              xy_sotemp2 = xy_surftemp(j-1,1)                             
     .           else                                                           
     .              xy_sotemp2 = tempbelowseaice                                
     .           endif                                                          
     .           xy_sotemp(j-1,1) = xy_sotemp2                                  
     .        enddo                                                             
   483  
   484      do j = 1, jmax
   485        do i = 0, imax-1
   486          do k = 1, xy_SOSILocalKMax(i,j)
   487            xyz_SOSeaIceThicknessAdv(i,j,k) = &
   488              & xyr_SOSILocalDepth(i,j,k-1) - xyr_SOSILocalDepth(i,j,k)
   489            xyz_SOSeaIceTempAdv     (i,j,k) = xyz_SOSeaIceTemp(i,j,k)
   490          end do
   491          do k = xy_SOSILocalKMax(i,j)+1, ksimax
   492            xyz_SOSeaIceThicknessAdv(i,j,k) = 0.0_DP
   493            xyz_SOSeaIceTempAdv     (i,j,k) = TempCondWater
   494  !!$          xyz_SOSeaIceTempAdv     (i,j,k) = TempBelowSeaIce
   495          end do
     .           xy_sosilocalkmax1 = xy_sosilocalkmax(i,j)                      
     .  !cdir nodep                                                             
     .        do k = 1, ksimax - xy_sosilocalkmax(i,j)                          
     .           xyz_soseaicethicknessadv(i,j,xy_sosilocalkmax1+k) =            
     .       1      0.0000000000000000e+000                                     
     .           xyz_soseaicetempadv(i,j,xy_sosilocalkmax1+k) = tempcondwater   
     .        enddo                                                             
   496        end do
   497      end do
   498      !
   499      xy_SOTempAdv = xy_SOTemp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t928 = 1, xy_sotempadv.DSC.U2*xy_sotempadv.DSC.U1 +            
     .       1   xy_sotempadv.DSC.U2                                            
     .           xy_sotempadv(t928-1,1) = xy_sotemp(t928-1,1)                   
     .        enddo                                                             
   500  
   501  
   502  !!$    call SOSIUtilsSetMissingValue( &
   503  !!$      & xy_SOSeaIceMass,                 & !(in )
   504  !!$      & xyz_SOSeaIceTemp,                & !(inout)
   505  !!$      & SOSeaIceValue                    & !(in ) optional
   506  !!$      & )
   507  
   508      call SOSIHorTransportDiff(                          &
   509        & xy_FlagSlabOcean,                               & ! (in)
   510        & xy_SOSeaIceMass,                                & ! (in)
   511        & xy_SOTempAdv,                                   & ! (in)
   512        & xyz_SOSeaIceThicknessAdv, xyz_SOSeaIceTempAdv,  & ! (in)
   513        & xy_DSOTempDt,                                   & ! (out)
   514        & xyz_DSOSeaIceThicknessDt, xyz_DSOSeaIceTempDt   & ! (out)
   515        & )
   516  
   517  
   518      xyz_SOSeaIceThickness = xyz_SOSeaIceThicknessAdv
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t936 = 1, (xyz_soseaicethickness.DSC.U3 + 1)*                  
     .       1   xyz_soseaicethickness.DSC.U2*(xyz_soseaicethickness.DSC.U1 + 1)
     .           xyz_soseaicethickness(t936-1,1,0) = xyz_soseaicethicknessadv(  
     .       1      t936-1,1,0)                                                 
     .           xyz_soseaicetemp(t936-1,1,0) = xyz_soseaicetempadv(t936-1,1,0) 
     .        enddo                                                             
   519      xyz_SOSeaIceTemp      = xyz_SOSeaIceTempAdv
   520      xy_SOTemp             = xy_SOTempAdv
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t954 = 1, xy_sotemp.DSC.U2*xy_sotemp.DSC.U1 + xy_sotemp.DSC.U2 
     .           xy_sotemp(t954-1,1) = xy_sotempadv(t954-1,1)                   
     .        enddo                                                             
   521      !
   522      if ( FlagSOSIAdv ) then
   523        xyz_SOSeaIceThickness = xyz_SOSeaIceThickness &
   524          & + xyz_DSOSeaIceThicknessDt * DelTime
   525        xyz_SOSeaIceTemp      = xyz_SOSeaIceTemp      &
   526          & + xyz_DSOSeaIceTempDt      * DelTime
   527      else
   528        xy_SOTemp = xy_SOTemp &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t962 = 1, xy_sotemp.DSC.U2*xy_sotemp.DSC.U1 + xy_sotemp.DSC.U2 
     .           xy_sotemp(t962-1,1) = xy_sotemp(t962-1,1) + xy_dsotempdt(t962-1
     .       1      ,1)*deltime                                                 
     .        enddo                                                             
   529          & + xy_DSOTempDt * DelTime
   530      end if
   531  
   532  
   533  
   534      ! Adjustment
   535      !
   536  !!$    do j = 1, jmax
   537  !!$      do i = 0, imax-1
   538  !!$        if ( xy_FlagSlabOcean(i,j) ) then
   539  !!$          do k = xy_SOSILocalKMax(i,j), 1, -1
   540  !!$            if ( xyz_SOSeaIceThickness(i,j,k) > 0.0_DP ) then
   541  !!$              if ( xy_SurfTemp(i,j) > TempCondWater ) then
   542  !!$                ! Check whether all sea ice melt
   543  !!$                SOSIMass = SeaIceDen * xyz_SOSeaIceThickness(i,j,k)
   544  !!$                SurfTempTent = &
   545  !!$                  &   (   WaterHeatCap * ( SOMass - SOSIMass ) * xy_SurfTemp(i,j) &
   546  !!$                  &     + SeaIceHeatCap * SOSIMass * xyz_SOSeaIceTemp(i,j,k)      &
   547  !!$                  &     - LatentHeatFusion * SOSIMass )                           &
   548  !!$                  & / ( WaterHeatCap * SOMass )
   549  !!$
   550  !!$                if ( SurfTempTent >= TempCondWater ) then
   551  !!$                  ! Case in which all sea ice melt
   552  !!$                  xy_SurfTemp          (i,j)   = SurfTempTent
   553  !!$                  xyz_SOSeaIceThickness(i,j,k) = 0.0_DP
   554  !!$                  xyz_SOSeaIceTemp     (i,j,k) = TempCondWater
   555  !!$                else
   556  !!$                  ! Case in which a part of sea ice melt
   557  !!$                  DelSOSIMass =                                  &
   558  !!$                    & - WaterHeatCap * ( SOMass - SOSIMass )     &
   559  !!$                    &   * ( xy_SurfTemp(i,j) - TempBelowSeaIce ) &
   560  !!$                    &   / (                                                   &
   561  !!$                    &         LatentHeatFusion                                &
   562  !!$                    &       + SeaIceHeatCap                                   &
   563  !!$                    &         * ( TempBelowSeaIce - xyz_SOSeaIceTemp(i,j,k) ) &
   564  !!$                    &      )
   565  !!$
   566  !!$                  xy_SurfTemp(i,j) = TempCondWater
   567  !!$                  xyz_SOSeaIceThickness(i,j,k) =     &
   568  !!$                    &   xyz_SOSeaIceThickness(i,j,k) &
   569  !!$                    & + DelSOSIMass / SeaIceDen
   570  !!$                end if
   571  !!$              end if
   572  !!$            end if
   573  !!$          end do
   574  !!$        end if
   575  !!$      end do
   576  !!$    end do
   577  !!$    !
   578  !!$    xy_SOSeaIceMass = 0.0_DP
   579  !!$    do j = 1, jmax
   580  !!$      do i = 0, imax-1
   581  !!$        do k = 1, xy_SOSILocalKMax(i,j)
   582  !!$          xy_SOSeaIceMass(i,j) = xy_SOSeaIceMass(i,j) &
   583  !!$            & + SeaIceDen * xyz_SOSeaIceThickness(i,j,k)
   584  !!$        end do
   585  !!$      end do
   586  !!$    end do
   587  
   588      do j = 1, jmax
   589        do i = 0, imax-1
   590          do k = 1, xy_SOSILocalKMax(i,j)
   591            xyz_SOSIMassEachLayer(i,j,k) = SeaIceDen * xyz_SOSeaIceThickness(i,j,k)
   592          end do
   593          do k = xy_SOSILocalKMax(i,j)+1, ksimax
   594            xyz_SOSIMassEachLayer(i,j,k) = 0.0_DP
   595          end do
     .           xy_sosilocalkmax2 = xy_sosilocalkmax(i,j)                      
     .  !cdir nodep                                                             
     .        do k = 1, ksimax - xy_sosilocalkmax(i,j)                          
     .           xyz_sosimasseachlayer(i,j,xy_sosilocalkmax2+k) =               
     .       1      0.0000000000000000e+000                                     
     .        enddo                                                             
   596        end do
   597      end do
   598  
   599      xy_SOSeaIceMass = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t972 = 1, jmax*imax                                            
     .           xy_soseaicemass(t972-1,1) = 0.0000000000000000e+000            
     .        enddo                                                             
   600      do j = 1, jmax
   601        do i = 0, imax-1
   602          do k = 1, xy_SOSILocalKMax(i,j)
   603            xy_SOSeaIceMass(i,j) = xy_SOSeaIceMass(i,j) &
   604              & + xyz_SOSIMassEachLayer(i,j,k)
   605          end do
     .        if (xy_sosilocalkmax(i,j) .gt. 0) then                            
     .           xy_soseaicemass3 = xy_soseaicemass(i,j)                        
     .  !cdir    nodep                                                          
     .           do k = 1, xy_sosilocalkmax(i,j)                                
     .              xy_soseaicemass3 = xy_soseaicemass3 + xyz_sosimasseachlayer(
     .       1         i,j,k)                                                   
     .           enddo                                                          
     .           xy_soseaicemass(i,j) = xy_soseaicemass3                        
     .        endif                                                             
   606        end do
   607      end do
   608  
   609      do j = 1, jmax
   610        do i = 0, imax-1
   611          if ( xy_FlagSlabOcean(i,j) ) then
   612            do k = xy_SOSILocalKMax(i,j), 1, -1
   613              if ( xy_SOTemp(i,j) > TempBelowSeaIce ) then
   614                ! Check whether all sea ice melt
   615                SOSIMass    = xy_SOSeaIceMass(i,j)
   616                SOSIMass1L  = xyz_SOSIMassEachLayer(i,j,k)
   617                DelSOSIMass = - SOSIMass1L
   618  
   619  !!$              SOTempTent =                                                    &
   620  !!$                &   (   WaterHeatCap * ( SOMass - SOSIMass ) * xy_SOTemp(i,j) &
   621  !!$                &     + SeaIceHeatCap * SOSIMass1L * xyz_SOSeaIceTemp(i,j,k)  &
   622  !!$                &     + LatentHeatFusion * DelSOSIMass )                      &
   623  !!$                & / ( WaterHeatCap * ( ( SOMass - SOSIMass ) - DelSOSIMass ) )
   624  
   625                SOTempTent1st = TempBelowSeaIce
   626                SOTempTent =                                                    &
   627                  &   (   WaterHeatCap * ( SOMass - SOSIMass ) * xy_SOTemp(i,j) &
   628                  &     - WaterHeatCap * DelSOSIMass * SOTempTent1st            &
   629                  &     + SeaIceHeatCap * DelSOSIMass                           &
   630                  &         * ( SOTempTent1st - xyz_SOSeaIceTemp(i,j,k) )       &
   631                  &     + LatentHeatFusionBelowSeaice * DelSOSIMass )           &
   632                  & / ( WaterHeatCap * ( ( SOMass - SOSIMass ) - DelSOSIMass ) )
   633  
   634                if ( SOTempTent >= TempBelowSeaIce ) then
   635                  ! Case in which all sea ice melt
   636                  xy_SOTemp            (i,j)   = SOTempTent
   637                  xyz_SOSeaIceTemp     (i,j,k) = TempBelowSeaIce
   638                else
   639                  ! Case in which a part of sea ice melt
   640                  SOTempTent = TempBelowSeaIce
   641  
   642  !!$                DelSOSIMass =                                  &
   643  !!$                  &   ( &
   644  !!$                  &     - WaterHeatCap * ( SOMass - SOSIMass )     &
   645  !!$                  &         * ( SOTempTent - xy_SOTemp(i,j) )      &
   646  !!$                  &     - SeaIceHeatCap * SOSIMass1L               &
   647  !!$                  &         * ( xyz_SOSeaIceTemp(i,j,k) - xyz_SOSeaIceTemp(i,j,k) )  &
   648  !!$                  &   ) &
   649  !!$                  & / (                                                 &
   650  !!$                  &     - WaterHeatCap * SOTempTent                     &
   651  !!$                  &     + SeaIceHeatCap * xyz_SOSeaIceTemp(i,j,k)       &
   652  !!$                  &     - LatentHeatFusion                              &
   653  !!$                  &   )
   654  
   655                  SOTempTent1st = TempBelowSeaIce
   656                  DelSOSIMass =                                  &
   657                    &   ( &
   658                    &       WaterHeatCap * ( SOMass - SOSIMass ) &
   659                    &         * ( SOTempTent - xy_SOTemp(i,j) )  &
   660                    &   ) &
   661                    & / (                                                               &
   662                    &       WaterHeatCap * ( SOTempTent - SOTempTent1st )               &
   663                    &     + SeaIceHeatCap * ( SOTempTent1st - xyz_SOSeaIceTemp(i,j,k) ) &
   664                    &     + LatentHeatFusionBelowSeaIce                                 &
   665                    &   )
   666  
   667                  xy_SOTemp(i,j) = SOTempTent
   668                end if
   669                xyz_SOSIMassEachLayer(i,j,k) = &
   670                  &   xyz_SOSIMassEachLayer(i,j,k) + DelSOSIMass
   671                xy_SOSeaIceMass(i,j) = xy_SOSeaIceMass(i,j) + DelSOSIMass
   672              end if
   673            end do
   674          end if
   675        end do
   676      end do
   677  
   678      do j = 1, jmax
   679        do i = 0, imax-1
   680          if ( xy_SOSeaIceMass(i,j) > SOSeaIceThresholdMass ) then
   681            ! in case with sea ice remained
   682            xy_SurfTemp(i,j) = xy_SurfTemp(i,j)
   683          else if ( xy_SOSeaIceMassSave(i,j) > SOSeaIceThresholdMass ) then
   684            ! in case with sea ice was present but melts completely
   685            xy_SurfTemp(i,j) = xy_SOTemp(i,j)
   686          else
   687            ! in case with sea ice was/is not present
   688  !!$          xy_SurfTemp(i,j) = xy_SurfTemp(i,j)
   689            xy_SurfTemp(i,j) = xy_SOTemp(i,j)
   690          end if
   691        end do
   692      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (.not.xy_soseaicemass(j-1,1).gt.soseaicethresholdmass) then 
     .              if (xy_soseaicemasssave(j-1,1) .gt. soseaicethresholdmass)  
     .       1         then                                                     
     .                 xy_surftemp(j-1,1) = xy_sotemp(j-1,1)                    
     .              else                                                        
     .                 xy_surftemp(j-1,1) = xy_sotemp(j-1,1)                    
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   693  
   694  
   695      do j = 1, jmax
   696        do i = 0, imax-1
   697          if ( xy_FlagSlabOcean(i,j) ) then
   698            if ( xy_SOSeaIceMass(i,j) < 0 ) then
   699              if ( xy_SOSeaIceMass(i,j) < SOSeaIceMassNegativeThreshold ) then
   700                call MessageNotify( 'M', module_name, &
   701                  & '  Slab sea ice mass is negative after diffusion, %f, and this is set to zero.', &
   702                  & d = (/ xy_SOSeaIceMass(i,j) /) )
   703              end if
   704              xy_SOSeaIceMass(i,j) = 0.0_DP
   705            end if
   706          end if
   707        end do
   708      end do
   709  
   710  
   711      ! Check
   712      !
   713      xy_SOSeaIceThickness = xy_SOSeaIceMass / SeaIceDen
     .        d4 = 1.D0/seaiceden                                               
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t978 = 1, jmax*imax                                            
     .           xy_soseaicethickness(t978-1,1) = xy_soseaicemass(t978-1,1)*d4  
     .        enddo                                                             
   714      !
   715      call SOSIUtilsChkSOSeaIce(                &
   716        & xy_SOSeaIceThickness, xyz_SOSeaIceTemp, & ! (in)
   717        & "SOSIDynamics"                        & ! (in)
   718        & )
   719  
   720  
   721    end subroutine SOSIDynamics
   722  
   723    !----------------------------------------------------------------------------
   724  
   725    subroutine SOSIHorTransportFFSL(                    &
   726      & xy_FlagSlabOcean,                               & ! (in)
   727      & xy_SOSeaIceMass,                                & ! (in)
   728      & xy_SurfTemp,                                    & ! (in)
   729      & xyz_SOSeaIceThickness, xyz_SOSeaIceTemp,        & ! (in)
   730      & xy_DSurfTempDt,                                 & ! (out)
   731      & xyz_DSOSeaIceThicknessDt, xyz_DSOSeaIceTempDt   & ! (out)
   732      & )
   733      !
   734      ! Calculates slab sea ice transport by diffusion
   735  
   736      use timeset    , only : DelTime
   737                                ! $\Delta t$
   738      use axesset    , only : x_Lon, y_Lat
   739                                ! $\lambda, \varphai$ lon and lat
   740      use sltt_const , only : dtjw, iexmin, iexmax, jexmin, jexmax
   741      use sosi_dynamics_extarr, only : SLTTExtArrExt2
   742                                ! 配列拡張ルーチン
   743                                ! Expansion of arrays
   744      ! 雪と海氷の定数の設定
   745      ! Setting constants of snow and sea ice
   746      !
   747      use constants_snowseaice, only: &
   748        & SeaIceDen
   749  
   750  
   751      logical , intent(in ) :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
   752      real(DP), intent(in ) :: xy_SOSeaIceMass      (0:imax-1, 1:jmax)
   753      real(DP), intent(in ) :: xy_SurfTemp          (0:imax-1, 1:jmax)
   754  !!!! Modified by M.Ishiwatari (2016-12-10)
   755  !!!!    real(DP), intent(in ) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 1:ksimax)
   756  !!!!    real(DP), intent(in ) :: xyz_SOSeaIceTemp     (0:imax-1, 1:jmax, 1:ksimax)
   757      real(DP), intent(in ) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 0:ksimax)
   758      real(DP), intent(in ) :: xyz_SOSeaIceTemp     (0:imax-1, 1:jmax, 0:ksimax)
   759      real(DP), intent(out) :: xy_DSurfTempDt          (0:imax-1, 1:jmax)
   760  !!!! Modified by M.Ishiwatari (2016-12-10)
   761  !!!!    real(DP), intent(out) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 1:ksimax)
   762  !!!!    real(DP), intent(out) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 1:ksimax)
   763      real(DP), intent(out) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 0:ksimax)
   764      real(DP), intent(out) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 0:ksimax)
   765  
   766  
   767      !
   768      ! local variables
   769      !
   770      real(DP) :: xy_SurfTempA          (0:imax-1, 1:jmax)
   771  !!!! Modified by M.Ishiwatari (2016-12-10)
   772  !!!!    real(DP) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 1:ksimax)
   773  !!!!    real(DP) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 1:ksimax)
   774      real(DP) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 0:ksimax)
   775      real(DP) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 0:ksimax)
   776  
   777      real(DP) :: xy_SOSeaIceMassA      (0:imax-1, 1:jmax)
   778  
   779      real(DP) :: xyza_TMP4DArray(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   780  
   781      real(DP) :: xyza_ExtTMP4DArrayS(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   782                                !
   783                                ! Extended 4D array (SH)
   784      real(DP) :: xyza_ExtTMP4DArrayN(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   785                                !
   786                                ! Extended 4D array (NH)
   787  
   788  !!!! Modified by M.Ishiwatari (2016-12-10)
   789  !!!!    real(DP) :: xyz_ExtSOSeaIceThicknessS(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   790  !!!!    real(DP) :: xyz_ExtSOSeaIceTempS     (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   791  !!!!    real(DP) :: xyz_ExtSurfTempS         (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   792      real(DP) :: xyz_ExtSOSeaIceThicknessS(iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   793      real(DP) :: xyz_ExtSOSeaIceTempS     (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   794      real(DP) :: xyz_ExtSurfTempS         (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   795      real(DP) :: xy_ExtSOSeaIceMassS      (iexmin:iexmax, jexmin:jexmax)
   796                                !
   797                                ! Extended 4D array (SH)
   798  !!!! Modified by M.Ishiwatari (2016-12-10)
   799  !!!!    real(DP) :: xyz_ExtSOSeaIceThicknessN(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   800  !!!!    real(DP) :: xyz_ExtSOSeaIceTempN     (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   801  !!!!    real(DP) :: xyz_ExtSurfTempN         (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   802      real(DP) :: xyz_ExtSOSeaIceThicknessN(iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   803      real(DP) :: xyz_ExtSOSeaIceTempN     (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   804      real(DP) :: xyz_ExtSurfTempN         (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   805      real(DP) :: xy_ExtSOSeaIceMassN      (iexmin:iexmax, jexmin:jexmax)
   806                                !
   807                                ! Extended 4D array (NH)
   808  
   809      logical  :: xy_ExtFlagSlabOceanS(iexmin:iexmax, jexmin:jexmax)
   810                                !
   811                                ! Extended 4D array (SH)
   812      logical  :: xy_ExtFlagSlabOceanN(iexmin:iexmax, jexmin:jexmax)
   813                                !
   814                                ! Extended 4D array (NH)
   815  
   816  !!!! Modified by M.Ishiwatari (2016-12-10)
   817  !!!!    real(DP) :: xyz_DSOSeaIceThicknessDtS(0:imax-1, 1:jmax/2, 1:ksimax)
   818  !!!!    real(DP) :: xyz_DSOSeaIceTempDtS     (0:imax-1, 1:jmax/2, 1:ksimax)
   819  !!!!    real(DP) :: xya_DSurfTempDtS         (0:imax-1, 1:jmax/2, 1:ksimax)
   820  !!!!    real(DP) :: xyz_DSOSeaIceThicknessDtN(0:imax-1, 1:jmax/2, 1:ksimax)
   821  !!!!    real(DP) :: xyz_DSOSeaIceTempDtN     (0:imax-1, 1:jmax/2, 1:ksimax)
   822  !!!!    real(DP) :: xya_DSurfTempDtN         (0:imax-1, 1:jmax/2, 1:ksimax)
   823      real(DP) :: xyz_DSOSeaIceThicknessDtS(0:imax-1, 1:jmax/2, 0:ksimax)
   824      real(DP) :: xyz_DSOSeaIceTempDtS     (0:imax-1, 1:jmax/2, 0:ksimax)
   825      real(DP) :: xya_DSurfTempDtS         (0:imax-1, 1:jmax/2, 0:ksimax)
   826      real(DP) :: xyz_DSOSeaIceThicknessDtN(0:imax-1, 1:jmax/2, 0:ksimax)
   827      real(DP) :: xyz_DSOSeaIceTempDtN     (0:imax-1, 1:jmax/2, 0:ksimax)
   828      real(DP) :: xya_DSurfTempDtN         (0:imax-1, 1:jmax/2, 0:ksimax)
   829  
   830  
   831      real(DP) :: PM
   832      ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。
   833      ! そうでない場合は1.0を与える。
   834      ! Sign change flag for array extension; -1.0 for sign change
   835      ! over the pole, 1.0 for no sign change
   836  
   837  
   838  
   839      integer:: i               ! 東西方向に回る DO ループ用作業変数
   840                                ! Work variables for DO loop in zonal direction
   841      integer:: j               ! 南北方向に回る DO ループ用作業変数
   842                                ! Work variables for DO loop in meridional direction
   843      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   844                                ! Work variables for DO loop in vertical direction
   845      integer:: n               ! 組成方向に回る DO ループ用作業変数
   846                                ! Work variables for DO loop in dimension of constituents
   847      integer:: kk
   848  
   849  
   850      ! 実行文 ; Executable statement
   851      !
   852  
   853      ! 初期化確認
   854      ! Initialization check
   855      !
   856      if ( .not. sosi_dynamics_inited ) then
   857        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   858      end if
   859  
   860  
   861      !
   862      ! Longitudinal diffusion
   863      !
   864  
   865  
   866      call SOSIDiffusionX(                               &
   867        & x_Lon(1)-x_Lon(0), y_CosLat, xy_FlagSlabOcean, & ! (in)
   868        & xy_SOSeaIceMass,                                             & ! (in)
   869        & xy_SurfTemp , xyz_SOSeaIceThickness , xyz_SOSeaIceTemp,      & ! (in)
   870        & xy_SurfTempA, xyz_SOSeaIceThicknessA, xyz_SOSeaIceTempA      & ! (out)
   871        & )
   872  
   873  
   874      xy_SOSeaIceMassA = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t945 = 1, xy_soseaicemassa.DSC.U2*xy_soseaicemassa.DSC.U1 +    
     .       1   xy_soseaicemassa.DSC.U2                                        
     .           xy_soseaicemassa(t945-1,1) = 0.0000000000000000e+000           
     .        enddo                                                             
   875      do k = 1, ksimax
   876        xy_SOSeaIceMassA = xy_SOSeaIceMassA &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_soseaicemassa)                                          
     .        do t951 = 1, xy_soseaicemassa.DSC.U2*xy_soseaicemassa.DSC.U1 +    
     .       1   xy_soseaicemassa.DSC.U2                                        
     .           xy_soseaicemassa(t951-1,1) = xy_soseaicemassa(t951-1,1) +      
     .       1      seaiceden*xyz_soseaicethicknessa(t951-1,1,k)                
     .        enddo                                                             
   877          & + SeaIceDen * xyz_SOSeaIceThicknessA(:,:,k)
   878      end do
   879  
   880  
   881      !
   882      ! Latitudinal diffusion
   883      !
   884  
   885      ! 配列の分割と拡張
   886      ! Division and extension of arrays
   887      !
   888  
   889      if ( ksimax > kmax ) then
   890        call MessageNotify( 'E', module_name, 'ksimax > kmax.' )
   891      end if
   892      if ( kmax < 3 ) then
   893        call MessageNotify( 'E', module_name, 'kmax < 3.' )
   894      end if
   895      if ( ncmax < 3 ) then
   896        call MessageNotify( 'E', module_name, 'ncmax < 3.' )
   897      end if
   898  
   899  
   900      n = 1
   901      do k = 1, ksimax
   902        xyza_TMP4DArray(:,:,k,n) = xyz_SOSeaIceThicknessA(:,:,k)
   903      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, ksimax*(xyza_tmp4darray.DSC.U2*xyza_tmp4darray.DSC.U1 + 
     .       1   xyza_tmp4darray.DSC.U2)                                        
     .           xyza_tmp4darray(k-1,1,1,1) = xyz_soseaicethicknessa(k-1,1,1)   
     .        enddo                                                             
   904      do k = ksimax+1, kmax
   905        xyza_TMP4DArray(:,:,k,n) = 0.0_DP
   906      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - ksimax)*(xyza_tmp4darray.DSC.U2*                
     .       1   xyza_tmp4darray.DSC.U1 + xyza_tmp4darray.DSC.U2)               
     .           xyza_tmp4darray(k-1,1,1+ksimax,1) = 0.0000000000000000e+000    
     .        enddo                                                             
   907      !
   908      n = 2
   909      do k = 1, ksimax
   910        xyza_TMP4DArray(:,:,k,n) = xyz_SOSeaIceTempA(:,:,k)
   911      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, ksimax*(xyza_tmp4darray.DSC.U2*xyza_tmp4darray.DSC.U1 + 
     .       1   xyza_tmp4darray.DSC.U2)                                        
     .           xyza_tmp4darray(k-1,1,1,2) = xyz_soseaicetempa(k-1,1,1)        
     .        enddo                                                             
   912      do k = ksimax+1, kmax
   913        xyza_TMP4DArray(:,:,k,n) = 0.0_DP
   914      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - ksimax)*(xyza_tmp4darray.DSC.U2*                
     .       1   xyza_tmp4darray.DSC.U1 + xyza_tmp4darray.DSC.U2)               
     .           xyza_tmp4darray(k-1,1,1+ksimax,2) = 0.0000000000000000e+000    
     .        enddo                                                             
   915      !
   916      n = 3
   917      k = 1
   918      do j = 1, jmax
   919        do i = 0, imax-1
   920          if ( xy_FlagSlabOcean(i,j) ) then
   921            xyza_TMP4DArray(i,j,k,n) = 1.0_DP
   922          else
   923            xyza_TMP4DArray(i,j,k,n) = 0.0_DP
   924          end if
   925        end do
   926      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_flagslabocean(j-1,1) .ne. 0) then                       
     .              xyza_tmp4darray1 = 1.00000000000000e+000                    
     .           else                                                           
     .              xyza_tmp4darray1 = 0.0000000000000000e+000                  
     .           endif                                                          
     .           xyza_tmp4darray(j-1,1,1,3) = xyza_tmp4darray1                  
     .        enddo                                                             
   927      k = 2
   928      xyza_TMP4DArray(:,:,k,n) = xy_SurfTempA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t989 = 1, xyza_tmp4darray.DSC.U2*xyza_tmp4darray.DSC.U1 +      
     .       1   xyza_tmp4darray.DSC.U2                                         
     .           xyza_tmp4darray(t989-1,1,2,3) = xy_surftempa(t989-1,1)         
     .        enddo                                                             
   929      k = 3
   930      xyza_TMP4DArray(:,:,k,n) = xy_SOSeaIceMassA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_soseaicemassa)                                          
     .        do t997 = 1, xyza_tmp4darray.DSC.U2*xyza_tmp4darray.DSC.U1 +      
     .       1   xyza_tmp4darray.DSC.U2                                         
     .           xyza_tmp4darray(t997-1,1,3,3) = xy_soseaicemassa(t997-1,1)     
     .        enddo                                                             
   931      do k = 3+1, kmax
   932        xyza_TMP4DArray(:,:,k,n) = 0.0_DP
   933      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 3)*(xyza_tmp4darray.DSC.U2*                     
     .       1   xyza_tmp4darray.DSC.U1 + xyza_tmp4darray.DSC.U2)               
     .           xyza_tmp4darray(k-1,1,4,3) = 0.0000000000000000e+000           
     .        enddo                                                             
   934      !
   935      do n = 3+1, ncmax
   936        xyza_TMP4DArray(:,:,:,n) = 0.0_DP
   937      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do n = 1, (ncmax - 3)*xyza_tmp4darray.DSC.U3*                     
     .       1   xyza_tmp4darray.DSC.U2*(xyza_tmp4darray.DSC.U1 + 1)            
     .           xyza_tmp4darray(n-1,1,1,4) = 0.0000000000000000e+000           
     .        enddo                                                             
   938  
   939      PM = 1.0_DP
   940      call SLTTExtArrExt2(                            &
   941        & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   942        & xyza_TMP4DArray, PM,                        & ! (in)
   943        & xyza_ExtTMP4DArrayS, xyza_ExtTMP4DArrayN    & ! (out)
   944        & )
   945  
   946      n = 1
   947      do k = 1, ksimax
   948        xyz_ExtSOSeaIceThicknessS(:,:,k) = xyza_ExtTMP4DArrayS(:,:,k,n)
   949        xyz_ExtSOSeaIceThicknessN(:,:,k) = xyza_ExtTMP4DArrayN(:,:,k,n)
   950      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, ksimax*(xyz_extsoseaicethicknesss.DSC.U2 + 1 -          
     .       1   xyz_extsoseaicethicknesss.DSC.L2)*(                            
     .       2   xyz_extsoseaicethicknesss.DSC.U1 + 1 -                         
     .       3   xyz_extsoseaicethicknesss.DSC.L1)                              
     .           xyz_extsoseaicethicknesss(xyz_extsoseaicethicknesss.DSC.L1+k-1,
     .       1      xyz_extsoseaicethicknesss.DSC.L2,1) = xyza_exttmp4darrays(  
     .       2      xyza_exttmp4darrays.DSC.L1+k-1,xyza_exttmp4darrays.DSC.L2,1,
     .       3      1)                                                          
     .           xyz_extsoseaicethicknessn(xyz_extsoseaicethicknessn.DSC.L1+k-1,
     .       1      xyz_extsoseaicethicknessn.DSC.L2,1) = xyza_exttmp4darrayn(  
     .       2      xyza_exttmp4darrayn.DSC.L1+k-1,xyza_exttmp4darrayn.DSC.L2,1,
     .       3      1)                                                          
     .        enddo                                                             
   951      n = 2
   952      do k = 1, ksimax
   953        xyz_ExtSOSeaIceTempS     (:,:,k) = xyza_ExtTMP4DArrayS(:,:,k,n)
   954        xyz_ExtSOSeaIceTempN     (:,:,k) = xyza_ExtTMP4DArrayN(:,:,k,n)
   955      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, ksimax*(xyz_extsoseaicetemps.DSC.U2 + 1 -               
     .       1   xyz_extsoseaicetemps.DSC.L2)*(xyz_extsoseaicetemps.DSC.U1 + 1  
     .       2    - xyz_extsoseaicetemps.DSC.L1)                                
     .           xyz_extsoseaicetemps(xyz_extsoseaicetemps.DSC.L1+k-1,          
     .       1      xyz_extsoseaicetemps.DSC.L2,1) = xyza_exttmp4darrays(       
     .       2      xyza_exttmp4darrays.DSC.L1+k-1,xyza_exttmp4darrays.DSC.L2,1,
     .       3      2)                                                          
     .           xyz_extsoseaicetempn(xyz_extsoseaicetempn.DSC.L1+k-1,          
     .       1      xyz_extsoseaicetempn.DSC.L2,1) = xyza_exttmp4darrayn(       
     .       2      xyza_exttmp4darrayn.DSC.L1+k-1,xyza_exttmp4darrayn.DSC.L2,1,
     .       3      2)                                                          
     .        enddo                                                             
   956      n = 3
   957      k = 1
   958      do j = jexmin, jexmax
   959        do i = iexmin, iexmax
   960          if ( xyza_ExtTMP4DArrayS(i,j,k,n) == 1.0_DP ) then
   961            xy_ExtFlagSlabOceanS(i,j) = .true.
   962          else
   963            xy_ExtFlagSlabOceanS(i,j) = .false.
   964          end if
   965          if ( xyza_ExtTMP4DArrayN(i,j,k,n) == 1.0_DP ) then
   966            xy_ExtFlagSlabOceanN(i,j) = .true.
   967          else
   968            xy_ExtFlagSlabOceanN(i,j) = .false.
   969          end if
   970        end do
   971      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, (jexmax + 1 - jexmin)*(iexmax + 1 - iexmin)             
     .           if (xyza_exttmp4darrays(iexmin+j-1,jexmin,1,3) .eq.            
     .       1      1.00000000000000e+000) then                                 
     .              xy_extflagslaboceans1 = 1                                   
     .           else                                                           
     .              xy_extflagslaboceans1 = 0                                   
     .           endif                                                          
     .           xy_extflagslaboceans(iexmin+j-1,jexmin) = xy_extflagslaboceans1
     .           if (xyza_exttmp4darrayn(iexmin+j-1,jexmin,1,3) .eq.            
     .       1      1.00000000000000e+000) then                                 
     .              xy_extflagslaboceann2 = 1                                   
     .           else                                                           
     .              xy_extflagslaboceann2 = 0                                   
     .           endif                                                          
     .           xy_extflagslaboceann(iexmin+j-1,jexmin) = xy_extflagslaboceann2
     .        enddo                                                             
   972      k = 2
   973      do kk = 1, ksimax
   974        xyz_ExtSurfTempS(:,:,kk) = xyza_ExtTMP4DArrayS(:,:,k,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyza_exttmp4darrays,xyza_exttmp4darrayn)                   
     .        do t1044 = 1, (xyz_extsurftemps.DSC.U2 + 1 -                      
     .       1   xyz_extsurftemps.DSC.L2)*(xyz_extsurftemps.DSC.U1 + 1 -        
     .       2   xyz_extsurftemps.DSC.L1)                                       
     .           xyz_extsurftemps(xyz_extsurftemps.DSC.L1+t1044-1,              
     .       1      xyz_extsurftemps.DSC.L2,kk) = xyza_exttmp4darrays(          
     .       2      xyza_exttmp4darrays.DSC.L1+t1044-1,                         
     .       3      xyza_exttmp4darrays.DSC.L2,2,3)                             
     .           xyz_extsurftempn(xyz_extsurftempn.DSC.L1+t1044-1,              
     .       1      xyz_extsurftempn.DSC.L2,kk) = xyza_exttmp4darrayn(          
     .       2      xyza_exttmp4darrayn.DSC.L1+t1044-1,                         
     .       3      xyza_exttmp4darrayn.DSC.L2,2,3)                             
     .        enddo                                                             
   975        xyz_ExtSurfTempN(:,:,kk) = xyza_ExtTMP4DArrayN(:,:,k,n)
   976      end do
   977      k = 3
   978      do kk = 1, ksimax
   979        xy_ExtSOSeaIceMassS = xyza_ExtTMP4DArrayS(:,:,k,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyza_exttmp4darrays,xyza_exttmp4darrayn,xy_extsoseaicemasss
     .       1   ,xy_extsoseaicemassn)                                          
     .        do t1056 = 1, (xy_extsoseaicemasss.DSC.U2 + 1 -                   
     .       1   xy_extsoseaicemasss.DSC.L2)*(xy_extsoseaicemasss.DSC.U1 + 1 -  
     .       2   xy_extsoseaicemasss.DSC.L1)                                    
     .           xy_extsoseaicemasss(xy_extsoseaicemasss.DSC.L1+t1056-1,        
     .       1      xy_extsoseaicemasss.DSC.L2) = xyza_exttmp4darrays(          
     .       2      xyza_exttmp4darrays.DSC.L1+t1056-1,                         
     .       3      xyza_exttmp4darrays.DSC.L2,3,3)                             
     .           xy_extsoseaicemassn(xy_extsoseaicemassn.DSC.L1+t1056-1,        
     .       1      xy_extsoseaicemassn.DSC.L2) = xyza_exttmp4darrayn(          
     .       2      xyza_exttmp4darrayn.DSC.L1+t1056-1,                         
     .       3      xyza_exttmp4darrayn.DSC.L2,3,3)                             
     .        enddo                                                             
   980        xy_ExtSOSeaIceMassN = xyza_ExtTMP4DArrayN(:,:,k,n)
   981      end do
   982  
   983  
   984  !!$    call SSIDiffusion(                             &
   985  !!$      & x_ExtLonS, y_ExtLatS, y_ExtCosLatS,        & ! (in)
   986  !!$      & p_LonS, q_LatS, q_CosLatS,                 & ! (in)
   987  !!$      & xy_ExtFlagSlabOceanS, xy_ExtSOSeaIceMassS, & ! (in)
   988  !!$      & xy_DSOSeaIceMassDtS                        & ! (out)
   989  !!$      & )
   990  !!$    call SSIDiffusion(                             &
   991  !!$      & x_ExtLonN, y_ExtLatN, y_ExtCosLatN,        & ! (in)
   992  !!$      & p_LonN, q_LatN, q_CosLatN,                 & ! (in)
   993  !!$      & xy_ExtFlagSlabOceanN, xy_ExtSOSeaIceMassN, & ! (in)
   994  !!$      & xy_DSOSeaIceMassDtN                        & ! (out)
   995  !!$      & )
   996  
   997      call SOSIDiffusionY(                                 &
   998        & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
   999        & q_LatS, q_CosLatS,                               & ! (in)
  1000        & xy_ExtFlagSlabOceanS, xyz_ExtSOSeaIceThicknessS, & ! (in)
  1001        & xyz_DSOSeaIceThicknessDtS                        & ! (out)
  1002        & )
  1003      call SOSIDiffusionY(                                 &
  1004        & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1005        & q_LatN, q_CosLatN,                               & ! (in)
  1006        & xy_ExtFlagSlabOceanN, xyz_ExtSOSeaIceThicknessN, & ! (in)
  1007        & xyz_DSOSeaIceThicknessDtN                        & ! (out)
  1008        & )
  1009      !
  1010      call SOSIDiffusionY(                                 &
  1011        & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1012        & q_LatS, q_CosLatS,                               & ! (in)
  1013        & xy_ExtFlagSlabOceanS, xyz_ExtSOSeaIceTempS, & ! (in)
  1014        & xyz_DSOSeaIceTempDtS                        & ! (out)
  1015        & )
  1016      call SOSIDiffusionY(                                 &
  1017        & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1018        & q_LatN, q_CosLatN,                               & ! (in)
  1019        & xy_ExtFlagSlabOceanN, xyz_ExtSOSeaIceTempN, & ! (in)
  1020        & xyz_DSOSeaIceTempDtN                        & ! (out)
  1021        & )
  1022      !
  1023      call SOSIDiffusionY(                                 &
  1024        & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1025        & q_LatS, q_CosLatS,                               & ! (in)
  1026        & xy_ExtFlagSlabOceanS, xyz_ExtSurfTempS,     & ! (in)
  1027        & xya_DSurfTempDtS,                           & ! (out)
  1028        & xy_ExtSOSeaIceMassS                         & ! (in) optional
  1029        & )
  1030      call SOSIDiffusionY(                                 &
  1031        & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1032        & q_LatN, q_CosLatN,                               & ! (in)
  1033        & xy_ExtFlagSlabOceanN, xyz_ExtSurfTempN,     & ! (in)
  1034        & xya_DSurfTempDtN,                           & ! (out)
  1035        & xy_ExtSOSeaIceMassN                         & ! (in) optional
  1036        & )
  1037  
  1038      xyz_DSOSeaIceThicknessDt(:,1:jmax/2     ,:) = xyz_DSOSeaIceThicknessDtS(:,1:jmax/2,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1070 = 1, (jmax/2)*imax                                       
     .           xyz_dsoseaicethicknessdt(t1070-1,1,t1068) =                    
     .       1      xyz_dsoseaicethicknessdts(t1070-1,1,t1068)                  
     .        enddo                                                             
  1039      xyz_DSOSeaIceThicknessDt(:,jmax/2+1:jmax,:) = xyz_DSOSeaIceThicknessDtN(:,1:jmax/2,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1082 = 1, (jmax - jmax/2)*imax                                
     .           xyz_dsoseaicethicknessdt(t1082-1,1+jmax/2,t1080) =             
     .       1      xyz_dsoseaicethicknessdtn(t1082-1,1,t1080)                  
     .           xyz_dsoseaicetempdt(t1082-1,1,t1080) = xyz_dsoseaicetempdts(   
     .       1      t1082-1,1,t1080)                                            
     .        enddo                                                             
  1040      !
  1041      xyz_DSOSeaIceTempDt(:,1:jmax/2     ,:) = xyz_DSOSeaIceTempDtS(:,1:jmax/2,:)
  1042      xyz_DSOSeaIceTempDt(:,jmax/2+1:jmax,:) = xyz_DSOSeaIceTempDtN(:,1:jmax/2,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1100 = 1, (jmax - jmax/2)*imax                                
     .           xyz_dsoseaicetempdt(t1100-1,1+jmax/2,t1098) =                  
     .       1      xyz_dsoseaicetempdtn(t1100-1,1,t1098)                       
     .        enddo                                                             
  1043      !
  1044      xy_DSurfTempDt(:,1:jmax/2     ) = xya_DSurfTempDtS(:,1:jmax/2,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1110 = 1, (jmax/2)*imax                                       
     .           xy_dsurftempdt(t1110-1,1) = xya_dsurftempdts(t1110-1,1,1)      
     .        enddo                                                             
  1045      xy_DSurfTempDt(:,jmax/2+1:jmax) = xya_DSurfTempDtN(:,1:jmax/2,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1118 = 1, (jmax - jmax/2)*imax                                
     .           xy_dsurftempdt(t1118-1,1+jmax/2)=xya_dsurftempdtn(t1118-1,1,1) 
     .        enddo                                                             
  1046  
  1047  
  1048  !!$    ! sea ice mass at next time step is calculated temporarily
  1049  !!$    xy_SOSeaIceMassA = xy_SOSeaIceMassA &
  1050  !!$      & + xy_DSOSeaIceMassDt * ( 2.0_DP * DelTime )
  1051  !!$
  1052  !!$    ! tendency is calculated
  1053  !!$    xy_DSOSeaIceMassDt = &
  1054  !!$      & ( xy_SOSeaIceMassA - xy_SOSeaIceMassB ) / ( 2.0_DP * DelTime )
  1055  
  1056  
  1057  !!$    py_ExtSOSeaIceMassXFlux = 0.0_DP
  1058  !!$    xq_ExtSOSeaIceMassYFlux = 0.0_DP
  1059  !!$    do j = jexmin, jexmax-1
  1060  !!$      do i = iexmin, iexmax-1
  1061  !!$        py_ExtSOSeaIceMassXFlux(i,j) = &
  1062  !!$          & - SOSeaIceDiffCoef &
  1063  !!$          &   * ( xy_ExtSOSeaIceMassS(i+1,j) - xy_ExtSOSeaIceMassS(i,j) ) &
  1064  !!$          &   / ( RPlanet * y_CosLatS(j) * ( x_ExtLonS(i+1) - x_ExtLonS(i) ) )
  1065  !!$        xq_ExtSOSeaIceMassYFlux(i,j) = &
  1066  !!$          & - SOSeaIceDiffCoef &
  1067  !!$          &   * ( xy_ExtSOSeaIceMassS(i,j+1) - xy_ExtSOSeaIceMassS(i,j) ) &
  1068  !!$          &   / ( RPlanet * ( y_ExtLatS(j+1) - y_ExtLatS(j) ) )
  1069  !!$      end do
  1070  !!$    end do
  1071  !!$    if ( myrank == nprocs-1 ) then
  1072  !!$      j = 0
  1073  !!$      do i = iexmin, iexmax-1
  1074  !!$        xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1075  !!$      end do
  1076  !!$    end if
  1077  !!$
  1078  !!$    do j = 1, jmax
  1079  !!$      do i = 0, imax-1
  1080  !!$        xy_DSOSeaIceMassDt(i,j) = &
  1081  !!$          & - ( py_ExtSOSeaIceMassXFlux(i,j) - py_ExtSOSeaIceMassXFlux(i-1,j) ) &
  1082  !!$          &   / ( RPlanet * y_CosLatS(j) * ( p_Lon(i) - p_Lon(i-1) ) ) &
  1083  !!$          & - (   xq_ExtSOSeaIceMassYFlux(i,j  ) * q_CosLatS(j  )   &
  1084  !!$          &     - xq_ExtSOSeaIceMassYFlux(i,j-1) * q_CosLatS(j-1) ) &
  1085  !!$          &   / ( RPlanet * y_CosLatS(j) * ( q_LatS(j) - q_LatS(j-1) ) )
  1086  !!$      end do
  1087  !!$    end do
  1088  
  1089  
  1090  
  1091  
  1092    end subroutine SOSIHorTransportFFSL
  1093  
  1094    !----------------------------------------------------------------------------
  1095  
  1096  !!$  subroutine SOSIFFSLX(                          &
  1097  !!$    & DelLon, y_CosLat, xy_FlagSlabOcean,        & ! (in)
  1098  !!$    & xy_SOSeaIceMass,                           & ! (in)
  1099  !!$    & xy_SurfTemp , xyz_SOSeaIceThickness , xyz_SOSeaIceTemp,  & ! (in)
  1100  !!$    & xy_SurfTempA, xyz_SOSeaIceThicknessA, xyz_SOSeaIceTempA  & ! (out)
  1101  !!$    & )
  1102  !!$    !
  1103  !!$    ! Calculates slab sea ice transport by longitudinal diffusion
  1104  !!$
  1105  !!$
  1106  !!$    !
  1107  !!$    !
  1108  !!$    use ludecomp_module, only : &
  1109  !!$      & ludecomp_prep_simple_many, &
  1110  !!$      & ludecomp_solve_simple_many
  1111  !!$
  1112  !!$    use constants, only: &
  1113  !!$      & RPlanet, &
  1114  !!$      ! $ a $ [m].
  1115  !!$      ! 惑星半径.
  1116  !!$      ! Radius of planet
  1117  !!$      & SOMass
  1118  !!$                              ! Slab ocean mass
  1119  !!$
  1120  !!$    real(DP), intent(in ) :: DelLon
  1121  !!$    real(DP), intent(in ) :: y_CosLat(1:jmax)
  1122  !!$    logical , intent(in ) :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
  1123  !!$    real(DP), intent(in ) :: xy_SOSeaIceMass       (0:imax-1, 1:jmax)
  1124  !!$    real(DP), intent(in ) :: xy_SurfTemp           (0:imax-1, 1:jmax)
  1125  !!$    real(DP), intent(in ) :: xyz_SOSeaIceThickness (0:imax-1, 1:jmax, 1:ksimax)
  1126  !!$    real(DP), intent(in ) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
  1127  !!$    real(DP), intent(out) :: xy_SurfTempA          (0:imax-1, 1:jmax)
  1128  !!$    real(DP), intent(out) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 1:ksimax)
  1129  !!$    real(DP), intent(out) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 1:ksimax)
  1130  !!$
  1131  !!$    !
  1132  !!$    ! local variables
  1133  !!$    !
  1134  !!$    real(DP) :: SOSeaIceU0 = 0.1_DP
  1135  !!$
  1136  !!$    real(DP) :: y_Factor(1:jmax)
  1137  !!$
  1138  !!$    real(DP) :: py_SOSeaIceU(0:imax-1, 1:jmax)
  1139  !!$                              !
  1140  !!$                              ! Longitudional Flux of slab sea ice
  1141  !!$
  1142  !!$    integer:: i            ! 東西方向に回る DO ループ用作業変数
  1143  !!$                           ! Work variables for DO loop in zonal direction
  1144  !!$    integer:: j            ! 南北方向に回る DO ループ用作業変数
  1145  !!$                           ! Work variables for DO loop in meridional direction
  1146  !!$    integer:: k
  1147  !!$
  1148  !!$    integer:: l
  1149  !!$    integer:: ii
  1150  !!$    integer:: iprev
  1151  !!$    integer:: inext
  1152  !!$
  1153  !!$
  1154  !!$    ! 実行文 ; Executable statement
  1155  !!$    !
  1156  !!$
  1157  !!$    ! 初期化確認
  1158  !!$    ! Initialization check
  1159  !!$    !
  1160  !!$    if ( .not. sosi_dynamics_inited ) then
  1161  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1162  !!$    end if
  1163  !!$
  1164  !!$
  1165  !!$    y_Factor = 1.0_DP / ( RPlanet * y_CosLat * DelLon )**2
  1166  !!$
  1167  !!$    ! grid arrangement
  1168  !!$    !
  1169  !!$    !       |   .   |   .   |   .   |   .   |   .   |   .
  1170  !!$    !
  1171  !!$    ! x         0       1       2       3       4
  1172  !!$    ! p             0       1       2       3       4
  1173  !!$    !
  1174  !!$    do j = 1, jmax
  1175  !!$      do i = 0, imax-1
  1176  !!$        if ( i == imax-1 ) then
  1177  !!$          iprev = i
  1178  !!$          inext = 0
  1179  !!$        else
  1180  !!$          iprev = i
  1181  !!$          inext = i+1
  1182  !!$        end if
  1183  !!$        if ( xy_FlagSlabOcean(iprev,j) .and. xy_FlagSlabOcean(inext,j) ) then
  1184  !!$          py_SOSeaIceU(i,j) = SOSeaIceU0
  1185  !!$        else
  1186  !!$          py_SOSeaIceU(i,j) = 0.0_DP
  1187  !!$        end if
  1188  !!$      end do
  1189  !!$    end do
  1190  !!$
  1191  !!$!    do i = 0, imax-1
  1192  !!$!      p_Lon(i) = DelLon / 2.0_DP + DelLon * i
  1193  !!$!    end do
  1194  !!$    p_Lon = x_Lon + ( x_Lon(1) - x_Lon(0) ) / 2.0_DP
  1195  !!$
  1196  !!$    ! Departure point
  1197  !!$    do j = 1, jmax
  1198  !!$      py_DPLon(:,j) = &
  1199  !!$        & p_Lon - py_SOSeaIceU(:,j) * DelTime / ( RPlanet * y_CosLat(j) )
  1200  !!$    end do
  1201  !!$    do j = 1, jmax
  1202  !!$      do i = 0, imax-1
  1203  !!$        if ( py_DPLon(i,j) < 0.0_DP ) then
  1204  !!$          py_DPLon(i,j) = py_DPLon(i,j) + 2.0_DP * PI
  1205  !!$        else if ( py_DPLon(i,j) > 2.0_DP * PI ) then
  1206  !!$          py_DPLon(i,j) = py_DPLon(i,j) - 2.0_DP * PI
  1207  !!$        end if
  1208  !!$      end do
  1209  !!$    end do
  1210  !!$
  1211  !!$    do j = 1, jmax
  1212  !!$      do i = 0, imax-1
  1213  !!$        dp_search : do ii = 0, imax-1
  1214  !!$          if ( py_DPLon(i,j) <= p_Lon(ii) ) then
  1215  !!$            exit dp_search
  1216  !!$          end if
  1217  !!$        end do dp_search
  1218  !!$        py_DPIndex
  1219  !!$        if (
  1220  !!$        py_SOSeaIceDPLon(i,j) = p_Lon
  1221  !!$      end do
  1222  !!$    end do
  1223  !!$
  1224  !!$
  1225  !!$
  1226  !!$
  1227  !!$  end subroutine SOSIFFSLX
  1228  
  1229    !----------------------------------------------------------------------------
  1230  
  1231    subroutine SOSIHorTransportDiff(                    &
  1232      & xy_FlagSlabOcean,                               & ! (in)
  1233      & xy_SOSeaIceMass,                                & ! (in)
  1234      & xy_SurfTemp,                                    & ! (in)
  1235      & xyz_SOSeaIceThickness, xyz_SOSeaIceTemp,        & ! (in)
  1236      & xy_DSurfTempDt,                                 & ! (out)
  1237      & xyz_DSOSeaIceThicknessDt, xyz_DSOSeaIceTempDt   & ! (out)
  1238      & )
  1239      !
  1240      ! Calculates slab sea ice transport by diffusion
  1241  
  1242      use timeset    , only : DelTime
  1243                                ! $\Delta t$
  1244      use axesset    , only : x_Lon, y_Lat
  1245                                ! $\lambda, \varphai$ lon and lat
  1246      use sltt_const , only : dtjw, iexmin, iexmax, jexmin, jexmax
  1247      use sosi_dynamics_extarr, only : SLTTExtArrExt2
  1248                                ! 配列拡張ルーチン
  1249                                ! Expansion of arrays
  1250      ! 雪と海氷の定数の設定
  1251      ! Setting constants of snow and sea ice
  1252      !
  1253      use constants_snowseaice, only: &
  1254        & SeaIceDen
  1255  
  1256  
  1257      logical , intent(in ) :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
  1258      real(DP), intent(in ) :: xy_SOSeaIceMass      (0:imax-1, 1:jmax)
  1259      real(DP), intent(in ) :: xy_SurfTemp          (0:imax-1, 1:jmax)
  1260  !!!! Modified by M.Ishiwatari (2016-12-10)
  1261  !!!!    real(DP), intent(in ) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 1:ksimax)
  1262  !!!!    real(DP), intent(in ) :: xyz_SOSeaIceTemp     (0:imax-1, 1:jmax, 1:ksimax)
  1263      real(DP), intent(in ) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 0:ksimax)
  1264      real(DP), intent(in ) :: xyz_SOSeaIceTemp     (0:imax-1, 1:jmax, 0:ksimax)
  1265      real(DP), intent(out) :: xy_DSurfTempDt          (0:imax-1, 1:jmax)
  1266  !!!! Modified by M.Ishiwatari (2016-12-10)
  1267  !!!!    real(DP), intent(out) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 1:ksimax)
  1268  !!!!    real(DP), intent(out) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 1:ksimax)
  1269      real(DP), intent(out) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 0:ksimax)
  1270      real(DP), intent(out) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 0:ksimax)
  1271  
  1272  
  1273      !
  1274      ! local variables
  1275      !
  1276      real(DP) :: xy_SurfTempA          (0:imax-1, 1:jmax)
  1277  !!!! Modified by M.Ishiwatari (2016-12-10)
  1278  !!!!    real(DP) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 1:ksimax)
  1279  !!!!    real(DP) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 1:ksimax)
  1280      real(DP) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 0:ksimax)
  1281      real(DP) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 0:ksimax)
  1282  
  1283      real(DP) :: xy_SOSeaIceMassA      (0:imax-1, 1:jmax)
  1284  
  1285      real(DP) :: xyza_TMP4DArray(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1286  
  1287      real(DP) :: xyza_ExtTMP4DArrayS(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1288                                !
  1289                                ! Extended 4D array (SH)
  1290      real(DP) :: xyza_ExtTMP4DArrayN(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1291                                !
  1292                                ! Extended 4D array (NH)
  1293  
  1294      real(DP) :: xyz_ExtSOSeaIceThicknessS(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1295      real(DP) :: xyz_ExtSOSeaIceTempS     (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1296      real(DP) :: xyz_ExtSurfTempS         (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1297      real(DP) :: xy_ExtSOSeaIceMassS      (iexmin:iexmax, jexmin:jexmax)
  1298                                !
  1299                                ! Extended 4D array (SH)
  1300  !!!! Modified by M.Ishiwatari (2016-12-10)
  1301  !!!!    real(DP) :: xyz_ExtSOSeaIceThicknessN(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1302  !!!!    real(DP) :: xyz_ExtSOSeaIceTempN     (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1303  !!!!    real(DP) :: xyz_ExtSurfTempN         (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1304      real(DP) :: xyz_ExtSOSeaIceThicknessN(iexmin:iexmax, jexmin:jexmax, 0:ksimax)
  1305      real(DP) :: xyz_ExtSOSeaIceTempN     (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
  1306      real(DP) :: xyz_ExtSurfTempN         (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
  1307      real(DP) :: xy_ExtSOSeaIceMassN      (iexmin:iexmax, jexmin:jexmax)
  1308                                !
  1309                                ! Extended 4D array (NH)
  1310  
  1311      logical  :: xy_ExtFlagSlabOceanS(iexmin:iexmax, jexmin:jexmax)
  1312                                !
  1313                                ! Extended 4D array (SH)
  1314      logical  :: xy_ExtFlagSlabOceanN(iexmin:iexmax, jexmin:jexmax)
  1315                                !
  1316                                ! Extended 4D array (NH)
  1317  
  1318  !!!! Modified by M.Ishiwatari (2016-12-10)
  1319  !!!!    real(DP) :: xyz_DSOSeaIceThicknessDtS(0:imax-1, 1:jmax/2, 1:ksimax)
  1320  !!!!    real(DP) :: xyz_DSOSeaIceTempDtS     (0:imax-1, 1:jmax/2, 1:ksimax)
  1321  !!!!    real(DP) :: xya_DSurfTempDtS         (0:imax-1, 1:jmax/2, 1:ksimax)
  1322  !!!!    real(DP) :: xyz_DSOSeaIceThicknessDtN(0:imax-1, 1:jmax/2, 1:ksimax)
  1323  !!!!    real(DP) :: xyz_DSOSeaIceTempDtN     (0:imax-1, 1:jmax/2, 1:ksimax)
  1324  !!!!    real(DP) :: xya_DSurfTempDtN         (0:imax-1, 1:jmax/2, 1:ksimax)
  1325  
  1326      real(DP) :: xyz_DSOSeaIceThicknessDtS(0:imax-1, 1:jmax/2, 0:ksimax)
  1327      real(DP) :: xyz_DSOSeaIceTempDtS     (0:imax-1, 1:jmax/2, 0:ksimax)
  1328      real(DP) :: xya_DSurfTempDtS         (0:imax-1, 1:jmax/2, 0:ksimax)
  1329      real(DP) :: xyz_DSOSeaIceThicknessDtN(0:imax-1, 1:jmax/2, 0:ksimax)
  1330      real(DP) :: xyz_DSOSeaIceTempDtN     (0:imax-1, 1:jmax/2, 0:ksimax)
  1331      real(DP) :: xya_DSurfTempDtN         (0:imax-1, 1:jmax/2, 0:ksimax)
  1332  
  1333  
  1334  
  1335      real(DP) :: PM
  1336      ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。
  1337      ! そうでない場合は1.0を与える。
  1338      ! Sign change flag for array extension; -1.0 for sign change
  1339      ! over the pole, 1.0 for no sign change
  1340  
  1341  
  1342  
  1343      integer:: i               ! 東西方向に回る DO ループ用作業変数
  1344                                ! Work variables for DO loop in zonal direction
  1345      integer:: j               ! 南北方向に回る DO ループ用作業変数
  1346                                ! Work variables for DO loop in meridional direction
  1347      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1348                                ! Work variables for DO loop in vertical direction
  1349      integer:: n               ! 組成方向に回る DO ループ用作業変数
  1350                                ! Work variables for DO loop in dimension of constituents
  1351      integer:: kk
  1352  
  1353  
  1354      ! 実行文 ; Executable statement
  1355      !
  1356  
  1357      ! 初期化確認
  1358      ! Initialization check
  1359      !
  1360      if ( .not. sosi_dynamics_inited ) then
  1361        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1362      end if
  1363  
  1364  
  1365      !
  1366      ! Longitudinal diffusion
  1367      !
  1368  
  1369  
  1370      call SOSIDiffusionX(                               &
  1371        & x_Lon(1)-x_Lon(0), y_CosLat, xy_FlagSlabOcean, & ! (in)
  1372        & xy_SOSeaIceMass,                                             & ! (in)
  1373        & xy_SurfTemp , xyz_SOSeaIceThickness , xyz_SOSeaIceTemp,      & ! (in)
  1374        & xy_SurfTempA, xyz_SOSeaIceThicknessA, xyz_SOSeaIceTempA      & ! (out)
  1375        & )
  1376  
  1377  
  1378      xy_SOSeaIceMassA = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t945 = 1, xy_soseaicemassa.DSC.U2*xy_soseaicemassa.DSC.U1 +    
     .       1   xy_soseaicemassa.DSC.U2                                        
     .           xy_soseaicemassa(t945-1,1) = 0.0000000000000000e+000           
     .        enddo                                                             
  1379      do k = 1, ksimax
  1380        xy_SOSeaIceMassA = xy_SOSeaIceMassA &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_soseaicemassa)                                          
     .        do t951 = 1, xy_soseaicemassa.DSC.U2*xy_soseaicemassa.DSC.U1 +    
     .       1   xy_soseaicemassa.DSC.U2                                        
     .           xy_soseaicemassa(t951-1,1) = xy_soseaicemassa(t951-1,1) +      
     .       1      seaiceden*xyz_soseaicethicknessa(t951-1,1,k)                
     .        enddo                                                             
  1381          & + SeaIceDen * xyz_SOSeaIceThicknessA(:,:,k)
  1382      end do
  1383  
  1384  
  1385      !
  1386      ! Latitudinal diffusion
  1387      !
  1388  
  1389      ! 配列の分割と拡張
  1390      ! Division and extension of arrays
  1391      !
  1392  
  1393      if ( ksimax > kmax ) then
  1394        call MessageNotify( 'E', module_name, 'ksimax > kmax.' )
  1395      end if
  1396      if ( kmax < 3 ) then
  1397        call MessageNotify( 'E', module_name, 'kmax < 3.' )
  1398      end if
  1399      if ( ncmax < 3 ) then
  1400        call MessageNotify( 'E', module_name, 'ncmax < 3.' )
  1401      end if
  1402  
  1403  
  1404      n = 1
  1405      do k = 1, ksimax
  1406        xyza_TMP4DArray(:,:,k,n) = xyz_SOSeaIceThicknessA(:,:,k)
  1407      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, ksimax*(xyza_tmp4darray.DSC.U2*xyza_tmp4darray.DSC.U1 + 
     .       1   xyza_tmp4darray.DSC.U2)                                        
     .           xyza_tmp4darray(k-1,1,1,1) = xyz_soseaicethicknessa(k-1,1,1)   
     .        enddo                                                             
  1408      do k = ksimax+1, kmax
  1409        xyza_TMP4DArray(:,:,k,n) = 0.0_DP
  1410      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - ksimax)*(xyza_tmp4darray.DSC.U2*                
     .       1   xyza_tmp4darray.DSC.U1 + xyza_tmp4darray.DSC.U2)               
     .           xyza_tmp4darray(k-1,1,1+ksimax,1) = 0.0000000000000000e+000    
     .        enddo                                                             
  1411      !
  1412      n = 2
  1413      do k = 1, ksimax
  1414        xyza_TMP4DArray(:,:,k,n) = xyz_SOSeaIceTempA(:,:,k)
  1415      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, ksimax*(xyza_tmp4darray.DSC.U2*xyza_tmp4darray.DSC.U1 + 
     .       1   xyza_tmp4darray.DSC.U2)                                        
     .           xyza_tmp4darray(k-1,1,1,2) = xyz_soseaicetempa(k-1,1,1)        
     .        enddo                                                             
  1416      do k = ksimax+1, kmax
  1417        xyza_TMP4DArray(:,:,k,n) = 0.0_DP
  1418      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - ksimax)*(xyza_tmp4darray.DSC.U2*                
     .       1   xyza_tmp4darray.DSC.U1 + xyza_tmp4darray.DSC.U2)               
     .           xyza_tmp4darray(k-1,1,1+ksimax,2) = 0.0000000000000000e+000    
     .        enddo                                                             
  1419      !
  1420      n = 3
  1421      k = 1
  1422      do j = 1, jmax
  1423        do i = 0, imax-1
  1424          if ( xy_FlagSlabOcean(i,j) ) then
  1425            xyza_TMP4DArray(i,j,k,n) = 1.0_DP
  1426          else
  1427            xyza_TMP4DArray(i,j,k,n) = 0.0_DP
  1428          end if
  1429        end do
  1430      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_flagslabocean(j-1,1) .ne. 0) then                       
     .              xyza_tmp4darray1 = 1.00000000000000e+000                    
     .           else                                                           
     .              xyza_tmp4darray1 = 0.0000000000000000e+000                  
     .           endif                                                          
     .           xyza_tmp4darray(j-1,1,1,3) = xyza_tmp4darray1                  
     .        enddo                                                             
  1431      k = 2
  1432      xyza_TMP4DArray(:,:,k,n) = xy_SurfTempA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t989 = 1, xyza_tmp4darray.DSC.U2*xyza_tmp4darray.DSC.U1 +      
     .       1   xyza_tmp4darray.DSC.U2                                         
     .           xyza_tmp4darray(t989-1,1,2,3) = xy_surftempa(t989-1,1)         
     .        enddo                                                             
  1433      k = 3
  1434      xyza_TMP4DArray(:,:,k,n) = xy_SOSeaIceMassA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_soseaicemassa)                                          
     .        do t997 = 1, xyza_tmp4darray.DSC.U2*xyza_tmp4darray.DSC.U1 +      
     .       1   xyza_tmp4darray.DSC.U2                                         
     .           xyza_tmp4darray(t997-1,1,3,3) = xy_soseaicemassa(t997-1,1)     
     .        enddo                                                             
  1435      do k = 3+1, kmax
  1436        xyza_TMP4DArray(:,:,k,n) = 0.0_DP
  1437      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 3)*(xyza_tmp4darray.DSC.U2*                     
     .       1   xyza_tmp4darray.DSC.U1 + xyza_tmp4darray.DSC.U2)               
     .           xyza_tmp4darray(k-1,1,4,3) = 0.0000000000000000e+000           
     .        enddo                                                             
  1438      !
  1439      do n = 3+1, ncmax
  1440        xyza_TMP4DArray(:,:,:,n) = 0.0_DP
  1441      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do n = 1, (ncmax - 3)*xyza_tmp4darray.DSC.U3*                     
     .       1   xyza_tmp4darray.DSC.U2*(xyza_tmp4darray.DSC.U1 + 1)            
     .           xyza_tmp4darray(n-1,1,1,4) = 0.0000000000000000e+000           
     .        enddo                                                             
  1442  
  1443      PM = 1.0_DP
  1444      call SLTTExtArrExt2(                            &
  1445        & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
  1446        & xyza_TMP4DArray, PM,                        & ! (in)
  1447        & xyza_ExtTMP4DArrayS, xyza_ExtTMP4DArrayN    & ! (out)
  1448        & )
  1449  
  1450      n = 1
  1451      do k = 1, ksimax
  1452        xyz_ExtSOSeaIceThicknessS(:,:,k) = xyza_ExtTMP4DArrayS(:,:,k,n)
  1453        xyz_ExtSOSeaIceThicknessN(:,:,k) = xyza_ExtTMP4DArrayN(:,:,k,n)
  1454      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, ksimax*(xyz_extsoseaicethicknesss.DSC.U2 + 1 -          
     .       1   xyz_extsoseaicethicknesss.DSC.L2)*(                            
     .       2   xyz_extsoseaicethicknesss.DSC.U1 + 1 -                         
     .       3   xyz_extsoseaicethicknesss.DSC.L1)                              
     .           xyz_extsoseaicethicknesss(xyz_extsoseaicethicknesss.DSC.L1+k-1,
     .       1      xyz_extsoseaicethicknesss.DSC.L2,1) = xyza_exttmp4darrays(  
     .       2      xyza_exttmp4darrays.DSC.L1+k-1,xyza_exttmp4darrays.DSC.L2,1,
     .       3      1)                                                          
     .           xyz_extsoseaicethicknessn(xyz_extsoseaicethicknessn.DSC.L1+k-1,
     .       1      xyz_extsoseaicethicknessn.DSC.L2,1) = xyza_exttmp4darrayn(  
     .       2      xyza_exttmp4darrayn.DSC.L1+k-1,xyza_exttmp4darrayn.DSC.L2,1,
     .       3      1)                                                          
     .        enddo                                                             
  1455      n = 2
  1456      do k = 1, ksimax
  1457        xyz_ExtSOSeaIceTempS     (:,:,k) = xyza_ExtTMP4DArrayS(:,:,k,n)
  1458        xyz_ExtSOSeaIceTempN     (:,:,k) = xyza_ExtTMP4DArrayN(:,:,k,n)
  1459      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, ksimax*(xyz_extsoseaicetemps.DSC.U2 + 1 -               
     .       1   xyz_extsoseaicetemps.DSC.L2)*(xyz_extsoseaicetemps.DSC.U1 + 1  
     .       2    - xyz_extsoseaicetemps.DSC.L1)                                
     .           xyz_extsoseaicetemps(xyz_extsoseaicetemps.DSC.L1+k-1,          
     .       1      xyz_extsoseaicetemps.DSC.L2,1) = xyza_exttmp4darrays(       
     .       2      xyza_exttmp4darrays.DSC.L1+k-1,xyza_exttmp4darrays.DSC.L2,1,
     .       3      2)                                                          
     .           xyz_extsoseaicetempn(xyz_extsoseaicetempn.DSC.L1+k-1,          
     .       1      xyz_extsoseaicetempn.DSC.L2,1) = xyza_exttmp4darrayn(       
     .       2      xyza_exttmp4darrayn.DSC.L1+k-1,xyza_exttmp4darrayn.DSC.L2,1,
     .       3      2)                                                          
     .        enddo                                                             
  1460      n = 3
  1461      k = 1
  1462      do j = jexmin, jexmax
  1463        do i = iexmin, iexmax
  1464          if ( xyza_ExtTMP4DArrayS(i,j,k,n) == 1.0_DP ) then
  1465            xy_ExtFlagSlabOceanS(i,j) = .true.
  1466          else
  1467            xy_ExtFlagSlabOceanS(i,j) = .false.
  1468          end if
  1469          if ( xyza_ExtTMP4DArrayN(i,j,k,n) == 1.0_DP ) then
  1470            xy_ExtFlagSlabOceanN(i,j) = .true.
  1471          else
  1472            xy_ExtFlagSlabOceanN(i,j) = .false.
  1473          end if
  1474        end do
  1475      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, (jexmax + 1 - jexmin)*(iexmax + 1 - iexmin)             
     .           if (xyza_exttmp4darrays(iexmin+j-1,jexmin,1,3) .eq.            
     .       1      1.00000000000000e+000) then                                 
     .              xy_extflagslaboceans1 = 1                                   
     .           else                                                           
     .              xy_extflagslaboceans1 = 0                                   
     .           endif                                                          
     .           xy_extflagslaboceans(iexmin+j-1,jexmin) = xy_extflagslaboceans1
     .           if (xyza_exttmp4darrayn(iexmin+j-1,jexmin,1,3) .eq.            
     .       1      1.00000000000000e+000) then                                 
     .              xy_extflagslaboceann2 = 1                                   
     .           else                                                           
     .              xy_extflagslaboceann2 = 0                                   
     .           endif                                                          
     .           xy_extflagslaboceann(iexmin+j-1,jexmin) = xy_extflagslaboceann2
     .        enddo                                                             
  1476      k = 2
  1477      do kk = 1, ksimax
  1478        xyz_ExtSurfTempS(:,:,kk) = xyza_ExtTMP4DArrayS(:,:,k,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyza_exttmp4darrays,xyza_exttmp4darrayn)                   
     .        do t1044 = 1, (xyz_extsurftemps.DSC.U2 + 1 -                      
     .       1   xyz_extsurftemps.DSC.L2)*(xyz_extsurftemps.DSC.U1 + 1 -        
     .       2   xyz_extsurftemps.DSC.L1)                                       
     .           xyz_extsurftemps(xyz_extsurftemps.DSC.L1+t1044-1,              
     .       1      xyz_extsurftemps.DSC.L2,kk) = xyza_exttmp4darrays(          
     .       2      xyza_exttmp4darrays.DSC.L1+t1044-1,                         
     .       3      xyza_exttmp4darrays.DSC.L2,2,3)                             
     .           xyz_extsurftempn(xyz_extsurftempn.DSC.L1+t1044-1,              
     .       1      xyz_extsurftempn.DSC.L2,kk) = xyza_exttmp4darrayn(          
     .       2      xyza_exttmp4darrayn.DSC.L1+t1044-1,                         
     .       3      xyza_exttmp4darrayn.DSC.L2,2,3)                             
     .        enddo                                                             
  1479        xyz_ExtSurfTempN(:,:,kk) = xyza_ExtTMP4DArrayN(:,:,k,n)
  1480      end do
  1481      k = 3
  1482      do kk = 1, ksimax
  1483        xy_ExtSOSeaIceMassS = xyza_ExtTMP4DArrayS(:,:,k,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyza_exttmp4darrays,xyza_exttmp4darrayn,xy_extsoseaicemasss
     .       1   ,xy_extsoseaicemassn)                                          
     .        do t1056 = 1, (xy_extsoseaicemasss.DSC.U2 + 1 -                   
     .       1   xy_extsoseaicemasss.DSC.L2)*(xy_extsoseaicemasss.DSC.U1 + 1 -  
     .       2   xy_extsoseaicemasss.DSC.L1)                                    
     .           xy_extsoseaicemasss(xy_extsoseaicemasss.DSC.L1+t1056-1,        
     .       1      xy_extsoseaicemasss.DSC.L2) = xyza_exttmp4darrays(          
     .       2      xyza_exttmp4darrays.DSC.L1+t1056-1,                         
     .       3      xyza_exttmp4darrays.DSC.L2,3,3)                             
     .           xy_extsoseaicemassn(xy_extsoseaicemassn.DSC.L1+t1056-1,        
     .       1      xy_extsoseaicemassn.DSC.L2) = xyza_exttmp4darrayn(          
     .       2      xyza_exttmp4darrayn.DSC.L1+t1056-1,                         
     .       3      xyza_exttmp4darrayn.DSC.L2,3,3)                             
     .        enddo                                                             
  1484        xy_ExtSOSeaIceMassN = xyza_ExtTMP4DArrayN(:,:,k,n)
  1485      end do
  1486  
  1487  
  1488  !!$    call SSIDiffusion(                             &
  1489  !!$      & x_ExtLonS, y_ExtLatS, y_ExtCosLatS,        & ! (in)
  1490  !!$      & p_LonS, q_LatS, q_CosLatS,                 & ! (in)
  1491  !!$      & xy_ExtFlagSlabOceanS, xy_ExtSOSeaIceMassS, & ! (in)
  1492  !!$      & xy_DSOSeaIceMassDtS                        & ! (out)
  1493  !!$      & )
  1494  !!$    call SSIDiffusion(                             &
  1495  !!$      & x_ExtLonN, y_ExtLatN, y_ExtCosLatN,        & ! (in)
  1496  !!$      & p_LonN, q_LatN, q_CosLatN,                 & ! (in)
  1497  !!$      & xy_ExtFlagSlabOceanN, xy_ExtSOSeaIceMassN, & ! (in)
  1498  !!$      & xy_DSOSeaIceMassDtN                        & ! (out)
  1499  !!$      & )
  1500  
  1501      call SOSIDiffusionY(                                 &
  1502        & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1503        & q_LatS, q_CosLatS,                               & ! (in)
  1504        & xy_ExtFlagSlabOceanS, xyz_ExtSOSeaIceThicknessS, & ! (in)
  1505        & xyz_DSOSeaIceThicknessDtS                        & ! (out)
  1506        & )
  1507      call SOSIDiffusionY(                                 &
  1508        & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1509        & q_LatN, q_CosLatN,                               & ! (in)
  1510        & xy_ExtFlagSlabOceanN, xyz_ExtSOSeaIceThicknessN, & ! (in)
  1511        & xyz_DSOSeaIceThicknessDtN                        & ! (out)
  1512        & )
  1513      !
  1514      call SOSIDiffusionY(                                 &
  1515        & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1516        & q_LatS, q_CosLatS,                               & ! (in)
  1517        & xy_ExtFlagSlabOceanS, xyz_ExtSOSeaIceTempS, & ! (in)
  1518        & xyz_DSOSeaIceTempDtS                        & ! (out)
  1519        & )
  1520      call SOSIDiffusionY(                                 &
  1521        & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1522        & q_LatN, q_CosLatN,                               & ! (in)
  1523        & xy_ExtFlagSlabOceanN, xyz_ExtSOSeaIceTempN, & ! (in)
  1524        & xyz_DSOSeaIceTempDtN                        & ! (out)
  1525        & )
  1526      !
  1527      call SOSIDiffusionY(                                 &
  1528        & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1529        & q_LatS, q_CosLatS,                               & ! (in)
  1530        & xy_ExtFlagSlabOceanS, xyz_ExtSurfTempS,     & ! (in)
  1531        & xya_DSurfTempDtS,                           & ! (out)
  1532        & xy_ExtSOSeaIceMassS                         & ! (in) optional
  1533        & )
  1534      call SOSIDiffusionY(                                 &
  1535        & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1536        & q_LatN, q_CosLatN,                               & ! (in)
  1537        & xy_ExtFlagSlabOceanN, xyz_ExtSurfTempN,     & ! (in)
  1538        & xya_DSurfTempDtN,                           & ! (out)
  1539        & xy_ExtSOSeaIceMassN                         & ! (in) optional
  1540        & )
  1541  
  1542      xyz_DSOSeaIceThicknessDt(:,1:jmax/2     ,:) = xyz_DSOSeaIceThicknessDtS(:,1:jmax/2,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1070 = 1, (jmax/2)*imax                                       
     .           xyz_dsoseaicethicknessdt(t1070-1,1,t1068) =                    
     .       1      xyz_dsoseaicethicknessdts(t1070-1,1,t1068)                  
     .        enddo                                                             
  1543      xyz_DSOSeaIceThicknessDt(:,jmax/2+1:jmax,:) = xyz_DSOSeaIceThicknessDtN(:,1:jmax/2,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1082 = 1, (jmax - jmax/2)*imax                                
     .           xyz_dsoseaicethicknessdt(t1082-1,1+jmax/2,t1080) =             
     .       1      xyz_dsoseaicethicknessdtn(t1082-1,1,t1080)                  
     .           xyz_dsoseaicetempdt(t1082-1,1,t1080) = xyz_dsoseaicetempdts(   
     .       1      t1082-1,1,t1080)                                            
     .        enddo                                                             
  1544      !
  1545      xyz_DSOSeaIceTempDt(:,1:jmax/2     ,:) = xyz_DSOSeaIceTempDtS(:,1:jmax/2,:)
  1546      xyz_DSOSeaIceTempDt(:,jmax/2+1:jmax,:) = xyz_DSOSeaIceTempDtN(:,1:jmax/2,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1100 = 1, (jmax - jmax/2)*imax                                
     .           xyz_dsoseaicetempdt(t1100-1,1+jmax/2,t1098) =                  
     .       1      xyz_dsoseaicetempdtn(t1100-1,1,t1098)                       
     .        enddo                                                             
  1547      !
  1548      xy_DSurfTempDt(:,1:jmax/2     ) = xya_DSurfTempDtS(:,1:jmax/2,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1110 = 1, (jmax/2)*imax                                       
     .           xy_dsurftempdt(t1110-1,1) = xya_dsurftempdts(t1110-1,1,1)      
     .        enddo                                                             
  1549      xy_DSurfTempDt(:,jmax/2+1:jmax) = xya_DSurfTempDtN(:,1:jmax/2,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1118 = 1, (jmax - jmax/2)*imax                                
     .           xy_dsurftempdt(t1118-1,1+jmax/2)=xya_dsurftempdtn(t1118-1,1,1) 
     .        enddo                                                             
  1550  
  1551  
  1552  !!$    ! sea ice mass at next time step is calculated temporarily
  1553  !!$    xy_SOSeaIceMassA = xy_SOSeaIceMassA &
  1554  !!$      & + xy_DSOSeaIceMassDt * ( 2.0_DP * DelTime )
  1555  !!$
  1556  !!$    ! tendency is calculated
  1557  !!$    xy_DSOSeaIceMassDt = &
  1558  !!$      & ( xy_SOSeaIceMassA - xy_SOSeaIceMassB ) / ( 2.0_DP * DelTime )
  1559  
  1560  
  1561  !!$    py_ExtSOSeaIceMassXFlux = 0.0_DP
  1562  !!$    xq_ExtSOSeaIceMassYFlux = 0.0_DP
  1563  !!$    do j = jexmin, jexmax-1
  1564  !!$      do i = iexmin, iexmax-1
  1565  !!$        py_ExtSOSeaIceMassXFlux(i,j) = &
  1566  !!$          & - SOSeaIceDiffCoef &
  1567  !!$          &   * ( xy_ExtSOSeaIceMassS(i+1,j) - xy_ExtSOSeaIceMassS(i,j) ) &
  1568  !!$          &   / ( RPlanet * y_CosLatS(j) * ( x_ExtLonS(i+1) - x_ExtLonS(i) ) )
  1569  !!$        xq_ExtSOSeaIceMassYFlux(i,j) = &
  1570  !!$          & - SOSeaIceDiffCoef &
  1571  !!$          &   * ( xy_ExtSOSeaIceMassS(i,j+1) - xy_ExtSOSeaIceMassS(i,j) ) &
  1572  !!$          &   / ( RPlanet * ( y_ExtLatS(j+1) - y_ExtLatS(j) ) )
  1573  !!$      end do
  1574  !!$    end do
  1575  !!$    if ( myrank == nprocs-1 ) then
  1576  !!$      j = 0
  1577  !!$      do i = iexmin, iexmax-1
  1578  !!$        xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1579  !!$      end do
  1580  !!$    end if
  1581  !!$
  1582  !!$    do j = 1, jmax
  1583  !!$      do i = 0, imax-1
  1584  !!$        xy_DSOSeaIceMassDt(i,j) = &
  1585  !!$          & - ( py_ExtSOSeaIceMassXFlux(i,j) - py_ExtSOSeaIceMassXFlux(i-1,j) ) &
  1586  !!$          &   / ( RPlanet * y_CosLatS(j) * ( p_Lon(i) - p_Lon(i-1) ) ) &
  1587  !!$          & - (   xq_ExtSOSeaIceMassYFlux(i,j  ) * q_CosLatS(j  )   &
  1588  !!$          &     - xq_ExtSOSeaIceMassYFlux(i,j-1) * q_CosLatS(j-1) ) &
  1589  !!$          &   / ( RPlanet * y_CosLatS(j) * ( q_LatS(j) - q_LatS(j-1) ) )
  1590  !!$      end do
  1591  !!$    end do
  1592  
  1593  
  1594  
  1595  
  1596    end subroutine SOSIHorTransportDiff
  1597  
  1598    !----------------------------------------------------------------------------
  1599  
  1600    subroutine SOSIDiffusion(                      &
  1601      & x_ExtLonH, y_ExtLatH, y_ExtCosLatH,        & ! (in)
  1602      & p_LonH, q_LatH, q_CosLatH,                 & ! (in)
  1603      & xy_ExtFlagSlabOceanH, xy_ExtSOSeaIceMassH, & ! (in)
  1604      & xy_DSOSeaIceMassDtH                        & ! (out)
  1605      & )
  1606  
  1607      !
  1608      ! Calculates slab sea ice transport by diffusion
  1609  
  1610      use sltt_const , only : iexmin, iexmax, jexmin, jexmax
  1611                                ! 配列拡張ルーチン
  1612                                ! Expansion of arrays
  1613  
  1614      use constants, only: &
  1615        & RPlanet
  1616        ! $ a $ [m].
  1617        ! 惑星半径.
  1618        ! Radius of planet
  1619  
  1620      real(DP), intent(in ) :: x_ExtLonH   (iexmin:iexmax)
  1621      real(DP), intent(in ) :: y_ExtLatH   (jexmin:jexmax)
  1622      real(DP), intent(in ) :: y_ExtCosLatH(jexmin:jexmax)
  1623      real(DP), intent(in ) :: p_LonH   (0-1:imax-1+1)
  1624      real(DP), intent(in ) :: q_LatH   (1-1:jmax/2+1)
  1625      real(DP), intent(in ) :: q_CosLatH(1-1:jmax/2+1)
  1626      real(DP), intent(in ) :: xy_ExtSOSeaIceMassH(iexmin:iexmax, jexmin:jexmax)
  1627                                !
  1628                                ! Extended 4D array
  1629      logical , intent(in ) :: xy_ExtFlagSlabOceanH(iexmin:iexmax, jexmin:jexmax)
  1630                                !
  1631                                ! Extended 4D array
  1632      real(DP), intent(out) :: xy_DSOSeaIceMassDtH(0:imax-1, 1:jmax/2)
  1633                                !
  1634                                ! Slab sea ice mass tendency
  1635  
  1636      !
  1637      ! local variables
  1638      !
  1639  
  1640      real(DP) :: py_ExtSOSeaIceMassXFlux(iexmin-1:iexmax, jexmin:jexmax)
  1641                                !
  1642                                ! Longitudional Flux of slab sea ice
  1643      real(DP) :: xq_ExtSOSeaIceMassYFlux(iexmin:iexmax, jexmin-1:jexmax)
  1644                                !
  1645                                ! Latitudinal Flux of slab sea ice
  1646  
  1647  
  1648      integer:: i               ! 東西方向に回る DO ループ用作業変数
  1649                                ! Work variables for DO loop in zonal direction
  1650      integer:: j               ! 南北方向に回る DO ループ用作業変数
  1651                                ! Work variables for DO loop in meridional direction
  1652  
  1653  
  1654      ! 実行文 ; Executable statement
  1655      !
  1656  
  1657      ! 初期化確認
  1658      ! Initialization check
  1659      !
  1660      if ( .not. sosi_dynamics_inited ) then
  1661        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1662      end if
  1663  
  1664  
  1665      py_ExtSOSeaIceMassXFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t270 = 1, (py_extsoseaicemassxflux.DSC.U2 + 1 -                
     .       1   py_extsoseaicemassxflux.DSC.L2)*(py_extsoseaicemassxflux.DSC.U1
     .       2    + 1 - py_extsoseaicemassxflux.DSC.L1)                         
     .           py_extsoseaicemassxflux(py_extsoseaicemassxflux.DSC.L1+t270-1, 
     .       1      py_extsoseaicemassxflux.DSC.L2) = 0.0000000000000000e+000   
     .        enddo                                                             
  1666      xq_ExtSOSeaIceMassYFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t276 = 1, (xq_extsoseaicemassyflux.DSC.U2 + 1 -                
     .       1   xq_extsoseaicemassyflux.DSC.L2)*(xq_extsoseaicemassyflux.DSC.U1
     .       2    + 1 - xq_extsoseaicemassyflux.DSC.L1)                         
     .           xq_extsoseaicemassyflux(xq_extsoseaicemassyflux.DSC.L1+t276-1, 
     .       1      xq_extsoseaicemassyflux.DSC.L2) = 0.0000000000000000e+000   
     .        enddo                                                             
  1667      do j = jexmin, jexmax-1
  1668        do i = iexmin, iexmax-1
  1669          if ( xy_ExtFlagSlabOceanH(i,j) .and. xy_ExtFlagSlabOceanH(i+1,j) ) then
  1670            py_ExtSOSeaIceMassXFlux(i,j) =                                    &
  1671              & - SOSeaIceDiffCoef                                            &
  1672              &   * ( xy_ExtSOSeaIceMassH(i+1,j) - xy_ExtSOSeaIceMassH(i,j) ) &
  1673              &   / ( RPlanet * y_ExtCosLatH(j) * ( x_ExtLonH(i+1) - x_ExtLonH(i) ) )
  1674          else
  1675            py_ExtSOSeaIceMassXFlux(i,j) = 0.0_DP
  1676          end if
  1677          if ( xy_ExtFlagSlabOceanH(i,j) .and. xy_ExtFlagSlabOceanH(i,j+1) ) then
  1678            xq_ExtSOSeaIceMassYFlux(i,j) =                                    &
  1679              & - SOSeaIceDiffCoef                                            &
  1680              &   * ( xy_ExtSOSeaIceMassH(i,j+1) - xy_ExtSOSeaIceMassH(i,j) ) &
  1681              &   / ( RPlanet * ( y_ExtLatH(j+1) - y_ExtLatH(j) ) )
  1682          else
  1683            xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1684          end if
  1685        end do
  1686      end do
     .  !cdir noassume                                                          
     .        do i1 = 0, iexmax - iexmin - 1, maxvl()                           
     .           i2 = min0(iexmax - iexmin - i1,maxvl())                        
     .           do j = 1, jexmax - jexmin                                      
     .  !cdir       shortloop                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_extflagslaboceanh)                                
     .              do i = 1, i2                                                
     .                 if (xy_extflagslaboceanh(i1+iexmin+i-1,j-1+jexmin) .and. 
     .       1            xy_extflagslaboceanh(i1+iexmin+i,j-1+jexmin)) then    
     .                    py_extsoseaicemassxflux1 = -soseaicediffcoef*(        
     .       1               xy_extsoseaicemassh(i1+iexmin+i,j-1+jexmin)-       
     .       2               xy_extsoseaicemassh(i1+iexmin+i-1,j-1+jexmin))/(   
     .       3               rplanet*y_extcoslath(j-1+jexmin)*(x_extlonh(i1+    
     .       4               iexmin+i)-x_extlonh(i1+iexmin+i-1)))               
     .                 else                                                     
     .                    py_extsoseaicemassxflux1 = 0.0000000000000000e+000    
     .                 endif                                                    
     .                 py_extsoseaicemassxflux(i1+iexmin+i-1,j-1+jexmin) =      
     .       1            py_extsoseaicemassxflux1                              
     .                 if (xy_extflagslaboceanh(i1+iexmin+i-1,j-1+jexmin) .and. 
     .       1            xy_extflagslaboceanh(i1+iexmin+i-1,j+jexmin)) then    
     .                    xq_extsoseaicemassyflux2 = -soseaicediffcoef*(        
     .       1               xy_extsoseaicemassh(i1+iexmin+i-1,j+jexmin)-       
     .       2               xy_extsoseaicemassh(i1+iexmin+i-1,j-1+jexmin))/(   
     .       3               rplanet*(y_extlath(j+jexmin)-y_extlath(j-1+jexmin))
     .       4               )                                                  
     .                 else                                                     
     .                    xq_extsoseaicemassyflux2 = 0.0000000000000000e+000    
     .                 endif                                                    
     .                 xq_extsoseaicemassyflux(i1+iexmin+i-1,j-1+jexmin) =      
     .       1            xq_extsoseaicemassyflux2                              
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
  1687  !!$    if ( myrank == nprocs-1 ) then
  1688  !!$      j = 0
  1689  !!$      do i = iexmin, iexmax-1
  1690  !!$        xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1691  !!$      end do
  1692  !!$    end if
  1693  
  1694      do j = 1, jmax/2
  1695        do i = 0, imax-1
  1696          xy_DSOSeaIceMassDtH(i,j) =                 &
  1697            & - (   py_ExtSOSeaIceMassXFlux(i  ,j)   &
  1698            &     - py_ExtSOSeaIceMassXFlux(i-1,j) ) &
  1699            &   / ( RPlanet * y_ExtCosLatH(j) * ( p_LonH(i) - p_LonH(i-1) ) ) &
  1700            & - (   xq_ExtSOSeaIceMassYFlux(i,j  ) * q_CosLatH(j  )           &
  1701            &     - xq_ExtSOSeaIceMassYFlux(i,j-1) * q_CosLatH(j-1) )         &
  1702            &   / ( RPlanet * y_ExtCosLatH(j) * ( q_LatH(j) - q_LatH(j-1) ) )
  1703        end do
  1704      end do
     .  !cdir noassume                                                          
     .        do i3 = 0, imax - 1, maxvl()                                      
     .           i4 = min0(imax - i3,maxvl())                                   
     .           do j = 1, jmax/2                                               
     .              d3=1.D0/((rplanet*y_extcoslath(j))*(q_lath(j)-q_lath(j-1))) 
     .  !cdir       shortloop                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(py_extsoseaicemassxflux,xq_extsoseaicemassyflux)     
     .              do i = 1, i4                                                
     .                 xy_dsoseaicemassdth(i3+i-1,j) = (-(                      
     .       1            py_extsoseaicemassxflux(i3+i-1,j)-                    
     .       2            py_extsoseaicemassxflux(i3-2+i,j))/((rplanet*         
     .       3            y_extcoslath(j))*(p_lonh(i3+i-1)-p_lonh(i3-2+i)))) - (
     .       4            xq_extsoseaicemassyflux(i3+i-1,j)*q_coslath(j)-       
     .       5            xq_extsoseaicemassyflux(i3+i-1,j-1)*q_coslath(j-1))*d3
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
  1705  
  1706  
  1707    end subroutine SOSIDiffusion
  1708  
  1709    !----------------------------------------------------------------------------
  1710  
  1711    subroutine SOSIDiffusionY(                      &
  1712      & y_ExtLatH, y_ExtCosLatH,                    & ! (in)
  1713      & q_LatH, q_CosLatH,                          & ! (in)
  1714      & xy_ExtFlagSlabOceanH, xyz_ExtSOSeaIceMassH, & ! (in)
  1715      & xyz_DSOSeaIceMassDtH,                       & ! (out)
  1716      & xy_ExtSOSeaIceMassH                         & ! (in) optional
  1717      & )
  1718  
  1719      !
  1720      ! Calculates slab sea ice transport by diffusion
  1721  
  1722      use sltt_const , only : iexmin, iexmax, jexmin, jexmax
  1723                                ! 配列拡張ルーチン
  1724                                ! Expansion of arrays
  1725  
  1726      use constants, only: &
  1727        & RPlanet, &
  1728        ! $ a $ [m].
  1729        ! 惑星半径.
  1730        ! Radius of planet
  1731        & SOMass
  1732                                ! Slab ocean mass
  1733  
  1734      real(DP), intent(in ) :: y_ExtLatH   (jexmin:jexmax)
  1735      real(DP), intent(in ) :: y_ExtCosLatH(jexmin:jexmax)
  1736      real(DP), intent(in ) :: q_LatH   (1-1:jmax/2+1)
  1737      real(DP), intent(in ) :: q_CosLatH(1-1:jmax/2+1)
  1738      logical , intent(in ) :: xy_ExtFlagSlabOceanH(iexmin:iexmax, jexmin:jexmax)
  1739                                !
  1740                                ! Extended 4D array
  1741  !!!! Modified by M.Ishiwatari (2016-12-10)
  1742  !!!!    real(DP), intent(in ) :: xyz_ExtSOSeaIceMassH(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1743      real(DP), intent(in ) :: xyz_ExtSOSeaIceMassH(iexmin:iexmax, jexmin:jexmax, 0:ksimax)
  1744                                !
  1745                                ! Extended 4D array
  1746  !!!! Modified by M.Ishiwatari (2016-12-10)
  1747  !!!!    real(DP), intent(out) :: xyz_DSOSeaIceMassDtH(0:imax-1, 1:jmax/2, 1:ksimax)
  1748      real(DP), intent(out) :: xyz_DSOSeaIceMassDtH(0:imax-1, 1:jmax/2, 0:ksimax)
  1749                                !
  1750                                ! Slab sea ice mass tendency
  1751      real(DP), intent(in ), optional :: xy_ExtSOSeaIceMassH(iexmin:iexmax, jexmin:jexmax)
  1752  
  1753  
  1754      !
  1755      ! local variables
  1756      !
  1757  
  1758  !!!! Modified by M.Ishiwatari (2016-12-10)
  1759  !!!!    real(DP) :: xqz_ExtSODiffCoef       (iexmin:iexmax, jexmin-1:jexmax, 1:ksimax)
  1760  !!!!    real(DP) :: xqz_ExtSOSeaIceMassYFlux(iexmin:iexmax, jexmin-1:jexmax, 1:ksimax)
  1761      real(DP) :: xqz_ExtSODiffCoef       (iexmin:iexmax, jexmin-1:jexmax, 0:ksimax)
  1762      real(DP) :: xqz_ExtSOSeaIceMassYFlux(iexmin:iexmax, jexmin-1:jexmax, 0:ksimax)
  1763                                !
  1764                                ! Latitudinal Flux of slab sea ice
  1765  
  1766  
  1767      integer:: i               ! 東西方向に回る DO ループ用作業変数
  1768                                ! Work variables for DO loop in zonal direction
  1769      integer:: j               ! 南北方向に回る DO ループ用作業変数
  1770                                ! Work variables for DO loop in meridional direction
  1771      integer:: k
  1772  
  1773  
  1774      ! 実行文 ; Executable statement
  1775      !
  1776  
  1777      ! 初期化確認
  1778      ! Initialization check
  1779      !
  1780      if ( .not. sosi_dynamics_inited ) then
  1781        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1782      end if
  1783  
  1784  
  1785      do k = 1, ksimax
  1786        do j = jexmin, jexmax-1
  1787          do i = iexmin, iexmax-1
  1788            if ( xy_ExtFlagSlabOceanH(i,j) .and. xy_ExtFlagSlabOceanH(i,j+1) ) then
  1789              xqz_ExtSODiffCoef(i,j,k) = SOSeaIceDiffCoef
  1790              if ( present( xy_ExtSOSeaIceMassH ) ) then
  1791                xqz_ExtSODiffCoef(i,j,k) = xqz_ExtSODiffCoef(i,j,k) &
  1792                  & * min( SOMass - xy_ExtSOSeaIceMassH(i,j  ), &
  1793                  &        SOMass - xy_ExtSOSeaIceMassH(i,j+1) )
  1794              end if
  1795            else
  1796              xqz_ExtSODiffCoef(i,j,k) = 0.0_DP
  1797            end if
  1798          end do
  1799        end do
  1800      end do
     .        if (loc(xy_extsoseaicemassh) .eq. 1) then                         
     .           do k = 1, ksimax                                               
     .              if (jexmax - jexmin .gt. 0) then                            
     .                 j1 = and(jexmax - jexmin,3)                              
     .                 do j = 1, j1                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_extflagslaboceanh,xy_extsoseaicemassh)      
     .                    do i = 1, iexmax - iexmin                             
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j-1+jexmin)    
     .       1                  .and. xy_extflagslaboceanh(iexmin+i-1,j+jexmin) 
     .       2                  ) then                                          
     .                          xqz_extsodiffcoef1 = soseaicediffcoef           
     .                          if (0 .ne. 0) then                              
     .                             xqz_extsodiffcoef1 = xqz_extsodiffcoef1*min( 
     .       1                        somass - xy_extsoseaicemassh(iexmin+i-1,j-
     .       2                        1+jexmin),somass-xy_extsoseaicemassh(     
     .       3                        iexmin+i-1,j+jexmin))                     
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef1 = 0.0000000000000000e+000    
     .                       endif                                              
     .                       xqz_extsodiffcoef(iexmin+i-1,j-1+jexmin,k) =       
     .       1                  xqz_extsodiffcoef1                              
     .                    enddo                                                 
     .                 enddo                                                    
     .                 do j = j1 + 1, jexmax - jexmin, 4                        
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_extflagslaboceanh,xy_extsoseaicemassh)      
     .                    do i = 1, iexmax - iexmin                             
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j-1+jexmin)    
     .       1                  .and. xy_extflagslaboceanh(iexmin+i-1,j+jexmin) 
     .       2                  ) then                                          
     .                          xqz_extsodiffcoef2 = soseaicediffcoef           
     .                          if (0 .ne. 0) then                              
     .                             xqz_extsodiffcoef2 = xqz_extsodiffcoef2*min( 
     .       1                        somass - xy_extsoseaicemassh(iexmin+i-1,j-
     .       2                        1+jexmin),somass-xy_extsoseaicemassh(     
     .       3                        iexmin+i-1,j+jexmin))                     
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef2 = 0.0000000000000000e+000    
     .                       endif                                              
     .                       xqz_extsodiffcoef(iexmin+i-1,j-1+jexmin,k) =       
     .       1                  xqz_extsodiffcoef2                              
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j+jexmin) .and.
     .       1                   xy_extflagslaboceanh(iexmin+i-1,j+1+jexmin))   
     .       2                  then                                            
     .                          xqz_extsodiffcoef(iexmin+i-1,j+jexmin,k) =      
     .       1                     soseaicediffcoef                             
     .                          if (0 .ne. 0) then                              
     .                             xqz_extsodiffcoef(iexmin+i-1,j+jexmin,k) =   
     .       1                        xqz_extsodiffcoef(iexmin+i-1,j+jexmin,k)* 
     .       2                        min(somass - xy_extsoseaicemassh(iexmin+i-
     .       3                        1,j+jexmin),somass-xy_extsoseaicemassh(   
     .       4                        iexmin+i-1,j+1+jexmin))                   
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef(iexmin+i-1,j+jexmin,k) =      
     .       1                     0.0000000000000000e+000                      
     .                       endif                                              
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j+1+jexmin)    
     .       1                  .and. xy_extflagslaboceanh(iexmin+i-1,j+2+jexmin
     .       2                  )) then                                         
     .                          xqz_extsodiffcoef(iexmin+i-1,j+1+jexmin,k) =    
     .       1                     soseaicediffcoef                             
     .                          if (0 .ne. 0) then                              
     .                             xqz_extsodiffcoef(iexmin+i-1,j+1+jexmin,k) = 
     .       1                        xqz_extsodiffcoef(iexmin+i-1,j+1+jexmin,k)
     .       2                        *min(somass - xy_extsoseaicemassh(iexmin+i
     .       3                        -1,j+1+jexmin),somass-xy_extsoseaicemassh(
     .       4                        iexmin+i-1,j+2+jexmin))                   
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef(iexmin+i-1,j+1+jexmin,k) =    
     .       1                     0.0000000000000000e+000                      
     .                       endif                                              
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j+2+jexmin)    
     .       1                  .and. xy_extflagslaboceanh(iexmin+i-1,j+3+jexmin
     .       2                  )) then                                         
     .                          xqz_extsodiffcoef(iexmin+i-1,j+2+jexmin,k) =    
     .       1                     soseaicediffcoef                             
     .                          if (0 .ne. 0) then                              
     .                             xqz_extsodiffcoef(iexmin+i-1,j+2+jexmin,k) = 
     .       1                        xqz_extsodiffcoef(iexmin+i-1,j+2+jexmin,k)
     .       2                        *min(somass - xy_extsoseaicemassh(iexmin+i
     .       3                        -1,j+2+jexmin),somass-xy_extsoseaicemassh(
     .       4                        iexmin+i-1,j+3+jexmin))                   
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef(iexmin+i-1,j+2+jexmin,k) =    
     .       1                     0.0000000000000000e+000                      
     .                       endif                                              
     .                    enddo                                                 
     .                 enddo                                                    
     .              endif                                                       
     .  31052       continue                                                    
     .  31053       continue                                                    
     .           enddo                                                          
     .        else                                                              
     .           do k = 1, ksimax                                               
     .  31054       continue                                                    
     .  31055       continue                                                    
     .              if (jexmax - jexmin .gt. 0) then                            
     .                 j2 = and(jexmax - jexmin,3)                              
     .                 do j = 1, j2                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_extflagslaboceanh,xy_extsoseaicemassh)      
     .                    do i = 1, iexmax - iexmin                             
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j-1+jexmin)    
     .       1                  .and. xy_extflagslaboceanh(iexmin+i-1,j+jexmin) 
     .       2                  ) then                                          
     .                          xqz_extsodiffcoef3 = soseaicediffcoef           
     .                          if (1 .ne. 0) then                              
     .                             xqz_extsodiffcoef3 = xqz_extsodiffcoef3*min( 
     .       1                        somass - xy_extsoseaicemassh(iexmin+i-1,j-
     .       2                        1+jexmin),somass-xy_extsoseaicemassh(     
     .       3                        iexmin+i-1,j+jexmin))                     
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef3 = 0.0000000000000000e+000    
     .                       endif                                              
     .                       xqz_extsodiffcoef(iexmin+i-1,j-1+jexmin,k) =       
     .       1                  xqz_extsodiffcoef3                              
     .                    enddo                                                 
     .                 enddo                                                    
     .                 do j = j2 + 1, jexmax - jexmin, 4                        
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_extflagslaboceanh,xy_extsoseaicemassh)      
     .                    do i = 1, iexmax - iexmin                             
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j-1+jexmin)    
     .       1                  .and. xy_extflagslaboceanh(iexmin+i-1,j+jexmin) 
     .       2                  ) then                                          
     .                          xqz_extsodiffcoef4 = soseaicediffcoef           
     .                          if (1 .ne. 0) then                              
     .                             xqz_extsodiffcoef4 = xqz_extsodiffcoef4*min( 
     .       1                        somass - xy_extsoseaicemassh(iexmin+i-1,j-
     .       2                        1+jexmin),somass-xy_extsoseaicemassh(     
     .       3                        iexmin+i-1,j+jexmin))                     
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef4 = 0.0000000000000000e+000    
     .                       endif                                              
     .                       xqz_extsodiffcoef(iexmin+i-1,j-1+jexmin,k) =       
     .       1                  xqz_extsodiffcoef4                              
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j+jexmin) .and.
     .       1                   xy_extflagslaboceanh(iexmin+i-1,j+1+jexmin))   
     .       2                  then                                            
     .                          xqz_extsodiffcoef(iexmin+i-1,j+jexmin,k) =      
     .       1                     soseaicediffcoef                             
     .                          if (1 .ne. 0) then                              
     .                             xqz_extsodiffcoef(iexmin+i-1,j+jexmin,k) =   
     .       1                        xqz_extsodiffcoef(iexmin+i-1,j+jexmin,k)* 
     .       2                        min(somass - xy_extsoseaicemassh(iexmin+i-
     .       3                        1,j+jexmin),somass-xy_extsoseaicemassh(   
     .       4                        iexmin+i-1,j+1+jexmin))                   
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef(iexmin+i-1,j+jexmin,k) =      
     .       1                     0.0000000000000000e+000                      
     .                       endif                                              
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j+1+jexmin)    
     .       1                  .and. xy_extflagslaboceanh(iexmin+i-1,j+2+jexmin
     .       2                  )) then                                         
     .                          xqz_extsodiffcoef(iexmin+i-1,j+1+jexmin,k) =    
     .       1                     soseaicediffcoef                             
     .                          if (1 .ne. 0) then                              
     .                             xqz_extsodiffcoef(iexmin+i-1,j+1+jexmin,k) = 
     .       1                        xqz_extsodiffcoef(iexmin+i-1,j+1+jexmin,k)
     .       2                        *min(somass - xy_extsoseaicemassh(iexmin+i
     .       3                        -1,j+1+jexmin),somass-xy_extsoseaicemassh(
     .       4                        iexmin+i-1,j+2+jexmin))                   
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef(iexmin+i-1,j+1+jexmin,k) =    
     .       1                     0.0000000000000000e+000                      
     .                       endif                                              
     .                       if (xy_extflagslaboceanh(iexmin+i-1,j+2+jexmin)    
     .       1                  .and. xy_extflagslaboceanh(iexmin+i-1,j+3+jexmin
     .       2                  )) then                                         
     .                          xqz_extsodiffcoef(iexmin+i-1,j+2+jexmin,k) =    
     .       1                     soseaicediffcoef                             
     .                          if (1 .ne. 0) then                              
     .                             xqz_extsodiffcoef(iexmin+i-1,j+2+jexmin,k) = 
     .       1                        xqz_extsodiffcoef(iexmin+i-1,j+2+jexmin,k)
     .       2                        *min(somass - xy_extsoseaicemassh(iexmin+i
     .       3                        -1,j+2+jexmin),somass-xy_extsoseaicemassh(
     .       4                        iexmin+i-1,j+3+jexmin))                   
     .                          endif                                           
     .                       else                                               
     .                          xqz_extsodiffcoef(iexmin+i-1,j+2+jexmin,k) =    
     .       1                     0.0000000000000000e+000                      
     .                       endif                                              
     .                    enddo                                                 
     .                 enddo                                                    
     .              endif                                                       
     .           enddo                                                          
     .        endif                                                             
  1801  
  1802      do k = 1, ksimax
  1803        do j = jexmin, jexmax-1
  1804          do i = iexmin, iexmax-1
  1805            xqz_ExtSOSeaIceMassYFlux(i,j,k) =                                       &
  1806              & - xqz_ExtSODiffCoef(i,j,k)                                          &
  1807              &   * ( xyz_ExtSOSeaIceMassH(i,j+1,k) - xyz_ExtSOSeaIceMassH(i,j,k) ) &
  1808              &   / ( RPlanet * ( y_ExtLatH(j+1) - y_ExtLatH(j) ) )
  1809          end do
  1810        end do
     .        if (jexmax - jexmin .gt. 0) then                                  
     .           j3 = and(jexmax - jexmin,3)                                    
     .           do j = 1, j3                                                   
     .              d5 = 1.D0/(rplanet*(y_extlath(j+jexmin)-y_extlath(j-1+jexmin
     .       1         )))                                                      
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_extsoseaicemassh)                                
     .              do i = 1, iexmax - iexmin                                   
     .                 xqz_extsoseaicemassyflux(iexmin+i-1,j-1+jexmin,k) = -    
     .       1            xqz_extsodiffcoef(iexmin+i-1,j-1+jexmin,k)*(          
     .       2            xyz_extsoseaicemassh(iexmin+i-1,j+jexmin,k)-          
     .       3            xyz_extsoseaicemassh(iexmin+i-1,j-1+jexmin,k))*d5     
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j3 + 1, jexmax - jexmin, 4                              
     .              d6 = 1.D0/(rplanet*(y_extlath(j+jexmin)-y_extlath(j-1+jexmin
     .       1         )))                                                      
     .              d7 = 1.D0/(rplanet*(y_extlath(j+1+jexmin)-y_extlath(j+jexmin
     .       1         )))                                                      
     .              d8 = 1.D0/(rplanet*(y_extlath(j+2+jexmin)-y_extlath(j+1+    
     .       1         jexmin)))                                                
     .              d9 = 1.D0/(rplanet*(y_extlath(j+3+jexmin)-y_extlath(j+2+    
     .       1         jexmin)))                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_extsoseaicemassh)                                
     .              do i = 1, iexmax - iexmin                                   
     .                 xqz_extsoseaicemassyflux(iexmin+i-1,j-1+jexmin,k) = -    
     .       1            xqz_extsodiffcoef(iexmin+i-1,j-1+jexmin,k)*(          
     .       2            xyz_extsoseaicemassh(iexmin+i-1,j+jexmin,k)-          
     .       3            xyz_extsoseaicemassh(iexmin+i-1,j-1+jexmin,k))*d6     
     .                 xqz_extsoseaicemassyflux(iexmin+i-1,j+jexmin,k) = -      
     .       1            xqz_extsodiffcoef(iexmin+i-1,j+jexmin,k)*(            
     .       2            xyz_extsoseaicemassh(iexmin+i-1,j+1+jexmin,k)-        
     .       3            xyz_extsoseaicemassh(iexmin+i-1,j+jexmin,k))*d7       
     .                 xqz_extsoseaicemassyflux(iexmin+i-1,j+1+jexmin,k) = -    
     .       1            xqz_extsodiffcoef(iexmin+i-1,j+1+jexmin,k)*(          
     .       2            xyz_extsoseaicemassh(iexmin+i-1,j+2+jexmin,k)-        
     .       3            xyz_extsoseaicemassh(iexmin+i-1,j+1+jexmin,k))*d8     
     .                 xqz_extsoseaicemassyflux(iexmin+i-1,j+2+jexmin,k) = -    
     .       1            xqz_extsodiffcoef(iexmin+i-1,j+2+jexmin,k)*(          
     .       2            xyz_extsoseaicemassh(iexmin+i-1,j+3+jexmin,k)-        
     .       3            xyz_extsoseaicemassh(iexmin+i-1,j+2+jexmin,k))*d9     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1811      end do
  1812  !!$    if ( myrank == nprocs-1 ) then
  1813  !!$      j = 0
  1814  !!$      do i = iexmin, iexmax-1
  1815  !!$        xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1816  !!$      end do
  1817  !!$    end if
  1818  
  1819      do k = 1, ksimax
  1820        do j = 1, jmax/2
  1821          do i = 0, imax-1
  1822            xyz_DSOSeaIceMassDtH(i,j,k) =                                      &
  1823              & - (   xqz_ExtSOSeaIceMassYFlux(i,j  ,k) * q_CosLatH(j  )       &
  1824              &     - xqz_ExtSOSeaIceMassYFlux(i,j-1,k) * q_CosLatH(j-1) )     &
  1825              &   / ( RPlanet * y_ExtCosLatH(j) * ( q_LatH(j) - q_LatH(j-1) ) )
  1826            if ( present( xy_ExtSOSeaIceMassH ) ) then
  1827              if ( SOMass - xy_ExtSOSeaIceMassH(i,j) > 0.0_DP ) then
  1828                xyz_DSOSeaIceMassDtH(i,j,k) = xyz_DSOSeaIceMassDtH(i,j,k) &
  1829                  & / ( SOMass - xy_ExtSOSeaIceMassH(i,j) )
  1830              else
  1831                xyz_DSOSeaIceMassDtH(i,j,k) = 0.0_DP
  1832              end if
  1833            end if
  1834          end do
  1835        end do
  1836      end do
     .        if (loc(xy_extsoseaicemassh) .eq. 1) then                         
     .           do k = 1, ksimax                                               
     .              if (jmax/2 .gt. 0) then                                     
     .                 j4 = and(jmax/2,3)                                       
     .                 t300 = 0                                                 
     .                 do j = 1, j4                                             
     .                    d11 = 1.D0/(rplanet*y_extcoslath(j)*(q_lath(j)-q_lath(
     .       1               j-1)))                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_extsoseaicemassh,xqz_extsoseaicemassyflux)  
     .                    do i = 1, imax                                        
     .                       xyz_dsoseaicemassdth1 = -(xqz_extsoseaicemassyflux(
     .       1                  i-1,j,k)*q_coslath(j)-xqz_extsoseaicemassyflux(i
     .       2                  -1,j-1,k)*q_coslath(j-1))*d11                   
     .                       if (t300 .ne. 0) then                              
     .                          if (somass - xy_extsoseaicemassh(i-1,j) .le.    
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth1 =                      
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth1 = xyz_dsoseaicemassdth1
     .       1                        /(somass - xy_extsoseaicemassh(i-1,j))    
     .                          endif                                           
     .                       endif                                              
     .                       xyz_dsoseaicemassdth(i-1,j,k) =                    
     .       1                  xyz_dsoseaicemassdth1                           
     .                    enddo                                                 
     .                 enddo                                                    
     .                 t300 = 0                                                 
     .                 do j = j4 + 1, jmax/2, 4                                 
     .                    d12 = 1.D0/(rplanet*y_extcoslath(j)*(q_lath(j)-q_lath(
     .       1               j-1)))                                             
     .                    d13 = 1.D0/(rplanet*y_extcoslath(j+1)*(q_lath(j+1)-   
     .       1               q_lath(j)))                                        
     .                    d14 = 1.D0/(rplanet*y_extcoslath(j+2)*(q_lath(j+2)-   
     .       1               q_lath(j+1)))                                      
     .                    d15 = 1.D0/(rplanet*y_extcoslath(j+3)*(q_lath(j+3)-   
     .       1               q_lath(j+2)))                                      
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_extsoseaicemassh,xqz_extsoseaicemassyflux)  
     .                    do i = 1, imax                                        
     .                       xyz_dsoseaicemassdth(i-1,j,k) = -((                
     .       1                  xqz_extsoseaicemassyflux(i-1,j,k)*q_coslath(j))-
     .       2                  xqz_extsoseaicemassyflux(i-1,j-1,k)*q_coslath(j-
     .       3                  1))*d12                                         
     .                       xyz_dsoseaicemassdth(i-1,j+1,k) = -((              
     .       1                  xqz_extsoseaicemassyflux(i-1,j+1,k)*q_coslath(j+
     .       2                  1))-(xqz_extsoseaicemassyflux(i-1,j,k)*q_coslath
     .       3                  (j)))*d13                                       
     .                       xyz_dsoseaicemassdth(i-1,j+2,k) = -((              
     .       1                  xqz_extsoseaicemassyflux(i-1,j+2,k)*q_coslath(j+
     .       2                  2))-(xqz_extsoseaicemassyflux(i-1,j+1,k)*       
     .       3                  q_coslath(j+1)))*d14                            
     .                       xyz_dsoseaicemassdth(i-1,j+3,k) = -(               
     .       1                  xqz_extsoseaicemassyflux(i-1,j+3,k)*q_coslath(j+
     .       2                  3)-(xqz_extsoseaicemassyflux(i-1,j+2,k)*        
     .       3                  q_coslath(j+2)))*d15                            
     .                       if (t300 .ne. 0) then                              
     .                          if (somass - xy_extsoseaicemassh(i-1,j) .le.    
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth16 =                     
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth16 = xyz_dsoseaicemassdth
     .       1                        (i-1,j,k)/(somass - xy_extsoseaicemassh(i-
     .       2                        1,j))                                     
     .                          endif                                           
     .                          xyz_dsoseaicemassdth(i-1,j,k) =                 
     .       1                     xyz_dsoseaicemassdth16                       
     .                          if (somass - xy_extsoseaicemassh(i-1,j+1) .le.  
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth17 =                     
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth17 = xyz_dsoseaicemassdth
     .       1                        (i-1,j+1,k)/(somass - xy_extsoseaicemassh(
     .       2                        i-1,j+1))                                 
     .                          endif                                           
     .                          xyz_dsoseaicemassdth(i-1,j+1,k) =               
     .       1                     xyz_dsoseaicemassdth17                       
     .                          if (somass - xy_extsoseaicemassh(i-1,j+2) .le.  
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth18 =                     
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth18 = xyz_dsoseaicemassdth
     .       1                        (i-1,j+2,k)/(somass - xy_extsoseaicemassh(
     .       2                        i-1,j+2))                                 
     .                          endif                                           
     .                          xyz_dsoseaicemassdth(i-1,j+2,k) =               
     .       1                     xyz_dsoseaicemassdth18                       
     .                          if (somass - xy_extsoseaicemassh(i-1,j+3) .le.  
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth19 =                     
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth19 = xyz_dsoseaicemassdth
     .       1                        (i-1,j+3,k)/(somass - xy_extsoseaicemassh(
     .       2                        i-1,j+3))                                 
     .                          endif                                           
     .                          xyz_dsoseaicemassdth(i-1,j+3,k) =               
     .       1                     xyz_dsoseaicemassdth19                       
     .                       endif                                              
     .                    enddo                                                 
     .                 enddo                                                    
     .              endif                                                       
     .           enddo                                                          
     .        else                                                              
     .           do k = 1, ksimax                                               
     .              if (jmax/2 .gt. 0) then                                     
     .                 j5 = and(jmax/2,3)                                       
     .                 t300 = 1                                                 
     .                 do j = 1, j5                                             
     .                    d21 = 1.D0/(rplanet*y_extcoslath(j)*(q_lath(j)-q_lath(
     .       1               j-1)))                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_extsoseaicemassh,xqz_extsoseaicemassyflux)  
     .                    do i = 1, imax                                        
     .                       xyz_dsoseaicemassdth2 = -(xqz_extsoseaicemassyflux(
     .       1                  i-1,j,k)*q_coslath(j)-xqz_extsoseaicemassyflux(i
     .       2                  -1,j-1,k)*q_coslath(j-1))*d21                   
     .                       if (t300 .ne. 0) then                              
     .                          if (somass - xy_extsoseaicemassh(i-1,j) .le.    
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth2 =                      
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth2 = xyz_dsoseaicemassdth2
     .       1                        /(somass - xy_extsoseaicemassh(i-1,j))    
     .                          endif                                           
     .                       endif                                              
     .                       xyz_dsoseaicemassdth(i-1,j,k) =                    
     .       1                  xyz_dsoseaicemassdth2                           
     .                    enddo                                                 
     .                 enddo                                                    
     .                 t300 = 1                                                 
     .                 do j = j5 + 1, jmax/2, 4                                 
     .                    d22 = 1.D0/(rplanet*y_extcoslath(j)*(q_lath(j)-q_lath(
     .       1               j-1)))                                             
     .                    d23 = 1.D0/(rplanet*y_extcoslath(j+1)*(q_lath(j+1)-   
     .       1               q_lath(j)))                                        
     .                    d24 = 1.D0/(rplanet*y_extcoslath(j+2)*(q_lath(j+2)-   
     .       1               q_lath(j+1)))                                      
     .                    d25 = 1.D0/(rplanet*y_extcoslath(j+3)*(q_lath(j+3)-   
     .       1               q_lath(j+2)))                                      
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_extsoseaicemassh,xqz_extsoseaicemassyflux)  
     .                    do i = 1, imax                                        
     .                       xyz_dsoseaicemassdth(i-1,j,k) = -((                
     .       1                  xqz_extsoseaicemassyflux(i-1,j,k)*q_coslath(j))-
     .       2                  xqz_extsoseaicemassyflux(i-1,j-1,k)*q_coslath(j-
     .       3                  1))*d22                                         
     .                       xyz_dsoseaicemassdth(i-1,j+1,k) = -((              
     .       1                  xqz_extsoseaicemassyflux(i-1,j+1,k)*q_coslath(j+
     .       2                  1))-(xqz_extsoseaicemassyflux(i-1,j,k)*q_coslath
     .       3                  (j)))*d23                                       
     .                       xyz_dsoseaicemassdth(i-1,j+2,k) = -((              
     .       1                  xqz_extsoseaicemassyflux(i-1,j+2,k)*q_coslath(j+
     .       2                  2))-(xqz_extsoseaicemassyflux(i-1,j+1,k)*       
     .       3                  q_coslath(j+1)))*d24                            
     .                       xyz_dsoseaicemassdth(i-1,j+3,k) = -(               
     .       1                  xqz_extsoseaicemassyflux(i-1,j+3,k)*q_coslath(j+
     .       2                  3)-(xqz_extsoseaicemassyflux(i-1,j+2,k)*        
     .       3                  q_coslath(j+2)))*d25                            
     .                       if (t300 .ne. 0) then                              
     .                          if (somass - xy_extsoseaicemassh(i-1,j) .le.    
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth26 =                     
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth26 = xyz_dsoseaicemassdth
     .       1                        (i-1,j,k)/(somass - xy_extsoseaicemassh(i-
     .       2                        1,j))                                     
     .                          endif                                           
     .                          xyz_dsoseaicemassdth(i-1,j,k) =                 
     .       1                     xyz_dsoseaicemassdth26                       
     .                          if (somass - xy_extsoseaicemassh(i-1,j+1) .le.  
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth27 =                     
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth27 = xyz_dsoseaicemassdth
     .       1                        (i-1,j+1,k)/(somass - xy_extsoseaicemassh(
     .       2                        i-1,j+1))                                 
     .                          endif                                           
     .                          xyz_dsoseaicemassdth(i-1,j+1,k) =               
     .       1                     xyz_dsoseaicemassdth27                       
     .                          if (somass - xy_extsoseaicemassh(i-1,j+2) .le.  
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth28 =                     
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth28 = xyz_dsoseaicemassdth
     .       1                        (i-1,j+2,k)/(somass - xy_extsoseaicemassh(
     .       2                        i-1,j+2))                                 
     .                          endif                                           
     .                          xyz_dsoseaicemassdth(i-1,j+2,k) =               
     .       1                     xyz_dsoseaicemassdth28                       
     .                          if (somass - xy_extsoseaicemassh(i-1,j+3) .le.  
     .       1                     0.0000000000000000e+000) then                
     .                             xyz_dsoseaicemassdth29 =                     
     .       1                        0.0000000000000000e+000                   
     .                          else                                            
     .                             xyz_dsoseaicemassdth29 = xyz_dsoseaicemassdth
     .       1                        (i-1,j+3,k)/(somass - xy_extsoseaicemassh(
     .       2                        i-1,j+3))                                 
     .                          endif                                           
     .                          xyz_dsoseaicemassdth(i-1,j+3,k) =               
     .       1                     xyz_dsoseaicemassdth29                       
     .                       endif                                              
     .                    enddo                                                 
     .                 enddo                                                    
     .              endif                                                       
     .           enddo                                                          
     .        endif                                                             
  1837  
  1838  
  1839    end subroutine SOSIDiffusionY
  1840  
  1841    !----------------------------------------------------------------------------
  1842  
  1843    subroutine SOSIDiffusionX(                     &
  1844      & DelLon, y_CosLat, xy_FlagSlabOcean,        & ! (in)
  1845      & xy_SOSeaIceMass,                           & ! (in)
  1846      & xy_SurfTemp , xyz_SOSeaIceThickness , xyz_SOSeaIceTemp,  & ! (in)
  1847      & xy_SurfTempA, xyz_SOSeaIceThicknessA, xyz_SOSeaIceTempA  & ! (out)
  1848      & )
  1849      !
  1850      ! Calculates slab sea ice transport by longitudinal diffusion
  1851  
  1852  
  1853      !
  1854      !
  1855      use ludecomp_module, only : &
  1856        & ludecomp_prep_simple_many, &
  1857        & ludecomp_solve_simple_many
  1858  
  1859      use constants, only: &
  1860        & RPlanet, &
  1861        ! $ a $ [m].
  1862        ! 惑星半径.
  1863        ! Radius of planet
  1864        & SOMass
  1865                                ! Slab ocean mass
  1866  
  1867      real(DP), intent(in ) :: DelLon
  1868      real(DP), intent(in ) :: y_CosLat(1:jmax)
  1869      logical , intent(in ) :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
  1870      real(DP), intent(in ) :: xy_SOSeaIceMass       (0:imax-1, 1:jmax)
  1871      real(DP), intent(in ) :: xy_SurfTemp           (0:imax-1, 1:jmax)
  1872  !!!! Modified by M.Ishiwatari (2016-12-10)
  1873  !!!!    real(DP), intent(in ) :: xyz_SOSeaIceThickness (0:imax-1, 1:jmax, 1:ksimax)
  1874  !!!!    real(DP), intent(in ) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
  1875      real(DP), intent(in ) :: xyz_SOSeaIceThickness (0:imax-1, 1:jmax, 0:ksimax)
  1876      real(DP), intent(in ) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 0:ksimax)
  1877      real(DP), intent(out) :: xy_SurfTempA          (0:imax-1, 1:jmax)
  1878  !!!! Modified by M.Ishiwatari (2016-12-10)
  1879  !!!!    real(DP), intent(out) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 1:ksimax)
  1880  !!!!    real(DP), intent(out) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 1:ksimax)
  1881      real(DP), intent(out) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 0:ksimax)
  1882      real(DP), intent(out) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 0:ksimax)
  1883  
  1884      !
  1885      ! local variables
  1886      !
  1887  
  1888      real(DP) :: aax_LUMat(1:jmax*ksimax, 0:imax-1, 0:imax-1)
  1889      real(DP) :: aa_LUVec (1:jmax*ksimax, 0:imax-1)
  1890  
  1891      real(DP) :: y_Factor(1:jmax)
  1892  
  1893  !!!! Modified by M.Ishiwatari (2016-12-10)
  1894  !!!!    real(DP) :: pyz_SOSeaIceDiffCoef(0:imax-1, 1:jmax, 1:ksimax)
  1895      real(DP) :: pyz_SOSeaIceDiffCoef(0:imax-1, 1:jmax, 0:ksimax)
  1896                                !
  1897                                ! Longitudional Flux of slab sea ice
  1898  
  1899      integer:: i            ! 東西方向に回る DO ループ用作業変数
  1900                             ! Work variables for DO loop in zonal direction
  1901      integer:: j            ! 南北方向に回る DO ループ用作業変数
  1902                             ! Work variables for DO loop in meridional direction
  1903      integer:: k
  1904  
  1905      integer:: l
  1906      integer:: ii
  1907      integer:: iprev
  1908      integer:: inext
  1909  
  1910  
  1911      ! 実行文 ; Executable statement
  1912      !
  1913  
  1914      ! 初期化確認
  1915      ! Initialization check
  1916      !
  1917      if ( .not. sosi_dynamics_inited ) then
  1918        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1919      end if
  1920  
  1921  
  1922      y_Factor = 1.0_DP / ( RPlanet * y_CosLat * DelLon )**2
  1923  
  1924      do k = 1, ksimax
  1925        do j = 1, jmax
  1926          do i = 0, imax-1
  1927            if ( i == imax-1 ) then
  1928              iprev = i
  1929              inext = 0
  1930            else
  1931              iprev = i
  1932              inext = i+1
  1933            end if
  1934            if ( xy_FlagSlabOcean(iprev,j) .and. xy_FlagSlabOcean(inext,j) ) then
  1935              pyz_SOSeaIceDiffCoef(i,j,k) = SOSeaIceDiffCoef
  1936            else
  1937              pyz_SOSeaIceDiffCoef(i,j,k) = 0.0_DP
  1938            end if
  1939          end do
     .  !cdir    nodep                                                          
     .  !cdir on_adb(xy_flagslabocean)                                          
     .        do i = 1, imax                                                    
     .           if (i - 1 .eq. imax-1) then                                    
     .              iprev = i - 1                                               
     .              inext = 0                                                   
     .           else                                                           
     .              iprev = i - 1                                               
     .              inext = i                                                   
     .           endif                                                          
     .           if (xy_flagslabocean(iprev,j) .and. xy_flagslabocean(inext,j)) 
     .       1      then                                                        
     .              pyz_soseaicediffcoef1 = soseaicediffcoef                    
     .           else                                                           
     .              pyz_soseaicediffcoef1 = 0.0000000000000000e+000             
     .           endif                                                          
     .           pyz_soseaicediffcoef(i-1,j,k) = pyz_soseaicediffcoef1          
     .        enddo                                                             
  1940        end do
  1941      end do
  1942  
  1943      aax_LUMat = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1129 = 1, (aax_lumat.DSC.U3 + 1)*(aax_lumat.DSC.U2 + 1)*      
     .       1   aax_lumat.DSC.U1                                               
     .           aax_lumat(t1129,0,0) = 0.0000000000000000e+000                 
     .        enddo                                                             
  1944      do k = 1, ksimax
  1945        do j = 1, jmax
  1946          l = (k-1)*jmax+j
  1947  
  1948          do ii = 0, 0
  1949            i = ii
  1950            aax_LUMat(l,ii,imax-1) = &
  1951              & - pyz_SOSeaIceDiffCoef(imax-1,j,k) &
  1952              &   * y_Factor(j)
  1953            aax_LUMat(l,ii,i  ) = &
  1954              &   1.0_DP / ( 1.0_DP * DelTime ) &
  1955              & + ( pyz_SOSeaIceDiffCoef(imax-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  1956              &   * y_Factor(j)
  1957            aax_LUMat(l,ii,i+1) = &
  1958              & - pyz_SOSeaIceDiffCoef(i     ,j,k) &
  1959              &   * y_Factor(j)
  1960          end do
  1961          do ii = 0+1, (imax-1)-1
  1962            i = ii
  1963            aax_LUMat(l,ii,i-1) = &
  1964              & - pyz_SOSeaIceDiffCoef(i-1,j,k) &
  1965              &   * y_Factor(j)
  1966            aax_LUMat(l,ii,i  ) = &
  1967              &   1.0_DP / ( 1.0_DP * DelTime ) &
  1968              & + ( pyz_SOSeaIceDiffCoef(i-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  1969              &   * y_Factor(j)
  1970            aax_LUMat(l,ii,i+1) = &
  1971              & - pyz_SOSeaIceDiffCoef(i  ,j,k) &
  1972              &   * y_Factor(j)
  1973          end do
  1974          do ii = imax-1, imax-1
  1975            i = ii
  1976            aax_LUMat(l,ii,i-1) = &
  1977              & - pyz_SOSeaIceDiffCoef(i-1,j,k) &
  1978              &   * y_Factor(j)
  1979            aax_LUMat(l,ii,i  ) = &
  1980              &   1.0_DP / ( 1.0_DP * DelTime ) &
  1981              & + ( pyz_SOSeaIceDiffCoef(i-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  1982              &   * y_Factor(j)
  1983            aax_LUMat(l,ii,0  ) = &
  1984              & - pyz_SOSeaIceDiffCoef(imax-1,j,k) &
  1985              &   * y_Factor(j)
  1986          end do
  1987  
  1988  
  1989        end do
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .           i1 = 0                                                         
     .           do j = 1, j2                                                   
     .              aax_lumat(j+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(  
     .       1         imax-1,j,k)*y_factor(j)                                  
     .              aax_lumat(j+k*jmax-jmax,0,i1) = 1.00000000000000e+000/(     
     .       1         1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(  
     .       2         imax-1,j,k)+pyz_soseaicediffcoef(i1,j,k))*y_factor(j)    
     .              aax_lumat(j+k*jmax-jmax,0,i1+1) = -pyz_soseaicediffcoef(i1,j
     .       1         ,k)*y_factor(j)                                          
     .  !cdir       nodep                                                       
     .              do ii = 1, imax - 2                                         
     .                 aax_lumat(j+k*jmax-jmax,ii,ii-1) = -pyz_soseaicediffcoef(
     .       1            ii-1,j,k)*y_factor(j)                                 
     .                 aax_lumat(j+k*jmax-jmax,ii,ii) = 1.00000000000000e+000/( 
     .       1            1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef
     .       2            (ii-1,j,k)+pyz_soseaicediffcoef(ii,j,k))*y_factor(j)  
     .                 aax_lumat(j+k*jmax-jmax,ii,1+ii) = -pyz_soseaicediffcoef(
     .       1            ii,j,k)*y_factor(j)                                   
     .              enddo                                                       
     .              i = imax - 1                                                
     .              aax_lumat(j+k*jmax-jmax,imax-1,i-1) = -pyz_soseaicediffcoef(
     .       1         i-1,j,k)*y_factor(j)                                     
     .              aax_lumat(j+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/( 
     .       1         1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(i-
     .       2         1,j,k)+pyz_soseaicediffcoef(i,j,k))*y_factor(j)          
     .              aax_lumat(j+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(  
     .       1         imax-1,j,k)*y_factor(j)                                  
     .           enddo                                                          
     .           i1 = 0                                                         
     .           do j = j2 + 1, jmax, 4                                         
     .              aax_lumat(j+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(  
     .       1         imax-1,j,k)*y_factor(j)                                  
     .              aax_lumat(j+1+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+1,k)*y_factor(j+1)                              
     .              aax_lumat(j+2+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+2,k)*y_factor(j+2)                              
     .              aax_lumat(j+3+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+3,k)*y_factor(j+3)                              
     .              aax_lumat(j+k*jmax-jmax,0,i1) = 1.00000000000000e+000/(     
     .       1         1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(  
     .       2         imax-1,j,k)+pyz_soseaicediffcoef(i1,j,k))*y_factor(j)    
     .              aax_lumat(j+1+k*jmax-jmax,0,i1) = 1.00000000000000e+000/(   
     .       1         1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(  
     .       2         imax-1,j+1,k)+pyz_soseaicediffcoef(i1,j+1,k))*y_factor(j+
     .       3         1)                                                       
     .              aax_lumat(j+2+k*jmax-jmax,0,i1) = 1.00000000000000e+000/(   
     .       1         1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(  
     .       2         imax-1,j+2,k)+pyz_soseaicediffcoef(i1,j+2,k))*y_factor(j+
     .       3         2)                                                       
     .              aax_lumat(j+3+k*jmax-jmax,0,i1) = 1.00000000000000e+000/(   
     .       1         1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(  
     .       2         imax-1,j+3,k)+pyz_soseaicediffcoef(i1,j+3,k))*y_factor(j+
     .       3         3)                                                       
     .              aax_lumat(j+k*jmax-jmax,0,i1+1) = -pyz_soseaicediffcoef(i1,j
     .       1         ,k)*y_factor(j)                                          
     .              aax_lumat(j+1+k*jmax-jmax,0,i1+1) = -pyz_soseaicediffcoef(i1
     .       1         ,j+1,k)*y_factor(j+1)                                    
     .              aax_lumat(j+2+k*jmax-jmax,0,i1+1) = -pyz_soseaicediffcoef(i1
     .       1         ,j+2,k)*y_factor(j+2)                                    
     .              aax_lumat(j+3+k*jmax-jmax,0,i1+1) = -pyz_soseaicediffcoef(i1
     .       1         ,j+3,k)*y_factor(j+3)                                    
     .  !cdir       nodep                                                       
     .              do ii = 1, imax - 2                                         
     .                 aax_lumat(j+k*jmax-jmax,ii,ii-1) = -pyz_soseaicediffcoef(
     .       1            ii-1,j,k)*y_factor(j)                                 
     .                 aax_lumat(j+1+k*jmax-jmax,ii,ii-1) = -                   
     .       1            pyz_soseaicediffcoef(ii-1,j+1,k)*y_factor(j+1)        
     .                 aax_lumat(j+2+k*jmax-jmax,ii,ii-1) = -                   
     .       1            pyz_soseaicediffcoef(ii-1,j+2,k)*y_factor(j+2)        
     .                 aax_lumat(j+3+k*jmax-jmax,ii,ii-1) = -                   
     .       1            pyz_soseaicediffcoef(ii-1,j+3,k)*y_factor(j+3)        
     .                 aax_lumat(j+k*jmax-jmax,ii,ii) = (1.00000000000000e+000/(
     .       1            1.00000000000000e+000*deltime)) + (                   
     .       2            pyz_soseaicediffcoef(ii-1,j,k)+pyz_soseaicediffcoef(ii
     .       3            ,j,k))*y_factor(j)                                    
     .                 aax_lumat(j+1+k*jmax-jmax,ii,ii) = (1.00000000000000e+000
     .       1            /(1.00000000000000e+000*deltime)) + (                 
     .       2            pyz_soseaicediffcoef(ii-1,j+1,k)+pyz_soseaicediffcoef(
     .       3            ii,j+1,k))*y_factor(j+1)                              
     .                 aax_lumat(j+2+k*jmax-jmax,ii,ii) = (1.00000000000000e+000
     .       1            /(1.00000000000000e+000*deltime)) + (                 
     .       2            pyz_soseaicediffcoef(ii-1,j+2,k)+pyz_soseaicediffcoef(
     .       3            ii,j+2,k))*y_factor(j+2)                              
     .                 aax_lumat(j+3+k*jmax-jmax,ii,ii) = (1.00000000000000e+000
     .       1            /(1.00000000000000e+000*deltime)) + (                 
     .       2            pyz_soseaicediffcoef(ii-1,j+3,k)+pyz_soseaicediffcoef(
     .       3            ii,j+3,k))*y_factor(j+3)                              
     .                 aax_lumat(j+k*jmax-jmax,ii,1+ii) = -pyz_soseaicediffcoef(
     .       1            ii,j,k)*y_factor(j)                                   
     .                 aax_lumat(j+1+k*jmax-jmax,ii,1+ii) = -                   
     .       1            pyz_soseaicediffcoef(ii,j+1,k)*y_factor(j+1)          
     .                 aax_lumat(j+2+k*jmax-jmax,ii,1+ii) = -                   
     .       1            pyz_soseaicediffcoef(ii,j+2,k)*y_factor(j+2)          
     .                 aax_lumat(j+3+k*jmax-jmax,ii,1+ii) = -                   
     .       1            pyz_soseaicediffcoef(ii,j+3,k)*y_factor(j+3)          
     .              enddo                                                       
     .              i = imax - 1                                                
     .              aax_lumat(j+k*jmax-jmax,imax-1,i-1) = -pyz_soseaicediffcoef(
     .       1         i-1,j,k)*y_factor(j)                                     
     .              aax_lumat(j+1+k*jmax-jmax,imax-1,i-1) = -                   
     .       1         pyz_soseaicediffcoef(i-1,j+1,k)*y_factor(j+1)            
     .              aax_lumat(j+2+k*jmax-jmax,imax-1,i-1) = -                   
     .       1         pyz_soseaicediffcoef(i-1,j+2,k)*y_factor(j+2)            
     .              aax_lumat(j+3+k*jmax-jmax,imax-1,i-1) = -                   
     .       1         pyz_soseaicediffcoef(i-1,j+3,k)*y_factor(j+3)            
     .              aax_lumat(j+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/( 
     .       1         1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(i-
     .       2         1,j,k)+pyz_soseaicediffcoef(i,j,k))*y_factor(j)          
     .              aax_lumat(j+1+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/
     .       1         (1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(i
     .       2         -1,j+1,k)+pyz_soseaicediffcoef(i,j+1,k))*y_factor(j+1)   
     .              aax_lumat(j+2+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/
     .       1         (1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(i
     .       2         -1,j+2,k)+pyz_soseaicediffcoef(i,j+2,k))*y_factor(j+2)   
     .              aax_lumat(j+3+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/
     .       1         (1.00000000000000e+000*deltime) + (pyz_soseaicediffcoef(i
     .       2         -1,j+3,k)+pyz_soseaicediffcoef(i,j+3,k))*y_factor(j+3)   
     .              aax_lumat(j+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(  
     .       1         imax-1,j,k)*y_factor(j)                                  
     .              aax_lumat(j+1+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+1,k)*y_factor(j+1)                              
     .              aax_lumat(j+2+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+2,k)*y_factor(j+2)                              
     .              aax_lumat(j+3+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+3,k)*y_factor(j+3)                              
     .           enddo                                                          
     .        endif                                                             
  1990      end do
  1991  
  1992      call ludecomp_prep_simple_many ( jmax*ksimax, imax, aax_LUMat, 1, jmax*ksimax )
  1993  
  1994  
  1995      do k = 1, ksimax
  1996        do j = 1, jmax
  1997          l = (k-1)*jmax+j
  1998          do ii = 0, imax-1
  1999            i = ii
  2000            aa_LUVec(l,ii) = xyz_SOSeaIceThickness(i,j,k) / ( 1.0_DP * DelTime )
  2001          end do
  2002        end do
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .           do j = 1, j3                                                   
     .              d2 = 1.D0/(1.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 aa_luvec(j+k*jmax-jmax,ii-1) = xyz_soseaicethickness(ii-1
     .       1            ,j,k)*d2                                              
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j3 + 1, jmax, 4                                         
     .              d3 = 1.D0/(1.00000000000000e+000*deltime)                   
     .              d4 = 1.D0/(1.00000000000000e+000*deltime)                   
     .              d5 = 1.D0/(1.00000000000000e+000*deltime)                   
     .              d6 = 1.D0/(1.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 aa_luvec(j+k*jmax-jmax,ii-1) = xyz_soseaicethickness(ii-1
     .       1            ,j,k)*d3                                              
     .                 aa_luvec(j+1+k*jmax-jmax,ii-1) = xyz_soseaicethickness(ii
     .       1            -1,j+1,k)*d4                                          
     .                 aa_luvec(j+2+k*jmax-jmax,ii-1) = xyz_soseaicethickness(ii
     .       1            -1,j+2,k)*d5                                          
     .                 aa_luvec(j+3+k*jmax-jmax,ii-1) = xyz_soseaicethickness(ii
     .       1            -1,j+3,k)*d6                                          
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  2003      end do
  2004      call ludecomp_solve_simple_many( jmax*ksimax, imax, aax_LUMat, aa_LUVec, 1, jmax*ksimax )
  2005      do k = 1, ksimax
  2006        do j = 1, jmax
  2007          l = (k-1)*jmax+j
  2008          do ii = 0, imax-1
  2009            i = ii
  2010            xyz_SOSeaIceThicknessA(i,j,k) = aa_LUVec(l,ii)
  2011          end do
  2012        end do
     .        if (jmax .gt. 0) then                                             
     .           j4 = and(jmax,3)                                               
     .           do j = 1, j4                                                   
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 xyz_soseaicethicknessa(ii-1,j,k) = aa_luvec(j+k*jmax-jmax
     .       1            ,ii-1)                                                
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j4 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 xyz_soseaicethicknessa(ii-1,j,k) = aa_luvec(j+k*jmax-jmax
     .       1            ,ii-1)                                                
     .                 xyz_soseaicethicknessa(ii-1,j+1,k) = aa_luvec(j+1+k*jmax-
     .       1            jmax,ii-1)                                            
     .                 xyz_soseaicethicknessa(ii-1,j+2,k) = aa_luvec(j+2+k*jmax-
     .       1            jmax,ii-1)                                            
     .                 xyz_soseaicethicknessa(ii-1,j+3,k) = aa_luvec(j+3+k*jmax-
     .       1            jmax,ii-1)                                            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  2013      end do
  2014  
  2015      do k = 1, ksimax
  2016        do j = 1, jmax
  2017          l = (k-1)*jmax+j
  2018          do ii = 0, imax-1
  2019            i = ii
  2020            aa_LUVec(l,ii) = xyz_SOSeaIceTemp(i,j,k) / ( 1.0_DP * DelTime )
  2021          end do
  2022        end do
     .        if (jmax .gt. 0) then                                             
     .           j5 = and(jmax,3)                                               
     .           do j = 1, j5                                                   
     .              d7 = 1.D0/(1.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 aa_luvec(j+k*jmax-jmax,ii-1) = xyz_soseaicetemp(ii-1,j,k)
     .       1            *d7                                                   
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j5 + 1, jmax, 4                                         
     .              d8 = 1.D0/(1.00000000000000e+000*deltime)                   
     .              d9 = 1.D0/(1.00000000000000e+000*deltime)                   
     .              d10 = 1.D0/(1.00000000000000e+000*deltime)                  
     .              d11 = 1.D0/(1.00000000000000e+000*deltime)                  
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 aa_luvec(j+k*jmax-jmax,ii-1) = xyz_soseaicetemp(ii-1,j,k)
     .       1            *d8                                                   
     .                 aa_luvec(j+1+k*jmax-jmax,ii-1) = xyz_soseaicetemp(ii-1,j+
     .       1            1,k)*d9                                               
     .                 aa_luvec(j+2+k*jmax-jmax,ii-1) = xyz_soseaicetemp(ii-1,j+
     .       1            2,k)*d10                                              
     .                 aa_luvec(j+3+k*jmax-jmax,ii-1) = xyz_soseaicetemp(ii-1,j+
     .       1            3,k)*d11                                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  2023      end do
  2024      call ludecomp_solve_simple_many( jmax*ksimax, imax, aax_LUMat, aa_LUVec, 1, jmax*ksimax )
  2025      do k = 1, ksimax
  2026        do j = 1, jmax
  2027          l = (k-1)*jmax+j
  2028          do ii = 0, imax-1
  2029            i = ii
  2030            xyz_SOSeaIceTempA(i,j,k) = aa_LUVec(l,ii)
  2031          end do
  2032        end do
     .        if (jmax .gt. 0) then                                             
     .           j6 = and(jmax,3)                                               
     .           do j = 1, j6                                                   
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 xyz_soseaicetempa(ii-1,j,k)=aa_luvec(j+k*jmax-jmax,ii-1) 
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j6 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 xyz_soseaicetempa(ii-1,j,k)=aa_luvec(j+k*jmax-jmax,ii-1) 
     .                 xyz_soseaicetempa(ii-1,j+1,k) = aa_luvec(j+1+k*jmax-jmax,
     .       1            ii-1)                                                 
     .                 xyz_soseaicetempa(ii-1,j+2,k) = aa_luvec(j+2+k*jmax-jmax,
     .       1            ii-1)                                                 
     .                 xyz_soseaicetempa(ii-1,j+3,k) = aa_luvec(j+3+k*jmax-jmax,
     .       1            ii-1)                                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  2033      end do
  2034  
  2035  
  2036      ! Diffusion of slab ocean temperature
  2037      !
  2038      do k = 1, ksimax
  2039        do j = 1, jmax
  2040          do i = 0, imax-1
  2041            if ( i == imax-1 ) then
  2042              iprev = i
  2043              inext = 0
  2044            else
  2045              iprev = i
  2046              inext = i+1
  2047            end if
  2048            if ( xy_FlagSlabOcean(iprev,j) .and. xy_FlagSlabOcean(inext,j) ) then
  2049              pyz_SOSeaIceDiffCoef(i,j,k) = SOSeaIceDiffCoef &
  2050                & * min( SOMass - xy_SOSeaIceMass(iprev,j), &
  2051                &        SOMass - xy_SOSeaIceMass(inext,j) )
  2052            else
  2053              pyz_SOSeaIceDiffCoef(i,j,k) = 0.0_DP
  2054            end if
  2055          end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(xy_flagslabocean,xy_soseaicemass)                          
     .        do i = 1, imax                                                    
     .           if (i - 1 .eq. imax-1) then                                    
     .              iprev = i - 1                                               
     .              inext = 0                                                   
     .           else                                                           
     .              iprev = i - 1                                               
     .              inext = i                                                   
     .           endif                                                          
     .           if (xy_flagslabocean(iprev,j) .and. xy_flagslabocean(inext,j)) 
     .       1      then                                                        
     .              pyz_soseaicediffcoef12 = soseaicediffcoef*min(somass -      
     .       1         xy_soseaicemass(iprev,j),somass-xy_soseaicemass(inext,j))
     .           else                                                           
     .              pyz_soseaicediffcoef12 = 0.0000000000000000e+000            
     .           endif                                                          
     .           pyz_soseaicediffcoef(i-1,j,k) = pyz_soseaicediffcoef12         
     .        enddo                                                             
  2056        end do
  2057      end do
  2058  
  2059      aax_LUMat = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1138 = 1, (aax_lumat.DSC.U3 + 1)*(aax_lumat.DSC.U2 + 1)*      
     .       1   aax_lumat.DSC.U1                                               
     .           aax_lumat(t1138,0,0) = 0.0000000000000000e+000                 
     .        enddo                                                             
  2060      do k = 1, ksimax
  2061        do j = 1, jmax
  2062          l = (k-1)*jmax+j
  2063  
  2064          do ii = 0, 0
  2065            i = ii
  2066            aax_LUMat(l,ii,imax-1) = &
  2067              & - pyz_SOSeaIceDiffCoef(imax-1,j,k) &
  2068              &   * y_Factor(j)
  2069            aax_LUMat(l,ii,i  ) = &
  2070              &   1.0_DP / ( 1.0_DP * DelTime )          &
  2071              &     * ( SOMass - xy_SOSeaIceMass(i,j) )  &
  2072              & + ( pyz_SOSeaIceDiffCoef(imax-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  2073              &   * y_Factor(j)
  2074            aax_LUMat(l,ii,i+1) = &
  2075              & - pyz_SOSeaIceDiffCoef(i     ,j,k) &
  2076              &   * y_Factor(j)
  2077          end do
  2078          do ii = 0+1, (imax-1)-1
  2079            i = ii
  2080            aax_LUMat(l,ii,i-1) = &
  2081              & - pyz_SOSeaIceDiffCoef(i-1,j,k) &
  2082              &   * y_Factor(j)
  2083            aax_LUMat(l,ii,i  ) = &
  2084              &   1.0_DP / ( 1.0_DP * DelTime )          &
  2085              &     * ( SOMass - xy_SOSeaIceMass(i,j) )  &
  2086              & + ( pyz_SOSeaIceDiffCoef(i-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  2087              &   * y_Factor(j)
  2088            aax_LUMat(l,ii,i+1) = &
  2089              & - pyz_SOSeaIceDiffCoef(i  ,j,k) &
  2090              &   * y_Factor(j)
  2091          end do
  2092          do ii = imax-1, imax-1
  2093            i = ii
  2094            aax_LUMat(l,ii,i-1) = &
  2095              & - pyz_SOSeaIceDiffCoef(i-1,j,k) &
  2096              &   * y_Factor(j)
  2097            aax_LUMat(l,ii,i  ) = &
  2098              &   1.0_DP / ( 1.0_DP * DelTime )          &
  2099              &     * ( SOMass - xy_SOSeaIceMass(i,j) )  &
  2100              & + ( pyz_SOSeaIceDiffCoef(i-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  2101              &   * y_Factor(j)
  2102            aax_LUMat(l,ii,0  ) = &
  2103              & - pyz_SOSeaIceDiffCoef(imax-1,j,k) &
  2104              &   * y_Factor(j)
  2105          end do
  2106  
  2107  
  2108        end do
     .        if (jmax .gt. 0) then                                             
     .           j8 = and(jmax,3)                                               
     .           i2 = 0                                                         
     .           do j = 1, j8                                                   
     .              aax_lumat(j+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(  
     .       1         imax-1,j,k)*y_factor(j)                                  
     .              aax_lumat(j+k*jmax-jmax,0,i2) = 1.00000000000000e+000/(     
     .       1         1.00000000000000e+000*deltime)*(somass - xy_soseaicemass(
     .       2         i2,j)) + (pyz_soseaicediffcoef(imax-1,j,k)+              
     .       3         pyz_soseaicediffcoef(i2,j,k))*y_factor(j)                
     .              aax_lumat(j+k*jmax-jmax,0,i2+1) = -pyz_soseaicediffcoef(i2,j
     .       1         ,k)*y_factor(j)                                          
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_soseaicemass)                                     
     .              do ii = 1, imax - 2                                         
     .                 aax_lumat(j+k*jmax-jmax,ii,ii-1) = -pyz_soseaicediffcoef(
     .       1            ii-1,j,k)*y_factor(j)                                 
     .                 aax_lumat(j+k*jmax-jmax,ii,ii) = 1.00000000000000e+000/( 
     .       1            1.00000000000000e+000*deltime)*(somass -              
     .       2            xy_soseaicemass(ii,j)) + (pyz_soseaicediffcoef(ii-1,j,
     .       3            k)+pyz_soseaicediffcoef(ii,j,k))*y_factor(j)          
     .                 aax_lumat(j+k*jmax-jmax,ii,1+ii) = -pyz_soseaicediffcoef(
     .       1            ii,j,k)*y_factor(j)                                   
     .              enddo                                                       
     .              i = imax - 1                                                
     .              aax_lumat(j+k*jmax-jmax,imax-1,i-1) = -pyz_soseaicediffcoef(
     .       1         i-1,j,k)*y_factor(j)                                     
     .              aax_lumat(j+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/( 
     .       1         1.00000000000000e+000*deltime)*(somass - xy_soseaicemass(
     .       2         i,j)) + (pyz_soseaicediffcoef(i-1,j,k)+                  
     .       3         pyz_soseaicediffcoef(i,j,k))*y_factor(j)                 
     .              aax_lumat(j+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(  
     .       1         imax-1,j,k)*y_factor(j)                                  
     .           enddo                                                          
     .           i2 = 0                                                         
     .           do j = j8 + 1, jmax, 4                                         
     .              aax_lumat(j+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(  
     .       1         imax-1,j,k)*y_factor(j)                                  
     .              aax_lumat(j+1+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+1,k)*y_factor(j+1)                              
     .              aax_lumat(j+2+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+2,k)*y_factor(j+2)                              
     .              aax_lumat(j+3+k*jmax-jmax,0,imax-1) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+3,k)*y_factor(j+3)                              
     .              aax_lumat(j+k*jmax-jmax,0,i2) = 1.00000000000000e+000/(     
     .       1         1.00000000000000e+000*deltime)*(somass - xy_soseaicemass(
     .       2         i2,j)) + (pyz_soseaicediffcoef(imax-1,j,k)+              
     .       3         pyz_soseaicediffcoef(i2,j,k))*y_factor(j)                
     .              aax_lumat(j+1+k*jmax-jmax,0,i2) = 1.00000000000000e+000/(   
     .       1         1.00000000000000e+000*deltime)*(somass - xy_soseaicemass(
     .       2         i2,j+1)) + (pyz_soseaicediffcoef(imax-1,j+1,k)+          
     .       3         pyz_soseaicediffcoef(i2,j+1,k))*y_factor(j+1)            
     .              aax_lumat(j+2+k*jmax-jmax,0,i2) = 1.00000000000000e+000/(   
     .       1         1.00000000000000e+000*deltime)*(somass - xy_soseaicemass(
     .       2         i2,j+2)) + (pyz_soseaicediffcoef(imax-1,j+2,k)+          
     .       3         pyz_soseaicediffcoef(i2,j+2,k))*y_factor(j+2)            
     .              aax_lumat(j+3+k*jmax-jmax,0,i2) = 1.00000000000000e+000/(   
     .       1         1.00000000000000e+000*deltime)*(somass - xy_soseaicemass(
     .       2         i2,j+3)) + (pyz_soseaicediffcoef(imax-1,j+3,k)+          
     .       3         pyz_soseaicediffcoef(i2,j+3,k))*y_factor(j+3)            
     .              aax_lumat(j+k*jmax-jmax,0,i2+1) = -pyz_soseaicediffcoef(i2,j
     .       1         ,k)*y_factor(j)                                          
     .              aax_lumat(j+1+k*jmax-jmax,0,i2+1) = -pyz_soseaicediffcoef(i2
     .       1         ,j+1,k)*y_factor(j+1)                                    
     .              aax_lumat(j+2+k*jmax-jmax,0,i2+1) = -pyz_soseaicediffcoef(i2
     .       1         ,j+2,k)*y_factor(j+2)                                    
     .              aax_lumat(j+3+k*jmax-jmax,0,i2+1) = -pyz_soseaicediffcoef(i2
     .       1         ,j+3,k)*y_factor(j+3)                                    
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_soseaicemass)                                     
     .              do ii = 1, imax - 2                                         
     .                 aax_lumat(j+k*jmax-jmax,ii,ii-1) = -pyz_soseaicediffcoef(
     .       1            ii-1,j,k)*y_factor(j)                                 
     .                 aax_lumat(j+1+k*jmax-jmax,ii,ii-1) = -                   
     .       1            pyz_soseaicediffcoef(ii-1,j+1,k)*y_factor(j+1)        
     .                 aax_lumat(j+2+k*jmax-jmax,ii,ii-1) = -                   
     .       1            pyz_soseaicediffcoef(ii-1,j+2,k)*y_factor(j+2)        
     .                 aax_lumat(j+3+k*jmax-jmax,ii,ii-1) = -                   
     .       1            pyz_soseaicediffcoef(ii-1,j+3,k)*y_factor(j+3)        
     .                 aax_lumat(j+k*jmax-jmax,ii,ii) = (1.00000000000000e+000/(
     .       1            1.00000000000000e+000*deltime))*(somass -             
     .       2            xy_soseaicemass(ii,j)) + (pyz_soseaicediffcoef(ii-1,j,
     .       3            k)+pyz_soseaicediffcoef(ii,j,k))*y_factor(j)          
     .                 aax_lumat(j+1+k*jmax-jmax,ii,ii) = (1.00000000000000e+000
     .       1            /(1.00000000000000e+000*deltime))*(somass -           
     .       2            xy_soseaicemass(ii,j+1)) + (pyz_soseaicediffcoef(ii-1,
     .       3            j+1,k)+pyz_soseaicediffcoef(ii,j+1,k))*y_factor(j+1)  
     .                 aax_lumat(j+2+k*jmax-jmax,ii,ii) = (1.00000000000000e+000
     .       1            /(1.00000000000000e+000*deltime))*(somass -           
     .       2            xy_soseaicemass(ii,j+2)) + (pyz_soseaicediffcoef(ii-1,
     .       3            j+2,k)+pyz_soseaicediffcoef(ii,j+2,k))*y_factor(j+2)  
     .                 aax_lumat(j+3+k*jmax-jmax,ii,ii) = (1.00000000000000e+000
     .       1            /(1.00000000000000e+000*deltime))*(somass -           
     .       2            xy_soseaicemass(ii,j+3)) + (pyz_soseaicediffcoef(ii-1,
     .       3            j+3,k)+pyz_soseaicediffcoef(ii,j+3,k))*y_factor(j+3)  
     .                 aax_lumat(j+k*jmax-jmax,ii,1+ii) = -pyz_soseaicediffcoef(
     .       1            ii,j,k)*y_factor(j)                                   
     .                 aax_lumat(j+1+k*jmax-jmax,ii,1+ii) = -                   
     .       1            pyz_soseaicediffcoef(ii,j+1,k)*y_factor(j+1)          
     .                 aax_lumat(j+2+k*jmax-jmax,ii,1+ii) = -                   
     .       1            pyz_soseaicediffcoef(ii,j+2,k)*y_factor(j+2)          
     .                 aax_lumat(j+3+k*jmax-jmax,ii,1+ii) = -                   
     .       1            pyz_soseaicediffcoef(ii,j+3,k)*y_factor(j+3)          
     .              enddo                                                       
     .              i = imax - 1                                                
     .              aax_lumat(j+k*jmax-jmax,imax-1,i-1) = -pyz_soseaicediffcoef(
     .       1         i-1,j,k)*y_factor(j)                                     
     .              aax_lumat(j+1+k*jmax-jmax,imax-1,i-1) = -                   
     .       1         pyz_soseaicediffcoef(i-1,j+1,k)*y_factor(j+1)            
     .              aax_lumat(j+2+k*jmax-jmax,imax-1,i-1) = -                   
     .       1         pyz_soseaicediffcoef(i-1,j+2,k)*y_factor(j+2)            
     .              aax_lumat(j+3+k*jmax-jmax,imax-1,i-1) = -                   
     .       1         pyz_soseaicediffcoef(i-1,j+3,k)*y_factor(j+3)            
     .              aax_lumat(j+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/( 
     .       1         1.00000000000000e+000*deltime)*(somass - xy_soseaicemass(
     .       2         i,j)) + (pyz_soseaicediffcoef(i-1,j,k)+                  
     .       3         pyz_soseaicediffcoef(i,j,k))*y_factor(j)                 
     .              aax_lumat(j+1+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/
     .       1         (1.00000000000000e+000*deltime)*(somass - xy_soseaicemass
     .       2         (i,j+1)) + (pyz_soseaicediffcoef(i-1,j+1,k)+             
     .       3         pyz_soseaicediffcoef(i,j+1,k))*y_factor(j+1)             
     .              aax_lumat(j+2+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/
     .       1         (1.00000000000000e+000*deltime)*(somass - xy_soseaicemass
     .       2         (i,j+2)) + (pyz_soseaicediffcoef(i-1,j+2,k)+             
     .       3         pyz_soseaicediffcoef(i,j+2,k))*y_factor(j+2)             
     .              aax_lumat(j+3+k*jmax-jmax,imax-1,i) = 1.00000000000000e+000/
     .       1         (1.00000000000000e+000*deltime)*(somass - xy_soseaicemass
     .       2         (i,j+3)) + (pyz_soseaicediffcoef(i-1,j+3,k)+             
     .       3         pyz_soseaicediffcoef(i,j+3,k))*y_factor(j+3)             
     .              aax_lumat(j+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(  
     .       1         imax-1,j,k)*y_factor(j)                                  
     .              aax_lumat(j+1+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+1,k)*y_factor(j+1)                              
     .              aax_lumat(j+2+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+2,k)*y_factor(j+2)                              
     .              aax_lumat(j+3+k*jmax-jmax,imax-1,0) = -pyz_soseaicediffcoef(
     .       1         imax-1,j+3,k)*y_factor(j+3)                              
     .           enddo                                                          
     .        endif                                                             
  2109      end do
  2110      !
  2111      do k = 1, ksimax
  2112        do j = 1, jmax
  2113          l = (k-1)*jmax+j
  2114          do ii = 0, 0
     .  !cdir on_adb(xy_soseaicemass)                                           
     .        do ii = 0, 0                                                      
  2115            i = ii
  2116            if ( SOMass - xy_SOSeaIceMass(i,j) <= 0.0_DP ) then
  2117              aax_LUMat(l,ii,imax-1) = 0.0_DP
  2118              aax_LUMat(l,ii,i     ) = 1.0_DP
  2119              aax_LUMat(l,ii,i+1   ) = 0.0_DP
  2120            end if
  2121          end do
  2122          do ii = 0+1, (imax-1)-1
     .  !cdir    nodep                                                          
     .  !cdir on_adb(xy_soseaicemass)                                           
     .        do ii = 1, imax - 2                                               
  2123            i = ii
  2124            if ( SOMass - xy_SOSeaIceMass(i,j) <= 0.0_DP ) then
  2125              aax_LUMat(l,ii,i-1) = 0.0_DP
  2126              aax_LUMat(l,ii,i  ) = 1.0_DP
  2127              aax_LUMat(l,ii,i+1) = 0.0_DP
  2128            end if
  2129          end do
  2130          do ii = imax-1, imax-1
     .  !cdir    on_adb(xy_soseaicemass)                                        
     .        do ii = imax - 1, imax - 1                                        
  2131            i = ii
  2132            if ( SOMass - xy_SOSeaIceMass(i,j) <= 0.0_DP ) then
  2133              aax_LUMat(l,ii,i-1) = 0.0_DP
  2134              aax_LUMat(l,ii,i  ) = 1.0_DP
  2135              aax_LUMat(l,ii,0  ) = 0.0_DP
  2136            end if
  2137          end do
  2138  
  2139  
  2140        end do
  2141      end do
  2142  
  2143  
  2144      call ludecomp_prep_simple_many ( jmax*ksimax, imax, aax_LUMat, 1, jmax*ksimax )
  2145  
  2146      do k = 1, ksimax
  2147        do j = 1, jmax
  2148          l = (k-1)*jmax+j
  2149          do ii = 0, imax-1
  2150            i = ii
  2151            if ( SOMass - xy_SOSeaIceMass(i,j) <= 0.0_DP ) then
  2152              aa_LUVec(l,ii) = xy_SurfTemp(i,j)
  2153            else
  2154              aa_LUVec(l,ii) = xy_SurfTemp(i,j) &
  2155                & * ( SOMass - xy_SOSeaIceMass(i,j) )  &
  2156                & / ( 1.0_DP * DelTime )
  2157            end if
  2158          end do
  2159        end do
     .           if (jmax .gt. 0) then                                          
     .           j9 = and(jmax,3)                                               
     .           do j = 1, j9                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_soseaicemass,xy_surftemp)                         
     .              do ii = 1, imax                                             
     .                 if ((somass - xy_soseaicemass(ii-1,j)) .le.              
     .       1            0.0000000000000000e+000) then                         
     .                    aa_luvec13 = xy_surftemp(ii-1,j)                      
     .                 else                                                     
     .                    aa_luvec13 = xy_surftemp(ii-1,j)*(somass -            
     .       1               xy_soseaicemass(ii-1,j))/(1.00000000000000e+000*   
     .       2               deltime)                                           
     .                 endif                                                    
     .                 aa_luvec(j+k*jmax-jmax,ii-1) = aa_luvec13                
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j9 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_soseaicemass,xy_surftemp)                         
     .              do ii = 1, imax                                             
     .                 if ((somass - xy_soseaicemass(ii-1,j)) .le.              
     .       1            0.0000000000000000e+000) then                         
     .                    aa_luvec14 = xy_surftemp(ii-1,j)                      
     .                 else                                                     
     .                    aa_luvec14 = xy_surftemp(ii-1,j)*(somass -            
     .       1               xy_soseaicemass(ii-1,j))/(1.00000000000000e+000*   
     .       2               deltime)                                           
     .                 endif                                                    
     .                 aa_luvec(j+k*jmax-jmax,ii-1) = aa_luvec14                
     .                 if ((somass - xy_soseaicemass(ii-1,j+1)) .le.            
     .       1            0.0000000000000000e+000) then                         
     .                    aa_luvec15 = xy_surftemp(ii-1,j+1)                    
     .                 else                                                     
     .                    aa_luvec15 = xy_surftemp(ii-1,j+1)*(somass -          
     .       1               xy_soseaicemass(ii-1,j+1))/(1.00000000000000e+000* 
     .       2               deltime)                                           
     .                 endif                                                    
     .                 aa_luvec(j+1+k*jmax-jmax,ii-1) = aa_luvec15              
     .                 if ((somass - xy_soseaicemass(ii-1,j+2)) .le.            
     .       1            0.0000000000000000e+000) then                         
     .                    aa_luvec16 = xy_surftemp(ii-1,j+2)                    
     .                 else                                                     
     .                    aa_luvec16 = xy_surftemp(ii-1,j+2)*(somass -          
     .       1               xy_soseaicemass(ii-1,j+2))/(1.00000000000000e+000* 
     .       2               deltime)                                           
     .                 endif                                                    
     .                 aa_luvec(j+2+k*jmax-jmax,ii-1) = aa_luvec16              
     .                 if ((somass - xy_soseaicemass(ii-1,j+3)) .le.            
     .       1            0.0000000000000000e+000) then                         
     .                    aa_luvec17 = xy_surftemp(ii-1,j+3)                    
     .                 else                                                     
     .                    aa_luvec17 = xy_surftemp(ii-1,j+3)*(somass -          
     .       1               xy_soseaicemass(ii-1,j+3))/(1.00000000000000e+000* 
     .       2               deltime)                                           
     .                 endif                                                    
     .                 aa_luvec(j+3+k*jmax-jmax,ii-1) = aa_luvec17              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  2160      end do
  2161      call ludecomp_solve_simple_many( jmax*ksimax, imax, aax_LUMat, aa_LUVec, 1, jmax*ksimax )
  2162      do k = 1, 1
  2163        do j = 1, jmax
  2164          l = (k-1)*jmax+j
  2165          do ii = 0, imax-1
  2166            i = ii
  2167            xy_SurfTempA(i,j) = aa_LUVec(l,ii)
  2168          end do
  2169        end do
  2170      end do
     .        if (jmax .gt. 0) then                                             
     .           j10 = and(jmax,3)                                              
     .           do j = 1, j10                                                  
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 xy_surftempa(ii-1,j) = aa_luvec(j,ii-1)                  
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j10 + 1, jmax, 4                                        
     .  !cdir       nodep                                                       
     .              do ii = 1, imax                                             
     .                 xy_surftempa(ii-1,j) = aa_luvec(j,ii-1)                  
     .                 xy_surftempa(ii-1,j+1) = aa_luvec(j+1,ii-1)              
     .                 xy_surftempa(ii-1,j+2) = aa_luvec(j+2,ii-1)              
     .                 xy_surftempa(ii-1,j+3) = aa_luvec(j+3,ii-1)              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  2171  
  2172  
  2173    end subroutine SOSIDiffusionX
  2174  
  2175    !-------------------------------------------------
  2176  
  2177    subroutine SOSIDynamicsInit( &
  2178      & ArgFlagSlabOcean &
  2179      & )
  2180      ! flag for use of slab ocean
  2181      !
  2182      ! Initialization of module
  2183  
  2184  
  2185      !
  2186      ! MPI
  2187      !
  2188      ! 種別型パラメタ
  2189      ! Kind type parameter
  2190      !
  2191      use dc_types, only: &
  2192        & STDOUT, &             ! 標準出力の装置番号. Unit number of standard output
  2193        & STRING                ! 文字列.       Strings.
  2194  
  2195      ! ファイル入出力補助
  2196      ! File I/O support
  2197      !
  2198      use dc_iounit, only: FileOpen
  2199  
  2200      ! NAMELIST ファイル入力に関するユーティリティ
  2201      ! Utilities for NAMELIST file input
  2202      !
  2203      use namelist_util, only: namelist_filename, NmlutilMsg
  2204  
  2205      use mpi_wrapper   , only : myrank, nprocs
  2206  
  2207      ! ヒストリデータ出力
  2208      ! History data output
  2209      !
  2210      use gtool_historyauto, only: HistoryAutoAddVariable
  2211  
  2212      ! 組成に関わる配列の設定
  2213      ! Settings of array for atmospheric composition
  2214      !
  2215      use composition, only:                              &
  2216        &                    ncmax
  2217                               ! 成分の数
  2218                               ! Number of composition
  2219  
  2220      ! 座標データ設定
  2221      ! Axes data settings
  2222      !
  2223      use axesset, only: &
  2224        & r_Sigma, &
  2225                                ! $ \sigma $ レベル (半整数).
  2226                                ! Half $ \sigma $ level
  2227        & z_Sigma, &            ! $ \sigma $ レベル (整数).
  2228                                ! Full $ \sigma $ level
  2229        & x_Lon, y_Lat, &
  2230        & AxNameX, AxNameY, AxNameZ, AxNameT
  2231  
  2232      use constants0, only : PI
  2233  
  2234      ! 雪と海氷の定数の設定
  2235      ! Setting constants of snow and sea ice
  2236      !
  2237      use constants_snowseaice, only: &
  2238        & ConstantsSnowSeaIceInit
  2239  
  2240      !
  2241      ! Slab ocean sea ice utility module
  2242      !
  2243      use sosi_utils, only : SOSIUtilsInit
  2244  
  2245      use sltt_const , only : SLTTConstInit
  2246      use sosi_dynamics_extarr, only : SLTTExtArrInit
  2247  
  2248  
  2249      use sltt_const , only : iexmin, iexmax, jexmin, jexmax
  2250  
  2251  
  2252  
  2253      logical, intent(in ) :: ArgFlagSlabOcean
  2254  
  2255  
  2256      !
  2257      ! local variables
  2258      !
  2259      integer:: i               ! 東西方向に回る DO ループ用作業変数
  2260                                ! Work variables for DO loop in zonal direction
  2261      integer:: j               ! 南北方向に回る DO ループ用作業変数
  2262                                ! Work variables for DO loop in meridional direction
  2263      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  2264                                ! Work variables for DO loop in vertical direction
  2265      integer:: n
  2266  
  2267      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  2268                                ! Unit number for NAMELIST file open
  2269      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  2270                                ! IOSTAT of NAMELIST read
  2271      ! NAMELIST 変数群
  2272      ! NAMELIST group name
  2273      !
  2274      namelist /sosi_dynamics_nml/ &
  2275        & SOSeaIceDiffCoef
  2276  
  2277  
  2278      ! 実行文 ; Executable statement
  2279      !
  2280  
  2281      if ( sosi_dynamics_inited ) return
  2282  
  2283  
  2284  
  2285      FlagSlabOcean = ArgFlagSlabOcean
  2286  
  2287  
  2288      if ( mod( jmax, 2 ) /= 0 ) then
  2289        stop 'jmax cannot be divided by 2.'
  2290      end if
  2291  
  2292  
  2293      ! Initialization of modules used in this module
  2294      !
  2295  
  2296      ! 雪と海氷の定数の設定
  2297      ! Setting constants of snow and sea ice
  2298      !
  2299      call ConstantsSnowSeaIceInit
  2300  
  2301      !
  2302      ! Slab ocean sea ice utility module
  2303      !
  2304      call SOSIUtilsInit
  2305  
  2306  
  2307      call SLTTConstInit
  2308  
  2309  
  2310      ! デフォルト値の設定
  2311      ! Default values settings
  2312      !
  2313      SOSeaIceDiffCoef              =  0.0e0_DP
  2314  
  2315  
  2316      ! NAMELIST の読み込み
  2317      ! NAMELIST is input
  2318      !
  2319      if ( trim(namelist_filename) /= '' ) then
  2320        call FileOpen( unit_nml, &          ! (out)
  2321          & namelist_filename, mode = 'r' ) ! (in)
  2322  
  2323        rewind( unit_nml )
  2324        read( unit_nml, &               ! (in)
  2325          & nml = sosi_dynamics_nml, &  ! (out)
  2326          & iostat = iostat_nml )       ! (out)
  2327        close( unit_nml )
  2328  
  2329        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2330        if ( iostat_nml == 0 ) write( STDOUT, nml = sosi_dynamics_nml )
  2331      end if
  2332  
  2333  
  2334      allocate( y_CosLat(1:jmax) )
  2335      y_CosLat = cos( y_Lat )
  2336  
  2337      allocate( x_LonS   (0:imax-1) )
  2338      allocate( x_SinLonS(0:imax-1) )
  2339      allocate( x_CosLonS(0:imax-1) )
  2340      allocate( y_latS   (1:jmax/2) )
  2341      allocate( y_SinLatS(1:jmax/2) )
  2342      allocate( y_CosLatS(1:jmax/2) )
  2343      do i = 0, imax-1
  2344        x_LonS   (i) = x_Lon(i)
  2345        x_SinLonS(i) = sin( x_LonS(i) )
  2346        x_CosLonS(i) = cos( x_LonS(i) )
  2347      end do
  2348      do j = 1, jmax/2
  2349        y_LatS   (j) = y_Lat(j)
  2350        y_SinLatS(j) = sin( y_LatS(j) )
  2351        y_CosLatS(j) = cos( y_LatS(j) )
  2352      end do
  2353  
  2354      allocate( x_LonN   (0:imax-1) )
  2355      allocate( x_SinLonN(0:imax-1) )
  2356      allocate( x_CosLonN(0:imax-1) )
  2357      allocate( y_latN   (1:jmax/2) )
  2358      allocate( y_SinLatN(1:jmax/2) )
  2359      allocate( y_CosLatN(1:jmax/2) )
  2360      do i = 0, imax-1
  2361        x_LonN   (i) = x_Lon(i)
  2362        x_SinLonN(i) = sin( x_LonN(i) )
  2363        x_CosLonN(i) = cos( x_LonN(i) )
  2364      end do
  2365      do j = 1, jmax/2
  2366        y_LatN   (j) = y_Lat(j+jmax/2)
  2367        y_SinLatN(j) = sin( y_LatN(j) )
  2368        y_CosLatN(j) = cos( y_LatN(j) )
  2369      end do
  2370  
  2371      allocate( x_ExtLonS( iexmin:iexmax ) )
  2372      allocate( x_ExtLonN( iexmin:iexmax ) )
  2373  
  2374      allocate( y_ExtLatS( jexmin:jexmax ) )
  2375      allocate( y_ExtLatN( jexmin:jexmax ) )
  2376  
  2377      allocate( y_ExtCosLatS( jexmin:jexmax ) )
  2378      allocate( y_ExtCosLatN( jexmin:jexmax ) )
  2379  
  2380  
  2381      call SLTTExtArrInit(                            &
  2382        & x_LonS, y_LatS, x_LonN, y_LatN,             & ! (in )
  2383        & x_ExtLonS, y_ExtLatS, x_ExtLonN, y_ExtLatN  & ! (out)
  2384        & )
  2385  
  2386      y_ExtCosLatS = cos( y_ExtLatS )
  2387      y_ExtCosLatN = cos( y_ExtLatN )
  2388  
  2389      allocate( p_LonS   (0-1:imax-1+1) )
  2390      allocate( q_LatS   (1-1:jmax/2+1) )
  2391      allocate( q_CosLatS(1-1:jmax/2+1) )
  2392      allocate( p_LonN   (0-1:imax-1+1) )
  2393      allocate( q_LatN   (1-1:jmax/2+1) )
  2394      allocate( q_CosLatN(1-1:jmax/2+1) )
  2395  
  2396  
  2397      do i = 0-1, imax-1+1
  2398        p_LonS(i) = ( x_ExtLonS(i) + x_ExtLonS(i+1) ) / 2.0_DP
  2399        p_LonN(i) = ( x_ExtLonN(i) + x_ExtLonN(i+1) ) / 2.0_DP
  2400      end do
  2401      do j = 1-1, jmax/2+1
  2402        q_LatS(j) = ( y_ExtLatS(j) + y_ExtLatS(j+1) ) / 2.0_DP
  2403      end do
  2404      do j = 1-1, jmax/2+1
  2405        q_LatN(j) = ( y_ExtLatN(j) + y_ExtLatN(j+1) ) / 2.0_DP
  2406      end do
  2407      if ( myrank == nprocs-1 ) then
  2408        j = 0
  2409        q_LatS(j) = - PI / 2.0_DP
  2410        j = jmax/2+1
  2411        q_LatN(j) =   PI / 2.0_DP
  2412      end if
  2413  
  2414      q_CosLatS = cos( q_LatS )
  2415      q_CosLatN = cos( q_LatN )
  2416  
  2417  
  2418  
  2419      ! ヒストリデータ出力のためのへの変数登録
  2420      ! Register of variables for history data output
  2421      !
  2422  !!$    do n = 1, ncmax
  2423  !!$      call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtHorMassFix', &
  2424  !!$        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  2425  !!$        & 'tendency of horizontal mass fix of '//trim(a_QMixName(n)), 's-1' )
  2426  !!$      call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtVerMassFix', &
  2427  !!$        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  2428  !!$        & 'tendency of vertical mass fix of '//trim(a_QMixName(n)), 's-1' )
  2429  !!$      call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtTotMassFix', &
  2430  !!$        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  2431  !!$        & 'tendency of mass fix of '//trim(a_QMixName(n)), 's-1' )
  2432  !!$    end do
  2433  
  2434  
  2435      ! 印字 ; Print
  2436      !
  2437      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2438      call MessageNotify( 'M', module_name, '  SOSeaIceDiffCoef              = %f', d = (/ SOSeaIceDiffCoef /) )
  2439  !!$    call MessageNotify( 'M', module_name, '  FlagSLTTArcsineVer       = %b', l = (/ FlagSLTTArcsineVer /) )
  2440  !!$    call MessageNotify( 'M', module_name, '  SLTTArcsineFactor        = %f', d = (/ SLTTArcsineFactor /) )
  2441  !!$    call MessageNotify( 'M', module_name, '  SLTTIntHor               = %c', c1 = trim( SLTTIntHor ) )
  2442  !!$    call MessageNotify( 'M', module_name, '  SLTTIntVer               = %c', c1 = trim( SLTTIntVer ) )
  2443      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2444  
  2445      sosi_dynamics_inited = .true.
  2446  
  2447    end subroutine SOSIDynamicsInit
     .        if (sosi_dynamics_inited .ne. 0) goto 10041                       
     .        flagslabocean = argflagslabocean                                  
     .        if (mod(jmax,2) .eq. 0) goto 10002                                
     .        ASSIST_IO_FLAG1 = 1091239937                                      
     .        ITEM_PTR = loc('jmax cannot be divided by 2.')                    
     .        ITEM_LGTH = 28                                                    
     .        stop 'jmax cannot be divided by 2.'                               
     .  10002 continue                                                          
     .        call constantssnowseaiceinit                                      
     .        call sosiutilsinit                                                
     .        call slttconstinit                                                
     .        soseaicediffcoef = 0.0000000000000000e+000                        
     .        call f_null (%000747)                                             
     .        call fy_chtrim (%000747, %000746, namelist_filename, 256)         
     .        t152 = fy_ccompi(3,%000747,                                       
     .       1   _?1.sosi_dynamics.sosidynamicsinit_.Constdecl.52,%000746,0)    
     .        deallocate (%000747)                                              
     .        if (t152 .eq. 0) goto 10006                                       
     .        call fileopen (unit_nml, namelist_filename, 'r', 1, 256, 1)       
     .        ASSIST_IO_FLAG1 = 159383555                                       
     .        ASSIST_IO_FLAG48 = 32                                             
     .        ASSIST_UNO_INTRL = unit_nml                                       
     .        call f_rwnd                                                       
     .        INIT_IO_FLAG1 = -1450966973                                       
     .        INIT_IO_FLAG2 = 0                                                 
     .        INIT_IO_FLAG48 = 1024                                             
     .        INIT_UNO_INTRL = unit_nml                                         
     .        INIT_IOSTAT_PTR = loc(iostat_nml)                                 
     .        FMT_BEG_PTR = loc(HEADER%ID)                                      
     .        call f_namei                                                      
     .        ASSIST_IO_FLAG1 = 159383555                                       
     .        ASSIST_IO_FLAG2 = 0                                               
     .        ASSIST_IO_FLAG3 = 0                                               
     .        ASSIST_IO_FLAG48 = 32                                             
     .        ASSIST_UNO_INTRL = unit_nml                                       
     .        call f_clos                                                       
     .        call nmlutilmsg (iostat_nml, module_name, 13)                     
     .        if (iostat_nml .ne. 0) goto 10006                                 
     .        INIT_IO_FLAG1 = -1451229117                                       
     .        INIT_IO_FLAG2 = 0                                                 
     .        INIT_IO_FLAG48 = 1024                                             
     .        INIT_UNO_INTRL = 6                                                
     .        FMT_BEG_PTR = loc(HEADER%ID)                                      
     .        call f_nameo                                                      
     .  10006 continue                                                          
     .        y_coslat.DSC.RANK = 1                                             
     .        y_coslat.DSC.L1 = 1                                               
     .        y_coslat.DSC.U1 = jmax                                            
     .        allocate (y_coslat(y_coslat.DSC.L1:y_coslat.DSC.U1))              
     .  !cdir nodep                                                             
     .        do t601 = 0, y_lat.DSC.U1 - y_lat.DSC.L1                          
     .           y_coslat(t601+y_coslat.DSC.L1) = dcos(y_lat(t601+y_lat.DSC.L1))
     .        enddo                                                             
     .        x_lons.DSC.RANK = 1                                               
     .        x_lons.DSC.L1 = 0                                                 
     .        x_lons.DSC.U1 = imax - 1                                          
     .        allocate (x_lons(x_lons.DSC.L1:x_lons.DSC.U1))                    
     .        x_sinlons.DSC.RANK = 1                                            
     .        x_sinlons.DSC.L1 = 0                                              
     .        x_sinlons.DSC.U1 = imax - 1                                       
     .        allocate (x_sinlons(x_sinlons.DSC.L1:x_sinlons.DSC.U1))           
     .        x_coslons.DSC.RANK = 1                                            
     .        x_coslons.DSC.L1 = 0                                              
     .        x_coslons.DSC.U1 = imax - 1                                       
     .        allocate (x_coslons(x_coslons.DSC.L1:x_coslons.DSC.U1))           
     .        y_lats.DSC.RANK = 1                                               
     .        y_lats.DSC.L1 = 1                                                 
     .        y_lats.DSC.U1 = jmax/2                                            
     .        allocate (y_lats(y_lats.DSC.L1:y_lats.DSC.U1))                    
     .        y_sinlats.DSC.RANK = 1                                            
     .        y_sinlats.DSC.L1 = 1                                              
     .        y_sinlats.DSC.U1 = jmax/2                                         
     .        allocate (y_sinlats(y_sinlats.DSC.L1:y_sinlats.DSC.U1))           
     .        y_coslats.DSC.RANK = 1                                            
     .        y_coslats.DSC.L1 = 1                                              
     .        y_coslats.DSC.U1 = jmax/2                                         
     .        allocate (y_coslats(y_coslats.DSC.L1:y_coslats.DSC.U1))           
     .  !cdir nodep                                                             
     .        do i = 0, imax - 1                                                
     .           x_lons(i) = x_lon(i)                                           
     .           x_sinlons(i) = dsin(x_lons(i))                                 
     .           x_coslons(i) = dcos(x_lons(i))                                 
     .        enddo                                                             
     .  !cdir nodep                                                             
     .        do j = 1, jmax/2                                                  
     .           y_lats(j) = y_lat(j)                                           
     .           y_sinlats(j) = dsin(y_lats(j))                                 
     .           y_coslats(j) = dcos(y_lats(j))                                 
     .        enddo                                                             
     .        x_lonn.DSC.RANK = 1                                               
     .        x_lonn.DSC.L1 = 0                                                 
     .        x_lonn.DSC.U1 = imax - 1                                          
     .        allocate (x_lonn(x_lonn.DSC.L1:x_lonn.DSC.U1))                    
     .        x_sinlonn.DSC.RANK = 1                                            
     .        x_sinlonn.DSC.L1 = 0                                              
     .        x_sinlonn.DSC.U1 = imax - 1                                       
     .        allocate (x_sinlonn(x_sinlonn.DSC.L1:x_sinlonn.DSC.U1))           
     .        x_coslonn.DSC.RANK = 1                                            
     .        x_coslonn.DSC.L1 = 0                                              
     .        x_coslonn.DSC.U1 = imax - 1                                       
     .        allocate (x_coslonn(x_coslonn.DSC.L1:x_coslonn.DSC.U1))           
     .        y_latn.DSC.RANK = 1                                               
     .        y_latn.DSC.L1 = 1                                                 
     .        y_latn.DSC.U1 = jmax/2                                            
     .        allocate (y_latn(y_latn.DSC.L1:y_latn.DSC.U1))                    
     .        y_sinlatn.DSC.RANK = 1                                            
     .        y_sinlatn.DSC.L1 = 1                                              
     .        y_sinlatn.DSC.U1 = jmax/2                                         
     .        allocate (y_sinlatn(y_sinlatn.DSC.L1:y_sinlatn.DSC.U1))           
     .        y_coslatn.DSC.RANK = 1                                            
     .        y_coslatn.DSC.L1 = 1                                              
     .        y_coslatn.DSC.U1 = jmax/2                                         
     .        allocate (y_coslatn(y_coslatn.DSC.L1:y_coslatn.DSC.U1))           
     .  !cdir nodep                                                             
     .        do i = 0, imax - 1                                                
     .           x_lonn(i) = x_lon(i)                                           
     .           x_sinlonn(i) = dsin(x_lonn(i))                                 
     .           x_coslonn(i) = dcos(x_lonn(i))                                 
     .        enddo                                                             
     .  !cdir nodep                                                             
     .        do j = 1, jmax/2                                                  
     .           y_latn(j) = y_lat(j+jmax/2)                                    
     .           y_sinlatn(j) = dsin(y_latn(j))                                 
     .           y_coslatn(j) = dcos(y_latn(j))                                 
     .        enddo                                                             
     .        x_extlons.DSC.RANK = 1                                            
     .        x_extlons.DSC.L1 = iexmin                                         
     .        x_extlons.DSC.U1 = iexmax                                         
     .        allocate (x_extlons(x_extlons.DSC.L1:x_extlons.DSC.U1))           
     .        x_extlonn.DSC.RANK = 1                                            
     .        x_extlonn.DSC.L1 = iexmin                                         
     .        x_extlonn.DSC.U1 = iexmax                                         
     .        allocate (x_extlonn(x_extlonn.DSC.L1:x_extlonn.DSC.U1))           
     .        y_extlats.DSC.RANK = 1                                            
     .        y_extlats.DSC.L1 = jexmin                                         
     .        y_extlats.DSC.U1 = jexmax                                         
     .        allocate (y_extlats(y_extlats.DSC.L1:y_extlats.DSC.U1))           
     .        y_extlatn.DSC.RANK = 1                                            
     .        y_extlatn.DSC.L1 = jexmin                                         
     .        y_extlatn.DSC.U1 = jexmax                                         
     .        allocate (y_extlatn(y_extlatn.DSC.L1:y_extlatn.DSC.U1))           
     .        y_extcoslats.DSC.RANK = 1                                         
     .        y_extcoslats.DSC.L1 = jexmin                                      
     .        y_extcoslats.DSC.U1 = jexmax                                      
     .        allocate (y_extcoslats(y_extcoslats.DSC.L1:y_extcoslats.DSC.U1))  
     .        y_extcoslatn.DSC.RANK = 1                                         
     .        y_extcoslatn.DSC.L1 = jexmin                                      
     .        y_extcoslatn.DSC.U1 = jexmax                                      
     .        allocate (y_extcoslatn(y_extcoslatn.DSC.L1:y_extcoslatn.DSC.U1))  
     .        call slttextarrinit (x_lons, y_lats, x_lonn, y_latn, x_extlons,   
     .       1   y_extlats, x_extlonn, y_extlatn)                               
     .  !cdir nodep                                                             
     .        do t605 = 0, y_extlats.DSC.U1 - y_extlats.DSC.L1                  
     .           y_extcoslats(t605+y_extcoslats.DSC.L1) = dcos(y_extlats(t605+  
     .       1      y_extlats.DSC.L1))                                          
     .        enddo                                                             
     .  !cdir nodep                                                             
     .        do t609 = 0, y_extlatn.DSC.U1 - y_extlatn.DSC.L1                  
     .           y_extcoslatn(t609+y_extcoslatn.DSC.L1) = dcos(y_extlatn(t609+  
     .       1      y_extlatn.DSC.L1))                                          
     .        enddo                                                             
     .        p_lons.DSC.RANK = 1                                               
     .        p_lons.DSC.L1 = -1                                                
     .        p_lons.DSC.U1 = imax                                              
     .        allocate (p_lons(p_lons.DSC.L1:p_lons.DSC.U1))                    
     .        q_lats.DSC.RANK = 1                                               
     .        q_lats.DSC.L1 = 0                                                 
     .        q_lats.DSC.U1 = jmax/2 + 1                                        
     .        allocate (q_lats(q_lats.DSC.L1:q_lats.DSC.U1))                    
     .        q_coslats.DSC.RANK = 1                                            
     .        q_coslats.DSC.L1 = 0                                              
     .        q_coslats.DSC.U1 = jmax/2 + 1                                     
     .        allocate (q_coslats(q_coslats.DSC.L1:q_coslats.DSC.U1))           
     .        p_lonn.DSC.RANK = 1                                               
     .        p_lonn.DSC.L1 = -1                                                
     .        p_lonn.DSC.U1 = imax                                              
     .        allocate (p_lonn(p_lonn.DSC.L1:p_lonn.DSC.U1))                    
     .        q_latn.DSC.RANK = 1                                               
     .        q_latn.DSC.L1 = 0                                                 
     .        q_latn.DSC.U1 = jmax/2 + 1                                        
     .        allocate (q_latn(q_latn.DSC.L1:q_latn.DSC.U1))                    
     .        q_coslatn.DSC.RANK = 1                                            
     .        q_coslatn.DSC.L1 = 0                                              
     .        q_coslatn.DSC.U1 = jmax/2 + 1                                     
     .        allocate (q_coslatn(q_coslatn.DSC.L1:q_coslatn.DSC.U1))           
     .        d1 = 1.D0/2.00000000000000e+000                                   
     .        d2 = 1.D0/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .        do i = 1, imax + 2                                                
     .           p_lons(i-2) = (x_extlons(i-2)+x_extlons(i-1))*d1               
     .           p_lonn(i-2) = (x_extlonn(i-2)+x_extlonn(i-1))*d2               
     .        enddo                                                             
     .        d3 = 1.D0/2.00000000000000e+000                                   
     .        d4 = 1.D0/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .        do j = 1, jmax/2 + 2                                              
     .           q_lats(j-1) = (y_extlats(j-1)+y_extlats(j))*d3                 
     .           q_latn(j-1) = (y_extlatn(j-1)+y_extlatn(j))*d4                 
     .        enddo                                                             
     .        if (myrank .ne. nprocs-1) goto 10031                              
     .        j = 0                                                             
     .        q_lats(0) = -1.57079632679489e+000                                
     .        j = jmax/2 + 1                                                    
     .        q_latn(j) = 1.57079632679489e+000                                 
     .  10031 continue                                                          
     .  !cdir nodep                                                             
     .        do t613 = 0, q_lats.DSC.U1 - q_lats.DSC.L1                        
     .           q_coslats(t613+q_coslats.DSC.L1) = dcos(q_lats(t613+           
     .       1      q_lats.DSC.L1))                                             
     .        enddo                                                             
     .  !cdir nodep                                                             
     .        do t617 = 0, q_latn.DSC.U1 - q_latn.DSC.L1                        
     .           q_coslatn(t617+q_coslatn.DSC.L1) = dcos(q_latn(t617+           
     .       1      q_latn.DSC.L1))                                             
     .        enddo                                                             
     .        call messagenotifyc ('M', module_name,                            
     .       1   '----- Initialization Messages -----', 1, 1, 1, 1, 1, 1, 1, 1, 
     .       2   1, 1, 1, 13, 35, 0, 0, 0, 0)                                   
     .        %IG13(1) = soseaicediffcoef                                       
     .        call messagenotifyc ('M', module_name,                            
     .       1   '  SOSeaIceDiffCoef              = %f', 1, 1, %IG13, 1, 1, 1, 1
     .       2   , 1, 1, 1, 1, 13, 36, 0, 0, 0, 0)                              
     .        call f_null (%000776)                                             
     .        call fy_chtrim (%000776, %000775, version, 58)                    
     .        call messagenotifyc ('M', module_name, '-- version = %c', 1, 1, 1 
     .       1   , 1, 1, %000776, 1, 1, 1, 1, 1, 13, 15, %000775, 0, 0, 0)      
     .        deallocate (%000776)                                              
     .        sosi_dynamics_inited = 1                                          
     .  10041 continue                                                          
  2448  
  2449    !--------------------------------------------------------------------------------------
  2450  
  2451  end module sosi_dynamics
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:51 2016
FILE NAME: i.sosi_dynamics.F90
PROGRAM NAME: sosi_dynamics
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != Slab ocean sea ice horizontal transport
     4:             !
     5:             ! Authors::   Yoshiyuki O. TAKAHASHI
     6:             ! Version::
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2013. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module sosi_dynamics
    13:               !
    14:               != 
    15:               !
    16:               != Slab sea ice horizontal transport
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! Horizontal transport of slab sea ice (sea ice on slab ocean) is calculated
    21:               ! based on diffusion.
    22:               !
    23:               !== Procedures List
    24:               !
    25:             !!$  ! SLTTMain     :: 移流計算
    26:             !!$  ! SLTTInit     :: 初期化
    27:             !!$  ! SLTTTest     :: 移流テスト用
    28:             !!$  ! ---------------------     :: ------------
    29:             !!$  ! SLTTMain     :: Main subroutine for SLTT
    30:             !!$  ! SLTTInit     :: Initialization for SLTT
    31:             !!$  ! SLTTTest     :: Generate velocity for SLTT Test 
    32:               !
    33:               !== NAMELIST
    34:               !
    35:               ! NAMELIST#
    36:               !
    37:               !== References
    38:               !
    39:               !
    40:               ! モジュール引用 ; USE statements
    41:               !
    42:               ! 種別型パラメタ
    43:               ! Kind type parameter
    44:               !
    45:               use dc_types, only: DP,  & ! 倍精度実数型. Double precision.
    46:                 &                 TOKEN  ! キーワード.   Keywords. 
    47:             
    48:               ! メッセージ出力
    49:               ! Message output
    50:               !
    51:               use dc_message, only: MessageNotify
    52:             
    53:               !
    54:               ! MPI
    55:               !
    56:               use mpi_wrapper, only : MPIWrapperFindMaxVal
    57:             
    58:               ! 時刻管理
    59:               ! Time control
    60:               !
    61:               use timeset, only: &
    62:                 & DelTime
    63:             
    64:               ! 格子点設定
    65:               ! Grid points settings
    66:               !
    67:               use gridset, only:       &
    68:                 &                imax, & ! 経度格子点数.
    69:                                          ! Number of grid points in longitude
    70:                 &                jmax, & ! 緯度格子点数.
    71:                                          ! Number of grid points in latitude
    72:                 &                kmax, & ! 鉛直層数.
    73:                                          ! Number of vertical level
    74:                 &                ksimax  ! 海氷の鉛直層数.
    75:                                          ! Number of sea ice vertical level
    76:             
    77:               ! 組成に関わる配列の設定
    78:               ! Settings of array for atmospheric composition
    79:               !
    80:               use composition, only:                              &
    81:                 &                    ncmax
    82:                                          ! 成分の数
    83:                                          ! Number of composition
    84:             
    85:               ! 質量の補正
    86:               ! Mass fixer
    87:               !
    88:             !!$  use mass_fixer, only: &
    89:             !!$    & MassFixerBC02, MassFixerBC02Layer, MassFixerBC02Column, &
    90:             !!$    & MassFixer, MassFixerR95, MassFixerWO94, MassFixerColumn!, MassFixerLayer
    91:             
    92:             
    93:               ! 宣言文 ; Declaration statements
    94:               !
    95:               implicit none
    96:               private
    97:             
    98:               ! 公開手続き
    99:               ! Public procedure
   100:               !
   101:               public :: SOSIDynamics
   102:               public :: SOSIDynamicsInit
   103:             
   104:             
   105:               ! 公開変数
   106:               ! Public variables
   107:               !
   108:             
   109:               ! 非公開変数
   110:               ! Private variables
   111:               !
   112:               logical, save      :: FlagSlabOcean
   113:               ! flag for use of slab ocean
   114:             
   115:               real(DP)    , save              :: SOSeaIceDiffCoef
   116:             
   117:               real(DP)    , save, allocatable :: y_CosLat(:)
   118:                                           ! $\cos\varphai$
   119:             
   120:               real(DP)    , save, allocatable :: x_LonS   (:)
   121:                                           ! $\lambda_S$ 南半球の経度。
   122:                                           ! longitude in SH.
   123:               real(DP)    , save, allocatable :: x_SinLonS(:)
   124:                                           ! $\sin\lambda_S$
   125:               real(DP)    , save, allocatable :: x_CosLonS(:)
   126:                                           ! $\cos\lambda_S$
   127:               real(DP)    , save, allocatable :: y_LatS   (:)
   128:                                           ! $\varphi_S$ 南半球の緯度。
   129:                                           ! latitude in SH.
   130:               real(DP)    , save, allocatable :: y_SinLatS(:)
   131:                                           ! $\sin\varphai_S$
   132:               real(DP)    , save, allocatable :: y_CosLatS(:)
   133:                                           ! $\cos\varphai_S$
   134:               real(DP)    , save, allocatable :: x_ExtLonS(:)
   135:                                           ! $ x_LonSの拡張配列。
   136:                                           !Extended array of x_LonS.
   137:               real(DP)    , save, allocatable :: y_ExtLatS(:)
   138:                                           ! $ x_LatSの拡張配列。
   139:                                           !Extended array of x_LatS.
   140:               real(DP)    , save, allocatable :: y_ExtCosLatS(:)
   141:                                           ! $ y_CosLatS の拡張配列。
   142:                                           !Extended array of y_CosLatS.
   143:             
   144:               real(DP)    , save, allocatable :: x_LonN   (:)
   145:                                           ! $\lambda_N$ 北半球の経度。
   146:                                           ! longitude in NH.
   147:               real(DP)    , save, allocatable :: x_SinLonN(:)
   148:                                           ! $\sin\lambda_N$
   149:               real(DP)    , save, allocatable :: x_CosLonN(:)
   150:                                           ! $\cos\lambda_N$
   151:               real(DP)    , save, allocatable :: y_LatN   (:)
   152:                                           ! $\varphi_N$ 北半球の緯度。
   153:                                           ! latitude in NH.
   154:               real(DP)    , save, allocatable :: y_SinLatN(:)
   155:                                           ! $\sin\varphai_N$
   156:               real(DP)    , save, allocatable :: y_CosLatN(:)
   157:                                           ! $\cos\varphai_N$
   158:               real(DP)    , save, allocatable :: x_ExtLonN(:)
   159:                                           ! $ x_LonNの拡張配列。
   160:                                           !Extended array of x_LonN.
   161:               real(DP)    , save, allocatable :: y_ExtLatN(:)
   162:                                           ! $ x_LatNの拡張配列。
   163:                                           !Extended array of x_LatN.
   164:               real(DP)    , save, allocatable :: y_ExtCosLatN(:)
   165:                                           ! $ y_CosLatNの拡張配列。
   166:                                           !Extended array of y_CosLatN.
   167:             
   168:               real(DP)    , save, allocatable :: p_LonS   (:)
   169:               real(DP)    , save, allocatable :: q_LatS   (:)
   170:               real(DP)    , save, allocatable :: q_CosLatS(:)
   171:               real(DP)    , save, allocatable :: p_LonN   (:)
   172:               real(DP)    , save, allocatable :: q_LatN   (:)
   173:               real(DP)    , save, allocatable :: q_CosLatN(:)
   174:             
   175:             
   176:               logical, save :: sosi_dynamics_inited = .false.
   177:                                           ! 初期設定フラグ.
   178:                                           ! Initialization flag
   179:             
   180:             
   181:               character(*), parameter:: module_name = 'sosi_dynamics'
   182:                                           ! モジュールの名称.
   183:                                           ! Module name
   184:               character(*), parameter:: version = &
   185:                 & '$Name:  $' // &
   186:                 & '$Id: sltt.F90,v 1.8 2014/06/29 07:21:28 yot Exp $'
   187:                                           ! モジュールのバージョン
   188:                                           ! Module version
   189:             
   190:             
   191:               !--------------------------------------------------------------------------------------
   192:             
   193:             contains
   194:             
   195:               !--------------------------------------------------------------------------------------
   196:             
   197:               subroutine SOSIDynamics(                                &
   198:                 & xy_SurfType,                                        & !(in   )
   199:                 & xy_SurfTemp, xy_SOSeaIceMass, xyz_SOSeaIceTemp,     & !(inout)
   200:                 & xy_DSOSeaIceMassDtPhyTop, xy_DSOSeaIceMassDtPhyBot, & !(in   )
   201:                 & xyz_DSOSeaIceTempDtPhy                              & !(in   )
   202:                 & )
   203:                 ! 
   204:                 ! Calculates slab sea ice horizontal transports by diffusion
   205:             
   206:                 ! ヒストリデータ出力
   207:                 ! History data output
   208:                 !
   209:                 use gtool_historyauto, only: HistoryAutoPut
   210:             
   211:                 use timeset    , only : &
   212:                   & TimeN, &
   213:                   & DelTime
   214:                                           ! $\Delta t$
   215:             
   216:                 ! 物理・数学定数設定
   217:                 ! Physical and mathematical constants settings
   218:                 !
   219:                 use constants0, only: &
   220:                   & WaterHeatCap
   221:             
   222:                 ! 物理定数設定
   223:                 ! Physical constants settings
   224:                 !
   225:                 use constants, only: &
   226:                   & SOMass
   227:                                           ! Slab ocean mass
   228:             
   229:                 ! 雪と海氷の定数の設定
   230:                 ! Setting constants of snow and sea ice
   231:                 !
   232:                 use constants_snowseaice, only: &
   233:                   & TempCondWater,              &
   234:                   & SeaIceDen,                  &
   235:                   & SeaIceHeatCap,              &
   236:                   & TempBelowSeaIce,            &
   237:                   & SOSeaIceThresholdMass,      &
   238:                   & LatentHeatFusionBelowSeaIce
   239:             
   240:                 !
   241:                 ! Slab ocean sea ice utility module
   242:                 !
   243:                 use sosi_utils, only :             &
   244:                   & SOSIUtilsChkSOSeaIce,          &
   245:                   & SOSIUtilsSetSOSeaIceLevels,    &
   246:                   & SOSeaIceMassNegativeThreshold, &
   247:                   & SOSIUtilsAddPhysics
   248:             
   249:             
   250:                 ! 宣言文 ; Declaration statements
   251:                 !
   252:                 integer , intent(in ) :: xy_SurfType       (0:imax-1, 1:jmax)
   253:                                           ! 土地利用.
   254:                                           ! Surface index
   255:                 real(DP), intent(inout) :: xy_SurfTemp        (0:imax-1, 1:jmax)
   256:                 real(DP), intent(inout) :: xy_SOSeaIceMass    (0:imax-1, 1:jmax)
   257:                                           ! $ M_si $ . 海氷質量 (kg m-2)
   258:                                           ! Slab ocean sea ice mass (kg m-2)
   259:             !!!! Modified by M.Ishiwatari (2016-12-10)
   260:             !!!!    real(DP), intent(inout) :: xyz_SOSeaIceTemp   (0:imax-1, 1:jmax, 1:ksimax)
   261:                 real(DP), intent(inout) :: xyz_SOSeaIceTemp   (0:imax-1, 1:jmax, 0:ksimax)
   262:                 real(DP), intent(in   ) :: xy_DSOSeaIceMassDtPhyTop(0:imax-1, 1:jmax)
   263:                 real(DP), intent(in   ) :: xy_DSOSeaIceMassDtPhyBot(0:imax-1, 1:jmax)
   264:                                           !
   265:                                           ! Slab sea ice mass at next time step
   266:             !!!! Modified by M.Ishiwatari (2016-12-10)
   267:             !!!!    real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 1:ksimax)
   268:                 real(DP), intent(in   ) :: xyz_DSOSeaIceTempDtPhy(0:imax-1, 1:jmax, 0:ksimax)
   269:             
   270:             
   271:                 ! 作業変数
   272:                 ! Work variables
   273:                 !
   274:                 real(DP) :: xy_SurfTempSave     (0:imax-1, 1:jmax)
   275:                 real(DP) :: xy_SOSeaIceMassSave (0:imax-1, 1:jmax)
   276:                 real(DP) :: xyz_SOSeaIceTempSave(0:imax-1, 1:jmax, ksimax)
   277:             
   278:                 real(DP) :: xy_SOSeaIceThickness(0:imax-1, 1:jmax)
   279:             
   280:             !!!! Modified by M.Ishiwatari (2016-12-10)
   281:             !!!!    real(DP) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 1:ksimax)
   282:                 real(DP) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 0:ksimax)
   283:                              !
   284:                              ! Sea ice thickness
   285:                 integer  :: xy_SOSILocalKMax  (0:imax-1, 1:jmax)
   286:                 real(DP) :: xyr_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   287:             !!!! Modified by M.Ishiwatari (2016-12-10)
   288:             !!!!    real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 1:ksimax)
   289:                 real(DP) :: xyz_SOSILocalDepth(0:imax-1, 1:jmax, 0:ksimax)
   290:             
   291:                 real(DP) :: xy_SeaIceThicknessA(0:imax-1, 1:jmax)
   292:                              !
   293:                              ! Sea ice thickness
   294:                 integer  :: xy_SOSILocalKMaxA  (0:imax-1, 1:jmax)
   295:                 real(DP) :: xyr_SOSILocalDepthA(0:imax-1, 1:jmax, 0:ksimax)
   296:             !!!! Modified by M.Ishiwatari (2016-12-10)
   297:             !!!!    real(DP) :: xyz_SOSILocalDepthA(0:imax-1, 1:jmax, 1:ksimax)
   298:                 real(DP) :: xyz_SOSILocalDepthA(0:imax-1, 1:jmax, 0:ksimax)
   299:             
   300:                 logical  :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
   301:             
   302:             !!!! Modified by M.Ishiwatari (2016-12-10)
   303:             !!!!    real(DP) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 1:ksimax)
   304:             !!!!    real(DP) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 1:ksimax)
   305:                 real(DP) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 0:ksimax)
   306:                 real(DP) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 0:ksimax)
   307:                 real(DP) :: xy_DSOTempDt            (0:imax-1, 1:jmax)
   308:             
   309:             !!$    real(DP) :: xy_DSOSeaIceMassDt(0:imax-1, 1:jmax)
   310:             !!$                              !
   311:             !!$                              ! Slab sea ice mass tendency
   312:             
   313:                 real(DP) :: xy_SOTemp               (0:imax-1, 1:jmax)
   314:             
   315:             !!!! Modified by M.Ishiwatari (2016-12-10)
   316:             !!!!    real(DP) :: xyz_SOSeaIceThicknessAdv(0:imax-1, 1:jmax, 1:ksimax)
   317:             !!!!    real(DP) :: xyz_SOSeaIceTempAdv     (0:imax-1, 1:jmax, 1:ksimax)
   318:                 real(DP) :: xyz_SOSeaIceThicknessAdv(0:imax-1, 1:jmax, 0:ksimax)
   319:                 real(DP) :: xyz_SOSeaIceTempAdv     (0:imax-1, 1:jmax, 0:ksimax)
   320:                 real(DP) :: xy_SOTempAdv            (0:imax-1, 1:jmax)
   321:             
   322:             !!$    real(DP) :: xy_TempSlabOcean (0:imax-1, 1:jmax)
   323:             !!$                              !
   324:             !!$                              ! Slab ocean temperature
   325:             !!$    real(DP) :: xy_TempSlabSeaIce(0:imax-1, 1:jmax)
   326:             !!$                              !
   327:             !!$                              ! Slab sea ice temperature
   328:             
   329:             !!!! Modified by M.Ishiwatari (2016-12-10)
   330:             !!!!    real(DP) :: xyz_SOSIMassEachLayer(0:imax-1, 1:jmax, 1:ksimax)
   331:                 real(DP) :: xyz_SOSIMassEachLayer(0:imax-1, 1:jmax, 0:ksimax)
   332:             
   333:                 real(DP) :: SOSIMass
   334:                 real(DP) :: SOSIMass1L
   335:                 real(DP) :: DelSOSIMass
   336:             
   337:             !!$    real(DP) :: SurfTempTent
   338:                 real(DP) :: SOTempTent
   339:                 real(DP) :: SOTempTent1st
   340:             
   341:                 logical, parameter :: FlagSOSIAdv = .false.
   342:             
   343:                 logical  :: FlagCalc
   344:             
   345:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   346:                                           ! Work variables for DO loop in zonal direction
   347:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   348:                                           ! Work variables for DO loop in meridional direction
   349:                 integer:: k
   350:                 integer:: kk
   351:             
   352:             
   353:                 if ( .not. sosi_dynamics_inited ) then
   354:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   355:                 end if
   356:             
   357:             
   358:                 ! add physics tendency
   359:                 call SOSIUtilsAddPhysics(                         &
   360:                   & xy_SOSeaIceMass, xyz_SOSeaIceTemp,            & !(inout)
   361:                   & xy_DSOSeaIceMassDtPhyTop, xy_DSOSeaIceMassDtPhyBot, & !(in   )
   362:                   & xyz_DSOSeaIceTempDtPhy                           & !(in   )
   363:                   & )
   364:             
   365:             
   366:             !!$    xy_SOSeaIceMassA = xy_SOSeaIceMassB &
   367:             !!$      & + xy_DSOSeaIceMassDtPhy * ( 2.0_DP * DelTime )
   368:             !!$
   369:             !!$
   370:             !!$    !
   371:             !!$    ! Calcuate sea ice thickness
   372:             !!$    !
   373:             !!$    xy_SeaIceThickness = xy_SOSeaIceMassB / SeaIceDen
   374:             !!$    !
   375:             !!$    ! Set slab ocean sea ice levels
   376:             !!$    !
   377:             !!$    call SOSIUtilsSetSOSeaIceLevels(                     &
   378:             !!$      & xy_SeaIceThickness,                                       & ! (in   )
   379:             !!$      & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   380:             !!$      & )
   381:             !!$
   382:             !!$    !
   383:             !!$    ! Calcuate sea ice thickness
   384:             !!$    !
   385:             !!$    xy_SeaIceThicknessA = xy_SOSeaIceMassA / SeaIceDen
   386:             !!$    !
   387:             !!$    ! Set slab ocean sea ice levels
   388:             !!$    !
   389:             !!$    call SOSIUtilsSetSOSeaIceLevels(                     &
   390:             !!$      & xy_SeaIceThicknessA,                                       & ! (in   )
   391:             !!$      & xy_SOSILocalKMaxA, xyr_SOSILocalDepthA, xyz_SOSILocalDepthA  & ! (out)
   392:             !!$      & )
   393:             !!$
   394:             !!$
   395:             !!$    ! 海氷温度時間積分
   396:             !!$    ! Time integration of sea ice temperature
   397:             !!$    !
   398:             !!$    xyz_SOSeaIceTemp = xyz_SOSeaIceTemp + xyz_DSOSeaIceTempDtPhy * DelTime
   399:             !!$
   400:             !!$
   401:             !!$    ! Adjust levels
   402:             !!$    !
   403:             !!$    do j = 1, jmax
   404:             !!$      do i = 0, imax-1
   405:             !!$        if ( xy_SOSILocalKMaxA(i,j) > xy_SOSILocalKMax(i,j) ) then
   406:             !!$          ! sea ice thickness increases
   407:             !!$          do k = 1, xy_SOSILocalKMax(i,j)
   408:             !!$            xyz_SOSeaIceTemp(i,j,k) = xyz_SOSeaIceTemp(i,j,k) &
   409:             !!$              & + xyz_DSOSeaIceTempDtPhy(i,j,k) * DelTime
   410:             !!$          end do
   411:             !!$          do k = xy_SOSILocalKMax(i,j)+1, xy_SOSILocalKMaxA(i,j)
   412:             !!$            kk = xy_SOSILocalKMax(i,j)
   413:             !!$            xyz_SOSeaIceTemp(i,j,k) = xyz_SOSeaIceTemp(i,j,kk)
   414:             !!$          end do
   415:             !!$        else if ( xy_SOSILocalKMaxA(i,j) < xy_SOSILocalKMax(i,j) ) then
   416:             !!$          ! sea ice thickness decreases
   417:             !!$          !   Do nothing
   418:             !!$          !   Melted sea ice had freezing temperature
   419:             !!$        end if
   420:             !!$      end do
   421:             !!$    end do
   422:             
   423:             
   424:             
   425: W*===== A       xy_FlagSlabOcean = .false.
   426:                 FlagCalc         = .false.
   427:                 if ( FlagSlabOcean ) then
   428: W------>          do j = 1, jmax
   429: |*----->            do i = 0, imax-1
   430: ||      A             if ( xy_SurfType(i,j) <= 0 ) then
   431: ||                      ! slab ocean
   432: ||      A               xy_FlagSlabOcean(i,j) = .true.
   433: ||                      FlagCalc              = .true.
   434: ||                    end if
   435: |*-----             end do
   436: W------           end do
   437:                 end if
   438:             
   439:                 if ( SOSeaIceDiffCoef <= 0.0_DP ) then
   440:                   FlagCalc = .false.
   441:             !!$    else
   442:             !!$      call MessageNotify( 'E', module_name, &
   443:             !!$        & '  Now, SOSeaIceDiffCoef has to be zero.' )
   444:                 end if
   445:             
   446:                 if ( .not. FlagCalc ) then
   447:                   return
   448:                 end if
   449:             
   450:             
   451:             
   452:                 ! Save values
   453:                 !
   454: *W----->        xy_SurfTempSave      = xy_SurfTemp
   455: *W----- A       xy_SOSeaIceMassSave  = xy_SOSeaIceMass
   456: ++V==== A       xyz_SOSeaIceTempSave = xyz_SOSeaIceTemp
   457:             
   458:             
   459:                 !
   460:                 ! Calcuate sea ice thickness
   461:                 !
   462: W*===== A       xy_SOSeaIceThickness = xy_SOSeaIceMass / SeaIceDen
   463:                 !
   464:                 ! Set slab ocean sea ice levels
   465:                 !
   466:                 call SOSIUtilsSetSOSeaIceLevels(                     &
   467:                   & xy_SOSeaIceThickness,                                     & ! (in   )
   468:                   & xy_SOSILocalKMax, xyr_SOSILocalDepth, xyz_SOSILocalDepth  & ! (out)
   469:                   & )
   470:             
   471:                 ! Slab ocean temperature
   472:                 !
   473: W------>        do j = 1, jmax
   474: |*----->          do i = 0, imax-1
   475: ||          !!$        if ( xy_SOSILocalKMax(i,j) <= 0 ) then
   476: ||      A           if ( xy_SOSeaIceMass(i,j) < SOSeaIceThresholdMass ) then
   477: ||      A             xy_SOTemp(i,j) = xy_SurfTemp(i,j)
   478: ||                  else
   479: ||                    xy_SOTemp(i,j) = TempBelowSeaIce
   480: ||                  end if
   481: |*-----           end do
   482: W------         end do
   483:             
   484: +------>        do j = 1, jmax
   485: |+----->          do i = 0, imax-1
   486: ||V---->            do k = 1, xy_SOSILocalKMax(i,j)
   487: |||     A             xyz_SOSeaIceThicknessAdv(i,j,k) = &
   488: |||                     & xyr_SOSILocalDepth(i,j,k-1) - xyr_SOSILocalDepth(i,j,k)
   489: |||     A             xyz_SOSeaIceTempAdv     (i,j,k) = xyz_SOSeaIceTemp(i,j,k)
   490: ||V----             end do
   491: ||V---->            do k = xy_SOSILocalKMax(i,j)+1, ksimax
   492: |||     A             xyz_SOSeaIceThicknessAdv(i,j,k) = 0.0_DP
   493: |||     A             xyz_SOSeaIceTempAdv     (i,j,k) = TempCondWater
   494: |||         !!$          xyz_SOSeaIceTempAdv     (i,j,k) = TempBelowSeaIce
   495: ||V----             end do
   496: |+-----           end do
   497: +------         end do
   498:                 !
   499: W*===== A       xy_SOTempAdv = xy_SOTemp
   500:             
   501:             
   502:             !!$    call SOSIUtilsSetMissingValue( &
   503:             !!$      & xy_SOSeaIceMass,                 & !(in )
   504:             !!$      & xyz_SOSeaIceTemp,                & !(inout)
   505:             !!$      & SOSeaIceValue                    & !(in ) optional
   506:             !!$      & )
   507:             
   508:                 call SOSIHorTransportDiff(                          &
   509:                   & xy_FlagSlabOcean,                               & ! (in)
   510:                   & xy_SOSeaIceMass,                                & ! (in)
   511:                   & xy_SOTempAdv,                                   & ! (in)
   512:                   & xyz_SOSeaIceThicknessAdv, xyz_SOSeaIceTempAdv,  & ! (in)
   513:                   & xy_DSOTempDt,                                   & ! (out)
   514:                   & xyz_DSOSeaIceThicknessDt, xyz_DSOSeaIceTempDt   & ! (out)
   515:                   & )
   516:             
   517:             
   518: **W---->A       xyz_SOSeaIceThickness = xyz_SOSeaIceThicknessAdv
   519: **W---- A       xyz_SOSeaIceTemp      = xyz_SOSeaIceTempAdv
   520: W*===== A       xy_SOTemp             = xy_SOTempAdv
   521:                 !
   522:                 if ( FlagSOSIAdv ) then
   523: ***---->          xyz_SOSeaIceThickness = xyz_SOSeaIceThickness &
   524: |||                 & + xyz_DSOSeaIceThicknessDt * DelTime
   525: ***----           xyz_SOSeaIceTemp      = xyz_SOSeaIceTemp      &
   526:                     & + xyz_DSOSeaIceTempDt      * DelTime
   527:                 else
   528: W*===== A         xy_SOTemp = xy_SOTemp &
   529:                     & + xy_DSOTempDt * DelTime
   530:                 end if
   531:             
   532:             
   533:             
   534:                 ! Adjustment
   535:                 !
   536:             !!$    do j = 1, jmax
   537:             !!$      do i = 0, imax-1
   538:             !!$        if ( xy_FlagSlabOcean(i,j) ) then
   539:             !!$          do k = xy_SOSILocalKMax(i,j), 1, -1
   540:             !!$            if ( xyz_SOSeaIceThickness(i,j,k) > 0.0_DP ) then
   541:             !!$              if ( xy_SurfTemp(i,j) > TempCondWater ) then
   542:             !!$                ! Check whether all sea ice melt
   543:             !!$                SOSIMass = SeaIceDen * xyz_SOSeaIceThickness(i,j,k)
   544:             !!$                SurfTempTent = &
   545:             !!$                  &   (   WaterHeatCap * ( SOMass - SOSIMass ) * xy_SurfTemp(i,j) &
   546:             !!$                  &     + SeaIceHeatCap * SOSIMass * xyz_SOSeaIceTemp(i,j,k)      &
   547:             !!$                  &     - LatentHeatFusion * SOSIMass )                           &
   548:             !!$                  & / ( WaterHeatCap * SOMass )
   549:             !!$
   550:             !!$                if ( SurfTempTent >= TempCondWater ) then
   551:             !!$                  ! Case in which all sea ice melt
   552:             !!$                  xy_SurfTemp          (i,j)   = SurfTempTent
   553:             !!$                  xyz_SOSeaIceThickness(i,j,k) = 0.0_DP
   554:             !!$                  xyz_SOSeaIceTemp     (i,j,k) = TempCondWater
   555:             !!$                else
   556:             !!$                  ! Case in which a part of sea ice melt
   557:             !!$                  DelSOSIMass =                                  &
   558:             !!$                    & - WaterHeatCap * ( SOMass - SOSIMass )     &
   559:             !!$                    &   * ( xy_SurfTemp(i,j) - TempBelowSeaIce ) &
   560:             !!$                    &   / (                                                   &
   561:             !!$                    &         LatentHeatFusion                                &
   562:             !!$                    &       + SeaIceHeatCap                                   &
   563:             !!$                    &         * ( TempBelowSeaIce - xyz_SOSeaIceTemp(i,j,k) ) &
   564:             !!$                    &      )
   565:             !!$
   566:             !!$                  xy_SurfTemp(i,j) = TempCondWater
   567:             !!$                  xyz_SOSeaIceThickness(i,j,k) =     &
   568:             !!$                    &   xyz_SOSeaIceThickness(i,j,k) &
   569:             !!$                    & + DelSOSIMass / SeaIceDen
   570:             !!$                end if
   571:             !!$              end if
   572:             !!$            end if
   573:             !!$          end do
   574:             !!$        end if
   575:             !!$      end do
   576:             !!$    end do
   577:             !!$    !
   578:             !!$    xy_SOSeaIceMass = 0.0_DP
   579:             !!$    do j = 1, jmax
   580:             !!$      do i = 0, imax-1
   581:             !!$        do k = 1, xy_SOSILocalKMax(i,j)
   582:             !!$          xy_SOSeaIceMass(i,j) = xy_SOSeaIceMass(i,j) &
   583:             !!$            & + SeaIceDen * xyz_SOSeaIceThickness(i,j,k)
   584:             !!$        end do
   585:             !!$      end do
   586:             !!$    end do
   587:             
   588: +------>        do j = 1, jmax
   589: |+----->          do i = 0, imax-1
   590: ||V---->            do k = 1, xy_SOSILocalKMax(i,j)
   591: |||     A             xyz_SOSIMassEachLayer(i,j,k) = SeaIceDen * xyz_SOSeaIceThickness(i,j,k)
   592: ||V----             end do
   593: ||V---->            do k = xy_SOSILocalKMax(i,j)+1, ksimax
   594: |||     A             xyz_SOSIMassEachLayer(i,j,k) = 0.0_DP
   595: ||V----             end do
   596: |+-----           end do
   597: +------         end do
   598:             
   599: W*===== A       xy_SOSeaIceMass = 0.0_DP
   600: +------>        do j = 1, jmax
   601: |+----->          do i = 0, imax-1
   602: ||V---->            do k = 1, xy_SOSILocalKMax(i,j)
   603: |||     A             xy_SOSeaIceMass(i,j) = xy_SOSeaIceMass(i,j) &
   604: |||                     & + xyz_SOSIMassEachLayer(i,j,k)
   605: ||V----             end do
   606: |+-----           end do
   607: +------         end do
   608:             
   609: +------>        do j = 1, jmax
   610: |+----->          do i = 0, imax-1
   611: ||                  if ( xy_FlagSlabOcean(i,j) ) then
   612: ||+---->              do k = xy_SOSILocalKMax(i,j), 1, -1
   613: |||                     if ( xy_SOTemp(i,j) > TempBelowSeaIce ) then
   614: |||                       ! Check whether all sea ice melt
   615: |||                       SOSIMass    = xy_SOSeaIceMass(i,j)
   616: |||                       SOSIMass1L  = xyz_SOSIMassEachLayer(i,j,k)
   617: |||                       DelSOSIMass = - SOSIMass1L
   618: |||         
   619: |||         !!$              SOTempTent =                                                    &
   620: |||         !!$                &   (   WaterHeatCap * ( SOMass - SOSIMass ) * xy_SOTemp(i,j) &
   621: |||         !!$                &     + SeaIceHeatCap * SOSIMass1L * xyz_SOSeaIceTemp(i,j,k)  &
   622: |||         !!$                &     + LatentHeatFusion * DelSOSIMass )                      &
   623: |||         !!$                & / ( WaterHeatCap * ( ( SOMass - SOSIMass ) - DelSOSIMass ) )
   624: |||         
   625: |||                       SOTempTent1st = TempBelowSeaIce
   626: |||                       SOTempTent =                                                    &
   627: |||                         &   (   WaterHeatCap * ( SOMass - SOSIMass ) * xy_SOTemp(i,j) &
   628: |||                         &     - WaterHeatCap * DelSOSIMass * SOTempTent1st            &
   629: |||                         &     + SeaIceHeatCap * DelSOSIMass                           &
   630: |||                         &         * ( SOTempTent1st - xyz_SOSeaIceTemp(i,j,k) )       &
   631: |||                         &     + LatentHeatFusionBelowSeaice * DelSOSIMass )           &
   632: |||                         & / ( WaterHeatCap * ( ( SOMass - SOSIMass ) - DelSOSIMass ) )
   633: |||         
   634: |||                       if ( SOTempTent >= TempBelowSeaIce ) then
   635: |||                         ! Case in which all sea ice melt
   636: |||                         xy_SOTemp            (i,j)   = SOTempTent
   637: |||                         xyz_SOSeaIceTemp     (i,j,k) = TempBelowSeaIce
   638: |||                       else
   639: |||                         ! Case in which a part of sea ice melt
   640: |||                         SOTempTent = TempBelowSeaIce
   641: |||         
   642: |||         !!$                DelSOSIMass =                                  &
   643: |||         !!$                  &   ( &
   644: |||         !!$                  &     - WaterHeatCap * ( SOMass - SOSIMass )     &
   645: |||         !!$                  &         * ( SOTempTent - xy_SOTemp(i,j) )      &
   646: |||         !!$                  &     - SeaIceHeatCap * SOSIMass1L               &
   647: |||         !!$                  &         * ( xyz_SOSeaIceTemp(i,j,k) - xyz_SOSeaIceTemp(i,j,k) )  &
   648: |||         !!$                  &   ) &
   649: |||         !!$                  & / (                                                 &
   650: |||         !!$                  &     - WaterHeatCap * SOTempTent                     &
   651: |||         !!$                  &     + SeaIceHeatCap * xyz_SOSeaIceTemp(i,j,k)       &
   652: |||         !!$                  &     - LatentHeatFusion                              &
   653: |||         !!$                  &   )
   654: |||         
   655: |||                         SOTempTent1st = TempBelowSeaIce
   656: |||                         DelSOSIMass =                                  &
   657: |||                           &   ( &
   658: |||                           &       WaterHeatCap * ( SOMass - SOSIMass ) &
   659: |||                           &         * ( SOTempTent - xy_SOTemp(i,j) )  &
   660: |||                           &   ) &
   661: |||                           & / (                                                               &
   662: |||                           &       WaterHeatCap * ( SOTempTent - SOTempTent1st )               &
   663: |||                           &     + SeaIceHeatCap * ( SOTempTent1st - xyz_SOSeaIceTemp(i,j,k) ) &
   664: |||                           &     + LatentHeatFusionBelowSeaIce                                 &
   665: |||                           &   )
   666: |||         
   667: |||                         xy_SOTemp(i,j) = SOTempTent
   668: |||                       end if
   669: |||                       xyz_SOSIMassEachLayer(i,j,k) = &
   670: |||                         &   xyz_SOSIMassEachLayer(i,j,k) + DelSOSIMass
   671: |||                       xy_SOSeaIceMass(i,j) = xy_SOSeaIceMass(i,j) + DelSOSIMass
   672: |||                     end if
   673: ||+----               end do
   674: ||                  end if
   675: |+-----           end do
   676: +------         end do
   677:             
   678: W------>        do j = 1, jmax
   679: |*----->          do i = 0, imax-1
   680: ||                  if ( xy_SOSeaIceMass(i,j) > SOSeaIceThresholdMass ) then
   681: ||                    ! in case with sea ice remained
   682: ||      A             xy_SurfTemp(i,j) = xy_SurfTemp(i,j)
   683: ||                  else if ( xy_SOSeaIceMassSave(i,j) > SOSeaIceThresholdMass ) then
   684: ||                    ! in case with sea ice was present but melts completely
   685: ||      A             xy_SurfTemp(i,j) = xy_SOTemp(i,j)
   686: ||                  else
   687: ||                    ! in case with sea ice was/is not present
   688: ||          !!$          xy_SurfTemp(i,j) = xy_SurfTemp(i,j)
   689: ||      A             xy_SurfTemp(i,j) = xy_SOTemp(i,j)
   690: ||                  end if
   691: |*-----           end do
   692: W------         end do
   693:             
   694:             
   695: +------>        do j = 1, jmax
   696: |+----->          do i = 0, imax-1
   697: ||                  if ( xy_FlagSlabOcean(i,j) ) then
   698: ||                    if ( xy_SOSeaIceMass(i,j) < 0 ) then
   699: ||                      if ( xy_SOSeaIceMass(i,j) < SOSeaIceMassNegativeThreshold ) then
   700: ||                        call MessageNotify( 'M', module_name, &
   701: ||                          & '  Slab sea ice mass is negative after diffusion, %f, and this is set to zero.', &
   702: ||                          & d = (/ xy_SOSeaIceMass(i,j) /) )
   703: ||                      end if
   704: ||                      xy_SOSeaIceMass(i,j) = 0.0_DP
   705: ||                    end if
   706: ||                  end if
   707: |+-----           end do
   708: +------         end do
   709:             
   710:             
   711:                 ! Check
   712:                 !
   713: W*===== A       xy_SOSeaIceThickness = xy_SOSeaIceMass / SeaIceDen
   714:                 !
   715:                 call SOSIUtilsChkSOSeaIce(                &
   716:                   & xy_SOSeaIceThickness, xyz_SOSeaIceTemp, & ! (in)
   717:                   & "SOSIDynamics"                        & ! (in)
   718:                   & )
   719:             
   720:             
   721:               end subroutine SOSIDynamics
   722:             
   723:               !----------------------------------------------------------------------------
   724:             
   725:               subroutine SOSIHorTransportFFSL(                    &
   726:                 & xy_FlagSlabOcean,                               & ! (in)
   727:                 & xy_SOSeaIceMass,                                & ! (in)
   728:                 & xy_SurfTemp,                                    & ! (in)
   729:                 & xyz_SOSeaIceThickness, xyz_SOSeaIceTemp,        & ! (in)
   730:                 & xy_DSurfTempDt,                                 & ! (out)
   731:                 & xyz_DSOSeaIceThicknessDt, xyz_DSOSeaIceTempDt   & ! (out)
   732:                 & )
   733:                 ! 
   734:                 ! Calculates slab sea ice transport by diffusion
   735:             
   736:                 use timeset    , only : DelTime
   737:                                           ! $\Delta t$
   738:                 use axesset    , only : x_Lon, y_Lat
   739:                                           ! $\lambda, \varphai$ lon and lat
   740:                 use sltt_const , only : dtjw, iexmin, iexmax, jexmin, jexmax
   741:                 use sosi_dynamics_extarr, only : SLTTExtArrExt2
   742:                                           ! 配列拡張ルーチン
   743:                                           ! Expansion of arrays
   744:                 ! 雪と海氷の定数の設定
   745:                 ! Setting constants of snow and sea ice
   746:                 !
   747:                 use constants_snowseaice, only: &
   748:                   & SeaIceDen
   749:             
   750:             
   751:                 logical , intent(in ) :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
   752:                 real(DP), intent(in ) :: xy_SOSeaIceMass      (0:imax-1, 1:jmax)
   753:                 real(DP), intent(in ) :: xy_SurfTemp          (0:imax-1, 1:jmax)
   754:             !!!! Modified by M.Ishiwatari (2016-12-10)
   755:             !!!!    real(DP), intent(in ) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 1:ksimax)
   756:             !!!!    real(DP), intent(in ) :: xyz_SOSeaIceTemp     (0:imax-1, 1:jmax, 1:ksimax)
   757:                 real(DP), intent(in ) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 0:ksimax)
   758:                 real(DP), intent(in ) :: xyz_SOSeaIceTemp     (0:imax-1, 1:jmax, 0:ksimax)
   759:                 real(DP), intent(out) :: xy_DSurfTempDt          (0:imax-1, 1:jmax)
   760:             !!!! Modified by M.Ishiwatari (2016-12-10)
   761:             !!!!    real(DP), intent(out) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 1:ksimax)
   762:             !!!!    real(DP), intent(out) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 1:ksimax)
   763:                 real(DP), intent(out) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 0:ksimax)
   764:                 real(DP), intent(out) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 0:ksimax)
   765:             
   766:             
   767:                 !
   768:                 ! local variables
   769:                 !
   770:                 real(DP) :: xy_SurfTempA          (0:imax-1, 1:jmax)
   771:             !!!! Modified by M.Ishiwatari (2016-12-10)
   772:             !!!!    real(DP) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 1:ksimax)
   773:             !!!!    real(DP) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 1:ksimax)
   774:                 real(DP) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 0:ksimax)
   775:                 real(DP) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 0:ksimax)
   776:             
   777:                 real(DP) :: xy_SOSeaIceMassA      (0:imax-1, 1:jmax)
   778:             
   779:                 real(DP) :: xyza_TMP4DArray(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   780:             
   781:                 real(DP) :: xyza_ExtTMP4DArrayS(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   782:                                           ! 
   783:                                           ! Extended 4D array (SH)
   784:                 real(DP) :: xyza_ExtTMP4DArrayN(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
   785:                                           ! 
   786:                                           ! Extended 4D array (NH)
   787:             
   788:             !!!! Modified by M.Ishiwatari (2016-12-10)
   789:             !!!!    real(DP) :: xyz_ExtSOSeaIceThicknessS(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   790:             !!!!    real(DP) :: xyz_ExtSOSeaIceTempS     (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   791:             !!!!    real(DP) :: xyz_ExtSurfTempS         (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   792:                 real(DP) :: xyz_ExtSOSeaIceThicknessS(iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   793:                 real(DP) :: xyz_ExtSOSeaIceTempS     (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   794:                 real(DP) :: xyz_ExtSurfTempS         (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   795:                 real(DP) :: xy_ExtSOSeaIceMassS      (iexmin:iexmax, jexmin:jexmax)
   796:                                           ! 
   797:                                           ! Extended 4D array (SH)
   798:             !!!! Modified by M.Ishiwatari (2016-12-10)
   799:             !!!!    real(DP) :: xyz_ExtSOSeaIceThicknessN(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   800:             !!!!    real(DP) :: xyz_ExtSOSeaIceTempN     (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   801:             !!!!    real(DP) :: xyz_ExtSurfTempN         (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
   802:                 real(DP) :: xyz_ExtSOSeaIceThicknessN(iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   803:                 real(DP) :: xyz_ExtSOSeaIceTempN     (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   804:                 real(DP) :: xyz_ExtSurfTempN         (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
   805:                 real(DP) :: xy_ExtSOSeaIceMassN      (iexmin:iexmax, jexmin:jexmax)
   806:                                           ! 
   807:                                           ! Extended 4D array (NH)
   808:             
   809:                 logical  :: xy_ExtFlagSlabOceanS(iexmin:iexmax, jexmin:jexmax)
   810:                                           ! 
   811:                                           ! Extended 4D array (SH)
   812:                 logical  :: xy_ExtFlagSlabOceanN(iexmin:iexmax, jexmin:jexmax)
   813:                                           ! 
   814:                                           ! Extended 4D array (NH)
   815:             
   816:             !!!! Modified by M.Ishiwatari (2016-12-10)
   817:             !!!!    real(DP) :: xyz_DSOSeaIceThicknessDtS(0:imax-1, 1:jmax/2, 1:ksimax)
   818:             !!!!    real(DP) :: xyz_DSOSeaIceTempDtS     (0:imax-1, 1:jmax/2, 1:ksimax)
   819:             !!!!    real(DP) :: xya_DSurfTempDtS         (0:imax-1, 1:jmax/2, 1:ksimax)
   820:             !!!!    real(DP) :: xyz_DSOSeaIceThicknessDtN(0:imax-1, 1:jmax/2, 1:ksimax)
   821:             !!!!    real(DP) :: xyz_DSOSeaIceTempDtN     (0:imax-1, 1:jmax/2, 1:ksimax)
   822:             !!!!    real(DP) :: xya_DSurfTempDtN         (0:imax-1, 1:jmax/2, 1:ksimax)
   823:                 real(DP) :: xyz_DSOSeaIceThicknessDtS(0:imax-1, 1:jmax/2, 0:ksimax)
   824:                 real(DP) :: xyz_DSOSeaIceTempDtS     (0:imax-1, 1:jmax/2, 0:ksimax)
   825:                 real(DP) :: xya_DSurfTempDtS         (0:imax-1, 1:jmax/2, 0:ksimax)
   826:                 real(DP) :: xyz_DSOSeaIceThicknessDtN(0:imax-1, 1:jmax/2, 0:ksimax)
   827:                 real(DP) :: xyz_DSOSeaIceTempDtN     (0:imax-1, 1:jmax/2, 0:ksimax)
   828:                 real(DP) :: xya_DSurfTempDtN         (0:imax-1, 1:jmax/2, 0:ksimax)
   829:             
   830:             
   831:                 real(DP) :: PM
   832:                 ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。
   833:                 ! そうでない場合は1.0を与える。
   834:                 ! Sign change flag for array extension; -1.0 for sign change
   835:                 ! over the pole, 1.0 for no sign change
   836:             
   837:             
   838:             
   839:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
   840:                                           ! Work variables for DO loop in zonal direction
   841:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
   842:                                           ! Work variables for DO loop in meridional direction
   843:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   844:                                           ! Work variables for DO loop in vertical direction
   845:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   846:                                           ! Work variables for DO loop in dimension of constituents
   847:                 integer:: kk
   848:             
   849:             
   850:                 ! 実行文 ; Executable statement
   851:                 !
   852:             
   853:                 ! 初期化確認
   854:                 ! Initialization check
   855:                 !
   856:                 if ( .not. sosi_dynamics_inited ) then
   857:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   858:                 end if
   859:             
   860:             
   861:                 !
   862:                 ! Longitudinal diffusion
   863:                 !
   864:             
   865:             
   866:                 call SOSIDiffusionX(                               &
   867:                   & x_Lon(1)-x_Lon(0), y_CosLat, xy_FlagSlabOcean, & ! (in)
   868:                   & xy_SOSeaIceMass,                                             & ! (in)
   869:                   & xy_SurfTemp , xyz_SOSeaIceThickness , xyz_SOSeaIceTemp,      & ! (in)
   870:                   & xy_SurfTempA, xyz_SOSeaIceThicknessA, xyz_SOSeaIceTempA      & ! (out)
   871:                   & )
   872:             
   873:             
   874: W*=====         xy_SOSeaIceMassA = 0.0_DP
   875: +------>        do k = 1, ksimax
   876: |W*==== A         xy_SOSeaIceMassA = xy_SOSeaIceMassA &
   877: |                   & + SeaIceDen * xyz_SOSeaIceThicknessA(:,:,k)
   878: +------         end do
   879:             
   880:             
   881:                 !
   882:                 ! Latitudinal diffusion
   883:                 !
   884:             
   885:                 ! 配列の分割と拡張
   886:                 ! Division and extension of arrays
   887:                 !
   888:             
   889:                 if ( ksimax > kmax ) then
   890:                   call MessageNotify( 'E', module_name, 'ksimax > kmax.' )
   891:                 end if
   892:                 if ( kmax < 3 ) then
   893:                   call MessageNotify( 'E', module_name, 'kmax < 3.' )
   894:                 end if
   895:                 if ( ncmax < 3 ) then
   896:                   call MessageNotify( 'E', module_name, 'ncmax < 3.' )
   897:                 end if
   898:             
   899:             
   900:                 n = 1
   901: W------>        do k = 1, ksimax
   902: |**==== A         xyza_TMP4DArray(:,:,k,n) = xyz_SOSeaIceThicknessA(:,:,k)
   903: W------         end do
   904: W------>        do k = ksimax+1, kmax
   905: |**==== A         xyza_TMP4DArray(:,:,k,n) = 0.0_DP
   906: W------         end do
   907:                 !
   908:                 n = 2
   909: W------>        do k = 1, ksimax
   910: |**==== A         xyza_TMP4DArray(:,:,k,n) = xyz_SOSeaIceTempA(:,:,k)
   911: W------         end do
   912: W------>        do k = ksimax+1, kmax
   913: |**==== A         xyza_TMP4DArray(:,:,k,n) = 0.0_DP
   914: W------         end do
   915:                 !
   916:                 n = 3
   917:                 k = 1
   918: W------>        do j = 1, jmax
   919: |*----->          do i = 0, imax-1
   920: ||      A           if ( xy_FlagSlabOcean(i,j) ) then
   921: ||                    xyza_TMP4DArray(i,j,k,n) = 1.0_DP
   922: ||                  else
   923: ||                    xyza_TMP4DArray(i,j,k,n) = 0.0_DP
   924: ||                  end if
   925: |*----- A         end do
   926: W------         end do
   927:                 k = 2
   928: W*===== A       xyza_TMP4DArray(:,:,k,n) = xy_SurfTempA
   929:                 k = 3
   930: W*===== A       xyza_TMP4DArray(:,:,k,n) = xy_SOSeaIceMassA
   931: W------>        do k = 3+1, kmax
   932: |**==== A         xyza_TMP4DArray(:,:,k,n) = 0.0_DP
   933: W------         end do
   934:                 !
   935: W------>        do n = 3+1, ncmax
   936: |***=== A         xyza_TMP4DArray(:,:,:,n) = 0.0_DP
   937: W------         end do
   938:             
   939:                 PM = 1.0_DP
   940:                 call SLTTExtArrExt2(                            &
   941:                   & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
   942:                   & xyza_TMP4DArray, PM,                        & ! (in)
   943:                   & xyza_ExtTMP4DArrayS, xyza_ExtTMP4DArrayN    & ! (out)
   944:                   & )
   945:             
   946:                 n = 1
   947: W------>        do k = 1, ksimax
   948: |**---->A         xyz_ExtSOSeaIceThicknessS(:,:,k) = xyza_ExtTMP4DArrayS(:,:,k,n)
   949: |**---- A         xyz_ExtSOSeaIceThicknessN(:,:,k) = xyza_ExtTMP4DArrayN(:,:,k,n)
   950: W------         end do
   951:                 n = 2
   952: W------>        do k = 1, ksimax
   953: |**---->A         xyz_ExtSOSeaIceTempS     (:,:,k) = xyza_ExtTMP4DArrayS(:,:,k,n)
   954: |**---- A         xyz_ExtSOSeaIceTempN     (:,:,k) = xyza_ExtTMP4DArrayN(:,:,k,n)
   955: W------         end do
   956:                 n = 3
   957:                 k = 1
   958: W------>        do j = jexmin, jexmax
   959: |*----->          do i = iexmin, iexmax
   960: ||      A           if ( xyza_ExtTMP4DArrayS(i,j,k,n) == 1.0_DP ) then
   961: ||                    xy_ExtFlagSlabOceanS(i,j) = .true.
   962: ||                  else
   963: ||                    xy_ExtFlagSlabOceanS(i,j) = .false.
   964: ||                  end if
   965: ||      A           if ( xyza_ExtTMP4DArrayN(i,j,k,n) == 1.0_DP ) then
   966: ||                    xy_ExtFlagSlabOceanN(i,j) = .true.
   967: ||                  else
   968: ||                    xy_ExtFlagSlabOceanN(i,j) = .false.
   969: ||                  end if
   970: |*----- A         end do
   971: W------         end do
   972:                 k = 2
   973: +------>        do kk = 1, ksimax
   974: |*W---->A         xyz_ExtSurfTempS(:,:,kk) = xyza_ExtTMP4DArrayS(:,:,k,n)
   975: |*W---- A         xyz_ExtSurfTempN(:,:,kk) = xyza_ExtTMP4DArrayN(:,:,k,n)
   976: +------         end do
   977:                 k = 3
   978: +------>        do kk = 1, ksimax
   979: |*W---->A         xy_ExtSOSeaIceMassS = xyza_ExtTMP4DArrayS(:,:,k,n)
   980: |*W---- A         xy_ExtSOSeaIceMassN = xyza_ExtTMP4DArrayN(:,:,k,n)
   981: +------         end do
   982:             
   983:             
   984:             !!$    call SSIDiffusion(                             &
   985:             !!$      & x_ExtLonS, y_ExtLatS, y_ExtCosLatS,        & ! (in)
   986:             !!$      & p_LonS, q_LatS, q_CosLatS,                 & ! (in)
   987:             !!$      & xy_ExtFlagSlabOceanS, xy_ExtSOSeaIceMassS, & ! (in)
   988:             !!$      & xy_DSOSeaIceMassDtS                        & ! (out)
   989:             !!$      & )
   990:             !!$    call SSIDiffusion(                             &
   991:             !!$      & x_ExtLonN, y_ExtLatN, y_ExtCosLatN,        & ! (in)
   992:             !!$      & p_LonN, q_LatN, q_CosLatN,                 & ! (in)
   993:             !!$      & xy_ExtFlagSlabOceanN, xy_ExtSOSeaIceMassN, & ! (in)
   994:             !!$      & xy_DSOSeaIceMassDtN                        & ! (out)
   995:             !!$      & )
   996:             
   997:                 call SOSIDiffusionY(                                 &
   998:                   & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
   999:                   & q_LatS, q_CosLatS,                               & ! (in)
  1000:                   & xy_ExtFlagSlabOceanS, xyz_ExtSOSeaIceThicknessS, & ! (in)
  1001:                   & xyz_DSOSeaIceThicknessDtS                        & ! (out)
  1002:                   & )
  1003:                 call SOSIDiffusionY(                                 &
  1004:                   & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1005:                   & q_LatN, q_CosLatN,                               & ! (in)
  1006:                   & xy_ExtFlagSlabOceanN, xyz_ExtSOSeaIceThicknessN, & ! (in)
  1007:                   & xyz_DSOSeaIceThicknessDtN                        & ! (out)
  1008:                   & )
  1009:                 !
  1010:                 call SOSIDiffusionY(                                 &
  1011:                   & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1012:                   & q_LatS, q_CosLatS,                               & ! (in)
  1013:                   & xy_ExtFlagSlabOceanS, xyz_ExtSOSeaIceTempS, & ! (in)
  1014:                   & xyz_DSOSeaIceTempDtS                        & ! (out)
  1015:                   & )
  1016:                 call SOSIDiffusionY(                                 &
  1017:                   & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1018:                   & q_LatN, q_CosLatN,                               & ! (in)
  1019:                   & xy_ExtFlagSlabOceanN, xyz_ExtSOSeaIceTempN, & ! (in)
  1020:                   & xyz_DSOSeaIceTempDtN                        & ! (out)
  1021:                   & )
  1022:                 !
  1023:                 call SOSIDiffusionY(                                 &
  1024:                   & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1025:                   & q_LatS, q_CosLatS,                               & ! (in)
  1026:                   & xy_ExtFlagSlabOceanS, xyz_ExtSurfTempS,     & ! (in)
  1027:                   & xya_DSurfTempDtS,                           & ! (out)
  1028:                   & xy_ExtSOSeaIceMassS                         & ! (in) optional
  1029:                   & )
  1030:                 call SOSIDiffusionY(                                 &
  1031:                   & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1032:                   & q_LatN, q_CosLatN,                               & ! (in)
  1033:                   & xy_ExtFlagSlabOceanN, xyz_ExtSurfTempN,     & ! (in)
  1034:                   & xya_DSurfTempDtN,                           & ! (out)
  1035:                   & xy_ExtSOSeaIceMassN                         & ! (in) optional
  1036:                   & )
  1037:             
  1038: W**==== A       xyz_DSOSeaIceThicknessDt(:,1:jmax/2     ,:) = xyz_DSOSeaIceThicknessDtS(:,1:jmax/2,:)
  1039: **W---->A       xyz_DSOSeaIceThicknessDt(:,jmax/2+1:jmax,:) = xyz_DSOSeaIceThicknessDtN(:,1:jmax/2,:)
  1040: |||             !
  1041: **W---- A       xyz_DSOSeaIceTempDt(:,1:jmax/2     ,:) = xyz_DSOSeaIceTempDtS(:,1:jmax/2,:)
  1042: W**==== A       xyz_DSOSeaIceTempDt(:,jmax/2+1:jmax,:) = xyz_DSOSeaIceTempDtN(:,1:jmax/2,:)
  1043:                 !
  1044: W*===== A       xy_DSurfTempDt(:,1:jmax/2     ) = xya_DSurfTempDtS(:,1:jmax/2,1)
  1045: W*===== A       xy_DSurfTempDt(:,jmax/2+1:jmax) = xya_DSurfTempDtN(:,1:jmax/2,1)
  1046:             
  1047:             
  1048:             !!$    ! sea ice mass at next time step is calculated temporarily
  1049:             !!$    xy_SOSeaIceMassA = xy_SOSeaIceMassA &
  1050:             !!$      & + xy_DSOSeaIceMassDt * ( 2.0_DP * DelTime )
  1051:             !!$
  1052:             !!$    ! tendency is calculated
  1053:             !!$    xy_DSOSeaIceMassDt = &
  1054:             !!$      & ( xy_SOSeaIceMassA - xy_SOSeaIceMassB ) / ( 2.0_DP * DelTime )
  1055:             
  1056:             
  1057:             !!$    py_ExtSOSeaIceMassXFlux = 0.0_DP
  1058:             !!$    xq_ExtSOSeaIceMassYFlux = 0.0_DP
  1059:             !!$    do j = jexmin, jexmax-1
  1060:             !!$      do i = iexmin, iexmax-1
  1061:             !!$        py_ExtSOSeaIceMassXFlux(i,j) = &
  1062:             !!$          & - SOSeaIceDiffCoef &
  1063:             !!$          &   * ( xy_ExtSOSeaIceMassS(i+1,j) - xy_ExtSOSeaIceMassS(i,j) ) &
  1064:             !!$          &   / ( RPlanet * y_CosLatS(j) * ( x_ExtLonS(i+1) - x_ExtLonS(i) ) )
  1065:             !!$        xq_ExtSOSeaIceMassYFlux(i,j) = &
  1066:             !!$          & - SOSeaIceDiffCoef &
  1067:             !!$          &   * ( xy_ExtSOSeaIceMassS(i,j+1) - xy_ExtSOSeaIceMassS(i,j) ) &
  1068:             !!$          &   / ( RPlanet * ( y_ExtLatS(j+1) - y_ExtLatS(j) ) )
  1069:             !!$      end do
  1070:             !!$    end do
  1071:             !!$    if ( myrank == nprocs-1 ) then
  1072:             !!$      j = 0
  1073:             !!$      do i = iexmin, iexmax-1
  1074:             !!$        xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1075:             !!$      end do
  1076:             !!$    end if
  1077:             !!$
  1078:             !!$    do j = 1, jmax
  1079:             !!$      do i = 0, imax-1
  1080:             !!$        xy_DSOSeaIceMassDt(i,j) = &
  1081:             !!$          & - ( py_ExtSOSeaIceMassXFlux(i,j) - py_ExtSOSeaIceMassXFlux(i-1,j) ) &
  1082:             !!$          &   / ( RPlanet * y_CosLatS(j) * ( p_Lon(i) - p_Lon(i-1) ) ) &
  1083:             !!$          & - (   xq_ExtSOSeaIceMassYFlux(i,j  ) * q_CosLatS(j  )   &
  1084:             !!$          &     - xq_ExtSOSeaIceMassYFlux(i,j-1) * q_CosLatS(j-1) ) &
  1085:             !!$          &   / ( RPlanet * y_CosLatS(j) * ( q_LatS(j) - q_LatS(j-1) ) )
  1086:             !!$      end do
  1087:             !!$    end do
  1088:             
  1089:             
  1090:             
  1091:             
  1092:               end subroutine SOSIHorTransportFFSL
  1093:             
  1094:               !----------------------------------------------------------------------------
  1095:             
  1096:             !!$  subroutine SOSIFFSLX(                          &
  1097:             !!$    & DelLon, y_CosLat, xy_FlagSlabOcean,        & ! (in)
  1098:             !!$    & xy_SOSeaIceMass,                           & ! (in)
  1099:             !!$    & xy_SurfTemp , xyz_SOSeaIceThickness , xyz_SOSeaIceTemp,  & ! (in)
  1100:             !!$    & xy_SurfTempA, xyz_SOSeaIceThicknessA, xyz_SOSeaIceTempA  & ! (out)
  1101:             !!$    & )
  1102:             !!$    ! 
  1103:             !!$    ! Calculates slab sea ice transport by longitudinal diffusion
  1104:             !!$
  1105:             !!$
  1106:             !!$    !
  1107:             !!$    !
  1108:             !!$    use ludecomp_module, only : &
  1109:             !!$      & ludecomp_prep_simple_many, &
  1110:             !!$      & ludecomp_solve_simple_many
  1111:             !!$
  1112:             !!$    use constants, only: &
  1113:             !!$      & RPlanet, &
  1114:             !!$      ! $ a $ [m].
  1115:             !!$      ! 惑星半径.
  1116:             !!$      ! Radius of planet
  1117:             !!$      & SOMass
  1118:             !!$                              ! Slab ocean mass
  1119:             !!$
  1120:             !!$    real(DP), intent(in ) :: DelLon
  1121:             !!$    real(DP), intent(in ) :: y_CosLat(1:jmax)
  1122:             !!$    logical , intent(in ) :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
  1123:             !!$    real(DP), intent(in ) :: xy_SOSeaIceMass       (0:imax-1, 1:jmax)
  1124:             !!$    real(DP), intent(in ) :: xy_SurfTemp           (0:imax-1, 1:jmax)
  1125:             !!$    real(DP), intent(in ) :: xyz_SOSeaIceThickness (0:imax-1, 1:jmax, 1:ksimax)
  1126:             !!$    real(DP), intent(in ) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
  1127:             !!$    real(DP), intent(out) :: xy_SurfTempA          (0:imax-1, 1:jmax)
  1128:             !!$    real(DP), intent(out) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 1:ksimax)
  1129:             !!$    real(DP), intent(out) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 1:ksimax)
  1130:             !!$
  1131:             !!$    !
  1132:             !!$    ! local variables
  1133:             !!$    !
  1134:             !!$    real(DP) :: SOSeaIceU0 = 0.1_DP
  1135:             !!$
  1136:             !!$    real(DP) :: y_Factor(1:jmax)
  1137:             !!$
  1138:             !!$    real(DP) :: py_SOSeaIceU(0:imax-1, 1:jmax)
  1139:             !!$                              ! 
  1140:             !!$                              ! Longitudional Flux of slab sea ice
  1141:             !!$
  1142:             !!$    integer:: i            ! 東西方向に回る DO ループ用作業変数
  1143:             !!$                           ! Work variables for DO loop in zonal direction
  1144:             !!$    integer:: j            ! 南北方向に回る DO ループ用作業変数
  1145:             !!$                           ! Work variables for DO loop in meridional direction
  1146:             !!$    integer:: k
  1147:             !!$
  1148:             !!$    integer:: l
  1149:             !!$    integer:: ii
  1150:             !!$    integer:: iprev
  1151:             !!$    integer:: inext
  1152:             !!$
  1153:             !!$
  1154:             !!$    ! 実行文 ; Executable statement
  1155:             !!$    !
  1156:             !!$
  1157:             !!$    ! 初期化確認
  1158:             !!$    ! Initialization check
  1159:             !!$    !
  1160:             !!$    if ( .not. sosi_dynamics_inited ) then
  1161:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1162:             !!$    end if
  1163:             !!$
  1164:             !!$
  1165:             !!$    y_Factor = 1.0_DP / ( RPlanet * y_CosLat * DelLon )**2
  1166:             !!$
  1167:             !!$    ! grid arrangement
  1168:             !!$    !
  1169:             !!$    !       |   .   |   .   |   .   |   .   |   .   |   .
  1170:             !!$    !
  1171:             !!$    ! x         0       1       2       3       4
  1172:             !!$    ! p             0       1       2       3       4
  1173:             !!$    !
  1174:             !!$    do j = 1, jmax
  1175:             !!$      do i = 0, imax-1
  1176:             !!$        if ( i == imax-1 ) then
  1177:             !!$          iprev = i
  1178:             !!$          inext = 0
  1179:             !!$        else
  1180:             !!$          iprev = i
  1181:             !!$          inext = i+1
  1182:             !!$        end if
  1183:             !!$        if ( xy_FlagSlabOcean(iprev,j) .and. xy_FlagSlabOcean(inext,j) ) then
  1184:             !!$          py_SOSeaIceU(i,j) = SOSeaIceU0
  1185:             !!$        else
  1186:             !!$          py_SOSeaIceU(i,j) = 0.0_DP
  1187:             !!$        end if
  1188:             !!$      end do
  1189:             !!$    end do
  1190:             !!$
  1191:             !!$!    do i = 0, imax-1
  1192:             !!$!      p_Lon(i) = DelLon / 2.0_DP + DelLon * i
  1193:             !!$!    end do
  1194:             !!$    p_Lon = x_Lon + ( x_Lon(1) - x_Lon(0) ) / 2.0_DP
  1195:             !!$
  1196:             !!$    ! Departure point
  1197:             !!$    do j = 1, jmax
  1198:             !!$      py_DPLon(:,j) = &
  1199:             !!$        & p_Lon - py_SOSeaIceU(:,j) * DelTime / ( RPlanet * y_CosLat(j) )
  1200:             !!$    end do
  1201:             !!$    do j = 1, jmax
  1202:             !!$      do i = 0, imax-1
  1203:             !!$        if ( py_DPLon(i,j) < 0.0_DP ) then
  1204:             !!$          py_DPLon(i,j) = py_DPLon(i,j) + 2.0_DP * PI
  1205:             !!$        else if ( py_DPLon(i,j) > 2.0_DP * PI ) then
  1206:             !!$          py_DPLon(i,j) = py_DPLon(i,j) - 2.0_DP * PI
  1207:             !!$        end if
  1208:             !!$      end do
  1209:             !!$    end do
  1210:             !!$
  1211:             !!$    do j = 1, jmax
  1212:             !!$      do i = 0, imax-1
  1213:             !!$        dp_search : do ii = 0, imax-1
  1214:             !!$          if ( py_DPLon(i,j) <= p_Lon(ii) ) then
  1215:             !!$            exit dp_search
  1216:             !!$          end if
  1217:             !!$        end do dp_search
  1218:             !!$        py_DPIndex
  1219:             !!$        if (
  1220:             !!$        py_SOSeaIceDPLon(i,j) = p_Lon
  1221:             !!$      end do
  1222:             !!$    end do
  1223:             !!$
  1224:             !!$
  1225:             !!$
  1226:             !!$
  1227:             !!$  end subroutine SOSIFFSLX
  1228:             
  1229:               !----------------------------------------------------------------------------
  1230:             
  1231:               subroutine SOSIHorTransportDiff(                    &
  1232:                 & xy_FlagSlabOcean,                               & ! (in)
  1233:                 & xy_SOSeaIceMass,                                & ! (in)
  1234:                 & xy_SurfTemp,                                    & ! (in)
  1235:                 & xyz_SOSeaIceThickness, xyz_SOSeaIceTemp,        & ! (in)
  1236:                 & xy_DSurfTempDt,                                 & ! (out)
  1237:                 & xyz_DSOSeaIceThicknessDt, xyz_DSOSeaIceTempDt   & ! (out)
  1238:                 & )
  1239:                 ! 
  1240:                 ! Calculates slab sea ice transport by diffusion
  1241:             
  1242:                 use timeset    , only : DelTime
  1243:                                           ! $\Delta t$
  1244:                 use axesset    , only : x_Lon, y_Lat
  1245:                                           ! $\lambda, \varphai$ lon and lat
  1246:                 use sltt_const , only : dtjw, iexmin, iexmax, jexmin, jexmax
  1247:                 use sosi_dynamics_extarr, only : SLTTExtArrExt2
  1248:                                           ! 配列拡張ルーチン
  1249:                                           ! Expansion of arrays
  1250:                 ! 雪と海氷の定数の設定
  1251:                 ! Setting constants of snow and sea ice
  1252:                 !
  1253:                 use constants_snowseaice, only: &
  1254:                   & SeaIceDen
  1255:             
  1256:             
  1257:                 logical , intent(in ) :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
  1258:                 real(DP), intent(in ) :: xy_SOSeaIceMass      (0:imax-1, 1:jmax)
  1259:                 real(DP), intent(in ) :: xy_SurfTemp          (0:imax-1, 1:jmax)
  1260:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1261:             !!!!    real(DP), intent(in ) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 1:ksimax)
  1262:             !!!!    real(DP), intent(in ) :: xyz_SOSeaIceTemp     (0:imax-1, 1:jmax, 1:ksimax)
  1263:                 real(DP), intent(in ) :: xyz_SOSeaIceThickness(0:imax-1, 1:jmax, 0:ksimax)
  1264:                 real(DP), intent(in ) :: xyz_SOSeaIceTemp     (0:imax-1, 1:jmax, 0:ksimax)
  1265:                 real(DP), intent(out) :: xy_DSurfTempDt          (0:imax-1, 1:jmax)
  1266:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1267:             !!!!    real(DP), intent(out) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 1:ksimax)
  1268:             !!!!    real(DP), intent(out) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 1:ksimax)
  1269:                 real(DP), intent(out) :: xyz_DSOSeaIceThicknessDt(0:imax-1, 1:jmax, 0:ksimax)
  1270:                 real(DP), intent(out) :: xyz_DSOSeaIceTempDt     (0:imax-1, 1:jmax, 0:ksimax)
  1271:             
  1272:             
  1273:                 !
  1274:                 ! local variables
  1275:                 !
  1276:                 real(DP) :: xy_SurfTempA          (0:imax-1, 1:jmax)
  1277:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1278:             !!!!    real(DP) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 1:ksimax)
  1279:             !!!!    real(DP) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 1:ksimax)
  1280:                 real(DP) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 0:ksimax)
  1281:                 real(DP) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 0:ksimax)
  1282:             
  1283:                 real(DP) :: xy_SOSeaIceMassA      (0:imax-1, 1:jmax)
  1284:             
  1285:                 real(DP) :: xyza_TMP4DArray(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1286:             
  1287:                 real(DP) :: xyza_ExtTMP4DArrayS(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1288:                                           ! 
  1289:                                           ! Extended 4D array (SH)
  1290:                 real(DP) :: xyza_ExtTMP4DArrayN(iexmin:iexmax, jexmin:jexmax, 1:kmax, 1:ncmax)
  1291:                                           ! 
  1292:                                           ! Extended 4D array (NH)
  1293:             
  1294:                 real(DP) :: xyz_ExtSOSeaIceThicknessS(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1295:                 real(DP) :: xyz_ExtSOSeaIceTempS     (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1296:                 real(DP) :: xyz_ExtSurfTempS         (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1297:                 real(DP) :: xy_ExtSOSeaIceMassS      (iexmin:iexmax, jexmin:jexmax)
  1298:                                           ! 
  1299:                                           ! Extended 4D array (SH)
  1300:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1301:             !!!!    real(DP) :: xyz_ExtSOSeaIceThicknessN(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1302:             !!!!    real(DP) :: xyz_ExtSOSeaIceTempN     (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1303:             !!!!    real(DP) :: xyz_ExtSurfTempN         (iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1304:                 real(DP) :: xyz_ExtSOSeaIceThicknessN(iexmin:iexmax, jexmin:jexmax, 0:ksimax)
  1305:                 real(DP) :: xyz_ExtSOSeaIceTempN     (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
  1306:                 real(DP) :: xyz_ExtSurfTempN         (iexmin:iexmax, jexmin:jexmax, 0:ksimax)
  1307:                 real(DP) :: xy_ExtSOSeaIceMassN      (iexmin:iexmax, jexmin:jexmax)
  1308:                                           ! 
  1309:                                           ! Extended 4D array (NH)
  1310:             
  1311:                 logical  :: xy_ExtFlagSlabOceanS(iexmin:iexmax, jexmin:jexmax)
  1312:                                           ! 
  1313:                                           ! Extended 4D array (SH)
  1314:                 logical  :: xy_ExtFlagSlabOceanN(iexmin:iexmax, jexmin:jexmax)
  1315:                                           ! 
  1316:                                           ! Extended 4D array (NH)
  1317:             
  1318:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1319:             !!!!    real(DP) :: xyz_DSOSeaIceThicknessDtS(0:imax-1, 1:jmax/2, 1:ksimax)
  1320:             !!!!    real(DP) :: xyz_DSOSeaIceTempDtS     (0:imax-1, 1:jmax/2, 1:ksimax)
  1321:             !!!!    real(DP) :: xya_DSurfTempDtS         (0:imax-1, 1:jmax/2, 1:ksimax)
  1322:             !!!!    real(DP) :: xyz_DSOSeaIceThicknessDtN(0:imax-1, 1:jmax/2, 1:ksimax)
  1323:             !!!!    real(DP) :: xyz_DSOSeaIceTempDtN     (0:imax-1, 1:jmax/2, 1:ksimax)
  1324:             !!!!    real(DP) :: xya_DSurfTempDtN         (0:imax-1, 1:jmax/2, 1:ksimax)
  1325:             
  1326:                 real(DP) :: xyz_DSOSeaIceThicknessDtS(0:imax-1, 1:jmax/2, 0:ksimax)
  1327:                 real(DP) :: xyz_DSOSeaIceTempDtS     (0:imax-1, 1:jmax/2, 0:ksimax)
  1328:                 real(DP) :: xya_DSurfTempDtS         (0:imax-1, 1:jmax/2, 0:ksimax)
  1329:                 real(DP) :: xyz_DSOSeaIceThicknessDtN(0:imax-1, 1:jmax/2, 0:ksimax)
  1330:                 real(DP) :: xyz_DSOSeaIceTempDtN     (0:imax-1, 1:jmax/2, 0:ksimax)
  1331:                 real(DP) :: xya_DSurfTempDtN         (0:imax-1, 1:jmax/2, 0:ksimax)
  1332:             
  1333:             
  1334:             
  1335:                 real(DP) :: PM
  1336:                 ! 配列拡張する際、極ごえ後に符号が変わる場合は -1.0を与える。
  1337:                 ! そうでない場合は1.0を与える。
  1338:                 ! Sign change flag for array extension; -1.0 for sign change
  1339:                 ! over the pole, 1.0 for no sign change
  1340:             
  1341:             
  1342:             
  1343:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
  1344:                                           ! Work variables for DO loop in zonal direction
  1345:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
  1346:                                           ! Work variables for DO loop in meridional direction
  1347:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1348:                                           ! Work variables for DO loop in vertical direction
  1349:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
  1350:                                           ! Work variables for DO loop in dimension of constituents
  1351:                 integer:: kk
  1352:             
  1353:             
  1354:                 ! 実行文 ; Executable statement
  1355:                 !
  1356:             
  1357:                 ! 初期化確認
  1358:                 ! Initialization check
  1359:                 !
  1360:                 if ( .not. sosi_dynamics_inited ) then
  1361:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1362:                 end if
  1363:             
  1364:             
  1365:                 !
  1366:                 ! Longitudinal diffusion
  1367:                 !
  1368:             
  1369:             
  1370:                 call SOSIDiffusionX(                               &
  1371:                   & x_Lon(1)-x_Lon(0), y_CosLat, xy_FlagSlabOcean, & ! (in)
  1372:                   & xy_SOSeaIceMass,                                             & ! (in)
  1373:                   & xy_SurfTemp , xyz_SOSeaIceThickness , xyz_SOSeaIceTemp,      & ! (in)
  1374:                   & xy_SurfTempA, xyz_SOSeaIceThicknessA, xyz_SOSeaIceTempA      & ! (out)
  1375:                   & )
  1376:             
  1377:             
  1378: W*=====         xy_SOSeaIceMassA = 0.0_DP
  1379: +------>        do k = 1, ksimax
  1380: |W*==== A         xy_SOSeaIceMassA = xy_SOSeaIceMassA &
  1381: |                   & + SeaIceDen * xyz_SOSeaIceThicknessA(:,:,k)
  1382: +------         end do
  1383:             
  1384:             
  1385:                 !
  1386:                 ! Latitudinal diffusion
  1387:                 !
  1388:             
  1389:                 ! 配列の分割と拡張
  1390:                 ! Division and extension of arrays
  1391:                 !
  1392:             
  1393:                 if ( ksimax > kmax ) then
  1394:                   call MessageNotify( 'E', module_name, 'ksimax > kmax.' )
  1395:                 end if
  1396:                 if ( kmax < 3 ) then
  1397:                   call MessageNotify( 'E', module_name, 'kmax < 3.' )
  1398:                 end if
  1399:                 if ( ncmax < 3 ) then
  1400:                   call MessageNotify( 'E', module_name, 'ncmax < 3.' )
  1401:                 end if
  1402:             
  1403:             
  1404:                 n = 1
  1405: W------>        do k = 1, ksimax
  1406: |**==== A         xyza_TMP4DArray(:,:,k,n) = xyz_SOSeaIceThicknessA(:,:,k)
  1407: W------         end do
  1408: W------>        do k = ksimax+1, kmax
  1409: |**==== A         xyza_TMP4DArray(:,:,k,n) = 0.0_DP
  1410: W------         end do
  1411:                 !
  1412:                 n = 2
  1413: W------>        do k = 1, ksimax
  1414: |**==== A         xyza_TMP4DArray(:,:,k,n) = xyz_SOSeaIceTempA(:,:,k)
  1415: W------         end do
  1416: W------>        do k = ksimax+1, kmax
  1417: |**==== A         xyza_TMP4DArray(:,:,k,n) = 0.0_DP
  1418: W------         end do
  1419:                 !
  1420:                 n = 3
  1421:                 k = 1
  1422: W------>        do j = 1, jmax
  1423: |*----->          do i = 0, imax-1
  1424: ||      A           if ( xy_FlagSlabOcean(i,j) ) then
  1425: ||                    xyza_TMP4DArray(i,j,k,n) = 1.0_DP
  1426: ||                  else
  1427: ||                    xyza_TMP4DArray(i,j,k,n) = 0.0_DP
  1428: ||                  end if
  1429: |*----- A         end do
  1430: W------         end do
  1431:                 k = 2
  1432: W*===== A       xyza_TMP4DArray(:,:,k,n) = xy_SurfTempA
  1433:                 k = 3
  1434: W*===== A       xyza_TMP4DArray(:,:,k,n) = xy_SOSeaIceMassA
  1435: W------>        do k = 3+1, kmax
  1436: |**==== A         xyza_TMP4DArray(:,:,k,n) = 0.0_DP
  1437: W------         end do
  1438:                 !
  1439: W------>        do n = 3+1, ncmax
  1440: |***=== A         xyza_TMP4DArray(:,:,:,n) = 0.0_DP
  1441: W------         end do
  1442:             
  1443:                 PM = 1.0_DP
  1444:                 call SLTTExtArrExt2(                            &
  1445:                   & x_SinLonS, x_CosLonS, x_SinLonN, x_CosLonN, & ! (in)
  1446:                   & xyza_TMP4DArray, PM,                        & ! (in)
  1447:                   & xyza_ExtTMP4DArrayS, xyza_ExtTMP4DArrayN    & ! (out)
  1448:                   & )
  1449:             
  1450:                 n = 1
  1451: W------>        do k = 1, ksimax
  1452: |**---->A         xyz_ExtSOSeaIceThicknessS(:,:,k) = xyza_ExtTMP4DArrayS(:,:,k,n)
  1453: |**---- A         xyz_ExtSOSeaIceThicknessN(:,:,k) = xyza_ExtTMP4DArrayN(:,:,k,n)
  1454: W------         end do
  1455:                 n = 2
  1456: W------>        do k = 1, ksimax
  1457: |**---->A         xyz_ExtSOSeaIceTempS     (:,:,k) = xyza_ExtTMP4DArrayS(:,:,k,n)
  1458: |**---- A         xyz_ExtSOSeaIceTempN     (:,:,k) = xyza_ExtTMP4DArrayN(:,:,k,n)
  1459: W------         end do
  1460:                 n = 3
  1461:                 k = 1
  1462: W------>        do j = jexmin, jexmax
  1463: |*----->          do i = iexmin, iexmax
  1464: ||      A           if ( xyza_ExtTMP4DArrayS(i,j,k,n) == 1.0_DP ) then
  1465: ||                    xy_ExtFlagSlabOceanS(i,j) = .true.
  1466: ||                  else
  1467: ||                    xy_ExtFlagSlabOceanS(i,j) = .false.
  1468: ||                  end if
  1469: ||      A           if ( xyza_ExtTMP4DArrayN(i,j,k,n) == 1.0_DP ) then
  1470: ||                    xy_ExtFlagSlabOceanN(i,j) = .true.
  1471: ||                  else
  1472: ||                    xy_ExtFlagSlabOceanN(i,j) = .false.
  1473: ||                  end if
  1474: |*----- A         end do
  1475: W------         end do
  1476:                 k = 2
  1477: +------>        do kk = 1, ksimax
  1478: |*W---->A         xyz_ExtSurfTempS(:,:,kk) = xyza_ExtTMP4DArrayS(:,:,k,n)
  1479: |*W---- A         xyz_ExtSurfTempN(:,:,kk) = xyza_ExtTMP4DArrayN(:,:,k,n)
  1480: +------         end do
  1481:                 k = 3
  1482: +------>        do kk = 1, ksimax
  1483: |*W---->A         xy_ExtSOSeaIceMassS = xyza_ExtTMP4DArrayS(:,:,k,n)
  1484: |*W---- A         xy_ExtSOSeaIceMassN = xyza_ExtTMP4DArrayN(:,:,k,n)
  1485: +------         end do
  1486:             
  1487:             
  1488:             !!$    call SSIDiffusion(                             &
  1489:             !!$      & x_ExtLonS, y_ExtLatS, y_ExtCosLatS,        & ! (in)
  1490:             !!$      & p_LonS, q_LatS, q_CosLatS,                 & ! (in)
  1491:             !!$      & xy_ExtFlagSlabOceanS, xy_ExtSOSeaIceMassS, & ! (in)
  1492:             !!$      & xy_DSOSeaIceMassDtS                        & ! (out)
  1493:             !!$      & )
  1494:             !!$    call SSIDiffusion(                             &
  1495:             !!$      & x_ExtLonN, y_ExtLatN, y_ExtCosLatN,        & ! (in)
  1496:             !!$      & p_LonN, q_LatN, q_CosLatN,                 & ! (in)
  1497:             !!$      & xy_ExtFlagSlabOceanN, xy_ExtSOSeaIceMassN, & ! (in)
  1498:             !!$      & xy_DSOSeaIceMassDtN                        & ! (out)
  1499:             !!$      & )
  1500:             
  1501:                 call SOSIDiffusionY(                                 &
  1502:                   & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1503:                   & q_LatS, q_CosLatS,                               & ! (in)
  1504:                   & xy_ExtFlagSlabOceanS, xyz_ExtSOSeaIceThicknessS, & ! (in)
  1505:                   & xyz_DSOSeaIceThicknessDtS                        & ! (out)
  1506:                   & )
  1507:                 call SOSIDiffusionY(                                 &
  1508:                   & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1509:                   & q_LatN, q_CosLatN,                               & ! (in)
  1510:                   & xy_ExtFlagSlabOceanN, xyz_ExtSOSeaIceThicknessN, & ! (in)
  1511:                   & xyz_DSOSeaIceThicknessDtN                        & ! (out)
  1512:                   & )
  1513:                 !
  1514:                 call SOSIDiffusionY(                                 &
  1515:                   & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1516:                   & q_LatS, q_CosLatS,                               & ! (in)
  1517:                   & xy_ExtFlagSlabOceanS, xyz_ExtSOSeaIceTempS, & ! (in)
  1518:                   & xyz_DSOSeaIceTempDtS                        & ! (out)
  1519:                   & )
  1520:                 call SOSIDiffusionY(                                 &
  1521:                   & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1522:                   & q_LatN, q_CosLatN,                               & ! (in)
  1523:                   & xy_ExtFlagSlabOceanN, xyz_ExtSOSeaIceTempN, & ! (in)
  1524:                   & xyz_DSOSeaIceTempDtN                        & ! (out)
  1525:                   & )
  1526:                 !
  1527:                 call SOSIDiffusionY(                                 &
  1528:                   & y_ExtLatS, y_ExtCosLatS,                         & ! (in)
  1529:                   & q_LatS, q_CosLatS,                               & ! (in)
  1530:                   & xy_ExtFlagSlabOceanS, xyz_ExtSurfTempS,     & ! (in)
  1531:                   & xya_DSurfTempDtS,                           & ! (out)
  1532:                   & xy_ExtSOSeaIceMassS                         & ! (in) optional
  1533:                   & )
  1534:                 call SOSIDiffusionY(                                 &
  1535:                   & y_ExtLatN, y_ExtCosLatN,                         & ! (in)
  1536:                   & q_LatN, q_CosLatN,                               & ! (in)
  1537:                   & xy_ExtFlagSlabOceanN, xyz_ExtSurfTempN,     & ! (in)
  1538:                   & xya_DSurfTempDtN,                           & ! (out)
  1539:                   & xy_ExtSOSeaIceMassN                         & ! (in) optional
  1540:                   & )
  1541:             
  1542: W**==== A       xyz_DSOSeaIceThicknessDt(:,1:jmax/2     ,:) = xyz_DSOSeaIceThicknessDtS(:,1:jmax/2,:)
  1543: **W---->A       xyz_DSOSeaIceThicknessDt(:,jmax/2+1:jmax,:) = xyz_DSOSeaIceThicknessDtN(:,1:jmax/2,:)
  1544: |||             !
  1545: **W---- A       xyz_DSOSeaIceTempDt(:,1:jmax/2     ,:) = xyz_DSOSeaIceTempDtS(:,1:jmax/2,:)
  1546: W**==== A       xyz_DSOSeaIceTempDt(:,jmax/2+1:jmax,:) = xyz_DSOSeaIceTempDtN(:,1:jmax/2,:)
  1547:                 !
  1548: W*===== A       xy_DSurfTempDt(:,1:jmax/2     ) = xya_DSurfTempDtS(:,1:jmax/2,1)
  1549: W*===== A       xy_DSurfTempDt(:,jmax/2+1:jmax) = xya_DSurfTempDtN(:,1:jmax/2,1)
  1550:             
  1551:             
  1552:             !!$    ! sea ice mass at next time step is calculated temporarily
  1553:             !!$    xy_SOSeaIceMassA = xy_SOSeaIceMassA &
  1554:             !!$      & + xy_DSOSeaIceMassDt * ( 2.0_DP * DelTime )
  1555:             !!$
  1556:             !!$    ! tendency is calculated
  1557:             !!$    xy_DSOSeaIceMassDt = &
  1558:             !!$      & ( xy_SOSeaIceMassA - xy_SOSeaIceMassB ) / ( 2.0_DP * DelTime )
  1559:             
  1560:             
  1561:             !!$    py_ExtSOSeaIceMassXFlux = 0.0_DP
  1562:             !!$    xq_ExtSOSeaIceMassYFlux = 0.0_DP
  1563:             !!$    do j = jexmin, jexmax-1
  1564:             !!$      do i = iexmin, iexmax-1
  1565:             !!$        py_ExtSOSeaIceMassXFlux(i,j) = &
  1566:             !!$          & - SOSeaIceDiffCoef &
  1567:             !!$          &   * ( xy_ExtSOSeaIceMassS(i+1,j) - xy_ExtSOSeaIceMassS(i,j) ) &
  1568:             !!$          &   / ( RPlanet * y_CosLatS(j) * ( x_ExtLonS(i+1) - x_ExtLonS(i) ) )
  1569:             !!$        xq_ExtSOSeaIceMassYFlux(i,j) = &
  1570:             !!$          & - SOSeaIceDiffCoef &
  1571:             !!$          &   * ( xy_ExtSOSeaIceMassS(i,j+1) - xy_ExtSOSeaIceMassS(i,j) ) &
  1572:             !!$          &   / ( RPlanet * ( y_ExtLatS(j+1) - y_ExtLatS(j) ) )
  1573:             !!$      end do
  1574:             !!$    end do
  1575:             !!$    if ( myrank == nprocs-1 ) then
  1576:             !!$      j = 0
  1577:             !!$      do i = iexmin, iexmax-1
  1578:             !!$        xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1579:             !!$      end do
  1580:             !!$    end if
  1581:             !!$
  1582:             !!$    do j = 1, jmax
  1583:             !!$      do i = 0, imax-1
  1584:             !!$        xy_DSOSeaIceMassDt(i,j) = &
  1585:             !!$          & - ( py_ExtSOSeaIceMassXFlux(i,j) - py_ExtSOSeaIceMassXFlux(i-1,j) ) &
  1586:             !!$          &   / ( RPlanet * y_CosLatS(j) * ( p_Lon(i) - p_Lon(i-1) ) ) &
  1587:             !!$          & - (   xq_ExtSOSeaIceMassYFlux(i,j  ) * q_CosLatS(j  )   &
  1588:             !!$          &     - xq_ExtSOSeaIceMassYFlux(i,j-1) * q_CosLatS(j-1) ) &
  1589:             !!$          &   / ( RPlanet * y_CosLatS(j) * ( q_LatS(j) - q_LatS(j-1) ) )
  1590:             !!$      end do
  1591:             !!$    end do
  1592:             
  1593:             
  1594:             
  1595:             
  1596:               end subroutine SOSIHorTransportDiff
  1597:             
  1598:               !----------------------------------------------------------------------------
  1599:             
  1600:               subroutine SOSIDiffusion(                      &
  1601:                 & x_ExtLonH, y_ExtLatH, y_ExtCosLatH,        & ! (in)
  1602:                 & p_LonH, q_LatH, q_CosLatH,                 & ! (in)
  1603:                 & xy_ExtFlagSlabOceanH, xy_ExtSOSeaIceMassH, & ! (in)
  1604:                 & xy_DSOSeaIceMassDtH                        & ! (out)
  1605:                 & )
  1606:             
  1607:                 ! 
  1608:                 ! Calculates slab sea ice transport by diffusion
  1609:             
  1610:                 use sltt_const , only : iexmin, iexmax, jexmin, jexmax
  1611:                                           ! 配列拡張ルーチン
  1612:                                           ! Expansion of arrays
  1613:             
  1614:                 use constants, only: &
  1615:                   & RPlanet
  1616:                   ! $ a $ [m].
  1617:                   ! 惑星半径.
  1618:                   ! Radius of planet
  1619:             
  1620:                 real(DP), intent(in ) :: x_ExtLonH   (iexmin:iexmax)
  1621:                 real(DP), intent(in ) :: y_ExtLatH   (jexmin:jexmax)
  1622:                 real(DP), intent(in ) :: y_ExtCosLatH(jexmin:jexmax)
  1623:                 real(DP), intent(in ) :: p_LonH   (0-1:imax-1+1)
  1624:                 real(DP), intent(in ) :: q_LatH   (1-1:jmax/2+1)
  1625:                 real(DP), intent(in ) :: q_CosLatH(1-1:jmax/2+1)
  1626:                 real(DP), intent(in ) :: xy_ExtSOSeaIceMassH(iexmin:iexmax, jexmin:jexmax)
  1627:                                           ! 
  1628:                                           ! Extended 4D array
  1629:                 logical , intent(in ) :: xy_ExtFlagSlabOceanH(iexmin:iexmax, jexmin:jexmax)
  1630:                                           ! 
  1631:                                           ! Extended 4D array
  1632:                 real(DP), intent(out) :: xy_DSOSeaIceMassDtH(0:imax-1, 1:jmax/2)
  1633:                                           ! 
  1634:                                           ! Slab sea ice mass tendency
  1635:             
  1636:                 !
  1637:                 ! local variables
  1638:                 !
  1639:             
  1640:                 real(DP) :: py_ExtSOSeaIceMassXFlux(iexmin-1:iexmax, jexmin:jexmax)
  1641:                                           ! 
  1642:                                           ! Longitudional Flux of slab sea ice
  1643:                 real(DP) :: xq_ExtSOSeaIceMassYFlux(iexmin:iexmax, jexmin-1:jexmax)
  1644:                                           ! 
  1645:                                           ! Latitudinal Flux of slab sea ice
  1646:             
  1647:             
  1648:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
  1649:                                           ! Work variables for DO loop in zonal direction
  1650:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
  1651:                                           ! Work variables for DO loop in meridional direction
  1652:             
  1653:             
  1654:                 ! 実行文 ; Executable statement
  1655:                 !
  1656:             
  1657:                 ! 初期化確認
  1658:                 ! Initialization check
  1659:                 !
  1660:                 if ( .not. sosi_dynamics_inited ) then
  1661:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1662:                 end if
  1663:             
  1664:             
  1665: W*=====         py_ExtSOSeaIceMassXFlux = 0.0_DP
  1666: W*=====         xq_ExtSOSeaIceMassYFlux = 0.0_DP
  1667: +------>        do j = jexmin, jexmax-1
  1668: |V----->          do i = iexmin, iexmax-1
  1669: ||      A           if ( xy_ExtFlagSlabOceanH(i,j) .and. xy_ExtFlagSlabOceanH(i+1,j) ) then
  1670: ||      A             py_ExtSOSeaIceMassXFlux(i,j) =                                    &
  1671: ||                      & - SOSeaIceDiffCoef                                            &
  1672: ||                      &   * ( xy_ExtSOSeaIceMassH(i+1,j) - xy_ExtSOSeaIceMassH(i,j) ) &
  1673: ||                      &   / ( RPlanet * y_ExtCosLatH(j) * ( x_ExtLonH(i+1) - x_ExtLonH(i) ) )
  1674: ||                  else
  1675: ||                    py_ExtSOSeaIceMassXFlux(i,j) = 0.0_DP
  1676: ||                  end if
  1677: ||      A           if ( xy_ExtFlagSlabOceanH(i,j) .and. xy_ExtFlagSlabOceanH(i,j+1) ) then
  1678: ||      A             xq_ExtSOSeaIceMassYFlux(i,j) =                                    &
  1679: ||                      & - SOSeaIceDiffCoef                                            &
  1680: ||                      &   * ( xy_ExtSOSeaIceMassH(i,j+1) - xy_ExtSOSeaIceMassH(i,j) ) &
  1681: ||                      &   / ( RPlanet * ( y_ExtLatH(j+1) - y_ExtLatH(j) ) )
  1682: ||                  else
  1683: ||                    xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1684: ||                  end if
  1685: |V-----           end do
  1686: +------         end do
  1687:             !!$    if ( myrank == nprocs-1 ) then
  1688:             !!$      j = 0
  1689:             !!$      do i = iexmin, iexmax-1
  1690:             !!$        xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1691:             !!$      end do
  1692:             !!$    end if
  1693:             
  1694: +------>        do j = 1, jmax/2
  1695: |V----->          do i = 0, imax-1
  1696: ||      A           xy_DSOSeaIceMassDtH(i,j) =                 &
  1697: ||                    & - (   py_ExtSOSeaIceMassXFlux(i  ,j)   &
  1698: ||                    &     - py_ExtSOSeaIceMassXFlux(i-1,j) ) &
  1699: ||                    &   / ( RPlanet * y_ExtCosLatH(j) * ( p_LonH(i) - p_LonH(i-1) ) ) &
  1700: ||                    & - (   xq_ExtSOSeaIceMassYFlux(i,j  ) * q_CosLatH(j  )           &
  1701: ||                    &     - xq_ExtSOSeaIceMassYFlux(i,j-1) * q_CosLatH(j-1) )         &
  1702: ||                    &   / ( RPlanet * y_ExtCosLatH(j) * ( q_LatH(j) - q_LatH(j-1) ) )
  1703: |V-----           end do
  1704: +------         end do
  1705:             
  1706:             
  1707:               end subroutine SOSIDiffusion
  1708:             
  1709:               !----------------------------------------------------------------------------
  1710:             
  1711:               subroutine SOSIDiffusionY(                      &
  1712:                 & y_ExtLatH, y_ExtCosLatH,                    & ! (in)
  1713:                 & q_LatH, q_CosLatH,                          & ! (in)
  1714:                 & xy_ExtFlagSlabOceanH, xyz_ExtSOSeaIceMassH, & ! (in)
  1715:                 & xyz_DSOSeaIceMassDtH,                       & ! (out)
  1716:                 & xy_ExtSOSeaIceMassH                         & ! (in) optional
  1717:                 & )
  1718:             
  1719:                 ! 
  1720:                 ! Calculates slab sea ice transport by diffusion
  1721:             
  1722:                 use sltt_const , only : iexmin, iexmax, jexmin, jexmax
  1723:                                           ! 配列拡張ルーチン
  1724:                                           ! Expansion of arrays
  1725:             
  1726:                 use constants, only: &
  1727:                   & RPlanet, &
  1728:                   ! $ a $ [m].
  1729:                   ! 惑星半径.
  1730:                   ! Radius of planet
  1731:                   & SOMass
  1732:                                           ! Slab ocean mass
  1733:             
  1734:                 real(DP), intent(in ) :: y_ExtLatH   (jexmin:jexmax)
  1735:                 real(DP), intent(in ) :: y_ExtCosLatH(jexmin:jexmax)
  1736:                 real(DP), intent(in ) :: q_LatH   (1-1:jmax/2+1)
  1737:                 real(DP), intent(in ) :: q_CosLatH(1-1:jmax/2+1)
  1738:                 logical , intent(in ) :: xy_ExtFlagSlabOceanH(iexmin:iexmax, jexmin:jexmax)
  1739:                                           ! 
  1740:                                           ! Extended 4D array
  1741:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1742:             !!!!    real(DP), intent(in ) :: xyz_ExtSOSeaIceMassH(iexmin:iexmax, jexmin:jexmax, 1:ksimax)
  1743:                 real(DP), intent(in ) :: xyz_ExtSOSeaIceMassH(iexmin:iexmax, jexmin:jexmax, 0:ksimax)
  1744:                                           ! 
  1745:                                           ! Extended 4D array
  1746:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1747:             !!!!    real(DP), intent(out) :: xyz_DSOSeaIceMassDtH(0:imax-1, 1:jmax/2, 1:ksimax)
  1748:                 real(DP), intent(out) :: xyz_DSOSeaIceMassDtH(0:imax-1, 1:jmax/2, 0:ksimax)
  1749:                                           ! 
  1750:                                           ! Slab sea ice mass tendency
  1751:                 real(DP), intent(in ), optional :: xy_ExtSOSeaIceMassH(iexmin:iexmax, jexmin:jexmax)
  1752:             
  1753:             
  1754:                 !
  1755:                 ! local variables
  1756:                 !
  1757:             
  1758:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1759:             !!!!    real(DP) :: xqz_ExtSODiffCoef       (iexmin:iexmax, jexmin-1:jexmax, 1:ksimax)
  1760:             !!!!    real(DP) :: xqz_ExtSOSeaIceMassYFlux(iexmin:iexmax, jexmin-1:jexmax, 1:ksimax)
  1761:                 real(DP) :: xqz_ExtSODiffCoef       (iexmin:iexmax, jexmin-1:jexmax, 0:ksimax)
  1762:                 real(DP) :: xqz_ExtSOSeaIceMassYFlux(iexmin:iexmax, jexmin-1:jexmax, 0:ksimax)
  1763:                                           ! 
  1764:                                           ! Latitudinal Flux of slab sea ice
  1765:             
  1766:             
  1767:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
  1768:                                           ! Work variables for DO loop in zonal direction
  1769:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
  1770:                                           ! Work variables for DO loop in meridional direction
  1771:                 integer:: k
  1772:             
  1773:             
  1774:                 ! 実行文 ; Executable statement
  1775:                 !
  1776:             
  1777:                 ! 初期化確認
  1778:                 ! Initialization check
  1779:                 !
  1780:                 if ( .not. sosi_dynamics_inited ) then
  1781:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1782:                 end if
  1783:             
  1784:             
  1785: +------>        do k = 1, ksimax
  1786: |+----->          do j = jexmin, jexmax-1
  1787: ||V---->            do i = iexmin, iexmax-1
  1788: |||     A             if ( xy_ExtFlagSlabOceanH(i,j) .and. xy_ExtFlagSlabOceanH(i,j+1) ) then
  1789: |||                     xqz_ExtSODiffCoef(i,j,k) = SOSeaIceDiffCoef
  1790: |||                     if ( present( xy_ExtSOSeaIceMassH ) ) then
  1791: |||     A                 xqz_ExtSODiffCoef(i,j,k) = xqz_ExtSODiffCoef(i,j,k) &
  1792: |||                         & * min( SOMass - xy_ExtSOSeaIceMassH(i,j  ), &
  1793: |||                         &        SOMass - xy_ExtSOSeaIceMassH(i,j+1) )
  1794: |||                     end if
  1795: |||                   else
  1796: |||                     xqz_ExtSODiffCoef(i,j,k) = 0.0_DP
  1797: |||                   end if
  1798: ||V---- A           end do
  1799: |+-----           end do
  1800: +------         end do
  1801:             
  1802: +------>        do k = 1, ksimax
  1803: |+----->          do j = jexmin, jexmax-1
  1804: ||V---->            do i = iexmin, iexmax-1
  1805: |||     A             xqz_ExtSOSeaIceMassYFlux(i,j,k) =                                       &
  1806: |||                     & - xqz_ExtSODiffCoef(i,j,k)                                          &
  1807: |||                     &   * ( xyz_ExtSOSeaIceMassH(i,j+1,k) - xyz_ExtSOSeaIceMassH(i,j,k) ) &
  1808: |||                     &   / ( RPlanet * ( y_ExtLatH(j+1) - y_ExtLatH(j) ) )
  1809: ||V----             end do
  1810: |+-----           end do
  1811: +------         end do
  1812:             !!$    if ( myrank == nprocs-1 ) then
  1813:             !!$      j = 0
  1814:             !!$      do i = iexmin, iexmax-1
  1815:             !!$        xq_ExtSOSeaIceMassYFlux(i,j) = 0.0_DP
  1816:             !!$      end do
  1817:             !!$    end if
  1818:             
  1819: +------>        do k = 1, ksimax
  1820: |+----->          do j = 1, jmax/2
  1821: ||V---->            do i = 0, imax-1
  1822: |||     A             xyz_DSOSeaIceMassDtH(i,j,k) =                                      &
  1823: |||                     & - (   xqz_ExtSOSeaIceMassYFlux(i,j  ,k) * q_CosLatH(j  )       &
  1824: |||                     &     - xqz_ExtSOSeaIceMassYFlux(i,j-1,k) * q_CosLatH(j-1) )     &
  1825: |||                     &   / ( RPlanet * y_ExtCosLatH(j) * ( q_LatH(j) - q_LatH(j-1) ) )
  1826: |||                   if ( present( xy_ExtSOSeaIceMassH ) ) then
  1827: |||     A               if ( SOMass - xy_ExtSOSeaIceMassH(i,j) > 0.0_DP ) then
  1828: |||                       xyz_DSOSeaIceMassDtH(i,j,k) = xyz_DSOSeaIceMassDtH(i,j,k) &
  1829: |||                         & / ( SOMass - xy_ExtSOSeaIceMassH(i,j) )
  1830: |||                     else
  1831: |||                       xyz_DSOSeaIceMassDtH(i,j,k) = 0.0_DP
  1832: |||                     end if
  1833: |||                   end if
  1834: ||V---- A           end do
  1835: |+-----           end do
  1836: +------         end do
  1837:             
  1838:             
  1839:               end subroutine SOSIDiffusionY
  1840:             
  1841:               !----------------------------------------------------------------------------
  1842:             
  1843:               subroutine SOSIDiffusionX(                     &
  1844:                 & DelLon, y_CosLat, xy_FlagSlabOcean,        & ! (in)
  1845:                 & xy_SOSeaIceMass,                           & ! (in)
  1846:                 & xy_SurfTemp , xyz_SOSeaIceThickness , xyz_SOSeaIceTemp,  & ! (in)
  1847:                 & xy_SurfTempA, xyz_SOSeaIceThicknessA, xyz_SOSeaIceTempA  & ! (out)
  1848:                 & )
  1849:                 ! 
  1850:                 ! Calculates slab sea ice transport by longitudinal diffusion
  1851:             
  1852:             
  1853:                 !
  1854:                 !
  1855:                 use ludecomp_module, only : &
  1856:                   & ludecomp_prep_simple_many, &
  1857:                   & ludecomp_solve_simple_many
  1858:             
  1859:                 use constants, only: &
  1860:                   & RPlanet, &
  1861:                   ! $ a $ [m].
  1862:                   ! 惑星半径.
  1863:                   ! Radius of planet
  1864:                   & SOMass
  1865:                                           ! Slab ocean mass
  1866:             
  1867:                 real(DP), intent(in ) :: DelLon
  1868:                 real(DP), intent(in ) :: y_CosLat(1:jmax)
  1869:                 logical , intent(in ) :: xy_FlagSlabOcean(0:imax-1, 1:jmax)
  1870:                 real(DP), intent(in ) :: xy_SOSeaIceMass       (0:imax-1, 1:jmax)
  1871:                 real(DP), intent(in ) :: xy_SurfTemp           (0:imax-1, 1:jmax)
  1872:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1873:             !!!!    real(DP), intent(in ) :: xyz_SOSeaIceThickness (0:imax-1, 1:jmax, 1:ksimax)
  1874:             !!!!    real(DP), intent(in ) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 1:ksimax)
  1875:                 real(DP), intent(in ) :: xyz_SOSeaIceThickness (0:imax-1, 1:jmax, 0:ksimax)
  1876:                 real(DP), intent(in ) :: xyz_SOSeaIceTemp      (0:imax-1, 1:jmax, 0:ksimax)
  1877:                 real(DP), intent(out) :: xy_SurfTempA          (0:imax-1, 1:jmax)
  1878:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1879:             !!!!    real(DP), intent(out) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 1:ksimax)
  1880:             !!!!    real(DP), intent(out) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 1:ksimax)
  1881:                 real(DP), intent(out) :: xyz_SOSeaIceThicknessA(0:imax-1, 1:jmax, 0:ksimax)
  1882:                 real(DP), intent(out) :: xyz_SOSeaIceTempA     (0:imax-1, 1:jmax, 0:ksimax)
  1883:             
  1884:                 !
  1885:                 ! local variables
  1886:                 !
  1887:             
  1888:                 real(DP) :: aax_LUMat(1:jmax*ksimax, 0:imax-1, 0:imax-1)
  1889:                 real(DP) :: aa_LUVec (1:jmax*ksimax, 0:imax-1)
  1890:             
  1891:                 real(DP) :: y_Factor(1:jmax)
  1892:             
  1893:             !!!! Modified by M.Ishiwatari (2016-12-10)
  1894:             !!!!    real(DP) :: pyz_SOSeaIceDiffCoef(0:imax-1, 1:jmax, 1:ksimax)
  1895:                 real(DP) :: pyz_SOSeaIceDiffCoef(0:imax-1, 1:jmax, 0:ksimax)
  1896:                                           ! 
  1897:                                           ! Longitudional Flux of slab sea ice
  1898:             
  1899:                 integer:: i            ! 東西方向に回る DO ループ用作業変数
  1900:                                        ! Work variables for DO loop in zonal direction
  1901:                 integer:: j            ! 南北方向に回る DO ループ用作業変数
  1902:                                        ! Work variables for DO loop in meridional direction
  1903:                 integer:: k
  1904:             
  1905:                 integer:: l
  1906:                 integer:: ii
  1907:                 integer:: iprev
  1908:                 integer:: inext
  1909:             
  1910:             
  1911:                 ! 実行文 ; Executable statement
  1912:                 !
  1913:             
  1914:                 ! 初期化確認
  1915:                 ! Initialization check
  1916:                 !
  1917:                 if ( .not. sosi_dynamics_inited ) then
  1918:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1919:                 end if
  1920:             
  1921:             
  1922: V====== A       y_Factor = 1.0_DP / ( RPlanet * y_CosLat * DelLon )**2
  1923:             
  1924: +------>        do k = 1, ksimax
  1925: |+----->          do j = 1, jmax
  1926: ||V---->            do i = 0, imax-1
  1927: |||                   if ( i == imax-1 ) then
  1928: |||                     iprev = i
  1929: |||                     inext = 0
  1930: |||                   else
  1931: |||                     iprev = i
  1932: |||                     inext = i+1
  1933: |||                   end if
  1934: |||     A             if ( xy_FlagSlabOcean(iprev,j) .and. xy_FlagSlabOcean(inext,j) ) then
  1935: |||                     pyz_SOSeaIceDiffCoef(i,j,k) = SOSeaIceDiffCoef
  1936: |||                   else
  1937: |||                     pyz_SOSeaIceDiffCoef(i,j,k) = 0.0_DP
  1938: |||                   end if
  1939: ||V----             end do
  1940: |+-----           end do
  1941: +------         end do
  1942:             
  1943: W**==== A       aax_LUMat = 0.0_DP
  1944: +------>        do k = 1, ksimax
  1945: |+----->          do j = 1, jmax
  1946: ||                  l = (k-1)*jmax+j
  1947: ||          
  1948: ||*---->            do ii = 0, 0
  1949: |||                   i = ii
  1950: |||                   aax_LUMat(l,ii,imax-1) = &
  1951: |||                     & - pyz_SOSeaIceDiffCoef(imax-1,j,k) &
  1952: |||                     &   * y_Factor(j)
  1953: |||                   aax_LUMat(l,ii,i  ) = &
  1954: |||                     &   1.0_DP / ( 1.0_DP * DelTime ) &
  1955: |||                     & + ( pyz_SOSeaIceDiffCoef(imax-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  1956: |||                     &   * y_Factor(j)
  1957: |||                   aax_LUMat(l,ii,i+1) = &
  1958: |||                     & - pyz_SOSeaIceDiffCoef(i     ,j,k) &
  1959: |||                     &   * y_Factor(j)
  1960: ||*----             end do
  1961: ||V---->            do ii = 0+1, (imax-1)-1
  1962: |||                   i = ii
  1963: |||     A             aax_LUMat(l,ii,i-1) = &
  1964: |||                     & - pyz_SOSeaIceDiffCoef(i-1,j,k) &
  1965: |||                     &   * y_Factor(j)
  1966: |||     A             aax_LUMat(l,ii,i  ) = &
  1967: |||     A               &   1.0_DP / ( 1.0_DP * DelTime ) &
  1968: |||     A               & + ( pyz_SOSeaIceDiffCoef(i-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  1969: |||     A               &   * y_Factor(j)
  1970: |||     A             aax_LUMat(l,ii,i+1) = &
  1971: |||                     & - pyz_SOSeaIceDiffCoef(i  ,j,k) &
  1972: |||                     &   * y_Factor(j)
  1973: ||V----             end do
  1974: ||*---->            do ii = imax-1, imax-1
  1975: |||                   i = ii
  1976: |||                   aax_LUMat(l,ii,i-1) = &
  1977: |||                     & - pyz_SOSeaIceDiffCoef(i-1,j,k) &
  1978: |||                     &   * y_Factor(j)
  1979: |||                   aax_LUMat(l,ii,i  ) = &
  1980: |||                     &   1.0_DP / ( 1.0_DP * DelTime ) &
  1981: |||                     & + ( pyz_SOSeaIceDiffCoef(i-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  1982: |||                     &   * y_Factor(j)
  1983: |||                   aax_LUMat(l,ii,0  ) = &
  1984: |||                     & - pyz_SOSeaIceDiffCoef(imax-1,j,k) &
  1985: |||                     &   * y_Factor(j)
  1986: ||*----             end do
  1987: ||          
  1988: ||          
  1989: |+-----           end do
  1990: +------         end do
  1991:             
  1992:                 call ludecomp_prep_simple_many ( jmax*ksimax, imax, aax_LUMat, 1, jmax*ksimax )
  1993:             
  1994:             
  1995: +------>        do k = 1, ksimax
  1996: |+----->          do j = 1, jmax
  1997: ||                  l = (k-1)*jmax+j
  1998: ||V---->            do ii = 0, imax-1
  1999: |||                   i = ii
  2000: |||     A             aa_LUVec(l,ii) = xyz_SOSeaIceThickness(i,j,k) / ( 1.0_DP * DelTime )
  2001: ||V----             end do
  2002: |+-----           end do
  2003: +------         end do
  2004:                 call ludecomp_solve_simple_many( jmax*ksimax, imax, aax_LUMat, aa_LUVec, 1, jmax*ksimax )
  2005: +------>        do k = 1, ksimax
  2006: |+----->          do j = 1, jmax
  2007: ||                  l = (k-1)*jmax+j
  2008: ||V---->            do ii = 0, imax-1
  2009: |||                   i = ii
  2010: |||     A             xyz_SOSeaIceThicknessA(i,j,k) = aa_LUVec(l,ii)
  2011: ||V----             end do
  2012: |+-----           end do
  2013: +------         end do
  2014:             
  2015: +------>        do k = 1, ksimax
  2016: |+----->          do j = 1, jmax
  2017: ||                  l = (k-1)*jmax+j
  2018: ||V---->            do ii = 0, imax-1
  2019: |||                   i = ii
  2020: |||     A             aa_LUVec(l,ii) = xyz_SOSeaIceTemp(i,j,k) / ( 1.0_DP * DelTime )
  2021: ||V----             end do
  2022: |+-----           end do
  2023: +------         end do
  2024:                 call ludecomp_solve_simple_many( jmax*ksimax, imax, aax_LUMat, aa_LUVec, 1, jmax*ksimax )
  2025: +------>        do k = 1, ksimax
  2026: |+----->          do j = 1, jmax
  2027: ||                  l = (k-1)*jmax+j
  2028: ||V---->            do ii = 0, imax-1
  2029: |||                   i = ii
  2030: |||     A             xyz_SOSeaIceTempA(i,j,k) = aa_LUVec(l,ii)
  2031: ||V----             end do
  2032: |+-----           end do
  2033: +------         end do
  2034:             
  2035:             
  2036:                 ! Diffusion of slab ocean temperature
  2037:                 !
  2038: +------>        do k = 1, ksimax
  2039: |+----->          do j = 1, jmax
  2040: ||V---->            do i = 0, imax-1
  2041: |||                   if ( i == imax-1 ) then
  2042: |||                     iprev = i
  2043: |||                     inext = 0
  2044: |||                   else
  2045: |||                     iprev = i
  2046: |||                     inext = i+1
  2047: |||                   end if
  2048: |||     A             if ( xy_FlagSlabOcean(iprev,j) .and. xy_FlagSlabOcean(inext,j) ) then
  2049: |||     A               pyz_SOSeaIceDiffCoef(i,j,k) = SOSeaIceDiffCoef &
  2050: |||                       & * min( SOMass - xy_SOSeaIceMass(iprev,j), &
  2051: |||                       &        SOMass - xy_SOSeaIceMass(inext,j) )
  2052: |||                   else
  2053: |||                     pyz_SOSeaIceDiffCoef(i,j,k) = 0.0_DP
  2054: |||                   end if
  2055: ||V----             end do
  2056: |+-----           end do
  2057: +------         end do
  2058:             
  2059: W**==== A       aax_LUMat = 0.0_DP
  2060: +------>        do k = 1, ksimax
  2061: |+----->          do j = 1, jmax
  2062: ||                  l = (k-1)*jmax+j
  2063: ||          
  2064: ||*---->            do ii = 0, 0
  2065: |||                   i = ii
  2066: |||                   aax_LUMat(l,ii,imax-1) = &
  2067: |||                     & - pyz_SOSeaIceDiffCoef(imax-1,j,k) &
  2068: |||                     &   * y_Factor(j)
  2069: |||                   aax_LUMat(l,ii,i  ) = &
  2070: |||                     &   1.0_DP / ( 1.0_DP * DelTime )          &
  2071: |||                     &     * ( SOMass - xy_SOSeaIceMass(i,j) )  &
  2072: |||                     & + ( pyz_SOSeaIceDiffCoef(imax-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  2073: |||                     &   * y_Factor(j)
  2074: |||                   aax_LUMat(l,ii,i+1) = &
  2075: |||                     & - pyz_SOSeaIceDiffCoef(i     ,j,k) &
  2076: |||                     &   * y_Factor(j)
  2077: ||*----             end do
  2078: ||V---->            do ii = 0+1, (imax-1)-1
  2079: |||                   i = ii
  2080: |||     A             aax_LUMat(l,ii,i-1) = &
  2081: |||                     & - pyz_SOSeaIceDiffCoef(i-1,j,k) &
  2082: |||                     &   * y_Factor(j)
  2083: |||     A             aax_LUMat(l,ii,i  ) = &
  2084: |||     A               &   1.0_DP / ( 1.0_DP * DelTime )          &
  2085: |||     A               &     * ( SOMass - xy_SOSeaIceMass(i,j) )  &
  2086: |||     A               & + ( pyz_SOSeaIceDiffCoef(i-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  2087: |||     A               &   * y_Factor(j)
  2088: |||     A             aax_LUMat(l,ii,i+1) = &
  2089: |||                     & - pyz_SOSeaIceDiffCoef(i  ,j,k) &
  2090: |||                     &   * y_Factor(j)
  2091: ||V----             end do
  2092: ||*---->            do ii = imax-1, imax-1
  2093: |||                   i = ii
  2094: |||                   aax_LUMat(l,ii,i-1) = &
  2095: |||                     & - pyz_SOSeaIceDiffCoef(i-1,j,k) &
  2096: |||                     &   * y_Factor(j)
  2097: |||                   aax_LUMat(l,ii,i  ) = &
  2098: |||                     &   1.0_DP / ( 1.0_DP * DelTime )          &
  2099: |||                     &     * ( SOMass - xy_SOSeaIceMass(i,j) )  &
  2100: |||                     & + ( pyz_SOSeaIceDiffCoef(i-1,j,k) + pyz_SOSeaIceDiffCoef(i,j,k) ) &
  2101: |||                     &   * y_Factor(j)
  2102: |||                   aax_LUMat(l,ii,0  ) = &
  2103: |||                     & - pyz_SOSeaIceDiffCoef(imax-1,j,k) &
  2104: |||                     &   * y_Factor(j)
  2105: ||*----             end do
  2106: ||          
  2107: ||          
  2108: |+-----           end do
  2109: +------         end do
  2110:                 !
  2111: +------>        do k = 1, ksimax
  2112: |+----->          do j = 1, jmax
  2113: ||                  l = (k-1)*jmax+j
  2114: ||*---->            do ii = 0, 0
  2115: |||                   i = ii
  2116: |||                   if ( SOMass - xy_SOSeaIceMass(i,j) <= 0.0_DP ) then
  2117: |||                     aax_LUMat(l,ii,imax-1) = 0.0_DP
  2118: |||                     aax_LUMat(l,ii,i     ) = 1.0_DP
  2119: |||                     aax_LUMat(l,ii,i+1   ) = 0.0_DP
  2120: |||                   end if
  2121: ||*----             end do
  2122: ||V---->            do ii = 0+1, (imax-1)-1
  2123: |||                   i = ii
  2124: |||     A             if ( SOMass - xy_SOSeaIceMass(i,j) <= 0.0_DP ) then
  2125: |||     A               aax_LUMat(l,ii,i-1) = 0.0_DP
  2126: |||     A               aax_LUMat(l,ii,i  ) = 1.0_DP
  2127: |||     A               aax_LUMat(l,ii,i+1) = 0.0_DP
  2128: |||                   end if
  2129: ||V----             end do
  2130: ||*---->            do ii = imax-1, imax-1
  2131: |||                   i = ii
  2132: |||                   if ( SOMass - xy_SOSeaIceMass(i,j) <= 0.0_DP ) then
  2133: |||                     aax_LUMat(l,ii,i-1) = 0.0_DP
  2134: |||                     aax_LUMat(l,ii,i  ) = 1.0_DP
  2135: |||                     aax_LUMat(l,ii,0  ) = 0.0_DP
  2136: |||                   end if
  2137: ||*----             end do
  2138: ||          
  2139: ||          
  2140: |+-----           end do
  2141: +------         end do
  2142:             
  2143:             
  2144:                 call ludecomp_prep_simple_many ( jmax*ksimax, imax, aax_LUMat, 1, jmax*ksimax )
  2145:             
  2146: +------>        do k = 1, ksimax
  2147: |+----->          do j = 1, jmax
  2148: ||                  l = (k-1)*jmax+j
  2149: ||V---->            do ii = 0, imax-1
  2150: |||                   i = ii
  2151: |||     A             if ( SOMass - xy_SOSeaIceMass(i,j) <= 0.0_DP ) then
  2152: |||     A               aa_LUVec(l,ii) = xy_SurfTemp(i,j)
  2153: |||                   else
  2154: |||     A               aa_LUVec(l,ii) = xy_SurfTemp(i,j) &
  2155: |||                       & * ( SOMass - xy_SOSeaIceMass(i,j) )  &
  2156: |||                       & / ( 1.0_DP * DelTime )
  2157: |||                   end if
  2158: ||V---- A           end do
  2159: |+-----           end do
  2160: +------         end do
  2161:                 call ludecomp_solve_simple_many( jmax*ksimax, imax, aax_LUMat, aa_LUVec, 1, jmax*ksimax )
  2162: *------>        do k = 1, 1
  2163: |+----->          do j = 1, jmax
  2164: ||                  l = (k-1)*jmax+j
  2165: ||V---->            do ii = 0, imax-1
  2166: |||                   i = ii
  2167: |||     A             xy_SurfTempA(i,j) = aa_LUVec(l,ii)
  2168: ||V----             end do
  2169: |+-----           end do
  2170: *------         end do
  2171:             
  2172:             
  2173:               end subroutine SOSIDiffusionX
  2174:             
  2175:               !-------------------------------------------------
  2176:             
  2177:               subroutine SOSIDynamicsInit( &
  2178:                 & ArgFlagSlabOcean &
  2179:                 & )
  2180:                 ! flag for use of slab ocean
  2181:                 ! 
  2182:                 ! Initialization of module
  2183:             
  2184:             
  2185:                 !
  2186:                 ! MPI
  2187:                 !
  2188:                 ! 種別型パラメタ
  2189:                 ! Kind type parameter
  2190:                 !
  2191:                 use dc_types, only: &
  2192:                   & STDOUT, &             ! 標準出力の装置番号. Unit number of standard output
  2193:                   & STRING                ! 文字列.       Strings. 
  2194:             
  2195:                 ! ファイル入出力補助
  2196:                 ! File I/O support
  2197:                 !
  2198:                 use dc_iounit, only: FileOpen
  2199:             
  2200:                 ! NAMELIST ファイル入力に関するユーティリティ
  2201:                 ! Utilities for NAMELIST file input
  2202:                 !
  2203:                 use namelist_util, only: namelist_filename, NmlutilMsg
  2204:             
  2205:                 use mpi_wrapper   , only : myrank, nprocs
  2206:             
  2207:                 ! ヒストリデータ出力
  2208:                 ! History data output
  2209:                 !
  2210:                 use gtool_historyauto, only: HistoryAutoAddVariable
  2211:             
  2212:                 ! 組成に関わる配列の設定
  2213:                 ! Settings of array for atmospheric composition
  2214:                 !
  2215:                 use composition, only:                              &
  2216:                   &                    ncmax
  2217:                                          ! 成分の数
  2218:                                          ! Number of composition
  2219:             
  2220:                 ! 座標データ設定
  2221:                 ! Axes data settings
  2222:                 !
  2223:                 use axesset, only: &
  2224:                   & r_Sigma, &
  2225:                                           ! $ \sigma $ レベル (半整数).
  2226:                                           ! Half $ \sigma $ level
  2227:                   & z_Sigma, &            ! $ \sigma $ レベル (整数).
  2228:                                           ! Full $ \sigma $ level
  2229:                   & x_Lon, y_Lat, &
  2230:                   & AxNameX, AxNameY, AxNameZ, AxNameT
  2231:             
  2232:                 use constants0, only : PI
  2233:             
  2234:                 ! 雪と海氷の定数の設定
  2235:                 ! Setting constants of snow and sea ice
  2236:                 !
  2237:                 use constants_snowseaice, only: &
  2238:                   & ConstantsSnowSeaIceInit
  2239:             
  2240:                 !
  2241:                 ! Slab ocean sea ice utility module
  2242:                 !
  2243:                 use sosi_utils, only : SOSIUtilsInit
  2244:             
  2245:                 use sltt_const , only : SLTTConstInit
  2246:                 use sosi_dynamics_extarr, only : SLTTExtArrInit
  2247:             
  2248:             
  2249:                 use sltt_const , only : iexmin, iexmax, jexmin, jexmax
  2250:             
  2251:             
  2252:             
  2253:                 logical, intent(in ) :: ArgFlagSlabOcean
  2254:             
  2255:             
  2256:                 !
  2257:                 ! local variables
  2258:                 !
  2259:                 integer:: i               ! 東西方向に回る DO ループ用作業変数
  2260:                                           ! Work variables for DO loop in zonal direction
  2261:                 integer:: j               ! 南北方向に回る DO ループ用作業変数
  2262:                                           ! Work variables for DO loop in meridional direction
  2263:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  2264:                                           ! Work variables for DO loop in vertical direction
  2265:                 integer:: n
  2266:             
  2267:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  2268:                                           ! Unit number for NAMELIST file open
  2269:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  2270:                                           ! IOSTAT of NAMELIST read
  2271:                 ! NAMELIST 変数群
  2272:                 ! NAMELIST group name
  2273:                 !
  2274:                 namelist /sosi_dynamics_nml/ &
  2275:                   & SOSeaIceDiffCoef
  2276:             
  2277:             
  2278:                 ! 実行文 ; Executable statement
  2279:                 !
  2280:             
  2281:                 if ( sosi_dynamics_inited ) return
  2282:             
  2283:             
  2284:             
  2285:                 FlagSlabOcean = ArgFlagSlabOcean
  2286:             
  2287:             
  2288:                 if ( mod( jmax, 2 ) /= 0 ) then
  2289:                   stop 'jmax cannot be divided by 2.'
  2290:                 end if
  2291:             
  2292:             
  2293:                 ! Initialization of modules used in this module
  2294:                 !
  2295:             
  2296:                 ! 雪と海氷の定数の設定
  2297:                 ! Setting constants of snow and sea ice
  2298:                 !
  2299:                 call ConstantsSnowSeaIceInit
  2300:             
  2301:                 !
  2302:                 ! Slab ocean sea ice utility module
  2303:                 !
  2304:                 call SOSIUtilsInit
  2305:             
  2306:             
  2307:                 call SLTTConstInit
  2308:             
  2309:             
  2310:                 ! デフォルト値の設定
  2311:                 ! Default values settings
  2312:                 !
  2313:                 SOSeaIceDiffCoef              =  0.0e0_DP
  2314:             
  2315:             
  2316:                 ! NAMELIST の読み込み
  2317:                 ! NAMELIST is input
  2318:                 !
  2319:                 if ( trim(namelist_filename) /= '' ) then
  2320:                   call FileOpen( unit_nml, &          ! (out)
  2321:                     & namelist_filename, mode = 'r' ) ! (in)
  2322:             
  2323:                   rewind( unit_nml )
  2324:                   read( unit_nml, &               ! (in)
  2325:                     & nml = sosi_dynamics_nml, &  ! (out)
  2326:                     & iostat = iostat_nml )       ! (out)
  2327:                   close( unit_nml )
  2328:             
  2329:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2330:                   if ( iostat_nml == 0 ) write( STDOUT, nml = sosi_dynamics_nml )
  2331:                 end if
  2332:             
  2333:             
  2334:                 allocate( y_CosLat(1:jmax) )
  2335: V====== A       y_CosLat = cos( y_Lat )
  2336:             
  2337:                 allocate( x_LonS   (0:imax-1) )
  2338:                 allocate( x_SinLonS(0:imax-1) )
  2339:                 allocate( x_CosLonS(0:imax-1) )
  2340:                 allocate( y_latS   (1:jmax/2) )
  2341:                 allocate( y_SinLatS(1:jmax/2) )
  2342:                 allocate( y_CosLatS(1:jmax/2) )
  2343: V------>        do i = 0, imax-1
  2344: |       A         x_LonS   (i) = x_Lon(i)
  2345: |       A         x_SinLonS(i) = sin( x_LonS(i) )
  2346: |       A         x_CosLonS(i) = cos( x_LonS(i) )
  2347: V------         end do
  2348: V------>        do j = 1, jmax/2
  2349: |       A         y_LatS   (j) = y_Lat(j)
  2350: |       A         y_SinLatS(j) = sin( y_LatS(j) )
  2351: |       A         y_CosLatS(j) = cos( y_LatS(j) )
  2352: V------         end do
  2353:             
  2354:                 allocate( x_LonN   (0:imax-1) )
  2355:                 allocate( x_SinLonN(0:imax-1) )
  2356:                 allocate( x_CosLonN(0:imax-1) )
  2357:                 allocate( y_latN   (1:jmax/2) )
  2358:                 allocate( y_SinLatN(1:jmax/2) )
  2359:                 allocate( y_CosLatN(1:jmax/2) )
  2360: V------>        do i = 0, imax-1
  2361: |       A         x_LonN   (i) = x_Lon(i)
  2362: |       A         x_SinLonN(i) = sin( x_LonN(i) )
  2363: |       A         x_CosLonN(i) = cos( x_LonN(i) )
  2364: V------         end do
  2365: V------>        do j = 1, jmax/2
  2366: |       A         y_LatN   (j) = y_Lat(j+jmax/2)
  2367: |       A         y_SinLatN(j) = sin( y_LatN(j) )
  2368: |       A         y_CosLatN(j) = cos( y_LatN(j) )
  2369: V------         end do
  2370:             
  2371:                 allocate( x_ExtLonS( iexmin:iexmax ) )
  2372:                 allocate( x_ExtLonN( iexmin:iexmax ) )
  2373:             
  2374:                 allocate( y_ExtLatS( jexmin:jexmax ) )
  2375:                 allocate( y_ExtLatN( jexmin:jexmax ) )
  2376:             
  2377:                 allocate( y_ExtCosLatS( jexmin:jexmax ) )
  2378:                 allocate( y_ExtCosLatN( jexmin:jexmax ) )
  2379:             
  2380:             
  2381:                 call SLTTExtArrInit(                            &
  2382:                   & x_LonS, y_LatS, x_LonN, y_LatN,             & ! (in )
  2383:                   & x_ExtLonS, y_ExtLatS, x_ExtLonN, y_ExtLatN  & ! (out)
  2384:                   & )
  2385:             
  2386: V====== A       y_ExtCosLatS = cos( y_ExtLatS )
  2387: V====== A       y_ExtCosLatN = cos( y_ExtLatN )
  2388:             
  2389:                 allocate( p_LonS   (0-1:imax-1+1) )
  2390:                 allocate( q_LatS   (1-1:jmax/2+1) )
  2391:                 allocate( q_CosLatS(1-1:jmax/2+1) )
  2392:                 allocate( p_LonN   (0-1:imax-1+1) )
  2393:                 allocate( q_LatN   (1-1:jmax/2+1) )
  2394:                 allocate( q_CosLatN(1-1:jmax/2+1) )
  2395:             
  2396:             
  2397: V------>        do i = 0-1, imax-1+1
  2398: |       A         p_LonS(i) = ( x_ExtLonS(i) + x_ExtLonS(i+1) ) / 2.0_DP
  2399: |       A         p_LonN(i) = ( x_ExtLonN(i) + x_ExtLonN(i+1) ) / 2.0_DP
  2400: V------         end do
  2401: V------>        do j = 1-1, jmax/2+1
  2402: |       A         q_LatS(j) = ( y_ExtLatS(j) + y_ExtLatS(j+1) ) / 2.0_DP
  2403: |               end do
  2404: |               do j = 1-1, jmax/2+1
  2405: |                 q_LatN(j) = ( y_ExtLatN(j) + y_ExtLatN(j+1) ) / 2.0_DP
  2406: V------         end do
  2407:                 if ( myrank == nprocs-1 ) then
  2408:                   j = 0
  2409:                   q_LatS(j) = - PI / 2.0_DP
  2410:                   j = jmax/2+1
  2411:                   q_LatN(j) =   PI / 2.0_DP
  2412:                 end if
  2413:             
  2414: V====== A       q_CosLatS = cos( q_LatS )
  2415: V====== A       q_CosLatN = cos( q_LatN )
  2416:             
  2417:             
  2418:             
  2419:                 ! ヒストリデータ出力のためのへの変数登録
  2420:                 ! Register of variables for history data output
  2421:                 !
  2422:             !!$    do n = 1, ncmax
  2423:             !!$      call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtHorMassFix', &
  2424:             !!$        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  2425:             !!$        & 'tendency of horizontal mass fix of '//trim(a_QMixName(n)), 's-1' )
  2426:             !!$      call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtVerMassFix', &
  2427:             !!$        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  2428:             !!$        & 'tendency of vertical mass fix of '//trim(a_QMixName(n)), 's-1' )
  2429:             !!$      call HistoryAutoAddVariable( 'SLD'//trim(a_QMixName(n))//'DtTotMassFix', &
  2430:             !!$        & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
  2431:             !!$        & 'tendency of mass fix of '//trim(a_QMixName(n)), 's-1' )
  2432:             !!$    end do
  2433:             
  2434:             
  2435:                 ! 印字 ; Print
  2436:                 !
  2437:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2438:                 call MessageNotify( 'M', module_name, '  SOSeaIceDiffCoef              = %f', d = (/ SOSeaIceDiffCoef /) )
  2439:             !!$    call MessageNotify( 'M', module_name, '  FlagSLTTArcsineVer       = %b', l = (/ FlagSLTTArcsineVer /) )
  2440:             !!$    call MessageNotify( 'M', module_name, '  SLTTArcsineFactor        = %f', d = (/ SLTTArcsineFactor /) )
  2441:             !!$    call MessageNotify( 'M', module_name, '  SLTTIntHor               = %c', c1 = trim( SLTTIntHor ) )
  2442:             !!$    call MessageNotify( 'M', module_name, '  SLTTIntVer               = %c', c1 = trim( SLTTIntVer ) )
  2443:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2444:             
  2445:                 sosi_dynamics_inited = .true.
  2446:             
  2447:               end subroutine SOSIDynamicsInit
  2448:             
  2449:               !--------------------------------------------------------------------------------------
  2450:             
  2451:             end module sosi_dynamics
