Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:49 2016
FILE NAME: ludecomp_module.f90
PROGRAM NAME: ludecomp_module
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

    79  opt  (1593): Loop nest collapsed into one loop.
    79  vec  (   1): Vectorized loop.
    86  opt  (1592): Outer loop unrolled inside inner loop.
    87  vec  (   1): Vectorized loop.
    87  vec  (   1): Vectorized loop.
    94  vec  (   1): Vectorized loop.
    94  vec  (  29): ADB is used for array.: ratio
    94  vec  (  29): ADB is used for array.: mat
    95  opt  (1036): Potential feedback - use directive if OK.
    98  opt  (1592): Outer loop unrolled inside inner loop.
    99  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
    99  vec  (   1): Vectorized loop.
    99  vec  (  29): ADB is used for array.: mat
    99  vec  (  29): ADB is used for array.: ratio
    99  vec  (   1): Vectorized loop.
    99  vec  (  29): ADB is used for array.: mat
    99  vec  (  29): ADB is used for array.: ratio
   100  opt  (1036): Potential feedback - use directive if OK.
   104  vec  (   1): Vectorized loop.
   104  vec  (  29): ADB is used for array.: ratio
   115  opt  (1592): Outer loop unrolled inside inner loop.
   116  vec  (   1): Vectorized loop.
   116  vec  (  29): ADB is used for array.: mat
   116  vec  (   1): Vectorized loop.
   116  vec  (  29): ADB is used for array.: mat
   145  vec  (   1): Vectorized loop.
   145  vec  (  29): ADB is used for array.: tmp
   148  opt  (1592): Outer loop unrolled inside inner loop.
   149  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   149  vec  (   1): Vectorized loop.
   149  vec  (  29): ADB is used for array.: tmp
   149  vec  (  29): ADB is used for array.: vec
   149  vec  (  29): ADB is used for array.: mat
   149  vec  (   1): Vectorized loop.
   149  vec  (  29): ADB is used for array.: tmp
   149  vec  (  29): ADB is used for array.: vec
   149  vec  (  29): ADB is used for array.: mat
   150  opt  (1036): Potential feedback - use directive if OK.
   153  vec  (   1): Vectorized loop.
   153  vec  (  29): ADB is used for array.: vec
   153  vec  (  29): ADB is used for array.: tmp
   160  vec  (   1): Vectorized loop.
   160  vec  (  29): ADB is used for array.: tmp
   163  opt  (1592): Outer loop unrolled inside inner loop.
   164  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   164  vec  (   1): Vectorized loop.
   164  vec  (  29): ADB is used for array.: tmp
   164  vec  (  29): ADB is used for array.: vec
   164  vec  (  29): ADB is used for array.: mat
   164  vec  (   1): Vectorized loop.
   164  vec  (  29): ADB is used for array.: tmp
   164  vec  (  29): ADB is used for array.: vec
   164  vec  (  29): ADB is used for array.: mat
   165  opt  (1036): Potential feedback - use directive if OK.
   168  vec  (   1): Vectorized loop.
   168  vec  (  29): ADB is used for array.: vec
   168  vec  (  29): ADB is used for array.: mat
   168  vec  (  29): ADB is used for array.: tmp
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:49 2016
FILE NAME: ludecomp_module.f90
PROGRAM NAME: ludecomp_module
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !******************************************************************************
     2  ! subroutine ludecomp
     3  !******************************************************************************
     4  !     Arrangement of array elements
     5  !----------------------------------------------------------------------
     6  !  A x = b
     7  !          a(1,1)  a(1,2)  a(1,3)  a(1,4) ...  a(1,n)  |   x(1)  |   b(1)
     8  !          a(2,1)  a(2,2)  a(2,3)  a(2,4) ...  a(2,n)  |   x(2)  |   b(2)
     9  !          a(3,1)  a(3,2)  a(3,3)  a(3,4) ...  a(3,n)  |   x(3)  |   b(3)
    10  !          a(4,1)  a(4,2)  a(4,3)  a(4,4) ...  a(4,n)  |   x(4)  |   b(4)
    11  !          a(5,1)  a(5,2)  a(5,3)  a(5,4) ...  a(5,n)  |   x(5)  |   b(5)
    12  !          ...     ...     ...     ...    ...  ...     |   ...   |   ...
    13  !          a(n,1)  a(n,2)  a(n,3)  a(n,4) ...  a(n,n)  |   x(n)  |   b(n)
    14  !----------------------------------------------------------------------
    15  !  A = L * U
    16  !          a(1,1)  a(1,2)  a(1,3)  a(1,4) ...  a(1,n)
    17  !          a(2,1)  a(2,2)  a(2,3)  a(2,4) ...  a(2,n)
    18  !          a(3,1)  a(3,2)  a(3,3)  a(3,4) ...  a(3,n)
    19  !          a(4,1)  a(4,2)  a(4,3)  a(4,4) ...  a(4,n)
    20  !          a(5,1)  a(5,2)  a(5,3)  a(5,4) ...  a(5,n)
    21  !          ...     ...     ...     ...    ...  ...
    22  !          a(n,1)  a(n,2)  a(n,3)  a(n,4) ...  a(n,n)
    23  !----------------------------------------------------------------------
    24  !  matrix L
    25  !          1       0       0       0      ...  0
    26  !          a(2,1)  1       0       0      ...  0
    27  !          a(3,1)  a(3,2)  1       0      ...  0
    28  !          a(4,1)  a(4,2)  a(4,3)  1      ...  0
    29  !          a(5,1)  a(5,2)  a(5,3)  a(5,4) ...  0
    30  !          ...     ...     ...     ...    ...  ...
    31  !          a(n,1)  a(n,2)  a(n,3)  a(n,4) ...  a(n,n)
    32  !----------------------------------------------------------------------
    33  !  matrix L
    34  !          a(1,1)  a(1,2)  a(1,3)  a(1,4) ...  a(1,n)
    35  !          0       a(2,2)  a(2,3)  a(2,4) ...  a(2,n)
    36  !          0       0       a(3,3)  a(3,4) ...  a(3,n)
    37  !          0       0       0       a(4,4) ...  a(4,n)
    38  !          0       0       0       0      ...  a(5,n)
    39  !          ...     ...     ...     ...    ...  ...
    40  !          0       0       0       0      ...  a(n,n)
    41  !******************************************************************************
    42  
    43  module ludecomp_module
    44  
    45    ! モジュール引用 ; USE statements
    46    !
    47    ! 種別型パラメタ
    48    ! Kind type parameter
    49    !
    50    use dc_types, only: DP,  & ! 倍精度実数型. Double precision.
    51      &                 TOKEN  ! キーワード.   Keywords.
    52  
    53    implicit none
    54  
    55    private
    56  
    57    public :: ludecomp_prep_simple_many
    58    public :: ludecomp_solve_simple_many
    59  
    60  contains
    61  
    62    !**************************************************************************************
    63  
    64    subroutine ludecomp_prep_simple_many( mm, nn, mat, ms, me )
    65  
    66      integer , intent(in   ) :: mm, nn
    67      real(DP), intent(inout) :: mat( mm, nn, nn )
    68      integer , intent(in   ) :: ms, me
    69  
    70  
    71      !
    72      ! local variables
    73      !
    74      real(DP) :: lmat( ms:me, nn, nn )
    75      real(DP) :: ratio( ms:me )
    76      integer  :: i, j, k, m
    77  
    78  
    79      do j = 1, nn
    80         do i = 1, nn
    81            do m = ms, me
    82               lmat( m, i, j ) = 0.0d0
    83            end do
    84         end do
    85      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, nn*(nn - nn*(ms - me))                                  
     .           lmat(ms+j-1,1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
    86      do i = 1, nn
    87         do m = ms, me
    88            lmat( m, i, i ) = 1.0d0
    89         end do
    90      end do
     .        if (nn .gt. 0) then                                               
     .           j1 = and(nn,3)                                                 
     .           do i = 1, j1                                                   
     .  !cdir       nodep                                                       
     .              do m = 1, me + 1 - ms                                       
     .                 lmat(ms+m-1,i,i) = 1.00000000000000e+000                 
     .              enddo                                                       
     .           enddo                                                          
     .           do i = j1 + 1, nn, 4                                           
     .  !cdir       nodep                                                       
     .              do m = 1, me + 1 - ms                                       
     .                 lmat(ms+m-1,i,i) = 1.00000000000000e+000                 
     .                 lmat(ms+m-1,1+i,1+i) = 1.00000000000000e+000             
     .                 lmat(ms+m-1,2+i,2+i) = 1.00000000000000e+000             
     .                 lmat(ms+m-1,3+i,3+i) = 1.00000000000000e+000             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
    91  
    92      do k = 1, nn-1
    93         do i = k+1, nn
    94            do m = ms, me
     .  !cdir nodep                                                             
     .  !cdir on_adb(mat,ratio)                                                 
     .        do m = ms, me                                                     
    95               ratio( m ) = mat( m, i, k ) / mat( m, k, k )
    96            end do
    97  
    98            do j = 1, nn
    99               do m = ms, me
   100                  mat( m, i, j ) = mat( m, i, j ) - mat( m, k, j ) * ratio( m )
   101               end do
   102            end do
     .  !cdir    noassume                                                       
     .        do m1 = 0, me - ms, maxvl()                                       
     .           m2 = min0(me + 1 - ms - m1,maxvl())                            
     .           if (nn .gt. 0) then                                            
     .              j4 = and(nn,3)                                              
     .              do j = 1, j4                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(mat,ratio)                                        
     .                 do m = 1, m2                                             
     .                    mat(m1+ms+m-1,i,j) = mat(m1+ms+m-1,i,j) - mat(m1+ms+m-
     .       1               1,k,j)*ratio(m1+ms+m-1)                            
     .                 enddo                                                    
     .              enddo                                                       
     .              do j = j4 + 1, nn, 4                                        
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(mat,ratio)                                        
     .                 do m = 1, m2                                             
     .                    d1 = ratio(m1+ms+m-1)                                 
     .                    mat(m1+ms+m-1,i,j) = mat(m1+ms+m-1,i,j) - mat(m1+ms+m-
     .       1               1,k,j)*d1                                          
     .                    mat(m1+ms+m-1,i,j+1) = mat(m1+ms+m-1,i,j+1) - mat(m1+ 
     .       1               ms+m-1,k,j+1)*d1                                   
     .                    mat(m1+ms+m-1,i,j+2) = mat(m1+ms+m-1,i,j+2) - mat(m1+ 
     .       1               ms+m-1,k,j+2)*d1                                   
     .                    mat(m1+ms+m-1,i,j+3) = mat(m1+ms+m-1,i,j+3) - mat(m1+ 
     .       1               ms+m-1,k,j+3)*d1                                   
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   103  
   104            do m = ms, me
     .  !cdir nodep                                                             
     .  !cdir on_adb(ratio)                                                     
     .        do m = ms, me                                                     
   105               lmat( m, i, k ) = ratio( m )
   106            end do
   107         end do
   108  
   109      end do
   110  
   111      !
   112      ! assemble into 1 matrix
   113      !
   114      do j = 1, nn
   115         do i = j+1, nn
   116            do m = ms, me
   117               mat( m, i, j ) = lmat( m, i, j )
   118            end do
   119         end do
     .           if (nn - j .gt. 0) then                                        
     .           j5 = and(nn - j,3)                                             
     .           do i = 1, j5                                                   
     .  !cdir       nodep                                                       
     .              do m = 1, me + 1 - ms                                       
     .                 mat(ms+m-1,i+j,j) = lmat(ms+m-1,i+j,j)                   
     .              enddo                                                       
     .           enddo                                                          
     .           do i = j5 + 1, nn - j, 4                                       
     .  !cdir       nodep                                                       
     .              do m = 1, me + 1 - ms                                       
     .                 mat(ms+m-1,i+j,j) = lmat(ms+m-1,i+j,j)                   
     .                 mat(ms+m-1,i+1+j,j) = lmat(ms+m-1,i+1+j,j)               
     .                 mat(ms+m-1,i+2+j,j) = lmat(ms+m-1,i+2+j,j)               
     .                 mat(ms+m-1,i+3+j,j) = lmat(ms+m-1,i+3+j,j)               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   120      end do
   121  
   122  
   123    end subroutine ludecomp_prep_simple_many
   124  
   125    !**************************************************************************************
   126  
   127    subroutine ludecomp_solve_simple_many( mm, nn, mat, vec, ms, me )
   128  
   129      integer , intent(in   ) :: mm, nn
   130      real(DP), intent(in   ) :: mat( mm, nn, nn )
   131      real(DP), intent(inout) :: vec( mm, nn )
   132      integer , intent(in   ) :: ms, me
   133  
   134  
   135      !
   136      ! local variables
   137      !
   138      real(DP) :: tmp( ms:me )
   139      integer  :: i, j, m
   140  
   141  
   142      ! solve matrix
   143  
   144      do i = 1+1, nn
   145         do m = ms, me
     .  !cdir nodep                                                             
     .  !cdir on_adb(tmp)                                                       
     .        do m = ms, me                                                     
   146            tmp( m ) = 0.0d0
   147         end do
   148         do j = 1, i-1
   149            do m = ms, me
   150               tmp( m ) = tmp( m ) + mat( m, i, j ) * vec( m, j )
   151            end do
   152         end do
     .  !cdir    noassume                                                       
     .        do m1 = 0, me - ms, maxvl()                                       
     .           m2 = min0(me + 1 - ms - m1,maxvl())                            
     .           if (i - 1 .gt. 0) then                                         
     .              j3 = and(i - 1,3)                                           
     .              do j = 1, j3                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(tmp,vec)                                          
     .                 do m = 1, m2                                             
     .                    tmp(m1+ms+m-1) = tmp(m1+ms+m-1) + mat(m1+ms+m-1,i,j)* 
     .       1               vec(m1+ms+m-1,j)                                   
     .                 enddo                                                    
     .              enddo                                                       
     .              do j = j3 + 1, i - 1, 4                                     
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(tmp,vec)                                          
     .                 do m = 1, m2                                             
     .                    tmp(m1+ms+m-1) = tmp(m1+ms+m-1) + mat(m1+ms+m-1,i,j)* 
     .       1               vec(m1+ms+m-1,j) + mat(m1+ms+m-1,i,j+1)*vec(m1+ms+m
     .       2               -1,j+1) + mat(m1+ms+m-1,i,j+2)*vec(m1+ms+m-1,j+2)  
     .       3                + mat(m1+ms+m-1,i,j+3)*vec(m1+ms+m-1,j+3)         
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   153         do m = ms, me
     .  !cdir nodep                                                             
     .  !cdir on_adb(tmp,vec)                                                   
     .        do m = ms, me                                                     
   154            vec( m, i ) = vec( m, i ) - tmp( m )
   155         end do
   156      end do
   157  
   158  
   159      do i = nn, 1, -1
   160         do m = ms, me
     .  !cdir    nodep                                                          
     .  !cdir on_adb(tmp)                                                       
     .        do m = ms, me                                                     
   161            tmp( m ) = 0.0d0
   162         end do
   163         do j = i+1, nn
   164            do m = ms, me
   165               tmp( m ) = tmp( m ) + mat( m, i, j ) * vec( m, j )
   166            end do
   167         end do
     .  !cdir    noassume                                                       
     .        do m3 = 0, me - ms, maxvl()                                       
     .           m4 = min0(me + 1 - ms - m3,maxvl())                            
     .           if (nn - i .gt. 0) then                                        
     .              j6 = and(nn - i,3)                                          
     .              do j = 1, j6                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(tmp,vec)                                          
     .                 do m = 1, m4                                             
     .                    tmp(m3+ms+m-1) = tmp(m3+ms+m-1) + mat(m3+ms+m-1,i,j+i)
     .       1               *vec(m3+ms+m-1,j+i)                                
     .                 enddo                                                    
     .              enddo                                                       
     .              do j = j6 + 1, nn - i, 4                                    
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(tmp)                                              
     .                 do m = 1, m4                                             
     .                    tmp(m3+ms+m-1) = tmp(m3+ms+m-1) + mat(m3+ms+m-1,i,j+i)
     .       1               *vec(m3+ms+m-1,j+i) + mat(m3+ms+m-1,i,j+1+i)*vec(m3
     .       2               +ms+m-1,j+1+i) + mat(m3+ms+m-1,i,j+2+i)*vec(m3+ms+m
     .       3               -1,j+2+i) + mat(m3+ms+m-1,i,j+3+i)*vec(m3+ms+m-1,j+
     .       4               3+i)                                               
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   168         do m = ms, me
     .  !cdir nodep                                                             
     .  !cdir on_adb(tmp,vec)                                                   
     .        do m = ms, me                                                     
   169            vec( m, i ) = ( vec( m, i ) - tmp( m ) ) / mat( m, i, i )
   170         end do
   171      end do
   172  
   173  
   174  
   175    end subroutine ludecomp_solve_simple_many
   176  
   177    !**************************************************************************************
   178  
   179  end module ludecomp_module
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:49 2016
FILE NAME: ludecomp_module.f90
PROGRAM NAME: ludecomp_module
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             !******************************************************************************
     2:             ! subroutine ludecomp
     3:             !******************************************************************************
     4:             !     Arrangement of array elements
     5:             !----------------------------------------------------------------------
     6:             !  A x = b
     7:             !          a(1,1)  a(1,2)  a(1,3)  a(1,4) ...  a(1,n)  |   x(1)  |   b(1)
     8:             !          a(2,1)  a(2,2)  a(2,3)  a(2,4) ...  a(2,n)  |   x(2)  |   b(2)
     9:             !          a(3,1)  a(3,2)  a(3,3)  a(3,4) ...  a(3,n)  |   x(3)  |   b(3)
    10:             !          a(4,1)  a(4,2)  a(4,3)  a(4,4) ...  a(4,n)  |   x(4)  |   b(4)
    11:             !          a(5,1)  a(5,2)  a(5,3)  a(5,4) ...  a(5,n)  |   x(5)  |   b(5)
    12:             !          ...     ...     ...     ...    ...  ...     |   ...   |   ...
    13:             !          a(n,1)  a(n,2)  a(n,3)  a(n,4) ...  a(n,n)  |   x(n)  |   b(n)
    14:             !----------------------------------------------------------------------
    15:             !  A = L * U
    16:             !          a(1,1)  a(1,2)  a(1,3)  a(1,4) ...  a(1,n)
    17:             !          a(2,1)  a(2,2)  a(2,3)  a(2,4) ...  a(2,n)
    18:             !          a(3,1)  a(3,2)  a(3,3)  a(3,4) ...  a(3,n)
    19:             !          a(4,1)  a(4,2)  a(4,3)  a(4,4) ...  a(4,n)
    20:             !          a(5,1)  a(5,2)  a(5,3)  a(5,4) ...  a(5,n)
    21:             !          ...     ...     ...     ...    ...  ...
    22:             !          a(n,1)  a(n,2)  a(n,3)  a(n,4) ...  a(n,n)
    23:             !----------------------------------------------------------------------
    24:             !  matrix L
    25:             !          1       0       0       0      ...  0
    26:             !          a(2,1)  1       0       0      ...  0
    27:             !          a(3,1)  a(3,2)  1       0      ...  0
    28:             !          a(4,1)  a(4,2)  a(4,3)  1      ...  0
    29:             !          a(5,1)  a(5,2)  a(5,3)  a(5,4) ...  0
    30:             !          ...     ...     ...     ...    ...  ...
    31:             !          a(n,1)  a(n,2)  a(n,3)  a(n,4) ...  a(n,n)
    32:             !----------------------------------------------------------------------
    33:             !  matrix L
    34:             !          a(1,1)  a(1,2)  a(1,3)  a(1,4) ...  a(1,n)
    35:             !          0       a(2,2)  a(2,3)  a(2,4) ...  a(2,n)
    36:             !          0       0       a(3,3)  a(3,4) ...  a(3,n)
    37:             !          0       0       0       a(4,4) ...  a(4,n)
    38:             !          0       0       0       0      ...  a(5,n)
    39:             !          ...     ...     ...     ...    ...  ...
    40:             !          0       0       0       0      ...  a(n,n)
    41:             !******************************************************************************
    42:             
    43:             module ludecomp_module
    44:             
    45:               ! モジュール引用 ; USE statements
    46:               !
    47:               ! 種別型パラメタ
    48:               ! Kind type parameter
    49:               !
    50:               use dc_types, only: DP,  & ! 倍精度実数型. Double precision.
    51:                 &                 TOKEN  ! キーワード.   Keywords. 
    52:             
    53:               implicit none
    54:             
    55:               private
    56:             
    57:               public :: ludecomp_prep_simple_many
    58:               public :: ludecomp_solve_simple_many
    59:             
    60:             contains
    61:             
    62:               !**************************************************************************************
    63:             
    64:               subroutine ludecomp_prep_simple_many( mm, nn, mat, ms, me )
    65:             
    66:                 integer , intent(in   ) :: mm, nn
    67:                 real(DP), intent(inout) :: mat( mm, nn, nn )
    68:                 integer , intent(in   ) :: ms, me
    69:             
    70:             
    71:                 !
    72:                 ! local variables
    73:                 !
    74:                 real(DP) :: lmat( ms:me, nn, nn )
    75:                 real(DP) :: ratio( ms:me )
    76:                 integer  :: i, j, k, m
    77:             
    78:             
    79: W------>        do j = 1, nn
    80: |*----->           do i = 1, nn
    81: ||*---->              do m = ms, me
    82: |||                      lmat( m, i, j ) = 0.0d0
    83: ||*----               end do
    84: |*-----            end do
    85: W------         end do
    86: +------>        do i = 1, nn
    87: |V----->           do m = ms, me
    88: ||                    lmat( m, i, i ) = 1.0d0
    89: |V-----            end do
    90: +------         end do
    91:             
    92: +------>        do k = 1, nn-1
    93: |+----->           do i = k+1, nn
    94: ||V---->              do m = ms, me
    95: |||     A                ratio( m ) = mat( m, i, k ) / mat( m, k, k )
    96: ||V----               end do
    97: ||          
    98: ||+---->              do j = 1, nn
    99: |||V--->A                do m = ms, me
   100: ||||    A                   mat( m, i, j ) = mat( m, i, j ) - mat( m, k, j ) * ratio( m )
   101: |||V---                  end do
   102: ||+----               end do
   103: ||          
   104: ||V---->              do m = ms, me
   105: |||     A                lmat( m, i, k ) = ratio( m )
   106: ||V----               end do
   107: |+-----            end do
   108: |           
   109: +------         end do
   110:             
   111:                 !
   112:                 ! assemble into 1 matrix
   113:                 !
   114: +------>        do j = 1, nn
   115: |+----->           do i = j+1, nn
   116: ||V---->              do m = ms, me
   117: |||     A                mat( m, i, j ) = lmat( m, i, j )
   118: ||V----               end do
   119: |+-----            end do
   120: +------         end do
   121:             
   122:             
   123:               end subroutine ludecomp_prep_simple_many
   124:             
   125:               !**************************************************************************************
   126:             
   127:               subroutine ludecomp_solve_simple_many( mm, nn, mat, vec, ms, me )
   128:             
   129:                 integer , intent(in   ) :: mm, nn
   130:                 real(DP), intent(in   ) :: mat( mm, nn, nn )
   131:                 real(DP), intent(inout) :: vec( mm, nn )
   132:                 integer , intent(in   ) :: ms, me
   133:             
   134:             
   135:                 !
   136:                 ! local variables
   137:                 !
   138:                 real(DP) :: tmp( ms:me )
   139:                 integer  :: i, j, m
   140:             
   141:             
   142:                 ! solve matrix
   143:             
   144: +------>        do i = 1+1, nn
   145: |V----->           do m = ms, me
   146: ||      A             tmp( m ) = 0.0d0
   147: |V-----            end do
   148: |+----->           do j = 1, i-1
   149: ||V---->              do m = ms, me
   150: |||     A                tmp( m ) = tmp( m ) + mat( m, i, j ) * vec( m, j )
   151: ||V----               end do
   152: |+-----            end do
   153: |V----->           do m = ms, me
   154: ||      A             vec( m, i ) = vec( m, i ) - tmp( m )
   155: |V-----            end do
   156: +------         end do
   157:             
   158:             
   159: +------>        do i = nn, 1, -1
   160: |V----->           do m = ms, me
   161: ||      A             tmp( m ) = 0.0d0
   162: |V-----            end do
   163: |+----->           do j = i+1, nn
   164: ||V---->              do m = ms, me
   165: |||     A                tmp( m ) = tmp( m ) + mat( m, i, j ) * vec( m, j )
   166: ||V----               end do
   167: |+-----            end do
   168: |V----->           do m = ms, me
   169: ||      A             vec( m, i ) = ( vec( m, i ) - tmp( m ) ) / mat( m, i, i )
   170: |V-----            end do
   171: +------         end do
   172:             
   173:             
   174:             
   175:               end subroutine ludecomp_solve_simple_many
   176:             
   177:               !**************************************************************************************
   178:             
   179:             end module ludecomp_module
