Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:44 2016
FILE NAME: lb_flux_simple.f90
PROGRAM NAME: lb_flux_simple
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   289  opt  (1592): Outer loop unrolled inside inner loop.
   289  vec  (   4): Vectorized array expression.
   289  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   289  vec  (   4): Vectorized array expression.
   289  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   294  vec  (   3): Unvectorized loop.
   294  vec  (  13): Overhead of loop division is too large.
   296  vec  (   4): Vectorized array expression.
   296  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   296  vec  (  29): ADB is used for array.: xyr_press
   300  vec  (   4): Vectorized array expression.
   300  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   307  opt  (1592): Outer loop unrolled inside inner loop.
   307  vec  (   4): Vectorized array expression.
   307  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   307  vec  (   4): Vectorized array expression.
   307  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   309  opt  (1593): Loop nest collapsed into one loop.
   309  vec  (   4): Vectorized array expression.
   309  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   309  vec  (  29): ADB is used for array.: xy_surfheight
   309  vec  (  29): ADB is used for array.: xyz_height
   309  vec  (  29): ADB is used for array.: xyr_virtemp
   309  vec  (  29): ADB is used for array.: xyr_press
   317  opt  (1592): Outer loop unrolled inside inner loop.
   317  vec  (   4): Vectorized array expression.
   317  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   317  vec  (   4): Vectorized array expression.
   317  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   319  opt  (1593): Loop nest collapsed into one loop.
   319  vec  (   4): Vectorized array expression.
   319  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   319  vec  (  29): ADB is used for array.: xy_surfheight
   319  vec  (  29): ADB is used for array.: xyz_height
   319  vec  (  29): ADB is used for array.: xyr_virtemp
   319  vec  (  29): ADB is used for array.: xyr_press
   331  opt  (  11): Fused array assignments. :line 331 - 332
   331  opt  (1593): Loop nest collapsed into one loop.
   331  vec  (   4): Vectorized array expression.
   331  vec  (  29): ADB is used for array.: xyr_momfluxy
   331  vec  (  29): ADB is used for array.: xyz_v
   331  vec  (  29): ADB is used for array.: xyr_momfluxx
   331  vec  (  29): ADB is used for array.: xyz_u
   331  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   338  opt  (1592): Outer loop unrolled inside inner loop.
   338  vec  (   4): Vectorized array expression.
   338  vec  (  29): ADB is used for array.: xyr_heatflux
   338  vec  (   4): Vectorized array expression.
   338  vec  (  29): ADB is used for array.: xyr_heatflux
   340  opt  (  11): Fused array assignments. :line 340 - 341
   340  opt  (1593): Loop nest collapsed into one loop.
   340  vec  (   4): Vectorized array expression.
   340  vec  (  29): ADB is used for array.: xyr_heatflux
   340  vec  (  29): ADB is used for array.: xyz_exner
   340  vec  (  29): ADB is used for array.: xyz_temp
   340  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   340  vec  (  29): ADB is used for array.: xyr_exner
   350  opt  (1592): Outer loop unrolled inside inner loop.
   350  vec  (   4): Vectorized array expression.
   350  vec  (  29): ADB is used for array.: xyrf_qmixflux
   350  vec  (   4): Vectorized array expression.
   350  vec  (  29): ADB is used for array.: xyrf_qmixflux
   352  opt  (  11): Fused array assignments. :line 352 - 353
   352  opt  (1593): Loop nest collapsed into one loop.
   352  vec  (   4): Vectorized array expression.
   352  vec  (  29): ADB is used for array.: xyrf_qmixflux
   352  vec  (  29): ADB is used for array.: xyzf_qmix
   352  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   358  opt  (1593): Loop nest collapsed into one loop.
   358  vec  (   4): Vectorized array expression.
   358  vec  (  29): ADB is used for array.: xyrf_qmixflux
   359  opt  (1593): Loop nest collapsed into one loop.
   359  vec  (   4): Vectorized array expression.
   359  vec  (  29): ADB is used for array.: xyrf_qmixflux
   374  warn (  82): Name "n" is not used.
   561  opt  (1593): Loop nest collapsed into one loop.
   561  vec  (   1): Vectorized loop.
   561  vec  (  29): ADB is used for array.: xyr_heatfluxcor
   561  vec  (  29): ADB is used for array.: xy_dsurftempdt
   561  vec  (  29): ADB is used for array.: xyz_exner
   561  vec  (  29): ADB is used for array.: xyz_dtempdt
   561  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   561  vec  (  29): ADB is used for array.: xyr_exner
   561  vec  (  29): ADB is used for array.: xyr_heatflux
   561  vec  (  29): ADB is used for array.: xyr_momfluxycor
   561  vec  (  29): ADB is used for array.: xyz_dvdt
   561  vec  (  29): ADB is used for array.: xyr_momfluxy
   561  vec  (  29): ADB is used for array.: xyr_momfluxxcor
   561  vec  (  29): ADB is used for array.: xyz_dudt
   561  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   561  vec  (  29): ADB is used for array.: xyr_momfluxx
   577  opt  (1592): Outer loop unrolled inside inner loop.
   578  vec  (   1): Vectorized loop.
   578  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   578  vec  (  29): ADB is used for array.: xy_dsurftempdt
   578  vec  (  29): ADB is used for array.: xy_surfdqvapsatdtemp
   578  vec  (  29): ADB is used for array.: xyzf_dqmixdt
   578  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   578  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   578  vec  (  29): ADB is used for array.: xyrf_qmixflux
   578  vec  (   1): Vectorized loop.
   578  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   578  vec  (  29): ADB is used for array.: xy_dsurftempdt
   578  vec  (  29): ADB is used for array.: xy_surfdqvapsatdtemp
   578  vec  (  29): ADB is used for array.: xyzf_dqmixdt
   578  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   578  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   578  vec  (  29): ADB is used for array.: xyrf_qmixflux
   585  vec  (   3): Unvectorized loop.
   585  vec  (  13): Overhead of loop division is too large.
   586  opt  (1593): Loop nest collapsed into one loop.
   586  vec  (   4): Vectorized array expression.
   586  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   586  vec  (  29): ADB is used for array.: xyrf_qmixflux
   588  vec  (   3): Unvectorized loop.
   588  vec  (  13): Overhead of loop division is too large.
   589  opt  (1593): Loop nest collapsed into one loop.
   589  vec  (   4): Vectorized array expression.
   589  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   589  vec  (  29): ADB is used for array.: xyrf_qmixflux
   592  opt  (1593): Loop nest collapsed into one loop.
   592  vec  (   1): Vectorized loop.
   592  vec  (  29): ADB is used for array.: xyr_latentheatfluxcor
   592  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   615  opt  (1593): Loop nest collapsed into one loop.
   615  vec  (   1): Vectorized loop.
   615  vec  (  29): ADB is used for array.: xyr_heatfluxcor
   615  vec  (  29): ADB is used for array.: xyr_heatflux
   615  vec  (  29): ADB is used for array.: xyr_momfluxycor
   615  vec  (  29): ADB is used for array.: xyr_momfluxy
   615  vec  (  29): ADB is used for array.: xyr_momfluxxcor
   615  vec  (  29): ADB is used for array.: xyr_momfluxx
   623  opt  (1593): Loop nest collapsed into one loop.
   623  vec  (   1): Vectorized loop.
   623  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   623  vec  (  29): ADB is used for array.: xyrf_qmixflux
   628  vec  (   3): Unvectorized loop.
   628  vec  (  13): Overhead of loop division is too large.
   629  opt  (1593): Loop nest collapsed into one loop.
   629  vec  (   4): Vectorized array expression.
   629  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   629  vec  (  29): ADB is used for array.: xyrf_qmixflux
   631  vec  (   3): Unvectorized loop.
   631  vec  (  13): Overhead of loop division is too large.
   632  opt  (1593): Loop nest collapsed into one loop.
   632  vec  (   4): Vectorized array expression.
   632  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   632  vec  (  29): ADB is used for array.: xyrf_qmixflux
   635  opt  (1593): Loop nest collapsed into one loop.
   635  vec  (   1): Vectorized loop.
   635  vec  (  29): ADB is used for array.: xyr_latentheatfluxcor
   635  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   657  opt  (1593): Loop nest collapsed into one loop.
   657  vec  (   1): Vectorized loop.
   657  vec  (  29): ADB is used for array.: xyr_heatfluxcor
   657  vec  (  29): ADB is used for array.: xy_dsurftempdt
   657  vec  (  29): ADB is used for array.: xyz_exner
   657  vec  (  29): ADB is used for array.: xyz_dtempdt
   657  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   657  vec  (  29): ADB is used for array.: xyr_exner
   657  vec  (  29): ADB is used for array.: xyr_heatflux
   657  vec  (  29): ADB is used for array.: xyr_momfluxycor
   657  vec  (  29): ADB is used for array.: xyz_dvdt
   657  vec  (  29): ADB is used for array.: xyr_momfluxy
   657  vec  (  29): ADB is used for array.: xyr_momfluxxcor
   657  vec  (  29): ADB is used for array.: xyz_dudt
   657  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   657  vec  (  29): ADB is used for array.: xyr_momfluxx
   673  opt  (1592): Outer loop unrolled inside inner loop.
   674  vec  (   1): Vectorized loop.
   674  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   674  vec  (  29): ADB is used for array.: xy_dsurftempdt
   674  vec  (  29): ADB is used for array.: xy_surfdqvapsatdtemp
   674  vec  (  29): ADB is used for array.: xyzf_dqmixdt
   674  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   674  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   674  vec  (  29): ADB is used for array.: xyrf_qmixflux
   674  vec  (   1): Vectorized loop.
   674  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   674  vec  (  29): ADB is used for array.: xy_dsurftempdt
   674  vec  (  29): ADB is used for array.: xy_surfdqvapsatdtemp
   674  vec  (  29): ADB is used for array.: xyzf_dqmixdt
   674  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   674  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   674  vec  (  29): ADB is used for array.: xyrf_qmixflux
   681  vec  (   3): Unvectorized loop.
   681  vec  (  13): Overhead of loop division is too large.
   682  opt  (1593): Loop nest collapsed into one loop.
   682  vec  (   4): Vectorized array expression.
   682  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   682  vec  (  29): ADB is used for array.: xyrf_qmixflux
   684  vec  (   3): Unvectorized loop.
   684  vec  (  13): Overhead of loop division is too large.
   685  opt  (1593): Loop nest collapsed into one loop.
   685  vec  (   4): Vectorized array expression.
   685  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
   685  vec  (  29): ADB is used for array.: xyrf_qmixflux
   688  opt  (1593): Loop nest collapsed into one loop.
   688  vec  (   1): Vectorized loop.
   688  vec  (  29): ADB is used for array.: xyr_latentheatfluxcor
   688  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:44 2016
FILE NAME: lb_flux_simple.f90
PROGRAM NAME: lb_flux_simple
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 下部境界フラックス
     2  !
     3  != Lower boundary flux
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: lb_flux_simple.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module lb_flux_simple
    13    !
    14    != 下部境界フラックス
    15    !
    16    != Lower boundary flux
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    !
    23    !
    24    !== References
    25    !
    26  !!$  ! Louis, J-F., M. Tiedtke, and J-F. Geleyn,
    27  !!$  ! A short history of the PBL parameterization at ECMWF,
    28  !!$  ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K.,
    29  !!$  ! 1982.
    30    !
    31    !== Procedures List
    32    !
    33  !!$  ! SurfaceFlux       :: 地表面フラックスの計算
    34  !!$  ! SurfaceFluxOutput :: 地表面フラックスの出力
    35  !!$  ! ------------      :: ------------
    36  !!$  ! SurfaceFlux       :: Calculate surface fluxes
    37  !!$  ! SurfaceFluxOutput :: Output surface fluxes
    38    !
    39    !== NAMELIST
    40    !
    41    ! NAMELIST#lb_flux_simple_nml
    42    !
    43  
    44    ! モジュール引用 ; USE statements
    45    !
    46  
    47    ! 格子点設定
    48    ! Grid points settings
    49    !
    50    use gridset, only: imax, & ! 経度格子点数.
    51                               ! Number of grid points in longitude
    52      &                jmax, & ! 緯度格子点数.
    53                               ! Number of grid points in latitude
    54      &                kmax    ! 鉛直層数.
    55                               ! Number of vertical level
    56  
    57    ! 組成に関わる配列の設定
    58    ! Settings of array for atmospheric composition
    59    !
    60    use composition, only: ncmax, IndexH2OVap
    61  
    62    ! 種別型パラメタ
    63    ! Kind type parameter
    64    !
    65    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    66      &                 STRING, &  ! 文字列.       Strings.
    67      &                 TOKEN      ! キーワード.   Keywords.
    68  
    69    ! メッセージ出力
    70    ! Message output
    71    !
    72    use dc_message, only: MessageNotify
    73  
    74    ! 宣言文 ; Declaration statements
    75    !
    76    implicit none
    77    private
    78  
    79    ! 公開手続き
    80    ! Public procedure
    81    !
    82    public :: LBFluxSimple
    83    public :: LBFluxSimpleInit
    84  !!$  public :: SurfaceFluxOutput
    85  
    86    ! 公開変数
    87    ! Public variables
    88    !
    89  
    90    ! 非公開変数
    91    ! Private variables
    92    !
    93    logical, save :: lb_flux_simple_inited = .false.
    94                                ! 初期設定フラグ.
    95                                ! Initialization flag
    96  
    97    integer, save      :: IDLBMomFluxMode
    98    integer, parameter :: IDLBMomFluxModeNoFlux       = 10
    99    integer, parameter :: IDLBMomFluxModeFixTimeConst = 11
   100    integer, save      :: IDLBHeatFluxMode
   101    integer, parameter :: IDLBHeatFluxModeFixFlux     = 20
   102    integer, parameter :: IDLBHeatFluxModeFixTemp     = 21
   103    integer, save      :: IDLBH2OVapFluxMode
   104    integer, parameter :: IDLBH2OVapFluxModeFixFlux   = 30
   105    integer, parameter :: IDLBH2OVapFluxModeFixMixRt  = 31
   106  
   107  
   108    real(DP), save:: FricTimeConstAtLB
   109                              ! 下部境界摩擦の係数 (s).
   110                              ! Time constant of surface friction (s).
   111    real(DP), save:: FricLowestLatAtLB
   112                              ! 下部境界摩擦が働く最低緯度 (degree).
   113                              ! Lowest latitude where the friction is applied (degree)
   114    real(DP), save:: HeatFluxAtLB
   115                              ! 下部境界での熱フラックス (W m-2).
   116                              ! Heat flux at the lower boundary (W m-2).
   117    real(DP), save:: TempAtLB
   118    real(DP), save:: H2OVapFluxAtLB
   119                              ! 下部境界での H2O 蒸気質量フラックス (W m-2).
   120                              ! 実際にはゼロに固定するために使う程度にしか使えないだろう.
   121                              ! H2O vapor flux at the lower boundary (kg m-2 s-1).
   122    real(DP), save:: QH2OVapAtLB
   123    real(DP), save:: DiffCoefHeatMass
   124  
   125  
   126    character(*), parameter:: module_name = 'lb_flux_simple'
   127                                ! モジュールの名称.
   128                                ! Module name
   129    character(*), parameter:: version = &
   130      & '$Name:  $' // &
   131      & '$Id: lb_flux_simple.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $'
   132                                ! モジュールのバージョン
   133                                ! Module version
   134  
   135  
   136  contains
   137  
   138    !--------------------------------------------------------------------------------------
   139  
   140    subroutine LBFluxSimple( &
   141      & xyz_U, xyz_V, xyz_Temp, xyr_VirTemp, xyzf_QMix,             & ! (in)
   142      & xyr_Press, xy_SurfHeight, xyz_Height, xyz_Exner, xyr_Exner, & ! (in)
   143      & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,    & ! (out)
   144      & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                  & ! (out)
   145      & xy_SurfQVapTransCoef                                        & ! (out)
   146      & )
   147      !
   148      ! 温度, 比湿, 気圧から, 放射フラックスを計算します.
   149      !
   150      ! Calculate radiation flux from temperature, specific humidity, and
   151      ! air pressure.
   152      !
   153  
   154      ! モジュール引用 ; USE statements
   155      !
   156  
   157      ! 物理・数学定数設定
   158      ! Physical and mathematical constants settings
   159      !
   160      use constants0, only: &
   161        & PI
   162                                ! $ \pi $ .
   163                                ! 円周率.  Circular constant
   164  
   165      ! 物理定数設定
   166      ! Physical constants settings
   167      !
   168      use constants, only: &
   169        & Grav, &               ! $ g $ [m s-2].
   170                                ! 重力加速度.
   171                                ! Gravitational acceleration
   172        & GasRDry, &
   173                                ! $ R $ [J kg-1 K-1].
   174                                ! 乾燥大気の気体定数.
   175                                ! Gas constant of air
   176        & CpDry
   177                                ! $ C_p $ [J kg-1 K-1].
   178                                ! 乾燥大気の定圧比熱.
   179                                ! Specific heat of air at constant pressure
   180  
   181      ! 飽和比湿の算出
   182      ! Evaluate saturation specific humidity
   183      !
   184      use saturate, only: xy_CalcQVapSat
   185  
   186      ! 座標データ設定
   187      ! Axes data settings
   188      !
   189      use axesset, only: &
   190        & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   191  
   192      ! 時刻管理
   193      ! Time control
   194      !
   195      use timeset, only: &
   196        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   197        & TimesetClockStart, TimesetClockStop
   198  
   199      ! デバッグ用ユーティリティ
   200      ! Utilities for debug
   201      !
   202      use dc_trace, only: DbgMessage, BeginSub, EndSub
   203  
   204      ! 宣言文 ; Declaration statements
   205      !
   206  
   207      real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   208                                ! $ u $ . 東西風速. Eastward wind
   209      real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   210                                ! $ v $ . 南北風速. Northward wind
   211  
   212      real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   213                                ! $ T $ . 温度 (整数レベル).
   214                                ! Temperature (full level)
   215      real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   216                                ! $ T_v $ . 仮温度 (半整数レベル).
   217                                ! Virtual temperature (half level)
   218      real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   219                                ! $ q $ .     比湿. Specific humidity
   220      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   221                                ! $ p_s $ . 地表面気圧 (半整数レベル).
   222                                ! Surface pressure (half level)
   223      real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
   224                                ! $ z_s $ . 地表面高度.
   225                                ! Surface height.
   226      real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   227                                ! 高度 (整数レベル).
   228                                ! Height (full level)
   229      real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   230                                ! Exner 関数 (整数レベル).
   231                                ! Exner function (full level)
   232      real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   233                                ! Exner 関数 (半整数レベル).
   234                                ! Exner function (half level)
   235      real(DP), intent(out):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:0)
   236                                ! 東西方向運動量フラックス.
   237                                ! Eastward momentum flux
   238      real(DP), intent(out):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:0)
   239                                ! 南北方向運動量フラックス.
   240                                ! Northward momentum flux
   241      real(DP), intent(out):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:0)
   242                                ! 熱フラックス.
   243                                ! Heat flux
   244      real(DP), intent(out):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:0, 1:ncmax)
   245                                ! 比湿フラックス.
   246                                ! Specific humidity flux
   247      real(DP), intent(out):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   248                                ! 輸送係数：運動量.
   249                                ! Diffusion coefficient: velocity
   250      real(DP), intent(out):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   251                                ! 輸送係数：温度.
   252                                ! Transfer coefficient: temperature
   253      real(DP), intent(out):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   254                                ! 輸送係数：水蒸気
   255                                ! Transfer coefficient: water vapor
   256  
   257      ! 作業変数
   258      ! Work variables
   259      !
   260      real(DP) :: xy_TempAtLB   (0:imax-1, 1:jmax)
   261      real(DP) :: xy_QH2OVapAtLB(0:imax-1, 1:jmax)
   262  
   263      integer:: j
   264      integer:: n               ! 組成方向に回る DO ループ用作業変数
   265                                ! Work variables for DO loop in dimension of constituents
   266  
   267      ! 実行文 ; Executable statement
   268      !
   269  
   270      ! 初期化確認
   271      ! Initialization check
   272      !
   273      if ( .not. lb_flux_simple_inited ) then
   274        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   275      end if
   276  
   277  
   278      ! 計算時間計測開始
   279      ! Start measurement of computation time
   280      !
   281      call TimesetClockStart( module_name )
   282  
   283  
   284      ! 輸送係数の計算
   285      ! Calculate transfer coefficient
   286      !
   287      select case ( IDLBMomFluxMode )
   288      case ( IDLBMomFluxModeNoFlux )
   289        xy_SurfVelTransCoef = 0.0_DP
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t523 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t525 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surfveltranscoef(t525-1,t523) =                       
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t523 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t525 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surfveltranscoef(t525-1,t523) =                       
     .       1            0.0000000000000000e+000                               
     .                 xy_surfveltranscoef(t525-1,t523+1) =                     
     .       1            0.0000000000000000e+000                               
     .                 xy_surfveltranscoef(t525-1,t523+2) =                     
     .       1            0.0000000000000000e+000                               
     .                 xy_surfveltranscoef(t525-1,t523+3) =                     
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10004                                                        
   290      case ( IDLBMomFluxModeFixTimeConst )
   291        if ( FricTimeConstAtLB <= 0.0_DP ) then
   292          call MessageNotify( 'E', module_name, 'FricTimeConstAtLB must be greater than or equal to zero.' )
   293        end if
   294        do j = 1, jmax
   295          if ( abs( y_Lat(j) ) >= FricLowestLatAtLB * PI / 180.0_DP ) then
   296            xy_SurfVelTransCoef(:,j) =                           &
     .        d1 = 1.D0/grav                                                    
     .        d2 = d1/frictimeconstatlb                                         
     .  !cdir nodep                                                             
     .        do t518 = 1, imax                                                 
     .           xy_surfveltranscoef(t518-1,j) = -(xyr_press(t518-1,j,1)-       
     .       1      xyr_press(t518-1,j,0))*d2                                   
     .        enddo                                                             
     .        goto 10094                                                        
   297              & - ( xyr_Press(:,j,1) - xyr_Press(:,j,0) ) / Grav &
   298              &   / FricTimeConstAtLB
   299          else
   300            xy_SurfVelTransCoef(:,j) = 0.0_DP
   301          end if
   302        end do
   303      end select
   304  
   305      select case ( IDLBHeatFluxMode )
   306      case ( IDLBHeatFluxModeFixFlux )
   307        xy_SurfTempTransCoef = HeatFluxAtLB
     .           if (jmax .gt. 0) then                                          
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t509 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t511 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemptranscoef(t511-1,t509) = heatfluxatlb         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t509 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t511 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemptranscoef(t511-1,t509) = heatfluxatlb         
     .                 xy_surftemptranscoef(t511-1,t509+1) = heatfluxatlb       
     .                 xy_surftemptranscoef(t511-1,t509+2) = heatfluxatlb       
     .                 xy_surftemptranscoef(t511-1,t509+3) = heatfluxatlb       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10006                                                        
   308      case ( IDLBHeatFluxModeFixTemp )
   309        xy_SurfTempTransCoef =                                    &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t495 = 1, jmax*imax                                            
     .           xy_surftemptranscoef(t495-1,1) = xyr_press(t495-1,1,0)/(gasrdry
     .       1      *xyr_virtemp(t495-1,1,0))*diffcoefheatmass/(xyz_height(t495-
     .       2      1,1,1)-xy_surfheight(t495-1,1))                             
     .        enddo                                                             
   310          &   xyr_Press(:,:,0) / ( GasRDry * xyr_VirTemp(:,:,0) ) &
   311          & * DiffCoefHeatMass                                    &
   312          & / ( xyz_Height(:,:,1) - xy_SurfHeight )
   313      end select
   314  
   315      select case( IDLBH2OVapFluxMode )
   316      case ( IDLBH2OVapFluxModeFixFlux )
   317        xy_SurfQVapTransCoef = H2OVapFluxAtLB
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t489 = 1, j3                                                
     .  !cdir       nodep                                                       
     .              do t491 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surfqvaptranscoef(t491-1,t489) = h2ovapfluxatlb       
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t489 = j3 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t491 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surfqvaptranscoef(t491-1,t489) = h2ovapfluxatlb       
     .                 xy_surfqvaptranscoef(t491-1,t489+1) = h2ovapfluxatlb     
     .                 xy_surfqvaptranscoef(t491-1,t489+2) = h2ovapfluxatlb     
     .                 xy_surfqvaptranscoef(t491-1,t489+3) = h2ovapfluxatlb     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10008                                                        
   318      case ( IDLBH2OVapFluxModeFixMixRt )
   319        xy_SurfQVapTransCoef =                                    &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t475 = 1, jmax*imax                                            
     .           xy_surfqvaptranscoef(t475-1,1) = xyr_press(t475-1,1,0)/(gasrdry
     .       1      *xyr_virtemp(t475-1,1,0))*diffcoefheatmass/(xyz_height(t475-
     .       2      1,1,1)-xy_surfheight(t475-1,1))                             
     .        enddo                                                             
   320          &   xyr_Press(:,:,0) / ( GasRDry * xyr_VirTemp(:,:,0) ) &
   321          & * DiffCoefHeatMass                                    &
   322          & / ( xyz_Height(:,:,1) - xy_SurfHeight )
   323      end select
   324  
   325  
   326      ! 下部境界フラックスの計算
   327      ! Calculate fluxes at lower boundary
   328      !
   329      !   Momentum
   330      !
   331      xyr_MomFluxX(:,:,0) = - xy_SurfVelTransCoef * xyz_U(:,:,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t392 = 1, jmax*imax                                            
     .           xyr_momfluxx(t392-1,1,0) = -xy_surfveltranscoef(t392-1,1)*xyz_u
     .       1      (t392-1,1,1)                                                
     .           xyr_momfluxy(t392-1,1,0) = -xy_surfveltranscoef(t392-1,1)*xyz_v
     .       1      (t392-1,1,1)                                                
     .        enddo                                                             
   332      xyr_MomFluxY(:,:,0) = - xy_SurfVelTransCoef * xyz_V(:,:,1)
   333  
   334      !   Heat
   335      !
   336      select case ( IDLBHeatFluxMode )
   337      case ( IDLBHeatFluxModeFixFlux )
   338        xyr_HeatFlux = HeatFluxAtLB
     .        if (1 + jmax - min0(1,jmax) .gt. 0) then                          
     .           j4 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t468 = 1, j4                                                
     .  !cdir       nodep                                                       
     .              do t470 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_heatflux(t470-1,t468,0) = heatfluxatlb               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t468 = j4 + 1, 1 + jmax - min0(1,jmax), 4                   
     .  !cdir       nodep                                                       
     .              do t470 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_heatflux(t470-1,t468,0) = heatfluxatlb               
     .                 xyr_heatflux(t470-1,t468+1,0) = heatfluxatlb             
     .                 xyr_heatflux(t470-1,t468+2,0) = heatfluxatlb             
     .                 xyr_heatflux(t470-1,t468+3,0) = heatfluxatlb             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10016                                                        
   339      case ( IDLBHeatFluxModeFixTemp )
   340        xy_TempAtLB = TempAtLB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t446 = 1, xy_tempatlb.DSC.U2*xy_tempatlb.DSC.U1 +              
     .       1   xy_tempatlb.DSC.U2                                             
     .           xy_tempatlb1 = tempatlb                                        
     .           xyr_heatflux(t446-1,1,0) = -cpdry*xyr_exner(t446-1,1,0)*       
     .       1      xy_surftemptranscoef(t446-1,1)*(xyz_temp(t446-1,1,1)/       
     .       2      xyz_exner(t446-1,1,1)-xy_tempatlb1/xyr_exner(t446-1,1,0))   
     .        enddo                                                             
   341        xyr_HeatFlux(:,:,0) = - CpDry * xyr_Exner(:,:,0) * xy_SurfTempTransCoef &
   342          &                       * (   xyz_Temp(:,:,1) / xyz_Exner(:,:,1)      &
   343          &                           - xy_TempAtLB     / xyr_Exner(:,:,0) )
   344      end select
   345  
   346      !   Mass
   347      !
   348      select case( IDLBH2OVapFluxMode )
   349      case ( IDLBH2OVapFluxModeFixFlux )
   350        xyrf_QMixFlux(:,:,0,IndexH2OVap) = H2OVapFluxAtLB
     .        if (jmax .gt. 0) then                                             
     .           j5 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t440 = 1, j5                                                
     .  !cdir       nodep                                                       
     .              do t442 = 1, 1 + imax - min0(1,imax)                        
     .                 xyrf_qmixflux(t442-1,t440,0,indexh2ovap) = h2ovapfluxatlb
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t440 = j5 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t442 = 1, 1 + imax - min0(1,imax)                        
     .                 xyrf_qmixflux(t442-1,t440,0,indexh2ovap) = h2ovapfluxatlb
     .                 xyrf_qmixflux(t442-1,t440+1,0,indexh2ovap) =             
     .       1            h2ovapfluxatlb                                        
     .                 xyrf_qmixflux(t442-1,t440+2,0,indexh2ovap) =             
     .       1            h2ovapfluxatlb                                        
     .                 xyrf_qmixflux(t442-1,t440+3,0,indexh2ovap) =             
     .       1            h2ovapfluxatlb                                        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10018                                                        
   351      case ( IDLBH2OVapFluxModeFixMixRt )
   352        xy_QH2OVapAtLB = QH2OVapAtLB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t426 = 1, xy_qh2ovapatlb.DSC.U2*xy_qh2ovapatlb.DSC.U1 +        
     .       1   xy_qh2ovapatlb.DSC.U2                                          
     .           xy_qh2ovapatlb1 = qh2ovapatlb                                  
     .           xyrf_qmixflux(t426-1,1,0,indexh2ovap) = -xy_surfqvaptranscoef( 
     .       1      t426-1,1)*(xyzf_qmix(t426-1,1,1,indexh2ovap)-xy_qh2ovapatlb1
     .       2      )                                                           
     .        enddo                                                             
   353        xyrf_QMixFlux(:,:,0,IndexH2OVap) =                      &
   354          & - xy_SurfQVapTransCoef                              &
   355          & * ( xyzf_QMix(:,:,1,IndexH2OVap) - xy_QH2OVapAtLB )
   356      end select
   357      !
   358      xyrf_QMixFlux(:,:,0,1:IndexH2OVap-1)     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t410 = 1, jmax*imax                                            
     .           xyrf_qmixflux(t410-1,1,0,t408+1) = 0.0000000000000000e+000     
     .        enddo                                                             
   359      xyrf_QMixFlux(:,:,0,IndexH2OVap+1:ncmax) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t419 = 1, jmax*imax                                            
     .           xyrf_qmixflux(t419-1,1,0,t417+indexh2ovap+1) =                 
     .       1      0.0000000000000000e+000                                     
     .        enddo                                                             
   360  
   361      ! Surface flux of constituents except for water vapor is zero.
   362  !!$    write( 6, * ) "MEMO: Surface flux of constituents except for water vapor is zero. (YOT, 2013/05/15)"
   363  
   364  
   365      ! ヒストリデータ出力
   366      ! History data output
   367      !
   368  
   369      ! 計算時間計測一時停止
   370      ! Pause measurement of computation time
   371      !
   372      call TimesetClockStop( module_name )
   373  
   374    end subroutine LBFluxSimple
   375  
   376    !--------------------------------------------------------------------------------------
   377  
   378    subroutine SurfaceFluxOutput(                                &
   379      & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
   380      & xy_SurfH2OVapFluxA, xy_SurfLatentHeatFluxA,              & ! (in)
   381      & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt,           & ! (in)
   382      & xy_SurfTemp, xy_DSurfTempDt,                             & ! (in)
   383      & xyr_Press, xyz_Exner, xyr_Exner, xy_SurfHumidCoef,       & ! (in)
   384      & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
   385      & xy_SurfQVapTransCoef                                     & ! (in)
   386      & )
   387      !
   388      ! フラックス (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux).
   389      ! について, その他の引数を用いて補正し, 出力を行う.
   390      !
   391      ! Fluxes (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux) are
   392      ! corrected by using other arguments, and the corrected values are output.
   393      !
   394  
   395      ! モジュール引用 ; USE statements
   396      !
   397  
   398      ! 物理定数設定
   399      ! Physical constant settings
   400      !
   401      use constants, only: &
   402        & GasRDry, &
   403                                ! $ R $ [J kg-1 K-1].
   404                                ! 乾燥大気の気体定数.
   405                                ! Gas constant of air
   406        & CpDry, &
   407                                ! $ C_p $ [J kg-1 K-1].
   408                                ! 乾燥大気の定圧比熱.
   409                                ! Specific heat of air at constant pressure
   410        & LatentHeat
   411                                ! $ L $ [J kg-1] .
   412                                ! 凝結の潜熱.
   413                                ! Latent heat of condensation
   414  
   415      ! 飽和比湿の算出
   416      ! Evaluation of saturation specific humidity
   417      !
   418      use saturate, only: xy_CalcQVapSat, xy_CalcDQVapSatDTemp
   419  
   420      ! 時刻管理
   421      ! Time control
   422      !
   423      use timeset, only: &
   424        & DelTime, &            ! $ \Delta t $ [s]
   425        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   426        & TimesetClockStart, TimesetClockStop
   427  
   428      ! ヒストリデータ出力
   429      ! History data output
   430      !
   431      use gtool_historyauto, only: HistoryAutoPut
   432  
   433      ! 宣言文 ; Declaration statements
   434      !
   435  
   436      real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
   437                                ! 東西方向運動量フラックス.
   438                                ! Eastward momentum flux
   439      real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
   440                                ! 南北方向運動量フラックス.
   441                                ! Northward momentum flux
   442      real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   443                                ! 熱フラックス.
   444                                ! Heat flux
   445      real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   446                                ! 比湿フラックス.
   447                                ! Specific humidity flux
   448      real(DP), intent(in):: xy_SurfH2OVapFluxA    (0:imax-1, 1:jmax)
   449                                ! 惑星表面水蒸気フラックス.
   450                                ! Water vapor flux at the surface
   451      real(DP), intent(in):: xy_SurfLatentHeatFluxA(0:imax-1, 1:jmax)
   452                                ! 惑星表面潜熱フラックス.
   453                                ! Latent heat flux at the surface
   454      real(DP), intent(in):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   455                                ! $ \DP{u}{t} $ . 東西風速時間変化率.
   456                                ! Eastward wind tendency
   457      real(DP), intent(in):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   458                                ! $ \DP{v}{t} $ . 南北風速時間変化率.
   459                                ! Northward wind tendency
   460      real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   461                                ! $ \DP{T}{t} $ . 温度時間変化率.
   462                                ! Temperature tendency
   463      real(DP), intent(in):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   464                                ! $ \DP{q}{t} $ . 比湿時間変化率.
   465                                ! Specific humidity tendency
   466      real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   467                                ! 地表面温度.
   468                                ! Surface temperature
   469      real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
   470                                ! 地表面温度時間変化率.
   471                                ! Surface temperature tendency
   472      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   473                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   474                                ! Air pressure (half level)
   475      real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   476                                ! Exner 関数 (整数レベル).
   477                                ! Exner function (full level)
   478      real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   479                                ! Exner 関数 (半整数レベル).
   480                                ! Exner function (half level)
   481      real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   482                                ! 地表湿潤度.
   483                                ! Surface humidity coefficient
   484      real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   485                                ! 輸送係数：運動量.
   486                                ! Diffusion coefficient: velocity
   487      real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   488                                ! 輸送係数：温度.
   489                                ! Transfer coefficient: temperature
   490      real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   491                                ! 輸送係数：水蒸気
   492                                ! Transfer coefficient: water vapor
   493  
   494      ! 出力のための作業変数
   495      ! Work variables for output
   496      !
   497      real(DP):: xyr_MomFluxXCor (0:imax-1, 1:jmax, 0:kmax)
   498                                ! 東西方向運動量フラックス.
   499                                ! Eastward momentum flux
   500      real(DP):: xyr_MomFluxYCor (0:imax-1, 1:jmax, 0:kmax)
   501                                ! 南北方向運動量フラックス.
   502                                ! Northward momentum flux
   503      real(DP):: xyr_HeatFluxCor (0:imax-1, 1:jmax, 0:kmax)
   504                                ! 熱フラックス.
   505                                ! Heat flux
   506      real(DP):: xyrf_QMixFluxCor(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   507                                ! 比湿フラックス.
   508                                ! Specific humidity flux
   509      real(DP):: xyr_LatentHeatFluxCor(0:imax-1, 1:jmax, 0:kmax)
   510                                ! 表面潜熱フラックス.
   511                                ! Latent heat flux
   512      real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
   513                                ! 地表飽和比湿.
   514                                ! Saturated specific humidity on surface
   515      real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
   516                                ! 地表飽和比湿変化.
   517                                ! Saturated specific humidity tendency on surface
   518  
   519      ! 作業変数
   520      ! Work variables
   521      !
   522      integer:: i               ! 経度方向に回る DO ループ用作業変数
   523                                ! Work variables for DO loop in longitude
   524      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   525                                ! Work variables for DO loop in latitude
   526      integer:: n               ! 組成方向に回る DO ループ用作業変数
   527                                ! Work variables for DO loop in dimension of constituents
   528  
   529  
   530      ! 実行文 ; Executable statement
   531      !
   532  
   533      ! 初期化確認
   534      ! Initialization check
   535      !
   536      if ( .not. lb_flux_simple_inited ) then
   537        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   538      end if
   539  
   540  
   541      ! 計算時間計測開始
   542      ! Start measurement of computation time
   543      !
   544      call TimesetClockStart( module_name )
   545  
   546  
   547      ! 飽和比湿の計算
   548      ! Calculate saturated specific humidity
   549      !
   550      xy_SurfQVapSat       = &
   551        & xy_CalcQVapSat      ( xy_SurfTemp, xyr_Press(:,:,0) )
   552      xy_SurfDQVapSatDTemp = &
   553        & xy_CalcDQVapSatDTemp( xy_SurfTemp, xy_SurfQVapSat   )
   554  
   555      ! Output of fluxes at t
   556      !
   557  
   558      ! 風速, 温度, 比湿フラックス補正
   559      ! Correct fluxes of wind, temperature, specific humidity
   560      !
   561      do j = 1, jmax
   562        do i = 0, imax-1
   563          xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
   564            & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * DelTime
   565  
   566          xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
   567            & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * DelTime
   568  
   569          xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
   570            & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
   571            &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
   572            &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
   573            &   * DelTime
   574        end do
   575      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_momfluxxcor(j-1,1,0) = xyr_momfluxx(j-1,1,0) - (           
     .       1      xy_surfveltranscoef(j-1,1)*deltime)*xyz_dudt(j-1,1,1)       
     .           xyr_momfluxycor(j-1,1,0) = xyr_momfluxy(j-1,1,0) - (           
     .       1      xy_surfveltranscoef(j-1,1)*deltime)*xyz_dvdt(j-1,1,1)       
     .           xyr_heatfluxcor(j-1,1,0) = xyr_heatflux(j-1,1,0) - cpdry*      
     .       1      xyr_exner(j-1,1,0)*xy_surftemptranscoef(j-1,1)*(xyz_dtempdt(
     .       2      j-1,1,1)/xyz_exner(j-1,1,1)-xy_dsurftempdt(j-1,1)/xyr_exner(
     .       3      j-1,1,0))*deltime                                           
     .        enddo                                                             
   576      n = IndexH2OVap
   577      do j = 1, jmax
   578        do i = 0, imax-1
   579          xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
   580            & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
   581            &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
   582            &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * DelTime
   583        end do
   584      end do
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyrf_qmixfluxcor(i-1,j,0,n) = xyrf_qmixflux(i-1,j,0,n) - 
     .       1            xy_surfhumidcoef(i-1,j)*xy_surfqvaptranscoef(i-1,j)*( 
     .       2            xyzf_dqmixdt(i-1,j,1,n)-xy_surfdqvapsatdtemp(i-1,j)*  
     .       3            xy_dsurftempdt(i-1,j))*deltime                        
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyrf_qmixfluxcor(i-1,j,0,n) = xyrf_qmixflux(i-1,j,0,n) - 
     .       1            xy_surfhumidcoef(i-1,j)*xy_surfqvaptranscoef(i-1,j)*( 
     .       2            xyzf_dqmixdt(i-1,j,1,n)-xy_surfdqvapsatdtemp(i-1,j)*  
     .       3            xy_dsurftempdt(i-1,j))*deltime                        
     .                 xyrf_qmixfluxcor(i-1,j+1,0,n) = xyrf_qmixflux(i-1,j+1,0,n
     .       1            ) - xy_surfhumidcoef(i-1,j+1)*xy_surfqvaptranscoef(i-1
     .       2            ,j+1)*(xyzf_dqmixdt(i-1,j+1,1,n)-xy_surfdqvapsatdtemp(
     .       3            i-1,j+1)*xy_dsurftempdt(i-1,j+1))*deltime             
     .                 xyrf_qmixfluxcor(i-1,j+2,0,n) = xyrf_qmixflux(i-1,j+2,0,n
     .       1            ) - xy_surfhumidcoef(i-1,j+2)*xy_surfqvaptranscoef(i-1
     .       2            ,j+2)*(xyzf_dqmixdt(i-1,j+2,1,n)-xy_surfdqvapsatdtemp(
     .       3            i-1,j+2)*xy_dsurftempdt(i-1,j+2))*deltime             
     .                 xyrf_qmixfluxcor(i-1,j+3,0,n) = xyrf_qmixflux(i-1,j+3,0,n
     .       1            ) - xy_surfhumidcoef(i-1,j+3)*xy_surfqvaptranscoef(i-1
     .       2            ,j+3)*(xyzf_dqmixdt(i-1,j+3,1,n)-xy_surfdqvapsatdtemp(
     .       3            i-1,j+3)*xy_dsurftempdt(i-1,j+3))*deltime             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   585      do n = 1, IndexH2OVap-1
   586        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t969 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +    
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t969-1,1,0,n) = xyrf_qmixflux(t969-1,1,0,n)   
     .        enddo                                                             
   587      end do
   588      do n = IndexH2OVap+1, ncmax
   589        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t977 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +    
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t977-1,1,0,n) = xyrf_qmixflux(t977-1,1,0,n)   
     .        enddo                                                             
   590      end do
   591      n = IndexH2OVap
   592      do j = 1, jmax
   593        do i = 0, imax-1
   594          xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
   595        end do
   596      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_latentheatfluxcor(j-1,1,0) = latentheat*xyrf_qmixfluxcor(j-
     .       1      1,1,0,n)                                                    
     .        enddo                                                             
   597  
   598  
   599      ! ヒストリデータ出力
   600      ! History data output
   601      !
   602      call HistoryAutoPut( TimeN, 'TauX'          , xyr_MomFluxXCor (:,:,0) )
   603      call HistoryAutoPut( TimeN, 'TauY'          , xyr_MomFluxYCor (:,:,0) )
   604      call HistoryAutoPut( TimeN, 'Sens'          , xyr_HeatFluxCor (:,:,0) )
   605      call HistoryAutoPut( TimeN, 'SurfH2OVapFlux', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
   606      call HistoryAutoPut( TimeN, 'Evap'          , xyr_LatentHeatFluxCor(:,:,0) )
   607  
   608  
   609      ! Output of fluxes at t - \Delta t
   610      !
   611  
   612      ! 風速, 温度, 比湿フラックス補正
   613      ! Correct fluxes of wind, temperature, specific humidity
   614      !
   615      do j = 1, jmax
   616        do i = 0, imax-1
   617          xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 )
   618          xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 )
   619          xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )
   620        end do
   621      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_momfluxxcor(j-1,1,0) = xyr_momfluxx(j-1,1,0)               
     .           xyr_momfluxycor(j-1,1,0) = xyr_momfluxy(j-1,1,0)               
     .           xyr_heatfluxcor(j-1,1,0) = xyr_heatflux(j-1,1,0)               
     .        enddo                                                             
   622      n = IndexH2OVap
   623      do j = 1, jmax
   624        do i = 0, imax-1
   625          xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )
   626        end do
   627      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyrf_qmixfluxcor(j-1,1,0,n) = xyrf_qmixflux(j-1,1,0,n)         
     .        enddo                                                             
   628      do n = 1, IndexH2OVap-1
   629        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t985 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +    
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t985-1,1,0,n) = xyrf_qmixflux(t985-1,1,0,n)   
     .        enddo                                                             
   630      end do
   631      do n = IndexH2OVap+1, ncmax
   632        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t993 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +    
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t993-1,1,0,n) = xyrf_qmixflux(t993-1,1,0,n)   
     .        enddo                                                             
   633      end do
   634      n = IndexH2OVap
   635      do j = 1, jmax
   636        do i = 0, imax-1
   637          xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
   638        end do
   639      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_latentheatfluxcor(j-1,1,0) = latentheat*xyrf_qmixfluxcor(j-
     .       1      1,1,0,n)                                                    
     .        enddo                                                             
   640  
   641      ! ヒストリデータ出力
   642      ! History data output
   643      !
   644      call HistoryAutoPut( TimeN, 'TauXB'          , xyr_MomFluxXCor (:,:,0) )
   645      call HistoryAutoPut( TimeN, 'TauYB'          , xyr_MomFluxYCor (:,:,0) )
   646      call HistoryAutoPut( TimeN, 'SensB'          , xyr_HeatFluxCor (:,:,0) )
   647      call HistoryAutoPut( TimeN, 'SurfH2OVapFluxB', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
   648      call HistoryAutoPut( TimeN, 'EvapB'          , xyr_LatentHeatFluxCor(:,:,0) )
   649  
   650  
   651      ! Output of fluxes at t + \Delta t
   652      !
   653  
   654      ! 風速, 温度, 比湿フラックス補正
   655      ! Correct fluxes of wind, temperature, specific humidity
   656      !
   657      do j = 1, jmax
   658        do i = 0, imax-1
   659          xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
   660            & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * 2.0_DP * DelTime
   661  
   662          xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
   663            & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * 2.0_DP * DelTime
   664  
   665          xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
   666            & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
   667            &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
   668            &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
   669            &   * 2.0_DP * DelTime
   670        end do
   671      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_momfluxxcor(j-1,1,0) = xyr_momfluxx(j-1,1,0) - ((          
     .       1      xy_surfveltranscoef(j-1,1)*2.00000000000000e+000)*deltime)* 
     .       2      xyz_dudt(j-1,1,1)                                           
     .           xyr_momfluxycor(j-1,1,0) = xyr_momfluxy(j-1,1,0) - ((          
     .       1      xy_surfveltranscoef(j-1,1)*2.00000000000000e+000)*deltime)* 
     .       2      xyz_dvdt(j-1,1,1)                                           
     .           xyr_heatfluxcor(j-1,1,0) = xyr_heatflux(j-1,1,0) - cpdry*      
     .       1      xyr_exner(j-1,1,0)*xy_surftemptranscoef(j-1,1)*(xyz_dtempdt(
     .       2      j-1,1,1)/xyz_exner(j-1,1,1)-xy_dsurftempdt(j-1,1)/xyr_exner(
     .       3      j-1,1,0))*2.00000000000000e+000*deltime                     
     .        enddo                                                             
   672      n = IndexH2OVap
   673      do j = 1, jmax
   674        do i = 0, imax-1
   675          xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
   676            & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
   677            &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
   678            &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * 2.0_DP * DelTime
   679        end do
   680      end do
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .           do j = 1, j2                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyrf_qmixfluxcor(i-1,j,0,n) = xyrf_qmixflux(i-1,j,0,n) - 
     .       1            xy_surfhumidcoef(i-1,j)*xy_surfqvaptranscoef(i-1,j)*( 
     .       2            xyzf_dqmixdt(i-1,j,1,n)-xy_surfdqvapsatdtemp(i-1,j)*  
     .       3            xy_dsurftempdt(i-1,j))*2.00000000000000e+000*deltime  
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j2 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 xyrf_qmixfluxcor(i-1,j,0,n) = xyrf_qmixflux(i-1,j,0,n) - 
     .       1            xy_surfhumidcoef(i-1,j)*xy_surfqvaptranscoef(i-1,j)*( 
     .       2            xyzf_dqmixdt(i-1,j,1,n)-xy_surfdqvapsatdtemp(i-1,j)*  
     .       3            xy_dsurftempdt(i-1,j))*2.00000000000000e+000*deltime  
     .                 xyrf_qmixfluxcor(i-1,j+1,0,n) = xyrf_qmixflux(i-1,j+1,0,n
     .       1            ) - xy_surfhumidcoef(i-1,j+1)*xy_surfqvaptranscoef(i-1
     .       2            ,j+1)*(xyzf_dqmixdt(i-1,j+1,1,n)-xy_surfdqvapsatdtemp(
     .       3            i-1,j+1)*xy_dsurftempdt(i-1,j+1))*                    
     .       4            2.00000000000000e+000*deltime                         
     .                 xyrf_qmixfluxcor(i-1,j+2,0,n) = xyrf_qmixflux(i-1,j+2,0,n
     .       1            ) - xy_surfhumidcoef(i-1,j+2)*xy_surfqvaptranscoef(i-1
     .       2            ,j+2)*(xyzf_dqmixdt(i-1,j+2,1,n)-xy_surfdqvapsatdtemp(
     .       3            i-1,j+2)*xy_dsurftempdt(i-1,j+2))*                    
     .       4            2.00000000000000e+000*deltime                         
     .                 xyrf_qmixfluxcor(i-1,j+3,0,n) = xyrf_qmixflux(i-1,j+3,0,n
     .       1            ) - xy_surfhumidcoef(i-1,j+3)*xy_surfqvaptranscoef(i-1
     .       2            ,j+3)*(xyzf_dqmixdt(i-1,j+3,1,n)-xy_surfdqvapsatdtemp(
     .       3            i-1,j+3)*xy_dsurftempdt(i-1,j+3))*                    
     .       4            2.00000000000000e+000*deltime                         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   681      do n = 1, IndexH2OVap-1
   682        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1001 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +   
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t1001-1,1,0,n) = xyrf_qmixflux(t1001-1,1,0,n) 
     .        enddo                                                             
   683      end do
   684      do n = IndexH2OVap+1, ncmax
   685        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1009 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +   
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t1009-1,1,0,n) = xyrf_qmixflux(t1009-1,1,0,n) 
     .        enddo                                                             
   686      end do
   687      n = IndexH2OVap
   688      do j = 1, jmax
   689        do i = 0, imax-1
   690          xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
   691        end do
   692      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_latentheatfluxcor(j-1,1,0) = latentheat*xyrf_qmixfluxcor(j-
     .       1      1,1,0,n)                                                    
     .        enddo                                                             
   693  
   694      ! ヒストリデータ出力
   695      ! History data output
   696      !
   697      call HistoryAutoPut( TimeN, 'TauXA'          , xyr_MomFluxXCor (:,:,0) )
   698      call HistoryAutoPut( TimeN, 'TauYA'          , xyr_MomFluxYCor (:,:,0) )
   699      call HistoryAutoPut( TimeN, 'SensA'          , xyr_HeatFluxCor (:,:,0) )
   700      call HistoryAutoPut( TimeN, 'SurfH2OVapFluxA', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
   701      call HistoryAutoPut( TimeN, 'EvapA'          , xyr_LatentHeatFluxCor(:,:,0) )
   702  
   703  
   704      ! ヒストリデータ出力
   705      ! History data output
   706      !
   707      call HistoryAutoPut( TimeN, 'SurfH2OVapFluxU', xy_SurfH2OVapFluxA     )
   708      call HistoryAutoPut( TimeN, 'EvapU'          , xy_SurfLatentHeatFluxA )
   709  
   710  
   711      ! 計算時間計測一時停止
   712      ! Pause measurement of computation time
   713      !
   714      call TimesetClockStop( module_name )
   715  
   716    end subroutine SurfaceFluxOutput
   717  
   718    !--------------------------------------------------------------------------------------
   719  
   720    subroutine LBFluxSimpleInit
   721      !
   722      ! surface_flux_bulk モジュールの初期化を行います.
   723      ! NAMELIST#surface_flux_bulk_nml の読み込みはこの手続きで行われます.
   724      !
   725      ! "surface_flux_bulk" module is initialized.
   726      ! "NAMELIST#surface_flux_bulk_nml" is loaded in this procedure.
   727      !
   728  
   729      ! モジュール引用 ; USE statements
   730      !
   731  
   732      ! NAMELIST ファイル入力に関するユーティリティ
   733      ! Utilities for NAMELIST file input
   734      !
   735      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   736  
   737      ! ファイル入出力補助
   738      ! File I/O support
   739      !
   740      use dc_iounit, only: FileOpen
   741  
   742      ! 種別型パラメタ
   743      ! Kind type parameter
   744      !
   745      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   746  
   747      ! 文字列操作
   748      ! Character handling
   749      !
   750      use dc_string, only: StoA
   751  
   752  
   753      ! 日付および時刻の取り扱い
   754      ! Date and time handler
   755      !
   756      use dc_calendar, only: DCCalConvertByUnit
   757  
   758      ! ヒストリデータ出力
   759      ! History data output
   760      !
   761      use gtool_historyauto, only: HistoryAutoAddVariable
   762  
   763      ! 物理定数設定
   764      ! Physical constant settings
   765      !
   766      use constants, only: &
   767        & GasRDry, &
   768                                ! $ R $ [J kg-1 K-1].
   769                                ! 乾燥大気の気体定数.
   770                                ! Gas constant of air
   771        & CpDry
   772                                ! $ C_p $ [J kg-1 K-1].
   773                                ! 乾燥大気の定圧比熱.
   774                                ! Specific heat of air at constant pressure
   775  
   776      ! 宣言文 ; Declaration statements
   777      !
   778      real(DP)         :: FricTimeConstAtLBValue
   779      character(TOKEN) :: FricTimeConstAtLBUnit
   780  
   781      character(STRING) :: LBMomFluxMode
   782      character(STRING) :: LBHeatFluxMode
   783      character(STRING) :: LBH2OVapFluxMode
   784  
   785      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   786                                ! Unit number for NAMELIST file open
   787      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   788                                ! IOSTAT of NAMELIST read
   789  
   790      ! NAMELIST 変数群
   791      ! NAMELIST group name
   792      !
   793      namelist /lb_flux_simple_nml/                        &
   794        & LBMomFluxMode,                                   &
   795        & FricTimeConstAtLBValue, FricTimeConstAtLBUnit,   &
   796        & FricLowestLatAtLB,                               &
   797        & LBHeatFluxMode,                                  &
   798        & HeatFluxAtLB, TempAtLB,                          &
   799        & LBH2OVapFluxMode,                                &
   800        & H2OVapFluxAtLB, QH2OVapAtLB, DiffCoefHeatMass
   801            !
   802            ! デフォルト値については初期化手続 "lb_flux_simple#LBFluxSimpleInit"
   803            ! のソースコードを参照のこと.
   804            !
   805            ! Refer to source codes in the initialization procedure
   806            ! "lb_flux_simple#LBFluxSimpleInit" for the default values.
   807            !
   808  
   809      ! 実行文 ; Executable statement
   810      !
   811  
   812      if ( lb_flux_simple_inited ) return
   813  
   814  
   815      ! デフォルト値の設定
   816      ! Default values settings
   817      !
   818      LBMomFluxMode            = 'FixTimeConst'
   819      FricTimeConstAtLBValue   = 20.0_DP   ! Schneider and Liou (2009)
   820      FricTimeConstAtLBUnit    = 'day'
   821      FricLowestLatAtLB        = 16.3_DP   ! Schneider and Liou (2009)
   822  
   823      LBHeatFluxMode           = 'FixFlux'
   824      HeatFluxAtLB             =  5.7_DP   ! Schneider and Liou (2009)
   825      TempAtLB                 =  160.0_DP * ( 30.0_DP / 0.6_DP )**( GasRDry / CpDry )
   826                                   ! Sugiyama et al. (2009), Nagare Multimedia
   827                                   ! Potential Temperature of 160 K with
   828                                   ! reference pressure of 0.6 bars
   829  
   830      LBH2OVapFluxMode         = 'FixFlux'
   831      H2OVapFluxAtLB           =  0.0_DP
   832      QH2OVapAtLB              =  7.816e-4_DP
   833                                   ! Sugiyama et al. (2009), Nagare Multimedia
   834      DiffCoefHeatMass         = 800.0_DP
   835                                   ! Sugiyama et al. (2009), Nagare Multimedia
   836  
   837      ! NAMELIST の読み込み
   838      ! NAMELIST is input
   839      !
   840      if ( trim(namelist_filename) /= '' ) then
   841        call FileOpen( unit_nml, &          ! (out)
   842          & namelist_filename, mode = 'r' ) ! (in)
   843  
   844        rewind( unit_nml )
   845        read( unit_nml, &                ! (in)
   846          & nml = lb_flux_simple_nml, &  ! (out)
   847          & iostat = iostat_nml )        ! (out)
   848        close( unit_nml )
   849  
   850        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   851      end if
   852  
   853  
   854      FricTimeConstAtLB = &
   855        & DCCalConvertByUnit( FricTimeConstAtLBValue, FricTimeConstAtLBUnit, 'sec' ) ! (in)
   856  
   857  
   858      ! Identification of calculation method for momentum flux
   859      !
   860      call MessageNotify( 'M', module_name, &
   861        & 'LBMomFluxMode=<%c>.', c1 = trim(LBMomFluxMode) )
   862      select case ( LBMomFluxMode )
   863      case ( 'NoFlux' )
   864        IDLBMomFluxMode = IDLBMomFluxModeNoFlux
   865      case ( 'FixTimeConst' )
   866        IDLBMomFluxMode = IDLBMomFluxModeFixTimeConst
   867      case default
   868        call MessageNotify( 'E', module_name, &
   869          & 'LBMomFluxMode=<%c> is not supported.', c1 = trim(LBMomFluxMode) )
   870      end select
   871  
   872      ! Identification of calculation method for heat flux
   873      !
   874      call MessageNotify( 'M', module_name, &
   875        & 'LBHeatFluxMode=<%c>.', c1 = trim(LBHeatFluxMode) )
   876      select case ( LBHeatFluxMode )
   877      case ( 'FixFlux' )
   878        IDLBHeatFluxMode = IDLBHeatFluxModeFixFlux
   879      case ( 'FixTemp' )
   880        IDLBHeatFluxMode = IDLBHeatFluxModeFixFlux
   881      case default
   882        call MessageNotify( 'E', module_name, &
   883          & 'LBHeatFluxMode=<%c> is not supported.', c1 = trim(LBHeatFluxMode) )
   884      end select
   885  
   886      ! Identification of calculation method for H2O vapor flux
   887      !
   888      call MessageNotify( 'M', module_name, &
   889        & 'LBH2OVapFluxMode=<%c>.', c1 = trim(LBH2OVapFluxMode) )
   890      select case ( LBH2OVapFluxMode )
   891      case ( 'FixFlux' )
   892        IDLBH2OVapFluxMode = IDLBH2OVapFluxModeFixFlux
   893      case ( 'FixMixRt' )
   894        IDLBH2OVapFluxMode = IDLBH2OVapFluxModeFixMixRt
   895      case default
   896        call MessageNotify( 'E', module_name, &
   897          & 'LBH2OVapFluxMode=<%c> is not supported.', c1 = trim(LBH2OVapFluxMode) )
   898      end select
   899  
   900  
   901  
   902      ! ヒストリデータ出力のためのへの変数登録
   903      ! Register of variables for history data output
   904      !
   905      call HistoryAutoAddVariable( 'TauX', &
   906        & (/ 'lon ', 'lat ', 'time' /), &
   907        & 'surface stress(x)  ', 'N m-2' )
   908      call HistoryAutoAddVariable( 'TauY', &
   909        & (/ 'lon ', 'lat ', 'time' /), &
   910        & 'surface stress(y)  ', 'N m-2' )
   911      call HistoryAutoAddVariable( 'Sens', &
   912        & (/ 'lon ', 'lat ', 'time' /), &
   913        & 'sensible heat flux', 'W m-2' )
   914      call HistoryAutoAddVariable( 'SurfH2OVapFlux', &
   915        & (/ 'lon ', 'lat ', 'time' /), &
   916        & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
   917      call HistoryAutoAddVariable( 'Evap', &
   918        & (/ 'lon ', 'lat ', 'time' /), &
   919        & 'latent heat flux  ', 'W m-2' )
   920  
   921      call HistoryAutoAddVariable( 'TauXB', &
   922        & (/ 'lon ', 'lat ', 'time' /), &
   923        & 'surface stress(x)  ', 'N m-2' )
   924      call HistoryAutoAddVariable( 'TauYB', &
   925        & (/ 'lon ', 'lat ', 'time' /), &
   926        & 'surface stress(y)  ', 'N m-2' )
   927      call HistoryAutoAddVariable( 'SensB', &
   928        & (/ 'lon ', 'lat ', 'time' /), &
   929        & 'sensible heat flux', 'W m-2' )
   930      call HistoryAutoAddVariable( 'SurfH2OVapFluxB', &
   931        & (/ 'lon ', 'lat ', 'time' /), &
   932        & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
   933      call HistoryAutoAddVariable( 'EvapB', &
   934        & (/ 'lon ', 'lat ', 'time' /), &
   935        & 'latent heat flux  ', 'W m-2' )
   936  
   937      call HistoryAutoAddVariable( 'TauXA', &
   938        & (/ 'lon ', 'lat ', 'time' /), &
   939        & 'surface stress(x)  ', 'N m-2' )
   940      call HistoryAutoAddVariable( 'TauYA', &
   941        & (/ 'lon ', 'lat ', 'time' /), &
   942        & 'surface stress(y)  ', 'N m-2' )
   943      call HistoryAutoAddVariable( 'SensA', &
   944        & (/ 'lon ', 'lat ', 'time' /), &
   945        & 'sensible heat flux', 'W m-2' )
   946      call HistoryAutoAddVariable( 'SurfH2OVapFluxA', &
   947        & (/ 'lon ', 'lat ', 'time' /), &
   948        & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
   949      call HistoryAutoAddVariable( 'EvapA', &
   950        & (/ 'lon ', 'lat ', 'time' /), &
   951        & 'latent heat flux  ', 'W m-2' )
   952  
   953      call HistoryAutoAddVariable( 'SurfH2OVapFluxU', &
   954        & (/ 'lon ', 'lat ', 'time' /), &
   955        & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
   956      call HistoryAutoAddVariable( 'EvapU', &
   957        & (/ 'lon ', 'lat ', 'time' /), &
   958        & 'latent heat flux  ', 'W m-2' )
   959  
   960      ! 印字 ; Print
   961      !
   962      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   963      call MessageNotify( 'M', module_name, 'LBMomFluxMode            = %c', c1 = trim( LBMomFluxMode ) )
   964      call MessageNotify( 'M', module_name, 'FricTimeConstAtLB        = %f', d = (/ FricTimeConstAtLB /) )
   965      call MessageNotify( 'M', module_name, 'FricLowestLatAtLB        = %f', d = (/ FricLowestLatAtLB /) )
   966      call MessageNotify( 'M', module_name, 'LBHeatFluxMode           = %c', c1 = trim( LBHeatFluxMode ) )
   967      call MessageNotify( 'M', module_name, 'HeatFluxAtLB             = %f', d = (/ HeatFluxAtLB /) )
   968      call MessageNotify( 'M', module_name, 'TempAtLB                 = %f', d = (/ TempAtLB /) )
   969      call MessageNotify( 'M', module_name, 'LBH2OVapFluxMode         = %c', c1 = trim( LBH2OVapFluxMode ) )
   970      call MessageNotify( 'M', module_name, 'H2OVapFluxAtLB           = %f', d = (/ H2OVapFluxAtLB /) )
   971      call MessageNotify( 'M', module_name, 'QH2OVapAtLB              = %f', d = (/ QH2OVapAtLB /) )
   972      call MessageNotify( 'M', module_name, 'DiffCoefHeatMass         = %f', d = (/ DiffCoefHeatMass /) )
   973      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   974  
   975      lb_flux_simple_inited = .true.
   976  
   977    end subroutine LBFluxSimpleInit
   978  
   979    !--------------------------------------------------------------------------------------
   980  
   981  end module lb_flux_simple
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:44 2016
FILE NAME: lb_flux_simple.f90
PROGRAM NAME: lb_flux_simple
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 下部境界フラックス
     2:             !
     3:             != Lower boundary flux
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: lb_flux_simple.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module lb_flux_simple
    13:               !
    14:               != 下部境界フラックス
    15:               !
    16:               != Lower boundary flux
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! 
    23:               !
    24:               !== References
    25:               !
    26:             !!$  ! Louis, J-F., M. Tiedtke, and J-F. Geleyn, 
    27:             !!$  ! A short history of the PBL parameterization at ECMWF, 
    28:             !!$  ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K., 
    29:             !!$  ! 1982.
    30:               !
    31:               !== Procedures List
    32:               !
    33:             !!$  ! SurfaceFlux       :: 地表面フラックスの計算
    34:             !!$  ! SurfaceFluxOutput :: 地表面フラックスの出力
    35:             !!$  ! ------------      :: ------------
    36:             !!$  ! SurfaceFlux       :: Calculate surface fluxes
    37:             !!$  ! SurfaceFluxOutput :: Output surface fluxes
    38:               !
    39:               !== NAMELIST
    40:               !
    41:               ! NAMELIST#lb_flux_simple_nml
    42:               !
    43:             
    44:               ! モジュール引用 ; USE statements
    45:               !
    46:             
    47:               ! 格子点設定
    48:               ! Grid points settings
    49:               !
    50:               use gridset, only: imax, & ! 経度格子点数. 
    51:                                          ! Number of grid points in longitude
    52:                 &                jmax, & ! 緯度格子点数. 
    53:                                          ! Number of grid points in latitude
    54:                 &                kmax    ! 鉛直層数. 
    55:                                          ! Number of vertical level
    56:             
    57:               ! 組成に関わる配列の設定
    58:               ! Settings of array for atmospheric composition
    59:               !
    60:               use composition, only: ncmax, IndexH2OVap
    61:             
    62:               ! 種別型パラメタ
    63:               ! Kind type parameter
    64:               !
    65:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    66:                 &                 STRING, &  ! 文字列.       Strings. 
    67:                 &                 TOKEN      ! キーワード.   Keywords.
    68:             
    69:               ! メッセージ出力
    70:               ! Message output
    71:               !
    72:               use dc_message, only: MessageNotify
    73:             
    74:               ! 宣言文 ; Declaration statements
    75:               !
    76:               implicit none
    77:               private
    78:             
    79:               ! 公開手続き
    80:               ! Public procedure
    81:               !
    82:               public :: LBFluxSimple
    83:               public :: LBFluxSimpleInit
    84:             !!$  public :: SurfaceFluxOutput
    85:             
    86:               ! 公開変数
    87:               ! Public variables
    88:               !
    89:             
    90:               ! 非公開変数
    91:               ! Private variables
    92:               !
    93:               logical, save :: lb_flux_simple_inited = .false.
    94:                                           ! 初期設定フラグ. 
    95:                                           ! Initialization flag
    96:             
    97:               integer, save      :: IDLBMomFluxMode
    98:               integer, parameter :: IDLBMomFluxModeNoFlux       = 10
    99:               integer, parameter :: IDLBMomFluxModeFixTimeConst = 11
   100:               integer, save      :: IDLBHeatFluxMode
   101:               integer, parameter :: IDLBHeatFluxModeFixFlux     = 20
   102:               integer, parameter :: IDLBHeatFluxModeFixTemp     = 21
   103:               integer, save      :: IDLBH2OVapFluxMode
   104:               integer, parameter :: IDLBH2OVapFluxModeFixFlux   = 30
   105:               integer, parameter :: IDLBH2OVapFluxModeFixMixRt  = 31
   106:             
   107:             
   108:               real(DP), save:: FricTimeConstAtLB
   109:                                         ! 下部境界摩擦の係数 (s).
   110:                                         ! Time constant of surface friction (s).
   111:               real(DP), save:: FricLowestLatAtLB
   112:                                         ! 下部境界摩擦が働く最低緯度 (degree).
   113:                                         ! Lowest latitude where the friction is applied (degree)
   114:               real(DP), save:: HeatFluxAtLB
   115:                                         ! 下部境界での熱フラックス (W m-2).
   116:                                         ! Heat flux at the lower boundary (W m-2).
   117:               real(DP), save:: TempAtLB
   118:               real(DP), save:: H2OVapFluxAtLB
   119:                                         ! 下部境界での H2O 蒸気質量フラックス (W m-2).
   120:                                         ! 実際にはゼロに固定するために使う程度にしか使えないだろう.
   121:                                         ! H2O vapor flux at the lower boundary (kg m-2 s-1).
   122:               real(DP), save:: QH2OVapAtLB
   123:               real(DP), save:: DiffCoefHeatMass
   124:             
   125:             
   126:               character(*), parameter:: module_name = 'lb_flux_simple'
   127:                                           ! モジュールの名称. 
   128:                                           ! Module name
   129:               character(*), parameter:: version = &
   130:                 & '$Name:  $' // &
   131:                 & '$Id: lb_flux_simple.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $'
   132:                                           ! モジュールのバージョン
   133:                                           ! Module version
   134:             
   135:             
   136:             contains
   137:             
   138:               !--------------------------------------------------------------------------------------
   139:             
   140:               subroutine LBFluxSimple( &
   141:                 & xyz_U, xyz_V, xyz_Temp, xyr_VirTemp, xyzf_QMix,             & ! (in)
   142:                 & xyr_Press, xy_SurfHeight, xyz_Height, xyz_Exner, xyr_Exner, & ! (in)
   143:                 & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,    & ! (out)
   144:                 & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                  & ! (out)
   145:                 & xy_SurfQVapTransCoef                                        & ! (out)
   146:                 & )
   147:                 !
   148:                 ! 温度, 比湿, 気圧から, 放射フラックスを計算します. 
   149:                 !
   150:                 ! Calculate radiation flux from temperature, specific humidity, and 
   151:                 ! air pressure. 
   152:                 !
   153:             
   154:                 ! モジュール引用 ; USE statements
   155:                 !
   156:             
   157:                 ! 物理・数学定数設定
   158:                 ! Physical and mathematical constants settings
   159:                 !
   160:                 use constants0, only: &
   161:                   & PI
   162:                                           ! $ \pi $ .
   163:                                           ! 円周率.  Circular constant
   164:             
   165:                 ! 物理定数設定
   166:                 ! Physical constants settings
   167:                 !
   168:                 use constants, only: &
   169:                   & Grav, &               ! $ g $ [m s-2].
   170:                                           ! 重力加速度.
   171:                                           ! Gravitational acceleration
   172:                   & GasRDry, &
   173:                                           ! $ R $ [J kg-1 K-1]. 
   174:                                           ! 乾燥大気の気体定数. 
   175:                                           ! Gas constant of air
   176:                   & CpDry
   177:                                           ! $ C_p $ [J kg-1 K-1]. 
   178:                                           ! 乾燥大気の定圧比熱. 
   179:                                           ! Specific heat of air at constant pressure
   180:             
   181:                 ! 飽和比湿の算出
   182:                 ! Evaluate saturation specific humidity
   183:                 !
   184:                 use saturate, only: xy_CalcQVapSat
   185:             
   186:                 ! 座標データ設定
   187:                 ! Axes data settings
   188:                 !
   189:                 use axesset, only: &
   190:                   & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   191:             
   192:                 ! 時刻管理
   193:                 ! Time control
   194:                 !
   195:                 use timeset, only: &
   196:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   197:                   & TimesetClockStart, TimesetClockStop
   198:             
   199:                 ! デバッグ用ユーティリティ
   200:                 ! Utilities for debug
   201:                 !
   202:                 use dc_trace, only: DbgMessage, BeginSub, EndSub
   203:             
   204:                 ! 宣言文 ; Declaration statements
   205:                 !
   206:             
   207:                 real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   208:                                           ! $ u $ . 東西風速. Eastward wind
   209:                 real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   210:                                           ! $ v $ . 南北風速. Northward wind
   211:             
   212:                 real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   213:                                           ! $ T $ . 温度 (整数レベル). 
   214:                                           ! Temperature (full level)
   215:                 real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   216:                                           ! $ T_v $ . 仮温度 (半整数レベル). 
   217:                                           ! Virtual temperature (half level)
   218:                 real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   219:                                           ! $ q $ .     比湿. Specific humidity
   220:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   221:                                           ! $ p_s $ . 地表面気圧 (半整数レベル). 
   222:                                           ! Surface pressure (half level)
   223:                 real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
   224:                                           ! $ z_s $ . 地表面高度. 
   225:                                           ! Surface height. 
   226:                 real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   227:                                           ! 高度 (整数レベル). 
   228:                                           ! Height (full level)
   229:                 real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   230:                                           ! Exner 関数 (整数レベル). 
   231:                                           ! Exner function (full level)
   232:                 real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   233:                                           ! Exner 関数 (半整数レベル). 
   234:                                           ! Exner function (half level)
   235:                 real(DP), intent(out):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:0)
   236:                                           ! 東西方向運動量フラックス. 
   237:                                           ! Eastward momentum flux
   238:                 real(DP), intent(out):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:0)
   239:                                           ! 南北方向運動量フラックス. 
   240:                                           ! Northward momentum flux
   241:                 real(DP), intent(out):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:0)
   242:                                           ! 熱フラックス. 
   243:                                           ! Heat flux
   244:                 real(DP), intent(out):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:0, 1:ncmax)
   245:                                           ! 比湿フラックス. 
   246:                                           ! Specific humidity flux
   247:                 real(DP), intent(out):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   248:                                           ! 輸送係数：運動量. 
   249:                                           ! Diffusion coefficient: velocity
   250:                 real(DP), intent(out):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   251:                                           ! 輸送係数：温度. 
   252:                                           ! Transfer coefficient: temperature
   253:                 real(DP), intent(out):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   254:                                           ! 輸送係数：水蒸気
   255:                                           ! Transfer coefficient: water vapor
   256:             
   257:                 ! 作業変数
   258:                 ! Work variables
   259:                 !
   260:                 real(DP) :: xy_TempAtLB   (0:imax-1, 1:jmax)
   261:                 real(DP) :: xy_QH2OVapAtLB(0:imax-1, 1:jmax)
   262:             
   263:                 integer:: j
   264:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   265:                                           ! Work variables for DO loop in dimension of constituents
   266:             
   267:                 ! 実行文 ; Executable statement
   268:                 !
   269:             
   270:                 ! 初期化確認
   271:                 ! Initialization check
   272:                 !
   273:                 if ( .not. lb_flux_simple_inited ) then
   274:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   275:                 end if
   276:             
   277:             
   278:                 ! 計算時間計測開始
   279:                 ! Start measurement of computation time
   280:                 !
   281:                 call TimesetClockStart( module_name )
   282:             
   283:             
   284:                 ! 輸送係数の計算
   285:                 ! Calculate transfer coefficient
   286:                 !
   287:                 select case ( IDLBMomFluxMode )
   288:                 case ( IDLBMomFluxModeNoFlux )
   289: +V===== A         xy_SurfVelTransCoef = 0.0_DP
   290:                 case ( IDLBMomFluxModeFixTimeConst )
   291:                   if ( FricTimeConstAtLB <= 0.0_DP ) then
   292:                     call MessageNotify( 'E', module_name, 'FricTimeConstAtLB must be greater than or equal to zero.' )
   293:                   end if
   294: +------>          do j = 1, jmax
   295: |                   if ( abs( y_Lat(j) ) >= FricLowestLatAtLB * PI / 180.0_DP ) then
   296: |V===== A             xy_SurfVelTransCoef(:,j) =                           &
   297: |                       & - ( xyr_Press(:,j,1) - xyr_Press(:,j,0) ) / Grav &
   298: |                       &   / FricTimeConstAtLB
   299: |                   else
   300: |V===== A             xy_SurfVelTransCoef(:,j) = 0.0_DP
   301: |                   end if
   302: +------           end do
   303:                 end select
   304:             
   305:                 select case ( IDLBHeatFluxMode )
   306:                 case ( IDLBHeatFluxModeFixFlux )
   307: +V===== A         xy_SurfTempTransCoef = HeatFluxAtLB
   308:                 case ( IDLBHeatFluxModeFixTemp )
   309: W*===== A         xy_SurfTempTransCoef =                                    &
   310:                     &   xyr_Press(:,:,0) / ( GasRDry * xyr_VirTemp(:,:,0) ) &
   311:                     & * DiffCoefHeatMass                                    &
   312:                     & / ( xyz_Height(:,:,1) - xy_SurfHeight )
   313:                 end select
   314:             
   315:                 select case( IDLBH2OVapFluxMode )
   316:                 case ( IDLBH2OVapFluxModeFixFlux )
   317: +V===== A         xy_SurfQVapTransCoef = H2OVapFluxAtLB
   318:                 case ( IDLBH2OVapFluxModeFixMixRt )
   319: W*===== A         xy_SurfQVapTransCoef =                                    &
   320:                     &   xyr_Press(:,:,0) / ( GasRDry * xyr_VirTemp(:,:,0) ) &
   321:                     & * DiffCoefHeatMass                                    &
   322:                     & / ( xyz_Height(:,:,1) - xy_SurfHeight )
   323:                 end select
   324:             
   325:             
   326:                 ! 下部境界フラックスの計算
   327:                 ! Calculate fluxes at lower boundary
   328:                 !
   329:                 !   Momentum
   330:                 !
   331: *W----->A       xyr_MomFluxX(:,:,0) = - xy_SurfVelTransCoef * xyz_U(:,:,1)
   332: *W----- A       xyr_MomFluxY(:,:,0) = - xy_SurfVelTransCoef * xyz_V(:,:,1)
   333:             
   334:                 !   Heat
   335:                 !
   336:                 select case ( IDLBHeatFluxMode )
   337:                 case ( IDLBHeatFluxModeFixFlux )
   338: ++V==== A         xyr_HeatFlux = HeatFluxAtLB
   339:                 case ( IDLBHeatFluxModeFixTemp )
   340: *W----->          xy_TempAtLB = TempAtLB
   341: *W----- A         xyr_HeatFlux(:,:,0) = - CpDry * xyr_Exner(:,:,0) * xy_SurfTempTransCoef &
   342:                     &                       * (   xyz_Temp(:,:,1) / xyz_Exner(:,:,1)      &
   343:                     &                           - xy_TempAtLB     / xyr_Exner(:,:,0) )
   344:                 end select
   345:             
   346:                 !   Mass
   347:                 !
   348:                 select case( IDLBH2OVapFluxMode )
   349:                 case ( IDLBH2OVapFluxModeFixFlux )
   350: +V===== A         xyrf_QMixFlux(:,:,0,IndexH2OVap) = H2OVapFluxAtLB
   351:                 case ( IDLBH2OVapFluxModeFixMixRt )
   352: *W----->          xy_QH2OVapAtLB = QH2OVapAtLB
   353: *W----- A         xyrf_QMixFlux(:,:,0,IndexH2OVap) =                      &
   354:                     & - xy_SurfQVapTransCoef                              &
   355:                     & * ( xyzf_QMix(:,:,1,IndexH2OVap) - xy_QH2OVapAtLB )
   356:                 end select
   357:                 !
   358: W**==== A       xyrf_QMixFlux(:,:,0,1:IndexH2OVap-1)     = 0.0_DP
   359: W**==== A       xyrf_QMixFlux(:,:,0,IndexH2OVap+1:ncmax) = 0.0_DP
   360:             
   361:                 ! Surface flux of constituents except for water vapor is zero.
   362:             !!$    write( 6, * ) "MEMO: Surface flux of constituents except for water vapor is zero. (YOT, 2013/05/15)"
   363:             
   364:             
   365:                 ! ヒストリデータ出力
   366:                 ! History data output
   367:                 !
   368:             
   369:                 ! 計算時間計測一時停止
   370:                 ! Pause measurement of computation time
   371:                 !
   372:                 call TimesetClockStop( module_name )
   373:             
   374:               end subroutine LBFluxSimple
   375:             
   376:               !--------------------------------------------------------------------------------------
   377:             
   378:               subroutine SurfaceFluxOutput(                                &
   379:                 & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
   380:                 & xy_SurfH2OVapFluxA, xy_SurfLatentHeatFluxA,              & ! (in)
   381:                 & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt,           & ! (in)
   382:                 & xy_SurfTemp, xy_DSurfTempDt,                             & ! (in)
   383:                 & xyr_Press, xyz_Exner, xyr_Exner, xy_SurfHumidCoef,       & ! (in)
   384:                 & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
   385:                 & xy_SurfQVapTransCoef                                     & ! (in)
   386:                 & )
   387:                 !
   388:                 ! フラックス (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux). 
   389:                 ! について, その他の引数を用いて補正し, 出力を行う. 
   390:                 !
   391:                 ! Fluxes (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux) are
   392:                 ! corrected by using other arguments, and the corrected values are output.
   393:                 !
   394:             
   395:                 ! モジュール引用 ; USE statements
   396:                 !
   397:             
   398:                 ! 物理定数設定
   399:                 ! Physical constant settings
   400:                 !
   401:                 use constants, only: &
   402:                   & GasRDry, &
   403:                                           ! $ R $ [J kg-1 K-1]. 
   404:                                           ! 乾燥大気の気体定数. 
   405:                                           ! Gas constant of air
   406:                   & CpDry, &
   407:                                           ! $ C_p $ [J kg-1 K-1]. 
   408:                                           ! 乾燥大気の定圧比熱. 
   409:                                           ! Specific heat of air at constant pressure
   410:                   & LatentHeat
   411:                                           ! $ L $ [J kg-1] . 
   412:                                           ! 凝結の潜熱. 
   413:                                           ! Latent heat of condensation
   414:             
   415:                 ! 飽和比湿の算出
   416:                 ! Evaluation of saturation specific humidity
   417:                 !
   418:                 use saturate, only: xy_CalcQVapSat, xy_CalcDQVapSatDTemp
   419:             
   420:                 ! 時刻管理
   421:                 ! Time control
   422:                 !
   423:                 use timeset, only: &
   424:                   & DelTime, &            ! $ \Delta t $ [s]
   425:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   426:                   & TimesetClockStart, TimesetClockStop
   427:             
   428:                 ! ヒストリデータ出力
   429:                 ! History data output
   430:                 !
   431:                 use gtool_historyauto, only: HistoryAutoPut
   432:             
   433:                 ! 宣言文 ; Declaration statements
   434:                 !
   435:             
   436:                 real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
   437:                                           ! 東西方向運動量フラックス. 
   438:                                           ! Eastward momentum flux
   439:                 real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
   440:                                           ! 南北方向運動量フラックス. 
   441:                                           ! Northward momentum flux
   442:                 real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   443:                                           ! 熱フラックス. 
   444:                                           ! Heat flux
   445:                 real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   446:                                           ! 比湿フラックス. 
   447:                                           ! Specific humidity flux
   448:                 real(DP), intent(in):: xy_SurfH2OVapFluxA    (0:imax-1, 1:jmax)
   449:                                           ! 惑星表面水蒸気フラックス.
   450:                                           ! Water vapor flux at the surface
   451:                 real(DP), intent(in):: xy_SurfLatentHeatFluxA(0:imax-1, 1:jmax)
   452:                                           ! 惑星表面潜熱フラックス.
   453:                                           ! Latent heat flux at the surface
   454:                 real(DP), intent(in):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
   455:                                           ! $ \DP{u}{t} $ . 東西風速時間変化率. 
   456:                                           ! Eastward wind tendency
   457:                 real(DP), intent(in):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
   458:                                           ! $ \DP{v}{t} $ . 南北風速時間変化率. 
   459:                                           ! Northward wind tendency
   460:                 real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
   461:                                           ! $ \DP{T}{t} $ . 温度時間変化率. 
   462:                                           ! Temperature tendency
   463:                 real(DP), intent(in):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   464:                                           ! $ \DP{q}{t} $ . 比湿時間変化率. 
   465:                                           ! Specific humidity tendency
   466:                 real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   467:                                           ! 地表面温度. 
   468:                                           ! Surface temperature
   469:                 real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
   470:                                           ! 地表面温度時間変化率. 
   471:                                           ! Surface temperature tendency
   472:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   473:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   474:                                           ! Air pressure (half level)
   475:                 real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   476:                                           ! Exner 関数 (整数レベル). 
   477:                                           ! Exner function (full level)
   478:                 real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   479:                                           ! Exner 関数 (半整数レベル). 
   480:                                           ! Exner function (half level)
   481:                 real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   482:                                           ! 地表湿潤度. 
   483:                                           ! Surface humidity coefficient
   484:                 real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   485:                                           ! 輸送係数：運動量. 
   486:                                           ! Diffusion coefficient: velocity
   487:                 real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   488:                                           ! 輸送係数：温度. 
   489:                                           ! Transfer coefficient: temperature
   490:                 real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   491:                                           ! 輸送係数：水蒸気
   492:                                           ! Transfer coefficient: water vapor
   493:             
   494:                 ! 出力のための作業変数
   495:                 ! Work variables for output
   496:                 !
   497:                 real(DP):: xyr_MomFluxXCor (0:imax-1, 1:jmax, 0:kmax)
   498:                                           ! 東西方向運動量フラックス. 
   499:                                           ! Eastward momentum flux
   500:                 real(DP):: xyr_MomFluxYCor (0:imax-1, 1:jmax, 0:kmax)
   501:                                           ! 南北方向運動量フラックス. 
   502:                                           ! Northward momentum flux
   503:                 real(DP):: xyr_HeatFluxCor (0:imax-1, 1:jmax, 0:kmax)
   504:                                           ! 熱フラックス. 
   505:                                           ! Heat flux
   506:                 real(DP):: xyrf_QMixFluxCor(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   507:                                           ! 比湿フラックス. 
   508:                                           ! Specific humidity flux
   509:                 real(DP):: xyr_LatentHeatFluxCor(0:imax-1, 1:jmax, 0:kmax)
   510:                                           ! 表面潜熱フラックス.
   511:                                           ! Latent heat flux
   512:                 real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
   513:                                           ! 地表飽和比湿. 
   514:                                           ! Saturated specific humidity on surface
   515:                 real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
   516:                                           ! 地表飽和比湿変化. 
   517:                                           ! Saturated specific humidity tendency on surface
   518:             
   519:                 ! 作業変数
   520:                 ! Work variables
   521:                 !
   522:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   523:                                           ! Work variables for DO loop in longitude
   524:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   525:                                           ! Work variables for DO loop in latitude
   526:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   527:                                           ! Work variables for DO loop in dimension of constituents
   528:             
   529:             
   530:                 ! 実行文 ; Executable statement
   531:                 !
   532:             
   533:                 ! 初期化確認
   534:                 ! Initialization check
   535:                 !
   536:                 if ( .not. lb_flux_simple_inited ) then
   537:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   538:                 end if
   539:             
   540:             
   541:                 ! 計算時間計測開始
   542:                 ! Start measurement of computation time
   543:                 !
   544:                 call TimesetClockStart( module_name )
   545:             
   546:             
   547:                 ! 飽和比湿の計算
   548:                 ! Calculate saturated specific humidity
   549:                 !
   550:                 xy_SurfQVapSat       = &
   551:                   & xy_CalcQVapSat      ( xy_SurfTemp, xyr_Press(:,:,0) )
   552:                 xy_SurfDQVapSatDTemp = &
   553:                   & xy_CalcDQVapSatDTemp( xy_SurfTemp, xy_SurfQVapSat   )
   554:             
   555:                 ! Output of fluxes at t
   556:                 !
   557:             
   558:                 ! 風速, 温度, 比湿フラックス補正
   559:                 ! Correct fluxes of wind, temperature, specific humidity
   560:                 !
   561: W------>        do j = 1, jmax
   562: |*----->          do i = 0, imax-1
   563: ||      A           xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
   564: ||                    & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * DelTime
   565: ||          
   566: ||      A           xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
   567: ||                    & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * DelTime
   568: ||          
   569: ||      A           xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
   570: ||                    & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
   571: ||                    &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
   572: ||                    &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
   573: ||                    &   * DelTime
   574: |*-----           end do
   575: W------         end do
   576:                 n = IndexH2OVap
   577: +------>        do j = 1, jmax
   578: |V----->          do i = 0, imax-1
   579: ||      A           xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
   580: ||                    & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
   581: ||                    &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
   582: ||                    &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * DelTime
   583: |V-----           end do
   584: +------         end do
   585: +------>        do n = 1, IndexH2OVap-1
   586: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
   587: +------         end do
   588: +------>        do n = IndexH2OVap+1, ncmax
   589: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
   590: +------         end do
   591:                 n = IndexH2OVap
   592: W------>        do j = 1, jmax
   593: |*----->          do i = 0, imax-1
   594: ||      A           xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
   595: |*-----           end do
   596: W------         end do
   597:             
   598:             
   599:                 ! ヒストリデータ出力
   600:                 ! History data output
   601:                 !
   602:                 call HistoryAutoPut( TimeN, 'TauX'          , xyr_MomFluxXCor (:,:,0) )
   603:                 call HistoryAutoPut( TimeN, 'TauY'          , xyr_MomFluxYCor (:,:,0) )
   604:                 call HistoryAutoPut( TimeN, 'Sens'          , xyr_HeatFluxCor (:,:,0) )
   605:                 call HistoryAutoPut( TimeN, 'SurfH2OVapFlux', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
   606:                 call HistoryAutoPut( TimeN, 'Evap'          , xyr_LatentHeatFluxCor(:,:,0) )
   607:             
   608:             
   609:                 ! Output of fluxes at t - \Delta t
   610:                 !
   611:             
   612:                 ! 風速, 温度, 比湿フラックス補正
   613:                 ! Correct fluxes of wind, temperature, specific humidity
   614:                 !
   615: W------>        do j = 1, jmax
   616: |*----->          do i = 0, imax-1
   617: ||      A           xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 )
   618: ||      A           xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 )
   619: ||      A           xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )
   620: |*-----           end do
   621: W------         end do
   622:                 n = IndexH2OVap
   623: W------>        do j = 1, jmax
   624: |*----->          do i = 0, imax-1
   625: ||      A           xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )
   626: |*-----           end do
   627: W------         end do
   628: +------>        do n = 1, IndexH2OVap-1
   629: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
   630: +------         end do
   631: +------>        do n = IndexH2OVap+1, ncmax
   632: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
   633: +------         end do
   634:                 n = IndexH2OVap
   635: W------>        do j = 1, jmax
   636: |*----->          do i = 0, imax-1
   637: ||      A           xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
   638: |*-----           end do
   639: W------         end do
   640:             
   641:                 ! ヒストリデータ出力
   642:                 ! History data output
   643:                 !
   644:                 call HistoryAutoPut( TimeN, 'TauXB'          , xyr_MomFluxXCor (:,:,0) )
   645:                 call HistoryAutoPut( TimeN, 'TauYB'          , xyr_MomFluxYCor (:,:,0) )
   646:                 call HistoryAutoPut( TimeN, 'SensB'          , xyr_HeatFluxCor (:,:,0) )
   647:                 call HistoryAutoPut( TimeN, 'SurfH2OVapFluxB', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
   648:                 call HistoryAutoPut( TimeN, 'EvapB'          , xyr_LatentHeatFluxCor(:,:,0) )
   649:             
   650:             
   651:                 ! Output of fluxes at t + \Delta t
   652:                 !
   653:             
   654:                 ! 風速, 温度, 比湿フラックス補正
   655:                 ! Correct fluxes of wind, temperature, specific humidity
   656:                 !
   657: W------>        do j = 1, jmax
   658: |*----->          do i = 0, imax-1
   659: ||      A           xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
   660: ||                    & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * 2.0_DP * DelTime
   661: ||          
   662: ||      A           xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
   663: ||                    & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * 2.0_DP * DelTime
   664: ||          
   665: ||      A           xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
   666: ||                    & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
   667: ||                    &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
   668: ||                    &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
   669: ||                    &   * 2.0_DP * DelTime
   670: |*-----           end do
   671: W------         end do
   672:                 n = IndexH2OVap
   673: +------>        do j = 1, jmax
   674: |V----->          do i = 0, imax-1
   675: ||      A           xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
   676: ||                    & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
   677: ||                    &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
   678: ||                    &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * 2.0_DP * DelTime
   679: |V-----           end do
   680: +------         end do
   681: +------>        do n = 1, IndexH2OVap-1
   682: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
   683: +------         end do
   684: +------>        do n = IndexH2OVap+1, ncmax
   685: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
   686: +------         end do
   687:                 n = IndexH2OVap
   688: W------>        do j = 1, jmax
   689: |*----->          do i = 0, imax-1
   690: ||      A           xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
   691: |*-----           end do
   692: W------         end do
   693:             
   694:                 ! ヒストリデータ出力
   695:                 ! History data output
   696:                 !
   697:                 call HistoryAutoPut( TimeN, 'TauXA'          , xyr_MomFluxXCor (:,:,0) )
   698:                 call HistoryAutoPut( TimeN, 'TauYA'          , xyr_MomFluxYCor (:,:,0) )
   699:                 call HistoryAutoPut( TimeN, 'SensA'          , xyr_HeatFluxCor (:,:,0) )
   700:                 call HistoryAutoPut( TimeN, 'SurfH2OVapFluxA', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
   701:                 call HistoryAutoPut( TimeN, 'EvapA'          , xyr_LatentHeatFluxCor(:,:,0) )
   702:             
   703:             
   704:                 ! ヒストリデータ出力
   705:                 ! History data output
   706:                 !
   707:                 call HistoryAutoPut( TimeN, 'SurfH2OVapFluxU', xy_SurfH2OVapFluxA     )
   708:                 call HistoryAutoPut( TimeN, 'EvapU'          , xy_SurfLatentHeatFluxA )
   709:             
   710:             
   711:                 ! 計算時間計測一時停止
   712:                 ! Pause measurement of computation time
   713:                 !
   714:                 call TimesetClockStop( module_name )
   715:             
   716:               end subroutine SurfaceFluxOutput
   717:             
   718:               !--------------------------------------------------------------------------------------
   719:             
   720:               subroutine LBFluxSimpleInit
   721:                 !
   722:                 ! surface_flux_bulk モジュールの初期化を行います. 
   723:                 ! NAMELIST#surface_flux_bulk_nml の読み込みはこの手続きで行われます. 
   724:                 !
   725:                 ! "surface_flux_bulk" module is initialized. 
   726:                 ! "NAMELIST#surface_flux_bulk_nml" is loaded in this procedure. 
   727:                 !
   728:             
   729:                 ! モジュール引用 ; USE statements
   730:                 !
   731:             
   732:                 ! NAMELIST ファイル入力に関するユーティリティ
   733:                 ! Utilities for NAMELIST file input
   734:                 !
   735:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   736:             
   737:                 ! ファイル入出力補助
   738:                 ! File I/O support
   739:                 !
   740:                 use dc_iounit, only: FileOpen
   741:             
   742:                 ! 種別型パラメタ
   743:                 ! Kind type parameter
   744:                 !
   745:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   746:             
   747:                 ! 文字列操作
   748:                 ! Character handling
   749:                 !
   750:                 use dc_string, only: StoA
   751:             
   752:             
   753:                 ! 日付および時刻の取り扱い
   754:                 ! Date and time handler
   755:                 !
   756:                 use dc_calendar, only: DCCalConvertByUnit
   757:             
   758:                 ! ヒストリデータ出力
   759:                 ! History data output
   760:                 !
   761:                 use gtool_historyauto, only: HistoryAutoAddVariable
   762:             
   763:                 ! 物理定数設定
   764:                 ! Physical constant settings
   765:                 !
   766:                 use constants, only: &
   767:                   & GasRDry, &
   768:                                           ! $ R $ [J kg-1 K-1]. 
   769:                                           ! 乾燥大気の気体定数. 
   770:                                           ! Gas constant of air
   771:                   & CpDry
   772:                                           ! $ C_p $ [J kg-1 K-1]. 
   773:                                           ! 乾燥大気の定圧比熱. 
   774:                                           ! Specific heat of air at constant pressure
   775:             
   776:                 ! 宣言文 ; Declaration statements
   777:                 !
   778:                 real(DP)         :: FricTimeConstAtLBValue
   779:                 character(TOKEN) :: FricTimeConstAtLBUnit
   780:             
   781:                 character(STRING) :: LBMomFluxMode
   782:                 character(STRING) :: LBHeatFluxMode
   783:                 character(STRING) :: LBH2OVapFluxMode
   784:             
   785:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   786:                                           ! Unit number for NAMELIST file open
   787:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   788:                                           ! IOSTAT of NAMELIST read
   789:             
   790:                 ! NAMELIST 変数群
   791:                 ! NAMELIST group name
   792:                 !
   793:                 namelist /lb_flux_simple_nml/                        &
   794:                   & LBMomFluxMode,                                   &
   795:                   & FricTimeConstAtLBValue, FricTimeConstAtLBUnit,   &
   796:                   & FricLowestLatAtLB,                               &
   797:                   & LBHeatFluxMode,                                  &
   798:                   & HeatFluxAtLB, TempAtLB,                          &
   799:                   & LBH2OVapFluxMode,                                &
   800:                   & H2OVapFluxAtLB, QH2OVapAtLB, DiffCoefHeatMass
   801:                       !
   802:                       ! デフォルト値については初期化手続 "lb_flux_simple#LBFluxSimpleInit" 
   803:                       ! のソースコードを参照のこと. 
   804:                       !
   805:                       ! Refer to source codes in the initialization procedure
   806:                       ! "lb_flux_simple#LBFluxSimpleInit" for the default values. 
   807:                       !
   808:             
   809:                 ! 実行文 ; Executable statement
   810:                 !
   811:             
   812:                 if ( lb_flux_simple_inited ) return
   813:             
   814:             
   815:                 ! デフォルト値の設定
   816:                 ! Default values settings
   817:                 !
   818:                 LBMomFluxMode            = 'FixTimeConst'
   819:                 FricTimeConstAtLBValue   = 20.0_DP   ! Schneider and Liou (2009)
   820:                 FricTimeConstAtLBUnit    = 'day'
   821:                 FricLowestLatAtLB        = 16.3_DP   ! Schneider and Liou (2009)
   822:             
   823:                 LBHeatFluxMode           = 'FixFlux'
   824:                 HeatFluxAtLB             =  5.7_DP   ! Schneider and Liou (2009)
   825:                 TempAtLB                 =  160.0_DP * ( 30.0_DP / 0.6_DP )**( GasRDry / CpDry )
   826:                                              ! Sugiyama et al. (2009), Nagare Multimedia
   827:                                              ! Potential Temperature of 160 K with 
   828:                                              ! reference pressure of 0.6 bars
   829:             
   830:                 LBH2OVapFluxMode         = 'FixFlux'
   831:                 H2OVapFluxAtLB           =  0.0_DP
   832:                 QH2OVapAtLB              =  7.816e-4_DP
   833:                                              ! Sugiyama et al. (2009), Nagare Multimedia
   834:                 DiffCoefHeatMass         = 800.0_DP
   835:                                              ! Sugiyama et al. (2009), Nagare Multimedia
   836:             
   837:                 ! NAMELIST の読み込み
   838:                 ! NAMELIST is input
   839:                 !
   840:                 if ( trim(namelist_filename) /= '' ) then
   841:                   call FileOpen( unit_nml, &          ! (out)
   842:                     & namelist_filename, mode = 'r' ) ! (in)
   843:             
   844:                   rewind( unit_nml )
   845:                   read( unit_nml, &                ! (in)
   846:                     & nml = lb_flux_simple_nml, &  ! (out)
   847:                     & iostat = iostat_nml )        ! (out)
   848:                   close( unit_nml )
   849:             
   850:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   851:                 end if
   852:             
   853:             
   854:                 FricTimeConstAtLB = &
   855:                   & DCCalConvertByUnit( FricTimeConstAtLBValue, FricTimeConstAtLBUnit, 'sec' ) ! (in)
   856:             
   857:             
   858:                 ! Identification of calculation method for momentum flux
   859:                 !
   860:                 call MessageNotify( 'M', module_name, &
   861:                   & 'LBMomFluxMode=<%c>.', c1 = trim(LBMomFluxMode) )
   862:                 select case ( LBMomFluxMode )
   863:                 case ( 'NoFlux' )
   864:                   IDLBMomFluxMode = IDLBMomFluxModeNoFlux
   865:                 case ( 'FixTimeConst' )
   866:                   IDLBMomFluxMode = IDLBMomFluxModeFixTimeConst
   867:                 case default
   868:                   call MessageNotify( 'E', module_name, &
   869:                     & 'LBMomFluxMode=<%c> is not supported.', c1 = trim(LBMomFluxMode) )
   870:                 end select
   871:             
   872:                 ! Identification of calculation method for heat flux
   873:                 !
   874:                 call MessageNotify( 'M', module_name, &
   875:                   & 'LBHeatFluxMode=<%c>.', c1 = trim(LBHeatFluxMode) )
   876:                 select case ( LBHeatFluxMode )
   877:                 case ( 'FixFlux' )
   878:                   IDLBHeatFluxMode = IDLBHeatFluxModeFixFlux
   879:                 case ( 'FixTemp' )
   880:                   IDLBHeatFluxMode = IDLBHeatFluxModeFixFlux
   881:                 case default
   882:                   call MessageNotify( 'E', module_name, &
   883:                     & 'LBHeatFluxMode=<%c> is not supported.', c1 = trim(LBHeatFluxMode) )
   884:                 end select
   885:             
   886:                 ! Identification of calculation method for H2O vapor flux
   887:                 !
   888:                 call MessageNotify( 'M', module_name, &
   889:                   & 'LBH2OVapFluxMode=<%c>.', c1 = trim(LBH2OVapFluxMode) )
   890:                 select case ( LBH2OVapFluxMode )
   891:                 case ( 'FixFlux' )
   892:                   IDLBH2OVapFluxMode = IDLBH2OVapFluxModeFixFlux
   893:                 case ( 'FixMixRt' )
   894:                   IDLBH2OVapFluxMode = IDLBH2OVapFluxModeFixMixRt
   895:                 case default
   896:                   call MessageNotify( 'E', module_name, &
   897:                     & 'LBH2OVapFluxMode=<%c> is not supported.', c1 = trim(LBH2OVapFluxMode) )
   898:                 end select
   899:             
   900:             
   901:             
   902:                 ! ヒストリデータ出力のためのへの変数登録
   903:                 ! Register of variables for history data output
   904:                 !
   905:                 call HistoryAutoAddVariable( 'TauX', &
   906:                   & (/ 'lon ', 'lat ', 'time' /), &
   907:                   & 'surface stress(x)  ', 'N m-2' )
   908:                 call HistoryAutoAddVariable( 'TauY', &
   909:                   & (/ 'lon ', 'lat ', 'time' /), &
   910:                   & 'surface stress(y)  ', 'N m-2' )
   911:                 call HistoryAutoAddVariable( 'Sens', &
   912:                   & (/ 'lon ', 'lat ', 'time' /), &
   913:                   & 'sensible heat flux', 'W m-2' )
   914:                 call HistoryAutoAddVariable( 'SurfH2OVapFlux', &
   915:                   & (/ 'lon ', 'lat ', 'time' /), &
   916:                   & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
   917:                 call HistoryAutoAddVariable( 'Evap', &
   918:                   & (/ 'lon ', 'lat ', 'time' /), &
   919:                   & 'latent heat flux  ', 'W m-2' )
   920:             
   921:                 call HistoryAutoAddVariable( 'TauXB', &
   922:                   & (/ 'lon ', 'lat ', 'time' /), &
   923:                   & 'surface stress(x)  ', 'N m-2' )
   924:                 call HistoryAutoAddVariable( 'TauYB', &
   925:                   & (/ 'lon ', 'lat ', 'time' /), &
   926:                   & 'surface stress(y)  ', 'N m-2' )
   927:                 call HistoryAutoAddVariable( 'SensB', &
   928:                   & (/ 'lon ', 'lat ', 'time' /), &
   929:                   & 'sensible heat flux', 'W m-2' )
   930:                 call HistoryAutoAddVariable( 'SurfH2OVapFluxB', &
   931:                   & (/ 'lon ', 'lat ', 'time' /), &
   932:                   & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
   933:                 call HistoryAutoAddVariable( 'EvapB', &
   934:                   & (/ 'lon ', 'lat ', 'time' /), &
   935:                   & 'latent heat flux  ', 'W m-2' )
   936:             
   937:                 call HistoryAutoAddVariable( 'TauXA', &
   938:                   & (/ 'lon ', 'lat ', 'time' /), &
   939:                   & 'surface stress(x)  ', 'N m-2' )
   940:                 call HistoryAutoAddVariable( 'TauYA', &
   941:                   & (/ 'lon ', 'lat ', 'time' /), &
   942:                   & 'surface stress(y)  ', 'N m-2' )
   943:                 call HistoryAutoAddVariable( 'SensA', &
   944:                   & (/ 'lon ', 'lat ', 'time' /), &
   945:                   & 'sensible heat flux', 'W m-2' )
   946:                 call HistoryAutoAddVariable( 'SurfH2OVapFluxA', &
   947:                   & (/ 'lon ', 'lat ', 'time' /), &
   948:                   & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
   949:                 call HistoryAutoAddVariable( 'EvapA', &
   950:                   & (/ 'lon ', 'lat ', 'time' /), &
   951:                   & 'latent heat flux  ', 'W m-2' )
   952:             
   953:                 call HistoryAutoAddVariable( 'SurfH2OVapFluxU', &
   954:                   & (/ 'lon ', 'lat ', 'time' /), &
   955:                   & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
   956:                 call HistoryAutoAddVariable( 'EvapU', &
   957:                   & (/ 'lon ', 'lat ', 'time' /), &
   958:                   & 'latent heat flux  ', 'W m-2' )
   959:             
   960:                 ! 印字 ; Print
   961:                 !
   962:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   963:                 call MessageNotify( 'M', module_name, 'LBMomFluxMode            = %c', c1 = trim( LBMomFluxMode ) )
   964:                 call MessageNotify( 'M', module_name, 'FricTimeConstAtLB        = %f', d = (/ FricTimeConstAtLB /) )
   965:                 call MessageNotify( 'M', module_name, 'FricLowestLatAtLB        = %f', d = (/ FricLowestLatAtLB /) )
   966:                 call MessageNotify( 'M', module_name, 'LBHeatFluxMode           = %c', c1 = trim( LBHeatFluxMode ) )
   967:                 call MessageNotify( 'M', module_name, 'HeatFluxAtLB             = %f', d = (/ HeatFluxAtLB /) )
   968:                 call MessageNotify( 'M', module_name, 'TempAtLB                 = %f', d = (/ TempAtLB /) )
   969:                 call MessageNotify( 'M', module_name, 'LBH2OVapFluxMode         = %c', c1 = trim( LBH2OVapFluxMode ) )
   970:                 call MessageNotify( 'M', module_name, 'H2OVapFluxAtLB           = %f', d = (/ H2OVapFluxAtLB /) )
   971:                 call MessageNotify( 'M', module_name, 'QH2OVapAtLB              = %f', d = (/ QH2OVapAtLB /) )
   972:                 call MessageNotify( 'M', module_name, 'DiffCoefHeatMass         = %f', d = (/ DiffCoefHeatMass /) )
   973:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   974:             
   975:                 lb_flux_simple_inited = .true.
   976:             
   977:               end subroutine LBFluxSimpleInit
   978:             
   979:               !--------------------------------------------------------------------------------------
   980:             
   981:             end module lb_flux_simple
