Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:44 2016
FILE NAME: set_dust_flux.f90
PROGRAM NAME: set_dust_flux
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   231  opt  (1592): Outer loop unrolled inside inner loop.
   231  vec  (   4): Vectorized array expression.
   231  vec  (  29): ADB is used for array.: xy_surfdustflux
   231  vec  (   4): Vectorized array expression.
   231  vec  (  29): ADB is used for array.: xy_surfdustflux
   233  opt  (1593): Loop nest collapsed into one loop.
   233  vec  (   4): Vectorized array expression.
   233  vec  (  29): ADB is used for array.: xy_surfdustflux
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:44 2016
FILE NAME: set_dust_flux.f90
PROGRAM NAME: set_dust_flux
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != set dust flux
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: set_dust_flux.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module set_dust_flux
    13    !
    14    !=
    15    !
    16    != set dust flux
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    !
    23    !
    24    !== Procedures List
    25    !
    26    ! SetDustFlux     :: ダストフラックスの設定
    27    ! SetDustFluxInit :: 初期化
    28    ! --------------- :: ------------
    29    ! SetDustFlux     :: Set dust flux
    30    ! SetDustFluxInit :: Initialization
    31    !
    32    !== NAMELIST
    33    !
    34    ! NAMELIST#set_dust_flux_nml
    35    !
    36  
    37    ! モジュール引用 ; USE statements
    38    !
    39  
    40    ! 種別型パラメタ
    41    ! Kind type parameter
    42    !
    43    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    44      &                 STRING, &  ! 文字列.       Strings.
    45      &                 TOKEN      ! キーワード.   Keywords.
    46  
    47    ! メッセージ出力
    48    ! Message output
    49    !
    50    use dc_message, only: MessageNotify
    51  
    52    ! 格子点設定
    53    ! Grid points settings
    54    !
    55    use gridset, only: imax, & ! 経度格子点数.
    56                               ! Number of grid points in longitude
    57      &                jmax, & ! 緯度格子点数.
    58                               ! Number of grid points in latitude
    59      &                kmax    ! 鉛直層数.
    60                               ! Number of vertical level
    61  
    62    ! 時刻管理
    63    ! Time control
    64    !
    65    use timeset, only: &
    66      & TimeN,                & !
    67      & InitialDate             ! 計算開始日時.
    68                                ! Start date of calculation
    69  
    70    ! 宣言文 ; Declaration statements
    71    !
    72    implicit none
    73    private
    74  
    75    ! 公開手続き
    76    ! Public procedure
    77    !
    78    public:: SetDustFlux
    79    public:: SetDustFluxInit
    80  
    81    ! 公開変数
    82    ! Public variables
    83    !
    84    logical, save :: set_dust_flux_inited = .false.
    85                                ! 初期設定フラグ.
    86                                ! Initialization flag.
    87  
    88  
    89    ! 非公開変数
    90    ! Private variables
    91    !
    92    real(DP), save :: StartDay
    93                                ! start day of dust injection
    94    real(DP), save :: DustFlux
    95                                ! Dust flux
    96  
    97    real(DP), save :: sec_in_a_day
    98  
    99  !!$  logical,  save:: FlagAnnualMean
   100  !!$                              ! 年平均入射フラグ.
   101  !!$                              ! Flag for annual mean incoming radiation.
   102  !!$  logical,  save:: FlagDiurnalMean
   103  !!$                              ! 日平均入射フラグ.
   104  !!$                              ! Flag for diurnal mean incoming radiation.
   105  !!$  logical,  save:: FlagPerpetual
   106  !!$                              ! 季節変化なし入射フラグ.
   107  !!$                              ! Flag for perpetual incoming radiation.
   108  !!$
   109  !!$  logical,  save:: FlagSpecifySolDay
   110  !!$                              !
   111  !!$                              ! Flag for specifying solar day
   112  !!$  real(DP), save :: SolDay
   113  !!$                              ! length of solar day
   114  
   115  
   116    ! NOTE:
   117    !   Distance between the central star and the planet, and the declination can be
   118    !   determined by specifying following three parameters:
   119    !     PerLonFromVE     : the longitude of the perihelion measured from the vernal
   120    !                        equinox,
   121    !     LonFromVEAtEpoch : the longitude of the planet at epoch,
   122    !     epoch            : date or time.
   123    !
   124  !!$  real(DP), save:: PerLonFromVE
   125  !!$                              ! 春分から測った近日点の経度 (近日点黄経) (degree)
   126  !!$                              ! Longitude of the perihelion from vernal equinox (degree)
   127  !!$  real(DP), save:: LonFromVEAtEpoch
   128  !!$                              ! 元期における惑星の経度 (黄経) (degree)
   129  !!$                              ! Longitude of the planet at epoch (degree)
   130  !!$  real(DP), save:: TimeAtEpoch
   131  !!$                              ! 元期における時刻 (sec)
   132  !!$                              ! Time at epoch (sec)
   133  !!$
   134  !!$  real(DP), save:: EpsOrb
   135  !!$                              ! 赤道傾斜角.
   136  !!$                              ! Inclination of equator to orbit.
   137  !!$  real(DP), save:: Eccentricity
   138  !!$                              ! 離心率.
   139  !!$                              ! Eccentricity.
   140  !!$
   141  !!$  integer,  save:: MaxItrEccAnomaly
   142  !!$                              ! 離心近点角を計算する時の最大繰り返し回数.
   143  !!$                              ! Maximum iteration number of times
   144  !!$                              ! to calculate eccentric anomaly.
   145  !!$  real(DP), save:: ThreEccAnomalyError
   146  !!$                              ! 離心近点角を計算する時の誤差の許容しきい値.
   147  !!$                              ! Threshold of error
   148  !!$                              ! to calculate eccentric anomaly.
   149  !!$
   150  !!$  real(DP), save:: IncomAIns
   151  !!$                              ! $ A_{ins} $ . 年平均入射の係数.
   152  !!$                              ! Coefficient of annual mean incoming radiation.
   153  !!$  real(DP), save:: IncomBIns
   154  !!$                              ! $ B_{ins} $ . 年平均入射の係数. AIns に同じ.
   155  !!$                              ! Coefficient of annual mean incoming radiation.
   156  !!$                              ! Same as "AIns".
   157  !!$  real(DP), save:: IncomAZet
   158  !!$                              ! $ A_{\zeta} $ . 年平均入射角の係数. AIns に同じ.
   159  !!$                              ! Coefficient of annual mean incoming radiation.
   160  !!$                              ! Same as "AIns".
   161  !!$  real(DP), save:: IncomBZet
   162  !!$                              ! $ B_{\zeta} $ . 年平均入射角の係数. AIns に同じ.
   163  !!$                              ! Coefficient of annual mean incoming radiation.
   164  !!$                              ! Same as "AIns".
   165  !!$
   166  !!$
   167  !!$  real(DP), allocatable, save:: xy_InAngle (:,:)
   168  !!$                              ! sec (入射角).
   169  !!$                              ! sec (angle of incidence)
   170  !!$
   171  !!$  logical:: FlagRadSynchronous
   172  !!$                              ! 同期回転日射のフラグ
   173  !!$                              ! Flag for synchronous rotation
   174  
   175    character(*), parameter:: module_name = 'set_dust_flux'
   176                                ! モジュールの名称.
   177                                ! Module name
   178    character(*), parameter:: version = &
   179      & '$Name:  $' // &
   180      & '$Id: set_dust_flux.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $'
   181                                ! モジュールのバージョン
   182                                ! Module version
   183  
   184  contains
   185  
   186    !--------------------------------------------------------------------------------------
   187  
   188    subroutine SetDustFlux( &
   189      & xy_SurfDustFlux     & ! (out)
   190      & )
   191      !
   192      !
   193      !
   194      ! Set dust flux
   195      !
   196  
   197      ! モジュール引用 ; USE statements
   198      !
   199  
   200      ! ヒストリデータ出力
   201      ! History data output
   202      !
   203      use gtool_historyauto, only: HistoryAutoPut
   204  
   205  
   206      ! 宣言文 ; Declaration statements
   207      !
   208      implicit none
   209      real(DP), intent(out) :: xy_SurfDustFlux(0:imax-1, 1:jmax)
   210                                !
   211                                !
   212  
   213  
   214      ! 作業変数
   215      ! Work variables
   216      !
   217  
   218  
   219      ! 実行文 ; Executable statement
   220      !
   221  
   222      ! 初期化確認
   223      ! Initialization check
   224      !
   225      if ( .not. set_dust_flux_inited ) then
   226        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   227      end if
   228  
   229  
   230      if ( TimeN >= sec_in_a_day * StartDay ) then
   231        xy_SurfDustFlux = DustFlux
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t33 = 1, j1                                                 
     .  !cdir       nodep                                                       
     .              do t35 = 1, 1 + imax - min0(1,imax)                         
     .                 xy_surfdustflux(t35-1,t33) = dustflux                    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t33 = j1 + 1, jmax, 4                                       
     .  !cdir       nodep                                                       
     .              do t35 = 1, 1 + imax - min0(1,imax)                         
     .                 xy_surfdustflux(t35-1,t33) = dustflux                    
     .                 xy_surfdustflux(t35-1,t33+1) = dustflux                  
     .                 xy_surfdustflux(t35-1,t33+2) = dustflux                  
     .                 xy_surfdustflux(t35-1,t33+3) = dustflux                  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10008                                                        
   232      else
   233        xy_SurfDustFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t27 = 1, jmax*imax                                             
     .           xy_surfdustflux(t27-1,1) = 0.0000000000000000e+000             
     .        enddo                                                             
   234      end if
   235  
   236  
   237    end subroutine SetDustFlux
   238  
   239    !--------------------------------------------------------------------------------------
   240  
   241    subroutine SetDustFluxInit
   242      !
   243      ! set_dust_flux モジュールの初期化を行います.
   244      ! NAMELIST#set_dust_flux_nml の読み込みはこの手続きで行われます.
   245      !
   246      ! "set_dust_flux" module is initialized.
   247      ! "NAMELIST#set_dust_flux_nml" is loaded in this procedure.
   248      !
   249  
   250      ! モジュール引用 ; USE statements
   251      !
   252  
   253      ! 種別型パラメタ
   254      ! Kind type parameter
   255      !
   256      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   257  
   258      ! ファイル入出力補助
   259      ! File I/O support
   260      !
   261      use dc_iounit, only: FileOpen
   262  
   263      ! ヒストリデータ出力
   264      ! History data output
   265      !
   266      use gtool_historyauto, only: HistoryAutoAddVariable
   267  
   268      ! 暦と日時の取り扱い
   269      ! Calendar and Date handler
   270      !
   271      use dc_calendar, only: &
   272        & DCCalInquire
   273  
   274      ! NAMELIST ファイル入力に関するユーティリティ
   275      ! Utilities for NAMELIST file input
   276      !
   277      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   278  
   279      ! 宣言文 ; Declaration statements
   280      !
   281      implicit none
   282  
   283      integer  :: hour_in_a_day
   284      integer  :: min_in_a_hour
   285      real(DP) :: sec_in_a_min
   286  
   287  
   288      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   289                                ! Unit number for NAMELIST file open
   290      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   291                                ! IOSTAT of NAMELIST read
   292  !!$
   293  !!$    logical         :: FlagUseOfEpochDate
   294  !!$    character(TOKEN):: date_print
   295  
   296  
   297      ! NAMELIST 変数群
   298      ! NAMELIST group name
   299      !
   300      namelist /set_dust_flux_nml/ &
   301        & StartDay, DustFlux
   302            !
   303            ! デフォルト値については初期化手続 "set_dust_flux#SetDustFluxInit"
   304            ! のソースコードを参照のこと.
   305            !
   306            ! Refer to source codes in the initialization procedure
   307            ! "set_dust_flux#SetDustFluxInit" for the default values.
   308            !
   309  
   310      ! 実行文 ; Executable statement
   311      !
   312  
   313      if ( set_dust_flux_inited ) return
   314  
   315  
   316      ! デフォルト値の設定
   317      ! Default values settings
   318      !
   319      StartDay = 0.0_DP
   320      DustFlux = 1.0e-6_DP
   321  
   322  
   323      ! NAMELIST の読み込み
   324      ! NAMELIST is input
   325      !
   326      if ( trim(namelist_filename) /= '' ) then
   327        call FileOpen( unit_nml, &          ! (out)
   328          & namelist_filename, mode = 'r' ) ! (in)
   329  
   330        rewind( unit_nml )
   331        read( unit_nml, &                ! (in)
   332          & nml = set_dust_flux_nml,  &  ! (out)
   333          & iostat = iostat_nml )        ! (out)
   334        close( unit_nml )
   335  
   336        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   337      end if
   338  
   339  
   340      !
   341      ! Preparation of length of a day in second
   342      !
   343      call DCCalInquire( &
   344        & hour_in_day      = hour_in_a_day,     & ! (out)
   345        & min_in_hour      = min_in_a_hour,     & ! (out)
   346        & sec_in_min       = sec_in_a_min       & ! (out)
   347        & )
   348      sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min
   349  
   350  
   351      ! 保存用の変数の割り付け
   352      ! Allocate variables for saving
   353      !
   354  
   355      ! ヒストリデータ出力のためのへの変数登録
   356      ! Register of variables for history data output
   357      !
   358  !!$    call HistoryAutoAddVariable( 'xxxxx' , &
   359  !!$      & (/ 'lon ', 'lat ', 'sig', 'time'/), &
   360  !!$      & 'xxxx', 'W m-2' )
   361  
   362  
   363      ! 印字 ; Print
   364      !
   365      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   366      call MessageNotify( 'M', module_name, 'StartDay     = %f', d = (/ StartDay /) )
   367      call MessageNotify( 'M', module_name, 'DustFlux     = %f', d = (/ DustFlux /) )
   368      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   369  
   370      set_dust_flux_inited = .true.
   371  
   372    end subroutine SetDustFluxInit
   373  
   374    !-------------------------------------------------------------------
   375  
   376  end module set_dust_flux
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:44 2016
FILE NAME: set_dust_flux.f90
PROGRAM NAME: set_dust_flux
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != set dust flux
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: set_dust_flux.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module set_dust_flux
    13:               !
    14:               != 
    15:               !
    16:               != set dust flux
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! 
    23:               !
    24:               !== Procedures List
    25:               !
    26:               ! SetDustFlux     :: ダストフラックスの設定
    27:               ! SetDustFluxInit :: 初期化
    28:               ! --------------- :: ------------
    29:               ! SetDustFlux     :: Set dust flux
    30:               ! SetDustFluxInit :: Initialization
    31:               !
    32:               !== NAMELIST
    33:               !
    34:               ! NAMELIST#set_dust_flux_nml
    35:               !
    36:             
    37:               ! モジュール引用 ; USE statements
    38:               !
    39:             
    40:               ! 種別型パラメタ
    41:               ! Kind type parameter
    42:               !
    43:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    44:                 &                 STRING, &  ! 文字列.       Strings. 
    45:                 &                 TOKEN      ! キーワード.   Keywords.
    46:             
    47:               ! メッセージ出力
    48:               ! Message output
    49:               !
    50:               use dc_message, only: MessageNotify
    51:             
    52:               ! 格子点設定
    53:               ! Grid points settings
    54:               !
    55:               use gridset, only: imax, & ! 経度格子点数. 
    56:                                          ! Number of grid points in longitude
    57:                 &                jmax, & ! 緯度格子点数. 
    58:                                          ! Number of grid points in latitude
    59:                 &                kmax    ! 鉛直層数. 
    60:                                          ! Number of vertical level
    61:             
    62:               ! 時刻管理
    63:               ! Time control
    64:               !
    65:               use timeset, only: &
    66:                 & TimeN,                & !
    67:                 & InitialDate             ! 計算開始日時.
    68:                                           ! Start date of calculation
    69:             
    70:               ! 宣言文 ; Declaration statements
    71:               !
    72:               implicit none
    73:               private
    74:             
    75:               ! 公開手続き
    76:               ! Public procedure
    77:               !
    78:               public:: SetDustFlux
    79:               public:: SetDustFluxInit
    80:             
    81:               ! 公開変数
    82:               ! Public variables
    83:               !
    84:               logical, save :: set_dust_flux_inited = .false.
    85:                                           ! 初期設定フラグ. 
    86:                                           ! Initialization flag.
    87:             
    88:             
    89:               ! 非公開変数
    90:               ! Private variables
    91:               !
    92:               real(DP), save :: StartDay
    93:                                           ! start day of dust injection
    94:               real(DP), save :: DustFlux
    95:                                           ! Dust flux
    96:             
    97:               real(DP), save :: sec_in_a_day
    98:             
    99:             !!$  logical,  save:: FlagAnnualMean
   100:             !!$                              ! 年平均入射フラグ.
   101:             !!$                              ! Flag for annual mean incoming radiation. 
   102:             !!$  logical,  save:: FlagDiurnalMean
   103:             !!$                              ! 日平均入射フラグ.
   104:             !!$                              ! Flag for diurnal mean incoming radiation. 
   105:             !!$  logical,  save:: FlagPerpetual
   106:             !!$                              ! 季節変化なし入射フラグ.
   107:             !!$                              ! Flag for perpetual incoming radiation. 
   108:             !!$
   109:             !!$  logical,  save:: FlagSpecifySolDay
   110:             !!$                              ! 
   111:             !!$                              ! Flag for specifying solar day
   112:             !!$  real(DP), save :: SolDay
   113:             !!$                              ! length of solar day
   114:             
   115:             
   116:               ! NOTE:
   117:               !   Distance between the central star and the planet, and the declination can be
   118:               !   determined by specifying following three parameters: 
   119:               !     PerLonFromVE     : the longitude of the perihelion measured from the vernal 
   120:               !                        equinox, 
   121:               !     LonFromVEAtEpoch : the longitude of the planet at epoch, 
   122:               !     epoch            : date or time. 
   123:               !
   124:             !!$  real(DP), save:: PerLonFromVE
   125:             !!$                              ! 春分から測った近日点の経度 (近日点黄経) (degree)
   126:             !!$                              ! Longitude of the perihelion from vernal equinox (degree)
   127:             !!$  real(DP), save:: LonFromVEAtEpoch
   128:             !!$                              ! 元期における惑星の経度 (黄経) (degree)
   129:             !!$                              ! Longitude of the planet at epoch (degree)
   130:             !!$  real(DP), save:: TimeAtEpoch
   131:             !!$                              ! 元期における時刻 (sec)
   132:             !!$                              ! Time at epoch (sec)
   133:             !!$
   134:             !!$  real(DP), save:: EpsOrb
   135:             !!$                              ! 赤道傾斜角.
   136:             !!$                              ! Inclination of equator to orbit.
   137:             !!$  real(DP), save:: Eccentricity
   138:             !!$                              ! 離心率.
   139:             !!$                              ! Eccentricity.
   140:             !!$
   141:             !!$  integer,  save:: MaxItrEccAnomaly
   142:             !!$                              ! 離心近点角を計算する時の最大繰り返し回数.
   143:             !!$                              ! Maximum iteration number of times
   144:             !!$                              ! to calculate eccentric anomaly.
   145:             !!$  real(DP), save:: ThreEccAnomalyError
   146:             !!$                              ! 離心近点角を計算する時の誤差の許容しきい値.
   147:             !!$                              ! Threshold of error
   148:             !!$                              ! to calculate eccentric anomaly.
   149:             !!$
   150:             !!$  real(DP), save:: IncomAIns
   151:             !!$                              ! $ A_{ins} $ . 年平均入射の係数. 
   152:             !!$                              ! Coefficient of annual mean incoming radiation. 
   153:             !!$  real(DP), save:: IncomBIns
   154:             !!$                              ! $ B_{ins} $ . 年平均入射の係数. AIns に同じ. 
   155:             !!$                              ! Coefficient of annual mean incoming radiation. 
   156:             !!$                              ! Same as "AIns". 
   157:             !!$  real(DP), save:: IncomAZet
   158:             !!$                              ! $ A_{\zeta} $ . 年平均入射角の係数. AIns に同じ. 
   159:             !!$                              ! Coefficient of annual mean incoming radiation. 
   160:             !!$                              ! Same as "AIns". 
   161:             !!$  real(DP), save:: IncomBZet
   162:             !!$                              ! $ B_{\zeta} $ . 年平均入射角の係数. AIns に同じ. 
   163:             !!$                              ! Coefficient of annual mean incoming radiation. 
   164:             !!$                              ! Same as "AIns". 
   165:             !!$
   166:             !!$
   167:             !!$  real(DP), allocatable, save:: xy_InAngle (:,:)
   168:             !!$                              ! sec (入射角). 
   169:             !!$                              ! sec (angle of incidence)
   170:             !!$
   171:             !!$  logical:: FlagRadSynchronous
   172:             !!$                              ! 同期回転日射のフラグ
   173:             !!$                              ! Flag for synchronous rotation
   174:             
   175:               character(*), parameter:: module_name = 'set_dust_flux'
   176:                                           ! モジュールの名称. 
   177:                                           ! Module name
   178:               character(*), parameter:: version = &
   179:                 & '$Name:  $' // &
   180:                 & '$Id: set_dust_flux.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $'
   181:                                           ! モジュールのバージョン
   182:                                           ! Module version
   183:             
   184:             contains
   185:             
   186:               !--------------------------------------------------------------------------------------
   187:             
   188:               subroutine SetDustFlux( &
   189:                 & xy_SurfDustFlux     & ! (out)
   190:                 & )
   191:                 !
   192:                 ! 
   193:                 !
   194:                 ! Set dust flux
   195:                 !
   196:             
   197:                 ! モジュール引用 ; USE statements
   198:                 !
   199:             
   200:                 ! ヒストリデータ出力
   201:                 ! History data output
   202:                 !
   203:                 use gtool_historyauto, only: HistoryAutoPut
   204:             
   205:             
   206:                 ! 宣言文 ; Declaration statements
   207:                 !
   208:                 implicit none
   209:                 real(DP), intent(out) :: xy_SurfDustFlux(0:imax-1, 1:jmax)
   210:                                           ! 
   211:                                           ! 
   212:             
   213:             
   214:                 ! 作業変数
   215:                 ! Work variables
   216:                 !
   217:             
   218:             
   219:                 ! 実行文 ; Executable statement
   220:                 !
   221:             
   222:                 ! 初期化確認
   223:                 ! Initialization check
   224:                 !
   225:                 if ( .not. set_dust_flux_inited ) then
   226:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   227:                 end if
   228:             
   229:             
   230:                 if ( TimeN >= sec_in_a_day * StartDay ) then
   231: +V===== A         xy_SurfDustFlux = DustFlux
   232:                 else
   233: W*===== A         xy_SurfDustFlux = 0.0_DP
   234:                 end if
   235:             
   236:             
   237:               end subroutine SetDustFlux
   238:             
   239:               !--------------------------------------------------------------------------------------
   240:             
   241:               subroutine SetDustFluxInit
   242:                 !
   243:                 ! set_dust_flux モジュールの初期化を行います. 
   244:                 ! NAMELIST#set_dust_flux_nml の読み込みはこの手続きで行われます. 
   245:                 !
   246:                 ! "set_dust_flux" module is initialized. 
   247:                 ! "NAMELIST#set_dust_flux_nml" is loaded in this procedure. 
   248:                 !
   249:             
   250:                 ! モジュール引用 ; USE statements
   251:                 !
   252:             
   253:                 ! 種別型パラメタ
   254:                 ! Kind type parameter
   255:                 !
   256:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   257:             
   258:                 ! ファイル入出力補助
   259:                 ! File I/O support
   260:                 !
   261:                 use dc_iounit, only: FileOpen
   262:             
   263:                 ! ヒストリデータ出力
   264:                 ! History data output
   265:                 !
   266:                 use gtool_historyauto, only: HistoryAutoAddVariable
   267:             
   268:                 ! 暦と日時の取り扱い
   269:                 ! Calendar and Date handler
   270:                 !
   271:                 use dc_calendar, only: &
   272:                   & DCCalInquire
   273:             
   274:                 ! NAMELIST ファイル入力に関するユーティリティ
   275:                 ! Utilities for NAMELIST file input
   276:                 !
   277:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   278:             
   279:                 ! 宣言文 ; Declaration statements
   280:                 !
   281:                 implicit none
   282:             
   283:                 integer  :: hour_in_a_day
   284:                 integer  :: min_in_a_hour
   285:                 real(DP) :: sec_in_a_min
   286:             
   287:             
   288:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   289:                                           ! Unit number for NAMELIST file open
   290:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   291:                                           ! IOSTAT of NAMELIST read
   292:             !!$
   293:             !!$    logical         :: FlagUseOfEpochDate
   294:             !!$    character(TOKEN):: date_print
   295:             
   296:             
   297:                 ! NAMELIST 変数群
   298:                 ! NAMELIST group name
   299:                 !
   300:                 namelist /set_dust_flux_nml/ &
   301:                   & StartDay, DustFlux
   302:                       !
   303:                       ! デフォルト値については初期化手続 "set_dust_flux#SetDustFluxInit" 
   304:                       ! のソースコードを参照のこと. 
   305:                       !
   306:                       ! Refer to source codes in the initialization procedure
   307:                       ! "set_dust_flux#SetDustFluxInit" for the default values. 
   308:                       !
   309:             
   310:                 ! 実行文 ; Executable statement
   311:                 !
   312:             
   313:                 if ( set_dust_flux_inited ) return
   314:             
   315:             
   316:                 ! デフォルト値の設定
   317:                 ! Default values settings
   318:                 !
   319:                 StartDay = 0.0_DP
   320:                 DustFlux = 1.0e-6_DP
   321:             
   322:             
   323:                 ! NAMELIST の読み込み
   324:                 ! NAMELIST is input
   325:                 !
   326:                 if ( trim(namelist_filename) /= '' ) then
   327:                   call FileOpen( unit_nml, &          ! (out)
   328:                     & namelist_filename, mode = 'r' ) ! (in)
   329:             
   330:                   rewind( unit_nml )
   331:                   read( unit_nml, &                ! (in)
   332:                     & nml = set_dust_flux_nml,  &  ! (out)
   333:                     & iostat = iostat_nml )        ! (out)
   334:                   close( unit_nml )
   335:             
   336:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   337:                 end if
   338:             
   339:             
   340:                 !
   341:                 ! Preparation of length of a day in second
   342:                 !
   343:                 call DCCalInquire( &
   344:                   & hour_in_day      = hour_in_a_day,     & ! (out)
   345:                   & min_in_hour      = min_in_a_hour,     & ! (out)
   346:                   & sec_in_min       = sec_in_a_min       & ! (out)
   347:                   & )
   348:                 sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min
   349:             
   350:             
   351:                 ! 保存用の変数の割り付け
   352:                 ! Allocate variables for saving
   353:                 !
   354:             
   355:                 ! ヒストリデータ出力のためのへの変数登録
   356:                 ! Register of variables for history data output
   357:                 !
   358:             !!$    call HistoryAutoAddVariable( 'xxxxx' , &
   359:             !!$      & (/ 'lon ', 'lat ', 'sig', 'time'/), &
   360:             !!$      & 'xxxx', 'W m-2' )
   361:             
   362:             
   363:                 ! 印字 ; Print
   364:                 !
   365:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   366:                 call MessageNotify( 'M', module_name, 'StartDay     = %f', d = (/ StartDay /) )
   367:                 call MessageNotify( 'M', module_name, 'DustFlux     = %f', d = (/ DustFlux /) )
   368:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   369:             
   370:                 set_dust_flux_inited = .true.
   371:             
   372:               end subroutine SetDustFluxInit
   373:             
   374:               !-------------------------------------------------------------------
   375:             
   376:             end module set_dust_flux
