Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:43 2016
FILE NAME: subsurface_diffusion_heat.f90
PROGRAM NAME: subsurface_diffusion_heat
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   268  opt  (1592): Outer loop unrolled inside inner loop.
   268  vec  (   4): Vectorized array expression.
   268  vec  (  29): ADB is used for array.: xyr_soiltemptranscoef
   268  vec  (   4): Vectorized array expression.
   268  vec  (  29): ADB is used for array.: xyr_soiltemptranscoef
   276  opt  (1772): Loop nest fused with following nest(s).
   276  opt  (1593): Loop nest collapsed into one loop.
   276  vec  (   4): Vectorized array expression.
   276  vec  (  29): ADB is used for array.: xyr_soiltemptranscoef
   276  vec  (  29): ADB is used for array.: xy_surfsnowb
   276  vec  (  29): ADB is used for array.: xy_soilheatdiffcoef
   278  opt  (  11): Fused array assignments. :line 278 - 284
   288  vec  (   3): Unvectorized loop.
   288  vec  (  13): Overhead of loop division is too large.
   289  opt  (1593): Loop nest collapsed into one loop.
   289  vec  (   4): Vectorized array expression.
   289  vec  (  29): ADB is used for array.: xyr_soiltemptranscoef
   289  vec  (  29): ADB is used for array.: xy_soilheatdiffcoef
   293  opt  (1593): Loop nest collapsed into one loop.
   293  vec  (   4): Vectorized array expression.
   293  vec  (  29): ADB is used for array.: xyr_soiltemptranscoef
   302  opt  (1592): Outer loop unrolled inside inner loop.
   302  vec  (   4): Vectorized array expression.
   302  vec  (  29): ADB is used for array.: xyr_soilheatflux
   302  vec  (   4): Vectorized array expression.
   302  vec  (  29): ADB is used for array.: xyr_soilheatflux
   304  opt  (1593): Loop nest collapsed into one loop.
   304  vec  (   4): Vectorized array expression.
   304  vec  (  29): ADB is used for array.: xyr_soilheatflux
   304  vec  (  29): ADB is used for array.: xy_surftemp
   304  vec  (  29): ADB is used for array.: xyz_soiltemp
   304  vec  (  29): ADB is used for array.: xyr_soiltemptranscoef
   307  opt  (1593): Loop nest collapsed into one loop.
   307  vec  (   1): Vectorized loop.
   307  vec  (  29): ADB is used for array.: xyr_soilheatflux
   307  vec  (  29): ADB is used for array.: xyz_soiltemp
   307  vec  (  29): ADB is used for array.: xyr_soiltemptranscoef
   313  opt  (1593): Loop nest collapsed into one loop.
   313  vec  (   4): Vectorized array expression.
   313  vec  (  29): ADB is used for array.: xyr_soilheatflux
   313  vec  (  29): ADB is used for array.: xy_deepsubsurfheatflux
   321  warn (  83): Dummy argument "xy_soilheatcap" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:43 2016
FILE NAME: subsurface_diffusion_heat.f90
PROGRAM NAME: subsurface_diffusion_heat
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地下における熱の鉛直拡散
     2  !
     3  != Vertical diffusion of heat under the ground
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: subsurface_diffusion_heat.f90,v 1.10 2015/01/29 12:07:59 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module subsurface_diffusion_heat
    13    !
    14    != 地下の鉛直拡散
    15    !
    16    != Vertical diffusion under the ground
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Procedures List
    21    !
    22    ! SubsurfaceDiffusion     :: 熱伝導フラックスの計算
    23    ! SubsurfaceDiffusionInit :: 初期化サブルーチン
    24    ! ----------------------- :: ------------
    25    ! SubsurfaceDiffusion     :: Calculate thermal conduction flux
    26    ! SubsurfaceDiffusionInit :: Initialization
    27    !
    28    !--
    29    !== NAMELIST
    30    !
    31    ! NAMELIST#subsurface_diffusion_heat_nml
    32    !++
    33  
    34    ! モジュール引用 ; USE statements
    35    !
    36  
    37    ! 格子点設定
    38    ! Grid points settings
    39    !
    40    use gridset, only:   imax, & ! 経度格子点数.
    41                                 ! Number of grid points in longitude
    42      &                  jmax, & ! 緯度格子点数.
    43                                 ! Number of grid points in latitude
    44      &                  kmax, & ! 鉛直層数.
    45                                 ! Number of vertical level
    46      &                  kslmax  ! 地下の鉛直層数.
    47                                 ! Number of subsurface vertical level
    48  
    49    ! 種別型パラメタ
    50    ! Kind type parameter
    51    !
    52    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    53      &                 STRING     ! 文字列.       Strings.
    54  
    55    ! メッセージ出力
    56    ! Message output
    57    !
    58    use dc_message, only: MessageNotify
    59  
    60    ! 宣言文 ; Declaration statements
    61    !
    62    implicit none
    63    private
    64  
    65    ! 公開手続き
    66    ! Public procedure
    67    !
    68  !!$  public:: SubsurfaceDiffusionFlagLand
    69    public:: SubsurfaceDiffusion
    70    public:: SubsurfaceDiffusionInit
    71  
    72    ! 公開変数
    73    ! Public variables
    74    !
    75  
    76    ! 非公開変数
    77    ! Private variables
    78    !
    79    logical, save :: subsurface_diffusion_inited = .false.
    80                                ! 初期設定フラグ.
    81                                ! Initialization flag
    82  
    83    character(*), parameter:: module_name = 'subsurface_diffusion_heat'
    84                                ! モジュールの名称.
    85                                ! Module name
    86    character(*), parameter:: version = &
    87      & '$Name:  $' // &
    88      & '$Id: subsurface_diffusion_heat.f90,v 1.10 2015/01/29 12:07:59 yot Exp $'
    89                                ! モジュールのバージョン
    90                                ! Module version
    91  
    92  contains
    93  
    94    !--------------------------------------------------------------------------------------
    95  
    96  !!$  subroutine SubsurfaceDiffusionFlagLand(  &
    97  !!$    & xy_SurfType,                         & ! (in)
    98  !!$    & xy_FlagMatthewsLand                  & ! (out)
    99  !!$    & )
   100  !!$    !
   101  !!$    !
   102  !!$    !
   103  !!$    ! Set index for calculation method from Matthews' index
   104  !!$    !
   105  !!$
   106  !!$    ! モジュール引用 ; USE statements
   107  !!$    !
   108  !!$
   109  !!$    ! 雪と海氷の定数の設定
   110  !!$    ! Setting constants of snow and sea ice
   111  !!$    !
   112  !!$    use constants_snowseaice, only: &
   113  !!$      & SeaIceThreshold
   114  !!$
   115  !!$
   116  !!$    ! 宣言文 ; Declaration statements
   117  !!$    !
   118  !!$
   119  !!$    integer , intent(in ) :: xy_SurfType        (0:imax-1, 1:jmax)
   120  !!$                              ! 土地利用.
   121  !!$                              ! Surface index
   122  !!$    logical , intent(out) :: xy_FlagMatthewsLand(0:imax-1, 1:jmax)
   123  !!$                              !
   124  !!$                              ! Flag for land grid box
   125  !!$
   126  !!$
   127  !!$    ! 作業変数
   128  !!$    ! Work variables
   129  !!$    !
   130  !!$
   131  !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   132  !!$                              ! Work variables for DO loop in longitude
   133  !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   134  !!$                              ! Work variables for DO loop in latitude
   135  !!$
   136  !!$
   137  !!$    ! 実行文 ; Executable statement
   138  !!$    !
   139  !!$
   140  !!$    ! 初期化確認
   141  !!$    ! Initialization check
   142  !!$    !
   143  !!$    if ( .not. subsurface_diffusion_inited ) then
   144  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   145  !!$    end if
   146  !!$
   147  !!$    !
   148  !!$    ! Set flag for land
   149  !!$    !
   150  !!$    do j = 1, jmax
   151  !!$      do i = 0, imax-1
   152  !!$        if ( xy_SurfType(i,j) >= 1 ) then
   153  !!$          ! land
   154  !!$          xy_FlagMatthewsLand(i,j) = .true.
   155  !!$        else
   156  !!$          ! others
   157  !!$          xy_FlagMatthewsLand(i,j) = .false.
   158  !!$        end if
   159  !!$      end do
   160  !!$    end do
   161  !!$
   162  !!$
   163  !!$  end subroutine SubsurfaceDiffusionFlagLand
   164  
   165    !--------------------------------------------------------------------------------------
   166  
   167    subroutine SubsurfaceDiffusion(              &
   168      & xy_DeepSubSurfHeatFlux,                  &          ! (in )
   169      & xy_SoilHeatCap, xy_SoilHeatDiffCoef,     &          ! (in )
   170      & xy_SurfTemp, xyz_SoilTemp, xy_SurfSnowB, &          ! (in )
   171      & xyr_SoilTempTransCoef, xyr_SoilHeatFlux  &          ! (out)
   172      & )
   173      !
   174      ! 時間変化率の計算を行います.
   175      !
   176      ! Calculate tendencies.
   177      !
   178  
   179      ! モジュール引用 ; USE statements
   180      !
   181  
   182      ! 時刻管理
   183      ! Time control
   184      !
   185      use timeset, only: &
   186        & TimesetClockStart, TimesetClockStop
   187  
   188      ! 座標データ設定
   189      ! Axes data settings
   190      !
   191      use axesset, only: &
   192        r_SSDepth, & ! subsurface grid on interface of layer
   193        z_SSDepth    ! subsurface grid at midpoint of layer
   194  
   195      ! 雪と海氷の定数の設定
   196      ! Setting constants of snow and sea ice
   197      !
   198      use constants_snowseaice, only: &
   199        & SnowDens,            &
   200        & SnowMaxThermDepth,   &
   201        & SnowThermCondCoef
   202  
   203      ! 宣言文 ; Declaration statements
   204      !
   205      implicit none
   206  
   207      real(DP), intent(in ):: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
   208                                ! 地中熱フラックス.
   209                                ! "Deep subsurface heat flux"
   210                                ! Heat flux at the bottom of surface/soil layer.
   211      real(DP), intent(in ):: xy_SoilHeatCap (0:imax-1, 1:jmax)
   212                                ! 土壌熱容量 (J K-1 kg-1)
   213                                ! Specific heat of soil (J K-1 kg-1)
   214      real(DP), intent(in ):: xy_SoilHeatDiffCoef (0:imax-1, 1:jmax)
   215                                ! 土壌熱伝導係数 (J m-3 K-1)
   216                                ! Heat conduction coefficient of soil (J m-3 K-1)
   217      real(DP), intent(in ):: xy_SurfTemp (0:imax-1, 1:jmax)
   218                                ! 地表面温度.
   219                                ! Surface temperature
   220      real(DP), intent(in ):: xyz_SoilTemp (0:imax-1, 1:jmax, 1:kslmax)
   221                                ! 土壌温度 (K)
   222                                ! Soil temperature (K)
   223      real(DP), intent(in ):: xy_SurfSnowB (0:imax-1, 1:jmax)
   224                                ! 積雪量.
   225                                ! Surface snow amount.
   226      real(DP), intent(out):: xyr_SoilTempTransCoef (0:imax-1, 1:jmax, 0:kslmax)
   227                                ! 輸送係数：土壌温度.
   228                                ! Transfer coefficient: soil temperature
   229      real(DP), intent(out):: xyr_SoilHeatFlux (0:imax-1, 1:jmax, 0:kslmax)
   230                                ! 土壌中の熱フラックス.
   231                                ! Heat flux in sub-surface soil
   232  
   233  
   234  
   235      ! 作業変数
   236      ! Work variables
   237      !
   238      real(DP) :: xy_SnowDepth             (0:imax-1, 1:jmax)
   239      real(DP) :: xy_SurfTransCoefCorFactor(0:imax-1, 1:jmax)
   240  
   241      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   242                                ! Work variables for DO loop in vertical direction
   243  
   244      ! 実行文 ; Executable statement
   245      !
   246  
   247      ! 初期化確認
   248      ! Initialization check
   249      !
   250      if ( .not. subsurface_diffusion_inited ) then
   251        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   252      end if
   253  
   254  
   255      ! 計算時間計測開始
   256      ! Start measurement of computation time
   257      !
   258      call TimesetClockStart( module_name )
   259  
   260  
   261  
   262      ! 土壌温度計算用の輸送係数の計算
   263      ! Calculate transfer coefficient for heat diffusion in the soil
   264      !
   265      k = 0
   266      if ( kslmax == 0 ) then
   267        ! This line is used when kslmax == 0, because z_SSDepth(k+1) does not exist.
   268        xyr_SoilTempTransCoef(:,:,k) = 0.0_DP
   269      else
   270  !!$      xyr_SoilTempTransCoef(:,:,k) = &
   271  !!$        & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - 0.0_DP )
   272  !!$      xyr_SoilTempTransCoef(:,:,k) =                                          &
   273  !!$        & (   ( z_SSDepth(k+1) - 0.0_DP ) / xy_SoilHeatDiffCoef               &
   274  !!$        &   - min( max( xy_SurfSnowB / SnowDens, 0.0_DP ), SnowMaxThermDepth )&
   275  !!$        &     / SnowThermCondCoef )**(-1)
   276        xyr_SoilTempTransCoef(:,:,k) = &
   277          & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - 0.0_DP )
   278        xy_SnowDepth = min( max( xy_SurfSnowB / SnowDens, 0.0_DP ), &
   279          &                 SnowMaxThermDepth                       )
   280        xy_SurfTransCoefCorFactor = &
   281          &   SnowThermCondCoef * ( z_SSDepth(k+1) - 0.0_DP )             &
   282          &     / (   SnowThermCondCoef   * ( z_SSDepth(k+1) - 0.0_DP )   &
   283          &         + xy_SoilHeatDiffCoef * ( 0.0_DP - xy_SnowDepth   ) )
   284        xyr_SoilTempTransCoef(:,:,k) = xyr_SoilTempTransCoef(:,:,k)   &
   285          & * xy_SurfTransCoefCorFactor
   286  
   287      end if
   288      do k = 1, kslmax-1
   289        xyr_SoilTempTransCoef(:,:,k) = &
   290          & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - z_SSDepth(k) )
   291      end do
   292      k = kslmax
   293      xyr_SoilTempTransCoef(:,:,k) = 0.0_DP
   294  
   295  
   296      ! 土壌中の熱フラックスの計算
   297      ! Calculate heat flux in sub-surface soil
   298      !
   299      k = 0
   300      if ( kslmax == 0 ) then
   301        ! This line is used when kslmax == 0, because xyz_SoilTemp(:,:,k+1) does not exist.
   302        xyr_SoilHeatFlux(:,:,k) = 0.0_DP
   303      else
   304        xyr_SoilHeatFlux(:,:,k) = &
   305          & - xyr_SoilTempTransCoef(:,:,k) * ( xyz_SoilTemp(:,:,1) - xy_SurfTemp(:,:) )
   306      end if
   307      do k = 1, kslmax-1
   308        xyr_SoilHeatFlux(:,:,k) =                               &
   309          & - xyr_SoilTempTransCoef(:,:,k)                      &
   310          &   * ( xyz_SoilTemp(:,:,k+1) - xyz_SoilTemp(:,:,k) )
   311      end do
   312      k = kslmax
   313      xyr_SoilHeatFlux(:,:,k) = xy_DeepSubSurfHeatFlux
   314  
   315  
   316      ! 計算時間計測一時停止
   317      ! Pause measurement of computation time
   318      !
   319      call TimesetClockStop( module_name )
     .        xy_snowdepth.DSC.U1 = imax - 1                                    
     .        xy_snowdepth.DSC.U2 = jmax                                        
     .        allocate (xy_snowdepth(0:imax-1,1:jmax))                          
     .        xy_surftranscoefcorfactor.DSC.U1 = imax - 1                       
     .        xy_surftranscoefcorfactor.DSC.U2 = jmax                           
     .        allocate (xy_surftranscoefcorfactor(0:imax-1,1:jmax))             
     .        xy_surftranscoefcorfactor.DSC.S2 = (                              
     .       1   xy_surftranscoefcorfactor.DSC.U1 + 1)*8                        
     .        xy_snowdepth.DSC.S2 = (xy_snowdepth.DSC.U1 + 1)*8                 
     .        if (subsurface_diffusion_inited .ne. 0) goto 10001                
     .        call messagenotifyc ('E', module_name,                            
     .       1   'This module has not been initialized.', 1, 1, 1, 1, 1, 1, 1, 1
     .       2   , 1, 1, 1, 25, 37, 0, 0, 0, 0)                                 
     .  10001 continue                                                          
     .        call timesetclockstart (module_name, 25)                          
     .        k = 0                                                             
     .        if (kslmax .ne. 0) goto 10003                                     
     .        if (imax - 1 + 1 .le. 0) goto 10015                               
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t319 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t321 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_soiltemptranscoef(t321-1,t319,0) =                   
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t319 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t321 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_soiltemptranscoef(t321-1,t319,0) =                   
     .       1            0.0000000000000000e+000                               
     .                 xyr_soiltemptranscoef(t321-1,t319+1,0) =                 
     .       1            0.0000000000000000e+000                               
     .                 xyr_soiltemptranscoef(t321-1,t319+2,0) =                 
     .       1            0.0000000000000000e+000                               
     .                 xyr_soiltemptranscoef(t321-1,t319+3,0) =                 
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10015                                                        
     .  10003 continue                                                          
     .        d4 = 1.D0/(z_ssdepth(1)-0.0000000000000000e+000)                  
     .        d5 = 1.D0/snowdens                                                
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t239 = 1, jmax*imax                                            
     .           xyr_soiltemptranscoef1 = xy_soilheatdiffcoef(t239-1,1)*d4      
     .           xy_snowdepth1 = min(max(xy_surfsnowb(t239-1,1)*d5,             
     .       1      0.0000000000000000e+000),snowmaxthermdepth)                 
     .           xy_surftranscoefcorfactor1 = (snowthermcondcoef*(z_ssdepth(1)- 
     .       1      0.0000000000000000e+000))/((snowthermcondcoef*(z_ssdepth(1)-
     .       2      0.0000000000000000e+000))+xy_soilheatdiffcoef(t239-1,1)*(   
     .       3      0.0000000000000000e+000-xy_snowdepth1))                     
     .           xyr_soiltemptranscoef(t239-1,1,0) = xyr_soiltemptranscoef1*    
     .       1      xy_surftranscoefcorfactor1                                  
     .        enddo                                                             
     .  10015 continue                                                          
     .        do k = 1, kslmax - 1                                              
     .           d6 = 1.D0/(z_ssdepth(k+1)-z_ssdepth(k))                        
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_soilheatdiffcoef)                                    
     .           do t267 = 1, jmax*imax                                         
     .              xyr_soiltemptranscoef(t267-1,1,k) = xy_soilheatdiffcoef(t267
     .       1         -1,1)*d6                                                 
     .           enddo                                                          
     .        enddo                                                             
     .        k = kslmax                                                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t275 = 1, jmax*imax                                            
     .           xyr_soiltemptranscoef(t275-1,1,k) = 0.0000000000000000e+000    
     .        enddo                                                             
     .        k = 0                                                             
     .        if (kslmax .ne. 0) goto 10030                                     
     .        if (imax - 1 + 1 .le. 0) goto 10036                               
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t313 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t315 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_soilheatflux(t315-1,t313,0) = 0.0000000000000000e+000
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t313 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t315 = 1, 1 + imax - min0(1,imax)                        
     .                 xyr_soilheatflux(t315-1,t313,0) = 0.0000000000000000e+000
     .                 xyr_soilheatflux(t315-1,t313+1,0) =                      
     .       1            0.0000000000000000e+000                               
     .                 xyr_soilheatflux(t315-1,t313+2,0) =                      
     .       1            0.0000000000000000e+000                               
     .                 xyr_soilheatflux(t315-1,t313+3,0) =                      
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10036                                                        
     .  10030 continue                                                          
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t281 = 1, jmax*imax                                            
     .           xyr_soilheatflux(t281-1,1,0) = -xyr_soiltemptranscoef(t281-1,1,
     .       1      0)*(xyz_soiltemp(t281-1,1,1)-xy_surftemp(t281-1,1))         
     .        enddo                                                             
     .  10036 continue                                                          
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kslmax*imax - imax)                               
     .           xyr_soilheatflux(k-1,1,1) = -xyr_soiltemptranscoef(k-1,1,1)*(  
     .       1      xyz_soiltemp(k-1,1,2)-xyz_soiltemp(k-1,1,1))                
     .        enddo                                                             
     .        k = kslmax                                                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t305 = 1, jmax*imax                                            
     .           xyr_soilheatflux(t305-1,1,k) = xy_deepsubsurfheatflux(t305-1,1)
     .        enddo                                                             
     .        call timesetclockstop (module_name, 25)                           
   320  
   321    end subroutine SubsurfaceDiffusion
   322  
   323    !-------------------------------------------------------------------
   324  
   325    subroutine SubsurfaceDiffusionInit
   326      !
   327      ! subsurface_diffusion_heat モジュールの初期化を行います.
   328      ! NAMELIST#subsurface_diffusion_heat_nml の読み込みはこの手続きで行われます.
   329      !
   330      ! "subsurface_diffusion_heat" module is initialized.
   331      ! "NAMELIST#subsurface_diffusion_heat_nml" is loaded in this procedure.
   332      !
   333  
   334      ! モジュール引用 ; USE statements
   335      !
   336  
   337      ! NAMELIST ファイル入力に関するユーティリティ
   338      ! Utilities for NAMELIST file input
   339      !
   340      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   341  
   342      ! ファイル入出力補助
   343      ! File I/O support
   344      !
   345      use dc_iounit, only: FileOpen
   346  
   347      ! 種別型パラメタ
   348      ! Kind type parameter
   349      !
   350      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   351  
   352      ! 文字列操作
   353      ! Character handling
   354      !
   355      use dc_string, only: StoA
   356  
   357      ! ヒストリデータ出力
   358      ! History data output
   359      !
   360      use gtool_historyauto, only: HistoryAutoAddVariable
   361  
   362      ! メッセージ出力
   363      ! Message output
   364      !
   365      use dc_message, only: MessageNotify
   366  
   367      ! 宣言文 ; Declaration statements
   368      !
   369      implicit none
   370  
   371      ! 作業変数
   372      ! Work variables
   373      !
   374  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   375  !!$                              ! Unit number for NAMELIST file open
   376  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   377  !!$                              ! IOSTAT of NAMELIST read
   378  
   379  !!$    real(DP) :: SoilHeatCap
   380  !!$    real(DP) :: SoilHeatDiffCoef
   381  
   382      ! NAMELIST 変数群
   383      ! NAMELIST group name
   384      !
   385  !!$    namelist /subsurface_diffusion_heat_nml/ &
   386  !!$      & SoilHeatCap, SoilHeatDiffCoef
   387  !!$          !
   388  !!$          ! デフォルト値については初期化手続 "subsurface_diffusion_heat#SubSurfaceDiffusionInit"
   389  !!$          ! のソースコードを参照のこと.
   390  !!$          !
   391  !!$          ! Refer to source codes in the initialization procedure
   392  !!$          ! "subsurface_diffusion_heat#SubsurfaceDiffusionInit" for the default values.
   393  !!$          !
   394  
   395      ! 実行文 ; Executable statement
   396      !
   397  
   398      if ( subsurface_diffusion_inited ) return
   399  
   400      ! デフォルト値の設定
   401      ! Default values settings
   402      !
   403  
   404  
   405      ! NAMELIST の読み込み
   406      ! NAMELIST is input
   407      !
   408  !!$    if ( trim(namelist_filename) /= '' ) then
   409  !!$      call FileOpen( unit_nml, &          ! (out)
   410  !!$        & namelist_filename, mode = 'r' ) ! (in)
   411  !!$
   412  !!$      rewind( unit_nml )
   413  !!$      read( unit_nml, &           ! (in)
   414  !!$        & nml = subsurface_diffusion_heat_nml, &  ! (out)
   415  !!$        & iostat = iostat_nml )   ! (out)
   416  !!$      close( unit_nml )
   417  !!$
   418  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   419  !!$    end if
   420  
   421  
   422      ! 印字 ; Print
   423      !
   424      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   425      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   426  
   427      subsurface_diffusion_inited = .true.
   428  
   429    end subroutine SubsurfaceDiffusionInit
   430  
   431    !-------------------------------------------------------------------
   432  
   433  end module subsurface_diffusion_heat
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:43 2016
FILE NAME: subsurface_diffusion_heat.f90
PROGRAM NAME: subsurface_diffusion_heat
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地下における熱の鉛直拡散
     2:             !
     3:             != Vertical diffusion of heat under the ground
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: subsurface_diffusion_heat.f90,v 1.10 2015/01/29 12:07:59 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module subsurface_diffusion_heat
    13:               !
    14:               != 地下の鉛直拡散
    15:               !
    16:               != Vertical diffusion under the ground
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Procedures List
    21:               !
    22:               ! SubsurfaceDiffusion     :: 熱伝導フラックスの計算
    23:               ! SubsurfaceDiffusionInit :: 初期化サブルーチン
    24:               ! ----------------------- :: ------------
    25:               ! SubsurfaceDiffusion     :: Calculate thermal conduction flux
    26:               ! SubsurfaceDiffusionInit :: Initialization
    27:               !
    28:               !--
    29:               !== NAMELIST
    30:               !
    31:               ! NAMELIST#subsurface_diffusion_heat_nml
    32:               !++
    33:             
    34:               ! モジュール引用 ; USE statements
    35:               !
    36:             
    37:               ! 格子点設定
    38:               ! Grid points settings
    39:               !
    40:               use gridset, only:   imax, & ! 経度格子点数. 
    41:                                            ! Number of grid points in longitude
    42:                 &                  jmax, & ! 緯度格子点数. 
    43:                                            ! Number of grid points in latitude
    44:                 &                  kmax, & ! 鉛直層数. 
    45:                                            ! Number of vertical level
    46:                 &                  kslmax  ! 地下の鉛直層数. 
    47:                                            ! Number of subsurface vertical level
    48:             
    49:               ! 種別型パラメタ
    50:               ! Kind type parameter
    51:               !
    52:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    53:                 &                 STRING     ! 文字列.       Strings. 
    54:             
    55:               ! メッセージ出力
    56:               ! Message output
    57:               !
    58:               use dc_message, only: MessageNotify
    59:             
    60:               ! 宣言文 ; Declaration statements
    61:               !
    62:               implicit none
    63:               private
    64:             
    65:               ! 公開手続き
    66:               ! Public procedure
    67:               !
    68:             !!$  public:: SubsurfaceDiffusionFlagLand
    69:               public:: SubsurfaceDiffusion
    70:               public:: SubsurfaceDiffusionInit
    71:             
    72:               ! 公開変数
    73:               ! Public variables
    74:               !
    75:             
    76:               ! 非公開変数
    77:               ! Private variables
    78:               !
    79:               logical, save :: subsurface_diffusion_inited = .false.
    80:                                           ! 初期設定フラグ. 
    81:                                           ! Initialization flag
    82:             
    83:               character(*), parameter:: module_name = 'subsurface_diffusion_heat'
    84:                                           ! モジュールの名称. 
    85:                                           ! Module name
    86:               character(*), parameter:: version = &
    87:                 & '$Name:  $' // &
    88:                 & '$Id: subsurface_diffusion_heat.f90,v 1.10 2015/01/29 12:07:59 yot Exp $'
    89:                                           ! モジュールのバージョン
    90:                                           ! Module version
    91:             
    92:             contains
    93:             
    94:               !--------------------------------------------------------------------------------------
    95:             
    96:             !!$  subroutine SubsurfaceDiffusionFlagLand(  &
    97:             !!$    & xy_SurfType,                         & ! (in)
    98:             !!$    & xy_FlagMatthewsLand                  & ! (out)
    99:             !!$    & )
   100:             !!$    !
   101:             !!$    !
   102:             !!$    !
   103:             !!$    ! Set index for calculation method from Matthews' index
   104:             !!$    !
   105:             !!$
   106:             !!$    ! モジュール引用 ; USE statements
   107:             !!$    !
   108:             !!$
   109:             !!$    ! 雪と海氷の定数の設定
   110:             !!$    ! Setting constants of snow and sea ice
   111:             !!$    !
   112:             !!$    use constants_snowseaice, only: &
   113:             !!$      & SeaIceThreshold
   114:             !!$
   115:             !!$
   116:             !!$    ! 宣言文 ; Declaration statements
   117:             !!$    !
   118:             !!$
   119:             !!$    integer , intent(in ) :: xy_SurfType        (0:imax-1, 1:jmax)
   120:             !!$                              ! 土地利用.
   121:             !!$                              ! Surface index
   122:             !!$    logical , intent(out) :: xy_FlagMatthewsLand(0:imax-1, 1:jmax)
   123:             !!$                              ! 
   124:             !!$                              ! Flag for land grid box
   125:             !!$
   126:             !!$
   127:             !!$    ! 作業変数
   128:             !!$    ! Work variables
   129:             !!$    !
   130:             !!$
   131:             !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   132:             !!$                              ! Work variables for DO loop in longitude
   133:             !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   134:             !!$                              ! Work variables for DO loop in latitude
   135:             !!$
   136:             !!$
   137:             !!$    ! 実行文 ; Executable statement
   138:             !!$    !
   139:             !!$
   140:             !!$    ! 初期化確認
   141:             !!$    ! Initialization check
   142:             !!$    !
   143:             !!$    if ( .not. subsurface_diffusion_inited ) then
   144:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   145:             !!$    end if
   146:             !!$
   147:             !!$    !
   148:             !!$    ! Set flag for land
   149:             !!$    !
   150:             !!$    do j = 1, jmax
   151:             !!$      do i = 0, imax-1
   152:             !!$        if ( xy_SurfType(i,j) >= 1 ) then
   153:             !!$          ! land
   154:             !!$          xy_FlagMatthewsLand(i,j) = .true.
   155:             !!$        else
   156:             !!$          ! others
   157:             !!$          xy_FlagMatthewsLand(i,j) = .false.
   158:             !!$        end if
   159:             !!$      end do
   160:             !!$    end do
   161:             !!$
   162:             !!$
   163:             !!$  end subroutine SubsurfaceDiffusionFlagLand
   164:             
   165:               !--------------------------------------------------------------------------------------
   166:             
   167:               subroutine SubsurfaceDiffusion(              &
   168:                 & xy_DeepSubSurfHeatFlux,                  &          ! (in )
   169:                 & xy_SoilHeatCap, xy_SoilHeatDiffCoef,     &          ! (in )
   170:                 & xy_SurfTemp, xyz_SoilTemp, xy_SurfSnowB, &          ! (in )
   171:                 & xyr_SoilTempTransCoef, xyr_SoilHeatFlux  &          ! (out)
   172:                 & )
   173:                 !
   174:                 ! 時間変化率の計算を行います. 
   175:                 !
   176:                 ! Calculate tendencies. 
   177:                 !
   178:             
   179:                 ! モジュール引用 ; USE statements
   180:                 !
   181:             
   182:                 ! 時刻管理
   183:                 ! Time control
   184:                 !
   185:                 use timeset, only: &
   186:                   & TimesetClockStart, TimesetClockStop
   187:             
   188:                 ! 座標データ設定
   189:                 ! Axes data settings
   190:                 !
   191:                 use axesset, only: &
   192:                   r_SSDepth, & ! subsurface grid on interface of layer
   193:                   z_SSDepth    ! subsurface grid at midpoint of layer
   194:             
   195:                 ! 雪と海氷の定数の設定
   196:                 ! Setting constants of snow and sea ice
   197:                 !
   198:                 use constants_snowseaice, only: &
   199:                   & SnowDens,            &
   200:                   & SnowMaxThermDepth,   &
   201:                   & SnowThermCondCoef
   202:             
   203:                 ! 宣言文 ; Declaration statements
   204:                 !
   205:                 implicit none
   206:             
   207:                 real(DP), intent(in ):: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
   208:                                           ! 地中熱フラックス. 
   209:                                           ! "Deep subsurface heat flux"
   210:                                           ! Heat flux at the bottom of surface/soil layer.
   211:                 real(DP), intent(in ):: xy_SoilHeatCap (0:imax-1, 1:jmax)
   212:                                           ! 土壌熱容量 (J K-1 kg-1)
   213:                                           ! Specific heat of soil (J K-1 kg-1)
   214:                 real(DP), intent(in ):: xy_SoilHeatDiffCoef (0:imax-1, 1:jmax)
   215:                                           ! 土壌熱伝導係数 (J m-3 K-1)
   216:                                           ! Heat conduction coefficient of soil (J m-3 K-1)
   217:                 real(DP), intent(in ):: xy_SurfTemp (0:imax-1, 1:jmax)
   218:                                           ! 地表面温度. 
   219:                                           ! Surface temperature
   220:                 real(DP), intent(in ):: xyz_SoilTemp (0:imax-1, 1:jmax, 1:kslmax)
   221:                                           ! 土壌温度 (K)
   222:                                           ! Soil temperature (K)
   223:                 real(DP), intent(in ):: xy_SurfSnowB (0:imax-1, 1:jmax)
   224:                                           ! 積雪量.
   225:                                           ! Surface snow amount.
   226:                 real(DP), intent(out):: xyr_SoilTempTransCoef (0:imax-1, 1:jmax, 0:kslmax)
   227:                                           ! 輸送係数：土壌温度.
   228:                                           ! Transfer coefficient: soil temperature
   229:                 real(DP), intent(out):: xyr_SoilHeatFlux (0:imax-1, 1:jmax, 0:kslmax)
   230:                                           ! 土壌中の熱フラックス. 
   231:                                           ! Heat flux in sub-surface soil
   232:             
   233:             
   234:             
   235:                 ! 作業変数
   236:                 ! Work variables
   237:                 !
   238:                 real(DP) :: xy_SnowDepth             (0:imax-1, 1:jmax)
   239:                 real(DP) :: xy_SurfTransCoefCorFactor(0:imax-1, 1:jmax)
   240:             
   241:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   242:                                           ! Work variables for DO loop in vertical direction
   243:             
   244:                 ! 実行文 ; Executable statement
   245:                 !
   246:             
   247:                 ! 初期化確認
   248:                 ! Initialization check
   249:                 !
   250:                 if ( .not. subsurface_diffusion_inited ) then
   251:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   252:                 end if
   253:             
   254:             
   255:                 ! 計算時間計測開始
   256:                 ! Start measurement of computation time
   257:                 !
   258:                 call TimesetClockStart( module_name )
   259:             
   260:             
   261:             
   262:                 ! 土壌温度計算用の輸送係数の計算
   263:                 ! Calculate transfer coefficient for heat diffusion in the soil
   264:                 !
   265:                 k = 0
   266:                 if ( kslmax == 0 ) then
   267:                   ! This line is used when kslmax == 0, because z_SSDepth(k+1) does not exist. 
   268: +V===== A         xyr_SoilTempTransCoef(:,:,k) = 0.0_DP
   269:                 else
   270:             !!$      xyr_SoilTempTransCoef(:,:,k) = &
   271:             !!$        & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - 0.0_DP )
   272:             !!$      xyr_SoilTempTransCoef(:,:,k) =                                          &
   273:             !!$        & (   ( z_SSDepth(k+1) - 0.0_DP ) / xy_SoilHeatDiffCoef               &
   274:             !!$        &   - min( max( xy_SurfSnowB / SnowDens, 0.0_DP ), SnowMaxThermDepth )&
   275:             !!$        &     / SnowThermCondCoef )**(-1)
   276: *W----->A         xyr_SoilTempTransCoef(:,:,k) = &
   277:                     & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - 0.0_DP )
   278: *------>          xy_SnowDepth = min( max( xy_SurfSnowB / SnowDens, 0.0_DP ), &
   279: ||                  &                 SnowMaxThermDepth                       )
   280: ||                xy_SurfTransCoefCorFactor = &
   281: ||                  &   SnowThermCondCoef * ( z_SSDepth(k+1) - 0.0_DP )             &
   282: ||                  &     / (   SnowThermCondCoef   * ( z_SSDepth(k+1) - 0.0_DP )   &
   283: ||                  &         + xy_SoilHeatDiffCoef * ( 0.0_DP - xy_SnowDepth   ) )
   284: *W-----           xyr_SoilTempTransCoef(:,:,k) = xyr_SoilTempTransCoef(:,:,k)   &
   285:                     & * xy_SurfTransCoefCorFactor
   286:             
   287:                 end if
   288: +------>        do k = 1, kslmax-1
   289: |W*==== A         xyr_SoilTempTransCoef(:,:,k) = &
   290: |                   & xy_SoilHeatDiffCoef(:,:) / ( z_SSDepth(k+1) - z_SSDepth(k) )
   291: +------         end do
   292:                 k = kslmax
   293: W*===== A       xyr_SoilTempTransCoef(:,:,k) = 0.0_DP
   294:             
   295:             
   296:                 ! 土壌中の熱フラックスの計算
   297:                 ! Calculate heat flux in sub-surface soil
   298:                 !
   299:                 k = 0
   300:                 if ( kslmax == 0 ) then
   301:                   ! This line is used when kslmax == 0, because xyz_SoilTemp(:,:,k+1) does not exist. 
   302: +V===== A         xyr_SoilHeatFlux(:,:,k) = 0.0_DP
   303:                 else
   304: W*===== A         xyr_SoilHeatFlux(:,:,k) = &
   305:                     & - xyr_SoilTempTransCoef(:,:,k) * ( xyz_SoilTemp(:,:,1) - xy_SurfTemp(:,:) )
   306:                 end if
   307: W------>        do k = 1, kslmax-1
   308: |**==== A         xyr_SoilHeatFlux(:,:,k) =                               &
   309: |                   & - xyr_SoilTempTransCoef(:,:,k)                      &
   310: |                   &   * ( xyz_SoilTemp(:,:,k+1) - xyz_SoilTemp(:,:,k) )
   311: W------         end do
   312:                 k = kslmax
   313: W*===== A       xyr_SoilHeatFlux(:,:,k) = xy_DeepSubSurfHeatFlux
   314:             
   315:             
   316:                 ! 計算時間計測一時停止
   317:                 ! Pause measurement of computation time
   318:                 !
   319:                 call TimesetClockStop( module_name )
   320:             
   321:               end subroutine SubsurfaceDiffusion
   322:             
   323:               !-------------------------------------------------------------------
   324:             
   325:               subroutine SubsurfaceDiffusionInit
   326:                 !
   327:                 ! subsurface_diffusion_heat モジュールの初期化を行います. 
   328:                 ! NAMELIST#subsurface_diffusion_heat_nml の読み込みはこの手続きで行われます. 
   329:                 !
   330:                 ! "subsurface_diffusion_heat" module is initialized. 
   331:                 ! "NAMELIST#subsurface_diffusion_heat_nml" is loaded in this procedure. 
   332:                 !
   333:             
   334:                 ! モジュール引用 ; USE statements
   335:                 !
   336:             
   337:                 ! NAMELIST ファイル入力に関するユーティリティ
   338:                 ! Utilities for NAMELIST file input
   339:                 !
   340:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   341:             
   342:                 ! ファイル入出力補助
   343:                 ! File I/O support
   344:                 !
   345:                 use dc_iounit, only: FileOpen
   346:             
   347:                 ! 種別型パラメタ
   348:                 ! Kind type parameter
   349:                 !
   350:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   351:             
   352:                 ! 文字列操作
   353:                 ! Character handling
   354:                 !
   355:                 use dc_string, only: StoA
   356:             
   357:                 ! ヒストリデータ出力
   358:                 ! History data output
   359:                 !
   360:                 use gtool_historyauto, only: HistoryAutoAddVariable
   361:             
   362:                 ! メッセージ出力
   363:                 ! Message output
   364:                 !
   365:                 use dc_message, only: MessageNotify
   366:             
   367:                 ! 宣言文 ; Declaration statements
   368:                 !
   369:                 implicit none
   370:             
   371:                 ! 作業変数
   372:                 ! Work variables
   373:                 !
   374:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   375:             !!$                              ! Unit number for NAMELIST file open
   376:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   377:             !!$                              ! IOSTAT of NAMELIST read
   378:             
   379:             !!$    real(DP) :: SoilHeatCap
   380:             !!$    real(DP) :: SoilHeatDiffCoef
   381:             
   382:                 ! NAMELIST 変数群
   383:                 ! NAMELIST group name
   384:                 !
   385:             !!$    namelist /subsurface_diffusion_heat_nml/ &
   386:             !!$      & SoilHeatCap, SoilHeatDiffCoef
   387:             !!$          !
   388:             !!$          ! デフォルト値については初期化手続 "subsurface_diffusion_heat#SubSurfaceDiffusionInit" 
   389:             !!$          ! のソースコードを参照のこと. 
   390:             !!$          !
   391:             !!$          ! Refer to source codes in the initialization procedure
   392:             !!$          ! "subsurface_diffusion_heat#SubsurfaceDiffusionInit" for the default values. 
   393:             !!$          !
   394:             
   395:                 ! 実行文 ; Executable statement
   396:                 !
   397:             
   398:                 if ( subsurface_diffusion_inited ) return
   399:             
   400:                 ! デフォルト値の設定
   401:                 ! Default values settings
   402:                 !
   403:             
   404:             
   405:                 ! NAMELIST の読み込み
   406:                 ! NAMELIST is input
   407:                 !
   408:             !!$    if ( trim(namelist_filename) /= '' ) then
   409:             !!$      call FileOpen( unit_nml, &          ! (out)
   410:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   411:             !!$
   412:             !!$      rewind( unit_nml )
   413:             !!$      read( unit_nml, &           ! (in)
   414:             !!$        & nml = subsurface_diffusion_heat_nml, &  ! (out)
   415:             !!$        & iostat = iostat_nml )   ! (out)
   416:             !!$      close( unit_nml )
   417:             !!$
   418:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   419:             !!$    end if
   420:             
   421:             
   422:                 ! 印字 ; Print
   423:                 !
   424:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   425:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   426:             
   427:                 subsurface_diffusion_inited = .true.
   428:             
   429:               end subroutine SubsurfaceDiffusionInit
   430:             
   431:               !-------------------------------------------------------------------
   432:             
   433:             end module subsurface_diffusion_heat
