Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:42 2016
FILE NAME: surface_flux_bulk.f90
PROGRAM NAME: surface_flux_bulk
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   451  opt  (1593): Loop nest collapsed into one loop.
   451  vec  (   4): Vectorized array expression.
   451  vec  (  29): ADB is used for array.: xy_betaw
   451  vec  (  29): ADB is used for array.: xyz_v
   451  vec  (  29): ADB is used for array.: xyz_u
   459  opt  (1593): Loop nest collapsed into one loop.
   459  vec  (   1): Vectorized loop.
   459  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   459  vec  (  29): ADB is used for array.: xyr_virtemp
   459  vec  (  29): ADB is used for array.: xyr_press
   459  vec  (  29): ADB is used for array.: xy_surfvelbulkcoef
   472  vec  (   3): Unvectorized loop.
   472  vec  (  13): Overhead of loop division is too large.
   474  vec  (   4): Vectorized array expression.
   474  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   476  vec  (   4): Vectorized array expression.
   476  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   482  opt  (1593): Loop nest collapsed into one loop.
   482  vec  (   1): Vectorized loop.
   482  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   482  vec  (  29): ADB is used for array.: xyr_virtemp
   482  vec  (  29): ADB is used for array.: xyr_press
   482  vec  (  29): ADB is used for array.: xy_surftempbulkcoef
   496  opt  (1593): Loop nest collapsed into one loop.
   496  vec  (   4): Vectorized array expression.
   496  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   500  opt  (1593): Loop nest collapsed into one loop.
   500  vec  (   1): Vectorized loop.
   500  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   500  vec  (  29): ADB is used for array.: xyr_virtemp
   500  vec  (  29): ADB is used for array.: xyr_press
   500  vec  (  29): ADB is used for array.: xy_surfqvapbulkcoef
   514  opt  (1593): Loop nest collapsed into one loop.
   514  vec  (   4): Vectorized array expression.
   514  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   523  opt  (  11): Fused array assignments. :line 523 - 534
   523  opt  (1592): Outer loop unrolled inside inner loop.
   523  vec  (   4): Vectorized array expression.
   523  vec  (  29): ADB is used for array.: xyz_v
   523  vec  (  29): ADB is used for array.: xyz_u
   523  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   523  vec  (  29): ADB is used for array.: xy_surfqvapsatonsol
   523  vec  (  29): ADB is used for array.: xy_surfqvapsatonliq
   523  vec  (  29): ADB is used for array.: xy_snowfrac
   523  vec  (   4): Vectorized array expression.
   523  vec  (  29): ADB is used for array.: xyz_v
   523  vec  (  29): ADB is used for array.: xyz_u
   523  vec  (  29): ADB is used for array.: xy_surfveltranscoef
   523  vec  (  29): ADB is used for array.: xy_surfqvapsatonsol
   523  vec  (  29): ADB is used for array.: xy_surfqvapsatonliq
   523  vec  (  29): ADB is used for array.: xy_snowfrac
   539  opt  (1592): Outer loop unrolled inside inner loop.
   539  vec  (   4): Vectorized array expression.
   539  vec  (  29): ADB is used for array.: xy_surftemp
   539  vec  (  29): ADB is used for array.: xyz_exner
   539  vec  (  29): ADB is used for array.: xyz_temp
   539  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   539  vec  (  29): ADB is used for array.: xyr_exner
   539  vec  (   4): Vectorized array expression.
   539  vec  (  29): ADB is used for array.: xy_surftemp
   539  vec  (  29): ADB is used for array.: xyz_exner
   539  vec  (  29): ADB is used for array.: xyz_temp
   539  vec  (  29): ADB is used for array.: xy_surftemptranscoef
   539  vec  (  29): ADB is used for array.: xyr_exner
   543  opt  (1593): Loop nest collapsed into one loop.
   543  vec  (   4): Vectorized array expression.
   549  opt  (1592): Outer loop unrolled inside inner loop.
   549  vec  (   4): Vectorized array expression.
   549  vec  (  29): ADB is used for array.: xyzf_qmix
   549  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   549  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   549  vec  (   4): Vectorized array expression.
   549  vec  (  29): ADB is used for array.: xyzf_qmix
   549  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
   549  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   553  opt  (1593): Loop nest collapsed into one loop.
   553  vec  (   4): Vectorized array expression.
   556  opt  (1593): Loop nest collapsed into one loop.
   556  vec  (   4): Vectorized array expression.
   557  opt  (1593): Loop nest collapsed into one loop.
   557  vec  (   4): Vectorized array expression.
   566  opt  (  11): Fused array assignments. :line 566 - 568
   566  opt  (1593): Loop nest collapsed into one loop.
   566  vec  (   4): Vectorized array expression.
   566  vec  (  29): ADB is used for array.: xy_heatflux
   566  vec  (  29): ADB is used for array.: xy_momfluxy
   566  vec  (  29): ADB is used for array.: xy_momfluxx
   569  opt  (1593): Loop nest collapsed into one loop.
   569  vec  (   1): Vectorized loop.
   569  vec  (  29): ADB is used for array.: xyf_qmixflux
   584  warn (  83): Dummy argument "xyr_temp" is not used.
   710  opt  (  11): Fused array assignments. :line 710 - 716
   710  vec  (   4): Vectorized array expression.
   710  vec  (  29): ADB is used for array.: xy_surfbulkrinum
   710  vec  (  29): ADB is used for array.: xy_betaw
   710  vec  (  29): ADB is used for array.: xy_surfqvapbulkcoef
   710  vec  (  29): ADB is used for array.: xy_surftempbulkcoef
   710  vec  (  29): ADB is used for array.: xy_surfvelbulkcoef
   729  opt  (  11): Fused array assignments. :line 729 - 733
   729  opt  (1593): Loop nest collapsed into one loop.
   729  vec  (   4): Vectorized array expression.
   729  vec  (  29): ADB is used for array.: xy_surfbulkcoefheatinneutcond
   729  vec  (  29): ADB is used for array.: xy_surfroughlengthheat
   729  vec  (  29): ADB is used for array.: xy_surfbulkcoefmominneutcond
   729  vec  (  29): ADB is used for array.: xy_surfroughlengthmom
   729  vec  (  29): ADB is used for array.: xy_surfheight
   729  vec  (  29): ADB is used for array.: xyz_height
   747  opt  (  11): Fused array assignments. :line 747 - 752
   747  opt  (1592): Outer loop unrolled inside inner loop.
   747  vec  (   4): Vectorized array expression.
   747  vec  (  29): ADB is used for array.: xy_surfbulkrinum
   747  vec  (  29): ADB is used for array.: xy_surfqvapbulkcoef
   747  vec  (  29): ADB is used for array.: xy_surftempbulkcoef
   747  vec  (  29): ADB is used for array.: xy_surfbulkcoefheatinneutcond
   747  vec  (  29): ADB is used for array.: xy_surfvelbulkcoef
   747  vec  (  29): ADB is used for array.: xy_surfbulkcoefmominneutcond
   747  vec  (   4): Vectorized array expression.
   747  vec  (  29): ADB is used for array.: xy_surfbulkrinum
   747  vec  (  29): ADB is used for array.: xy_surfqvapbulkcoef
   747  vec  (  29): ADB is used for array.: xy_surftempbulkcoef
   747  vec  (  29): ADB is used for array.: xy_surfbulkcoefheatinneutcond
   747  vec  (  29): ADB is used for array.: xy_surfvelbulkcoef
   747  vec  (  29): ADB is used for array.: xy_surfbulkcoefmominneutcond
   759  opt  (  11): Fused array assignments. :line 759 - 760
   759  opt  (1593): Loop nest collapsed into one loop.
   759  vec  (   4): Vectorized array expression.
   759  vec  (  29): ADB is used for array.: xy_surfbulkrinum
   759  vec  (  29): ADB is used for array.: xy_surfheight
   759  vec  (  29): ADB is used for array.: xyz_height
   759  vec  (  29): ADB is used for array.: xy_exner
   759  vec  (  29): ADB is used for array.: xy_virtemp
   759  vec  (  29): ADB is used for array.: xy_surfexner
   759  vec  (  29): ADB is used for array.: xy_surfvirtemp
   759  vec  (  29): ADB is used for array.: xy_v
   759  vec  (  29): ADB is used for array.: xy_u
   787  opt  (1592): Outer loop unrolled inside inner loop.
   787  vec  (   4): Vectorized array expression.
   787  vec  (  29): ADB is used for array.: xy_betaw
   787  vec  (   4): Vectorized array expression.
   787  vec  (  29): ADB is used for array.: xy_betaw
   817  opt  (1593): Loop nest collapsed into one loop.
   817  vec  (   1): Vectorized loop.
   817  vec  (  29): ADB is used for array.: xy_surfqvapbulkcoef
   817  vec  (  29): ADB is used for array.: xy_surftempbulkcoef
   817  vec  (  29): ADB is used for array.: xy_surfvelbulkcoef
   928  opt  (1593): Loop nest collapsed into one loop.
   928  vec  (   1): Vectorized loop.
   928  vec  (  29): ADB is used for array.: xy_surftempbulkcoef
   928  vec  (  29): ADB is used for array.: xy_surfvelbulkcoef
   928  vec  (  29): ADB is used for array.: xy_surfheight
   928  vec  (  29): ADB is used for array.: xyz_height
   928  vec  (  29): ADB is used for array.: xy_surfbulkrinum
   928  vec  (  29): ADB is used for array.: xy_surfqvapbulkcoef
   928  vec  (  29): ADB is used for array.: xy_surfbulkcoefheatinneutcond
   928  vec  (  29): ADB is used for array.: xy_surfbulkcoefmominneutcond
   928  vec  (  29): ADB is used for array.: xy_surfroughlengthheat
   928  vec  (  29): ADB is used for array.: xy_surfroughlengthmom
   992  opt  (1593): Loop nest collapsed into one loop.
   992  vec  (   4): Vectorized array expression.
   992  vec  (  29): ADB is used for array.: xy_surfmolength
  1146  opt  (  11): Fused array assignments. :line 1146 - 1149
  1146  opt  (1593): Loop nest collapsed into one loop.
  1146  vec  (   4): Vectorized array expression.
  1146  vec  (  29): ADB is used for array.: xy_betaw
  1146  vec  (  29): ADB is used for array.: xy_molength
  1153  opt  (1593): Loop nest collapsed into one loop.
  1153  vec  (   4): Vectorized array expression.
  1153  vec  (  29): ADB is used for array.: xy_molength
  1157  opt  (  11): Fused array assignments. :line 1157 - 1160
  1157  vec  (   4): Vectorized array expression.
  1157  vec  (  29): ADB is used for array.: xy_psih1
  1157  vec  (  29): ADB is used for array.: xy_psim1
  1157  vec  (  29): ADB is used for array.: xy_psih0
  1157  vec  (  29): ADB is used for array.: xy_psim0
  1162  opt  (  11): Fused array assignments. :line 1162 - 1163
  1162  opt  (1593): Loop nest collapsed into one loop.
  1162  vec  (   4): Vectorized array expression.
  1162  vec  (  29): ADB is used for array.: xy_zetah
  1162  vec  (  29): ADB is used for array.: xy_surfroughlengthheat
  1162  vec  (  29): ADB is used for array.: xy_zetam
  1162  vec  (  29): ADB is used for array.: xy_molength
  1162  vec  (  29): ADB is used for array.: xy_surfroughlengthmom
  1164  opt  (1017): Subroutine call prevents optimization.
  1169  opt  (  11): Fused array assignments. :line 1169 - 1170
  1169  opt  (1593): Loop nest collapsed into one loop.
  1169  vec  (   4): Vectorized array expression.
  1169  vec  (  29): ADB is used for array.: xy_zetah
  1169  vec  (  29): ADB is used for array.: xy_surfroughlengthheat
  1169  vec  (  29): ADB is used for array.: xy_zetam
  1169  vec  (  29): ADB is used for array.: xy_molength
  1169  vec  (  29): ADB is used for array.: xy_surfroughlengthmom
  1169  vec  (  29): ADB is used for array.: xy_surfheight
  1169  vec  (  29): ADB is used for array.: xyz_height
  1178  opt  (1593): Loop nest collapsed into one loop.
  1178  vec  (   1): Vectorized loop.
  1178  vec  (  29): ADB is used for array.: xy_surfqvapbulkcoef
  1178  vec  (  29): ADB is used for array.: xy_surftempbulkcoef
  1178  vec  (  29): ADB is used for array.: xy_psih0
  1178  vec  (  29): ADB is used for array.: xy_psih1
  1178  vec  (  29): ADB is used for array.: xy_surfroughlengthheat
  1178  vec  (  29): ADB is used for array.: xy_surfvelbulkcoef
  1178  vec  (  29): ADB is used for array.: xy_psim0
  1178  vec  (  29): ADB is used for array.: xy_psim1
  1178  vec  (  29): ADB is used for array.: xy_surfroughlengthmom
  1178  vec  (  29): ADB is used for array.: xy_surfheight
  1178  vec  (  29): ADB is used for array.: xyz_height
  1209  opt  (1593): Loop nest collapsed into one loop.
  1209  vec  (   1): Vectorized loop.
  1209  vec  (  29): ADB is used for array.: xy_blheight
  1209  vec  (  29): ADB is used for array.: xy_betaw
  1209  vec  (  29): ADB is used for array.: xy_psih0
  1209  vec  (  29): ADB is used for array.: xy_surfroughlengthheat
  1209  vec  (  29): ADB is used for array.: xy_psim0
  1209  vec  (  29): ADB is used for array.: xy_surfroughlengthmom
  1209  vec  (  29): ADB is used for array.: xy_surfexner
  1209  vec  (  29): ADB is used for array.: xy_surfvirtemp
  1209  vec  (  29): ADB is used for array.: xy_exner
  1209  vec  (  29): ADB is used for array.: xy_virtemp
  1209  vec  (  29): ADB is used for array.: xy_molength
  1244  opt  (1593): Loop nest collapsed into one loop.
  1244  vec  (   1): Vectorized loop.
  1244  vec  (  29): ADB is used for array.: xy_betaw
  1254  opt  (1593): Loop nest collapsed into one loop.
  1254  vec  (   1): Vectorized loop.
  1254  vec  (  29): ADB is used for array.: xy_molength
  1254  vec  (  29): ADB is used for array.: xy_surftempbulkcoef
  1254  vec  (  29): ADB is used for array.: xy_surfvelbulkcoef
  1254  vec  (  29): ADB is used for array.: xy_surfheight
  1254  vec  (  29): ADB is used for array.: xyz_height
  1254  vec  (  29): ADB is used for array.: xy_surfbulkrinum
  1254  vec  (  29): ADB is used for array.: xy_exner
  1254  vec  (  29): ADB is used for array.: xy_virtemp
  1254  vec  (  29): ADB is used for array.: xy_surfexner
  1254  vec  (  29): ADB is used for array.: xy_surfvirtemp
  1254  vec  (  29): ADB is used for array.: xy_betaw
  1254  vec  (  29): ADB is used for array.: xy_v
  1254  vec  (  29): ADB is used for array.: xy_u
  1302  opt  (1593): Loop nest collapsed into one loop.
  1302  vec  (   1): Vectorized loop.
  1302  vec  (  29): ADB is used for array.: xy_molength
  1316  vec  (   1): Vectorized loop.
  1317  vec  (  26): Macro operation Search.
  1318  opt  (1084): Branch out of the loop inhibits optimization.
  1332  opt  (1593): Loop nest collapsed into one loop.
  1332  vec  (   4): Vectorized array expression.
  1332  vec  (  29): ADB is used for array.: xy_surfmolength
  1332  vec  (  29): ADB is used for array.: xy_molength
  1336  opt  (1592): Outer loop unrolled inside inner loop.
  1336  vec  (   4): Vectorized array expression.
  1336  vec  (  29): ADB is used for array.: xy_molength
  1336  vec  (   4): Vectorized array expression.
  1336  vec  (  29): ADB is used for array.: xy_molength
  1341  warn (  82): Name "a_flagrecalcglobal" is not used.
  1341  warn (  82): Name "a_flagrecalclocal" is not used.
  1410  opt  (1593): Loop nest collapsed into one loop.
  1410  vec  (   1): Vectorized loop.
  1410  vec  (  29): ADB is used for array.: xy_psim
  1410  vec  (  29): ADB is used for array.: xy_psih
  1410  vec  (  29): ADB is used for array.: xy_zetah
  1410  vec  (  29): ADB is used for array.: xy_zetam
  1657  opt  (  11): Fused array assignments. :line 1657 - 1664
  1657  vec  (   4): Vectorized array expression.
  1657  vec  (  29): ADB is used for array.: xy_surfqvapsatonsol
  1657  vec  (  29): ADB is used for array.: xy_surfqvapsatonliq
  1657  vec  (  29): ADB is used for array.: xy_snowfrac
  1674  opt  (1593): Loop nest collapsed into one loop.
  1674  vec  (   1): Vectorized loop.
  1674  vec  (  29): ADB is used for array.: xyr_heatfluxcor
  1674  vec  (  29): ADB is used for array.: xy_dsurftempdt
  1674  vec  (  29): ADB is used for array.: xyz_exner
  1674  vec  (  29): ADB is used for array.: xyz_dtempdt
  1674  vec  (  29): ADB is used for array.: xy_surftemptranscoef
  1674  vec  (  29): ADB is used for array.: xyr_exner
  1674  vec  (  29): ADB is used for array.: xyr_heatflux
  1674  vec  (  29): ADB is used for array.: xyr_momfluxycor
  1674  vec  (  29): ADB is used for array.: xyz_dvdt
  1674  vec  (  29): ADB is used for array.: xyr_momfluxy
  1674  vec  (  29): ADB is used for array.: xyr_momfluxxcor
  1674  vec  (  29): ADB is used for array.: xyz_dudt
  1674  vec  (  29): ADB is used for array.: xy_surfveltranscoef
  1674  vec  (  29): ADB is used for array.: xyr_momfluxx
  1690  opt  (1593): Loop nest collapsed into one loop.
  1690  vec  (   1): Vectorized loop.
  1690  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1690  vec  (  29): ADB is used for array.: xy_dsurftempdt
  1690  vec  (  29): ADB is used for array.: xyzf_dqmixdt
  1690  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
  1690  vec  (  29): ADB is used for array.: xy_surfhumidcoef
  1690  vec  (  29): ADB is used for array.: xyrf_qmixflux
  1698  vec  (   3): Unvectorized loop.
  1698  vec  (  13): Overhead of loop division is too large.
  1699  opt  (1593): Loop nest collapsed into one loop.
  1699  vec  (   4): Vectorized array expression.
  1699  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1699  vec  (  29): ADB is used for array.: xyrf_qmixflux
  1701  vec  (   3): Unvectorized loop.
  1701  vec  (  13): Overhead of loop division is too large.
  1702  opt  (1593): Loop nest collapsed into one loop.
  1702  vec  (   4): Vectorized array expression.
  1702  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1702  vec  (  29): ADB is used for array.: xyrf_qmixflux
  1705  opt  (1593): Loop nest collapsed into one loop.
  1705  vec  (   1): Vectorized loop.
  1705  vec  (  29): ADB is used for array.: xyr_latentheatfluxcor
  1705  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1732  opt  (1593): Loop nest collapsed into one loop.
  1732  vec  (   1): Vectorized loop.
  1732  vec  (  29): ADB is used for array.: xyr_heatfluxcor
  1732  vec  (  29): ADB is used for array.: xyr_heatflux
  1732  vec  (  29): ADB is used for array.: xyr_momfluxycor
  1732  vec  (  29): ADB is used for array.: xyr_momfluxy
  1732  vec  (  29): ADB is used for array.: xyr_momfluxxcor
  1732  vec  (  29): ADB is used for array.: xyr_momfluxx
  1740  opt  (1593): Loop nest collapsed into one loop.
  1740  vec  (   1): Vectorized loop.
  1740  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1740  vec  (  29): ADB is used for array.: xyrf_qmixflux
  1745  vec  (   3): Unvectorized loop.
  1745  vec  (  13): Overhead of loop division is too large.
  1746  opt  (1593): Loop nest collapsed into one loop.
  1746  vec  (   4): Vectorized array expression.
  1746  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1746  vec  (  29): ADB is used for array.: xyrf_qmixflux
  1748  vec  (   3): Unvectorized loop.
  1748  vec  (  13): Overhead of loop division is too large.
  1749  opt  (1593): Loop nest collapsed into one loop.
  1749  vec  (   4): Vectorized array expression.
  1749  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1749  vec  (  29): ADB is used for array.: xyrf_qmixflux
  1752  opt  (1593): Loop nest collapsed into one loop.
  1752  vec  (   1): Vectorized loop.
  1752  vec  (  29): ADB is used for array.: xyr_latentheatfluxcor
  1752  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1775  opt  (1593): Loop nest collapsed into one loop.
  1775  vec  (   1): Vectorized loop.
  1775  vec  (  29): ADB is used for array.: xyr_heatfluxcor
  1775  vec  (  29): ADB is used for array.: xy_dsurftempdt
  1775  vec  (  29): ADB is used for array.: xyz_exner
  1775  vec  (  29): ADB is used for array.: xyz_dtempdt
  1775  vec  (  29): ADB is used for array.: xy_surftemptranscoef
  1775  vec  (  29): ADB is used for array.: xyr_exner
  1775  vec  (  29): ADB is used for array.: xyr_heatflux
  1775  vec  (  29): ADB is used for array.: xyr_momfluxycor
  1775  vec  (  29): ADB is used for array.: xyz_dvdt
  1775  vec  (  29): ADB is used for array.: xyr_momfluxy
  1775  vec  (  29): ADB is used for array.: xyr_momfluxxcor
  1775  vec  (  29): ADB is used for array.: xyz_dudt
  1775  vec  (  29): ADB is used for array.: xy_surfveltranscoef
  1775  vec  (  29): ADB is used for array.: xyr_momfluxx
  1791  opt  (1593): Loop nest collapsed into one loop.
  1791  vec  (   1): Vectorized loop.
  1791  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1791  vec  (  29): ADB is used for array.: xy_dsurftempdt
  1791  vec  (  29): ADB is used for array.: xyzf_dqmixdt
  1791  vec  (  29): ADB is used for array.: xy_surfqvaptranscoef
  1791  vec  (  29): ADB is used for array.: xy_surfhumidcoef
  1791  vec  (  29): ADB is used for array.: xyrf_qmixflux
  1799  vec  (   3): Unvectorized loop.
  1799  vec  (  13): Overhead of loop division is too large.
  1800  opt  (1593): Loop nest collapsed into one loop.
  1800  vec  (   4): Vectorized array expression.
  1800  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1800  vec  (  29): ADB is used for array.: xyrf_qmixflux
  1802  vec  (   3): Unvectorized loop.
  1802  vec  (  13): Overhead of loop division is too large.
  1803  opt  (1593): Loop nest collapsed into one loop.
  1803  vec  (   4): Vectorized array expression.
  1803  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
  1803  vec  (  29): ADB is used for array.: xyrf_qmixflux
  1806  opt  (1593): Loop nest collapsed into one loop.
  1806  vec  (   1): Vectorized loop.
  1806  vec  (  29): ADB is used for array.: xyr_latentheatfluxcor
  1806  vec  (  29): ADB is used for array.: xyrf_qmixfluxcor
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:42 2016
FILE NAME: surface_flux_bulk.f90
PROGRAM NAME: surface_flux_bulk
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地表面フラックス (バルク法)
     2  !
     3  != Surface flux (Bulk method)
     4  !
     5  ! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: surface_flux_bulk.f90,v 1.27 2015/02/06 11:25:14 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module surface_flux_bulk
    13    !
    14    != 地表面フラックス
    15    !
    16    != Surface flux
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 地表面フラックスを計算.
    21    !
    22    ! Surface fluxes are calculated.
    23    !
    24    !== References
    25    !
    26    ! Louis, J-F., M. Tiedtke, and J-F. Geleyn,
    27    ! A short history of the PBL parameterization at ECMWF,
    28    ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K.,
    29    ! 1982.
    30    !
    31    ! Beljaars, A. C. M., and A. A. M. Holtslag,
    32    ! Flux parameterization over land surfaces for atmospheric models,
    33    ! J. Appl. Meteor., 30, 327-341, 1991.
    34    !
    35    ! Beljaars, A. C. M.,
    36    ! The parameterization of surface fluxes in large-scale models
    37    ! under free convection,
    38    ! Q. J. R. Meteorol. Soc., 121, 255-270, 1994.
    39    !
    40    !== Procedures List
    41    !
    42    ! SurfaceFlux       :: 地表面フラックスの計算
    43    ! SurfaceFluxOutput :: 地表面フラックスの出力
    44    ! ------------      :: ------------
    45    ! SurfaceFlux       :: Calculate surface fluxes
    46    ! SurfaceFluxOutput :: Output surface fluxes
    47    !
    48    !== NAMELIST
    49    !
    50    ! NAMELIST#surface_flux_bulk_nml
    51    !
    52  
    53    ! モジュール引用 ; USE statements
    54    !
    55  
    56    ! 格子点設定
    57    ! Grid points settings
    58    !
    59    use gridset, only: imax, & ! 経度格子点数.
    60                               ! Number of grid points in longitude
    61      &                jmax, & ! 緯度格子点数.
    62                               ! Number of grid points in latitude
    63      &                kmax    ! 鉛直層数.
    64                               ! Number of vertical level
    65  
    66    ! 組成に関わる配列の設定
    67    ! Settings of array for atmospheric composition
    68    !
    69    use composition, only: ncmax, IndexH2OVap
    70  
    71    ! 種別型パラメタ
    72    ! Kind type parameter
    73    !
    74    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    75      &                 STRING     ! 文字列.       Strings.
    76  
    77    ! メッセージ出力
    78    ! Message output
    79    !
    80    use dc_message, only: MessageNotify
    81  
    82    ! 宣言文 ; Declaration statements
    83    !
    84    implicit none
    85    private
    86  
    87    ! 公開手続き
    88    ! Public procedure
    89    !
    90    public :: SurfaceFlux
    91    public :: SurfaceFluxOutput
    92    public :: SurfaceFluxInit
    93  
    94    ! 公開変数
    95    ! Public variables
    96    !
    97  
    98    ! 非公開変数
    99    ! Private variables
   100    !
   101    integer, parameter :: IDBulkCoefMethodL82     = 1
   102    integer, parameter :: IDBulkCoefMethodBH91B94 = 2
   103  
   104    logical            :: FlagIncludeB94W
   105  
   106    logical, save :: surface_flux_bulk_inited = .false.
   107                                ! 初期設定フラグ.
   108                                ! Initialization flag
   109  
   110    real(DP), save:: VelMinForRi
   111                              ! $ R_i $ 数用風最小値.
   112                              ! Minimum value of velocity for $ R_i $ number
   113    real(DP), save:: VelMinForVel
   114                              ! 運動量用風最小値.
   115                              ! Minimum value of velocity for momentum
   116    real(DP), save:: VelMinForTemp
   117                              ! 熱用風最小値.
   118                              ! Minimum value of velocity for thermal
   119    real(DP), save:: VelMinForQVap
   120                              ! 水蒸気用風最小値.
   121                              ! Minimum value of velocity for vapor
   122    real(DP), save:: VelMaxForVel
   123                              ! 運動量用風最大値.
   124                              ! Maximum value of velocity for momentum
   125    real(DP), save:: VelMaxForTemp
   126                              ! 熱用風最大値.
   127                              ! Maximum value of velocity for thermal
   128    real(DP), save:: VelMaxForQVap
   129                              ! 水蒸気用風最大値.
   130                              ! Maximum value of velocity for vapor
   131  
   132  
   133    ! バルク係数
   134    ! Bluk coefficients
   135    !
   136    logical, save:: FlagConstBulkCoef
   137                              ! Flag for using constant bulk coefficient
   138    logical, save:: FlagUseOfBulkCoefInNeutralCond
   139                              ! Flag for using bulk coefficient in neutral condition
   140    real(DP), save:: ConstBulkCoef
   141                              ! バルク係数一定値.
   142                              ! Steady value of bulk coefficient
   143    real(DP), save:: VelBulkCoefMin
   144                              ! $ u $ バルク係数最小値.
   145                              ! Minimum value of $ u $ bulk coefficient
   146    real(DP), save:: TempBulkCoefMin
   147                              ! $ T $ バルク係数最小値.
   148                              ! Minimum value of $ T $ bulk coefficient
   149    real(DP), save:: QVapBulkCoefMin
   150                              ! $ q $ バルク係数最小値.
   151                              ! Minimum value of $ q $ bulk coefficient
   152    real(DP), save:: VelBulkCoefMax
   153                              ! $ u $ バルク係数最大値.
   154                              ! Maximum value of $ u $ bulk coefficient
   155    real(DP), save:: TempBulkCoefMax
   156                              ! $ T $ バルク係数最大値.
   157                              ! Maximum value of $ T $ bulk coefficient
   158    real(DP), save:: QVapBulkCoefMax
   159                              ! $ q $ バルク係数最大値.
   160                              ! Maximum value of $ q $ bulk coefficient
   161    logical , save:: FlagFixFricTimeConstAtLB
   162    real(DP), save:: FricTimeConstAtLB
   163                              ! 下部境界摩擦の時定数 (s).
   164                              ! Time constant of surface friction (s).
   165    real(DP), save:: LowLatFricAtLB
   166                              ! 下部境界摩擦が働く最低緯度 (degree).
   167                              ! Lowest latitude where the friction is applied (degree)
   168    logical , save:: FlagFixHeatFluxAtLB
   169    real(DP), save:: HeatFluxAtLB
   170                              ! 下部境界での熱フラックス (W m-2).
   171                              ! Heat flux at the lower boundary (W m-2).
   172    logical , save:: FlagFixMassFluxAtLB
   173    real(DP), save:: MassFluxAtLB
   174                              ! 下部境界での質量フラックス (W m-2).
   175                              ! 実際にはゼロに固定するために使う程度にしか使えないだろう.
   176                              ! Mass flux at the lower boundary (kg m-2 s-1).
   177  
   178    character(*), parameter:: module_name = 'surface_flux_bulk'
   179                                ! モジュールの名称.
   180                                ! Module name
   181    character(*), parameter:: version = &
   182      & '$Name:  $' // &
   183      & '$Id: surface_flux_bulk.f90,v 1.27 2015/02/06 11:25:14 yot Exp $'
   184                                ! モジュールのバージョン
   185                                ! Module version
   186  
   187  
   188  contains
   189  
   190    !--------------------------------------------------------------------------------------
   191  
   192    subroutine SurfaceFlux( &
   193      & BulkCoefMethod,                                               & ! (in)
   194      & xyz_U, xyz_V,                                                 & ! (in)
   195      & xyz_Temp, xyr_Temp, xyz_VirTemp, xyr_VirTemp, xy_SurfVirTemp, & ! (in)
   196      & xyzf_QMix,                                                    & ! (in)
   197      & xyr_Press, xy_SurfHeight, xyz_Height, xyz_Exner, xyr_Exner,   & ! (in)
   198      & xy_SurfTemp, xy_SurfHumidCoef,                                & ! (in)
   199      & xy_SurfRoughLengthMom, xy_SurfRoughLengthHeat,                & ! (in)
   200      & xy_SnowFrac,                                                  & ! (in)
   201      & xy_MomFluxX, xy_MomFluxY, xy_HeatFlux, xyf_QMixFlux,          & ! (out)
   202      & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                    & ! (out)
   203      & xy_SurfQVapTransCoef,                                         & ! (out)
   204      & xy_SurfMOLength                                               & ! (out)
   205      & )
   206      !
   207      ! 温度, 比湿, 気圧から, 放射フラックスを計算します.
   208      !
   209      ! Calculate radiation flux from temperature, specific humidity, and
   210      ! air pressure.
   211      !
   212  
   213      ! モジュール引用 ; USE statements
   214      !
   215  
   216      ! ヒストリデータ出力
   217      ! History data output
   218      !
   219      use gtool_historyauto, only: HistoryAutoPut
   220  
   221      ! 物理・数学定数設定
   222      ! Physical and mathematical constants settings
   223      !
   224      use constants0, only: &
   225        & PI
   226                                ! $ \pi $ .
   227                                ! 円周率.  Circular constant
   228  
   229      ! 物理定数設定
   230      ! Physical constants settings
   231      !
   232      use constants, only: &
   233        & GasRDry, &
   234                                ! $ R $ [J kg-1 K-1].
   235                                ! 乾燥大気の気体定数.
   236                                ! Gas constant of air
   237        & CpDry
   238                                ! $ C_p $ [J kg-1 K-1].
   239                                ! 乾燥大気の定圧比熱.
   240                                ! Specific heat of air at constant pressure
   241  
   242      ! 飽和比湿の算出
   243      ! Evaluate saturation specific humidity
   244      !
   245      use saturate, only: &
   246        & xy_CalcQVapSatOnLiq, &
   247        & xy_CalcQVapSatOnSol
   248  
   249      ! 座標データ設定
   250      ! Axes data settings
   251      !
   252      use axesset, only: &
   253        & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   254  
   255      ! 時刻管理
   256      ! Time control
   257      !
   258      use timeset, only: &
   259        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   260        & TimesetClockStart, TimesetClockStop
   261  
   262      ! デバッグ用ユーティリティ
   263      ! Utilities for debug
   264      !
   265      use dc_trace, only: DbgMessage, BeginSub, EndSub
   266  
   267      ! 宣言文 ; Declaration statements
   268      !
   269      implicit none
   270  
   271      character(*), intent(in):: BulkCoefMethod
   272                                !
   273                                ! Method for calculating bulk coefficient
   274      real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   275                                ! $ u $ . 東西風速. Eastward wind
   276      real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   277                                ! $ v $ . 南北風速. Northward wind
   278  
   279      real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   280                                ! $ T $ . 温度 (整数レベル).
   281                                ! Temperature (full level)
   282      real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
   283                                ! $ T $ . 温度 (半整数レベル).
   284                                ! Temperature (half level)
   285      real(DP), intent(in):: xyz_VirTemp (0:imax-1, 1:jmax, 1:kmax)
   286                                ! $ T_v $ . 仮温度 (整数レベル).
   287                                ! Virtual temperature (full level)
   288      real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   289                                ! $ T_v $ . 仮温度 (半整数レベル).
   290                                ! Virtual temperature (half level)
   291      real(DP), intent(in):: xy_SurfVirTemp (0:imax-1, 1:jmax)
   292                                ! $ T_v $ . 仮温度 (惑星表面).
   293                                ! Virtual temperature (surface)
   294      real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   295                                ! $ q $ .     比湿. Specific humidity
   296      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   297                                ! $ p_s $ . 地表面気圧 (半整数レベル).
   298                                ! Surface pressure (half level)
   299      real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
   300                                ! $ z_s $ . 地表面高度.
   301                                ! Surface height.
   302      real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   303                                ! 高度 (整数レベル).
   304                                ! Height (full level)
   305      real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   306                                ! Exner 関数 (整数レベル).
   307                                ! Exner function (full level)
   308      real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   309                                ! Exner 関数 (半整数レベル).
   310                                ! Exner function (half level)
   311      real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   312                                ! 地表面温度.
   313                                ! Surface temperature
   314      real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   315                                ! 地表湿潤度.
   316                                ! Surface humidity coefficient
   317      real(DP), intent(in):: xy_SurfRoughLengthMom (0:imax-1, 1:jmax)
   318                                ! 地表粗度長.
   319                                ! Surface rough length for momentum
   320      real(DP), intent(in):: xy_SurfRoughLengthHeat(0:imax-1, 1:jmax)
   321                                ! 地表粗度長.
   322                                ! Surface rough length for heat
   323      real(DP), intent(in):: xy_SnowFrac(0:imax-1, 1:jmax)
   324                                !
   325                                ! Snow fraction
   326      real(DP), intent(out):: xy_MomFluxX (0:imax-1, 1:jmax)
   327                                ! 惑星表面東西方向運動量フラックス.
   328                                ! Eastward momentum flux at surface
   329      real(DP), intent(out):: xy_MomFluxY (0:imax-1, 1:jmax)
   330                                ! 惑星表面南北方向運動量フラックス.
   331                                ! Northward momentum flux at surface
   332      real(DP), intent(out):: xy_HeatFlux (0:imax-1, 1:jmax)
   333                                ! 惑星表面熱フラックス.
   334                                ! Heat flux at surface
   335      real(DP), intent(out):: xyf_QMixFlux(0:imax-1, 1:jmax, 1:ncmax)
   336                                ! 惑星表面比湿フラックス.
   337                                ! Specific humidity flux at surface
   338      real(DP), intent(out):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   339                                ! 輸送係数：運動量.
   340                                ! Diffusion coefficient: velocity
   341      real(DP), intent(out):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   342                                ! 輸送係数：温度.
   343                                ! Transfer coefficient: temperature
   344      real(DP), intent(out):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   345                                ! 輸送係数：水蒸気
   346                                ! Transfer coefficient: water vapor
   347      real(DP), intent(out):: xy_SurfMOLength(0:imax-1, 1:jmax)
   348  
   349      ! 作業変数
   350      ! Work variables
   351      !
   352      real(DP):: xy_SurfTempBulkCoef (0:imax-1, 1:jmax)
   353                                ! バルク係数：温度.
   354                                ! Bulk coefficient: temperature
   355      real(DP):: xy_SurfQVapBulkCoef (0:imax-1, 1:jmax)
   356                                ! バルク係数：比湿.
   357                                ! Bulk coefficient: specific humidity
   358      real(DP):: xy_SurfVelBulkCoef (0:imax-1, 1:jmax)
   359                                ! バルク係数：運動量.
   360                                ! Bulk coefficient: temperature
   361      real(DP):: xy_SurfVelAbs (0:imax-1, 1:jmax)
   362                                ! 風速絶対値.
   363                                ! Absolute velocity
   364      real(DP):: xy_SurfQVapSatOnLiq (0:imax-1, 1:jmax)
   365                                ! 地表飽和比湿.
   366                                ! Saturated specific humidity on surface
   367      real(DP):: xy_SurfQVapSatOnSol (0:imax-1, 1:jmax)
   368                                ! 地表飽和比湿.
   369                                ! Saturated specific humidity on surface
   370      real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
   371                                ! 地表飽和比湿.
   372                                ! Saturated specific humidity on surface
   373  
   374      real(DP):: xy_MomFluxXSurf (0:imax-1, 1:jmax)
   375                                ! 地表面の東西方向運動量フラックス.
   376                                ! Eastward momentum flux on surface
   377      real(DP):: xy_MomFluxYSurf (0:imax-1, 1:jmax)
   378                                ! 地表面の南北方向運動量フラックス.
   379                                ! Northward momentum flux on surface
   380      real(DP):: xy_HeatFluxSurf (0:imax-1, 1:jmax)
   381                                ! 地表面の熱フラックス.
   382                                ! Heat flux on surface
   383      real(DP):: xyf_QMixFluxSurf(0:imax-1, 1:jmax, 1:ncmax)
   384                                ! 地表面の質量フラックス.
   385                                ! Mass flux of constituents on surface
   386  
   387      real(DP):: xy_BetaW   (0:imax-1, 1:jmax)
   388                                !
   389                                ! "vertical velocity" (B94)
   390  
   391      integer            :: IDBulkCoefMethod
   392  
   393      integer:: i               ! 経度方向に回る DO ループ用作業変数
   394                                ! Work variables for DO loop in longitude
   395      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   396                                ! Work variables for DO loop in latitude
   397      integer:: n               ! 組成方向に回る DO ループ用作業変数
   398                                ! Work variables for DO loop in dimension of constituents
   399  
   400      ! 実行文 ; Executable statement
   401      !
   402  
   403      ! 初期化確認
   404      ! Initialization check
   405      !
   406      if ( .not. surface_flux_bulk_inited ) then
   407        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   408      end if
   409  
   410  
   411      ! 計算時間計測開始
   412      ! Start measurement of computation time
   413      !
   414      call TimesetClockStart( module_name )
   415  
   416  
   417      ! Check method for calculating bulk coefficient
   418      !
   419      if ( BulkCoefMethod == 'L82' ) then
   420        IDBulkCoefMethod = IDBulkCoefMethodL82
   421      else if ( BulkCoefMethod == 'BH91B94' ) then
   422        IDBulkCoefMethod = IDBulkCoefMethodBH91B94
   423      else
   424        call MessageNotify( 'E', module_name, 'BulkCoefMethod of %c is inappropriate.', c1 = trim( BulkCoefMethod ) )
   425      end if
   426  
   427  
   428      ! バルク係数算出
   429      ! Calculate bulk coefficients
   430      !
   431      call BulkCoef( &
   432        & IDBulkCoefMethod, &       ! (in)
   433        & xy_SurfRoughLengthMom ,  & ! (in)
   434        & xy_SurfRoughLengthHeat,  & ! (in)
   435        & xy_SurfHeight,       & ! (in)
   436        & xyz_Height,          & ! (in)
   437        & xyz_U(:,:,1), xyz_V(:,:,1), & ! (in)
   438  !!$      & xy_SurfTemp, xyz_Temp(:,:,1), xyr_Exner(:,:,0), xyz_Exner(:,:,1), & ! (in)
   439        & xy_SurfVirTemp, xyz_VirTemp(:,:,1), xyr_Exner(:,:,0), xyz_Exner(:,:,1), & ! (in)
   440        & xy_SurfVelBulkCoef,  & ! (out)
   441        & xy_SurfTempBulkCoef, & ! (out)
   442        & xy_SurfQVapBulkCoef, & ! (out)
   443        & xy_BetaW,            & ! (out)
   444        & xy_SurfMOLength      & ! (out)
   445        & )
   446  
   447  
   448      !
   449      ! Calculation of wind speed
   450      !
   451      xy_SurfVelAbs = sqrt ( xyz_U(:,:,1)**2 + xyz_V(:,:,1)**2 + xy_BetaW**2 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t753 = 1, jmax*imax                                            
     .           xy_surfvelabs(t753-1,1) = dsqrt(xyz_u(t753-1,1,1)**2+xyz_v(t753
     .       1      -1,1,1)**2+xy_betaw(t753-1,1)**2)                           
     .        enddo                                                             
   452  !!$    xy_SurfVelAbs = sqrt ( xyz_U(:,:,1)**2 + xyz_V(:,:,1)**2 )
   453  
   454  
   455      ! 輸送係数の計算
   456      ! Calculate transfer coefficient
   457      !
   458      if ( .not. FlagFixFricTimeConstAtLB ) then
   459        do i = 0, imax-1
   460          do j = 1, jmax
   461  !!$          xy_SurfVelTransCoef(i,j) = &
   462  !!$            &   xy_SurfVelBulkCoef(i,j) &
   463  !!$            &   * xyr_Press(i,j,0) / ( GasRDry * xyr_Temp(i,j,0) ) &
   464  !!$            &   * min( max( xy_SurfVelAbs(i,j), VelMinForVel ), VelMaxForVel )
   465            xy_SurfVelTransCoef(i,j) =                                  &
   466              &   xy_SurfVelBulkCoef(i,j)                               &
   467              &   * xyr_Press(i,j,0) / ( GasRDry * xyr_VirTemp(i,j,0) ) &
   468              &   * min( max( xy_SurfVelAbs(i,j), VelMinForVel ), VelMaxForVel )
   469          end do
   470        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do i = 1, imax*jmax                                               
     .           xy_surfveltranscoef(i-1,1) = xy_surfvelbulkcoef(i-1,1)*        
     .       1      xyr_press(i-1,1,0)/(gasrdry*xyr_virtemp(i-1,1,0))*min(max(  
     .       2      xy_surfvelabs(i-1,1),velminforvel),velmaxforvel)            
     .        enddo                                                             
     .        goto 10020                                                        
   471      else
   472        do j = 1, jmax
   473          if ( abs( y_Lat(j) ) >= LowLatFricAtLB * PI / 180.0_DP ) then
   474            xy_SurfVelTransCoef(:,j) = 1.0_DP / FricTimeConstAtLB
     .        d1 = 1.D0/frictimeconstatlb                                       
     .  !cdir nodep                                                             
     .        do t892 = 1, imax                                                 
     .           xy_surfveltranscoef(t892-1,j) = 1.00000000000000e+000*d1       
     .        enddo                                                             
     .        goto 10019                                                        
   475          else
   476            xy_SurfVelTransCoef(:,j) = 0.0_DP
   477          end if
   478        end do
   479      end if
   480  
   481      if ( .not. FlagFixHeatFluxAtLB ) then
   482        do i = 0, imax-1
   483          do j = 1, jmax
   484  !!$          xy_SurfTempTransCoef(i,j) = &
   485  !!$            &   xy_SurfTempBulkCoef(i,j) &
   486  !!$            &   * xyr_Press(i,j,0) / ( GasRDry * xyr_Temp(i,j,0) ) &
   487  !!$            &   * min( max( xy_SurfVelAbs(i,j), VelMinForTemp ), VelMaxForTemp )
   488            xy_SurfTempTransCoef(i,j) =                                 &
   489              &   xy_SurfTempBulkCoef(i,j)                              &
   490              &   * xyr_Press(i,j,0) / ( GasRDry * xyr_VirTemp(i,j,0) ) &
   491              &   * min( max( xy_SurfVelAbs(i,j), VelMinForTemp ), VelMaxForTemp )
   492          end do
   493        end do
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do i = 1, imax*jmax                                               
     .           xy_surftemptranscoef(i-1,1) = xy_surftempbulkcoef(i-1,1)*      
     .       1      xyr_press(i-1,1,0)/(gasrdry*xyr_virtemp(i-1,1,0))*min(max(  
     .       2      xy_surfvelabs(i-1,1),velminfortemp),velmaxfortemp)          
     .        enddo                                                             
     .        goto 10027                                                        
   494      else
   495        ! Set meaningless value.
   496        xy_SurfTempTransCoef = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t768 = 1, jmax*imax                                            
     .           xy_surftemptranscoef(t768-1,1) = 0.0000000000000000e+000       
     .        enddo                                                             
   497      end if
   498  
   499      if ( .not. FlagFixMassFluxAtLB ) then
   500        do i = 0, imax-1
   501          do j = 1, jmax
   502  !!$          xy_SurfQVapTransCoef(i,j) =                                            &
   503  !!$            &   xy_SurfQVapBulkCoef(i,j)                                         &
   504  !!$            &   * xyr_Press(i,j,0) / ( GasRDry * xyr_Temp(i,j,0) )               &
   505  !!$            &   * min( max( xy_SurfVelAbs(i,j), VelMinForQVap ), VelMaxForQVap )
   506            xy_SurfQVapTransCoef(i,j) =                                            &
   507              &   xy_SurfQVapBulkCoef(i,j)                                         &
   508              &   * xyr_Press(i,j,0) / ( GasRDry * xyr_VirTemp(i,j,0) )            &
   509              &   * min( max( xy_SurfVelAbs(i,j), VelMinForQVap ), VelMaxForQVap )
   510          end do
   511        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do i = 1, imax*jmax                                               
     .           xy_surfqvaptranscoef(i-1,1) = xy_surfqvapbulkcoef(i-1,1)*      
     .       1      xyr_press(i-1,1,0)/(gasrdry*xyr_virtemp(i-1,1,0))*min(max(  
     .       2      xy_surfvelabs(i-1,1),velminforqvap),velmaxforqvap)          
     .        enddo                                                             
     .        goto 10034                                                        
   512      else
   513        ! Set meaningless value.
   514        xy_SurfQVapTransCoef = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t774 = 1, jmax*imax                                            
     .           xy_surfqvaptranscoef(t774-1,1) = 0.0000000000000000e+000       
     .        enddo                                                             
   515      end if
   516  
   517      ! 飽和比湿の計算
   518      ! Calculate saturated specific humidity
   519      !
   520  !!$    xy_SurfQVapSat = xy_CalcQVapSat( xy_SurfTemp, xyr_Press(:,:,0) )
   521      xy_SurfQVapSatOnLiq = xy_CalcQVapSatOnLiq( xy_SurfTemp, xyr_Press(:,:,0) )
   522      xy_SurfQVapSatOnSol = xy_CalcQVapSatOnSol( xy_SurfTemp, xyr_Press(:,:,0) )
   523      xy_SurfQVapSat = &
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t780 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t782 = 1, imax                                           
     .                 xy_surfqvapsat(t782-1,t780) = (1.00000000000000e+000 -   
     .       1            xy_snowfrac(t782-1,t780))*xy_surfqvapsatonliq(t782-1, 
     .       2            t780) + xy_snowfrac(t782-1,t780)*xy_surfqvapsatonsol( 
     .       3            t782-1,t780)                                          
     .                 xy_momfluxxsurf(t782-1,t780) = -xy_surfveltranscoef(t782-
     .       1            1,t780)*xyz_u(t782-1,t780,1)                          
     .                 xy_momfluxysurf(t782-1,t780) = -xy_surfveltranscoef(t782-
     .       1            1,t780)*xyz_v(t782-1,t780,1)                          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t780 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t782 = 1, imax                                           
     .                 xy_surfqvapsat(t782-1,t780) = (1.00000000000000e+000 -   
     .       1            xy_snowfrac(t782-1,t780))*xy_surfqvapsatonliq(t782-1, 
     .       2            t780) + xy_snowfrac(t782-1,t780)*xy_surfqvapsatonsol( 
     .       3            t782-1,t780)                                          
     .                 xy_surfqvapsat(t782-1,t780+1) = (1.00000000000000e+000 - 
     .       1            xy_snowfrac(t782-1,t780+1))*xy_surfqvapsatonliq(t782-1
     .       2            ,t780+1) + xy_snowfrac(t782-1,t780+1)*                
     .       3            xy_surfqvapsatonsol(t782-1,t780+1)                    
     .                 xy_surfqvapsat(t782-1,t780+2) = (1.00000000000000e+000 - 
     .       1            xy_snowfrac(t782-1,t780+2))*xy_surfqvapsatonliq(t782-1
     .       2            ,t780+2) + xy_snowfrac(t782-1,t780+2)*                
     .       3            xy_surfqvapsatonsol(t782-1,t780+2)                    
     .                 xy_surfqvapsat(t782-1,t780+3) = (1.00000000000000e+000 - 
     .       1            xy_snowfrac(t782-1,t780+3))*xy_surfqvapsatonliq(t782-1
     .       2            ,t780+3) + xy_snowfrac(t782-1,t780+3)*                
     .       3            xy_surfqvapsatonsol(t782-1,t780+3)                    
     .                 xy_momfluxxsurf(t782-1,t780) = -xy_surfveltranscoef(t782-
     .       1            1,t780)*xyz_u(t782-1,t780,1)                          
     .                 xy_momfluxxsurf(t782-1,t780+1) = -xy_surfveltranscoef(   
     .       1            t782-1,t780+1)*xyz_u(t782-1,t780+1,1)                 
     .                 xy_momfluxxsurf(t782-1,t780+2) = -xy_surfveltranscoef(   
     .       1            t782-1,t780+2)*xyz_u(t782-1,t780+2,1)                 
     .                 xy_momfluxxsurf(t782-1,t780+3) = -xy_surfveltranscoef(   
     .       1            t782-1,t780+3)*xyz_u(t782-1,t780+3,1)                 
     .                 xy_momfluxysurf(t782-1,t780) = -xy_surfveltranscoef(t782-
     .       1            1,t780)*xyz_v(t782-1,t780,1)                          
     .                 xy_momfluxysurf(t782-1,t780+1) = -xy_surfveltranscoef(   
     .       1            t782-1,t780+1)*xyz_v(t782-1,t780+1,1)                 
     .                 xy_momfluxysurf(t782-1,t780+2) = -xy_surfveltranscoef(   
     .       1            t782-1,t780+2)*xyz_v(t782-1,t780+2,1)                 
     .                 xy_momfluxysurf(t782-1,t780+3) = -xy_surfveltranscoef(   
     .       1            t782-1,t780+3)*xyz_v(t782-1,t780+3,1)                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   524        &   ( 1.0_DP - xy_SnowFrac ) * xy_SurfQVapSatOnLiq &
   525        & + xy_SnowFrac              * xy_SurfQVapSatOnSol
   526  
   527  
   528      ! 地表面フラックスの計算
   529      ! Calculate fluxes on flux
   530      !
   531      !   Momentum
   532      !
   533      xy_MomFluxXSurf = - xy_SurfVelTransCoef * xyz_U(:,:,1)
   534      xy_MomFluxYSurf = - xy_SurfVelTransCoef * xyz_V(:,:,1)
   535  
   536      !   Heat
   537      !
   538      if ( .not. FlagFixHeatFluxAtLB ) then
   539        xy_HeatFluxSurf = - CpDry * xyr_Exner(:,:,0) * xy_SurfTempTransCoef &
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t874 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t876 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_heatfluxsurf(t876-1,t874) = -cpdry*xyr_exner(t876-1,  
     .       1            t874,0)*xy_surftemptranscoef(t876-1,t874)*(xyz_temp(  
     .       2            t876-1,t874,1)/xyz_exner(t876-1,t874,1)-xy_surftemp(  
     .       3            t876-1,t874)/xyr_exner(t876-1,t874,0))                
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t874 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t876 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_heatfluxsurf(t876-1,t874) = -cpdry*xyr_exner(t876-1,  
     .       1            t874,0)*xy_surftemptranscoef(t876-1,t874)*(xyz_temp(  
     .       2            t876-1,t874,1)/xyz_exner(t876-1,t874,1)-xy_surftemp(  
     .       3            t876-1,t874)/xyr_exner(t876-1,t874,0))                
     .                 xy_heatfluxsurf(t876-1,t874+1) = -cpdry*xyr_exner(t876-1,
     .       1            t874+1,0)*xy_surftemptranscoef(t876-1,t874+1)*(       
     .       2            xyz_temp(t876-1,t874+1,1)/xyz_exner(t876-1,t874+1,1)- 
     .       3            xy_surftemp(t876-1,t874+1)/xyr_exner(t876-1,t874+1,0))
     .                 xy_heatfluxsurf(t876-1,t874+2) = -cpdry*xyr_exner(t876-1,
     .       1            t874+2,0)*xy_surftemptranscoef(t876-1,t874+2)*(       
     .       2            xyz_temp(t876-1,t874+2,1)/xyz_exner(t876-1,t874+2,1)- 
     .       3            xy_surftemp(t876-1,t874+2)/xyr_exner(t876-1,t874+2,0))
     .                 xy_heatfluxsurf(t876-1,t874+3) = -cpdry*xyr_exner(t876-1,
     .       1            t874+3,0)*xy_surftemptranscoef(t876-1,t874+3)*(       
     .       2            xyz_temp(t876-1,t874+3,1)/xyz_exner(t876-1,t874+3,1)- 
     .       3            xy_surftemp(t876-1,t874+3)/xyr_exner(t876-1,t874+3,0))
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10049                                                        
   540          &                   * (   xyz_Temp(:,:,1) / xyz_Exner(:,:,1) &
   541          &                       - xy_SurfTemp     / xyr_Exner(:,:,0) )
   542      else
   543        xy_HeatFluxSurf = HeatFluxAtLB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t806 = 1, xy_heatfluxsurf.DSC.U2*xy_heatfluxsurf.DSC.U1 +      
     .       1   xy_heatfluxsurf.DSC.U2                                         
     .           xy_heatfluxsurf(t806-1,1) = heatfluxatlb                       
     .        enddo                                                             
   544      end if
   545  
   546      !   Mass
   547      !
   548      if ( .not. FlagFixMassFluxAtLB ) then
   549        xyf_QMixFluxSurf(:,:,IndexH2OVap) =                      &
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t860 = 1, j3                                                
     .  !cdir       nodep                                                       
     .              do t862 = 1, 1 + imax - min0(1,imax)                        
     .                 xyf_qmixfluxsurf(t862-1,t860,indexh2ovap) = -            
     .       1            xy_surfhumidcoef(t862-1,t860)*xy_surfqvaptranscoef(   
     .       2            t862-1,t860)*(xyzf_qmix(t862-1,t860,1,indexh2ovap)-   
     .       3            xy_surfqvapsat(t862-1,t860))                          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t860 = j3 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t862 = 1, 1 + imax - min0(1,imax)                        
     .                 xyf_qmixfluxsurf(t862-1,t860,indexh2ovap) = -            
     .       1            xy_surfhumidcoef(t862-1,t860)*xy_surfqvaptranscoef(   
     .       2            t862-1,t860)*(xyzf_qmix(t862-1,t860,1,indexh2ovap)-   
     .       3            xy_surfqvapsat(t862-1,t860))                          
     .                 xyf_qmixfluxsurf(t862-1,t860+1,indexh2ovap) = -          
     .       1            xy_surfhumidcoef(t862-1,t860+1)*xy_surfqvaptranscoef( 
     .       2            t862-1,t860+1)*(xyzf_qmix(t862-1,t860+1,1,indexh2ovap)
     .       3            -xy_surfqvapsat(t862-1,t860+1))                       
     .                 xyf_qmixfluxsurf(t862-1,t860+2,indexh2ovap) = -          
     .       1            xy_surfhumidcoef(t862-1,t860+2)*xy_surfqvaptranscoef( 
     .       2            t862-1,t860+2)*(xyzf_qmix(t862-1,t860+2,1,indexh2ovap)
     .       3            -xy_surfqvapsat(t862-1,t860+2))                       
     .                 xyf_qmixfluxsurf(t862-1,t860+3,indexh2ovap) = -          
     .       1            xy_surfhumidcoef(t862-1,t860+3)*xy_surfqvaptranscoef( 
     .       2            t862-1,t860+3)*(xyzf_qmix(t862-1,t860+3,1,indexh2ovap)
     .       3            -xy_surfqvapsat(t862-1,t860+3))                       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10056                                                        
   550          & - xy_SurfHumidCoef * xy_SurfQVapTransCoef(:,:)       &
   551          & * ( xyzf_QMix(:,:,1,IndexH2OVap) - xy_SurfQVapSat )
   552      else
   553        xyf_QMixFluxSurf(:,:,IndexH2OVap) = MassFluxAtLB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t812 = 1, xyf_qmixfluxsurf.DSC.U2*xyf_qmixfluxsurf.DSC.U1 +    
     .       1   xyf_qmixfluxsurf.DSC.U2                                        
     .           xyf_qmixfluxsurf(t812-1,1,indexh2ovap) = massfluxatlb          
     .        enddo                                                             
   554      end if
   555      !
   556      xyf_QMixFluxSurf(:,:,1:IndexH2OVap-1)     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t818 = 1, (indexh2ovap - 1)*xyf_qmixfluxsurf.DSC.U2*(          
     .       1   xyf_qmixfluxsurf.DSC.U1 + 1)                                   
     .           xyf_qmixfluxsurf(t818-1,1,1) = 0.0000000000000000e+000         
     .        enddo                                                             
   557      xyf_QMixFluxSurf(:,:,IndexH2OVap+1:ncmax) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t827 = 1, (ncmax - indexh2ovap)*(xyf_qmixfluxsurf.DSC.U2*      
     .       1   xyf_qmixfluxsurf.DSC.U1 + xyf_qmixfluxsurf.DSC.U2)             
     .           xyf_qmixfluxsurf(t827-1,1,1+indexh2ovap) =                     
     .       1      0.0000000000000000e+000                                     
     .        enddo                                                             
   558  
   559      ! Surface flux of constituents except for water vapor is zero.
   560  !!$    write( 6, * ) "MEMO: Surface flux of constituents except for water vapor is zero. (YOT, 2009/08/14)"
   561  
   562  
   563      ! フラックスの計算
   564      ! Calculate fluxes
   565      !
   566      xy_MomFluxX = xy_MomFluxXSurf
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t836 = 1, jmax*imax                                            
     .           xy_momfluxx(t836-1,1) = xy_momfluxxsurf(t836-1,1)              
     .           xy_momfluxy(t836-1,1) = xy_momfluxysurf(t836-1,1)              
     .           xy_heatflux(t836-1,1) = xy_heatfluxsurf(t836-1,1)              
     .        enddo                                                             
   567      xy_MomFluxY = xy_MomFluxYSurf
   568      xy_HeatFlux = xy_HeatFluxSurf
   569      do n = 1, ncmax
   570        xyf_QMixFlux(:,:,n) = xyf_QMixFluxSurf(:,:,n)
   571      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do n = 1, ncmax*jmax*imax                                         
     .           xyf_qmixflux(n-1,1,1) = xyf_qmixfluxsurf(n-1,1,1)              
     .        enddo                                                             
   572  
   573      ! ヒストリデータ出力
   574      ! History data output
   575      !
   576      call HistoryAutoPut( TimeN, 'BulkCoefMom' , xy_SurfVelBulkCoef   )
   577      call HistoryAutoPut( TimeN, 'BulkCoefHeat', xy_SurfTempBulkCoef  )
   578  
   579      ! 計算時間計測一時停止
   580      ! Pause measurement of computation time
   581      !
   582      call TimesetClockStop( module_name )
   583  
   584    end subroutine SurfaceFlux
   585  
   586    !--------------------------------------------------------------------------------------
   587  
   588    subroutine BulkCoef( &
   589      & IDBulkCoefMethod, &       ! (in)
   590      & xy_SurfRoughLengthMom ,  & ! (in)
   591      & xy_SurfRoughLengthHeat,  & ! (in)
   592      & xy_SurfHeight,          & ! (in)
   593      & xyz_Height,             & ! (in)
   594      & xy_U, xy_V,                                   & ! (in)
   595      & xy_SurfVirTemp, xy_VirTemp, xy_SurfExner, xy_Exner, & ! (in)
   596      & xy_SurfVelBulkCoef,     & ! (out)
   597      & xy_SurfTempBulkCoef,    & ! (out)
   598      & xy_SurfQVapBulkCoef,    & ! (out)
   599      & xy_BetaW,               & ! (out)
   600      & xy_SurfMOLength         & ! (out)
   601      & )
   602      !
   603      ! バルク係数を算出します.
   604      !
   605      ! Bulk coefficients are calculated.
   606      !
   607  
   608      ! モジュール引用 ; USE statements
   609      !
   610  
   611      ! ヒストリデータ出力
   612      ! History data output
   613      !
   614      use gtool_historyauto, only: HistoryAutoPut
   615  
   616      ! 時刻管理
   617      ! Time control
   618      !
   619      use timeset, only: &
   620        & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $.
   621  
   622      ! 物理定数設定
   623      ! Physical constants settings
   624      !
   625      use constants, only: &
   626        & Grav, &               ! $ g $ [m s-2].
   627                                ! 重力加速度.
   628                                ! Gravitational acceleration
   629        & FKarm                 ! $ k $ .
   630                                ! カルマン定数.
   631                                ! Karman constant
   632  
   633      ! 宣言文 ; Declaration statements
   634      !
   635  
   636      integer , intent(in):: IDBulkCoefMethod
   637                                !
   638                                !
   639      real(DP), intent(in):: xy_SurfRoughLengthMom (0:imax-1, 1:jmax)
   640                                ! 地表粗度長
   641                                ! Surface rough length for momentum
   642      real(DP), intent(in):: xy_SurfRoughLengthHeat(0:imax-1, 1:jmax)
   643                                ! 地表粗度長
   644                                ! Surface rough length for heat
   645      real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
   646                                ! $ z_s $ . 地表面高度.
   647                                ! Surface height.
   648      real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   649                                ! 高度.
   650                                ! Height
   651      real(DP), intent(in):: xy_U (0:imax-1, 1:jmax)
   652                                !
   653                                ! Eastward wind velocity at lowest level
   654      real(DP), intent(in):: xy_V (0:imax-1, 1:jmax)
   655                                !
   656                                ! Northward wind velocity at lowest level
   657      real(DP), intent(in):: xy_SurfVirTemp (0:imax-1, 1:jmax)
   658                                !
   659                                ! Surface virtual temperature
   660      real(DP), intent(in):: xy_SurfExner(0:imax-1, 1:jmax)
   661                                !
   662                                ! Exner function at the surface
   663      real(DP), intent(in):: xy_VirTemp     (0:imax-1, 1:jmax)
   664                                !
   665                                ! Virtual temperature at lowest layer
   666      real(DP), intent(in):: xy_Exner    (0:imax-1, 1:jmax)
   667                                !
   668                                ! Exner function at lowest layer
   669      real(DP), intent(out):: xy_SurfVelBulkCoef (0:imax-1, 1:jmax)
   670                                ! バルク係数：運動量.
   671                                ! Bulk coefficient: temperature
   672      real(DP), intent(out):: xy_SurfTempBulkCoef (0:imax-1, 1:jmax)
   673                                ! バルク係数：温度.
   674                                ! Bulk coefficient: temperature
   675      real(DP), intent(out):: xy_SurfQVapBulkCoef (0:imax-1, 1:jmax)
   676                                ! バルク係数：比湿.
   677                                ! Bulk coefficient: specific humidity
   678      real(DP), intent(out):: xy_BetaW   (0:imax-1, 1:jmax)
   679                                !
   680                                ! "vertical velocity" (B94)
   681      real(DP), intent(out):: xy_SurfMOLength(0:imax-1, 1:jmax)
   682                                !
   683                                ! Monin-Obukov length
   684  
   685      ! 作業変数
   686      ! Work variables
   687      !
   688      real(DP):: xy_SurfBulkRiNum (0:imax-1, 1:jmax)
   689                                ! バルク $ R_i $ 数.
   690                                ! Bulk $ R_i $ number
   691      real(DP):: xy_SurfVelAbs (0:imax-1, 1:jmax)
   692                                ! 風速絶対値.
   693                                ! Absolute velocity
   694      real(DP) :: xy_SurfBulkCoefMomInNeutCond    (0:imax-1, 1:jmax)
   695      real(DP) :: xy_SurfBulkCoefHeatInNeutCond   (0:imax-1, 1:jmax)
   696  
   697      integer:: i               ! 経度方向に回る DO ループ用作業変数
   698                                ! Work variables for DO loop in longitude
   699      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   700                                ! Work variables for DO loop in latitude
   701  
   702      ! 実行文 ; Executable statement
   703      !
   704  
   705      if ( FlagConstBulkCoef ) then
   706  
   707        ! Use of constant bulk coefficient
   708        !
   709  
   710        xy_SurfVelBulkCoef  = ConstBulkCoef
   711        xy_SurfTempBulkCoef = ConstBulkCoef
   712        xy_SurfQVapBulkCoef = ConstBulkCoef
   713  
   714        xy_BetaW = 0.0_DP
   715  
   716        xy_SurfBulkRiNum = 0.0_DP
   717  
   718      else
   719  
   720        select case ( IDBulkCoefMethod )
   721        case ( IDBulkCoefMethodL82 )
   722  
   723          ! Parameterization by Louis et al. (1982)
   724          !
   725  
   726          ! 中立バルク係数の計算
   727          ! Calculate bulk coefficient in neutral condition
   728          !
   729          xy_SurfBulkCoefMomInNeutCond  =                     &
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t317 = 1, jmax*imax                                            
     .           xy_surfbulkcoefmominneutcond(t317-1,1) = (4.00000000000000e-001
     .       1      /(dlog((((xyz_height(t317-1,1,1)-xy_surfheight(t317-1,1))+  
     .       2      xy_surfroughlengthmom(t317-1,1))/xy_surfroughlengthmom(t317-
     .       3      1,1)))))**2                                                 
     .           xy_surfbulkcoefheatinneutcond(t317-1,1) = (                    
     .       1      4.00000000000000e-001/(dlog((((xyz_height(t317-1,1,1)-      
     .       2      xy_surfheight(t317-1,1))+xy_surfroughlengthmom(t317-1,1))/  
     .       3      xy_surfroughlengthmom(t317-1,1)))))*(4.00000000000000e-001/ 
     .       4      dlog(((xyz_height(t317-1,1,1)-xy_surfheight(t317-1,1))+     
     .       5      xy_surfroughlengthheat(t317-1,1))/xy_surfroughlengthheat(   
     .       6      t317-1,1)))                                                 
     .        enddo                                                             
   730            & ( FKarm                                         &
   731            & / log (   ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthMom ) &
   732            &         / xy_SurfRoughLengthMom  ) )**2
   733          xy_SurfBulkCoefHeatInNeutCond  =                    &
   734            &   ( FKarm                                       &
   735            & / log (   ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthMom ) &
   736            &         / xy_SurfRoughLengthMom  ) )            &
   737            & * ( FKarm                                       &
   738            & / log (   ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthHeat ) &
   739            &         / xy_SurfRoughLengthHeat ) )
   740  
   741          if ( FlagUseOfBulkCoefInNeutralCond ) then
   742  
   743            ! 中立条件でのバルク係数の設定
   744            ! Set bulk coefficient in neutral condition
   745            !
   746  
   747            xy_SurfVelBulkCoef  = xy_SurfBulkCoefMomInNeutCond
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t385 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t387 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surfvelbulkcoef(t387-1,t385) =                        
     .       1            xy_surfbulkcoefmominneutcond(t387-1,t385)             
     .                 xy_surftempbulkcoef(t387-1,t385) =                       
     .       1            xy_surfbulkcoefheatinneutcond(t387-1,t385)            
     .                 xy_surfqvapbulkcoef(t387-1,t385) = xy_surftempbulkcoef(  
     .       1            t387-1,t385)                                          
     .                 xy_surfbulkrinum(t387-1,t385) = 0.0000000000000000e+000  
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t385 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t387 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surfvelbulkcoef(t387-1,t385) =                        
     .       1            xy_surfbulkcoefmominneutcond(t387-1,t385)             
     .                 xy_surfvelbulkcoef(t387-1,t385+1) =                      
     .       1            xy_surfbulkcoefmominneutcond(t387-1,t385+1)           
     .                 xy_surfvelbulkcoef(t387-1,t385+2) =                      
     .       1            xy_surfbulkcoefmominneutcond(t387-1,t385+2)           
     .                 xy_surfvelbulkcoef(t387-1,t385+3) =                      
     .       1            xy_surfbulkcoefmominneutcond(t387-1,t385+3)           
     .                 xy_surftempbulkcoef(t387-1,t385) =                       
     .       1            xy_surfbulkcoefheatinneutcond(t387-1,t385)            
     .                 xy_surftempbulkcoef(t387-1,t385+1) =                     
     .       1            xy_surfbulkcoefheatinneutcond(t387-1,t385+1)          
     .                 xy_surftempbulkcoef(t387-1,t385+2) =                     
     .       1            xy_surfbulkcoefheatinneutcond(t387-1,t385+2)          
     .                 xy_surftempbulkcoef(t387-1,t385+3) =                     
     .       1            xy_surfbulkcoefheatinneutcond(t387-1,t385+3)          
     .                 xy_surfqvapbulkcoef(t387-1,t385) = xy_surftempbulkcoef(  
     .       1            t387-1,t385)                                          
     .                 xy_surfqvapbulkcoef(t387-1,t385+1) = xy_surftempbulkcoef(
     .       1            t387-1,t385+1)                                        
     .                 xy_surfqvapbulkcoef(t387-1,t385+2) = xy_surftempbulkcoef(
     .       1            t387-1,t385+2)                                        
     .                 xy_surfqvapbulkcoef(t387-1,t385+3) = xy_surftempbulkcoef(
     .       1            t387-1,t385+3)                                        
     .                 xy_surfbulkrinum(t387-1,t385) = 0.0000000000000000e+000  
     .                 xy_surfbulkrinum(t387-1,t385+1) = 0.0000000000000000e+000
     .                 xy_surfbulkrinum(t387-1,t385+2) = 0.0000000000000000e+000
     .                 xy_surfbulkrinum(t387-1,t385+3) = 0.0000000000000000e+000
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10024                                                        
   748            xy_SurfTempBulkCoef = xy_SurfBulkCoefHeatInNeutCond
   749  
   750            xy_SurfQVapBulkCoef = xy_SurfTempBulkCoef
   751  
   752            xy_SurfBulkRiNum = 0.0_DP
   753  
   754          else
   755  
   756            ! バルク $ R_i $ 数算出
   757            ! Calculate bulk $ R_i $
   758            !
   759            xy_SurfVelAbs = sqrt ( xy_U**2 + xy_V**2 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t349 = 1, jmax*imax                                            
     .           xy_surfvelabs1 = dsqrt(xy_u(t349-1,1)**2+xy_v(t349-1,1)**2)    
     .           xy_surfbulkrinum(t349-1,1) = grav/(xy_surfvirtemp(t349-1,1)/   
     .       1      xy_surfexner(t349-1,1))*(xy_virtemp(t349-1,1)/xy_exner(t349-
     .       2      1,1)-(xy_surfvirtemp(t349-1,1)/xy_surfexner(t349-1,1)))/max(
     .       3      xy_surfvelabs1,velminforri)**2*(xyz_height(t349-1,1,1)-     
     .       4      xy_surfheight(t349-1,1))                                    
     .        enddo                                                             
   760            xy_SurfBulkRiNum =                                 &
   761              &   Grav / ( xy_SurfVirTemp / xy_SurfExner )     &
   762              &   * (   xy_VirTemp     / xy_Exner              &
   763              &       - xy_SurfVirTemp / xy_SurfExner )        &
   764              &   / max( xy_SurfVelAbs, VelMinForRi )**2       &
   765              &   * ( xyz_Height(:,:,1) - xy_SurfHeight )
   766  
   767            ! 非中立条件でのバルク係数の計算
   768            ! Calculate bulk coefficients in non-neutral condition
   769            !
   770  
   771            call BulkCoefL82( &
   772              & xy_SurfBulkRiNum, &       ! (in)
   773              & xy_SurfRoughLengthMom ,  & ! (in)
   774              & xy_SurfRoughLengthHeat,  & ! (in)
   775              & xy_SurfHeight,          & ! (in)
   776              & xyz_Height,             & ! (in)
   777              & xy_SurfBulkCoefMomInNeutCond,  & ! (in)
   778              & xy_SurfBulkCoefHeatInNeutCond, & ! (in)
   779              & xy_SurfVelBulkCoef,     & ! (out)
   780              & xy_SurfTempBulkCoef,    & ! (out)
   781              & xy_SurfQVapBulkCoef,    & ! (out)
   782              & xy_SurfMOLength         & ! (out)
   783              & )
   784  
   785          end if
   786  
   787          xy_BetaW = 0.0_DP
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t379 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t381 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_betaw(t381-1,t379) = 0.0000000000000000e+000          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t379 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t381 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_betaw(t381-1,t379) = 0.0000000000000000e+000          
     .                 xy_betaw(t381-1,t379+1) = 0.0000000000000000e+000        
     .                 xy_betaw(t381-1,t379+2) = 0.0000000000000000e+000        
     .                 xy_betaw(t381-1,t379+3) = 0.0000000000000000e+000        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10003                                                        
   788  
   789        case ( IDBulkCoefMethodBH91B94 )
   790  
   791          ! Parameterization by Beljaars and Holtslag (1991), Beljaars (1994)
   792          !
   793  
   794          call BulkCoefBH91B94( &
   795            & xy_SurfRoughLengthMom , & ! (in)
   796            & xy_SurfRoughLengthHeat, & ! (in)
   797            & xy_SurfHeight,          & ! (in)
   798            & xyz_Height,             & ! (in)
   799            & xy_U, xy_V,                                   & ! (in)
   800            & xy_SurfVirTemp, xy_VirTemp, xy_SurfExner, xy_Exner, & ! (in)
   801            & xy_SurfVelBulkCoef,     & ! (out)
   802            & xy_SurfTempBulkCoef,    & ! (out)
   803            & xy_SurfQVapBulkCoef,    & ! (out)
   804            & xy_BetaW,               & ! (out)
   805            & xy_SurfBulkRiNum,       & ! (out)
   806            & xy_SurfMOLength         & ! (out)
   807            & )
   808  
   809        end select
   810  
   811      end if
   812  
   813  
   814      ! 最大/最小 判定
   815      ! Measure maximum/minimum
   816      !
   817      do i = 0, imax-1
   818        do j = 1, jmax
   819  
   820          xy_SurfVelBulkCoef(i,j)  = &
   821            & max( min( xy_SurfVelBulkCoef(i,j), VelBulkCoefMax ), &
   822            &      VelBulkCoefMin )
   823  
   824          xy_SurfTempBulkCoef(i,j) = &
   825            & max( min( xy_SurfTempBulkCoef(i,j), TempBulkCoefMax ), &
   826            &      TempBulkCoefMin )
   827  
   828          xy_SurfQVapBulkCoef(i,j) = &
   829            & max( min( xy_SurfQVapBulkCoef(i,j), QVapBulkCoefMax ), &
   830            &      QVapBulkCoefMin )
   831  
   832        end do
   833      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do i = 1, imax*jmax                                               
     .           xy_surfvelbulkcoef(i-1,1) = max(min(xy_surfvelbulkcoef(i-1,1), 
     .       1      velbulkcoefmax),velbulkcoefmin)                             
     .           xy_surftempbulkcoef(i-1,1) = max(min(xy_surftempbulkcoef(i-1,1)
     .       1      ,tempbulkcoefmax),tempbulkcoefmin)                          
     .           xy_surfqvapbulkcoef(i-1,1) = max(min(xy_surfqvapbulkcoef(i-1,1)
     .       1      ,qvapbulkcoefmax),qvapbulkcoefmin)                          
     .        enddo                                                             
   834  
   835      ! ヒストリデータ出力
   836      ! History data output
   837      !
   838      call HistoryAutoPut( TimeN, 'SfcBulkRi', xy_SurfBulkRiNum )
   839  
   840  
   841    end subroutine BulkCoef
   842  
   843    !--------------------------------------------------------------------------------------
   844  
   845    subroutine BulkCoefL82( &
   846      & xy_SurfBulkRiNum, &       ! (in)
   847      & xy_SurfRoughLengthMom ,  & ! (in)
   848      & xy_SurfRoughLengthHeat,  & ! (in)
   849      & xy_SurfHeight,          & ! (in)
   850      & xyz_Height,             & ! (in)
   851      & xy_SurfBulkCoefMomInNeutCond, & ! (in)
   852      & xy_SurfBulkCoefHeatInNeutCond, & ! (in)
   853      & xy_SurfVelBulkCoef,     & ! (out)
   854      & xy_SurfTempBulkCoef,    & ! (out)
   855      & xy_SurfQVapBulkCoef,    & ! (out)
   856      & xy_SurfMOLength         & ! (out)
   857      & )
   858      !
   859      ! バルク係数を算出します.
   860      !
   861      ! Bulk coefficients are calculated.
   862      !
   863  
   864      ! モジュール引用 ; USE statements
   865      !
   866      ! 物理定数設定
   867      ! Physical constants settings
   868      !
   869      use constants, only: &
   870        & FKarm                 ! $ k $ .
   871                                ! カルマン定数.
   872                                ! Karman constant
   873  
   874      ! 宣言文 ; Declaration statements
   875      !
   876  
   877      real(DP), intent(in):: xy_SurfBulkRiNum (0:imax-1, 1:jmax)
   878                                ! バルク $ R_i $ 数.
   879                                ! Bulk $ R_i $ number
   880      real(DP), intent(in):: xy_SurfRoughLengthMom (0:imax-1, 1:jmax)
   881                                ! 地表粗度長
   882                                ! Surface rough length for momentum
   883      real(DP), intent(in):: xy_SurfRoughLengthHeat(0:imax-1, 1:jmax)
   884                                ! 地表粗度長
   885                                ! Surface rough length for heat
   886      real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
   887                                ! $ z_s $ . 地表面高度.
   888                                ! Surface height.
   889      real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   890                                ! 高度.
   891                                ! Height
   892      real(DP), intent(in):: xy_SurfBulkCoefMomInNeutCond (0:imax-1, 1:jmax)
   893                                !
   894                                !
   895      real(DP), intent(in):: xy_SurfBulkCoefHeatInNeutCond(0:imax-1, 1:jmax)
   896                                !
   897                                !
   898      real(DP), intent(out):: xy_SurfVelBulkCoef (0:imax-1, 1:jmax)
   899                                ! バルク係数：運動量.
   900                                ! Bulk coefficient: temperature
   901      real(DP), intent(out):: xy_SurfTempBulkCoef (0:imax-1, 1:jmax)
   902                                ! バルク係数：温度.
   903                                ! Bulk coefficient: temperature
   904      real(DP), intent(out):: xy_SurfQVapBulkCoef (0:imax-1, 1:jmax)
   905                                ! バルク係数：比湿.
   906                                ! Bulk coefficient: specific humidity
   907      real(DP), intent(out):: xy_SurfMOLength(0:imax-1, 1:jmax)
   908  
   909      ! 作業変数
   910      ! Work variables
   911      !
   912      real(DP) :: SurfBulkRiNum
   913      real(DP) :: xy_MOLength(0:imax-1, 1:jmax)
   914  
   915      integer:: i               ! 経度方向に回る DO ループ用作業変数
   916                                ! Work variables for DO loop in longitude
   917      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   918                                ! Work variables for DO loop in latitude
   919  
   920      ! 実行文 ; Executable statement
   921      !
   922  
   923      ! 非中立条件でのバルク係数の計算
   924      ! Calculate bulk coefficients in non-neutral condition
   925      !
   926      ! Parameterization by Louis et al. (1982)
   927      !
   928      do j = 1, jmax
   929        do i = 0, imax-1
   930  
   931          if ( xy_SurfBulkRiNum(i,j) > 0.0_DP ) then
   932  
   933            xy_SurfVelBulkCoef(i,j) =                                       &
   934              &   xy_SurfBulkCoefMomInNeutCond(i,j)                         &
   935              &   / (   1.0_DP                                              &
   936              &       + 10.0_DP * xy_SurfBulkRiNum(i,j)                     &
   937              &         / sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) )   &
   938              &     )
   939  
   940            xy_SurfTempBulkCoef(i,j) =                                      &
   941              &   xy_SurfBulkCoefHeatInNeutCond(i,j)                        &
   942              &   / (   1.0_DP                                              &
   943              &       + 15.0_DP * xy_SurfBulkRiNum(i,j)                     &
   944              &         * sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) )   &
   945              &     )
   946  
   947            xy_SurfQVapBulkCoef(i,j) = xy_SurfTempBulkCoef(i,j)
   948  
   949          else
   950  
   951            xy_SurfVelBulkCoef(i,j) =                                              &
   952              &   xy_SurfBulkCoefMomInNeutCond(i,j)                                &
   953              &   * (   1.0_DP                                                     &
   954              &       - 10.0_DP * xy_SurfBulkRiNum(i,j)                            &
   955              &         / (   1.0_DP                                               &
   956              &             + 75.0_DP * xy_SurfBulkCoefMomInNeutCond(i,j)          &
   957              &               * sqrt( - ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) + xy_SurfRoughLengthMom(i,j) ) &
   958              &                         / xy_SurfRoughLengthMom(i,j)               &
   959              &                         * xy_SurfBulkRiNum(i,j)                    &
   960              &                     )                                              &
   961              &           )                                                        &
   962              &     )
   963  
   964            xy_SurfTempBulkCoef(i,j) =                                             &
   965              &   xy_SurfBulkCoefHeatInNeutCond(i,j)                               &
   966              &   * (   1.0_DP                                                     &
   967              &       - 15.0_DP * xy_SurfBulkRiNum(i,j)                            &
   968              &         / (   1.0_DP                                               &
   969              &             + 75.0_DP * xy_SurfBulkCoefHeatInNeutCond(i,j)         &
   970              &               * sqrt( - ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) + xy_SurfRoughLengthHeat(i,j) ) &
   971              &                         / xy_SurfRoughLengthHeat(i,j)              &
   972              &                         * xy_SurfBulkRiNum(i,j)                    &
   973              &                     )                                              &
   974              &           )                                                        &
   975              &     )
   976  
   977            xy_SurfQVapBulkCoef(i,j) = xy_SurfTempBulkCoef(i,j)
   978  
   979          end if
   980  
   981          ! Calculation of Monin-Obukhov length
   982          SurfBulkRiNum = xy_SurfBulkRiNum(i,j)
   983          if ( SurfBulkRiNum == 0.0_DP ) SurfBulkRiNum = 1.0e-10_DP
   984          xy_MOLength(i,j) =                               &
   985            &   ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) ) &
   986            & / ( FKarm * SurfBulkRiNum )                  &
   987            & * xy_SurfVelBulkCoef(i,j)**1.5_DP / xy_SurfTempBulkCoef(i,j)
   988  
   989        end do
   990      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surfbulkrinum(j-1,1) .gt. 0.0000000000000000e+000) then 
     .              xy_surfvelbulkcoef1 = xy_surfbulkcoefmominneutcond(j-1,1)/( 
     .       1         1.00000000000000e+000 + 1.00000000000000e+001*           
     .       2         xy_surfbulkrinum(j-1,1)/(dsqrt((1.00000000000000e+000+(  
     .       3         5.00000000000000e+000*xy_surfbulkrinum(j-1,1))))))       
     .              xy_surftempbulkcoef2 = xy_surfbulkcoefheatinneutcond(j-1,1)/
     .       1         (1.00000000000000e+000 + 1.50000000000000e+001*          
     .       2         xy_surfbulkrinum(j-1,1)*(dsqrt((1.00000000000000e+000+(  
     .       3         5.00000000000000e+000*xy_surfbulkrinum(j-1,1))))))       
     .              xy_surfqvapbulkcoef3 = xy_surftempbulkcoef2                 
     .           else                                                           
     .              xy_surfvelbulkcoef1 = xy_surfbulkcoefmominneutcond(j-1,1)*( 
     .       1         1.00000000000000e+000 - 1.00000000000000e+001*           
     .       2         xy_surfbulkrinum(j-1,1)/(1.00000000000000e+000+          
     .       3         7.50000000000000e+001*xy_surfbulkcoefmominneutcond(j-1,1)
     .       4         *dsqrt((-((xyz_height(j-1,1,1)-xy_surfheight(j-1,1))+    
     .       5         xy_surfroughlengthmom(j-1,1))/xy_surfroughlengthmom(j-1,1
     .       6         )*xy_surfbulkrinum(j-1,1)))))                            
     .              xy_surftempbulkcoef2 = xy_surfbulkcoefheatinneutcond(j-1,1)*
     .       1         (1.00000000000000e+000 - 1.50000000000000e+001*          
     .       2         xy_surfbulkrinum(j-1,1)/(1.00000000000000e+000+          
     .       3         7.50000000000000e+001*xy_surfbulkcoefheatinneutcond(j-1,1
     .       4         )*dsqrt((-((xyz_height(j-1,1,1)-xy_surfheight(j-1,1))+   
     .       5         xy_surfroughlengthheat(j-1,1))/xy_surfroughlengthheat(j-1
     .       6         ,1)*xy_surfbulkrinum(j-1,1)))))                          
     .              xy_surfqvapbulkcoef3 = xy_surftempbulkcoef2                 
     .           endif                                                          
     .           xy_surfqvapbulkcoef(j-1,1) = xy_surfqvapbulkcoef3              
     .           xy_surftempbulkcoef(j-1,1) = xy_surftempbulkcoef2              
     .           xy_surfvelbulkcoef(j-1,1) = xy_surfvelbulkcoef1                
     .           surfbulkrinum = xy_surfbulkrinum(j-1,1)                        
     .           if (surfbulkrinum .eq. 0.0000000000000000e+000) then           
     .              surfbulkrinum = 1.00000000000000e-010                       
     .           endif                                                          
     .           xy_molength(j-1,1) = (xyz_height(j-1,1,1)-xy_surfheight(j-1,1))
     .       1      /(4.00000000000000e-001*surfbulkrinum)*xy_surfvelbulkcoef(j-
     .       2      1,1)**1.50000000000000e+000/xy_surftempbulkcoef(j-1,1)      
     .        enddo                                                             
   991  
   992      xy_SurfMOLength = xy_MOLength
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t281 = 1, jmax*imax                                            
     .           xy_surfmolength(t281-1,1) = xy_molength(t281-1,1)              
     .        enddo                                                             
   993  
   994  
   995    end subroutine BulkCoefL82
   996  
   997    !--------------------------------------------------------------------------------------
   998  
   999    subroutine BulkCoefBH91B94( &
  1000      & xy_SurfRoughLengthMom ,                       & ! (in)
  1001      & xy_SurfRoughLengthHeat,                       & ! (in)
  1002      & xy_SurfHeight,                                & ! (in)
  1003      & xyz_Height,                                   & ! (in)
  1004      & xy_U, xy_V,                                   & ! (in)
  1005      & xy_SurfVirTemp, xy_VirTemp, xy_SurfExner, xy_Exner, & ! (in)
  1006      & xy_SurfVelBulkCoef,                           & ! (out)
  1007      & xy_SurfTempBulkCoef,                          & ! (out)
  1008      & xy_SurfQVapBulkCoef,                          & ! (out)
  1009      & xy_BetaW,                                     & ! (out)
  1010      & xy_SurfBulkRiNum,                             & ! (out)
  1011      & xy_SurfMOLength                               & ! (out)
  1012      & )
  1013      !
  1014      ! バルク係数を算出します.
  1015      !
  1016      ! Bulk coefficients are calculated.
  1017      !
  1018  
  1019      ! モジュール引用 ; USE statements
  1020      !
  1021  
  1022      ! ヒストリデータ出力
  1023      ! History data output
  1024      !
  1025      use gtool_historyauto, only: HistoryAutoPut
  1026  
  1027  !!$    ! MPI 関連ルーチン
  1028  !!$    ! MPI related routines
  1029  !!$    !
  1030  !!$    use mpi_wrapper, only : MPIWrapperChkTrue
  1031  
  1032      ! 時刻管理
  1033      ! Time control
  1034      !
  1035      use timeset, only: &
  1036        & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $.
  1037  
  1038      ! 物理定数設定
  1039      ! Physical constants settings
  1040      !
  1041      use constants, only: &
  1042        & Grav, &               ! $ g $ [m s-2].
  1043                                ! 重力加速度.
  1044                                ! Gravitational acceleration
  1045        & FKarm                 ! $ k $ .
  1046                                ! カルマン定数.
  1047                                ! Karman constant
  1048  
  1049      ! 宣言文 ; Declaration statements
  1050      !
  1051  
  1052      real(DP), intent(in):: xy_SurfRoughLengthMom (0:imax-1, 1:jmax)
  1053                                ! 地表粗度長
  1054                                ! Surface rough length for momentum
  1055      real(DP), intent(in):: xy_SurfRoughLengthHeat(0:imax-1, 1:jmax)
  1056                                ! 地表粗度長
  1057                                ! Surface rough length for heat
  1058      real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
  1059                                ! $ z_s $ . 地表面高度.
  1060                                ! Surface height.
  1061      real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
  1062                                ! 高度.
  1063                                ! Height
  1064      real(DP), intent(in):: xy_U (0:imax-1, 1:jmax)
  1065                                !
  1066                                ! Eastward wind velocity at lowest level
  1067      real(DP), intent(in):: xy_V (0:imax-1, 1:jmax)
  1068                                !
  1069                                ! Northward wind velocity at lowest level
  1070      real(DP), intent(in):: xy_SurfVirTemp (0:imax-1, 1:jmax)
  1071                                !
  1072                                ! Surface virtual temperature
  1073      real(DP), intent(in):: xy_SurfExner(0:imax-1, 1:jmax)
  1074                                !
  1075                                ! Exner function at the surface
  1076      real(DP), intent(in):: xy_VirTemp     (0:imax-1, 1:jmax)
  1077                                !
  1078                                ! Virtual temperature at lowest layer
  1079      real(DP), intent(in):: xy_Exner    (0:imax-1, 1:jmax)
  1080                                !
  1081                                ! Exner function at lowest layer
  1082  
  1083      real(DP), intent(out):: xy_SurfVelBulkCoef (0:imax-1, 1:jmax)
  1084                                ! バルク係数：運動量.
  1085                                ! Bulk coefficient: temperature
  1086      real(DP), intent(out):: xy_SurfTempBulkCoef (0:imax-1, 1:jmax)
  1087                                ! バルク係数：温度.
  1088                                ! Bulk coefficient: temperature
  1089      real(DP), intent(out):: xy_SurfQVapBulkCoef (0:imax-1, 1:jmax)
  1090                                ! バルク係数：比湿.
  1091                                ! Bulk coefficient: specific humidity
  1092      real(DP), intent(out):: xy_BetaW   (0:imax-1, 1:jmax)
  1093                                !
  1094                                ! "vertical velocity" (B94)
  1095      real(DP), intent(out):: xy_SurfBulkRiNum (0:imax-1, 1:jmax)
  1096                                ! バルク $ R_i $ 数.
  1097                                ! Bulk $ R_i $ number
  1098      real(DP), intent(out):: xy_SurfMOLength(0:imax-1, 1:jmax)
  1099  
  1100      ! 作業変数
  1101      ! Work variables
  1102      !
  1103      real(DP):: xy_SurfVelAbs (0:imax-1, 1:jmax)
  1104                                ! 風速絶対値.
  1105                                ! Absolute velocity
  1106      real(DP) :: xy_MOLength    (0:imax-1, 1:jmax)
  1107      real(DP) :: xy_MOLengthSave(0:imax-1, 1:jmax)
  1108      real(DP) :: xy_ZetaM(0:imax-1, 1:jmax)
  1109      real(DP) :: xy_ZetaH(0:imax-1, 1:jmax)
  1110      real(DP) :: xy_PsiM1(0:imax-1, 1:jmax)
  1111      real(DP) :: xy_PsiH1(0:imax-1, 1:jmax)
  1112      real(DP) :: xy_PsiM0(0:imax-1, 1:jmax)
  1113      real(DP) :: xy_PsiH0(0:imax-1, 1:jmax)
  1114      real(DP) :: xy_FricVelByU1(0:imax-1, 1:jmax)
  1115      real(DP) :: SurfBulkRiNum
  1116      logical  :: FlagConverge
  1117      logical  :: xy_FlagConverge(0:imax-1, 1:jmax)
  1118      logical :: a_FlagReCalcLocal (1)
  1119      logical :: a_FlagReCalcGlobal(1)
  1120      integer             :: iLoop
  1121      integer , parameter :: nLoop = 100
  1122      real(DP)            :: MOLengthErr
  1123      real(DP), parameter :: MOLengthErrCriterion = 1.0d-5
  1124  
  1125      real(DP), parameter :: Gamma = 16.0_DP
  1126      real(DP), parameter :: Beta  = 1.2_DP
  1127  
  1128      real(DP) :: SurfPotTemp
  1129      real(DP) :: PotTemp
  1130      real(DP) :: BLHeight
  1131      real(DP) :: xy_BLHeight(0:imax-1, 1:jmax)
  1132  
  1133      integer:: i               ! 経度方向に回る DO ループ用作業変数
  1134                                ! Work variables for DO loop in longitude
  1135      integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1136                                ! Work variables for DO loop in latitude
  1137  
  1138      ! 実行文 ; Executable statement
  1139      !
  1140  
  1141      ! Calculate bulk coefficients
  1142      ! Parameterization by Beljaars and Holtslag (1991)
  1143      !
  1144  
  1145      ! initialization
  1146      xy_MOLength = 1.0e10_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t738 = 1, xy_molength.DSC.U2*xy_molength.DSC.U1 +              
     .       1   xy_molength.DSC.U2                                             
     .           xy_molength(t738-1,1) = 1.00000000000000e+010                  
     .           xy_betaw(t738-1,1) = 0.0000000000000000e+000                   
     .           xy_flagconverge(t738-1,1) = 0                                  
     .        enddo                                                             
  1147      xy_BetaW    = 0.0_DP
  1148  
  1149      xy_FlagConverge = .false.
  1150  
  1151      loop_iteration : do iLoop = 1, nLoop
  1152  
  1153        xy_MOLengthSave = xy_MOLength
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t748 = 1, xy_molengthsave.DSC.U2*xy_molengthsave.DSC.U1 +      
     .       1   xy_molengthsave.DSC.U2                                         
     .           xy_molengthsave(t748-1,1) = xy_molength(t748-1,1)              
     .        enddo                                                             
  1154  
  1155        ! Calculation of Psi_{M,H}
  1156        if ( FlagUseOfBulkCoefInNeutralCond ) then
  1157          xy_PsiM0 = 0.0_DP
  1158          xy_PsiH0 = 0.0_DP
  1159          xy_PsiM1 = 0.0_DP
  1160          xy_PsiH1 = 0.0_DP
  1161        else
  1162          xy_ZetaM = xy_SurfRoughLengthMom  / xy_MOLength
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t756 = 1, jmax*imax                                            
     .           xy_zetam(t756-1,1) = xy_surfroughlengthmom(t756-1,1)/          
     .       1      xy_molength(t756-1,1)                                       
     .           xy_zetah(t756-1,1) = xy_surfroughlengthheat(t756-1,1)/         
     .       1      xy_molength(t756-1,1)                                       
     .        enddo                                                             
  1163          xy_ZetaH = xy_SurfRoughLengthHeat / xy_MOLength
  1164          call BH91CalcPsi(       &
  1165            & Gamma,              & ! (in)
  1166            & xy_ZetaM, xy_ZetaH, & ! (in)
  1167            & xy_PsiM0, xy_PsiH0  & ! (out)
  1168            & )
  1169          xy_ZetaM = ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthMom  ) / xy_MOLength
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t772 = 1, jmax*imax                                            
     .           xy_zetam(t772-1,1) = ((xyz_height(t772-1,1,1)-xy_surfheight(   
     .       1      t772-1,1))+xy_surfroughlengthmom(t772-1,1))/xy_molength(t772
     .       2      -1,1)                                                       
     .           xy_zetah(t772-1,1) = ((xyz_height(t772-1,1,1)-xy_surfheight(   
     .       1      t772-1,1))+xy_surfroughlengthheat(t772-1,1))/xy_molength(   
     .       2      t772-1,1)                                                   
     .        enddo                                                             
  1170          xy_ZetaH = ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthHeat ) / xy_MOLength
  1171          call BH91CalcPsi(       &
  1172            & Gamma,              & ! (in)
  1173            & xy_ZetaM, xy_ZetaH, & ! (in)
  1174            & xy_PsiM1, xy_PsiH1  & ! (out)
  1175            & )
  1176        end if
  1177  
  1178        do j = 1, jmax
  1179          do i = 0, imax-1
  1180            if ( .not. xy_FlagConverge(i,j) ) then
  1181              ! u_* / U_1, Eq. (5)
  1182              xy_FricVelByU1(i,j) =                             &
  1183                &   FKarm                                       &
  1184                & / (                                           &
  1185                &       log (   ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) + xy_SurfRoughLengthMom(i,j)  ) &
  1186                &             / xy_SurfRoughLengthMom(i,j)  )   &
  1187                &     - xy_PsiM1(i,j) + xy_PsiM0(i,j)           &
  1188                &   )
  1189  
  1190              xy_SurfVelBulkCoef(i,j) = xy_FricVelByU1(i,j)**2
  1191              !
  1192              xy_SurfTempBulkCoef(i,j) =                        &
  1193                &   xy_FricVelByU1(i,j)                         &
  1194                & * FKarm                                       &
  1195                & / (                                           &
  1196                &       log (   ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) + xy_SurfRoughLengthHeat(i,j) ) &
  1197                &             / xy_SurfRoughLengthHeat(i,j) )   &
  1198                &     - xy_PsiH1(i,j) + xy_PsiH0(i,j)           &
  1199                &   )
  1200              !
  1201              xy_SurfQVapBulkCoef(i,j) = xy_SurfTempBulkCoef(i,j)
  1202            end if
  1203          end do
  1204        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_flagconverge(j-1,1) .eq. 0) then                        
     .              xy_fricvelbyu1(j-1,1) = 4.00000000000000e-001/(dlog(((      
     .       1         xyz_height(j-1,1,1)-xy_surfheight(j-1,1))+               
     .       2         xy_surfroughlengthmom(j-1,1))/xy_surfroughlengthmom(j-1,1
     .       3         ))-xy_psim1(j-1,1)+xy_psim0(j-1,1))                      
     .              xy_surfvelbulkcoef(j-1,1) = xy_fricvelbyu1(j-1,1)**2        
     .              xy_surftempbulkcoef(j-1,1) = xy_fricvelbyu1(j-1,1)*         
     .       1         4.00000000000000e-001/(dlog(((xyz_height(j-1,1,1)-       
     .       2         xy_surfheight(j-1,1))+xy_surfroughlengthheat(j-1,1))/    
     .       3         xy_surfroughlengthheat(j-1,1))-xy_psih1(j-1,1)+xy_psih0(j
     .       4         -1,1))                                                   
     .              xy_surfqvapbulkcoef(j-1,1) = xy_surftempbulkcoef(j-1,1)     
     .           endif                                                          
     .        enddo                                                             
  1205  
  1206  
  1207        ! Calculation of wind speed related to convection
  1208        if ( FlagIncludeB94W ) then
  1209          do j = 1, jmax
  1210            do i = 0, imax-1
  1211              if ( .not. xy_FlagConverge(i,j) ) then
  1212                if ( xy_MOLength(i,j) < 0.0_DP ) then
  1213                  SurfPotTemp = xy_SurfVirTemp(i,j) / xy_SurfExner(i,j)
  1214                  PotTemp     = xy_VirTemp    (i,j) / xy_Exner    (i,j)
  1215  !!$              BLHeight =                                                      &
  1216  !!$                & - xy_MOLength(i,j) / ( FKarm**2 * Beta**3 )                 &
  1217  !!$                &     * (   log( - 38.5_DP * xy_MOLength(i,j)                 &
  1218  !!$                &                  / ( Gamma * xy_SurfRoughLengthMom(i,j) ) ) &
  1219  !!$                &         + xy_PsiM0(i,j) )**3
  1220                  ! BLHeight is assumed to be constant.
  1221                  BLHeight = 1000.0_DP
  1222                  xy_BetaW(i,j) =                                                 &
  1223                    & sqrt(                                                       &
  1224                    &       Grav / PotTemp * ( SurfPotTemp - PotTemp )            &
  1225                    &         * FKarm**2 * Beta * BLHeight                        &
  1226                    &     / (                                                     &
  1227                    &           (   log( - 38.5_DP * xy_MOLength(i,j)             &
  1228                    &                / ( Gamma * xy_SurfRoughLengthMom (i,j) ) )  &
  1229                    &             + xy_PsiM0(i,j)                                )&
  1230                    &         * (   log( -  4.0_DP * xy_MOLength(i,j)             &
  1231                    &                / ( Gamma * xy_SurfRoughLengthHeat(i,j) ) )  &
  1232                    &             + xy_PsiH0(i,j)                                )&
  1233                    &       )                                                     &
  1234                    &     )
  1235                  xy_BLHeight(i,j) = BLHeight
  1236                else
  1237                  xy_BetaW(i,j) = 0.0_DP
  1238                  xy_BLHeight(i,j) = 0.0_DP
  1239                end if
  1240              end if
  1241            end do
  1242          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_flagconverge(j-1,1) .eq. 0) then                        
     .              if (xy_molength(j-1,1) .ge. 0.0000000000000000e+000) then   
     .                 xy_betaw(j-1,1) = 0.0000000000000000e+000                
     .                 xy_blheight(j-1,1) = 0.0000000000000000e+000             
     .              else                                                        
     .                 pottemp = xy_virtemp(j-1,1)/xy_exner(j-1,1)              
     .                 xy_betaw(j-1,1) = dsqrt(grav/pottemp*(xy_surfvirtemp(j-1,
     .       1            1)/xy_surfexner(j-1,1)-pottemp)*1.60000000000000e-001*
     .       2            1.20000000000000e+000*1.00000000000000e+003/((dlog((- 
     .       3            3.85000000000000e+001*xy_molength(j-1,1)/(            
     .       4            1.60000000000000e+001*xy_surfroughlengthmom(j-1,1))))+
     .       5            xy_psim0(j-1,1))*(dlog((-4.00000000000000e+000*       
     .       6            xy_molength(j-1,1)/(1.60000000000000e+001*            
     .       7            xy_surfroughlengthheat(j-1,1))))+xy_psih0(j-1,1))))   
     .                 xy_blheight(j-1,1) = 1.00000000000000e+003               
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
     .        goto 10039                                                        
  1243        else
  1244          do j = 1, jmax
  1245            do i = 0, imax-1
  1246              if ( .not. xy_FlagConverge(i,j) ) then
  1247                xy_BetaW(i,j) = 0.0_DP
  1248              end if
  1249            end do
  1250          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_flagconverge(j-1,1) .eq. 0) then                        
     .              xy_betaw(j-1,1) = 0.0000000000000000e+000                   
     .           endif                                                          
     .        enddo                                                             
  1251        end if
  1252  
  1253  
  1254        do j = 1, jmax
  1255          do i = 0, imax-1
  1256            if ( .not. xy_FlagConverge(i,j) ) then
  1257  
  1258              ! Calculation of bulk Richardson number
  1259              xy_SurfVelAbs(i,j) = sqrt ( xy_U(i,j)**2 + xy_V(i,j)**2 + xy_BetaW(i,j)**2 )
  1260              xy_SurfBulkRiNum(i,j) =                                  &
  1261                &   Grav / ( xy_SurfVirTemp(i,j) / xy_SurfExner(i,j) ) &
  1262                &   * (   xy_VirTemp(i,j)     / xy_Exner(i,j)          &
  1263                &       - xy_SurfVirTemp(i,j) / xy_SurfExner(i,j) )    &
  1264                &   / max( xy_SurfVelAbs(i,j), VelMinForRi )**2        &
  1265                &   * ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) )
  1266  
  1267              ! Calculation of Monin-Obukhov length
  1268              SurfBulkRiNum = xy_SurfBulkRiNum(i,j)
  1269              if ( SurfBulkRiNum == 0.0_DP ) SurfBulkRiNum = 1.0e-10_DP
  1270              xy_MOLength(i,j) =                               &
  1271                &   ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) ) &
  1272                & / ( FKarm * SurfBulkRiNum )                  &
  1273                & * xy_SurfVelBulkCoef(i,j)**1.5_DP / xy_SurfTempBulkCoef(i,j)
  1274  
  1275            end if
  1276          end do
  1277        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_flagconverge(j-1,1) .eq. 0) then                        
     .              xy_surfvelabs(j-1,1) = dsqrt(xy_u(j-1,1)**2+xy_v(j-1,1)**2+ 
     .       1         xy_betaw(j-1,1)**2)                                      
     .              xy_surfbulkrinum(j-1,1) = grav/(xy_surfvirtemp(j-1,1)/      
     .       1         xy_surfexner(j-1,1))*(xy_virtemp(j-1,1)/xy_exner(j-1,1)-(
     .       2         xy_surfvirtemp(j-1,1)/xy_surfexner(j-1,1)))/max(         
     .       3         xy_surfvelabs(j-1,1),velminforri)**2*(xyz_height(j-1,1,1)
     .       4         -xy_surfheight(j-1,1))                                   
     .              surfbulkrinum = xy_surfbulkrinum(j-1,1)                     
     .              if (surfbulkrinum .eq. 0.0000000000000000e+000) then        
     .                 surfbulkrinum = 1.00000000000000e-010                    
     .              endif                                                       
     .              xy_molength(j-1,1) = (xyz_height(j-1,1,1)-xy_surfheight(j-1,
     .       1         1))/(4.00000000000000e-001*surfbulkrinum)*               
     .       2         xy_surfvelbulkcoef(j-1,1)**1.50000000000000e+000/        
     .       3         xy_surftempbulkcoef(j-1,1)                               
     .           endif                                                          
     .        enddo                                                             
  1278  
  1279  
  1280        ! TO BE DELETED
  1281  !!$      ! Check of convergence
  1282  !!$      FlagConverge = .true.
  1283  !!$      loop_check : do j = 1, jmax
  1284  !!$        do i = 0, imax-1
  1285  !!$          MOLengthErr =                                      &
  1286  !!$            & abs( xy_MOLength(i,j) - xy_MOLengthSave(i,j) ) &
  1287  !!$            &    / max( abs( xy_MOLength(i,j) ), 1.0d-10 )
  1288  !!$          if ( MOLengthErr > MOLengthErrCriterion ) then
  1289  !!$            FlagConverge = .false.
  1290  !!$            exit loop_check
  1291  !!$          end if
  1292  !!$        end do
  1293  !!$      end do loop_check
  1294  !!$      a_FlagReCalcLocal = ( .not. FlagConverge )
  1295  !!$      call MPIWrapperChkTrue(   &
  1296  !!$        & 1, a_FlagReCalcLocal, & ! (in)
  1297  !!$        & a_FlagReCalcGlobal    & ! (out)
  1298  !!$        & )
  1299  !!$      if ( .not. a_FlagReCalcGlobal(1) ) exit loop_iteration
  1300  
  1301        ! Check of convergence
  1302        do j = 1, jmax
  1303          do i = 0, imax-1
  1304            if ( .not. xy_FlagConverge(i,j) ) then
  1305              MOLengthErr =                                      &
  1306                & abs( xy_MOLength(i,j) - xy_MOLengthSave(i,j) ) &
  1307                &    / max( abs( xy_MOLength(i,j) ), 1.0e-10_DP )
  1308              if ( MOLengthErr <= MOLengthErrCriterion ) then
  1309                xy_FlagConverge(i,j) = .true.
  1310              end if
  1311            end if
  1312          end do
  1313        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_flagconverge(j-1,1) .eq. 0) then                        
     .              if (abs(xy_molength(j-1,1)-xy_molengthsave(j-1,1))/max(abs( 
     .       1         xy_molength(j-1,1)),1.00000000000000e-010) .le.          
     .       2         1.00000000000000e-005) then                              
     .                 xy_flagconverge(j-1,1) = 1                               
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
  1314        FlagConverge = .true.
  1315        loop_check : do j = 1, jmax
  1316          do i = 0, imax-1
  1317            if ( .not. xy_FlagConverge(i,j) ) then
  1318              FlagConverge = .false.
  1319              exit loop_check
  1320            end if
  1321          end do
  1322        end do loop_check
  1323        if ( FlagConverge ) exit loop_iteration
  1324  
  1325  
  1326      end do loop_iteration
  1327      if ( iLoop > nLoop ) then
  1328        call MessageNotify( 'E', module_name, 'Monin-Obukhov length is not convergent.' )
  1329      end if
  1330  
  1331  
  1332      xy_SurfMOLength = xy_MOLength
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t796 = 1, jmax*imax                                            
     .           xy_surfmolength(t796-1,1) = xy_molength(t796-1,1)              
     .        enddo                                                             
  1333  
  1334  
  1335      call HistoryAutoPut( TimeN, 'MOLength'   , xy_MOLength        )
  1336      call HistoryAutoPut( TimeN, 'MOLengthInv', 1.0_DP/xy_MOLength )
     .        if (xy_molength.DSC.U2 .gt. 0) then                               
     .           j1 = and(xy_molength.DSC.U2,3)                                 
     .  !cdir    nodep                                                          
     .           do t804 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t806 = 1, xy_molength.DSC.U1 + 1                         
     .                 %IG0(t806,t804) = 1.00000000000000e+000/xy_molength(t806-
     .       1            1,t804)                                               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t804 = j1 + 1, xy_molength.DSC.U2, 4                        
     .  !cdir       nodep                                                       
     .              do t806 = 1, xy_molength.DSC.U1 + 1                         
     .                 %IG0(t806,t804) = 1.00000000000000e+000/xy_molength(t806-
     .       1            1,t804)                                               
     .                 %IG0(t806,t804+1) = 1.00000000000000e+000/xy_molength(   
     .       1            t806-1,t804+1)                                        
     .                 %IG0(t806,t804+2) = 1.00000000000000e+000/xy_molength(   
     .       1            t806-1,t804+2)                                        
     .                 %IG0(t806,t804+3) = 1.00000000000000e+000/xy_molength(   
     .       1            t806-1,t804+3)                                        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1337      call HistoryAutoPut( TimeN, 'BetaW'      , xy_BetaW           )
  1338      call HistoryAutoPut( TimeN, 'BLHeight'   , xy_BLHeight        )
  1339  
  1340  
  1341    end subroutine BulkCoefBH91B94
  1342  
  1343    !--------------------------------------------------------------------------------------
  1344  
  1345    subroutine BH91CalcPsi( &
  1346      & Gamma,              & ! (in)
  1347      & xy_ZetaM, xy_ZetaH, & ! (in)
  1348      & xy_PsiM, xy_PsiH    & ! (out)
  1349      & )
  1350      !
  1351      !
  1352      !
  1353      ! Calculation of Psi_M and Psi_H
  1354      !
  1355  
  1356      ! モジュール引用 ; USE statements
  1357      !
  1358  
  1359      ! 物理・数学定数設定
  1360      ! Physical and mathematical constants settings
  1361      !
  1362      use constants0, only: &
  1363        & PI
  1364                                ! $ \pi $ .
  1365                                ! 円周率.  Circular constant
  1366  
  1367      ! 宣言文 ; Declaration statements
  1368      !
  1369  
  1370      real(DP), intent(in ) :: Gamma
  1371  
  1372      real(DP), intent(in ) :: xy_ZetaM(0:imax-1, 1:jmax)
  1373                                !
  1374                                ! zeta = z / L for momentum
  1375      real(DP), intent(in ) :: xy_ZetaH(0:imax-1, 1:jmax)
  1376                                !
  1377                                ! zeta = z / L for heat
  1378      real(DP), intent(out) :: xy_PsiM(0:imax-1, 1:jmax)
  1379                                !
  1380                                ! PsiM
  1381      real(DP), intent(out) :: xy_PsiH(0:imax-1, 1:jmax)
  1382                                !
  1383                                ! PsiH
  1384  
  1385      ! 作業変数
  1386      ! Work variables
  1387      !
  1388      real(DP) :: ZetaM
  1389      real(DP) :: ZetaH
  1390      real(DP) :: ParamXM
  1391      real(DP) :: ParamXH
  1392  
  1393      real(DP), parameter :: ConstA = 1.0_DP
  1394      real(DP), parameter :: ConstB = 0.667_DP
  1395      real(DP), parameter :: ConstC = 5.0_DP
  1396      real(DP), parameter :: ConstD = 0.35_DP
  1397  
  1398      integer:: i               ! 経度方向に回る DO ループ用作業変数
  1399                                ! Work variables for DO loop in longitude
  1400      integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1401                                ! Work variables for DO loop in latitude
  1402  
  1403      ! 実行文 ; Executable statement
  1404      !
  1405  
  1406      ! Parameterization by Beljaars and Holtslag (1991)
  1407      !
  1408  
  1409  
  1410      do j = 1, jmax
  1411        do i = 0, imax-1
  1412  
  1413          ZetaM = xy_ZetaM(i,j)
  1414          ZetaH = xy_ZetaH(i,j)
  1415  
  1416          if ( ZetaM < 0.0_DP ) then
  1417            ! for unstable condition
  1418  
  1419            ParamXM = ( 1.0_DP - Gamma * ZetaM )**0.25_DP
  1420            ParamXH = ( 1.0_DP - Gamma * ZetaH )**0.25_DP
  1421  
  1422            ! Eq. (25)
  1423            xy_PsiM(i,j) =                                    &
  1424              &   log(                                        &
  1425              &          ( 1.0_DP + ParamXM    )**2           &
  1426              &        * ( 1.0_DP + ParamXM**2 )    / 8.0_DP  &
  1427              &      )                                        &
  1428              & - 2.0_DP * atan( ParamXM ) + PI / 2.0_DP
  1429            ! Eq. (26)
  1430            xy_PsiH(i,j) =                                    &
  1431              &   log(                                        &
  1432              &          ( 1.0_DP + ParamXH**2 )**2 / 4.0_DP  &
  1433              &      )
  1434          else
  1435            ! for stable condition
  1436  
  1437            ! Eq. (28)
  1438            xy_PsiM(i,j) =                                                      &
  1439              & - ConstA * ZetaM                                                &
  1440              & - ConstB * ( ZetaM - ConstC / ConstD ) * exp( - ConstD * ZetaM )&
  1441              & - ConstB * ConstC / ConstD
  1442            ! Eq. (32)
  1443            xy_PsiH(i,j) =                                                      &
  1444              & - ( 1.0_DP + 2.0_DP / 3.0_DP * ConstA * ZetaH )**1.5            &
  1445              & - ConstB * ( ZetaH - ConstC / ConstD ) * exp( - ConstD * ZetaH )&
  1446              & - ConstB * ConstC / ConstD                                      &
  1447              & + 1.0_DP
  1448          end if
  1449  
  1450        end do
  1451      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_zetam(j-1,1) .lt. 0.0000000000000000e+000) then         
     .              paramxm = (1.00000000000000e+000 - gamma*xy_zetam(j-1,1))** 
     .       1         2.50000000000000e-001                                    
     .              paramxh = (1.00000000000000e+000 - gamma*xy_zetah(j-1,1))** 
     .       1         2.50000000000000e-001                                    
     .              xy_psim1 = dlog((1.00000000000000e+000 + paramxm)**2*(      
     .       1         1.00000000000000e+000 + paramxm**2)/8.00000000000000e+000
     .       2         ) - 2.00000000000000e+000*datan(paramxm) +               
     .       3         1.57079632679489e+000                                    
     .              xy_psih2 = dlog((1.00000000000000e+000 + paramxh**2)**2/    
     .       1         4.00000000000000e+000)                                   
     .           else                                                           
     .              xy_psim1 = (-1.00000000000000e+000*xy_zetam(j-1,1)) -       
     .       1         6.67000000000000e-001*(xy_zetam(j-1,1)-                  
     .       2         1.42857142857142e+001)*dexp((-3.49999999999999e-001*     
     .       3         xy_zetam(j-1,1))) - 9.52857142857142e+000                
     .              xy_psih2 = (-(1.00000000000000e+000 + 6.66666666666666e-001*
     .       1         xy_zetah(j-1,1))**1.50000000000000e+000) -               
     .       2         6.67000000000000e-001*(xy_zetah(j-1,1)-                  
     .       3         1.42857142857142e+001)*dexp((-3.49999999999999e-001*     
     .       4         xy_zetah(j-1,1))) - 9.52857142857142e+000 +              
     .       5         1.00000000000000e+000                                    
     .           endif                                                          
     .           xy_psih(j-1,1) = xy_psih2                                      
     .           xy_psim(j-1,1) = xy_psim1                                      
     .        enddo                                                             
  1452  
  1453  
  1454    end subroutine BH91CalcPsi
  1455  
  1456    !--------------------------------------------------------------------------------------
  1457  
  1458    subroutine SurfaceFluxOutput(                                &
  1459      & xy_SnowFrac,                                             & ! (in)
  1460      & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
  1461      & xy_SurfH2OVapFluxA, xy_SurfLatentHeatFluxA,              & ! (in)
  1462      & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt,           & ! (in)
  1463      & xy_SurfTemp, xy_DSurfTempDt,                             & ! (in)
  1464      & xyr_Press, xyz_Exner, xyr_Exner, xy_SurfHumidCoef,       & ! (in)
  1465      & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
  1466      & xy_SurfQVapTransCoef                                     & ! (in)
  1467      & )
  1468      !
  1469      ! フラックス (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux).
  1470      ! について, その他の引数を用いて補正し, 出力を行う.
  1471      !
  1472      ! Fluxes (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux) are
  1473      ! corrected by using other arguments, and the corrected values are output.
  1474      !
  1475  
  1476      ! モジュール引用 ; USE statements
  1477      !
  1478  
  1479      ! 物理定数設定
  1480      ! Physical constant settings
  1481      !
  1482      use constants, only: &
  1483        & Grav, &               ! $ g $ [m s-2].
  1484                                ! 重力加速度.
  1485                                ! Gravitational acceleration
  1486        & GasRDry, &
  1487                                ! $ R $ [J kg-1 K-1].
  1488                                ! 乾燥大気の気体定数.
  1489                                ! Gas constant of air
  1490        & CpDry, &
  1491                                ! $ C_p $ [J kg-1 K-1].
  1492                                ! 乾燥大気の定圧比熱.
  1493                                ! Specific heat of air at constant pressure
  1494        & LatentHeat
  1495                                ! $ L $ [J kg-1] .
  1496                                ! 凝結の潜熱.
  1497                                ! Latent heat of condensation
  1498  
  1499      ! 飽和比湿の算出
  1500      ! Evaluation of saturation specific humidity
  1501      !
  1502      use saturate, only: &
  1503        & xy_CalcQVapSatOnLiq,       &
  1504        & xy_CalcQVapSatOnSol,       &
  1505        & xy_CalcDQVapSatDTempOnLiq, &
  1506        & xy_CalcDQVapSatDTempOnSol
  1507  
  1508      ! 時刻管理
  1509      ! Time control
  1510      !
  1511      use timeset, only: &
  1512        & DelTime, &            ! $ \Delta t $ [s]
  1513        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
  1514        & TimesetClockStart, TimesetClockStop
  1515  
  1516      ! ヒストリデータ出力
  1517      ! History data output
  1518      !
  1519      use gtool_historyauto, only: HistoryAutoPut
  1520  
  1521      ! 宣言文 ; Declaration statements
  1522      !
  1523      implicit none
  1524      real(DP), intent(in):: xy_SnowFrac(0:imax-1, 1:jmax)
  1525                                !
  1526                                ! Snow fraction
  1527      real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
  1528                                ! 東西方向運動量フラックス.
  1529                                ! Eastward momentum flux
  1530      real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
  1531                                ! 南北方向運動量フラックス.
  1532                                ! Northward momentum flux
  1533      real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
  1534                                ! 熱フラックス.
  1535                                ! Heat flux
  1536      real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
  1537                                ! 比湿フラックス.
  1538                                ! Specific humidity flux
  1539      real(DP), intent(in):: xy_SurfH2OVapFluxA    (0:imax-1, 1:jmax)
  1540                                ! 惑星表面水蒸気フラックス.
  1541                                ! Water vapor flux at the surface
  1542      real(DP), intent(in):: xy_SurfLatentHeatFluxA(0:imax-1, 1:jmax)
  1543                                ! 惑星表面潜熱フラックス.
  1544                                ! Latent heat flux at the surface
  1545      real(DP), intent(in):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
  1546                                ! $ \DP{u}{t} $ . 東西風速時間変化率.
  1547                                ! Eastward wind tendency
  1548      real(DP), intent(in):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
  1549                                ! $ \DP{v}{t} $ . 南北風速時間変化率.
  1550                                ! Northward wind tendency
  1551      real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
  1552                                ! $ \DP{T}{t} $ . 温度時間変化率.
  1553                                ! Temperature tendency
  1554      real(DP), intent(in):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1555                                ! $ \DP{q}{t} $ . 比湿時間変化率.
  1556                                ! Specific humidity tendency
  1557      real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
  1558                                ! 地表面温度.
  1559                                ! Surface temperature
  1560      real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
  1561                                ! 地表面温度時間変化率.
  1562                                ! Surface temperature tendency
  1563      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
  1564                                ! $ \hat{p} $ . 気圧 (半整数レベル).
  1565                                ! Air pressure (half level)
  1566      real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
  1567                                ! Exner 関数 (整数レベル).
  1568                                ! Exner function (full level)
  1569      real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
  1570                                ! Exner 関数 (半整数レベル).
  1571                                ! Exner function (half level)
  1572      real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
  1573                                ! 地表湿潤度.
  1574                                ! Surface humidity coefficient
  1575      real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
  1576                                ! 輸送係数：運動量.
  1577                                ! Diffusion coefficient: velocity
  1578      real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
  1579                                ! 輸送係数：温度.
  1580                                ! Transfer coefficient: temperature
  1581      real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
  1582                                ! 輸送係数：水蒸気
  1583                                ! Transfer coefficient: water vapor
  1584  
  1585      ! 出力のための作業変数
  1586      ! Work variables for output
  1587      !
  1588      real(DP):: xyr_MomFluxXCor (0:imax-1, 1:jmax, 0:kmax)
  1589                                ! 東西方向運動量フラックス.
  1590                                ! Eastward momentum flux
  1591      real(DP):: xyr_MomFluxYCor (0:imax-1, 1:jmax, 0:kmax)
  1592                                ! 南北方向運動量フラックス.
  1593                                ! Northward momentum flux
  1594      real(DP):: xyr_HeatFluxCor (0:imax-1, 1:jmax, 0:kmax)
  1595                                ! 熱フラックス.
  1596                                ! Heat flux
  1597      real(DP):: xyrf_QMixFluxCor(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
  1598                                ! 比湿フラックス.
  1599                                ! Specific humidity flux
  1600      real(DP):: xyr_LatentHeatFluxCor(0:imax-1, 1:jmax, 0:kmax)
  1601                                ! 表面潜熱フラックス.
  1602                                ! Latent heat flux
  1603      real(DP):: xy_SurfQVapSatOnLiq (0:imax-1, 1:jmax)
  1604                                ! 地表飽和比湿.
  1605                                ! Saturated specific humidity on surface
  1606      real(DP):: xy_SurfQVapSatOnSol (0:imax-1, 1:jmax)
  1607                                ! 地表飽和比湿.
  1608                                ! Saturated specific humidity on surface
  1609      real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
  1610                                ! 地表飽和比湿.
  1611                                ! Saturated specific humidity on surface
  1612      real(DP):: xy_SurfDQVapSatDTempOnLiq (0:imax-1, 1:jmax)
  1613                                ! 地表飽和比湿変化.
  1614                                ! Saturated specific humidity tendency on surface
  1615      real(DP):: xy_SurfDQVapSatDTempOnSol (0:imax-1, 1:jmax)
  1616                                ! 地表飽和比湿変化.
  1617                                ! Saturated specific humidity tendency on surface
  1618      real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
  1619                                ! 地表飽和比湿変化.
  1620                                ! Saturated specific humidity tendency on surface
  1621  
  1622      ! 作業変数
  1623      ! Work variables
  1624      !
  1625      integer:: i               ! 経度方向に回る DO ループ用作業変数
  1626                                ! Work variables for DO loop in longitude
  1627      integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1628                                ! Work variables for DO loop in latitude
  1629      integer:: n               ! 組成方向に回る DO ループ用作業変数
  1630                                ! Work variables for DO loop in dimension of constituents
  1631  
  1632  
  1633      ! 実行文 ; Executable statement
  1634      !
  1635  
  1636      ! 初期化確認
  1637      ! Initialization check
  1638      !
  1639      if ( .not. surface_flux_bulk_inited ) then
  1640        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1641      end if
  1642  
  1643  
  1644      ! 計算時間計測開始
  1645      ! Start measurement of computation time
  1646      !
  1647      call TimesetClockStart( module_name )
  1648  
  1649  
  1650      ! 飽和比湿の計算
  1651      ! Calculate saturated specific humidity
  1652      !
  1653      xy_SurfQVapSatOnLiq  = &
  1654        & xy_CalcQVapSatOnLiq( xy_SurfTemp, xyr_Press(:,:,0) )
  1655      xy_SurfQVapSatOnSol  = &
  1656        & xy_CalcQVapSatOnSol( xy_SurfTemp, xyr_Press(:,:,0) )
  1657      xy_SurfQVapSat       = &
  1658        &   ( 1.0_DP - xy_SnowFrac ) * xy_SurfQVapSatOnLiq &
  1659        & + xy_SnowFrac              * xy_SurfQVapSatOnSol
  1660      xy_SurfDQVapSatDTempOnLiq = &
  1661        & xy_CalcDQVapSatDTempOnLiq( xy_SurfTemp, xy_SurfQVapSatOnLiq )
  1662      xy_SurfDQVapSatDTempOnSol = &
  1663        & xy_CalcDQVapSatDTempOnSol( xy_SurfTemp, xy_SurfQVapSatOnSol )
  1664      xy_SurfDQVapSatDTemp = &
  1665        &   ( 1.0_DP - xy_SnowFrac ) * xy_SurfDQVapSatDTempOnLiq &
  1666        & + xy_SnowFrac              * xy_SurfDQVapSatDTempOnSol
  1667  
  1668      ! Output of fluxes at t
  1669      !
  1670  
  1671      ! 風速, 温度, 比湿フラックス補正
  1672      ! Correct fluxes of wind, temperature, specific humidity
  1673      !
  1674      do j = 1, jmax
  1675        do i = 0, imax-1
  1676          xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
  1677            & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * DelTime
  1678  
  1679          xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
  1680            & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * DelTime
  1681  
  1682          xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
  1683            & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
  1684            &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
  1685            &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
  1686            &   * DelTime
  1687        end do
  1688      end do
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_momfluxxcor(j-1,1,0) = xyr_momfluxx(j-1,1,0) - (           
     .       1      xy_surfveltranscoef(j-1,1)*deltime)*xyz_dudt(j-1,1,1)       
     .           xyr_momfluxycor(j-1,1,0) = xyr_momfluxy(j-1,1,0) - (           
     .       1      xy_surfveltranscoef(j-1,1)*deltime)*xyz_dvdt(j-1,1,1)       
     .           xyr_heatfluxcor(j-1,1,0) = xyr_heatflux(j-1,1,0) - cpdry*      
     .       1      xyr_exner(j-1,1,0)*xy_surftemptranscoef(j-1,1)*(xyz_dtempdt(
     .       2      j-1,1,1)/xyz_exner(j-1,1,1)-xy_dsurftempdt(j-1,1)/xyr_exner(
     .       3      j-1,1,0))*deltime                                           
     .        enddo                                                             
  1689      n = IndexH2OVap
  1690      do j = 1, jmax
  1691        do i = 0, imax-1
  1692          xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
  1693            & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
  1694            &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
  1695            &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * DelTime
  1696        end do
  1697      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyrf_qmixfluxcor(j-1,1,0,n) = xyrf_qmixflux(j-1,1,0,n) -       
     .       1      xy_surfhumidcoef(j-1,1)*xy_surfqvaptranscoef(j-1,1)*(       
     .       2      xyzf_dqmixdt(j-1,1,1,n)-xy_surfdqvapsatdtemp(j-1,1)*        
     .       3      xy_dsurftempdt(j-1,1))*deltime                              
     .        enddo                                                             
  1698      do n = 1, IndexH2OVap-1
  1699        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1101 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +   
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t1101-1,1,0,n) = xyrf_qmixflux(t1101-1,1,0,n) 
     .        enddo                                                             
  1700      end do
  1701      do n = IndexH2OVap+1, ncmax
  1702        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1109 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +   
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t1109-1,1,0,n) = xyrf_qmixflux(t1109-1,1,0,n) 
     .        enddo                                                             
  1703      end do
  1704      n = IndexH2OVap
  1705      do j = 1, jmax
  1706        do i = 0, imax-1
  1707  !!$        xyr_LatentHeatFluxCor( i,j,0 ) = xy_SurfLatentHeatFlux( i,j )             &
  1708  !!$          & - LatentHeat * xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )  &
  1709  !!$          &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
  1710  !!$          &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * DelTime
  1711          xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
  1712        end do
  1713      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_latentheatfluxcor(j-1,1,0) = latentheat*xyrf_qmixfluxcor(j-
     .       1      1,1,0,n)                                                    
     .        enddo                                                             
  1714  
  1715  
  1716      ! ヒストリデータ出力
  1717      ! History data output
  1718      !
  1719      call HistoryAutoPut( TimeN, 'TauX'          , xyr_MomFluxXCor (:,:,0) )
  1720      call HistoryAutoPut( TimeN, 'TauY'          , xyr_MomFluxYCor (:,:,0) )
  1721      call HistoryAutoPut( TimeN, 'Sens'          , xyr_HeatFluxCor (:,:,0) )
  1722      call HistoryAutoPut( TimeN, 'SurfH2OVapFlux', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
  1723      call HistoryAutoPut( TimeN, 'Evap'          , xyr_LatentHeatFluxCor(:,:,0) )
  1724  
  1725  
  1726      ! Output of fluxes at t - \Delta t
  1727      !
  1728  
  1729      ! 風速, 温度, 比湿フラックス補正
  1730      ! Correct fluxes of wind, temperature, specific humidity
  1731      !
  1732      do j = 1, jmax
  1733        do i = 0, imax-1
  1734          xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 )
  1735          xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 )
  1736          xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )
  1737        end do
  1738      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_momfluxxcor(j-1,1,0) = xyr_momfluxx(j-1,1,0)               
     .           xyr_momfluxycor(j-1,1,0) = xyr_momfluxy(j-1,1,0)               
     .           xyr_heatfluxcor(j-1,1,0) = xyr_heatflux(j-1,1,0)               
     .        enddo                                                             
  1739      n = IndexH2OVap
  1740      do j = 1, jmax
  1741        do i = 0, imax-1
  1742          xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )
  1743        end do
  1744      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyrf_qmixfluxcor(j-1,1,0,n) = xyrf_qmixflux(j-1,1,0,n)         
     .        enddo                                                             
  1745      do n = 1, IndexH2OVap-1
  1746        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1117 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +   
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t1117-1,1,0,n) = xyrf_qmixflux(t1117-1,1,0,n) 
     .        enddo                                                             
  1747      end do
  1748      do n = IndexH2OVap+1, ncmax
  1749        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1125 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +   
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t1125-1,1,0,n) = xyrf_qmixflux(t1125-1,1,0,n) 
     .        enddo                                                             
  1750      end do
  1751      n = IndexH2OVap
  1752      do j = 1, jmax
  1753        do i = 0, imax-1
  1754  !!$        xyr_LatentHeatFluxCor( i,j,0 ) = xy_SurfLatentHeatFlux( i,j )
  1755          xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
  1756        end do
  1757      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_latentheatfluxcor(j-1,1,0) = latentheat*xyrf_qmixfluxcor(j-
     .       1      1,1,0,n)                                                    
     .        enddo                                                             
  1758  
  1759      ! ヒストリデータ出力
  1760      ! History data output
  1761      !
  1762      call HistoryAutoPut( TimeN, 'TauXB'          , xyr_MomFluxXCor (:,:,0) )
  1763      call HistoryAutoPut( TimeN, 'TauYB'          , xyr_MomFluxYCor (:,:,0) )
  1764      call HistoryAutoPut( TimeN, 'SensB'          , xyr_HeatFluxCor (:,:,0) )
  1765      call HistoryAutoPut( TimeN, 'SurfH2OVapFluxB', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
  1766      call HistoryAutoPut( TimeN, 'EvapB'          , xyr_LatentHeatFluxCor(:,:,0) )
  1767  
  1768  
  1769      ! Output of fluxes at t + \Delta t
  1770      !
  1771  
  1772      ! 風速, 温度, 比湿フラックス補正
  1773      ! Correct fluxes of wind, temperature, specific humidity
  1774      !
  1775      do j = 1, jmax
  1776        do i = 0, imax-1
  1777          xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
  1778            & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * 2.0_DP * DelTime
  1779  
  1780          xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
  1781            & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * 2.0_DP * DelTime
  1782  
  1783          xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
  1784            & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
  1785            &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
  1786            &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
  1787            &   * 2.0_DP * DelTime
  1788        end do
  1789      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_momfluxxcor(j-1,1,0) = xyr_momfluxx(j-1,1,0) - ((          
     .       1      xy_surfveltranscoef(j-1,1)*2.00000000000000e+000)*deltime)* 
     .       2      xyz_dudt(j-1,1,1)                                           
     .           xyr_momfluxycor(j-1,1,0) = xyr_momfluxy(j-1,1,0) - ((          
     .       1      xy_surfveltranscoef(j-1,1)*2.00000000000000e+000)*deltime)* 
     .       2      xyz_dvdt(j-1,1,1)                                           
     .           xyr_heatfluxcor(j-1,1,0) = xyr_heatflux(j-1,1,0) - cpdry*      
     .       1      xyr_exner(j-1,1,0)*xy_surftemptranscoef(j-1,1)*(xyz_dtempdt(
     .       2      j-1,1,1)/xyz_exner(j-1,1,1)-xy_dsurftempdt(j-1,1)/xyr_exner(
     .       3      j-1,1,0))*2.00000000000000e+000*deltime                     
     .        enddo                                                             
  1790      n = IndexH2OVap
  1791      do j = 1, jmax
  1792        do i = 0, imax-1
  1793          xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
  1794            & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
  1795            &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
  1796            &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * 2.0_DP * DelTime
  1797        end do
  1798      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyrf_qmixfluxcor(j-1,1,0,n) = xyrf_qmixflux(j-1,1,0,n) -       
     .       1      xy_surfhumidcoef(j-1,1)*xy_surfqvaptranscoef(j-1,1)*(       
     .       2      xyzf_dqmixdt(j-1,1,1,n)-xy_surfdqvapsatdtemp(j-1,1)*        
     .       3      xy_dsurftempdt(j-1,1))*2.00000000000000e+000*deltime        
     .        enddo                                                             
  1799      do n = 1, IndexH2OVap-1
  1800        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1133 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +   
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t1133-1,1,0,n) = xyrf_qmixflux(t1133-1,1,0,n) 
     .        enddo                                                             
  1801      end do
  1802      do n = IndexH2OVap+1, ncmax
  1803        xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1141 = 1, xyrf_qmixfluxcor.DSC.U2*xyrf_qmixfluxcor.DSC.U1 +   
     .       1   xyrf_qmixfluxcor.DSC.U2                                        
     .           xyrf_qmixfluxcor(t1141-1,1,0,n) = xyrf_qmixflux(t1141-1,1,0,n) 
     .        enddo                                                             
  1804      end do
  1805      n = IndexH2OVap
  1806      do j = 1, jmax
  1807        do i = 0, imax-1
  1808  !!$        xyr_LatentHeatFluxCor( i,j,0 ) = xy_SurfLatentHeatFlux( i,j )             &
  1809  !!$          & - LatentHeat * xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )  &
  1810  !!$          &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
  1811  !!$          &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * 2.0d0 * DelTime
  1812          xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
  1813        end do
  1814      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_latentheatfluxcor(j-1,1,0) = latentheat*xyrf_qmixfluxcor(j-
     .       1      1,1,0,n)                                                    
     .        enddo                                                             
  1815  
  1816      ! ヒストリデータ出力
  1817      ! History data output
  1818      !
  1819      call HistoryAutoPut( TimeN, 'TauXA'          , xyr_MomFluxXCor (:,:,0) )
  1820      call HistoryAutoPut( TimeN, 'TauYA'          , xyr_MomFluxYCor (:,:,0) )
  1821      call HistoryAutoPut( TimeN, 'SensA'          , xyr_HeatFluxCor (:,:,0) )
  1822      call HistoryAutoPut( TimeN, 'SurfH2OVapFluxA', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
  1823      call HistoryAutoPut( TimeN, 'EvapA'          , xyr_LatentHeatFluxCor(:,:,0) )
  1824  
  1825  
  1826      ! ヒストリデータ出力
  1827      ! History data output
  1828      !
  1829      call HistoryAutoPut( TimeN, 'SurfH2OVapFluxU', xy_SurfH2OVapFluxA     )
  1830      call HistoryAutoPut( TimeN, 'EvapU'          , xy_SurfLatentHeatFluxA )
  1831  
  1832  
  1833      ! 計算時間計測一時停止
  1834      ! Pause measurement of computation time
  1835      !
  1836      call TimesetClockStop( module_name )
  1837  
  1838    end subroutine SurfaceFluxOutput
  1839  
  1840    !--------------------------------------------------------------------------------------
  1841  
  1842    subroutine SurfaceFluxInit
  1843      !
  1844      ! surface_flux_bulk モジュールの初期化を行います.
  1845      ! NAMELIST#surface_flux_bulk_nml の読み込みはこの手続きで行われます.
  1846      !
  1847      ! "surface_flux_bulk" module is initialized.
  1848      ! "NAMELIST#surface_flux_bulk_nml" is loaded in this procedure.
  1849      !
  1850  
  1851      ! モジュール引用 ; USE statements
  1852      !
  1853  
  1854      ! NAMELIST ファイル入力に関するユーティリティ
  1855      ! Utilities for NAMELIST file input
  1856      !
  1857      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1858  
  1859      ! ファイル入出力補助
  1860      ! File I/O support
  1861      !
  1862      use dc_iounit, only: FileOpen
  1863  
  1864      ! 種別型パラメタ
  1865      ! Kind type parameter
  1866      !
  1867      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1868  
  1869      ! 文字列操作
  1870      ! Character handling
  1871      !
  1872      use dc_string, only: StoA
  1873  
  1874      ! ヒストリデータ出力
  1875      ! History data output
  1876      !
  1877      use gtool_historyauto, only: HistoryAutoAddVariable
  1878  
  1879      ! 座標データ設定
  1880      ! Axes data settings
  1881      !
  1882      use axesset, only: &
  1883        & AxnameX, &
  1884        & AxnameY, &
  1885        & AxnameZ, &
  1886        & AxnameR, &
  1887        & AxnameT
  1888  
  1889      ! 飽和比湿の算出
  1890      ! Evaluate saturation specific humidity
  1891      !
  1892      use saturate, only: SaturateInit
  1893  
  1894  
  1895      ! 宣言文 ; Declaration statements
  1896      !
  1897      implicit none
  1898  
  1899      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1900                                ! Unit number for NAMELIST file open
  1901      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1902                                ! IOSTAT of NAMELIST read
  1903  
  1904      ! NAMELIST 変数群
  1905      ! NAMELIST group name
  1906      !
  1907      namelist /surface_flux_bulk_nml/                                  &
  1908        & FlagConstBulkCoef,                                            &
  1909        & FlagUseOfBulkCoefInNeutralCond, ConstBulkCoef,                &
  1910        & FlagIncludeB94W,                                              &
  1911        !
  1912        & VelMinForRi, VelMinForVel, VelMinForTemp, VelMinForQVap,      &
  1913        & VelMaxForVel, VelMaxForTemp, VelMaxForQVap,                   &
  1914        !
  1915        & VelBulkCoefMin, TempBulkCoefMin, QVapBulkCoefMin,             &
  1916        & VelBulkCoefMax, TempBulkCoefMax, QVapBulkCoefMax,             &
  1917        !
  1918        & FlagFixFricTimeConstAtLB, FricTimeConstAtLB, LowLatFricAtLB,  &
  1919        & FlagFixHeatFluxAtLB,      HeatFluxAtLB,                       &
  1920        & FlagFixMassFluxAtLB,      MassFluxAtLB
  1921            !
  1922            ! デフォルト値については初期化手続 "surface_flux_bulk#SurfaceFluxInit"
  1923            ! のソースコードを参照のこと.
  1924            !
  1925            ! Refer to source codes in the initialization procedure
  1926            ! "surface_flux_bulk#SurfaceFluxInit" for the default values.
  1927            !
  1928  
  1929      ! 実行文 ; Executable statement
  1930      !
  1931  
  1932      if ( surface_flux_bulk_inited ) return
  1933  
  1934  
  1935      ! デフォルト値の設定
  1936      ! Default values settings
  1937      !
  1938      FlagConstBulkCoef              = .false.
  1939      FlagUseOfBulkCoefInNeutralCond = .false.
  1940      ConstBulkCoef                  =  0.0_DP
  1941  !!$    FlagIncludeB94W                = .false.
  1942      FlagIncludeB94W                = .true.
  1943  
  1944      VelMinForRi   = 0.01_DP
  1945      VelMinForVel  = 0.01_DP
  1946      VelMinForTemp = 0.01_DP
  1947      VelMinForQVap = 0.01_DP
  1948      VelMaxForVel  = 1000.0_DP
  1949      VelMaxForTemp = 1000.0_DP
  1950      VelMaxForQVap = 1000.0_DP
  1951  
  1952      VelBulkCoefMin  =  0.0_DP
  1953      TempBulkCoefMin =  0.0_DP
  1954      QVapBulkCoefMin =  0.0_DP
  1955      VelBulkCoefMax  =  1.0_DP
  1956      TempBulkCoefMax =  1.0_DP
  1957      QVapBulkCoefMax =  1.0_DP
  1958  
  1959      FlagFixFricTimeConstAtLB = .false.
  1960      FricTimeConstAtLB        = 1.0e100_DP
  1961      LowLatFricAtLB           = 1.0e100_DP
  1962      FlagFixHeatFluxAtLB      = .false.
  1963      HeatFluxAtLB             = 1.0e100_DP
  1964      FlagFixMassFluxAtLB      = .false.
  1965      MassFluxAtLB             = 1.0e100_DP
  1966  
  1967      ! NAMELIST の読み込み
  1968      ! NAMELIST is input
  1969      !
  1970      if ( trim(namelist_filename) /= '' ) then
  1971        call FileOpen( unit_nml, &          ! (out)
  1972          & namelist_filename, mode = 'r' ) ! (in)
  1973  
  1974        rewind( unit_nml )
  1975        read( unit_nml, &                ! (in)
  1976          & nml = surface_flux_bulk_nml, &  ! (out)
  1977          & iostat = iostat_nml )        ! (out)
  1978        close( unit_nml )
  1979  
  1980        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1981      end if
  1982  
  1983      ! ヒストリデータ出力のためのへの変数登録
  1984      ! Register of variables for history data output
  1985      !
  1986      call HistoryAutoAddVariable( 'BulkCoefMom', &
  1987        & (/ AxNameX, AxNameY, AxNameT /), &
  1988        & 'bulk coefficient for momentum', '1' )
  1989      call HistoryAutoAddVariable( 'BulkCoefHeat', &
  1990        & (/ AxNameX, AxNameY, AxNameT /), &
  1991        & 'bulk coefficient for heat', '1' )
  1992      call HistoryAutoAddVariable( 'SfcBulkRi', &
  1993        & (/ AxNameX, AxNameY, AxNameT /), &
  1994        & 'bulk Richardson number at the surface', '1' )
  1995  
  1996      call HistoryAutoAddVariable( 'TauX', &
  1997        & (/ AxNameX, AxNameY, AxNameT /), &
  1998        & 'surface stress(x)  ', 'N m-2' )
  1999      call HistoryAutoAddVariable( 'TauY', &
  2000        & (/ AxNameX, AxNameY, AxNameT /), &
  2001        & 'surface stress(y)  ', 'N m-2' )
  2002      call HistoryAutoAddVariable( 'Sens', &
  2003        & (/ AxNameX, AxNameY, AxNameT /), &
  2004        & 'sensible heat flux', 'W m-2' )
  2005      call HistoryAutoAddVariable( 'SurfH2OVapFlux', &
  2006        & (/ AxNameX, AxNameY, AxNameT /), &
  2007        & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
  2008      call HistoryAutoAddVariable( 'Evap', &
  2009        & (/ AxNameX, AxNameY, AxNameT /), &
  2010        & 'latent heat flux  ', 'W m-2' )
  2011  
  2012      call HistoryAutoAddVariable( 'TauXB', &
  2013        & (/ AxNameX, AxNameY, AxNameT /), &
  2014        & 'surface stress(x)  ', 'N m-2' )
  2015      call HistoryAutoAddVariable( 'TauYB', &
  2016        & (/ AxNameX, AxNameY, AxNameT /), &
  2017        & 'surface stress(y)  ', 'N m-2' )
  2018      call HistoryAutoAddVariable( 'SensB', &
  2019        & (/ AxNameX, AxNameY, AxNameT /), &
  2020        & 'sensible heat flux', 'W m-2' )
  2021      call HistoryAutoAddVariable( 'SurfH2OVapFluxB', &
  2022        & (/ AxNameX, AxNameY, AxNameT /), &
  2023        & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
  2024      call HistoryAutoAddVariable( 'EvapB', &
  2025        & (/ AxNameX, AxNameY, AxNameT /), &
  2026        & 'latent heat flux  ', 'W m-2' )
  2027  
  2028      call HistoryAutoAddVariable( 'TauXA', &
  2029        & (/ AxNameX, AxNameY, AxNameT /), &
  2030        & 'surface stress(x)  ', 'N m-2' )
  2031      call HistoryAutoAddVariable( 'TauYA', &
  2032        & (/ AxNameX, AxNameY, AxNameT /), &
  2033        & 'surface stress(y)  ', 'N m-2' )
  2034      call HistoryAutoAddVariable( 'SensA', &
  2035        & (/ AxNameX, AxNameY, AxNameT /), &
  2036        & 'sensible heat flux', 'W m-2' )
  2037      call HistoryAutoAddVariable( 'SurfH2OVapFluxA', &
  2038        & (/ AxNameX, AxNameY, AxNameT /), &
  2039        & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
  2040      call HistoryAutoAddVariable( 'EvapA', &
  2041        & (/ AxNameX, AxNameY, AxNameT /), &
  2042        & 'latent heat flux  ', 'W m-2' )
  2043  
  2044      call HistoryAutoAddVariable( 'SurfH2OVapFluxU', &
  2045        & (/ AxNameX, AxNameY, AxNameT /), &
  2046        & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
  2047      call HistoryAutoAddVariable( 'EvapU', &
  2048        & (/ AxNameX, AxNameY, AxNameT /), &
  2049        & 'latent heat flux  ', 'W m-2' )
  2050  
  2051      call HistoryAutoAddVariable( 'MOLength', &
  2052        & (/ AxNameX, AxNameY, AxNameT /), &
  2053        & 'Monin-Obukhov length', 'm' )
  2054      call HistoryAutoAddVariable( 'MOLengthInv', &
  2055        & (/ AxNameX, AxNameY, AxNameT /), &
  2056        & 'Monin-Obukhov length inverse', 'm-1' )
  2057      call HistoryAutoAddVariable( 'BetaW', &
  2058        & (/ AxNameX, AxNameY, AxNameT /), &
  2059        & 'beta w_*', 'm s-1' )
  2060      call HistoryAutoAddVariable( 'BLHeight', &
  2061        & (/ AxNameX, AxNameY, AxNameT /), &
  2062        & 'boundary layer height', 'm' )
  2063  
  2064  
  2065      ! Initialization of modules used in this module
  2066      !
  2067      ! 飽和比湿の算出
  2068      ! Evaluate saturation specific humidity
  2069      !
  2070      call SaturateInit
  2071  
  2072  
  2073      ! 印字 ; Print
  2074      !
  2075      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2076  
  2077      call MessageNotify( 'M', module_name, '  VelMinForRi       = %f', d = (/ VelMinForRi   /) )
  2078      call MessageNotify( 'M', module_name, '  VelMinForVel      = %f', d = (/ VelMinForVel  /) )
  2079      call MessageNotify( 'M', module_name, '  VelMinForTemp     = %f', d = (/ VelMinForTemp /) )
  2080      call MessageNotify( 'M', module_name, '  VelMinForQVap     = %f', d = (/ VelMinForQVap /) )
  2081      call MessageNotify( 'M', module_name, '  VelMaxForVel      = %f', d = (/ VelMaxForVel  /) )
  2082      call MessageNotify( 'M', module_name, '  VelMaxForTemp     = %f', d = (/ VelMaxForTemp /) )
  2083      call MessageNotify( 'M', module_name, '  VelMaxForQVap     = %f', d = (/ VelMaxForQVap /) )
  2084      call MessageNotify( 'M', module_name, 'Bulk coefficients:' )
  2085      call MessageNotify( 'M', module_name, '  FlagConstBulkCoef              = %b', l = (/ FlagConstBulkCoef /) )
  2086      call MessageNotify( 'M', module_name, '  FlagUseOfBulkCoefInNeutralCond = %b', l = (/ FlagUseOfBulkCoefInNeutralCond /) )
  2087      call MessageNotify( 'M', module_name, '  ConstBulkCoef   = %f', d = (/ ConstBulkCoef   /) )
  2088      call MessageNotify( 'M', module_name, '  VelBulkCoefMin  = %f', d = (/ VelBulkCoefMin  /) )
  2089      call MessageNotify( 'M', module_name, '  TempBulkCoefMin = %f', d = (/ TempBulkCoefMin /) )
  2090      call MessageNotify( 'M', module_name, '  QVapBulkCoefMin = %f', d = (/ QVapBulkCoefMin /) )
  2091      call MessageNotify( 'M', module_name, '  VelBulkCoefMax  = %f', d = (/ VelBulkCoefMax  /) )
  2092      call MessageNotify( 'M', module_name, '  TempBulkCoefMax = %f', d = (/ TempBulkCoefMax /) )
  2093      call MessageNotify( 'M', module_name, '  QVapBulkCoefMax = %f', d = (/ QVapBulkCoefMax /) )
  2094      call MessageNotify( 'M', module_name, 'FlagIncludeB94W          = %b', l = (/ FlagIncludeB94W /) )
  2095      call MessageNotify( 'M', module_name, 'FlagFixFricTimeConstAtLB = %b', l = (/ FlagFixFricTimeConstAtLB /) )
  2096      call MessageNotify( 'M', module_name, 'FricTimeConstAtLB        = %f', d = (/ FricTimeConstAtLB /) )
  2097      call MessageNotify( 'M', module_name, 'LowLatFricAtLB           = %f', d = (/ LowLatFricAtLB /) )
  2098      call MessageNotify( 'M', module_name, 'FlagFixHeatFluxAtLB      = %b', l = (/ FlagFixHeatFluxAtLB /) )
  2099      call MessageNotify( 'M', module_name, 'HeatFluxAtLB             = %f', d = (/ HeatFluxAtLB /) )
  2100      call MessageNotify( 'M', module_name, 'FlagFixMassFluxAtLB      = %b', l = (/ FlagFixMassFluxAtLB /) )
  2101      call MessageNotify( 'M', module_name, 'MassFluxAtLB             = %f', d = (/ MassFluxAtLB /) )
  2102      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2103  
  2104      surface_flux_bulk_inited = .true.
  2105  
  2106    end subroutine SurfaceFluxInit
  2107  
  2108    !--------------------------------------------------------------------------------------
  2109  
  2110  end module surface_flux_bulk
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:42 2016
FILE NAME: surface_flux_bulk.f90
PROGRAM NAME: surface_flux_bulk
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地表面フラックス (バルク法)
     2:             !
     3:             != Surface flux (Bulk method)
     4:             !
     5:             ! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: surface_flux_bulk.f90,v 1.27 2015/02/06 11:25:14 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module surface_flux_bulk
    13:               !
    14:               != 地表面フラックス
    15:               !
    16:               != Surface flux
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 地表面フラックスを計算. 
    21:               !
    22:               ! Surface fluxes are calculated.
    23:               !
    24:               !== References
    25:               !
    26:               ! Louis, J-F., M. Tiedtke, and J-F. Geleyn, 
    27:               ! A short history of the PBL parameterization at ECMWF, 
    28:               ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K., 
    29:               ! 1982.
    30:               !
    31:               ! Beljaars, A. C. M., and A. A. M. Holtslag, 
    32:               ! Flux parameterization over land surfaces for atmospheric models,
    33:               ! J. Appl. Meteor., 30, 327-341, 1991.
    34:               !
    35:               ! Beljaars, A. C. M., 
    36:               ! The parameterization of surface fluxes in large-scale models 
    37:               ! under free convection, 
    38:               ! Q. J. R. Meteorol. Soc., 121, 255-270, 1994.
    39:               !
    40:               !== Procedures List
    41:               !
    42:               ! SurfaceFlux       :: 地表面フラックスの計算
    43:               ! SurfaceFluxOutput :: 地表面フラックスの出力
    44:               ! ------------      :: ------------
    45:               ! SurfaceFlux       :: Calculate surface fluxes
    46:               ! SurfaceFluxOutput :: Output surface fluxes
    47:               !
    48:               !== NAMELIST
    49:               !
    50:               ! NAMELIST#surface_flux_bulk_nml
    51:               !
    52:             
    53:               ! モジュール引用 ; USE statements
    54:               !
    55:             
    56:               ! 格子点設定
    57:               ! Grid points settings
    58:               !
    59:               use gridset, only: imax, & ! 経度格子点数. 
    60:                                          ! Number of grid points in longitude
    61:                 &                jmax, & ! 緯度格子点数. 
    62:                                          ! Number of grid points in latitude
    63:                 &                kmax    ! 鉛直層数. 
    64:                                          ! Number of vertical level
    65:             
    66:               ! 組成に関わる配列の設定
    67:               ! Settings of array for atmospheric composition
    68:               !
    69:               use composition, only: ncmax, IndexH2OVap
    70:             
    71:               ! 種別型パラメタ
    72:               ! Kind type parameter
    73:               !
    74:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    75:                 &                 STRING     ! 文字列.       Strings. 
    76:             
    77:               ! メッセージ出力
    78:               ! Message output
    79:               !
    80:               use dc_message, only: MessageNotify
    81:             
    82:               ! 宣言文 ; Declaration statements
    83:               !
    84:               implicit none
    85:               private
    86:             
    87:               ! 公開手続き
    88:               ! Public procedure
    89:               !
    90:               public :: SurfaceFlux
    91:               public :: SurfaceFluxOutput
    92:               public :: SurfaceFluxInit
    93:             
    94:               ! 公開変数
    95:               ! Public variables
    96:               !
    97:             
    98:               ! 非公開変数
    99:               ! Private variables
   100:               !
   101:               integer, parameter :: IDBulkCoefMethodL82     = 1
   102:               integer, parameter :: IDBulkCoefMethodBH91B94 = 2
   103:             
   104:               logical            :: FlagIncludeB94W
   105:             
   106:               logical, save :: surface_flux_bulk_inited = .false.
   107:                                           ! 初期設定フラグ. 
   108:                                           ! Initialization flag
   109:             
   110:               real(DP), save:: VelMinForRi
   111:                                         ! $ R_i $ 数用風最小値. 
   112:                                         ! Minimum value of velocity for $ R_i $ number
   113:               real(DP), save:: VelMinForVel
   114:                                         ! 運動量用風最小値. 
   115:                                         ! Minimum value of velocity for momentum
   116:               real(DP), save:: VelMinForTemp
   117:                                         ! 熱用風最小値. 
   118:                                         ! Minimum value of velocity for thermal
   119:               real(DP), save:: VelMinForQVap
   120:                                         ! 水蒸気用風最小値. 
   121:                                         ! Minimum value of velocity for vapor
   122:               real(DP), save:: VelMaxForVel
   123:                                         ! 運動量用風最大値. 
   124:                                         ! Maximum value of velocity for momentum
   125:               real(DP), save:: VelMaxForTemp
   126:                                         ! 熱用風最大値. 
   127:                                         ! Maximum value of velocity for thermal
   128:               real(DP), save:: VelMaxForQVap
   129:                                         ! 水蒸気用風最大値. 
   130:                                         ! Maximum value of velocity for vapor
   131:             
   132:             
   133:               ! バルク係数
   134:               ! Bluk coefficients
   135:               !
   136:               logical, save:: FlagConstBulkCoef
   137:                                         ! Flag for using constant bulk coefficient
   138:               logical, save:: FlagUseOfBulkCoefInNeutralCond
   139:                                         ! Flag for using bulk coefficient in neutral condition
   140:               real(DP), save:: ConstBulkCoef
   141:                                         ! バルク係数一定値. 
   142:                                         ! Steady value of bulk coefficient
   143:               real(DP), save:: VelBulkCoefMin
   144:                                         ! $ u $ バルク係数最小値. 
   145:                                         ! Minimum value of $ u $ bulk coefficient
   146:               real(DP), save:: TempBulkCoefMin
   147:                                         ! $ T $ バルク係数最小値. 
   148:                                         ! Minimum value of $ T $ bulk coefficient
   149:               real(DP), save:: QVapBulkCoefMin
   150:                                         ! $ q $ バルク係数最小値. 
   151:                                         ! Minimum value of $ q $ bulk coefficient
   152:               real(DP), save:: VelBulkCoefMax
   153:                                         ! $ u $ バルク係数最大値. 
   154:                                         ! Maximum value of $ u $ bulk coefficient
   155:               real(DP), save:: TempBulkCoefMax
   156:                                         ! $ T $ バルク係数最大値. 
   157:                                         ! Maximum value of $ T $ bulk coefficient
   158:               real(DP), save:: QVapBulkCoefMax
   159:                                         ! $ q $ バルク係数最大値. 
   160:                                         ! Maximum value of $ q $ bulk coefficient
   161:               logical , save:: FlagFixFricTimeConstAtLB
   162:               real(DP), save:: FricTimeConstAtLB
   163:                                         ! 下部境界摩擦の時定数 (s).
   164:                                         ! Time constant of surface friction (s).
   165:               real(DP), save:: LowLatFricAtLB
   166:                                         ! 下部境界摩擦が働く最低緯度 (degree).
   167:                                         ! Lowest latitude where the friction is applied (degree)
   168:               logical , save:: FlagFixHeatFluxAtLB
   169:               real(DP), save:: HeatFluxAtLB
   170:                                         ! 下部境界での熱フラックス (W m-2).
   171:                                         ! Heat flux at the lower boundary (W m-2).
   172:               logical , save:: FlagFixMassFluxAtLB
   173:               real(DP), save:: MassFluxAtLB
   174:                                         ! 下部境界での質量フラックス (W m-2).
   175:                                         ! 実際にはゼロに固定するために使う程度にしか使えないだろう.
   176:                                         ! Mass flux at the lower boundary (kg m-2 s-1).
   177:             
   178:               character(*), parameter:: module_name = 'surface_flux_bulk'
   179:                                           ! モジュールの名称. 
   180:                                           ! Module name
   181:               character(*), parameter:: version = &
   182:                 & '$Name:  $' // &
   183:                 & '$Id: surface_flux_bulk.f90,v 1.27 2015/02/06 11:25:14 yot Exp $'
   184:                                           ! モジュールのバージョン
   185:                                           ! Module version
   186:             
   187:             
   188:             contains
   189:             
   190:               !--------------------------------------------------------------------------------------
   191:             
   192:               subroutine SurfaceFlux( &
   193:                 & BulkCoefMethod,                                               & ! (in)
   194:                 & xyz_U, xyz_V,                                                 & ! (in)
   195:                 & xyz_Temp, xyr_Temp, xyz_VirTemp, xyr_VirTemp, xy_SurfVirTemp, & ! (in)
   196:                 & xyzf_QMix,                                                    & ! (in)
   197:                 & xyr_Press, xy_SurfHeight, xyz_Height, xyz_Exner, xyr_Exner,   & ! (in)
   198:                 & xy_SurfTemp, xy_SurfHumidCoef,                                & ! (in)
   199:                 & xy_SurfRoughLengthMom, xy_SurfRoughLengthHeat,                & ! (in)
   200:                 & xy_SnowFrac,                                                  & ! (in)
   201:                 & xy_MomFluxX, xy_MomFluxY, xy_HeatFlux, xyf_QMixFlux,          & ! (out)
   202:                 & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                    & ! (out)
   203:                 & xy_SurfQVapTransCoef,                                         & ! (out)
   204:                 & xy_SurfMOLength                                               & ! (out)
   205:                 & )
   206:                 !
   207:                 ! 温度, 比湿, 気圧から, 放射フラックスを計算します. 
   208:                 !
   209:                 ! Calculate radiation flux from temperature, specific humidity, and 
   210:                 ! air pressure. 
   211:                 !
   212:             
   213:                 ! モジュール引用 ; USE statements
   214:                 !
   215:             
   216:                 ! ヒストリデータ出力
   217:                 ! History data output
   218:                 !
   219:                 use gtool_historyauto, only: HistoryAutoPut
   220:             
   221:                 ! 物理・数学定数設定
   222:                 ! Physical and mathematical constants settings
   223:                 !
   224:                 use constants0, only: &
   225:                   & PI
   226:                                           ! $ \pi $ .
   227:                                           ! 円周率.  Circular constant
   228:             
   229:                 ! 物理定数設定
   230:                 ! Physical constants settings
   231:                 !
   232:                 use constants, only: &
   233:                   & GasRDry, &
   234:                                           ! $ R $ [J kg-1 K-1]. 
   235:                                           ! 乾燥大気の気体定数. 
   236:                                           ! Gas constant of air
   237:                   & CpDry
   238:                                           ! $ C_p $ [J kg-1 K-1]. 
   239:                                           ! 乾燥大気の定圧比熱. 
   240:                                           ! Specific heat of air at constant pressure
   241:             
   242:                 ! 飽和比湿の算出
   243:                 ! Evaluate saturation specific humidity
   244:                 !
   245:                 use saturate, only: &
   246:                   & xy_CalcQVapSatOnLiq, &
   247:                   & xy_CalcQVapSatOnSol
   248:             
   249:                 ! 座標データ設定
   250:                 ! Axes data settings
   251:                 !
   252:                 use axesset, only: &
   253:                   & y_Lat                 ! $ \varphi $ [rad.] . 緯度. Latitude
   254:             
   255:                 ! 時刻管理
   256:                 ! Time control
   257:                 !
   258:                 use timeset, only: &
   259:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   260:                   & TimesetClockStart, TimesetClockStop
   261:             
   262:                 ! デバッグ用ユーティリティ
   263:                 ! Utilities for debug
   264:                 !
   265:                 use dc_trace, only: DbgMessage, BeginSub, EndSub
   266:             
   267:                 ! 宣言文 ; Declaration statements
   268:                 !
   269:                 implicit none
   270:             
   271:                 character(*), intent(in):: BulkCoefMethod
   272:                                           !
   273:                                           ! Method for calculating bulk coefficient
   274:                 real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   275:                                           ! $ u $ . 東西風速. Eastward wind
   276:                 real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   277:                                           ! $ v $ . 南北風速. Northward wind
   278:             
   279:                 real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   280:                                           ! $ T $ . 温度 (整数レベル). 
   281:                                           ! Temperature (full level)
   282:                 real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
   283:                                           ! $ T $ . 温度 (半整数レベル). 
   284:                                           ! Temperature (half level)
   285:                 real(DP), intent(in):: xyz_VirTemp (0:imax-1, 1:jmax, 1:kmax)
   286:                                           ! $ T_v $ . 仮温度 (整数レベル). 
   287:                                           ! Virtual temperature (full level)
   288:                 real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   289:                                           ! $ T_v $ . 仮温度 (半整数レベル). 
   290:                                           ! Virtual temperature (half level)
   291:                 real(DP), intent(in):: xy_SurfVirTemp (0:imax-1, 1:jmax)
   292:                                           ! $ T_v $ . 仮温度 (惑星表面). 
   293:                                           ! Virtual temperature (surface)
   294:                 real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   295:                                           ! $ q $ .     比湿. Specific humidity
   296:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   297:                                           ! $ p_s $ . 地表面気圧 (半整数レベル). 
   298:                                           ! Surface pressure (half level)
   299:                 real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
   300:                                           ! $ z_s $ . 地表面高度. 
   301:                                           ! Surface height. 
   302:                 real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   303:                                           ! 高度 (整数レベル). 
   304:                                           ! Height (full level)
   305:                 real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   306:                                           ! Exner 関数 (整数レベル). 
   307:                                           ! Exner function (full level)
   308:                 real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   309:                                           ! Exner 関数 (半整数レベル). 
   310:                                           ! Exner function (half level)
   311:                 real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   312:                                           ! 地表面温度. 
   313:                                           ! Surface temperature
   314:                 real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   315:                                           ! 地表湿潤度. 
   316:                                           ! Surface humidity coefficient
   317:                 real(DP), intent(in):: xy_SurfRoughLengthMom (0:imax-1, 1:jmax)
   318:                                           ! 地表粗度長. 
   319:                                           ! Surface rough length for momentum
   320:                 real(DP), intent(in):: xy_SurfRoughLengthHeat(0:imax-1, 1:jmax)
   321:                                           ! 地表粗度長. 
   322:                                           ! Surface rough length for heat
   323:                 real(DP), intent(in):: xy_SnowFrac(0:imax-1, 1:jmax)
   324:                                           ! 
   325:                                           ! Snow fraction
   326:                 real(DP), intent(out):: xy_MomFluxX (0:imax-1, 1:jmax)
   327:                                           ! 惑星表面東西方向運動量フラックス. 
   328:                                           ! Eastward momentum flux at surface
   329:                 real(DP), intent(out):: xy_MomFluxY (0:imax-1, 1:jmax)
   330:                                           ! 惑星表面南北方向運動量フラックス. 
   331:                                           ! Northward momentum flux at surface
   332:                 real(DP), intent(out):: xy_HeatFlux (0:imax-1, 1:jmax)
   333:                                           ! 惑星表面熱フラックス. 
   334:                                           ! Heat flux at surface
   335:                 real(DP), intent(out):: xyf_QMixFlux(0:imax-1, 1:jmax, 1:ncmax)
   336:                                           ! 惑星表面比湿フラックス. 
   337:                                           ! Specific humidity flux at surface
   338:                 real(DP), intent(out):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
   339:                                           ! 輸送係数：運動量. 
   340:                                           ! Diffusion coefficient: velocity
   341:                 real(DP), intent(out):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
   342:                                           ! 輸送係数：温度. 
   343:                                           ! Transfer coefficient: temperature
   344:                 real(DP), intent(out):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
   345:                                           ! 輸送係数：水蒸気
   346:                                           ! Transfer coefficient: water vapor
   347:                 real(DP), intent(out):: xy_SurfMOLength(0:imax-1, 1:jmax)
   348:             
   349:                 ! 作業変数
   350:                 ! Work variables
   351:                 !
   352:                 real(DP):: xy_SurfTempBulkCoef (0:imax-1, 1:jmax)
   353:                                           ! バルク係数：温度. 
   354:                                           ! Bulk coefficient: temperature
   355:                 real(DP):: xy_SurfQVapBulkCoef (0:imax-1, 1:jmax)
   356:                                           ! バルク係数：比湿. 
   357:                                           ! Bulk coefficient: specific humidity
   358:                 real(DP):: xy_SurfVelBulkCoef (0:imax-1, 1:jmax)
   359:                                           ! バルク係数：運動量. 
   360:                                           ! Bulk coefficient: temperature
   361:                 real(DP):: xy_SurfVelAbs (0:imax-1, 1:jmax)
   362:                                           ! 風速絶対値. 
   363:                                           ! Absolute velocity
   364:                 real(DP):: xy_SurfQVapSatOnLiq (0:imax-1, 1:jmax)
   365:                                           ! 地表飽和比湿. 
   366:                                           ! Saturated specific humidity on surface
   367:                 real(DP):: xy_SurfQVapSatOnSol (0:imax-1, 1:jmax)
   368:                                           ! 地表飽和比湿. 
   369:                                           ! Saturated specific humidity on surface
   370:                 real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
   371:                                           ! 地表飽和比湿. 
   372:                                           ! Saturated specific humidity on surface
   373:             
   374:                 real(DP):: xy_MomFluxXSurf (0:imax-1, 1:jmax)
   375:                                           ! 地表面の東西方向運動量フラックス. 
   376:                                           ! Eastward momentum flux on surface
   377:                 real(DP):: xy_MomFluxYSurf (0:imax-1, 1:jmax)
   378:                                           ! 地表面の南北方向運動量フラックス. 
   379:                                           ! Northward momentum flux on surface
   380:                 real(DP):: xy_HeatFluxSurf (0:imax-1, 1:jmax)
   381:                                           ! 地表面の熱フラックス. 
   382:                                           ! Heat flux on surface
   383:                 real(DP):: xyf_QMixFluxSurf(0:imax-1, 1:jmax, 1:ncmax)
   384:                                           ! 地表面の質量フラックス. 
   385:                                           ! Mass flux of constituents on surface
   386:             
   387:                 real(DP):: xy_BetaW   (0:imax-1, 1:jmax)
   388:                                           ! 
   389:                                           ! "vertical velocity" (B94)
   390:             
   391:                 integer            :: IDBulkCoefMethod
   392:             
   393:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   394:                                           ! Work variables for DO loop in longitude
   395:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   396:                                           ! Work variables for DO loop in latitude
   397:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   398:                                           ! Work variables for DO loop in dimension of constituents
   399:             
   400:                 ! 実行文 ; Executable statement
   401:                 !
   402:             
   403:                 ! 初期化確認
   404:                 ! Initialization check
   405:                 !
   406:                 if ( .not. surface_flux_bulk_inited ) then
   407:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   408:                 end if
   409:             
   410:             
   411:                 ! 計算時間計測開始
   412:                 ! Start measurement of computation time
   413:                 !
   414:                 call TimesetClockStart( module_name )
   415:             
   416:             
   417:                 ! Check method for calculating bulk coefficient
   418:                 !
   419:                 if ( BulkCoefMethod == 'L82' ) then
   420:                   IDBulkCoefMethod = IDBulkCoefMethodL82
   421:                 else if ( BulkCoefMethod == 'BH91B94' ) then
   422:                   IDBulkCoefMethod = IDBulkCoefMethodBH91B94
   423:                 else
   424:                   call MessageNotify( 'E', module_name, 'BulkCoefMethod of %c is inappropriate.', c1 = trim( BulkCoefMethod ) )
   425:                 end if
   426:             
   427:             
   428:                 ! バルク係数算出
   429:                 ! Calculate bulk coefficients
   430:                 !
   431:                 call BulkCoef( &
   432:                   & IDBulkCoefMethod, &       ! (in)
   433:                   & xy_SurfRoughLengthMom ,  & ! (in)
   434:                   & xy_SurfRoughLengthHeat,  & ! (in)
   435:                   & xy_SurfHeight,       & ! (in)
   436:                   & xyz_Height,          & ! (in)
   437:                   & xyz_U(:,:,1), xyz_V(:,:,1), & ! (in)
   438:             !!$      & xy_SurfTemp, xyz_Temp(:,:,1), xyr_Exner(:,:,0), xyz_Exner(:,:,1), & ! (in)
   439:                   & xy_SurfVirTemp, xyz_VirTemp(:,:,1), xyr_Exner(:,:,0), xyz_Exner(:,:,1), & ! (in)
   440:                   & xy_SurfVelBulkCoef,  & ! (out)
   441:                   & xy_SurfTempBulkCoef, & ! (out)
   442:                   & xy_SurfQVapBulkCoef, & ! (out)
   443:                   & xy_BetaW,            & ! (out)
   444:                   & xy_SurfMOLength      & ! (out)
   445:                   & )
   446:             
   447:             
   448:                 ! 
   449:                 ! Calculation of wind speed
   450:                 !
   451: W*===== A       xy_SurfVelAbs = sqrt ( xyz_U(:,:,1)**2 + xyz_V(:,:,1)**2 + xy_BetaW**2 )
   452:             !!$    xy_SurfVelAbs = sqrt ( xyz_U(:,:,1)**2 + xyz_V(:,:,1)**2 )
   453:             
   454:             
   455:                 ! 輸送係数の計算
   456:                 ! Calculate transfer coefficient
   457:                 !
   458:                 if ( .not. FlagFixFricTimeConstAtLB ) then
   459: W------>          do i = 0, imax-1
   460: |*----->            do j = 1, jmax
   461: ||          !!$          xy_SurfVelTransCoef(i,j) = &
   462: ||          !!$            &   xy_SurfVelBulkCoef(i,j) &
   463: ||          !!$            &   * xyr_Press(i,j,0) / ( GasRDry * xyr_Temp(i,j,0) ) &
   464: ||          !!$            &   * min( max( xy_SurfVelAbs(i,j), VelMinForVel ), VelMaxForVel )
   465: ||      A             xy_SurfVelTransCoef(i,j) =                                  &
   466: ||                      &   xy_SurfVelBulkCoef(i,j)                               &
   467: ||                      &   * xyr_Press(i,j,0) / ( GasRDry * xyr_VirTemp(i,j,0) ) &
   468: ||                      &   * min( max( xy_SurfVelAbs(i,j), VelMinForVel ), VelMaxForVel )
   469: |*-----             end do
   470: W------           end do
   471:                 else
   472: +------>          do j = 1, jmax
   473: |                   if ( abs( y_Lat(j) ) >= LowLatFricAtLB * PI / 180.0_DP ) then
   474: |V===== A             xy_SurfVelTransCoef(:,j) = 1.0_DP / FricTimeConstAtLB
   475: |                   else
   476: |V===== A             xy_SurfVelTransCoef(:,j) = 0.0_DP
   477: |                   end if
   478: +------           end do
   479:                 end if
   480:             
   481:                 if ( .not. FlagFixHeatFluxAtLB ) then
   482: W------>          do i = 0, imax-1
   483: |*----->            do j = 1, jmax
   484: ||          !!$          xy_SurfTempTransCoef(i,j) = &
   485: ||          !!$            &   xy_SurfTempBulkCoef(i,j) &
   486: ||          !!$            &   * xyr_Press(i,j,0) / ( GasRDry * xyr_Temp(i,j,0) ) &
   487: ||          !!$            &   * min( max( xy_SurfVelAbs(i,j), VelMinForTemp ), VelMaxForTemp )
   488: ||      A             xy_SurfTempTransCoef(i,j) =                                 &
   489: ||                      &   xy_SurfTempBulkCoef(i,j)                              &
   490: ||                      &   * xyr_Press(i,j,0) / ( GasRDry * xyr_VirTemp(i,j,0) ) &
   491: ||                      &   * min( max( xy_SurfVelAbs(i,j), VelMinForTemp ), VelMaxForTemp )
   492: |*-----             end do
   493: W------           end do
   494:                 else
   495:                   ! Set meaningless value.
   496: W*===== A         xy_SurfTempTransCoef = 0.0_DP
   497:                 end if
   498:             
   499:                 if ( .not. FlagFixMassFluxAtLB ) then
   500: W------>          do i = 0, imax-1
   501: |*----->            do j = 1, jmax
   502: ||          !!$          xy_SurfQVapTransCoef(i,j) =                                            &
   503: ||          !!$            &   xy_SurfQVapBulkCoef(i,j)                                         &
   504: ||          !!$            &   * xyr_Press(i,j,0) / ( GasRDry * xyr_Temp(i,j,0) )               &
   505: ||          !!$            &   * min( max( xy_SurfVelAbs(i,j), VelMinForQVap ), VelMaxForQVap )
   506: ||      A             xy_SurfQVapTransCoef(i,j) =                                            &
   507: ||                      &   xy_SurfQVapBulkCoef(i,j)                                         &
   508: ||                      &   * xyr_Press(i,j,0) / ( GasRDry * xyr_VirTemp(i,j,0) )            &
   509: ||                      &   * min( max( xy_SurfVelAbs(i,j), VelMinForQVap ), VelMaxForQVap )
   510: |*-----             end do
   511: W------           end do
   512:                 else
   513:                   ! Set meaningless value.
   514: W*===== A         xy_SurfQVapTransCoef = 0.0_DP
   515:                 end if
   516:             
   517:                 ! 飽和比湿の計算
   518:                 ! Calculate saturated specific humidity
   519:                 !
   520:             !!$    xy_SurfQVapSat = xy_CalcQVapSat( xy_SurfTemp, xyr_Press(:,:,0) )
   521:                 xy_SurfQVapSatOnLiq = xy_CalcQVapSatOnLiq( xy_SurfTemp, xyr_Press(:,:,0) )
   522:                 xy_SurfQVapSatOnSol = xy_CalcQVapSatOnSol( xy_SurfTemp, xyr_Press(:,:,0) )
   523: *V----->A       xy_SurfQVapSat = &
   524: ||                &   ( 1.0_DP - xy_SnowFrac ) * xy_SurfQVapSatOnLiq &
   525: ||                & + xy_SnowFrac              * xy_SurfQVapSatOnSol
   526: ||          
   527: ||          
   528: ||              ! 地表面フラックスの計算
   529: ||              ! Calculate fluxes on flux
   530: ||              !
   531: ||              !   Momentum
   532: ||              !
   533: ||      A       xy_MomFluxXSurf = - xy_SurfVelTransCoef * xyz_U(:,:,1)
   534: *V----- A       xy_MomFluxYSurf = - xy_SurfVelTransCoef * xyz_V(:,:,1)
   535:             
   536:                 !   Heat
   537:                 !
   538:                 if ( .not. FlagFixHeatFluxAtLB ) then
   539: +V===== A         xy_HeatFluxSurf = - CpDry * xyr_Exner(:,:,0) * xy_SurfTempTransCoef &
   540:                     &                   * (   xyz_Temp(:,:,1) / xyz_Exner(:,:,1) &
   541:                     &                       - xy_SurfTemp     / xyr_Exner(:,:,0) )
   542:                 else
   543: W*=====           xy_HeatFluxSurf = HeatFluxAtLB
   544:                 end if
   545:             
   546:                 !   Mass
   547:                 !
   548:                 if ( .not. FlagFixMassFluxAtLB ) then
   549: +V===== A         xyf_QMixFluxSurf(:,:,IndexH2OVap) =                      &
   550:                     & - xy_SurfHumidCoef * xy_SurfQVapTransCoef(:,:)       &
   551:                     & * ( xyzf_QMix(:,:,1,IndexH2OVap) - xy_SurfQVapSat )
   552:                 else
   553: W*=====           xyf_QMixFluxSurf(:,:,IndexH2OVap) = MassFluxAtLB
   554:                 end if
   555:                 !
   556: W**====         xyf_QMixFluxSurf(:,:,1:IndexH2OVap-1)     = 0.0_DP
   557: W**====         xyf_QMixFluxSurf(:,:,IndexH2OVap+1:ncmax) = 0.0_DP
   558:             
   559:                 ! Surface flux of constituents except for water vapor is zero.
   560:             !!$    write( 6, * ) "MEMO: Surface flux of constituents except for water vapor is zero. (YOT, 2009/08/14)"
   561:             
   562:             
   563:                 ! フラックスの計算
   564:                 ! Calculate fluxes
   565:                 !
   566: *W----->A       xy_MomFluxX = xy_MomFluxXSurf
   567: ||      A       xy_MomFluxY = xy_MomFluxYSurf
   568: *W----- A       xy_HeatFlux = xy_HeatFluxSurf
   569: W------>        do n = 1, ncmax
   570: |**==== A         xyf_QMixFlux(:,:,n) = xyf_QMixFluxSurf(:,:,n)
   571: W------         end do
   572:             
   573:                 ! ヒストリデータ出力
   574:                 ! History data output
   575:                 !
   576:                 call HistoryAutoPut( TimeN, 'BulkCoefMom' , xy_SurfVelBulkCoef   )
   577:                 call HistoryAutoPut( TimeN, 'BulkCoefHeat', xy_SurfTempBulkCoef  )
   578:             
   579:                 ! 計算時間計測一時停止
   580:                 ! Pause measurement of computation time
   581:                 !
   582:                 call TimesetClockStop( module_name )
   583:             
   584:               end subroutine SurfaceFlux
   585:             
   586:               !--------------------------------------------------------------------------------------
   587:             
   588:               subroutine BulkCoef( &
   589:                 & IDBulkCoefMethod, &       ! (in)
   590:                 & xy_SurfRoughLengthMom ,  & ! (in)
   591:                 & xy_SurfRoughLengthHeat,  & ! (in)
   592:                 & xy_SurfHeight,          & ! (in)
   593:                 & xyz_Height,             & ! (in)
   594:                 & xy_U, xy_V,                                   & ! (in)
   595:                 & xy_SurfVirTemp, xy_VirTemp, xy_SurfExner, xy_Exner, & ! (in)
   596:                 & xy_SurfVelBulkCoef,     & ! (out)
   597:                 & xy_SurfTempBulkCoef,    & ! (out)
   598:                 & xy_SurfQVapBulkCoef,    & ! (out)
   599:                 & xy_BetaW,               & ! (out)
   600:                 & xy_SurfMOLength         & ! (out)
   601:                 & )
   602:                 !
   603:                 ! バルク係数を算出します.
   604:                 !
   605:                 ! Bulk coefficients are calculated.
   606:                 !
   607:             
   608:                 ! モジュール引用 ; USE statements
   609:                 !
   610:             
   611:                 ! ヒストリデータ出力
   612:                 ! History data output
   613:                 !
   614:                 use gtool_historyauto, only: HistoryAutoPut
   615:             
   616:                 ! 時刻管理
   617:                 ! Time control
   618:                 !
   619:                 use timeset, only: &
   620:                   & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $. 
   621:             
   622:                 ! 物理定数設定
   623:                 ! Physical constants settings
   624:                 !
   625:                 use constants, only: &
   626:                   & Grav, &               ! $ g $ [m s-2]. 
   627:                                           ! 重力加速度. 
   628:                                           ! Gravitational acceleration
   629:                   & FKarm                 ! $ k $ .
   630:                                           ! カルマン定数. 
   631:                                           ! Karman constant
   632:             
   633:                 ! 宣言文 ; Declaration statements
   634:                 !
   635:             
   636:                 integer , intent(in):: IDBulkCoefMethod
   637:                                           !
   638:                                           !
   639:                 real(DP), intent(in):: xy_SurfRoughLengthMom (0:imax-1, 1:jmax)
   640:                                           ! 地表粗度長
   641:                                           ! Surface rough length for momentum
   642:                 real(DP), intent(in):: xy_SurfRoughLengthHeat(0:imax-1, 1:jmax)
   643:                                           ! 地表粗度長
   644:                                           ! Surface rough length for heat
   645:                 real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
   646:                                           ! $ z_s $ . 地表面高度. 
   647:                                           ! Surface height. 
   648:                 real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   649:                                           ! 高度. 
   650:                                           ! Height
   651:                 real(DP), intent(in):: xy_U (0:imax-1, 1:jmax)
   652:                                           !
   653:                                           ! Eastward wind velocity at lowest level
   654:                 real(DP), intent(in):: xy_V (0:imax-1, 1:jmax)
   655:                                           !
   656:                                           ! Northward wind velocity at lowest level
   657:                 real(DP), intent(in):: xy_SurfVirTemp (0:imax-1, 1:jmax)
   658:                                           !
   659:                                           ! Surface virtual temperature
   660:                 real(DP), intent(in):: xy_SurfExner(0:imax-1, 1:jmax)
   661:                                           !
   662:                                           ! Exner function at the surface
   663:                 real(DP), intent(in):: xy_VirTemp     (0:imax-1, 1:jmax)
   664:                                           !
   665:                                           ! Virtual temperature at lowest layer
   666:                 real(DP), intent(in):: xy_Exner    (0:imax-1, 1:jmax)
   667:                                           !
   668:                                           ! Exner function at lowest layer
   669:                 real(DP), intent(out):: xy_SurfVelBulkCoef (0:imax-1, 1:jmax)
   670:                                           ! バルク係数：運動量. 
   671:                                           ! Bulk coefficient: temperature
   672:                 real(DP), intent(out):: xy_SurfTempBulkCoef (0:imax-1, 1:jmax)
   673:                                           ! バルク係数：温度. 
   674:                                           ! Bulk coefficient: temperature
   675:                 real(DP), intent(out):: xy_SurfQVapBulkCoef (0:imax-1, 1:jmax)
   676:                                           ! バルク係数：比湿. 
   677:                                           ! Bulk coefficient: specific humidity
   678:                 real(DP), intent(out):: xy_BetaW   (0:imax-1, 1:jmax)
   679:                                           ! 
   680:                                           ! "vertical velocity" (B94)
   681:                 real(DP), intent(out):: xy_SurfMOLength(0:imax-1, 1:jmax)
   682:                                           !
   683:                                           ! Monin-Obukov length
   684:             
   685:                 ! 作業変数
   686:                 ! Work variables
   687:                 !
   688:                 real(DP):: xy_SurfBulkRiNum (0:imax-1, 1:jmax)
   689:                                           ! バルク $ R_i $ 数. 
   690:                                           ! Bulk $ R_i $ number
   691:                 real(DP):: xy_SurfVelAbs (0:imax-1, 1:jmax)
   692:                                           ! 風速絶対値. 
   693:                                           ! Absolute velocity
   694:                 real(DP) :: xy_SurfBulkCoefMomInNeutCond    (0:imax-1, 1:jmax)
   695:                 real(DP) :: xy_SurfBulkCoefHeatInNeutCond   (0:imax-1, 1:jmax)
   696:             
   697:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   698:                                           ! Work variables for DO loop in longitude
   699:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   700:                                           ! Work variables for DO loop in latitude
   701:             
   702:                 ! 実行文 ; Executable statement
   703:                 !
   704:             
   705:                 if ( FlagConstBulkCoef ) then
   706:             
   707:                   ! Use of constant bulk coefficient
   708:                   !
   709:             
   710: *V----->A         xy_SurfVelBulkCoef  = ConstBulkCoef
   711: ||      A         xy_SurfTempBulkCoef = ConstBulkCoef
   712: ||      A         xy_SurfQVapBulkCoef = ConstBulkCoef
   713: ||          
   714: ||      A         xy_BetaW = 0.0_DP
   715: ||          
   716: *V----- A         xy_SurfBulkRiNum = 0.0_DP
   717:             
   718:                 else
   719:             
   720:                   select case ( IDBulkCoefMethod )
   721:                   case ( IDBulkCoefMethodL82 )
   722:             
   723:                     ! Parameterization by Louis et al. (1982)
   724:                     !
   725:             
   726:                     ! 中立バルク係数の計算
   727:                     ! Calculate bulk coefficient in neutral condition
   728:                     !
   729: *W----->A           xy_SurfBulkCoefMomInNeutCond  =                     &
   730: ||                    & ( FKarm                                         &
   731: ||                    & / log (   ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthMom ) &
   732: ||                    &         / xy_SurfRoughLengthMom  ) )**2
   733: *W----- A           xy_SurfBulkCoefHeatInNeutCond  =                    &
   734:                       &   ( FKarm                                       &
   735:                       & / log (   ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthMom ) &
   736:                       &         / xy_SurfRoughLengthMom  ) )            &
   737:                       & * ( FKarm                                       &
   738:                       & / log (   ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthHeat ) &
   739:                       &         / xy_SurfRoughLengthHeat ) )
   740:             
   741:                     if ( FlagUseOfBulkCoefInNeutralCond ) then
   742:             
   743:                       ! 中立条件でのバルク係数の設定
   744:                       ! Set bulk coefficient in neutral condition
   745:                       !
   746:             
   747: *V----->A             xy_SurfVelBulkCoef  = xy_SurfBulkCoefMomInNeutCond
   748: ||      A             xy_SurfTempBulkCoef = xy_SurfBulkCoefHeatInNeutCond
   749: ||          
   750: ||      A             xy_SurfQVapBulkCoef = xy_SurfTempBulkCoef
   751: ||          
   752: *V----- A             xy_SurfBulkRiNum = 0.0_DP
   753:             
   754:                     else
   755:             
   756:                       ! バルク $ R_i $ 数算出
   757:                       ! Calculate bulk $ R_i $
   758:                       !
   759: *W----->A             xy_SurfVelAbs = sqrt ( xy_U**2 + xy_V**2 )
   760: *W----- A             xy_SurfBulkRiNum =                                 &
   761:                         &   Grav / ( xy_SurfVirTemp / xy_SurfExner )     &
   762:                         &   * (   xy_VirTemp     / xy_Exner              &
   763:                         &       - xy_SurfVirTemp / xy_SurfExner )        &
   764:                         &   / max( xy_SurfVelAbs, VelMinForRi )**2       &
   765:                         &   * ( xyz_Height(:,:,1) - xy_SurfHeight )
   766:             
   767:                       ! 非中立条件でのバルク係数の計算
   768:                       ! Calculate bulk coefficients in non-neutral condition
   769:                       !
   770:             
   771:                       call BulkCoefL82( &
   772:                         & xy_SurfBulkRiNum, &       ! (in)
   773:                         & xy_SurfRoughLengthMom ,  & ! (in)
   774:                         & xy_SurfRoughLengthHeat,  & ! (in)
   775:                         & xy_SurfHeight,          & ! (in)
   776:                         & xyz_Height,             & ! (in)
   777:                         & xy_SurfBulkCoefMomInNeutCond,  & ! (in)
   778:                         & xy_SurfBulkCoefHeatInNeutCond, & ! (in)
   779:                         & xy_SurfVelBulkCoef,     & ! (out)
   780:                         & xy_SurfTempBulkCoef,    & ! (out)
   781:                         & xy_SurfQVapBulkCoef,    & ! (out)
   782:                         & xy_SurfMOLength         & ! (out)
   783:                         & )
   784:             
   785:                     end if
   786:             
   787: +V===== A           xy_BetaW = 0.0_DP
   788:             
   789:                   case ( IDBulkCoefMethodBH91B94 )
   790:             
   791:                     ! Parameterization by Beljaars and Holtslag (1991), Beljaars (1994)
   792:                     !
   793:             
   794:                     call BulkCoefBH91B94( &
   795:                       & xy_SurfRoughLengthMom , & ! (in)
   796:                       & xy_SurfRoughLengthHeat, & ! (in)
   797:                       & xy_SurfHeight,          & ! (in)
   798:                       & xyz_Height,             & ! (in)
   799:                       & xy_U, xy_V,                                   & ! (in)
   800:                       & xy_SurfVirTemp, xy_VirTemp, xy_SurfExner, xy_Exner, & ! (in)
   801:                       & xy_SurfVelBulkCoef,     & ! (out)
   802:                       & xy_SurfTempBulkCoef,    & ! (out)
   803:                       & xy_SurfQVapBulkCoef,    & ! (out)
   804:                       & xy_BetaW,               & ! (out)
   805:                       & xy_SurfBulkRiNum,       & ! (out)
   806:                       & xy_SurfMOLength         & ! (out)
   807:                       & )
   808:             
   809:                   end select
   810:             
   811:                 end if
   812:             
   813:             
   814:                 ! 最大/最小 判定
   815:                 ! Measure maximum/minimum
   816:                 !
   817: W------>        do i = 0, imax-1
   818: |*----->          do j = 1, jmax
   819: ||          
   820: ||      A           xy_SurfVelBulkCoef(i,j)  = &
   821: ||                    & max( min( xy_SurfVelBulkCoef(i,j), VelBulkCoefMax ), &
   822: ||                    &      VelBulkCoefMin )
   823: ||          
   824: ||      A           xy_SurfTempBulkCoef(i,j) = &
   825: ||                    & max( min( xy_SurfTempBulkCoef(i,j), TempBulkCoefMax ), &
   826: ||                    &      TempBulkCoefMin )
   827: ||          
   828: ||      A           xy_SurfQVapBulkCoef(i,j) = &
   829: ||                    & max( min( xy_SurfQVapBulkCoef(i,j), QVapBulkCoefMax ), &
   830: ||                    &      QVapBulkCoefMin )
   831: ||          
   832: |*-----           end do
   833: W------         end do
   834:             
   835:                 ! ヒストリデータ出力
   836:                 ! History data output
   837:                 !
   838:                 call HistoryAutoPut( TimeN, 'SfcBulkRi', xy_SurfBulkRiNum )
   839:             
   840:             
   841:               end subroutine BulkCoef
   842:             
   843:               !--------------------------------------------------------------------------------------
   844:             
   845:               subroutine BulkCoefL82( &
   846:                 & xy_SurfBulkRiNum, &       ! (in)
   847:                 & xy_SurfRoughLengthMom ,  & ! (in)
   848:                 & xy_SurfRoughLengthHeat,  & ! (in)
   849:                 & xy_SurfHeight,          & ! (in)
   850:                 & xyz_Height,             & ! (in)
   851:                 & xy_SurfBulkCoefMomInNeutCond, & ! (in)
   852:                 & xy_SurfBulkCoefHeatInNeutCond, & ! (in)
   853:                 & xy_SurfVelBulkCoef,     & ! (out)
   854:                 & xy_SurfTempBulkCoef,    & ! (out)
   855:                 & xy_SurfQVapBulkCoef,    & ! (out)
   856:                 & xy_SurfMOLength         & ! (out)
   857:                 & )
   858:                 !
   859:                 ! バルク係数を算出します.
   860:                 !
   861:                 ! Bulk coefficients are calculated.
   862:                 !
   863:             
   864:                 ! モジュール引用 ; USE statements
   865:                 !
   866:                 ! 物理定数設定
   867:                 ! Physical constants settings
   868:                 !
   869:                 use constants, only: &
   870:                   & FKarm                 ! $ k $ .
   871:                                           ! カルマン定数. 
   872:                                           ! Karman constant
   873:             
   874:                 ! 宣言文 ; Declaration statements
   875:                 !
   876:             
   877:                 real(DP), intent(in):: xy_SurfBulkRiNum (0:imax-1, 1:jmax)
   878:                                           ! バルク $ R_i $ 数. 
   879:                                           ! Bulk $ R_i $ number
   880:                 real(DP), intent(in):: xy_SurfRoughLengthMom (0:imax-1, 1:jmax)
   881:                                           ! 地表粗度長
   882:                                           ! Surface rough length for momentum
   883:                 real(DP), intent(in):: xy_SurfRoughLengthHeat(0:imax-1, 1:jmax)
   884:                                           ! 地表粗度長
   885:                                           ! Surface rough length for heat
   886:                 real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
   887:                                           ! $ z_s $ . 地表面高度. 
   888:                                           ! Surface height. 
   889:                 real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   890:                                           ! 高度. 
   891:                                           ! Height
   892:                 real(DP), intent(in):: xy_SurfBulkCoefMomInNeutCond (0:imax-1, 1:jmax)
   893:                                           !
   894:                                           !
   895:                 real(DP), intent(in):: xy_SurfBulkCoefHeatInNeutCond(0:imax-1, 1:jmax)
   896:                                           !
   897:                                           !
   898:                 real(DP), intent(out):: xy_SurfVelBulkCoef (0:imax-1, 1:jmax)
   899:                                           ! バルク係数：運動量. 
   900:                                           ! Bulk coefficient: temperature
   901:                 real(DP), intent(out):: xy_SurfTempBulkCoef (0:imax-1, 1:jmax)
   902:                                           ! バルク係数：温度. 
   903:                                           ! Bulk coefficient: temperature
   904:                 real(DP), intent(out):: xy_SurfQVapBulkCoef (0:imax-1, 1:jmax)
   905:                                           ! バルク係数：比湿. 
   906:                                           ! Bulk coefficient: specific humidity
   907:                 real(DP), intent(out):: xy_SurfMOLength(0:imax-1, 1:jmax)
   908:             
   909:                 ! 作業変数
   910:                 ! Work variables
   911:                 !
   912:                 real(DP) :: SurfBulkRiNum
   913:                 real(DP) :: xy_MOLength(0:imax-1, 1:jmax)
   914:             
   915:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   916:                                           ! Work variables for DO loop in longitude
   917:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   918:                                           ! Work variables for DO loop in latitude
   919:             
   920:                 ! 実行文 ; Executable statement
   921:                 !
   922:             
   923:                 ! 非中立条件でのバルク係数の計算
   924:                 ! Calculate bulk coefficients in non-neutral condition
   925:                 !
   926:                 ! Parameterization by Louis et al. (1982)
   927:                 !
   928: W------>        do j = 1, jmax
   929: |*----->          do i = 0, imax-1
   930: ||          
   931: ||      A           if ( xy_SurfBulkRiNum(i,j) > 0.0_DP ) then 
   932: ||          
   933: ||      A             xy_SurfVelBulkCoef(i,j) =                                       &
   934: ||                      &   xy_SurfBulkCoefMomInNeutCond(i,j)                         &
   935: ||                      &   / (   1.0_DP                                              &
   936: ||                      &       + 10.0_DP * xy_SurfBulkRiNum(i,j)                     &
   937: ||                      &         / sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) )   &
   938: ||                      &     )
   939: ||          
   940: ||      A             xy_SurfTempBulkCoef(i,j) =                                      &
   941: ||                      &   xy_SurfBulkCoefHeatInNeutCond(i,j)                        &
   942: ||                      &   / (   1.0_DP                                              &
   943: ||                      &       + 15.0_DP * xy_SurfBulkRiNum(i,j)                     &
   944: ||                      &         * sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) )   &
   945: ||                      &     )
   946: ||          
   947: ||                    xy_SurfQVapBulkCoef(i,j) = xy_SurfTempBulkCoef(i,j)
   948: ||          
   949: ||                  else
   950: ||          
   951: ||      A             xy_SurfVelBulkCoef(i,j) =                                              &
   952: ||                      &   xy_SurfBulkCoefMomInNeutCond(i,j)                                &
   953: ||                      &   * (   1.0_DP                                                     &
   954: ||                      &       - 10.0_DP * xy_SurfBulkRiNum(i,j)                            &
   955: ||                      &         / (   1.0_DP                                               &
   956: ||                      &             + 75.0_DP * xy_SurfBulkCoefMomInNeutCond(i,j)          &
   957: ||                      &               * sqrt( - ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) + xy_SurfRoughLengthMom(i,j) ) &
   958: ||                      &                         / xy_SurfRoughLengthMom(i,j)               &
   959: ||                      &                         * xy_SurfBulkRiNum(i,j)                    &
   960: ||                      &                     )                                              &
   961: ||                      &           )                                                        &
   962: ||                      &     )
   963: ||          
   964: ||      A             xy_SurfTempBulkCoef(i,j) =                                             &
   965: ||                      &   xy_SurfBulkCoefHeatInNeutCond(i,j)                               &
   966: ||                      &   * (   1.0_DP                                                     &
   967: ||                      &       - 15.0_DP * xy_SurfBulkRiNum(i,j)                            &
   968: ||                      &         / (   1.0_DP                                               &
   969: ||                      &             + 75.0_DP * xy_SurfBulkCoefHeatInNeutCond(i,j)         &
   970: ||                      &               * sqrt( - ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) + xy_SurfRoughLengthHeat(i,j) ) &
   971: ||                      &                         / xy_SurfRoughLengthHeat(i,j)              &
   972: ||                      &                         * xy_SurfBulkRiNum(i,j)                    &
   973: ||                      &                     )                                              &
   974: ||                      &           )                                                        &
   975: ||                      &     )
   976: ||          
   977: ||                    xy_SurfQVapBulkCoef(i,j) = xy_SurfTempBulkCoef(i,j)
   978: ||          
   979: ||                  end if
   980: ||          
   981: ||                  ! Calculation of Monin-Obukhov length
   982: ||      A           SurfBulkRiNum = xy_SurfBulkRiNum(i,j)
   983: ||                  if ( SurfBulkRiNum == 0.0_DP ) SurfBulkRiNum = 1.0e-10_DP
   984: ||      A           xy_MOLength(i,j) =                               &
   985: ||                    &   ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) ) &
   986: ||                    & / ( FKarm * SurfBulkRiNum )                  &
   987: ||                    & * xy_SurfVelBulkCoef(i,j)**1.5_DP / xy_SurfTempBulkCoef(i,j)
   988: ||          
   989: |*-----           end do
   990: W------         end do
   991:             
   992: W*===== A       xy_SurfMOLength = xy_MOLength
   993:             
   994:             
   995:               end subroutine BulkCoefL82
   996:             
   997:               !--------------------------------------------------------------------------------------
   998:             
   999:               subroutine BulkCoefBH91B94( &
  1000:                 & xy_SurfRoughLengthMom ,                       & ! (in)
  1001:                 & xy_SurfRoughLengthHeat,                       & ! (in)
  1002:                 & xy_SurfHeight,                                & ! (in)
  1003:                 & xyz_Height,                                   & ! (in)
  1004:                 & xy_U, xy_V,                                   & ! (in)
  1005:                 & xy_SurfVirTemp, xy_VirTemp, xy_SurfExner, xy_Exner, & ! (in)
  1006:                 & xy_SurfVelBulkCoef,                           & ! (out)
  1007:                 & xy_SurfTempBulkCoef,                          & ! (out)
  1008:                 & xy_SurfQVapBulkCoef,                          & ! (out)
  1009:                 & xy_BetaW,                                     & ! (out)
  1010:                 & xy_SurfBulkRiNum,                             & ! (out)
  1011:                 & xy_SurfMOLength                               & ! (out)
  1012:                 & )
  1013:                 !
  1014:                 ! バルク係数を算出します.
  1015:                 !
  1016:                 ! Bulk coefficients are calculated.
  1017:                 !
  1018:             
  1019:                 ! モジュール引用 ; USE statements
  1020:                 !
  1021:             
  1022:                 ! ヒストリデータ出力
  1023:                 ! History data output
  1024:                 !
  1025:                 use gtool_historyauto, only: HistoryAutoPut
  1026:             
  1027:             !!$    ! MPI 関連ルーチン
  1028:             !!$    ! MPI related routines
  1029:             !!$    !
  1030:             !!$    use mpi_wrapper, only : MPIWrapperChkTrue
  1031:             
  1032:                 ! 時刻管理
  1033:                 ! Time control
  1034:                 !
  1035:                 use timeset, only: &
  1036:                   & TimeN                 ! ステップ $ t $ の時刻. Time of step $ t $. 
  1037:             
  1038:                 ! 物理定数設定
  1039:                 ! Physical constants settings
  1040:                 !
  1041:                 use constants, only: &
  1042:                   & Grav, &               ! $ g $ [m s-2]. 
  1043:                                           ! 重力加速度. 
  1044:                                           ! Gravitational acceleration
  1045:                   & FKarm                 ! $ k $ .
  1046:                                           ! カルマン定数. 
  1047:                                           ! Karman constant
  1048:             
  1049:                 ! 宣言文 ; Declaration statements
  1050:                 !
  1051:             
  1052:                 real(DP), intent(in):: xy_SurfRoughLengthMom (0:imax-1, 1:jmax)
  1053:                                           ! 地表粗度長
  1054:                                           ! Surface rough length for momentum
  1055:                 real(DP), intent(in):: xy_SurfRoughLengthHeat(0:imax-1, 1:jmax)
  1056:                                           ! 地表粗度長
  1057:                                           ! Surface rough length for heat
  1058:                 real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
  1059:                                           ! $ z_s $ . 地表面高度. 
  1060:                                           ! Surface height. 
  1061:                 real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
  1062:                                           ! 高度. 
  1063:                                           ! Height
  1064:                 real(DP), intent(in):: xy_U (0:imax-1, 1:jmax)
  1065:                                           !
  1066:                                           ! Eastward wind velocity at lowest level
  1067:                 real(DP), intent(in):: xy_V (0:imax-1, 1:jmax)
  1068:                                           !
  1069:                                           ! Northward wind velocity at lowest level
  1070:                 real(DP), intent(in):: xy_SurfVirTemp (0:imax-1, 1:jmax)
  1071:                                           !
  1072:                                           ! Surface virtual temperature
  1073:                 real(DP), intent(in):: xy_SurfExner(0:imax-1, 1:jmax)
  1074:                                           !
  1075:                                           ! Exner function at the surface
  1076:                 real(DP), intent(in):: xy_VirTemp     (0:imax-1, 1:jmax)
  1077:                                           !
  1078:                                           ! Virtual temperature at lowest layer
  1079:                 real(DP), intent(in):: xy_Exner    (0:imax-1, 1:jmax)
  1080:                                           !
  1081:                                           ! Exner function at lowest layer
  1082:             
  1083:                 real(DP), intent(out):: xy_SurfVelBulkCoef (0:imax-1, 1:jmax)
  1084:                                           ! バルク係数：運動量. 
  1085:                                           ! Bulk coefficient: temperature
  1086:                 real(DP), intent(out):: xy_SurfTempBulkCoef (0:imax-1, 1:jmax)
  1087:                                           ! バルク係数：温度. 
  1088:                                           ! Bulk coefficient: temperature
  1089:                 real(DP), intent(out):: xy_SurfQVapBulkCoef (0:imax-1, 1:jmax)
  1090:                                           ! バルク係数：比湿. 
  1091:                                           ! Bulk coefficient: specific humidity
  1092:                 real(DP), intent(out):: xy_BetaW   (0:imax-1, 1:jmax)
  1093:                                           ! 
  1094:                                           ! "vertical velocity" (B94)
  1095:                 real(DP), intent(out):: xy_SurfBulkRiNum (0:imax-1, 1:jmax)
  1096:                                           ! バルク $ R_i $ 数. 
  1097:                                           ! Bulk $ R_i $ number
  1098:                 real(DP), intent(out):: xy_SurfMOLength(0:imax-1, 1:jmax)
  1099:             
  1100:                 ! 作業変数
  1101:                 ! Work variables
  1102:                 !
  1103:                 real(DP):: xy_SurfVelAbs (0:imax-1, 1:jmax)
  1104:                                           ! 風速絶対値. 
  1105:                                           ! Absolute velocity
  1106:                 real(DP) :: xy_MOLength    (0:imax-1, 1:jmax)
  1107:                 real(DP) :: xy_MOLengthSave(0:imax-1, 1:jmax)
  1108:                 real(DP) :: xy_ZetaM(0:imax-1, 1:jmax)
  1109:                 real(DP) :: xy_ZetaH(0:imax-1, 1:jmax)
  1110:                 real(DP) :: xy_PsiM1(0:imax-1, 1:jmax)
  1111:                 real(DP) :: xy_PsiH1(0:imax-1, 1:jmax)
  1112:                 real(DP) :: xy_PsiM0(0:imax-1, 1:jmax)
  1113:                 real(DP) :: xy_PsiH0(0:imax-1, 1:jmax)
  1114:                 real(DP) :: xy_FricVelByU1(0:imax-1, 1:jmax)
  1115:                 real(DP) :: SurfBulkRiNum
  1116:                 logical  :: FlagConverge
  1117:                 logical  :: xy_FlagConverge(0:imax-1, 1:jmax)
  1118:                 logical :: a_FlagReCalcLocal (1)
  1119:                 logical :: a_FlagReCalcGlobal(1)
  1120:                 integer             :: iLoop
  1121:                 integer , parameter :: nLoop = 100
  1122:                 real(DP)            :: MOLengthErr
  1123:                 real(DP), parameter :: MOLengthErrCriterion = 1.0d-5
  1124:             
  1125:                 real(DP), parameter :: Gamma = 16.0_DP
  1126:                 real(DP), parameter :: Beta  = 1.2_DP
  1127:             
  1128:                 real(DP) :: SurfPotTemp
  1129:                 real(DP) :: PotTemp
  1130:                 real(DP) :: BLHeight
  1131:                 real(DP) :: xy_BLHeight(0:imax-1, 1:jmax)
  1132:             
  1133:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
  1134:                                           ! Work variables for DO loop in longitude
  1135:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1136:                                           ! Work variables for DO loop in latitude
  1137:             
  1138:                 ! 実行文 ; Executable statement
  1139:                 !
  1140:             
  1141:                 ! Calculate bulk coefficients 
  1142:                 ! Parameterization by Beljaars and Holtslag (1991)
  1143:                 !
  1144:             
  1145:                 ! initialization
  1146: *W----->A       xy_MOLength = 1.0e10_DP
  1147: ||      A       xy_BetaW    = 0.0_DP
  1148: ||          
  1149: *W-----         xy_FlagConverge = .false.
  1150:             
  1151: +------>        loop_iteration : do iLoop = 1, nLoop
  1152: |           
  1153: |W*==== A         xy_MOLengthSave = xy_MOLength
  1154: |           
  1155: |                 ! Calculation of Psi_{M,H}
  1156: |                 if ( FlagUseOfBulkCoefInNeutralCond ) then
  1157: |*V---->A           xy_PsiM0 = 0.0_DP
  1158: |||     A           xy_PsiH0 = 0.0_DP
  1159: |||     A           xy_PsiM1 = 0.0_DP
  1160: |*V---- A           xy_PsiH1 = 0.0_DP
  1161: |                 else
  1162: |*W---->A           xy_ZetaM = xy_SurfRoughLengthMom  / xy_MOLength
  1163: |*W---- A           xy_ZetaH = xy_SurfRoughLengthHeat / xy_MOLength
  1164: |                   call BH91CalcPsi(       &
  1165: |                     & Gamma,              & ! (in)
  1166: |                     & xy_ZetaM, xy_ZetaH, & ! (in)
  1167: |                     & xy_PsiM0, xy_PsiH0  & ! (out)
  1168: |                     & )
  1169: |*W---->A           xy_ZetaM = ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthMom  ) / xy_MOLength
  1170: |*W---- A           xy_ZetaH = ( xyz_Height(:,:,1) - xy_SurfHeight + xy_SurfRoughLengthHeat ) / xy_MOLength
  1171: |                   call BH91CalcPsi(       &
  1172: |                     & Gamma,              & ! (in)
  1173: |                     & xy_ZetaM, xy_ZetaH, & ! (in)
  1174: |                     & xy_PsiM1, xy_PsiH1  & ! (out)
  1175: |                     & )
  1176: |                 end if
  1177: |           
  1178: |W----->          do j = 1, jmax
  1179: ||*---->            do i = 0, imax-1
  1180: |||                   if ( .not. xy_FlagConverge(i,j) ) then
  1181: |||                     ! u_* / U_1, Eq. (5)
  1182: |||     A               xy_FricVelByU1(i,j) =                             &
  1183: |||                       &   FKarm                                       &
  1184: |||                       & / (                                           &
  1185: |||                       &       log (   ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) + xy_SurfRoughLengthMom(i,j)  ) &
  1186: |||                       &             / xy_SurfRoughLengthMom(i,j)  )   &
  1187: |||                       &     - xy_PsiM1(i,j) + xy_PsiM0(i,j)           &
  1188: |||                       &   )
  1189: |||         
  1190: |||     A               xy_SurfVelBulkCoef(i,j) = xy_FricVelByU1(i,j)**2
  1191: |||                     !
  1192: |||     A               xy_SurfTempBulkCoef(i,j) =                        &
  1193: |||                       &   xy_FricVelByU1(i,j)                         &
  1194: |||                       & * FKarm                                       &
  1195: |||                       & / (                                           &
  1196: |||                       &       log (   ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) + xy_SurfRoughLengthHeat(i,j) ) &
  1197: |||                       &             / xy_SurfRoughLengthHeat(i,j) )   &
  1198: |||                       &     - xy_PsiH1(i,j) + xy_PsiH0(i,j)           &
  1199: |||                       &   )
  1200: |||                     !
  1201: |||     A               xy_SurfQVapBulkCoef(i,j) = xy_SurfTempBulkCoef(i,j)
  1202: |||                   end if
  1203: ||*----             end do
  1204: |W-----           end do
  1205: |           
  1206: |           
  1207: |                 ! Calculation of wind speed related to convection
  1208: |                 if ( FlagIncludeB94W ) then
  1209: |W----->            do j = 1, jmax
  1210: ||*---->              do i = 0, imax-1
  1211: |||                     if ( .not. xy_FlagConverge(i,j) ) then
  1212: |||     A                 if ( xy_MOLength(i,j) < 0.0_DP ) then
  1213: |||                         SurfPotTemp = xy_SurfVirTemp(i,j) / xy_SurfExner(i,j)
  1214: |||     A                   PotTemp     = xy_VirTemp    (i,j) / xy_Exner    (i,j)
  1215: |||         !!$              BLHeight =                                                      &
  1216: |||         !!$                & - xy_MOLength(i,j) / ( FKarm**2 * Beta**3 )                 &
  1217: |||         !!$                &     * (   log( - 38.5_DP * xy_MOLength(i,j)                 &
  1218: |||         !!$                &                  / ( Gamma * xy_SurfRoughLengthMom(i,j) ) ) &
  1219: |||         !!$                &         + xy_PsiM0(i,j) )**3
  1220: |||                         ! BLHeight is assumed to be constant.
  1221: |||                         BLHeight = 1000.0_DP
  1222: |||     A                   xy_BetaW(i,j) =                                                 &
  1223: |||                           & sqrt(                                                       &
  1224: |||                           &       Grav / PotTemp * ( SurfPotTemp - PotTemp )            &
  1225: |||                           &         * FKarm**2 * Beta * BLHeight                        &
  1226: |||                           &     / (                                                     &
  1227: |||                           &           (   log( - 38.5_DP * xy_MOLength(i,j)             &
  1228: |||                           &                / ( Gamma * xy_SurfRoughLengthMom (i,j) ) )  &
  1229: |||                           &             + xy_PsiM0(i,j)                                )&
  1230: |||                           &         * (   log( -  4.0_DP * xy_MOLength(i,j)             &
  1231: |||                           &                / ( Gamma * xy_SurfRoughLengthHeat(i,j) ) )  &
  1232: |||                           &             + xy_PsiH0(i,j)                                )&
  1233: |||                           &       )                                                     &
  1234: |||                           &     )
  1235: |||     A                   xy_BLHeight(i,j) = BLHeight
  1236: |||                       else
  1237: |||     A                   xy_BetaW(i,j) = 0.0_DP
  1238: |||     A                   xy_BLHeight(i,j) = 0.0_DP
  1239: |||                       end if
  1240: |||                     end if
  1241: ||*----               end do
  1242: |W-----             end do
  1243: |                 else
  1244: |W----->            do j = 1, jmax
  1245: ||*---->              do i = 0, imax-1
  1246: |||                     if ( .not. xy_FlagConverge(i,j) ) then
  1247: |||     A                 xy_BetaW(i,j) = 0.0_DP
  1248: |||                     end if
  1249: ||*----               end do
  1250: |W-----             end do
  1251: |                 end if
  1252: |           
  1253: |           
  1254: |W----->          do j = 1, jmax
  1255: ||*---->            do i = 0, imax-1
  1256: |||                   if ( .not. xy_FlagConverge(i,j) ) then
  1257: |||         
  1258: |||                     ! Calculation of bulk Richardson number
  1259: |||     A               xy_SurfVelAbs(i,j) = sqrt ( xy_U(i,j)**2 + xy_V(i,j)**2 + xy_BetaW(i,j)**2 )
  1260: |||     A               xy_SurfBulkRiNum(i,j) =                                  &
  1261: |||                       &   Grav / ( xy_SurfVirTemp(i,j) / xy_SurfExner(i,j) ) &
  1262: |||                       &   * (   xy_VirTemp(i,j)     / xy_Exner(i,j)          &
  1263: |||                       &       - xy_SurfVirTemp(i,j) / xy_SurfExner(i,j) )    &
  1264: |||                       &   / max( xy_SurfVelAbs(i,j), VelMinForRi )**2        &
  1265: |||                       &   * ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) )
  1266: |||         
  1267: |||                     ! Calculation of Monin-Obukhov length
  1268: |||                     SurfBulkRiNum = xy_SurfBulkRiNum(i,j)
  1269: |||                     if ( SurfBulkRiNum == 0.0_DP ) SurfBulkRiNum = 1.0e-10_DP
  1270: |||     A               xy_MOLength(i,j) =                               &
  1271: |||                       &   ( xyz_Height(i,j,1) - xy_SurfHeight(i,j) ) &
  1272: |||                       & / ( FKarm * SurfBulkRiNum )                  &
  1273: |||                       & * xy_SurfVelBulkCoef(i,j)**1.5_DP / xy_SurfTempBulkCoef(i,j)
  1274: |||         
  1275: |||                   end if
  1276: ||*----             end do
  1277: |W-----           end do
  1278: |           
  1279: |           
  1280: |                 ! TO BE DELETED
  1281: |           !!$      ! Check of convergence
  1282: |           !!$      FlagConverge = .true.
  1283: |           !!$      loop_check : do j = 1, jmax
  1284: |           !!$        do i = 0, imax-1
  1285: |           !!$          MOLengthErr =                                      &
  1286: |           !!$            & abs( xy_MOLength(i,j) - xy_MOLengthSave(i,j) ) &
  1287: |           !!$            &    / max( abs( xy_MOLength(i,j) ), 1.0d-10 )
  1288: |           !!$          if ( MOLengthErr > MOLengthErrCriterion ) then
  1289: |           !!$            FlagConverge = .false.
  1290: |           !!$            exit loop_check
  1291: |           !!$          end if
  1292: |           !!$        end do
  1293: |           !!$      end do loop_check
  1294: |           !!$      a_FlagReCalcLocal = ( .not. FlagConverge )
  1295: |           !!$      call MPIWrapperChkTrue(   &
  1296: |           !!$        & 1, a_FlagReCalcLocal, & ! (in)
  1297: |           !!$        & a_FlagReCalcGlobal    & ! (out)
  1298: |           !!$        & )
  1299: |           !!$      if ( .not. a_FlagReCalcGlobal(1) ) exit loop_iteration
  1300: |           
  1301: |                 ! Check of convergence
  1302: |W----->          do j = 1, jmax
  1303: ||*---->            do i = 0, imax-1
  1304: |||                   if ( .not. xy_FlagConverge(i,j) ) then
  1305: |||                     MOLengthErr =                                      &
  1306: |||                       & abs( xy_MOLength(i,j) - xy_MOLengthSave(i,j) ) &
  1307: |||                       &    / max( abs( xy_MOLength(i,j) ), 1.0e-10_DP )
  1308: |||     A               if ( MOLengthErr <= MOLengthErrCriterion ) then
  1309: |||                       xy_FlagConverge(i,j) = .true.
  1310: |||                     end if
  1311: |||                   end if
  1312: ||*----             end do
  1313: |W-----           end do
  1314: |                 FlagConverge = .true.
  1315: |+----->          loop_check : do j = 1, jmax
  1316: ||V---->            do i = 0, imax-1
  1317: |||                   if ( .not. xy_FlagConverge(i,j) ) then
  1318: |||                     FlagConverge = .false.
  1319: |||                     exit loop_check
  1320: |||                   end if
  1321: ||V----             end do
  1322: |+-----           end do loop_check
  1323: |                 if ( FlagConverge ) exit loop_iteration
  1324: |           
  1325: |           
  1326: +------         end do loop_iteration
  1327:                 if ( iLoop > nLoop ) then
  1328:                   call MessageNotify( 'E', module_name, 'Monin-Obukhov length is not convergent.' )
  1329:                 end if
  1330:             
  1331:             
  1332: W*===== A       xy_SurfMOLength = xy_MOLength
  1333:             
  1334:             
  1335:                 call HistoryAutoPut( TimeN, 'MOLength'   , xy_MOLength        )
  1336: +V===== A       call HistoryAutoPut( TimeN, 'MOLengthInv', 1.0_DP/xy_MOLength )
  1337:                 call HistoryAutoPut( TimeN, 'BetaW'      , xy_BetaW           )
  1338:                 call HistoryAutoPut( TimeN, 'BLHeight'   , xy_BLHeight        )
  1339:             
  1340:             
  1341:               end subroutine BulkCoefBH91B94
  1342:             
  1343:               !--------------------------------------------------------------------------------------
  1344:             
  1345:               subroutine BH91CalcPsi( &
  1346:                 & Gamma,              & ! (in)
  1347:                 & xy_ZetaM, xy_ZetaH, & ! (in)
  1348:                 & xy_PsiM, xy_PsiH    & ! (out)
  1349:                 & )
  1350:                 !
  1351:                 ! 
  1352:                 !
  1353:                 ! Calculation of Psi_M and Psi_H
  1354:                 !
  1355:             
  1356:                 ! モジュール引用 ; USE statements
  1357:                 !
  1358:             
  1359:                 ! 物理・数学定数設定
  1360:                 ! Physical and mathematical constants settings
  1361:                 !
  1362:                 use constants0, only: &
  1363:                   & PI
  1364:                                           ! $ \pi $ .
  1365:                                           ! 円周率.  Circular constant
  1366:             
  1367:                 ! 宣言文 ; Declaration statements
  1368:                 !
  1369:             
  1370:                 real(DP), intent(in ) :: Gamma
  1371:             
  1372:                 real(DP), intent(in ) :: xy_ZetaM(0:imax-1, 1:jmax)
  1373:                                           ! 
  1374:                                           ! zeta = z / L for momentum
  1375:                 real(DP), intent(in ) :: xy_ZetaH(0:imax-1, 1:jmax)
  1376:                                           ! 
  1377:                                           ! zeta = z / L for heat
  1378:                 real(DP), intent(out) :: xy_PsiM(0:imax-1, 1:jmax)
  1379:                                           ! 
  1380:                                           ! PsiM
  1381:                 real(DP), intent(out) :: xy_PsiH(0:imax-1, 1:jmax)
  1382:                                           ! 
  1383:                                           ! PsiH
  1384:             
  1385:                 ! 作業変数
  1386:                 ! Work variables
  1387:                 !
  1388:                 real(DP) :: ZetaM
  1389:                 real(DP) :: ZetaH
  1390:                 real(DP) :: ParamXM
  1391:                 real(DP) :: ParamXH
  1392:             
  1393:                 real(DP), parameter :: ConstA = 1.0_DP
  1394:                 real(DP), parameter :: ConstB = 0.667_DP
  1395:                 real(DP), parameter :: ConstC = 5.0_DP
  1396:                 real(DP), parameter :: ConstD = 0.35_DP
  1397:             
  1398:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
  1399:                                           ! Work variables for DO loop in longitude
  1400:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1401:                                           ! Work variables for DO loop in latitude
  1402:             
  1403:                 ! 実行文 ; Executable statement
  1404:                 !
  1405:             
  1406:                 ! Parameterization by Beljaars and Holtslag (1991)
  1407:                 !
  1408:             
  1409:             
  1410: W------>        do j = 1, jmax
  1411: |*----->          do i = 0, imax-1
  1412: ||          
  1413: ||                  ZetaM = xy_ZetaM(i,j)
  1414: ||                  ZetaH = xy_ZetaH(i,j)
  1415: ||          
  1416: ||      A           if ( ZetaM < 0.0_DP ) then
  1417: ||                    ! for unstable condition
  1418: ||          
  1419: ||      A             ParamXM = ( 1.0_DP - Gamma * ZetaM )**0.25_DP
  1420: ||      A             ParamXH = ( 1.0_DP - Gamma * ZetaH )**0.25_DP
  1421: ||          
  1422: ||                    ! Eq. (25)
  1423: ||                    xy_PsiM(i,j) =                                    &
  1424: ||                      &   log(                                        &
  1425: ||                      &          ( 1.0_DP + ParamXM    )**2           &
  1426: ||                      &        * ( 1.0_DP + ParamXM**2 )    / 8.0_DP  &
  1427: ||                      &      )                                        &
  1428: ||                      & - 2.0_DP * atan( ParamXM ) + PI / 2.0_DP
  1429: ||                    ! Eq. (26)
  1430: ||                    xy_PsiH(i,j) =                                    &
  1431: ||                      &   log(                                        &
  1432: ||                      &          ( 1.0_DP + ParamXH**2 )**2 / 4.0_DP  &
  1433: ||                      &      )
  1434: ||                  else
  1435: ||                    ! for stable condition
  1436: ||          
  1437: ||                    ! Eq. (28)
  1438: ||                    xy_PsiM(i,j) =                                                      &
  1439: ||                      & - ConstA * ZetaM                                                &
  1440: ||                      & - ConstB * ( ZetaM - ConstC / ConstD ) * exp( - ConstD * ZetaM )&
  1441: ||                      & - ConstB * ConstC / ConstD
  1442: ||                    ! Eq. (32)
  1443: ||      A             xy_PsiH(i,j) =                                                      &
  1444: ||                      & - ( 1.0_DP + 2.0_DP / 3.0_DP * ConstA * ZetaH )**1.5            &
  1445: ||                      & - ConstB * ( ZetaH - ConstC / ConstD ) * exp( - ConstD * ZetaH )&
  1446: ||                      & - ConstB * ConstC / ConstD                                      &
  1447: ||                      & + 1.0_DP
  1448: ||                  end if
  1449: ||          
  1450: |*----- A         end do
  1451: W------         end do
  1452:             
  1453:             
  1454:               end subroutine BH91CalcPsi
  1455:             
  1456:               !--------------------------------------------------------------------------------------
  1457:             
  1458:               subroutine SurfaceFluxOutput(                                &
  1459:                 & xy_SnowFrac,                                             & ! (in)
  1460:                 & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
  1461:                 & xy_SurfH2OVapFluxA, xy_SurfLatentHeatFluxA,              & ! (in)
  1462:                 & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt,           & ! (in)
  1463:                 & xy_SurfTemp, xy_DSurfTempDt,                             & ! (in)
  1464:                 & xyr_Press, xyz_Exner, xyr_Exner, xy_SurfHumidCoef,       & ! (in)
  1465:                 & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
  1466:                 & xy_SurfQVapTransCoef                                     & ! (in)
  1467:                 & )
  1468:                 !
  1469:                 ! フラックス (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux). 
  1470:                 ! について, その他の引数を用いて補正し, 出力を行う. 
  1471:                 !
  1472:                 ! Fluxes (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux) are
  1473:                 ! corrected by using other arguments, and the corrected values are output.
  1474:                 !
  1475:             
  1476:                 ! モジュール引用 ; USE statements
  1477:                 !
  1478:             
  1479:                 ! 物理定数設定
  1480:                 ! Physical constant settings
  1481:                 !
  1482:                 use constants, only: &
  1483:                   & Grav, &               ! $ g $ [m s-2]. 
  1484:                                           ! 重力加速度. 
  1485:                                           ! Gravitational acceleration
  1486:                   & GasRDry, &
  1487:                                           ! $ R $ [J kg-1 K-1]. 
  1488:                                           ! 乾燥大気の気体定数. 
  1489:                                           ! Gas constant of air
  1490:                   & CpDry, &
  1491:                                           ! $ C_p $ [J kg-1 K-1]. 
  1492:                                           ! 乾燥大気の定圧比熱. 
  1493:                                           ! Specific heat of air at constant pressure
  1494:                   & LatentHeat
  1495:                                           ! $ L $ [J kg-1] . 
  1496:                                           ! 凝結の潜熱. 
  1497:                                           ! Latent heat of condensation
  1498:             
  1499:                 ! 飽和比湿の算出
  1500:                 ! Evaluation of saturation specific humidity
  1501:                 !
  1502:                 use saturate, only: &
  1503:                   & xy_CalcQVapSatOnLiq,       &
  1504:                   & xy_CalcQVapSatOnSol,       &
  1505:                   & xy_CalcDQVapSatDTempOnLiq, &
  1506:                   & xy_CalcDQVapSatDTempOnSol
  1507:             
  1508:                 ! 時刻管理
  1509:                 ! Time control
  1510:                 !
  1511:                 use timeset, only: &
  1512:                   & DelTime, &            ! $ \Delta t $ [s]
  1513:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
  1514:                   & TimesetClockStart, TimesetClockStop
  1515:             
  1516:                 ! ヒストリデータ出力
  1517:                 ! History data output
  1518:                 !
  1519:                 use gtool_historyauto, only: HistoryAutoPut
  1520:             
  1521:                 ! 宣言文 ; Declaration statements
  1522:                 !
  1523:                 implicit none
  1524:                 real(DP), intent(in):: xy_SnowFrac(0:imax-1, 1:jmax)
  1525:                                           ! 
  1526:                                           ! Snow fraction
  1527:                 real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
  1528:                                           ! 東西方向運動量フラックス. 
  1529:                                           ! Eastward momentum flux
  1530:                 real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
  1531:                                           ! 南北方向運動量フラックス. 
  1532:                                           ! Northward momentum flux
  1533:                 real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
  1534:                                           ! 熱フラックス. 
  1535:                                           ! Heat flux
  1536:                 real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
  1537:                                           ! 比湿フラックス. 
  1538:                                           ! Specific humidity flux
  1539:                 real(DP), intent(in):: xy_SurfH2OVapFluxA    (0:imax-1, 1:jmax)
  1540:                                           ! 惑星表面水蒸気フラックス.
  1541:                                           ! Water vapor flux at the surface
  1542:                 real(DP), intent(in):: xy_SurfLatentHeatFluxA(0:imax-1, 1:jmax)
  1543:                                           ! 惑星表面潜熱フラックス.
  1544:                                           ! Latent heat flux at the surface
  1545:                 real(DP), intent(in):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
  1546:                                           ! $ \DP{u}{t} $ . 東西風速時間変化率. 
  1547:                                           ! Eastward wind tendency
  1548:                 real(DP), intent(in):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
  1549:                                           ! $ \DP{v}{t} $ . 南北風速時間変化率. 
  1550:                                           ! Northward wind tendency
  1551:                 real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
  1552:                                           ! $ \DP{T}{t} $ . 温度時間変化率. 
  1553:                                           ! Temperature tendency
  1554:                 real(DP), intent(in):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1555:                                           ! $ \DP{q}{t} $ . 比湿時間変化率. 
  1556:                                           ! Specific humidity tendency
  1557:                 real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
  1558:                                           ! 地表面温度. 
  1559:                                           ! Surface temperature
  1560:                 real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
  1561:                                           ! 地表面温度時間変化率. 
  1562:                                           ! Surface temperature tendency
  1563:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
  1564:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
  1565:                                           ! Air pressure (half level)
  1566:                 real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
  1567:                                           ! Exner 関数 (整数レベル). 
  1568:                                           ! Exner function (full level)
  1569:                 real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
  1570:                                           ! Exner 関数 (半整数レベル). 
  1571:                                           ! Exner function (half level)
  1572:                 real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
  1573:                                           ! 地表湿潤度. 
  1574:                                           ! Surface humidity coefficient
  1575:                 real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
  1576:                                           ! 輸送係数：運動量. 
  1577:                                           ! Diffusion coefficient: velocity
  1578:                 real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
  1579:                                           ! 輸送係数：温度. 
  1580:                                           ! Transfer coefficient: temperature
  1581:                 real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
  1582:                                           ! 輸送係数：水蒸気
  1583:                                           ! Transfer coefficient: water vapor
  1584:             
  1585:                 ! 出力のための作業変数
  1586:                 ! Work variables for output
  1587:                 !
  1588:                 real(DP):: xyr_MomFluxXCor (0:imax-1, 1:jmax, 0:kmax)
  1589:                                           ! 東西方向運動量フラックス. 
  1590:                                           ! Eastward momentum flux
  1591:                 real(DP):: xyr_MomFluxYCor (0:imax-1, 1:jmax, 0:kmax)
  1592:                                           ! 南北方向運動量フラックス. 
  1593:                                           ! Northward momentum flux
  1594:                 real(DP):: xyr_HeatFluxCor (0:imax-1, 1:jmax, 0:kmax)
  1595:                                           ! 熱フラックス. 
  1596:                                           ! Heat flux
  1597:                 real(DP):: xyrf_QMixFluxCor(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
  1598:                                           ! 比湿フラックス. 
  1599:                                           ! Specific humidity flux
  1600:                 real(DP):: xyr_LatentHeatFluxCor(0:imax-1, 1:jmax, 0:kmax)
  1601:                                           ! 表面潜熱フラックス.
  1602:                                           ! Latent heat flux
  1603:                 real(DP):: xy_SurfQVapSatOnLiq (0:imax-1, 1:jmax)
  1604:                                           ! 地表飽和比湿. 
  1605:                                           ! Saturated specific humidity on surface
  1606:                 real(DP):: xy_SurfQVapSatOnSol (0:imax-1, 1:jmax)
  1607:                                           ! 地表飽和比湿. 
  1608:                                           ! Saturated specific humidity on surface
  1609:                 real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
  1610:                                           ! 地表飽和比湿. 
  1611:                                           ! Saturated specific humidity on surface
  1612:                 real(DP):: xy_SurfDQVapSatDTempOnLiq (0:imax-1, 1:jmax)
  1613:                                           ! 地表飽和比湿変化. 
  1614:                                           ! Saturated specific humidity tendency on surface
  1615:                 real(DP):: xy_SurfDQVapSatDTempOnSol (0:imax-1, 1:jmax)
  1616:                                           ! 地表飽和比湿変化. 
  1617:                                           ! Saturated specific humidity tendency on surface
  1618:                 real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
  1619:                                           ! 地表飽和比湿変化. 
  1620:                                           ! Saturated specific humidity tendency on surface
  1621:             
  1622:                 ! 作業変数
  1623:                 ! Work variables
  1624:                 !
  1625:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
  1626:                                           ! Work variables for DO loop in longitude
  1627:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1628:                                           ! Work variables for DO loop in latitude
  1629:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
  1630:                                           ! Work variables for DO loop in dimension of constituents
  1631:             
  1632:             
  1633:                 ! 実行文 ; Executable statement
  1634:                 !
  1635:             
  1636:                 ! 初期化確認
  1637:                 ! Initialization check
  1638:                 !
  1639:                 if ( .not. surface_flux_bulk_inited ) then
  1640:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1641:                 end if
  1642:             
  1643:             
  1644:                 ! 計算時間計測開始
  1645:                 ! Start measurement of computation time
  1646:                 !
  1647:                 call TimesetClockStart( module_name )
  1648:             
  1649:             
  1650:                 ! 飽和比湿の計算
  1651:                 ! Calculate saturated specific humidity
  1652:                 !
  1653:                 xy_SurfQVapSatOnLiq  = &
  1654:                   & xy_CalcQVapSatOnLiq( xy_SurfTemp, xyr_Press(:,:,0) )
  1655:                 xy_SurfQVapSatOnSol  = &
  1656:                   & xy_CalcQVapSatOnSol( xy_SurfTemp, xyr_Press(:,:,0) )
  1657: *V----->A       xy_SurfQVapSat       = &
  1658: ||                &   ( 1.0_DP - xy_SnowFrac ) * xy_SurfQVapSatOnLiq &
  1659: ||                & + xy_SnowFrac              * xy_SurfQVapSatOnSol
  1660: ||              xy_SurfDQVapSatDTempOnLiq = &
  1661: ||                & xy_CalcDQVapSatDTempOnLiq( xy_SurfTemp, xy_SurfQVapSatOnLiq )
  1662: ||              xy_SurfDQVapSatDTempOnSol = &
  1663: ||                & xy_CalcDQVapSatDTempOnSol( xy_SurfTemp, xy_SurfQVapSatOnSol )
  1664: *V-----         xy_SurfDQVapSatDTemp = &
  1665:                   &   ( 1.0_DP - xy_SnowFrac ) * xy_SurfDQVapSatDTempOnLiq &
  1666:                   & + xy_SnowFrac              * xy_SurfDQVapSatDTempOnSol
  1667:             
  1668:                 ! Output of fluxes at t
  1669:                 !
  1670:             
  1671:                 ! 風速, 温度, 比湿フラックス補正
  1672:                 ! Correct fluxes of wind, temperature, specific humidity
  1673:                 !
  1674: W------>        do j = 1, jmax
  1675: |*----->          do i = 0, imax-1
  1676: ||      A           xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
  1677: ||                    & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * DelTime
  1678: ||          
  1679: ||      A           xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
  1680: ||                    & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * DelTime
  1681: ||          
  1682: ||      A           xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
  1683: ||                    & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
  1684: ||                    &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
  1685: ||                    &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
  1686: ||                    &   * DelTime
  1687: |*-----           end do
  1688: W------         end do
  1689:                 n = IndexH2OVap
  1690: W------>        do j = 1, jmax
  1691: |*----->          do i = 0, imax-1
  1692: ||      A           xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
  1693: ||                    & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
  1694: ||                    &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
  1695: ||                    &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * DelTime
  1696: |*-----           end do
  1697: W------         end do
  1698: +------>        do n = 1, IndexH2OVap-1
  1699: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
  1700: +------         end do
  1701: +------>        do n = IndexH2OVap+1, ncmax
  1702: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
  1703: +------         end do
  1704:                 n = IndexH2OVap
  1705: W------>        do j = 1, jmax
  1706: |*----->          do i = 0, imax-1
  1707: ||          !!$        xyr_LatentHeatFluxCor( i,j,0 ) = xy_SurfLatentHeatFlux( i,j )             &
  1708: ||          !!$          & - LatentHeat * xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )  &
  1709: ||          !!$          &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
  1710: ||          !!$          &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * DelTime
  1711: ||      A           xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
  1712: |*-----           end do
  1713: W------         end do
  1714:             
  1715:             
  1716:                 ! ヒストリデータ出力
  1717:                 ! History data output
  1718:                 !
  1719:                 call HistoryAutoPut( TimeN, 'TauX'          , xyr_MomFluxXCor (:,:,0) )
  1720:                 call HistoryAutoPut( TimeN, 'TauY'          , xyr_MomFluxYCor (:,:,0) )
  1721:                 call HistoryAutoPut( TimeN, 'Sens'          , xyr_HeatFluxCor (:,:,0) )
  1722:                 call HistoryAutoPut( TimeN, 'SurfH2OVapFlux', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
  1723:                 call HistoryAutoPut( TimeN, 'Evap'          , xyr_LatentHeatFluxCor(:,:,0) )
  1724:             
  1725:             
  1726:                 ! Output of fluxes at t - \Delta t
  1727:                 !
  1728:             
  1729:                 ! 風速, 温度, 比湿フラックス補正
  1730:                 ! Correct fluxes of wind, temperature, specific humidity
  1731:                 !
  1732: W------>        do j = 1, jmax
  1733: |*----->          do i = 0, imax-1
  1734: ||      A           xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 )
  1735: ||      A           xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 )
  1736: ||      A           xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )
  1737: |*-----           end do
  1738: W------         end do
  1739:                 n = IndexH2OVap
  1740: W------>        do j = 1, jmax
  1741: |*----->          do i = 0, imax-1
  1742: ||      A           xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )
  1743: |*-----           end do
  1744: W------         end do
  1745: +------>        do n = 1, IndexH2OVap-1
  1746: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
  1747: +------         end do
  1748: +------>        do n = IndexH2OVap+1, ncmax
  1749: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
  1750: +------         end do
  1751:                 n = IndexH2OVap
  1752: W------>        do j = 1, jmax
  1753: |*----->          do i = 0, imax-1
  1754: ||          !!$        xyr_LatentHeatFluxCor( i,j,0 ) = xy_SurfLatentHeatFlux( i,j )
  1755: ||      A           xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
  1756: |*-----           end do
  1757: W------         end do
  1758:             
  1759:                 ! ヒストリデータ出力
  1760:                 ! History data output
  1761:                 !
  1762:                 call HistoryAutoPut( TimeN, 'TauXB'          , xyr_MomFluxXCor (:,:,0) )
  1763:                 call HistoryAutoPut( TimeN, 'TauYB'          , xyr_MomFluxYCor (:,:,0) )
  1764:                 call HistoryAutoPut( TimeN, 'SensB'          , xyr_HeatFluxCor (:,:,0) )
  1765:                 call HistoryAutoPut( TimeN, 'SurfH2OVapFluxB', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
  1766:                 call HistoryAutoPut( TimeN, 'EvapB'          , xyr_LatentHeatFluxCor(:,:,0) )
  1767:             
  1768:             
  1769:                 ! Output of fluxes at t + \Delta t
  1770:                 !
  1771:             
  1772:                 ! 風速, 温度, 比湿フラックス補正
  1773:                 ! Correct fluxes of wind, temperature, specific humidity
  1774:                 !
  1775: W------>        do j = 1, jmax
  1776: |*----->          do i = 0, imax-1
  1777: ||      A           xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
  1778: ||                    & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * 2.0_DP * DelTime
  1779: ||          
  1780: ||      A           xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
  1781: ||                    & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * 2.0_DP * DelTime
  1782: ||          
  1783: ||      A           xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
  1784: ||                    & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
  1785: ||                    &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
  1786: ||                    &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
  1787: ||                    &   * 2.0_DP * DelTime
  1788: |*-----           end do
  1789: W------         end do
  1790:                 n = IndexH2OVap
  1791: W------>        do j = 1, jmax
  1792: |*----->          do i = 0, imax-1
  1793: ||      A           xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
  1794: ||                    & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
  1795: ||                    &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
  1796: ||                    &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * 2.0_DP * DelTime
  1797: |*-----           end do
  1798: W------         end do
  1799: +------>        do n = 1, IndexH2OVap-1
  1800: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
  1801: +------         end do
  1802: +------>        do n = IndexH2OVap+1, ncmax
  1803: |W*==== A         xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
  1804: +------         end do
  1805:                 n = IndexH2OVap
  1806: W------>        do j = 1, jmax
  1807: |*----->          do i = 0, imax-1
  1808: ||          !!$        xyr_LatentHeatFluxCor( i,j,0 ) = xy_SurfLatentHeatFlux( i,j )             &
  1809: ||          !!$          & - LatentHeat * xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )  &
  1810: ||          !!$          &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
  1811: ||          !!$          &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * 2.0d0 * DelTime
  1812: ||      A           xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
  1813: |*-----           end do
  1814: W------         end do
  1815:             
  1816:                 ! ヒストリデータ出力
  1817:                 ! History data output
  1818:                 !
  1819:                 call HistoryAutoPut( TimeN, 'TauXA'          , xyr_MomFluxXCor (:,:,0) )
  1820:                 call HistoryAutoPut( TimeN, 'TauYA'          , xyr_MomFluxYCor (:,:,0) )
  1821:                 call HistoryAutoPut( TimeN, 'SensA'          , xyr_HeatFluxCor (:,:,0) )
  1822:                 call HistoryAutoPut( TimeN, 'SurfH2OVapFluxA', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
  1823:                 call HistoryAutoPut( TimeN, 'EvapA'          , xyr_LatentHeatFluxCor(:,:,0) )
  1824:             
  1825:             
  1826:                 ! ヒストリデータ出力
  1827:                 ! History data output
  1828:                 !
  1829:                 call HistoryAutoPut( TimeN, 'SurfH2OVapFluxU', xy_SurfH2OVapFluxA     )
  1830:                 call HistoryAutoPut( TimeN, 'EvapU'          , xy_SurfLatentHeatFluxA )
  1831:             
  1832:             
  1833:                 ! 計算時間計測一時停止
  1834:                 ! Pause measurement of computation time
  1835:                 !
  1836:                 call TimesetClockStop( module_name )
  1837:             
  1838:               end subroutine SurfaceFluxOutput
  1839:             
  1840:               !--------------------------------------------------------------------------------------
  1841:             
  1842:               subroutine SurfaceFluxInit
  1843:                 !
  1844:                 ! surface_flux_bulk モジュールの初期化を行います. 
  1845:                 ! NAMELIST#surface_flux_bulk_nml の読み込みはこの手続きで行われます. 
  1846:                 !
  1847:                 ! "surface_flux_bulk" module is initialized. 
  1848:                 ! "NAMELIST#surface_flux_bulk_nml" is loaded in this procedure. 
  1849:                 !
  1850:             
  1851:                 ! モジュール引用 ; USE statements
  1852:                 !
  1853:             
  1854:                 ! NAMELIST ファイル入力に関するユーティリティ
  1855:                 ! Utilities for NAMELIST file input
  1856:                 !
  1857:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1858:             
  1859:                 ! ファイル入出力補助
  1860:                 ! File I/O support
  1861:                 !
  1862:                 use dc_iounit, only: FileOpen
  1863:             
  1864:                 ! 種別型パラメタ
  1865:                 ! Kind type parameter
  1866:                 !
  1867:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1868:             
  1869:                 ! 文字列操作
  1870:                 ! Character handling
  1871:                 !
  1872:                 use dc_string, only: StoA
  1873:             
  1874:                 ! ヒストリデータ出力
  1875:                 ! History data output
  1876:                 !
  1877:                 use gtool_historyauto, only: HistoryAutoAddVariable
  1878:             
  1879:                 ! 座標データ設定
  1880:                 ! Axes data settings
  1881:                 !
  1882:                 use axesset, only: &
  1883:                   & AxnameX, &
  1884:                   & AxnameY, &
  1885:                   & AxnameZ, &
  1886:                   & AxnameR, &
  1887:                   & AxnameT
  1888:             
  1889:                 ! 飽和比湿の算出
  1890:                 ! Evaluate saturation specific humidity
  1891:                 !
  1892:                 use saturate, only: SaturateInit
  1893:             
  1894:             
  1895:                 ! 宣言文 ; Declaration statements
  1896:                 !
  1897:                 implicit none
  1898:             
  1899:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1900:                                           ! Unit number for NAMELIST file open
  1901:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1902:                                           ! IOSTAT of NAMELIST read
  1903:             
  1904:                 ! NAMELIST 変数群
  1905:                 ! NAMELIST group name
  1906:                 !
  1907:                 namelist /surface_flux_bulk_nml/                                  &
  1908:                   & FlagConstBulkCoef,                                            &
  1909:                   & FlagUseOfBulkCoefInNeutralCond, ConstBulkCoef,                &
  1910:                   & FlagIncludeB94W,                                              &
  1911:                   !
  1912:                   & VelMinForRi, VelMinForVel, VelMinForTemp, VelMinForQVap,      &
  1913:                   & VelMaxForVel, VelMaxForTemp, VelMaxForQVap,                   &
  1914:                   !
  1915:                   & VelBulkCoefMin, TempBulkCoefMin, QVapBulkCoefMin,             &
  1916:                   & VelBulkCoefMax, TempBulkCoefMax, QVapBulkCoefMax,             &
  1917:                   !
  1918:                   & FlagFixFricTimeConstAtLB, FricTimeConstAtLB, LowLatFricAtLB,  &
  1919:                   & FlagFixHeatFluxAtLB,      HeatFluxAtLB,                       &
  1920:                   & FlagFixMassFluxAtLB,      MassFluxAtLB
  1921:                       !
  1922:                       ! デフォルト値については初期化手続 "surface_flux_bulk#SurfaceFluxInit" 
  1923:                       ! のソースコードを参照のこと. 
  1924:                       !
  1925:                       ! Refer to source codes in the initialization procedure
  1926:                       ! "surface_flux_bulk#SurfaceFluxInit" for the default values. 
  1927:                       !
  1928:             
  1929:                 ! 実行文 ; Executable statement
  1930:                 !
  1931:             
  1932:                 if ( surface_flux_bulk_inited ) return
  1933:             
  1934:             
  1935:                 ! デフォルト値の設定
  1936:                 ! Default values settings
  1937:                 !
  1938:                 FlagConstBulkCoef              = .false.
  1939:                 FlagUseOfBulkCoefInNeutralCond = .false.
  1940:                 ConstBulkCoef                  =  0.0_DP
  1941:             !!$    FlagIncludeB94W                = .false.
  1942:                 FlagIncludeB94W                = .true.
  1943:             
  1944:                 VelMinForRi   = 0.01_DP
  1945:                 VelMinForVel  = 0.01_DP
  1946:                 VelMinForTemp = 0.01_DP
  1947:                 VelMinForQVap = 0.01_DP
  1948:                 VelMaxForVel  = 1000.0_DP
  1949:                 VelMaxForTemp = 1000.0_DP
  1950:                 VelMaxForQVap = 1000.0_DP
  1951:             
  1952:                 VelBulkCoefMin  =  0.0_DP
  1953:                 TempBulkCoefMin =  0.0_DP
  1954:                 QVapBulkCoefMin =  0.0_DP
  1955:                 VelBulkCoefMax  =  1.0_DP
  1956:                 TempBulkCoefMax =  1.0_DP
  1957:                 QVapBulkCoefMax =  1.0_DP
  1958:             
  1959:                 FlagFixFricTimeConstAtLB = .false.
  1960:                 FricTimeConstAtLB        = 1.0e100_DP
  1961:                 LowLatFricAtLB           = 1.0e100_DP
  1962:                 FlagFixHeatFluxAtLB      = .false.
  1963:                 HeatFluxAtLB             = 1.0e100_DP
  1964:                 FlagFixMassFluxAtLB      = .false.
  1965:                 MassFluxAtLB             = 1.0e100_DP
  1966:             
  1967:                 ! NAMELIST の読み込み
  1968:                 ! NAMELIST is input
  1969:                 !
  1970:                 if ( trim(namelist_filename) /= '' ) then
  1971:                   call FileOpen( unit_nml, &          ! (out)
  1972:                     & namelist_filename, mode = 'r' ) ! (in)
  1973:             
  1974:                   rewind( unit_nml )
  1975:                   read( unit_nml, &                ! (in)
  1976:                     & nml = surface_flux_bulk_nml, &  ! (out)
  1977:                     & iostat = iostat_nml )        ! (out)
  1978:                   close( unit_nml )
  1979:             
  1980:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1981:                 end if
  1982:             
  1983:                 ! ヒストリデータ出力のためのへの変数登録
  1984:                 ! Register of variables for history data output
  1985:                 !
  1986:                 call HistoryAutoAddVariable( 'BulkCoefMom', &
  1987:                   & (/ AxNameX, AxNameY, AxNameT /), &
  1988:                   & 'bulk coefficient for momentum', '1' )
  1989:                 call HistoryAutoAddVariable( 'BulkCoefHeat', &
  1990:                   & (/ AxNameX, AxNameY, AxNameT /), &
  1991:                   & 'bulk coefficient for heat', '1' )
  1992:                 call HistoryAutoAddVariable( 'SfcBulkRi', &
  1993:                   & (/ AxNameX, AxNameY, AxNameT /), &
  1994:                   & 'bulk Richardson number at the surface', '1' )
  1995:             
  1996:                 call HistoryAutoAddVariable( 'TauX', &
  1997:                   & (/ AxNameX, AxNameY, AxNameT /), &
  1998:                   & 'surface stress(x)  ', 'N m-2' )
  1999:                 call HistoryAutoAddVariable( 'TauY', &
  2000:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2001:                   & 'surface stress(y)  ', 'N m-2' )
  2002:                 call HistoryAutoAddVariable( 'Sens', &
  2003:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2004:                   & 'sensible heat flux', 'W m-2' )
  2005:                 call HistoryAutoAddVariable( 'SurfH2OVapFlux', &
  2006:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2007:                   & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
  2008:                 call HistoryAutoAddVariable( 'Evap', &
  2009:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2010:                   & 'latent heat flux  ', 'W m-2' )
  2011:             
  2012:                 call HistoryAutoAddVariable( 'TauXB', &
  2013:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2014:                   & 'surface stress(x)  ', 'N m-2' )
  2015:                 call HistoryAutoAddVariable( 'TauYB', &
  2016:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2017:                   & 'surface stress(y)  ', 'N m-2' )
  2018:                 call HistoryAutoAddVariable( 'SensB', &
  2019:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2020:                   & 'sensible heat flux', 'W m-2' )
  2021:                 call HistoryAutoAddVariable( 'SurfH2OVapFluxB', &
  2022:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2023:                   & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
  2024:                 call HistoryAutoAddVariable( 'EvapB', &
  2025:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2026:                   & 'latent heat flux  ', 'W m-2' )
  2027:             
  2028:                 call HistoryAutoAddVariable( 'TauXA', &
  2029:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2030:                   & 'surface stress(x)  ', 'N m-2' )
  2031:                 call HistoryAutoAddVariable( 'TauYA', &
  2032:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2033:                   & 'surface stress(y)  ', 'N m-2' )
  2034:                 call HistoryAutoAddVariable( 'SensA', &
  2035:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2036:                   & 'sensible heat flux', 'W m-2' )
  2037:                 call HistoryAutoAddVariable( 'SurfH2OVapFluxA', &
  2038:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2039:                   & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
  2040:                 call HistoryAutoAddVariable( 'EvapA', &
  2041:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2042:                   & 'latent heat flux  ', 'W m-2' )
  2043:             
  2044:                 call HistoryAutoAddVariable( 'SurfH2OVapFluxU', &
  2045:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2046:                   & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
  2047:                 call HistoryAutoAddVariable( 'EvapU', &
  2048:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2049:                   & 'latent heat flux  ', 'W m-2' )
  2050:             
  2051:                 call HistoryAutoAddVariable( 'MOLength', &
  2052:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2053:                   & 'Monin-Obukhov length', 'm' )
  2054:                 call HistoryAutoAddVariable( 'MOLengthInv', &
  2055:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2056:                   & 'Monin-Obukhov length inverse', 'm-1' )
  2057:                 call HistoryAutoAddVariable( 'BetaW', &
  2058:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2059:                   & 'beta w_*', 'm s-1' )
  2060:                 call HistoryAutoAddVariable( 'BLHeight', &
  2061:                   & (/ AxNameX, AxNameY, AxNameT /), &
  2062:                   & 'boundary layer height', 'm' )
  2063:             
  2064:             
  2065:                 ! Initialization of modules used in this module
  2066:                 !
  2067:                 ! 飽和比湿の算出
  2068:                 ! Evaluate saturation specific humidity
  2069:                 !
  2070:                 call SaturateInit
  2071:             
  2072:             
  2073:                 ! 印字 ; Print
  2074:                 !
  2075:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2076:             
  2077:                 call MessageNotify( 'M', module_name, '  VelMinForRi       = %f', d = (/ VelMinForRi   /) )
  2078:                 call MessageNotify( 'M', module_name, '  VelMinForVel      = %f', d = (/ VelMinForVel  /) )
  2079:                 call MessageNotify( 'M', module_name, '  VelMinForTemp     = %f', d = (/ VelMinForTemp /) )
  2080:                 call MessageNotify( 'M', module_name, '  VelMinForQVap     = %f', d = (/ VelMinForQVap /) )
  2081:                 call MessageNotify( 'M', module_name, '  VelMaxForVel      = %f', d = (/ VelMaxForVel  /) )
  2082:                 call MessageNotify( 'M', module_name, '  VelMaxForTemp     = %f', d = (/ VelMaxForTemp /) )
  2083:                 call MessageNotify( 'M', module_name, '  VelMaxForQVap     = %f', d = (/ VelMaxForQVap /) )
  2084:                 call MessageNotify( 'M', module_name, 'Bulk coefficients:' )
  2085:                 call MessageNotify( 'M', module_name, '  FlagConstBulkCoef              = %b', l = (/ FlagConstBulkCoef /) )
  2086:                 call MessageNotify( 'M', module_name, '  FlagUseOfBulkCoefInNeutralCond = %b', l = (/ FlagUseOfBulkCoefInNeutralCond /) )
  2087:                 call MessageNotify( 'M', module_name, '  ConstBulkCoef   = %f', d = (/ ConstBulkCoef   /) )
  2088:                 call MessageNotify( 'M', module_name, '  VelBulkCoefMin  = %f', d = (/ VelBulkCoefMin  /) )
  2089:                 call MessageNotify( 'M', module_name, '  TempBulkCoefMin = %f', d = (/ TempBulkCoefMin /) )
  2090:                 call MessageNotify( 'M', module_name, '  QVapBulkCoefMin = %f', d = (/ QVapBulkCoefMin /) )
  2091:                 call MessageNotify( 'M', module_name, '  VelBulkCoefMax  = %f', d = (/ VelBulkCoefMax  /) )
  2092:                 call MessageNotify( 'M', module_name, '  TempBulkCoefMax = %f', d = (/ TempBulkCoefMax /) )
  2093:                 call MessageNotify( 'M', module_name, '  QVapBulkCoefMax = %f', d = (/ QVapBulkCoefMax /) )
  2094:                 call MessageNotify( 'M', module_name, 'FlagIncludeB94W          = %b', l = (/ FlagIncludeB94W /) )
  2095:                 call MessageNotify( 'M', module_name, 'FlagFixFricTimeConstAtLB = %b', l = (/ FlagFixFricTimeConstAtLB /) )
  2096:                 call MessageNotify( 'M', module_name, 'FricTimeConstAtLB        = %f', d = (/ FricTimeConstAtLB /) )
  2097:                 call MessageNotify( 'M', module_name, 'LowLatFricAtLB           = %f', d = (/ LowLatFricAtLB /) )
  2098:                 call MessageNotify( 'M', module_name, 'FlagFixHeatFluxAtLB      = %b', l = (/ FlagFixHeatFluxAtLB /) )
  2099:                 call MessageNotify( 'M', module_name, 'HeatFluxAtLB             = %f', d = (/ HeatFluxAtLB /) )
  2100:                 call MessageNotify( 'M', module_name, 'FlagFixMassFluxAtLB      = %b', l = (/ FlagFixMassFluxAtLB /) )
  2101:                 call MessageNotify( 'M', module_name, 'MassFluxAtLB             = %f', d = (/ MassFluxAtLB /) )
  2102:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2103:             
  2104:                 surface_flux_bulk_inited = .true.
  2105:             
  2106:               end subroutine SurfaceFluxInit
  2107:             
  2108:               !--------------------------------------------------------------------------------------
  2109:             
  2110:             end module surface_flux_bulk
