Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: albedo_Matthews.f90
PROGRAM NAME: albedo_matthews
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   216  opt  (1593): Loop nest collapsed into one loop.
   216  vec  (   4): Vectorized array expression.
   216  vec  (  29): ADB is used for array.: xy_surfalbedo
   219  opt  (1772): Loop nest fused with following nest(s).
   219  opt  (1593): Loop nest collapsed into one loop.
   219  vec  (   1): Vectorized loop.
   219  vec  (  29): ADB is used for array.: xy_surfalbedo
   219  vec  (  29): ADB is used for array.: aa_data_albedo
   219  vec  (  29): ADB is used for array.: xy_surftype
   226  opt  (1592): Outer loop unrolled inside inner loop.
   226  vec  (   4): Vectorized array expression.
   226  vec  (  29): ADB is used for array.: xy_surfalbedo
   226  vec  (   4): Vectorized array expression.
   226  vec  (  29): ADB is used for array.: xy_surfalbedo
   238  vec  (   4): Vectorized array expression.
   238  vec  (  26): Macro operation Sum/InnerProd.
   238  vec  (  29): ADB is used for array.: day_in_month_ptr
   254  vec  (   3): Unvectorized loop.
   254  vec  (   7): Iteration count is too small.
   271  opt  (1593): Loop nest collapsed into one loop.
   271  vec  (   1): Vectorized loop.
   271  vec  (  29): ADB is used for array.: aa_data_albedo
   271  vec  (  29): ADB is used for array.: xy_surftype
   286  opt  (1593): Loop nest collapsed into one loop.
   286  vec  (   1): Vectorized loop.
   286  vec  (  29): ADB is used for array.: aa_data_albedo
   286  vec  (  29): ADB is used for array.: xy_surftype
   293  opt  (1593): Loop nest collapsed into one loop.
   293  vec  (   4): Vectorized array expression.
   293  vec  (  29): ADB is used for array.: xy_surfalbedo
   392  opt  (1593): Loop nest collapsed into one loop.
   392  vec  (   1): Vectorized loop.
   392  vec  (  29): ADB is used for array.: xy_surfalbedo
   392  vec  (  29): ADB is used for array.: xy_surfculint
   392  vec  (  29): ADB is used for array.: xy_surftype
   412  vec  (   4): Vectorized array expression.
   412  vec  (  26): Macro operation Sum/InnerProd.
   412  vec  (  29): ADB is used for array.: day_in_month_ptr
   428  vec  (   3): Unvectorized loop.
   428  vec  (   7): Iteration count is too small.
   445  opt  (1593): Loop nest collapsed into one loop.
   445  vec  (   1): Vectorized loop.
   460  opt  (1593): Loop nest collapsed into one loop.
   460  vec  (   1): Vectorized loop.
   467  opt  (1593): Loop nest collapsed into one loop.
   467  vec  (   4): Vectorized array expression.
   473  opt  (1593): Loop nest collapsed into one loop.
   473  vec  (   1): Vectorized loop.
   473  vec  (  29): ADB is used for array.: xy_surfalbedo
   473  vec  (  29): ADB is used for array.: xy_surfculint
   473  vec  (  29): ADB is used for array.: xy_surftype
   557  vec  (   4): Vectorized array expression.
   557  vec  (  29): ADB is used for array.: aa_data_albedo
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: albedo_Matthews.f90
PROGRAM NAME: albedo_matthews
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Matthews のデータに基づく惑星表面アルベド設定
     2  !
     3  != set surface albedo based on data by Matthews
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Satoshi Noda
     6  ! Version::   $Id: albedo_Matthews.f90,v 1.10 2014/05/07 09:39:23 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module albedo_Matthews
    13  
    14    ! モジュール引用 ; USE statements
    15    !
    16  
    17    ! 種別型パラメタ
    18    ! Kind type parameter
    19    !
    20    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    21      &                 STRING     ! 文字列.       Strings.
    22  
    23    ! メッセージ出力
    24    ! Message output
    25    !
    26    use dc_message, only: MessageNotify
    27  
    28    ! 格子点設定
    29    ! Grid points settings
    30  
    31    ! 宣言文 ; Declaration statements
    32    !
    33    implicit none
    34    private
    35  
    36    ! 公開手続き
    37    ! Public procedure
    38    !
    39    public:: SetAlbedoMatthews
    40    public:: ModAlbedoMatthewsCultivation
    41    public:: AlbedoMatthewsInit
    42  
    43    ! 公開変数
    44    ! Public variables
    45    !
    46  
    47    ! 非公開変数
    48    ! Private variables
    49    !
    50    logical, save :: albedo_matthews_inited = .false.
    51                                ! 初期設定フラグ.
    52                                ! Initialization flag
    53    logical   , save      :: flag_annual_mean
    54                                ! 年平均フラグ.
    55                                ! Flag of annual mean
    56    real(DP)  , save      :: OceanAlbedo
    57                                ! 海洋のアルベド.
    58                                ! Albedo of ocean.
    59  
    60    integer , parameter :: NAlbType = 32
    61                                ! 植生の種類の数.
    62                                ! Number of vegetation type.
    63    integer , parameter :: NSeason = 4
    64                                ! 季節の数.
    65                                ! Number of season.
    66    real(DP), save      :: a_Data_DOY( NSeason )
    67                                ! 各季節の開始日.
    68                                ! Start date of each season.
    69    real(DP), save      :: aa_Data_Albedo( NSeason, 0:NAlbType )
    70                                ! 各植生, 各季節におけるアルベド.
    71                                ! Albedo of each vegetation type, each season.
    72    integer, parameter  :: IndexCultivation = 32
    73                                !
    74                                ! Index for cultivation
    75  
    76  
    77    !    win.  spr.  sum.  fall
    78    data a_Data_DOY / 0.0_DP, 90.0_DP, 181.0_DP, 273.0_DP /
    79  
    80    !
    81    ! Matthews, 1985, NASA Technical memorandum #86199
    82    ! ATLAS, OF ARCHIVED VEGETATION, LAND-USE AND SEASONAL ALBEDO DATA SET
    83    ! http://ntrs.nasa.gov/archive/nasa/casi.ntrs.nasa.gov/19850016197_1985016197.pdf
    84    !
    85    ! Notice: The unit of the following values is percent.
    86    !         0.01 is multiplied in initialization.
    87    !
    88    !    win.  spr.  sum.  fall
    89    !    Jan.  Apr.  Jul.  Oct.   for nothern hemisphere
    90    !    Jul.  Oct.  Jan.  Apr.   for southern hemisphere
    91    data aa_Data_Albedo / &
    92      10,   10,   10,   10, & !  0  The values for 0 are not included in Matthes compilation.
    93      11,   11,   11,   11, & !  1
    94      11,   11,   11,   11, & !  2
    95      11,   11,   11,   11, & !  3
    96      12,   12,   12,   12, & !  4
    97      12,   13,   14,   13, & !  5
    98      17,   14,   13,   14, & !  6
    99      13,   14,   16,   13, & !  7
   100      11,   12,   15,   12, & !  8
   101      18,   16,   15,   16, & !  9
   102      12,   15,   18,   13, & ! 10
   103      12,   15,   18,   13, & ! 11
   104      28,   32,   28,   28, & ! 12
   105      15,   13,   12,   13, & ! 13
   106      14,   14,   16,   14, & ! 14
   107      20,   18,   17,   18, & ! 15
   108      14,   14,   17,   14, & ! 16
   109      15,   15,   18,   15, & ! 17
   110      15,   15,   18,   15, & ! 18
   111      17,   20,   20,   17, & ! 19
   112      17,   20,   20,   17, & ! 20
   113      28,   32,   28,   28, & ! 21
   114      12,   12,   17,   15, & ! 22
   115      14,   15,   17,   15, & ! 23
   116      14,   15,   16,   14, & ! 24
   117      16,   18,   25,   20, & ! 25
   118      17,   17,   20,   17, & ! 26
   119      16,   20,   20,   18, & ! 27
   120      16,   20,   20,   18, & ! 28
   121      16,   20,   20,   18, & ! 29
   122      30,   30,   30,   30, & ! 30
   123      75,   75,   75,   75, & ! 31
   124      16,   18,   20,   18  & ! 32 cultivation
   125      /
   126  
   127  
   128    character(*), parameter:: module_name = 'albedo_Matthews'
   129                                ! モジュールの名称.
   130                                ! Module name
   131    character(*), parameter:: version = &
   132      & '$Name:  $' // &
   133      & '$Id: albedo_Matthews.f90,v 1.10 2014/05/07 09:39:23 murashin Exp $'
   134                                ! モジュールのバージョン
   135                                ! Module version
   136  
   137    ! INTERFACE 文 ; INTERFACE statements
   138    !
   139  
   140  contains
   141  
   142    !--------------------------------------------------------------------------------------
   143  
   144    subroutine SetAlbedoMatthews( xy_SurfType, xy_SurfAlbedo )
   145  
   146      ! モジュール引用 ; USE statements
   147      !
   148  
   149      ! 格子点設定
   150      ! Grid points settings
   151      !
   152      use gridset, only: imax, & ! 経度格子点数.
   153                                 ! Number of grid points in longitude
   154        &                jmax, & ! 緯度格子点数.
   155                                 ! Number of grid points in latitude
   156        &                kmax    ! 鉛直層数.
   157                                 ! Number of vertical level
   158  
   159      ! 日付および時刻の取り扱い
   160      ! Date and time handler
   161      !
   162      use dc_calendar, only: DCCalInquire, DCCalDateEvalSecOfYear
   163  
   164      ! 時刻管理
   165      ! Time control
   166      !
   167      use timeset, only: TimeN, InitialDate
   168  
   169      ! 宣言文 ; Declaration statements
   170      !
   171      integer , intent(in ) :: xy_SurfType  ( 0:imax-1, 1:jmax )
   172                                ! 植生のインデックス
   173                                ! Index of vegetation
   174      real(DP), intent(out) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
   175                                ! 地表アルベド.
   176                                ! Surface albedo
   177  
   178      ! 作業変数
   179      ! Work variables
   180      !
   181      real(DP):: SecOfYear
   182      real(DP):: a_Data_SOY_Ex( 0:nseason+1 )
   183                                ! 各季節の開始時刻 (内挿のために拡張).
   184                                ! Start time of each season (extended for interpolation).
   185      real(DP):: xya_SurfAlbedoLocal( 0:imax-1, 1:jmax, 1:2 )
   186      integer :: i              ! 経度方向に回る DO ループ用作業変数
   187                                ! Work variables for DO loop in longitude
   188      integer :: j              ! 緯度方向に回る DO ループ用作業変数
   189                                ! Work variables for DO loop in latitude
   190      integer :: l              ! 季節方向に回る DO ループ用作業変数
   191                                ! Work variables for DO loop in season
   192      integer :: t
   193      integer :: tindex
   194      integer :: a_tindex(1:2)
   195  
   196      integer:: hour_in_day, min_in_hour, day_in_year
   197      integer, pointer:: day_in_month_ptr(:) => null()
   198      real(DP):: sec_in_min, sec_in_day
   199  
   200      ! 実行文 ; Executable statement
   201      !
   202  
   203      ! 初期化確認
   204      ! Initialization check
   205      !
   206      if ( .not. albedo_matthews_inited ) then
   207        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   208      end if
   209  
   210  
   211      if ( flag_annual_mean ) then
   212  
   213        !
   214        ! Now, annual mean value is used, temporarily.
   215        !
   216        xy_SurfAlbedo = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t309 = 1, jmax*imax                                            
     .           xy_surfalbedo(t309-1,1) = 0.0000000000000000e+000              
     .        enddo                                                             
   217  
   218        do l = 1, nseason
   219          do j = 1, jmax
   220            do i = 0, imax-1
   221              xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j) + aa_Data_Albedo( l, xy_SurfType(i,j) )
   222            end do
   223          end do
   224        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xy_surfalbedo(j-1,1) = xy_surfalbedo(j-1,1) + aa_data_albedo(1,
     .       1      xy_surftype(j-1,1))                                         
     .           xy_surfalbedo(j-1,1) = xy_surfalbedo(j-1,1) + aa_data_albedo(2,
     .       1      xy_surftype(j-1,1))                                         
     .           xy_surfalbedo(j-1,1) = xy_surfalbedo(j-1,1) + aa_data_albedo(3,
     .       1      xy_surftype(j-1,1))                                         
     .           xy_surfalbedo(j-1,1) = xy_surfalbedo(j-1,1) + aa_data_albedo(4,
     .       1      xy_surftype(j-1,1))                                         
     .        enddo                                                             
   225  
   226        xy_SurfAlbedo = xy_SurfAlbedo / dble( nseason )
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t315 = 1, j1                                                
     .              d1 = 1.D0/4.00000000000000e+000                             
     .  !cdir       nodep                                                       
     .              do t317 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surfalbedo(t317-1,t315) = xy_surfalbedo(t317-1,t315)* 
     .       1            d1                                                    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t315 = j1 + 1, jmax, 4                                      
     .              d2 = 1.D0/4.00000000000000e+000                             
     .              d3 = 1.D0/4.00000000000000e+000                             
     .              d4 = 1.D0/4.00000000000000e+000                             
     .              d5 = 1.D0/4.00000000000000e+000                             
     .  !cdir       nodep                                                       
     .              do t317 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surfalbedo(t317-1,t315) = xy_surfalbedo(t317-1,t315)* 
     .       1            d2                                                    
     .                 xy_surfalbedo(t317-1,t315+1) = xy_surfalbedo(t317-1,t315+
     .       1            1)*d3                                                 
     .                 xy_surfalbedo(t317-1,t315+2) = xy_surfalbedo(t317-1,t315+
     .       1            2)*d4                                                 
     .                 xy_surfalbedo(t317-1,t315+3) = xy_surfalbedo(t317-1,t315+
     .       1            3)*d5                                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10036                                                        
   227  
   228      else
   229  
   230        SecOfYear = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )
   231  
   232        call DCCalInquire( &
   233          & day_in_month_ptr = day_in_month_ptr , & ! (out)
   234          & hour_in_day      = hour_in_day  , &     ! (out)
   235          & min_in_hour      = min_in_hour  , &     ! (out)
   236          & sec_in_min       = sec_in_min )         ! (out)
   237  
   238        day_in_year = sum( day_in_month_ptr )
   239        deallocate( day_in_month_ptr )
   240        sec_in_day  = hour_in_day * min_in_hour * sec_in_min
   241  
   242  
   243        if ( SecOfYear > day_in_year * sec_in_day ) SecOfYear = day_in_year * sec_in_day
   244  
   245        a_Data_SOY_Ex(0) = ( 0.0_DP - ( day_in_year - a_Data_DOY(nseason) ) ) * sec_in_day
   246        do t = 1, nseason
   247          a_Data_SOY_Ex(t) = a_Data_DOY(t) * sec_in_day
   248        end do
     .           a_data_soy_ex(1) = a_data_doy(1)*sec_in_day                    
     .        a_data_soy_ex(2) = a_data_doy(2)*sec_in_day                       
     .        a_data_soy_ex(3) = a_data_doy(3)*sec_in_day                       
     .        a_data_soy_ex(4) = a_data_doy(4)*sec_in_day                       
   249        a_Data_SOY_Ex(nseason+1) = ( day_in_year + a_Data_DOY(1) ) * sec_in_day
   250  
   251  
   252        a_tindex(1) = 0
   253        a_tindex(2) = 1
   254        do t = 1, nseason
   255          if ( a_Data_DOY(t) * sec_in_day <= SecOfYear ) then
   256            a_tindex(1) = t
   257            a_tindex(2) = t+1
   258          end if
   259        end do
   260  
   261        do t = 1, 2
   262          ! for northern hemisphere
   263          tindex = a_tindex(t)
   264          if ( tindex == 0 ) then
   265            tindex = nseason
   266          else if ( tindex == nseason+1 ) then
   267            tindex = 1
   268          else
   269            tindex = tindex
   270          end if
   271          do j = jmax/2+1, jmax
   272            do i = 0, imax-1
   273              xya_SurfAlbedoLocal(i,j,t) = aa_Data_Albedo( tindex, xy_SurfType(i,j) )
   274            end do
   275          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surftype,aa_data_albedo)                                
     .        do j = 1, (jmax - jmax/2)*imax                                    
     .           xya_surfalbedolocal(j-1,1+jmax/2,t) = aa_data_albedo(tindex,   
     .       1      xy_surftype(j-1,1+jmax/2))                                  
     .        enddo                                                             
   276          ! for southern hemisphere
   277          tindex = a_tindex(t) + nseason / 2
   278          if ( tindex > nseason ) tindex = tindex - nseason
   279          if ( tindex == 0 ) then
   280            tindex = nseason
   281          else if ( tindex == nseason+1 ) then
   282            tindex = 1
   283          else
   284            tindex = tindex
   285          end if
   286          do j = 1, jmax/2
   287            do i = 0, imax-1
   288              xya_SurfAlbedoLocal(i,j,t) = aa_Data_Albedo( tindex, xy_SurfType(i,j) )
   289            end do
   290          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surftype,aa_data_albedo)                                
     .        do j = 1, (jmax/2)*imax                                           
     .           xya_surfalbedolocal(j-1,1,t) = aa_data_albedo(tindex,          
     .       1      xy_surftype(j-1,1))                                         
     .        enddo                                                             
   291        end do
   292  
   293        xy_SurfAlbedo =                                                   &
     .        a_tindex3 = a_tindex(1)                                           
     .        d6 = 1.D0/(a_data_soy_ex(a_tindex(2))-a_data_soy_ex(a_tindex3))   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t297 = 1, xya_surfalbedolocal.DSC.U2*xya_surfalbedolocal.DSC.U1
     .       1    + xya_surfalbedolocal.DSC.U2                                  
     .           xy_surfalbedo(t297-1,1) = (xya_surfalbedolocal(t297-1,1,2)-    
     .       1      xya_surfalbedolocal(t297-1,1,1))*d6*(secofyear -            
     .       2      a_data_soy_ex(a_tindex3)) + xya_surfalbedolocal(t297-1,1,1) 
     .        enddo                                                             
   294          &   ( xya_SurfAlbedoLocal(:,:,2) - xya_SurfAlbedoLocal(:,:,1) ) &
   295          & / ( a_Data_SOY_Ex(a_tindex(2)) - a_Data_SOY_Ex(a_tindex(1)) ) &
   296          & * ( SecOfYear                  - a_Data_SOY_Ex(a_tindex(1)) ) &
   297          & + xya_SurfAlbedoLocal(:,:,1)
   298  
   299      end if
   300  
   301  
   302    end subroutine SetAlbedoMatthews
   303  
   304    !--------------------------------------------------------------------------------------
   305  
   306    subroutine ModAlbedoMatthewsCultivation( &
   307      & xy_SurfType, xy_SurfCulInt,          &
   308      & xy_SurfAlbedo                        &
   309      & )
   310  
   311      ! モジュール引用 ; USE statements
   312      !
   313  
   314      ! 格子点設定
   315      ! Grid points settings
   316      !
   317      use gridset, only: imax, & ! 経度格子点数.
   318                                 ! Number of grid points in longitude
   319        &                jmax, & ! 緯度格子点数.
   320                                 ! Number of grid points in latitude
   321        &                kmax    ! 鉛直層数.
   322                                 ! Number of vertical level
   323  
   324      ! 日付および時刻の取り扱い
   325      ! Date and time handler
   326      !
   327      use dc_calendar, only: DCCalInquire, DCCalDateEvalSecOfYear
   328  
   329      ! 時刻管理
   330      ! Time control
   331      !
   332      use timeset, only: TimeN, InitialDate
   333  
   334      ! 宣言文 ; Declaration statements
   335      !
   336      integer , intent(in   ) :: xy_SurfType  ( 0:imax-1, 1:jmax )
   337                                ! 植生のインデックス
   338                                ! Index of vegetation
   339      real(DP), intent(in   ) :: xy_SurfCulInt( 0:imax-1, 1:jmax )
   340                                ! ...
   341                                ! Cultivation index
   342      real(DP), intent(inout) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
   343                                ! 地表アルベド.
   344                                ! Surface albedo
   345  
   346      ! 作業変数
   347      ! Work variables
   348      !
   349      real(DP):: SecOfYear
   350      real(DP):: a_Data_SOY_Ex( 0:nseason+1 )
   351                                ! 各季節の開始時刻 (内挿のために拡張).
   352                                ! Start time of each season (extended for interpolation).
   353      real(DP):: SurfAlbedoCul
   354      real(DP):: xy_SurfAlbedoCul ( 0:imax-1, 1:jmax )
   355      real(DP):: xya_SurfAlbedoCul( 0:imax-1, 1:jmax, 1:2 )
   356      integer :: i              ! 経度方向に回る DO ループ用作業変数
   357                                ! Work variables for DO loop in longitude
   358      integer :: j              ! 緯度方向に回る DO ループ用作業変数
   359                                ! Work variables for DO loop in latitude
   360      integer :: l              ! 季節方向に回る DO ループ用作業変数
   361                                ! Work variables for DO loop in season
   362      integer :: t
   363      integer :: tindex
   364      integer :: a_tindex(1:2)
   365  
   366      integer:: hour_in_day, min_in_hour, day_in_year
   367      integer, pointer:: day_in_month_ptr(:) => null()
   368      real(DP):: sec_in_min, sec_in_day
   369  
   370      ! 実行文 ; Executable statement
   371      !
   372  
   373      ! 初期化確認
   374      ! Initialization check
   375      !
   376      if ( .not. albedo_matthews_inited ) then
   377        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   378      end if
   379  
   380  
   381      if ( flag_annual_mean ) then
   382  
   383        !
   384        ! Now, annual mean value is used, temporarily.
   385        !
   386        SurfAlbedoCul = 0.0_DP
   387        do l = 1, nseason
   388          SurfAlbedoCul = SurfAlbedoCul + aa_Data_Albedo( l, IndexCultivation )
   389        end do
     .        surfalbedocul = surfalbedocul + aa_data_albedo(1,32)              
     .        surfalbedocul = surfalbedocul + aa_data_albedo(2,32)              
     .        surfalbedocul = surfalbedocul + aa_data_albedo(3,32)              
     .        surfalbedocul = surfalbedocul + aa_data_albedo(4,32)              
   390        SurfAlbedoCul = SurfAlbedoCul / dble( nseason )
   391  
   392        do j = 1, jmax
   393          do i = 0, imax-1
   394            if ( xy_SurfType(i,j) > 0 ) then
   395              xy_SurfAlbedo(i,j) =                                       &
   396                &   ( 1.0_DP - xy_SurfCulInt(i,j) ) * xy_SurfAlbedo(i,j) &
   397                & + xy_SurfCulInt(i,j)              * SurfAlbedoCul
   398            end if
   399          end do
   400        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .gt. 0) then                            
     .              xy_surfalbedo(j-1,1) = (1.00000000000000e+000 -             
     .       1         xy_surfculint(j-1,1))*xy_surfalbedo(j-1,1) +             
     .       2         xy_surfculint(j-1,1)*surfalbedocul                       
     .           endif                                                          
     .        enddo                                                             
     .        goto 10041                                                        
   401  
   402      else
   403  
   404        SecOfYear = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )
   405  
   406        call DCCalInquire( &
   407          & day_in_month_ptr = day_in_month_ptr , & ! (out)
   408          & hour_in_day      = hour_in_day  , &     ! (out)
   409          & min_in_hour      = min_in_hour  , &     ! (out)
   410          & sec_in_min       = sec_in_min )         ! (out)
   411  
   412        day_in_year = sum( day_in_month_ptr )
   413        deallocate( day_in_month_ptr )
   414        sec_in_day  = hour_in_day * min_in_hour * sec_in_min
   415  
   416  
   417        if ( SecOfYear > day_in_year * sec_in_day ) SecOfYear = day_in_year * sec_in_day
   418  
   419        a_Data_SOY_Ex(0) = ( 0.0_DP - ( day_in_year - a_Data_DOY(nseason) ) ) * sec_in_day
   420        do t = 1, nseason
   421          a_Data_SOY_Ex(t) = a_Data_DOY(t) * sec_in_day
   422        end do
     .           a_data_soy_ex(1) = a_data_doy(1)*sec_in_day                    
     .        a_data_soy_ex(2) = a_data_doy(2)*sec_in_day                       
     .        a_data_soy_ex(3) = a_data_doy(3)*sec_in_day                       
     .        a_data_soy_ex(4) = a_data_doy(4)*sec_in_day                       
   423        a_Data_SOY_Ex(nseason+1) = ( day_in_year + a_Data_DOY(1) ) * sec_in_day
   424  
   425  
   426        a_tindex(1) = 0
   427        a_tindex(2) = 1
   428        do t = 1, nseason
   429          if ( a_Data_DOY(t) * sec_in_day <= SecOfYear ) then
   430            a_tindex(1) = t
   431            a_tindex(2) = t+1
   432          end if
   433        end do
   434  
   435        do t = 1, 2
   436          ! for northern hemisphere
   437          tindex = a_tindex(t)
   438          if ( tindex == 0 ) then
   439            tindex = nseason
   440          else if ( tindex == nseason+1 ) then
   441            tindex = 1
   442          else
   443            tindex = tindex
   444          end if
   445          do j = jmax/2+1, jmax
   446            do i = 0, imax-1
   447              xya_SurfAlbedoCul(i,j,t) = aa_Data_Albedo( tindex, IndexCultivation )
   448            end do
   449          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, (jmax - jmax/2)*imax                                    
     .           xya_surfalbedocul(j-1,1+jmax/2,t) = aa_data_albedo(tindex,32)  
     .        enddo                                                             
   450          ! for southern hemisphere
   451          tindex = a_tindex(t) + nseason / 2
   452          if ( tindex > nseason ) tindex = tindex - nseason
   453          if ( tindex == 0 ) then
   454            tindex = nseason
   455          else if ( tindex == nseason+1 ) then
   456            tindex = 1
   457          else
   458            tindex = tindex
   459          end if
   460          do j = 1, jmax/2
   461            do i = 0, imax-1
   462              xya_SurfAlbedoCul(i,j,t) = aa_Data_Albedo( tindex, IndexCultivation )
   463            end do
   464          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, (jmax/2)*imax                                           
     .           xya_surfalbedocul(j-1,1,t) = aa_data_albedo(tindex,32)         
     .        enddo                                                             
   465        end do
   466  
   467        xy_SurfAlbedoCul =                                                &
     .        a_tindex2 = a_tindex(1)                                           
     .        d1 = 1.D0/(a_data_soy_ex(a_tindex(2))-a_data_soy_ex(a_tindex2))   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t357 = 1, xya_surfalbedocul.DSC.U2*xya_surfalbedocul.DSC.U1 +  
     .       1   xya_surfalbedocul.DSC.U2                                       
     .           xy_surfalbedocul(t357-1,1) = (xya_surfalbedocul(t357-1,1,2)-   
     .       1      xya_surfalbedocul(t357-1,1,1))*d1*(secofyear - a_data_soy_ex
     .       2      (a_tindex2)) + xya_surfalbedocul(t357-1,1,1)                
     .        enddo                                                             
   468          &   ( xya_SurfAlbedoCul(:,:,2)   - xya_SurfAlbedoCul(:,:,1)   ) &
   469          & / ( a_Data_SOY_Ex(a_tindex(2)) - a_Data_SOY_Ex(a_tindex(1)) ) &
   470          & * ( SecOfYear                  - a_Data_SOY_Ex(a_tindex(1)) ) &
   471          & + xya_SurfAlbedoCul(:,:,1)
   472  
   473        do j = 1, jmax
   474          do i = 0, imax-1
   475            if ( xy_SurfType(i,j) > 0 ) then
   476              xy_SurfAlbedo(i,j) =                                          &
   477                &   ( 1.0_DP - xy_SurfCulInt(i,j) ) * xy_SurfAlbedo(i,j)    &
   478                & + xy_SurfCulInt(i,j)              * xy_SurfAlbedoCul(i,j)
   479            end if
   480          end do
   481        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .gt. 0) then                            
     .              xy_surfalbedo(j-1,1) = (1.00000000000000e+000 -             
     .       1         xy_surfculint(j-1,1))*xy_surfalbedo(j-1,1) +             
     .       2         xy_surfculint(j-1,1)*xy_surfalbedocul(j-1,1)             
     .           endif                                                          
     .        enddo                                                             
   482  
   483      end if
   484  
   485  
   486    end subroutine ModAlbedoMatthewsCultivation
   487  
   488    !--------------------------------------------------------------------------------------
   489  
   490    subroutine AlbedoMatthewsInit
   491  
   492      ! NAMELIST ファイル入力に関するユーティリティ
   493      ! Utilities for NAMELIST file input
   494      !
   495      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   496  
   497      ! ファイル入出力補助
   498      ! File I/O support
   499      !
   500      use dc_iounit, only: FileOpen
   501  
   502      ! メッセージ出力
   503      ! Message output
   504      !
   505      use dc_message, only: MessageNotify
   506  
   507      ! 作業変数
   508      ! Work variables
   509      !
   510      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   511                                ! Unit number for NAMELIST file open
   512      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   513                                ! IOSTAT of NAMELIST read
   514  
   515      ! NAMELIST 変数群
   516      ! NAMELIST group name
   517      !
   518      namelist /albedo_Matthews_nml/ &
   519        & flag_annual_mean, &
   520        & OceanAlbedo
   521            !
   522            ! デフォルト値については初期化手続 "surface_flux_bulk#SurfFluxInit"
   523            ! のソースコードを参照のこと.
   524            !
   525            ! Refer to source codes in the initialization procedure
   526            ! "surface_flux_bulk#SurfFluxInit" for the default values.
   527            !
   528  
   529      if ( albedo_matthews_inited ) return
   530  
   531  
   532      ! デフォルト値の設定
   533      ! Default values settings
   534      !
   535      flag_annual_mean = .false.
   536      OceanAlbedo      = 0.1_DP
   537  
   538  
   539      ! NAMELIST の読み込み
   540      ! NAMELIST is input
   541      !
   542      if ( trim(namelist_filename) /= '' ) then
   543        call FileOpen( unit_nml, &          ! (out)
   544          & namelist_filename, mode = 'r' ) ! (in)
   545  
   546        rewind( unit_nml )
   547        read( unit_nml, &                ! (in)
   548          & nml = albedo_Matthews_nml, &  ! (out)
   549          & iostat = iostat_nml )        ! (out)
   550        close( unit_nml )
   551  
   552        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   553      end if
   554  
   555  
   556  
   557      aa_Data_Albedo = aa_Data_Albedo * 1.0e-2_DP
     .  !cdir nodep                                                             
     .        do t70 = 0, 32                                                    
     .           aa_data_albedo(1,t70) = aa_data_albedo(1,t70)*                 
     .       1      1.00000000000000e-002                                       
     .           aa_data_albedo(2,t70) = aa_data_albedo(2,t70)*                 
     .       1      1.00000000000000e-002                                       
     .           aa_data_albedo(3,t70) = aa_data_albedo(3,t70)*                 
     .       1      1.00000000000000e-002                                       
     .           aa_data_albedo(4,t70) = aa_data_albedo(4,t70)*                 
     .       1      1.00000000000000e-002                                       
     .        enddo                                                             
   558  
   559  
   560      aa_Data_Albedo(:,0) = OceanAlbedo
     .        aa_data_albedo(1,0) = oceanalbedo                                 
     .        aa_data_albedo(2,0) = oceanalbedo                                 
     .        aa_data_albedo(3,0) = oceanalbedo                                 
     .        aa_data_albedo(4,0) = oceanalbedo                                 
   561  
   562  
   563  
   564      ! 印字 ; Print
   565      !
   566      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   567      call MessageNotify( 'M', module_name, '  flag_annual_mean = %b', l = (/ flag_annual_mean /) )
   568      call MessageNotify( 'M', module_name, '  OceanAlbedo      = %f', d = (/ OceanAlbedo      /) )
   569      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   570  
   571  
   572      albedo_matthews_inited = .true.
   573  
   574    end subroutine AlbedoMatthewsInit
   575  
   576    !--------------------------------------------------------------------------------------
   577  
   578  end module albedo_Matthews
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: albedo_Matthews.f90
PROGRAM NAME: albedo_matthews
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Matthews のデータに基づく惑星表面アルベド設定
     2:             !
     3:             != set surface albedo based on data by Matthews
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Satoshi Noda
     6:             ! Version::   $Id: albedo_Matthews.f90,v 1.10 2014/05/07 09:39:23 murashin Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module albedo_Matthews
    13:             
    14:               ! モジュール引用 ; USE statements
    15:               !
    16:             
    17:               ! 種別型パラメタ
    18:               ! Kind type parameter
    19:               !
    20:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    21:                 &                 STRING     ! 文字列.       Strings.
    22:             
    23:               ! メッセージ出力
    24:               ! Message output
    25:               !
    26:               use dc_message, only: MessageNotify
    27:             
    28:               ! 格子点設定
    29:               ! Grid points settings
    30:             
    31:               ! 宣言文 ; Declaration statements
    32:               !
    33:               implicit none
    34:               private
    35:             
    36:               ! 公開手続き
    37:               ! Public procedure
    38:               !
    39:               public:: SetAlbedoMatthews
    40:               public:: ModAlbedoMatthewsCultivation
    41:               public:: AlbedoMatthewsInit
    42:             
    43:               ! 公開変数
    44:               ! Public variables
    45:               !
    46:             
    47:               ! 非公開変数
    48:               ! Private variables
    49:               !
    50:               logical, save :: albedo_matthews_inited = .false.
    51:                                           ! 初期設定フラグ.
    52:                                           ! Initialization flag
    53:               logical   , save      :: flag_annual_mean
    54:                                           ! 年平均フラグ.
    55:                                           ! Flag of annual mean
    56:               real(DP)  , save      :: OceanAlbedo
    57:                                           ! 海洋のアルベド.
    58:                                           ! Albedo of ocean.
    59:             
    60:               integer , parameter :: NAlbType = 32
    61:                                           ! 植生の種類の数.
    62:                                           ! Number of vegetation type.
    63:               integer , parameter :: NSeason = 4
    64:                                           ! 季節の数.
    65:                                           ! Number of season.
    66:               real(DP), save      :: a_Data_DOY( NSeason )
    67:                                           ! 各季節の開始日.
    68:                                           ! Start date of each season.
    69:               real(DP), save      :: aa_Data_Albedo( NSeason, 0:NAlbType )
    70:                                           ! 各植生, 各季節におけるアルベド.
    71:                                           ! Albedo of each vegetation type, each season.
    72:               integer, parameter  :: IndexCultivation = 32
    73:                                           !
    74:                                           ! Index for cultivation
    75:             
    76:             
    77:               !    win.  spr.  sum.  fall
    78:               data a_Data_DOY / 0.0_DP, 90.0_DP, 181.0_DP, 273.0_DP /
    79:             
    80:               !
    81:               ! Matthews, 1985, NASA Technical memorandum #86199 
    82:               ! ATLAS, OF ARCHIVED VEGETATION, LAND-USE AND SEASONAL ALBEDO DATA SET
    83:               ! http://ntrs.nasa.gov/archive/nasa/casi.ntrs.nasa.gov/19850016197_1985016197.pdf
    84:               ! 
    85:               ! Notice: The unit of the following values is percent.
    86:               !         0.01 is multiplied in initialization.
    87:               !
    88:               !    win.  spr.  sum.  fall
    89:               !    Jan.  Apr.  Jul.  Oct.   for nothern hemisphere
    90:               !    Jul.  Oct.  Jan.  Apr.   for southern hemisphere
    91:               data aa_Data_Albedo / &
    92:                 10,   10,   10,   10, & !  0  The values for 0 are not included in Matthes compilation.
    93:                 11,   11,   11,   11, & !  1
    94:                 11,   11,   11,   11, & !  2
    95:                 11,   11,   11,   11, & !  3
    96:                 12,   12,   12,   12, & !  4
    97:                 12,   13,   14,   13, & !  5
    98:                 17,   14,   13,   14, & !  6
    99:                 13,   14,   16,   13, & !  7
   100:                 11,   12,   15,   12, & !  8
   101:                 18,   16,   15,   16, & !  9
   102:                 12,   15,   18,   13, & ! 10
   103:                 12,   15,   18,   13, & ! 11
   104:                 28,   32,   28,   28, & ! 12
   105:                 15,   13,   12,   13, & ! 13
   106:                 14,   14,   16,   14, & ! 14
   107:                 20,   18,   17,   18, & ! 15
   108:                 14,   14,   17,   14, & ! 16
   109:                 15,   15,   18,   15, & ! 17
   110:                 15,   15,   18,   15, & ! 18
   111:                 17,   20,   20,   17, & ! 19
   112:                 17,   20,   20,   17, & ! 20
   113:                 28,   32,   28,   28, & ! 21
   114:                 12,   12,   17,   15, & ! 22
   115:                 14,   15,   17,   15, & ! 23
   116:                 14,   15,   16,   14, & ! 24
   117:                 16,   18,   25,   20, & ! 25
   118:                 17,   17,   20,   17, & ! 26
   119:                 16,   20,   20,   18, & ! 27
   120:                 16,   20,   20,   18, & ! 28
   121:                 16,   20,   20,   18, & ! 29
   122:                 30,   30,   30,   30, & ! 30
   123:                 75,   75,   75,   75, & ! 31
   124:                 16,   18,   20,   18  & ! 32 cultivation
   125:                 /
   126:             
   127:             
   128:               character(*), parameter:: module_name = 'albedo_Matthews'
   129:                                           ! モジュールの名称.
   130:                                           ! Module name
   131:               character(*), parameter:: version = &
   132:                 & '$Name:  $' // &
   133:                 & '$Id: albedo_Matthews.f90,v 1.10 2014/05/07 09:39:23 murashin Exp $'
   134:                                           ! モジュールのバージョン
   135:                                           ! Module version
   136:             
   137:               ! INTERFACE 文 ; INTERFACE statements
   138:               !
   139:             
   140:             contains
   141:             
   142:               !--------------------------------------------------------------------------------------
   143:             
   144:               subroutine SetAlbedoMatthews( xy_SurfType, xy_SurfAlbedo )
   145:             
   146:                 ! モジュール引用 ; USE statements
   147:                 !
   148:             
   149:                 ! 格子点設定
   150:                 ! Grid points settings
   151:                 !
   152:                 use gridset, only: imax, & ! 経度格子点数.
   153:                                            ! Number of grid points in longitude
   154:                   &                jmax, & ! 緯度格子点数.
   155:                                            ! Number of grid points in latitude
   156:                   &                kmax    ! 鉛直層数.
   157:                                            ! Number of vertical level
   158:             
   159:                 ! 日付および時刻の取り扱い
   160:                 ! Date and time handler
   161:                 !
   162:                 use dc_calendar, only: DCCalInquire, DCCalDateEvalSecOfYear
   163:             
   164:                 ! 時刻管理
   165:                 ! Time control
   166:                 !
   167:                 use timeset, only: TimeN, InitialDate
   168:             
   169:                 ! 宣言文 ; Declaration statements
   170:                 !
   171:                 integer , intent(in ) :: xy_SurfType  ( 0:imax-1, 1:jmax )
   172:                                           ! 植生のインデックス
   173:                                           ! Index of vegetation
   174:                 real(DP), intent(out) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
   175:                                           ! 地表アルベド.
   176:                                           ! Surface albedo
   177:             
   178:                 ! 作業変数
   179:                 ! Work variables
   180:                 !
   181:                 real(DP):: SecOfYear
   182:                 real(DP):: a_Data_SOY_Ex( 0:nseason+1 )
   183:                                           ! 各季節の開始時刻 (内挿のために拡張).
   184:                                           ! Start time of each season (extended for interpolation).
   185:                 real(DP):: xya_SurfAlbedoLocal( 0:imax-1, 1:jmax, 1:2 )
   186:                 integer :: i              ! 経度方向に回る DO ループ用作業変数
   187:                                           ! Work variables for DO loop in longitude
   188:                 integer :: j              ! 緯度方向に回る DO ループ用作業変数
   189:                                           ! Work variables for DO loop in latitude
   190:                 integer :: l              ! 季節方向に回る DO ループ用作業変数
   191:                                           ! Work variables for DO loop in season
   192:                 integer :: t
   193:                 integer :: tindex
   194:                 integer :: a_tindex(1:2)
   195:             
   196:                 integer:: hour_in_day, min_in_hour, day_in_year
   197:                 integer, pointer:: day_in_month_ptr(:) => null()
   198:                 real(DP):: sec_in_min, sec_in_day
   199:             
   200:                 ! 実行文 ; Executable statement
   201:                 !
   202:             
   203:                 ! 初期化確認
   204:                 ! Initialization check
   205:                 !
   206:                 if ( .not. albedo_matthews_inited ) then
   207:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   208:                 end if
   209:             
   210:             
   211:                 if ( flag_annual_mean ) then
   212:             
   213:                   !
   214:                   ! Now, annual mean value is used, temporarily.
   215:                   !
   216: W*===== A         xy_SurfAlbedo = 0.0_DP
   217:             
   218: *------>          do l = 1, nseason
   219: |W----->            do j = 1, jmax
   220: ||*---->              do i = 0, imax-1
   221: |||     A               xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j) + aa_Data_Albedo( l, xy_SurfType(i,j) )
   222: ||*----               end do
   223: |W-----             end do
   224: *------           end do
   225:             
   226: +V===== A         xy_SurfAlbedo = xy_SurfAlbedo / dble( nseason )
   227:             
   228:                 else
   229:             
   230:                   SecOfYear = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )
   231:             
   232:                   call DCCalInquire( &
   233:                     & day_in_month_ptr = day_in_month_ptr , & ! (out)
   234:                     & hour_in_day      = hour_in_day  , &     ! (out)
   235:                     & min_in_hour      = min_in_hour  , &     ! (out)
   236:                     & sec_in_min       = sec_in_min )         ! (out)
   237:             
   238: V====== A         day_in_year = sum( day_in_month_ptr )
   239:                   deallocate( day_in_month_ptr )
   240:                   sec_in_day  = hour_in_day * min_in_hour * sec_in_min
   241:             
   242:             
   243:                   if ( SecOfYear > day_in_year * sec_in_day ) SecOfYear = day_in_year * sec_in_day
   244:             
   245:                   a_Data_SOY_Ex(0) = ( 0.0_DP - ( day_in_year - a_Data_DOY(nseason) ) ) * sec_in_day
   246: *------>          do t = 1, nseason
   247: |                   a_Data_SOY_Ex(t) = a_Data_DOY(t) * sec_in_day
   248: *------           end do
   249:                   a_Data_SOY_Ex(nseason+1) = ( day_in_year + a_Data_DOY(1) ) * sec_in_day
   250:             
   251:             
   252:                   a_tindex(1) = 0
   253:                   a_tindex(2) = 1
   254: +------>          do t = 1, nseason
   255: |                   if ( a_Data_DOY(t) * sec_in_day <= SecOfYear ) then
   256: |                     a_tindex(1) = t
   257: |                     a_tindex(2) = t+1
   258: |                   end if
   259: +------           end do
   260:             
   261: +------>          do t = 1, 2
   262: |                   ! for northern hemisphere
   263: |                   tindex = a_tindex(t)
   264: |                   if ( tindex == 0 ) then
   265: |                     tindex = nseason
   266: |                   else if ( tindex == nseason+1 ) then
   267: |                     tindex = 1
   268: |                   else
   269: |                     tindex = tindex
   270: |                   end if
   271: |W----->            do j = jmax/2+1, jmax
   272: ||*---->              do i = 0, imax-1
   273: |||     A               xya_SurfAlbedoLocal(i,j,t) = aa_Data_Albedo( tindex, xy_SurfType(i,j) )
   274: ||*----               end do
   275: |W-----             end do
   276: |                   ! for southern hemisphere
   277: |                   tindex = a_tindex(t) + nseason / 2
   278: |                   if ( tindex > nseason ) tindex = tindex - nseason
   279: |                   if ( tindex == 0 ) then
   280: |                     tindex = nseason
   281: |                   else if ( tindex == nseason+1 ) then
   282: |                     tindex = 1
   283: |                   else
   284: |                     tindex = tindex
   285: |                   end if
   286: |W----->            do j = 1, jmax/2
   287: ||*---->              do i = 0, imax-1
   288: |||     A               xya_SurfAlbedoLocal(i,j,t) = aa_Data_Albedo( tindex, xy_SurfType(i,j) )
   289: ||*----               end do
   290: |W-----             end do
   291: +------           end do
   292:             
   293: W*===== A         xy_SurfAlbedo =                                                   &
   294:                     &   ( xya_SurfAlbedoLocal(:,:,2) - xya_SurfAlbedoLocal(:,:,1) ) &
   295:                     & / ( a_Data_SOY_Ex(a_tindex(2)) - a_Data_SOY_Ex(a_tindex(1)) ) &
   296:                     & * ( SecOfYear                  - a_Data_SOY_Ex(a_tindex(1)) ) &
   297:                     & + xya_SurfAlbedoLocal(:,:,1)
   298:             
   299:                 end if
   300:             
   301:             
   302:               end subroutine SetAlbedoMatthews
   303:             
   304:               !--------------------------------------------------------------------------------------
   305:             
   306:               subroutine ModAlbedoMatthewsCultivation( &
   307:                 & xy_SurfType, xy_SurfCulInt,          &
   308:                 & xy_SurfAlbedo                        &
   309:                 & )
   310:             
   311:                 ! モジュール引用 ; USE statements
   312:                 !
   313:             
   314:                 ! 格子点設定
   315:                 ! Grid points settings
   316:                 !
   317:                 use gridset, only: imax, & ! 経度格子点数.
   318:                                            ! Number of grid points in longitude
   319:                   &                jmax, & ! 緯度格子点数.
   320:                                            ! Number of grid points in latitude
   321:                   &                kmax    ! 鉛直層数.
   322:                                            ! Number of vertical level
   323:             
   324:                 ! 日付および時刻の取り扱い
   325:                 ! Date and time handler
   326:                 !
   327:                 use dc_calendar, only: DCCalInquire, DCCalDateEvalSecOfYear
   328:             
   329:                 ! 時刻管理
   330:                 ! Time control
   331:                 !
   332:                 use timeset, only: TimeN, InitialDate
   333:             
   334:                 ! 宣言文 ; Declaration statements
   335:                 !
   336:                 integer , intent(in   ) :: xy_SurfType  ( 0:imax-1, 1:jmax )
   337:                                           ! 植生のインデックス
   338:                                           ! Index of vegetation
   339:                 real(DP), intent(in   ) :: xy_SurfCulInt( 0:imax-1, 1:jmax )
   340:                                           ! ...
   341:                                           ! Cultivation index
   342:                 real(DP), intent(inout) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
   343:                                           ! 地表アルベド.
   344:                                           ! Surface albedo
   345:             
   346:                 ! 作業変数
   347:                 ! Work variables
   348:                 !
   349:                 real(DP):: SecOfYear
   350:                 real(DP):: a_Data_SOY_Ex( 0:nseason+1 )
   351:                                           ! 各季節の開始時刻 (内挿のために拡張).
   352:                                           ! Start time of each season (extended for interpolation).
   353:                 real(DP):: SurfAlbedoCul
   354:                 real(DP):: xy_SurfAlbedoCul ( 0:imax-1, 1:jmax )
   355:                 real(DP):: xya_SurfAlbedoCul( 0:imax-1, 1:jmax, 1:2 )
   356:                 integer :: i              ! 経度方向に回る DO ループ用作業変数
   357:                                           ! Work variables for DO loop in longitude
   358:                 integer :: j              ! 緯度方向に回る DO ループ用作業変数
   359:                                           ! Work variables for DO loop in latitude
   360:                 integer :: l              ! 季節方向に回る DO ループ用作業変数
   361:                                           ! Work variables for DO loop in season
   362:                 integer :: t
   363:                 integer :: tindex
   364:                 integer :: a_tindex(1:2)
   365:             
   366:                 integer:: hour_in_day, min_in_hour, day_in_year
   367:                 integer, pointer:: day_in_month_ptr(:) => null()
   368:                 real(DP):: sec_in_min, sec_in_day
   369:             
   370:                 ! 実行文 ; Executable statement
   371:                 !
   372:             
   373:                 ! 初期化確認
   374:                 ! Initialization check
   375:                 !
   376:                 if ( .not. albedo_matthews_inited ) then
   377:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   378:                 end if
   379:             
   380:             
   381:                 if ( flag_annual_mean ) then
   382:             
   383:                   !
   384:                   ! Now, annual mean value is used, temporarily.
   385:                   !
   386:                   SurfAlbedoCul = 0.0_DP
   387: *------>          do l = 1, nseason
   388: |                   SurfAlbedoCul = SurfAlbedoCul + aa_Data_Albedo( l, IndexCultivation )
   389: *------           end do
   390:                   SurfAlbedoCul = SurfAlbedoCul / dble( nseason )
   391:             
   392: W------>          do j = 1, jmax
   393: |*----->            do i = 0, imax-1
   394: ||      A             if ( xy_SurfType(i,j) > 0 ) then
   395: ||      A               xy_SurfAlbedo(i,j) =                                       &
   396: ||                        &   ( 1.0_DP - xy_SurfCulInt(i,j) ) * xy_SurfAlbedo(i,j) &
   397: ||                        & + xy_SurfCulInt(i,j)              * SurfAlbedoCul
   398: ||                    end if
   399: |*-----             end do
   400: W------           end do
   401:             
   402:                 else
   403:             
   404:                   SecOfYear = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )
   405:             
   406:                   call DCCalInquire( &
   407:                     & day_in_month_ptr = day_in_month_ptr , & ! (out)
   408:                     & hour_in_day      = hour_in_day  , &     ! (out)
   409:                     & min_in_hour      = min_in_hour  , &     ! (out)
   410:                     & sec_in_min       = sec_in_min )         ! (out)
   411:             
   412: V====== A         day_in_year = sum( day_in_month_ptr )
   413:                   deallocate( day_in_month_ptr )
   414:                   sec_in_day  = hour_in_day * min_in_hour * sec_in_min
   415:             
   416:             
   417:                   if ( SecOfYear > day_in_year * sec_in_day ) SecOfYear = day_in_year * sec_in_day
   418:             
   419:                   a_Data_SOY_Ex(0) = ( 0.0_DP - ( day_in_year - a_Data_DOY(nseason) ) ) * sec_in_day
   420: *------>          do t = 1, nseason
   421: |                   a_Data_SOY_Ex(t) = a_Data_DOY(t) * sec_in_day
   422: *------           end do
   423:                   a_Data_SOY_Ex(nseason+1) = ( day_in_year + a_Data_DOY(1) ) * sec_in_day
   424:             
   425:             
   426:                   a_tindex(1) = 0
   427:                   a_tindex(2) = 1
   428: +------>          do t = 1, nseason
   429: |                   if ( a_Data_DOY(t) * sec_in_day <= SecOfYear ) then
   430: |                     a_tindex(1) = t
   431: |                     a_tindex(2) = t+1
   432: |                   end if
   433: +------           end do
   434:             
   435: +------>          do t = 1, 2
   436: |                   ! for northern hemisphere
   437: |                   tindex = a_tindex(t)
   438: |                   if ( tindex == 0 ) then
   439: |                     tindex = nseason
   440: |                   else if ( tindex == nseason+1 ) then
   441: |                     tindex = 1
   442: |                   else
   443: |                     tindex = tindex
   444: |                   end if
   445: |W----->            do j = jmax/2+1, jmax
   446: ||*---->              do i = 0, imax-1
   447: |||                     xya_SurfAlbedoCul(i,j,t) = aa_Data_Albedo( tindex, IndexCultivation )
   448: ||*----               end do
   449: |W-----             end do
   450: |                   ! for southern hemisphere
   451: |                   tindex = a_tindex(t) + nseason / 2
   452: |                   if ( tindex > nseason ) tindex = tindex - nseason
   453: |                   if ( tindex == 0 ) then
   454: |                     tindex = nseason
   455: |                   else if ( tindex == nseason+1 ) then
   456: |                     tindex = 1
   457: |                   else
   458: |                     tindex = tindex
   459: |                   end if
   460: |W----->            do j = 1, jmax/2
   461: ||*---->              do i = 0, imax-1
   462: |||                     xya_SurfAlbedoCul(i,j,t) = aa_Data_Albedo( tindex, IndexCultivation )
   463: ||*----               end do
   464: |W-----             end do
   465: +------           end do
   466:             
   467: W*=====           xy_SurfAlbedoCul =                                                &
   468:                     &   ( xya_SurfAlbedoCul(:,:,2)   - xya_SurfAlbedoCul(:,:,1)   ) &
   469:                     & / ( a_Data_SOY_Ex(a_tindex(2)) - a_Data_SOY_Ex(a_tindex(1)) ) &
   470:                     & * ( SecOfYear                  - a_Data_SOY_Ex(a_tindex(1)) ) &
   471:                     & + xya_SurfAlbedoCul(:,:,1)
   472:             
   473: W------>          do j = 1, jmax
   474: |*----->            do i = 0, imax-1
   475: ||      A             if ( xy_SurfType(i,j) > 0 ) then
   476: ||      A               xy_SurfAlbedo(i,j) =                                          &
   477: ||                        &   ( 1.0_DP - xy_SurfCulInt(i,j) ) * xy_SurfAlbedo(i,j)    &
   478: ||                        & + xy_SurfCulInt(i,j)              * xy_SurfAlbedoCul(i,j)
   479: ||                    end if
   480: |*-----             end do
   481: W------           end do
   482:             
   483:                 end if
   484:             
   485:             
   486:               end subroutine ModAlbedoMatthewsCultivation
   487:             
   488:               !--------------------------------------------------------------------------------------
   489:             
   490:               subroutine AlbedoMatthewsInit
   491:             
   492:                 ! NAMELIST ファイル入力に関するユーティリティ
   493:                 ! Utilities for NAMELIST file input
   494:                 !
   495:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   496:             
   497:                 ! ファイル入出力補助
   498:                 ! File I/O support
   499:                 !
   500:                 use dc_iounit, only: FileOpen
   501:             
   502:                 ! メッセージ出力
   503:                 ! Message output
   504:                 !
   505:                 use dc_message, only: MessageNotify
   506:             
   507:                 ! 作業変数
   508:                 ! Work variables
   509:                 !
   510:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   511:                                           ! Unit number for NAMELIST file open
   512:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   513:                                           ! IOSTAT of NAMELIST read
   514:             
   515:                 ! NAMELIST 変数群
   516:                 ! NAMELIST group name
   517:                 !
   518:                 namelist /albedo_Matthews_nml/ &
   519:                   & flag_annual_mean, &
   520:                   & OceanAlbedo
   521:                       !
   522:                       ! デフォルト値については初期化手続 "surface_flux_bulk#SurfFluxInit"
   523:                       ! のソースコードを参照のこと.
   524:                       !
   525:                       ! Refer to source codes in the initialization procedure
   526:                       ! "surface_flux_bulk#SurfFluxInit" for the default values.
   527:                       !
   528:             
   529:                 if ( albedo_matthews_inited ) return
   530:             
   531:             
   532:                 ! デフォルト値の設定
   533:                 ! Default values settings
   534:                 !
   535:                 flag_annual_mean = .false.
   536:                 OceanAlbedo      = 0.1_DP
   537:             
   538:             
   539:                 ! NAMELIST の読み込み
   540:                 ! NAMELIST is input
   541:                 !
   542:                 if ( trim(namelist_filename) /= '' ) then
   543:                   call FileOpen( unit_nml, &          ! (out)
   544:                     & namelist_filename, mode = 'r' ) ! (in)
   545:             
   546:                   rewind( unit_nml )
   547:                   read( unit_nml, &                ! (in)
   548:                     & nml = albedo_Matthews_nml, &  ! (out)
   549:                     & iostat = iostat_nml )        ! (out)
   550:                   close( unit_nml )
   551:             
   552:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   553:                 end if
   554:             
   555:             
   556:             
   557: +V===== A       aa_Data_Albedo = aa_Data_Albedo * 1.0e-2_DP
   558:             
   559:             
   560: *======         aa_Data_Albedo(:,0) = OceanAlbedo
   561:             
   562:             
   563:             
   564:                 ! 印字 ; Print
   565:                 !
   566:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   567:                 call MessageNotify( 'M', module_name, '  flag_annual_mean = %b', l = (/ flag_annual_mean /) )
   568:                 call MessageNotify( 'M', module_name, '  OceanAlbedo      = %f', d = (/ OceanAlbedo      /) )
   569:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   570:             
   571:             
   572:                 albedo_matthews_inited = .true.
   573:             
   574:               end subroutine AlbedoMatthewsInit
   575:             
   576:               !--------------------------------------------------------------------------------------
   577:             
   578:             end module albedo_Matthews
