Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: bucket_model.f90
PROGRAM NAME: bucket_model
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   145  opt  (1593): Loop nest collapsed into one loop.
   145  vec  (   1): Vectorized loop.
   145  vec  (  29): ADB is used for array.: xy_flagoceangrid
   145  vec  (  29): ADB is used for array.: xy_surftype
   217  opt  (1593): Loop nest collapsed into one loop.
   217  vec  (   4): Vectorized array expression.
   217  vec  (  29): ADB is used for array.: xy_soilmoista
   217  vec  (  29): ADB is used for array.: xy_dsoilmoistdt
   217  vec  (  29): ADB is used for array.: xy_soilmoistb
   221  opt  (1593): Loop nest collapsed into one loop.
   221  vec  (   1): Vectorized loop.
   221  vec  (  29): ADB is used for array.: xy_soilmoista
   228  opt  (1593): Loop nest collapsed into one loop.
   228  vec  (   4): Vectorized array expression.
   228  vec  (  29): ADB is used for array.: xy_surfsnowa
   228  vec  (  29): ADB is used for array.: xy_dsurfsnowdt
   228  vec  (  29): ADB is used for array.: xy_surfsnowb
   232  opt  (1593): Loop nest collapsed into one loop.
   232  vec  (   1): Vectorized loop.
   232  vec  (  29): ADB is used for array.: xy_surfsnowa
   238  opt  (1593): Loop nest collapsed into one loop.
   238  vec  (   4): Vectorized array expression.
   238  vec  (  29): ADB is used for array.: xy_surfsnowa
   238  vec  (  29): ADB is used for array.: xy_surfsnowb
   244  opt  (1593): Loop nest collapsed into one loop.
   244  vec  (   1): Vectorized loop.
   244  vec  (  29): ADB is used for array.: xy_surfsnowa
   244  vec  (  29): ADB is used for array.: xy_soilmoista
   244  vec  (  29): ADB is used for array.: xy_flagoceangrid
   538  opt  (1593): Loop nest collapsed into one loop.
   538  vec  (   1): Vectorized loop.
   538  vec  (  29): ADB is used for array.: xy_surfsnow
   538  vec  (  29): ADB is used for array.: xy_surfsnowflux
   538  vec  (  29): ADB is used for array.: xy_soilmoist
   538  vec  (  29): ADB is used for array.: xy_surfrainflux
   552  opt  (1593): Loop nest collapsed into one loop.
   552  vec  (   4): Vectorized array expression.
   552  vec  (  29): ADB is used for array.: xy_soilmoist
   552  vec  (  29): ADB is used for array.: xy_surfsnowflux
   552  vec  (  29): ADB is used for array.: xy_surfrainflux
   558  opt  (1772): Loop nest fused with following nest(s).
   558  opt  (1593): Loop nest collapsed into one loop.
   558  vec  (   1): Vectorized loop.
   558  vec  (  29): ADB is used for array.: xy_surfsnow
   558  vec  (  29): ADB is used for array.: xy_soilmoist
   558  vec  (  29): ADB is used for array.: xy_flagoceangrid
   636  opt  (1593): Loop nest collapsed into one loop.
   636  vec  (   1): Vectorized loop.
   636  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   636  vec  (  29): ADB is used for array.: xy_soilmoist
   636  vec  (  29): ADB is used for array.: xy_surfsnow
   636  vec  (  29): ADB is used for array.: xy_flagoceangrid
   650  opt  (1593): Loop nest collapsed into one loop.
   650  vec  (   1): Vectorized loop.
   650  vec  (  29): ADB is used for array.: xy_surfhumidcoef
   650  vec  (  29): ADB is used for array.: xy_soilmoist
   650  vec  (  29): ADB is used for array.: xy_flagoceangrid
   735  opt  (1593): Loop nest collapsed into one loop.
   735  vec  (   1): Vectorized loop.
   735  vec  (  29): ADB is used for array.: xy_surflatentheatflux
   735  vec  (  29): ADB is used for array.: xy_surfevapflux
   735  vec  (  29): ADB is used for array.: xy_surfsnow
   735  vec  (  29): ADB is used for array.: xy_soilmoist
   735  vec  (  29): ADB is used for array.: xy_flagoceangrid
   784  opt  (1593): Loop nest collapsed into one loop.
   784  vec  (   1): Vectorized loop.
   784  vec  (  29): ADB is used for array.: xy_surflatentheatflux
   784  vec  (  29): ADB is used for array.: xy_surfevapflux
   784  vec  (  29): ADB is used for array.: xy_soilmoist
   784  vec  (  29): ADB is used for array.: xy_flagoceangrid
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: bucket_model.f90
PROGRAM NAME: bucket_model
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != バケツモデル
     2  !
     3  != Bucket model
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: bucket_model.f90,v 1.16 2015/01/29 12:07:59 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module Bucket_Model
    13  
    14    ! モジュール引用 ; USE statements
    15    !
    16  
    17  
    18    ! 種別型パラメタ
    19    ! Kind type parameter
    20    !
    21    use dc_types, only: DP      ! 倍精度実数型. Double precision.
    22  
    23    ! メッセージ出力
    24    ! Message output
    25    !
    26    use dc_message, only: MessageNotify
    27  
    28    ! 宣言文 ; Declaration statements
    29    !
    30    implicit none
    31    private
    32  
    33    logical, save :: bucket_model_inited = .false.
    34                                ! 初期設定フラグ.
    35                                ! Initialization flag
    36  
    37  
    38    logical, save :: FlagSnow   ! 雪の扱い オン／オフ.
    39                                ! treatment of snow on/off.
    40  
    41    ! 公開手続き
    42    ! Public procedure
    43    !
    44    public :: BucketSetFlagOceanFromMatthews
    45  !!$  public :: BucketEvap
    46  !!$  public :: BucketEvapAdjust
    47    public :: BucketIntegration
    48    public :: BucketPRCPAdjust
    49    public :: BucketModHumidCoef
    50    public :: BucketModEvapAndLatentHeatFlux
    51    public :: BucketGetSoilMoistCritAmnt
    52    public :: BucketModelInit
    53  
    54  
    55    ! 非公開変数
    56    ! Private variables
    57    !
    58    real(DP), save:: SoilMoistCritAmnt
    59                          ! 土壌水分量の上限値
    60                          ! Critical amount of soil moisture
    61    real(DP), save:: SoilMoistCritAmntforEvapEff
    62                          ! 地表湿潤度を 1 とする閾値
    63                          ! Critical amount of soil moisture for evaporation efficiency
    64  
    65    real(DP), save:: SoilMoistMeaningLess = -1.0d0
    66                          ! 海洋条件の場合に使用する物理的には意味のない変数
    67                          ! Meaning less value for soil moisture on the ocean
    68  
    69    real(DP), save:: HumidCoefSnowThreshold = 1.0d-50
    70                          !
    71                          ! Threshold of surface snow amount for surface humid coefficient determination
    72  
    73    character(*), parameter:: module_name = 'bucket_model'
    74                                ! モジュールの名称.
    75                                ! Module name
    76    character(*), parameter:: version = &
    77      & '$Name:  $' // &
    78      & '$Id: bucket_model.f90,v 1.16 2015/01/29 12:07:59 yot Exp $'
    79                                ! モジュールのバージョン
    80                                ! Module version
    81  
    82  contains
    83  
    84    !--------------------------------------------------------------------------------------
    85  
    86    subroutine BucketSetFlagOceanFromMatthews( &
    87      & xy_SurfType,                           & ! (in)
    88      & xy_FlagOceanGrid                       & ! (out)
    89      & )
    90      !
    91      !
    92      !
    93      ! Set flagx for ocean grid point from Matthews' index
    94      !
    95  
    96      ! モジュール引用 ; USE statements
    97      !
    98  
    99      ! 格子点設定
   100      ! Grid points settings
   101      !
   102      use gridset, only: imax, & ! 経度格子点数.
   103                                 ! Number of grid points in longitude
   104        &                jmax, & ! 緯度格子点数.
   105                                 ! Number of grid points in latitude
   106        &                kmax    ! 鉛直層数.
   107                                 ! Number of vertical level
   108  
   109      ! 宣言文 ; Declaration statements
   110      !
   111      implicit none
   112  
   113      integer , intent(in ) :: xy_SurfType     (0:imax-1, 1:jmax)
   114                                ! 土地利用
   115                                ! Surface index
   116      logical , intent(out) :: xy_FlagOceanGrid(0:imax-1, 1:jmax)
   117                                !
   118                                ! Flag for ocean grid
   119  
   120  
   121      ! 作業変数
   122      ! Work variables
   123      !
   124  
   125      integer:: i               ! 経度方向に回る DO ループ用作業変数
   126                                ! Work variables for DO loop in longitude
   127      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   128                                ! Work variables for DO loop in latitude
   129  
   130  
   131      ! 実行文 ; Executable statement
   132      !
   133  
   134      ! 初期化確認
   135      ! Initialization check
   136      !
   137      if ( .not. bucket_model_inited ) then
   138        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   139      end if
   140  
   141  
   142      !
   143      ! Set index for calculation method
   144      !
   145      do j = 1, jmax
   146        do i = 0, imax-1
   147          if ( xy_SurfType(i,j) == 0 ) then
   148            ! ocean
   149            xy_FlagOceanGrid(i,j) = .true.
   150          else
   151            ! land
   152            xy_FlagOceanGrid(i,j) = .false.
   153          end if
   154        end do
   155      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .eq. 0) then                            
     .              xy_flagoceangrid1 = 1                                       
     .           else                                                           
     .              xy_flagoceangrid1 = 0                                       
     .           endif                                                          
     .           xy_flagoceangrid(j-1,1) = xy_flagoceangrid1                    
     .        enddo                                                             
   156  
   157  
   158    end subroutine BucketSetFlagOceanFromMatthews
   159  
   160    !--------------------------------------------------------------------------------------
   161  
   162    subroutine BucketIntegration(        &
   163      & xy_FlagOceanGrid,                & ! (in )
   164      & xy_DSoilMoistDt, xy_DSurfSnowDt, & ! (in )
   165      & xy_SoilMoistB, xy_SurfSnowB,     & ! (in )
   166      & xy_SoilMoistA, xy_SurfSnowA      & ! (out)
   167      & )
   168  
   169      ! 時刻管理
   170      ! Time control
   171      !
   172      use timeset, only: &
   173        & DelTime, &             ! $ \Delta t $ [s]
   174        & TimesetClockStart, TimesetClockStop
   175  
   176      ! 格子点設定
   177      ! Grid points settings
   178      !
   179      use gridset, only: imax, & ! 経度格子点数.
   180                                 ! Number of grid points in longitude
   181        &                jmax, & ! 緯度格子点数.
   182                                 ! Number of grid points in latitude
   183        &                kmax    ! 鉛直層数.
   184                                 ! Number of vertical level
   185  
   186      logical , intent(in ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   187      real(DP), intent(in ) :: xy_DSoilMoistDt ( 0:imax-1, 1:jmax )
   188      real(DP), intent(in ) :: xy_DSurfSnowDt  ( 0:imax-1, 1:jmax )
   189      real(DP), intent(in ) :: xy_SoilMoistB   ( 0:imax-1, 1:jmax )
   190      real(DP), intent(in ) :: xy_SurfSnowB    ( 0:imax-1, 1:jmax )
   191      real(DP), intent(out) :: xy_SoilMoistA   ( 0:imax-1, 1:jmax )
   192      real(DP), intent(out) :: xy_SurfSnowA    ( 0:imax-1, 1:jmax )
   193  
   194      ! 作業変数
   195      ! Work variables
   196      !
   197      integer:: i               ! 経度方向に回る DO ループ用作業変数
   198                                ! Work variables for DO loop in longitude
   199      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   200                                ! Work variables for DO loop in latitude
   201  
   202  
   203      ! 初期化確認
   204      ! Initialization check
   205      !
   206      if ( .not. bucket_model_inited ) then
   207        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   208      end if
   209  
   210  
   211      ! 計算時間計測開始
   212      ! Start measurement of computation time
   213      !
   214      call TimesetClockStart( module_name )
   215  
   216  
   217      xy_SoilMoistA = xy_SoilMoistB + xy_DSoilMoistDt * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t176 = 1, jmax*imax                                            
     .           xy_soilmoista(t176-1,1) = xy_soilmoistb(t176-1,1) +            
     .       1      xy_dsoilmoistdt(t176-1,1)*2.00000000000000e+000*deltime     
     .        enddo                                                             
   218  
   219      ! Remove negative values
   220      !
   221      do j = 1, jmax
   222        do i = 0, imax-1
   223          if( xy_SoilMoistA(i,j) < 0.0_DP ) xy_SoilMoistA(i,j) = 0.0_DP
   224        end do
   225      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_soilmoista(j-1,1) .lt. 0.0000000000000000e+000) then    
     .              xy_soilmoista(j-1,1) = 0.0000000000000000e+000              
     .           endif                                                          
     .        enddo                                                             
   226  
   227      if ( FlagSnow ) then
   228        xy_SurfSnowA = xy_SurfSnowB + xy_DSurfSnowDt * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t194 = 1, jmax*imax                                            
     .           xy_surfsnowa(t194-1,1) = xy_surfsnowb(t194-1,1) +              
     .       1      xy_dsurfsnowdt(t194-1,1)*2.00000000000000e+000*deltime      
     .        enddo                                                             
   229  
   230        ! Remove negative values
   231        !
   232        do j = 1, jmax
   233          do i = 0, imax-1
   234            if( xy_SurfSnowA (i,j) < 0.0_DP ) xy_SurfSnowA (i,j) = 0.0_DP
   235          end do
   236        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surfsnowa(j-1,1) .lt. 0.0000000000000000e+000) then     
     .              xy_surfsnowa(j-1,1) = 0.0000000000000000e+000               
     .           endif                                                          
     .        enddo                                                             
     .        goto 10020                                                        
   237      else
   238        xy_SurfSnowA = xy_SurfSnowB
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t186 = 1, jmax*imax                                            
     .           xy_surfsnowa(t186-1,1) = xy_surfsnowb(t186-1,1)                
     .        enddo                                                             
   239      end if
   240  
   241  
   242      ! Fill meaningless value in ocean grid
   243      !
   244      do j = 1, jmax
   245        do i = 0, imax-1
   246          if ( xy_FlagOceanGrid(i,j) ) then
   247            xy_SoilMoistA(i,j) = SoilMoistMeaningLess
   248            xy_SurfSnowA(i,j)  = SoilMoistMeaningLess
   249          end if
   250        end do
   251      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_flagoceangrid(j-1,1) .ne. 0) then                       
     .              xy_soilmoista(j-1,1) = soilmoistmeaningless                 
     .              xy_surfsnowa(j-1,1) = soilmoistmeaningless                  
     .           endif                                                          
     .        enddo                                                             
   252  
   253  
   254      ! 計算時間計測一時停止
   255      ! Pause measurement of computation time
   256      !
   257      call TimesetClockStop( module_name )
   258  
   259  
   260    end subroutine BucketIntegration
   261  
   262    !--------------------------------------------------------------------------------------
   263  !!$
   264  !!$  ! This is wrong under the condition that water vapor flux is negative (transported
   265  !!$  ! downward). (2011/12/17, yot)
   266  !!$
   267  !!$  subroutine BucketEvap(                 &
   268  !!$    & xy_FlagOceanGrid, xy_SurfEvapFlux, & ! (in )
   269  !!$    & xy_SoilMoistB, xy_SurfSnowB,       & ! (in )
   270  !!$    & xy_SoilMoistA, xy_SurfSnowA        & ! (out)
   271  !!$    )
   272  !!$
   273  !!$    ! 時刻管理
   274  !!$    ! Time control
   275  !!$    !
   276  !!$    use timeset, only: &
   277  !!$      & DelTime, &             ! $ \Delta t $ [s]
   278  !!$      & TimesetClockStart, TimesetClockStop
   279  !!$
   280  !!$    ! 格子点設定
   281  !!$    ! Grid points settings
   282  !!$    !
   283  !!$    use gridset, only: imax, & ! 経度格子点数.
   284  !!$                               ! Number of grid points in longitude
   285  !!$      &                jmax, & ! 緯度格子点数.
   286  !!$                               ! Number of grid points in latitude
   287  !!$      &                kmax    ! 鉛直層数.
   288  !!$                               ! Number of vertical level
   289  !!$
   290  !!$    ! 雪と海氷の定数の設定
   291  !!$    ! Setting constants of snow and sea ice
   292  !!$    !
   293  !!$    use constants_snowseaice, only: &
   294  !!$      & ThresholdSurfSnow,          &
   295  !!$      & TempCondWater
   296  !!$
   297  !!$    logical , intent(in ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   298  !!$    real(DP), intent(in ) :: xy_SurfEvapFlux ( 0:imax-1, 1:jmax )
   299  !!$    real(DP), intent(in ) :: xy_SoilMoistB   ( 0:imax-1, 1:jmax )
   300  !!$    real(DP), intent(in ) :: xy_SurfSnowB    ( 0:imax-1, 1:jmax )
   301  !!$    real(DP), intent(out) :: xy_SoilMoistA   ( 0:imax-1, 1:jmax )
   302  !!$    real(DP), intent(out) :: xy_SurfSnowA    ( 0:imax-1, 1:jmax )
   303  !!$
   304  !!$    ! 作業変数
   305  !!$    ! Work variables
   306  !!$    !
   307  !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   308  !!$                              ! Work variables for DO loop in longitude
   309  !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   310  !!$                              ! Work variables for DO loop in latitude
   311  !!$
   312  !!$
   313  !!$    ! 初期化確認
   314  !!$    ! Initialization check
   315  !!$    !
   316  !!$    if ( .not. bucket_model_inited ) then
   317  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   318  !!$    end if
   319  !!$
   320  !!$
   321  !!$    ! 計算時間計測開始
   322  !!$    ! Start measurement of computation time
   323  !!$    !
   324  !!$    call TimesetClockStart( module_name )
   325  !!$
   326  !!$
   327  !!$    if ( .not. FlagBucketModel ) then
   328  !!$      xy_SoilMoistA = xy_SoilMoistB
   329  !!$      xy_SurfSnowA  = xy_SurfSnowB
   330  !!$      return
   331  !!$    end if
   332  !!$
   333  !!$
   334  !!$    if ( FlagBucketModelSnow ) then
   335  !!$
   336  !!$      ! Evaporation is subtracted from surface snow and soil moisture
   337  !!$      !
   338  !!$      xy_SurfSnowA = xy_SurfSnowB - xy_SurfEvapFlux * 2.0d0 * DelTime
   339  !!$      do j = 1, jmax
   340  !!$        do i = 0, imax-1
   341  !!$          if ( xy_SurfSnowA(i,j) < 0.0d0 ) then
   342  !!$            xy_SoilMoistA(i,j) = xy_SoilMoistB(i,j) + xy_SurfSnowA(i,j)
   343  !!$            xy_SurfSnowA (i,j) = 0.0d0
   344  !!$          else
   345  !!$            xy_SoilMoistA(i,j) = xy_SoilMoistB(i,j)
   346  !!$          end if
   347  !!$        end do
   348  !!$      end do
   349  !!$    else
   350  !!$      ! Evaporation is subtracted from soil moisture
   351  !!$      !
   352  !!$      xy_SoilMoistA = xy_SoilMoistB - xy_SurfEvapFlux * 2.0d0 * DelTime
   353  !!$      xy_SurfSnowA  = xy_SurfSnowB
   354  !!$    end if
   355  !!$
   356  !!$    ! Remove negative values
   357  !!$    !
   358  !!$    do j = 1, jmax
   359  !!$      do i = 0, imax-1
   360  !!$        if( xy_SoilMoistA(i,j) < 0.0d0 ) xy_SoilMoistA(i,j) = 0.0d0
   361  !!$        if( xy_SurfSnowA (i,j) < 0.0d0 ) xy_SurfSnowA (i,j) = 0.0d0
   362  !!$      end do
   363  !!$    end do
   364  !!$
   365  !!$    ! Fill meaningless value in ocean grid
   366  !!$    !
   367  !!$    do j = 1, jmax
   368  !!$      do i = 0, imax-1
   369  !!$        if ( xy_FlagOceanGrid(i,j) ) then
   370  !!$          xy_SoilMoistA(i,j) = SoilMoistMeaningLess
   371  !!$          xy_SurfSnowA(i,j)  = SoilMoistMeaningLess
   372  !!$        end if
   373  !!$      end do
   374  !!$    end do
   375  !!$
   376  !!$    ! 計算時間計測一時停止
   377  !!$    ! Pause measurement of computation time
   378  !!$    !
   379  !!$    call TimesetClockStop( module_name )
   380  !!$
   381  !!$
   382  !!$  end subroutine BucketEvap
   383  !!$
   384  !!$  !--------------------------------------------------------------------------------------
   385  !!$
   386  !!$  subroutine BucketEvapAdjust(           &
   387  !!$    & xy_FlagOceanGrid, xy_SurfEvapFlux, & ! (in   )
   388  !!$    & xy_SoilMoist, xy_SurfSnow          & ! (inout)
   389  !!$    )
   390  !!$
   391  !!$    ! 格子点設定
   392  !!$    ! Grid points settings
   393  !!$    !
   394  !!$    use gridset, only: imax, & ! 経度格子点数.
   395  !!$                               ! Number of grid points in longitude
   396  !!$      &                jmax, & ! 緯度格子点数.
   397  !!$                               ! Number of grid points in latitude
   398  !!$      &                kmax    ! 鉛直層数.
   399  !!$                               ! Number of vertical level
   400  !!$
   401  !!$    logical , intent(in   ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   402  !!$    real(DP), intent(in   ) :: xy_SurfEvapFlux ( 0:imax-1, 1:jmax )
   403  !!$    real(DP), intent(inout) :: xy_SoilMoist    ( 0:imax-1, 1:jmax )
   404  !!$    real(DP), intent(inout) :: xy_SurfSnow     ( 0:imax-1, 1:jmax )
   405  !!$
   406  !!$    ! 作業変数
   407  !!$    ! Work variables
   408  !!$    !
   409  !!$    real(DP) :: xy_SoilMoistB( 0:imax-1, 1:jmax )
   410  !!$    real(DP) :: xy_SurfSnowB ( 0:imax-1, 1:jmax )
   411  !!$    real(DP) :: xy_SoilMoistA( 0:imax-1, 1:jmax )
   412  !!$    real(DP) :: xy_SurfSnowA ( 0:imax-1, 1:jmax )
   413  !!$
   414  !!$
   415  !!$    ! 初期化確認
   416  !!$    ! Initialization check
   417  !!$    !
   418  !!$    if ( .not. bucket_model_inited ) then
   419  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   420  !!$    end if
   421  !!$
   422  !!$
   423  !!$    xy_SoilMoistB = xy_SoilMoist
   424  !!$    xy_SurfSnowB  = xy_SurfSnow
   425  !!$
   426  !!$    call BucketEvap(                       &
   427  !!$      & xy_FlagOceanGrid, xy_SurfEvapFlux, & ! (in )
   428  !!$      & xy_SoilMoistB, xy_SurfSnowB,       & ! (in )
   429  !!$      & xy_SoilMoistA, xy_SurfSnowA        & ! (out)
   430  !!$      )
   431  !!$
   432  !!$    xy_SoilMoist = xy_SoilMoistA
   433  !!$    xy_SurfSnow  = xy_SurfSnowA
   434  !!$
   435  !!$
   436  !!$  end subroutine BucketEvapAdjust
   437  !!$
   438    !--------------------------------------------------------------------------------------
   439  
   440    subroutine BucketPRCPAdjust(                            &
   441      & xy_FlagOceanGrid, xy_SurfRainFlux, xy_SurfSnowFlux, &  ! (in )
   442      & xy_SoilMoist, xy_SurfSnow                           &  ! (inout)
   443      & )
   444  
   445      ! ヒストリデータ出力
   446      ! History data output
   447      !
   448      use gtool_historyauto, only: HistoryAutoPut
   449  
   450      ! 物理定数設定
   451      ! Physical constants settings
   452      !
   453      use constants, only:  &
   454        & CpDry,            &
   455                                ! $ C_p $ [J kg-1 K-1].
   456                                ! 乾燥大気の定圧比熱.
   457                                ! Specific heat of air at constant pressure
   458        & Grav,             &
   459                                ! $ g $ [m s-2].
   460                                ! 重力加速度.
   461                                ! Gravitational acceleration
   462        & LatentHeat,       &
   463                                ! $ L $ [J kg-1] .
   464                                ! 凝結の潜熱.
   465                                ! Latent heat of condensation
   466        & LatentHeatFusion
   467                                ! $ L $ [J kg-1] .
   468                                ! 融解の潜熱.
   469                                ! Latent heat of fusion
   470  
   471      ! 時刻管理
   472      ! Time control
   473      !
   474      use timeset, only: &
   475        & TimeN,   &             ! ステップ $ t $ の時刻. Time of step $ t $.
   476        & DelTime, &             ! $ \Delta t $ [s]
   477        & TimesetClockStart, TimesetClockStop
   478  
   479      ! 格子点設定
   480      ! Grid points settings
   481      !
   482      use gridset, only: imax, & ! 経度格子点数.
   483                                 ! Number of grid points in longitude
   484        &                jmax, & ! 緯度格子点数.
   485                                 ! Number of grid points in latitude
   486        &                kmax    ! 鉛直層数.
   487                                 ! Number of vertical level
   488  
   489      ! 座標データ設定
   490      ! Axes data settings
   491      !
   492      use axesset, only: &
   493        & z_DelSigma
   494                                ! $ \Delta \sigma $ (整数).
   495                                ! $ \Delta \sigma $ (Full)
   496  
   497      logical , intent(in   ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   498      real(DP), intent(in   ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   499      real(DP), intent(in   ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   500      real(DP), intent(inout) :: xy_SoilMoist    ( 0:imax-1, 1:jmax )
   501      real(DP), intent(inout) :: xy_SurfSnow     ( 0:imax-1, 1:jmax )
   502  
   503  
   504      ! 作業変数
   505      ! Work variables
   506      !
   507  !!$    real(DP) :: xy_TempIncByFusion( 0:imax-1, 1:jmax )
   508  !!$                              ! Temperature increase by fusion
   509  
   510      integer:: i               ! 経度方向に回る DO ループ用作業変数
   511                                ! Work variables for DO loop in longitude
   512      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   513                                ! Work variables for DO loop in latitude
   514  
   515  
   516      ! 初期化確認
   517      ! Initialization check
   518      !
   519      if ( .not. bucket_model_inited ) then
   520        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   521      end if
   522  
   523  
   524      ! 計算時間計測開始
   525      ! Start measurement of computation time
   526      !
   527      call TimesetClockStart( module_name )
   528  
   529  
   530  !!$    ! Initialize an array for temperature increase by fusion
   531  !!$    !
   532  !!$    xy_TempIncByFusion = 0.0d0
   533  
   534  
   535      if ( FlagSnow ) then
   536        ! Precipitation is added to soil moisture or surface snow
   537        !
   538        do j = 1, jmax
   539          do i = 0, imax-1
   540  
   541            xy_SoilMoist(i,j) = xy_SoilMoist(i,j) &
   542              & + xy_SurfRainFlux(i,j) * 2.0_DP * DelTime
   543            xy_SurfSnow (i,j) = xy_SurfSnow (i,j) &
   544              & + xy_SurfSnowFlux(i,j) * 2.0_DP * DelTime
   545  
   546          end do
   547        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xy_soilmoist(j-1,1) = xy_soilmoist(j-1,1) + (                  
     .       1      2.00000000000000e+000*deltime)*xy_surfrainflux(j-1,1)       
     .           xy_surfsnow(j-1,1) = xy_surfsnow(j-1,1) + (                    
     .       1      2.00000000000000e+000*deltime)*xy_surfsnowflux(j-1,1)       
     .        enddo                                                             
     .        goto 10009                                                        
   548      else
   549        ! Precipitation is added to soil moisture
   550        !
   551  !!$      xy_SoilMoist = xy_SoilMoist + xy_SurfPRCPFlux * 2.0d0 * DelTime
   552        xy_SoilMoist = xy_SoilMoist &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t165 = 1, jmax*imax                                            
     .           xy_soilmoist(t165-1,1) = xy_soilmoist(t165-1,1) + (            
     .       1      xy_surfrainflux(t165-1,1)+xy_surfsnowflux(t165-1,1))*       
     .       2      2.00000000000000e+000*deltime                               
     .        enddo                                                             
   553          & + ( xy_SurfRainFlux + xy_SurfSnowFlux ) * 2.0_DP * DelTime
   554      end if
   555  
   556      ! Calculation of Run-off
   557      !
   558      do j = 1, jmax
   559        do i = 0, imax-1
   560          if ( xy_SoilMoist(i,j) > SoilMoistCritAmnt ) &
   561            & xy_SoilMoist(i,j) = SoilMoistCritAmnt
   562        end do
   563      end do
   564  
   565      ! Fill meaningless value in ocean grid
   566      !
   567      do j = 1, jmax
   568        do i = 0, imax-1
   569          if ( xy_FlagOceanGrid(i,j) ) then
   570            xy_SoilMoist(i,j) = SoilMoistMeaningLess
   571            xy_SurfSnow (i,j) = SoilMoistMeaningLess
   572          end if
   573        end do
   574      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_soilmoist(j-1,1) .gt. soilmoistcritamnt) then           
     .              xy_soilmoist(j-1,1) = soilmoistcritamnt                     
     .           endif                                                          
     .           if (xy_flagoceangrid(j-1,1) .ne. 0) then                       
     .              xy_soilmoist(j-1,1) = soilmoistmeaningless                  
     .              xy_surfsnow(j-1,1) = soilmoistmeaningless                   
     .           endif                                                          
     .        enddo                                                             
   575  
   576      ! ヒストリデータ出力
   577      ! History data output
   578      !
   579  !!$    call HistoryAutoPut( TimeN, 'TempIncByFusion' , xy_TempIncByFusion )
   580  
   581      ! 計算時間計測一時停止
   582      ! Pause measurement of computation time
   583      !
   584      call TimesetClockStop( module_name )
   585  
   586    end subroutine BucketPRCPAdjust
   587  
   588    !--------------------------------------------------------------------------------------
   589  
   590    subroutine BucketModHumidCoef(                   &
   591      & xy_FlagOceanGrid, xy_SoilMoist, xy_SurfSnow, & ! (in   )
   592      & xy_SurfHumidCoef                             & ! (inout)
   593      & )
   594  
   595      ! 時刻管理
   596      ! Time control
   597      !
   598      use timeset, only: &
   599        & DelTime            ! $ \Delta t $ [s]
   600  
   601      ! 格子点設定
   602      ! Grid points settings
   603      !
   604      use gridset, only: imax, & ! 経度格子点数.
   605                                 ! Number of grid points in longitude
   606        &                jmax, & ! 緯度格子点数.
   607                                 ! Number of grid points in latitude
   608        &                kmax    ! 鉛直層数.
   609                                 ! Number of vertical level
   610  
   611      logical , intent(in   ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   612      real(DP), intent(in   ) :: xy_SoilMoist    ( 0:imax-1, 1:jmax )
   613      real(DP), intent(in   ) :: xy_SurfSnow     ( 0:imax-1, 1:jmax )
   614      real(DP), intent(inout) :: xy_SurfHumidCoef( 0:imax-1, 1:jmax )
   615  
   616  
   617      ! 作業変数
   618      ! Work variables
   619      !
   620      integer:: i               ! 経度方向に回る DO ループ用作業変数
   621                                ! Work variables for DO loop in longitude
   622      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   623                                ! Work variables for DO loop in latitude
   624  
   625      ! 初期化確認
   626      ! Initialization check
   627      !
   628      if ( .not. bucket_model_inited ) then
   629        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   630      end if
   631  
   632  
   633      ! Surface humidity coefficient is modified.
   634      !
   635      if ( FlagSnow ) then
   636        do j = 1, jmax
   637          do i = 0, imax-1
   638            if ( xy_FlagOceanGrid(i,j) ) then
   639              xy_SurfHumidCoef(i,j) = xy_SurfHumidCoef(i,j)
   640  !!$          else if ( xy_SurfSnow(i,j) > ThresholdSurfSnow ) then
   641            else if ( xy_SurfSnow(i,j) > HumidCoefSnowThreshold ) then
   642              xy_SurfHumidCoef(i,j) = 1.0_DP
   643            else
   644              xy_SurfHumidCoef(i,j) = xy_SoilMoist(i,j) / SoilMoistCritAmntforEvapEff
   645              if ( xy_SurfHumidCoef(i,j) > 1.0_DP ) xy_SurfHumidCoef(i,j) = 1.0_DP
   646            end if
   647          end do
   648        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (.not.xy_flagoceangrid(j-1,1).ne.0) then                    
     .              if (xy_surfsnow(j-1,1) .gt. humidcoefsnowthreshold) then    
     .                 xy_surfhumidcoef(j-1,1) = 1.00000000000000e+000          
     .              else                                                        
     .                 xy_surfhumidcoef(j-1,1) = xy_soilmoist(j-1,1)/           
     .       1            soilmoistcritamntforevapeff                           
     .                 if (xy_surfhumidcoef(j-1,1) .gt. 1.00000000000000e+000)  
     .       1            then                                                  
     .                    xy_surfhumidcoef(j-1,1) = 1.00000000000000e+000       
     .                 endif                                                    
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
     .        goto 10008                                                        
   649      else
   650        do j = 1, jmax
   651          do i = 0, imax-1
   652            if ( xy_FlagOceanGrid(i,j) ) then
   653              xy_SurfHumidCoef(i,j) = xy_SurfHumidCoef(i,j)
   654            else
   655              xy_SurfHumidCoef(i,j) = xy_SoilMoist(i,j) / SoilMoistCritAmntforEvapEff
   656              if ( xy_SurfHumidCoef(i,j) > 1.0_DP ) xy_SurfHumidCoef(i,j) = 1.0_DP
   657            end if
   658          end do
   659        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (.not.xy_flagoceangrid(j-1,1).ne.0) then                    
     .              xy_surfhumidcoef(j-1,1) = xy_soilmoist(j-1,1)/              
     .       1         soilmoistcritamntforevapeff                              
     .              if (xy_surfhumidcoef(j-1,1) .gt. 1.00000000000000e+000) then
     .                 xy_surfhumidcoef(j-1,1) = 1.00000000000000e+000          
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   660      end if
   661  
   662  
   663    end subroutine BucketModHumidCoef
   664  
   665    !--------------------------------------------------------------------------------------
   666  
   667    subroutine BucketModEvapAndLatentHeatFlux(       &
   668      & xy_FlagOceanGrid, xy_SoilMoist, xy_SurfSnow, & ! (in   )
   669      & xy_SurfEvapFlux, xy_SurfLatentHeatFlux       & ! (inout)
   670      & )
   671  
   672      ! 時刻管理
   673      ! Time control
   674      !
   675      use timeset, only: &
   676        & DelTime, &             ! $ \Delta t $ [s]
   677        & TimesetClockStart, TimesetClockStop
   678  
   679      ! 格子点設定
   680      ! Grid points settings
   681      !
   682      use gridset, only: imax, & ! 経度格子点数.
   683                                 ! Number of grid points in longitude
   684        &                jmax, & ! 緯度格子点数.
   685                                 ! Number of grid points in latitude
   686        &                kmax    ! 鉛直層数.
   687                                 ! Number of vertical level
   688  
   689      ! 物理定数設定
   690      ! Physical constants settings
   691      !
   692      use constants, only:  &
   693        & LatentHeat,       &
   694                                ! $ L $ [J kg-1] .
   695                                ! 凝結の潜熱.
   696                                ! Latent heat of condensation
   697        & LatentHeatFusion
   698                                ! $ L $ [J kg-1] .
   699                                ! 融解の潜熱.
   700                                ! Latent heat of fusion
   701  
   702      logical , intent(in   ) :: xy_FlagOceanGrid     ( 0:imax-1, 1:jmax )
   703      real(DP), intent(in   ) :: xy_SoilMoist         ( 0:imax-1, 1:jmax )
   704      real(DP), intent(in   ) :: xy_SurfSnow          ( 0:imax-1, 1:jmax )
   705      real(DP), intent(inout) :: xy_SurfEvapFlux      ( 0:imax-1, 1:jmax )
   706      real(DP), intent(inout) :: xy_SurfLatentHeatFlux( 0:imax-1, 1:jmax )
   707  
   708  
   709      ! 作業変数
   710      ! Work variables
   711      !
   712      integer:: i               ! 経度方向に回る DO ループ用作業変数
   713                                ! Work variables for DO loop in longitude
   714      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   715                                ! Work variables for DO loop in latitude
   716  
   717  
   718      ! 初期化確認
   719      ! Initialization check
   720      !
   721      if ( .not. bucket_model_inited ) then
   722        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   723      end if
   724  
   725  
   726      ! 計算時間計測開始
   727      ! Start measurement of computation time
   728      !
   729      call TimesetClockStart( module_name )
   730  
   731  
   732      if ( FlagSnow ) then
   733        ! Surface water vapor flux is limited up to the water and snow amount on land.
   734        !
   735        do j = 1, jmax
   736          do i = 0, imax-1
   737  
   738            if ( .not. xy_FlagOceanGrid(i,j)  ) then
   739              if ( xy_SurfEvapFlux(i,j) > 0.0_DP ) then
   740                ! Water vapor flux is positive (transported upward).
   741  
   742                if ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime >           &
   743                  &     xy_SoilMoist(i,j) + xy_SurfSnow(i,j)          ) then
   744                  ! All snow and all water is evaporated.
   745                  xy_SurfEvapFlux(i,j) = &
   746                    & ( xy_SoilMoist(i,j) + xy_SurfSnow(i,j) ) / ( 2.0_DP * DelTime )
   747                  xy_SurfLatentHeatFlux(i,j) =                                    &
   748                    & (                                                           &
   749                    &     LatentHeat                        * xy_SoilMoist(i,j)   &
   750                    &   + ( LatentHeat + LatentHeatFusion ) * xy_SurfSnow(i,j)    &
   751                    & )                                                           &
   752                    & / ( 2.0_DP * DelTime )
   753                else if ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime > xy_SurfSnow(i,j) ) then
   754                  ! All snow and a part of water is evaporated.
   755                  xy_SurfLatentHeatFlux(i,j) =                                      &
   756                    & (                                                             &
   757                    &     LatentHeat * ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime - xy_SurfSnow(i,j) )  &
   758                    &   + ( LatentHeat + LatentHeatFusion ) * xy_SurfSnow(i,j)      &
   759                    & )                                                             &
   760                    & / ( 2.0_DP * DelTime )
   761                else
   762                  ! Only a part of snow is evaporated.
   763                  xy_SurfLatentHeatFlux(i,j) =                                      &
   764                    & ( LatentHeat + LatentHeatFusion ) * xy_SurfEvapFlux(i,j)
   765                end if
   766  
   767              else
   768                ! Water vapor flux is negative (transported downward).
   769  
   770                if ( xy_SurfSnow(i,j) > 0.0_DP ) then
   771                  ! Water vapor is converted to snow.
   772                  xy_SurfLatentHeatFlux(i,j) =                                      &
   773                    &   ( LatentHeat + LatentHeatFusion ) * xy_SurfEvapFlux(i,j)
   774                end if
   775  
   776              end if
   777            end if
   778  
   779          end do
   780        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_flagoceangrid(j-1,1) .eq. 0) then                       
     .              if (xy_surfevapflux(j-1,1) .gt. 0.0000000000000000e+000)    
     .       1         then                                                     
     .                 if (xy_surfevapflux(j-1,1)*2.00000000000000e+000*deltime 
     .       1            .gt. xy_soilmoist(j-1,1)+xy_surfsnow(j-1,1)) then     
     .                    xy_surfevapflux(j-1,1) = (xy_soilmoist(j-1,1)+        
     .       1               xy_surfsnow(j-1,1))/(2.00000000000000e+000*deltime)
     .                    xy_surflatentheatflux(j-1,1) = (latentheat*           
     .       1               xy_soilmoist(j-1,1)+(latentheat+latentheatfusion)* 
     .       2               xy_surfsnow(j-1,1))/(2.00000000000000e+000*deltime)
     .                 else                                                     
     .                    if (xy_surfevapflux(j-1,1)*2.00000000000000e+000*     
     .       1               deltime .le. xy_surfsnow(j-1,1)) then              
     .                       xy_surflatentheatflux(j-1,1) = (latentheat +       
     .       1                  latentheatfusion)*xy_surfevapflux(j-1,1)        
     .                    else                                                  
     .                       xy_surflatentheatflux(j-1,1) = (latentheat*((      
     .       1                  2.00000000000000e+000*deltime)*xy_surfevapflux(j
     .       2                  -1,1)-xy_surfsnow(j-1,1))+(latentheat+          
     .       3                  latentheatfusion)*xy_surfsnow(j-1,1))/(         
     .       4                  2.00000000000000e+000*deltime)                  
     .                    endif                                                 
     .                 endif                                                    
     .              else                                                        
     .                 if (xy_surfsnow(j-1,1) .gt. 0.0000000000000000e+000) then
     .                    xy_surflatentheatflux(j-1,1) = (latentheat +          
     .       1               latentheatfusion)*xy_surfevapflux(j-1,1)           
     .                 endif                                                    
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
     .        goto 10008                                                        
   781      else
   782        ! Surface water vapor flux is limited up to the water amount on land.
   783        !
   784        do j = 1, jmax
   785          do i = 0, imax-1
   786            if ( ( .not. xy_FlagOceanGrid(i,j)                                  ) .and.&
   787              &  ( xy_SurfEvapFlux(i,j)                    >  0.0_DP            ) .and.&
   788              &  ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime >  xy_SoilMoist(i,j) ) ) &
   789              & then
   790              xy_SurfEvapFlux(i,j) = xy_SoilMoist(i,j) / ( 2.0_DP * DelTime )
   791  
   792              xy_SurfLatentHeatFlux(i,j) = LatentHeat * xy_SoilMoist(i,j) / ( 2.0_DP * DelTime )
   793  
   794            end if
   795          end do
   796        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (.not.xy_flagoceangrid(j-1,1) .and. xy_surfevapflux(j-1,1)  
     .       1      .gt.0.0000000000000000e+000 .and. (2.00000000000000e+000*   
     .       2      deltime)*xy_surfevapflux(j-1,1).gt.xy_soilmoist(j-1,1)) then
     .              xy_surfevapflux(j-1,1) = xy_soilmoist(j-1,1)/(              
     .       1         2.00000000000000e+000*deltime)                           
     .              xy_surflatentheatflux(j-1,1) = latentheat*xy_soilmoist(j-1,1
     .       1         )/(2.00000000000000e+000*deltime)                        
     .           endif                                                          
     .        enddo                                                             
   797      end if
   798  
   799      ! 計算時間計測一時停止
   800      ! Pause measurement of computation time
   801      !
   802      call TimesetClockStop( module_name )
   803  
   804  
   805    end subroutine BucketModEvapAndLatentHeatFlux
   806  
   807  
   808    !--------------------------------------------------------------------------------------
   809  
   810    function BucketGetSoilMoistCritAmnt() result( OutSoilMoistCritAmnt )
   811  
   812  
   813      real(DP) :: OutSoilMoistCritAmnt
   814  
   815  
   816      ! 作業変数
   817      ! Work variables
   818      !
   819  
   820  
   821      ! 初期化確認
   822      ! Initialization check
   823      !
   824      if ( .not. bucket_model_inited ) then
   825        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   826      end if
   827  
   828  
   829  !!$    ! 計算時間計測開始
   830  !!$    ! Start measurement of computation time
   831  !!$    !
   832  !!$    call TimesetClockStart( module_name )
   833  
   834      OutSoilMoistCritAmnt = SoilMoistCritAmnt
   835  
   836  !!$    ! 計算時間計測一時停止
   837  !!$    ! Pause measurement of computation time
   838  !!$    !
   839  !!$    call TimesetClockStop( module_name )
   840  
   841  
   842    end function BucketGetSoilMoistCritAmnt
   843  
   844    !-------------------------------------------------------------------------------------
   845  
   846    subroutine BucketModelInit( &
   847      & ArgFlagSnow             & ! (in)
   848      & )
   849      !
   850      ! bucket_model モジュールの初期化を行います.
   851      ! NAMELIST#bucket_model_nml の読み込みはこの手続きで行われます.
   852      !
   853      ! "bucket_model" module is initialized.
   854      ! "NAMELIST#bucket_model_nml" is loaded in this procedure.
   855      !
   856  
   857      ! モジュール引用 ; USE statements
   858      !
   859  
   860      ! 種別型パラメタ
   861      ! Kind type parameter
   862      !
   863      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   864  
   865      ! 文字列操作
   866      ! Character handling
   867      !
   868      use dc_string, only: StoA
   869  
   870      ! ファイル入出力補助
   871      ! File I/O support
   872      !
   873      use dc_iounit, only: FileOpen
   874  
   875      ! ヒストリデータ出力
   876      ! History data output
   877      !
   878      use gtool_historyauto, only: HistoryAutoAddVariable
   879  
   880      ! NAMELIST ファイル入力に関するユーティリティ
   881      ! Utilities for NAMELIST file input
   882      !
   883      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   884  
   885  
   886      ! 宣言文 ; Declaration statements
   887      !
   888      implicit none
   889  
   890      logical, intent(in) :: ArgFlagSnow
   891  
   892  
   893      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   894                                ! Unit number for NAMELIST file open
   895      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   896                                ! IOSTAT of NAMELIST read
   897  
   898      ! NAMELIST 変数群
   899      ! NAMELIST group name
   900      !
   901      namelist /bucket_model_nml/                         &
   902        & SoilMoistCritAmnt, SoilMoistCritAmntforEvapEff
   903  
   904  
   905      ! 実行文 ; Executable statement
   906      !
   907  
   908      if ( bucket_model_inited ) return
   909  
   910  
   911      FlagSnow = ArgFlagSnow
   912  
   913  
   914      ! デフォルト値の設定
   915      ! Default values settings
   916      !
   917  
   918      ! Values from Manabe (1969)
   919      !  Manabe, Climate and the ocean circulation I. The atmospheric circulation and
   920      !  the hydrology of the Earth's surface, Mon. Wea. Rev., 97, 739-774, 1969
   921      !
   922      SoilMoistCritAmnt            = 1.0e3_DP * 0.15e0_DP
   923      SoilMoistCritAmntforEvapEff  = 1.0e3_DP * 0.15e0_DP * 0.75e0_DP
   924  
   925  
   926      ! NAMELIST の読み込み
   927      ! NAMELIST is input
   928      !
   929      if ( trim(namelist_filename) /= '' ) then
   930        call FileOpen( unit_nml, &          ! (out)
   931          & namelist_filename, mode = 'r' ) ! (in)
   932  
   933        rewind( unit_nml )
   934        read( unit_nml, &                ! (in)
   935          & nml = bucket_model_nml, &    ! (out)
   936          & iostat = iostat_nml )        ! (out)
   937        close( unit_nml )
   938  
   939        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   940      end if
   941  
   942  
   943  !!$    ! ヒストリデータ出力のためのへの変数登録
   944  !!$    ! Register of variables for history data output
   945  !!$    !
   946  !!$    call HistoryAutoAddVariable( 'TempIncByFusion', &
   947  !!$      & (/ 'lon ', 'lat ', 'time' /), &
   948  !!$      & 'temperature increase by fusion', 'K' )
   949  
   950  
   951      ! 印字 ; Print
   952      !
   953      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   954  
   955      call MessageNotify( 'M', module_name, '  SoilMoistCritAmnt           = %f', d = (/ SoilMoistCritAmnt  /) )
   956      call MessageNotify( 'M', module_name, '  SoilMoistCritAmntforEvapEff = %f', d = (/ SoilMoistCritAmntforEvapEff /) )
   957      call MessageNotify( 'M', module_name, '  FlagSnow                    = %y', l = (/ FlagSnow /) )
   958  
   959  
   960      bucket_model_inited = .true.
   961  
   962    end subroutine BucketModelInit
   963  
   964    !--------------------------------------------------------------------------------------
   965  
   966  end module Bucket_Model
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: bucket_model.f90
PROGRAM NAME: bucket_model
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != バケツモデル
     2:             !
     3:             != Bucket model
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: bucket_model.f90,v 1.16 2015/01/29 12:07:59 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module Bucket_Model
    13:             
    14:               ! モジュール引用 ; USE statements
    15:               !
    16:             
    17:             
    18:               ! 種別型パラメタ
    19:               ! Kind type parameter
    20:               !
    21:               use dc_types, only: DP      ! 倍精度実数型. Double precision.
    22:             
    23:               ! メッセージ出力
    24:               ! Message output
    25:               !
    26:               use dc_message, only: MessageNotify
    27:             
    28:               ! 宣言文 ; Declaration statements
    29:               !
    30:               implicit none
    31:               private
    32:             
    33:               logical, save :: bucket_model_inited = .false.
    34:                                           ! 初期設定フラグ.
    35:                                           ! Initialization flag
    36:             
    37:             
    38:               logical, save :: FlagSnow   ! 雪の扱い オン／オフ.
    39:                                           ! treatment of snow on/off.
    40:             
    41:               ! 公開手続き
    42:               ! Public procedure
    43:               !
    44:               public :: BucketSetFlagOceanFromMatthews
    45:             !!$  public :: BucketEvap
    46:             !!$  public :: BucketEvapAdjust
    47:               public :: BucketIntegration
    48:               public :: BucketPRCPAdjust
    49:               public :: BucketModHumidCoef
    50:               public :: BucketModEvapAndLatentHeatFlux
    51:               public :: BucketGetSoilMoistCritAmnt
    52:               public :: BucketModelInit
    53:             
    54:             
    55:               ! 非公開変数
    56:               ! Private variables
    57:               !
    58:               real(DP), save:: SoilMoistCritAmnt
    59:                                     ! 土壌水分量の上限値
    60:                                     ! Critical amount of soil moisture
    61:               real(DP), save:: SoilMoistCritAmntforEvapEff
    62:                                     ! 地表湿潤度を 1 とする閾値
    63:                                     ! Critical amount of soil moisture for evaporation efficiency
    64:             
    65:               real(DP), save:: SoilMoistMeaningLess = -1.0d0
    66:                                     ! 海洋条件の場合に使用する物理的には意味のない変数
    67:                                     ! Meaning less value for soil moisture on the ocean
    68:             
    69:               real(DP), save:: HumidCoefSnowThreshold = 1.0d-50
    70:                                     !
    71:                                     ! Threshold of surface snow amount for surface humid coefficient determination
    72:             
    73:               character(*), parameter:: module_name = 'bucket_model'
    74:                                           ! モジュールの名称. 
    75:                                           ! Module name
    76:               character(*), parameter:: version = &
    77:                 & '$Name:  $' // &
    78:                 & '$Id: bucket_model.f90,v 1.16 2015/01/29 12:07:59 yot Exp $'
    79:                                           ! モジュールのバージョン
    80:                                           ! Module version
    81:             
    82:             contains
    83:             
    84:               !--------------------------------------------------------------------------------------
    85:             
    86:               subroutine BucketSetFlagOceanFromMatthews( &
    87:                 & xy_SurfType,                           & ! (in)
    88:                 & xy_FlagOceanGrid                       & ! (out)
    89:                 & )
    90:                 !
    91:                 !
    92:                 !
    93:                 ! Set flagx for ocean grid point from Matthews' index
    94:                 !
    95:             
    96:                 ! モジュール引用 ; USE statements
    97:                 !
    98:             
    99:                 ! 格子点設定
   100:                 ! Grid points settings
   101:                 !
   102:                 use gridset, only: imax, & ! 経度格子点数.
   103:                                            ! Number of grid points in longitude
   104:                   &                jmax, & ! 緯度格子点数.
   105:                                            ! Number of grid points in latitude
   106:                   &                kmax    ! 鉛直層数.
   107:                                            ! Number of vertical level
   108:             
   109:                 ! 宣言文 ; Declaration statements
   110:                 !
   111:                 implicit none
   112:             
   113:                 integer , intent(in ) :: xy_SurfType     (0:imax-1, 1:jmax)
   114:                                           ! 土地利用
   115:                                           ! Surface index
   116:                 logical , intent(out) :: xy_FlagOceanGrid(0:imax-1, 1:jmax)
   117:                                           ! 
   118:                                           ! Flag for ocean grid
   119:             
   120:             
   121:                 ! 作業変数
   122:                 ! Work variables
   123:                 !
   124:             
   125:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   126:                                           ! Work variables for DO loop in longitude
   127:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   128:                                           ! Work variables for DO loop in latitude
   129:             
   130:             
   131:                 ! 実行文 ; Executable statement
   132:                 !
   133:             
   134:                 ! 初期化確認
   135:                 ! Initialization check
   136:                 !
   137:                 if ( .not. bucket_model_inited ) then
   138:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   139:                 end if
   140:             
   141:             
   142:                 !
   143:                 ! Set index for calculation method
   144:                 !
   145: W------>        do j = 1, jmax
   146: |*----->          do i = 0, imax-1
   147: ||      A           if ( xy_SurfType(i,j) == 0 ) then
   148: ||                    ! ocean
   149: ||                    xy_FlagOceanGrid(i,j) = .true.
   150: ||                  else
   151: ||                    ! land
   152: ||                    xy_FlagOceanGrid(i,j) = .false.
   153: ||                  end if
   154: |*----- A         end do
   155: W------         end do
   156:             
   157:             
   158:               end subroutine BucketSetFlagOceanFromMatthews
   159:             
   160:               !--------------------------------------------------------------------------------------
   161:             
   162:               subroutine BucketIntegration(        &
   163:                 & xy_FlagOceanGrid,                & ! (in )
   164:                 & xy_DSoilMoistDt, xy_DSurfSnowDt, & ! (in )
   165:                 & xy_SoilMoistB, xy_SurfSnowB,     & ! (in )
   166:                 & xy_SoilMoistA, xy_SurfSnowA      & ! (out)
   167:                 & )
   168:             
   169:                 ! 時刻管理
   170:                 ! Time control
   171:                 !
   172:                 use timeset, only: &
   173:                   & DelTime, &             ! $ \Delta t $ [s]
   174:                   & TimesetClockStart, TimesetClockStop
   175:             
   176:                 ! 格子点設定
   177:                 ! Grid points settings
   178:                 !
   179:                 use gridset, only: imax, & ! 経度格子点数.
   180:                                            ! Number of grid points in longitude
   181:                   &                jmax, & ! 緯度格子点数.
   182:                                            ! Number of grid points in latitude
   183:                   &                kmax    ! 鉛直層数.
   184:                                            ! Number of vertical level
   185:             
   186:                 logical , intent(in ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   187:                 real(DP), intent(in ) :: xy_DSoilMoistDt ( 0:imax-1, 1:jmax )
   188:                 real(DP), intent(in ) :: xy_DSurfSnowDt  ( 0:imax-1, 1:jmax )
   189:                 real(DP), intent(in ) :: xy_SoilMoistB   ( 0:imax-1, 1:jmax )
   190:                 real(DP), intent(in ) :: xy_SurfSnowB    ( 0:imax-1, 1:jmax )
   191:                 real(DP), intent(out) :: xy_SoilMoistA   ( 0:imax-1, 1:jmax )
   192:                 real(DP), intent(out) :: xy_SurfSnowA    ( 0:imax-1, 1:jmax )
   193:             
   194:                 ! 作業変数
   195:                 ! Work variables
   196:                 !
   197:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   198:                                           ! Work variables for DO loop in longitude
   199:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   200:                                           ! Work variables for DO loop in latitude
   201:             
   202:             
   203:                 ! 初期化確認
   204:                 ! Initialization check
   205:                 !
   206:                 if ( .not. bucket_model_inited ) then
   207:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   208:                 end if
   209:             
   210:             
   211:                 ! 計算時間計測開始
   212:                 ! Start measurement of computation time
   213:                 !
   214:                 call TimesetClockStart( module_name )
   215:             
   216:             
   217: W*===== A       xy_SoilMoistA = xy_SoilMoistB + xy_DSoilMoistDt * 2.0_DP * DelTime
   218:             
   219:                 ! Remove negative values
   220:                 !
   221: W------>        do j = 1, jmax
   222: |*----->          do i = 0, imax-1
   223: ||      A           if( xy_SoilMoistA(i,j) < 0.0_DP ) xy_SoilMoistA(i,j) = 0.0_DP
   224: |*-----           end do
   225: W------         end do
   226:             
   227:                 if ( FlagSnow ) then
   228: W*===== A         xy_SurfSnowA = xy_SurfSnowB + xy_DSurfSnowDt * 2.0_DP * DelTime
   229:             
   230:                   ! Remove negative values
   231:                   !
   232: W------>          do j = 1, jmax
   233: |*----->            do i = 0, imax-1
   234: ||      A             if( xy_SurfSnowA (i,j) < 0.0_DP ) xy_SurfSnowA (i,j) = 0.0_DP
   235: |*-----             end do
   236: W------           end do
   237:                 else
   238: W*===== A         xy_SurfSnowA = xy_SurfSnowB
   239:                 end if
   240:             
   241:             
   242:                 ! Fill meaningless value in ocean grid
   243:                 !
   244: W------>        do j = 1, jmax
   245: |*----->          do i = 0, imax-1
   246: ||      A           if ( xy_FlagOceanGrid(i,j) ) then
   247: ||      A             xy_SoilMoistA(i,j) = SoilMoistMeaningLess
   248: ||      A             xy_SurfSnowA(i,j)  = SoilMoistMeaningLess
   249: ||                  end if
   250: |*-----           end do
   251: W------         end do
   252:             
   253:             
   254:                 ! 計算時間計測一時停止
   255:                 ! Pause measurement of computation time
   256:                 !
   257:                 call TimesetClockStop( module_name )
   258:             
   259:             
   260:               end subroutine BucketIntegration
   261:             
   262:               !--------------------------------------------------------------------------------------
   263:             !!$
   264:             !!$  ! This is wrong under the condition that water vapor flux is negative (transported 
   265:             !!$  ! downward). (2011/12/17, yot)
   266:             !!$
   267:             !!$  subroutine BucketEvap(                 &
   268:             !!$    & xy_FlagOceanGrid, xy_SurfEvapFlux, & ! (in )
   269:             !!$    & xy_SoilMoistB, xy_SurfSnowB,       & ! (in )
   270:             !!$    & xy_SoilMoistA, xy_SurfSnowA        & ! (out)
   271:             !!$    )
   272:             !!$
   273:             !!$    ! 時刻管理
   274:             !!$    ! Time control
   275:             !!$    !
   276:             !!$    use timeset, only: &
   277:             !!$      & DelTime, &             ! $ \Delta t $ [s]
   278:             !!$      & TimesetClockStart, TimesetClockStop
   279:             !!$
   280:             !!$    ! 格子点設定
   281:             !!$    ! Grid points settings
   282:             !!$    !
   283:             !!$    use gridset, only: imax, & ! 経度格子点数.
   284:             !!$                               ! Number of grid points in longitude
   285:             !!$      &                jmax, & ! 緯度格子点数.
   286:             !!$                               ! Number of grid points in latitude
   287:             !!$      &                kmax    ! 鉛直層数.
   288:             !!$                               ! Number of vertical level
   289:             !!$
   290:             !!$    ! 雪と海氷の定数の設定
   291:             !!$    ! Setting constants of snow and sea ice
   292:             !!$    !
   293:             !!$    use constants_snowseaice, only: &
   294:             !!$      & ThresholdSurfSnow,          &
   295:             !!$      & TempCondWater
   296:             !!$
   297:             !!$    logical , intent(in ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   298:             !!$    real(DP), intent(in ) :: xy_SurfEvapFlux ( 0:imax-1, 1:jmax )
   299:             !!$    real(DP), intent(in ) :: xy_SoilMoistB   ( 0:imax-1, 1:jmax )
   300:             !!$    real(DP), intent(in ) :: xy_SurfSnowB    ( 0:imax-1, 1:jmax )
   301:             !!$    real(DP), intent(out) :: xy_SoilMoistA   ( 0:imax-1, 1:jmax )
   302:             !!$    real(DP), intent(out) :: xy_SurfSnowA    ( 0:imax-1, 1:jmax )
   303:             !!$
   304:             !!$    ! 作業変数
   305:             !!$    ! Work variables
   306:             !!$    !
   307:             !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   308:             !!$                              ! Work variables for DO loop in longitude
   309:             !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   310:             !!$                              ! Work variables for DO loop in latitude
   311:             !!$
   312:             !!$
   313:             !!$    ! 初期化確認
   314:             !!$    ! Initialization check
   315:             !!$    !
   316:             !!$    if ( .not. bucket_model_inited ) then
   317:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   318:             !!$    end if
   319:             !!$
   320:             !!$
   321:             !!$    ! 計算時間計測開始
   322:             !!$    ! Start measurement of computation time
   323:             !!$    !
   324:             !!$    call TimesetClockStart( module_name )
   325:             !!$
   326:             !!$
   327:             !!$    if ( .not. FlagBucketModel ) then
   328:             !!$      xy_SoilMoistA = xy_SoilMoistB
   329:             !!$      xy_SurfSnowA  = xy_SurfSnowB
   330:             !!$      return
   331:             !!$    end if
   332:             !!$
   333:             !!$
   334:             !!$    if ( FlagBucketModelSnow ) then
   335:             !!$
   336:             !!$      ! Evaporation is subtracted from surface snow and soil moisture
   337:             !!$      !
   338:             !!$      xy_SurfSnowA = xy_SurfSnowB - xy_SurfEvapFlux * 2.0d0 * DelTime
   339:             !!$      do j = 1, jmax
   340:             !!$        do i = 0, imax-1
   341:             !!$          if ( xy_SurfSnowA(i,j) < 0.0d0 ) then
   342:             !!$            xy_SoilMoistA(i,j) = xy_SoilMoistB(i,j) + xy_SurfSnowA(i,j)
   343:             !!$            xy_SurfSnowA (i,j) = 0.0d0
   344:             !!$          else
   345:             !!$            xy_SoilMoistA(i,j) = xy_SoilMoistB(i,j)
   346:             !!$          end if
   347:             !!$        end do
   348:             !!$      end do
   349:             !!$    else
   350:             !!$      ! Evaporation is subtracted from soil moisture
   351:             !!$      !
   352:             !!$      xy_SoilMoistA = xy_SoilMoistB - xy_SurfEvapFlux * 2.0d0 * DelTime
   353:             !!$      xy_SurfSnowA  = xy_SurfSnowB
   354:             !!$    end if
   355:             !!$
   356:             !!$    ! Remove negative values
   357:             !!$    !
   358:             !!$    do j = 1, jmax
   359:             !!$      do i = 0, imax-1
   360:             !!$        if( xy_SoilMoistA(i,j) < 0.0d0 ) xy_SoilMoistA(i,j) = 0.0d0
   361:             !!$        if( xy_SurfSnowA (i,j) < 0.0d0 ) xy_SurfSnowA (i,j) = 0.0d0
   362:             !!$      end do
   363:             !!$    end do
   364:             !!$
   365:             !!$    ! Fill meaningless value in ocean grid
   366:             !!$    !
   367:             !!$    do j = 1, jmax
   368:             !!$      do i = 0, imax-1
   369:             !!$        if ( xy_FlagOceanGrid(i,j) ) then
   370:             !!$          xy_SoilMoistA(i,j) = SoilMoistMeaningLess
   371:             !!$          xy_SurfSnowA(i,j)  = SoilMoistMeaningLess
   372:             !!$        end if
   373:             !!$      end do
   374:             !!$    end do
   375:             !!$
   376:             !!$    ! 計算時間計測一時停止
   377:             !!$    ! Pause measurement of computation time
   378:             !!$    !
   379:             !!$    call TimesetClockStop( module_name )
   380:             !!$
   381:             !!$
   382:             !!$  end subroutine BucketEvap
   383:             !!$
   384:             !!$  !--------------------------------------------------------------------------------------
   385:             !!$
   386:             !!$  subroutine BucketEvapAdjust(           &
   387:             !!$    & xy_FlagOceanGrid, xy_SurfEvapFlux, & ! (in   )
   388:             !!$    & xy_SoilMoist, xy_SurfSnow          & ! (inout)
   389:             !!$    )
   390:             !!$
   391:             !!$    ! 格子点設定
   392:             !!$    ! Grid points settings
   393:             !!$    !
   394:             !!$    use gridset, only: imax, & ! 経度格子点数.
   395:             !!$                               ! Number of grid points in longitude
   396:             !!$      &                jmax, & ! 緯度格子点数.
   397:             !!$                               ! Number of grid points in latitude
   398:             !!$      &                kmax    ! 鉛直層数.
   399:             !!$                               ! Number of vertical level
   400:             !!$
   401:             !!$    logical , intent(in   ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   402:             !!$    real(DP), intent(in   ) :: xy_SurfEvapFlux ( 0:imax-1, 1:jmax )
   403:             !!$    real(DP), intent(inout) :: xy_SoilMoist    ( 0:imax-1, 1:jmax )
   404:             !!$    real(DP), intent(inout) :: xy_SurfSnow     ( 0:imax-1, 1:jmax )
   405:             !!$
   406:             !!$    ! 作業変数
   407:             !!$    ! Work variables
   408:             !!$    !
   409:             !!$    real(DP) :: xy_SoilMoistB( 0:imax-1, 1:jmax )
   410:             !!$    real(DP) :: xy_SurfSnowB ( 0:imax-1, 1:jmax )
   411:             !!$    real(DP) :: xy_SoilMoistA( 0:imax-1, 1:jmax )
   412:             !!$    real(DP) :: xy_SurfSnowA ( 0:imax-1, 1:jmax )
   413:             !!$
   414:             !!$
   415:             !!$    ! 初期化確認
   416:             !!$    ! Initialization check
   417:             !!$    !
   418:             !!$    if ( .not. bucket_model_inited ) then
   419:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   420:             !!$    end if
   421:             !!$
   422:             !!$
   423:             !!$    xy_SoilMoistB = xy_SoilMoist
   424:             !!$    xy_SurfSnowB  = xy_SurfSnow
   425:             !!$
   426:             !!$    call BucketEvap(                       &
   427:             !!$      & xy_FlagOceanGrid, xy_SurfEvapFlux, & ! (in )
   428:             !!$      & xy_SoilMoistB, xy_SurfSnowB,       & ! (in )
   429:             !!$      & xy_SoilMoistA, xy_SurfSnowA        & ! (out)
   430:             !!$      )
   431:             !!$
   432:             !!$    xy_SoilMoist = xy_SoilMoistA
   433:             !!$    xy_SurfSnow  = xy_SurfSnowA
   434:             !!$
   435:             !!$
   436:             !!$  end subroutine BucketEvapAdjust
   437:             !!$
   438:               !--------------------------------------------------------------------------------------
   439:             
   440:               subroutine BucketPRCPAdjust(                            &
   441:                 & xy_FlagOceanGrid, xy_SurfRainFlux, xy_SurfSnowFlux, &  ! (in )
   442:                 & xy_SoilMoist, xy_SurfSnow                           &  ! (inout)
   443:                 & )
   444:             
   445:                 ! ヒストリデータ出力
   446:                 ! History data output
   447:                 !
   448:                 use gtool_historyauto, only: HistoryAutoPut
   449:             
   450:                 ! 物理定数設定
   451:                 ! Physical constants settings
   452:                 !
   453:                 use constants, only:  &
   454:                   & CpDry,            &
   455:                                           ! $ C_p $ [J kg-1 K-1].
   456:                                           ! 乾燥大気の定圧比熱.
   457:                                           ! Specific heat of air at constant pressure
   458:                   & Grav,             &
   459:                                           ! $ g $ [m s-2].
   460:                                           ! 重力加速度.
   461:                                           ! Gravitational acceleration
   462:                   & LatentHeat,       &
   463:                                           ! $ L $ [J kg-1] .
   464:                                           ! 凝結の潜熱.
   465:                                           ! Latent heat of condensation
   466:                   & LatentHeatFusion
   467:                                           ! $ L $ [J kg-1] .
   468:                                           ! 融解の潜熱.
   469:                                           ! Latent heat of fusion
   470:             
   471:                 ! 時刻管理
   472:                 ! Time control
   473:                 !
   474:                 use timeset, only: &
   475:                   & TimeN,   &             ! ステップ $ t $ の時刻. Time of step $ t $.
   476:                   & DelTime, &             ! $ \Delta t $ [s]
   477:                   & TimesetClockStart, TimesetClockStop
   478:             
   479:                 ! 格子点設定
   480:                 ! Grid points settings
   481:                 !
   482:                 use gridset, only: imax, & ! 経度格子点数.
   483:                                            ! Number of grid points in longitude
   484:                   &                jmax, & ! 緯度格子点数.
   485:                                            ! Number of grid points in latitude
   486:                   &                kmax    ! 鉛直層数.
   487:                                            ! Number of vertical level
   488:             
   489:                 ! 座標データ設定
   490:                 ! Axes data settings
   491:                 !
   492:                 use axesset, only: &
   493:                   & z_DelSigma
   494:                                           ! $ \Delta \sigma $ (整数).
   495:                                           ! $ \Delta \sigma $ (Full)
   496:             
   497:                 logical , intent(in   ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   498:                 real(DP), intent(in   ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   499:                 real(DP), intent(in   ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   500:                 real(DP), intent(inout) :: xy_SoilMoist    ( 0:imax-1, 1:jmax )
   501:                 real(DP), intent(inout) :: xy_SurfSnow     ( 0:imax-1, 1:jmax )
   502:             
   503:             
   504:                 ! 作業変数
   505:                 ! Work variables
   506:                 !
   507:             !!$    real(DP) :: xy_TempIncByFusion( 0:imax-1, 1:jmax )
   508:             !!$                              ! Temperature increase by fusion
   509:             
   510:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   511:                                           ! Work variables for DO loop in longitude
   512:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   513:                                           ! Work variables for DO loop in latitude
   514:             
   515:             
   516:                 ! 初期化確認
   517:                 ! Initialization check
   518:                 !
   519:                 if ( .not. bucket_model_inited ) then
   520:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   521:                 end if
   522:             
   523:             
   524:                 ! 計算時間計測開始
   525:                 ! Start measurement of computation time
   526:                 !
   527:                 call TimesetClockStart( module_name )
   528:             
   529:             
   530:             !!$    ! Initialize an array for temperature increase by fusion
   531:             !!$    !
   532:             !!$    xy_TempIncByFusion = 0.0d0
   533:             
   534:             
   535:                 if ( FlagSnow ) then
   536:                   ! Precipitation is added to soil moisture or surface snow
   537:                   !
   538: W------>          do j = 1, jmax
   539: |*----->            do i = 0, imax-1
   540: ||          
   541: ||      A             xy_SoilMoist(i,j) = xy_SoilMoist(i,j) &
   542: ||                      & + xy_SurfRainFlux(i,j) * 2.0_DP * DelTime
   543: ||      A             xy_SurfSnow (i,j) = xy_SurfSnow (i,j) &
   544: ||                      & + xy_SurfSnowFlux(i,j) * 2.0_DP * DelTime
   545: ||          
   546: |*-----             end do
   547: W------           end do
   548:                 else
   549:                   ! Precipitation is added to soil moisture
   550:                   !
   551:             !!$      xy_SoilMoist = xy_SoilMoist + xy_SurfPRCPFlux * 2.0d0 * DelTime
   552: W*===== A         xy_SoilMoist = xy_SoilMoist &
   553:                     & + ( xy_SurfRainFlux + xy_SurfSnowFlux ) * 2.0_DP * DelTime
   554:                 end if
   555:             
   556:                 ! Calculation of Run-off
   557:                 !
   558: W------>        do j = 1, jmax
   559: |*----->          do i = 0, imax-1
   560: ||      A           if ( xy_SoilMoist(i,j) > SoilMoistCritAmnt ) &
   561: ||                    & xy_SoilMoist(i,j) = SoilMoistCritAmnt
   562: ||                end do
   563: ||              end do
   564: ||          
   565: ||              ! Fill meaningless value in ocean grid
   566: ||              !
   567: ||              do j = 1, jmax
   568: ||                do i = 0, imax-1
   569: ||                  if ( xy_FlagOceanGrid(i,j) ) then
   570: ||                    xy_SoilMoist(i,j) = SoilMoistMeaningLess
   571: ||                    xy_SurfSnow (i,j) = SoilMoistMeaningLess
   572: ||                  end if
   573: |*-----           end do
   574: W------         end do
   575:             
   576:                 ! ヒストリデータ出力
   577:                 ! History data output
   578:                 !
   579:             !!$    call HistoryAutoPut( TimeN, 'TempIncByFusion' , xy_TempIncByFusion )
   580:             
   581:                 ! 計算時間計測一時停止
   582:                 ! Pause measurement of computation time
   583:                 !
   584:                 call TimesetClockStop( module_name )
   585:             
   586:               end subroutine BucketPRCPAdjust
   587:             
   588:               !--------------------------------------------------------------------------------------
   589:             
   590:               subroutine BucketModHumidCoef(                   &
   591:                 & xy_FlagOceanGrid, xy_SoilMoist, xy_SurfSnow, & ! (in   )
   592:                 & xy_SurfHumidCoef                             & ! (inout)
   593:                 & )
   594:             
   595:                 ! 時刻管理
   596:                 ! Time control
   597:                 !
   598:                 use timeset, only: &
   599:                   & DelTime            ! $ \Delta t $ [s]
   600:             
   601:                 ! 格子点設定
   602:                 ! Grid points settings
   603:                 !
   604:                 use gridset, only: imax, & ! 経度格子点数.
   605:                                            ! Number of grid points in longitude
   606:                   &                jmax, & ! 緯度格子点数.
   607:                                            ! Number of grid points in latitude
   608:                   &                kmax    ! 鉛直層数.
   609:                                            ! Number of vertical level
   610:             
   611:                 logical , intent(in   ) :: xy_FlagOceanGrid( 0:imax-1, 1:jmax )
   612:                 real(DP), intent(in   ) :: xy_SoilMoist    ( 0:imax-1, 1:jmax )
   613:                 real(DP), intent(in   ) :: xy_SurfSnow     ( 0:imax-1, 1:jmax )
   614:                 real(DP), intent(inout) :: xy_SurfHumidCoef( 0:imax-1, 1:jmax )
   615:             
   616:             
   617:                 ! 作業変数
   618:                 ! Work variables
   619:                 !
   620:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   621:                                           ! Work variables for DO loop in longitude
   622:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   623:                                           ! Work variables for DO loop in latitude
   624:             
   625:                 ! 初期化確認
   626:                 ! Initialization check
   627:                 !
   628:                 if ( .not. bucket_model_inited ) then
   629:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   630:                 end if
   631:             
   632:             
   633:                 ! Surface humidity coefficient is modified.
   634:                 !
   635:                 if ( FlagSnow ) then
   636: W------>          do j = 1, jmax
   637: |*----->            do i = 0, imax-1
   638: ||                    if ( xy_FlagOceanGrid(i,j) ) then
   639: ||      A               xy_SurfHumidCoef(i,j) = xy_SurfHumidCoef(i,j)
   640: ||          !!$          else if ( xy_SurfSnow(i,j) > ThresholdSurfSnow ) then
   641: ||      A             else if ( xy_SurfSnow(i,j) > HumidCoefSnowThreshold ) then
   642: ||      A               xy_SurfHumidCoef(i,j) = 1.0_DP
   643: ||                    else
   644: ||      A               xy_SurfHumidCoef(i,j) = xy_SoilMoist(i,j) / SoilMoistCritAmntforEvapEff
   645: ||      A               if ( xy_SurfHumidCoef(i,j) > 1.0_DP ) xy_SurfHumidCoef(i,j) = 1.0_DP
   646: ||                    end if
   647: |*-----             end do
   648: W------           end do
   649:                 else
   650: W------>          do j = 1, jmax
   651: |*----->            do i = 0, imax-1
   652: ||                    if ( xy_FlagOceanGrid(i,j) ) then
   653: ||      A               xy_SurfHumidCoef(i,j) = xy_SurfHumidCoef(i,j)
   654: ||                    else
   655: ||      A               xy_SurfHumidCoef(i,j) = xy_SoilMoist(i,j) / SoilMoistCritAmntforEvapEff
   656: ||      A               if ( xy_SurfHumidCoef(i,j) > 1.0_DP ) xy_SurfHumidCoef(i,j) = 1.0_DP
   657: ||                    end if
   658: |*-----             end do
   659: W------           end do
   660:                 end if
   661:             
   662:             
   663:               end subroutine BucketModHumidCoef
   664:             
   665:               !--------------------------------------------------------------------------------------
   666:             
   667:               subroutine BucketModEvapAndLatentHeatFlux(       &
   668:                 & xy_FlagOceanGrid, xy_SoilMoist, xy_SurfSnow, & ! (in   )
   669:                 & xy_SurfEvapFlux, xy_SurfLatentHeatFlux       & ! (inout)
   670:                 & )
   671:             
   672:                 ! 時刻管理
   673:                 ! Time control
   674:                 !
   675:                 use timeset, only: &
   676:                   & DelTime, &             ! $ \Delta t $ [s]
   677:                   & TimesetClockStart, TimesetClockStop
   678:             
   679:                 ! 格子点設定
   680:                 ! Grid points settings
   681:                 !
   682:                 use gridset, only: imax, & ! 経度格子点数.
   683:                                            ! Number of grid points in longitude
   684:                   &                jmax, & ! 緯度格子点数.
   685:                                            ! Number of grid points in latitude
   686:                   &                kmax    ! 鉛直層数.
   687:                                            ! Number of vertical level
   688:             
   689:                 ! 物理定数設定
   690:                 ! Physical constants settings
   691:                 !
   692:                 use constants, only:  &
   693:                   & LatentHeat,       &
   694:                                           ! $ L $ [J kg-1] .
   695:                                           ! 凝結の潜熱.
   696:                                           ! Latent heat of condensation
   697:                   & LatentHeatFusion
   698:                                           ! $ L $ [J kg-1] .
   699:                                           ! 融解の潜熱.
   700:                                           ! Latent heat of fusion
   701:             
   702:                 logical , intent(in   ) :: xy_FlagOceanGrid     ( 0:imax-1, 1:jmax )
   703:                 real(DP), intent(in   ) :: xy_SoilMoist         ( 0:imax-1, 1:jmax )
   704:                 real(DP), intent(in   ) :: xy_SurfSnow          ( 0:imax-1, 1:jmax )
   705:                 real(DP), intent(inout) :: xy_SurfEvapFlux      ( 0:imax-1, 1:jmax )
   706:                 real(DP), intent(inout) :: xy_SurfLatentHeatFlux( 0:imax-1, 1:jmax )
   707:             
   708:             
   709:                 ! 作業変数
   710:                 ! Work variables
   711:                 !
   712:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   713:                                           ! Work variables for DO loop in longitude
   714:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   715:                                           ! Work variables for DO loop in latitude
   716:             
   717:             
   718:                 ! 初期化確認
   719:                 ! Initialization check
   720:                 !
   721:                 if ( .not. bucket_model_inited ) then
   722:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   723:                 end if
   724:             
   725:             
   726:                 ! 計算時間計測開始
   727:                 ! Start measurement of computation time
   728:                 !
   729:                 call TimesetClockStart( module_name )
   730:             
   731:             
   732:                 if ( FlagSnow ) then
   733:                   ! Surface water vapor flux is limited up to the water and snow amount on land. 
   734:                   !
   735: W------>          do j = 1, jmax
   736: |*----->            do i = 0, imax-1
   737: ||          
   738: ||                    if ( .not. xy_FlagOceanGrid(i,j)  ) then
   739: ||                      if ( xy_SurfEvapFlux(i,j) > 0.0_DP ) then
   740: ||                        ! Water vapor flux is positive (transported upward).
   741: ||          
   742: ||      A                 if ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime >           &
   743: ||                          &     xy_SoilMoist(i,j) + xy_SurfSnow(i,j)          ) then
   744: ||                          ! All snow and all water is evaporated.
   745: ||      A                   xy_SurfEvapFlux(i,j) = &
   746: ||                            & ( xy_SoilMoist(i,j) + xy_SurfSnow(i,j) ) / ( 2.0_DP * DelTime )
   747: ||      A                   xy_SurfLatentHeatFlux(i,j) =                                    &
   748: ||                            & (                                                           &
   749: ||                            &     LatentHeat                        * xy_SoilMoist(i,j)   &
   750: ||                            &   + ( LatentHeat + LatentHeatFusion ) * xy_SurfSnow(i,j)    &
   751: ||                            & )                                                           &
   752: ||                            & / ( 2.0_DP * DelTime )
   753: ||                        else if ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime > xy_SurfSnow(i,j) ) then
   754: ||                          ! All snow and a part of water is evaporated.
   755: ||      A                   xy_SurfLatentHeatFlux(i,j) =                                      &
   756: ||                            & (                                                             &
   757: ||                            &     LatentHeat * ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime - xy_SurfSnow(i,j) )  &
   758: ||                            &   + ( LatentHeat + LatentHeatFusion ) * xy_SurfSnow(i,j)      &
   759: ||                            & )                                                             &
   760: ||                            & / ( 2.0_DP * DelTime )
   761: ||                        else
   762: ||                          ! Only a part of snow is evaporated.
   763: ||      A                   xy_SurfLatentHeatFlux(i,j) =                                      &
   764: ||                            & ( LatentHeat + LatentHeatFusion ) * xy_SurfEvapFlux(i,j)
   765: ||                        end if
   766: ||          
   767: ||                      else
   768: ||                        ! Water vapor flux is negative (transported downward).
   769: ||          
   770: ||      A                 if ( xy_SurfSnow(i,j) > 0.0_DP ) then
   771: ||                          ! Water vapor is converted to snow. 
   772: ||      A                   xy_SurfLatentHeatFlux(i,j) =                                      &
   773: ||                            &   ( LatentHeat + LatentHeatFusion ) * xy_SurfEvapFlux(i,j)
   774: ||                        end if
   775: ||          
   776: ||                      end if
   777: ||                    end if
   778: ||          
   779: |*-----             end do
   780: W------           end do
   781:                 else
   782:                   ! Surface water vapor flux is limited up to the water amount on land. 
   783:                   !
   784: W------>          do j = 1, jmax
   785: |*----->            do i = 0, imax-1
   786: ||      A             if ( ( .not. xy_FlagOceanGrid(i,j)                                  ) .and.&
   787: ||                      &  ( xy_SurfEvapFlux(i,j)                    >  0.0_DP            ) .and.&
   788: ||                      &  ( xy_SurfEvapFlux(i,j) * 2.0_DP * DelTime >  xy_SoilMoist(i,j) ) ) &
   789: ||                      & then
   790: ||      A               xy_SurfEvapFlux(i,j) = xy_SoilMoist(i,j) / ( 2.0_DP * DelTime )
   791: ||          
   792: ||      A               xy_SurfLatentHeatFlux(i,j) = LatentHeat * xy_SoilMoist(i,j) / ( 2.0_DP * DelTime )
   793: ||          
   794: ||                    end if
   795: |*-----             end do
   796: W------           end do
   797:                 end if
   798:             
   799:                 ! 計算時間計測一時停止
   800:                 ! Pause measurement of computation time
   801:                 !
   802:                 call TimesetClockStop( module_name )
   803:             
   804:             
   805:               end subroutine BucketModEvapAndLatentHeatFlux
   806:             
   807:             
   808:               !--------------------------------------------------------------------------------------
   809:             
   810:               function BucketGetSoilMoistCritAmnt() result( OutSoilMoistCritAmnt )
   811:             
   812:             
   813:                 real(DP) :: OutSoilMoistCritAmnt
   814:             
   815:             
   816:                 ! 作業変数
   817:                 ! Work variables
   818:                 !
   819:             
   820:             
   821:                 ! 初期化確認
   822:                 ! Initialization check
   823:                 !
   824:                 if ( .not. bucket_model_inited ) then
   825:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   826:                 end if
   827:             
   828:             
   829:             !!$    ! 計算時間計測開始
   830:             !!$    ! Start measurement of computation time
   831:             !!$    !
   832:             !!$    call TimesetClockStart( module_name )
   833:             
   834:                 OutSoilMoistCritAmnt = SoilMoistCritAmnt
   835:             
   836:             !!$    ! 計算時間計測一時停止
   837:             !!$    ! Pause measurement of computation time
   838:             !!$    !
   839:             !!$    call TimesetClockStop( module_name )
   840:             
   841:             
   842:               end function BucketGetSoilMoistCritAmnt
   843:             
   844:               !-------------------------------------------------------------------------------------
   845:             
   846:               subroutine BucketModelInit( &
   847:                 & ArgFlagSnow             & ! (in)
   848:                 & )
   849:                 !
   850:                 ! bucket_model モジュールの初期化を行います. 
   851:                 ! NAMELIST#bucket_model_nml の読み込みはこの手続きで行われます. 
   852:                 !
   853:                 ! "bucket_model" module is initialized. 
   854:                 ! "NAMELIST#bucket_model_nml" is loaded in this procedure. 
   855:                 !
   856:             
   857:                 ! モジュール引用 ; USE statements
   858:                 !
   859:             
   860:                 ! 種別型パラメタ
   861:                 ! Kind type parameter
   862:                 !
   863:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   864:             
   865:                 ! 文字列操作
   866:                 ! Character handling
   867:                 !
   868:                 use dc_string, only: StoA
   869:             
   870:                 ! ファイル入出力補助
   871:                 ! File I/O support
   872:                 !
   873:                 use dc_iounit, only: FileOpen
   874:             
   875:                 ! ヒストリデータ出力
   876:                 ! History data output
   877:                 !
   878:                 use gtool_historyauto, only: HistoryAutoAddVariable
   879:             
   880:                 ! NAMELIST ファイル入力に関するユーティリティ
   881:                 ! Utilities for NAMELIST file input
   882:                 !
   883:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   884:             
   885:             
   886:                 ! 宣言文 ; Declaration statements
   887:                 !
   888:                 implicit none
   889:             
   890:                 logical, intent(in) :: ArgFlagSnow
   891:             
   892:             
   893:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   894:                                           ! Unit number for NAMELIST file open
   895:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   896:                                           ! IOSTAT of NAMELIST read
   897:             
   898:                 ! NAMELIST 変数群
   899:                 ! NAMELIST group name
   900:                 !
   901:                 namelist /bucket_model_nml/                         &
   902:                   & SoilMoistCritAmnt, SoilMoistCritAmntforEvapEff
   903:             
   904:             
   905:                 ! 実行文 ; Executable statement
   906:                 !
   907:             
   908:                 if ( bucket_model_inited ) return
   909:             
   910:             
   911:                 FlagSnow = ArgFlagSnow
   912:             
   913:             
   914:                 ! デフォルト値の設定
   915:                 ! Default values settings
   916:                 !
   917:             
   918:                 ! Values from Manabe (1969)
   919:                 !  Manabe, Climate and the ocean circulation I. The atmospheric circulation and 
   920:                 !  the hydrology of the Earth's surface, Mon. Wea. Rev., 97, 739-774, 1969
   921:                 !
   922:                 SoilMoistCritAmnt            = 1.0e3_DP * 0.15e0_DP
   923:                 SoilMoistCritAmntforEvapEff  = 1.0e3_DP * 0.15e0_DP * 0.75e0_DP
   924:             
   925:             
   926:                 ! NAMELIST の読み込み
   927:                 ! NAMELIST is input
   928:                 !
   929:                 if ( trim(namelist_filename) /= '' ) then
   930:                   call FileOpen( unit_nml, &          ! (out)
   931:                     & namelist_filename, mode = 'r' ) ! (in)
   932:             
   933:                   rewind( unit_nml )
   934:                   read( unit_nml, &                ! (in)
   935:                     & nml = bucket_model_nml, &    ! (out)
   936:                     & iostat = iostat_nml )        ! (out)
   937:                   close( unit_nml )
   938:             
   939:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   940:                 end if
   941:             
   942:             
   943:             !!$    ! ヒストリデータ出力のためのへの変数登録
   944:             !!$    ! Register of variables for history data output
   945:             !!$    !
   946:             !!$    call HistoryAutoAddVariable( 'TempIncByFusion', &
   947:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
   948:             !!$      & 'temperature increase by fusion', 'K' )
   949:             
   950:             
   951:                 ! 印字 ; Print
   952:                 !
   953:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   954:             
   955:                 call MessageNotify( 'M', module_name, '  SoilMoistCritAmnt           = %f', d = (/ SoilMoistCritAmnt  /) )
   956:                 call MessageNotify( 'M', module_name, '  SoilMoistCritAmntforEvapEff = %f', d = (/ SoilMoistCritAmntforEvapEff /) )
   957:                 call MessageNotify( 'M', module_name, '  FlagSnow                    = %y', l = (/ FlagSnow /) )
   958:             
   959:             
   960:                 bucket_model_inited = .true.
   961:             
   962:               end subroutine BucketModelInit
   963:             
   964:               !--------------------------------------------------------------------------------------
   965:             
   966:             end module Bucket_Model
