Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: gabls.f90
PROGRAM NAME: gabls
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   205  opt  (1592): Outer loop unrolled inside inner loop.
   205  vec  (   4): Vectorized array expression.
   205  vec  (  29): ADB is used for array.: d1
   205  vec  (   4): Vectorized array expression.
   205  vec  (  29): ADB is used for array.: xy_surftemp
   205  vec  (  29): ADB is used for array.: d1
   205  vec  (   4): Vectorized array expression.
   205  vec  (  29): ADB is used for array.: xy_surftemp
   205  vec  (  29): ADB is used for array.: d1
   208  opt  (1592): Outer loop unrolled inside inner loop.
   208  vec  (   4): Vectorized array expression.
   208  vec  (  29): ADB is used for array.: xy_surftemp
   208  vec  (   4): Vectorized array expression.
   208  vec  (  29): ADB is used for array.: xy_surftemp
   211  opt  (1592): Outer loop unrolled inside inner loop.
   211  vec  (   4): Vectorized array expression.
   211  vec  (  29): ADB is used for array.: d3
   211  vec  (   4): Vectorized array expression.
   211  vec  (  29): ADB is used for array.: xy_surftemp
   211  vec  (  29): ADB is used for array.: d3
   211  vec  (   4): Vectorized array expression.
   211  vec  (  29): ADB is used for array.: xy_surftemp
   211  vec  (  29): ADB is used for array.: d3
   214  opt  (1592): Outer loop unrolled inside inner loop.
   214  vec  (   4): Vectorized array expression.
   214  vec  (  29): ADB is used for array.: xy_surftemp
   214  vec  (   4): Vectorized array expression.
   214  vec  (  29): ADB is used for array.: xy_surftemp
   217  opt  (1592): Outer loop unrolled inside inner loop.
   217  vec  (   4): Vectorized array expression.
   217  vec  (  29): ADB is used for array.: d5
   217  vec  (   4): Vectorized array expression.
   217  vec  (  29): ADB is used for array.: xy_surftemp
   217  vec  (  29): ADB is used for array.: d5
   217  vec  (   4): Vectorized array expression.
   217  vec  (  29): ADB is used for array.: xy_surftemp
   217  vec  (  29): ADB is used for array.: d5
   220  opt  (1593): Loop nest collapsed into one loop.
   220  vec  (   4): Vectorized array expression.
   220  vec  (  29): ADB is used for array.: xy_surftemp
   224  opt  (1593): Loop nest collapsed into one loop.
   224  vec  (   4): Vectorized array expression.
   224  vec  (  29): ADB is used for array.: xy_surftemp
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: gabls.f90
PROGRAM NAME: gabls
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != Routines for GABLS tests
     4  !
     5  ! Authors::   Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: gabls.f90,v 1.1 2015/01/31 06:16:26 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module gabls
    13    !
    14    !=
    15    !
    16    != Routines for GABLS tests
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    !
    23    !
    24    !== Procedures List
    25    !
    26  !!$  ! ShortIncoming      :: 短波入射 (太陽入射) の計算
    27  !!$  ! ------------       :: ------------
    28  !!$  ! ShortIncoming      :: Calculate short wave (insolation) incoming radiation.
    29    !
    30    !== NAMELIST
    31    !
    32  !!$  ! NAMELIST#rad_short_income_nml
    33    !
    34  
    35    ! モジュール引用 ; USE statements
    36    !
    37  
    38    ! 種別型パラメタ
    39    ! Kind type parameter
    40    !
    41    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    42      &                 STRING, &  ! 文字列.       Strings.
    43      &                 TOKEN      ! キーワード.   Keywords.
    44  
    45    ! メッセージ出力
    46    ! Message output
    47    !
    48    use dc_message, only: MessageNotify
    49  
    50    ! 物理・数学定数設定
    51    ! Physical and mathematical constants settings
    52    !
    53    use constants0, only: &
    54      & PI                    ! $ \pi $.
    55                              ! 円周率. Circular constant
    56  
    57    ! 格子点設定
    58    ! Grid points settings
    59    !
    60    use gridset, only: imax, & ! 経度格子点数.
    61                               ! Number of grid points in longitude
    62      &                jmax, & ! 緯度格子点数.
    63                               ! Number of grid points in latitude
    64      &                kmax    ! 鉛直層数.
    65                               ! Number of vertical level
    66  
    67    ! 時刻管理
    68    ! Time control
    69    !
    70    use timeset, only: &
    71      & TimeN,                & !
    72      & InitialDate             ! 計算開始日時.
    73                                ! Start date of calculation
    74  
    75    ! 宣言文 ; Declaration statements
    76    !
    77    implicit none
    78    private
    79  
    80    ! 公開手続き
    81    ! Public procedure
    82    !
    83    public :: SetGabls2SurfTemp
    84    public :: GablsInit
    85  
    86    ! 公開変数
    87    ! Public variables
    88    !
    89    logical, save :: gabls_inited = .false.
    90                                ! 初期設定フラグ.
    91                                ! Initialization flag.
    92  
    93  
    94    ! 非公開変数
    95    ! Private variables
    96    !
    97  
    98  !!$  logical,  save:: FlagAnnualMean
    99  !!$                              ! 年平均入射フラグ.
   100  !!$                              ! Flag for annual mean incoming radiation.
   101  
   102    character(*), parameter:: module_name = 'gabls'
   103                                ! モジュールの名称.
   104                                ! Module name
   105    character(*), parameter:: version = &
   106      & '$Name:  $' // &
   107      & '$Id: gabls.f90,v 1.1 2015/01/31 06:16:26 yot Exp $'
   108                                ! モジュールのバージョン
   109                                ! Module version
   110  
   111  contains
   112  
   113    !--------------------------------------------------------------------------------------
   114  
   115    subroutine SetGabls2SurfTemp(     &
   116      & xy_SurfTemp                   & ! (out)
   117      & )
   118      !
   119      !
   120      !
   121      ! Set surface temperature
   122      !
   123  
   124      ! モジュール引用 ; USE statements
   125      !
   126  
   127      ! 日付および時刻の取り扱い
   128      ! Date and time handler
   129      !
   130      use dc_calendar, only: DC_CAL_DATE, DCCalDateCreate, DCCalDateDifference, DCCalInquire
   131  
   132      ! ヒストリデータ出力
   133      ! History data output
   134      !
   135      use gtool_historyauto, only: HistoryAutoPut
   136  
   137  
   138      ! 宣言文 ; Declaration statements
   139      !
   140      implicit none
   141      real(DP), intent(out) :: xy_SurfTemp(0:imax-1, 1:jmax)
   142                                !
   143                                ! surface temperature
   144  
   145  
   146      ! 作業変数
   147      ! Work variables
   148      !
   149      integer         :: hour_in_a_day
   150      integer         :: min_in_a_hour
   151      real(DP)        :: sec_in_a_min
   152  
   153      integer           :: Year
   154      integer           :: Month
   155      integer           :: Day
   156      integer           :: Hour
   157      integer           :: Min
   158      real(DP)          :: Sec
   159      type(DC_CAL_DATE) :: Date1999Oct22UT0000
   160  
   161      real(DP) :: Time1999Oct22UT0000
   162  
   163      real(DP) :: HourFrom1999Oct22UT0000
   164  
   165  
   166      ! 実行文 ; Executable statement
   167      !
   168  
   169      ! 初期化確認
   170      ! Initialization check
   171      !
   172      if ( .not. gabls_inited ) then
   173        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   174      end if
   175  
   176  
   177      call DCCalInquire( &
   178        & hour_in_day      = hour_in_a_day,     & ! (out)
   179        & min_in_hour      = min_in_a_hour,     & ! (out)
   180        & sec_in_min       = sec_in_a_min       & ! (out)
   181        & )
   182  
   183  
   184      Year  = 1999
   185      Month =   10
   186      Day   =   22
   187      Hour  =    0
   188      Min   =    0
   189      Sec   =    0.0_DP
   190      call DCCalDateCreate( &
   191        & year = Year, month = Month, day = Day, &
   192        & hour = Hour, min   = Min  , sec = Sec, &
   193        & date = Date1999Oct22UT0000             &
   194        & )
   195  
   196      Time1999Oct22UT0000 = &
   197        & DCCalDateDifference( Date1999Oct22UT0000, InitialDate )
   198  
   199      HourFrom1999Oct22UT0000 = TimeN + Time1999Oct22UT0000
   200      HourFrom1999Oct22UT0000 = &
   201        & HourFrom1999Oct22UT0000 / ( min_in_a_hour * sec_in_a_min )
   202  
   203  
   204      if ( HourFrom1999Oct22UT0000 <= 17.4_DP ) then
   205        xy_SurfTemp = &
     .  !cdir nodep                                                             
     .  !cdir on_adb(d1)                                                        
     .        do t139 = 1, 1 + imax - min0(1,imax)                              
     .           d1(t139) = dcos(2.20000000000000e-001*hourfrom1999oct22ut0000  
     .       1       + 2.00000000000000e-001)                                   
     .        enddo                                                             
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t137 = 1, j1                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d1)                                                  
     .              do t139 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t139-1,t137) = (-1.00000000000000e+001) -    
     .       1            2.50000000000000e+001*d1(t139)                        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t137 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d1)                                                  
     .              do t139 = 1, 1 + imax - min0(1,imax)                        
     .                 d2 = d1(t139)                                            
     .                 xy_surftemp(t139-1,t137) = (-1.00000000000000e+001 - (   
     .       1            2.50000000000000e+001*d2))                            
     .                 xy_surftemp(t139-1,t137+1) = (-1.00000000000000e+001 - ( 
     .       1            2.50000000000000e+001*d2))                            
     .                 xy_surftemp(t139-1,t137+2) = (-1.00000000000000e+001 - ( 
     .       1            2.50000000000000e+001*d2))                            
     .                 xy_surftemp(t139-1,t137+3) = (-1.00000000000000e+001 - ( 
     .       1            2.50000000000000e+001*d2))                            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10015                                                        
   206          & - 10.0_DP - 25.0_DP * cos( 0.22 * HourFrom1999Oct22UT0000 + 0.2_DP )
   207      else if ( HourFrom1999Oct22UT0000 <= 30.0_DP ) then
   208        xy_SurfTemp = &
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t131 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t133 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t133-1,t131) = 1.51999999999999e+001 -       
     .       1            5.40000000000000e-001*hourfrom1999oct22ut0000         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t131 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t133 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t133-1,t131) = (1.51999999999999e+001 - (    
     .       1            5.40000000000000e-001*hourfrom1999oct22ut0000))       
     .                 xy_surftemp(t133-1,t131+1) = (1.51999999999999e+001 - (  
     .       1            5.40000000000000e-001*hourfrom1999oct22ut0000))       
     .                 xy_surftemp(t133-1,t131+2) = (1.51999999999999e+001 - (  
     .       1            5.40000000000000e-001*hourfrom1999oct22ut0000))       
     .                 xy_surftemp(t133-1,t131+3) = (1.51999999999999e+001 - (  
     .       1            5.40000000000000e-001*hourfrom1999oct22ut0000))       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10015                                                        
   209          & - 0.54_DP * HourFrom1999Oct22UT0000 + 15.2_DP
   210      else if ( HourFrom1999Oct22UT0000 <= 41.9_DP ) then
   211        xy_SurfTemp = &
     .  !cdir nodep                                                             
     .  !cdir on_adb(d3)                                                        
     .        do t127 = 1, 1 + imax - min0(1,imax)                              
     .           d3(t127) = dcos(2.09999999999999e-001*hourfrom1999oct22ut0000  
     .       1       + 1.80000000000000e+000)                                   
     .        enddo                                                             
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t125 = 1, j3                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d3)                                                  
     .              do t127 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t127-1,t125) = (-7.00000000000000e+000) -    
     .       1            2.50000000000000e+001*d3(t127)                        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t125 = j3 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d3)                                                  
     .              do t127 = 1, 1 + imax - min0(1,imax)                        
     .                 d4 = d3(t127)                                            
     .                 xy_surftemp(t127-1,t125) = (-7.00000000000000e+000 - (   
     .       1            2.50000000000000e+001*d4))                            
     .                 xy_surftemp(t127-1,t125+1) = (-7.00000000000000e+000 - ( 
     .       1            2.50000000000000e+001*d4))                            
     .                 xy_surftemp(t127-1,t125+2) = (-7.00000000000000e+000 - ( 
     .       1            2.50000000000000e+001*d4))                            
     .                 xy_surftemp(t127-1,t125+3) = (-7.00000000000000e+000 - ( 
     .       1            2.50000000000000e+001*d4))                            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10015                                                        
   212          & -  7.0_DP - 25.0_DP * cos( 0.21 * HourFrom1999Oct22UT0000 + 1.8_DP )
   213      else if ( HourFrom1999Oct22UT0000 <= 53.3_DP ) then
   214        xy_SurfTemp = &
     .        if (jmax .gt. 0) then                                             
     .           j4 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t119 = 1, j4                                                
     .  !cdir       nodep                                                       
     .              do t121 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t121-1,t119) = 1.80000000000000e+001 -       
     .       1            3.70000000000000e-001*hourfrom1999oct22ut0000         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t119 = j4 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t121 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t121-1,t119) = (1.80000000000000e+001 - (    
     .       1            3.70000000000000e-001*hourfrom1999oct22ut0000))       
     .                 xy_surftemp(t121-1,t119+1) = (1.80000000000000e+001 - (  
     .       1            3.70000000000000e-001*hourfrom1999oct22ut0000))       
     .                 xy_surftemp(t121-1,t119+2) = (1.80000000000000e+001 - (  
     .       1            3.70000000000000e-001*hourfrom1999oct22ut0000))       
     .                 xy_surftemp(t121-1,t119+3) = (1.80000000000000e+001 - (  
     .       1            3.70000000000000e-001*hourfrom1999oct22ut0000))       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10015                                                        
   215          & - 0.37_DP * HourFrom1999Oct22UT0000 + 18.0_DP
   216      else if ( HourFrom1999Oct22UT0000 <= 65.6_DP ) then
   217        xy_SurfTemp = &
     .  !cdir nodep                                                             
     .  !cdir on_adb(d5)                                                        
     .        do t115 = 1, 1 + imax - min0(1,imax)                              
     .           d5(t115) = dcos(2.20000000000000e-001*hourfrom1999oct22ut0000  
     .       1       + 2.50000000000000e+000)                                   
     .        enddo                                                             
     .        if (jmax .gt. 0) then                                             
     .           j5 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t113 = 1, j5                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d5)                                                  
     .              do t115 = 1, 1 + imax - min0(1,imax)                        
     .                 xy_surftemp(t115-1,t113) = (-4.00000000000000e+000) -    
     .       1            2.50000000000000e+001*d5(t115)                        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t113 = j5 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d5)                                                  
     .              do t115 = 1, 1 + imax - min0(1,imax)                        
     .                 d6 = d5(t115)                                            
     .                 xy_surftemp(t115-1,t113) = (-4.00000000000000e+000 - (   
     .       1            2.50000000000000e+001*d6))                            
     .                 xy_surftemp(t115-1,t113+1) = (-4.00000000000000e+000 - ( 
     .       1            2.50000000000000e+001*d6))                            
     .                 xy_surftemp(t115-1,t113+2) = (-4.00000000000000e+000 - ( 
     .       1            2.50000000000000e+001*d6))                            
     .                 xy_surftemp(t115-1,t113+3) = (-4.00000000000000e+000 - ( 
     .       1            2.50000000000000e+001*d6))                            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10015                                                        
   218          & -  4.0_DP - 25.0_DP * cos( 0.22 * HourFrom1999Oct22UT0000 + 2.5_DP )
   219      else
   220        xy_SurfTemp = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t99 = 1, jmax*imax                                             
     .           xy_surftemp(t99-1,1) = 4.40000000000000e+000                   
     .        enddo                                                             
   221          &    4.4_DP
   222      end if
   223  
   224      xy_SurfTemp = xy_SurfTemp + 273.15_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t105 = 1, jmax*imax                                            
     .           xy_surftemp(t105-1,1) = xy_surftemp(t105-1,1) +                
     .       1      2.73149999999999e+002                                       
     .        enddo                                                             
   225  
   226  
   227    end subroutine SetGabls2SurfTemp
   228  
   229    !--------------------------------------------------------------------------------------
   230  
   231    subroutine GablsInit
   232      !
   233      ! rad_short_income モジュールの初期化を行います.
   234      ! NAMELIST#rad_short_income_nml の読み込みはこの手続きで行われます.
   235      !
   236      ! "rad_short_income" module is initialized.
   237      ! "NAMELIST#rad_short_income_nml" is loaded in this procedure.
   238      !
   239  
   240      ! モジュール引用 ; USE statements
   241      !
   242  
   243      ! 種別型パラメタ
   244      ! Kind type parameter
   245      !
   246      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   247  
   248      ! ファイル入出力補助
   249      ! File I/O support
   250      !
   251      use dc_iounit, only: FileOpen
   252  
   253      ! ヒストリデータ出力
   254      ! History data output
   255      !
   256      use gtool_historyauto, only: HistoryAutoAddVariable
   257  
   258      ! 暦と日時の取り扱い
   259      ! Calendar and Date handler
   260      !
   261      use dc_calendar, only: &
   262        & DC_CAL_DATE, &          ! 日時を表現するデータ型.
   263                                  ! Data type for date and time
   264        & DCCalDateInquire, DCCalDateCreate, DCCalDateDifference, &
   265        & DCCalConvertByUnit
   266  
   267      ! NAMELIST ファイル入力に関するユーティリティ
   268      ! Utilities for NAMELIST file input
   269      !
   270      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   271  
   272      ! 宣言文 ; Declaration statements
   273      !
   274      implicit none
   275  
   276  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   277  !!$                              ! Unit number for NAMELIST file open
   278  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   279  !!$                              ! IOSTAT of NAMELIST read
   280  
   281  
   282      ! NAMELIST 変数群
   283      ! NAMELIST group name
   284      !
   285  !!$    namelist /gabls_nml/                                     &
   286  !!$      & FlagRadSynchronous
   287            !
   288            ! デフォルト値については初期化手続 "rad_short_income#RadShortIncomeInit"
   289            ! のソースコードを参照のこと.
   290            !
   291            ! Refer to source codes in the initialization procedure
   292            ! "rad_short_income#RadShortIncomeInit" for the default values.
   293            !
   294  
   295      ! 実行文 ; Executable statement
   296      !
   297  
   298      if ( gabls_inited ) return
   299  
   300  
   301      ! デフォルト値の設定
   302      ! Default values settings
   303      !
   304  !!$    FlagRadSynchronous       = .false.
   305  
   306  
   307      ! NAMELIST の読み込み
   308      ! NAMELIST is input
   309      !
   310  !!$    if ( trim(namelist_filename) /= '' ) then
   311  !!$      call FileOpen( unit_nml, &          ! (out)
   312  !!$        & namelist_filename, mode = 'r' ) ! (in)
   313  !!$
   314  !!$      rewind( unit_nml )
   315  !!$      read( unit_nml, &                ! (in)
   316  !!$        & nml = gabls_nml, &           ! (out)
   317  !!$        & iostat = iostat_nml )        ! (out)
   318  !!$      close( unit_nml )
   319  !!$
   320  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   321  !!$    end if
   322  
   323  
   324  
   325      ! 印字 ; Print
   326      !
   327      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   328  !!$    call MessageNotify( 'M', module_name, '  FlagRadSynchronous       = %b', l = (/ FlagRadSynchronous /) )
   329      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   330  
   331      gabls_inited = .true.
   332  
   333    end subroutine GablsInit
   334  
   335    !-------------------------------------------------------------------
   336  
   337  end module gabls
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:33 2016
FILE NAME: gabls.f90
PROGRAM NAME: gabls
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != Routines for GABLS tests
     4:             !
     5:             ! Authors::   Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: gabls.f90,v 1.1 2015/01/31 06:16:26 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module gabls
    13:               !
    14:               != 
    15:               !
    16:               != Routines for GABLS tests
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! 
    23:               !
    24:               !== Procedures List
    25:               !
    26:             !!$  ! ShortIncoming      :: 短波入射 (太陽入射) の計算
    27:             !!$  ! ------------       :: ------------
    28:             !!$  ! ShortIncoming      :: Calculate short wave (insolation) incoming radiation. 
    29:               !
    30:               !== NAMELIST
    31:               !
    32:             !!$  ! NAMELIST#rad_short_income_nml
    33:               !
    34:             
    35:               ! モジュール引用 ; USE statements
    36:               !
    37:             
    38:               ! 種別型パラメタ
    39:               ! Kind type parameter
    40:               !
    41:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    42:                 &                 STRING, &  ! 文字列.       Strings. 
    43:                 &                 TOKEN      ! キーワード.   Keywords.
    44:             
    45:               ! メッセージ出力
    46:               ! Message output
    47:               !
    48:               use dc_message, only: MessageNotify
    49:             
    50:               ! 物理・数学定数設定
    51:               ! Physical and mathematical constants settings
    52:               !
    53:               use constants0, only: &
    54:                 & PI                    ! $ \pi $.
    55:                                         ! 円周率. Circular constant
    56:             
    57:               ! 格子点設定
    58:               ! Grid points settings
    59:               !
    60:               use gridset, only: imax, & ! 経度格子点数. 
    61:                                          ! Number of grid points in longitude
    62:                 &                jmax, & ! 緯度格子点数. 
    63:                                          ! Number of grid points in latitude
    64:                 &                kmax    ! 鉛直層数. 
    65:                                          ! Number of vertical level
    66:             
    67:               ! 時刻管理
    68:               ! Time control
    69:               !
    70:               use timeset, only: &
    71:                 & TimeN,                & !
    72:                 & InitialDate             ! 計算開始日時.
    73:                                           ! Start date of calculation
    74:             
    75:               ! 宣言文 ; Declaration statements
    76:               !
    77:               implicit none
    78:               private
    79:             
    80:               ! 公開手続き
    81:               ! Public procedure
    82:               !
    83:               public :: SetGabls2SurfTemp
    84:               public :: GablsInit
    85:             
    86:               ! 公開変数
    87:               ! Public variables
    88:               !
    89:               logical, save :: gabls_inited = .false.
    90:                                           ! 初期設定フラグ. 
    91:                                           ! Initialization flag.
    92:             
    93:             
    94:               ! 非公開変数
    95:               ! Private variables
    96:               !
    97:             
    98:             !!$  logical,  save:: FlagAnnualMean
    99:             !!$                              ! 年平均入射フラグ.
   100:             !!$                              ! Flag for annual mean incoming radiation. 
   101:             
   102:               character(*), parameter:: module_name = 'gabls'
   103:                                           ! モジュールの名称. 
   104:                                           ! Module name
   105:               character(*), parameter:: version = &
   106:                 & '$Name:  $' // &
   107:                 & '$Id: gabls.f90,v 1.1 2015/01/31 06:16:26 yot Exp $'
   108:                                           ! モジュールのバージョン
   109:                                           ! Module version
   110:             
   111:             contains
   112:             
   113:               !--------------------------------------------------------------------------------------
   114:             
   115:               subroutine SetGabls2SurfTemp(     &
   116:                 & xy_SurfTemp                   & ! (out)
   117:                 & )
   118:                 !
   119:                 ! 
   120:                 !
   121:                 ! Set surface temperature
   122:                 !
   123:             
   124:                 ! モジュール引用 ; USE statements
   125:                 !
   126:             
   127:                 ! 日付および時刻の取り扱い
   128:                 ! Date and time handler
   129:                 !
   130:                 use dc_calendar, only: DC_CAL_DATE, DCCalDateCreate, DCCalDateDifference, DCCalInquire
   131:             
   132:                 ! ヒストリデータ出力
   133:                 ! History data output
   134:                 !
   135:                 use gtool_historyauto, only: HistoryAutoPut
   136:             
   137:             
   138:                 ! 宣言文 ; Declaration statements
   139:                 !
   140:                 implicit none
   141:                 real(DP), intent(out) :: xy_SurfTemp(0:imax-1, 1:jmax)
   142:                                           ! 
   143:                                           ! surface temperature
   144:             
   145:             
   146:                 ! 作業変数
   147:                 ! Work variables
   148:                 !
   149:                 integer         :: hour_in_a_day
   150:                 integer         :: min_in_a_hour
   151:                 real(DP)        :: sec_in_a_min
   152:             
   153:                 integer           :: Year
   154:                 integer           :: Month
   155:                 integer           :: Day
   156:                 integer           :: Hour
   157:                 integer           :: Min
   158:                 real(DP)          :: Sec
   159:                 type(DC_CAL_DATE) :: Date1999Oct22UT0000
   160:             
   161:                 real(DP) :: Time1999Oct22UT0000
   162:             
   163:                 real(DP) :: HourFrom1999Oct22UT0000
   164:             
   165:             
   166:                 ! 実行文 ; Executable statement
   167:                 !
   168:             
   169:                 ! 初期化確認
   170:                 ! Initialization check
   171:                 !
   172:                 if ( .not. gabls_inited ) then
   173:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   174:                 end if
   175:             
   176:             
   177:                 call DCCalInquire( &
   178:                   & hour_in_day      = hour_in_a_day,     & ! (out)
   179:                   & min_in_hour      = min_in_a_hour,     & ! (out)
   180:                   & sec_in_min       = sec_in_a_min       & ! (out)
   181:                   & )
   182:             
   183:             
   184:                 Year  = 1999
   185:                 Month =   10
   186:                 Day   =   22
   187:                 Hour  =    0
   188:                 Min   =    0
   189:                 Sec   =    0.0_DP
   190:                 call DCCalDateCreate( &
   191:                   & year = Year, month = Month, day = Day, &
   192:                   & hour = Hour, min   = Min  , sec = Sec, &
   193:                   & date = Date1999Oct22UT0000             &
   194:                   & )
   195:             
   196:                 Time1999Oct22UT0000 = &
   197:                   & DCCalDateDifference( Date1999Oct22UT0000, InitialDate )
   198:             
   199:                 HourFrom1999Oct22UT0000 = TimeN + Time1999Oct22UT0000
   200:                 HourFrom1999Oct22UT0000 = &
   201:                   & HourFrom1999Oct22UT0000 / ( min_in_a_hour * sec_in_a_min )
   202:             
   203:             
   204:                 if ( HourFrom1999Oct22UT0000 <= 17.4_DP ) then
   205: +V===== A         xy_SurfTemp = &
   206:                     & - 10.0_DP - 25.0_DP * cos( 0.22 * HourFrom1999Oct22UT0000 + 0.2_DP )
   207:                 else if ( HourFrom1999Oct22UT0000 <= 30.0_DP ) then
   208: +V===== A         xy_SurfTemp = &
   209:                     & - 0.54_DP * HourFrom1999Oct22UT0000 + 15.2_DP
   210:                 else if ( HourFrom1999Oct22UT0000 <= 41.9_DP ) then
   211: +V===== A         xy_SurfTemp = &
   212:                     & -  7.0_DP - 25.0_DP * cos( 0.21 * HourFrom1999Oct22UT0000 + 1.8_DP )
   213:                 else if ( HourFrom1999Oct22UT0000 <= 53.3_DP ) then
   214: +V===== A         xy_SurfTemp = &
   215:                     & - 0.37_DP * HourFrom1999Oct22UT0000 + 18.0_DP
   216:                 else if ( HourFrom1999Oct22UT0000 <= 65.6_DP ) then
   217: +V===== A         xy_SurfTemp = &
   218:                     & -  4.0_DP - 25.0_DP * cos( 0.22 * HourFrom1999Oct22UT0000 + 2.5_DP )
   219:                 else
   220: W*===== A         xy_SurfTemp = &
   221:                     &    4.4_DP
   222:                 end if
   223:             
   224: W*===== A       xy_SurfTemp = xy_SurfTemp + 273.15_DP
   225:             
   226:             
   227:               end subroutine SetGabls2SurfTemp
   228:             
   229:               !--------------------------------------------------------------------------------------
   230:             
   231:               subroutine GablsInit
   232:                 !
   233:                 ! rad_short_income モジュールの初期化を行います. 
   234:                 ! NAMELIST#rad_short_income_nml の読み込みはこの手続きで行われます. 
   235:                 !
   236:                 ! "rad_short_income" module is initialized. 
   237:                 ! "NAMELIST#rad_short_income_nml" is loaded in this procedure. 
   238:                 !
   239:             
   240:                 ! モジュール引用 ; USE statements
   241:                 !
   242:             
   243:                 ! 種別型パラメタ
   244:                 ! Kind type parameter
   245:                 !
   246:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   247:             
   248:                 ! ファイル入出力補助
   249:                 ! File I/O support
   250:                 !
   251:                 use dc_iounit, only: FileOpen
   252:             
   253:                 ! ヒストリデータ出力
   254:                 ! History data output
   255:                 !
   256:                 use gtool_historyauto, only: HistoryAutoAddVariable
   257:             
   258:                 ! 暦と日時の取り扱い
   259:                 ! Calendar and Date handler
   260:                 !
   261:                 use dc_calendar, only: &
   262:                   & DC_CAL_DATE, &          ! 日時を表現するデータ型.
   263:                                             ! Data type for date and time
   264:                   & DCCalDateInquire, DCCalDateCreate, DCCalDateDifference, &
   265:                   & DCCalConvertByUnit
   266:             
   267:                 ! NAMELIST ファイル入力に関するユーティリティ
   268:                 ! Utilities for NAMELIST file input
   269:                 !
   270:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   271:             
   272:                 ! 宣言文 ; Declaration statements
   273:                 !
   274:                 implicit none
   275:             
   276:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   277:             !!$                              ! Unit number for NAMELIST file open
   278:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   279:             !!$                              ! IOSTAT of NAMELIST read
   280:             
   281:             
   282:                 ! NAMELIST 変数群
   283:                 ! NAMELIST group name
   284:                 !
   285:             !!$    namelist /gabls_nml/                                     &
   286:             !!$      & FlagRadSynchronous
   287:                       !
   288:                       ! デフォルト値については初期化手続 "rad_short_income#RadShortIncomeInit" 
   289:                       ! のソースコードを参照のこと. 
   290:                       !
   291:                       ! Refer to source codes in the initialization procedure
   292:                       ! "rad_short_income#RadShortIncomeInit" for the default values. 
   293:                       !
   294:             
   295:                 ! 実行文 ; Executable statement
   296:                 !
   297:             
   298:                 if ( gabls_inited ) return
   299:             
   300:             
   301:                 ! デフォルト値の設定
   302:                 ! Default values settings
   303:                 !
   304:             !!$    FlagRadSynchronous       = .false.
   305:             
   306:             
   307:                 ! NAMELIST の読み込み
   308:                 ! NAMELIST is input
   309:                 !
   310:             !!$    if ( trim(namelist_filename) /= '' ) then
   311:             !!$      call FileOpen( unit_nml, &          ! (out)
   312:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   313:             !!$
   314:             !!$      rewind( unit_nml )
   315:             !!$      read( unit_nml, &                ! (in)
   316:             !!$        & nml = gabls_nml, &           ! (out)
   317:             !!$        & iostat = iostat_nml )        ! (out)
   318:             !!$      close( unit_nml )
   319:             !!$
   320:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   321:             !!$    end if
   322:             
   323:             
   324:             
   325:                 ! 印字 ; Print
   326:                 !
   327:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   328:             !!$    call MessageNotify( 'M', module_name, '  FlagRadSynchronous       = %b', l = (/ FlagRadSynchronous /) )
   329:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   330:             
   331:                 gabls_inited = .true.
   332:             
   333:               end subroutine GablsInit
   334:             
   335:               !-------------------------------------------------------------------
   336:             
   337:             end module gabls
