Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: modify_albedo_snowseaice.f90
PROGRAM NAME: modify_albedo_snowseaice
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   149  vec  (   3): Unvectorized loop.
   152  opt  (1025): Reference to this function inhibits optimization.
   152  vec  (  10): Vectorization obstructive procedure reference.:seaiceabovethreshold
   184  opt  (1593): Loop nest collapsed into one loop.
   184  vec  (   1): Vectorized loop.
   184  vec  (  29): ADB is used for array.: xy_surfalbedo
   184  vec  (  29): ADB is used for array.: xy_soseaicemass
   184  vec  (  29): ADB is used for array.: xy_surftype
   205  opt  (1593): Loop nest collapsed into one loop.
   205  vec  (   1): Vectorized loop.
   205  vec  (  29): ADB is used for array.: xy_surfalbedo
   205  vec  (  29): ADB is used for array.: xy_surftemp
   205  vec  (  29): ADB is used for array.: xy_surftype
   231  opt  (1593): Loop nest collapsed into one loop.
   231  vec  (   1): Vectorized loop.
   231  vec  (  29): ADB is used for array.: xy_surfalbedo
   231  vec  (  29): ADB is used for array.: xy_snowfrac
   231  vec  (  29): ADB is used for array.: xy_surftype
   271  vec  (   1): Vectorized loop.
   271  vec  (  29): ADB is used for array.: xy_surfalbedo
   271  vec  (  29): ADB is used for array.: xy_surfmajcompice
   271  vec  (  29): ADB is used for array.: xy_surftype
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: modify_albedo_snowseaice.f90
PROGRAM NAME: modify_albedo_snowseaice
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 雪と海氷によるアルベド変化
     2  !
     3  != modification of surface albedo on the snow covered ground and on the sea ice
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: modify_albedo_snowseaice.f90,v 1.6 2015/01/29 12:08:40 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module modify_albedo_snowseaice
    13  
    14    ! モジュール引用 ; USE statements
    15    !
    16  
    17    ! 種別型パラメタ
    18    ! Kind type parameter
    19    !
    20    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    21      &                 STRING     ! 文字列.       Strings.
    22  
    23    ! メッセージ出力
    24    ! Message output
    25    !
    26    use dc_message, only: MessageNotify
    27  
    28    ! 格子点設定
    29    ! Grid points settings
    30  
    31    ! 宣言文 ; Declaration statements
    32    !
    33    implicit none
    34    private
    35  
    36    ! 公開手続き
    37    ! Public procedure
    38    !
    39    public :: ModAlbedoDueToSnowSeaIce
    40    public :: ModAlbedoSnowSeaIceInit
    41  
    42    ! 公開変数
    43    ! Public variables
    44    !
    45  
    46    ! 非公開変数
    47    ! Private variables
    48    !
    49  
    50    logical, save :: FlagModAlbedoBasedOnTemp
    51  
    52    logical, save :: modify_albedo_snowseaice_inited = .false.
    53                                ! 初期設定フラグ.
    54                                ! Initialization flag
    55  
    56    character(*), parameter:: module_name = 'modify_albedo_snowseaice'
    57                                ! モジュールの名称.
    58                                ! Module name
    59    character(*), parameter:: version = &
    60      & '$Name:  $' // &
    61      & '$Id: modify_albedo_snowseaice.f90,v 1.6 2015/01/29 12:08:40 yot Exp $'
    62                                ! モジュールのバージョン
    63                                ! Module version
    64  
    65  contains
    66  
    67    !--------------------------------------------------------------------------------------
    68  
    69    subroutine ModAlbedoDueToSnowSeaIce(                                &
    70      & xy_SurfType,                                                    &
    71      & xy_SurfMajCompIce, xy_SurfSnow, xy_SeaIceConc, xy_SOSeaIceMass, & ! (in   ) optional
    72      & xy_SurfTemp,                                                    & ! (in   ) optional
    73      & xy_SurfAlbedo                                                   & ! (inout)
    74      )
    75  
    76      ! モジュール引用 ; USE statements
    77      !
    78  
    79      ! 格子点設定
    80      ! Grid points settings
    81      !
    82      use gridset, only: imax, & ! 経度格子点数.
    83                                 ! Number of grid points in longitude
    84        &                jmax, & ! 緯度格子点数.
    85                                 ! Number of grid points in latitude
    86        &                kmax    ! 鉛直層数.
    87                                 ! Number of vertical level
    88  
    89      ! 座標データ設定
    90      ! Axes data settings
    91      !
    92      use axesset, only: y_Lat
    93  
    94      ! 雪と海氷の定数の設定
    95      ! Setting constants of snow and sea ice
    96      !
    97      use constants_snowseaice, only:            &
    98        & SnowAlbedo,                            &
    99        & SeaIceAlbedo,                          &
   100        & SOSeaIceThresholdMass,                 &
   101        & CO2IceThreshold,                       &
   102        & CO2IceAlbedoS,                         &
   103        & CO2IceAlbedoN,                         &
   104        & TempBelowSeaIce
   105  
   106      ! 雪, 氷の割合
   107      ! snow/ice fraction
   108      !
   109      use snowice_frac, only : CalcSnowFrac
   110  
   111      ! 雪, 氷の割合
   112      ! snow/ice fraction
   113      !
   114      use snowice_frac, only : SeaIceAboveThreshold
   115  
   116      integer , intent(in   )           :: xy_SurfType      ( 0:imax-1, 1:jmax )
   117      real(DP), intent(in   ), optional :: xy_SurfMajCompIce( 0:imax-1, 1:jmax )
   118      real(DP), intent(in   ), optional :: xy_SurfSnow      ( 0:imax-1, 1:jmax )
   119      real(DP), intent(in   ), optional :: xy_SeaIceConc    ( 0:imax-1, 1:jmax )
   120      real(DP), intent(in   ), optional :: xy_SOSeaIceMass  ( 0:imax-1, 1:jmax )
   121      real(DP), intent(in   ), optional :: xy_SurfTemp      ( 0:imax-1, 1:jmax )
   122      real(DP), intent(inout)           :: xy_SurfAlbedo    ( 0:imax-1, 1:jmax )
   123  
   124  
   125      ! 作業変数
   126      ! Work variables
   127      !
   128      real(DP):: xy_SnowFrac(0:imax-1, 1:jmax)
   129      real(DP):: MajCompIceThreshold
   130      real(DP):: MajCompIceAlbedo
   131      integer:: i               ! 経度方向に回る DO ループ用作業変数
   132                                ! Work variables for DO loop in longitude
   133      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   134                                ! Work variables for DO loop in latitude
   135  
   136      ! 初期化確認
   137      ! Initialization check
   138      !
   139      if ( .not. modify_albedo_snowseaice_inited ) then
   140        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   141      end if
   142  
   143  
   144  
   145      if ( present( xy_SeaIceConc ) ) then
   146        ! modify surface albedo on the sea ice
   147        !
   148        do j = 1, jmax
   149          do i = 0, imax-1
   150  
   151  
   152            if ( ( xy_SurfType(i,j) == 0                  ) .and. &
   153              &  SeaIceAboveThreshold( xy_SeaIceConc(i,j) ) ) then
   154              xy_SurfAlbedo(i,j) = SeaIceAlbedo
   155            end if
   156  
   157  !!$          if ( xy_SurfType(i,j) == 0 ) then
   158  !!$            if ( xy_SeaIceConc(i,j) > 1.0_DP ) then
   159  !!$!              call MessageNotify( 'E', module_name,                &
   160  !!$!                & 'The value of SeaIceConc is inappropriate, %f.', &
   161  !!$!                & d = (/ xy_SeaIceConc(i,j) / ) )
   162  !!$              xy_SurfAlbedo(i,j) = SeaIceAlbedo
   163  !!$            else if ( xy_SeaIceConc(i,j) < 0.0_DP ) then
   164  !!$!              call MessageNotify( 'E', module_name,                &
   165  !!$!                & 'The value of SeaIceConc is inappropriate, %f.', &
   166  !!$!                & d = (/ xy_SeaIceConc(i,j) / ) )
   167  !!$              xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j)
   168  !!$            else
   169  !!$              xy_SurfAlbedo(i,j) =                                             &
   170  !!$                & ( SeaIceAlbedo - xy_SurfAlbedo(i,j) ) / ( 1.0_DP - 0.0_DP )  &
   171  !!$                & * ( xy_SeaIceConc(i,j) - 0.0_DP )                            &
   172  !!$                & + xy_SurfAlbedo(i,j)
   173  !!$            end if
   174  !!$          end if
   175  
   176          end do
   177        end do
   178      end if
   179  
   180  
   181      if ( present( xy_SOSeaIceMass ) ) then
   182        ! modify surface albedo on slab sea ice
   183        !
   184        do j = 1, jmax
   185          do i = 0, imax-1
   186  
   187  
   188            if ( xy_SurfType(i,j) == 0 ) then
   189              if ( xy_SOSeaIceMass(i,j) >= SOSeaIceThresholdMass ) then
   190                xy_SurfAlbedo(i,j) = SeaIceAlbedo
   191              end if
   192            end if
   193  
   194          end do
   195        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .eq. 0) then                            
     .              if (xy_soseaicemass(j-1,1) .ge. soseaicethresholdmass) then 
     .                 xy_surfalbedo(j-1,1) = seaicealbedo                      
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   196      end if
   197  
   198      if ( FlagModAlbedoBasedOnTemp ) then
   199        ! modify surface albedo on slab sea ice dependent on temperature
   200        !
   201        if ( .not. present( xy_SurfTemp ) ) then
   202          call MessageNotify( 'E', module_name, &
   203            & '  xy_SurfTemp has to be included arguments when FlagModAlbedoBaseOnTemp is true.' )
   204        end if
   205        do j = 1, jmax
   206          do i = 0, imax-1
   207  
   208            if ( xy_SurfType(i,j) == 0 ) then
   209              if ( xy_SurfTemp(i,j) <= TempBelowSeaIce ) then
   210                xy_SurfAlbedo(i,j) = SeaIceAlbedo
   211              end if
   212            end if
   213  
   214          end do
   215        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .eq. 0) then                            
     .              if (xy_surftemp(j-1,1) .le. tempbelowseaice) then           
     .                 xy_surfalbedo(j-1,1) = seaicealbedo                      
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   216      end if
   217  
   218      if ( present( xy_SurfSnow ) ) then
   219  
   220        ! 雪, 氷の割合
   221        ! snow/ice fraction
   222        !
   223        call CalcSnowFrac(       &
   224  !!$        & xy_FlagLand, xy_SurfSnow,  & ! (in )
   225          & xy_SurfSnow,               & ! (in )
   226          & xy_SnowFrac                & ! (out)
   227          & )
   228  
   229        ! modify surface albedo on the snow covered ground
   230        !
   231        do j = 1, jmax
   232          do i = 0, imax-1
   233  
   234  !!$          if ( xy_SurfType(i,j) > 0 .and. xy_SurfSnow(i,j) > SnowThreshold ) then
   235  !!$            xy_SurfAlbedo(i,j) = SnowAlbedo
   236  !!$          end if
   237  !!$
   238            if ( xy_SurfType(i,j) > 0 ) then
   239  !!$            if ( xy_SurfSnow(i,j) > SnowThreshold ) then
   240  !!$              xy_SurfAlbedo(i,j) = SnowAlbedo
   241  !!$            else if ( xy_SurfSnow(i,j) < 0.0_DP ) then
   242  !!$              xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j)
   243  !!$            else
   244  !!$              xy_SurfAlbedo(i,j) =                                                  &
   245  !!$                & ( SnowAlbedo - xy_SurfAlbedo(i,j) ) / ( SnowThreshold - 0.0_DP )  &
   246  !!$                & * ( xy_SurfSnow(i,j) - 0.0_DP )                                   &
   247  !!$                & + xy_SurfAlbedo(i,j)
   248  !!$            end if
   249              xy_SurfAlbedo(i,j) = &
   250                &   ( 1.0_DP - xy_SnowFrac(i,j) ) * xy_SurfAlbedo(i,j) &
   251                & + xy_SnowFrac(i,j)              * SnowAlbedo
   252            end if
   253  
   254  
   255          end do
   256        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .gt. 0) then                            
     .              xy_surfalbedo(j-1,1) = (1.00000000000000e+000 - xy_snowfrac(
     .       1         j-1,1))*xy_surfalbedo(j-1,1) + xy_snowfrac(j-1,1)*       
     .       2         snowalbedo                                               
     .           endif                                                          
     .        enddo                                                             
   257  
   258      end if
   259  
   260  
   261      if ( present( xy_SurfMajCompIce ) ) then
   262        ! modify surface albedo on the major component ice covered ground
   263        !
   264        MajCompIceThreshold = CO2IceThreshold
   265        do j = 1, jmax
   266          if ( y_Lat(j) < 0.0_DP ) then
   267            MajCompIceAlbedo = CO2IceAlbedoS
   268          else
   269            MajCompIceAlbedo = CO2IceAlbedoN
   270          end if
   271          do i = 0, imax-1
   272  
   273  !!$          if ( xy_SurfCond(i,j) > 0 .and. xy_SurfMajCompIce(i,j) > MajCompIceThreshold ) then
   274  !!$            xy_SurfAlbedo(i,j) = MajCompIceAlbedo
   275  !!$          end if
   276  
   277            if ( xy_SurfType(i,j) > 0 ) then
   278              if ( xy_SurfMajCompIce(i,j) > MajCompIceThreshold ) then
   279                xy_SurfAlbedo(i,j) = MajCompIceAlbedo
   280              else if ( xy_SurfMajCompIce(i,j) < 0.0_DP ) then
   281                xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j)
   282              else
   283                xy_SurfAlbedo(i,j) =                                                  &
   284                  & ( MajCompIceAlbedo - xy_SurfAlbedo(i,j) ) / ( MajCompIceThreshold - 0.0_DP )  &
   285                  & * ( xy_SurfMajCompIce(i,j) - 0.0_DP )                                   &
   286                  & + xy_SurfAlbedo(i,j)
   287              end if
   288            end if
   289  
   290          end do
     .  !cdir nodep                                                             
     .        do i = 1, imax                                                    
     .           if (xy_surftype(i-1,j) .gt. 0) then                            
     .              if (xy_surfmajcompice(i-1,j) .gt. majcompicethreshold) then 
     .                 xy_surfalbedo(i-1,j) = majcompicealbedo                  
     .              else                                                        
     .                 if (xy_surfmajcompice(i-1,j) .ge. 0.0000000000000000e+000
     .       1            ) then                                                
     .                    xy_surfalbedo(i-1,j) = (majcompicealbedo -            
     .       1               xy_surfalbedo(i-1,j))/(majcompicethreshold -       
     .       2               0.0000000000000000e+000)*(xy_surfmajcompice(i-1,j)-
     .       3               0.0000000000000000e+000) + xy_surfalbedo(i-1,j)    
     .                 endif                                                    
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   291        end do
   292  
   293      end if
   294  
   295  
   296    end subroutine ModAlbedoDueToSnowSeaIce
   297  
   298    !--------------------------------------------------------------------------------------
   299  
   300    subroutine ModAlbedoSnowSeaIceInit
   301  
   302      ! モジュール引用 ; USE statements
   303      !
   304  
   305      ! NAMELIST ファイル入力に関するユーティリティ
   306      ! Utilities for NAMELIST file input
   307      !
   308      use namelist_util, only: namelist_filename, NmlutilMsg
   309  
   310      ! ファイル入出力補助
   311      ! File I/O support
   312      !
   313      use dc_iounit, only: FileOpen
   314  
   315      ! 種別型パラメタ
   316      ! Kind type parameter
   317      !
   318      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   319  
   320      ! メッセージ出力
   321      ! Message output
   322      !
   323      use dc_message, only: MessageNotify
   324  
   325      ! 雪, 氷の割合
   326      ! snow/ice fraction
   327      !
   328      use snowice_frac, only : SnowIceFracInit
   329  
   330  
   331      ! 宣言文 ; Declaration statements
   332      !
   333      implicit none
   334  
   335      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   336                                ! Unit number for NAMELIST file open
   337      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   338                                ! IOSTAT of NAMELIST read
   339  
   340      ! NAMELIST 変数群
   341      ! NAMELIST group name
   342      !
   343      namelist /modify_albedo_snowseaice_nml/ &
   344        & FlagModAlbedoBasedOnTemp
   345            !
   346            ! デフォルト値については初期化手続 "modify_albedo_snowseaice#ModAlbedoSnowSeaIceInit"
   347            ! のソースコードを参照のこと.
   348            !
   349            ! Refer to source codes in the initialization procedure
   350            ! "modify_albedo_snowseaice#ModAlbedoSnowSeaIceInit" for the default values.
   351            !
   352  
   353      ! 実行文 ; Executable statement
   354      !
   355  
   356  
   357      if ( modify_albedo_snowseaice_inited ) return
   358  
   359  
   360      ! デフォルト値の設定
   361      ! Default values settings
   362      !
   363      FlagModAlbedoBasedOnTemp = .false.
   364  
   365  
   366      ! NAMELIST からの入力
   367      ! Input from NAMELIST
   368      !
   369      if ( trim(namelist_filename) /= '' ) then
   370        call FileOpen( unit_nml, &          ! (out)
   371          & namelist_filename, mode = 'r' ) ! (in)
   372  
   373        rewind( unit_nml )
   374        read( unit_nml, &           ! (in)
   375          & nml = modify_albedo_snowseaice_nml, &  ! (out)
   376          & iostat = iostat_nml )   ! (out)
   377        close( unit_nml )
   378  
   379        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   380        if ( iostat_nml == 0 ) write( STDOUT, nml = modify_albedo_snowseaice_nml )
   381      end if
   382  
   383  
   384      ! 雪, 氷の割合
   385      ! snow/ice fraction
   386      !
   387      call SnowIceFracInit
   388  
   389  
   390      ! 印字 ; Print
   391      !
   392      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   393      call MessageNotify( 'M', module_name, '  FlagModAlbedoBaseOnTemp = %b', l = (/ FlagModAlbedoBasedOnTemp /) )
   394      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   395  
   396  
   397      modify_albedo_snowseaice_inited = .true.
   398  
   399    end subroutine ModAlbedoSnowSeaIceInit
   400  
   401    !--------------------------------------------------------------------------------------
   402  
   403  end module modify_albedo_snowseaice
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: modify_albedo_snowseaice.f90
PROGRAM NAME: modify_albedo_snowseaice
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 雪と海氷によるアルベド変化
     2:             !
     3:             != modification of surface albedo on the snow covered ground and on the sea ice
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: modify_albedo_snowseaice.f90,v 1.6 2015/01/29 12:08:40 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module modify_albedo_snowseaice
    13:             
    14:               ! モジュール引用 ; USE statements
    15:               !
    16:             
    17:               ! 種別型パラメタ
    18:               ! Kind type parameter
    19:               !
    20:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    21:                 &                 STRING     ! 文字列.       Strings.
    22:             
    23:               ! メッセージ出力
    24:               ! Message output
    25:               !
    26:               use dc_message, only: MessageNotify
    27:             
    28:               ! 格子点設定
    29:               ! Grid points settings
    30:             
    31:               ! 宣言文 ; Declaration statements
    32:               !
    33:               implicit none
    34:               private
    35:             
    36:               ! 公開手続き
    37:               ! Public procedure
    38:               !
    39:               public :: ModAlbedoDueToSnowSeaIce
    40:               public :: ModAlbedoSnowSeaIceInit
    41:             
    42:               ! 公開変数
    43:               ! Public variables
    44:               !
    45:             
    46:               ! 非公開変数
    47:               ! Private variables
    48:               !
    49:             
    50:               logical, save :: FlagModAlbedoBasedOnTemp
    51:             
    52:               logical, save :: modify_albedo_snowseaice_inited = .false.
    53:                                           ! 初期設定フラグ.
    54:                                           ! Initialization flag
    55:             
    56:               character(*), parameter:: module_name = 'modify_albedo_snowseaice'
    57:                                           ! モジュールの名称.
    58:                                           ! Module name
    59:               character(*), parameter:: version = &
    60:                 & '$Name:  $' // &
    61:                 & '$Id: modify_albedo_snowseaice.f90,v 1.6 2015/01/29 12:08:40 yot Exp $'
    62:                                           ! モジュールのバージョン
    63:                                           ! Module version
    64:             
    65:             contains
    66:             
    67:               !--------------------------------------------------------------------------------------
    68:             
    69:               subroutine ModAlbedoDueToSnowSeaIce(                                &
    70:                 & xy_SurfType,                                                    &
    71:                 & xy_SurfMajCompIce, xy_SurfSnow, xy_SeaIceConc, xy_SOSeaIceMass, & ! (in   ) optional
    72:                 & xy_SurfTemp,                                                    & ! (in   ) optional
    73:                 & xy_SurfAlbedo                                                   & ! (inout)
    74:                 )
    75:             
    76:                 ! モジュール引用 ; USE statements
    77:                 !
    78:             
    79:                 ! 格子点設定
    80:                 ! Grid points settings
    81:                 !
    82:                 use gridset, only: imax, & ! 経度格子点数.
    83:                                            ! Number of grid points in longitude
    84:                   &                jmax, & ! 緯度格子点数.
    85:                                            ! Number of grid points in latitude
    86:                   &                kmax    ! 鉛直層数.
    87:                                            ! Number of vertical level
    88:             
    89:                 ! 座標データ設定
    90:                 ! Axes data settings
    91:                 !
    92:                 use axesset, only: y_Lat
    93:             
    94:                 ! 雪と海氷の定数の設定
    95:                 ! Setting constants of snow and sea ice
    96:                 !
    97:                 use constants_snowseaice, only:            &
    98:                   & SnowAlbedo,                            &
    99:                   & SeaIceAlbedo,                          &
   100:                   & SOSeaIceThresholdMass,                 &
   101:                   & CO2IceThreshold,                       &
   102:                   & CO2IceAlbedoS,                         &
   103:                   & CO2IceAlbedoN,                         &
   104:                   & TempBelowSeaIce
   105:             
   106:                 ! 雪, 氷の割合
   107:                 ! snow/ice fraction
   108:                 !
   109:                 use snowice_frac, only : CalcSnowFrac
   110:             
   111:                 ! 雪, 氷の割合
   112:                 ! snow/ice fraction
   113:                 !
   114:                 use snowice_frac, only : SeaIceAboveThreshold
   115:             
   116:                 integer , intent(in   )           :: xy_SurfType      ( 0:imax-1, 1:jmax )
   117:                 real(DP), intent(in   ), optional :: xy_SurfMajCompIce( 0:imax-1, 1:jmax )
   118:                 real(DP), intent(in   ), optional :: xy_SurfSnow      ( 0:imax-1, 1:jmax )
   119:                 real(DP), intent(in   ), optional :: xy_SeaIceConc    ( 0:imax-1, 1:jmax )
   120:                 real(DP), intent(in   ), optional :: xy_SOSeaIceMass  ( 0:imax-1, 1:jmax )
   121:                 real(DP), intent(in   ), optional :: xy_SurfTemp      ( 0:imax-1, 1:jmax )
   122:                 real(DP), intent(inout)           :: xy_SurfAlbedo    ( 0:imax-1, 1:jmax )
   123:             
   124:             
   125:                 ! 作業変数
   126:                 ! Work variables
   127:                 !
   128:                 real(DP):: xy_SnowFrac(0:imax-1, 1:jmax)
   129:                 real(DP):: MajCompIceThreshold
   130:                 real(DP):: MajCompIceAlbedo
   131:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   132:                                           ! Work variables for DO loop in longitude
   133:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   134:                                           ! Work variables for DO loop in latitude
   135:             
   136:                 ! 初期化確認
   137:                 ! Initialization check
   138:                 !
   139:                 if ( .not. modify_albedo_snowseaice_inited ) then
   140:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   141:                 end if
   142:             
   143:             
   144:             
   145:                 if ( present( xy_SeaIceConc ) ) then
   146:                   ! modify surface albedo on the sea ice
   147:                   !
   148: +------>          do j = 1, jmax
   149: |+----->            do i = 0, imax-1
   150: ||          
   151: ||          
   152: ||                    if ( ( xy_SurfType(i,j) == 0                  ) .and. &
   153: ||                      &  SeaIceAboveThreshold( xy_SeaIceConc(i,j) ) ) then
   154: ||                      xy_SurfAlbedo(i,j) = SeaIceAlbedo
   155: ||                    end if
   156: ||          
   157: ||          !!$          if ( xy_SurfType(i,j) == 0 ) then
   158: ||          !!$            if ( xy_SeaIceConc(i,j) > 1.0_DP ) then
   159: ||          !!$!              call MessageNotify( 'E', module_name,                &
   160: ||          !!$!                & 'The value of SeaIceConc is inappropriate, %f.', &
   161: ||          !!$!                & d = (/ xy_SeaIceConc(i,j) / ) )
   162: ||          !!$              xy_SurfAlbedo(i,j) = SeaIceAlbedo
   163: ||          !!$            else if ( xy_SeaIceConc(i,j) < 0.0_DP ) then
   164: ||          !!$!              call MessageNotify( 'E', module_name,                &
   165: ||          !!$!                & 'The value of SeaIceConc is inappropriate, %f.', &
   166: ||          !!$!                & d = (/ xy_SeaIceConc(i,j) / ) )
   167: ||          !!$              xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j)
   168: ||          !!$            else
   169: ||          !!$              xy_SurfAlbedo(i,j) =                                             &
   170: ||          !!$                & ( SeaIceAlbedo - xy_SurfAlbedo(i,j) ) / ( 1.0_DP - 0.0_DP )  &
   171: ||          !!$                & * ( xy_SeaIceConc(i,j) - 0.0_DP )                            &
   172: ||          !!$                & + xy_SurfAlbedo(i,j)
   173: ||          !!$            end if
   174: ||          !!$          end if
   175: ||          
   176: |+-----             end do
   177: +------           end do
   178:                 end if
   179:             
   180:             
   181:                 if ( present( xy_SOSeaIceMass ) ) then
   182:                   ! modify surface albedo on slab sea ice
   183:                   !
   184: W------>          do j = 1, jmax
   185: |*----->            do i = 0, imax-1
   186: ||          
   187: ||          
   188: ||      A             if ( xy_SurfType(i,j) == 0 ) then
   189: ||      A               if ( xy_SOSeaIceMass(i,j) >= SOSeaIceThresholdMass ) then
   190: ||      A                 xy_SurfAlbedo(i,j) = SeaIceAlbedo
   191: ||                      end if
   192: ||                    end if
   193: ||          
   194: |*-----             end do
   195: W------           end do
   196:                 end if
   197:             
   198:                 if ( FlagModAlbedoBasedOnTemp ) then
   199:                   ! modify surface albedo on slab sea ice dependent on temperature
   200:                   !
   201:                   if ( .not. present( xy_SurfTemp ) ) then
   202:                     call MessageNotify( 'E', module_name, &
   203:                       & '  xy_SurfTemp has to be included arguments when FlagModAlbedoBaseOnTemp is true.' )
   204:                   end if
   205: W------>          do j = 1, jmax
   206: |*----->            do i = 0, imax-1
   207: ||          
   208: ||      A             if ( xy_SurfType(i,j) == 0 ) then
   209: ||      A               if ( xy_SurfTemp(i,j) <= TempBelowSeaIce ) then
   210: ||      A                 xy_SurfAlbedo(i,j) = SeaIceAlbedo
   211: ||                      end if
   212: ||                    end if
   213: ||          
   214: |*-----             end do
   215: W------           end do
   216:                 end if
   217:             
   218:                 if ( present( xy_SurfSnow ) ) then
   219:             
   220:                   ! 雪, 氷の割合
   221:                   ! snow/ice fraction
   222:                   !
   223:                   call CalcSnowFrac(       &
   224:             !!$        & xy_FlagLand, xy_SurfSnow,  & ! (in )
   225:                     & xy_SurfSnow,               & ! (in )
   226:                     & xy_SnowFrac                & ! (out)
   227:                     & )
   228:             
   229:                   ! modify surface albedo on the snow covered ground
   230:                   !
   231: W------>          do j = 1, jmax
   232: |*----->            do i = 0, imax-1
   233: ||          
   234: ||          !!$          if ( xy_SurfType(i,j) > 0 .and. xy_SurfSnow(i,j) > SnowThreshold ) then
   235: ||          !!$            xy_SurfAlbedo(i,j) = SnowAlbedo
   236: ||          !!$          end if
   237: ||          !!$
   238: ||      A             if ( xy_SurfType(i,j) > 0 ) then
   239: ||          !!$            if ( xy_SurfSnow(i,j) > SnowThreshold ) then
   240: ||          !!$              xy_SurfAlbedo(i,j) = SnowAlbedo
   241: ||          !!$            else if ( xy_SurfSnow(i,j) < 0.0_DP ) then
   242: ||          !!$              xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j)
   243: ||          !!$            else
   244: ||          !!$              xy_SurfAlbedo(i,j) =                                                  &
   245: ||          !!$                & ( SnowAlbedo - xy_SurfAlbedo(i,j) ) / ( SnowThreshold - 0.0_DP )  &
   246: ||          !!$                & * ( xy_SurfSnow(i,j) - 0.0_DP )                                   &
   247: ||          !!$                & + xy_SurfAlbedo(i,j)
   248: ||          !!$            end if
   249: ||      A               xy_SurfAlbedo(i,j) = &
   250: ||                        &   ( 1.0_DP - xy_SnowFrac(i,j) ) * xy_SurfAlbedo(i,j) &
   251: ||                        & + xy_SnowFrac(i,j)              * SnowAlbedo
   252: ||                    end if
   253: ||          
   254: ||          
   255: |*-----             end do
   256: W------           end do
   257:             
   258:                 end if
   259:             
   260:             
   261:                 if ( present( xy_SurfMajCompIce ) ) then
   262:                   ! modify surface albedo on the major component ice covered ground
   263:                   !
   264:                   MajCompIceThreshold = CO2IceThreshold
   265: +------>          do j = 1, jmax
   266: |                   if ( y_Lat(j) < 0.0_DP ) then
   267: |                     MajCompIceAlbedo = CO2IceAlbedoS
   268: |                   else
   269: |                     MajCompIceAlbedo = CO2IceAlbedoN
   270: |                   end if
   271: |V----->            do i = 0, imax-1
   272: ||          
   273: ||          !!$          if ( xy_SurfCond(i,j) > 0 .and. xy_SurfMajCompIce(i,j) > MajCompIceThreshold ) then
   274: ||          !!$            xy_SurfAlbedo(i,j) = MajCompIceAlbedo
   275: ||          !!$          end if
   276: ||          
   277: ||                    if ( xy_SurfType(i,j) > 0 ) then
   278: ||      A               if ( xy_SurfMajCompIce(i,j) > MajCompIceThreshold ) then
   279: ||      A                 xy_SurfAlbedo(i,j) = MajCompIceAlbedo
   280: ||                      else if ( xy_SurfMajCompIce(i,j) < 0.0_DP ) then
   281: ||                        xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j)
   282: ||                      else
   283: ||      A                 xy_SurfAlbedo(i,j) =                                                  &
   284: ||                          & ( MajCompIceAlbedo - xy_SurfAlbedo(i,j) ) / ( MajCompIceThreshold - 0.0_DP )  &
   285: ||                          & * ( xy_SurfMajCompIce(i,j) - 0.0_DP )                                   &
   286: ||                          & + xy_SurfAlbedo(i,j)
   287: ||                      end if
   288: ||                    end if
   289: ||          
   290: |V-----             end do
   291: +------           end do
   292:             
   293:                 end if
   294:             
   295:             
   296:               end subroutine ModAlbedoDueToSnowSeaIce
   297:             
   298:               !--------------------------------------------------------------------------------------
   299:             
   300:               subroutine ModAlbedoSnowSeaIceInit
   301:             
   302:                 ! モジュール引用 ; USE statements
   303:                 !
   304:             
   305:                 ! NAMELIST ファイル入力に関するユーティリティ
   306:                 ! Utilities for NAMELIST file input
   307:                 !
   308:                 use namelist_util, only: namelist_filename, NmlutilMsg
   309:             
   310:                 ! ファイル入出力補助
   311:                 ! File I/O support
   312:                 !
   313:                 use dc_iounit, only: FileOpen
   314:             
   315:                 ! 種別型パラメタ
   316:                 ! Kind type parameter
   317:                 !
   318:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   319:             
   320:                 ! メッセージ出力
   321:                 ! Message output
   322:                 !
   323:                 use dc_message, only: MessageNotify
   324:             
   325:                 ! 雪, 氷の割合
   326:                 ! snow/ice fraction
   327:                 !
   328:                 use snowice_frac, only : SnowIceFracInit
   329:             
   330:             
   331:                 ! 宣言文 ; Declaration statements
   332:                 !
   333:                 implicit none
   334:             
   335:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   336:                                           ! Unit number for NAMELIST file open
   337:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   338:                                           ! IOSTAT of NAMELIST read
   339:             
   340:                 ! NAMELIST 変数群
   341:                 ! NAMELIST group name
   342:                 !
   343:                 namelist /modify_albedo_snowseaice_nml/ &
   344:                   & FlagModAlbedoBasedOnTemp
   345:                       !
   346:                       ! デフォルト値については初期化手続 "modify_albedo_snowseaice#ModAlbedoSnowSeaIceInit" 
   347:                       ! のソースコードを参照のこと. 
   348:                       !
   349:                       ! Refer to source codes in the initialization procedure
   350:                       ! "modify_albedo_snowseaice#ModAlbedoSnowSeaIceInit" for the default values. 
   351:                       !
   352:             
   353:                 ! 実行文 ; Executable statement
   354:                 !
   355:             
   356:             
   357:                 if ( modify_albedo_snowseaice_inited ) return
   358:             
   359:             
   360:                 ! デフォルト値の設定
   361:                 ! Default values settings
   362:                 !
   363:                 FlagModAlbedoBasedOnTemp = .false.
   364:             
   365:             
   366:                 ! NAMELIST からの入力
   367:                 ! Input from NAMELIST
   368:                 !
   369:                 if ( trim(namelist_filename) /= '' ) then
   370:                   call FileOpen( unit_nml, &          ! (out)
   371:                     & namelist_filename, mode = 'r' ) ! (in)
   372:             
   373:                   rewind( unit_nml )
   374:                   read( unit_nml, &           ! (in)
   375:                     & nml = modify_albedo_snowseaice_nml, &  ! (out)
   376:                     & iostat = iostat_nml )   ! (out)
   377:                   close( unit_nml )
   378:             
   379:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   380:                   if ( iostat_nml == 0 ) write( STDOUT, nml = modify_albedo_snowseaice_nml )
   381:                 end if
   382:             
   383:             
   384:                 ! 雪, 氷の割合
   385:                 ! snow/ice fraction
   386:                 !
   387:                 call SnowIceFracInit
   388:             
   389:             
   390:                 ! 印字 ; Print
   391:                 !
   392:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   393:                 call MessageNotify( 'M', module_name, '  FlagModAlbedoBaseOnTemp = %b', l = (/ FlagModAlbedoBasedOnTemp /) )
   394:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   395:             
   396:             
   397:                 modify_albedo_snowseaice_inited = .true.
   398:             
   399:               end subroutine ModAlbedoSnowSeaIceInit
   400:             
   401:               !--------------------------------------------------------------------------------------
   402:             
   403:             end module modify_albedo_snowseaice
