Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: roughlen_Matthews.f90
PROGRAM NAME: roughlen_matthews
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   211  vec  (   4): Vectorized array expression.
   214  vec  (   4): Vectorized array expression.
   216  vec  (   4): Vectorized array expression.
   216  vec  (  29): ADB is used for array.: datam84rlratiomomtoheat
   227  opt  (1593): Loop nest collapsed into one loop.
   227  vec  (   1): Vectorized loop.
   227  vec  (  29): ADB is used for array.: xy_surfroughlen
   227  vec  (  29): ADB is used for array.: xy_surftype
   235  opt  (1593): Loop nest collapsed into one loop.
   235  vec  (   1): Vectorized loop.
   235  vec  (  29): ADB is used for array.: xy_surfroughlen
   235  vec  (  29): ADB is used for array.: datam84weight
   235  vec  (  29): ADB is used for array.: datasurftype2m84type
   235  vec  (  29): ADB is used for array.: xy_surftype
   249  opt  (1772): Loop nest fused with following nest(s).
   249  opt  (1593): Loop nest collapsed into one loop.
   249  vec  (   1): Vectorized loop.
   249  vec  (  29): ADB is used for array.: xy_surfroughlen
   249  vec  (  29): ADB is used for array.: xy_surftype
   325  vec  (   4): Vectorized array expression.
   325  vec  (  29): ADB is used for array.: a_ratiomomtoheat
   328  vec  (   4): Vectorized array expression.
   328  vec  (  29): ADB is used for array.: a_ratiomomtoheat
   330  vec  (   4): Vectorized array expression.
   330  vec  (  29): ADB is used for array.: a_ratiomomtoheat
   330  vec  (  29): ADB is used for array.: datam84rlratiomomtoheat
   341  vec  (   1): Vectorized loop.
   341  vec  (  29): ADB is used for array.: datam84weight
   341  vec  (  29): ADB is used for array.: a_ratiomomtoheat
   341  vec  (  29): ADB is used for array.: datam84rl
   342  vec  (  26): Macro operation Sum/InnerProd.
   347  opt  (1593): Loop nest collapsed into one loop.
   347  vec  (   1): Vectorized loop.
   347  vec  (  29): ADB is used for array.: xy_surfroughlen
   347  vec  (  29): ADB is used for array.: xy_surfculint
   347  vec  (  29): ADB is used for array.: xy_surftype
   476  opt  (1593): Loop nest collapsed into one loop.
   476  vec  (   1): Vectorized loop.
   476  vec  (  29): ADB is used for array.: datam84weight
   481  vec  (   1): Vectorized loop.
   481  vec  (  29): ADB is used for array.: datam84rl
   592  warn (   7): Characters in a line over this form limitation.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: roughlen_Matthews.f90
PROGRAM NAME: roughlen_matthews
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Matthews のデータに基づく地面粗度の設定
     2  !
     3  != set roughness length on land surface based on data by Matthews
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: roughlen_Matthews.f90,v 1.9 2015/01/29 12:08:40 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module roughlen_Matthews
    13  
    14    !== References
    15    !
    16    !  Matthews, E.,
    17    !    Global vegetation and land use: New high-resolution data bases for climate
    18    !    studies,
    19    !    J. Clim. Appl. Meteor., 22, 474, 1983.
    20    !
    21    !  Matthews, E.,
    22    !    Prescription of land-surface boundary conditions in GISS GCM II:
    23    !    A simple method based on fine-resolution data bases,
    24    !    NASA Technical memorandum #86096, 1984.
    25  
    26    ! モジュール引用 ; USE statements
    27    !
    28  
    29    ! 種別型パラメタ
    30    ! Kind type parameter
    31    !
    32    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    33      &                 STRING     ! 文字列.       Strings.
    34  
    35    ! メッセージ出力
    36    ! Message output
    37    !
    38    use dc_message, only: MessageNotify
    39  
    40    ! 宣言文 ; Declaration statements
    41    !
    42    implicit none
    43    private
    44  
    45    ! 公開手続き
    46    ! Public procedure
    47    !
    48    public:: SetRoughLenLandMatthews
    49    public:: ModRoughLenMatthewsCultivation
    50    public:: RoughLenMatthewsInit
    51  
    52    ! 公開変数
    53    ! Public variables
    54    !
    55  
    56    ! 非公開変数
    57    ! Private variables
    58    !
    59    logical, save :: roughlen_matthews_inited = .false.
    60                                ! 初期設定フラグ.
    61                                ! Initialization flag
    62  
    63    integer, parameter :: NLandUseType = 32
    64    integer, parameter :: NM84Element  =  9
    65    integer, parameter :: NM84Type     = 22
    66  
    67    integer, parameter :: IndexCultivation = 32
    68  
    69    integer   , save      :: DataSurfType2M84Type( 0:NLandUseType )
    70    real(DP)  , save      :: DataM84Weight( NM84Element, 0:NM84Type )
    71    real(DP)  , save      :: DataM84RL( NM84Element )
    72    real(DP)  , save      :: DataM84RLRatioMomToHeat( NM84Element )
    73  
    74    real(DP)  , save      :: RoughLenOcean
    75  
    76    real(DP)  , save      :: RoughLenIce
    77  
    78    logical   , save      :: FlagRoughLenHeatSameAsMom
    79  
    80  
    81    !
    82    ! Matthews (1984) grouped UNESCO land use type into 22 groups, whose properties
    83    ! can be constructed by conbining properties of those of 9 land use 'elemental
    84    ! groups'. Note that a word 'elemental group' is not used by Matthews (1984).
    85    !
    86    !
    87    ! Table 2B of Matthews (1984), NASA Technical memorandum #86096
    88    !
    89    ! 9 'elemental group' is as follows.
    90    !   #1 desert
    91    !   #2 tundra
    92    !   #3 grassland
    93    !   #4 grassland with shrub cover
    94    !   #5 grassland with tree cover
    95    !   #6 deciduous forest
    96    !   #7 evergreen forest
    97    !   #8 rainforest
    98    !   #9 ice
    99    !
   100    !     %1   %2   %3   %4   %5   %6   %7   %8   %9
   101    data DataM84Weight / &
   102           0,   0,   0,   0,   0,   0,   0,   0,   0, & !  0, This is not included in Matthews papers.
   103           0,   0,   0,   0,   0,   0,   0, 100,   0, & !  1
   104           0,   0,  25,   0,   0,   0,  75,   0,   0, & !  2
   105          40,   0,   0,   0,   0,   0,  60,   0,   0, & !  3
   106           0,   0,   0,   0,   0,   0, 100,   0,   0, & !  4
   107           0,   0,  25,   0,   0,  75,   0,   0,   0, & !  5
   108           0,   0,   0,   0,   0, 100,   0,   0,   0, & !  6
   109          15,   0,   0,   0,   0,  85,   0,   0,   0, & !  7
   110          85,   0,   0,   0,   0,  15,   0,   0,   0, & !  8
   111          35,   0,   0,   0,   0,   0,  65,   0,   0, & !  9
   112          25,   0,  25,   0,   0,   0,  50,   0,   0, & ! 10
   113          35,   0,   0,   0,   0,  65,   0,   0,   0, & ! 11
   114          30,   0,   0,   0,   0,  70,   0,   0,   0, & ! 12
   115           0,   0,  50,   0,   0,  50,   0,   0,   0, & ! 13
   116          10,   0,  80,   0,   0,   0,  10,   0,   0, & ! 14
   117          10,   0,  80,   0,   0,  10,   0,   0,   0, & ! 15
   118           0, 100,   0,   0,   0,   0,   0,   0,   0, & ! 16
   119           0,   0,   0,   0, 100,   0,   0,   0,   0, & ! 17
   120           0,   0,   0, 100,   0,   0,   0,   0,   0, & ! 18
   121           0,   0, 100,   0,   0,   0,   0,   0,   0, & ! 19
   122         100,   0,   0,   0,   0,   0,   0,   0,   0, & ! 20
   123           0,   0,   0,   0,   0,   0,   0,   0, 100, & ! 21 ice
   124          30,   0,   0,   0,   0,   0,  70,   0,   0  & ! 22
   125          /
   126  
   127    !
   128    ! roughness length
   129    ! Table 3 of Matthews (1984). unit is cm.
   130    ! A value of roughness length for ice is not included in Matthews (1984).
   131    !
   132    !     %1     %2      %3      %4      %5      %6       %7        %8        %9
   133    data DataM84RL / &
   134         0.5_DP, 0.5_DP, 1.0_DP, 1.0_DP, 1.8_DP, 32.0_DP, 100.0_DP, 200.0_DP, 0.0_DP &
   135         /
   136  
   137    !
   138    ! ratio of roughness length for momentum to that for heat
   139    ! Our strategy is that roughness length for heat on ocean, ice, and trees
   140    ! are the same as those for momentum. Roughness length for heat on other
   141    ! lands are 1/100 of those for momentum. The factor, 1/100, is based on
   142    ! ECMWF IFS (p.164, IFSPart4.pdf).
   143    !
   144    !    %1       %2       %3       %4       %5      %6      %7      %8      %9
   145    data DataM84RLRatioMomToHeat / &
   146         0.01_DP, 0.01_DP, 0.01_DP, 0.01_DP, 1.0_DP, 1.0_DP, 1.0_DP, 1.0_DP, 1.0_DP &
   147         /
   148  
   149  
   150  
   151    character(*), parameter:: module_name = 'roughlen_Matthews'
   152                                ! モジュールの名称.
   153                                ! Module name
   154    character(*), parameter:: version = &
   155      & '$Name:  $' // &
   156      & '$Id: roughlen_Matthews.f90,v 1.9 2015/01/29 12:08:40 yot Exp $'
   157                                ! モジュールのバージョン
   158                                ! Module version
   159  
   160  contains
   161  
   162    !--------------------------------------------------------------------------------------
   163  
   164    subroutine SetRoughLenLandMatthews( &
   165      & RoughLenType, xy_SurfType, &
   166      & xy_SurfRoughLen            &
   167      & )
   168  
   169      ! モジュール引用 ; USE statements
   170      !
   171  
   172      ! 格子点設定
   173      ! Grid points settings
   174      !
   175      use gridset, only: imax, & ! 経度格子点数.
   176                                 ! Number of grid points in longitude
   177        &                jmax, & ! 緯度格子点数.
   178                                 ! Number of grid points in latitude
   179        &                kmax    ! 鉛直層数.
   180                                 ! Number of vertical level
   181  
   182      ! 宣言文 ; Declaration statements
   183      !
   184      character(*), intent(in   ) :: RoughLenType
   185      integer , intent(in   ) :: xy_SurfType    ( 0:imax-1, 1:jmax )
   186      real(DP), intent(inout) :: xy_SurfRoughLen( 0:imax-1, 1:jmax )
   187  
   188  
   189      ! 作業変数
   190      ! Work variables
   191      !
   192      real(DP) :: a_RatioMomToHeat( NM84Element )
   193  
   194      integer:: i               ! 経度方向に回る DO ループ用作業変数
   195                                ! Work variables for DO loop in longitude
   196      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   197                                ! Work variables for DO loop in latitude
   198      integer:: l
   199  
   200  
   201      ! 初期化確認
   202      ! Initialization check
   203      !
   204      if ( .not. roughlen_matthews_inited ) then
   205        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   206      end if
   207  
   208  
   209      select case ( RoughLenType )
   210      case ( 'Mom' )
   211        a_RatioMomToHeat = 1.0_DP
   212      case ( 'Heat')
   213        if ( FlagRoughLenHeatSameAsMom ) then
   214          a_RatioMomToHeat = 1.0_DP
   215        else
   216          a_RatioMomToHeat = DataM84RLRatioMomToHeat( : )
   217        end if
   218      case default
   219        call MessageNotify( 'E', module_name, 'Unexpected value of RoughLenType = %c.', &
   220          & c1 = trim( RoughLenType ) )
   221      end select
   222  
   223  
   224      !
   225      ! land
   226      !
   227      do j = 1, jmax
   228        do i = 0, imax-1
   229          if( xy_SurfType( i, j ) >= 1 ) then
   230            xy_SurfRoughLen( i, j ) = 0.0_DP
   231          end if
   232        end do
   233      end do
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .ge. 1) then                            
     .              xy_surfroughlen(j-1,1) = 0.0000000000000000e+000            
     .           endif                                                          
     .        enddo                                                             
   234      do l = 1, NM84Element
   235        do j = 1, jmax
   236          do i = 0, imax-1
   237            if( xy_SurfType( i, j ) >= 1 ) then
   238              xy_SurfRoughLen( i, j ) = xy_SurfRoughLen( i, j ) &
   239                & + DataM84RL( l ) * a_RatioMomToHeat( l )      &
   240                & * DataM84Weight( l, DataSurfType2M84Type( xy_SurfType( i, j ) ) )
   241            end if
   242          end do
   243        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surftype,xy_surfroughlen)                               
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .ge. 1) then                            
     .              xy_surfroughlen(j-1,1) = xy_surfroughlen(j-1,1) + datam84rl(
     .       1         l)*a_ratiomomtoheat(l)*datam84weight(l,                  
     .       2         datasurftype2m84type(xy_surftype(j-1,1)))                
     .           endif                                                          
     .        enddo                                                             
   244      end do
   245  
   246      !
   247      ! ocean
   248      !
   249      do j = 1, jmax
   250        do i = 0, imax-1
   251  
   252          if( xy_SurfType( i, j ) == 0 ) then
   253            xy_SurfRoughLen( i, j ) = RoughLenOcean
   254          end if
   255  
   256        end do
   257      end do
   258  
   259      !
   260      ! ice
   261      !
   262      do j = 1, jmax
   263        do i = 0, imax-1
   264  
   265          if( xy_SurfType( i, j ) == 31 ) then
   266            xy_SurfRoughLen( i, j ) = RoughLenIce
   267          end if
   268  
   269        end do
   270      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surftype)                                               
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .eq. 0) then                            
     .              xy_surfroughlen(j-1,1) = roughlenocean                      
     .           endif                                                          
     .           if (xy_surftype(j-1,1) .eq. 31) then                           
     .              xy_surfroughlen(j-1,1) = roughlenice                        
     .           endif                                                          
     .        enddo                                                             
   271  
   272  
   273    end subroutine SetRoughLenLandMatthews
   274  
   275    !--------------------------------------------------------------------------------------
   276  
   277    subroutine ModRoughLenMatthewsCultivation(    &
   278      & RoughLenType, xy_SurfType, xy_SurfCulInt, &
   279      & xy_SurfRoughLen                           &
   280      & )
   281  
   282      ! モジュール引用 ; USE statements
   283      !
   284  
   285      ! 格子点設定
   286      ! Grid points settings
   287      !
   288      use gridset, only: imax, & ! 経度格子点数.
   289                                 ! Number of grid points in longitude
   290        &                jmax, & ! 緯度格子点数.
   291                                 ! Number of grid points in latitude
   292        &                kmax    ! 鉛直層数.
   293                                 ! Number of vertical level
   294  
   295      ! 宣言文 ; Declaration statements
   296      !
   297      character(*), intent(in   ) :: RoughLenType
   298      integer , intent(in   ) :: xy_SurfType    ( 0:imax-1, 1:jmax )
   299      real(DP), intent(in   ) :: xy_SurfCulInt  ( 0:imax-1, 1:jmax )
   300      real(DP), intent(inout) :: xy_SurfRoughLen( 0:imax-1, 1:jmax )
   301  
   302  
   303      ! 作業変数
   304      ! Work variables
   305      !
   306      real(DP) :: a_RatioMomToHeat( NM84Element )
   307      real(DP) :: SurfRoughLenCul
   308      integer:: i               ! 経度方向に回る DO ループ用作業変数
   309                                ! Work variables for DO loop in longitude
   310      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   311                                ! Work variables for DO loop in latitude
   312      integer:: l
   313  
   314  
   315      ! 初期化確認
   316      ! Initialization check
   317      !
   318      if ( .not. roughlen_matthews_inited ) then
   319        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   320      end if
   321  
   322  
   323      select case ( RoughLenType )
   324      case ( 'Mom' )
   325        a_RatioMomToHeat = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir on_adb(a_ratiomomtoheat)                                          
     .        do t132 = 0, 8                                                    
   326      case ( 'Heat')
   327        if ( FlagRoughLenHeatSameAsMom ) then
   328          a_RatioMomToHeat = 1.0_DP
     .  !cdir    nodep                                                          
     .  !cdir on_adb(a_ratiomomtoheat)                                          
     .        do t129 = 0, 8                                                    
   329        else
   330          a_RatioMomToHeat = DataM84RLRatioMomToHeat( : )
     .  !cdir    nodep                                                          
     .  !cdir on_adb(a_ratiomomtoheat)                                          
     .        do t125 = 0, 8                                                    
   331        end if
   332      case default
   333        call MessageNotify( 'E', module_name, 'Unexpected value of RoughLenType = %c.', &
   334          & c1 = trim( RoughLenType ) )
   335      end select
   336  
   337      !
   338      ! land
   339      !
   340      SurfRoughLenCul = 0.0_DP
   341      do l = 1, NM84Element
   342        SurfRoughLenCul = SurfRoughLenCul        &
   343          & + DataM84RL(l) * a_RatioMomToHeat(l) &
   344          &   * DataM84Weight( l, DataSurfType2M84Type( IndexCultivation ) )
   345      end do
     .           datasurftype2m84type1 = datasurftype2m84type(32)               
     .  !cdir nodep                                                             
     .  !cdir on_adb(a_ratiomomtoheat)                                          
     .        do l = 1, 9                                                       
     .           surfroughlencul = surfroughlencul + datam84rl(l)*              
     .       1      a_ratiomomtoheat(l)*datam84weight(l,datasurftype2m84type1)  
     .        enddo                                                             
   346  
   347      do j = 1, jmax
   348        do i = 0, imax-1
   349          if( xy_SurfType(i,j) >= 1 ) then
   350            xy_SurfRoughLen(i,j) =                                       &
   351              &   ( 1.0_DP - xy_SurfCulInt(i,j) ) * xy_SurfRoughLen(i,j) &
   352              & + xy_SurfCulInt(i,j)              * SurfRoughLenCul
   353          end if
   354        end do
   355      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .ge. 1) then                            
     .              xy_surfroughlen(j-1,1) = (1.00000000000000e+000 -           
     .       1         xy_surfculint(j-1,1))*xy_surfroughlen(j-1,1) +           
     .       2         xy_surfculint(j-1,1)*surfroughlencul                     
     .           endif                                                          
     .        enddo                                                             
   356  
   357  
   358    end subroutine ModRoughLenMatthewsCultivation
   359  
   360    !--------------------------------------------------------------------------------------
   361  
   362    subroutine RoughLenMatthewsInit
   363  
   364      ! モジュール引用 ; USE statements
   365      !
   366  
   367      ! 種別型パラメタ
   368      ! Kind type parameter
   369      !
   370      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   371  
   372      ! ファイル入出力補助
   373      ! File I/O support
   374      !
   375      use dc_iounit, only: FileOpen
   376  
   377      ! NAMELIST ファイル入力に関するユーティリティ
   378      ! Utilities for NAMELIST file input
   379      !
   380      use namelist_util, only: namelist_filename, NmlutilMsg
   381  
   382      ! 作業変数
   383      ! Work variables
   384      !
   385      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   386                                ! Unit number for NAMELIST file open
   387      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   388                                ! IOSTAT of NAMELIST read
   389  
   390      integer:: l
   391      integer:: m
   392  
   393  
   394      ! NAMELIST 変数群
   395      ! NAMELIST group name
   396      !
   397      namelist /roughlen_Matthews_nml/ &
   398        & RoughLenOcean,     &
   399        & RoughLenIce,       &
   400        & FlagRoughLenHeatSameAsMom
   401  
   402      ! 実行文 ; Executable statement
   403      !
   404  
   405      if ( roughlen_matthews_inited ) return
   406  
   407  
   408      ! デフォルト値の設定
   409      ! Default values settings
   410      !
   411  
   412      RoughLenOcean = 1.0e-4_DP
   413  
   414      RoughLenIce   = 1.0e-2_DP
   415  
   416      FlagRoughLenHeatSameAsMom = .true.
   417  
   418  
   419      ! NAMELIST の読み込み
   420      ! NAMELIST is input
   421      !
   422      if ( trim(namelist_filename) /= '' ) then
   423        call FileOpen( unit_nml, &          ! (out)
   424          & namelist_filename, mode = 'r' ) ! (in)
   425  
   426        rewind( unit_nml )
   427        read( unit_nml,                  &  ! (in)
   428          & nml = roughlen_Matthews_nml, &  ! (out)
   429          & iostat = iostat_nml          &  ! (out)
   430          & )
   431        close( unit_nml )
   432  
   433        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   434        if ( iostat_nml == 0 ) write( STDOUT, nml = roughlen_Matthews_nml )
   435      end if
   436  
   437  
   438      !
   439      ! This table/list is created by using Table 4 of Matthews (1983) and Table 1 of
   440      ! Matthews (1984).
   441      !
   442      DataSurfType2M84Type(  0 ) =  0 ! ocean, This is not included in Matthews papers.
   443      DataSurfType2M84Type(  1 ) =  1
   444      DataSurfType2M84Type(  2 ) =  1
   445      DataSurfType2M84Type(  3 ) =  1
   446      DataSurfType2M84Type(  4 ) =  1
   447      DataSurfType2M84Type(  5 ) =  2
   448      DataSurfType2M84Type(  6 ) =  3
   449      DataSurfType2M84Type(  7 ) =  4
   450      DataSurfType2M84Type(  8 ) =  4
   451      DataSurfType2M84Type(  9 ) =  5
   452      DataSurfType2M84Type( 10 ) =  6 ! A
   453      DataSurfType2M84Type( 11 ) =  6 ! B, This may be 7. I cannot identify.
   454      DataSurfType2M84Type( 12 ) =  8 ! C
   455      DataSurfType2M84Type( 13 ) =  9 ! D
   456      DataSurfType2M84Type( 14 ) = 10 ! E
   457      DataSurfType2M84Type( 15 ) = 11 ! F
   458      DataSurfType2M84Type( 16 ) = 12 ! G
   459      DataSurfType2M84Type( 17 ) = 14 ! H
   460      DataSurfType2M84Type( 18 ) = 14 ! I
   461      DataSurfType2M84Type( 19 ) = 15 ! J
   462      DataSurfType2M84Type( 20 ) = 15 ! K
   463      DataSurfType2M84Type( 21 ) =  8 ! L
   464      DataSurfType2M84Type( 22 ) = 16 ! M
   465      DataSurfType2M84Type( 23 ) = 17 ! N
   466      DataSurfType2M84Type( 24 ) = 17 ! O
   467      DataSurfType2M84Type( 25 ) = 17 ! P
   468      DataSurfType2M84Type( 26 ) = 19 ! Q
   469      DataSurfType2M84Type( 27 ) = 19 ! R
   470      DataSurfType2M84Type( 28 ) = 19 ! S
   471      DataSurfType2M84Type( 29 ) = 19 ! T
   472      DataSurfType2M84Type( 30 ) = 20 ! U
   473      DataSurfType2M84Type( 31 ) = 21 ! V ice
   474      DataSurfType2M84Type( 32 ) = 19 ! W cultivation
   475  
   476      do m = 0, NM84Type
   477        do l = 1, NM84Element
   478          DataM84Weight( l, m ) = DataM84Weight( l, m ) * 1.0e-2_DP
   479        end do
   480      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do m = 1, 207                                                     
     .           datam84weight(m,0) = datam84weight(m,0)*1.00000000000000e-002  
     .        enddo                                                             
   481      do l = 1, NM84Element
   482        DataM84RL( l ) = DataM84RL( l ) * 1.0e-2_DP
   483      end do
   484  
   485  
   486      ! 印字 ; Print
   487      !
   488      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   489      call MessageNotify( 'M', module_name, 'RoughLenOcean             = %f', d = (/RoughLenOcean/) )
   490      call MessageNotify( 'M', module_name, 'RoughLenIce               = %f', d = (/RoughLenIce/) )
   491      call MessageNotify( 'M', module_name, 'FlagRoughLenHeatSameAsMom = %b', l = (/FlagRoughLenHeatSameAsMom/) )
   492      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   493  
   494      roughlen_matthews_inited = .true.
   495  
   496    end subroutine RoughLenMatthewsInit
   497  
   498    !--------------------------------------------------------------------------------------
   499  
   500  !!$
   501  !!$  subroutine setroughnesslength_ocean( im, jm, km, gzs, gsfcindex, &
   502  !!$    gu, gv, gt, galt, gpt, gpth, gz0_out )
   503  !!$
   504  !!$    use vtype_module
   505  !!$    use const_module, only : grav
   506  !!$    use vdiff_module
   507  !!$
   508  !!$    implicit none
   509  !!$
   510  !!$    integer(i4b), intent(in   ) :: im, jm, km
   511  !!$    real(dp)    , intent(in   ) :: gzs( im, jm )
   512  !!$    integer(i4b), intent(in   ) :: gsfcindex( im, jm )
   513  !!$    real(dp)    , intent(in   ) :: gu( im, jm, km ), gv( im, jm, km ), gt( im, jm, km ), galt( im, jm, km ), gpt( im, jm, km ), gpth( im, jm, km+1 )
   514  !!$    real(dp)    , intent(inout) :: gz0_out( im, jm )
   515  !!$
   516  !!$    !
   517  !!$    ! local variables
   518  !!$    !
   519  !!$    real(dp)    , parameter :: gz0_init = 0.01d0
   520  !!$
   521  !!$    real(dp)                :: c_charnock
   522  !!$
   523  !!$    integer(i4b)            :: iitr, nitr
   524  !!$    real(dp)                :: cd( im, jm ), ch( im, jm ), fvsq( im, jm )
   525  !!$
   526  !!$    real(dp)                :: gz0( im, jm )
   527  !!$
   528  !!$    integer(i4b)            :: i, j
   529  !!$
   530  !!$
   531  !!$    !
   532  !!$    ! initial value for interation
   533  !!$    !
   534  !!$    do j = 1, jm
   535  !!$      do i = 1, im
   536  !!$        gz0( i, j ) = gz0_init
   537  !!$      end do
   538  !!$    end do
   539  !!$
   540  !!$    nitr = 10
   541  !!$    do iitr = 1, nitr
   542  !!$
   543  !!$      call vdiff_dragcoef_core( im, jm, km, gzs, &
   544  !!$        gz0, &
   545  !!$        gu, gv, gt, galt, gpt, gpth, cd, ch )
   546  !!$
   547  !!$      write( 6, * ) gsfcindex( 1, jm/2 ), iitr, gz0( 1, jm/2 ), cd( 1, jm/2 )
   548  !!$
   549  !!$
   550  !!$      do j = 1, jm
   551  !!$        do i = 1, im
   552  !!$          fvsq( i, j ) = ( cd( i, j ) + 1.0d-6 )&
   553  !!$            * ( gu( i, j, km )**2 + gv( i, j, km )**2 + 1.0d-3 )
   554  !!$        end do
   555  !!$      end do
   556  !!$
   557  !!$      !
   558  !!$      ! Krishnamurti?
   559  !!$!         c_charnock = 0.04d0
   560  !!$      !
   561  !!$      ! Wu (1967), technical report
   562  !!$      ! http://oai.dtic.mil/oai/oai?&verb=getRecord&metadataPrefix=html&identifier=AD0672750
   563  !!$!         c_charnock = 0.0156d0
   564  !!$      ! Wu (1980), JPO
   565  !!$      c_charnock = 0.0185d0
   566  !!$      do j = 1, jm
   567  !!$        do i = 1, im
   568  !!$          if( gsfcindex( i, j ) .le. 0 ) then
   569  !!$            ! Ocean
   570  !!$            ! Charnock, 1955
   571  !!$            gz0( i, j ) = c_charnock * fvsq( i, j ) / grav
   572  !!$          end if
   573  !!$        end do
   574  !!$      end do
   575  !!$
   576  !!$    end do
   577  !!$
   578  !!$
   579  !!$    do j = 1, jm
   580  !!$      do i = 1, im
   581  !!$
   582  !!$        if( gsfcindex( i, j ) .le. 0 ) then
   583  !!$          gz0_out( i, j ) = gz0( i, j )
   584  !!$        end if
   585  !!$
   586  !!$      end do
   587  !!$    end do
   588  !!$
   589  !!$
   590  !!$  end subroutine setroughnesslength_ocean
   591  
   592  end module roughlen_Matthews
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: roughlen_Matthews.f90
PROGRAM NAME: roughlen_matthews
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Matthews のデータに基づく地面粗度の設定
     2:             !
     3:             != set roughness length on land surface based on data by Matthews
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: roughlen_Matthews.f90,v 1.9 2015/01/29 12:08:40 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module roughlen_Matthews
    13:             
    14:               !== References
    15:               !
    16:               !  Matthews, E.,
    17:               !    Global vegetation and land use: New high-resolution data bases for climate 
    18:               !    studies, 
    19:               !    J. Clim. Appl. Meteor., 22, 474, 1983. 
    20:               !
    21:               !  Matthews, E., 
    22:               !    Prescription of land-surface boundary conditions in GISS GCM II:
    23:               !    A simple method based on fine-resolution data bases, 
    24:               !    NASA Technical memorandum #86096, 1984.
    25:             
    26:               ! モジュール引用 ; USE statements
    27:               !
    28:             
    29:               ! 種別型パラメタ
    30:               ! Kind type parameter
    31:               !
    32:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    33:                 &                 STRING     ! 文字列.       Strings.
    34:             
    35:               ! メッセージ出力
    36:               ! Message output
    37:               !
    38:               use dc_message, only: MessageNotify
    39:             
    40:               ! 宣言文 ; Declaration statements
    41:               !
    42:               implicit none
    43:               private
    44:             
    45:               ! 公開手続き
    46:               ! Public procedure
    47:               !
    48:               public:: SetRoughLenLandMatthews
    49:               public:: ModRoughLenMatthewsCultivation
    50:               public:: RoughLenMatthewsInit
    51:             
    52:               ! 公開変数
    53:               ! Public variables
    54:               !
    55:             
    56:               ! 非公開変数
    57:               ! Private variables
    58:               !
    59:               logical, save :: roughlen_matthews_inited = .false.
    60:                                           ! 初期設定フラグ.
    61:                                           ! Initialization flag
    62:             
    63:               integer, parameter :: NLandUseType = 32
    64:               integer, parameter :: NM84Element  =  9
    65:               integer, parameter :: NM84Type     = 22
    66:             
    67:               integer, parameter :: IndexCultivation = 32
    68:             
    69:               integer   , save      :: DataSurfType2M84Type( 0:NLandUseType )
    70:               real(DP)  , save      :: DataM84Weight( NM84Element, 0:NM84Type )
    71:               real(DP)  , save      :: DataM84RL( NM84Element )
    72:               real(DP)  , save      :: DataM84RLRatioMomToHeat( NM84Element )
    73:             
    74:               real(DP)  , save      :: RoughLenOcean
    75:             
    76:               real(DP)  , save      :: RoughLenIce
    77:             
    78:               logical   , save      :: FlagRoughLenHeatSameAsMom
    79:             
    80:             
    81:               !
    82:               ! Matthews (1984) grouped UNESCO land use type into 22 groups, whose properties
    83:               ! can be constructed by conbining properties of those of 9 land use 'elemental
    84:               ! groups'. Note that a word 'elemental group' is not used by Matthews (1984).
    85:               !
    86:               !
    87:               ! Table 2B of Matthews (1984), NASA Technical memorandum #86096
    88:               !
    89:               ! 9 'elemental group' is as follows.
    90:               !   #1 desert
    91:               !   #2 tundra
    92:               !   #3 grassland
    93:               !   #4 grassland with shrub cover
    94:               !   #5 grassland with tree cover
    95:               !   #6 deciduous forest
    96:               !   #7 evergreen forest
    97:               !   #8 rainforest
    98:               !   #9 ice
    99:               !
   100:               !     %1   %2   %3   %4   %5   %6   %7   %8   %9
   101:               data DataM84Weight / &
   102:                      0,   0,   0,   0,   0,   0,   0,   0,   0, & !  0, This is not included in Matthews papers.
   103:                      0,   0,   0,   0,   0,   0,   0, 100,   0, & !  1
   104:                      0,   0,  25,   0,   0,   0,  75,   0,   0, & !  2
   105:                     40,   0,   0,   0,   0,   0,  60,   0,   0, & !  3
   106:                      0,   0,   0,   0,   0,   0, 100,   0,   0, & !  4
   107:                      0,   0,  25,   0,   0,  75,   0,   0,   0, & !  5
   108:                      0,   0,   0,   0,   0, 100,   0,   0,   0, & !  6
   109:                     15,   0,   0,   0,   0,  85,   0,   0,   0, & !  7
   110:                     85,   0,   0,   0,   0,  15,   0,   0,   0, & !  8
   111:                     35,   0,   0,   0,   0,   0,  65,   0,   0, & !  9
   112:                     25,   0,  25,   0,   0,   0,  50,   0,   0, & ! 10
   113:                     35,   0,   0,   0,   0,  65,   0,   0,   0, & ! 11
   114:                     30,   0,   0,   0,   0,  70,   0,   0,   0, & ! 12
   115:                      0,   0,  50,   0,   0,  50,   0,   0,   0, & ! 13
   116:                     10,   0,  80,   0,   0,   0,  10,   0,   0, & ! 14
   117:                     10,   0,  80,   0,   0,  10,   0,   0,   0, & ! 15
   118:                      0, 100,   0,   0,   0,   0,   0,   0,   0, & ! 16
   119:                      0,   0,   0,   0, 100,   0,   0,   0,   0, & ! 17
   120:                      0,   0,   0, 100,   0,   0,   0,   0,   0, & ! 18
   121:                      0,   0, 100,   0,   0,   0,   0,   0,   0, & ! 19
   122:                    100,   0,   0,   0,   0,   0,   0,   0,   0, & ! 20
   123:                      0,   0,   0,   0,   0,   0,   0,   0, 100, & ! 21 ice
   124:                     30,   0,   0,   0,   0,   0,  70,   0,   0  & ! 22
   125:                     /
   126:             
   127:               !
   128:               ! roughness length
   129:               ! Table 3 of Matthews (1984). unit is cm.
   130:               ! A value of roughness length for ice is not included in Matthews (1984).
   131:               !
   132:               !     %1     %2      %3      %4      %5      %6       %7        %8        %9
   133:               data DataM84RL / &
   134:                    0.5_DP, 0.5_DP, 1.0_DP, 1.0_DP, 1.8_DP, 32.0_DP, 100.0_DP, 200.0_DP, 0.0_DP &
   135:                    /
   136:             
   137:               !
   138:               ! ratio of roughness length for momentum to that for heat
   139:               ! Our strategy is that roughness length for heat on ocean, ice, and trees 
   140:               ! are the same as those for momentum. Roughness length for heat on other 
   141:               ! lands are 1/100 of those for momentum. The factor, 1/100, is based on 
   142:               ! ECMWF IFS (p.164, IFSPart4.pdf).
   143:               !
   144:               !    %1       %2       %3       %4       %5      %6      %7      %8      %9
   145:               data DataM84RLRatioMomToHeat / &
   146:                    0.01_DP, 0.01_DP, 0.01_DP, 0.01_DP, 1.0_DP, 1.0_DP, 1.0_DP, 1.0_DP, 1.0_DP &
   147:                    /
   148:             
   149:             
   150:             
   151:               character(*), parameter:: module_name = 'roughlen_Matthews'
   152:                                           ! モジュールの名称. 
   153:                                           ! Module name
   154:               character(*), parameter:: version = &
   155:                 & '$Name:  $' // &
   156:                 & '$Id: roughlen_Matthews.f90,v 1.9 2015/01/29 12:08:40 yot Exp $'
   157:                                           ! モジュールのバージョン
   158:                                           ! Module version
   159:             
   160:             contains
   161:             
   162:               !--------------------------------------------------------------------------------------
   163:             
   164:               subroutine SetRoughLenLandMatthews( &
   165:                 & RoughLenType, xy_SurfType, &
   166:                 & xy_SurfRoughLen            &
   167:                 & )
   168:             
   169:                 ! モジュール引用 ; USE statements
   170:                 !
   171:             
   172:                 ! 格子点設定
   173:                 ! Grid points settings
   174:                 !
   175:                 use gridset, only: imax, & ! 経度格子点数.
   176:                                            ! Number of grid points in longitude
   177:                   &                jmax, & ! 緯度格子点数.
   178:                                            ! Number of grid points in latitude
   179:                   &                kmax    ! 鉛直層数.
   180:                                            ! Number of vertical level
   181:             
   182:                 ! 宣言文 ; Declaration statements
   183:                 !
   184:                 character(*), intent(in   ) :: RoughLenType
   185:                 integer , intent(in   ) :: xy_SurfType    ( 0:imax-1, 1:jmax )
   186:                 real(DP), intent(inout) :: xy_SurfRoughLen( 0:imax-1, 1:jmax )
   187:             
   188:             
   189:                 ! 作業変数
   190:                 ! Work variables
   191:                 !
   192:                 real(DP) :: a_RatioMomToHeat( NM84Element )
   193:             
   194:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   195:                                           ! Work variables for DO loop in longitude
   196:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   197:                                           ! Work variables for DO loop in latitude
   198:                 integer:: l
   199:             
   200:             
   201:                 ! 初期化確認
   202:                 ! Initialization check
   203:                 !
   204:                 if ( .not. roughlen_matthews_inited ) then
   205:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   206:                 end if
   207:             
   208:             
   209:                 select case ( RoughLenType )
   210:                 case ( 'Mom' )
   211: V======           a_RatioMomToHeat = 1.0_DP
   212:                 case ( 'Heat')
   213:                   if ( FlagRoughLenHeatSameAsMom ) then
   214: V======             a_RatioMomToHeat = 1.0_DP
   215:                   else
   216: V====== A           a_RatioMomToHeat = DataM84RLRatioMomToHeat( : )
   217:                   end if
   218:                 case default
   219:                   call MessageNotify( 'E', module_name, 'Unexpected value of RoughLenType = %c.', &
   220:                     & c1 = trim( RoughLenType ) )
   221:                 end select
   222:             
   223:             
   224:                 !
   225:                 ! land
   226:                 !
   227: W------>        do j = 1, jmax
   228: |*----->          do i = 0, imax-1
   229: ||      A           if( xy_SurfType( i, j ) >= 1 ) then
   230: ||      A             xy_SurfRoughLen( i, j ) = 0.0_DP
   231: ||                  end if
   232: |*-----           end do
   233: W------         end do
   234: +------>        do l = 1, NM84Element
   235: |W----->          do j = 1, jmax
   236: ||*---->            do i = 0, imax-1
   237: |||     A             if( xy_SurfType( i, j ) >= 1 ) then
   238: |||     A               xy_SurfRoughLen( i, j ) = xy_SurfRoughLen( i, j ) &
   239: |||                       & + DataM84RL( l ) * a_RatioMomToHeat( l )      &
   240: |||                       & * DataM84Weight( l, DataSurfType2M84Type( xy_SurfType( i, j ) ) )
   241: |||                   end if
   242: ||*----             end do
   243: |W-----           end do
   244: +------         end do
   245:             
   246:                 !
   247:                 ! ocean
   248:                 !
   249: W------>        do j = 1, jmax
   250: |*----->          do i = 0, imax-1
   251: ||          
   252: ||      A           if( xy_SurfType( i, j ) == 0 ) then
   253: ||      A             xy_SurfRoughLen( i, j ) = RoughLenOcean
   254: ||                  end if
   255: ||          
   256: ||                end do
   257: ||              end do
   258: ||          
   259: ||              !
   260: ||              ! ice
   261: ||              !
   262: ||              do j = 1, jmax
   263: ||                do i = 0, imax-1
   264: ||          
   265: ||                  if( xy_SurfType( i, j ) == 31 ) then
   266: ||                    xy_SurfRoughLen( i, j ) = RoughLenIce
   267: ||                  end if
   268: ||          
   269: |*-----           end do
   270: W------         end do
   271:             
   272:             
   273:               end subroutine SetRoughLenLandMatthews
   274:             
   275:               !--------------------------------------------------------------------------------------
   276:             
   277:               subroutine ModRoughLenMatthewsCultivation(    &
   278:                 & RoughLenType, xy_SurfType, xy_SurfCulInt, &
   279:                 & xy_SurfRoughLen                           &
   280:                 & )
   281:             
   282:                 ! モジュール引用 ; USE statements
   283:                 !
   284:             
   285:                 ! 格子点設定
   286:                 ! Grid points settings
   287:                 !
   288:                 use gridset, only: imax, & ! 経度格子点数.
   289:                                            ! Number of grid points in longitude
   290:                   &                jmax, & ! 緯度格子点数.
   291:                                            ! Number of grid points in latitude
   292:                   &                kmax    ! 鉛直層数.
   293:                                            ! Number of vertical level
   294:             
   295:                 ! 宣言文 ; Declaration statements
   296:                 !
   297:                 character(*), intent(in   ) :: RoughLenType
   298:                 integer , intent(in   ) :: xy_SurfType    ( 0:imax-1, 1:jmax )
   299:                 real(DP), intent(in   ) :: xy_SurfCulInt  ( 0:imax-1, 1:jmax )
   300:                 real(DP), intent(inout) :: xy_SurfRoughLen( 0:imax-1, 1:jmax )
   301:             
   302:             
   303:                 ! 作業変数
   304:                 ! Work variables
   305:                 !
   306:                 real(DP) :: a_RatioMomToHeat( NM84Element )
   307:                 real(DP) :: SurfRoughLenCul
   308:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   309:                                           ! Work variables for DO loop in longitude
   310:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   311:                                           ! Work variables for DO loop in latitude
   312:                 integer:: l
   313:             
   314:             
   315:                 ! 初期化確認
   316:                 ! Initialization check
   317:                 !
   318:                 if ( .not. roughlen_matthews_inited ) then
   319:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   320:                 end if
   321:             
   322:             
   323:                 select case ( RoughLenType )
   324:                 case ( 'Mom' )
   325: V====== A         a_RatioMomToHeat = 1.0_DP
   326:                 case ( 'Heat')
   327:                   if ( FlagRoughLenHeatSameAsMom ) then
   328: V====== A           a_RatioMomToHeat = 1.0_DP
   329:                   else
   330: V====== A           a_RatioMomToHeat = DataM84RLRatioMomToHeat( : )
   331:                   end if
   332:                 case default
   333:                   call MessageNotify( 'E', module_name, 'Unexpected value of RoughLenType = %c.', &
   334:                     & c1 = trim( RoughLenType ) )
   335:                 end select
   336:             
   337:                 !
   338:                 ! land
   339:                 !
   340:                 SurfRoughLenCul = 0.0_DP
   341: V------>        do l = 1, NM84Element
   342: |       A         SurfRoughLenCul = SurfRoughLenCul        &
   343: |                   & + DataM84RL(l) * a_RatioMomToHeat(l) &
   344: |                   &   * DataM84Weight( l, DataSurfType2M84Type( IndexCultivation ) )
   345: V------         end do
   346:             
   347: W------>        do j = 1, jmax
   348: |*----->          do i = 0, imax-1
   349: ||      A           if( xy_SurfType(i,j) >= 1 ) then
   350: ||      A             xy_SurfRoughLen(i,j) =                                       &
   351: ||                      &   ( 1.0_DP - xy_SurfCulInt(i,j) ) * xy_SurfRoughLen(i,j) &
   352: ||                      & + xy_SurfCulInt(i,j)              * SurfRoughLenCul
   353: ||                  end if
   354: |*-----           end do
   355: W------         end do
   356:             
   357:             
   358:               end subroutine ModRoughLenMatthewsCultivation
   359:             
   360:               !--------------------------------------------------------------------------------------
   361:             
   362:               subroutine RoughLenMatthewsInit
   363:             
   364:                 ! モジュール引用 ; USE statements
   365:                 !
   366:             
   367:                 ! 種別型パラメタ
   368:                 ! Kind type parameter
   369:                 !
   370:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   371:             
   372:                 ! ファイル入出力補助
   373:                 ! File I/O support
   374:                 !
   375:                 use dc_iounit, only: FileOpen
   376:             
   377:                 ! NAMELIST ファイル入力に関するユーティリティ
   378:                 ! Utilities for NAMELIST file input
   379:                 !
   380:                 use namelist_util, only: namelist_filename, NmlutilMsg
   381:             
   382:                 ! 作業変数
   383:                 ! Work variables
   384:                 !
   385:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   386:                                           ! Unit number for NAMELIST file open
   387:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   388:                                           ! IOSTAT of NAMELIST read
   389:             
   390:                 integer:: l
   391:                 integer:: m
   392:             
   393:             
   394:                 ! NAMELIST 変数群
   395:                 ! NAMELIST group name
   396:                 !
   397:                 namelist /roughlen_Matthews_nml/ &
   398:                   & RoughLenOcean,     &
   399:                   & RoughLenIce,       &
   400:                   & FlagRoughLenHeatSameAsMom
   401:             
   402:                 ! 実行文 ; Executable statement
   403:                 !
   404:             
   405:                 if ( roughlen_matthews_inited ) return
   406:             
   407:             
   408:                 ! デフォルト値の設定
   409:                 ! Default values settings
   410:                 !
   411:             
   412:                 RoughLenOcean = 1.0e-4_DP
   413:             
   414:                 RoughLenIce   = 1.0e-2_DP
   415:             
   416:                 FlagRoughLenHeatSameAsMom = .true.
   417:             
   418:             
   419:                 ! NAMELIST の読み込み
   420:                 ! NAMELIST is input
   421:                 !
   422:                 if ( trim(namelist_filename) /= '' ) then
   423:                   call FileOpen( unit_nml, &          ! (out)
   424:                     & namelist_filename, mode = 'r' ) ! (in)
   425:             
   426:                   rewind( unit_nml )
   427:                   read( unit_nml,                  &  ! (in)
   428:                     & nml = roughlen_Matthews_nml, &  ! (out)
   429:                     & iostat = iostat_nml          &  ! (out)
   430:                     & )
   431:                   close( unit_nml )
   432:             
   433:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   434:                   if ( iostat_nml == 0 ) write( STDOUT, nml = roughlen_Matthews_nml )
   435:                 end if
   436:             
   437:             
   438:                 !
   439:                 ! This table/list is created by using Table 4 of Matthews (1983) and Table 1 of 
   440:                 ! Matthews (1984).
   441:                 !
   442:                 DataSurfType2M84Type(  0 ) =  0 ! ocean, This is not included in Matthews papers.
   443:                 DataSurfType2M84Type(  1 ) =  1
   444:                 DataSurfType2M84Type(  2 ) =  1
   445:                 DataSurfType2M84Type(  3 ) =  1
   446:                 DataSurfType2M84Type(  4 ) =  1
   447:                 DataSurfType2M84Type(  5 ) =  2
   448:                 DataSurfType2M84Type(  6 ) =  3
   449:                 DataSurfType2M84Type(  7 ) =  4
   450:                 DataSurfType2M84Type(  8 ) =  4
   451:                 DataSurfType2M84Type(  9 ) =  5
   452:                 DataSurfType2M84Type( 10 ) =  6 ! A
   453:                 DataSurfType2M84Type( 11 ) =  6 ! B, This may be 7. I cannot identify.
   454:                 DataSurfType2M84Type( 12 ) =  8 ! C
   455:                 DataSurfType2M84Type( 13 ) =  9 ! D
   456:                 DataSurfType2M84Type( 14 ) = 10 ! E
   457:                 DataSurfType2M84Type( 15 ) = 11 ! F
   458:                 DataSurfType2M84Type( 16 ) = 12 ! G
   459:                 DataSurfType2M84Type( 17 ) = 14 ! H
   460:                 DataSurfType2M84Type( 18 ) = 14 ! I
   461:                 DataSurfType2M84Type( 19 ) = 15 ! J
   462:                 DataSurfType2M84Type( 20 ) = 15 ! K
   463:                 DataSurfType2M84Type( 21 ) =  8 ! L
   464:                 DataSurfType2M84Type( 22 ) = 16 ! M
   465:                 DataSurfType2M84Type( 23 ) = 17 ! N
   466:                 DataSurfType2M84Type( 24 ) = 17 ! O
   467:                 DataSurfType2M84Type( 25 ) = 17 ! P
   468:                 DataSurfType2M84Type( 26 ) = 19 ! Q
   469:                 DataSurfType2M84Type( 27 ) = 19 ! R
   470:                 DataSurfType2M84Type( 28 ) = 19 ! S
   471:                 DataSurfType2M84Type( 29 ) = 19 ! T
   472:                 DataSurfType2M84Type( 30 ) = 20 ! U
   473:                 DataSurfType2M84Type( 31 ) = 21 ! V ice
   474:                 DataSurfType2M84Type( 32 ) = 19 ! W cultivation
   475:             
   476: W------>        do m = 0, NM84Type
   477: |*----->          do l = 1, NM84Element
   478: ||      A           DataM84Weight( l, m ) = DataM84Weight( l, m ) * 1.0e-2_DP
   479: |*-----           end do
   480: W------         end do
   481: V------>        do l = 1, NM84Element
   482: |       A         DataM84RL( l ) = DataM84RL( l ) * 1.0e-2_DP
   483: V------         end do
   484:             
   485:             
   486:                 ! 印字 ; Print
   487:                 !
   488:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   489:                 call MessageNotify( 'M', module_name, 'RoughLenOcean             = %f', d = (/RoughLenOcean/) )
   490:                 call MessageNotify( 'M', module_name, 'RoughLenIce               = %f', d = (/RoughLenIce/) )
   491:                 call MessageNotify( 'M', module_name, 'FlagRoughLenHeatSameAsMom = %b', l = (/FlagRoughLenHeatSameAsMom/) )
   492:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   493:             
   494:                 roughlen_matthews_inited = .true.
   495:             
   496:               end subroutine RoughLenMatthewsInit
   497:             
   498:               !--------------------------------------------------------------------------------------
   499:             
   500:             !!$
   501:             !!$  subroutine setroughnesslength_ocean( im, jm, km, gzs, gsfcindex, &
   502:             !!$    gu, gv, gt, galt, gpt, gpth, gz0_out )
   503:             !!$
   504:             !!$    use vtype_module
   505:             !!$    use const_module, only : grav
   506:             !!$    use vdiff_module
   507:             !!$
   508:             !!$    implicit none
   509:             !!$
   510:             !!$    integer(i4b), intent(in   ) :: im, jm, km
   511:             !!$    real(dp)    , intent(in   ) :: gzs( im, jm )
   512:             !!$    integer(i4b), intent(in   ) :: gsfcindex( im, jm )
   513:             !!$    real(dp)    , intent(in   ) :: gu( im, jm, km ), gv( im, jm, km ), gt( im, jm, km ), galt( im, jm, km ), gpt( im, jm, km ), gpth( im, jm, km+1 )
   514:             !!$    real(dp)    , intent(inout) :: gz0_out( im, jm )
   515:             !!$
   516:             !!$    !
   517:             !!$    ! local variables
   518:             !!$    !
   519:             !!$    real(dp)    , parameter :: gz0_init = 0.01d0
   520:             !!$
   521:             !!$    real(dp)                :: c_charnock
   522:             !!$
   523:             !!$    integer(i4b)            :: iitr, nitr
   524:             !!$    real(dp)                :: cd( im, jm ), ch( im, jm ), fvsq( im, jm )
   525:             !!$
   526:             !!$    real(dp)                :: gz0( im, jm )
   527:             !!$
   528:             !!$    integer(i4b)            :: i, j
   529:             !!$
   530:             !!$
   531:             !!$    !
   532:             !!$    ! initial value for interation
   533:             !!$    !
   534:             !!$    do j = 1, jm
   535:             !!$      do i = 1, im
   536:             !!$        gz0( i, j ) = gz0_init
   537:             !!$      end do
   538:             !!$    end do
   539:             !!$
   540:             !!$    nitr = 10
   541:             !!$    do iitr = 1, nitr
   542:             !!$
   543:             !!$      call vdiff_dragcoef_core( im, jm, km, gzs, &
   544:             !!$        gz0, &
   545:             !!$        gu, gv, gt, galt, gpt, gpth, cd, ch )
   546:             !!$
   547:             !!$      write( 6, * ) gsfcindex( 1, jm/2 ), iitr, gz0( 1, jm/2 ), cd( 1, jm/2 )
   548:             !!$
   549:             !!$
   550:             !!$      do j = 1, jm
   551:             !!$        do i = 1, im
   552:             !!$          fvsq( i, j ) = ( cd( i, j ) + 1.0d-6 )&
   553:             !!$            * ( gu( i, j, km )**2 + gv( i, j, km )**2 + 1.0d-3 )
   554:             !!$        end do
   555:             !!$      end do
   556:             !!$
   557:             !!$      !
   558:             !!$      ! Krishnamurti?
   559:             !!$!         c_charnock = 0.04d0
   560:             !!$      !
   561:             !!$      ! Wu (1967), technical report
   562:             !!$      ! http://oai.dtic.mil/oai/oai?&verb=getRecord&metadataPrefix=html&identifier=AD0672750
   563:             !!$!         c_charnock = 0.0156d0
   564:             !!$      ! Wu (1980), JPO
   565:             !!$      c_charnock = 0.0185d0
   566:             !!$      do j = 1, jm
   567:             !!$        do i = 1, im
   568:             !!$          if( gsfcindex( i, j ) .le. 0 ) then
   569:             !!$            ! Ocean
   570:             !!$            ! Charnock, 1955
   571:             !!$            gz0( i, j ) = c_charnock * fvsq( i, j ) / grav
   572:             !!$          end if
   573:             !!$        end do
   574:             !!$      end do
   575:             !!$
   576:             !!$    end do
   577:             !!$
   578:             !!$
   579:             !!$    do j = 1, jm
   580:             !!$      do i = 1, im
   581:             !!$
   582:             !!$        if( gsfcindex( i, j ) .le. 0 ) then
   583:             !!$          gz0_out( i, j ) = gz0( i, j )
   584:             !!$        end if
   585:             !!$
   586:             !!$      end do
   587:             !!$    end do
   588:             !!$
   589:             !!$
   590:             !!$  end subroutine setroughnesslength_ocean
   591:             
   592:             end module roughlen_Matthews
