Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: soil_thermdiffcoef.f90
PROGRAM NAME: soil_thermdiffcoef
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   125  opt  (1593): Loop nest collapsed into one loop.
   125  vec  (   1): Vectorized loop.
   125  vec  (  29): ADB is used for array.: xy_soilthermdiffcoef
   125  vec  (  29): ADB is used for array.: xy_soilmoist
   125  vec  (  29): ADB is used for array.: xy_surftype
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: soil_thermdiffcoef.f90
PROGRAM NAME: soil_thermdiffcoef
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 土壌熱伝導係数の設定
     2  !
     3  != set soil thermal diffusion coefficient
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: soil_thermdiffcoef.f90,v 1.1 2015/01/29 12:12:21 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module soil_thermdiffcoef
    13  
    14    !== References
    15    !
    16  !!$  !  Matthews, E.,
    17  !!$  !    Global vegetation and land use: New high-resolution data bases for climate
    18  !!$  !    studies,
    19  !!$  !    J. Clim. Appl. Meteor., 22, 474, 1983.
    20  !!$  !
    21  !!$  !  Matthews, E.,
    22  !!$  !    Prescription of land-surface boundary conditions in GISS GCM II:
    23  !!$  !    A simple method based on fine-resolution data bases,
    24  !!$  !    NASA Technical memorandum #86096, 1984.
    25  
    26    ! モジュール引用 ; USE statements
    27    !
    28  
    29    ! 種別型パラメタ
    30    ! Kind type parameter
    31    !
    32    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    33      &                 STRING     ! 文字列.       Strings.
    34  
    35    ! メッセージ出力
    36    ! Message output
    37    !
    38    use dc_message, only: MessageNotify
    39  
    40    ! 宣言文 ; Declaration statements
    41    !
    42    implicit none
    43    private
    44  
    45    ! 公開手続き
    46    ! Public procedure
    47    !
    48    public:: SetSoilThermDiffCoefSimple
    49    public:: SoilThermDiffCoefInit
    50  
    51    ! 公開変数
    52    ! Public variables
    53    !
    54  
    55    ! 非公開変数
    56    ! Private variables
    57    !
    58    logical, save :: soil_thermdiffcoef_inited = .false.
    59                                ! 初期設定フラグ.
    60                                ! Initialization flag
    61  
    62    real(DP), save:: SoilThermDiffCoefMin
    63    real(DP), save:: SoilThermDiffCoefMax
    64  
    65    real(DP), save:: SoilMoistCritAmnt
    66  
    67    character(*), parameter:: module_name = 'soil_thermdiffcoef'
    68                                ! モジュールの名称.
    69                                ! Module name
    70    character(*), parameter:: version = &
    71      & '$Name:  $' // &
    72      & '$Id: soil_thermdiffcoef.f90,v 1.1 2015/01/29 12:12:21 yot Exp $'
    73                                ! モジュールのバージョン
    74                                ! Module version
    75  
    76  contains
    77  
    78    !--------------------------------------------------------------------------------------
    79  
    80    subroutine SetSoilThermDiffCoefSimple( &
    81      & xy_SurfType, xy_SoilMoist,         & ! (in )
    82      & xy_SoilThermDiffCoef               & ! (out)
    83      & )
    84  
    85      ! モジュール引用 ; USE statements
    86      !
    87  
    88      ! 格子点設定
    89      ! Grid points settings
    90      !
    91      use gridset, only: imax, & ! 経度格子点数.
    92                                 ! Number of grid points in longitude
    93        &                jmax, & ! 緯度格子点数.
    94                                 ! Number of grid points in latitude
    95        &                kmax    ! 鉛直層数.
    96                                 ! Number of vertical level
    97  
    98      ! 宣言文 ; Declaration statements
    99      !
   100      integer , intent(in ) :: xy_SurfType         ( 0:imax-1, 1:jmax )
   101      real(DP), intent(in ) :: xy_SoilMoist        ( 0:imax-1, 1:jmax )
   102      real(DP), intent(out) :: xy_SoilThermDiffCoef( 0:imax-1, 1:jmax )
   103  
   104  
   105      ! 作業変数
   106      ! Work variables
   107      !
   108      integer:: i               ! 経度方向に回る DO ループ用作業変数
   109                                ! Work variables for DO loop in longitude
   110      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   111                                ! Work variables for DO loop in latitude
   112  
   113  
   114      ! 初期化確認
   115      ! Initialization check
   116      !
   117      if ( .not. soil_thermdiffcoef_inited ) then
   118        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   119      end if
   120  
   121  
   122      !
   123      ! land
   124      !
   125      do j = 1, jmax
   126        do i = 0, imax-1
   127          if( xy_SurfType( i, j ) >= 1 ) then
   128            xy_SoilThermDiffCoef(i,j) =                           &
   129              &   ( SoilThermDiffCoefMax - SoilThermDiffCoefMin ) &
   130              & / ( SoilMoistCritAmnt    - 0.0_DP               ) &
   131              & * ( xy_SoilMoist(i,j)    - 0.0_DP               ) &
   132              & + SoilThermDiffCoefMin
   133            xy_SoilThermDiffCoef(i,j) =                           &
   134              & min( max( xy_SoilThermDiffCoef(i,j), SoilThermDiffCoefMin ), &
   135              &      SoilThermDiffCoefMax )
   136          else
   137            xy_SoilThermDiffCoef(i,j) = 1.0e100_DP
   138          end if
   139        end do
   140      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surftype(j-1,1) .ge. 1) then                            
     .              xy_soilthermdiffcoef1 = (soilthermdiffcoefmax -             
     .       1         soilthermdiffcoefmin)/(soilmoistcritamnt -               
     .       2         0.0000000000000000e+000)*(xy_soilmoist(j-1,1)-           
     .       3         0.0000000000000000e+000) + soilthermdiffcoefmin          
     .              xy_soilthermdiffcoef1 = min(max(xy_soilthermdiffcoef1,      
     .       1         soilthermdiffcoefmin),soilthermdiffcoefmax)              
     .           else                                                           
     .              xy_soilthermdiffcoef1 = 1.00000000000000e+100               
     .           endif                                                          
     .           xy_soilthermdiffcoef(j-1,1) = xy_soilthermdiffcoef1            
     .        enddo                                                             
   141  
   142  
   143    end subroutine SetSoilThermDiffCoefSimple
   144  
   145    !--------------------------------------------------------------------------------------
   146  
   147    subroutine SoilThermDiffCoefInit( &
   148      & FlagSnow &
   149      & )
   150  
   151      ! モジュール引用 ; USE statements
   152      !
   153  
   154      ! 種別型パラメタ
   155      ! Kind type parameter
   156      !
   157      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   158  
   159      ! ファイル入出力補助
   160      ! File I/O support
   161      !
   162      use dc_iounit, only: FileOpen
   163  
   164      ! NAMELIST ファイル入力に関するユーティリティ
   165      ! Utilities for NAMELIST file input
   166      !
   167      use namelist_util, only: namelist_filename, NmlutilMsg
   168  
   169      ! バケツモデル
   170      ! Bucket model
   171      !
   172      use Bucket_Model, only : &
   173        & BucketGetSoilMoistCritAmnt, &
   174        & BucketModelInit
   175  
   176  
   177      logical, intent(in) :: FlagSnow
   178  
   179  
   180      ! 作業変数
   181      ! Work variables
   182      !
   183      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   184                                ! Unit number for NAMELIST file open
   185      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   186                                ! IOSTAT of NAMELIST read
   187  
   188  
   189      ! NAMELIST 変数群
   190      ! NAMELIST group name
   191      !
   192      namelist /soil_thermdiffcoef_nml/ &
   193        & SoilThermDiffCoefMin, &
   194        & SoilThermDiffCoefMax
   195  
   196      ! 実行文 ; Executable statement
   197      !
   198  
   199      if ( soil_thermdiffcoef_inited ) return
   200  
   201  
   202      ! デフォルト値の設定
   203      ! Default values settings
   204      !
   205  
   206      SoilThermDiffCoefMin = 0.2_DP
   207      SoilThermDiffCoefMax = 2.0_DP
   208                       !   thermal conductivity (W m-1 K-1)
   209  
   210  
   211      ! NAMELIST の読み込み
   212      ! NAMELIST is input
   213      !
   214      if ( trim(namelist_filename) /= '' ) then
   215        call FileOpen( unit_nml, &          ! (out)
   216          & namelist_filename, mode = 'r' ) ! (in)
   217  
   218        rewind( unit_nml )
   219        read( unit_nml,                   &  ! (in)
   220          & nml = soil_thermdiffcoef_nml, &  ! (out)
   221          & iostat = iostat_nml           &  ! (out)
   222          & )
   223        close( unit_nml )
   224  
   225        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   226        if ( iostat_nml == 0 ) write( STDOUT, nml = soil_thermdiffcoef_nml )
   227      end if
   228  
   229  
   230      ! バケツモデル
   231      ! Bucket model
   232      !
   233      call BucketModelInit( &
   234        & FlagSnow          & ! (in)
   235        & )
   236      SoilMoistCritAmnt = BucketGetSoilMoistCritAmnt()
   237  
   238  
   239      ! 印字 ; Print
   240      !
   241      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   242      call MessageNotify( 'M', module_name, 'SoilThermDiffCoefMin = %f', d = (/SoilThermDiffCoefMin/) )
   243      call MessageNotify( 'M', module_name, 'SoilThermDiffCoefMax = %f', d = (/SoilThermDiffCoefMax/) )
   244      call MessageNotify( 'M', module_name, 'SoilMoistCritAmnt    = %f', d = (/SoilMoistCritAmnt/) )
   245      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   246  
   247      soil_thermdiffcoef_inited = .true.
   248  
   249    end subroutine SoilThermDiffCoefInit
   250  
   251    !--------------------------------------------------------------------------------------
   252  
   253  end module soil_thermdiffcoef
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: soil_thermdiffcoef.f90
PROGRAM NAME: soil_thermdiffcoef
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 土壌熱伝導係数の設定
     2:             !
     3:             != set soil thermal diffusion coefficient
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: soil_thermdiffcoef.f90,v 1.1 2015/01/29 12:12:21 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module soil_thermdiffcoef
    13:             
    14:               !== References
    15:               !
    16:             !!$  !  Matthews, E.,
    17:             !!$  !    Global vegetation and land use: New high-resolution data bases for climate 
    18:             !!$  !    studies, 
    19:             !!$  !    J. Clim. Appl. Meteor., 22, 474, 1983. 
    20:             !!$  !
    21:             !!$  !  Matthews, E., 
    22:             !!$  !    Prescription of land-surface boundary conditions in GISS GCM II:
    23:             !!$  !    A simple method based on fine-resolution data bases, 
    24:             !!$  !    NASA Technical memorandum #86096, 1984.
    25:             
    26:               ! モジュール引用 ; USE statements
    27:               !
    28:             
    29:               ! 種別型パラメタ
    30:               ! Kind type parameter
    31:               !
    32:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    33:                 &                 STRING     ! 文字列.       Strings.
    34:             
    35:               ! メッセージ出力
    36:               ! Message output
    37:               !
    38:               use dc_message, only: MessageNotify
    39:             
    40:               ! 宣言文 ; Declaration statements
    41:               !
    42:               implicit none
    43:               private
    44:             
    45:               ! 公開手続き
    46:               ! Public procedure
    47:               !
    48:               public:: SetSoilThermDiffCoefSimple
    49:               public:: SoilThermDiffCoefInit
    50:             
    51:               ! 公開変数
    52:               ! Public variables
    53:               !
    54:             
    55:               ! 非公開変数
    56:               ! Private variables
    57:               !
    58:               logical, save :: soil_thermdiffcoef_inited = .false.
    59:                                           ! 初期設定フラグ.
    60:                                           ! Initialization flag
    61:             
    62:               real(DP), save:: SoilThermDiffCoefMin
    63:               real(DP), save:: SoilThermDiffCoefMax
    64:             
    65:               real(DP), save:: SoilMoistCritAmnt
    66:             
    67:               character(*), parameter:: module_name = 'soil_thermdiffcoef'
    68:                                           ! モジュールの名称. 
    69:                                           ! Module name
    70:               character(*), parameter:: version = &
    71:                 & '$Name:  $' // &
    72:                 & '$Id: soil_thermdiffcoef.f90,v 1.1 2015/01/29 12:12:21 yot Exp $'
    73:                                           ! モジュールのバージョン
    74:                                           ! Module version
    75:             
    76:             contains
    77:             
    78:               !--------------------------------------------------------------------------------------
    79:             
    80:               subroutine SetSoilThermDiffCoefSimple( &
    81:                 & xy_SurfType, xy_SoilMoist,         & ! (in )
    82:                 & xy_SoilThermDiffCoef               & ! (out)
    83:                 & )
    84:             
    85:                 ! モジュール引用 ; USE statements
    86:                 !
    87:             
    88:                 ! 格子点設定
    89:                 ! Grid points settings
    90:                 !
    91:                 use gridset, only: imax, & ! 経度格子点数.
    92:                                            ! Number of grid points in longitude
    93:                   &                jmax, & ! 緯度格子点数.
    94:                                            ! Number of grid points in latitude
    95:                   &                kmax    ! 鉛直層数.
    96:                                            ! Number of vertical level
    97:             
    98:                 ! 宣言文 ; Declaration statements
    99:                 !
   100:                 integer , intent(in ) :: xy_SurfType         ( 0:imax-1, 1:jmax )
   101:                 real(DP), intent(in ) :: xy_SoilMoist        ( 0:imax-1, 1:jmax )
   102:                 real(DP), intent(out) :: xy_SoilThermDiffCoef( 0:imax-1, 1:jmax )
   103:             
   104:             
   105:                 ! 作業変数
   106:                 ! Work variables
   107:                 !
   108:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   109:                                           ! Work variables for DO loop in longitude
   110:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   111:                                           ! Work variables for DO loop in latitude
   112:             
   113:             
   114:                 ! 初期化確認
   115:                 ! Initialization check
   116:                 !
   117:                 if ( .not. soil_thermdiffcoef_inited ) then
   118:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   119:                 end if
   120:             
   121:             
   122:                 !
   123:                 ! land
   124:                 !
   125: W------>        do j = 1, jmax
   126: |*----->          do i = 0, imax-1
   127: ||      A           if( xy_SurfType( i, j ) >= 1 ) then
   128: ||      A             xy_SoilThermDiffCoef(i,j) =                           &
   129: ||                      &   ( SoilThermDiffCoefMax - SoilThermDiffCoefMin ) &
   130: ||                      & / ( SoilMoistCritAmnt    - 0.0_DP               ) &
   131: ||                      & * ( xy_SoilMoist(i,j)    - 0.0_DP               ) &
   132: ||                      & + SoilThermDiffCoefMin
   133: ||                    xy_SoilThermDiffCoef(i,j) =                           &
   134: ||                      & min( max( xy_SoilThermDiffCoef(i,j), SoilThermDiffCoefMin ), &
   135: ||                      &      SoilThermDiffCoefMax )
   136: ||                  else
   137: ||                    xy_SoilThermDiffCoef(i,j) = 1.0e100_DP
   138: ||                  end if
   139: |*----- A         end do
   140: W------         end do
   141:             
   142:             
   143:               end subroutine SetSoilThermDiffCoefSimple
   144:             
   145:               !--------------------------------------------------------------------------------------
   146:             
   147:               subroutine SoilThermDiffCoefInit( &
   148:                 & FlagSnow &
   149:                 & )
   150:             
   151:                 ! モジュール引用 ; USE statements
   152:                 !
   153:             
   154:                 ! 種別型パラメタ
   155:                 ! Kind type parameter
   156:                 !
   157:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   158:             
   159:                 ! ファイル入出力補助
   160:                 ! File I/O support
   161:                 !
   162:                 use dc_iounit, only: FileOpen
   163:             
   164:                 ! NAMELIST ファイル入力に関するユーティリティ
   165:                 ! Utilities for NAMELIST file input
   166:                 !
   167:                 use namelist_util, only: namelist_filename, NmlutilMsg
   168:             
   169:                 ! バケツモデル
   170:                 ! Bucket model
   171:                 !
   172:                 use Bucket_Model, only : &
   173:                   & BucketGetSoilMoistCritAmnt, &
   174:                   & BucketModelInit
   175:             
   176:             
   177:                 logical, intent(in) :: FlagSnow
   178:             
   179:             
   180:                 ! 作業変数
   181:                 ! Work variables
   182:                 !
   183:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   184:                                           ! Unit number for NAMELIST file open
   185:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   186:                                           ! IOSTAT of NAMELIST read
   187:             
   188:             
   189:                 ! NAMELIST 変数群
   190:                 ! NAMELIST group name
   191:                 !
   192:                 namelist /soil_thermdiffcoef_nml/ &
   193:                   & SoilThermDiffCoefMin, &
   194:                   & SoilThermDiffCoefMax
   195:             
   196:                 ! 実行文 ; Executable statement
   197:                 !
   198:             
   199:                 if ( soil_thermdiffcoef_inited ) return
   200:             
   201:             
   202:                 ! デフォルト値の設定
   203:                 ! Default values settings
   204:                 !
   205:             
   206:                 SoilThermDiffCoefMin = 0.2_DP
   207:                 SoilThermDiffCoefMax = 2.0_DP
   208:                                  !   thermal conductivity (W m-1 K-1)
   209:             
   210:             
   211:                 ! NAMELIST の読み込み
   212:                 ! NAMELIST is input
   213:                 !
   214:                 if ( trim(namelist_filename) /= '' ) then
   215:                   call FileOpen( unit_nml, &          ! (out)
   216:                     & namelist_filename, mode = 'r' ) ! (in)
   217:             
   218:                   rewind( unit_nml )
   219:                   read( unit_nml,                   &  ! (in)
   220:                     & nml = soil_thermdiffcoef_nml, &  ! (out)
   221:                     & iostat = iostat_nml           &  ! (out)
   222:                     & )
   223:                   close( unit_nml )
   224:             
   225:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   226:                   if ( iostat_nml == 0 ) write( STDOUT, nml = soil_thermdiffcoef_nml )
   227:                 end if
   228:             
   229:             
   230:                 ! バケツモデル
   231:                 ! Bucket model
   232:                 !
   233:                 call BucketModelInit( &
   234:                   & FlagSnow          & ! (in)
   235:                   & )
   236:                 SoilMoistCritAmnt = BucketGetSoilMoistCritAmnt()
   237:             
   238:             
   239:                 ! 印字 ; Print
   240:                 !
   241:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   242:                 call MessageNotify( 'M', module_name, 'SoilThermDiffCoefMin = %f', d = (/SoilThermDiffCoefMin/) )
   243:                 call MessageNotify( 'M', module_name, 'SoilThermDiffCoefMax = %f', d = (/SoilThermDiffCoefMax/) )
   244:                 call MessageNotify( 'M', module_name, 'SoilMoistCritAmnt    = %f', d = (/SoilMoistCritAmnt/) )
   245:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   246:             
   247:                 soil_thermdiffcoef_inited = .true.
   248:             
   249:               end subroutine SoilThermDiffCoefInit
   250:             
   251:               !--------------------------------------------------------------------------------------
   252:             
   253:             end module soil_thermdiffcoef
