Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:35 2016
FILE NAME: surface_properties.f90
PROGRAM NAME: surface_properties
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   633  opt  (1593): Loop nest collapsed into one loop.
   633  vec  (   4): Vectorized array expression.
   633  vec  (  29): ADB is used for array.: xy_seaiceconc
   633  vec  (  29): ADB is used for array.: xy_seaiceconcsave
   669  vec  (   3): Unvectorized loop.
   671  opt  (1025): Reference to this function inhibits optimization.
   671  vec  (  10): Vectorization obstructive procedure reference.:seaiceabovethreshold
   712  vec  (   3): Unvectorized loop.
   714  opt  (1017): Subroutine call prevents optimization.
   714  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   762  opt  (1592): Outer loop unrolled inside inner loop.
   762  vec  (   4): Vectorized array expression.
   762  vec  (  29): ADB is used for array.: xy_surfculintsave
   762  vec  (   4): Vectorized array expression.
   762  vec  (  29): ADB is used for array.: xy_surfculintsave
   769  opt  (1593): Loop nest collapsed into one loop.
   769  vec  (   4): Vectorized array expression.
   769  vec  (  29): ADB is used for array.: xy_surfculint
   769  vec  (  29): ADB is used for array.: xy_surfculintsave
   774  opt  (1593): Loop nest collapsed into one loop.
   774  vec  (   4): Vectorized array expression.
   774  vec  (  29): ADB is used for array.: xy_surfculint
   851  opt  (1593): Loop nest collapsed into one loop.
   851  vec  (   1): Vectorized loop.
   851  vec  (  29): ADB is used for array.: xy_surftemp
   851  vec  (  29): ADB is used for array.: xy_surftempsave
   851  vec  (  29): ADB is used for array.: xy_surfcond
   884  opt  (1592): Outer loop unrolled inside inner loop.
   884  vec  (   4): Vectorized array expression.
   884  vec  (  29): ADB is used for array.: xy_surfheight
   884  vec  (   4): Vectorized array expression.
   884  vec  (  29): ADB is used for array.: xy_surfheight
  1023  opt  (1593): Loop nest collapsed into one loop.
  1023  vec  (   4): Vectorized array expression.
  1023  vec  (  29): ADB is used for array.: xy_surfalbedo
  1023  vec  (  29): ADB is used for array.: xy_surfalbedosave
  1163  opt  (1592): Outer loop unrolled inside inner loop.
  1163  vec  (   4): Vectorized array expression.
  1163  vec  (  29): ADB is used for array.: xy_surfroughlenheat
  1163  vec  (  29): ADB is used for array.: xy_surfroughlenmom
  1163  vec  (   4): Vectorized array expression.
  1163  vec  (  29): ADB is used for array.: xy_surfroughlenheat
  1163  vec  (  29): ADB is used for array.: xy_surfroughlenmom
  1183  opt  (1592): Outer loop unrolled inside inner loop.
  1183  vec  (   4): Vectorized array expression.
  1183  vec  (  29): ADB is used for array.: xy_surfroughlenheat
  1183  vec  (  29): ADB is used for array.: xy_surfroughlenmom
  1183  vec  (   4): Vectorized array expression.
  1183  vec  (  29): ADB is used for array.: xy_surfroughlenheat
  1183  vec  (  29): ADB is used for array.: xy_surfroughlenmom
  1227  opt  (1592): Outer loop unrolled inside inner loop.
  1227  vec  (   4): Vectorized array expression.
  1227  vec  (  29): ADB is used for array.: xy_surfroughlenheat
  1227  vec  (  29): ADB is used for array.: xy_surfroughlenmom
  1227  vec  (   4): Vectorized array expression.
  1227  vec  (  29): ADB is used for array.: xy_surfroughlenheat
  1227  vec  (  29): ADB is used for array.: xy_surfroughlenmom
  1376  opt  (1592): Outer loop unrolled inside inner loop.
  1376  vec  (   4): Vectorized array expression.
  1376  vec  (  29): ADB is used for array.: xy_soilheatdiffcoef
  1376  vec  (  29): ADB is used for array.: xy_soilheatcap
  1376  vec  (   4): Vectorized array expression.
  1376  vec  (  29): ADB is used for array.: xy_soilheatdiffcoef
  1376  vec  (  29): ADB is used for array.: xy_soilheatcap
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:35 2016
FILE NAME: surface_properties.f90
PROGRAM NAME: surface_properties
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 惑星表面データの設定
     2  !
     3  != Setting planetary surface properties
     4  !
     5  ! Authors::   Yasuhiro Morikawa, Yukiko Yamada, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: surface_properties.f90,v 1.20 2015/01/31 06:16:26 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module surface_properties
    13    !
    14    != 惑星表面特性の設定
    15    !
    16    != Setting planetary surface properties
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 海面温度や地表面諸量を設定します.
    21    !
    22    ! Data about sea surface temperature (SST) or various values on surface
    23    ! are set.
    24    !
    25    !== Procedures List
    26    ! SetSurfaceProperties  :: 惑星表面特性の設定
    27    !--
    28  !!$  ! GroundFileOpen   :: 地表面データファイルのオープン
    29  !!$  ! GroundFileOutput :: 地表面データファイルへのデータ出力
    30  !!$  ! GroundFileClose  :: 地表面データファイルのクローズ
    31    !++
    32    ! ------------     :: ------------
    33    ! SetSurfaceProperties  :: Setting surface properties
    34    !--
    35  !!$  ! GroundFileOpen   :: Open ground data file
    36  !!$  ! GroundFileOutput :: Data output to ground data file
    37  !!$  ! GroundFileClose  :: Close ground data file
    38    !++
    39    !
    40    !== NAMELIST
    41    !
    42    ! NAMELIST#surface_properties_nml
    43    !
    44  
    45    ! モジュール引用 ; USE statements
    46    !
    47  
    48    ! 種別型パラメタ
    49    ! Kind type parameter
    50    !
    51    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    52      &                 STRING, &  ! 文字列.       Strings.
    53      &                 TOKEN      ! キーワード.   Keywords.
    54  
    55    ! メッセージ出力
    56    ! Message output
    57    !
    58    use dc_message, only: MessageNotify
    59  
    60    ! gtool5 データ出力
    61    ! Gtool5 data output
    62    !
    63    use gtool_history, only: GT_HISTORY
    64  
    65    ! 格子点設定
    66    ! Grid points settings
    67    !
    68    use gridset, only: imax, & ! 経度格子点数.
    69                               ! Number of grid points in longitude
    70      &                jmax, & ! 緯度格子点数.
    71                               ! Number of grid points in latitude
    72      &                kmax    ! 鉛直層数.
    73                               ! Number of vertical level
    74  
    75    ! 宣言文 ; Declaration statements
    76    !
    77    implicit none
    78    private
    79  
    80    ! 公開手続き
    81    ! Public procedure
    82    !
    83    public:: SetSurfaceProperties
    84    public:: SurfacePropertiesInit
    85  
    86    ! 公開変数
    87    ! Public variables
    88    !
    89    logical, save :: surface_properties_inited = .false.
    90                                ! 初期設定フラグ.
    91                                ! Initialization flag
    92  
    93  !!$  logical, save, public:: ground_file_opened = .false.
    94  !!$                              ! 地表面データファイルのオープンに関するフラグ.
    95  !!$                              ! Flag of ground data file open
    96  
    97    ! 非公開変数
    98    ! Private variables
    99    !
   100    logical          , save:: FlagSlabOcean
   101                                ! スラブオーシャン オン／オフ.
   102                                ! flag for use of slab ocean on/off
   103  
   104    character(STRING), save:: SurfTempSetting
   105                                ! 地表面温度の設定方法
   106                                ! Setting of surface temperature
   107    character(STRING), save:: SurfTempFile
   108                                ! 地表面温度のファイル名.
   109                                ! File name of surface temperature
   110    character(TOKEN) , save:: SurfTempName
   111                                ! 地表面温度の変数名.
   112                                ! Variable name of surface temperature
   113  
   114    character(STRING), save:: SeaIceSetting
   115                                ! 海氷面密度の設定方法
   116                                ! Setting of sea ice concentration
   117    character(STRING), save:: SeaIceFile
   118                                ! 海氷面密度のファイル名.
   119                                ! File name of sea ice concentration
   120    character(TOKEN) , save:: SeaIceName
   121                                ! 海氷面密度の変数名.
   122                                ! Variable name of sea ice concentration
   123  
   124    character(STRING), save:: AlbedoSetting
   125                                ! 地表アルベドの設定方法
   126                                ! Settingof surface albedo
   127    character(STRING), save:: AlbedoFile
   128                                ! 地表アルベドのファイル名.
   129                                ! File name of surface albedo
   130    character(TOKEN) , save:: AlbedoName
   131                                ! 地表アルベドの変数名.
   132                                ! Variable name of surface albedo
   133  
   134    character(STRING), save:: HumidCoefSetting
   135                                ! 地表湿潤度の設定方法
   136                                ! Setting of surface humidity coefficient
   137    character(STRING), save:: HumidCoefFile
   138                                ! 地表湿潤度のファイル名.
   139                                ! File name of surface humidity coefficient
   140    character(TOKEN) , save:: HumidCoefName
   141                                ! 地表湿潤度の変数名.
   142                                ! Variable name of surface humidity coefficient
   143  
   144    character(STRING), save:: RoughLengthSetting
   145                                ! 地表粗度長の設定方法
   146                                ! Setting of surface rough length
   147    character(STRING), save:: RoughLengthFile
   148                                ! 地表粗度長のファイル名.
   149                                ! File name of surface rough length
   150    character(TOKEN) , save:: RoughLengthName
   151                                ! 地表粗度長の変数名.
   152                                ! Variable name of surface rough length
   153    character(STRING), save:: HeatCapacitySetting
   154                                ! 地表熱容量の設定方法
   155                                ! Setting of surface heat capacity
   156    character(STRING), save:: HeatCapacityFile
   157                                ! 地表熱容量のファイル名.
   158                                ! File name of surface heat capacity
   159    character(TOKEN) , save:: HeatCapacityName
   160                                ! 地表熱容量の変数名.
   161                                ! Variable name of surface heat capacity
   162  
   163    character(STRING), save:: TempFluxSetting
   164                                ! 地中熱フラックスの設定方法
   165                                ! Setting of ground temperature flux
   166    character(STRING), save:: TempFluxFile
   167                                ! 地中熱フラックスのファイル名.
   168                                ! File name of ground temperature flux
   169    character(TOKEN) , save:: TempFluxName
   170                                ! 地中熱フラックスの変数名.
   171                                ! Variable name of ground temperature flux
   172  
   173    character(STRING), save:: SurfCondSetting
   174                                ! 惑星表面状態の設定方法
   175                                ! Setting of surface condition
   176    character(STRING), save:: SurfCondFile
   177                                ! 惑星表面状態のファイル名.
   178                                ! File name of surface condition
   179    character(TOKEN) , save:: SurfCondName
   180                                ! 惑星表面状態の変数名.
   181                                ! Variable name of surface condition
   182  
   183    character(STRING), save:: SurfTypeSetting
   184                                ! 惑星表面タイプ (土地利用) の設定方法
   185                                ! Setting of surface type (land use)
   186    character(STRING), save:: SurfTypeFile
   187                                ! 惑星表面タイプ (土地利用) のファイル名.
   188                                ! File name of surface type (land use)
   189    character(TOKEN) , save:: SurfTypeName
   190                                ! 惑星表面タイプ (土地利用) の変数名.
   191                                ! Variable name of surface type (land use)
   192  
   193    character(STRING), save:: SurfCulIntSetting
   194                                ! ... の設定方法
   195                                ! Setting of surface cultivation intensity
   196    character(STRING), save:: SurfCulIntFile
   197                                ! ... のファイル名.
   198                                ! File name of surface cultivation intensity
   199    character(TOKEN) , save:: SurfCulIntName
   200                                ! ... の変数名.
   201                                ! Variable name of surface cultivation intensity
   202  
   203    character(STRING), save:: SurfHeightSetting
   204                                ! 地表面高度の設定方法
   205                                ! Setting of surface height
   206    character(STRING), save:: SurfHeightFile
   207                                ! 地表面高度のファイル名.
   208                                ! File name of surface height
   209    character(TOKEN) , save:: SurfHeightName
   210                                ! 地表面高度の変数名.
   211                                ! Variable name of surface height
   212  
   213    character(STRING), save:: SurfHeightStdSetting
   214                                !
   215                                ! Setting of surface height standard deviation
   216    character(STRING), save:: SurfHeightStdFile
   217                                !
   218                                ! File name of surface height standard deviation
   219    character(TOKEN) , save:: SurfHeightStdName
   220                                !
   221                                ! Variable name of surface height standard deviation
   222  
   223    character(STRING), save:: SoilHeatCapSetting
   224                                ! 土壌熱容量の設定方法
   225                                ! Setting of heat conduction coefficient of soil
   226    character(STRING), save:: SoilHeatCapFile
   227                                ! 土壌熱容量のファイル名.
   228                                ! File name of heat conduction coefficient of soil
   229    character(TOKEN) , save:: SoilHeatCapName
   230                                ! 土壌熱容量の変数名.
   231                                ! Variable name of heat conduction coefficient of soil
   232  
   233    character(STRING), save:: SoilHeatDiffCoefSetting
   234                                ! 土壌熱伝導率の設定方法
   235                                ! Setting of heat conduction coefficient of soil
   236    character(STRING), save:: SoilHeatDiffCoefFile
   237                                ! 土壌熱伝導率のファイル名.
   238                                ! File name of heat conduction coefficient of soil
   239    character(TOKEN) , save:: SoilHeatDiffCoefName
   240                                ! 土壌熱伝導率の変数名.
   241                                ! Variable name of heat conduction coefficient of soil
   242  
   243    real(DP), save:: RoughLenHeatFactor
   244                                ! 運動量と熱の地表粗度長の比.
   245                                ! Ratio of roughness length for momentum and heat
   246  
   247    logical, save:: FlagUseBucket
   248  
   249  
   250  
   251  !!$  character(STRING), save:: OutputFile
   252  !!$                              ! 出力する地表面データのファイル名
   253  !!$                              ! filename of output ground data
   254  !!$  real(DP), save:: IntValue
   255  !!$                              ! 地表面データの出力間隔.
   256  !!$                              ! Interval of ground data output
   257  !!$  character(TOKEN):: IntUnit
   258  !!$                              ! 地表面データの出力間隔の単位.
   259  !!$                              ! Unit for interval of ground data output
   260  !!$
   261  !!$  type(GT_HISTORY), save:: gthst_grd
   262  !!$                              ! 地表面データ用 gtool_history#GT_HISTORY 変数
   263  !!$                              ! "gtool_history#GT_HISTORY" variable for ground data
   264  !!$
   265  !!$
   266  !!$  type(DC_DIFFTIME), save:: PrevOutputTime
   267  !!$                              ! 前回の出力時間.
   268  !!$                              ! Previous output time
   269  !!$
   270  !!$  type(DC_DIFFTIME), save:: IntTime
   271  !!$                              ! リスタートデータの出力時間.
   272  !!$                              ! Time interval of restart data output
   273  
   274    character(*), parameter:: module_name = 'surface_properties'
   275                                ! モジュールの名称.
   276                                ! Module name
   277    character(*), parameter:: version = &
   278      & '$Name:  $' // &
   279      & '$Id: surface_properties.f90,v 1.20 2015/01/31 06:16:26 yot Exp $'
   280                                ! モジュールのバージョン
   281                                ! Module version
   282  
   283  
   284  contains
   285  
   286    subroutine SetSurfaceProperties(                       &
   287      & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB,   & ! (in)    optional
   288      & xy_SOSeaIceMassB,                                  & ! (in)    optional
   289      & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoef,      & ! (inout) optional
   290      & xy_SurfRoughLenMom, xy_SurfRoughLenHeat,           & ! (inout) optional
   291      & xy_SurfHeatCapacity,                               & ! (inout) optional
   292      & xy_DeepSubSurfHeatFlux, xy_SurfCond, xy_SurfType,  & ! (inout) optional
   293      & xy_SurfHeight, xy_SurfHeightStd,                   & ! (inout) optional
   294      & xy_SeaIceConc,                                     & ! (inout) optional
   295      & xy_SoilHeatCap, xy_SoilHeatDiffCoef                & ! (inout) optional
   296      & )
   297      !
   298      ! 惑星表面特性を設定します.
   299      !
   300      ! Set surface properties.
   301      !
   302  
   303      ! モジュール引用 ; USE statements
   304      !
   305  
   306      ! 文字列操作
   307      ! Character handling
   308      !
   309      use dc_string, only: toChar
   310  
   311      ! gtool4 データ入力
   312      ! Gtool4 data input
   313      !
   314      use gtool_history, only: HistoryGet
   315  
   316      ! ヒストリデータ出力
   317      ! History data output
   318      !
   319      use gtool_historyauto, only: HistoryAutoPut
   320  
   321      ! 時系列データの読み込み
   322      ! Reading time series
   323      !
   324      use read_time_series, only: SetValuesFromTimeSeriesWrapper
   325  
   326      ! 時刻管理
   327      ! Time control
   328      !
   329      use timeset, only: &
   330        & TimeN, &              ! ステップ $ t $ の時刻.
   331                                ! Time of step $ t $.
   332        & EndTime, &            ! 計算終了時刻.
   333                                ! End time of calculation
   334        & TimesetClockStart, TimesetClockStop
   335  
   336      ! 地表面データ提供
   337      ! Prepare surface data
   338      !
   339      use surface_data, only: SetSurfData
   340  
   341      !
   342      ! Routines for GABLS tests
   343      !
   344      use gabls, only : SetGabls2SurfTemp
   345  
   346      ! Matthews のデータに基づく惑星表面アルベド設定
   347      ! set surface albedo based on data by Matthews
   348      !
   349      use albedo_Matthews, only: SetAlbedoMatthews, ModAlbedoMatthewsCultivation
   350  
   351      ! バケツモデル
   352      ! Bucket model
   353      !
   354      use Bucket_Model, only : BucketSetFlagOceanFromMatthews, BucketModHumidCoef
   355  
   356      ! 雪と海氷によるアルベド変化
   357      ! modification of surface albedo on the snow covered ground and on the sea ice
   358      !
   359      use modify_albedo_snowseaice, only: ModAlbedoDueToSnowSeaIce
   360  
   361      ! アルベド, 粗度長の設定, 陸面と海洋の差のみ考慮
   362      ! Set albedo and roughness length, only considering land-ocean contrast
   363      !
   364      use surface_properties_lo, only: &
   365        & SetAlbedoLO, SetRoughLenLO
   366  
   367      ! Matthews のデータに基づく地面粗度の設定
   368      ! set roughness length on land surface based on data by Matthews
   369      !
   370      use roughlen_Matthews, only: SetRoughLenLandMatthews, ModRoughLenMatthewsCultivation
   371  
   372      ! 土壌熱伝導係数の設定
   373      ! set soil thermal diffusion coefficient
   374      !
   375      use soil_thermdiffcoef, only : SetSoilThermDiffCoefSimple
   376  
   377      ! 雪, 氷の割合
   378      ! snow/ice fraction
   379      !
   380      use snowice_frac, only : SeaIceAboveThreshold
   381  
   382      ! 宣言文 ; Declaration statements
   383      !
   384      real(DP), intent(in   ), optional:: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   385                                ! $ M_mcs (t-\Delta t) $ .
   386                                ! Surface major component ice amount (kg m-2)
   387      real(DP), intent(in   ), optional:: xy_SoilMoistB(0:imax-1, 1:jmax)
   388                                ! $ M_ws (t-\Delta t) $ . 土壌水分 (kg m-2)
   389                                ! Soil moisture (kg m-2)
   390      real(DP), intent(in   ), optional:: xy_SurfSnowB(0:imax-1, 1:jmax)
   391                                ! $ M_ss (t-\Delta t) $ . 積雪量 (kg m-2)
   392                                ! Surface snow amount (kg m-2)
   393      real(DP), intent(in   ), optional:: xy_SOSeaIceMassB(0:imax-1, 1:jmax)
   394                                ! $ M_si (t-\Delta t) $ .
   395                                ! Slab seaice mass (kg m-2)
   396      real(DP), intent(inout), optional:: xy_SurfTemp (0:imax-1, 1:jmax)
   397                                ! 地表面温度.
   398                                ! Surface temperature
   399      real(DP), intent(inout), optional:: xy_SurfAlbedo (0:imax-1, 1:jmax)
   400                                ! 地表アルベド.
   401                                ! Surface albedo
   402      real(DP), intent(inout), optional:: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   403                                ! 地表湿潤度.
   404                                ! Surface humidity coefficient
   405      real(DP), intent(inout), optional:: xy_SurfRoughLenMom (0:imax-1, 1:jmax)
   406                                ! 地表粗度長.
   407                                ! Surface rough length for momentum
   408      real(DP), intent(inout), optional:: xy_SurfRoughLenHeat(0:imax-1, 1:jmax)
   409                                ! 地表粗度長.
   410                                ! Surface rough length for heat
   411      real(DP), intent(inout), optional:: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
   412                                ! 地表熱容量.
   413                                ! Surface heat capacity
   414      real(DP), intent(inout), optional:: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
   415                                ! 地中熱フラックス.
   416                                ! "Deep subsurface heat flux"
   417                                ! Heat flux at the bottom of surface/soil layer.
   418      integer , intent(inout), optional:: xy_SurfCond (0:imax-1, 1:jmax)
   419                                ! 惑星表面状態 (0: 固定, 1: 可変).
   420                                ! Surface condition (0: fixed, 1: variable)
   421      integer , intent(inout), optional:: xy_SurfType (0:imax-1, 1:jmax)
   422                                ! 惑星表面タイプ (土地利用)
   423                                ! Surface type (land use)
   424      real(DP), intent(inout), optional:: xy_SurfHeight   (0:imax-1, 1:jmax)
   425                                ! $ z_s $ . 地表面高度.
   426                                ! Surface height.
   427      real(DP), intent(inout), optional:: xy_SurfHeightStd(0:imax-1, 1:jmax)
   428                                ! $ z_s $ . 地表面高度.
   429                                ! Surface height.
   430      real(DP), intent(inout), optional:: xy_SeaIceConc(0:imax-1,1:jmax)
   431                                ! 海氷密度 (0 <= xy_SeaIceConc <= 1)
   432                                ! Sea ice concentration (0 <= xy_SeaIceConc <= 1)
   433      real(DP), intent(inout), optional:: xy_SoilHeatCap(0:imax-1,1:jmax)
   434                                ! 土壌熱容量 (J K-1 kg-1)
   435                                ! Specific heat of soil (J K-1 kg-1)
   436      real(DP), intent(inout), optional:: xy_SoilHeatDiffCoef(0:imax-1,1:jmax)
   437                                ! 土壌熱伝導率 (W m-1 K-1)
   438                                ! Heat conduction coefficient of soil (W m-1 K-1)
   439  
   440      ! 作業変数
   441      ! Work variables
   442      !
   443      real(DP), allocatable, save:: xy_SurfTempSave (:,:)
   444                                ! 地表面温度の保存値 (K)
   445                                ! Saved values of surface temperature (K)
   446      real(DP), allocatable, save:: xy_SeaIceConcSave(:,:)
   447                                ! 海氷面密度の保存値
   448                                ! Saved values of sea ice concentration
   449      real(DP), allocatable, save:: xy_SurfAlbedoSave(:,:)
   450                                ! アルベドの保存値
   451                                ! Saved values of albedo
   452  
   453      logical      :: xy_BucketFlagOceanGrid(0:imax-1,1:jmax)
   454                                !
   455                                ! Flag for ocean grid point used in bucket model
   456      real(DP), allocatable, save:: xy_SurfCulIntSave(:,:)
   457      real(DP)                   :: xy_SurfCulInt    (0:imax-1,1:jmax)
   458                                !
   459                                ! Surface cultivation intensity
   460  
   461      logical, save:: flag_first_SurfCond            = .true.
   462                                ! 初回を示すフラグ.
   463                                ! Flag that indicates first loop
   464                                !
   465      logical, save:: flag_first_SurfType            = .true.
   466      logical, save:: flag_first_SurfCulInt          = .true.
   467      logical, save:: flag_first_SeaIceConc          = .true.
   468      logical, save:: flag_first_SurfTemp            = .true.
   469      logical, save:: flag_first_SurfHeight          = .true.
   470      logical, save:: flag_first_SurfHeightStd       = .true.
   471      logical, save:: flag_first_SurfAlbedo          = .true.
   472      logical, save:: flag_first_SurfHumidCoef       = .true.
   473      logical, save:: flag_first_SurfRoughLen        = .true.
   474      logical, save:: flag_first_SurfHeatCapacity    = .true.
   475      logical, save:: flag_first_DeepSubSurfHeatFlux = .true.
   476      logical, save:: flag_first_SoilHeatCap         = .true.
   477      logical, save:: flag_first_SoilHeatDiffCoef    = .true.
   478  
   479      logical :: FlagSetSurfType
   480      logical :: FlagSetSeaIceConc
   481      logical :: FlagSetSurfCond
   482      logical :: FlagSetSurfCulInt
   483      logical :: FlagSetSurfTemp
   484      logical :: FlagSetSurfHeight
   485      logical :: FlagSetSurfHeightStd
   486      logical :: FlagSetSurfAlbedo
   487      logical :: FlagSetSurfHumidCoef
   488      logical :: FlagSetSurfRoughLenMom
   489      logical :: FlagSetSurfRoughLenHeat
   490      logical :: FlagSetSurfHeatCapacity
   491      logical :: FlagSetDeepSubSurfHeatFlux
   492      logical :: FlagSetSoilHeatCap
   493      logical :: FlagSetSoilHeatDiffCoef
   494  
   495      logical:: flag_mpi_init
   496  
   497      integer:: i               ! 経度方向に回る DO ループ用作業変数
   498                                ! Work variables for DO loop in longitude
   499      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   500                                ! Work variables for DO loop in latitude
   501  
   502  
   503      ! 実行文 ; Executable statement
   504      !
   505  
   506      ! 初期化確認
   507      ! Initialization check
   508      !
   509      if ( .not. surface_properties_inited ) then
   510        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   511      end if
   512  
   513  
   514      ! 計算時間計測開始
   515      ! Start measurement of computation time
   516      !
   517      call TimesetClockStart( module_name )
   518  
   519  
   520      flag_mpi_init = .true.
   521  
   522      FlagSetSurfType            = .false.
   523      FlagSetSeaIceConc          = .false.
   524      FlagSetSurfCond            = .false.
   525      FlagSetSurfCulInt          = .false.
   526      FlagSetSurfTemp            = .false.
   527      FlagSetSurfHeight          = .false.
   528      FlagSetSurfHeightStd       = .false.
   529      FlagSetSurfAlbedo          = .false.
   530      FlagSetSurfHumidCoef       = .false.
   531      FlagSetSurfRoughLenMom     = .false.
   532      FlagSetSurfRoughLenHeat    = .false.
   533      FlagSetSurfHeatCapacity    = .false.
   534      FlagSetDeepSubSurfHeatFlux = .false.
   535      FlagSetSoilHeatCap         = .false.
   536      FlagSetSoilHeatDiffCoef    = .false.
   537  
   538  
   539      ! NOTICE:
   540      ! The surface condition has to be set, before other fields are set.
   541      !
   542      ! 惑星表面タイプ (土地利用)
   543      ! Surface type (land use)
   544      !
   545      if ( present(xy_SurfType) ) then
   546  
   547        if ( SurfTypeSetting == 'file' ) then
   548          ! データをファイルから取得
   549          ! Data is input from files
   550          !
   551          if ( flag_first_SurfType ) then
   552            call HistoryGet( &
   553              & SurfTypeFile, SurfTypeName, &     ! (in)
   554              & xy_SurfType, &                    ! (out)
   555              & flag_mpi_split = flag_mpi_init )  ! (in) optional
   556          end if
   557          if ( SurfCondSetting /= 'generate_from_SurfType' ) then
   558            call MessageNotify( 'E', module_name, &
   559              & " SurfCond has to be 'generate_from_SurfType', if SurfTypeSetting = %c.", &
   560              & c1 = trim(SurfTypeSetting) )
   561          end if
   562        else if ( SurfTypeSetting == 'generate_internally' ) then
   563          ! データ (デフォルト値) を surface_data モジュールから取得
   564          ! Data (default values) is input from "surface_data" module
   565          !
   566          if ( flag_first_SurfType ) then
   567            call SetSurfData( &
   568              & xy_SurfType = xy_SurfType &                   ! (out)
   569              & )
   570          end if
   571        else
   572          call MessageNotify( 'E', module_name, &
   573            & ' SurfTypeSetting = %c is not appropriate.', &
   574            & c1 = trim(SurfTypeSetting) )
   575        end if
   576  
   577        FlagSetSurfType = .true.
   578  
   579        flag_first_SurfType = .false.
   580  
   581      end if
   582  
   583  
   584      ! NOTICE:
   585      ! The sea ice distribution has to be set,
   586      ! before set SurfTemp (surface temperature) and SurfCond.
   587      !
   588      ! 海氷面密度
   589      ! Sea ice concentration
   590      !
   591      if ( present(xy_SeaIceConc) ) then
   592  
   593        if ( flag_first_SeaIceConc ) then
   594          ! 保存用変数の割付
   595          ! Allocate a variable for save
   596          !
   597          allocate( xy_SeaIceConcSave(0:imax-1, 1:jmax) )
   598        end if
   599        if ( SeaIceSetting == 'file' ) then
   600          ! データをファイルから取得
   601          ! Data is input from files
   602          !
   603  
   604          ! This will be deleted near future (yot, 2010/10/11)
   605  !!$        if ( flag_first_SeaIceConc ) then
   606  !!$          call HistoryGet( &
   607  !!$            & SeaIceFile, SeaIceName,          & ! (in)
   608  !!$            & xy_SeaIceConcSave,               & ! (out)
   609  !!$            & flag_mpi_split = flag_mpi_init )   ! (in) optional
   610  !!$        end if
   611          call SetValuesFromTimeSeriesWrapper(    &
   612            & 'SIC',                              &
   613            & SeaIceFile, SeaIceName,             &
   614            & xy_SeaIceConcSave                   &               ! (inout)
   615            & )
   616        else if ( SeaIceSetting == 'generate_internally' ) then
   617          ! データ (デフォルト値) を surface_data モジュールから取得
   618          ! Data (default values) is input from "surface_data" module
   619          !
   620          if ( flag_first_SeaIceConc ) then
   621            call SetSurfData( &
   622              & xy_SeaIceConc = xy_SeaIceConcSave &                   ! (out)
   623              & )
   624          end if
   625        else
   626          call MessageNotify( 'E', module_name, &
   627            & ' SeaIceSetting = %c is not appropriate.', &
   628            & c1 = trim(SeaIceSetting) )
   629        end if
   630        ! 海氷面密度の設定 ( xy_SurfCond == 0 の場所のみ )
   631        ! Setting of sea ice concentration ( where xy_SurfCond == 0 only )
   632        !
   633        xy_SeaIceConc = xy_SeaIceConcSave
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1045 = 1, jmax*imax                                           
     .           xy_seaiceconc(t1045-1,1) = xy_seaiceconcsave(                  
     .       1      xy_seaiceconcsave.DSC.L1+t1045-1,xy_seaiceconcsave.DSC.L2)  
     .        enddo                                                             
   634  
   635        FlagSetSeaIceConc = .true.
   636  
   637        flag_first_SeaIceConc = .false.
   638  
   639      end if
   640  
   641  
   642      ! 惑星表面状態
   643      ! Surface condition
   644      ! Flag whether surface temperature is calculated or not
   645      ! 0 : surface temperature is not calculated
   646      ! 1 : surface temperature is     calculated
   647      !
   648      if ( present(xy_SurfCond) ) then
   649  
   650        ! NOTICE:
   651        ! Before set SurfCond, SeaIceConc has to be set.
   652        if ( .not. FlagSetSeaIceConc ) then
   653          call MessageNotify( 'E', module_name, &
   654            & " SeaIceConc has to be set before setting SurfCond is set." )
   655        end if
   656  
   657        if ( SurfCondSetting == 'generate_from_SurfType' ) then
   658          if ( flag_first_SurfCond ) then
   659  !!$          if ( ( SurfTypeSetting /= 'file' ) .and. ( SurfTypeSetting /= 'generate_internally' ) ) then
   660  !!$            call MessageNotify( 'E', module_name, &
   661  !!$              & " SurfCond has to be 'generate_from_SurfType' or 'generate_internally', if SurfTypeSetting = %c.", &
   662  !!$              & c1 = trim(SurfTypeSetting) )
   663  !!$          end if
   664            call MessageNotify( 'M', module_name, &
   665              & ' xy_SurfCond is constructed by use of xy_SurfType values because SurfTypeSetting = %c.', &
   666              & c1 = trim(SurfTypeSetting) )
   667          end if
   668          do j = 1, jmax
   669            do i = 0, imax-1
   670              if ( xy_SurfType(i,j) == 0 ) then
   671                if ( SeaIceAboveThreshold( xy_SeaIceConc(i,j) ) ) then
   672                  xy_SurfCond(i,j) = 1
   673                else if ( FlagSlabOcean ) then
   674                  xy_SurfCond(i,j) = 1
   675                else
   676                  xy_SurfCond(i,j) = 0
   677                end if
   678              else
   679                xy_SurfCond(i,j) = 1
   680              end if
   681            end do
   682          end do
   683  
   684        else if ( SurfCondSetting == 'file' ) then
   685          ! データをファイルから取得
   686          ! Data is input from files
   687          !
   688          if ( flag_first_SurfCond ) then
   689            call HistoryGet( &
   690              & SurfCondFile, SurfCondName, &     ! (in)
   691              & xy_SurfCond, &                    ! (out)
   692              & flag_mpi_split = flag_mpi_init )  ! (in) optional
   693          end if
   694        else if ( SurfCondSetting == 'generate_internally' ) then
   695          ! データ (デフォルト値) を surface_data モジュールから取得
   696          ! Data (default values) is input from "surface_data" module
   697          !
   698          if ( flag_first_SurfCond ) then
   699            call SetSurfData( &
   700              & xy_SurfCond = xy_SurfCond &                   ! (out)
   701              & )
   702          end if
   703        else
   704          call MessageNotify( 'E', module_name, &
   705            & ' SurfCondSetting = %c is not appropriate.', &
   706            & c1 = trim(SurfCondSetting) )
   707        end if
   708  
   709        ! Check of SurfCond values
   710        !
   711        do j = 1, jmax
   712          do i = 0, imax-1
   713            if ( ( xy_SurfCond(i,j) < 0 ) .or. ( xy_SurfCond(i,j) > 1 ) ) then
   714              call MessageNotify( 'E', module_name, &
   715                & ' SurfCond value of %d is not appropriate.', &
   716                & i = (/ xy_SurfCond(i,j) /) )
   717            end if
   718          end do
   719        end do
   720  
   721        FlagSetSurfCond = .true.
   722  
   723        flag_first_SurfCond = .false.
   724  
   725      end if
   726  
   727  
   728      !
   729      ! Surface cultivation index
   730      !
   731      ! Cultivation intensity is set only when xy_SurfType is present.
   732      if ( present( xy_SurfType ) ) then
   733  
   734        ! NOTICE:
   735        ! Before set SurfCulInt, SurfType has to be set.
   736        if ( .not. FlagSetSurfType ) then
   737          call MessageNotify( 'E', module_name, &
   738            & " SurfType has to be set before setting SurfCulInt is set." )
   739        end if
   740  
   741        if ( flag_first_SurfCulInt ) then
   742          ! 保存用変数の割付
   743          ! Allocate a variable for save
   744          !
   745          allocate( xy_SurfCulIntSave(0:imax-1, 1:jmax) )
   746        end if
   747        if ( SurfCulIntSetting == 'file' ) then
   748          ! データをファイルから取得
   749          ! Data is input from files
   750          !
   751          if ( SurfTypeSetting /= 'file' ) then
   752            call MessageNotify( 'E', module_name, &
   753              & " SurfType has to be 'file', when SurfCulIntSetting = %c.", &
   754              & c1 = trim(SurfCulIntSetting) )
   755          end if
   756          call SetValuesFromTimeSeriesWrapper(    &
   757            & 'CI',                               &
   758            & SurfCulIntFile, SurfCulIntName,     &
   759            & xy_SurfCulIntSave                   &               ! (inout)
   760            & )
   761        else if ( SurfCulIntSetting == 'generate_internally' ) then
   762          xy_SurfCulIntSave = 0.0_DP
     .        if(xy_surfculintsave.DSC.U2+1-xy_surfculintsave.DSC.L2.gt.0)then  
     .           j1 = and(xy_surfculintsave.DSC.U2 + 1 -                        
     .       1      xy_surfculintsave.DSC.L2,3)                                 
     .  !cdir    nodep                                                          
     .           do t1039 = 1, j1                                               
     .  !cdir       nodep                                                       
     .              do t1041 = 1, xy_surfculintsave.DSC.U1 -                    
     .       1         xy_surfculintsave.DSC.L1 + 2 - min0(1,                   
     .       2         xy_surfculintsave.DSC.U1 - xy_surfculintsave.DSC.L1 + 1) 
     .                 xy_surfculintsave(t28+t1041-1,t1039-1+t30) =             
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1039 = j1 + 1, xy_surfculintsave.DSC.U2 + 1 -              
     .       1      xy_surfculintsave.DSC.L2, 4                                 
     .  !cdir       nodep                                                       
     .              do t1041 = 1, xy_surfculintsave.DSC.U1 -                    
     .       1         xy_surfculintsave.DSC.L1 + 2 - min0(1,                   
     .       2         xy_surfculintsave.DSC.U1 - xy_surfculintsave.DSC.L1 + 1) 
     .                 xy_surfculintsave(t28+t1041-1,t1039-1+t30) =             
     .       1            0.0000000000000000e+000                               
     .                 xy_surfculintsave(t28+t1041-1,t1039+t30) =               
     .       1            0.0000000000000000e+000                               
     .                 xy_surfculintsave(t28+t1041-1,t1039+1+t30) =             
     .       1            0.0000000000000000e+000                               
     .                 xy_surfculintsave(t28+t1041-1,t1039+2+t30) =             
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10243                                                        
   763        else
   764          call MessageNotify( 'E', module_name, &
   765            & ' SurfCulIntSetting = %c is not appropriate.', &
   766            & c1 = trim(SurfCulIntSetting) )
   767        end if
   768        !
   769        xy_SurfCulInt = xy_SurfCulIntSave
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1031 = 1, xy_surfculint.DSC.U2*xy_surfculint.DSC.U1 +         
     .       1   xy_surfculint.DSC.U2                                           
     .           xy_surfculint(t1031-1,1) = xy_surfculintsave(t28+t1031-1,t30)  
     .        enddo                                                             
   770  
   771        FlagSetSurfCulInt = .true.
   772        flag_first_SurfCulInt = .false.
   773      else
   774        xy_SurfCulInt = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t977 = 1, xy_surfculint.DSC.U2*xy_surfculint.DSC.U1 +          
     .       1   xy_surfculint.DSC.U2                                           
     .           xy_surfculint(t977-1,1) = 0.0000000000000000e+000              
     .        enddo                                                             
   775  
   776        FlagSetSurfCulInt = .true.
   777      end if
   778  
   779  
   780  
   781      ! 地表面温度
   782      ! surface temperature
   783      !
   784      if ( present(xy_SurfTemp) ) then
   785  
   786        ! NOTICE:
   787        ! Before set surface temperature, sea ice distribution has to be set.
   788        if ( .not. FlagSetSeaIceConc ) then
   789          call MessageNotify( 'E', module_name, &
   790            & " SeaIceConc has to be set before setting SurfTemp is set." )
   791        end if
   792  
   793        if ( flag_first_SurfTemp ) then
   794          ! 保存用変数の割付
   795          ! Allocate a variable for save
   796          !
   797          allocate( xy_SurfTempSave  (0:imax-1, 1:jmax) )
   798        end if
   799        if ( SurfTempSetting == 'file' ) then
   800          ! データをファイルから取得
   801          ! Data is input from files
   802          !
   803  
   804          ! This will be deleted near future (yot, 2010/10/11)
   805  !!$        if ( flag_first_SurfTemp ) then
   806  !!$          call HistoryGet( &
   807  !!$            & SurfTempFile, SurfTempName, &    ! (in)
   808  !!$            & xy_SurfTempSave, &               ! (out)
   809  !!$            & flag_mpi_split = flag_mpi_init ) ! (in) optional
   810  !!$        end if
   811          call SetValuesFromTimeSeriesWrapper(    &
   812            & 'SST',                              &
   813            & SurfTempFile, SurfTempName,         &
   814            & xy_SurfTempSave                     &               ! (inout)
   815            & )
   816        else if ( SurfTempSetting == 'GABLS2' ) then
   817          !
   818          ! Routines for GABLS tests
   819          !
   820          call SetGabls2SurfTemp(     &
   821            & xy_SurfTempSave         & ! (out)
   822            & )
   823        else if ( SurfTempSetting == 'generate_internally' ) then
   824          ! データ (デフォルト値) を surface_data モジュールから取得
   825          ! Data (default values) is input from "surface_data" module
   826          !
   827          if ( flag_first_SurfTemp ) then
   828            call SetSurfData( &
   829              & xy_SurfTemp = xy_SurfTempSave & ! (out) optional
   830              & )
   831          end if
   832        else
   833          call MessageNotify( 'E', module_name, &
   834            & ' SurfTempSetting = %c is not appropriate.', &
   835            & c1 = trim(SurfTempSetting) )
   836        end if
   837        ! 地表面温度を SST で置き換え ( xy_SurfCond <=0 の場所のみ )
   838        ! Surface temperature is replaced with SST ( only xy_SurfCond <=0 )
   839        !
   840        if ( present(xy_SurfTemp) ) then
   841  
   842          if ( .not. present( xy_SurfCond ) ) then
   843            call MessageNotify( 'E', module_name, &
   844              & ' xy_SurfCond has to be present to set xy_SurfTemp.' )
   845          end if
   846          if ( .not. present( xy_SeaIceConc ) ) then
   847            call MessageNotify( 'E', module_name, &
   848              & ' xy_SeaIceConc has to be present to set xy_SurfTemp.' )
   849          end if
   850  
   851          do j = 1, jmax
   852            do i = 0, imax-1
   853              if ( xy_SurfCond(i,j) == 0 ) then
   854                xy_SurfTemp(i,j) = xy_SurfTempSave(i,j)
   855              end if
   856            end do
   857          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surfcond(j-1,1) .eq. 0) then                            
     .              xy_surftemp(j-1,1) = xy_surftempsave(j-1,1)                 
     .           endif                                                          
     .        enddo                                                             
   858  
   859        end if
   860  
   861        FlagSetSurfTemp = .true.
   862  
   863        flag_first_SurfTemp = .false.
   864      end if
   865  
   866  
   867      ! 地形
   868      ! Topography
   869      !
   870      if ( present(xy_SurfHeight) ) then
   871  
   872        if ( SurfHeightSetting == 'file' ) then
   873          ! データをファイルから取得
   874          ! Data is input from files
   875          !
   876          if ( flag_first_SurfHeight ) then
   877            call HistoryGet( &
   878              & SurfHeightFile, SurfHeightName, &  ! (in)
   879              & xy_SurfHeight, &                   ! (out)
   880              & flag_mpi_split = flag_mpi_init )   ! (in) optional
   881          end if
   882        else if ( SurfHeightSetting == 'generate_internally' ) then
   883          if ( flag_first_SurfHeight ) then
   884            xy_SurfHeight = 0.0_DP
     .        if (xy_surfheight.DSC.U2 .gt. 0) then                             
     .           j2 = and(xy_surfheight.DSC.U2,3)                               
     .  !cdir    nodep                                                          
     .           do t1025 = 1, j2                                               
     .  !cdir       nodep                                                       
     .              do t1027 = 1, xy_surfheight.DSC.U1 + 2 - min0(1,            
     .       1         xy_surfheight.DSC.U1 + 1)                                
     .                 xy_surfheight(t1027-1,t1025) = 0.0000000000000000e+000   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1025 = j2 + 1, xy_surfheight.DSC.U2, 4                     
     .  !cdir       nodep                                                       
     .              do t1027 = 1, xy_surfheight.DSC.U1 + 2 - min0(1,            
     .       1         xy_surfheight.DSC.U1 + 1)                                
     .                 xy_surfheight(t1027-1,t1025) = 0.0000000000000000e+000   
     .                 xy_surfheight(t1027-1,t1025+1) = 0.0000000000000000e+000 
     .                 xy_surfheight(t1027-1,t1025+2) = 0.0000000000000000e+000 
     .                 xy_surfheight(t1027-1,t1025+3) = 0.0000000000000000e+000 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10202                                                        
   885          end if
   886        else
   887          call MessageNotify( 'E', module_name, &
   888            & ' SurfHeightSetting = %c is not appropriate.', &
   889            & c1 = trim(SurfHeightSetting) )
   890        end if
   891  
   892        FlagSetSurfHeight = .true.
   893  
   894        flag_first_SurfHeight = .false.
   895      end if
   896  
   897      !
   898      ! Surface height standard deviation
   899      !
   900      if ( present(xy_SurfHeightStd) ) then
   901  
   902        if ( SurfHeightStdSetting == 'file' ) then
   903          ! データをファイルから取得
   904          ! Data is input from files
   905          !
   906          if ( flag_first_SurfHeightStd ) then
   907            call HistoryGet( &
   908              & SurfHeightStdFile, SurfHeightStdName, & ! (in)
   909              & xy_SurfHeightStd, &                     ! (out)
   910              & flag_mpi_split = flag_mpi_init )        ! (in) optional
   911          end if
   912        else if ( SurfHeightStdSetting == 'generate_internally' ) then
   913          ! データ (デフォルト値) を surface_data モジュールから取得
   914          ! Data (default values) is input from "surface_data" module
   915          !
   916          if ( flag_first_SurfHeightStd ) then
   917            call SetSurfData( &
   918              & xy_SurfHeightStd = xy_SurfHeightStd  & ! (out)
   919              & )
   920          end if
   921        else
   922          call MessageNotify( 'E', module_name, &
   923            & ' SurfHeightStdSetting = %c is not appropriate.', &
   924            & c1 = trim(SurfHeightStdSetting) )
   925        end if
   926  
   927        FlagSetSurfHeightStd = .true.
   928  
   929        flag_first_SurfHeightStd = .false.
   930      end if
   931  
   932  
   933      ! アルベド
   934      ! Albedo
   935      !
   936      if ( present(xy_SurfAlbedo) ) then
   937  
   938        ! NOTICE:
   939        ! The surface condition and sea ice concentration have to be set,
   940        ! before albedo is set.
   941        if ( ( .not. FlagSetSurfCond ) .or. ( .not. FlagSetSeaIceConc ) ) then
   942          call MessageNotify( 'E', module_name, &
   943            & " SurfCond and SeaIceConc have to be set before setting SurfAlbedo is set." )
   944        end if
   945  
   946        if ( flag_first_SurfAlbedo ) then
   947          ! 保存用変数の割付
   948          ! Allocate a variable for save
   949          !
   950          allocate( xy_SurfAlbedoSave(0:imax-1, 1:jmax) )
   951        end if
   952        if ( AlbedoSetting == 'file' ) then
   953          ! データをファイルから取得
   954          ! Data is input from files
   955          !
   956          if ( flag_first_SurfAlbedo ) then
   957            call HistoryGet( &
   958              & AlbedoFile, AlbedoName, &        ! (in)
   959              & xy_SurfAlbedoSave,      &        ! (out)
   960              & flag_mpi_split = flag_mpi_init ) ! (in) optional
   961          end if
   962  !!$        call SetValuesFromTimeSeriesWrapper(    &
   963  !!$          & 'surface_albedo',                   &
   964  !!$          & AlbedoFile, AlbedoName,             &
   965  !!$          & xy_SurfAlbedoSave                   &               ! (inout)
   966  !!$          & )
   967        else if ( AlbedoSetting == 'Matthews' ) then
   968          ! アルベドを Matthews のデータをもとに設定
   969          ! Surface albedo is set based on Matthews' data
   970          !
   971          if ( .not. present( xy_SurfType ) ) then
   972            call MessageNotify( 'E', module_name, &
   973              & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
   974          end if
   975          if ( SurfTypeSetting /= 'file' ) then
   976            call MessageNotify( 'E', module_name, &
   977              & " SurfType has to be 'file', when AlbedoSetting = %c.", &
   978              & c1 = trim(AlbedoSetting) )
   979          end if
   980          call SetAlbedoMatthews( &
   981            & xy_SurfType,      &
   982            & xy_SurfAlbedoSave &
   983            & )
   984          ! Modify albedo due to cultivation
   985          call ModAlbedoMatthewsCultivation( &
   986            & xy_SurfType, xy_SurfCulInt,    &
   987            & xy_SurfAlbedoSave              &
   988            & )
   989        else if ( AlbedoSetting == 'LOContrast' ) then
   990          ! アルベドの設定, 陸面と海洋の差のみ考慮
   991          ! Set albedo, only considering land-ocean contrast
   992          !
   993          if ( .not. present( xy_SurfType ) ) then
   994            call MessageNotify( 'E', module_name, &
   995              & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
   996          end if
   997          if ( SurfTypeSetting /= 'file' ) then
   998            call MessageNotify( 'E', module_name, &
   999              & " SurfType has to be 'file', when AlbedoSetting = %c.", &
  1000              & c1 = trim(AlbedoSetting) )
  1001          end if
  1002          call SetAlbedoLO(      &
  1003            & xy_SurfType,       &
  1004            & xy_SurfAlbedoSave  &
  1005            & )
  1006        else if ( AlbedoSetting == 'generate_internally' ) then
  1007          ! データ (デフォルト値) を surface_data モジュールから取得
  1008          ! Data (default values) is input from "surface_data" module
  1009          !
  1010          if ( flag_first_SurfAlbedo ) then
  1011            call SetSurfData( &
  1012              & xy_SurfAlbedo = xy_SurfAlbedoSave  & ! (out)
  1013              & )
  1014          end if
  1015        else
  1016          call MessageNotify( 'E', module_name, &
  1017            & ' AlbedoSetting = %c is not appropriate.', &
  1018            & c1 = trim(AlbedoSetting) )
  1019        end if
  1020        ! アルベドの設定
  1021        ! Setting of albedo
  1022        !
  1023        xy_SurfAlbedo = xy_SurfAlbedoSave
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1017 = 1, jmax*imax                                           
     .           xy_surfalbedo(t1017-1,1) = xy_surfalbedosave(                  
     .       1      xy_surfalbedosave.DSC.L1+t1017-1,xy_surfalbedosave.DSC.L2)  
     .        enddo                                                             
  1024  
  1025  
  1026        if ( present( xy_SurfType ) ) then
  1027          ! 雪と海氷によるアルベド変化
  1028          ! modification of surface albedo on the snow covered ground and on the sea ice
  1029          !
  1030  
  1031          if ( .not. present( xy_SurfMajCompIceB ) ) then
  1032            call MessageNotify( 'E', module_name, &
  1033              & ' xy_SurfMajCompIceB has to be present to set xy_SurfAlbedo.' )
  1034          end if
  1035          if ( .not. present( xy_SurfSnowB ) ) then
  1036            call MessageNotify( 'E', module_name, &
  1037              & ' xy_SurfSnowB has to be present to set xy_SurfAlbedo.' )
  1038          end if
  1039          if ( .not. present( xy_SeaIceConc ) ) then
  1040            call MessageNotify( 'E', module_name, &
  1041              & ' xy_SeaIceConc has to be present to set xy_SurfAlbedo.' )
  1042          end if
  1043  
  1044          if ( .not. present( xy_SurfType ) ) then
  1045            call MessageNotify( 'E', module_name, &
  1046              & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
  1047          end if
  1048  !!$        if ( SurfTypeSetting /= 'file' ) then
  1049  !!$          call MessageNotify( 'E', module_name, &
  1050  !!$            & " SurfType has to be 'file'." )
  1051  !!$        end if
  1052  
  1053          call ModAlbedoDueToSnowSeaIce(                                         &
  1054            & xy_SurfType,                                                       &
  1055            & xy_SurfMajCompIceB, xy_SurfSnowB, xy_SeaIceConc, xy_SOSeaIceMassB, & ! (in   ) optional
  1056            & xy_SurfTemp,                                                       & ! (in)
  1057            & xy_SurfAlbedo                                                      & ! (inout)
  1058            & )
  1059        else
  1060          call MessageNotify( 'E', module_name, &
  1061            & ' xy_SurfType has to be present to modify albedo due to snow and sea ice.' )
  1062        end if
  1063  
  1064        FlagSetSurfAlbedo = .true.
  1065  
  1066        flag_first_SurfAlbedo = .false.
  1067      end if
  1068  
  1069  
  1070      ! 惑星表面湿潤度
  1071      ! Surface humidity coefficient
  1072      !
  1073      if ( present(xy_SurfHumidCoef) ) then
  1074  
  1075        ! NOTICE:
  1076        ! The surface condition has to be set, before humidity coefficient
  1077        ! is set.
  1078        if ( .not. FlagSetSurfCond ) then
  1079          call MessageNotify( 'E', module_name, &
  1080            & " SurfCond has to be set before setting SurfHumidCoef is set." )
  1081        end if
  1082  
  1083        if ( HumidCoefSetting == 'file' ) then
  1084          ! データをファイルから取得
  1085          ! Data is input from files
  1086          !
  1087          if ( flag_first_SurfHumidCoef ) then
  1088            call HistoryGet( &
  1089              & HumidcoefFile, HumidcoefName, &  ! (in)
  1090              & xy_SurfHumidcoef, &              ! (out)
  1091              & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1092          end if
  1093        else if ( HumidCoefSetting == 'generate_internally' ) then
  1094          ! データ (デフォルト値) を surface_data モジュールから取得
  1095          ! Data (default values) is input from "surface_data" module
  1096          !
  1097          if ( flag_first_SurfHumidCoef ) then
  1098            call SetSurfData( &
  1099              & xy_SurfHumidCoef = xy_SurfHumidCoef  & ! (out)
  1100              & )
  1101          end if
  1102        else
  1103          call MessageNotify( 'E', module_name, &
  1104            & ' HumidCoefSetting = %c is not appropriate.', &
  1105            & c1 = trim(HumidCoefSetting) )
  1106        end if
  1107  
  1108        if ( FlagUseBucket ) then
  1109          if ( &
  1110            & ( present( xy_SurfType   ) ) .and. &
  1111            & ( present( xy_SoilMoistB ) ) .and. &
  1112            & ( present( xy_SurfSnowB  ) )       &
  1113            & ) then
  1114            ! バケツモデルに関わる地表面湿潤度の設定
  1115            ! Setting of surface humidity coefficient
  1116            !
  1117            call BucketSetFlagOceanFromMatthews( &
  1118              & xy_SurfType,                     & ! (in)
  1119              & xy_BucketFlagOceanGrid           & ! (out)
  1120              & )
  1121            call BucketModHumidCoef(                                 &
  1122              & xy_BucketFlagOceanGrid, xy_SoilMoistB, xy_SurfSnowB, & ! (in   )
  1123              & xy_SurfHumidCoef                                     & ! (inout)
  1124              & )
  1125          else
  1126            call MessageNotify( 'E', module_name, &
  1127              & ' xy_SurfType, xy_SoilMoistB and xy_SurfSnowB have to be present to modify humidity coefficient with bucket model.' )
  1128          end if
  1129        end if
  1130  
  1131        FlagSetSurfHumidCoef = .true.
  1132  
  1133        flag_first_SurfHumidCoef = .false.
  1134      end if
  1135  
  1136  
  1137      ! 粗度長
  1138      ! Roughness length
  1139      !
  1140      if ( present(xy_SurfRoughLenMom) ) then
  1141        if ( .not. present(xy_SurfRoughLenHeat) ) then
  1142          call MessageNotify( 'E', module_name, &
  1143            & ' xy_SurfRoughLenHeat has to be present if xy_SurfRoughLenMom is present.' )
  1144        end if
  1145      else
  1146        if ( present(xy_SurfRoughLenHeat) ) then
  1147          call MessageNotify( 'E', module_name, &
  1148            & ' xy_SurfRoughLenMom has to be present if xy_SurfRoughLenHeat is present.' )
  1149        end if
  1150      end if
  1151      if ( present(xy_SurfRoughLenMom) .and. present(xy_SurfRoughLenHeat) ) then
  1152  
  1153        if ( RoughLengthSetting == 'file' ) then
  1154          ! データをファイルから取得
  1155          ! Data is input from files
  1156          !
  1157          if ( flag_first_SurfRoughLen ) then
  1158            call HistoryGet( &
  1159              & RoughLengthFile, RoughLengthName, & ! (in)
  1160              & xy_SurfRoughLenMom, &               ! (out)
  1161              & flag_mpi_split = flag_mpi_init )    ! (in) optional
  1162            ! set roughness length for heat
  1163            xy_SurfRoughLenHeat = xy_SurfRoughLenMom * RoughLenHeatFactor
     .        if (xy_surfroughlenmom.DSC.U2 .gt. 0) then                        
     .           j3 = and(xy_surfroughlenmom.DSC.U2,3)                          
     .  !cdir    nodep                                                          
     .           do t1009 = 1, j3                                               
     .  !cdir       nodep                                                       
     .              do t1011 = 1, xy_surfroughlenmom.DSC.U1 + 2 - min0(1,       
     .       1         xy_surfroughlenmom.DSC.U1 + 1)                           
     .                 xy_surfroughlenheat(t1011-1,t1009) = xy_surfroughlenmom( 
     .       1            t1011-1,t1009)*roughlenheatfactor                     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1009 = j3 + 1, xy_surfroughlenmom.DSC.U2, 4                
     .  !cdir       nodep                                                       
     .              do t1011 = 1, xy_surfroughlenmom.DSC.U1 + 2 - min0(1,       
     .       1         xy_surfroughlenmom.DSC.U1 + 1)                           
     .                 xy_surfroughlenheat(t1011-1,t1009) = xy_surfroughlenmom( 
     .       1            t1011-1,t1009)*roughlenheatfactor                     
     .                 xy_surfroughlenheat(t1011-1,t1009+1) = xy_surfroughlenmom
     .       1            (t1011-1,t1009+1)*roughlenheatfactor                  
     .                 xy_surfroughlenheat(t1011-1,t1009+2) = xy_surfroughlenmom
     .       1            (t1011-1,t1009+2)*roughlenheatfactor                  
     .                 xy_surfroughlenheat(t1011-1,t1009+3) = xy_surfroughlenmom
     .       1            (t1011-1,t1009+3)*roughlenheatfactor                  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10087                                                        
  1164          end if
  1165        else if ( RoughLengthSetting == 'LOContrast' ) then
  1166          ! 粗度長の設定, 陸面と海洋の差のみ考慮
  1167          ! Set roughness length, only considering land-ocean contrast
  1168          !
  1169          if ( .not. present( xy_SurfType ) ) then
  1170            call MessageNotify( 'E', module_name, &
  1171              & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
  1172          end if
  1173          if ( SurfTypeSetting /= 'file' ) then
  1174            call MessageNotify( 'E', module_name, &
  1175              & " SurfType has to be 'file', when RoughLengthSetting = %c.", &
  1176              & c1 = trim(RoughLengthSetting) )
  1177          end if
  1178          call SetRoughLenLO(    &
  1179            & xy_SurfType,       &
  1180            & xy_SurfRoughLenMom &
  1181            & )
  1182          ! set roughness length for heat
  1183          xy_SurfRoughLenHeat = xy_SurfRoughLenMom * RoughLenHeatFactor
     .        if (xy_surfroughlenmom.DSC.U2 .gt. 0) then                        
     .           j4 = and(xy_surfroughlenmom.DSC.U2,3)                          
     .  !cdir    nodep                                                          
     .           do t1001 = 1, j4                                               
     .  !cdir       nodep                                                       
     .              do t1003 = 1, xy_surfroughlenmom.DSC.U1 + 2 - min0(1,       
     .       1         xy_surfroughlenmom.DSC.U1 + 1)                           
     .                 xy_surfroughlenheat(t1003-1,t1001) = xy_surfroughlenmom( 
     .       1            t1003-1,t1001)*roughlenheatfactor                     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1001 = j4 + 1, xy_surfroughlenmom.DSC.U2, 4                
     .  !cdir       nodep                                                       
     .              do t1003 = 1, xy_surfroughlenmom.DSC.U1 + 2 - min0(1,       
     .       1         xy_surfroughlenmom.DSC.U1 + 1)                           
     .                 xy_surfroughlenheat(t1003-1,t1001) = xy_surfroughlenmom( 
     .       1            t1003-1,t1001)*roughlenheatfactor                     
     .                 xy_surfroughlenheat(t1003-1,t1001+1) = xy_surfroughlenmom
     .       1            (t1003-1,t1001+1)*roughlenheatfactor                  
     .                 xy_surfroughlenheat(t1003-1,t1001+2) = xy_surfroughlenmom
     .       1            (t1003-1,t1001+2)*roughlenheatfactor                  
     .                 xy_surfroughlenheat(t1003-1,t1001+3) = xy_surfroughlenmom
     .       1            (t1003-1,t1001+3)*roughlenheatfactor                  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10087                                                        
  1184        else if ( RoughLengthSetting == 'Matthews' ) then
  1185          ! 粗度長の設定, Matthews のデータに基づく
  1186          ! Set roughness length based on Matthews dataset
  1187          !
  1188          if ( .not. FlagSetSurfType ) then
  1189            call MessageNotify( 'E', module_name, &
  1190              & ' xy_SurfType has to be set to set xy_SurfRoughLenMom.' )
  1191          end if
  1192          if ( SurfTypeSetting /= 'file' ) then
  1193            call MessageNotify( 'E', module_name, &
  1194              & " SurfType has to be 'file', when RoughLengthSetting = %c.", &
  1195              & c1 = trim(RoughLengthSetting) )
  1196          end if
  1197          call SetRoughLenLandMatthews( &
  1198            & "Mom", xy_SurfType,       &
  1199            & xy_SurfRoughLenMom        &
  1200            & )
  1201          ! Modify albedo due to cultivation
  1202          call ModRoughLenMatthewsCultivation(   &
  1203            & "Mom", xy_SurfType, xy_SurfCulInt, &
  1204            & xy_SurfRoughLenMom                 &
  1205            & )
  1206  
  1207          ! set roughness length for heat
  1208          call SetRoughLenLandMatthews( &
  1209            & "Heat", xy_SurfType,      &
  1210            & xy_SurfRoughLenHeat       &
  1211            & )
  1212          ! Modify albedo due to cultivation
  1213          call ModRoughLenMatthewsCultivation(    &
  1214            & "Heat", xy_SurfType, xy_SurfCulInt, &
  1215            & xy_SurfRoughLenHeat                 &
  1216            & )
  1217  
  1218        else if ( RoughLengthSetting == 'generate_internally' ) then
  1219          ! データ (デフォルト値) を surface_data モジュールから取得
  1220          ! Data (default values) is input from "surface_data" module
  1221          !
  1222          if ( flag_first_SurfRoughLen ) then
  1223            call SetSurfData( &
  1224              & xy_SurfRoughLength = xy_SurfRoughLenMom &          ! (out)
  1225              & )
  1226            ! set roughness length for heat
  1227            xy_SurfRoughLenHeat = xy_SurfRoughLenMom * RoughLenHeatFactor
     .        if (xy_surfroughlenmom.DSC.U2 .gt. 0) then                        
     .           j5 = and(xy_surfroughlenmom.DSC.U2,3)                          
     .  !cdir    nodep                                                          
     .           do t993 = 1, j5                                                
     .  !cdir       nodep                                                       
     .              do t995 = 1, xy_surfroughlenmom.DSC.U1 + 2 - min0(1,        
     .       1         xy_surfroughlenmom.DSC.U1 + 1)                           
     .                 xy_surfroughlenheat(t995-1,t993) = xy_surfroughlenmom(   
     .       1            t995-1,t993)*roughlenheatfactor                       
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t993 = j5 + 1, xy_surfroughlenmom.DSC.U2, 4                 
     .  !cdir       nodep                                                       
     .              do t995 = 1, xy_surfroughlenmom.DSC.U1 + 2 - min0(1,        
     .       1         xy_surfroughlenmom.DSC.U1 + 1)                           
     .                 xy_surfroughlenheat(t995-1,t993) = xy_surfroughlenmom(   
     .       1            t995-1,t993)*roughlenheatfactor                       
     .                 xy_surfroughlenheat(t995-1,t993+1) = xy_surfroughlenmom( 
     .       1            t995-1,t993+1)*roughlenheatfactor                     
     .                 xy_surfroughlenheat(t995-1,t993+2) = xy_surfroughlenmom( 
     .       1            t995-1,t993+2)*roughlenheatfactor                     
     .                 xy_surfroughlenheat(t995-1,t993+3) = xy_surfroughlenmom( 
     .       1            t995-1,t993+3)*roughlenheatfactor                     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10087                                                        
  1228          end if
  1229        else
  1230          call MessageNotify( 'E', module_name, &
  1231            & ' RoughLengthSetting = %c is not appropriate.', &
  1232            & c1 = trim(RoughLengthSetting) )
  1233        end if
  1234  
  1235        FlagSetSurfRoughLenMom  = .true.
  1236        FlagSetSurfRoughLenHeat = .true.
  1237  
  1238        flag_first_SurfRoughLen = .false.
  1239      end if
  1240  
  1241  
  1242      ! 地表熱容量
  1243      ! Surface heat capacity
  1244      !
  1245      if ( present(xy_SurfHeatCapacity) ) then
  1246  
  1247        if ( HeatCapacitySetting == 'file' ) then
  1248          ! データをファイルから取得
  1249          ! Data is input from files
  1250          !
  1251          if ( flag_first_SurfHeatCapacity ) then
  1252            call HistoryGet( &
  1253              & HeatCapacityFile, HeatCapacityName, & ! (in)
  1254              & xy_SurfHeatCapacity, &                ! (out)
  1255              & flag_mpi_split = flag_mpi_init )      ! (in) optional
  1256          end if
  1257        else if ( HeatCapacitySetting == 'generate_internally' ) then
  1258          ! データ (デフォルト値) を surface_data モジュールから取得
  1259          ! Data (default values) is input from "surface_data" module
  1260          !
  1261          if ( flag_first_SurfHeatCapacity ) then
  1262            call SetSurfData( &
  1263              & xy_SurfHeatCapacity = xy_SurfHeatCapacity &          ! (out)
  1264              & )
  1265          end if
  1266        else
  1267          call MessageNotify( 'E', module_name, &
  1268            & ' HeatCapacitySetting = %c is not appropriate.', &
  1269            & c1 = trim(HeatCapacitySetting) )
  1270        end if
  1271  
  1272        FlagSetSurfHeatCapacity = .true.
  1273  
  1274        flag_first_SurfHeatCapacity = .false.
  1275      end if
  1276  
  1277  
  1278      ! 地中熱フラックス
  1279      ! Ground temperature flux
  1280      !
  1281      if ( present(xy_DeepSubSurfHeatFlux) ) then
  1282  
  1283        if ( TempFluxSetting == 'file' ) then
  1284          ! データをファイルから取得
  1285          ! Data is input from files
  1286          !
  1287          if ( flag_first_DeepSubSurfHeatFlux ) then
  1288            call HistoryGet( &
  1289              & TempFluxFile, TempFluxName, &     ! (in)
  1290              & xy_DeepSubSurfHeatFlux, &              ! (out)
  1291              & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1292          end if
  1293        else if ( TempFluxSetting == 'generate_internally' ) then
  1294          ! データ (デフォルト値) を surface_data モジュールから取得
  1295          ! Data (default values) is input from "surface_data" module
  1296          !
  1297          if ( flag_first_DeepSubSurfHeatFlux ) then
  1298            call SetSurfData( &
  1299              & xy_DeepSubSurfHeatFlux = xy_DeepSubSurfHeatFlux &          ! (out)
  1300              & )
  1301          end if
  1302        else
  1303          call MessageNotify( 'E', module_name, &
  1304            & ' TempFluxSetting = %c is not appropriate.', &
  1305            & c1 = trim(TempFluxSetting) )
  1306        end if
  1307  
  1308        FlagSetDeepSubSurfHeatFlux = .true.
  1309  
  1310        flag_first_DeepSubSurfHeatFlux = .false.
  1311      end if
  1312  
  1313  
  1314      ! 土壌熱容量 (J K-1 kg-1)
  1315      ! Specific heat of soil (J K-1 kg-1)
  1316      !
  1317      if ( present(xy_SoilHeatCap) ) then
  1318  
  1319        if ( SoilHeatCapSetting == 'file' ) then
  1320          ! データをファイルから取得
  1321          ! Data is input from files
  1322          !
  1323          if ( flag_first_SoilHeatCap ) then
  1324            call HistoryGet( &
  1325              & SoilHeatCapFile, SoilHeatCapName, &     ! (in)
  1326              & xy_SoilHeatCap, &              ! (out)
  1327              & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1328          end if
  1329        else if ( SoilHeatCapSetting == 'generate_internally' ) then
  1330          ! データ (デフォルト値) を surface_data モジュールから取得
  1331          ! Data (default values) is input from "surface_data" module
  1332          !
  1333          if ( flag_first_SoilHeatCap ) then
  1334            call SetSurfData( &
  1335              & xy_SoilHeatCap = xy_SoilHeatCap &          ! (out)
  1336              & )
  1337          end if
  1338        else
  1339          call MessageNotify( 'E', module_name, &
  1340            & ' SoilHeatCapSetting = %c is not appropriate.', &
  1341            & c1 = trim(SoilHeatCapSetting) )
  1342        end if
  1343  
  1344        FlagSetSoilHeatCap = .true.
  1345  
  1346        flag_first_SoilHeatCap = .false.
  1347      end if
  1348  
  1349  
  1350      ! 土壌熱伝導率 (W m-1 K-1)
  1351      ! Heat conduction coefficient of soil (W m-1 K-1)
  1352      !
  1353      if ( present(xy_SoilHeatDiffCoef) ) then
  1354  
  1355        if ( SoilHeatDiffCoefSetting == 'file' ) then
  1356          ! データをファイルから取得
  1357          ! Data is input from files
  1358          !
  1359          if ( flag_first_SoilHeatDiffCoef ) then
  1360            call HistoryGet( &
  1361              & SoilHeatDiffCoefFile, SoilHeatDiffCoefName, &     ! (in)
  1362              & xy_SoilHeatDiffCoef, &              ! (out)
  1363              & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1364          end if
  1365        else if ( SoilHeatDiffCoefSetting == 'file_thermal_inertia' ) then
  1366          ! データをファイルから取得
  1367          ! Data is input from files
  1368          !
  1369          if ( flag_first_SoilHeatDiffCoef ) then
  1370            call HistoryGet( &
  1371              & SoilHeatDiffCoefFile, SoilHeatDiffCoefName, &     ! (in)
  1372              & xy_SoilHeatDiffCoef, &              ! (out)
  1373              & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1374  
  1375            if ( present( xy_SoilHeatCap ) ) then
  1376              xy_SoilHeatDiffCoef = xy_SoilHeatDiffCoef**2 / xy_SoilHeatCap
     .        if (xy_soilheatdiffcoef.DSC.U2 .gt. 0) then                       
     .           j6 = and(xy_soilheatdiffcoef.DSC.U2,3)                         
     .  !cdir    nodep                                                          
     .           do t983 = 1, j6                                                
     .  !cdir       nodep                                                       
     .              do t985 = 1, xy_soilheatdiffcoef.DSC.U1 + 2 - min0(1,       
     .       1         xy_soilheatdiffcoef.DSC.U1 + 1)                          
     .                 xy_soilheatdiffcoef(t985-1,t983) = xy_soilheatdiffcoef(  
     .       1            t985-1,t983)**2/xy_soilheatcap(t985-1,t983)           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t983 = j6 + 1, xy_soilheatdiffcoef.DSC.U2, 4                
     .  !cdir       nodep                                                       
     .              do t985 = 1, xy_soilheatdiffcoef.DSC.U1 + 2 - min0(1,       
     .       1         xy_soilheatdiffcoef.DSC.U1 + 1)                          
     .                 xy_soilheatdiffcoef(t985-1,t983) = xy_soilheatdiffcoef(  
     .       1            t985-1,t983)**2/xy_soilheatcap(t985-1,t983)           
     .                 xy_soilheatdiffcoef(t985-1,t983+1) = xy_soilheatdiffcoef(
     .       1            t985-1,t983+1)**2/xy_soilheatcap(t985-1,t983+1)       
     .                 xy_soilheatdiffcoef(t985-1,t983+2) = xy_soilheatdiffcoef(
     .       1            t985-1,t983+2)**2/xy_soilheatcap(t985-1,t983+2)       
     .                 xy_soilheatdiffcoef(t985-1,t983+3) = xy_soilheatdiffcoef(
     .       1            t985-1,t983+3)**2/xy_soilheatcap(t985-1,t983+3)       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10034                                                        
  1377            else
  1378              call MessageNotify( 'E', module_name, &
  1379                & ' xy_SoilHeatCap has to be present to calculate heat diffusion coefficient of soil from thermal inertia.' )
  1380            end if
  1381          end if
  1382        else if ( SoilHeatDiffCoefSetting == 'generate_internally' ) then
  1383          ! データ (デフォルト値) を surface_data モジュールから取得
  1384          ! Data (default values) is input from "surface_data" module
  1385          !
  1386          if ( flag_first_SoilHeatDiffCoef ) then
  1387            call SetSurfData( &
  1388              & xy_SoilHeatDiffCoef = xy_SoilHeatDiffCoef &          ! (out)
  1389              & )
  1390          end if
  1391        else if ( SoilHeatDiffCoefSetting == 'simple' ) then
  1392          if ( .not. FlagUseBucket ) then
  1393            call MessageNotify( 'E', module_name, &
  1394              & ' FlagUseBucket has to be .true. to set soil thermal diffusion coefficient.' )
  1395          end if
  1396          if ( &
  1397            & ( FlagSetSurfType          ) .and. &
  1398            & ( present( xy_SoilMoistB ) )       &
  1399            & ) then
  1400            ! 土壌熱伝導係数の設定
  1401            ! set soil thermal diffusion coefficient
  1402            !
  1403            call SetSoilThermDiffCoefSimple( &
  1404              & xy_SurfType, xy_SoilMoistB,  & ! (in )
  1405              & xy_SoilHeatDiffCoef          & ! (out)
  1406              & )
  1407          else
  1408            call MessageNotify( 'E', module_name, &
  1409              & ' xy_SurfType and xy_SoilMoistB have to be present to set soil thermal diffusion coefficient.' )
  1410          end if
  1411        else
  1412          call MessageNotify( 'E', module_name, &
  1413            & ' SoilHeatDiffCoefSetting = %c is not appropriate.', &
  1414            & c1 = trim(TempFluxSetting) )
  1415        end if
  1416  
  1417        FlagSetSoilHeatDiffCoef = .true.
  1418  
  1419        flag_first_SoilHeatDiffCoef = .false.
  1420      end if
  1421  
  1422  
  1423      ! ヒストリデータ出力
  1424      ! History data output
  1425      !
  1426      call HistoryAutoPut( TimeN, 'SurfCulInt', xy_SurfCulInt )
  1427  
  1428  
  1429      ! 計算時間計測一時停止
  1430      ! Pause measurement of computation time
  1431      !
  1432      call TimesetClockStop( module_name )
  1433  
  1434  
  1435    end subroutine SetSurfaceProperties
  1436  
  1437    !--------------------------------------------------------------------------------------
  1438  
  1439  !!$  subroutine GroundFileOpen
  1440  !!$    !
  1441  !!$    ! 地表面データファイルをオープンします.
  1442  !!$    !
  1443  !!$    ! A ground data file is opened.
  1444  !!$    !
  1445  !!$
  1446  !!$    ! モジュール引用 ; USE statements
  1447  !!$    !
  1448  !!$
  1449  !!$    ! 出力ファイルの基本情報
  1450  !!$    ! Basic information for output files
  1451  !!$    !
  1452  !!$    use fileset, only: &
  1453  !!$      & FileTitle, &
  1454  !!$                              ! 出力データファイルの表題.
  1455  !!$                              ! Title of output data files
  1456  !!$      & FileSource, &
  1457  !!$                              ! データファイル作成の手段.
  1458  !!$                              ! Source of data file
  1459  !!$      & FileInstitution
  1460  !!$                              ! データファイルを最終的に変更した組織/個人.
  1461  !!$                              ! Institution or person that changes data files for the last time
  1462  !!$
  1463  !!$    ! 物理定数設定
  1464  !!$    ! Physical constants settings
  1465  !!$    !
  1466  !!$    use constants, only: PI   ! $ \pi $ .
  1467  !!$                              ! 円周率.  Circular constant
  1468  !!$
  1469  !!$    ! 座標データ設定
  1470  !!$    ! Axes data settings
  1471  !!$    !
  1472  !!$    use axesset, only: &
  1473  !!$      & x_Lon, &
  1474  !!$                              ! $ \lambda $ [rad.] . 経度. Longitude
  1475  !!$      & x_Lon_Weight, &
  1476  !!$                              ! $ \Delta \lambda $ [rad.] .
  1477  !!$                              ! 経度座標重み.
  1478  !!$                              ! Weight of longitude
  1479  !!$      & y_Lat, &
  1480  !!$                              ! $ \varphi $ [rad.] . 緯度. Latitude
  1481  !!$      & y_Lat_Weight, &
  1482  !!$                              ! $ \Delta \varphi $ [rad.] .
  1483  !!$                              ! 緯度座標重み.
  1484  !!$                              ! Weight of latitude
  1485  !!$      & z_Sigma, &
  1486  !!$                              ! $ \sigma $ レベル (整数).
  1487  !!$                              ! Full $ \sigma $ level
  1488  !!$      & r_Sigma, &
  1489  !!$                              ! $ \sigma $ レベル (半整数).
  1490  !!$                              ! Half $ \sigma $ level
  1491  !!$      & z_DelSigma
  1492  !!$                              ! $ \Delta \sigma $ (整数).
  1493  !!$                              ! $ \Delta \sigma $ (Full)
  1494  !!$
  1495  !!$    ! 時刻管理
  1496  !!$    ! Time control
  1497  !!$    !
  1498  !!$    use timeset, only: &
  1499  !!$      & DelTime, &            ! $ \Delta t $ [s]
  1500  !!$      & StartTime, &          ! 計算開始時刻.
  1501  !!$                              ! Start time of calculation
  1502  !!$      & StartDate, &          ! 計算開始日時.
  1503  !!$                              ! Start date of calculation
  1504  !!$      & StartDateValid        ! 計算開始日時の有効性.
  1505  !!$                              ! Validation of start date of calculation
  1506  !!$
  1507  !!$    ! gtool4 データ出力
  1508  !!$    ! Gtool4 data output
  1509  !!$    !
  1510  !!$    use gtool_history, only: HistoryCreate, HistoryAddVariable, &
  1511  !!$      & HistoryPut, HistoryAddAttr
  1512  !!$
  1513  !!$    ! 文字列操作
  1514  !!$    ! Character handling
  1515  !!$    !
  1516  !!$    use dc_string, only: StoA
  1517  !!$
  1518  !!$    ! 日付および時刻の取り扱い
  1519  !!$    ! Date and time handler
  1520  !!$    !
  1521  !!$    use dc_date, only: toChar, EvalByUnit
  1522  !!$
  1523  !!$    ! 宣言文 ; Declaration statements
  1524  !!$    !
  1525  !!$    implicit none
  1526  !!$
  1527  !!$    ! 作業変数
  1528  !!$    ! Work variables
  1529  !!$    !
  1530  !!$    real(DP):: origin_time
  1531  !!$                              ! 計算開始時刻.
  1532  !!$                              ! Start time of calculation
  1533  !!$
  1534  !!$    ! 実行文 ; Executable statement
  1535  !!$    !
  1536  !!$
  1537  !!$    ! 初期化
  1538  !!$    ! Initialization
  1539  !!$    !
  1540  !!$    if ( .not. ground_file_io_inited ) call GroundFileInit
  1541  !!$    if ( ground_file_opened ) return
  1542  !!$
  1543  !!$    ! 時刻情報の取得
  1544  !!$    ! Get time information
  1545  !!$    !
  1546  !!$    origin_time = EvalByUnit( StartTime, IntUnit )
  1547  !!$
  1548  !!$    ! 地表面データファイルのオープン
  1549  !!$    ! Open a ground data file
  1550  !!$    !
  1551  !!$    call HistoryCreate( &
  1552  !!$      &      file = OutputFile,   &
  1553  !!$      &     title = trim(FileTitle) // ' ground data', &          ! (in)
  1554  !!$      &    source = FileSource, institution = FileInstitution, &   ! (in)
  1555  !!$      &      dims = StoA( 'lon', 'lat', 'sig', 'sigm', 'time' ), & ! (in)
  1556  !!$      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 0 /), &         ! (in)
  1557  !!$      & longnames = StoA( 'longitude', 'latitude', &
  1558  !!$      &                   'sigma at layer midpoints', &
  1559  !!$      &                   'sigma at layer end-points (half level)', &
  1560  !!$      &                   'time' ), &                              ! (in)
  1561  !!$      &     units = StoA( 'degree_east', 'degree_north', &
  1562  !!$      &                   '1', '1', IntUnit ), &                   ! (in)
  1563  !!$      &    origin = real( origin_time ), &                         ! (in)
  1564  !!$      &  interval = real( IntValue ), &                            ! (in)
  1565  !!$      &   history = gthst_grd )                                    ! (out)
  1566  !!$
  1567  !!$    ! $ \Delta t $ に関する情報を追加
  1568  !!$    ! Add information about $ \Delta t $
  1569  !!$    !
  1570  !!$    call HistoryAddVariable( &
  1571  !!$      & varname = 'deltime', &            ! (in)
  1572  !!$      & dims = StoA(''), &                ! (in)
  1573  !!$      & longname = 'delta time', &        ! (in)
  1574  !!$      & units = 's', xtype = 'float', &   ! (in)
  1575  !!$      & history = gthst_grd )             ! (inout)
  1576  !!$    call HistoryPut( &
  1577  !!$      & varname = 'deltime', &            ! (in)
  1578  !!$      & array = (/ DelTime /), &          ! (in)
  1579  !!$      & history = gthst_grd )             ! (inout)
  1580  !!$
  1581  !!$    ! 座標データの設定
  1582  !!$    ! Axes data settings
  1583  !!$    !
  1584  !!$    call HistoryAddAttr( &
  1585  !!$      & varname = 'lon', attrname = 'standard_name', &   ! (in)
  1586  !!$      & value = 'longitude', &                           ! (in)
  1587  !!$      & history = gthst_grd )                            ! (inout)
  1588  !!$    call HistoryAddAttr( &
  1589  !!$      & varname = 'lat', attrname = 'standard_name', &   ! (in)
  1590  !!$      & value = 'latitude', &                            ! (in)
  1591  !!$      & history = gthst_grd )                            ! (inout)
  1592  !!$    call HistoryAddAttr( &
  1593  !!$      & varname = 'sig', attrname = 'standard_name', &   ! (in)
  1594  !!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
  1595  !!$      & history = gthst_grd )                            ! (inout)
  1596  !!$    call HistoryAddAttr( &
  1597  !!$      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
  1598  !!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
  1599  !!$      & history = gthst_grd )                            ! (inout)
  1600  !!$    call HistoryAddAttr( &
  1601  !!$      & varname = 'time', attrname = 'standard_name', &  ! (in)
  1602  !!$      & value = 'time', &                                ! (in)
  1603  !!$      & history = gthst_grd )                            ! (inout)
  1604  !!$    call HistoryAddAttr( &
  1605  !!$      & varname = 'sig', attrname = 'positive', &        ! (in)
  1606  !!$      & value = 'down', &                                ! (in)
  1607  !!$      & history = gthst_grd )                            ! (inout)
  1608  !!$    call HistoryAddAttr( &
  1609  !!$      & varname = 'sigm', attrname = 'positive', &       ! (in)
  1610  !!$      & value = 'down', &                                ! (in)
  1611  !!$      & history = gthst_grd )                            ! (inout)
  1612  !!$
  1613  !!$    call HistoryPut( &
  1614  !!$      & varname = 'lon', &               ! (in)
  1615  !!$      & array = x_Lon / PI * 180.0_DP, & ! (in)
  1616  !!$      & history = gthst_grd )            ! (inout)
  1617  !!$    call HistoryPut( &
  1618  !!$      & varname = 'lat', &               ! (in)
  1619  !!$      & array = y_Lat / PI * 180.0_DP, & ! (in)
  1620  !!$      & history = gthst_grd )            ! (inout)
  1621  !!$    call HistoryPut( &
  1622  !!$      & varname = 'sig', &               ! (in)
  1623  !!$      & array = z_Sigma, &               ! (in)
  1624  !!$      & history = gthst_grd )            ! (inout)
  1625  !!$    call HistoryPut( &
  1626  !!$      & varname = 'sigm', &              ! (in)
  1627  !!$      & array = r_Sigma, &               ! (in)
  1628  !!$      & history = gthst_grd )            ! (inout)
  1629  !!$
  1630  !!$    ! 座標重みの設定
  1631  !!$    ! Axes weights settings
  1632  !!$    !
  1633  !!$    call HistoryAddVariable( &
  1634  !!$      & varname = 'lon_weight', &                           ! (in)
  1635  !!$      & dims = StoA('lon'), &                               ! (in)
  1636  !!$      & longname = 'weight for integration in longitude', & ! (in)
  1637  !!$      & units = 'radian', xtype = 'double', &               ! (in)
  1638  !!$      & history = gthst_grd )                               ! (inout)
  1639  !!$    call HistoryAddAttr( &
  1640  !!$      & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
  1641  !!$      & value = 'lon_weight', &                             ! (in)
  1642  !!$      & history = gthst_grd )                               ! (inout)
  1643  !!$    call HistoryPut( &
  1644  !!$      & varname = 'lon_weight', array = x_Lon_Weight, &     ! (in)
  1645  !!$      & history = gthst_grd )                               ! (inout)
  1646  !!$
  1647  !!$    call HistoryAddVariable( &
  1648  !!$      & varname = 'lat_weight', &                           ! (in)
  1649  !!$      & dims = StoA('lat'), &                               ! (in)
  1650  !!$      & longname = 'weight for integration in latitude', &  ! (in)
  1651  !!$      & units = 'radian', xtype = 'double', &               ! (in)
  1652  !!$      & history = gthst_grd )                               ! (inout)
  1653  !!$    call HistoryAddAttr( &
  1654  !!$      & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
  1655  !!$      & value = 'lat_weight', &                             ! (in)
  1656  !!$      & history = gthst_grd )                               ! (inout)
  1657  !!$    call HistoryPut( &
  1658  !!$      & varname = 'lat_weight', array = y_Lat_Weight, &     ! (in)
  1659  !!$      & history = gthst_grd )                               ! (inout)
  1660  !!$
  1661  !!$    call HistoryAddVariable( &
  1662  !!$      & varname = 'sig_weight', &                           ! (in)
  1663  !!$      & dims = StoA('sig'), &                               ! (in)
  1664  !!$      & longname = 'weight for integration in sigma', &     ! (in)
  1665  !!$      & units = '1', xtype = 'double', &                    ! (in)
  1666  !!$      & history = gthst_grd )                               ! (inout)
  1667  !!$    call HistoryAddAttr( &
  1668  !!$      & varname = 'sig', attrname = 'gt_calc_weight', &     ! (in)
  1669  !!$      & value = 'sig_weight', &                             ! (in)
  1670  !!$      & history = gthst_grd )                               ! (inout)
  1671  !!$    call HistoryPut( &
  1672  !!$      & varname = 'sig_weight', array = z_DelSigma, &       ! (in)
  1673  !!$      & history = gthst_grd )                               ! (inout)
  1674  !!$
  1675  !!$    ! 予報変数の設定
  1676  !!$    ! Predictional variables settings
  1677  !!$    !
  1678  !!$    call HistoryAddVariable( &
  1679  !!$      & varname = 'UB', &                                   ! (in)
  1680  !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1681  !!$      & longname = 'eastward wind (at t-\Delta t)', &       ! (in)
  1682  !!$      & units = 'm s-1', xtype = 'double', &                ! (in)
  1683  !!$      & history = gthst_grd )                               ! (inout)
  1684  !!$    call HistoryAddVariable( &
  1685  !!$      & varname = 'VB', &                                   ! (in)
  1686  !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1687  !!$      & longname = 'northward wind (at t-\Delta t)', &      ! (in)
  1688  !!$      & units = 'm s-1', xtype = 'double', &                ! (in)
  1689  !!$      & history = gthst_grd )                               ! (inout)
  1690  !!$    call HistoryAddVariable( &
  1691  !!$      & varname = 'TempB', &                                ! (in)
  1692  !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1693  !!$      & longname = 'temperature (at t-\Delta t)', &         ! (in)
  1694  !!$      & units = 'K', xtype = 'double', &                    ! (in)
  1695  !!$      & history = gthst_grd )                               ! (inout)
  1696  !!$    call HistoryAddVariable( &
  1697  !!$      & varname = 'QVapB', &                                ! (in)
  1698  !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1699  !!$      & longname = 'specific humidity (at t-\Delta t)', &   ! (in)
  1700  !!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
  1701  !!$      & history = gthst_grd )                               ! (inout)
  1702  !!$    call HistoryAddVariable( &
  1703  !!$      & varname = 'PsB', &                                  ! (in)
  1704  !!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
  1705  !!$      & longname = 'surface pressure (at t-\Delta t)', &    ! (in)
  1706  !!$      & units = 'Pa', xtype = 'double', &                   ! (in)
  1707  !!$      & history = gthst_grd )                               ! (inout)
  1708  !!$
  1709  !!$    call HistoryAddVariable( &
  1710  !!$      & varname = 'UN', &                                   ! (in)
  1711  !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1712  !!$      & longname = 'eastward wind (at t)', &                ! (in)
  1713  !!$      & units = 'm s-1', xtype = 'double', &                ! (in)
  1714  !!$      & history = gthst_grd )                               ! (inout)
  1715  !!$    call HistoryAddVariable( &
  1716  !!$      & varname = 'VN', &                                   ! (in)
  1717  !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1718  !!$      & longname = 'northward wind (at t)', &               ! (in)
  1719  !!$      & units = 'm s-1', xtype = 'double', &                ! (in)
  1720  !!$      & history = gthst_grd )                               ! (inout)
  1721  !!$    call HistoryAddVariable( &
  1722  !!$      & varname = 'TempN', &                                ! (in)
  1723  !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1724  !!$      & longname = 'temperature (at t)', &                  ! (in)
  1725  !!$      & units = 'K', xtype = 'double', &                    ! (in)
  1726  !!$      & history = gthst_grd )                               ! (inout)
  1727  !!$    call HistoryAddVariable( &
  1728  !!$      & varname = 'QVapN', &                                ! (in)
  1729  !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1730  !!$      & longname = 'specific humidity (at t)', &            ! (in)
  1731  !!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
  1732  !!$      & history = gthst_grd )                               ! (inout)
  1733  !!$    call HistoryAddVariable( &
  1734  !!$      & varname = 'PsN', &                                  ! (in)
  1735  !!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
  1736  !!$      & longname = 'surface pressure (at t)', &             ! (in)
  1737  !!$      & units = 'Pa', xtype = 'double', &                   ! (in)
  1738  !!$      & history = gthst_grd )                               ! (inout)
  1739  !!$
  1740  !!$    ground_file_opened = .true.
  1741  !!$  end subroutine GroundFileOpen
  1742  !!$
  1743  !!$  !-------------------------------------------------------------------
  1744  !!$
  1745  !!$  subroutine GroundFileOutput( &
  1746  !!$    & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
  1747  !!$    & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  &   ! (in)
  1748  !!$    & )
  1749  !!$    !
  1750  !!$    ! 地表面データの出力を行います.
  1751  !!$    !
  1752  !!$    ! Output ground data
  1753  !!$
  1754  !!$    ! モジュール引用 ; USE statements
  1755  !!$    !
  1756  !!$
  1757  !!$    ! gtool4 データ出力
  1758  !!$    ! Gtool4 data output
  1759  !!$    !
  1760  !!$    use gtool_history, only: HistoryPut
  1761  !!$
  1762  !!$    ! 時刻管理
  1763  !!$    ! Time control
  1764  !!$    !
  1765  !!$    use timeset, only: TimeN  ! ステップ $ t $ の時刻.
  1766  !!$                              ! Time of step $ t $.
  1767  !!$
  1768  !!$    ! 宣言文 ; Declaration statements
  1769  !!$    !
  1770  !!$    implicit none
  1771  !!$    real(DP), intent(in):: xyz_UB  (0:imax-1, 1:jmax, 1:kmax)
  1772  !!$                              ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
  1773  !!$    real(DP), intent(in):: xyz_VB  (0:imax-1, 1:jmax, 1:kmax)
  1774  !!$                              ! $ v (t-\Delta t) $ .   南北風速. Northward wind
  1775  !!$    real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
  1776  !!$                              ! $ T (t-\Delta t) $ .   温度. Temperature
  1777  !!$    real(DP), intent(in):: xyz_QVapB  (0:imax-1, 1:jmax, 1:kmax)
  1778  !!$                              ! $ q (t-\Delta t) $ .   比湿. Specific humidity
  1779  !!$    real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
  1780  !!$                              ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
  1781  !!$    real(DP), intent(in):: xyz_UN  (0:imax-1, 1:jmax, 1:kmax)
  1782  !!$                              ! $ u (t) $ .     東西風速. Eastward wind
  1783  !!$    real(DP), intent(in):: xyz_VN  (0:imax-1, 1:jmax, 1:kmax)
  1784  !!$                              ! $ v (t) $ .     南北風速. Northward wind
  1785  !!$    real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
  1786  !!$                              ! $ T (t) $ .     温度. Temperature
  1787  !!$    real(DP), intent(in):: xyz_QVapN  (0:imax-1, 1:jmax, 1:kmax)
  1788  !!$                              ! $ q (t) $ .     比湿. Specific humidity
  1789  !!$    real(DP), intent(in):: xy_PsN (0:imax-1, 1:jmax)
  1790  !!$                              ! $ p_s (t) $ .   地表面気圧. Surface pressure
  1791  !!$
  1792  !!$    ! 作業変数
  1793  !!$    ! Work variables
  1794  !!$    !
  1795  !!$
  1796  !!$
  1797  !!$    ! 実行文 ; Executable statement
  1798  !!$    !
  1799  !!$
  1800  !!$    if ( .not. ground_file_opened ) call GroundFileOpen
  1801  !!$
  1802  !!$    ! 出力タイミングのチェック
  1803  !!$    ! Check output timing
  1804  !!$    !
  1805  !!$    if ( TimeN - PrevOutputTime < IntTime ) return
  1806  !!$    PrevOutputTime = TimeN
  1807  !!$
  1808  !!$    ! データ出力
  1809  !!$    ! Data output
  1810  !!$    !
  1811  !!$    call HistoryPut( &
  1812  !!$      & 'UB', xyz_UB, history = gthst_grd ) ! (in)
  1813  !!$    call HistoryPut( &
  1814  !!$      & 'VB', xyz_VB, history = gthst_grd ) ! (in)
  1815  !!$    call HistoryPut( &
  1816  !!$      & 'TempB', xyz_TempB, history = gthst_grd ) ! (in)
  1817  !!$    call HistoryPut( &
  1818  !!$      & 'QVapB', xyz_QVapB, history = gthst_grd ) ! (in)
  1819  !!$    call HistoryPut( &
  1820  !!$      & 'PsB', xy_PsB, history = gthst_grd ) ! (in)
  1821  !!$
  1822  !!$    call HistoryPut( &
  1823  !!$      & 'UN', xyz_UN, history = gthst_grd ) ! (in)
  1824  !!$    call HistoryPut( &
  1825  !!$      & 'VN', xyz_VN, history = gthst_grd ) ! (in)
  1826  !!$    call HistoryPut( &
  1827  !!$      & 'TempN', xyz_TempN, history = gthst_grd ) ! (in)
  1828  !!$    call HistoryPut( &
  1829  !!$      & 'QVapN', xyz_QVapN, history = gthst_grd ) ! (in)
  1830  !!$    call HistoryPut( &
  1831  !!$      & 'PsN', xy_PsN, history = gthst_grd ) ! (in)
  1832  !!$
  1833  !!$  end subroutine GroundFileOutput
  1834  !!$
  1835  !!$  !-------------------------------------------------------------------
  1836  !!$
  1837  !!$  subroutine GroundFileClose
  1838  !!$    !
  1839  !!$    ! 地表面データファイル出力の終了処理を行います.
  1840  !!$    !
  1841  !!$    ! Terminate ground data files output.
  1842  !!$
  1843  !!$    ! モジュール引用 ; USE statements
  1844  !!$    !
  1845  !!$
  1846  !!$    ! gtool4 データ出力
  1847  !!$    ! Gtool4 data output
  1848  !!$    !
  1849  !!$    use gtool_history, only: HistoryClose
  1850  !!$
  1851  !!$    ! 宣言文 ; Declaration statements
  1852  !!$    !
  1853  !!$    implicit none
  1854  !!$
  1855  !!$    ! 作業変数
  1856  !!$    ! Work variables
  1857  !!$    !
  1858  !!$
  1859  !!$    ! 実行文 ; Executable statement
  1860  !!$    !
  1861  !!$    if ( .not. ground_file_opened ) return
  1862  !!$
  1863  !!$    call HistoryClose( history = gthst_grd ) ! (inout)
  1864  !!$
  1865  !!$    ground_file_opened = .false.
  1866  !!$  end subroutine GroundFileClose
  1867  
  1868    !--------------------------------------------------------------------------------------
  1869  
  1870    subroutine SurfacePropertiesInit(                     &
  1871      & ArgFlagSlabOcean, ArgFlagUseBucket, ArgFlagSnow   & ! (in)
  1872      & )
  1873      !
  1874      ! surface_properties モジュールの初期化を行います.
  1875      ! NAMELIST#surface_properties_nml の読み込みはこの手続きで行われます.
  1876      !
  1877      ! "surface_properties" module is initialized.
  1878      ! "NAMELIST#surface_properties_nml" is loaded in this procedure.
  1879      !
  1880  
  1881      ! モジュール引用 ; USE statements
  1882      !
  1883  
  1884      ! 種別型パラメタ
  1885      ! Kind type parameter
  1886      !
  1887      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1888  
  1889      ! ファイル入出力補助
  1890      ! File I/O support
  1891      !
  1892      use dc_iounit, only: FileOpen
  1893  
  1894      ! ヒストリデータ出力
  1895      ! History data output
  1896      !
  1897      use gtool_historyauto, only: HistoryAutoAddVariable
  1898  
  1899      ! NAMELIST ファイル入力に関するユーティリティ
  1900      ! Utilities for NAMELIST file input
  1901      !
  1902      use namelist_util, only: namelist_filename, NmlutilMsg
  1903  
  1904      ! 時刻管理
  1905      ! Time control
  1906      !
  1907      use timeset, only: DelTime  ! $ \Delta t $ [s]
  1908  
  1909      !
  1910      ! Routines for GABLS tests
  1911      !
  1912      use gabls, only : GablsInit
  1913  
  1914      ! Matthews のデータに基づく惑星表面アルベド設定
  1915      ! set surface albedo based on data by Matthews
  1916      !
  1917      use albedo_Matthews, only : AlbedoMatthewsInit
  1918  
  1919      ! バケツモデル
  1920      ! Bucket model
  1921      !
  1922      use Bucket_Model, only : BucketModelInit
  1923  
  1924      ! 雪と海氷によるアルベド変化
  1925      ! modification of surface albedo on the snow covered ground and on the sea ice
  1926      !
  1927      use modify_albedo_snowseaice, only : ModAlbedoSnowSeaIceInit
  1928  
  1929      ! アルベド, 粗度長の設定, 陸面と海洋の差のみ考慮
  1930      ! Set albedo and roughness length, only considering land-ocean contrast
  1931      !
  1932      use surface_properties_lo, only : SurfacePropertiesLOInit
  1933  
  1934      ! Matthews のデータに基づく地面粗度の設定
  1935      ! set roughness length on land surface based on data by Matthews
  1936      !
  1937      use roughlen_Matthews, only : RoughLenMatthewsInit
  1938  
  1939      ! 土壌熱伝導係数の設定
  1940      ! set soil thermal diffusion coefficient
  1941      !
  1942      use soil_thermdiffcoef, only : SoilThermDiffCoefInit
  1943  
  1944  
  1945      ! 宣言文 ; Declaration statements
  1946      !
  1947      logical, intent(in ) :: ArgFlagSlabOcean
  1948                                ! スラブオーシャン オン／オフ.
  1949                                ! flag for use of slab ocean on/off
  1950      logical, intent(in ) :: ArgFlagUseBucket
  1951                                !
  1952                                ! flag for bucket model
  1953      logical, intent(in ) :: ArgFlagSnow
  1954                                !
  1955                                ! flag for snow
  1956  
  1957      ! 作業変数
  1958      ! Work variables
  1959      !
  1960      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1961                                ! Unit number for NAMELIST file open
  1962      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1963                                ! IOSTAT of NAMELIST read
  1964  
  1965      ! NAMELIST 変数群
  1966      ! NAMELIST group name
  1967      !
  1968      namelist /surface_properties_nml/ &
  1969        & SurfTempSetting,     &
  1970        & SurfTempFile,        &
  1971        & SurfTempName,        &
  1972        & SeaIceSetting,       &
  1973        & SeaIceFile,          &
  1974        & SeaIceName,          &
  1975        & AlbedoSetting,       &
  1976        & AlbedoFile,          &
  1977        & AlbedoName,          &
  1978        & HumidCoefSetting,    &
  1979        & HumidCoefFile,       &
  1980        & HumidCoefName,       &
  1981        & RoughLengthSetting,  &
  1982        & RoughLengthFile,     &
  1983        & RoughLengthName,     &
  1984        & HeatCapacitySetting, &
  1985        & HeatCapacityFile,    &
  1986        & HeatCapacityName,    &
  1987        & TempFluxSetting,     &
  1988        & TempFluxFile,        &
  1989        & TempFluxName,        &
  1990        & SurfCondSetting,     &
  1991        & SurfCondFile,        &
  1992        & SurfCondName,        &
  1993        & SurfTypeSetting,     &
  1994        & SurfTypeFile,        &
  1995        & SurfTypeName,        &
  1996        & SurfCulIntSetting,   &
  1997        & SurfCulIntFile,      &
  1998        & SurfCulIntName,      &
  1999        & SurfHeightSetting,   &
  2000        & SurfHeightFile,      &
  2001        & SurfHeightName,      &
  2002        & SurfHeightStdSetting,&
  2003        & SurfHeightStdFile,   &
  2004        & SurfHeightStdName,   &
  2005        & SoilHeatCapSetting,  &
  2006        & SoilHeatCapFile,     &
  2007        & SoilHeatCapName,     &
  2008        & SoilHeatDiffCoefSetting, &
  2009        & SoilHeatDiffCoefFile,    &
  2010        & SoilHeatDiffCoefName,    &
  2011        & RoughLenHeatFactor
  2012  
  2013            ! デフォルト値については初期化手続 "surface_properties#SurfacePropertiesInit"
  2014            ! のソースコードを参照のこと.
  2015            !
  2016            ! Refer to source codes in the initialization procedure
  2017            ! "surface_properties#SurfacePropertiesInit" for the default values.
  2018            !
  2019  
  2020  !!$      & OutputFile, &
  2021  !!$      & IntValue, IntUnit
  2022  
  2023  
  2024      ! 実行文 ; Executable statement
  2025      !
  2026  
  2027      if ( surface_properties_inited ) return
  2028  
  2029  
  2030      ! Set flag for slab ocean
  2031      FlagUseBucket = ArgFlagUseBucket
  2032  
  2033      FlagSlabOcean = ArgFlagSlabOcean
  2034  
  2035  
  2036      ! デフォルト値の設定
  2037      ! Default values settings
  2038      !
  2039      SurfTempSetting         = 'generate_internally'
  2040      SurfTempFile            = ''
  2041      SurfTempName            = ''
  2042      SeaIceSetting           = 'generate_internally'
  2043      SeaIceFile              = ''
  2044      SeaIceName              = ''
  2045      AlbedoSetting           = 'generate_internally'
  2046      AlbedoFile              = ''
  2047      AlbedoName              = ''
  2048      HumidCoefSetting        = 'generate_internally'
  2049      HumidCoefFile           = ''
  2050      HumidCoefName           = ''
  2051      RoughLengthSetting      = 'generate_internally'
  2052      RoughLengthFile         = ''
  2053      RoughLengthName         = ''
  2054      HeatCapacitySetting     = 'generate_internally'
  2055      HeatCapacityFile        = ''
  2056      HeatCapacityName        = ''
  2057      TempFluxSetting         = 'generate_internally'
  2058      TempFluxFile            = ''
  2059      TempFluxName            = ''
  2060      SurfCondSetting         = 'generate_internally'
  2061      SurfCondFile            = ''
  2062      SurfCondName            = ''
  2063      SurfTypeSetting         = 'generate_internally'
  2064      SurfTypeFile            = ''
  2065      SurfTypeName            = ''
  2066      SurfCulIntSetting       = 'generate_internally'
  2067      SurfCulIntFile          = ''
  2068      SurfCulIntName          = ''
  2069      SurfHeightSetting       = 'generate_internally'
  2070      SurfHeightFile          = ''
  2071      SurfHeightName          = ''
  2072      SurfHeightStdSetting    = 'generate_internally'
  2073      SurfHeightStdFile       = ''
  2074      SurfHeightStdName       = ''
  2075      SoilHeatCapSetting      = 'generate_internally'
  2076      SoilHeatCapFile         = ''
  2077      SoilHeatCapName         = ''
  2078      SoilHeatDiffCoefSetting = 'generate_internally'
  2079      SoilHeatDiffCoefFile    = ''
  2080      SoilHeatDiffCoefName    = ''
  2081  
  2082      RoughLenHeatFactor = 1.0_DP
  2083  
  2084  !!$    OutputFile = 'sst.nc'
  2085  !!$    IntValue   = 1.0_DP
  2086  !!$    IntUnit    = 'day'
  2087  
  2088      ! NAMELIST の読み込み
  2089      ! NAMELIST is input
  2090      !
  2091      if ( trim(namelist_filename) /= '' ) then
  2092        call FileOpen( unit_nml, &          ! (out)
  2093          & namelist_filename, mode = 'r' ) ! (in)
  2094  
  2095        rewind( unit_nml )
  2096        read( unit_nml,                   &  ! (in)
  2097          & nml = surface_properties_nml, &  ! (out)
  2098          & iostat = iostat_nml           &  ! (out)
  2099          & )
  2100        close( unit_nml )
  2101  
  2102        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2103        if ( iostat_nml == 0 ) write( STDOUT, nml = surface_properties_nml )
  2104      end if
  2105  
  2106  !!$    ! 出力時間間隔の設定
  2107  !!$    ! Configure time interval of output
  2108  !!$    !
  2109  !!$    call DCDiffTimeCreate( PrevOutputTime, & ! (out)
  2110  !!$      & sec = 0.0_DP )                       ! (in)
  2111  !!$    call DCDiffTimeCreate( IntTime, & ! (out)
  2112  !!$      & IntValue, IntUnit )           ! (in)
  2113  
  2114  
  2115      ! A Value of "SurfTempSetting" is checked.
  2116      !
  2117      if ( ( SurfTempSetting == 'file' ) .and. ( FlagSlabOcean ) ) then
  2118        call MessageNotify( 'E', module_name, &
  2119          & "If FlagSlabOcean is .true., SurfTempSetting must not be 'file'." )
  2120      end if
  2121  
  2122  
  2123      ! Initialization of modules used in this module
  2124      !
  2125  
  2126      ! Matthews のデータに基づく惑星表面アルベド設定
  2127      ! set surface albedo based on data by Matthews
  2128      !
  2129      call AlbedoMatthewsInit
  2130  
  2131      if ( FlagUseBucket ) then
  2132        ! バケツモデル
  2133        ! Bucket model
  2134        !
  2135        call BucketModelInit( &
  2136          & ArgFlagSnow       &
  2137          & )
  2138      end if
  2139  
  2140      !
  2141      ! Routines for GABLS tests
  2142      !
  2143      call GablsInit
  2144  
  2145      ! 雪と海氷によるアルベド変化
  2146      ! modification of surface albedo on the snow covered ground and on the sea ice
  2147      !
  2148      call ModAlbedoSnowSeaIceInit
  2149  
  2150      ! アルベド, 粗度長の設定, 陸面と海洋の差のみ考慮
  2151      ! Set albedo and roughness length, only considering land-ocean contrast
  2152      !
  2153      call SurfacePropertiesLOInit
  2154  
  2155      ! Matthews のデータに基づく地面粗度の設定
  2156      ! set roughness length on land surface based on data by Matthews
  2157      !
  2158      call RoughLenMatthewsInit
  2159  
  2160      ! 土壌熱伝導係数の設定
  2161      ! set soil thermal diffusion coefficient
  2162      !
  2163      call SoilThermDiffCoefInit( &
  2164        & ArgFlagSnow &
  2165        & )
  2166  
  2167  
  2168      ! ヒストリデータ出力のためのへの変数登録
  2169      ! Register of variables for history data output
  2170      !
  2171      call HistoryAutoAddVariable( 'SurfCulInt' , &  ! (in)
  2172        & (/ 'lon ', 'lat ', 'time' /),           &  ! (in)
  2173        & 'cultivation intensity', '1' )             ! (in)
  2174  
  2175  
  2176      ! 印字 ; Print
  2177      !
  2178      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2179      call MessageNotify( 'M', module_name, 'Input:: ' )
  2180      call MessageNotify( 'M', module_name, '  SurfTempSetting         = %c', c1 = trim(SurfTempSetting) )
  2181      call MessageNotify( 'M', module_name, '  SurfTempFile            = %c', c1 = trim(SurfTempFile) )
  2182      call MessageNotify( 'M', module_name, '  SurfTempName            = %c', c1 = trim(SurfTempName        ) )
  2183      call MessageNotify( 'M', module_name, '  SeaIceSetting           = %c', c1 = trim(SeaIceSetting) )
  2184      call MessageNotify( 'M', module_name, '  SeaIceFile              = %c', c1 = trim(SeaIceFile) )
  2185      call MessageNotify( 'M', module_name, '  SeaIceName              = %c', c1 = trim(SeaIceName        ) )
  2186      call MessageNotify( 'M', module_name, '  AlbedoSetting           = %c', c1 = trim(AlbedoSetting      ) )
  2187      call MessageNotify( 'M', module_name, '  AlbedoFile              = %c', c1 = trim(AlbedoFile      ) )
  2188      call MessageNotify( 'M', module_name, '  AlbedoName              = %c', c1 = trim(AlbedoName      ) )
  2189      call MessageNotify( 'M', module_name, '  HumidCoefSetting        = %c', c1 = trim(HumidCoefSetting ) )
  2190      call MessageNotify( 'M', module_name, '  HumidCoefFile           = %c', c1 = trim(HumidCoefFile  ) )
  2191      call MessageNotify( 'M', module_name, '  HumidCoefName           = %c', c1 = trim(HumidCoefName  ) )
  2192      call MessageNotify( 'M', module_name, '  RoughLengthSetting      = %c', c1 = trim(RoughLengthSetting ) )
  2193      call MessageNotify( 'M', module_name, '  RoughLengthFile         = %c', c1 = trim(RoughLengthFile ) )
  2194      call MessageNotify( 'M', module_name, '  RoughLengthName         = %c', c1 = trim(RoughLengthName ) )
  2195      call MessageNotify( 'M', module_name, '  HeatCapacitySetting     = %c', c1 = trim(HeatCapacitySetting) )
  2196      call MessageNotify( 'M', module_name, '  HeatCapacityFile        = %c', c1 = trim(HeatCapacityFile) )
  2197      call MessageNotify( 'M', module_name, '  HeatCapacityName        = %c', c1 = trim(HeatCapacityName) )
  2198      call MessageNotify( 'M', module_name, '  TempFluxSetting         = %c', c1 = trim(TempFluxSetting  ) )
  2199      call MessageNotify( 'M', module_name, '  TempFluxFile            = %c', c1 = trim(TempFluxFile  ) )
  2200      call MessageNotify( 'M', module_name, '  TempFluxName            = %c', c1 = trim(TempFluxName  ) )
  2201      call MessageNotify( 'M', module_name, '  SurfCondSetting         = %c', c1 = trim(SurfCondSetting   ) )
  2202      call MessageNotify( 'M', module_name, '  SurfCondFile            = %c', c1 = trim(SurfCondFile   ) )
  2203      call MessageNotify( 'M', module_name, '  SurfCondName            = %c', c1 = trim(SurfCondName   ) )
  2204      call MessageNotify( 'M', module_name, '  SurfTypeSetting         = %c', c1 = trim(SurfTypeSetting   ) )
  2205      call MessageNotify( 'M', module_name, '  SurfTypeFile            = %c', c1 = trim(SurfTypeFile   ) )
  2206      call MessageNotify( 'M', module_name, '  SurfTypeName            = %c', c1 = trim(SurfTypeName   ) )
  2207      call MessageNotify( 'M', module_name, '  SurfCulIntSetting       = %c', c1 = trim(SurfCulIntSetting   ) )
  2208      call MessageNotify( 'M', module_name, '  SurfCulIntFile          = %c', c1 = trim(SurfCulIntFile   ) )
  2209      call MessageNotify( 'M', module_name, '  SurfCulIntName          = %c', c1 = trim(SurfCulIntName   ) )
  2210      call MessageNotify( 'M', module_name, '  SurfHeightSetting       = %c', c1 = trim(SurfHeightSetting   ) )
  2211      call MessageNotify( 'M', module_name, '  SurfHeightFile          = %c', c1 = trim(SurfHeightFile   ) )
  2212      call MessageNotify( 'M', module_name, '  SurfHeightName          = %c', c1 = trim(SurfHeightName   ) )
  2213      call MessageNotify( 'M', module_name, '  SurfHeightStdSetting    = %c', c1 = trim(SurfHeightStdSetting   ) )
  2214      call MessageNotify( 'M', module_name, '  SurfHeightStdFile       = %c', c1 = trim(SurfHeightStdFile   ) )
  2215      call MessageNotify( 'M', module_name, '  SurfHeightStdName       = %c', c1 = trim(SurfHeightStdName   ) )
  2216      call MessageNotify( 'M', module_name, '  SoilHeatCapSetting      = %c', c1 = trim(SoilHeatCapSetting   ) )
  2217      call MessageNotify( 'M', module_name, '  SoilHeatCapFile         = %c', c1 = trim(SoilHeatCapFile   ) )
  2218      call MessageNotify( 'M', module_name, '  SoilHeatCapName         = %c', c1 = trim(SoilHeatCapName   ) )
  2219      call MessageNotify( 'M', module_name, '  SoilHeatDiffCoefSetting = %c', c1 = trim(SoilHeatDiffCoefSetting   ) )
  2220      call MessageNotify( 'M', module_name, '  SoilHeatDiffCoefFile    = %c', c1 = trim(SoilHeatDiffCoefFile   ) )
  2221      call MessageNotify( 'M', module_name, '  SoilHeatDiffCoefName    = %c', c1 = trim(SoilHeatDiffCoefName   ) )
  2222  
  2223      call MessageNotify( 'M', module_name, '  RoughLenHeatFactor      = %f', d = (/RoughLenHeatFactor/) )
  2224  
  2225  
  2226  !!$    call MessageNotify( 'M', module_name, 'Output:: ' )
  2227  !!$    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
  2228  !!$    call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
  2229      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2230  
  2231      surface_properties_inited = .true.
  2232  
  2233    end subroutine SurfacePropertiesInit
  2234  
  2235    !--------------------------------------------------------------------------------------
  2236  
  2237  end module surface_properties
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:35 2016
FILE NAME: surface_properties.f90
PROGRAM NAME: surface_properties
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 惑星表面データの設定
     2:             !
     3:             != Setting planetary surface properties
     4:             !
     5:             ! Authors::   Yasuhiro Morikawa, Yukiko Yamada, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: surface_properties.f90,v 1.20 2015/01/31 06:16:26 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module surface_properties
    13:               !
    14:               != 惑星表面特性の設定
    15:               !
    16:               != Setting planetary surface properties
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 海面温度や地表面諸量を設定します. 
    21:               !
    22:               ! Data about sea surface temperature (SST) or various values on surface
    23:               ! are set. 
    24:               !
    25:               !== Procedures List
    26:               ! SetSurfaceProperties  :: 惑星表面特性の設定
    27:               !--
    28:             !!$  ! GroundFileOpen   :: 地表面データファイルのオープン
    29:             !!$  ! GroundFileOutput :: 地表面データファイルへのデータ出力
    30:             !!$  ! GroundFileClose  :: 地表面データファイルのクローズ
    31:               !++
    32:               ! ------------     :: ------------
    33:               ! SetSurfaceProperties  :: Setting surface properties
    34:               !--
    35:             !!$  ! GroundFileOpen   :: Open ground data file
    36:             !!$  ! GroundFileOutput :: Data output to ground data file
    37:             !!$  ! GroundFileClose  :: Close ground data file
    38:               !++
    39:               !
    40:               !== NAMELIST
    41:               !
    42:               ! NAMELIST#surface_properties_nml
    43:               !
    44:             
    45:               ! モジュール引用 ; USE statements
    46:               !
    47:             
    48:               ! 種別型パラメタ
    49:               ! Kind type parameter
    50:               !
    51:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    52:                 &                 STRING, &  ! 文字列.       Strings. 
    53:                 &                 TOKEN      ! キーワード.   Keywords. 
    54:             
    55:               ! メッセージ出力
    56:               ! Message output
    57:               !
    58:               use dc_message, only: MessageNotify
    59:             
    60:               ! gtool5 データ出力
    61:               ! Gtool5 data output
    62:               !
    63:               use gtool_history, only: GT_HISTORY
    64:             
    65:               ! 格子点設定
    66:               ! Grid points settings
    67:               !
    68:               use gridset, only: imax, & ! 経度格子点数. 
    69:                                          ! Number of grid points in longitude
    70:                 &                jmax, & ! 緯度格子点数. 
    71:                                          ! Number of grid points in latitude
    72:                 &                kmax    ! 鉛直層数. 
    73:                                          ! Number of vertical level
    74:             
    75:               ! 宣言文 ; Declaration statements
    76:               !
    77:               implicit none
    78:               private
    79:             
    80:               ! 公開手続き
    81:               ! Public procedure
    82:               !
    83:               public:: SetSurfaceProperties
    84:               public:: SurfacePropertiesInit
    85:             
    86:               ! 公開変数
    87:               ! Public variables
    88:               !
    89:               logical, save :: surface_properties_inited = .false.
    90:                                           ! 初期設定フラグ. 
    91:                                           ! Initialization flag
    92:             
    93:             !!$  logical, save, public:: ground_file_opened = .false.
    94:             !!$                              ! 地表面データファイルのオープンに関するフラグ. 
    95:             !!$                              ! Flag of ground data file open
    96:             
    97:               ! 非公開変数
    98:               ! Private variables
    99:               !
   100:               logical          , save:: FlagSlabOcean
   101:                                           ! スラブオーシャン オン／オフ.
   102:                                           ! flag for use of slab ocean on/off
   103:             
   104:               character(STRING), save:: SurfTempSetting
   105:                                           ! 地表面温度の設定方法
   106:                                           ! Setting of surface temperature
   107:               character(STRING), save:: SurfTempFile
   108:                                           ! 地表面温度のファイル名. 
   109:                                           ! File name of surface temperature
   110:               character(TOKEN) , save:: SurfTempName
   111:                                           ! 地表面温度の変数名. 
   112:                                           ! Variable name of surface temperature
   113:             
   114:               character(STRING), save:: SeaIceSetting
   115:                                           ! 海氷面密度の設定方法
   116:                                           ! Setting of sea ice concentration
   117:               character(STRING), save:: SeaIceFile
   118:                                           ! 海氷面密度のファイル名. 
   119:                                           ! File name of sea ice concentration
   120:               character(TOKEN) , save:: SeaIceName
   121:                                           ! 海氷面密度の変数名. 
   122:                                           ! Variable name of sea ice concentration
   123:             
   124:               character(STRING), save:: AlbedoSetting
   125:                                           ! 地表アルベドの設定方法
   126:                                           ! Settingof surface albedo
   127:               character(STRING), save:: AlbedoFile
   128:                                           ! 地表アルベドのファイル名. 
   129:                                           ! File name of surface albedo
   130:               character(TOKEN) , save:: AlbedoName
   131:                                           ! 地表アルベドの変数名. 
   132:                                           ! Variable name of surface albedo
   133:             
   134:               character(STRING), save:: HumidCoefSetting
   135:                                           ! 地表湿潤度の設定方法
   136:                                           ! Setting of surface humidity coefficient
   137:               character(STRING), save:: HumidCoefFile
   138:                                           ! 地表湿潤度のファイル名. 
   139:                                           ! File name of surface humidity coefficient
   140:               character(TOKEN) , save:: HumidCoefName
   141:                                           ! 地表湿潤度の変数名. 
   142:                                           ! Variable name of surface humidity coefficient
   143:             
   144:               character(STRING), save:: RoughLengthSetting
   145:                                           ! 地表粗度長の設定方法
   146:                                           ! Setting of surface rough length
   147:               character(STRING), save:: RoughLengthFile
   148:                                           ! 地表粗度長のファイル名. 
   149:                                           ! File name of surface rough length
   150:               character(TOKEN) , save:: RoughLengthName
   151:                                           ! 地表粗度長の変数名. 
   152:                                           ! Variable name of surface rough length
   153:               character(STRING), save:: HeatCapacitySetting
   154:                                           ! 地表熱容量の設定方法
   155:                                           ! Setting of surface heat capacity
   156:               character(STRING), save:: HeatCapacityFile
   157:                                           ! 地表熱容量のファイル名. 
   158:                                           ! File name of surface heat capacity
   159:               character(TOKEN) , save:: HeatCapacityName
   160:                                           ! 地表熱容量の変数名. 
   161:                                           ! Variable name of surface heat capacity
   162:             
   163:               character(STRING), save:: TempFluxSetting
   164:                                           ! 地中熱フラックスの設定方法
   165:                                           ! Setting of ground temperature flux
   166:               character(STRING), save:: TempFluxFile
   167:                                           ! 地中熱フラックスのファイル名. 
   168:                                           ! File name of ground temperature flux
   169:               character(TOKEN) , save:: TempFluxName
   170:                                           ! 地中熱フラックスの変数名. 
   171:                                           ! Variable name of ground temperature flux
   172:             
   173:               character(STRING), save:: SurfCondSetting
   174:                                           ! 惑星表面状態の設定方法
   175:                                           ! Setting of surface condition
   176:               character(STRING), save:: SurfCondFile
   177:                                           ! 惑星表面状態のファイル名. 
   178:                                           ! File name of surface condition
   179:               character(TOKEN) , save:: SurfCondName
   180:                                           ! 惑星表面状態の変数名. 
   181:                                           ! Variable name of surface condition
   182:             
   183:               character(STRING), save:: SurfTypeSetting
   184:                                           ! 惑星表面タイプ (土地利用) の設定方法
   185:                                           ! Setting of surface type (land use)
   186:               character(STRING), save:: SurfTypeFile
   187:                                           ! 惑星表面タイプ (土地利用) のファイル名. 
   188:                                           ! File name of surface type (land use)
   189:               character(TOKEN) , save:: SurfTypeName
   190:                                           ! 惑星表面タイプ (土地利用) の変数名. 
   191:                                           ! Variable name of surface type (land use)
   192:             
   193:               character(STRING), save:: SurfCulIntSetting
   194:                                           ! ... の設定方法
   195:                                           ! Setting of surface cultivation intensity
   196:               character(STRING), save:: SurfCulIntFile
   197:                                           ! ... のファイル名. 
   198:                                           ! File name of surface cultivation intensity
   199:               character(TOKEN) , save:: SurfCulIntName
   200:                                           ! ... の変数名. 
   201:                                           ! Variable name of surface cultivation intensity
   202:             
   203:               character(STRING), save:: SurfHeightSetting
   204:                                           ! 地表面高度の設定方法
   205:                                           ! Setting of surface height
   206:               character(STRING), save:: SurfHeightFile
   207:                                           ! 地表面高度のファイル名. 
   208:                                           ! File name of surface height
   209:               character(TOKEN) , save:: SurfHeightName
   210:                                           ! 地表面高度の変数名. 
   211:                                           ! Variable name of surface height
   212:             
   213:               character(STRING), save:: SurfHeightStdSetting
   214:                                           ! 
   215:                                           ! Setting of surface height standard deviation
   216:               character(STRING), save:: SurfHeightStdFile
   217:                                           ! 
   218:                                           ! File name of surface height standard deviation
   219:               character(TOKEN) , save:: SurfHeightStdName
   220:                                           ! 
   221:                                           ! Variable name of surface height standard deviation
   222:             
   223:               character(STRING), save:: SoilHeatCapSetting
   224:                                           ! 土壌熱容量の設定方法
   225:                                           ! Setting of heat conduction coefficient of soil
   226:               character(STRING), save:: SoilHeatCapFile
   227:                                           ! 土壌熱容量のファイル名. 
   228:                                           ! File name of heat conduction coefficient of soil
   229:               character(TOKEN) , save:: SoilHeatCapName
   230:                                           ! 土壌熱容量の変数名. 
   231:                                           ! Variable name of heat conduction coefficient of soil
   232:             
   233:               character(STRING), save:: SoilHeatDiffCoefSetting
   234:                                           ! 土壌熱伝導率の設定方法
   235:                                           ! Setting of heat conduction coefficient of soil
   236:               character(STRING), save:: SoilHeatDiffCoefFile
   237:                                           ! 土壌熱伝導率のファイル名. 
   238:                                           ! File name of heat conduction coefficient of soil
   239:               character(TOKEN) , save:: SoilHeatDiffCoefName
   240:                                           ! 土壌熱伝導率の変数名. 
   241:                                           ! Variable name of heat conduction coefficient of soil
   242:             
   243:               real(DP), save:: RoughLenHeatFactor
   244:                                           ! 運動量と熱の地表粗度長の比.
   245:                                           ! Ratio of roughness length for momentum and heat
   246:             
   247:               logical, save:: FlagUseBucket
   248:             
   249:             
   250:             
   251:             !!$  character(STRING), save:: OutputFile
   252:             !!$                              ! 出力する地表面データのファイル名
   253:             !!$                              ! filename of output ground data
   254:             !!$  real(DP), save:: IntValue
   255:             !!$                              ! 地表面データの出力間隔. 
   256:             !!$                              ! Interval of ground data output
   257:             !!$  character(TOKEN):: IntUnit
   258:             !!$                              ! 地表面データの出力間隔の単位. 
   259:             !!$                              ! Unit for interval of ground data output
   260:             !!$
   261:             !!$  type(GT_HISTORY), save:: gthst_grd
   262:             !!$                              ! 地表面データ用 gtool_history#GT_HISTORY 変数
   263:             !!$                              ! "gtool_history#GT_HISTORY" variable for ground data
   264:             !!$
   265:             !!$
   266:             !!$  type(DC_DIFFTIME), save:: PrevOutputTime
   267:             !!$                              ! 前回の出力時間. 
   268:             !!$                              ! Previous output time
   269:             !!$
   270:             !!$  type(DC_DIFFTIME), save:: IntTime
   271:             !!$                              ! リスタートデータの出力時間. 
   272:             !!$                              ! Time interval of restart data output
   273:             
   274:               character(*), parameter:: module_name = 'surface_properties'
   275:                                           ! モジュールの名称. 
   276:                                           ! Module name
   277:               character(*), parameter:: version = &
   278:                 & '$Name:  $' // &
   279:                 & '$Id: surface_properties.f90,v 1.20 2015/01/31 06:16:26 yot Exp $'
   280:                                           ! モジュールのバージョン
   281:                                           ! Module version
   282:             
   283:             
   284:             contains
   285:             
   286:               subroutine SetSurfaceProperties(                       &
   287:                 & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB,   & ! (in)    optional
   288:                 & xy_SOSeaIceMassB,                                  & ! (in)    optional
   289:                 & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoef,      & ! (inout) optional
   290:                 & xy_SurfRoughLenMom, xy_SurfRoughLenHeat,           & ! (inout) optional
   291:                 & xy_SurfHeatCapacity,                               & ! (inout) optional
   292:                 & xy_DeepSubSurfHeatFlux, xy_SurfCond, xy_SurfType,  & ! (inout) optional
   293:                 & xy_SurfHeight, xy_SurfHeightStd,                   & ! (inout) optional
   294:                 & xy_SeaIceConc,                                     & ! (inout) optional
   295:                 & xy_SoilHeatCap, xy_SoilHeatDiffCoef                & ! (inout) optional
   296:                 & )
   297:                 !
   298:                 ! 惑星表面特性を設定します. 
   299:                 !
   300:                 ! Set surface properties. 
   301:                 !
   302:             
   303:                 ! モジュール引用 ; USE statements
   304:                 !
   305:             
   306:                 ! 文字列操作
   307:                 ! Character handling
   308:                 !
   309:                 use dc_string, only: toChar
   310:             
   311:                 ! gtool4 データ入力
   312:                 ! Gtool4 data input
   313:                 !
   314:                 use gtool_history, only: HistoryGet
   315:             
   316:                 ! ヒストリデータ出力
   317:                 ! History data output
   318:                 !
   319:                 use gtool_historyauto, only: HistoryAutoPut
   320:             
   321:                 ! 時系列データの読み込み
   322:                 ! Reading time series
   323:                 !
   324:                 use read_time_series, only: SetValuesFromTimeSeriesWrapper
   325:             
   326:                 ! 時刻管理
   327:                 ! Time control
   328:                 !
   329:                 use timeset, only: &
   330:                   & TimeN, &              ! ステップ $ t $ の時刻.
   331:                                           ! Time of step $ t $.
   332:                   & EndTime, &            ! 計算終了時刻.
   333:                                           ! End time of calculation
   334:                   & TimesetClockStart, TimesetClockStop
   335:             
   336:                 ! 地表面データ提供
   337:                 ! Prepare surface data
   338:                 !
   339:                 use surface_data, only: SetSurfData
   340:             
   341:                 !
   342:                 ! Routines for GABLS tests
   343:                 !
   344:                 use gabls, only : SetGabls2SurfTemp
   345:             
   346:                 ! Matthews のデータに基づく惑星表面アルベド設定
   347:                 ! set surface albedo based on data by Matthews
   348:                 !
   349:                 use albedo_Matthews, only: SetAlbedoMatthews, ModAlbedoMatthewsCultivation
   350:             
   351:                 ! バケツモデル
   352:                 ! Bucket model
   353:                 !
   354:                 use Bucket_Model, only : BucketSetFlagOceanFromMatthews, BucketModHumidCoef
   355:             
   356:                 ! 雪と海氷によるアルベド変化
   357:                 ! modification of surface albedo on the snow covered ground and on the sea ice
   358:                 !
   359:                 use modify_albedo_snowseaice, only: ModAlbedoDueToSnowSeaIce
   360:             
   361:                 ! アルベド, 粗度長の設定, 陸面と海洋の差のみ考慮
   362:                 ! Set albedo and roughness length, only considering land-ocean contrast
   363:                 !
   364:                 use surface_properties_lo, only: &
   365:                   & SetAlbedoLO, SetRoughLenLO
   366:             
   367:                 ! Matthews のデータに基づく地面粗度の設定
   368:                 ! set roughness length on land surface based on data by Matthews
   369:                 !
   370:                 use roughlen_Matthews, only: SetRoughLenLandMatthews, ModRoughLenMatthewsCultivation
   371:             
   372:                 ! 土壌熱伝導係数の設定
   373:                 ! set soil thermal diffusion coefficient
   374:                 !
   375:                 use soil_thermdiffcoef, only : SetSoilThermDiffCoefSimple
   376:             
   377:                 ! 雪, 氷の割合
   378:                 ! snow/ice fraction
   379:                 !
   380:                 use snowice_frac, only : SeaIceAboveThreshold
   381:             
   382:                 ! 宣言文 ; Declaration statements
   383:                 !
   384:                 real(DP), intent(in   ), optional:: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   385:                                           ! $ M_mcs (t-\Delta t) $ .
   386:                                           ! Surface major component ice amount (kg m-2)
   387:                 real(DP), intent(in   ), optional:: xy_SoilMoistB(0:imax-1, 1:jmax)
   388:                                           ! $ M_ws (t-\Delta t) $ . 土壌水分 (kg m-2)
   389:                                           ! Soil moisture (kg m-2)
   390:                 real(DP), intent(in   ), optional:: xy_SurfSnowB(0:imax-1, 1:jmax)
   391:                                           ! $ M_ss (t-\Delta t) $ . 積雪量 (kg m-2)
   392:                                           ! Surface snow amount (kg m-2)
   393:                 real(DP), intent(in   ), optional:: xy_SOSeaIceMassB(0:imax-1, 1:jmax)
   394:                                           ! $ M_si (t-\Delta t) $ . 
   395:                                           ! Slab seaice mass (kg m-2)
   396:                 real(DP), intent(inout), optional:: xy_SurfTemp (0:imax-1, 1:jmax)
   397:                                           ! 地表面温度. 
   398:                                           ! Surface temperature
   399:                 real(DP), intent(inout), optional:: xy_SurfAlbedo (0:imax-1, 1:jmax)
   400:                                           ! 地表アルベド. 
   401:                                           ! Surface albedo
   402:                 real(DP), intent(inout), optional:: xy_SurfHumidCoef (0:imax-1, 1:jmax)
   403:                                           ! 地表湿潤度. 
   404:                                           ! Surface humidity coefficient
   405:                 real(DP), intent(inout), optional:: xy_SurfRoughLenMom (0:imax-1, 1:jmax)
   406:                                           ! 地表粗度長. 
   407:                                           ! Surface rough length for momentum
   408:                 real(DP), intent(inout), optional:: xy_SurfRoughLenHeat(0:imax-1, 1:jmax)
   409:                                           ! 地表粗度長. 
   410:                                           ! Surface rough length for heat
   411:                 real(DP), intent(inout), optional:: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
   412:                                           ! 地表熱容量. 
   413:                                           ! Surface heat capacity
   414:                 real(DP), intent(inout), optional:: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
   415:                                           ! 地中熱フラックス. 
   416:                                           ! "Deep subsurface heat flux"
   417:                                           ! Heat flux at the bottom of surface/soil layer.
   418:                 integer , intent(inout), optional:: xy_SurfCond (0:imax-1, 1:jmax)
   419:                                           ! 惑星表面状態 (0: 固定, 1: 可変). 
   420:                                           ! Surface condition (0: fixed, 1: variable)
   421:                 integer , intent(inout), optional:: xy_SurfType (0:imax-1, 1:jmax)
   422:                                           ! 惑星表面タイプ (土地利用)
   423:                                           ! Surface type (land use)
   424:                 real(DP), intent(inout), optional:: xy_SurfHeight   (0:imax-1, 1:jmax)
   425:                                           ! $ z_s $ . 地表面高度. 
   426:                                           ! Surface height. 
   427:                 real(DP), intent(inout), optional:: xy_SurfHeightStd(0:imax-1, 1:jmax)
   428:                                           ! $ z_s $ . 地表面高度. 
   429:                                           ! Surface height. 
   430:                 real(DP), intent(inout), optional:: xy_SeaIceConc(0:imax-1,1:jmax)
   431:                                           ! 海氷密度 (0 <= xy_SeaIceConc <= 1)
   432:                                           ! Sea ice concentration (0 <= xy_SeaIceConc <= 1)
   433:                 real(DP), intent(inout), optional:: xy_SoilHeatCap(0:imax-1,1:jmax)
   434:                                           ! 土壌熱容量 (J K-1 kg-1)
   435:                                           ! Specific heat of soil (J K-1 kg-1)
   436:                 real(DP), intent(inout), optional:: xy_SoilHeatDiffCoef(0:imax-1,1:jmax)
   437:                                           ! 土壌熱伝導率 (W m-1 K-1)
   438:                                           ! Heat conduction coefficient of soil (W m-1 K-1)
   439:             
   440:                 ! 作業変数
   441:                 ! Work variables
   442:                 !
   443:                 real(DP), allocatable, save:: xy_SurfTempSave (:,:)
   444:                                           ! 地表面温度の保存値 (K)
   445:                                           ! Saved values of surface temperature (K)
   446:                 real(DP), allocatable, save:: xy_SeaIceConcSave(:,:)
   447:                                           ! 海氷面密度の保存値
   448:                                           ! Saved values of sea ice concentration
   449:                 real(DP), allocatable, save:: xy_SurfAlbedoSave(:,:)
   450:                                           ! アルベドの保存値
   451:                                           ! Saved values of albedo
   452:             
   453:                 logical      :: xy_BucketFlagOceanGrid(0:imax-1,1:jmax)
   454:                                           !
   455:                                           ! Flag for ocean grid point used in bucket model
   456:                 real(DP), allocatable, save:: xy_SurfCulIntSave(:,:)
   457:                 real(DP)                   :: xy_SurfCulInt    (0:imax-1,1:jmax)
   458:                                           !
   459:                                           ! Surface cultivation intensity
   460:             
   461:                 logical, save:: flag_first_SurfCond            = .true.
   462:                                           ! 初回を示すフラグ. 
   463:                                           ! Flag that indicates first loop
   464:                                           !
   465:                 logical, save:: flag_first_SurfType            = .true.
   466:                 logical, save:: flag_first_SurfCulInt          = .true.
   467:                 logical, save:: flag_first_SeaIceConc          = .true.
   468:                 logical, save:: flag_first_SurfTemp            = .true.
   469:                 logical, save:: flag_first_SurfHeight          = .true.
   470:                 logical, save:: flag_first_SurfHeightStd       = .true.
   471:                 logical, save:: flag_first_SurfAlbedo          = .true.
   472:                 logical, save:: flag_first_SurfHumidCoef       = .true.
   473:                 logical, save:: flag_first_SurfRoughLen        = .true.
   474:                 logical, save:: flag_first_SurfHeatCapacity    = .true.
   475:                 logical, save:: flag_first_DeepSubSurfHeatFlux = .true.
   476:                 logical, save:: flag_first_SoilHeatCap         = .true.
   477:                 logical, save:: flag_first_SoilHeatDiffCoef    = .true.
   478:             
   479:                 logical :: FlagSetSurfType
   480:                 logical :: FlagSetSeaIceConc
   481:                 logical :: FlagSetSurfCond
   482:                 logical :: FlagSetSurfCulInt
   483:                 logical :: FlagSetSurfTemp
   484:                 logical :: FlagSetSurfHeight
   485:                 logical :: FlagSetSurfHeightStd
   486:                 logical :: FlagSetSurfAlbedo
   487:                 logical :: FlagSetSurfHumidCoef
   488:                 logical :: FlagSetSurfRoughLenMom
   489:                 logical :: FlagSetSurfRoughLenHeat
   490:                 logical :: FlagSetSurfHeatCapacity
   491:                 logical :: FlagSetDeepSubSurfHeatFlux
   492:                 logical :: FlagSetSoilHeatCap
   493:                 logical :: FlagSetSoilHeatDiffCoef
   494:             
   495:                 logical:: flag_mpi_init
   496:             
   497:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   498:                                           ! Work variables for DO loop in longitude
   499:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   500:                                           ! Work variables for DO loop in latitude
   501:             
   502:             
   503:                 ! 実行文 ; Executable statement
   504:                 !
   505:             
   506:                 ! 初期化確認
   507:                 ! Initialization check
   508:                 !
   509:                 if ( .not. surface_properties_inited ) then
   510:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   511:                 end if
   512:             
   513:             
   514:                 ! 計算時間計測開始
   515:                 ! Start measurement of computation time
   516:                 !
   517:                 call TimesetClockStart( module_name )
   518:             
   519:             
   520:                 flag_mpi_init = .true.
   521:             
   522:                 FlagSetSurfType            = .false.
   523:                 FlagSetSeaIceConc          = .false.
   524:                 FlagSetSurfCond            = .false.
   525:                 FlagSetSurfCulInt          = .false.
   526:                 FlagSetSurfTemp            = .false.
   527:                 FlagSetSurfHeight          = .false.
   528:                 FlagSetSurfHeightStd       = .false.
   529:                 FlagSetSurfAlbedo          = .false.
   530:                 FlagSetSurfHumidCoef       = .false.
   531:                 FlagSetSurfRoughLenMom     = .false.
   532:                 FlagSetSurfRoughLenHeat    = .false.
   533:                 FlagSetSurfHeatCapacity    = .false.
   534:                 FlagSetDeepSubSurfHeatFlux = .false.
   535:                 FlagSetSoilHeatCap         = .false.
   536:                 FlagSetSoilHeatDiffCoef    = .false.
   537:             
   538:             
   539:                 ! NOTICE:
   540:                 ! The surface condition has to be set, before other fields are set.
   541:                 !
   542:                 ! 惑星表面タイプ (土地利用)
   543:                 ! Surface type (land use)
   544:                 !
   545:                 if ( present(xy_SurfType) ) then
   546:             
   547:                   if ( SurfTypeSetting == 'file' ) then
   548:                     ! データをファイルから取得
   549:                     ! Data is input from files
   550:                     !
   551:                     if ( flag_first_SurfType ) then
   552:                       call HistoryGet( &
   553:                         & SurfTypeFile, SurfTypeName, &     ! (in)
   554:                         & xy_SurfType, &                    ! (out)
   555:                         & flag_mpi_split = flag_mpi_init )  ! (in) optional
   556:                     end if
   557:                     if ( SurfCondSetting /= 'generate_from_SurfType' ) then
   558:                       call MessageNotify( 'E', module_name, &
   559:                         & " SurfCond has to be 'generate_from_SurfType', if SurfTypeSetting = %c.", &
   560:                         & c1 = trim(SurfTypeSetting) )
   561:                     end if
   562:                   else if ( SurfTypeSetting == 'generate_internally' ) then
   563:                     ! データ (デフォルト値) を surface_data モジュールから取得
   564:                     ! Data (default values) is input from "surface_data" module
   565:                     !
   566:                     if ( flag_first_SurfType ) then
   567:                       call SetSurfData( &
   568:                         & xy_SurfType = xy_SurfType &                   ! (out)
   569:                         & )
   570:                     end if
   571:                   else
   572:                     call MessageNotify( 'E', module_name, &
   573:                       & ' SurfTypeSetting = %c is not appropriate.', &
   574:                       & c1 = trim(SurfTypeSetting) )
   575:                   end if
   576:             
   577:                   FlagSetSurfType = .true.
   578:             
   579:                   flag_first_SurfType = .false.
   580:             
   581:                 end if
   582:             
   583:             
   584:                 ! NOTICE:
   585:                 ! The sea ice distribution has to be set, 
   586:                 ! before set SurfTemp (surface temperature) and SurfCond. 
   587:                 !
   588:                 ! 海氷面密度
   589:                 ! Sea ice concentration
   590:                 !
   591:                 if ( present(xy_SeaIceConc) ) then
   592:             
   593:                   if ( flag_first_SeaIceConc ) then
   594:                     ! 保存用変数の割付
   595:                     ! Allocate a variable for save
   596:                     !
   597:                     allocate( xy_SeaIceConcSave(0:imax-1, 1:jmax) )
   598:                   end if
   599:                   if ( SeaIceSetting == 'file' ) then
   600:                     ! データをファイルから取得
   601:                     ! Data is input from files
   602:                     !
   603:             
   604:                     ! This will be deleted near future (yot, 2010/10/11)
   605:             !!$        if ( flag_first_SeaIceConc ) then
   606:             !!$          call HistoryGet( &
   607:             !!$            & SeaIceFile, SeaIceName,          & ! (in)
   608:             !!$            & xy_SeaIceConcSave,               & ! (out)
   609:             !!$            & flag_mpi_split = flag_mpi_init )   ! (in) optional
   610:             !!$        end if
   611:                     call SetValuesFromTimeSeriesWrapper(    &
   612:                       & 'SIC',                              &
   613:                       & SeaIceFile, SeaIceName,             &
   614:                       & xy_SeaIceConcSave                   &               ! (inout)
   615:                       & )
   616:                   else if ( SeaIceSetting == 'generate_internally' ) then
   617:                     ! データ (デフォルト値) を surface_data モジュールから取得
   618:                     ! Data (default values) is input from "surface_data" module
   619:                     !
   620:                     if ( flag_first_SeaIceConc ) then
   621:                       call SetSurfData( &
   622:                         & xy_SeaIceConc = xy_SeaIceConcSave &                   ! (out)
   623:                         & )
   624:                     end if
   625:                   else
   626:                     call MessageNotify( 'E', module_name, &
   627:                       & ' SeaIceSetting = %c is not appropriate.', &
   628:                       & c1 = trim(SeaIceSetting) )
   629:                   end if
   630:                   ! 海氷面密度の設定 ( xy_SurfCond == 0 の場所のみ )
   631:                   ! Setting of sea ice concentration ( where xy_SurfCond == 0 only )
   632:                   !
   633: W*===== A         xy_SeaIceConc = xy_SeaIceConcSave
   634:             
   635:                   FlagSetSeaIceConc = .true.
   636:             
   637:                   flag_first_SeaIceConc = .false.
   638:             
   639:                 end if
   640:             
   641:             
   642:                 ! 惑星表面状態
   643:                 ! Surface condition
   644:                 ! Flag whether surface temperature is calculated or not
   645:                 ! 0 : surface temperature is not calculated
   646:                 ! 1 : surface temperature is     calculated
   647:                 !
   648:                 if ( present(xy_SurfCond) ) then
   649:             
   650:                   ! NOTICE:
   651:                   ! Before set SurfCond, SeaIceConc has to be set.
   652:                   if ( .not. FlagSetSeaIceConc ) then
   653:                     call MessageNotify( 'E', module_name, &
   654:                       & " SeaIceConc has to be set before setting SurfCond is set." )
   655:                   end if
   656:             
   657:                   if ( SurfCondSetting == 'generate_from_SurfType' ) then
   658:                     if ( flag_first_SurfCond ) then
   659:             !!$          if ( ( SurfTypeSetting /= 'file' ) .and. ( SurfTypeSetting /= 'generate_internally' ) ) then
   660:             !!$            call MessageNotify( 'E', module_name, &
   661:             !!$              & " SurfCond has to be 'generate_from_SurfType' or 'generate_internally', if SurfTypeSetting = %c.", &
   662:             !!$              & c1 = trim(SurfTypeSetting) )
   663:             !!$          end if
   664:                       call MessageNotify( 'M', module_name, &
   665:                         & ' xy_SurfCond is constructed by use of xy_SurfType values because SurfTypeSetting = %c.', &
   666:                         & c1 = trim(SurfTypeSetting) )
   667:                     end if
   668: +------>            do j = 1, jmax
   669: |+----->              do i = 0, imax-1
   670: ||                      if ( xy_SurfType(i,j) == 0 ) then
   671: ||                        if ( SeaIceAboveThreshold( xy_SeaIceConc(i,j) ) ) then
   672: ||                          xy_SurfCond(i,j) = 1
   673: ||                        else if ( FlagSlabOcean ) then
   674: ||                          xy_SurfCond(i,j) = 1
   675: ||                        else
   676: ||                          xy_SurfCond(i,j) = 0
   677: ||                        end if
   678: ||                      else
   679: ||                        xy_SurfCond(i,j) = 1
   680: ||                      end if
   681: |+-----               end do
   682: +------             end do
   683:             
   684:                   else if ( SurfCondSetting == 'file' ) then
   685:                     ! データをファイルから取得
   686:                     ! Data is input from files
   687:                     !
   688:                     if ( flag_first_SurfCond ) then
   689:                       call HistoryGet( &
   690:                         & SurfCondFile, SurfCondName, &     ! (in)
   691:                         & xy_SurfCond, &                    ! (out)
   692:                         & flag_mpi_split = flag_mpi_init )  ! (in) optional
   693:                     end if
   694:                   else if ( SurfCondSetting == 'generate_internally' ) then
   695:                     ! データ (デフォルト値) を surface_data モジュールから取得
   696:                     ! Data (default values) is input from "surface_data" module
   697:                     !
   698:                     if ( flag_first_SurfCond ) then
   699:                       call SetSurfData( &
   700:                         & xy_SurfCond = xy_SurfCond &                   ! (out)
   701:                         & )
   702:                     end if
   703:                   else
   704:                     call MessageNotify( 'E', module_name, &
   705:                       & ' SurfCondSetting = %c is not appropriate.', &
   706:                       & c1 = trim(SurfCondSetting) )
   707:                   end if
   708:             
   709:                   ! Check of SurfCond values
   710:                   !
   711: +------>          do j = 1, jmax
   712: |+----->            do i = 0, imax-1
   713: ||                    if ( ( xy_SurfCond(i,j) < 0 ) .or. ( xy_SurfCond(i,j) > 1 ) ) then
   714: ||                      call MessageNotify( 'E', module_name, &
   715: ||                        & ' SurfCond value of %d is not appropriate.', &
   716: ||                        & i = (/ xy_SurfCond(i,j) /) )
   717: ||                    end if
   718: |+-----             end do
   719: +------           end do
   720:             
   721:                   FlagSetSurfCond = .true.
   722:             
   723:                   flag_first_SurfCond = .false.
   724:             
   725:                 end if
   726:             
   727:             
   728:                 ! 
   729:                 ! Surface cultivation index
   730:                 !
   731:                 ! Cultivation intensity is set only when xy_SurfType is present.
   732:                 if ( present( xy_SurfType ) ) then
   733:             
   734:                   ! NOTICE:
   735:                   ! Before set SurfCulInt, SurfType has to be set.
   736:                   if ( .not. FlagSetSurfType ) then
   737:                     call MessageNotify( 'E', module_name, &
   738:                       & " SurfType has to be set before setting SurfCulInt is set." )
   739:                   end if
   740:             
   741:                   if ( flag_first_SurfCulInt ) then
   742:                     ! 保存用変数の割付
   743:                     ! Allocate a variable for save
   744:                     !
   745:                     allocate( xy_SurfCulIntSave(0:imax-1, 1:jmax) )
   746:                   end if
   747:                   if ( SurfCulIntSetting == 'file' ) then
   748:                     ! データをファイルから取得
   749:                     ! Data is input from files
   750:                     !
   751:                     if ( SurfTypeSetting /= 'file' ) then
   752:                       call MessageNotify( 'E', module_name, &
   753:                         & " SurfType has to be 'file', when SurfCulIntSetting = %c.", &
   754:                         & c1 = trim(SurfCulIntSetting) )
   755:                     end if
   756:                     call SetValuesFromTimeSeriesWrapper(    &
   757:                       & 'CI',                               &
   758:                       & SurfCulIntFile, SurfCulIntName,     &
   759:                       & xy_SurfCulIntSave                   &               ! (inout)
   760:                       & )
   761:                   else if ( SurfCulIntSetting == 'generate_internally' ) then
   762: +V===== A           xy_SurfCulIntSave = 0.0_DP
   763:                   else
   764:                     call MessageNotify( 'E', module_name, &
   765:                       & ' SurfCulIntSetting = %c is not appropriate.', &
   766:                       & c1 = trim(SurfCulIntSetting) )
   767:                   end if
   768:                   !
   769: W*===== A         xy_SurfCulInt = xy_SurfCulIntSave
   770:             
   771:                   FlagSetSurfCulInt = .true.
   772:                   flag_first_SurfCulInt = .false.
   773:                 else
   774: W*===== A         xy_SurfCulInt = 0.0_DP
   775:             
   776:                   FlagSetSurfCulInt = .true.
   777:                 end if
   778:             
   779:             
   780:             
   781:                 ! 地表面温度
   782:                 ! surface temperature
   783:                 !
   784:                 if ( present(xy_SurfTemp) ) then
   785:             
   786:                   ! NOTICE:
   787:                   ! Before set surface temperature, sea ice distribution has to be set.
   788:                   if ( .not. FlagSetSeaIceConc ) then
   789:                     call MessageNotify( 'E', module_name, &
   790:                       & " SeaIceConc has to be set before setting SurfTemp is set." )
   791:                   end if
   792:             
   793:                   if ( flag_first_SurfTemp ) then
   794:                     ! 保存用変数の割付
   795:                     ! Allocate a variable for save
   796:                     !
   797:                     allocate( xy_SurfTempSave  (0:imax-1, 1:jmax) )
   798:                   end if
   799:                   if ( SurfTempSetting == 'file' ) then
   800:                     ! データをファイルから取得
   801:                     ! Data is input from files
   802:                     !
   803:             
   804:                     ! This will be deleted near future (yot, 2010/10/11)
   805:             !!$        if ( flag_first_SurfTemp ) then
   806:             !!$          call HistoryGet( &
   807:             !!$            & SurfTempFile, SurfTempName, &    ! (in)
   808:             !!$            & xy_SurfTempSave, &               ! (out)
   809:             !!$            & flag_mpi_split = flag_mpi_init ) ! (in) optional
   810:             !!$        end if
   811:                     call SetValuesFromTimeSeriesWrapper(    &
   812:                       & 'SST',                              &
   813:                       & SurfTempFile, SurfTempName,         &
   814:                       & xy_SurfTempSave                     &               ! (inout)
   815:                       & )
   816:                   else if ( SurfTempSetting == 'GABLS2' ) then
   817:                     !
   818:                     ! Routines for GABLS tests
   819:                     !
   820:                     call SetGabls2SurfTemp(     &
   821:                       & xy_SurfTempSave         & ! (out)
   822:                       & )
   823:                   else if ( SurfTempSetting == 'generate_internally' ) then
   824:                     ! データ (デフォルト値) を surface_data モジュールから取得
   825:                     ! Data (default values) is input from "surface_data" module
   826:                     !
   827:                     if ( flag_first_SurfTemp ) then
   828:                       call SetSurfData( &
   829:                         & xy_SurfTemp = xy_SurfTempSave & ! (out) optional
   830:                         & )
   831:                     end if
   832:                   else
   833:                     call MessageNotify( 'E', module_name, &
   834:                       & ' SurfTempSetting = %c is not appropriate.', &
   835:                       & c1 = trim(SurfTempSetting) )
   836:                   end if
   837:                   ! 地表面温度を SST で置き換え ( xy_SurfCond <=0 の場所のみ )
   838:                   ! Surface temperature is replaced with SST ( only xy_SurfCond <=0 )
   839:                   !
   840:                   if ( present(xy_SurfTemp) ) then
   841:             
   842:                     if ( .not. present( xy_SurfCond ) ) then
   843:                       call MessageNotify( 'E', module_name, &
   844:                         & ' xy_SurfCond has to be present to set xy_SurfTemp.' )
   845:                     end if
   846:                     if ( .not. present( xy_SeaIceConc ) ) then
   847:                       call MessageNotify( 'E', module_name, &
   848:                         & ' xy_SeaIceConc has to be present to set xy_SurfTemp.' )
   849:                     end if
   850:             
   851: W------>            do j = 1, jmax
   852: |*----->              do i = 0, imax-1
   853: ||      A               if ( xy_SurfCond(i,j) == 0 ) then
   854: ||      A                 xy_SurfTemp(i,j) = xy_SurfTempSave(i,j)
   855: ||                      end if
   856: |*-----               end do
   857: W------             end do
   858:             
   859:                   end if
   860:             
   861:                   FlagSetSurfTemp = .true.
   862:             
   863:                   flag_first_SurfTemp = .false.
   864:                 end if
   865:             
   866:             
   867:                 ! 地形
   868:                 ! Topography
   869:                 !
   870:                 if ( present(xy_SurfHeight) ) then
   871:             
   872:                   if ( SurfHeightSetting == 'file' ) then
   873:                     ! データをファイルから取得
   874:                     ! Data is input from files
   875:                     !
   876:                     if ( flag_first_SurfHeight ) then
   877:                       call HistoryGet( &
   878:                         & SurfHeightFile, SurfHeightName, &  ! (in)
   879:                         & xy_SurfHeight, &                   ! (out)
   880:                         & flag_mpi_split = flag_mpi_init )   ! (in) optional
   881:                     end if
   882:                   else if ( SurfHeightSetting == 'generate_internally' ) then
   883:                     if ( flag_first_SurfHeight ) then
   884: +V===== A             xy_SurfHeight = 0.0_DP
   885:                     end if
   886:                   else
   887:                     call MessageNotify( 'E', module_name, &
   888:                       & ' SurfHeightSetting = %c is not appropriate.', &
   889:                       & c1 = trim(SurfHeightSetting) )
   890:                   end if
   891:             
   892:                   FlagSetSurfHeight = .true.
   893:             
   894:                   flag_first_SurfHeight = .false.
   895:                 end if
   896:             
   897:                 ! 
   898:                 ! Surface height standard deviation
   899:                 !
   900:                 if ( present(xy_SurfHeightStd) ) then
   901:             
   902:                   if ( SurfHeightStdSetting == 'file' ) then
   903:                     ! データをファイルから取得
   904:                     ! Data is input from files
   905:                     !
   906:                     if ( flag_first_SurfHeightStd ) then
   907:                       call HistoryGet( &
   908:                         & SurfHeightStdFile, SurfHeightStdName, & ! (in)
   909:                         & xy_SurfHeightStd, &                     ! (out)
   910:                         & flag_mpi_split = flag_mpi_init )        ! (in) optional
   911:                     end if
   912:                   else if ( SurfHeightStdSetting == 'generate_internally' ) then
   913:                     ! データ (デフォルト値) を surface_data モジュールから取得
   914:                     ! Data (default values) is input from "surface_data" module
   915:                     ! 
   916:                     if ( flag_first_SurfHeightStd ) then
   917:                       call SetSurfData( &
   918:                         & xy_SurfHeightStd = xy_SurfHeightStd  & ! (out)
   919:                         & )
   920:                     end if
   921:                   else
   922:                     call MessageNotify( 'E', module_name, &
   923:                       & ' SurfHeightStdSetting = %c is not appropriate.', &
   924:                       & c1 = trim(SurfHeightStdSetting) )
   925:                   end if
   926:             
   927:                   FlagSetSurfHeightStd = .true.
   928:             
   929:                   flag_first_SurfHeightStd = .false.
   930:                 end if
   931:             
   932:             
   933:                 ! アルベド
   934:                 ! Albedo
   935:                 !
   936:                 if ( present(xy_SurfAlbedo) ) then
   937:             
   938:                   ! NOTICE:
   939:                   ! The surface condition and sea ice concentration have to be set, 
   940:                   ! before albedo is set.
   941:                   if ( ( .not. FlagSetSurfCond ) .or. ( .not. FlagSetSeaIceConc ) ) then
   942:                     call MessageNotify( 'E', module_name, &
   943:                       & " SurfCond and SeaIceConc have to be set before setting SurfAlbedo is set." )
   944:                   end if
   945:             
   946:                   if ( flag_first_SurfAlbedo ) then
   947:                     ! 保存用変数の割付
   948:                     ! Allocate a variable for save
   949:                     !
   950:                     allocate( xy_SurfAlbedoSave(0:imax-1, 1:jmax) )
   951:                   end if
   952:                   if ( AlbedoSetting == 'file' ) then
   953:                     ! データをファイルから取得
   954:                     ! Data is input from files
   955:                     !
   956:                     if ( flag_first_SurfAlbedo ) then
   957:                       call HistoryGet( &
   958:                         & AlbedoFile, AlbedoName, &        ! (in)
   959:                         & xy_SurfAlbedoSave,      &        ! (out)
   960:                         & flag_mpi_split = flag_mpi_init ) ! (in) optional
   961:                     end if
   962:             !!$        call SetValuesFromTimeSeriesWrapper(    &
   963:             !!$          & 'surface_albedo',                   &
   964:             !!$          & AlbedoFile, AlbedoName,             &
   965:             !!$          & xy_SurfAlbedoSave                   &               ! (inout)
   966:             !!$          & )
   967:                   else if ( AlbedoSetting == 'Matthews' ) then
   968:                     ! アルベドを Matthews のデータをもとに設定
   969:                     ! Surface albedo is set based on Matthews' data
   970:                     !
   971:                     if ( .not. present( xy_SurfType ) ) then
   972:                       call MessageNotify( 'E', module_name, &
   973:                         & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
   974:                     end if
   975:                     if ( SurfTypeSetting /= 'file' ) then
   976:                       call MessageNotify( 'E', module_name, &
   977:                         & " SurfType has to be 'file', when AlbedoSetting = %c.", &
   978:                         & c1 = trim(AlbedoSetting) )
   979:                     end if
   980:                     call SetAlbedoMatthews( &
   981:                       & xy_SurfType,      &
   982:                       & xy_SurfAlbedoSave &
   983:                       & )
   984:                     ! Modify albedo due to cultivation
   985:                     call ModAlbedoMatthewsCultivation( &
   986:                       & xy_SurfType, xy_SurfCulInt,    &
   987:                       & xy_SurfAlbedoSave              &
   988:                       & )
   989:                   else if ( AlbedoSetting == 'LOContrast' ) then
   990:                     ! アルベドの設定, 陸面と海洋の差のみ考慮
   991:                     ! Set albedo, only considering land-ocean contrast
   992:                     !
   993:                     if ( .not. present( xy_SurfType ) ) then
   994:                       call MessageNotify( 'E', module_name, &
   995:                         & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
   996:                     end if
   997:                     if ( SurfTypeSetting /= 'file' ) then
   998:                       call MessageNotify( 'E', module_name, &
   999:                         & " SurfType has to be 'file', when AlbedoSetting = %c.", &
  1000:                         & c1 = trim(AlbedoSetting) )
  1001:                     end if
  1002:                     call SetAlbedoLO(      &
  1003:                       & xy_SurfType,       &
  1004:                       & xy_SurfAlbedoSave  &
  1005:                       & )
  1006:                   else if ( AlbedoSetting == 'generate_internally' ) then
  1007:                     ! データ (デフォルト値) を surface_data モジュールから取得
  1008:                     ! Data (default values) is input from "surface_data" module
  1009:                     ! 
  1010:                     if ( flag_first_SurfAlbedo ) then
  1011:                       call SetSurfData( &
  1012:                         & xy_SurfAlbedo = xy_SurfAlbedoSave  & ! (out)
  1013:                         & )
  1014:                     end if
  1015:                   else
  1016:                     call MessageNotify( 'E', module_name, &
  1017:                       & ' AlbedoSetting = %c is not appropriate.', &
  1018:                       & c1 = trim(AlbedoSetting) )
  1019:                   end if
  1020:                   ! アルベドの設定
  1021:                   ! Setting of albedo
  1022:                   !
  1023: W*===== A         xy_SurfAlbedo = xy_SurfAlbedoSave
  1024:             
  1025:             
  1026:                   if ( present( xy_SurfType ) ) then
  1027:                     ! 雪と海氷によるアルベド変化
  1028:                     ! modification of surface albedo on the snow covered ground and on the sea ice
  1029:                     !
  1030:             
  1031:                     if ( .not. present( xy_SurfMajCompIceB ) ) then
  1032:                       call MessageNotify( 'E', module_name, &
  1033:                         & ' xy_SurfMajCompIceB has to be present to set xy_SurfAlbedo.' )
  1034:                     end if
  1035:                     if ( .not. present( xy_SurfSnowB ) ) then
  1036:                       call MessageNotify( 'E', module_name, &
  1037:                         & ' xy_SurfSnowB has to be present to set xy_SurfAlbedo.' )
  1038:                     end if
  1039:                     if ( .not. present( xy_SeaIceConc ) ) then
  1040:                       call MessageNotify( 'E', module_name, &
  1041:                         & ' xy_SeaIceConc has to be present to set xy_SurfAlbedo.' )
  1042:                     end if
  1043:             
  1044:                     if ( .not. present( xy_SurfType ) ) then
  1045:                       call MessageNotify( 'E', module_name, &
  1046:                         & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
  1047:                     end if
  1048:             !!$        if ( SurfTypeSetting /= 'file' ) then
  1049:             !!$          call MessageNotify( 'E', module_name, &
  1050:             !!$            & " SurfType has to be 'file'." )
  1051:             !!$        end if
  1052:             
  1053:                     call ModAlbedoDueToSnowSeaIce(                                         &
  1054:                       & xy_SurfType,                                                       &
  1055:                       & xy_SurfMajCompIceB, xy_SurfSnowB, xy_SeaIceConc, xy_SOSeaIceMassB, & ! (in   ) optional
  1056:                       & xy_SurfTemp,                                                       & ! (in)
  1057:                       & xy_SurfAlbedo                                                      & ! (inout)
  1058:                       & )
  1059:                   else
  1060:                     call MessageNotify( 'E', module_name, &
  1061:                       & ' xy_SurfType has to be present to modify albedo due to snow and sea ice.' )
  1062:                   end if
  1063:             
  1064:                   FlagSetSurfAlbedo = .true.
  1065:             
  1066:                   flag_first_SurfAlbedo = .false.
  1067:                 end if
  1068:             
  1069:             
  1070:                 ! 惑星表面湿潤度
  1071:                 ! Surface humidity coefficient
  1072:                 !
  1073:                 if ( present(xy_SurfHumidCoef) ) then
  1074:             
  1075:                   ! NOTICE:
  1076:                   ! The surface condition has to be set, before humidity coefficient 
  1077:                   ! is set.
  1078:                   if ( .not. FlagSetSurfCond ) then
  1079:                     call MessageNotify( 'E', module_name, &
  1080:                       & " SurfCond has to be set before setting SurfHumidCoef is set." )
  1081:                   end if
  1082:             
  1083:                   if ( HumidCoefSetting == 'file' ) then
  1084:                     ! データをファイルから取得
  1085:                     ! Data is input from files
  1086:                     !
  1087:                     if ( flag_first_SurfHumidCoef ) then
  1088:                       call HistoryGet( &
  1089:                         & HumidcoefFile, HumidcoefName, &  ! (in)
  1090:                         & xy_SurfHumidcoef, &              ! (out)
  1091:                         & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1092:                     end if
  1093:                   else if ( HumidCoefSetting == 'generate_internally' ) then
  1094:                     ! データ (デフォルト値) を surface_data モジュールから取得
  1095:                     ! Data (default values) is input from "surface_data" module
  1096:                     !
  1097:                     if ( flag_first_SurfHumidCoef ) then
  1098:                       call SetSurfData( &
  1099:                         & xy_SurfHumidCoef = xy_SurfHumidCoef  & ! (out)
  1100:                         & )
  1101:                     end if
  1102:                   else
  1103:                     call MessageNotify( 'E', module_name, &
  1104:                       & ' HumidCoefSetting = %c is not appropriate.', &
  1105:                       & c1 = trim(HumidCoefSetting) )
  1106:                   end if
  1107:             
  1108:                   if ( FlagUseBucket ) then
  1109:                     if ( &
  1110:                       & ( present( xy_SurfType   ) ) .and. &
  1111:                       & ( present( xy_SoilMoistB ) ) .and. &
  1112:                       & ( present( xy_SurfSnowB  ) )       &
  1113:                       & ) then
  1114:                       ! バケツモデルに関わる地表面湿潤度の設定
  1115:                       ! Setting of surface humidity coefficient
  1116:                       !
  1117:                       call BucketSetFlagOceanFromMatthews( &
  1118:                         & xy_SurfType,                     & ! (in)
  1119:                         & xy_BucketFlagOceanGrid           & ! (out)
  1120:                         & )
  1121:                       call BucketModHumidCoef(                                 &
  1122:                         & xy_BucketFlagOceanGrid, xy_SoilMoistB, xy_SurfSnowB, & ! (in   )
  1123:                         & xy_SurfHumidCoef                                     & ! (inout)
  1124:                         & )
  1125:                     else
  1126:                       call MessageNotify( 'E', module_name, &
  1127:                         & ' xy_SurfType, xy_SoilMoistB and xy_SurfSnowB have to be present to modify humidity coefficient with bucket model.' )
  1128:                     end if
  1129:                   end if
  1130:             
  1131:                   FlagSetSurfHumidCoef = .true.
  1132:             
  1133:                   flag_first_SurfHumidCoef = .false.
  1134:                 end if
  1135:             
  1136:             
  1137:                 ! 粗度長
  1138:                 ! Roughness length
  1139:                 !
  1140:                 if ( present(xy_SurfRoughLenMom) ) then
  1141:                   if ( .not. present(xy_SurfRoughLenHeat) ) then
  1142:                     call MessageNotify( 'E', module_name, &
  1143:                       & ' xy_SurfRoughLenHeat has to be present if xy_SurfRoughLenMom is present.' )
  1144:                   end if
  1145:                 else
  1146:                   if ( present(xy_SurfRoughLenHeat) ) then
  1147:                     call MessageNotify( 'E', module_name, &
  1148:                       & ' xy_SurfRoughLenMom has to be present if xy_SurfRoughLenHeat is present.' )
  1149:                   end if
  1150:                 end if
  1151:                 if ( present(xy_SurfRoughLenMom) .and. present(xy_SurfRoughLenHeat) ) then
  1152:             
  1153:                   if ( RoughLengthSetting == 'file' ) then
  1154:                     ! データをファイルから取得
  1155:                     ! Data is input from files
  1156:                     !
  1157:                     if ( flag_first_SurfRoughLen ) then
  1158:                       call HistoryGet( &
  1159:                         & RoughLengthFile, RoughLengthName, & ! (in)
  1160:                         & xy_SurfRoughLenMom, &               ! (out)
  1161:                         & flag_mpi_split = flag_mpi_init )    ! (in) optional
  1162:                       ! set roughness length for heat
  1163: +V===== A             xy_SurfRoughLenHeat = xy_SurfRoughLenMom * RoughLenHeatFactor
  1164:                     end if
  1165:                   else if ( RoughLengthSetting == 'LOContrast' ) then
  1166:                     ! 粗度長の設定, 陸面と海洋の差のみ考慮
  1167:                     ! Set roughness length, only considering land-ocean contrast
  1168:                     !
  1169:                     if ( .not. present( xy_SurfType ) ) then
  1170:                       call MessageNotify( 'E', module_name, &
  1171:                         & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
  1172:                     end if
  1173:                     if ( SurfTypeSetting /= 'file' ) then
  1174:                       call MessageNotify( 'E', module_name, &
  1175:                         & " SurfType has to be 'file', when RoughLengthSetting = %c.", &
  1176:                         & c1 = trim(RoughLengthSetting) )
  1177:                     end if
  1178:                     call SetRoughLenLO(    &
  1179:                       & xy_SurfType,       &
  1180:                       & xy_SurfRoughLenMom &
  1181:                       & )
  1182:                     ! set roughness length for heat
  1183: +V===== A           xy_SurfRoughLenHeat = xy_SurfRoughLenMom * RoughLenHeatFactor
  1184:                   else if ( RoughLengthSetting == 'Matthews' ) then
  1185:                     ! 粗度長の設定, Matthews のデータに基づく
  1186:                     ! Set roughness length based on Matthews dataset
  1187:                     !
  1188:                     if ( .not. FlagSetSurfType ) then
  1189:                       call MessageNotify( 'E', module_name, &
  1190:                         & ' xy_SurfType has to be set to set xy_SurfRoughLenMom.' )
  1191:                     end if
  1192:                     if ( SurfTypeSetting /= 'file' ) then
  1193:                       call MessageNotify( 'E', module_name, &
  1194:                         & " SurfType has to be 'file', when RoughLengthSetting = %c.", &
  1195:                         & c1 = trim(RoughLengthSetting) )
  1196:                     end if
  1197:                     call SetRoughLenLandMatthews( &
  1198:                       & "Mom", xy_SurfType,       &
  1199:                       & xy_SurfRoughLenMom        &
  1200:                       & )
  1201:                     ! Modify albedo due to cultivation
  1202:                     call ModRoughLenMatthewsCultivation(   &
  1203:                       & "Mom", xy_SurfType, xy_SurfCulInt, &
  1204:                       & xy_SurfRoughLenMom                 &
  1205:                       & )
  1206:             
  1207:                     ! set roughness length for heat
  1208:                     call SetRoughLenLandMatthews( &
  1209:                       & "Heat", xy_SurfType,      &
  1210:                       & xy_SurfRoughLenHeat       &
  1211:                       & )
  1212:                     ! Modify albedo due to cultivation
  1213:                     call ModRoughLenMatthewsCultivation(    &
  1214:                       & "Heat", xy_SurfType, xy_SurfCulInt, &
  1215:                       & xy_SurfRoughLenHeat                 &
  1216:                       & )
  1217:             
  1218:                   else if ( RoughLengthSetting == 'generate_internally' ) then
  1219:                     ! データ (デフォルト値) を surface_data モジュールから取得
  1220:                     ! Data (default values) is input from "surface_data" module
  1221:                     !
  1222:                     if ( flag_first_SurfRoughLen ) then
  1223:                       call SetSurfData( &
  1224:                         & xy_SurfRoughLength = xy_SurfRoughLenMom &          ! (out)
  1225:                         & )
  1226:                       ! set roughness length for heat
  1227: +V===== A             xy_SurfRoughLenHeat = xy_SurfRoughLenMom * RoughLenHeatFactor
  1228:                     end if
  1229:                   else
  1230:                     call MessageNotify( 'E', module_name, &
  1231:                       & ' RoughLengthSetting = %c is not appropriate.', &
  1232:                       & c1 = trim(RoughLengthSetting) )
  1233:                   end if
  1234:             
  1235:                   FlagSetSurfRoughLenMom  = .true.
  1236:                   FlagSetSurfRoughLenHeat = .true.
  1237:             
  1238:                   flag_first_SurfRoughLen = .false.
  1239:                 end if
  1240:             
  1241:             
  1242:                 ! 地表熱容量
  1243:                 ! Surface heat capacity
  1244:                 !
  1245:                 if ( present(xy_SurfHeatCapacity) ) then
  1246:             
  1247:                   if ( HeatCapacitySetting == 'file' ) then
  1248:                     ! データをファイルから取得
  1249:                     ! Data is input from files
  1250:                     !
  1251:                     if ( flag_first_SurfHeatCapacity ) then
  1252:                       call HistoryGet( &
  1253:                         & HeatCapacityFile, HeatCapacityName, & ! (in)
  1254:                         & xy_SurfHeatCapacity, &                ! (out)
  1255:                         & flag_mpi_split = flag_mpi_init )      ! (in) optional
  1256:                     end if
  1257:                   else if ( HeatCapacitySetting == 'generate_internally' ) then
  1258:                     ! データ (デフォルト値) を surface_data モジュールから取得
  1259:                     ! Data (default values) is input from "surface_data" module
  1260:                     !
  1261:                     if ( flag_first_SurfHeatCapacity ) then
  1262:                       call SetSurfData( &
  1263:                         & xy_SurfHeatCapacity = xy_SurfHeatCapacity &          ! (out)
  1264:                         & )
  1265:                     end if
  1266:                   else
  1267:                     call MessageNotify( 'E', module_name, &
  1268:                       & ' HeatCapacitySetting = %c is not appropriate.', &
  1269:                       & c1 = trim(HeatCapacitySetting) )
  1270:                   end if
  1271:             
  1272:                   FlagSetSurfHeatCapacity = .true.
  1273:             
  1274:                   flag_first_SurfHeatCapacity = .false.
  1275:                 end if
  1276:             
  1277:             
  1278:                 ! 地中熱フラックス
  1279:                 ! Ground temperature flux
  1280:                 !
  1281:                 if ( present(xy_DeepSubSurfHeatFlux) ) then
  1282:             
  1283:                   if ( TempFluxSetting == 'file' ) then
  1284:                     ! データをファイルから取得
  1285:                     ! Data is input from files
  1286:                     !
  1287:                     if ( flag_first_DeepSubSurfHeatFlux ) then
  1288:                       call HistoryGet( &
  1289:                         & TempFluxFile, TempFluxName, &     ! (in)
  1290:                         & xy_DeepSubSurfHeatFlux, &              ! (out)
  1291:                         & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1292:                     end if
  1293:                   else if ( TempFluxSetting == 'generate_internally' ) then
  1294:                     ! データ (デフォルト値) を surface_data モジュールから取得
  1295:                     ! Data (default values) is input from "surface_data" module
  1296:                     !
  1297:                     if ( flag_first_DeepSubSurfHeatFlux ) then
  1298:                       call SetSurfData( &
  1299:                         & xy_DeepSubSurfHeatFlux = xy_DeepSubSurfHeatFlux &          ! (out)
  1300:                         & )
  1301:                     end if
  1302:                   else
  1303:                     call MessageNotify( 'E', module_name, &
  1304:                       & ' TempFluxSetting = %c is not appropriate.', &
  1305:                       & c1 = trim(TempFluxSetting) )
  1306:                   end if
  1307:             
  1308:                   FlagSetDeepSubSurfHeatFlux = .true.
  1309:             
  1310:                   flag_first_DeepSubSurfHeatFlux = .false.
  1311:                 end if
  1312:             
  1313:             
  1314:                 ! 土壌熱容量 (J K-1 kg-1)
  1315:                 ! Specific heat of soil (J K-1 kg-1)
  1316:                 !
  1317:                 if ( present(xy_SoilHeatCap) ) then
  1318:             
  1319:                   if ( SoilHeatCapSetting == 'file' ) then
  1320:                     ! データをファイルから取得
  1321:                     ! Data is input from files
  1322:                     !
  1323:                     if ( flag_first_SoilHeatCap ) then
  1324:                       call HistoryGet( &
  1325:                         & SoilHeatCapFile, SoilHeatCapName, &     ! (in)
  1326:                         & xy_SoilHeatCap, &              ! (out)
  1327:                         & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1328:                     end if
  1329:                   else if ( SoilHeatCapSetting == 'generate_internally' ) then
  1330:                     ! データ (デフォルト値) を surface_data モジュールから取得
  1331:                     ! Data (default values) is input from "surface_data" module
  1332:                     !
  1333:                     if ( flag_first_SoilHeatCap ) then
  1334:                       call SetSurfData( &
  1335:                         & xy_SoilHeatCap = xy_SoilHeatCap &          ! (out)
  1336:                         & )
  1337:                     end if
  1338:                   else
  1339:                     call MessageNotify( 'E', module_name, &
  1340:                       & ' SoilHeatCapSetting = %c is not appropriate.', &
  1341:                       & c1 = trim(SoilHeatCapSetting) )
  1342:                   end if
  1343:             
  1344:                   FlagSetSoilHeatCap = .true.
  1345:             
  1346:                   flag_first_SoilHeatCap = .false.
  1347:                 end if
  1348:             
  1349:             
  1350:                 ! 土壌熱伝導率 (W m-1 K-1)
  1351:                 ! Heat conduction coefficient of soil (W m-1 K-1)
  1352:                 !
  1353:                 if ( present(xy_SoilHeatDiffCoef) ) then
  1354:             
  1355:                   if ( SoilHeatDiffCoefSetting == 'file' ) then
  1356:                     ! データをファイルから取得
  1357:                     ! Data is input from files
  1358:                     !
  1359:                     if ( flag_first_SoilHeatDiffCoef ) then
  1360:                       call HistoryGet( &
  1361:                         & SoilHeatDiffCoefFile, SoilHeatDiffCoefName, &     ! (in)
  1362:                         & xy_SoilHeatDiffCoef, &              ! (out)
  1363:                         & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1364:                     end if
  1365:                   else if ( SoilHeatDiffCoefSetting == 'file_thermal_inertia' ) then
  1366:                     ! データをファイルから取得
  1367:                     ! Data is input from files
  1368:                     !
  1369:                     if ( flag_first_SoilHeatDiffCoef ) then
  1370:                       call HistoryGet( &
  1371:                         & SoilHeatDiffCoefFile, SoilHeatDiffCoefName, &     ! (in)
  1372:                         & xy_SoilHeatDiffCoef, &              ! (out)
  1373:                         & flag_mpi_split = flag_mpi_init )  ! (in) optional
  1374:             
  1375:                       if ( present( xy_SoilHeatCap ) ) then
  1376: +V===== A               xy_SoilHeatDiffCoef = xy_SoilHeatDiffCoef**2 / xy_SoilHeatCap
  1377:                       else
  1378:                         call MessageNotify( 'E', module_name, &
  1379:                           & ' xy_SoilHeatCap has to be present to calculate heat diffusion coefficient of soil from thermal inertia.' )
  1380:                       end if
  1381:                     end if
  1382:                   else if ( SoilHeatDiffCoefSetting == 'generate_internally' ) then
  1383:                     ! データ (デフォルト値) を surface_data モジュールから取得
  1384:                     ! Data (default values) is input from "surface_data" module
  1385:                     !
  1386:                     if ( flag_first_SoilHeatDiffCoef ) then
  1387:                       call SetSurfData( &
  1388:                         & xy_SoilHeatDiffCoef = xy_SoilHeatDiffCoef &          ! (out)
  1389:                         & )
  1390:                     end if
  1391:                   else if ( SoilHeatDiffCoefSetting == 'simple' ) then
  1392:                     if ( .not. FlagUseBucket ) then
  1393:                       call MessageNotify( 'E', module_name, &
  1394:                         & ' FlagUseBucket has to be .true. to set soil thermal diffusion coefficient.' )
  1395:                     end if
  1396:                     if ( &
  1397:                       & ( FlagSetSurfType          ) .and. &
  1398:                       & ( present( xy_SoilMoistB ) )       &
  1399:                       & ) then
  1400:                       ! 土壌熱伝導係数の設定
  1401:                       ! set soil thermal diffusion coefficient
  1402:                       !
  1403:                       call SetSoilThermDiffCoefSimple( &
  1404:                         & xy_SurfType, xy_SoilMoistB,  & ! (in )
  1405:                         & xy_SoilHeatDiffCoef          & ! (out)
  1406:                         & )
  1407:                     else
  1408:                       call MessageNotify( 'E', module_name, &
  1409:                         & ' xy_SurfType and xy_SoilMoistB have to be present to set soil thermal diffusion coefficient.' )
  1410:                     end if
  1411:                   else
  1412:                     call MessageNotify( 'E', module_name, &
  1413:                       & ' SoilHeatDiffCoefSetting = %c is not appropriate.', &
  1414:                       & c1 = trim(TempFluxSetting) )
  1415:                   end if
  1416:             
  1417:                   FlagSetSoilHeatDiffCoef = .true.
  1418:             
  1419:                   flag_first_SoilHeatDiffCoef = .false.
  1420:                 end if
  1421:             
  1422:             
  1423:                 ! ヒストリデータ出力
  1424:                 ! History data output
  1425:                 !
  1426:                 call HistoryAutoPut( TimeN, 'SurfCulInt', xy_SurfCulInt )
  1427:             
  1428:             
  1429:                 ! 計算時間計測一時停止
  1430:                 ! Pause measurement of computation time
  1431:                 !
  1432:                 call TimesetClockStop( module_name )
  1433:             
  1434:             
  1435:               end subroutine SetSurfaceProperties
  1436:             
  1437:               !--------------------------------------------------------------------------------------
  1438:             
  1439:             !!$  subroutine GroundFileOpen
  1440:             !!$    !
  1441:             !!$    ! 地表面データファイルをオープンします. 
  1442:             !!$    !
  1443:             !!$    ! A ground data file is opened. 
  1444:             !!$    !
  1445:             !!$
  1446:             !!$    ! モジュール引用 ; USE statements
  1447:             !!$    !
  1448:             !!$
  1449:             !!$    ! 出力ファイルの基本情報
  1450:             !!$    ! Basic information for output files
  1451:             !!$    ! 
  1452:             !!$    use fileset, only: &
  1453:             !!$      & FileTitle, &
  1454:             !!$                              ! 出力データファイルの表題.
  1455:             !!$                              ! Title of output data files
  1456:             !!$      & FileSource, &
  1457:             !!$                              ! データファイル作成の手段. 
  1458:             !!$                              ! Source of data file
  1459:             !!$      & FileInstitution
  1460:             !!$                              ! データファイルを最終的に変更した組織/個人. 
  1461:             !!$                              ! Institution or person that changes data files for the last time
  1462:             !!$
  1463:             !!$    ! 物理定数設定
  1464:             !!$    ! Physical constants settings
  1465:             !!$    !
  1466:             !!$    use constants, only: PI   ! $ \pi $ .
  1467:             !!$                              ! 円周率.  Circular constant
  1468:             !!$
  1469:             !!$    ! 座標データ設定
  1470:             !!$    ! Axes data settings
  1471:             !!$    !
  1472:             !!$    use axesset, only: &
  1473:             !!$      & x_Lon, &
  1474:             !!$                              ! $ \lambda $ [rad.] . 経度. Longitude
  1475:             !!$      & x_Lon_Weight, &
  1476:             !!$                              ! $ \Delta \lambda $ [rad.] . 
  1477:             !!$                              ! 経度座標重み. 
  1478:             !!$                              ! Weight of longitude
  1479:             !!$      & y_Lat, &
  1480:             !!$                              ! $ \varphi $ [rad.] . 緯度. Latitude
  1481:             !!$      & y_Lat_Weight, &
  1482:             !!$                              ! $ \Delta \varphi $ [rad.] . 
  1483:             !!$                              ! 緯度座標重み. 
  1484:             !!$                              ! Weight of latitude
  1485:             !!$      & z_Sigma, &
  1486:             !!$                              ! $ \sigma $ レベル (整数). 
  1487:             !!$                              ! Full $ \sigma $ level
  1488:             !!$      & r_Sigma, &
  1489:             !!$                              ! $ \sigma $ レベル (半整数). 
  1490:             !!$                              ! Half $ \sigma $ level
  1491:             !!$      & z_DelSigma
  1492:             !!$                              ! $ \Delta \sigma $ (整数). 
  1493:             !!$                              ! $ \Delta \sigma $ (Full)
  1494:             !!$
  1495:             !!$    ! 時刻管理
  1496:             !!$    ! Time control
  1497:             !!$    !
  1498:             !!$    use timeset, only: &
  1499:             !!$      & DelTime, &            ! $ \Delta t $ [s]
  1500:             !!$      & StartTime, &          ! 計算開始時刻. 
  1501:             !!$                              ! Start time of calculation
  1502:             !!$      & StartDate, &          ! 計算開始日時. 
  1503:             !!$                              ! Start date of calculation
  1504:             !!$      & StartDateValid        ! 計算開始日時の有効性. 
  1505:             !!$                              ! Validation of start date of calculation
  1506:             !!$
  1507:             !!$    ! gtool4 データ出力
  1508:             !!$    ! Gtool4 data output
  1509:             !!$    !
  1510:             !!$    use gtool_history, only: HistoryCreate, HistoryAddVariable, &
  1511:             !!$      & HistoryPut, HistoryAddAttr
  1512:             !!$
  1513:             !!$    ! 文字列操作
  1514:             !!$    ! Character handling
  1515:             !!$    !
  1516:             !!$    use dc_string, only: StoA
  1517:             !!$
  1518:             !!$    ! 日付および時刻の取り扱い
  1519:             !!$    ! Date and time handler
  1520:             !!$    !
  1521:             !!$    use dc_date, only: toChar, EvalByUnit
  1522:             !!$
  1523:             !!$    ! 宣言文 ; Declaration statements
  1524:             !!$    !
  1525:             !!$    implicit none
  1526:             !!$
  1527:             !!$    ! 作業変数
  1528:             !!$    ! Work variables
  1529:             !!$    !
  1530:             !!$    real(DP):: origin_time
  1531:             !!$                              ! 計算開始時刻. 
  1532:             !!$                              ! Start time of calculation
  1533:             !!$
  1534:             !!$    ! 実行文 ; Executable statement
  1535:             !!$    !
  1536:             !!$
  1537:             !!$    ! 初期化
  1538:             !!$    ! Initialization
  1539:             !!$    !
  1540:             !!$    if ( .not. ground_file_io_inited ) call GroundFileInit
  1541:             !!$    if ( ground_file_opened ) return
  1542:             !!$
  1543:             !!$    ! 時刻情報の取得
  1544:             !!$    ! Get time information
  1545:             !!$    !
  1546:             !!$    origin_time = EvalByUnit( StartTime, IntUnit )
  1547:             !!$
  1548:             !!$    ! 地表面データファイルのオープン
  1549:             !!$    ! Open a ground data file
  1550:             !!$    !
  1551:             !!$    call HistoryCreate( &
  1552:             !!$      &      file = OutputFile,   &
  1553:             !!$      &     title = trim(FileTitle) // ' ground data', &          ! (in)
  1554:             !!$      &    source = FileSource, institution = FileInstitution, &   ! (in)
  1555:             !!$      &      dims = StoA( 'lon', 'lat', 'sig', 'sigm', 'time' ), & ! (in)
  1556:             !!$      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 0 /), &         ! (in)
  1557:             !!$      & longnames = StoA( 'longitude', 'latitude', &
  1558:             !!$      &                   'sigma at layer midpoints', &
  1559:             !!$      &                   'sigma at layer end-points (half level)', &
  1560:             !!$      &                   'time' ), &                              ! (in)
  1561:             !!$      &     units = StoA( 'degree_east', 'degree_north', &
  1562:             !!$      &                   '1', '1', IntUnit ), &                   ! (in)
  1563:             !!$      &    origin = real( origin_time ), &                         ! (in)
  1564:             !!$      &  interval = real( IntValue ), &                            ! (in)
  1565:             !!$      &   history = gthst_grd )                                    ! (out)
  1566:             !!$
  1567:             !!$    ! $ \Delta t $ に関する情報を追加
  1568:             !!$    ! Add information about $ \Delta t $
  1569:             !!$    !
  1570:             !!$    call HistoryAddVariable( &
  1571:             !!$      & varname = 'deltime', &            ! (in)
  1572:             !!$      & dims = StoA(''), &                ! (in)
  1573:             !!$      & longname = 'delta time', &        ! (in)
  1574:             !!$      & units = 's', xtype = 'float', &   ! (in)
  1575:             !!$      & history = gthst_grd )             ! (inout)
  1576:             !!$    call HistoryPut( &
  1577:             !!$      & varname = 'deltime', &            ! (in)
  1578:             !!$      & array = (/ DelTime /), &          ! (in)
  1579:             !!$      & history = gthst_grd )             ! (inout)
  1580:             !!$
  1581:             !!$    ! 座標データの設定
  1582:             !!$    ! Axes data settings
  1583:             !!$    !
  1584:             !!$    call HistoryAddAttr( &
  1585:             !!$      & varname = 'lon', attrname = 'standard_name', &   ! (in)
  1586:             !!$      & value = 'longitude', &                           ! (in)
  1587:             !!$      & history = gthst_grd )                            ! (inout)
  1588:             !!$    call HistoryAddAttr( &
  1589:             !!$      & varname = 'lat', attrname = 'standard_name', &   ! (in)
  1590:             !!$      & value = 'latitude', &                            ! (in)
  1591:             !!$      & history = gthst_grd )                            ! (inout)
  1592:             !!$    call HistoryAddAttr( &
  1593:             !!$      & varname = 'sig', attrname = 'standard_name', &   ! (in)
  1594:             !!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
  1595:             !!$      & history = gthst_grd )                            ! (inout)
  1596:             !!$    call HistoryAddAttr( &
  1597:             !!$      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
  1598:             !!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
  1599:             !!$      & history = gthst_grd )                            ! (inout)
  1600:             !!$    call HistoryAddAttr( &
  1601:             !!$      & varname = 'time', attrname = 'standard_name', &  ! (in)
  1602:             !!$      & value = 'time', &                                ! (in)
  1603:             !!$      & history = gthst_grd )                            ! (inout)
  1604:             !!$    call HistoryAddAttr( &
  1605:             !!$      & varname = 'sig', attrname = 'positive', &        ! (in)
  1606:             !!$      & value = 'down', &                                ! (in)
  1607:             !!$      & history = gthst_grd )                            ! (inout)
  1608:             !!$    call HistoryAddAttr( &
  1609:             !!$      & varname = 'sigm', attrname = 'positive', &       ! (in)
  1610:             !!$      & value = 'down', &                                ! (in)
  1611:             !!$      & history = gthst_grd )                            ! (inout)
  1612:             !!$
  1613:             !!$    call HistoryPut( &
  1614:             !!$      & varname = 'lon', &               ! (in)
  1615:             !!$      & array = x_Lon / PI * 180.0_DP, & ! (in)
  1616:             !!$      & history = gthst_grd )            ! (inout)
  1617:             !!$    call HistoryPut( &
  1618:             !!$      & varname = 'lat', &               ! (in)
  1619:             !!$      & array = y_Lat / PI * 180.0_DP, & ! (in)
  1620:             !!$      & history = gthst_grd )            ! (inout)
  1621:             !!$    call HistoryPut( &
  1622:             !!$      & varname = 'sig', &               ! (in)
  1623:             !!$      & array = z_Sigma, &               ! (in)
  1624:             !!$      & history = gthst_grd )            ! (inout)
  1625:             !!$    call HistoryPut( & 
  1626:             !!$      & varname = 'sigm', &              ! (in)
  1627:             !!$      & array = r_Sigma, &               ! (in)
  1628:             !!$      & history = gthst_grd )            ! (inout)
  1629:             !!$
  1630:             !!$    ! 座標重みの設定
  1631:             !!$    ! Axes weights settings
  1632:             !!$    !
  1633:             !!$    call HistoryAddVariable( &
  1634:             !!$      & varname = 'lon_weight', &                           ! (in)
  1635:             !!$      & dims = StoA('lon'), &                               ! (in)
  1636:             !!$      & longname = 'weight for integration in longitude', & ! (in)
  1637:             !!$      & units = 'radian', xtype = 'double', &               ! (in)
  1638:             !!$      & history = gthst_grd )                               ! (inout)
  1639:             !!$    call HistoryAddAttr( &
  1640:             !!$      & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
  1641:             !!$      & value = 'lon_weight', &                             ! (in)
  1642:             !!$      & history = gthst_grd )                               ! (inout)
  1643:             !!$    call HistoryPut( &
  1644:             !!$      & varname = 'lon_weight', array = x_Lon_Weight, &     ! (in)
  1645:             !!$      & history = gthst_grd )                               ! (inout)
  1646:             !!$
  1647:             !!$    call HistoryAddVariable( &
  1648:             !!$      & varname = 'lat_weight', &                           ! (in)
  1649:             !!$      & dims = StoA('lat'), &                               ! (in)
  1650:             !!$      & longname = 'weight for integration in latitude', &  ! (in)
  1651:             !!$      & units = 'radian', xtype = 'double', &               ! (in)
  1652:             !!$      & history = gthst_grd )                               ! (inout)
  1653:             !!$    call HistoryAddAttr( &
  1654:             !!$      & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
  1655:             !!$      & value = 'lat_weight', &                             ! (in)
  1656:             !!$      & history = gthst_grd )                               ! (inout)
  1657:             !!$    call HistoryPut( &
  1658:             !!$      & varname = 'lat_weight', array = y_Lat_Weight, &     ! (in)
  1659:             !!$      & history = gthst_grd )                               ! (inout)
  1660:             !!$
  1661:             !!$    call HistoryAddVariable( &
  1662:             !!$      & varname = 'sig_weight', &                           ! (in)
  1663:             !!$      & dims = StoA('sig'), &                               ! (in)
  1664:             !!$      & longname = 'weight for integration in sigma', &     ! (in)
  1665:             !!$      & units = '1', xtype = 'double', &                    ! (in)
  1666:             !!$      & history = gthst_grd )                               ! (inout)
  1667:             !!$    call HistoryAddAttr( &
  1668:             !!$      & varname = 'sig', attrname = 'gt_calc_weight', &     ! (in)
  1669:             !!$      & value = 'sig_weight', &                             ! (in)
  1670:             !!$      & history = gthst_grd )                               ! (inout)
  1671:             !!$    call HistoryPut( &
  1672:             !!$      & varname = 'sig_weight', array = z_DelSigma, &       ! (in)
  1673:             !!$      & history = gthst_grd )                               ! (inout)
  1674:             !!$
  1675:             !!$    ! 予報変数の設定
  1676:             !!$    ! Predictional variables settings
  1677:             !!$    !
  1678:             !!$    call HistoryAddVariable( &
  1679:             !!$      & varname = 'UB', &                                   ! (in)
  1680:             !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1681:             !!$      & longname = 'eastward wind (at t-\Delta t)', &       ! (in)
  1682:             !!$      & units = 'm s-1', xtype = 'double', &                ! (in)
  1683:             !!$      & history = gthst_grd )                               ! (inout)
  1684:             !!$    call HistoryAddVariable( &
  1685:             !!$      & varname = 'VB', &                                   ! (in)
  1686:             !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1687:             !!$      & longname = 'northward wind (at t-\Delta t)', &      ! (in)
  1688:             !!$      & units = 'm s-1', xtype = 'double', &                ! (in)
  1689:             !!$      & history = gthst_grd )                               ! (inout)
  1690:             !!$    call HistoryAddVariable( &
  1691:             !!$      & varname = 'TempB', &                                ! (in)
  1692:             !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1693:             !!$      & longname = 'temperature (at t-\Delta t)', &         ! (in)
  1694:             !!$      & units = 'K', xtype = 'double', &                    ! (in)
  1695:             !!$      & history = gthst_grd )                               ! (inout)
  1696:             !!$    call HistoryAddVariable( &
  1697:             !!$      & varname = 'QVapB', &                                ! (in)
  1698:             !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1699:             !!$      & longname = 'specific humidity (at t-\Delta t)', &   ! (in)
  1700:             !!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
  1701:             !!$      & history = gthst_grd )                               ! (inout)
  1702:             !!$    call HistoryAddVariable( &
  1703:             !!$      & varname = 'PsB', &                                  ! (in)
  1704:             !!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
  1705:             !!$      & longname = 'surface pressure (at t-\Delta t)', &    ! (in)
  1706:             !!$      & units = 'Pa', xtype = 'double', &                   ! (in)
  1707:             !!$      & history = gthst_grd )                               ! (inout)
  1708:             !!$
  1709:             !!$    call HistoryAddVariable( &
  1710:             !!$      & varname = 'UN', &                                   ! (in)
  1711:             !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1712:             !!$      & longname = 'eastward wind (at t)', &                ! (in)
  1713:             !!$      & units = 'm s-1', xtype = 'double', &                ! (in)
  1714:             !!$      & history = gthst_grd )                               ! (inout)
  1715:             !!$    call HistoryAddVariable( &
  1716:             !!$      & varname = 'VN', &                                   ! (in)
  1717:             !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1718:             !!$      & longname = 'northward wind (at t)', &               ! (in)
  1719:             !!$      & units = 'm s-1', xtype = 'double', &                ! (in)
  1720:             !!$      & history = gthst_grd )                               ! (inout)
  1721:             !!$    call HistoryAddVariable( &
  1722:             !!$      & varname = 'TempN', &                                ! (in)
  1723:             !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1724:             !!$      & longname = 'temperature (at t)', &                  ! (in)
  1725:             !!$      & units = 'K', xtype = 'double', &                    ! (in)
  1726:             !!$      & history = gthst_grd )                               ! (inout)
  1727:             !!$    call HistoryAddVariable( &
  1728:             !!$      & varname = 'QVapN', &                                ! (in)
  1729:             !!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
  1730:             !!$      & longname = 'specific humidity (at t)', &            ! (in)
  1731:             !!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
  1732:             !!$      & history = gthst_grd )                               ! (inout)
  1733:             !!$    call HistoryAddVariable( &
  1734:             !!$      & varname = 'PsN', &                                  ! (in)
  1735:             !!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
  1736:             !!$      & longname = 'surface pressure (at t)', &             ! (in)
  1737:             !!$      & units = 'Pa', xtype = 'double', &                   ! (in)
  1738:             !!$      & history = gthst_grd )                               ! (inout)
  1739:             !!$
  1740:             !!$    ground_file_opened = .true.
  1741:             !!$  end subroutine GroundFileOpen
  1742:             !!$
  1743:             !!$  !-------------------------------------------------------------------
  1744:             !!$
  1745:             !!$  subroutine GroundFileOutput( &
  1746:             !!$    & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
  1747:             !!$    & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  &   ! (in)
  1748:             !!$    & )
  1749:             !!$    !
  1750:             !!$    ! 地表面データの出力を行います. 
  1751:             !!$    !
  1752:             !!$    ! Output ground data
  1753:             !!$
  1754:             !!$    ! モジュール引用 ; USE statements
  1755:             !!$    !
  1756:             !!$
  1757:             !!$    ! gtool4 データ出力
  1758:             !!$    ! Gtool4 data output
  1759:             !!$    !
  1760:             !!$    use gtool_history, only: HistoryPut
  1761:             !!$
  1762:             !!$    ! 時刻管理
  1763:             !!$    ! Time control
  1764:             !!$    !
  1765:             !!$    use timeset, only: TimeN  ! ステップ $ t $ の時刻. 
  1766:             !!$                              ! Time of step $ t $. 
  1767:             !!$
  1768:             !!$    ! 宣言文 ; Declaration statements
  1769:             !!$    !
  1770:             !!$    implicit none
  1771:             !!$    real(DP), intent(in):: xyz_UB  (0:imax-1, 1:jmax, 1:kmax)
  1772:             !!$                              ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
  1773:             !!$    real(DP), intent(in):: xyz_VB  (0:imax-1, 1:jmax, 1:kmax)
  1774:             !!$                              ! $ v (t-\Delta t) $ .   南北風速. Northward wind
  1775:             !!$    real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
  1776:             !!$                              ! $ T (t-\Delta t) $ .   温度. Temperature
  1777:             !!$    real(DP), intent(in):: xyz_QVapB  (0:imax-1, 1:jmax, 1:kmax)
  1778:             !!$                              ! $ q (t-\Delta t) $ .   比湿. Specific humidity
  1779:             !!$    real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
  1780:             !!$                              ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
  1781:             !!$    real(DP), intent(in):: xyz_UN  (0:imax-1, 1:jmax, 1:kmax)
  1782:             !!$                              ! $ u (t) $ .     東西風速. Eastward wind
  1783:             !!$    real(DP), intent(in):: xyz_VN  (0:imax-1, 1:jmax, 1:kmax)
  1784:             !!$                              ! $ v (t) $ .     南北風速. Northward wind
  1785:             !!$    real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
  1786:             !!$                              ! $ T (t) $ .     温度. Temperature
  1787:             !!$    real(DP), intent(in):: xyz_QVapN  (0:imax-1, 1:jmax, 1:kmax)
  1788:             !!$                              ! $ q (t) $ .     比湿. Specific humidity
  1789:             !!$    real(DP), intent(in):: xy_PsN (0:imax-1, 1:jmax)
  1790:             !!$                              ! $ p_s (t) $ .   地表面気圧. Surface pressure
  1791:             !!$
  1792:             !!$    ! 作業変数
  1793:             !!$    ! Work variables
  1794:             !!$    !
  1795:             !!$
  1796:             !!$
  1797:             !!$    ! 実行文 ; Executable statement
  1798:             !!$    !
  1799:             !!$
  1800:             !!$    if ( .not. ground_file_opened ) call GroundFileOpen
  1801:             !!$
  1802:             !!$    ! 出力タイミングのチェック
  1803:             !!$    ! Check output timing
  1804:             !!$    !
  1805:             !!$    if ( TimeN - PrevOutputTime < IntTime ) return
  1806:             !!$    PrevOutputTime = TimeN
  1807:             !!$
  1808:             !!$    ! データ出力
  1809:             !!$    ! Data output
  1810:             !!$    !
  1811:             !!$    call HistoryPut( &
  1812:             !!$      & 'UB', xyz_UB, history = gthst_grd ) ! (in)
  1813:             !!$    call HistoryPut( &
  1814:             !!$      & 'VB', xyz_VB, history = gthst_grd ) ! (in)
  1815:             !!$    call HistoryPut( &
  1816:             !!$      & 'TempB', xyz_TempB, history = gthst_grd ) ! (in)
  1817:             !!$    call HistoryPut( &
  1818:             !!$      & 'QVapB', xyz_QVapB, history = gthst_grd ) ! (in)
  1819:             !!$    call HistoryPut( &
  1820:             !!$      & 'PsB', xy_PsB, history = gthst_grd ) ! (in)
  1821:             !!$
  1822:             !!$    call HistoryPut( &
  1823:             !!$      & 'UN', xyz_UN, history = gthst_grd ) ! (in)
  1824:             !!$    call HistoryPut( &
  1825:             !!$      & 'VN', xyz_VN, history = gthst_grd ) ! (in)
  1826:             !!$    call HistoryPut( &
  1827:             !!$      & 'TempN', xyz_TempN, history = gthst_grd ) ! (in)
  1828:             !!$    call HistoryPut( &
  1829:             !!$      & 'QVapN', xyz_QVapN, history = gthst_grd ) ! (in)
  1830:             !!$    call HistoryPut( &
  1831:             !!$      & 'PsN', xy_PsN, history = gthst_grd ) ! (in)
  1832:             !!$
  1833:             !!$  end subroutine GroundFileOutput
  1834:             !!$
  1835:             !!$  !-------------------------------------------------------------------
  1836:             !!$
  1837:             !!$  subroutine GroundFileClose
  1838:             !!$    !
  1839:             !!$    ! 地表面データファイル出力の終了処理を行います. 
  1840:             !!$    !
  1841:             !!$    ! Terminate ground data files output. 
  1842:             !!$
  1843:             !!$    ! モジュール引用 ; USE statements
  1844:             !!$    !
  1845:             !!$
  1846:             !!$    ! gtool4 データ出力
  1847:             !!$    ! Gtool4 data output
  1848:             !!$    !
  1849:             !!$    use gtool_history, only: HistoryClose
  1850:             !!$
  1851:             !!$    ! 宣言文 ; Declaration statements
  1852:             !!$    !
  1853:             !!$    implicit none
  1854:             !!$
  1855:             !!$    ! 作業変数
  1856:             !!$    ! Work variables
  1857:             !!$    !
  1858:             !!$
  1859:             !!$    ! 実行文 ; Executable statement
  1860:             !!$    !
  1861:             !!$    if ( .not. ground_file_opened ) return
  1862:             !!$
  1863:             !!$    call HistoryClose( history = gthst_grd ) ! (inout)
  1864:             !!$
  1865:             !!$    ground_file_opened = .false.
  1866:             !!$  end subroutine GroundFileClose
  1867:             
  1868:               !--------------------------------------------------------------------------------------
  1869:             
  1870:               subroutine SurfacePropertiesInit(                     &
  1871:                 & ArgFlagSlabOcean, ArgFlagUseBucket, ArgFlagSnow   & ! (in)
  1872:                 & )
  1873:                 !
  1874:                 ! surface_properties モジュールの初期化を行います. 
  1875:                 ! NAMELIST#surface_properties_nml の読み込みはこの手続きで行われます. 
  1876:                 !
  1877:                 ! "surface_properties" module is initialized. 
  1878:                 ! "NAMELIST#surface_properties_nml" is loaded in this procedure. 
  1879:                 !
  1880:             
  1881:                 ! モジュール引用 ; USE statements
  1882:                 !
  1883:             
  1884:                 ! 種別型パラメタ
  1885:                 ! Kind type parameter
  1886:                 !
  1887:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1888:             
  1889:                 ! ファイル入出力補助
  1890:                 ! File I/O support
  1891:                 !
  1892:                 use dc_iounit, only: FileOpen
  1893:             
  1894:                 ! ヒストリデータ出力
  1895:                 ! History data output
  1896:                 !
  1897:                 use gtool_historyauto, only: HistoryAutoAddVariable
  1898:             
  1899:                 ! NAMELIST ファイル入力に関するユーティリティ
  1900:                 ! Utilities for NAMELIST file input
  1901:                 !
  1902:                 use namelist_util, only: namelist_filename, NmlutilMsg
  1903:             
  1904:                 ! 時刻管理
  1905:                 ! Time control
  1906:                 !
  1907:                 use timeset, only: DelTime  ! $ \Delta t $ [s]
  1908:             
  1909:                 !
  1910:                 ! Routines for GABLS tests
  1911:                 !
  1912:                 use gabls, only : GablsInit
  1913:             
  1914:                 ! Matthews のデータに基づく惑星表面アルベド設定
  1915:                 ! set surface albedo based on data by Matthews
  1916:                 !
  1917:                 use albedo_Matthews, only : AlbedoMatthewsInit
  1918:             
  1919:                 ! バケツモデル
  1920:                 ! Bucket model
  1921:                 !
  1922:                 use Bucket_Model, only : BucketModelInit
  1923:             
  1924:                 ! 雪と海氷によるアルベド変化
  1925:                 ! modification of surface albedo on the snow covered ground and on the sea ice
  1926:                 !
  1927:                 use modify_albedo_snowseaice, only : ModAlbedoSnowSeaIceInit
  1928:             
  1929:                 ! アルベド, 粗度長の設定, 陸面と海洋の差のみ考慮
  1930:                 ! Set albedo and roughness length, only considering land-ocean contrast
  1931:                 !
  1932:                 use surface_properties_lo, only : SurfacePropertiesLOInit
  1933:             
  1934:                 ! Matthews のデータに基づく地面粗度の設定
  1935:                 ! set roughness length on land surface based on data by Matthews
  1936:                 !
  1937:                 use roughlen_Matthews, only : RoughLenMatthewsInit
  1938:             
  1939:                 ! 土壌熱伝導係数の設定
  1940:                 ! set soil thermal diffusion coefficient
  1941:                 !
  1942:                 use soil_thermdiffcoef, only : SoilThermDiffCoefInit
  1943:             
  1944:             
  1945:                 ! 宣言文 ; Declaration statements
  1946:                 !
  1947:                 logical, intent(in ) :: ArgFlagSlabOcean
  1948:                                           ! スラブオーシャン オン／オフ.
  1949:                                           ! flag for use of slab ocean on/off
  1950:                 logical, intent(in ) :: ArgFlagUseBucket
  1951:                                           ! 
  1952:                                           ! flag for bucket model
  1953:                 logical, intent(in ) :: ArgFlagSnow
  1954:                                           ! 
  1955:                                           ! flag for snow
  1956:             
  1957:                 ! 作業変数
  1958:                 ! Work variables
  1959:                 !
  1960:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1961:                                           ! Unit number for NAMELIST file open
  1962:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1963:                                           ! IOSTAT of NAMELIST read
  1964:             
  1965:                 ! NAMELIST 変数群
  1966:                 ! NAMELIST group name
  1967:                 !
  1968:                 namelist /surface_properties_nml/ &
  1969:                   & SurfTempSetting,     &
  1970:                   & SurfTempFile,        &
  1971:                   & SurfTempName,        &
  1972:                   & SeaIceSetting,       &
  1973:                   & SeaIceFile,          &
  1974:                   & SeaIceName,          &
  1975:                   & AlbedoSetting,       &
  1976:                   & AlbedoFile,          &
  1977:                   & AlbedoName,          &
  1978:                   & HumidCoefSetting,    &
  1979:                   & HumidCoefFile,       &
  1980:                   & HumidCoefName,       &
  1981:                   & RoughLengthSetting,  &
  1982:                   & RoughLengthFile,     &
  1983:                   & RoughLengthName,     &
  1984:                   & HeatCapacitySetting, &
  1985:                   & HeatCapacityFile,    &
  1986:                   & HeatCapacityName,    &
  1987:                   & TempFluxSetting,     &
  1988:                   & TempFluxFile,        &
  1989:                   & TempFluxName,        &
  1990:                   & SurfCondSetting,     &
  1991:                   & SurfCondFile,        &
  1992:                   & SurfCondName,        &
  1993:                   & SurfTypeSetting,     &
  1994:                   & SurfTypeFile,        &
  1995:                   & SurfTypeName,        &
  1996:                   & SurfCulIntSetting,   &
  1997:                   & SurfCulIntFile,      &
  1998:                   & SurfCulIntName,      &
  1999:                   & SurfHeightSetting,   &
  2000:                   & SurfHeightFile,      &
  2001:                   & SurfHeightName,      &
  2002:                   & SurfHeightStdSetting,&
  2003:                   & SurfHeightStdFile,   &
  2004:                   & SurfHeightStdName,   &
  2005:                   & SoilHeatCapSetting,  &
  2006:                   & SoilHeatCapFile,     &
  2007:                   & SoilHeatCapName,     &
  2008:                   & SoilHeatDiffCoefSetting, &
  2009:                   & SoilHeatDiffCoefFile,    &
  2010:                   & SoilHeatDiffCoefName,    &
  2011:                   & RoughLenHeatFactor
  2012:             
  2013:                       ! デフォルト値については初期化手続 "surface_properties#SurfacePropertiesInit" 
  2014:                       ! のソースコードを参照のこと. 
  2015:                       !
  2016:                       ! Refer to source codes in the initialization procedure
  2017:                       ! "surface_properties#SurfacePropertiesInit" for the default values. 
  2018:                       !
  2019:             
  2020:             !!$      & OutputFile, &
  2021:             !!$      & IntValue, IntUnit
  2022:             
  2023:             
  2024:                 ! 実行文 ; Executable statement
  2025:                 !
  2026:             
  2027:                 if ( surface_properties_inited ) return
  2028:             
  2029:             
  2030:                 ! Set flag for slab ocean
  2031:                 FlagUseBucket = ArgFlagUseBucket
  2032:             
  2033:                 FlagSlabOcean = ArgFlagSlabOcean
  2034:             
  2035:             
  2036:                 ! デフォルト値の設定
  2037:                 ! Default values settings
  2038:                 !
  2039:                 SurfTempSetting         = 'generate_internally'
  2040:                 SurfTempFile            = ''
  2041:                 SurfTempName            = ''
  2042:                 SeaIceSetting           = 'generate_internally'
  2043:                 SeaIceFile              = ''
  2044:                 SeaIceName              = ''
  2045:                 AlbedoSetting           = 'generate_internally'
  2046:                 AlbedoFile              = ''
  2047:                 AlbedoName              = ''
  2048:                 HumidCoefSetting        = 'generate_internally'
  2049:                 HumidCoefFile           = ''
  2050:                 HumidCoefName           = ''
  2051:                 RoughLengthSetting      = 'generate_internally'
  2052:                 RoughLengthFile         = ''
  2053:                 RoughLengthName         = ''
  2054:                 HeatCapacitySetting     = 'generate_internally'
  2055:                 HeatCapacityFile        = ''
  2056:                 HeatCapacityName        = ''
  2057:                 TempFluxSetting         = 'generate_internally'
  2058:                 TempFluxFile            = ''
  2059:                 TempFluxName            = ''
  2060:                 SurfCondSetting         = 'generate_internally'
  2061:                 SurfCondFile            = ''
  2062:                 SurfCondName            = ''
  2063:                 SurfTypeSetting         = 'generate_internally'
  2064:                 SurfTypeFile            = ''
  2065:                 SurfTypeName            = ''
  2066:                 SurfCulIntSetting       = 'generate_internally'
  2067:                 SurfCulIntFile          = ''
  2068:                 SurfCulIntName          = ''
  2069:                 SurfHeightSetting       = 'generate_internally'
  2070:                 SurfHeightFile          = ''
  2071:                 SurfHeightName          = ''
  2072:                 SurfHeightStdSetting    = 'generate_internally'
  2073:                 SurfHeightStdFile       = ''
  2074:                 SurfHeightStdName       = ''
  2075:                 SoilHeatCapSetting      = 'generate_internally'
  2076:                 SoilHeatCapFile         = ''
  2077:                 SoilHeatCapName         = ''
  2078:                 SoilHeatDiffCoefSetting = 'generate_internally'
  2079:                 SoilHeatDiffCoefFile    = ''
  2080:                 SoilHeatDiffCoefName    = ''
  2081:             
  2082:                 RoughLenHeatFactor = 1.0_DP
  2083:             
  2084:             !!$    OutputFile = 'sst.nc'
  2085:             !!$    IntValue   = 1.0_DP
  2086:             !!$    IntUnit    = 'day'
  2087:             
  2088:                 ! NAMELIST の読み込み
  2089:                 ! NAMELIST is input
  2090:                 !
  2091:                 if ( trim(namelist_filename) /= '' ) then
  2092:                   call FileOpen( unit_nml, &          ! (out)
  2093:                     & namelist_filename, mode = 'r' ) ! (in)
  2094:             
  2095:                   rewind( unit_nml )
  2096:                   read( unit_nml,                   &  ! (in)
  2097:                     & nml = surface_properties_nml, &  ! (out)
  2098:                     & iostat = iostat_nml           &  ! (out)
  2099:                     & )
  2100:                   close( unit_nml )
  2101:             
  2102:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2103:                   if ( iostat_nml == 0 ) write( STDOUT, nml = surface_properties_nml )
  2104:                 end if
  2105:             
  2106:             !!$    ! 出力時間間隔の設定
  2107:             !!$    ! Configure time interval of output 
  2108:             !!$    !
  2109:             !!$    call DCDiffTimeCreate( PrevOutputTime, & ! (out)
  2110:             !!$      & sec = 0.0_DP )                       ! (in)
  2111:             !!$    call DCDiffTimeCreate( IntTime, & ! (out)
  2112:             !!$      & IntValue, IntUnit )           ! (in)
  2113:             
  2114:             
  2115:                 ! A Value of "SurfTempSetting" is checked.
  2116:                 !
  2117:                 if ( ( SurfTempSetting == 'file' ) .and. ( FlagSlabOcean ) ) then
  2118:                   call MessageNotify( 'E', module_name, &
  2119:                     & "If FlagSlabOcean is .true., SurfTempSetting must not be 'file'." )
  2120:                 end if
  2121:             
  2122:             
  2123:                 ! Initialization of modules used in this module
  2124:                 !
  2125:             
  2126:                 ! Matthews のデータに基づく惑星表面アルベド設定
  2127:                 ! set surface albedo based on data by Matthews
  2128:                 !
  2129:                 call AlbedoMatthewsInit
  2130:             
  2131:                 if ( FlagUseBucket ) then
  2132:                   ! バケツモデル
  2133:                   ! Bucket model
  2134:                   !
  2135:                   call BucketModelInit( &
  2136:                     & ArgFlagSnow       &
  2137:                     & )
  2138:                 end if
  2139:             
  2140:                 !
  2141:                 ! Routines for GABLS tests
  2142:                 !
  2143:                 call GablsInit
  2144:             
  2145:                 ! 雪と海氷によるアルベド変化
  2146:                 ! modification of surface albedo on the snow covered ground and on the sea ice
  2147:                 !
  2148:                 call ModAlbedoSnowSeaIceInit
  2149:             
  2150:                 ! アルベド, 粗度長の設定, 陸面と海洋の差のみ考慮
  2151:                 ! Set albedo and roughness length, only considering land-ocean contrast
  2152:                 !
  2153:                 call SurfacePropertiesLOInit
  2154:             
  2155:                 ! Matthews のデータに基づく地面粗度の設定
  2156:                 ! set roughness length on land surface based on data by Matthews
  2157:                 !
  2158:                 call RoughLenMatthewsInit
  2159:             
  2160:                 ! 土壌熱伝導係数の設定
  2161:                 ! set soil thermal diffusion coefficient
  2162:                 !
  2163:                 call SoilThermDiffCoefInit( &
  2164:                   & ArgFlagSnow &
  2165:                   & )
  2166:             
  2167:             
  2168:                 ! ヒストリデータ出力のためのへの変数登録
  2169:                 ! Register of variables for history data output
  2170:                 !
  2171:                 call HistoryAutoAddVariable( 'SurfCulInt' , &  ! (in)
  2172:                   & (/ 'lon ', 'lat ', 'time' /),           &  ! (in)
  2173:                   & 'cultivation intensity', '1' )             ! (in)
  2174:             
  2175:             
  2176:                 ! 印字 ; Print
  2177:                 !
  2178:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2179:                 call MessageNotify( 'M', module_name, 'Input:: ' )
  2180:                 call MessageNotify( 'M', module_name, '  SurfTempSetting         = %c', c1 = trim(SurfTempSetting) )
  2181:                 call MessageNotify( 'M', module_name, '  SurfTempFile            = %c', c1 = trim(SurfTempFile) )
  2182:                 call MessageNotify( 'M', module_name, '  SurfTempName            = %c', c1 = trim(SurfTempName        ) )
  2183:                 call MessageNotify( 'M', module_name, '  SeaIceSetting           = %c', c1 = trim(SeaIceSetting) )
  2184:                 call MessageNotify( 'M', module_name, '  SeaIceFile              = %c', c1 = trim(SeaIceFile) )
  2185:                 call MessageNotify( 'M', module_name, '  SeaIceName              = %c', c1 = trim(SeaIceName        ) )
  2186:                 call MessageNotify( 'M', module_name, '  AlbedoSetting           = %c', c1 = trim(AlbedoSetting      ) )
  2187:                 call MessageNotify( 'M', module_name, '  AlbedoFile              = %c', c1 = trim(AlbedoFile      ) )
  2188:                 call MessageNotify( 'M', module_name, '  AlbedoName              = %c', c1 = trim(AlbedoName      ) )
  2189:                 call MessageNotify( 'M', module_name, '  HumidCoefSetting        = %c', c1 = trim(HumidCoefSetting ) )
  2190:                 call MessageNotify( 'M', module_name, '  HumidCoefFile           = %c', c1 = trim(HumidCoefFile  ) )
  2191:                 call MessageNotify( 'M', module_name, '  HumidCoefName           = %c', c1 = trim(HumidCoefName  ) )
  2192:                 call MessageNotify( 'M', module_name, '  RoughLengthSetting      = %c', c1 = trim(RoughLengthSetting ) )
  2193:                 call MessageNotify( 'M', module_name, '  RoughLengthFile         = %c', c1 = trim(RoughLengthFile ) )
  2194:                 call MessageNotify( 'M', module_name, '  RoughLengthName         = %c', c1 = trim(RoughLengthName ) )
  2195:                 call MessageNotify( 'M', module_name, '  HeatCapacitySetting     = %c', c1 = trim(HeatCapacitySetting) )
  2196:                 call MessageNotify( 'M', module_name, '  HeatCapacityFile        = %c', c1 = trim(HeatCapacityFile) )
  2197:                 call MessageNotify( 'M', module_name, '  HeatCapacityName        = %c', c1 = trim(HeatCapacityName) )
  2198:                 call MessageNotify( 'M', module_name, '  TempFluxSetting         = %c', c1 = trim(TempFluxSetting  ) )
  2199:                 call MessageNotify( 'M', module_name, '  TempFluxFile            = %c', c1 = trim(TempFluxFile  ) )
  2200:                 call MessageNotify( 'M', module_name, '  TempFluxName            = %c', c1 = trim(TempFluxName  ) )
  2201:                 call MessageNotify( 'M', module_name, '  SurfCondSetting         = %c', c1 = trim(SurfCondSetting   ) )
  2202:                 call MessageNotify( 'M', module_name, '  SurfCondFile            = %c', c1 = trim(SurfCondFile   ) )
  2203:                 call MessageNotify( 'M', module_name, '  SurfCondName            = %c', c1 = trim(SurfCondName   ) )
  2204:                 call MessageNotify( 'M', module_name, '  SurfTypeSetting         = %c', c1 = trim(SurfTypeSetting   ) )
  2205:                 call MessageNotify( 'M', module_name, '  SurfTypeFile            = %c', c1 = trim(SurfTypeFile   ) )
  2206:                 call MessageNotify( 'M', module_name, '  SurfTypeName            = %c', c1 = trim(SurfTypeName   ) )
  2207:                 call MessageNotify( 'M', module_name, '  SurfCulIntSetting       = %c', c1 = trim(SurfCulIntSetting   ) )
  2208:                 call MessageNotify( 'M', module_name, '  SurfCulIntFile          = %c', c1 = trim(SurfCulIntFile   ) )
  2209:                 call MessageNotify( 'M', module_name, '  SurfCulIntName          = %c', c1 = trim(SurfCulIntName   ) )
  2210:                 call MessageNotify( 'M', module_name, '  SurfHeightSetting       = %c', c1 = trim(SurfHeightSetting   ) )
  2211:                 call MessageNotify( 'M', module_name, '  SurfHeightFile          = %c', c1 = trim(SurfHeightFile   ) )
  2212:                 call MessageNotify( 'M', module_name, '  SurfHeightName          = %c', c1 = trim(SurfHeightName   ) )
  2213:                 call MessageNotify( 'M', module_name, '  SurfHeightStdSetting    = %c', c1 = trim(SurfHeightStdSetting   ) )
  2214:                 call MessageNotify( 'M', module_name, '  SurfHeightStdFile       = %c', c1 = trim(SurfHeightStdFile   ) )
  2215:                 call MessageNotify( 'M', module_name, '  SurfHeightStdName       = %c', c1 = trim(SurfHeightStdName   ) )
  2216:                 call MessageNotify( 'M', module_name, '  SoilHeatCapSetting      = %c', c1 = trim(SoilHeatCapSetting   ) )
  2217:                 call MessageNotify( 'M', module_name, '  SoilHeatCapFile         = %c', c1 = trim(SoilHeatCapFile   ) )
  2218:                 call MessageNotify( 'M', module_name, '  SoilHeatCapName         = %c', c1 = trim(SoilHeatCapName   ) )
  2219:                 call MessageNotify( 'M', module_name, '  SoilHeatDiffCoefSetting = %c', c1 = trim(SoilHeatDiffCoefSetting   ) )
  2220:                 call MessageNotify( 'M', module_name, '  SoilHeatDiffCoefFile    = %c', c1 = trim(SoilHeatDiffCoefFile   ) )
  2221:                 call MessageNotify( 'M', module_name, '  SoilHeatDiffCoefName    = %c', c1 = trim(SoilHeatDiffCoefName   ) )
  2222:             
  2223:                 call MessageNotify( 'M', module_name, '  RoughLenHeatFactor      = %f', d = (/RoughLenHeatFactor/) )
  2224:             
  2225:             
  2226:             !!$    call MessageNotify( 'M', module_name, 'Output:: ' )
  2227:             !!$    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
  2228:             !!$    call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
  2229:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2230:             
  2231:                 surface_properties_inited = .true.
  2232:             
  2233:               end subroutine SurfacePropertiesInit
  2234:             
  2235:               !--------------------------------------------------------------------------------------
  2236:             
  2237:             end module surface_properties
