Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: surface_properties_lo.f90
PROGRAM NAME: surface_properties_lo
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   111  opt  (1593): Loop nest collapsed into one loop.
   111  vec  (   1): Vectorized loop.
   111  vec  (  29): ADB is used for array.: xy_surfalbedo
   111  vec  (  29): ADB is used for array.: xy_surfcond
   166  opt  (1593): Loop nest collapsed into one loop.
   166  vec  (   1): Vectorized loop.
   166  vec  (  29): ADB is used for array.: xy_roughlen
   166  vec  (  29): ADB is used for array.: xy_surfcond
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: surface_properties_lo.f90
PROGRAM NAME: surface_properties_lo
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != アルベド, 粗度長の設定, 陸面と海洋の差のみ考慮
     2  !
     3  != Set surface albedo and roughness length, only considering land-ocean contrast
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: surface_properties_lo.f90,v 1.2 2014/05/07 09:39:23 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module surface_properties_lo
    13  
    14    ! モジュール引用 ; USE statements
    15    !
    16  
    17    ! 種別型パラメタ
    18    ! Kind type parameter
    19    !
    20    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    21      &                 STRING     ! 文字列.       Strings.
    22  
    23    ! メッセージ出力
    24    ! Message output
    25    !
    26    use dc_message, only: MessageNotify
    27  
    28  
    29    ! 宣言文 ; Declaration statements
    30    !
    31    implicit none
    32    private
    33  
    34    ! 公開手続き
    35    ! Public procedure
    36    !
    37    public :: SetAlbedoLO
    38    public :: SetRoughLenLO
    39    public :: SurfacePropertiesLOInit
    40  
    41  
    42    ! 公開変数
    43    ! Public variables
    44    !
    45  
    46    ! 非公開変数
    47    ! Private variables
    48    !
    49    real(DP), save :: AlbedoLand
    50    real(DP), save :: AlbedoOcean
    51    real(DP), save :: RoughLenLand
    52    real(DP), save :: RoughLenOcean
    53  
    54  
    55    logical, save :: surface_properties_lo_inited = .false.
    56                                ! 初期設定フラグ.
    57                                ! Initialization flag
    58  
    59    character(*), parameter:: module_name = 'surface_properties_lo'
    60                                ! モジュールの名称.
    61                                ! Module name
    62    character(*), parameter:: version = &
    63      & '$Name:  $' // &
    64      & '$Id: surface_properties_lo.f90,v 1.2 2014/05/07 09:39:23 murashin Exp $'
    65                                ! モジュールのバージョン
    66                                ! Module version
    67  
    68  
    69  contains
    70  
    71    !--------------------------------------------------------------------------------------
    72  
    73    subroutine SetAlbedoLO( &
    74      & xy_SurfCond,        &
    75      & xy_SurfAlbedo       &
    76      )
    77  
    78      ! モジュール引用 ; USE statements
    79      !
    80  
    81      ! 格子点設定
    82      ! Grid points settings
    83      !
    84      use gridset, only: imax, & ! 経度格子点数.
    85                                 ! Number of grid points in longitude
    86        &                jmax, & ! 緯度格子点数.
    87                                 ! Number of grid points in latitude
    88        &                kmax    ! 鉛直層数.
    89                                 ! Number of vertical level
    90  
    91  
    92      integer , intent(in   ) :: xy_SurfCond  ( 0:imax-1, 1:jmax )
    93      real(DP), intent(inout) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
    94  
    95      ! 作業変数
    96      ! Work variables
    97      !
    98      integer:: i               ! 経度方向に回る DO ループ用作業変数
    99                                ! Work variables for DO loop in longitude
   100      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   101                                ! Work variables for DO loop in latitude
   102  
   103      ! 初期化確認
   104      ! Initialization check
   105      !
   106      if ( .not. surface_properties_lo_inited ) then
   107        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   108      end if
   109  
   110  
   111      do j = 1, jmax
   112        do i = 0, imax-1
   113  
   114          if( xy_SurfCond(i,j) == 0 ) then
   115            xy_SurfAlbedo(i,j) = AlbedoOcean
   116          else
   117            xy_SurfAlbedo(i,j) = AlbedoLand
   118          end if
   119  
   120        end do
   121      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surfcond(j-1,1) .eq. 0) then                            
     .              xy_surfalbedo1 = albedoocean                                
     .           else                                                           
     .              xy_surfalbedo1 = albedoland                                 
     .           endif                                                          
     .           xy_surfalbedo(j-1,1) = xy_surfalbedo1                          
     .        enddo                                                             
   122  
   123  
   124    end subroutine SetAlbedoLO
   125  
   126    !--------------------------------------------------------------------------------------
   127  
   128    subroutine SetRoughLenLO( &
   129      & xy_SurfCond,          &
   130      & xy_RoughLen           &
   131      )
   132  
   133      ! モジュール引用 ; USE statements
   134      !
   135  
   136      ! 格子点設定
   137      ! Grid points settings
   138      !
   139      use gridset, only: imax, & ! 経度格子点数.
   140                                 ! Number of grid points in longitude
   141        &                jmax, & ! 緯度格子点数.
   142                                 ! Number of grid points in latitude
   143        &                kmax    ! 鉛直層数.
   144                                 ! Number of vertical level
   145  
   146  
   147      integer , intent(in   ) :: xy_SurfCond( 0:imax-1, 1:jmax )
   148      real(DP), intent(inout) :: xy_RoughLen( 0:imax-1, 1:jmax )
   149  
   150      ! 作業変数
   151      ! Work variables
   152      !
   153      integer:: i               ! 経度方向に回る DO ループ用作業変数
   154                                ! Work variables for DO loop in longitude
   155      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   156                                ! Work variables for DO loop in latitude
   157  
   158      ! 初期化確認
   159      ! Initialization check
   160      !
   161      if ( .not. surface_properties_lo_inited ) then
   162        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   163      end if
   164  
   165  
   166      do j = 1, jmax
   167        do i = 0, imax-1
   168  
   169          if( xy_SurfCond(i,j) == 0 ) then
   170            xy_RoughLen(i,j) = RoughLenOcean
   171          else
   172            xy_RoughLen(i,j) = RoughLenLand
   173          end if
   174  
   175        end do
   176      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surfcond(j-1,1) .eq. 0) then                            
     .              xy_roughlen1 = roughlenocean                                
     .           else                                                           
     .              xy_roughlen1 = roughlenland                                 
     .           endif                                                          
     .           xy_roughlen(j-1,1) = xy_roughlen1                              
     .        enddo                                                             
   177  
   178  
   179    end subroutine SetRoughLenLO
   180  
   181    !--------------------------------------------------------------------------------------
   182  
   183    subroutine SurfacePropertiesLOInit
   184  
   185      ! モジュール引用 ; USE statements
   186      !
   187  
   188      ! 種別型パラメタ
   189      ! Kind type parameter
   190      !
   191      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   192  
   193      ! ファイル入出力補助
   194      ! File I/O support
   195      !
   196      use dc_iounit, only: FileOpen
   197  
   198      ! NAMELIST ファイル入力に関するユーティリティ
   199      ! Utilities for NAMELIST file input
   200      !
   201      use namelist_util, only: namelist_filename, NmlutilMsg
   202  
   203      ! 作業変数
   204      ! Work variables
   205      !
   206      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   207                                ! Unit number for NAMELIST file open
   208      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   209                                ! IOSTAT of NAMELIST read
   210  
   211      ! NAMELIST 変数群
   212      ! NAMELIST group name
   213      !
   214      namelist /surface_properties_lo_nml/ &
   215        & AlbedoLand,    &
   216        & AlbedoOcean,   &
   217        & RoughLenLand,  &
   218        & RoughLenOcean
   219  
   220            ! デフォルト値については初期化手続 "surface_properties_lo#SurfacePropertiesLOInit"
   221            ! のソースコードを参照のこと.
   222            !
   223            ! Refer to source codes in the initialization procedure
   224            ! "surface_properties_lo#SurfacePropertiesLOInit" for the default values.
   225            !
   226  
   227      if ( surface_properties_lo_inited ) return
   228  
   229  
   230  
   231      ! デフォルト値の設定
   232      ! Default values settings
   233      !
   234  
   235      AlbedoLand    = 0.3_DP
   236      AlbedoOcean   = 0.1_DP
   237      RoughLenLand  = 1.0e-1_DP
   238      RoughLenOcean = 1.0e-4_DP
   239  
   240  
   241      ! NAMELIST の読み込み
   242      ! NAMELIST is input
   243      !
   244      if ( trim(namelist_filename) /= '' ) then
   245        call FileOpen( unit_nml, &          ! (out)
   246          & namelist_filename, mode = 'r' ) ! (in)
   247  
   248        rewind( unit_nml )
   249        read( unit_nml,                   &  ! (in)
   250          & nml = surface_properties_lo_nml, &  ! (out)
   251          & iostat = iostat_nml           &  ! (out)
   252          & )
   253        close( unit_nml )
   254  
   255        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   256        if ( iostat_nml == 0 ) write( STDOUT, nml = surface_properties_lo_nml )
   257      end if
   258  
   259  
   260      ! 印字 ; Print
   261      !
   262      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   263      call MessageNotify( 'M', module_name, 'AlbedoLand    = %f', d = (/ AlbedoLand /) )
   264      call MessageNotify( 'M', module_name, 'AlbedoOcean   = %f', d = (/ AlbedoOcean /) )
   265      call MessageNotify( 'M', module_name, 'RoughLenLand  = %f', d = (/ RoughLenLand /) )
   266      call MessageNotify( 'M', module_name, 'RoughLenOcean = %f', d = (/ RoughLenOcean /) )
   267      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   268  
   269  
   270      surface_properties_lo_inited = .true.
   271  
   272    end subroutine SurfacePropertiesLOInit
   273  
   274    !--------------------------------------------------------------------------------------
   275  
   276  end module surface_properties_lo
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: surface_properties_lo.f90
PROGRAM NAME: 
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   277  warn (   6): Only comment lines in program.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: surface_properties_lo.f90
PROGRAM NAME: 
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

   277  
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:34 2016
FILE NAME: surface_properties_lo.f90
PROGRAM NAME: surface_properties_lo
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != アルベド, 粗度長の設定, 陸面と海洋の差のみ考慮
     2:             !
     3:             != Set surface albedo and roughness length, only considering land-ocean contrast
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: surface_properties_lo.f90,v 1.2 2014/05/07 09:39:23 murashin Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module surface_properties_lo
    13:             
    14:               ! モジュール引用 ; USE statements
    15:               !
    16:             
    17:               ! 種別型パラメタ
    18:               ! Kind type parameter
    19:               !
    20:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    21:                 &                 STRING     ! 文字列.       Strings.
    22:             
    23:               ! メッセージ出力
    24:               ! Message output
    25:               !
    26:               use dc_message, only: MessageNotify
    27:             
    28:             
    29:               ! 宣言文 ; Declaration statements
    30:               !
    31:               implicit none
    32:               private
    33:             
    34:               ! 公開手続き
    35:               ! Public procedure
    36:               !
    37:               public :: SetAlbedoLO
    38:               public :: SetRoughLenLO
    39:               public :: SurfacePropertiesLOInit
    40:             
    41:             
    42:               ! 公開変数
    43:               ! Public variables
    44:               !
    45:             
    46:               ! 非公開変数
    47:               ! Private variables
    48:               !
    49:               real(DP), save :: AlbedoLand
    50:               real(DP), save :: AlbedoOcean
    51:               real(DP), save :: RoughLenLand
    52:               real(DP), save :: RoughLenOcean
    53:             
    54:             
    55:               logical, save :: surface_properties_lo_inited = .false.
    56:                                           ! 初期設定フラグ.
    57:                                           ! Initialization flag
    58:             
    59:               character(*), parameter:: module_name = 'surface_properties_lo'
    60:                                           ! モジュールの名称.
    61:                                           ! Module name
    62:               character(*), parameter:: version = &
    63:                 & '$Name:  $' // &
    64:                 & '$Id: surface_properties_lo.f90,v 1.2 2014/05/07 09:39:23 murashin Exp $'
    65:                                           ! モジュールのバージョン
    66:                                           ! Module version
    67:             
    68:             
    69:             contains
    70:             
    71:               !--------------------------------------------------------------------------------------
    72:             
    73:               subroutine SetAlbedoLO( &
    74:                 & xy_SurfCond,        &
    75:                 & xy_SurfAlbedo       &
    76:                 )
    77:             
    78:                 ! モジュール引用 ; USE statements
    79:                 !
    80:             
    81:                 ! 格子点設定
    82:                 ! Grid points settings
    83:                 !
    84:                 use gridset, only: imax, & ! 経度格子点数.
    85:                                            ! Number of grid points in longitude
    86:                   &                jmax, & ! 緯度格子点数.
    87:                                            ! Number of grid points in latitude
    88:                   &                kmax    ! 鉛直層数.
    89:                                            ! Number of vertical level
    90:             
    91:             
    92:                 integer , intent(in   ) :: xy_SurfCond  ( 0:imax-1, 1:jmax )
    93:                 real(DP), intent(inout) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
    94:             
    95:                 ! 作業変数
    96:                 ! Work variables
    97:                 !
    98:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
    99:                                           ! Work variables for DO loop in longitude
   100:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   101:                                           ! Work variables for DO loop in latitude
   102:             
   103:                 ! 初期化確認
   104:                 ! Initialization check
   105:                 !
   106:                 if ( .not. surface_properties_lo_inited ) then
   107:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   108:                 end if
   109:             
   110:             
   111: W------>        do j = 1, jmax
   112: |*----->          do i = 0, imax-1
   113: ||          
   114: ||      A           if( xy_SurfCond(i,j) == 0 ) then
   115: ||                    xy_SurfAlbedo(i,j) = AlbedoOcean
   116: ||                  else
   117: ||                    xy_SurfAlbedo(i,j) = AlbedoLand
   118: ||                  end if
   119: ||          
   120: |*----- A         end do
   121: W------         end do
   122:             
   123:             
   124:               end subroutine SetAlbedoLO
   125:             
   126:               !--------------------------------------------------------------------------------------
   127:             
   128:               subroutine SetRoughLenLO( &
   129:                 & xy_SurfCond,          &
   130:                 & xy_RoughLen           &
   131:                 )
   132:             
   133:                 ! モジュール引用 ; USE statements
   134:                 !
   135:             
   136:                 ! 格子点設定
   137:                 ! Grid points settings
   138:                 !
   139:                 use gridset, only: imax, & ! 経度格子点数.
   140:                                            ! Number of grid points in longitude
   141:                   &                jmax, & ! 緯度格子点数.
   142:                                            ! Number of grid points in latitude
   143:                   &                kmax    ! 鉛直層数.
   144:                                            ! Number of vertical level
   145:             
   146:             
   147:                 integer , intent(in   ) :: xy_SurfCond( 0:imax-1, 1:jmax )
   148:                 real(DP), intent(inout) :: xy_RoughLen( 0:imax-1, 1:jmax )
   149:             
   150:                 ! 作業変数
   151:                 ! Work variables
   152:                 !
   153:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   154:                                           ! Work variables for DO loop in longitude
   155:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   156:                                           ! Work variables for DO loop in latitude
   157:             
   158:                 ! 初期化確認
   159:                 ! Initialization check
   160:                 !
   161:                 if ( .not. surface_properties_lo_inited ) then
   162:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   163:                 end if
   164:             
   165:             
   166: W------>        do j = 1, jmax
   167: |*----->          do i = 0, imax-1
   168: ||          
   169: ||      A           if( xy_SurfCond(i,j) == 0 ) then
   170: ||                    xy_RoughLen(i,j) = RoughLenOcean
   171: ||                  else
   172: ||                    xy_RoughLen(i,j) = RoughLenLand
   173: ||                  end if
   174: ||          
   175: |*----- A         end do
   176: W------         end do
   177:             
   178:             
   179:               end subroutine SetRoughLenLO
   180:             
   181:               !--------------------------------------------------------------------------------------
   182:             
   183:               subroutine SurfacePropertiesLOInit
   184:             
   185:                 ! モジュール引用 ; USE statements
   186:                 !
   187:             
   188:                 ! 種別型パラメタ
   189:                 ! Kind type parameter
   190:                 !
   191:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   192:             
   193:                 ! ファイル入出力補助
   194:                 ! File I/O support
   195:                 !
   196:                 use dc_iounit, only: FileOpen
   197:             
   198:                 ! NAMELIST ファイル入力に関するユーティリティ
   199:                 ! Utilities for NAMELIST file input
   200:                 !
   201:                 use namelist_util, only: namelist_filename, NmlutilMsg
   202:             
   203:                 ! 作業変数
   204:                 ! Work variables
   205:                 !
   206:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   207:                                           ! Unit number for NAMELIST file open
   208:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   209:                                           ! IOSTAT of NAMELIST read
   210:             
   211:                 ! NAMELIST 変数群
   212:                 ! NAMELIST group name
   213:                 !
   214:                 namelist /surface_properties_lo_nml/ &
   215:                   & AlbedoLand,    &
   216:                   & AlbedoOcean,   &
   217:                   & RoughLenLand,  &
   218:                   & RoughLenOcean
   219:             
   220:                       ! デフォルト値については初期化手続 "surface_properties_lo#SurfacePropertiesLOInit"
   221:                       ! のソースコードを参照のこと.
   222:                       !
   223:                       ! Refer to source codes in the initialization procedure
   224:                       ! "surface_properties_lo#SurfacePropertiesLOInit" for the default values.
   225:                       !
   226:             
   227:                 if ( surface_properties_lo_inited ) return
   228:             
   229:             
   230:             
   231:                 ! デフォルト値の設定
   232:                 ! Default values settings
   233:                 !
   234:             
   235:                 AlbedoLand    = 0.3_DP
   236:                 AlbedoOcean   = 0.1_DP
   237:                 RoughLenLand  = 1.0e-1_DP
   238:                 RoughLenOcean = 1.0e-4_DP
   239:             
   240:             
   241:                 ! NAMELIST の読み込み
   242:                 ! NAMELIST is input
   243:                 !
   244:                 if ( trim(namelist_filename) /= '' ) then
   245:                   call FileOpen( unit_nml, &          ! (out)
   246:                     & namelist_filename, mode = 'r' ) ! (in)
   247:             
   248:                   rewind( unit_nml )
   249:                   read( unit_nml,                   &  ! (in)
   250:                     & nml = surface_properties_lo_nml, &  ! (out)
   251:                     & iostat = iostat_nml           &  ! (out)
   252:                     & )
   253:                   close( unit_nml )
   254:             
   255:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   256:                   if ( iostat_nml == 0 ) write( STDOUT, nml = surface_properties_lo_nml )
   257:                 end if
   258:             
   259:             
   260:                 ! 印字 ; Print
   261:                 !
   262:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   263:                 call MessageNotify( 'M', module_name, 'AlbedoLand    = %f', d = (/ AlbedoLand /) )
   264:                 call MessageNotify( 'M', module_name, 'AlbedoOcean   = %f', d = (/ AlbedoOcean /) )
   265:                 call MessageNotify( 'M', module_name, 'RoughLenLand  = %f', d = (/ RoughLenLand /) )
   266:                 call MessageNotify( 'M', module_name, 'RoughLenOcean = %f', d = (/ RoughLenOcean /) )
   267:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   268:             
   269:             
   270:                 surface_properties_lo_inited = .true.
   271:             
   272:               end subroutine SurfacePropertiesLOInit
   273:             
   274:               !--------------------------------------------------------------------------------------
   275:             
   276:             end module surface_properties_lo
