Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:25 2016
FILE NAME: auxiliary.f90
PROGRAM NAME: auxiliary
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   277  opt  (1593): Loop nest collapsed into one loop.
   277  vec  (   4): Vectorized array expression.
   277  vec  (  29): ADB is used for array.: xy_surfvirtemp
   277  vec  (  29): ADB is used for array.: xyz_qvap
   277  vec  (  29): ADB is used for array.: xy_surftemp
   284  opt  (1593): Loop nest collapsed into one loop.
   284  vec  (   4): Vectorized array expression.
   284  vec  (  29): ADB is used for array.: xyz_virtemp
   284  vec  (  29): ADB is used for array.: xyz_qvap
   284  vec  (  29): ADB is used for array.: xyz_temp
   292  opt  (1592): Outer loop unrolled inside inner loop.
   292  vec  (   4): Vectorized array expression.
   292  vec  (  29): ADB is used for array.: xyz_virtempwork
   292  vec  (  29): ADB is used for array.: xyz_virtemp
   292  vec  (   4): Vectorized array expression.
   292  vec  (  29): ADB is used for array.: xyz_virtempwork
   292  vec  (  29): ADB is used for array.: xyz_virtemp
   294  opt  (1593): Loop nest collapsed into one loop.
   294  vec  (   4): Vectorized array expression.
   294  vec  (  29): ADB is used for array.: xyz_virtempwork
   294  vec  (  29): ADB is used for array.: xyz_qvap
   294  vec  (  29): ADB is used for array.: xyz_temp
   337  opt  (1593): Loop nest collapsed into one loop.
   337  vec  (   4): Vectorized array expression.
   337  vec  (  29): ADB is used for array.: xyz_virtempwork
   337  vec  (  29): ADB is used for array.: xyz_virtemp
   338  opt  (1592): Outer loop unrolled inside inner loop.
   338  vec  (   4): Vectorized array expression.
   338  vec  (  29): ADB is used for array.: xyr_virtempwork
   338  vec  (  29): ADB is used for array.: xyr_virtemp
   338  vec  (   4): Vectorized array expression.
   338  vec  (  29): ADB is used for array.: xyr_virtempwork
   338  vec  (  29): ADB is used for array.: xyr_virtemp
   363  opt  (1593): Loop nest collapsed into one loop.
   363  vec  (   4): Vectorized array expression.
   363  vec  (  29): ADB is used for array.: xyz_height
   363  vec  (  29): ADB is used for array.: xyz_virtempwork
   363  vec  (  29): ADB is used for array.: xy_surfheight
   366  vec  (   3): Unvectorized loop.
   366  vec  (  13): Overhead of loop division is too large.
   367  opt  (1037): Feedback of array elements.
   367  opt  (1593): Loop nest collapsed into one loop.
   367  vec  (   4): Vectorized array expression.
   367  vec  (  29): ADB is used for array.: xyz_height
   367  vec  (  29): ADB is used for array.: xyr_virtempwork
   379  opt  (1592): Outer loop unrolled inside inner loop.
   379  vec  (   4): Vectorized array expression.
   379  vec  (  29): ADB is used for array.: xyz_virtempwork
   379  vec  (  29): ADB is used for array.: xyz_virtemp
   379  vec  (   4): Vectorized array expression.
   379  vec  (  29): ADB is used for array.: xyz_virtempwork
   379  vec  (  29): ADB is used for array.: xyz_virtemp
   393  opt  (1593): Loop nest collapsed into one loop.
   393  vec  (   4): Vectorized array expression.
   393  vec  (  29): ADB is used for array.: xyr_height
   393  vec  (  29): ADB is used for array.: xy_surfheight
   394  vec  (   3): Unvectorized loop.
   394  vec  (  13): Overhead of loop division is too large.
   398  opt  (1037): Feedback of array elements.
   398  opt  (1593): Loop nest collapsed into one loop.
   398  vec  (   4): Vectorized array expression.
   398  vec  (  29): ADB is used for array.: xyr_height
   398  vec  (  29): ADB is used for array.: xyz_virtempwork
   409  opt  (1592): Outer loop unrolled inside inner loop.
   409  vec  (   4): Vectorized array expression.
   409  vec  (  29): ADB is used for array.: xyz_presswork
   409  vec  (  29): ADB is used for array.: xyz_press
   409  vec  (   4): Vectorized array expression.
   409  vec  (  29): ADB is used for array.: xyz_presswork
   409  vec  (  29): ADB is used for array.: xyz_press
   417  opt  (1593): Loop nest collapsed into one loop.
   417  vec  (   4): Vectorized array expression.
   417  vec  (  29): ADB is used for array.: xyz_exner
   417  vec  (  29): ADB is used for array.: xyz_presswork
   423  opt  (1592): Outer loop unrolled inside inner loop.
   423  vec  (   4): Vectorized array expression.
   423  vec  (  29): ADB is used for array.: xyr_presswork
   423  vec  (  29): ADB is used for array.: xyr_press
   423  vec  (   4): Vectorized array expression.
   423  vec  (  29): ADB is used for array.: xyr_presswork
   423  vec  (  29): ADB is used for array.: xyr_press
   431  opt  (1593): Loop nest collapsed into one loop.
   431  vec  (   4): Vectorized array expression.
   431  vec  (  29): ADB is used for array.: xyr_exner
   431  vec  (  29): ADB is used for array.: xyr_presswork
   439  warn (  82): Name "xyr_tempwork" is not used.
   511  vec  (   3): Unvectorized loop.
   511  vec  (  13): Overhead of loop division is too large.
   512  opt  (1593): Loop nest collapsed into one loop.
   512  vec  (   4): Vectorized array expression.
   512  vec  (  29): ADB is used for array.: xyr_temp
   512  vec  (  29): ADB is used for array.: xyz_temp
   516  opt  (  11): Fused array assignments. :line 516 - 517
   516  opt  (1593): Loop nest collapsed into one loop.
   516  vec  (   4): Vectorized array expression.
   516  vec  (  29): ADB is used for array.: xyr_temp
   516  vec  (  29): ADB is used for array.: xyz_temp
   525  vec  (   3): Unvectorized loop.
   525  vec  (  13): Overhead of loop division is too large.
   526  opt  (1593): Loop nest collapsed into one loop.
   526  vec  (   4): Vectorized array expression.
   526  vec  (  29): ADB is used for array.: xyz_press
   526  vec  (  29): ADB is used for array.: xy_ps
   531  vec  (   3): Unvectorized loop.
   531  vec  (  13): Overhead of loop division is too large.
   532  opt  (1593): Loop nest collapsed into one loop.
   532  vec  (   4): Vectorized array expression.
   532  vec  (  29): ADB is used for array.: xyr_press
   532  vec  (  29): ADB is used for array.: xy_ps
   645  vec  (   1): Vectorized loop.
   645  vec  (  29): ADB is used for array.: z_tempinpol
   645  vec  (  29): ADB is used for array.: z_tempinpolm
   645  vec  (  29): ADB is used for array.: z_sigma
   645  vec  (  29): ADB is used for array.: r_sigma
   657  vec  (   4): Vectorized array expression.
   657  vec  (  29): ADB is used for array.: z_tempinpolm
   658  vec  (   4): Vectorized array expression.
   658  vec  (  29): ADB is used for array.: z_tempinpol
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:25 2016
FILE NAME: auxiliary.f90
PROGRAM NAME: auxiliary
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 補助的な変数を計算するサブルーチン・関数群
     2  !
     3  != Subroutines and functions for calculating auxiliary variables
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6  ! Version::   $Id: auxiliary.f90,v 1.18 2015/02/06 11:25:12 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module auxiliary
    13    !
    14    != 補助的な変数を計算するサブルーチン・関数群
    15    !
    16    != Subroutines and functions for calculating auxiliary variables
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! このモジュールでは, 補助的な変数を計算するサブルーチンや関数を提供します.
    21    !
    22    ! This module provides subroutines and functions for calculating auxiliary variables.
    23    !
    24    !== Procedures List
    25    !
    26    ! AuxVars          :: 温度の半整数 $ \sigma $ レベルの補間と
    27    !                     気圧と高度の算出
    28    ! AuxVarsInit      ::
    29    ! AuxVarsFinalize  :: 終了処理 (モジュール内部の変数の割り付け解除)
    30    ! ---------------  :: ---------------
    31    ! AuxVars          :: Interpolate temperature on half $ \sigma $ level,
    32    !                     and calculate pressure and height
    33    ! AuxVarsInit      ::
    34    ! AuxVarsFinalize  :: Termination (deallocate variables in this module)
    35    !
    36    !--
    37    !== NAMELIST
    38    !
    39    ! NAMELIST#auxiliary_nml
    40    !++
    41  
    42    ! モジュール引用 ; USE statements
    43    !
    44  
    45    ! 格子点設定
    46    ! Grid points settings
    47    !
    48    use gridset, only: imax, & ! 経度格子点数.
    49                               ! Number of grid points in longitude
    50      &                jmax, & ! 緯度格子点数.
    51                               ! Number of grid points in latitude
    52      &                kmax    ! 鉛直層数.
    53                               ! Number of vertical level
    54  
    55    ! 種別型パラメタ
    56    ! Kind type parameter
    57    !
    58    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    59      &                 STRING     ! 文字列.       Strings.
    60  
    61    ! メッセージ出力
    62    ! Message output
    63    !
    64    use dc_message, only: MessageNotify
    65  
    66    ! 宣言文 ; Declaration statements
    67    !
    68    implicit none
    69    private
    70  
    71    ! 公開手続き
    72    ! Public procedure
    73    !
    74    public :: AuxVars
    75    public :: AuxVarsFinalize
    76    public :: AuxVarsInit
    77  
    78    ! 公開変数
    79    ! Public variables
    80    !
    81    real(DP), save, public:: RefPress
    82                                ! 基準気圧.
    83                                ! Reference air pressure
    84  
    85    ! 非公開変数
    86    ! Private variables
    87    !
    88    logical, save :: auxiliary_inited = .false.
    89                                ! 初期設定フラグ.
    90                                ! Initialization flag
    91  
    92    real(DP), save, allocatable:: z_TempInpolM (:)
    93                                ! 温度の補間用の係数.
    94                                ! Coefficient for interpolation of temperature
    95    real(DP), save, allocatable:: z_TempInpol (:)
    96                                ! 温度の補間用の係数.
    97                                ! Coefficient for interpolation of temperature
    98  
    99    character(*), parameter:: module_name = 'auxiliary'
   100                                ! モジュールの名称.
   101                                ! Module name
   102    character(*), parameter:: version = &
   103      & '$Name:  $' // &
   104      & '$Id: auxiliary.f90,v 1.18 2015/02/06 11:25:12 yot Exp $'
   105                                ! モジュールのバージョン
   106                                ! Module version
   107  
   108  contains
   109  
   110    !--------------------------------------------------------------------------------------
   111  
   112    recursive subroutine AuxVars(                           &
   113      & xy_Ps, xyz_Temp, xyz_QVap,                          &  ! (in )
   114      & xyr_Temp, xyz_VirTemp, xyr_VirTemp, xy_SurfVirTemp, &  ! (out) optional
   115      & xyz_Press,  xyr_Press,                              &  ! (out) optional
   116      & xy_SurfHeight, xy_SurfTemp,                         &  ! (in ) optional
   117      & xyz_Height, xyr_Height,                             &  ! (out) optional
   118      & xyz_Exner,  xyr_Exner                               &  ! (out) optional
   119      & )
   120      !
   121      ! 温度の半整数σレベルの補間, 気圧と高度の算出,
   122      ! エクスナー関数の計算を行います.
   123      !
   124      ! Interpolate temperature on half sigma level,
   125      ! and calculate pressure and height,
   126      ! and calculate exner function.
   127  
   128      ! モジュール引用 ; USE statements
   129      !
   130  
   131      ! 座標データ設定
   132      ! Axes data settings
   133      !
   134      use axesset, only: &
   135        & z_Sigma, &
   136                                ! $ \sigma $ レベル (整数).
   137                                ! Full $ \sigma $ level
   138        & r_Sigma, &
   139                                ! $ \sigma $ レベル (半整数).
   140                                ! Half $ \sigma $ level
   141        & z_DelSigma, &
   142                                ! $ \Delta \sigma $ (整数).
   143                                ! $ \Delta \sigma $ (Full)
   144        & r_DelSigma
   145                                ! $ \Delta \sigma $ (半整数).
   146                                ! $ \Delta \sigma $ (Half)
   147  
   148      ! 物理定数設定
   149      ! Physical constants settings
   150      !
   151      use constants, only: &
   152        & Grav, &               ! $ g $ [m s-2].
   153                                ! 重力加速度.
   154                                ! Gravitational acceleration
   155        & GasRDry, &
   156                                ! $ R $ [J kg-1 K-1].
   157                                ! 乾燥大気の気体定数.
   158                                ! Gas constant of air
   159        & CpDry, &
   160                                ! $ C_p $ [J kg-1 K-1].
   161                                ! 乾燥大気の定圧比熱.
   162                                ! Specific heat of air at constant pressure
   163        & EpsV
   164                                ! $ \epsilon_v $ .
   165                                ! 水蒸気分子量比.
   166                                ! Molecular weight of water vapor
   167  
   168      ! 時刻管理
   169      ! Time control
   170      !
   171      use timeset, only: TimesetClockStart, TimesetClockStop
   172  
   173      ! 宣言文 ; Declaration statements
   174      !
   175      implicit none
   176  
   177      real(DP), intent(in):: xy_Ps       (0:imax-1, 1:jmax)
   178                                ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   179      real(DP), intent(in):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   180                                ! $ T $ .     温度. Temperature
   181      real(DP), intent(in):: xyz_QVap    (0:imax-1, 1:jmax, 1:kmax)
   182                                ! $ q $ .     比湿. Specific humidity
   183      real(DP), intent(out), optional:: xyr_Temp   (0:imax-1, 1:jmax, 0:kmax)
   184                                ! $ \hat{T} $ . 温度 (半整数レベル).
   185                                ! Temperature (half level)
   186      real(DP), intent(out), optional:: xyz_VirTemp(0:imax-1, 1:jmax, 1:kmax)
   187                                ! $ \hat{T} $ . 仮温度
   188                                ! Virtual temperature
   189      real(DP), intent(out), optional:: xyr_VirTemp(0:imax-1, 1:jmax, 0:kmax)
   190                                ! $ \hat{T} $ . 仮温度 (半整数レベル).
   191                                ! Virtual temperature (half level)
   192      real(DP), intent(out), optional:: xy_SurfVirTemp(0:imax-1, 1:jmax)
   193                                ! $ \hat{T} $ . 仮温度 (惑星表面).
   194                                ! Virtual temperature (surface)
   195      real(DP), intent(out), optional:: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   196                                ! $ p $ . 気圧 (整数レベル).
   197                                ! Air pressure (full level)
   198      real(DP), intent(out), optional:: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
   199                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   200                                ! Air pressure (half level)
   201      real(DP), intent(in ), optional:: xy_SurfHeight(0:imax-1,1:jmax)
   202                                ! $ z_s $ . 地表面高度.
   203                                ! Surface height.
   204      real(DP), intent(in ), optional:: xy_SurfTemp(0:imax-1,1:jmax)
   205                                ! $ T_s $ . 惑星表面温度.
   206                                ! Surface temperature.
   207      real(DP), intent(out), optional:: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   208                                ! 高度 (整数レベル).
   209                                ! Height (full level)
   210      real(DP), intent(out), optional:: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
   211                                ! 高度 (半整数レベル).
   212                                ! Height (half level)
   213      real(DP), intent(out), optional:: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   214                                ! Exner 関数 (整数レベル).
   215                                ! Exner function (full level)
   216      real(DP), intent(out), optional:: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   217                                ! Exner 関数 (半整数レベル).
   218                                ! Exner function (half level)
   219  
   220  
   221      ! 作業変数
   222      ! Work variables
   223      !
   224      real(DP):: xyz_PressWork  (0:imax-1, 1:jmax, 1:kmax)
   225                                ! $ p $ . 気圧 (整数レベル).
   226                                ! Air pressure (full level)
   227      real(DP):: xyr_PressWork  (0:imax-1, 1:jmax, 0:kmax)
   228                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   229                                ! Air pressure (half level)
   230      real(DP):: xyr_TempWork   (0:imax-1, 1:jmax, 0:kmax)
   231                                ! $ \hat{T} $ . 温度 (半整数レベル).
   232                                ! Temperature (half level)
   233      real(DP):: xyz_VirTempWork(0:imax-1, 1:jmax, 1:kmax)
   234                                ! $ T_v $ . 仮温度.
   235                                ! Virtual temperature
   236      real(DP):: xyr_VirTempWork(0:imax-1, 1:jmax, 0:kmax)
   237                                ! $ \hat{T}_v $ . 仮温度 (半整数レベル).
   238                                ! Virtual temperature (half level)
   239  
   240      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   241                                ! Work variables for DO loop in vertical direction
   242  
   243      ! 実行文 ; Executable statement
   244      !
   245  
   246      ! 初期化確認
   247      ! Initialization check
   248      !
   249      if ( .not. auxiliary_inited ) then
   250        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   251      end if
   252  
   253  
   254      ! 計算時間計測開始
   255      ! Start measurement of computation time
   256      !
   257      call TimesetClockStart( module_name )
   258  
   259  
   260      ! 温度の補間
   261      ! Interpolate temperature
   262      !
   263      if ( present( xyr_Temp ) ) then
   264        call AuxVarsInternalRoutine(   &
   265          & xy_Ps,      xyz_Temp,      &  ! (in )
   266          & xyr_Temp = xyr_Temp  &  ! (out) optional
   267          & )
   268      end if
   269  
   270      ! 仮温度の計算
   271      ! Calculate virtual temperature
   272      !
   273      if ( present( xy_SurfVirTemp ) ) then
   274        if ( .not. present( xy_SurfTemp ) ) then
   275          call MessageNotify( 'E', module_name, 'xy_SurfTemp has to be given in arguments to calculate xy_SurfVirTemp.' )
   276        end if
   277        xy_SurfVirTemp = xy_SurfTemp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap(:,:,1) ) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t667 = 1, jmax*imax                                            
     .           xy_surfvirtemp(t667-1,1) = xy_surftemp(t667-1,1)*(             
     .       1      1.00000000000000e+000 + (1.00000000000000e+000/epsv -       
     .       2      1.00000000000000e+000)*xyz_qvap(t667-1,1,1))                
     .        enddo                                                             
   278      end if
   279  
   280      ! 仮温度の計算
   281      ! Calculate virtual temperature
   282      !
   283      if ( present( xyz_VirTemp ) ) then
   284        xyz_VirTemp = xyz_Temp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t652 = 1, kmax*jmax*imax                                       
     .           xyz_virtemp(t652-1,1,1) = xyz_temp(t652-1,1,1)*(               
     .       1      1.00000000000000e+000 + (1.00000000000000e+000/epsv -       
     .       2      1.00000000000000e+000)*xyz_qvap(t652-1,1,1))                
     .        enddo                                                             
   285      end if
   286  
   287      ! 仮温度の補間
   288      ! Interpolate virtual temperature
   289      !
   290      if ( present( xyr_VirTemp ) ) then
   291        if ( present( xyz_VirTemp ) ) then
   292          xyz_VirTempWork = xyz_VirTemp
     .        if (1 + xyz_virtempwork.DSC.U2 - min0(1,xyz_virtempwork.DSC.U2)   
     .       1   .gt. 0) then                                                   
     .           j1 = and(1 + xyz_virtempwork.DSC.U2 - min0(1,                  
     .       1      xyz_virtempwork.DSC.U2),3)                                  
     .  !cdir    nodep                                                          
     .           do t642 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t644 = 1, xyz_virtempwork.DSC.U1 + 2 - min0(1,           
     .       1         xyz_virtempwork.DSC.U1 + 1)                              
     .                 xyz_virtempwork(t644-1,t642,t640+1) = xyz_virtemp(t644-1,
     .       1            t642,t640+1)                                          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t642 = j1 + 1, 1 + xyz_virtempwork.DSC.U2 - min0(1,         
     .       1      xyz_virtempwork.DSC.U2), 4                                  
     .  !cdir       nodep                                                       
     .              do t644 = 1, xyz_virtempwork.DSC.U1 + 2 - min0(1,           
     .       1         xyz_virtempwork.DSC.U1 + 1)                              
     .                 xyz_virtempwork(t644-1,t642,t640+1) = xyz_virtemp(t644-1,
     .       1            t642,t640+1)                                          
     .                 xyz_virtempwork(t644-1,t642+1,t640+1) = xyz_virtemp(t644-
     .       1            1,t642+1,t640+1)                                      
     .                 xyz_virtempwork(t644-1,t642+2,t640+1) = xyz_virtemp(t644-
     .       1            1,t642+2,t640+1)                                      
     .                 xyz_virtempwork(t644-1,t642+3,t640+1) = xyz_virtemp(t644-
     .       1            1,t642+3,t640+1)                                      
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   293        else
   294          xyz_VirTempWork = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t625 = 1, kmax*jmax*imax                                       
     .           xyz_virtempwork(t625-1,1,1) = xyz_temp(t625-1,1,1)*(           
     .       1      1.00000000000000e+000 + (1.00000000000000e+000/epsv -       
     .       2      1.00000000000000e+000)*xyz_qvap(t625-1,1,1))                
     .        enddo                                                             
   295            & xyz_Temp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap) )
   296        end if
   297        call AuxVarsInternalRoutine(   &
   298          & xy_Ps, xyz_VirTempWork,    &  ! (in )
   299          & xyr_Temp = xyr_VirTemp     &  ! (out) optional
   300          & )
   301      end if
   302  
   303      ! 気圧の計算
   304      ! Calculate pressure
   305      !
   306      if ( present( xyz_Press ) ) then
   307        call AuxVarsInternalRoutine(   &
   308          & xy_Ps,      xyz_Temp,      &  ! (in )
   309          & xyz_Press = xyz_Press  &  ! (out) optional
   310          & )
   311      end if
   312  
   313      if ( present( xyr_Press ) ) then
   314        call AuxVarsInternalRoutine(   &
   315          & xy_Ps,      xyz_Temp,      &  ! (in )
   316          & xyr_Press = xyr_Press  &  ! (out) optional
   317          & )
   318      end if
   319  
   320      ! 高度の計算
   321      ! Calculate height
   322      !
   323      if ( present( xyz_Height ) ) then
   324        if ( .not. present( xy_SurfHeight ) ) then
   325          call MessageNotify( 'E', module_name, 'xy_SurfHeight has to be given in arguments to calculate xyz_Height.' )
   326        end if
   327  
   328  !!$      if ( present( xyr_Temp ) ) then
   329  !!$        xyr_TempWork = xyr_Temp
   330  !!$      else
   331  !!$        call AuxVarsInternalRoutine( &
   332  !!$          & xy_Ps, xyz_Temp,         &  ! (in )
   333  !!$          & xyr_Temp = xyr_TempWork  &  ! (out) optional
   334  !!$          & )
   335  !!$      end if
   336        if ( present( xyz_VirTemp ) .and. present( xyr_VirTemp ) ) then
   337          xyz_VirTempWork = xyz_VirTemp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t601 = 1, xyz_virtempwork.DSC.U3*(xyz_virtempwork.DSC.U2*      
     .       1   xyz_virtempwork.DSC.U1 + xyz_virtempwork.DSC.U2)               
     .           xyz_virtempwork(t601-1,1,1) = xyz_virtemp(t601-1,1,1)          
     .        enddo                                                             
   338          xyr_VirTempWork = xyr_VirTemp
     .        if (1 + xyr_virtempwork.DSC.U2 - min0(1,xyr_virtempwork.DSC.U2)   
     .       1   .gt. 0) then                                                   
     .           j2 = and(1 + xyr_virtempwork.DSC.U2 - min0(1,                  
     .       1      xyr_virtempwork.DSC.U2),3)                                  
     .  !cdir    nodep                                                          
     .           do t615 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t617 = 1, xyr_virtempwork.DSC.U1 + 2 - min0(1,           
     .       1         xyr_virtempwork.DSC.U1 + 1)                              
     .                 xyr_virtempwork(t617-1,t615,t613) = xyr_virtemp(t617-1,  
     .       1            t615,t613)                                            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t615 = j2 + 1, 1 + xyr_virtempwork.DSC.U2 - min0(1,         
     .       1      xyr_virtempwork.DSC.U2), 4                                  
     .  !cdir       nodep                                                       
     .              do t617 = 1, xyr_virtempwork.DSC.U1 + 2 - min0(1,           
     .       1         xyr_virtempwork.DSC.U1 + 1)                              
     .                 xyr_virtempwork(t617-1,t615,t613) = xyr_virtemp(t617-1,  
     .       1            t615,t613)                                            
     .                 xyr_virtempwork(t617-1,t615+1,t613) = xyr_virtemp(t617-1,
     .       1            t615+1,t613)                                          
     .                 xyr_virtempwork(t617-1,t615+2,t613) = xyr_virtemp(t617-1,
     .       1            t615+2,t613)                                          
     .                 xyr_virtempwork(t617-1,t615+3,t613) = xyr_virtemp(t617-1,
     .       1            t615+3,t613)                                          
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   339        else
   340          ! 計算時間計測一時停止
   341          ! Pause measurement of computation time
   342          call TimesetClockStop( module_name )
   343          call AuxVars(                      &
   344            & xy_Ps, xyz_Temp, xyz_QVap,     &  ! (in )
   345            & xyz_VirTemp = xyz_VirTempWork, &  ! (out) optional
   346            & xyr_VirTemp = xyr_VirTempWork  &  ! (out) optional
   347            & )
   348          ! 計算時間計測開始
   349          ! Start measurement of computation time
   350          call TimesetClockStart( module_name )
   351        end if
   352  
   353  !!$      xyz_Height(:,:,1) = &
   354  !!$        & xy_SurfHeight(:,:) &
   355  !!$        & + GasRDry / Grav * xyz_Temp(:,:,1) * ( 1. - z_Sigma(1) )
   356  !!$      do k = 2, kmax
   357  !!$        xyz_Height(:,:,k) = &
   358  !!$          &   xyz_Height(:,:,k-1) &
   359  !!$          & + GasRDry / Grav * xyr_TempWork(:,:,k-1) &
   360  !!$          &   * r_DelSigma(k-1) / r_Sigma(k-1)
   361  !!$      end do
   362  
   363        xyz_Height(:,:,1) =                          &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t581 = 1, jmax*imax                                            
     .           xyz_height(t581-1,1,1) = xy_surfheight(t581-1,1) + gasrdry/grav
     .       1      *xyz_virtempwork(t581-1,1,1)*(1.00000000000000e+000 -       
     .       2      z_sigma(1))                                                 
     .        enddo                                                             
   364          & xy_SurfHeight                            &
   365          & + GasRDry / Grav * xyz_VirTempWork(:,:,1) * ( 1.0_DP - z_Sigma(1) )
   366        do k = 2, kmax
   367          xyz_Height(:,:,k) = xyz_Height(:,:,k-1)         &
     .        d1 = r_delsigma(k-1)/r_sigma(k-1)                                 
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t591 = 1, jmax*imax                                            
     .           xyz_height(t591-1,1,k) = xyz_height(t591-1,1,k-1) + gasrdry/   
     .       1      grav*xyr_virtempwork(t591-1,1,k-1)*d1                       
     .        enddo                                                             
   368            & + GasRDry / Grav * xyr_VirTempWork(:,:,k-1) &
   369            &   * r_DelSigma(k-1) / r_Sigma(k-1)
   370        end do
   371      end if
   372  
   373      if ( present( xyr_Height ) ) then
   374        if ( .not. present( xy_SurfHeight ) ) then
   375          call MessageNotify( 'E', module_name, 'xy_SurfHeight has to be given in arguments to calculate xyr_Height.' )
   376        end if
   377  
   378        if ( present( xyz_VirTemp ) ) then
   379          xyz_VirTempWork = xyz_VirTemp
     .        if (1 + xyz_virtempwork.DSC.U2 - min0(1,xyz_virtempwork.DSC.U2)   
     .       1   .gt. 0) then                                                   
     .           j3 = and(1 + xyz_virtempwork.DSC.U2 - min0(1,                  
     .       1      xyz_virtempwork.DSC.U2),3)                                  
     .  !cdir    nodep                                                          
     .           do t571 = 1, j3                                                
     .  !cdir       nodep                                                       
     .              do t573 = 1, xyz_virtempwork.DSC.U1 + 2 - min0(1,           
     .       1         xyz_virtempwork.DSC.U1 + 1)                              
     .                 xyz_virtempwork(t573-1,t571,t569+1) = xyz_virtemp(t573-1,
     .       1            t571,t569+1)                                          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t571 = j3 + 1, 1 + xyz_virtempwork.DSC.U2 - min0(1,         
     .       1      xyz_virtempwork.DSC.U2), 4                                  
     .  !cdir       nodep                                                       
     .              do t573 = 1, xyz_virtempwork.DSC.U1 + 2 - min0(1,           
     .       1         xyz_virtempwork.DSC.U1 + 1)                              
     .                 xyz_virtempwork(t573-1,t571,t569+1) = xyz_virtemp(t573-1,
     .       1            t571,t569+1)                                          
     .                 xyz_virtempwork(t573-1,t571+1,t569+1) = xyz_virtemp(t573-
     .       1            1,t571+1,t569+1)                                      
     .                 xyz_virtempwork(t573-1,t571+2,t569+1) = xyz_virtemp(t573-
     .       1            1,t571+2,t569+1)                                      
     .                 xyz_virtempwork(t573-1,t571+3,t569+1) = xyz_virtemp(t573-
     .       1            1,t571+3,t569+1)                                      
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   380        else
   381          ! 計算時間計測一時停止
   382          ! Pause measurement of computation time
   383          call TimesetClockStop( module_name )
   384          call AuxVars(                      &
   385            & xy_Ps, xyz_Temp, xyz_QVap,     &  ! (in )
   386            & xyz_VirTemp = xyz_VirTempWork  &  ! (out) optional
   387            & )
   388          ! 計算時間計測開始
   389          ! Start measurement of computation time
   390          call TimesetClockStart( module_name )
   391        end if
   392  
   393        xyr_Height(:,:,0) = xy_SurfHeight
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t551 = 1, jmax*imax                                            
     .           xyr_height(t551-1,1,0) = xy_surfheight(t551-1,1)               
     .        enddo                                                             
   394        do k = 1, kmax
   395  !!$        xyr_Height(:,:,k) = xyr_Height(:,:,k-1)        &
   396  !!$          & + GasRDry / Grav * xyz_Temp(:,:,k)     &
   397  !!$          &   * z_DelSigma(k) / z_Sigma(k)
   398          xyr_Height(:,:,k) = xyr_Height(:,:,k-1)        &
     .        d2 = z_delsigma(k)/z_sigma(k)                                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t559 = 1, jmax*imax                                            
     .           xyr_height(t559-1,1,k) = xyr_height(t559-1,1,k-1) + gasrdry/   
     .       1      grav*xyz_virtempwork(t559-1,1,k)*d2                         
     .        enddo                                                             
   399            & + GasRDry / Grav * xyz_VirTempWork(:,:,k)  &
   400            &   * z_DelSigma(k) / z_Sigma(k)
   401        end do
   402      end if
   403  
   404      ! エクスナー関数の計算
   405      ! Calculate exner function
   406      !
   407      if ( present( xyz_Exner ) ) then
   408        if ( present( xyz_Press ) ) then
   409          xyz_PressWork = xyz_Press
     .        if(1+xyz_presswork.DSC.U2-min0(1,xyz_presswork.DSC.U2).gt.0)then  
     .           j4=and(1+xyz_presswork.DSC.U2-min0(1,xyz_presswork.DSC.U2),3)  
     .  !cdir    nodep                                                          
     .           do t541 = 1, j4                                                
     .  !cdir       nodep                                                       
     .              do t543 = 1, xyz_presswork.DSC.U1 + 2 - min0(1,             
     .       1         xyz_presswork.DSC.U1 + 1)                                
     .                 xyz_presswork(t543-1,t541,t539+1) = xyz_press(t543-1,t541
     .       1            ,t539+1)                                              
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t541 = j4 + 1, 1 + xyz_presswork.DSC.U2 - min0(1,           
     .       1      xyz_presswork.DSC.U2), 4                                    
     .  !cdir       nodep                                                       
     .              do t543 = 1, xyz_presswork.DSC.U1 + 2 - min0(1,             
     .       1         xyz_presswork.DSC.U1 + 1)                                
     .                 xyz_presswork(t543-1,t541,t539+1) = xyz_press(t543-1,t541
     .       1            ,t539+1)                                              
     .                 xyz_presswork(t543-1,t541+1,t539+1) = xyz_press(t543-1,  
     .       1            t541+1,t539+1)                                        
     .                 xyz_presswork(t543-1,t541+2,t539+1) = xyz_press(t543-1,  
     .       1            t541+2,t539+1)                                        
     .                 xyz_presswork(t543-1,t541+3,t539+1) = xyz_press(t543-1,  
     .       1            t541+3,t539+1)                                        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   410        else
   411          call AuxVarsInternalRoutine(   &
   412            & xy_Ps,      xyz_Temp,      &  ! (in )
   413            & xyz_Press = xyz_PressWork  &  ! (out) optional
   414            & )
   415        end if
   416  
   417        xyz_Exner = ( xyz_PressWork / RefPress ) ** ( GasRDry / CpDry )
     .        d3 = 1.D0/refpress                                                
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t527 = 1, xyz_presswork.DSC.U3*(xyz_presswork.DSC.U2*          
     .       1   xyz_presswork.DSC.U1 + xyz_presswork.DSC.U2)                   
     .           xyz_exner(t527-1,1,1) = (xyz_presswork(t527-1,1,1)*d3)**(      
     .       1      gasrdry/cpdry)                                              
     .        enddo                                                             
   418      end if
   419  
   420  
   421      if ( present( xyr_Exner ) ) then
   422        if ( present( xyr_Press ) ) then
   423          xyr_PressWork = xyr_Press
     .        if(1+xyr_presswork.DSC.U2-min0(1,xyr_presswork.DSC.U2).gt.0)then  
     .           j5=and(1+xyr_presswork.DSC.U2-min0(1,xyr_presswork.DSC.U2),3)  
     .  !cdir    nodep                                                          
     .           do t517 = 1, j5                                                
     .  !cdir       nodep                                                       
     .              do t519 = 1, xyr_presswork.DSC.U1 + 2 - min0(1,             
     .       1         xyr_presswork.DSC.U1 + 1)                                
     .                 xyr_presswork(t519-1,t517,t515) = xyr_press(t519-1,t517, 
     .       1            t515)                                                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t517 = j5 + 1, 1 + xyr_presswork.DSC.U2 - min0(1,           
     .       1      xyr_presswork.DSC.U2), 4                                    
     .  !cdir       nodep                                                       
     .              do t519 = 1, xyr_presswork.DSC.U1 + 2 - min0(1,             
     .       1         xyr_presswork.DSC.U1 + 1)                                
     .                 xyr_presswork(t519-1,t517,t515) = xyr_press(t519-1,t517, 
     .       1            t515)                                                 
     .                 xyr_presswork(t519-1,t517+1,t515) = xyr_press(t519-1,t517
     .       1            +1,t515)                                              
     .                 xyr_presswork(t519-1,t517+2,t515) = xyr_press(t519-1,t517
     .       1            +2,t515)                                              
     .                 xyr_presswork(t519-1,t517+3,t515) = xyr_press(t519-1,t517
     .       1            +3,t515)                                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   424        else
   425          call AuxVarsInternalRoutine(   &
   426            & xy_Ps,      xyz_Temp,      &  ! (in )
   427            & xyr_Press = xyr_PressWork  &  ! (out) optional
   428            & )
   429        end if
   430  
   431        xyr_Exner = ( xyr_PressWork / RefPress ) ** ( GasRDry / CpDry )
     .        d4 = 1.D0/refpress                                                
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t503 = 1, (xyr_presswork.DSC.U3 + 1)*xyr_presswork.DSC.U2*(    
     .       1   xyr_presswork.DSC.U1 + 1)                                      
     .           xyr_exner(t503-1,1,0) = (xyr_presswork(t503-1,1,0)*d4)**(      
     .       1      gasrdry/cpdry)                                              
     .        enddo                                                             
   432      end if
   433  
   434      ! 計算時間計測一時停止
   435      ! Pause measurement of computation time
   436      !
   437      call TimesetClockStop( module_name )
   438  
   439    end subroutine AuxVars
   440  
   441    !--------------------------------------------------------------------------------------
   442  
   443    subroutine AuxVarsInternalRoutine( &
   444      & xy_Ps,      xyz_Temp,   &  ! (in )
   445      & xyr_Temp,               &  ! (out) optional
   446      & xyz_Press,  xyr_Press   &  ! (out) optional
   447      & )
   448      !
   449      ! 温度の半整数σレベルの補間, 気圧の算出,
   450      ! エクスナー関数の計算を行います.
   451      !
   452      ! Interpolate temperature on half sigma level,
   453      ! and calculate pressure,
   454      ! and calculate exner function.
   455  
   456      ! モジュール引用 ; USE statements
   457      !
   458  
   459      ! 座標データ設定
   460      ! Axes data settings
   461      !
   462      use axesset, only: &
   463        & z_Sigma, &
   464                                ! $ \sigma $ レベル (整数).
   465                                ! Full $ \sigma $ level
   466        & r_Sigma
   467                                ! $ \sigma $ レベル (半整数).
   468                                ! Half $ \sigma $ level
   469  
   470      ! 宣言文 ; Declaration statements
   471      !
   472      implicit none
   473  
   474      real(DP), intent(in):: xy_Ps       (0:imax-1, 1:jmax)
   475                                ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   476      real(DP), intent(in):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   477                                ! $ T $ .     温度. Temperature
   478      real(DP), intent(out), optional:: xyr_Temp   (0:imax-1, 1:jmax, 0:kmax)
   479                                ! $ \hat{T} $ . 温度 (半整数レベル).
   480                                ! Temperature (half level)
   481      real(DP), intent(out), optional:: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   482                                ! $ p $ . 気圧 (整数レベル).
   483                                ! Air pressure (full level)
   484      real(DP), intent(out), optional:: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
   485                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   486                                ! Air pressure (half level)
   487  
   488  
   489      ! 作業変数
   490      ! Work variables
   491      !
   492      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   493                                ! Work variables for DO loop in vertical direction
   494  
   495      ! 実行文 ; Executable statement
   496      !
   497  
   498  
   499      ! 初期化確認
   500      ! Initialization check
   501      !
   502      if ( .not. auxiliary_inited ) then
   503        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   504      end if
   505  
   506  
   507      ! 温度の補間
   508      ! Interpolate temperature
   509      !
   510      if ( present( xyr_Temp ) ) then
   511        do k = 2, kmax
   512          xyr_Temp(:,:,k-1) =   z_TempInpolM(k) * xyz_Temp(:,:,k-1)  &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_temp)                                                  
     .        do t185 = 1, jmax*imax                                            
     .           xyr_temp(t185-1,1,k-1) = z_tempinpolm(k)*xyz_temp(t185-1,1,k-1)
     .       1       + z_tempinpol(k)*xyz_temp(t185-1,1,k)                      
     .        enddo                                                             
   513            &                 + z_TempInpol (k) * xyz_Temp(:,:,k)
   514        end do
   515  
   516        xyr_Temp(:,:,kmax) = xyz_Temp(:,:,kmax)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_temp)                                                  
     .        do t195 = 1, jmax*imax                                            
     .           xyr_temp(t195-1,1,kmax) = xyz_temp(t195-1,1,kmax)              
     .           xyr_temp(t195-1,1,0) = xyz_temp(t195-1,1,1)                    
     .        enddo                                                             
   517        xyr_Temp(:,:,0)    = xyz_Temp(:,:,1)
   518  
   519      end if
   520  
   521      ! 気圧の計算
   522      ! Calculate pressure
   523      !
   524      if ( present( xyz_Press ) ) then
   525        do k = 1, kmax
   526          xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_ps)                                                     
     .        do t177 = 1, jmax*imax                                            
     .           xyz_press(t177-1,1,k) = xy_ps(t177-1,1)*z_sigma(k)             
     .        enddo                                                             
   527        end do
   528      end if
   529  
   530      if ( present( xyr_Press ) ) then
   531        do k = 0, kmax
   532          xyr_Press(:,:,k) = xy_Ps * r_Sigma(k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_ps)                                                     
     .        do t169 = 1, jmax*imax                                            
     .           xyr_press(t169-1,1,k) = xy_ps(t169-1,1)*r_sigma(k)             
     .        enddo                                                             
   533        end do
   534      end if
   535  
   536  
   537    end subroutine AuxVarsInternalRoutine
   538  
   539    !--------------------------------------------------------------------------------------
   540  
   541    subroutine AuxVarsInit
   542      !
   543      ! auxiliary モジュールの初期化を行います.
   544      ! NAMELIST#auxiliary_nml の読み込みはこの手続きで行われます.
   545      !
   546      ! "auxiliary" module is initialized.
   547      ! "NAMELIST#auxiliary_nml" is loaded in this procedure.
   548      !
   549  
   550      ! モジュール引用 ; USE statements
   551      !
   552  
   553      ! 座標データ設定
   554      ! Axes data settings
   555      !
   556      use axesset, only: &
   557        & z_Sigma, &
   558                                ! $ \sigma $ レベル (整数).
   559                                ! Full $ \sigma $ level
   560        & r_Sigma
   561                                ! $ \sigma $ レベル (半整数).
   562                                ! Half $ \sigma $ level
   563  
   564      ! NAMELIST ファイル入力に関するユーティリティ
   565      ! Utilities for NAMELIST file input
   566      !
   567      use namelist_util, only: namelist_filename, NmlutilMsg
   568  
   569      ! ファイル入出力補助
   570      ! File I/O support
   571      !
   572      use dc_iounit, only: FileOpen
   573  
   574      ! 種別型パラメタ
   575      ! Kind type parameter
   576      !
   577      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   578  
   579      ! 文字列操作
   580      ! Character handling
   581      !
   582      use dc_string, only: StoA
   583  
   584      ! 宣言文 ; Declaration statements
   585      !
   586      implicit none
   587  
   588      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   589                                ! Unit number for NAMELIST file open
   590      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   591                                ! IOSTAT of NAMELIST read
   592  
   593      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   594                                ! Work variables for DO loop in vertical direction
   595  
   596      ! NAMELIST 変数群
   597      ! NAMELIST group name
   598      !
   599      namelist /auxiliary_nml/ &
   600        & RefPress
   601            !
   602            ! デフォルト値については初期化手続 "auxiliary#AuxVarsInit"
   603            ! のソースコードを参照のこと.
   604            !
   605            ! Refer to source codes in the initialization procedure
   606            ! "auxiliary#AuxVarsInit" for the default values.
   607            !
   608  
   609      ! 実行文 ; Executable statement
   610      !
   611  
   612      if ( auxiliary_inited ) return
   613  
   614  
   615      ! デフォルト値の設定
   616      ! Default values settings
   617      !
   618      RefPress        =   1.0e5_DP
   619  
   620      ! NAMELIST の読み込み
   621      ! NAMELIST is input
   622      !
   623      if ( trim(namelist_filename) /= '' ) then
   624        call FileOpen( unit_nml, &          ! (out)
   625          & namelist_filename, mode = 'r' ) ! (in)
   626  
   627        rewind( unit_nml )
   628        read( unit_nml, &           ! (in)
   629          & nml = auxiliary_nml, &  ! (out)
   630          & iostat = iostat_nml )   ! (out)
   631        close( unit_nml )
   632  
   633        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   634      end if
   635  
   636      !  補間用の係数の計算
   637      !  Calculate coefficient for interpolation
   638      !
   639      allocate( z_TempInpolM(1:kmax) )
   640      allocate( z_TempInpol(1:kmax) )
   641  
   642      z_TempInpolM(1) = 0.0_DP
   643      z_TempInpol (1) = 0.0_DP
   644  
   645      do k = 2, kmax
   646        z_TempInpolM(k) = &
   647          &    ( log( r_Sigma( k-1 ) ) - log( z_Sigma( k ) ) ) &
   648          &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k ) ) )
   649        z_TempInpol(k) = &
   650          &    ( log( z_Sigma( k-1 ) ) - log( r_Sigma( k-1 ) ) ) &
   651          &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k )   ) )
   652      end  do
   653  
   654      ! 印字 ; Print
   655      !
   656      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   657      call MessageNotify( 'M', module_name, '  z_TempInpolM = %f', d = (/ z_TempInpolM /), n = (/ kmax /) )
   658      call MessageNotify( 'M', module_name, '  z_TempInpol  = %f', d = (/ z_TempInpol  /), n = (/ kmax /) )
   659      call MessageNotify( 'M', module_name, '  RefPress     = %f', d = (/ RefPress /) )
   660      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   661  
   662      auxiliary_inited = .true.
   663  
   664    end subroutine AuxVarsInit
     .        if (auxiliary_inited .ne. 0) goto 10016                           
     .        refpress = 1.00000000000000e+005                                  
     .        call f_null (%0001f9)                                             
     .        call fy_chtrim (%0001f9, %0001f8, namelist_filename, 256)         
     .        t41 = fy_ccompi(3,%0001f9,_?1.auxiliary.auxvarsinit_.Constdecl.29,
     .       1   %0001f8,0)                                                     
     .        deallocate (%0001f9)                                              
     .        if (t41 .eq. 0) goto 10002                                        
     .        call fileopen (unit_nml, namelist_filename, 'r', 1, 256, 1)       
     .        ASSIST_IO_FLAG1 = 159383555                                       
     .        ASSIST_IO_FLAG48 = 32                                             
     .        ASSIST_UNO_INTRL = unit_nml                                       
     .        call f_rwnd                                                       
     .        INIT_IO_FLAG1 = -1450966973                                       
     .        INIT_IO_FLAG2 = 0                                                 
     .        INIT_IO_FLAG48 = 1024                                             
     .        INIT_UNO_INTRL = unit_nml                                         
     .        INIT_IOSTAT_PTR = loc(iostat_nml)                                 
     .        FMT_BEG_PTR = loc(HEADER%ID)                                      
     .        call f_namei                                                      
     .        ASSIST_IO_FLAG1 = 159383555                                       
     .        ASSIST_IO_FLAG2 = 0                                               
     .        ASSIST_IO_FLAG3 = 0                                               
     .        ASSIST_IO_FLAG48 = 32                                             
     .        ASSIST_UNO_INTRL = unit_nml                                       
     .        call f_clos                                                       
     .        call nmlutilmsg (iostat_nml, module_name, 9)                      
     .  10002 continue                                                          
     .        z_tempinpolm.DSC.RANK = 1                                         
     .        z_tempinpolm.DSC.L1 = 1                                           
     .        z_tempinpolm.DSC.U1 = kmax                                        
     .        allocate (z_tempinpolm(z_tempinpolm.DSC.L1:z_tempinpolm.DSC.U1))  
     .        z_tempinpol.DSC.RANK = 1                                          
     .        z_tempinpol.DSC.L1 = 1                                            
     .        z_tempinpol.DSC.U1 = kmax                                         
     .        allocate (z_tempinpol(z_tempinpol.DSC.L1:z_tempinpol.DSC.U1))     
     .        z_tempinpolm(1) = 0.0000000000000000e+000                         
     .        z_tempinpol(1) = 0.0000000000000000e+000                          
     .  !cdir nodep                                                             
     .        do k = 1, kmax - 1                                                
     .           z_tempinpolm(1+k) = ((dlog(r_sigma(k)))-(dlog(z_sigma(1+k))))/(
     .       1      (dlog(z_sigma(k)))-(dlog(z_sigma(1+k))))                    
     .           z_tempinpol(1+k) = ((dlog(z_sigma(k)))-(dlog(r_sigma(k))))/((  
     .       1      dlog(z_sigma(k)))-(dlog(z_sigma(1+k))))                     
     .        enddo                                                             
     .        call messagenotifyc ('M', module_name,                            
     .       1   '----- Initialization Messages -----', 1, 1, 1, 1, 1, 1, 1, 1, 
     .       2   1, 1, 1, 9, 35, 0, 0, 0, 0)                                    
     .        t6 = z_tempinpolm.DSC.L1                                          
     .        t5 = z_tempinpolm.DSC.U1                                          
     .        t142 = t5 - t6 + 1                                                
     .        if (t142 .lt. 0) then                                             
     .           t142 = 0                                                       
     .        else                                                              
     .        endif                                                             
     .        %000205.DSC.U1 = t142                                             
     .        allocate (%000205(1:t142))                                        
     .        t6 = z_tempinpolm.DSC.L1                                          
     .        t5 = z_tempinpolm.DSC.U1                                          
     .        t6 = z_tempinpolm.DSC.L1                                          
     .  !cdir nodep                                                             
     .        do t198 = 0, z_tempinpolm.DSC.U1 - z_tempinpolm.DSC.L1            
     .           %000205(t198+1) = z_tempinpolm(t198+t6)                        
     .        enddo                                                             
     .        %IG0(1) = kmax                                                    
     .        call messagenotifyc ('M', module_name, '  z_TempInpolM = %f', 1, 1
     .       1   , %000205, 1, %IG0, 1, 1, 1, 1, 1, 1, 9, 19, 0, 0, 0, 0)       
     .        deallocate (%000205)                                              
     .        t1 = z_tempinpol.DSC.L1                                           
     .        t0 = z_tempinpol.DSC.U1                                           
     .        t163 = t0 - t1 + 1                                                
     .        if (t163 .lt. 0) then                                             
     .           t163 = 0                                                       
     .        else                                                              
     .        endif                                                             
     .        %000209.DSC.U1 = t163                                             
     .        allocate (%000209(1:t163))                                        
     .        t1 = z_tempinpol.DSC.L1                                           
     .        t0 = z_tempinpol.DSC.U1                                           
     .        t1 = z_tempinpol.DSC.L1                                           
     .  !cdir nodep                                                             
     .        do t202 = 0, z_tempinpol.DSC.U1 - z_tempinpol.DSC.L1              
     .           %000209(t202+1) = z_tempinpol(t202+t1)                         
     .        enddo                                                             
     .        %IG1(1) = kmax                                                    
     .        call messagenotifyc ('M', module_name, '  z_TempInpol  = %f', 1, 1
     .       1   , %000209, 1, %IG1, 1, 1, 1, 1, 1, 1, 9, 19, 0, 0, 0, 0)       
     .        deallocate (%000209)                                              
     .        %IG2(1) = refpress                                                
     .        call messagenotifyc ('M', module_name, '  RefPress     = %f', 1, 1
     .       1   , %IG2, 1, 1, 1, 1, 1, 1, 1, 1, 9, 19, 0, 0, 0, 0)             
     .        call f_null (%00020d)                                             
     .        call fy_chtrim (%00020d, %00020c, version, 64)                    
     .        call messagenotifyc ('M', module_name, '-- version = %c', 1, 1, 1 
     .       1   , 1, 1, %00020d, 1, 1, 1, 1, 1, 9, 15, %00020c, 0, 0, 0)       
     .        deallocate (%00020d)                                              
     .        auxiliary_inited = 1                                              
     .  10016 continue                                                          
   665  
   666    !--------------------------------------------------------------------------------------
   667  
   668    subroutine AuxVarsFinalize
   669      !
   670      ! モジュール内部の変数の割り付け解除を行います.
   671      !
   672      ! Deallocate variables in this module.
   673      !
   674  
   675      ! 宣言文 ; Declaration statements
   676      !
   677      implicit none
   678  
   679      ! 実行文 ; Executable statement
   680      !
   681  
   682      if ( .not. auxiliary_inited ) return
   683  
   684      ! 割り付け解除
   685      ! Deallocation
   686      !
   687      if ( allocated( z_TempInpolM ) ) deallocate( z_TempInpolM )
   688      if ( allocated( z_TempInpol  ) ) deallocate( z_TempInpol  )
   689  
   690      auxiliary_inited = .false.
   691  
   692    end subroutine AuxVarsFinalize
   693  
   694    !--------------------------------------------------------------------------------------
   695  
   696  end module auxiliary
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:25 2016
FILE NAME: auxiliary.f90
PROGRAM NAME: auxiliary
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 補助的な変数を計算するサブルーチン・関数群
     2:             !
     3:             != Subroutines and functions for calculating auxiliary variables
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
     6:             ! Version::   $Id: auxiliary.f90,v 1.18 2015/02/06 11:25:12 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module auxiliary
    13:               !
    14:               != 補助的な変数を計算するサブルーチン・関数群
    15:               !
    16:               != Subroutines and functions for calculating auxiliary variables
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! このモジュールでは, 補助的な変数を計算するサブルーチンや関数を提供します. 
    21:               !
    22:               ! This module provides subroutines and functions for calculating auxiliary variables. 
    23:               !
    24:               !== Procedures List
    25:               !
    26:               ! AuxVars          :: 温度の半整数 $ \sigma $ レベルの補間と
    27:               !                     気圧と高度の算出
    28:               ! AuxVarsInit      ::
    29:               ! AuxVarsFinalize  :: 終了処理 (モジュール内部の変数の割り付け解除)
    30:               ! ---------------  :: ---------------
    31:               ! AuxVars          :: Interpolate temperature on half $ \sigma $ level, 
    32:               !                     and calculate pressure and height
    33:               ! AuxVarsInit      ::
    34:               ! AuxVarsFinalize  :: Termination (deallocate variables in this module)
    35:               !
    36:               !--
    37:               !== NAMELIST
    38:               !
    39:               ! NAMELIST#auxiliary_nml
    40:               !++
    41:             
    42:               ! モジュール引用 ; USE statements
    43:               !
    44:             
    45:               ! 格子点設定
    46:               ! Grid points settings
    47:               !
    48:               use gridset, only: imax, & ! 経度格子点数. 
    49:                                          ! Number of grid points in longitude
    50:                 &                jmax, & ! 緯度格子点数. 
    51:                                          ! Number of grid points in latitude
    52:                 &                kmax    ! 鉛直層数. 
    53:                                          ! Number of vertical level
    54:             
    55:               ! 種別型パラメタ
    56:               ! Kind type parameter
    57:               !
    58:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    59:                 &                 STRING     ! 文字列.       Strings. 
    60:             
    61:               ! メッセージ出力
    62:               ! Message output
    63:               !
    64:               use dc_message, only: MessageNotify
    65:             
    66:               ! 宣言文 ; Declaration statements
    67:               !
    68:               implicit none
    69:               private
    70:             
    71:               ! 公開手続き
    72:               ! Public procedure
    73:               !
    74:               public :: AuxVars
    75:               public :: AuxVarsFinalize
    76:               public :: AuxVarsInit
    77:             
    78:               ! 公開変数
    79:               ! Public variables
    80:               !
    81:               real(DP), save, public:: RefPress
    82:                                           ! 基準気圧. 
    83:                                           ! Reference air pressure
    84:             
    85:               ! 非公開変数
    86:               ! Private variables
    87:               !
    88:               logical, save :: auxiliary_inited = .false.
    89:                                           ! 初期設定フラグ. 
    90:                                           ! Initialization flag
    91:             
    92:               real(DP), save, allocatable:: z_TempInpolM (:)
    93:                                           ! 温度の補間用の係数. 
    94:                                           ! Coefficient for interpolation of temperature
    95:               real(DP), save, allocatable:: z_TempInpol (:)
    96:                                           ! 温度の補間用の係数. 
    97:                                           ! Coefficient for interpolation of temperature
    98:             
    99:               character(*), parameter:: module_name = 'auxiliary'
   100:                                           ! モジュールの名称. 
   101:                                           ! Module name
   102:               character(*), parameter:: version = &
   103:                 & '$Name:  $' // &
   104:                 & '$Id: auxiliary.f90,v 1.18 2015/02/06 11:25:12 yot Exp $'
   105:                                           ! モジュールのバージョン
   106:                                           ! Module version
   107:             
   108:             contains
   109:             
   110:               !--------------------------------------------------------------------------------------
   111:             
   112:               recursive subroutine AuxVars(                           &
   113:                 & xy_Ps, xyz_Temp, xyz_QVap,                          &  ! (in )
   114:                 & xyr_Temp, xyz_VirTemp, xyr_VirTemp, xy_SurfVirTemp, &  ! (out) optional
   115:                 & xyz_Press,  xyr_Press,                              &  ! (out) optional
   116:                 & xy_SurfHeight, xy_SurfTemp,                         &  ! (in ) optional
   117:                 & xyz_Height, xyr_Height,                             &  ! (out) optional
   118:                 & xyz_Exner,  xyr_Exner                               &  ! (out) optional
   119:                 & )
   120:                 !
   121:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出, 
   122:                 ! エクスナー関数の計算を行います. 
   123:                 !
   124:                 ! Interpolate temperature on half sigma level, 
   125:                 ! and calculate pressure and height, 
   126:                 ! and calculate exner function. 
   127:             
   128:                 ! モジュール引用 ; USE statements
   129:                 !
   130:             
   131:                 ! 座標データ設定
   132:                 ! Axes data settings
   133:                 !
   134:                 use axesset, only: &
   135:                   & z_Sigma, &
   136:                                           ! $ \sigma $ レベル (整数). 
   137:                                           ! Full $ \sigma $ level
   138:                   & r_Sigma, &
   139:                                           ! $ \sigma $ レベル (半整数). 
   140:                                           ! Half $ \sigma $ level
   141:                   & z_DelSigma, &
   142:                                           ! $ \Delta \sigma $ (整数). 
   143:                                           ! $ \Delta \sigma $ (Full)
   144:                   & r_DelSigma
   145:                                           ! $ \Delta \sigma $ (半整数). 
   146:                                           ! $ \Delta \sigma $ (Half)
   147:             
   148:                 ! 物理定数設定
   149:                 ! Physical constants settings
   150:                 !
   151:                 use constants, only: &
   152:                   & Grav, &               ! $ g $ [m s-2]. 
   153:                                           ! 重力加速度. 
   154:                                           ! Gravitational acceleration
   155:                   & GasRDry, &
   156:                                           ! $ R $ [J kg-1 K-1]. 
   157:                                           ! 乾燥大気の気体定数. 
   158:                                           ! Gas constant of air
   159:                   & CpDry, &
   160:                                           ! $ C_p $ [J kg-1 K-1]. 
   161:                                           ! 乾燥大気の定圧比熱. 
   162:                                           ! Specific heat of air at constant pressure
   163:                   & EpsV
   164:                                           ! $ \epsilon_v $ .
   165:                                           ! 水蒸気分子量比.
   166:                                           ! Molecular weight of water vapor
   167:             
   168:                 ! 時刻管理
   169:                 ! Time control
   170:                 !
   171:                 use timeset, only: TimesetClockStart, TimesetClockStop
   172:             
   173:                 ! 宣言文 ; Declaration statements
   174:                 !
   175:                 implicit none
   176:             
   177:                 real(DP), intent(in):: xy_Ps       (0:imax-1, 1:jmax)
   178:                                           ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   179:                 real(DP), intent(in):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   180:                                           ! $ T $ .     温度. Temperature
   181:                 real(DP), intent(in):: xyz_QVap    (0:imax-1, 1:jmax, 1:kmax)
   182:                                           ! $ q $ .     比湿. Specific humidity
   183:                 real(DP), intent(out), optional:: xyr_Temp   (0:imax-1, 1:jmax, 0:kmax)
   184:                                           ! $ \hat{T} $ . 温度 (半整数レベル). 
   185:                                           ! Temperature (half level)
   186:                 real(DP), intent(out), optional:: xyz_VirTemp(0:imax-1, 1:jmax, 1:kmax)
   187:                                           ! $ \hat{T} $ . 仮温度
   188:                                           ! Virtual temperature
   189:                 real(DP), intent(out), optional:: xyr_VirTemp(0:imax-1, 1:jmax, 0:kmax)
   190:                                           ! $ \hat{T} $ . 仮温度 (半整数レベル). 
   191:                                           ! Virtual temperature (half level)
   192:                 real(DP), intent(out), optional:: xy_SurfVirTemp(0:imax-1, 1:jmax)
   193:                                           ! $ \hat{T} $ . 仮温度 (惑星表面). 
   194:                                           ! Virtual temperature (surface)
   195:                 real(DP), intent(out), optional:: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   196:                                           ! $ p $ . 気圧 (整数レベル). 
   197:                                           ! Air pressure (full level)
   198:                 real(DP), intent(out), optional:: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
   199:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   200:                                           ! Air pressure (half level)
   201:                 real(DP), intent(in ), optional:: xy_SurfHeight(0:imax-1,1:jmax)
   202:                                           ! $ z_s $ . 地表面高度. 
   203:                                           ! Surface height. 
   204:                 real(DP), intent(in ), optional:: xy_SurfTemp(0:imax-1,1:jmax)
   205:                                           ! $ T_s $ . 惑星表面温度. 
   206:                                           ! Surface temperature. 
   207:                 real(DP), intent(out), optional:: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   208:                                           ! 高度 (整数レベル). 
   209:                                           ! Height (full level)
   210:                 real(DP), intent(out), optional:: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
   211:                                           ! 高度 (半整数レベル). 
   212:                                           ! Height (half level)
   213:                 real(DP), intent(out), optional:: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   214:                                           ! Exner 関数 (整数レベル). 
   215:                                           ! Exner function (full level)
   216:                 real(DP), intent(out), optional:: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   217:                                           ! Exner 関数 (半整数レベル). 
   218:                                           ! Exner function (half level)
   219:             
   220:             
   221:                 ! 作業変数
   222:                 ! Work variables
   223:                 !
   224:                 real(DP):: xyz_PressWork  (0:imax-1, 1:jmax, 1:kmax)
   225:                                           ! $ p $ . 気圧 (整数レベル). 
   226:                                           ! Air pressure (full level)
   227:                 real(DP):: xyr_PressWork  (0:imax-1, 1:jmax, 0:kmax)
   228:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   229:                                           ! Air pressure (half level)
   230:                 real(DP):: xyr_TempWork   (0:imax-1, 1:jmax, 0:kmax)
   231:                                           ! $ \hat{T} $ . 温度 (半整数レベル). 
   232:                                           ! Temperature (half level)
   233:                 real(DP):: xyz_VirTempWork(0:imax-1, 1:jmax, 1:kmax)
   234:                                           ! $ T_v $ . 仮温度.
   235:                                           ! Virtual temperature
   236:                 real(DP):: xyr_VirTempWork(0:imax-1, 1:jmax, 0:kmax)
   237:                                           ! $ \hat{T}_v $ . 仮温度 (半整数レベル). 
   238:                                           ! Virtual temperature (half level)
   239:             
   240:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   241:                                           ! Work variables for DO loop in vertical direction
   242:             
   243:                 ! 実行文 ; Executable statement
   244:                 !
   245:             
   246:                 ! 初期化確認
   247:                 ! Initialization check
   248:                 !
   249:                 if ( .not. auxiliary_inited ) then
   250:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   251:                 end if
   252:             
   253:             
   254:                 ! 計算時間計測開始
   255:                 ! Start measurement of computation time
   256:                 !
   257:                 call TimesetClockStart( module_name )
   258:             
   259:             
   260:                 ! 温度の補間
   261:                 ! Interpolate temperature
   262:                 !
   263:                 if ( present( xyr_Temp ) ) then
   264:                   call AuxVarsInternalRoutine(   &
   265:                     & xy_Ps,      xyz_Temp,      &  ! (in )
   266:                     & xyr_Temp = xyr_Temp  &  ! (out) optional
   267:                     & )
   268:                 end if
   269:             
   270:                 ! 仮温度の計算
   271:                 ! Calculate virtual temperature
   272:                 !
   273:                 if ( present( xy_SurfVirTemp ) ) then
   274:                   if ( .not. present( xy_SurfTemp ) ) then
   275:                     call MessageNotify( 'E', module_name, 'xy_SurfTemp has to be given in arguments to calculate xy_SurfVirTemp.' )
   276:                   end if
   277: W*===== A         xy_SurfVirTemp = xy_SurfTemp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap(:,:,1) ) )
   278:                 end if
   279:             
   280:                 ! 仮温度の計算
   281:                 ! Calculate virtual temperature
   282:                 !
   283:                 if ( present( xyz_VirTemp ) ) then
   284: W**==== A         xyz_VirTemp = xyz_Temp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap) )
   285:                 end if
   286:             
   287:                 ! 仮温度の補間
   288:                 ! Interpolate virtual temperature
   289:                 !
   290:                 if ( present( xyr_VirTemp ) ) then
   291:                   if ( present( xyz_VirTemp ) ) then
   292: ++V==== A           xyz_VirTempWork = xyz_VirTemp
   293:                   else
   294: W**==== A           xyz_VirTempWork = &
   295:                       & xyz_Temp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap) )
   296:                   end if
   297:                   call AuxVarsInternalRoutine(   &
   298:                     & xy_Ps, xyz_VirTempWork,    &  ! (in )
   299:                     & xyr_Temp = xyr_VirTemp     &  ! (out) optional
   300:                     & )
   301:                 end if
   302:             
   303:                 ! 気圧の計算
   304:                 ! Calculate pressure
   305:                 !
   306:                 if ( present( xyz_Press ) ) then
   307:                   call AuxVarsInternalRoutine(   &
   308:                     & xy_Ps,      xyz_Temp,      &  ! (in )
   309:                     & xyz_Press = xyz_Press  &  ! (out) optional
   310:                     & )
   311:                 end if
   312:             
   313:                 if ( present( xyr_Press ) ) then
   314:                   call AuxVarsInternalRoutine(   &
   315:                     & xy_Ps,      xyz_Temp,      &  ! (in )
   316:                     & xyr_Press = xyr_Press  &  ! (out) optional
   317:                     & )
   318:                 end if
   319:             
   320:                 ! 高度の計算
   321:                 ! Calculate height
   322:                 !
   323:                 if ( present( xyz_Height ) ) then
   324:                   if ( .not. present( xy_SurfHeight ) ) then
   325:                     call MessageNotify( 'E', module_name, 'xy_SurfHeight has to be given in arguments to calculate xyz_Height.' )
   326:                   end if
   327:             
   328:             !!$      if ( present( xyr_Temp ) ) then
   329:             !!$        xyr_TempWork = xyr_Temp
   330:             !!$      else
   331:             !!$        call AuxVarsInternalRoutine( &
   332:             !!$          & xy_Ps, xyz_Temp,         &  ! (in )
   333:             !!$          & xyr_Temp = xyr_TempWork  &  ! (out) optional
   334:             !!$          & )
   335:             !!$      end if
   336:                   if ( present( xyz_VirTemp ) .and. present( xyr_VirTemp ) ) then
   337: W**==== A           xyz_VirTempWork = xyz_VirTemp
   338: ++V==== A           xyr_VirTempWork = xyr_VirTemp
   339:                   else
   340:                     ! 計算時間計測一時停止
   341:                     ! Pause measurement of computation time
   342:                     call TimesetClockStop( module_name )
   343:                     call AuxVars(                      &
   344:                       & xy_Ps, xyz_Temp, xyz_QVap,     &  ! (in )
   345:                       & xyz_VirTemp = xyz_VirTempWork, &  ! (out) optional
   346:                       & xyr_VirTemp = xyr_VirTempWork  &  ! (out) optional
   347:                       & )
   348:                     ! 計算時間計測開始
   349:                     ! Start measurement of computation time
   350:                     call TimesetClockStart( module_name )
   351:                   end if
   352:             
   353:             !!$      xyz_Height(:,:,1) = &
   354:             !!$        & xy_SurfHeight(:,:) &
   355:             !!$        & + GasRDry / Grav * xyz_Temp(:,:,1) * ( 1. - z_Sigma(1) )
   356:             !!$      do k = 2, kmax
   357:             !!$        xyz_Height(:,:,k) = &
   358:             !!$          &   xyz_Height(:,:,k-1) &
   359:             !!$          & + GasRDry / Grav * xyr_TempWork(:,:,k-1) &
   360:             !!$          &   * r_DelSigma(k-1) / r_Sigma(k-1)
   361:             !!$      end do
   362:             
   363: W*===== A         xyz_Height(:,:,1) =                          &
   364:                     & xy_SurfHeight                            &
   365:                     & + GasRDry / Grav * xyz_VirTempWork(:,:,1) * ( 1.0_DP - z_Sigma(1) )
   366: +------>          do k = 2, kmax
   367: |W*==== A           xyz_Height(:,:,k) = xyz_Height(:,:,k-1)         &
   368: |                     & + GasRDry / Grav * xyr_VirTempWork(:,:,k-1) &
   369: |                     &   * r_DelSigma(k-1) / r_Sigma(k-1)
   370: +------           end do
   371:                 end if
   372:             
   373:                 if ( present( xyr_Height ) ) then
   374:                   if ( .not. present( xy_SurfHeight ) ) then
   375:                     call MessageNotify( 'E', module_name, 'xy_SurfHeight has to be given in arguments to calculate xyr_Height.' )
   376:                   end if
   377:             
   378:                   if ( present( xyz_VirTemp ) ) then
   379: ++V==== A           xyz_VirTempWork = xyz_VirTemp
   380:                   else
   381:                     ! 計算時間計測一時停止
   382:                     ! Pause measurement of computation time
   383:                     call TimesetClockStop( module_name )
   384:                     call AuxVars(                      &
   385:                       & xy_Ps, xyz_Temp, xyz_QVap,     &  ! (in )
   386:                       & xyz_VirTemp = xyz_VirTempWork  &  ! (out) optional
   387:                       & )
   388:                     ! 計算時間計測開始
   389:                     ! Start measurement of computation time
   390:                     call TimesetClockStart( module_name )
   391:                   end if
   392:             
   393: W*===== A         xyr_Height(:,:,0) = xy_SurfHeight
   394: +------>          do k = 1, kmax
   395: |           !!$        xyr_Height(:,:,k) = xyr_Height(:,:,k-1)        &
   396: |           !!$          & + GasRDry / Grav * xyz_Temp(:,:,k)     &
   397: |           !!$          &   * z_DelSigma(k) / z_Sigma(k)
   398: |W*==== A           xyr_Height(:,:,k) = xyr_Height(:,:,k-1)        &
   399: |                     & + GasRDry / Grav * xyz_VirTempWork(:,:,k)  &
   400: |                     &   * z_DelSigma(k) / z_Sigma(k)
   401: +------           end do
   402:                 end if
   403:             
   404:                 ! エクスナー関数の計算
   405:                 ! Calculate exner function
   406:                 !
   407:                 if ( present( xyz_Exner ) ) then
   408:                   if ( present( xyz_Press ) ) then
   409: ++V==== A           xyz_PressWork = xyz_Press
   410:                   else
   411:                     call AuxVarsInternalRoutine(   &
   412:                       & xy_Ps,      xyz_Temp,      &  ! (in )
   413:                       & xyz_Press = xyz_PressWork  &  ! (out) optional
   414:                       & )
   415:                   end if
   416:             
   417: W**==== A         xyz_Exner = ( xyz_PressWork / RefPress ) ** ( GasRDry / CpDry )
   418:                 end if
   419:             
   420:             
   421:                 if ( present( xyr_Exner ) ) then
   422:                   if ( present( xyr_Press ) ) then
   423: ++V==== A           xyr_PressWork = xyr_Press
   424:                   else
   425:                     call AuxVarsInternalRoutine(   &
   426:                       & xy_Ps,      xyz_Temp,      &  ! (in )
   427:                       & xyr_Press = xyr_PressWork  &  ! (out) optional
   428:                       & )
   429:                   end if
   430:             
   431: W**==== A         xyr_Exner = ( xyr_PressWork / RefPress ) ** ( GasRDry / CpDry )
   432:                 end if
   433:             
   434:                 ! 計算時間計測一時停止
   435:                 ! Pause measurement of computation time
   436:                 !
   437:                 call TimesetClockStop( module_name )
   438:             
   439:               end subroutine AuxVars
   440:             
   441:               !--------------------------------------------------------------------------------------
   442:             
   443:               subroutine AuxVarsInternalRoutine( &
   444:                 & xy_Ps,      xyz_Temp,   &  ! (in )
   445:                 & xyr_Temp,               &  ! (out) optional
   446:                 & xyz_Press,  xyr_Press   &  ! (out) optional
   447:                 & )
   448:                 !
   449:                 ! 温度の半整数σレベルの補間, 気圧の算出, 
   450:                 ! エクスナー関数の計算を行います. 
   451:                 !
   452:                 ! Interpolate temperature on half sigma level, 
   453:                 ! and calculate pressure, 
   454:                 ! and calculate exner function. 
   455:             
   456:                 ! モジュール引用 ; USE statements
   457:                 !
   458:             
   459:                 ! 座標データ設定
   460:                 ! Axes data settings
   461:                 !
   462:                 use axesset, only: &
   463:                   & z_Sigma, &
   464:                                           ! $ \sigma $ レベル (整数). 
   465:                                           ! Full $ \sigma $ level
   466:                   & r_Sigma
   467:                                           ! $ \sigma $ レベル (半整数). 
   468:                                           ! Half $ \sigma $ level
   469:             
   470:                 ! 宣言文 ; Declaration statements
   471:                 !
   472:                 implicit none
   473:             
   474:                 real(DP), intent(in):: xy_Ps       (0:imax-1, 1:jmax)
   475:                                           ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   476:                 real(DP), intent(in):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   477:                                           ! $ T $ .     温度. Temperature
   478:                 real(DP), intent(out), optional:: xyr_Temp   (0:imax-1, 1:jmax, 0:kmax)
   479:                                           ! $ \hat{T} $ . 温度 (半整数レベル). 
   480:                                           ! Temperature (half level)
   481:                 real(DP), intent(out), optional:: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   482:                                           ! $ p $ . 気圧 (整数レベル). 
   483:                                           ! Air pressure (full level)
   484:                 real(DP), intent(out), optional:: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
   485:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   486:                                           ! Air pressure (half level)
   487:             
   488:             
   489:                 ! 作業変数
   490:                 ! Work variables
   491:                 !
   492:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   493:                                           ! Work variables for DO loop in vertical direction
   494:             
   495:                 ! 実行文 ; Executable statement
   496:                 !
   497:             
   498:             
   499:                 ! 初期化確認
   500:                 ! Initialization check
   501:                 !
   502:                 if ( .not. auxiliary_inited ) then
   503:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   504:                 end if
   505:             
   506:             
   507:                 ! 温度の補間
   508:                 ! Interpolate temperature
   509:                 !
   510:                 if ( present( xyr_Temp ) ) then
   511: +------>          do k = 2, kmax
   512: |W*==== A           xyr_Temp(:,:,k-1) =   z_TempInpolM(k) * xyz_Temp(:,:,k-1)  &
   513: |                     &                 + z_TempInpol (k) * xyz_Temp(:,:,k)
   514: +------           end do
   515:             
   516: *W----->A         xyr_Temp(:,:,kmax) = xyz_Temp(:,:,kmax)
   517: *W----- A         xyr_Temp(:,:,0)    = xyz_Temp(:,:,1)
   518:             
   519:                 end if
   520:             
   521:                 ! 気圧の計算
   522:                 ! Calculate pressure
   523:                 !
   524:                 if ( present( xyz_Press ) ) then
   525: +------>          do k = 1, kmax
   526: |W*==== A           xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
   527: +------           end do
   528:                 end if
   529:             
   530:                 if ( present( xyr_Press ) ) then
   531: +------>          do k = 0, kmax
   532: |W*==== A           xyr_Press(:,:,k) = xy_Ps * r_Sigma(k)
   533: +------           end do
   534:                 end if
   535:             
   536:             
   537:               end subroutine AuxVarsInternalRoutine
   538:             
   539:               !--------------------------------------------------------------------------------------
   540:             
   541:               subroutine AuxVarsInit
   542:                 !
   543:                 ! auxiliary モジュールの初期化を行います. 
   544:                 ! NAMELIST#auxiliary_nml の読み込みはこの手続きで行われます. 
   545:                 !
   546:                 ! "auxiliary" module is initialized. 
   547:                 ! "NAMELIST#auxiliary_nml" is loaded in this procedure. 
   548:                 !
   549:             
   550:                 ! モジュール引用 ; USE statements
   551:                 !
   552:             
   553:                 ! 座標データ設定
   554:                 ! Axes data settings
   555:                 !
   556:                 use axesset, only: &
   557:                   & z_Sigma, &
   558:                                           ! $ \sigma $ レベル (整数). 
   559:                                           ! Full $ \sigma $ level
   560:                   & r_Sigma
   561:                                           ! $ \sigma $ レベル (半整数). 
   562:                                           ! Half $ \sigma $ level
   563:             
   564:                 ! NAMELIST ファイル入力に関するユーティリティ
   565:                 ! Utilities for NAMELIST file input
   566:                 !
   567:                 use namelist_util, only: namelist_filename, NmlutilMsg
   568:             
   569:                 ! ファイル入出力補助
   570:                 ! File I/O support
   571:                 !
   572:                 use dc_iounit, only: FileOpen
   573:             
   574:                 ! 種別型パラメタ
   575:                 ! Kind type parameter
   576:                 !
   577:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   578:             
   579:                 ! 文字列操作
   580:                 ! Character handling
   581:                 !
   582:                 use dc_string, only: StoA
   583:             
   584:                 ! 宣言文 ; Declaration statements
   585:                 !
   586:                 implicit none
   587:             
   588:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   589:                                           ! Unit number for NAMELIST file open
   590:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   591:                                           ! IOSTAT of NAMELIST read
   592:             
   593:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   594:                                           ! Work variables for DO loop in vertical direction
   595:             
   596:                 ! NAMELIST 変数群
   597:                 ! NAMELIST group name
   598:                 !
   599:                 namelist /auxiliary_nml/ &
   600:                   & RefPress
   601:                       !
   602:                       ! デフォルト値については初期化手続 "auxiliary#AuxVarsInit" 
   603:                       ! のソースコードを参照のこと. 
   604:                       !
   605:                       ! Refer to source codes in the initialization procedure
   606:                       ! "auxiliary#AuxVarsInit" for the default values. 
   607:                       !
   608:             
   609:                 ! 実行文 ; Executable statement
   610:                 !
   611:             
   612:                 if ( auxiliary_inited ) return
   613:             
   614:             
   615:                 ! デフォルト値の設定
   616:                 ! Default values settings
   617:                 !
   618:                 RefPress        =   1.0e5_DP
   619:             
   620:                 ! NAMELIST の読み込み
   621:                 ! NAMELIST is input
   622:                 !
   623:                 if ( trim(namelist_filename) /= '' ) then
   624:                   call FileOpen( unit_nml, &          ! (out)
   625:                     & namelist_filename, mode = 'r' ) ! (in)
   626:             
   627:                   rewind( unit_nml )
   628:                   read( unit_nml, &           ! (in)
   629:                     & nml = auxiliary_nml, &  ! (out)
   630:                     & iostat = iostat_nml )   ! (out)
   631:                   close( unit_nml )
   632:             
   633:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   634:                 end if
   635:             
   636:                 !  補間用の係数の計算
   637:                 !  Calculate coefficient for interpolation
   638:                 !
   639:                 allocate( z_TempInpolM(1:kmax) )
   640:                 allocate( z_TempInpol(1:kmax) )
   641:             
   642:                 z_TempInpolM(1) = 0.0_DP
   643:                 z_TempInpol (1) = 0.0_DP
   644:             
   645: V------>        do k = 2, kmax
   646: |       A         z_TempInpolM(k) = &
   647: |                   &    ( log( r_Sigma( k-1 ) ) - log( z_Sigma( k ) ) ) &
   648: |                   &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k ) ) )
   649: |       A         z_TempInpol(k) = &
   650: |                   &    ( log( z_Sigma( k-1 ) ) - log( r_Sigma( k-1 ) ) ) &
   651: |                   &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k )   ) )
   652: V------         end  do
   653:             
   654:                 ! 印字 ; Print
   655:                 !
   656:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   657: V====== A       call MessageNotify( 'M', module_name, '  z_TempInpolM = %f', d = (/ z_TempInpolM /), n = (/ kmax /) )
   658: V====== A       call MessageNotify( 'M', module_name, '  z_TempInpol  = %f', d = (/ z_TempInpol  /), n = (/ kmax /) )
   659:                 call MessageNotify( 'M', module_name, '  RefPress     = %f', d = (/ RefPress /) )
   660:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   661:             
   662:                 auxiliary_inited = .true.
   663:             
   664:               end subroutine AuxVarsInit
   665:             
   666:               !--------------------------------------------------------------------------------------
   667:             
   668:               subroutine AuxVarsFinalize
   669:                 !
   670:                 ! モジュール内部の変数の割り付け解除を行います. 
   671:                 !
   672:                 ! Deallocate variables in this module. 
   673:                 !
   674:             
   675:                 ! 宣言文 ; Declaration statements
   676:                 !
   677:                 implicit none
   678:             
   679:                 ! 実行文 ; Executable statement
   680:                 !
   681:             
   682:                 if ( .not. auxiliary_inited ) return
   683:             
   684:                 ! 割り付け解除
   685:                 ! Deallocation
   686:                 !
   687:                 if ( allocated( z_TempInpolM ) ) deallocate( z_TempInpolM )
   688:                 if ( allocated( z_TempInpol  ) ) deallocate( z_TempInpol  )
   689:             
   690:                 auxiliary_inited = .false.
   691:             
   692:               end subroutine AuxVarsFinalize
   693:             
   694:               !--------------------------------------------------------------------------------------
   695:             
   696:             end module auxiliary
