Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: check_prog_vars.f90
PROGRAM NAME: check_prog_vars
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   225  opt  (1059): Unable to determine last value of scalar temporary.
   225  vec  (   1): Vectorized loop.
   225  vec  (  29): ADB is used for array.: xyz_u
   226  opt  (1019): Feedback of scalar value from one loop pass to another.
   226  vec  (  26): Macro operation Max/Min.
   232  opt  (1019): Feedback of scalar value from one loop pass to another.
   232  vec  (  26): Macro operation Max/Min.
   263  opt  (1059): Unable to determine last value of scalar temporary.
   263  vec  (   1): Vectorized loop.
   263  vec  (  29): ADB is used for array.: xyz_v
   264  opt  (1019): Feedback of scalar value from one loop pass to another.
   264  vec  (  26): Macro operation Max/Min.
   270  opt  (1019): Feedback of scalar value from one loop pass to another.
   270  vec  (  26): Macro operation Max/Min.
   301  opt  (1059): Unable to determine last value of scalar temporary.
   301  vec  (   1): Vectorized loop.
   301  vec  (  29): ADB is used for array.: xyz_temp
   302  opt  (1019): Feedback of scalar value from one loop pass to another.
   302  vec  (  26): Macro operation Max/Min.
   308  opt  (1019): Feedback of scalar value from one loop pass to another.
   308  vec  (  26): Macro operation Max/Min.
   336  warn (  82): Name "n" is not used.
   336  warn (  83): Dummy argument "xyzf_qmix" is not used.
   336  warn (  83): Dummy argument "xy_ps" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: check_prog_vars.f90
PROGRAM NAME: check_prog_vars
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 予報変数の値の確認
     2  !
     3  != Check values of prognostic variables
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: check_prog_vars.f90,v 1.5 2013/02/19 01:33:12 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module check_prog_vars
    13    !
    14    != 予報変数の値の確認
    15    !
    16    != Check values of prognostic variables
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 予報変数の値の確認
    21    !
    22    ! Check values of prognostic variables
    23    !
    24    !== Procedures List
    25    !
    26  !!$  ! SurfaceFlux       :: 地表面フラックスの計算
    27  !!$  ! SurfaceFluxOutput :: 地表面フラックスの出力
    28  !!$  ! ------------      :: ------------
    29  !!$  ! SurfaceFlux       :: Calculate surface fluxes
    30  !!$  ! SurfaceFluxOutput :: Output surface fluxes
    31    !
    32    !== NAMELIST
    33    !
    34    ! NAMELIST#check_prog_vars_nml
    35    !
    36  
    37    ! モジュール引用 ; USE statements
    38    !
    39  
    40    ! 種別型パラメタ
    41    ! Kind type parameter
    42    !
    43    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    44      &                 STRING     ! 文字列.       Strings.
    45  
    46  
    47    ! 宣言文 ; Declaration statements
    48    !
    49    implicit none
    50    private
    51  
    52    ! 公開手続き
    53    ! Public procedure
    54    !
    55    public :: CheckProgVars
    56    public :: CheckProgVarsInit
    57  
    58    ! 公開変数
    59    ! Public variables
    60    !
    61  
    62    ! 非公開変数
    63    ! Private variables
    64    !
    65    logical, save :: check_prog_vars_inited = .false.
    66                                ! 初期設定フラグ.
    67                                ! Initialization flag
    68  
    69    real(DP), save:: TempMin
    70                              ! 温度最小値
    71                              ! Minimum value of temperature
    72    real(DP), save:: TempMax
    73                              ! 温度最大値
    74                              ! Maximum value of temperature
    75    real(DP), save:: VelMin
    76                              ! 風速最小値
    77                              ! Minimum value of wind velocity
    78    real(DP), save:: VelMax
    79                              ! 風速最大値
    80                              ! Maximum value of wind velocity
    81  
    82    character(*), parameter:: module_name = 'check_prog_vars'
    83                                ! モジュールの名称.
    84                                ! Module name
    85    character(*), parameter:: version = &
    86      & '$Name:  $' // &
    87      & '$Id: check_prog_vars.f90,v 1.5 2013/02/19 01:33:12 yot Exp $'
    88                                ! モジュールのバージョン
    89                                ! Module version
    90  
    91    ! INTERFACE 文 ; INTERFACE statements
    92    !
    93  !!$  interface SurfaceFlux
    94  !!$    module procedure SurfaceFlux
    95  !!$  end interface
    96  !!$
    97  !!$  interface SurfaceFluxOutput
    98  !!$    module procedure SurfaceFluxOutput
    99  !!$  end interface
   100  
   101  contains
   102  
   103    subroutine CheckProgVars( &
   104      & xy_Ps, xyz_U, xyz_V, xyz_Temp, xyzf_QMix   & ! (in)
   105      & )
   106      !
   107      ! 予報変数の値の確認
   108      !
   109      ! Check values of prognostic variables
   110      !
   111  
   112      ! モジュール引用 ; USE statements
   113      !
   114  
   115      ! 格子点設定
   116      ! Grid points settings
   117      !
   118      use gridset, only: imax, & ! 経度格子点数.
   119                                 ! Number of grid points in longitude
   120        &                jmax, & ! 緯度格子点数.
   121                                 ! Number of grid points in latitude
   122        &                kmax    ! 鉛直層数.
   123                                 ! Number of vertical level
   124  
   125      ! 座標データ設定
   126      ! Axes data settings
   127      !
   128      use axesset, only: &
   129        & x_Lon,   & ! $ \lambda $ [rad.] . 経度. Longitude
   130        & y_Lat,   & ! $ \varphi $ [rad.] . 緯度. Latitude
   131        & z_Sigma    ! $ \sigma $ レベル (整数).  Full $ \sigma $ level
   132  
   133      ! 組成に関わる配列の設定
   134      ! Settings of array for atmospheric composition
   135      !
   136      use composition, only: ncmax, IndexH2OVap
   137  
   138      ! メッセージ出力
   139      ! Message output
   140      !
   141      use dc_message, only: MessageNotify
   142  
   143      ! 時刻管理
   144      ! Time control
   145      !
   146      use timeset, only: &
   147        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   148        & TimesetClockStart, TimesetClockStop
   149  
   150      ! デバッグ用ユーティリティ
   151      ! Utilities for debug
   152      !
   153      use dc_trace, only: DbgMessage, BeginSub, EndSub
   154  
   155      ! 物理・数学定数設定
   156      ! Physical and mathematical constants settings
   157      !
   158      use constants0, only: &
   159        & PI                    ! $ \pi $ .
   160                                ! Circular constant
   161  
   162      ! 宣言文 ; Declaration statements
   163      !
   164      implicit none
   165      real(DP), intent(in):: xy_Ps (0:imax-1, 1:jmax)
   166                                ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure (Pa)
   167      real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   168                                ! $ u $ . 東西風速. Eastward wind
   169      real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   170                                ! $ v $ . 南北風速. Northward wind
   171      real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   172                                ! $ T $ . 温度 (整数レベル).
   173                                ! Temperature (full level)
   174      real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   175                                ! $ q $ .     比湿. Specific humidity
   176  
   177      ! 作業変数
   178      ! Work variables
   179      !
   180      integer:: i               ! 経度方向に回る DO ループ用作業変数
   181                                ! Work variables for DO loop in longitude
   182      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   183                                ! Work variables for DO loop in latitude
   184      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   185                                ! Work variables for DO loop in vertical direction
   186      integer:: n               ! 組成方向に回る DO ループ用作業変数
   187                                ! Work variables for DO loop in dimension of constituents
   188  
   189      real(DP) :: minval, maxval
   190      integer  :: mini, minj, mink
   191      integer  :: maxi, maxj, maxk
   192  
   193  
   194      ! 実行文 ; Executable statement
   195      !
   196  
   197      ! 初期化確認
   198      ! Initialization check
   199      !
   200      if ( .not. check_prog_vars_inited ) then
   201        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   202      end if
   203  
   204  
   205      ! 計算時間計測開始
   206      ! Start measurement of computation time
   207      !
   208      call TimesetClockStart( module_name )
   209  
   210  
   211  
   212      i = 0
   213      j = 1
   214      k = 1
   215      minval = xyz_U(i,j,k)
   216      maxval = xyz_U(i,j,k)
   217      mini   = i
   218      minj   = j
   219      mink   = k
   220      maxi   = i
   221      maxj   = j
   222      maxk   = k
   223      do k = 1, kmax
   224        do j = 1, jmax
   225          do i = 0, imax-1
   226            if ( xyz_U   (i,j,k) < minval ) then
   227              minval = xyz_U   (i,j,k)
   228              mini   = i
   229              minj   = j
   230              mink   = k
   231            end if
   232            if ( maxval < xyz_U   (i,j,k) ) then
   233              maxval = xyz_U   (i,j,k)
   234              maxi   = i
   235              maxj   = j
   236              maxk   = k
   237            end if
   238          end do
   239        end do
   240      end do
   241      if ( minval  < VelMin  ) then
   242        call MessageNotify( 'M', module_name, 'Min value : U(%f,%f,%f) = %f.', &
   243          & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
   244      end if
   245      if ( VelMax  < maxval  ) then
   246        call MessageNotify( 'M', module_name, 'Max value : U(%f,%f,%f) = %f.', &
   247          & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
   248      end if
   249  
   250      i = 0
   251      j = 1
   252      k = 1
   253      minval = xyz_V(i,j,k)
   254      maxval = xyz_V(i,j,k)
   255      mini   = i
   256      minj   = j
   257      mink   = k
   258      maxi   = i
   259      maxj   = j
   260      maxk   = k
   261      do k = 1, kmax
   262        do j = 1, jmax
   263          do i = 0, imax-1
   264            if ( xyz_V   (i,j,k) < minval ) then
   265              minval = xyz_V   (i,j,k)
   266              mini   = i
   267              minj   = j
   268              mink   = k
   269            end if
   270            if ( maxval < xyz_V   (i,j,k) ) then
   271              maxval = xyz_V   (i,j,k)
   272              maxi   = i
   273              maxj   = j
   274              maxk   = k
   275            end if
   276          end do
   277        end do
   278      end do
   279      if ( minval  < VelMin  ) then
   280        call MessageNotify( 'M', module_name, 'Min value : V(%f,%f,%f) = %f.', &
   281          & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
   282      end if
   283      if ( VelMax  < maxval  ) then
   284        call MessageNotify( 'M', module_name, 'Max value : V(%f,%f,%f) = %f.', &
   285          & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
   286      end if
   287  
   288      i = 0
   289      j = 1
   290      k = 1
   291      minval = xyz_Temp(i,j,k)
   292      maxval = xyz_Temp(i,j,k)
   293      mini   = i
   294      minj   = j
   295      mink   = k
   296      maxi   = i
   297      maxj   = j
   298      maxk   = k
   299      do k = 1, kmax
   300        do j = 1, jmax
   301          do i = 0, imax-1
   302            if ( xyz_Temp(i,j,k) < minval ) then
   303              minval = xyz_Temp(i,j,k)
   304              mini   = i
   305              minj   = j
   306              mink   = k
   307            end if
   308            if ( maxval < xyz_Temp(i,j,k) ) then
   309              maxval = xyz_Temp(i,j,k)
   310              maxi   = i
   311              maxj   = j
   312              maxk   = k
   313            end if
   314          end do
   315        end do
   316      end do
   317      if ( minval  < TempMin ) then
   318        call MessageNotify( 'M', module_name, 'Min value : T(%f,%f,%f) = %f.', &
   319          & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
   320      end if
   321      if ( TempMax < maxval  ) then
   322        call MessageNotify( 'M', module_name, 'Max value : T(%f,%f,%f) = %f.', &
   323          & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
   324      end if
   325  
   326  
   327      ! ヒストリデータ出力
   328      ! History data output
   329      !
   330  
   331      ! 計算時間計測一時停止
   332      ! Pause measurement of computation time
   333      !
   334      call TimesetClockStop( module_name )
   335  
   336    end subroutine CheckProgVars
   337  
   338    !-------------------------------------------------------------------
   339  
   340    subroutine CheckProgVarsInit
   341      !
   342      ! check_prog_vars モジュールの初期化を行います.
   343      ! NAMELIST#check_prog_vars_nml の読み込みはこの手続きで行われます.
   344      !
   345      ! "check_prog_vars" module is initialized.
   346      ! "NAMELIST#check_prog_vars_nml" is loaded in this procedure.
   347      !
   348  
   349      ! モジュール引用 ; USE statements
   350      !
   351  
   352      ! NAMELIST ファイル入力に関するユーティリティ
   353      ! Utilities for NAMELIST file input
   354      !
   355      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   356  
   357      ! ファイル入出力補助
   358      ! File I/O support
   359      !
   360      use dc_iounit, only: FileOpen
   361  
   362      ! 種別型パラメタ
   363      ! Kind type parameter
   364      !
   365      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   366  
   367      ! 文字列操作
   368      ! Character handling
   369      !
   370      use dc_string, only: StoA
   371  
   372      ! メッセージ出力
   373      ! Message output
   374      !
   375      use dc_message, only: MessageNotify
   376  
   377      ! 宣言文 ; Declaration statements
   378      !
   379      implicit none
   380  
   381      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   382                                ! Unit number for NAMELIST file open
   383      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   384                                ! IOSTAT of NAMELIST read
   385  
   386      ! NAMELIST 変数群
   387      ! NAMELIST group name
   388      !
   389      namelist /check_prog_vars_nml/ &
   390        & VelMin, VelMax, TempMin, TempMax
   391            !
   392            ! デフォルト値については初期化手続 "check_prog_vars#CheckProgVarsInit"
   393            ! のソースコードを参照のこと.
   394            !
   395            ! Refer to source codes in the initialization procedure
   396            ! "check_prog_vars#CheckProgVarsInit" for the default values.
   397            !
   398  
   399      ! 実行文 ; Executable statement
   400      !
   401  
   402      if ( check_prog_vars_inited ) return
   403  !!$    call InitCheck
   404  
   405      ! デフォルト値の設定
   406      ! Default values settings
   407      !
   408      VelMin  = -300.0_DP
   409      VelMax  =  300.0_DP
   410      TempMin =   50.0_DP
   411      TempMax =  330.0_DP
   412  
   413      ! NAMELIST の読み込み
   414      ! NAMELIST is input
   415      !
   416      if ( trim(namelist_filename) /= '' ) then
   417        call FileOpen( unit_nml, &          ! (out)
   418          & namelist_filename, mode = 'r' ) ! (in)
   419  
   420        rewind( unit_nml )
   421        read( unit_nml, &                ! (in)
   422          & nml = check_prog_vars_nml, &  ! (out)
   423          & iostat = iostat_nml )        ! (out)
   424        close( unit_nml )
   425  
   426        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   427      end if
   428  
   429  
   430      ! 印字 ; Print
   431      !
   432      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   433  
   434      call MessageNotify( 'M', module_name, '  VelMin  = %f', d = (/ VelMin  /) )
   435      call MessageNotify( 'M', module_name, '  VelMax  = %f', d = (/ VelMax  /) )
   436      call MessageNotify( 'M', module_name, '  TempMin = %f', d = (/ TempMin /) )
   437      call MessageNotify( 'M', module_name, '  TempMax = %f', d = (/ TempMax /) )
   438  
   439      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   440  
   441      check_prog_vars_inited = .true.
   442  
   443    end subroutine CheckProgVarsInit
   444  
   445    !--------------------------------------------------------------------------------------
   446  
   447  end module check_prog_vars
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: check_prog_vars.f90
PROGRAM NAME: check_prog_vars
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 予報変数の値の確認
     2:             !
     3:             != Check values of prognostic variables
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: check_prog_vars.f90,v 1.5 2013/02/19 01:33:12 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module check_prog_vars
    13:               !
    14:               != 予報変数の値の確認
    15:               !
    16:               != Check values of prognostic variables
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 予報変数の値の確認
    21:               !
    22:               ! Check values of prognostic variables
    23:               !
    24:               !== Procedures List
    25:               !
    26:             !!$  ! SurfaceFlux       :: 地表面フラックスの計算
    27:             !!$  ! SurfaceFluxOutput :: 地表面フラックスの出力
    28:             !!$  ! ------------      :: ------------
    29:             !!$  ! SurfaceFlux       :: Calculate surface fluxes
    30:             !!$  ! SurfaceFluxOutput :: Output surface fluxes
    31:               !
    32:               !== NAMELIST
    33:               !
    34:               ! NAMELIST#check_prog_vars_nml
    35:               !
    36:             
    37:               ! モジュール引用 ; USE statements
    38:               !
    39:             
    40:               ! 種別型パラメタ
    41:               ! Kind type parameter
    42:               !
    43:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    44:                 &                 STRING     ! 文字列.       Strings. 
    45:             
    46:             
    47:               ! 宣言文 ; Declaration statements
    48:               !
    49:               implicit none
    50:               private
    51:             
    52:               ! 公開手続き
    53:               ! Public procedure
    54:               !
    55:               public :: CheckProgVars
    56:               public :: CheckProgVarsInit
    57:             
    58:               ! 公開変数
    59:               ! Public variables
    60:               !
    61:             
    62:               ! 非公開変数
    63:               ! Private variables
    64:               !
    65:               logical, save :: check_prog_vars_inited = .false.
    66:                                           ! 初期設定フラグ. 
    67:                                           ! Initialization flag
    68:             
    69:               real(DP), save:: TempMin
    70:                                         ! 温度最小値
    71:                                         ! Minimum value of temperature
    72:               real(DP), save:: TempMax
    73:                                         ! 温度最大値
    74:                                         ! Maximum value of temperature
    75:               real(DP), save:: VelMin
    76:                                         ! 風速最小値
    77:                                         ! Minimum value of wind velocity
    78:               real(DP), save:: VelMax
    79:                                         ! 風速最大値
    80:                                         ! Maximum value of wind velocity
    81:             
    82:               character(*), parameter:: module_name = 'check_prog_vars'
    83:                                           ! モジュールの名称. 
    84:                                           ! Module name
    85:               character(*), parameter:: version = &
    86:                 & '$Name:  $' // &
    87:                 & '$Id: check_prog_vars.f90,v 1.5 2013/02/19 01:33:12 yot Exp $'
    88:                                           ! モジュールのバージョン
    89:                                           ! Module version
    90:             
    91:               ! INTERFACE 文 ; INTERFACE statements
    92:               !
    93:             !!$  interface SurfaceFlux
    94:             !!$    module procedure SurfaceFlux
    95:             !!$  end interface
    96:             !!$
    97:             !!$  interface SurfaceFluxOutput
    98:             !!$    module procedure SurfaceFluxOutput
    99:             !!$  end interface
   100:             
   101:             contains
   102:             
   103:               subroutine CheckProgVars( &
   104:                 & xy_Ps, xyz_U, xyz_V, xyz_Temp, xyzf_QMix   & ! (in)
   105:                 & )
   106:                 !
   107:                 ! 予報変数の値の確認
   108:                 !
   109:                 ! Check values of prognostic variables
   110:                 !
   111:             
   112:                 ! モジュール引用 ; USE statements
   113:                 !
   114:             
   115:                 ! 格子点設定
   116:                 ! Grid points settings
   117:                 !
   118:                 use gridset, only: imax, & ! 経度格子点数. 
   119:                                            ! Number of grid points in longitude
   120:                   &                jmax, & ! 緯度格子点数. 
   121:                                            ! Number of grid points in latitude
   122:                   &                kmax    ! 鉛直層数. 
   123:                                            ! Number of vertical level
   124:             
   125:                 ! 座標データ設定
   126:                 ! Axes data settings
   127:                 !
   128:                 use axesset, only: &
   129:                   & x_Lon,   & ! $ \lambda $ [rad.] . 経度. Longitude
   130:                   & y_Lat,   & ! $ \varphi $ [rad.] . 緯度. Latitude
   131:                   & z_Sigma    ! $ \sigma $ レベル (整数).  Full $ \sigma $ level
   132:             
   133:                 ! 組成に関わる配列の設定
   134:                 ! Settings of array for atmospheric composition
   135:                 !
   136:                 use composition, only: ncmax, IndexH2OVap
   137:             
   138:                 ! メッセージ出力
   139:                 ! Message output
   140:                 !
   141:                 use dc_message, only: MessageNotify
   142:             
   143:                 ! 時刻管理
   144:                 ! Time control
   145:                 !
   146:                 use timeset, only: &
   147:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   148:                   & TimesetClockStart, TimesetClockStop
   149:             
   150:                 ! デバッグ用ユーティリティ
   151:                 ! Utilities for debug
   152:                 !
   153:                 use dc_trace, only: DbgMessage, BeginSub, EndSub
   154:             
   155:                 ! 物理・数学定数設定
   156:                 ! Physical and mathematical constants settings
   157:                 !
   158:                 use constants0, only: &
   159:                   & PI                    ! $ \pi $ .
   160:                                           ! Circular constant
   161:             
   162:                 ! 宣言文 ; Declaration statements
   163:                 !
   164:                 implicit none
   165:                 real(DP), intent(in):: xy_Ps (0:imax-1, 1:jmax)
   166:                                           ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure (Pa)
   167:                 real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   168:                                           ! $ u $ . 東西風速. Eastward wind
   169:                 real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   170:                                           ! $ v $ . 南北風速. Northward wind
   171:                 real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   172:                                           ! $ T $ . 温度 (整数レベル). 
   173:                                           ! Temperature (full level)
   174:                 real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   175:                                           ! $ q $ .     比湿. Specific humidity
   176:             
   177:                 ! 作業変数
   178:                 ! Work variables
   179:                 !
   180:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   181:                                           ! Work variables for DO loop in longitude
   182:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   183:                                           ! Work variables for DO loop in latitude
   184:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   185:                                           ! Work variables for DO loop in vertical direction
   186:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   187:                                           ! Work variables for DO loop in dimension of constituents
   188:             
   189:                 real(DP) :: minval, maxval
   190:                 integer  :: mini, minj, mink
   191:                 integer  :: maxi, maxj, maxk
   192:             
   193:             
   194:                 ! 実行文 ; Executable statement
   195:                 !
   196:             
   197:                 ! 初期化確認
   198:                 ! Initialization check
   199:                 !
   200:                 if ( .not. check_prog_vars_inited ) then
   201:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   202:                 end if
   203:             
   204:             
   205:                 ! 計算時間計測開始
   206:                 ! Start measurement of computation time
   207:                 !
   208:                 call TimesetClockStart( module_name )
   209:             
   210:             
   211:             
   212:                 i = 0
   213:                 j = 1
   214:                 k = 1
   215:                 minval = xyz_U(i,j,k)
   216:                 maxval = xyz_U(i,j,k)
   217:                 mini   = i
   218:                 minj   = j
   219:                 mink   = k
   220:                 maxi   = i
   221:                 maxj   = j
   222:                 maxk   = k
   223: +------>        do k = 1, kmax
   224: |+----->          do j = 1, jmax
   225: ||V---->            do i = 0, imax-1
   226: |||     A             if ( xyz_U   (i,j,k) < minval ) then
   227: |||                     minval = xyz_U   (i,j,k)
   228: |||                     mini   = i
   229: |||                     minj   = j
   230: |||                     mink   = k
   231: |||                   end if
   232: |||     A             if ( maxval < xyz_U   (i,j,k) ) then
   233: |||                     maxval = xyz_U   (i,j,k)
   234: |||                     maxi   = i
   235: |||                     maxj   = j
   236: |||                     maxk   = k
   237: |||                   end if
   238: ||V----             end do
   239: |+-----           end do
   240: +------         end do
   241:                 if ( minval  < VelMin  ) then
   242:                   call MessageNotify( 'M', module_name, 'Min value : U(%f,%f,%f) = %f.', &
   243:                     & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
   244:                 end if
   245:                 if ( VelMax  < maxval  ) then
   246:                   call MessageNotify( 'M', module_name, 'Max value : U(%f,%f,%f) = %f.', &
   247:                     & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
   248:                 end if
   249:             
   250:                 i = 0
   251:                 j = 1
   252:                 k = 1
   253:                 minval = xyz_V(i,j,k)
   254:                 maxval = xyz_V(i,j,k)
   255:                 mini   = i
   256:                 minj   = j
   257:                 mink   = k
   258:                 maxi   = i
   259:                 maxj   = j
   260:                 maxk   = k
   261: +------>        do k = 1, kmax
   262: |+----->          do j = 1, jmax
   263: ||V---->            do i = 0, imax-1
   264: |||     A             if ( xyz_V   (i,j,k) < minval ) then
   265: |||                     minval = xyz_V   (i,j,k)
   266: |||                     mini   = i
   267: |||                     minj   = j
   268: |||                     mink   = k
   269: |||                   end if
   270: |||     A             if ( maxval < xyz_V   (i,j,k) ) then
   271: |||                     maxval = xyz_V   (i,j,k)
   272: |||                     maxi   = i
   273: |||                     maxj   = j
   274: |||                     maxk   = k
   275: |||                   end if
   276: ||V----             end do
   277: |+-----           end do
   278: +------         end do
   279:                 if ( minval  < VelMin  ) then
   280:                   call MessageNotify( 'M', module_name, 'Min value : V(%f,%f,%f) = %f.', &
   281:                     & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
   282:                 end if
   283:                 if ( VelMax  < maxval  ) then
   284:                   call MessageNotify( 'M', module_name, 'Max value : V(%f,%f,%f) = %f.', &
   285:                     & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
   286:                 end if
   287:             
   288:                 i = 0
   289:                 j = 1
   290:                 k = 1
   291:                 minval = xyz_Temp(i,j,k)
   292:                 maxval = xyz_Temp(i,j,k)
   293:                 mini   = i
   294:                 minj   = j
   295:                 mink   = k
   296:                 maxi   = i
   297:                 maxj   = j
   298:                 maxk   = k
   299: +------>        do k = 1, kmax
   300: |+----->          do j = 1, jmax
   301: ||V---->            do i = 0, imax-1
   302: |||     A             if ( xyz_Temp(i,j,k) < minval ) then
   303: |||                     minval = xyz_Temp(i,j,k)
   304: |||                     mini   = i
   305: |||                     minj   = j
   306: |||                     mink   = k
   307: |||                   end if
   308: |||     A             if ( maxval < xyz_Temp(i,j,k) ) then
   309: |||                     maxval = xyz_Temp(i,j,k)
   310: |||                     maxi   = i
   311: |||                     maxj   = j
   312: |||                     maxk   = k
   313: |||                   end if
   314: ||V----             end do
   315: |+-----           end do
   316: +------         end do
   317:                 if ( minval  < TempMin ) then
   318:                   call MessageNotify( 'M', module_name, 'Min value : T(%f,%f,%f) = %f.', &
   319:                     & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
   320:                 end if
   321:                 if ( TempMax < maxval  ) then
   322:                   call MessageNotify( 'M', module_name, 'Max value : T(%f,%f,%f) = %f.', &
   323:                     & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
   324:                 end if
   325:             
   326:             
   327:                 ! ヒストリデータ出力
   328:                 ! History data output
   329:                 !
   330:             
   331:                 ! 計算時間計測一時停止
   332:                 ! Pause measurement of computation time
   333:                 !
   334:                 call TimesetClockStop( module_name )
   335:             
   336:               end subroutine CheckProgVars
   337:             
   338:               !-------------------------------------------------------------------
   339:             
   340:               subroutine CheckProgVarsInit
   341:                 !
   342:                 ! check_prog_vars モジュールの初期化を行います. 
   343:                 ! NAMELIST#check_prog_vars_nml の読み込みはこの手続きで行われます. 
   344:                 !
   345:                 ! "check_prog_vars" module is initialized. 
   346:                 ! "NAMELIST#check_prog_vars_nml" is loaded in this procedure. 
   347:                 !
   348:             
   349:                 ! モジュール引用 ; USE statements
   350:                 !
   351:             
   352:                 ! NAMELIST ファイル入力に関するユーティリティ
   353:                 ! Utilities for NAMELIST file input
   354:                 !
   355:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   356:             
   357:                 ! ファイル入出力補助
   358:                 ! File I/O support
   359:                 !
   360:                 use dc_iounit, only: FileOpen
   361:             
   362:                 ! 種別型パラメタ
   363:                 ! Kind type parameter
   364:                 !
   365:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   366:             
   367:                 ! 文字列操作
   368:                 ! Character handling
   369:                 !
   370:                 use dc_string, only: StoA
   371:             
   372:                 ! メッセージ出力
   373:                 ! Message output
   374:                 !
   375:                 use dc_message, only: MessageNotify
   376:             
   377:                 ! 宣言文 ; Declaration statements
   378:                 !
   379:                 implicit none
   380:             
   381:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   382:                                           ! Unit number for NAMELIST file open
   383:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   384:                                           ! IOSTAT of NAMELIST read
   385:             
   386:                 ! NAMELIST 変数群
   387:                 ! NAMELIST group name
   388:                 !
   389:                 namelist /check_prog_vars_nml/ &
   390:                   & VelMin, VelMax, TempMin, TempMax
   391:                       !
   392:                       ! デフォルト値については初期化手続 "check_prog_vars#CheckProgVarsInit" 
   393:                       ! のソースコードを参照のこと. 
   394:                       !
   395:                       ! Refer to source codes in the initialization procedure
   396:                       ! "check_prog_vars#CheckProgVarsInit" for the default values. 
   397:                       !
   398:             
   399:                 ! 実行文 ; Executable statement
   400:                 !
   401:             
   402:                 if ( check_prog_vars_inited ) return
   403:             !!$    call InitCheck
   404:             
   405:                 ! デフォルト値の設定
   406:                 ! Default values settings
   407:                 !
   408:                 VelMin  = -300.0_DP
   409:                 VelMax  =  300.0_DP
   410:                 TempMin =   50.0_DP
   411:                 TempMax =  330.0_DP
   412:             
   413:                 ! NAMELIST の読み込み
   414:                 ! NAMELIST is input
   415:                 !
   416:                 if ( trim(namelist_filename) /= '' ) then
   417:                   call FileOpen( unit_nml, &          ! (out)
   418:                     & namelist_filename, mode = 'r' ) ! (in)
   419:             
   420:                   rewind( unit_nml )
   421:                   read( unit_nml, &                ! (in)
   422:                     & nml = check_prog_vars_nml, &  ! (out)
   423:                     & iostat = iostat_nml )        ! (out)
   424:                   close( unit_nml )
   425:             
   426:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   427:                 end if
   428:             
   429:             
   430:                 ! 印字 ; Print
   431:                 !
   432:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   433:             
   434:                 call MessageNotify( 'M', module_name, '  VelMin  = %f', d = (/ VelMin  /) )
   435:                 call MessageNotify( 'M', module_name, '  VelMax  = %f', d = (/ VelMax  /) )
   436:                 call MessageNotify( 'M', module_name, '  TempMin = %f', d = (/ TempMin /) )
   437:                 call MessageNotify( 'M', module_name, '  TempMax = %f', d = (/ TempMax /) )
   438:             
   439:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   440:             
   441:                 check_prog_vars_inited = .true.
   442:             
   443:               end subroutine CheckProgVarsInit
   444:             
   445:               !--------------------------------------------------------------------------------------
   446:             
   447:             end module check_prog_vars
