Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:23 2016
FILE NAME: i.intavr_operate.F90
PROGRAM NAME: intavr_operate
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   228  opt  (1592): Outer loop unrolled inside inner loop.
   228  vec  (   4): Vectorized array expression.
   228  vec  (   4): Vectorized array expression.
   229  opt  (1592): Outer loop unrolled inside inner loop.
   230  opt  (1590): Inner loop moved outside outer loop(s).
   231  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   231  vec  (   1): Vectorized loop.
   231  vec  (  29): ADB is used for array.: x_lon_weight
   231  vec  (  29): ADB is used for array.: xya_data
   231  vec  (   1): Vectorized loop.
   231  vec  (  29): ADB is used for array.: xya_data
   231  vec  (  29): ADB is used for array.: x_lon_weight
   233  vec  (  26): Macro operation Sum/InnerProd.
   233  vec  (  26): Macro operation Sum/InnerProd.
   271  vec  (   4): Vectorized array expression.
   274  opt  (1800): Idiom detected (matrix multiply).
   331  vec  (   1): Vectorized loop.
   331  vec  (  29): ADB is used for array.: aa_sendbuf
   331  vec  (  29): ADB is used for array.: y_lat_weight
   331  vec  (  29): ADB is used for array.: ya_data
   334  vec  (   1): Vectorized loop.
   334  vec  (  29): ADB is used for array.: aa_sendbuf
   339  vec  (   3): Unvectorized loop.
   341  opt  (1592): Outer loop unrolled inside inner loop.
   341  vec  (   4): Vectorized array expression.
   341  vec  (  29): ADB is used for array.: aaa_recvbuf
   341  vec  (  29): ADB is used for array.: aa_sendbuf
   341  vec  (   4): Vectorized array expression.
   341  vec  (  29): ADB is used for array.: aaa_recvbuf
   341  vec  (  29): ADB is used for array.: aa_sendbuf
   343  opt  (1017): Subroutine call prevents optimization.
   347  vec  (   3): Unvectorized loop.
   349  opt  (1017): Subroutine call prevents optimization.
   349  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
   350  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
   354  vec  (   4): Vectorized array expression.
   356  opt  (1592): Outer loop unrolled inside inner loop.
   357  vec  (   1): Vectorized loop.
   357  vec  (  29): ADB is used for array.: aaa_recvbuf
   357  vec  (   1): Vectorized loop.
   357  vec  (  29): ADB is used for array.: aaa_recvbuf
   358  vec  (  26): Macro operation Sum/InnerProd.
   358  vec  (  26): Macro operation Sum/InnerProd.
   363  opt  (1592): Outer loop unrolled inside inner loop.
   364  vec  (   1): Vectorized loop.
   364  vec  (  29): ADB is used for array.: aaa_recvbuf
   364  vec  (   1): Vectorized loop.
   364  vec  (  29): ADB is used for array.: aaa_recvbuf
   365  vec  (  26): Macro operation Sum/InnerProd.
   365  vec  (  26): Macro operation Sum/InnerProd.
   425  vec  (   1): Vectorized loop.
   425  vec  (  29): ADB is used for array.: a_sendbuf
   425  vec  (  29): ADB is used for array.: y_lat_weight
   425  vec  (  29): ADB is used for array.: y_data
   428  vec  (   1): Vectorized loop.
   428  vec  (  29): ADB is used for array.: a_sendbuf
   432  vec  (   3): Unvectorized loop.
   434  vec  (   4): Vectorized array expression.
   434  vec  (  29): ADB is used for array.: aa_recvbuf
   434  vec  (  29): ADB is used for array.: a_sendbuf
   436  opt  (1017): Subroutine call prevents optimization.
   440  vec  (   3): Unvectorized loop.
   442  opt  (1017): Subroutine call prevents optimization.
   442  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
   443  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
   449  vec  (   1): Vectorized loop.
   449  vec  (  29): ADB is used for array.: aa_recvbuf
   450  vec  (  26): Macro operation Sum/InnerProd.
   454  vec  (   1): Vectorized loop.
   454  vec  (  29): ADB is used for array.: aa_recvbuf
   455  vec  (  26): Macro operation Sum/InnerProd.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:23 2016
FILE NAME: i.intavr_operate.F90
PROGRAM NAME: intavr_operate
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 積分と平均の操作
     2  !
     3  != Operation for integral and average
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6  ! Version::   $Id: intavr_operate.F90,v 1.6 2014/05/07 09:39:23 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module intavr_operate
    13    !
    14    != 積分と平均の操作
    15    !
    16    != Operation for integral and average
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 積分で用いる座標重みを考慮した積分や平均操作のための関数を提供します.
    21    ! {SPMODEL ライブラリ}[http://www.gfd-dennou.org/library/spmodel]
    22    ! の w_integral_module.f90 を参考に作成しました.
    23    !
    24    ! Functions for integral or average operation with weight for integration
    25    ! are provided
    26    ! This program is created referring to
    27    ! "w_integral_module.f90" in
    28    ! {SPMODEL library}[http://www.gfd-dennou.org/library/spmodel]
    29    !
    30    !== Procedures List
    31    !
    32    ! IntLonLat_xy           :: 緯度経度積分
    33  !!$  ! y_IntLon_xy, IntLon_x  :: 経度積分
    34  !!$  ! ya_IntLon_xya          :: 経度積分 (多層用)
    35  !!$  ! x_IntLat_xy, IntLat_y  :: 緯度積分
    36  !!$  ! xa_IntLat_xya          :: 緯度積分 (多層用)
    37  !!$  ! AvrLonLat_xy           :: 緯度経度平均
    38  !!$  ! y_AvrLon_xy, AvrLon_x  :: 経度平均
    39  !!$  ! ya_AvrLon_xya          :: 経度平均 (多層用)
    40  !!$  ! x_AvrLat_xy, AvrLat_y  :: 緯度平均
    41  !!$  ! xa_AvrLat_xya          :: 緯度平均 (多層用)
    42    ! ---------------------  :: ---------------------
    43    ! y_IntLon_xy, IntLon_x  :: Meridional integral
    44  !!$  ! ya_IntLon_xya          :: Meridional integral (for multi layer)
    45  !!$  ! x_IntLat_xy, IntLat_y  :: Zonal integral
    46  !!$  ! xa_IntLat_xya          :: Zonal integral (for multi layer)
    47  !!$  ! AvrLonLat_xy           :: Zonal and meridional average
    48  !!$  ! y_AvrLon_xy, AvrLon_x  :: Meridional average
    49  !!$  ! ya_AvrLon_xya          :: Meridional average (for multi layer)
    50  !!$  ! x_AvrLat_xy, AvrLat_y  :: Zonal average
    51  !!$  ! xa_AvrLat_xya          :: Zonal average (for multi layer)
    52    !
    53    !--
    54    !== NAMELIST
    55    !
    56    ! NAMELIST#intavr_operate_nml
    57    !++
    58  
    59    ! モジュール引用 ; USE statements
    60    !
    61  
    62    ! 座標データ設定
    63    ! Axes data settings
    64    !
    65    use axesset, only: &
    66      & x_Lon_Weight, &
    67                                ! $ \Delta \lambda $ [rad.] .
    68                                ! 経度座標重み.
    69                                ! Weight of longitude
    70      & y_Lat_Weight
    71                                ! $ \Delta \varphi $ [rad.] .
    72                                ! 緯度座標重み.
    73                                ! Weight of latitude
    74  
    75    ! 格子点設定
    76    ! Grid points settings
    77    !
    78    use gridset, only: imax, & ! 経度格子点数.
    79                               ! Number of grid points in longitude
    80      &                jmax, & ! 緯度格子点数.
    81                               ! Number of grid points in latitude
    82      &                kmax    ! 鉛直層数.
    83                               ! Number of vertical level
    84  
    85    ! 種別型パラメタ
    86    ! Kind type parameter
    87    !
    88    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    89      &                 STRING     ! 文字列.       Strings.
    90  
    91    ! メッセージ出力
    92    ! Message output
    93    !
    94    use dc_message, only: MessageNotify
    95  
    96    ! 宣言文 ; Declaration statements
    97    !
    98    implicit none
    99    private
   100  
   101    ! 公開手続き
   102    ! Public procedure
   103    !
   104    public:: IntLonLat_xy
   105    public:: a_IntLonLat_xya
   106  !!$  public:: y_IntLon_xy, ya_IntLon_xya, IntLon_x
   107  !!$  public:: x_IntLat_xy, xa_IntLat_xya, IntLat_y
   108  !!$  public:: IntLat_y
   109  !!$  public:: AvrLonLat_xy
   110  !!$  public:: y_AvrLon_xy, ya_AvrLon_xya, AvrLon_x
   111  !!$  public:: x_AvrLat_xy, xa_AvrLat_xya, AvrLat_y
   112  
   113    ! 公開変数
   114    ! Public variables
   115    !
   116    logical, save, public:: intavr_operate_inited = .false.
   117                                ! 初期設定フラグ.
   118                                ! Initialization flag
   119  
   120  
   121    ! 非公開変数
   122    ! Private variables
   123    !
   124  
   125    character(*), parameter:: module_name = 'intavr_operate'
   126                                ! モジュールの名称.
   127                                ! Module name
   128    character(*), parameter:: version = &
   129      & '$Name:  $' // &
   130      & '$Id: intavr_operate.F90,v 1.6 2014/05/07 09:39:23 murashin Exp $'
   131                                ! モジュールのバージョン
   132                                ! Module version
   133  
   134    ! INTERFACE 文 ; INTERFACE statements
   135    !
   136  
   137  contains
   138  
   139    !-------------------------------------------------------------------
   140  
   141    function a_IntLonLat_xya( xya_Data )
   142      !
   143      ! 2 次元緯度経度格子点データの全領域積分(1 層用).
   144      !
   145      ! 実際には格子点データ各点毎に x_Lon_Weight, y_Lat_Weight を掛けた
   146      ! 総和を計算している.
   147      !
   148      ! Global integration of 2-dimensional (latitude and longitude)
   149      ! grid data.
   150      !
   151      ! Practically, the sum total of grid data is calculated
   152      ! by multiplying in each grid "x_Lon_Weight" and "y_Lat_Weight".
   153      !
   154  
   155      real(DP), intent(in) :: xya_Data       (:,:,:)
   156      real(DP)             :: a_IntLonLat_xya(size(xya_Data,3))
   157  
   158  
   159      ! 実行文 ; Executable statement
   160      !
   161  
   162  
   163      a_IntLonLat_xya = a_IntLat_ya( ya_IntLon_xya( xya_Data ) )
   164  
   165  
   166    end function a_IntLonLat_xya
   167  
   168    !-------------------------------------------------------------------
   169  
   170    function IntLonLat_xy( xy_Data )
   171      !
   172      ! 2 次元緯度経度格子点データの全領域積分(1 層用).
   173      !
   174      ! 実際には格子点データ各点毎に x_Lon_Weight, y_Lat_Weight を掛けた
   175      ! 総和を計算している.
   176      !
   177      ! Global integration of 2-dimensional (latitude and longitude)
   178      ! grid data.
   179      !
   180      ! Practically, the sum total of grid data is calculated
   181      ! by multiplying in each grid "x_Lon_Weight" and "y_Lat_Weight".
   182      !
   183  
   184      real(DP), intent(in) :: xy_Data (0:imax-1, 1:jmax)
   185      real(DP)             :: IntLonLat_xy
   186  
   187      ! 実行文 ; Executable statement
   188      !
   189  
   190      IntLonLat_xy = IntLat_y( y_IntLon_xy( xy_Data ) )
   191  
   192    end function IntLonLat_xy
   193  
   194    !-------------------------------------------------------------------
   195  
   196    function ya_IntLon_xya( xya_Data )
   197      !
   198      ! 2 次元緯度経度格子点データの経度方向積分(1 層用).
   199      !
   200      ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   201      ! 総和を計算している.
   202      !
   203      ! Zonal integration of 2-dimensional (latitude and longitude)
   204      ! grid data.
   205      !
   206      ! Practically, the sum total of grid data is calculated
   207      ! by multiplying in each grid "x_Lon_Weight".
   208      !
   209  
   210      real(DP), intent(in) :: xya_Data     (:,:,:)
   211      real(DP)             :: ya_IntLon_xya(size(xya_Data,2), size(xya_Data,3))
   212  
   213      ! 作業変数
   214      ! Work variables
   215      !
   216      integer:: lmax
   217      integer:: i               ! 経度方向に回る DO ループ用作業変数
   218                                ! Work variables for DO loop in longitudinal direction
   219      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   220                                ! Work variables for DO loop in latitudinal direction
   221      integer:: l
   222  
   223  
   224      ! 実行文 ; Executable statement
   225      !
   226      lmax = size( xya_Data, 3 )
   227  
   228      ya_IntLon_xya = 0.0_DP
     .        if (ya_intlon_xya.DESCRIPT.RETVAL.DSC.U2 .gt. 0) then             
     .           j3 = and(ya_intlon_xya.DESCRIPT.RETVAL.DSC.U2,3)               
     .  !cdir    nodep                                                          
     .           do t86 = 1, j3                                                 
     .  !cdir       nodep                                                       
     .              do t88 = 1, ya_intlon_xya.DESCRIPT.RETVAL.DSC.U1            
     .                 ya_intlon_xya(t88,t86) = 0.0000000000000000e+000         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t86 = j3 + 1, ya_intlon_xya.DESCRIPT.RETVAL.DSC.U2, 4       
     .  !cdir       nodep                                                       
     .              do t88 = 1, ya_intlon_xya.DESCRIPT.RETVAL.DSC.U1            
     .                 ya_intlon_xya(t88,t86) = 0.0000000000000000e+000         
     .                 ya_intlon_xya(t88,t86+1) = 0.0000000000000000e+000       
     .                 ya_intlon_xya(t88,t86+2) = 0.0000000000000000e+000       
     .                 ya_intlon_xya(t88,t86+3) = 0.0000000000000000e+000       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   229      do l = 1, lmax
   230        do j = 1, jmax
   231          do i = 0, imax - 1
   232  !!$          ya_IntLon_xya(j,l) = ya_IntLon_xya(j,l) + xya_Data(i,j,l) * x_Lon_Weight(i)
   233            ya_IntLon_xya(j,l) = ya_IntLon_xya(j,l) + xya_Data(i+1,j,l) * x_Lon_Weight(i)
   234          end do
   235        end do
   236      end do
     .  !cdir noassume                                                          
     .        do i1 = 0, imax - 1, maxvl()                                      
     .           i2 = min0(imax - i1,maxvl())                                   
     .           do j = 1, jmax                                                 
     .              if (lmax .gt. 0) then                                       
     .                 j6 = and(lmax,3)                                         
     .                 do l = 1, j6                                             
     .                    ya_intlon_xya2 = ya_intlon_xya(j,l)                   
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(x_lon_weight)                                  
     .                    do i = 1, i2                                          
     .                       ya_intlon_xya2 = ya_intlon_xya2 + xya_data(i1+i,j,l
     .       1                  )*x_lon_weight(i1+i-1)                          
     .                    enddo                                                 
     .                    ya_intlon_xya(j,l) = ya_intlon_xya2                   
     .                 enddo                                                    
     .                 do l = j6 + 1, lmax, 4                                   
     .                    ya_intlon_xya3 = ya_intlon_xya(j,l)                   
     .                    ya_intlon_xya4 = ya_intlon_xya(j,l+1)                 
     .                    ya_intlon_xya5 = ya_intlon_xya(j,l+2)                 
     .                    ya_intlon_xya6 = ya_intlon_xya(j,l+3)                 
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(x_lon_weight)                                  
     .                    do i = 1, i2                                          
     .                       d1 = x_lon_weight(i1+i-1)                          
     .                       ya_intlon_xya3 = ya_intlon_xya3 + xya_data(i1+i,j,l
     .       1                  )*d1                                            
     .                       ya_intlon_xya4 = ya_intlon_xya4 + xya_data(i1+i,j,l
     .       1                  +1)*d1                                          
     .                       ya_intlon_xya5 = ya_intlon_xya5 + xya_data(i1+i,j,l
     .       1                  +2)*d1                                          
     .                       ya_intlon_xya6 = ya_intlon_xya6 + xya_data(i1+i,j,l
     .       1                  +3)*d1                                          
     .                    enddo                                                 
     .                    ya_intlon_xya(j,l+3) = ya_intlon_xya6                 
     .                    ya_intlon_xya(j,l+2) = ya_intlon_xya5                 
     .                    ya_intlon_xya(j,l+1) = ya_intlon_xya4                 
     .                    ya_intlon_xya(j,l) = ya_intlon_xya3                   
     .                 enddo                                                    
     .              endif                                                       
     .           enddo                                                          
     .        enddo                                                             
   237  
   238  
   239    end function ya_IntLon_xya
   240  
   241    !-------------------------------------------------------------------
   242  
   243    function y_IntLon_xy( xy_Data )
   244      !
   245      ! 2 次元緯度経度格子点データの経度方向積分(1 層用).
   246      !
   247      ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   248      ! 総和を計算している.
   249      !
   250      ! Zonal integration of 2-dimensional (latitude and longitude)
   251      ! grid data.
   252      !
   253      ! Practically, the sum total of grid data is calculated
   254      ! by multiplying in each grid "x_Lon_Weight".
   255      !
   256  
   257      real(DP), intent(in) :: xy_Data (0:imax-1, 1:jmax)
   258      real(DP)             :: y_IntLon_xy (1:jmax)
   259  
   260      ! 作業変数
   261      ! Work variables
   262      !
   263      integer:: i               ! 経度方向に回る DO ループ用作業変数
   264                                ! Work variables for DO loop in longitudinal direction
   265      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   266                                ! Work variables for DO loop in latitudinal direction
   267  
   268      ! 実行文 ; Executable statement
   269      !
   270  
   271      y_IntLon_xy = 0.0_DP
   272      do j = 1, jmax
   273        do i = 0, imax - 1
   274          y_IntLon_xy(j) = y_IntLon_xy(j) + xy_Data (i,j) * x_Lon_Weight(i)
   275        end do
   276      end do
     .           call vdmxpa (xy_data(0,1), 1*imax, 1, x_lon_weight(0), 1,      
     .       1   y_intlon_xy(1), 1, jmax, imax)                                 
   277  
   278    end function y_IntLon_xy
   279  
   280  
   281    !-------------------------------------------------------------------
   282  
   283    function a_IntLat_ya( ya_Data )
   284      !
   285      ! 1 次元緯度経度格子点データの全領域平均(1 層用).
   286      !
   287      ! Global mean of 2-dimensional (latitude and longitude)
   288      ! grid data.
   289      !
   290  
   291      ! MPI
   292      !
   293      use mpi_wrapper, only: nprocs, myrank, &
   294        & MPIWrapperISend, &
   295        & MPIWrapperIRecv, &
   296        & MPIWrapperWait
   297  
   298      ! 格子点数・最大波数設定
   299      ! Number of grid points and maximum truncated wavenumber settings
   300      !
   301      use gridset, only: a_jmax, jmax_max
   302  
   303      real(DP), intent(in) :: ya_Data (:,:)
   304      real(DP)             :: a_IntLat_ya(size(ya_Data,2))
   305  
   306  
   307      ! Local variable
   308      !
   309      integer               :: lmax
   310      real(DP), allocatable :: aa_SendBuf (:,:)
   311      real(DP), allocatable :: aaa_RecvBuf(:,:,:)
   312      integer , allocatable :: a_iReqSend (:)
   313      integer , allocatable :: a_iReqRecv (:)
   314  
   315      integer               :: j
   316      integer               :: l
   317      integer               :: n
   318  
   319  
   320      ! 実行文 ; Executable statement
   321      !
   322      lmax = size(ya_Data,2)
   323  
   324  
   325      allocate( aa_SendBuf (1:jmax_max, 1:lmax) )
   326      allocate( aaa_RecvBuf(1:jmax_max, 1:lmax, 0:nprocs-1) )
   327      allocate( a_iReqSend(0:nprocs-1) )
   328      allocate( a_iReqRecv(0:nprocs-1) )
   329  
   330      do l = 1, lmax
   331        do j = 1, jmax
     .  !cdir nodep                                                             
     .  !cdir on_adb(y_lat_weight)                                              
     .        do j = 1, jmax                                                    
   332          aa_SendBuf(j,l) = ya_Data(j,l) * y_Lat_Weight(j)
   333        end do
   334        do j = jmax+1, jmax_max
   335          aa_SendBuf(j,l) = -1.0_DP
   336        end do
   337      end do
   338  
   339      do n = 0, nprocs-1
   340        if ( n == myrank ) then
   341          aaa_RecvBuf(:,:,n) = aa_SendBuf
     .           if (aaa_recvbuf.DSC.U2 + 1 - aaa_recvbuf.DSC.L2 .gt. 0) then   
     .           j2 = and(aaa_recvbuf.DSC.U2 + 1 - aaa_recvbuf.DSC.L2,3)        
     .  !cdir    nodep                                                          
     .           do t322 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t324 = 1, aaa_recvbuf.DSC.U1 - aaa_recvbuf.DSC.L1 + 2 -  
     .       1         min0(1,aaa_recvbuf.DSC.U1 - aaa_recvbuf.DSC.L1 + 1)      
     .                 aaa_recvbuf(t19+t324-1,t322-1+t21,n) = aa_sendbuf(       
     .       1            aa_sendbuf.DSC.L1+t324-1,t322-1+aa_sendbuf.DSC.L2)    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t322=j2+1,aaa_recvbuf.DSC.U2+1-aaa_recvbuf.DSC.L2,4         
     .  !cdir       nodep                                                       
     .              do t324 = 1, aaa_recvbuf.DSC.U1 - aaa_recvbuf.DSC.L1 + 2 -  
     .       1         min0(1,aaa_recvbuf.DSC.U1 - aaa_recvbuf.DSC.L1 + 1)      
     .                 aaa_recvbuf(t19+t324-1,t322-1+t21,n) = aa_sendbuf(       
     .       1            aa_sendbuf.DSC.L1+t324-1,t322-1+aa_sendbuf.DSC.L2)    
     .                 aaa_recvbuf(t19+t324-1,t322+t21,n) = aa_sendbuf(         
     .       1            aa_sendbuf.DSC.L1+t324-1,t322+aa_sendbuf.DSC.L2)      
     .                 aaa_recvbuf(t19+t324-1,t322+1+t21,n) = aa_sendbuf(       
     .       1            aa_sendbuf.DSC.L1+t324-1,t322+1+aa_sendbuf.DSC.L2)    
     .                 aaa_recvbuf(t19+t324-1,t322+2+t21,n) = aa_sendbuf(       
     .       1            aa_sendbuf.DSC.L1+t324-1,t322+2+aa_sendbuf.DSC.L2)    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10011                                                        
   342        else
   343          call MPIWrapperISend( n, jmax_max, lmax, aa_SendBuf        , a_iReqSend(n) )
   344          call MPIWrapperIRecv( n, jmax_max, lmax, aaa_RecvBuf(:,:,n), a_iReqRecv(n) )
   345        end if
   346      end do
   347      do n = 0, nprocs-1
   348        if ( n == myrank ) cycle
   349        call MPIWrapperWait( a_iReqSend(n) )
   350        call MPIWrapperWait( a_iReqRecv(n) )
   351      end do
   352  
   353  
   354      a_IntLat_ya = 0.0_DP
   355      do n = nprocs-1, 0, -1
   356        do l = 1, lmax
   357          do j = 1, a_jmax(n) / 2
   358            a_IntLat_ya(l) = a_IntLat_ya(l) + aaa_RecvBuf(j,l,n)
   359          end do
   360        end do
     .           if (lmax .gt. 0) then                                          
     .           j3 = and(lmax,3)                                               
     .           do l = 1, j3                                                   
     .              if (a_jmax(n)/2 .gt. 0) then                                
     .                 a_intlat_ya1 = a_intlat_ya(l)                            
     .  !cdir          nodep                                                    
     .                 do j = 1, a_jmax(n)/2                                    
     .                    a_intlat_ya1 = a_intlat_ya1 + aaa_recvbuf(j,l,n)      
     .                 enddo                                                    
     .                 a_intlat_ya(l) = a_intlat_ya1                            
     .              endif                                                       
     .           enddo                                                          
     .           do l = j3 + 1, lmax, 4                                         
     .              if (a_jmax(n)/2 .gt. 0) then                                
     .                 a_intlat_ya2 = a_intlat_ya(l)                            
     .                 a_intlat_ya3 = a_intlat_ya(l+1)                          
     .                 a_intlat_ya4 = a_intlat_ya(l+2)                          
     .                 a_intlat_ya5 = a_intlat_ya(l+3)                          
     .  !cdir          nodep                                                    
     .                 do j = 1, a_jmax(n)/2                                    
     .                    a_intlat_ya2 = a_intlat_ya2 + aaa_recvbuf(j,l,n)      
     .                    a_intlat_ya3 = a_intlat_ya3 + aaa_recvbuf(j,l+1,n)    
     .                    a_intlat_ya4 = a_intlat_ya4 + aaa_recvbuf(j,l+2,n)    
     .                    a_intlat_ya5 = a_intlat_ya5 + aaa_recvbuf(j,l+3,n)    
     .                 enddo                                                    
     .                 a_intlat_ya(l+3) = a_intlat_ya5                          
     .                 a_intlat_ya(l+2) = a_intlat_ya4                          
     .                 a_intlat_ya(l+1) = a_intlat_ya3                          
     .                 a_intlat_ya(l) = a_intlat_ya2                            
     .              endif                                                       
     .           enddo                                                          
     .        endif                                                             
   361      end do
   362      do n = 0, nprocs-1
   363        do l = 1, lmax
   364          do j = a_jmax(n) / 2 + 1, a_jmax(n)
   365            a_IntLat_ya(l) = a_IntLat_ya(l) + aaa_RecvBuf(j,l,n)
   366          end do
   367        end do
     .        if (lmax .gt. 0) then                                             
     .           j4 = and(lmax,3)                                               
     .           do l = 1, j4                                                   
     .              if (a_jmax(n) - a_jmax(n)/2 .gt. 0) then                    
     .                 a_intlat_ya6 = a_intlat_ya(l)                            
     .                 a_jmax5 = a_jmax(n)                                      
     .  !cdir          nodep                                                    
     .                 do j = 1, a_jmax(n) - a_jmax(n)/2                        
     .                    a_intlat_ya6 = a_intlat_ya6 + aaa_recvbuf(a_jmax5/2+j,
     .       1               l,n)                                               
     .                 enddo                                                    
     .                 a_intlat_ya(l) = a_intlat_ya6                            
     .              endif                                                       
     .           enddo                                                          
     .           do l = j4 + 1, lmax, 4                                         
     .              if (a_jmax(n) - a_jmax(n)/2 .gt. 0) then                    
     .                 a_intlat_ya7 = a_intlat_ya(l)                            
     .                 a_jmax6 = a_jmax(n)                                      
     .                 a_intlat_ya8 = a_intlat_ya(l+1)                          
     .                 a_intlat_ya9 = a_intlat_ya(l+2)                          
     .                 a_intlat_ya10 = a_intlat_ya(l+3)                         
     .  !cdir          nodep                                                    
     .                 do j = 1, a_jmax(n) - a_jmax(n)/2                        
     .                    a_intlat_ya7 = a_intlat_ya7 + aaa_recvbuf(a_jmax6/2+j,
     .       1               l,n)                                               
     .                    a_intlat_ya8 = a_intlat_ya8 + aaa_recvbuf(a_jmax6/2+j,
     .       1               l+1,n)                                             
     .                    a_intlat_ya9 = a_intlat_ya9 + aaa_recvbuf(a_jmax6/2+j,
     .       1               l+2,n)                                             
     .                    a_intlat_ya10 = a_intlat_ya10 + aaa_recvbuf(a_jmax6/2+
     .       1               j,l+3,n)                                           
     .                 enddo                                                    
     .                 a_intlat_ya(l+3) = a_intlat_ya10                         
     .                 a_intlat_ya(l+2) = a_intlat_ya9                          
     .                 a_intlat_ya(l+1) = a_intlat_ya8                          
     .                 a_intlat_ya(l) = a_intlat_ya7                            
     .              endif                                                       
     .           enddo                                                          
     .        endif                                                             
   368      end do
   369  
   370  
   371      deallocate( aa_SendBuf  )
   372      deallocate( aaa_RecvBuf )
   373      deallocate( a_iReqSend  )
   374      deallocate( a_iReqRecv  )
   375  
   376  
   377    end function a_IntLat_ya
   378  
   379    !-------------------------------------------------------------------
   380  
   381    function IntLat_y( y_Data )
   382      !
   383      ! 1 次元緯度経度格子点データの全領域平均(1 層用).
   384      !
   385      ! Global mean of 2-dimensional (latitude and longitude)
   386      ! grid data.
   387      !
   388  
   389      ! MPI
   390      !
   391      use mpi_wrapper, only: nprocs, myrank, &
   392        & MPIWrapperISend, &
   393        & MPIWrapperIRecv, &
   394        & MPIWrapperWait
   395  
   396      ! 格子点数・最大波数設定
   397      ! Number of grid points and maximum truncated wavenumber settings
   398      !
   399      use gridset, only: a_jmax, jmax_max
   400  
   401      real(DP), intent(in) :: y_Data (1:jmax)
   402      real(DP)             :: IntLat_y
   403  
   404  
   405      ! Local variable
   406      !
   407      real(DP), allocatable :: a_SendBuf (:)
   408      real(DP), allocatable :: aa_RecvBuf(:,:)
   409      integer , allocatable :: a_iReqSend(:)
   410      integer , allocatable :: a_iReqRecv(:)
   411  
   412      integer               :: j
   413      integer               :: n
   414  
   415  
   416      ! 実行文 ; Executable statement
   417      !
   418  
   419  
   420      allocate( a_SendBuf (1:jmax_max) )
   421      allocate( aa_RecvBuf(1:jmax_max,0:nprocs-1) )
   422      allocate( a_iReqSend(0:nprocs-1) )
   423      allocate( a_iReqRecv(0:nprocs-1) )
   424  
   425      do j = 1, jmax
   426        a_SendBuf(j) = y_Data(j) * y_Lat_Weight(j)
   427      end do
   428      do j = jmax+1, jmax_max
   429        a_SendBuf(j) = -1.0_DP
   430      end do
   431  
   432      do n = 0, nprocs-1
   433        if ( n == myrank ) then
   434          aa_RecvBuf(:,n) = a_SendBuf
   435        else
   436          call MPIWrapperISend( n, jmax_max, a_SendBuf      , a_iReqSend(n) )
   437          call MPIWrapperIRecv( n, jmax_max, aa_RecvBuf(:,n), a_iReqRecv(n) )
   438        end if
   439      end do
   440      do n = 0, nprocs-1
   441        if ( n == myrank ) cycle
   442        call MPIWrapperWait( a_iReqSend(n) )
   443        call MPIWrapperWait( a_iReqRecv(n) )
   444      end do
   445  
   446  
   447      IntLat_y = 0.0d0
   448      do n = nprocs-1, 0, -1
   449        do j = 1, a_jmax(n) / 2
   450          IntLat_y = IntLat_y + aa_RecvBuf(j,n)
   451        end do
     .  !cdir    nodep                                                          
     .        do j = 1, a_jmax(n)/2                                             
     .           intlat_y = intlat_y + aa_recvbuf(j,n)                          
     .        enddo                                                             
   452      end do
   453      do n = 0, nprocs-1
   454        do j = a_jmax(n) / 2 + 1, a_jmax(n)
   455          IntLat_y = IntLat_y + aa_RecvBuf(j,n)
   456        end do
     .        a_jmax1 = a_jmax(n)                                               
     .  !cdir nodep                                                             
     .        do j = 1, a_jmax(n) - a_jmax(n)/2                                 
     .           intlat_y = intlat_y + aa_recvbuf(a_jmax1/2+j,n)                
     .        enddo                                                             
   457      end do
   458  
   459  
   460      deallocate( a_SendBuf  )
   461      deallocate( aa_RecvBuf )
   462      deallocate( a_iReqSend )
   463      deallocate( a_iReqRecv )
   464  
   465  
   466    end function IntLat_y
   467  
   468  
   469    !-------------------------------------------------------------------
   470  !!$
   471  !!$  function AvrLonLat_xy( xy_Data )
   472  !!$    !
   473  !!$    ! 2 次元緯度経度格子点データの全領域平均(1 層用).
   474  !!$    !
   475  !!$    ! Global mean of 2-dimensional (latitude and longitude)
   476  !!$    ! grid data.
   477  !!$    !
   478  !!$
   479  !!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
   480  !!$
   481  !!$
   482  !!$    ! Local variable
   483  !!$    !
   484  !!$    real(DP)              :: AvrLonLat_xy
   485  !!$
   486  !!$
   487  !!$    ! 実行文 ; Executable statement
   488  !!$    !
   489  !!$
   490  !!$    ! Old one to be deleted
   491  !!$!    AvrLonLat_xy = AvrLon_x( x_AvrLat_xy( xy_Data ) )
   492  !!$
   493  !!$    AvrLonLat_xy = AvrLat_y( y_AvrLon_xy( xy_Data ) )
   494  !!$
   495  !!$
   496  !!$  end function AvrLonLat_xy
   497  !!$
   498  !!$  !-------------------------------------------------------------------
   499  !!$
   500  !!$  function x_IntLat_xy( xy_Data )
   501  !!$    !
   502  !!$    ! 2 次元緯度経度格子点データの緯度方向積分(1 層用).
   503  !!$    !
   504  !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   505  !!$    ! 総和を計算している.
   506  !!$    !
   507  !!$    ! Meridional integration of 2-dimensional (latitude and longitude)
   508  !!$    ! grid data.
   509  !!$    !
   510  !!$    ! Practically, the sum total of grid data is calculated
   511  !!$    ! by multiplying in each grid "y_Lat_Weight".
   512  !!$    !
   513  !!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
   514  !!$    real(DP):: x_IntLat_xy (0:imax-1)
   515  !!$
   516  !!$    ! 作業変数
   517  !!$    ! Work variables
   518  !!$    !
   519  !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   520  !!$                              ! Work variables for DO loop in latitude
   521  !!$
   522  !!$    ! 実行文 ; Executable statement
   523  !!$    !
   524  !!$    x_IntLat_xy = 0.0_DP
   525  !!$    do j = 1, jmax
   526  !!$      x_IntLat_xy = x_IntLat_xy + xy_Data (:,j) * y_Lat_Weight(j)
   527  !!$    enddo
   528  !!$  end function x_IntLat_xy
   529  !!$
   530  !!$  !-------------------------------------------------------------------
   531  !!$
   532  !!$  function xa_IntLat_xya( xya_Data )
   533  !!$    !
   534  !!$    ! 3 次元緯度経度格子点データの緯度方向積分(多層用).
   535  !!$    !
   536  !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   537  !!$    ! 総和を計算している.
   538  !!$    !
   539  !!$    ! Meridional integration of 3-dimensional (latitude and longitude)
   540  !!$    ! grid data. (for multi layer)
   541  !!$    !
   542  !!$    ! Practically, the sum total of grid data is calculated
   543  !!$    ! by multiplying in each grid "y_Lat_Weight".
   544  !!$    !
   545  !!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
   546  !!$    real(DP):: xa_IntLat_xya (0:imax-1, 1:kmax)
   547  !!$
   548  !!$    ! 作業変数
   549  !!$    ! Work variables
   550  !!$    !
   551  !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   552  !!$                              ! Work variables for DO loop in vertical direction
   553  !!$
   554  !!$    ! 実行文 ; Executable statement
   555  !!$    !
   556  !!$    do k = 1, kmax
   557  !!$      xa_IntLat_xya(:,k) = x_IntLat_xy( xya_Data(:,:,k) )
   558  !!$    end do
   559  !!$  end function xa_IntLat_xya
   560  !!$
   561  !!$  !-------------------------------------------------------------------
   562  !!$
   563  !!$  function ya_IntLon_xya( xya_Data )
   564  !!$    !
   565  !!$    ! 3 次元緯度経度格子点データの経度方向積分(多層用).
   566  !!$    !
   567  !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   568  !!$    ! 総和を計算している.
   569  !!$    !
   570  !!$    ! Zonal integration of 3-dimensional (latitude and longitude)
   571  !!$    ! grid data. (for multi layer)
   572  !!$    !
   573  !!$    ! Practically, the sum total of grid data is calculated
   574  !!$    ! by multiplying in each grid "x_Lon_Weight".
   575  !!$    !
   576  !!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
   577  !!$    real(DP):: ya_IntLon_xya (1:jmax,1:kmax)
   578  !!$
   579  !!$    ! 作業変数
   580  !!$    ! Work variables
   581  !!$    !
   582  !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   583  !!$                              ! Work variables for DO loop in vertical direction
   584  !!$
   585  !!$    ! 実行文 ; Executable statement
   586  !!$    !
   587  !!$    do k = 1, kmax
   588  !!$      ya_IntLon_xya(:,k) = y_IntLon_xy( xya_Data(:,:,k) )
   589  !!$    end do
   590  !!$  end function ya_IntLon_xya
   591  !!$
   592  !!$  !-------------------------------------------------------------------
   593  !!$
   594  !!$  function IntLon_x( x_Data )
   595  !!$    !
   596  !!$    ! 1 次元経度格子点データの経度方向積分(1 層用).
   597  !!$    !
   598  !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   599  !!$    ! 総和を計算している.
   600  !!$    !
   601  !!$    ! Zonal integration of 1-dimensional (longitude)
   602  !!$    ! grid data.
   603  !!$    !
   604  !!$    ! Practically, the sum total of grid data is calculated
   605  !!$    ! by multiplying in each grid "x_Lon_Weight".
   606  !!$    !
   607  !!$    real(DP), intent(in):: x_Data (0:imax-1)
   608  !!$    real(DP):: IntLon_x
   609  !!$
   610  !!$    ! 作業変数
   611  !!$    ! Work variables
   612  !!$    !
   613  !!$
   614  !!$    ! 実行文 ; Executable statement
   615  !!$    !
   616  !!$    IntLon_x = sum( x_Data * x_Lon_Weight )
   617  !!$  end function IntLon_x
   618  !!$
   619  !!$  !-------------------------------------------------------------------
   620  !!$
   621  !!$  function x_AvrLat_xy( xy_Data )
   622  !!$    !
   623  !!$    ! 2 次元緯度経度格子点データの緯度方向平均(1 層用).
   624  !!$    !
   625  !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   626  !!$    ! 総和を計算し, y_Lat_Weight の総和で割ることで
   627  !!$    ! 平均している.
   628  !!$    !
   629  !!$    ! Meridional mean of 2-dimensional (latitude and longitude)
   630  !!$    ! grid data.
   631  !!$    !
   632  !!$    ! Practically, the mean grid data is calculated
   633  !!$    ! by multiplying in each grid "y_Lat_Weight"
   634  !!$    ! and deviding by the sum total of "y_Lat_Weight".
   635  !!$    !
   636  !!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
   637  !!$    real(DP):: x_AvrLat_xy (0:imax-1)
   638  !!$
   639  !!$    ! 作業変数
   640  !!$    ! Work variables
   641  !!$    !
   642  !!$
   643  !!$    ! 実行文 ; Executable statement
   644  !!$    !
   645  !!$    x_AvrLat_xy = x_IntLat_xy ( xy_Data ) / sum( y_Lat_Weight )
   646  !!$  end function x_AvrLat_xy
   647  !!$
   648  !!$  !-------------------------------------------------------------------
   649  !!$
   650  !!$  function xa_AvrLat_xya( xya_Data )
   651  !!$    !
   652  !!$    ! 3 次元緯度経度格子点データの緯度方向平均(多層用).
   653  !!$    !
   654  !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   655  !!$    ! 総和を計算し, y_Lat_Weight の総和で割ることで
   656  !!$    ! 平均している.
   657  !!$    !
   658  !!$    ! Meridional mean of 3-dimensional (latitude and longitude)
   659  !!$    ! grid data. (for multi layer)
   660  !!$    !
   661  !!$    ! Practically, the mean grid data is calculated
   662  !!$    ! by multiplying in each grid "y_Lat_Weight"
   663  !!$    ! and deviding by the sum total of "y_Lat_Weight".
   664  !!$    !
   665  !!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
   666  !!$    real(DP):: xa_AvrLat_xya (0:imax-1, 1:kmax)
   667  !!$
   668  !!$    ! 作業変数
   669  !!$    ! Work variables
   670  !!$    !
   671  !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   672  !!$                              ! Work variables for DO loop in vertical direction
   673  !!$
   674  !!$    ! 実行文 ; Executable statement
   675  !!$    !
   676  !!$    do k = 1, kmax
   677  !!$      xa_AvrLat_xya(:,k) = x_AvrLat_xy( xya_Data(:,:,k) )
   678  !!$    end do
   679  !!$  end function xa_AvrLat_xya
   680  !!$
   681  !!$  !-------------------------------------------------------------------
   682  !!$
   683  !!$  function y_AvrLon_xy( xy_Data )
   684  !!$    !
   685  !!$    ! 2 次元緯度経度格子点データの経度方向平均(1 層用).
   686  !!$    !
   687  !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   688  !!$    ! 総和を計算し, x_Lon_Weight の総和で割ることで
   689  !!$    ! 平均している.
   690  !!$    !
   691  !!$    ! Zonal mean of 2-dimensional (latitude and longitude)
   692  !!$    ! grid data.
   693  !!$    !
   694  !!$    ! Practically, the mean grid data is calculated
   695  !!$    ! by multiplying in each grid "x_Lon_Weight"
   696  !!$    ! and deviding by the sum total of "x_Lon_Weight".
   697  !!$    !
   698  !!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
   699  !!$    real(DP):: y_AvrLon_xy (1:jmax)
   700  !!$
   701  !!$    ! 作業変数
   702  !!$    ! Work variables
   703  !!$    !
   704  !!$
   705  !!$    ! 実行文 ; Executable statement
   706  !!$    !
   707  !!$    y_AvrLon_xy = y_IntLon_xy( xy_Data ) / sum( x_Lon_Weight )
   708  !!$  end function y_AvrLon_xy
   709  !!$
   710  !!$  !-------------------------------------------------------------------
   711  !!$
   712  !!$  function ya_AvrLon_xya( xya_Data )
   713  !!$    !
   714  !!$    ! 3 次元緯度経度格子点データの経度方向平均(多層用).
   715  !!$    !
   716  !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   717  !!$    ! 総和を計算し, x_Lon_Weight の総和で割ることで
   718  !!$    ! 平均している.
   719  !!$    !
   720  !!$    ! Zonal mean of 3-dimensional (latitude and longitude)
   721  !!$    ! grid data. (for multi layer)
   722  !!$    !
   723  !!$    ! Practically, the mean grid data is calculated
   724  !!$    ! by multiplying in each grid "x_Lon_Weight"
   725  !!$    ! and deviding by the sum total of "x_Lon_Weight".
   726  !!$    !
   727  !!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
   728  !!$    real(DP):: ya_AvrLon_xya (1:jmax, 1:kmax)
   729  !!$
   730  !!$    ! 作業変数
   731  !!$    ! Work variables
   732  !!$    !
   733  !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   734  !!$                              ! Work variables for DO loop in vertical direction
   735  !!$
   736  !!$    ! 実行文 ; Executable statement
   737  !!$    !
   738  !!$    do k = 1, kmax
   739  !!$      ya_AvrLon_xya(:,k) = y_AvrLon_xy( xya_Data(:,:,k) )
   740  !!$    end do
   741  !!$  end function ya_AvrLon_xya
   742  !!$
   743  !!$#ifdef 1
   744  !!$  !-------------------------------------------------------------------
   745  !!$
   746  !!$  function AvrLat_y( y_Data )
   747  !!$    !
   748  !!$    ! 1 次元緯度格子点データの緯度方向平均(1 層用).
   749  !!$    !
   750  !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   751  !!$    ! 総和を計算し, y_Lat_Weight の総和で割ることで
   752  !!$    ! 平均している.
   753  !!$    !
   754  !!$    ! Meridonal mean of 1-dimensional (latitude)
   755  !!$    ! grid data.
   756  !!$    !
   757  !!$    ! Practically, the sum total of grid data is calculated
   758  !!$    ! by multiplying in each grid "y_Lat_Weight"
   759  !!$    ! and deviding by the sum total of "y_Lat_Weight".
   760  !!$    !
   761  !!$
   762  !!$    ! MPI
   763  !!$    !
   764  !!$    use mpi_wrapper, only: nprocs, myrank, &
   765  !!$      & MPIWrapperISend, &
   766  !!$      & MPIWrapperIRecv, &
   767  !!$      & MPIWrapperWait
   768  !!$
   769  !!$    ! 格子点数・最大波数設定
   770  !!$    ! Number of grid points and maximum truncated wavenumber settings
   771  !!$    !
   772  !!$    use gridset, only: a_jmax, jmax_max
   773  !!$
   774  !!$    real(DP), intent(in):: y_Data (1:jmax)
   775  !!$    real(DP):: AvrLat_y
   776  !!$
   777  !!$    ! 作業変数
   778  !!$    ! Work variables
   779  !!$    !
   780  !!$
   781  !!$    ! 実行文 ; Executable statement
   782  !!$    !
   783  !!$
   784  !!$    real(DP), allocatable :: a_SendBuf (:)
   785  !!$    real(DP), allocatable :: aa_RecvBuf(:,:)
   786  !!$    integer , allocatable :: a_iReqSend(:)
   787  !!$    integer , allocatable :: a_iReqRecv(:)
   788  !!$
   789  !!$    real(DP)              :: SumWeight
   790  !!$
   791  !!$    integer               :: j
   792  !!$    integer               :: n
   793  !!$
   794  !!$    allocate( a_SendBuf (1:jmax_max) )
   795  !!$    allocate( aa_RecvBuf(1:jmax_max,0:nprocs-1) )
   796  !!$    allocate( a_iReqSend(0:nprocs-1) )
   797  !!$    allocate( a_iReqRecv(0:nprocs-1) )
   798  !!$
   799  !!$    do j = 1, jmax
   800  !!$      a_SendBuf(j) = y_Lat_Weight(j)
   801  !!$    end do
   802  !!$    do j = jmax+1, jmax_max
   803  !!$      a_SendBuf(j) = -1.0d0
   804  !!$    end do
   805  !!$
   806  !!$    do n = 0, nprocs-1
   807  !!$      if ( n == myrank ) then
   808  !!$        do j = 1, jmax
   809  !!$          aa_RecvBuf(:,n) = a_SendBuf
   810  !!$        end do
   811  !!$      else
   812  !!$        call MPIWrapperISend( n, jmax_max, a_SendBuf      , a_iReqSend(n) )
   813  !!$        call MPIWrapperIRecv( n, jmax_max, aa_RecvBuf(:,n), a_iReqRecv(n) )
   814  !!$      end if
   815  !!$    end do
   816  !!$    do n = 0, nprocs-1
   817  !!$      if ( n == myrank ) cycle
   818  !!$      call MPIWrapperWait( a_iReqSend(n) )
   819  !!$      call MPIWrapperWait( a_iReqRecv(n) )
   820  !!$    end do
   821  !!$
   822  !!$
   823  !!$    if ( nprocs == 1 ) then
   824  !!$      SumWeight = 0.0d0
   825  !!$      do n = 0, nprocs-1
   826  !!$        do j = 1, a_jmax(n)
   827  !!$          SumWeight = SumWeight + aa_RecvBuf(j,n)
   828  !!$        end do
   829  !!$      end do
   830  !!$    else
   831  !!$
   832  !!$      write( 6, * ) 'THIS WOULD BE WRONG.'
   833  !!$
   834  !!$      SumWeight = 0.0d0
   835  !!$      do n = nprocs-1, 0, -1
   836  !!$        do j = a_jmax(n), a_jmax(n) / 2 + 1, -1
   837  !!$          SumWeight = SumWeight + aa_RecvBuf(j,n)
   838  !!$        end do
   839  !!$      end do
   840  !!$      do n = 0, nprocs-1
   841  !!$        do j = 1, a_jmax(n) / 2
   842  !!$          SumWeight = SumWeight + aa_RecvBuf(j,n)
   843  !!$        end do
   844  !!$      end do
   845  !!$    end if
   846  !!$
   847  !!$    deallocate( a_SendBuf  )
   848  !!$    deallocate( aa_RecvBuf )
   849  !!$    deallocate( a_iReqSend )
   850  !!$    deallocate( a_iReqRecv )
   851  !!$
   852  !!$
   853  !!$    AvrLat_y = IntLat_y( y_Data ) / SumWeight
   854  !!$
   855  !!$  end function AvrLat_y
   856  !!$
   857  !!$#else
   858  !!$  !-------------------------------------------------------------------
   859  !!$
   860  !!$  function AvrLat_y( y_Data )
   861  !!$    !
   862  !!$    ! 1 次元緯度格子点データの緯度方向平均(1 層用).
   863  !!$    !
   864  !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   865  !!$    ! 総和を計算し, y_Lat_Weight の総和で割ることで
   866  !!$    ! 平均している.
   867  !!$    !
   868  !!$    ! Meridonal mean of 1-dimensional (latitude)
   869  !!$    ! grid data.
   870  !!$    !
   871  !!$    ! Practically, the sum total of grid data is calculated
   872  !!$    ! by multiplying in each grid "y_Lat_Weight"
   873  !!$    ! and deviding by the sum total of "y_Lat_Weight".
   874  !!$    !
   875  !!$    real(DP), intent(in):: y_Data (1:jmax)
   876  !!$    real(DP):: AvrLat_y
   877  !!$
   878  !!$    ! 作業変数
   879  !!$    ! Work variables
   880  !!$    !
   881  !!$
   882  !!$    ! 実行文 ; Executable statement
   883  !!$    !
   884  !!$
   885  !!$    AvrLat_y = IntLat_y( y_Data ) / sum( y_Lat_Weight )
   886  !!$
   887  !!$  end function AvrLat_y
   888  !!$
   889  !!$#endif
   890  !!$  !-------------------------------------------------------------------
   891  !!$
   892  !!$  function AvrLon_x( x_Data )
   893  !!$    !
   894  !!$    ! 1 次元経度格子点データの経度方向平均(1 層用).
   895  !!$    !
   896  !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   897  !!$    ! 総和を計算し, x_Lon_Weight の総和で割ることで
   898  !!$    ! 平均している.
   899  !!$    !
   900  !!$    ! Zonal mean of 1-dimensional (longitude)
   901  !!$    ! grid data.
   902  !!$    !
   903  !!$    ! Practically, the sum total of grid data is calculated
   904  !!$    ! by multiplying in each grid "x_Lon_Weight"
   905  !!$    ! and deviding by the sum total of "x_Lon_Weight".
   906  !!$    !
   907  !!$    real(DP), intent(in):: x_Data (0:imax-1)
   908  !!$    real(DP):: AvrLon_x
   909  !!$
   910  !!$    ! 作業変数
   911  !!$    ! Work variables
   912  !!$    !
   913  !!$
   914  !!$    ! 実行文 ; Executable statement
   915  !!$    !
   916  !!$    AvrLon_x = IntLon_x( x_Data ) / sum( x_Lon_Weight )
   917  !!$  end function AvrLon_x
   918  !!$
   919  
   920    !--------------------------------------------------------------------------------------
   921  
   922    subroutine IntAvrOprInit
   923      !
   924      ! intavr_operate モジュールの初期化を行います.
   925      ! NAMELIST#intavr_operate_nml の読み込みはこの手続きで行われます.
   926      !
   927      ! "intavr_operate" module is initialized.
   928      ! "NAMELIST#intavr_operate_nml" is loaded in this procedure.
   929      !
   930  
   931      ! モジュール引用 ; USE statements
   932      !
   933  
   934      ! 宣言文 ; Declaration statements
   935      !
   936  
   937  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   938  !!$                              ! Unit number for NAMELIST file open
   939  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   940  !!$                              ! IOSTAT of NAMELIST read
   941  
   942      ! NAMELIST 変数群
   943      ! NAMELIST group name
   944      !
   945  !!$    namelist /intavr_operate_nml/
   946            !
   947            ! デフォルト値については初期化手続 "intavr_operate#IntAvrOprInit"
   948            ! のソースコードを参照のこと.
   949            !
   950            ! Refer to source codes in the initialization procedure
   951            ! "intavr_operate#IntAvrOprInit" for the default values.
   952            !
   953  
   954      ! 実行文 ; Executable statement
   955      !
   956  
   957      if ( intavr_operate_inited ) return
   958  
   959  
   960      ! デフォルト値の設定
   961      ! Default values settings
   962      !
   963  
   964  !!$    ! NAMELIST の読み込み
   965  !!$    ! NAMELIST is input
   966  !!$    !
   967  !!$    if ( trim(namelist_filename) /= '' ) then
   968  !!$      call FileOpen( unit_nml, &          ! (out)
   969  !!$        & namelist_filename, mode = 'r' ) ! (in)
   970  !!$
   971  !!$      rewind( unit_nml )
   972  !!$      read( unit_nml, &           ! (in)
   973  !!$        & nml = intavr_operate_nml, &  ! (out)
   974  !!$        & iostat = iostat_nml )   ! (out)
   975  !!$      close( unit_nml )
   976  !!$
   977  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   978  !!$    end if
   979  
   980      ! 印字 ; Print
   981      !
   982      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   983      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   984      intavr_operate_inited = .true.
   985    end subroutine IntAvrOprInit
   986  
   987    !--------------------------------------------------------------------------------------
   988  
   989  end module intavr_operate
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:23 2016
FILE NAME: i.intavr_operate.F90
PROGRAM NAME: intavr_operate
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 積分と平均の操作
     2:             !
     3:             != Operation for integral and average
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6:             ! Version::   $Id: intavr_operate.F90,v 1.6 2014/05/07 09:39:23 murashin Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module intavr_operate
    13:               !
    14:               != 積分と平均の操作
    15:               !
    16:               != Operation for integral and average
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 積分で用いる座標重みを考慮した積分や平均操作のための関数を提供します. 
    21:               ! {SPMODEL ライブラリ}[http://www.gfd-dennou.org/library/spmodel]
    22:               ! の w_integral_module.f90 を参考に作成しました. 
    23:               !
    24:               ! Functions for integral or average operation with weight for integration
    25:               ! are provided
    26:               ! This program is created referring to 
    27:               ! "w_integral_module.f90" in 
    28:               ! {SPMODEL library}[http://www.gfd-dennou.org/library/spmodel]
    29:               !
    30:               !== Procedures List
    31:               !
    32:               ! IntLonLat_xy           :: 緯度経度積分
    33:             !!$  ! y_IntLon_xy, IntLon_x  :: 経度積分
    34:             !!$  ! ya_IntLon_xya          :: 経度積分 (多層用)
    35:             !!$  ! x_IntLat_xy, IntLat_y  :: 緯度積分
    36:             !!$  ! xa_IntLat_xya          :: 緯度積分 (多層用)
    37:             !!$  ! AvrLonLat_xy           :: 緯度経度平均
    38:             !!$  ! y_AvrLon_xy, AvrLon_x  :: 経度平均
    39:             !!$  ! ya_AvrLon_xya          :: 経度平均 (多層用)
    40:             !!$  ! x_AvrLat_xy, AvrLat_y  :: 緯度平均
    41:             !!$  ! xa_AvrLat_xya          :: 緯度平均 (多層用)
    42:               ! ---------------------  :: ---------------------
    43:               ! y_IntLon_xy, IntLon_x  :: Meridional integral
    44:             !!$  ! ya_IntLon_xya          :: Meridional integral (for multi layer)
    45:             !!$  ! x_IntLat_xy, IntLat_y  :: Zonal integral
    46:             !!$  ! xa_IntLat_xya          :: Zonal integral (for multi layer)
    47:             !!$  ! AvrLonLat_xy           :: Zonal and meridional average
    48:             !!$  ! y_AvrLon_xy, AvrLon_x  :: Meridional average
    49:             !!$  ! ya_AvrLon_xya          :: Meridional average (for multi layer)
    50:             !!$  ! x_AvrLat_xy, AvrLat_y  :: Zonal average
    51:             !!$  ! xa_AvrLat_xya          :: Zonal average (for multi layer)
    52:               !
    53:               !--
    54:               !== NAMELIST
    55:               !
    56:               ! NAMELIST#intavr_operate_nml
    57:               !++
    58:             
    59:               ! モジュール引用 ; USE statements
    60:               !
    61:             
    62:               ! 座標データ設定
    63:               ! Axes data settings
    64:               !
    65:               use axesset, only: &
    66:                 & x_Lon_Weight, &
    67:                                           ! $ \Delta \lambda $ [rad.] . 
    68:                                           ! 経度座標重み. 
    69:                                           ! Weight of longitude
    70:                 & y_Lat_Weight
    71:                                           ! $ \Delta \varphi $ [rad.] . 
    72:                                           ! 緯度座標重み. 
    73:                                           ! Weight of latitude
    74:             
    75:               ! 格子点設定
    76:               ! Grid points settings
    77:               !
    78:               use gridset, only: imax, & ! 経度格子点数. 
    79:                                          ! Number of grid points in longitude
    80:                 &                jmax, & ! 緯度格子点数. 
    81:                                          ! Number of grid points in latitude
    82:                 &                kmax    ! 鉛直層数. 
    83:                                          ! Number of vertical level
    84:             
    85:               ! 種別型パラメタ
    86:               ! Kind type parameter
    87:               !
    88:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    89:                 &                 STRING     ! 文字列.       Strings. 
    90:             
    91:               ! メッセージ出力
    92:               ! Message output
    93:               !
    94:               use dc_message, only: MessageNotify
    95:             
    96:               ! 宣言文 ; Declaration statements
    97:               !
    98:               implicit none
    99:               private
   100:             
   101:               ! 公開手続き
   102:               ! Public procedure
   103:               !
   104:               public:: IntLonLat_xy
   105:               public:: a_IntLonLat_xya
   106:             !!$  public:: y_IntLon_xy, ya_IntLon_xya, IntLon_x
   107:             !!$  public:: x_IntLat_xy, xa_IntLat_xya, IntLat_y
   108:             !!$  public:: IntLat_y
   109:             !!$  public:: AvrLonLat_xy
   110:             !!$  public:: y_AvrLon_xy, ya_AvrLon_xya, AvrLon_x
   111:             !!$  public:: x_AvrLat_xy, xa_AvrLat_xya, AvrLat_y
   112:             
   113:               ! 公開変数
   114:               ! Public variables
   115:               !
   116:               logical, save, public:: intavr_operate_inited = .false.
   117:                                           ! 初期設定フラグ. 
   118:                                           ! Initialization flag
   119:             
   120:             
   121:               ! 非公開変数
   122:               ! Private variables
   123:               !
   124:             
   125:               character(*), parameter:: module_name = 'intavr_operate'
   126:                                           ! モジュールの名称. 
   127:                                           ! Module name
   128:               character(*), parameter:: version = &
   129:                 & '$Name:  $' // &
   130:                 & '$Id: intavr_operate.F90,v 1.6 2014/05/07 09:39:23 murashin Exp $'
   131:                                           ! モジュールのバージョン
   132:                                           ! Module version
   133:             
   134:               ! INTERFACE 文 ; INTERFACE statements
   135:               !
   136:             
   137:             contains
   138:             
   139:               !-------------------------------------------------------------------
   140:             
   141:               function a_IntLonLat_xya( xya_Data )
   142:                 !
   143:                 ! 2 次元緯度経度格子点データの全領域積分(1 層用). 
   144:                 !
   145:                 ! 実際には格子点データ各点毎に x_Lon_Weight, y_Lat_Weight を掛けた
   146:                 ! 総和を計算している. 
   147:                 !
   148:                 ! Global integration of 2-dimensional (latitude and longitude)
   149:                 ! grid data.
   150:                 !
   151:                 ! Practically, the sum total of grid data is calculated
   152:                 ! by multiplying in each grid "x_Lon_Weight" and "y_Lat_Weight".
   153:                 !
   154:             
   155:                 real(DP), intent(in) :: xya_Data       (:,:,:)
   156:                 real(DP)             :: a_IntLonLat_xya(size(xya_Data,3))
   157:             
   158:             
   159:                 ! 実行文 ; Executable statement
   160:                 !
   161:             
   162:             
   163:                 a_IntLonLat_xya = a_IntLat_ya( ya_IntLon_xya( xya_Data ) )
   164:             
   165:             
   166:               end function a_IntLonLat_xya
   167:             
   168:               !-------------------------------------------------------------------
   169:             
   170:               function IntLonLat_xy( xy_Data )
   171:                 !
   172:                 ! 2 次元緯度経度格子点データの全領域積分(1 層用). 
   173:                 !
   174:                 ! 実際には格子点データ各点毎に x_Lon_Weight, y_Lat_Weight を掛けた
   175:                 ! 総和を計算している. 
   176:                 !
   177:                 ! Global integration of 2-dimensional (latitude and longitude)
   178:                 ! grid data.
   179:                 !
   180:                 ! Practically, the sum total of grid data is calculated
   181:                 ! by multiplying in each grid "x_Lon_Weight" and "y_Lat_Weight".
   182:                 !
   183:             
   184:                 real(DP), intent(in) :: xy_Data (0:imax-1, 1:jmax)
   185:                 real(DP)             :: IntLonLat_xy
   186:             
   187:                 ! 実行文 ; Executable statement
   188:                 !
   189:             
   190:                 IntLonLat_xy = IntLat_y( y_IntLon_xy( xy_Data ) )
   191:             
   192:               end function IntLonLat_xy
   193:             
   194:               !-------------------------------------------------------------------
   195:             
   196:               function ya_IntLon_xya( xya_Data )
   197:                 !
   198:                 ! 2 次元緯度経度格子点データの経度方向積分(1 層用). 
   199:                 !
   200:                 ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   201:                 ! 総和を計算している. 
   202:                 !
   203:                 ! Zonal integration of 2-dimensional (latitude and longitude)
   204:                 ! grid data.
   205:                 !
   206:                 ! Practically, the sum total of grid data is calculated
   207:                 ! by multiplying in each grid "x_Lon_Weight".
   208:                 !
   209:             
   210:                 real(DP), intent(in) :: xya_Data     (:,:,:)
   211:                 real(DP)             :: ya_IntLon_xya(size(xya_Data,2), size(xya_Data,3))
   212:             
   213:                 ! 作業変数
   214:                 ! Work variables
   215:                 !
   216:                 integer:: lmax
   217:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   218:                                           ! Work variables for DO loop in longitudinal direction
   219:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   220:                                           ! Work variables for DO loop in latitudinal direction
   221:                 integer:: l
   222:             
   223:             
   224:                 ! 実行文 ; Executable statement
   225:                 !
   226:                 lmax = size( xya_Data, 3 )
   227:             
   228: +V=====         ya_IntLon_xya = 0.0_DP
   229: +------>        do l = 1, lmax
   230: |+----->          do j = 1, jmax
   231: ||V---->A           do i = 0, imax - 1
   232: |||     A   !!$          ya_IntLon_xya(j,l) = ya_IntLon_xya(j,l) + xya_Data(i,j,l) * x_Lon_Weight(i)
   233: |||     A             ya_IntLon_xya(j,l) = ya_IntLon_xya(j,l) + xya_Data(i+1,j,l) * x_Lon_Weight(i)
   234: ||V----             end do
   235: |+-----           end do
   236: +------         end do
   237:             
   238:             
   239:               end function ya_IntLon_xya
   240:             
   241:               !-------------------------------------------------------------------
   242:             
   243:               function y_IntLon_xy( xy_Data )
   244:                 !
   245:                 ! 2 次元緯度経度格子点データの経度方向積分(1 層用). 
   246:                 !
   247:                 ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   248:                 ! 総和を計算している. 
   249:                 !
   250:                 ! Zonal integration of 2-dimensional (latitude and longitude)
   251:                 ! grid data.
   252:                 !
   253:                 ! Practically, the sum total of grid data is calculated
   254:                 ! by multiplying in each grid "x_Lon_Weight".
   255:                 !
   256:             
   257:                 real(DP), intent(in) :: xy_Data (0:imax-1, 1:jmax)
   258:                 real(DP)             :: y_IntLon_xy (1:jmax)
   259:             
   260:                 ! 作業変数
   261:                 ! Work variables
   262:                 !
   263:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   264:                                           ! Work variables for DO loop in longitudinal direction
   265:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   266:                                           ! Work variables for DO loop in latitudinal direction
   267:             
   268:                 ! 実行文 ; Executable statement
   269:                 !
   270:             
   271: V======         y_IntLon_xy = 0.0_DP
   272: *------>        do j = 1, jmax
   273: |V----->          do i = 0, imax - 1
   274: ||                  y_IntLon_xy(j) = y_IntLon_xy(j) + xy_Data (i,j) * x_Lon_Weight(i)
   275: |V-----           end do
   276: *------         end do
   277:             
   278:               end function y_IntLon_xy
   279:             
   280:             
   281:               !-------------------------------------------------------------------
   282:             
   283:               function a_IntLat_ya( ya_Data )
   284:                 !
   285:                 ! 1 次元緯度経度格子点データの全領域平均(1 層用). 
   286:                 !
   287:                 ! Global mean of 2-dimensional (latitude and longitude)
   288:                 ! grid data.
   289:                 !
   290:             
   291:                 ! MPI
   292:                 !
   293:                 use mpi_wrapper, only: nprocs, myrank, &
   294:                   & MPIWrapperISend, &
   295:                   & MPIWrapperIRecv, &
   296:                   & MPIWrapperWait
   297:             
   298:                 ! 格子点数・最大波数設定
   299:                 ! Number of grid points and maximum truncated wavenumber settings
   300:                 !
   301:                 use gridset, only: a_jmax, jmax_max
   302:             
   303:                 real(DP), intent(in) :: ya_Data (:,:)
   304:                 real(DP)             :: a_IntLat_ya(size(ya_Data,2))
   305:             
   306:             
   307:                 ! Local variable
   308:                 !
   309:                 integer               :: lmax
   310:                 real(DP), allocatable :: aa_SendBuf (:,:)
   311:                 real(DP), allocatable :: aaa_RecvBuf(:,:,:)
   312:                 integer , allocatable :: a_iReqSend (:)
   313:                 integer , allocatable :: a_iReqRecv (:)
   314:             
   315:                 integer               :: j
   316:                 integer               :: l
   317:                 integer               :: n
   318:             
   319:             
   320:                 ! 実行文 ; Executable statement
   321:                 !
   322:                 lmax = size(ya_Data,2)
   323:             
   324:             
   325:                 allocate( aa_SendBuf (1:jmax_max, 1:lmax) )
   326:                 allocate( aaa_RecvBuf(1:jmax_max, 1:lmax, 0:nprocs-1) )
   327:                 allocate( a_iReqSend(0:nprocs-1) )
   328:                 allocate( a_iReqRecv(0:nprocs-1) )
   329:             
   330: +------>        do l = 1, lmax
   331: |V----->          do j = 1, jmax
   332: ||      A           aa_SendBuf(j,l) = ya_Data(j,l) * y_Lat_Weight(j)
   333: |V-----           end do
   334: |V----->          do j = jmax+1, jmax_max
   335: ||      A           aa_SendBuf(j,l) = -1.0_DP
   336: |V-----           end do
   337: +------         end do
   338:             
   339: +------>        do n = 0, nprocs-1
   340: |                 if ( n == myrank ) then
   341: |+V==== A           aaa_RecvBuf(:,:,n) = aa_SendBuf
   342: |                 else
   343: |                   call MPIWrapperISend( n, jmax_max, lmax, aa_SendBuf        , a_iReqSend(n) )
   344: |                   call MPIWrapperIRecv( n, jmax_max, lmax, aaa_RecvBuf(:,:,n), a_iReqRecv(n) )
   345: |                 end if
   346: +------         end do
   347: +------>        do n = 0, nprocs-1
   348: |                 if ( n == myrank ) cycle
   349: |                 call MPIWrapperWait( a_iReqSend(n) )
   350: |                 call MPIWrapperWait( a_iReqRecv(n) )
   351: +------         end do
   352:             
   353:             
   354: V======         a_IntLat_ya = 0.0_DP
   355: +------>        do n = nprocs-1, 0, -1
   356: |+----->          do l = 1, lmax
   357: ||V---->            do j = 1, a_jmax(n) / 2
   358: |||     A             a_IntLat_ya(l) = a_IntLat_ya(l) + aaa_RecvBuf(j,l,n)
   359: ||V----             end do
   360: |+-----           end do
   361: +------         end do
   362: +------>        do n = 0, nprocs-1
   363: |+----->          do l = 1, lmax
   364: ||V---->            do j = a_jmax(n) / 2 + 1, a_jmax(n)
   365: |||     A             a_IntLat_ya(l) = a_IntLat_ya(l) + aaa_RecvBuf(j,l,n)
   366: ||V----             end do
   367: |+-----           end do
   368: +------         end do
   369:             
   370:             
   371:                 deallocate( aa_SendBuf  )
   372:                 deallocate( aaa_RecvBuf )
   373:                 deallocate( a_iReqSend  )
   374:                 deallocate( a_iReqRecv  )
   375:             
   376:             
   377:               end function a_IntLat_ya
   378:             
   379:               !-------------------------------------------------------------------
   380:             
   381:               function IntLat_y( y_Data )
   382:                 !
   383:                 ! 1 次元緯度経度格子点データの全領域平均(1 層用). 
   384:                 !
   385:                 ! Global mean of 2-dimensional (latitude and longitude)
   386:                 ! grid data.
   387:                 !
   388:             
   389:                 ! MPI
   390:                 !
   391:                 use mpi_wrapper, only: nprocs, myrank, &
   392:                   & MPIWrapperISend, &
   393:                   & MPIWrapperIRecv, &
   394:                   & MPIWrapperWait
   395:             
   396:                 ! 格子点数・最大波数設定
   397:                 ! Number of grid points and maximum truncated wavenumber settings
   398:                 !
   399:                 use gridset, only: a_jmax, jmax_max
   400:             
   401:                 real(DP), intent(in) :: y_Data (1:jmax)
   402:                 real(DP)             :: IntLat_y
   403:             
   404:             
   405:                 ! Local variable
   406:                 !
   407:                 real(DP), allocatable :: a_SendBuf (:)
   408:                 real(DP), allocatable :: aa_RecvBuf(:,:)
   409:                 integer , allocatable :: a_iReqSend(:)
   410:                 integer , allocatable :: a_iReqRecv(:)
   411:             
   412:                 integer               :: j
   413:                 integer               :: n
   414:             
   415:             
   416:                 ! 実行文 ; Executable statement
   417:                 !
   418:             
   419:             
   420:                 allocate( a_SendBuf (1:jmax_max) )
   421:                 allocate( aa_RecvBuf(1:jmax_max,0:nprocs-1) )
   422:                 allocate( a_iReqSend(0:nprocs-1) )
   423:                 allocate( a_iReqRecv(0:nprocs-1) )
   424:             
   425: V------>        do j = 1, jmax
   426: |       A         a_SendBuf(j) = y_Data(j) * y_Lat_Weight(j)
   427: V------         end do
   428: V------>        do j = jmax+1, jmax_max
   429: |       A         a_SendBuf(j) = -1.0_DP
   430: V------         end do
   431:             
   432: +------>        do n = 0, nprocs-1
   433: |                 if ( n == myrank ) then
   434: |V===== A           aa_RecvBuf(:,n) = a_SendBuf
   435: |                 else
   436: |                   call MPIWrapperISend( n, jmax_max, a_SendBuf      , a_iReqSend(n) )
   437: |                   call MPIWrapperIRecv( n, jmax_max, aa_RecvBuf(:,n), a_iReqRecv(n) )
   438: |                 end if
   439: +------         end do
   440: +------>        do n = 0, nprocs-1
   441: |                 if ( n == myrank ) cycle
   442: |                 call MPIWrapperWait( a_iReqSend(n) )
   443: |                 call MPIWrapperWait( a_iReqRecv(n) )
   444: +------         end do
   445:             
   446:             
   447:                 IntLat_y = 0.0d0
   448: +------>        do n = nprocs-1, 0, -1
   449: |V----->          do j = 1, a_jmax(n) / 2
   450: ||      A           IntLat_y = IntLat_y + aa_RecvBuf(j,n)
   451: |V-----           end do
   452: +------         end do
   453: +------>        do n = 0, nprocs-1
   454: |V----->          do j = a_jmax(n) / 2 + 1, a_jmax(n)
   455: ||      A           IntLat_y = IntLat_y + aa_RecvBuf(j,n)
   456: |V-----           end do
   457: +------         end do
   458:             
   459:             
   460:                 deallocate( a_SendBuf  )
   461:                 deallocate( aa_RecvBuf )
   462:                 deallocate( a_iReqSend )
   463:                 deallocate( a_iReqRecv )
   464:             
   465:             
   466:               end function IntLat_y
   467:             
   468:             
   469:               !-------------------------------------------------------------------
   470:             !!$
   471:             !!$  function AvrLonLat_xy( xy_Data )
   472:             !!$    !
   473:             !!$    ! 2 次元緯度経度格子点データの全領域平均(1 層用). 
   474:             !!$    !
   475:             !!$    ! Global mean of 2-dimensional (latitude and longitude)
   476:             !!$    ! grid data.
   477:             !!$    !
   478:             !!$
   479:             !!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
   480:             !!$
   481:             !!$
   482:             !!$    ! Local variable
   483:             !!$    !
   484:             !!$    real(DP)              :: AvrLonLat_xy
   485:             !!$
   486:             !!$
   487:             !!$    ! 実行文 ; Executable statement
   488:             !!$    !
   489:             !!$
   490:             !!$    ! Old one to be deleted
   491:             !!$!    AvrLonLat_xy = AvrLon_x( x_AvrLat_xy( xy_Data ) )
   492:             !!$
   493:             !!$    AvrLonLat_xy = AvrLat_y( y_AvrLon_xy( xy_Data ) )
   494:             !!$
   495:             !!$
   496:             !!$  end function AvrLonLat_xy
   497:             !!$
   498:             !!$  !-------------------------------------------------------------------
   499:             !!$
   500:             !!$  function x_IntLat_xy( xy_Data )
   501:             !!$    !
   502:             !!$    ! 2 次元緯度経度格子点データの緯度方向積分(1 層用). 
   503:             !!$    !
   504:             !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   505:             !!$    ! 総和を計算している. 
   506:             !!$    !
   507:             !!$    ! Meridional integration of 2-dimensional (latitude and longitude)
   508:             !!$    ! grid data.
   509:             !!$    !
   510:             !!$    ! Practically, the sum total of grid data is calculated
   511:             !!$    ! by multiplying in each grid "y_Lat_Weight".
   512:             !!$    !
   513:             !!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
   514:             !!$    real(DP):: x_IntLat_xy (0:imax-1)
   515:             !!$
   516:             !!$    ! 作業変数
   517:             !!$    ! Work variables
   518:             !!$    !
   519:             !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   520:             !!$                              ! Work variables for DO loop in latitude
   521:             !!$
   522:             !!$    ! 実行文 ; Executable statement
   523:             !!$    !
   524:             !!$    x_IntLat_xy = 0.0_DP
   525:             !!$    do j = 1, jmax
   526:             !!$      x_IntLat_xy = x_IntLat_xy + xy_Data (:,j) * y_Lat_Weight(j)
   527:             !!$    enddo
   528:             !!$  end function x_IntLat_xy
   529:             !!$
   530:             !!$  !-------------------------------------------------------------------
   531:             !!$
   532:             !!$  function xa_IntLat_xya( xya_Data )
   533:             !!$    !
   534:             !!$    ! 3 次元緯度経度格子点データの緯度方向積分(多層用). 
   535:             !!$    !
   536:             !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   537:             !!$    ! 総和を計算している. 
   538:             !!$    !
   539:             !!$    ! Meridional integration of 3-dimensional (latitude and longitude)
   540:             !!$    ! grid data. (for multi layer)
   541:             !!$    !
   542:             !!$    ! Practically, the sum total of grid data is calculated
   543:             !!$    ! by multiplying in each grid "y_Lat_Weight".
   544:             !!$    !
   545:             !!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
   546:             !!$    real(DP):: xa_IntLat_xya (0:imax-1, 1:kmax)
   547:             !!$
   548:             !!$    ! 作業変数
   549:             !!$    ! Work variables
   550:             !!$    !
   551:             !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   552:             !!$                              ! Work variables for DO loop in vertical direction
   553:             !!$
   554:             !!$    ! 実行文 ; Executable statement
   555:             !!$    !
   556:             !!$    do k = 1, kmax
   557:             !!$      xa_IntLat_xya(:,k) = x_IntLat_xy( xya_Data(:,:,k) )
   558:             !!$    end do
   559:             !!$  end function xa_IntLat_xya
   560:             !!$
   561:             !!$  !-------------------------------------------------------------------
   562:             !!$
   563:             !!$  function ya_IntLon_xya( xya_Data )
   564:             !!$    !
   565:             !!$    ! 3 次元緯度経度格子点データの経度方向積分(多層用). 
   566:             !!$    !
   567:             !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   568:             !!$    ! 総和を計算している. 
   569:             !!$    !
   570:             !!$    ! Zonal integration of 3-dimensional (latitude and longitude)
   571:             !!$    ! grid data. (for multi layer)
   572:             !!$    !
   573:             !!$    ! Practically, the sum total of grid data is calculated
   574:             !!$    ! by multiplying in each grid "x_Lon_Weight".
   575:             !!$    !
   576:             !!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
   577:             !!$    real(DP):: ya_IntLon_xya (1:jmax,1:kmax)
   578:             !!$
   579:             !!$    ! 作業変数
   580:             !!$    ! Work variables
   581:             !!$    !
   582:             !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   583:             !!$                              ! Work variables for DO loop in vertical direction
   584:             !!$
   585:             !!$    ! 実行文 ; Executable statement
   586:             !!$    !
   587:             !!$    do k = 1, kmax
   588:             !!$      ya_IntLon_xya(:,k) = y_IntLon_xy( xya_Data(:,:,k) )
   589:             !!$    end do
   590:             !!$  end function ya_IntLon_xya
   591:             !!$
   592:             !!$  !-------------------------------------------------------------------
   593:             !!$
   594:             !!$  function IntLon_x( x_Data )
   595:             !!$    !
   596:             !!$    ! 1 次元経度格子点データの経度方向積分(1 層用). 
   597:             !!$    !
   598:             !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   599:             !!$    ! 総和を計算している. 
   600:             !!$    !
   601:             !!$    ! Zonal integration of 1-dimensional (longitude)
   602:             !!$    ! grid data.
   603:             !!$    !
   604:             !!$    ! Practically, the sum total of grid data is calculated
   605:             !!$    ! by multiplying in each grid "x_Lon_Weight".
   606:             !!$    !
   607:             !!$    real(DP), intent(in):: x_Data (0:imax-1)
   608:             !!$    real(DP):: IntLon_x
   609:             !!$
   610:             !!$    ! 作業変数
   611:             !!$    ! Work variables
   612:             !!$    !
   613:             !!$
   614:             !!$    ! 実行文 ; Executable statement
   615:             !!$    !
   616:             !!$    IntLon_x = sum( x_Data * x_Lon_Weight )
   617:             !!$  end function IntLon_x
   618:             !!$
   619:             !!$  !-------------------------------------------------------------------
   620:             !!$
   621:             !!$  function x_AvrLat_xy( xy_Data )
   622:             !!$    !
   623:             !!$    ! 2 次元緯度経度格子点データの緯度方向平均(1 層用). 
   624:             !!$    !
   625:             !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   626:             !!$    ! 総和を計算し, y_Lat_Weight の総和で割ることで
   627:             !!$    ! 平均している. 
   628:             !!$    !
   629:             !!$    ! Meridional mean of 2-dimensional (latitude and longitude)
   630:             !!$    ! grid data.
   631:             !!$    !
   632:             !!$    ! Practically, the mean grid data is calculated
   633:             !!$    ! by multiplying in each grid "y_Lat_Weight" 
   634:             !!$    ! and deviding by the sum total of "y_Lat_Weight".
   635:             !!$    !
   636:             !!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
   637:             !!$    real(DP):: x_AvrLat_xy (0:imax-1)
   638:             !!$
   639:             !!$    ! 作業変数
   640:             !!$    ! Work variables
   641:             !!$    !
   642:             !!$
   643:             !!$    ! 実行文 ; Executable statement
   644:             !!$    !
   645:             !!$    x_AvrLat_xy = x_IntLat_xy ( xy_Data ) / sum( y_Lat_Weight )
   646:             !!$  end function x_AvrLat_xy
   647:             !!$
   648:             !!$  !-------------------------------------------------------------------
   649:             !!$
   650:             !!$  function xa_AvrLat_xya( xya_Data )
   651:             !!$    !
   652:             !!$    ! 3 次元緯度経度格子点データの緯度方向平均(多層用). 
   653:             !!$    !
   654:             !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   655:             !!$    ! 総和を計算し, y_Lat_Weight の総和で割ることで
   656:             !!$    ! 平均している. 
   657:             !!$    !
   658:             !!$    ! Meridional mean of 3-dimensional (latitude and longitude)
   659:             !!$    ! grid data. (for multi layer)
   660:             !!$    !
   661:             !!$    ! Practically, the mean grid data is calculated
   662:             !!$    ! by multiplying in each grid "y_Lat_Weight" 
   663:             !!$    ! and deviding by the sum total of "y_Lat_Weight".
   664:             !!$    !
   665:             !!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
   666:             !!$    real(DP):: xa_AvrLat_xya (0:imax-1, 1:kmax)
   667:             !!$
   668:             !!$    ! 作業変数
   669:             !!$    ! Work variables
   670:             !!$    !
   671:             !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   672:             !!$                              ! Work variables for DO loop in vertical direction
   673:             !!$
   674:             !!$    ! 実行文 ; Executable statement
   675:             !!$    !
   676:             !!$    do k = 1, kmax
   677:             !!$      xa_AvrLat_xya(:,k) = x_AvrLat_xy( xya_Data(:,:,k) )
   678:             !!$    end do
   679:             !!$  end function xa_AvrLat_xya
   680:             !!$
   681:             !!$  !-------------------------------------------------------------------
   682:             !!$
   683:             !!$  function y_AvrLon_xy( xy_Data )
   684:             !!$    !
   685:             !!$    ! 2 次元緯度経度格子点データの経度方向平均(1 層用). 
   686:             !!$    !
   687:             !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   688:             !!$    ! 総和を計算し, x_Lon_Weight の総和で割ることで
   689:             !!$    ! 平均している. 
   690:             !!$    !
   691:             !!$    ! Zonal mean of 2-dimensional (latitude and longitude)
   692:             !!$    ! grid data.
   693:             !!$    !
   694:             !!$    ! Practically, the mean grid data is calculated
   695:             !!$    ! by multiplying in each grid "x_Lon_Weight" 
   696:             !!$    ! and deviding by the sum total of "x_Lon_Weight".
   697:             !!$    !
   698:             !!$    real(DP), intent(in):: xy_Data (0:imax-1, 1:jmax)
   699:             !!$    real(DP):: y_AvrLon_xy (1:jmax)
   700:             !!$
   701:             !!$    ! 作業変数
   702:             !!$    ! Work variables
   703:             !!$    !
   704:             !!$
   705:             !!$    ! 実行文 ; Executable statement
   706:             !!$    !
   707:             !!$    y_AvrLon_xy = y_IntLon_xy( xy_Data ) / sum( x_Lon_Weight )
   708:             !!$  end function y_AvrLon_xy
   709:             !!$
   710:             !!$  !-------------------------------------------------------------------
   711:             !!$
   712:             !!$  function ya_AvrLon_xya( xya_Data )
   713:             !!$    !
   714:             !!$    ! 3 次元緯度経度格子点データの経度方向平均(多層用). 
   715:             !!$    !
   716:             !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   717:             !!$    ! 総和を計算し, x_Lon_Weight の総和で割ることで
   718:             !!$    ! 平均している. 
   719:             !!$    !
   720:             !!$    ! Zonal mean of 3-dimensional (latitude and longitude)
   721:             !!$    ! grid data. (for multi layer)
   722:             !!$    !
   723:             !!$    ! Practically, the mean grid data is calculated
   724:             !!$    ! by multiplying in each grid "x_Lon_Weight" 
   725:             !!$    ! and deviding by the sum total of "x_Lon_Weight".
   726:             !!$    !
   727:             !!$    real(DP), intent(in):: xya_Data (0:imax-1, 1:jmax, 1:kmax)
   728:             !!$    real(DP):: ya_AvrLon_xya (1:jmax, 1:kmax)
   729:             !!$
   730:             !!$    ! 作業変数
   731:             !!$    ! Work variables
   732:             !!$    !
   733:             !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   734:             !!$                              ! Work variables for DO loop in vertical direction
   735:             !!$
   736:             !!$    ! 実行文 ; Executable statement
   737:             !!$    !
   738:             !!$    do k = 1, kmax
   739:             !!$      ya_AvrLon_xya(:,k) = y_AvrLon_xy( xya_Data(:,:,k) )
   740:             !!$    end do
   741:             !!$  end function ya_AvrLon_xya
   742:             !!$
   743:             !!$#ifdef 1
   744:             !!$  !-------------------------------------------------------------------
   745:             !!$
   746:             !!$  function AvrLat_y( y_Data )
   747:             !!$    !
   748:             !!$    ! 1 次元緯度格子点データの緯度方向平均(1 層用). 
   749:             !!$    !
   750:             !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   751:             !!$    ! 総和を計算し, y_Lat_Weight の総和で割ることで
   752:             !!$    ! 平均している. 
   753:             !!$    !
   754:             !!$    ! Meridonal mean of 1-dimensional (latitude)
   755:             !!$    ! grid data.
   756:             !!$    !
   757:             !!$    ! Practically, the sum total of grid data is calculated
   758:             !!$    ! by multiplying in each grid "y_Lat_Weight" 
   759:             !!$    ! and deviding by the sum total of "y_Lat_Weight".
   760:             !!$    !
   761:             !!$
   762:             !!$    ! MPI
   763:             !!$    !
   764:             !!$    use mpi_wrapper, only: nprocs, myrank, &
   765:             !!$      & MPIWrapperISend, &
   766:             !!$      & MPIWrapperIRecv, &
   767:             !!$      & MPIWrapperWait
   768:             !!$
   769:             !!$    ! 格子点数・最大波数設定
   770:             !!$    ! Number of grid points and maximum truncated wavenumber settings
   771:             !!$    !
   772:             !!$    use gridset, only: a_jmax, jmax_max
   773:             !!$
   774:             !!$    real(DP), intent(in):: y_Data (1:jmax)
   775:             !!$    real(DP):: AvrLat_y
   776:             !!$
   777:             !!$    ! 作業変数
   778:             !!$    ! Work variables
   779:             !!$    !
   780:             !!$
   781:             !!$    ! 実行文 ; Executable statement
   782:             !!$    !
   783:             !!$
   784:             !!$    real(DP), allocatable :: a_SendBuf (:)
   785:             !!$    real(DP), allocatable :: aa_RecvBuf(:,:)
   786:             !!$    integer , allocatable :: a_iReqSend(:)
   787:             !!$    integer , allocatable :: a_iReqRecv(:)
   788:             !!$
   789:             !!$    real(DP)              :: SumWeight
   790:             !!$
   791:             !!$    integer               :: j
   792:             !!$    integer               :: n
   793:             !!$
   794:             !!$    allocate( a_SendBuf (1:jmax_max) )
   795:             !!$    allocate( aa_RecvBuf(1:jmax_max,0:nprocs-1) )
   796:             !!$    allocate( a_iReqSend(0:nprocs-1) )
   797:             !!$    allocate( a_iReqRecv(0:nprocs-1) )
   798:             !!$
   799:             !!$    do j = 1, jmax
   800:             !!$      a_SendBuf(j) = y_Lat_Weight(j)
   801:             !!$    end do
   802:             !!$    do j = jmax+1, jmax_max
   803:             !!$      a_SendBuf(j) = -1.0d0
   804:             !!$    end do
   805:             !!$
   806:             !!$    do n = 0, nprocs-1
   807:             !!$      if ( n == myrank ) then
   808:             !!$        do j = 1, jmax
   809:             !!$          aa_RecvBuf(:,n) = a_SendBuf
   810:             !!$        end do
   811:             !!$      else
   812:             !!$        call MPIWrapperISend( n, jmax_max, a_SendBuf      , a_iReqSend(n) )
   813:             !!$        call MPIWrapperIRecv( n, jmax_max, aa_RecvBuf(:,n), a_iReqRecv(n) )
   814:             !!$      end if
   815:             !!$    end do
   816:             !!$    do n = 0, nprocs-1
   817:             !!$      if ( n == myrank ) cycle
   818:             !!$      call MPIWrapperWait( a_iReqSend(n) )
   819:             !!$      call MPIWrapperWait( a_iReqRecv(n) )
   820:             !!$    end do
   821:             !!$
   822:             !!$
   823:             !!$    if ( nprocs == 1 ) then
   824:             !!$      SumWeight = 0.0d0
   825:             !!$      do n = 0, nprocs-1
   826:             !!$        do j = 1, a_jmax(n)
   827:             !!$          SumWeight = SumWeight + aa_RecvBuf(j,n)
   828:             !!$        end do
   829:             !!$      end do
   830:             !!$    else
   831:             !!$
   832:             !!$      write( 6, * ) 'THIS WOULD BE WRONG.'
   833:             !!$
   834:             !!$      SumWeight = 0.0d0
   835:             !!$      do n = nprocs-1, 0, -1
   836:             !!$        do j = a_jmax(n), a_jmax(n) / 2 + 1, -1
   837:             !!$          SumWeight = SumWeight + aa_RecvBuf(j,n)
   838:             !!$        end do
   839:             !!$      end do
   840:             !!$      do n = 0, nprocs-1
   841:             !!$        do j = 1, a_jmax(n) / 2
   842:             !!$          SumWeight = SumWeight + aa_RecvBuf(j,n)
   843:             !!$        end do
   844:             !!$      end do
   845:             !!$    end if
   846:             !!$
   847:             !!$    deallocate( a_SendBuf  )
   848:             !!$    deallocate( aa_RecvBuf )
   849:             !!$    deallocate( a_iReqSend )
   850:             !!$    deallocate( a_iReqRecv )
   851:             !!$
   852:             !!$
   853:             !!$    AvrLat_y = IntLat_y( y_Data ) / SumWeight
   854:             !!$
   855:             !!$  end function AvrLat_y
   856:             !!$
   857:             !!$#else
   858:             !!$  !-------------------------------------------------------------------
   859:             !!$
   860:             !!$  function AvrLat_y( y_Data )
   861:             !!$    !
   862:             !!$    ! 1 次元緯度格子点データの緯度方向平均(1 層用). 
   863:             !!$    !
   864:             !!$    ! 実際には格子点データ各点毎に y_Lat_Weight を掛けた
   865:             !!$    ! 総和を計算し, y_Lat_Weight の総和で割ることで
   866:             !!$    ! 平均している. 
   867:             !!$    !
   868:             !!$    ! Meridonal mean of 1-dimensional (latitude)
   869:             !!$    ! grid data.
   870:             !!$    !
   871:             !!$    ! Practically, the sum total of grid data is calculated
   872:             !!$    ! by multiplying in each grid "y_Lat_Weight" 
   873:             !!$    ! and deviding by the sum total of "y_Lat_Weight".
   874:             !!$    !
   875:             !!$    real(DP), intent(in):: y_Data (1:jmax)
   876:             !!$    real(DP):: AvrLat_y
   877:             !!$
   878:             !!$    ! 作業変数
   879:             !!$    ! Work variables
   880:             !!$    !
   881:             !!$
   882:             !!$    ! 実行文 ; Executable statement
   883:             !!$    !
   884:             !!$
   885:             !!$    AvrLat_y = IntLat_y( y_Data ) / sum( y_Lat_Weight )
   886:             !!$
   887:             !!$  end function AvrLat_y
   888:             !!$
   889:             !!$#endif
   890:             !!$  !-------------------------------------------------------------------
   891:             !!$
   892:             !!$  function AvrLon_x( x_Data )
   893:             !!$    !
   894:             !!$    ! 1 次元経度格子点データの経度方向平均(1 層用). 
   895:             !!$    !
   896:             !!$    ! 実際には格子点データ各点毎に x_Lon_Weight を掛けた
   897:             !!$    ! 総和を計算し, x_Lon_Weight の総和で割ることで
   898:             !!$    ! 平均している. 
   899:             !!$    !
   900:             !!$    ! Zonal mean of 1-dimensional (longitude)
   901:             !!$    ! grid data.
   902:             !!$    !
   903:             !!$    ! Practically, the sum total of grid data is calculated
   904:             !!$    ! by multiplying in each grid "x_Lon_Weight" 
   905:             !!$    ! and deviding by the sum total of "x_Lon_Weight".
   906:             !!$    !
   907:             !!$    real(DP), intent(in):: x_Data (0:imax-1)
   908:             !!$    real(DP):: AvrLon_x
   909:             !!$
   910:             !!$    ! 作業変数
   911:             !!$    ! Work variables
   912:             !!$    !
   913:             !!$
   914:             !!$    ! 実行文 ; Executable statement
   915:             !!$    !
   916:             !!$    AvrLon_x = IntLon_x( x_Data ) / sum( x_Lon_Weight )
   917:             !!$  end function AvrLon_x
   918:             !!$
   919:             
   920:               !--------------------------------------------------------------------------------------
   921:             
   922:               subroutine IntAvrOprInit
   923:                 !
   924:                 ! intavr_operate モジュールの初期化を行います. 
   925:                 ! NAMELIST#intavr_operate_nml の読み込みはこの手続きで行われます. 
   926:                 !
   927:                 ! "intavr_operate" module is initialized. 
   928:                 ! "NAMELIST#intavr_operate_nml" is loaded in this procedure. 
   929:                 !
   930:             
   931:                 ! モジュール引用 ; USE statements
   932:                 !
   933:             
   934:                 ! 宣言文 ; Declaration statements
   935:                 !
   936:             
   937:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   938:             !!$                              ! Unit number for NAMELIST file open
   939:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   940:             !!$                              ! IOSTAT of NAMELIST read
   941:             
   942:                 ! NAMELIST 変数群
   943:                 ! NAMELIST group name
   944:                 !
   945:             !!$    namelist /intavr_operate_nml/
   946:                       !
   947:                       ! デフォルト値については初期化手続 "intavr_operate#IntAvrOprInit" 
   948:                       ! のソースコードを参照のこと. 
   949:                       !
   950:                       ! Refer to source codes in the initialization procedure
   951:                       ! "intavr_operate#IntAvrOprInit" for the default values. 
   952:                       !
   953:             
   954:                 ! 実行文 ; Executable statement
   955:                 !
   956:             
   957:                 if ( intavr_operate_inited ) return
   958:             
   959:             
   960:                 ! デフォルト値の設定
   961:                 ! Default values settings
   962:                 !
   963:             
   964:             !!$    ! NAMELIST の読み込み
   965:             !!$    ! NAMELIST is input
   966:             !!$    !
   967:             !!$    if ( trim(namelist_filename) /= '' ) then
   968:             !!$      call FileOpen( unit_nml, &          ! (out)
   969:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   970:             !!$
   971:             !!$      rewind( unit_nml )
   972:             !!$      read( unit_nml, &           ! (in)
   973:             !!$        & nml = intavr_operate_nml, &  ! (out)
   974:             !!$        & iostat = iostat_nml )   ! (out)
   975:             !!$      close( unit_nml )
   976:             !!$
   977:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   978:             !!$    end if
   979:             
   980:                 ! 印字 ; Print
   981:                 !
   982:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   983:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   984:                 intavr_operate_inited = .true.
   985:               end subroutine IntAvrOprInit
   986:             
   987:               !--------------------------------------------------------------------------------------
   988:             
   989:             end module intavr_operate
