Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: i.rearrange_column.F90
PROGRAM NAME: rearrange_column
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   185  vec  (   3): Unvectorized loop.
   185  vec  (  13): Overhead of loop division is too large.
   186  opt  (1592): Outer loop unrolled inside inner loop.
   186  vec  (   4): Vectorized array expression.
   186  vec  (  29): ADB is used for array.: xyaa_sendbuf
   186  vec  (  29): ADB is used for array.: xya_data
   186  vec  (   4): Vectorized array expression.
   186  vec  (  29): ADB is used for array.: xyaa_sendbuf
   186  vec  (  29): ADB is used for array.: xya_data
   192  vec  (   3): Unvectorized loop.
   192  vec  (  13): Overhead of loop division is too large.
   193  opt  (1592): Outer loop unrolled inside inner loop.
   193  vec  (   4): Vectorized array expression.
   193  vec  (  29): ADB is used for array.: xyaa_recvbuf
   193  vec  (  29): ADB is used for array.: xyaa_sendbuf
   193  vec  (   4): Vectorized array expression.
   193  vec  (  29): ADB is used for array.: xyaa_recvbuf
   193  vec  (  29): ADB is used for array.: xyaa_sendbuf
   196  vec  (   3): Unvectorized loop.
   198  opt  (1592): Outer loop unrolled inside inner loop.
   198  vec  (   4): Vectorized array expression.
   198  vec  (  29): ADB is used for array.: xyaa_recvbuf
   198  vec  (  29): ADB is used for array.: xyaa_sendbuf
   198  vec  (   4): Vectorized array expression.
   198  vec  (  29): ADB is used for array.: xyaa_recvbuf
   198  vec  (  29): ADB is used for array.: xyaa_sendbuf
   200  opt  (1017): Subroutine call prevents optimization.
   204  vec  (   3): Unvectorized loop.
   206  opt  (1017): Subroutine call prevents optimization.
   206  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
   207  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
   214  vec  (   3): Unvectorized loop.
   214  vec  (  13): Overhead of loop division is too large.
   215  opt  (1033): Potential multiple store conflict -- use directive if OK.
   215  opt  (1592): Outer loop unrolled inside inner loop.
   215  vec  (   4): Vectorized array expression.
   215  vec  (  29): ADB is used for array.: xya_data
   215  vec  (  29): ADB is used for array.: xyaa_recvbuf
   215  vec  (   4): Vectorized array expression.
   215  vec  (  29): ADB is used for array.: xya_data
   215  vec  (  29): ADB is used for array.: xyaa_recvbuf
   226  warn (  82): Name "j" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: i.rearrange_column.F90
PROGRAM NAME: rearrange_column
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != Rearrangement of column
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rearrange_column.F90,v 1.1 2014/06/29 07:21:02 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rearrange_column
    13    !
    14    !=
    15    !
    16    != Rearrangement of column
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    ! Rearrange columns
    23    !
    24    !== Procedures List
    25    !
    26  !!$  ! IntLonLat_xy           :: 緯度経度積分
    27  !!$  ! y_IntLon_xy, IntLon_x  :: 経度積分
    28  !!$  ! ya_IntLon_xya          :: 経度積分 (多層用)
    29  !!$  ! x_IntLat_xy, IntLat_y  :: 緯度積分
    30  !!$  ! xa_IntLat_xya          :: 緯度積分 (多層用)
    31  !!$  ! AvrLonLat_xy           :: 緯度経度平均
    32  !!$  ! y_AvrLon_xy, AvrLon_x  :: 経度平均
    33  !!$  ! ya_AvrLon_xya          :: 経度平均 (多層用)
    34  !!$  ! x_AvrLat_xy, AvrLat_y  :: 緯度平均
    35  !!$  ! xa_AvrLat_xya          :: 緯度平均 (多層用)
    36    ! ---------------------  :: ---------------------
    37  !!$  ! y_IntLon_xy, IntLon_x  :: Meridional integral
    38  !!$  ! ya_IntLon_xya          :: Meridional integral (for multi layer)
    39  !!$  ! x_IntLat_xy, IntLat_y  :: Zonal integral
    40  !!$  ! xa_IntLat_xya          :: Zonal integral (for multi layer)
    41  !!$  ! AvrLonLat_xy           :: Zonal and meridional average
    42  !!$  ! y_AvrLon_xy, AvrLon_x  :: Meridional average
    43  !!$  ! ya_AvrLon_xya          :: Meridional average (for multi layer)
    44  !!$  ! x_AvrLat_xy, AvrLat_y  :: Zonal average
    45  !!$  ! xa_AvrLat_xya          :: Zonal average (for multi layer)
    46    !
    47    !--
    48    !== NAMELIST
    49    !
    50    ! NAMELIST#rearrange_column_nml
    51    !++
    52  
    53    ! モジュール引用 ; USE statements
    54    !
    55  
    56    ! 格子点設定
    57    ! Grid points settings
    58    !
    59  !!$  use gridset, only: imax, & ! 経度格子点数.
    60  !!$                             ! Number of grid points in longitude
    61  !!$    &                jmax, & ! 緯度格子点数.
    62  !!$                             ! Number of grid points in latitude
    63  !!$    &                kmax    ! 鉛直層数.
    64  !!$                             ! Number of vertical level
    65  
    66    ! 種別型パラメタ
    67    ! Kind type parameter
    68    !
    69    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    70      &                 STRING     ! 文字列.       Strings.
    71  
    72    ! メッセージ出力
    73    ! Message output
    74    !
    75    use dc_message, only: MessageNotify
    76  
    77    ! 宣言文 ; Declaration statements
    78    !
    79    implicit none
    80    private
    81  
    82    ! 公開手続き
    83    ! Public procedure
    84    !
    85    public:: RearrangeColumn
    86  
    87  
    88    ! 公開変数
    89    ! Public variables
    90    !
    91    logical, save, public:: rearrange_column_inited = .false.
    92                                ! 初期設定フラグ.
    93                                ! Initialization flag
    94  
    95  
    96    ! 非公開変数
    97    ! Private variables
    98    !
    99  
   100    character(*), parameter:: module_name = 'rearrange_column'
   101                                ! モジュールの名称.
   102                                ! Module name
   103    character(*), parameter:: version = &
   104      & '$Name:  $' // &
   105      & '$Id: rearrange_column.F90,v 1.1 2014/06/29 07:21:02 yot Exp $'
   106                                ! モジュールのバージョン
   107                                ! Module version
   108  
   109    ! INTERFACE 文 ; INTERFACE statements
   110    !
   111  
   112  contains
   113  
   114    !-------------------------------------------------------------------
   115  
   116  
   117  
   118    subroutine RearrangeColumn( &
   119      & xya_Data &
   120      & )
   121      !
   122      ! Rearrange columns
   123      !
   124  
   125      ! MPI
   126      !
   127      use mpi_wrapper, only: nprocs, myrank, &
   128        & MPIWrapperISend, &
   129        & MPIWrapperIRecv, &
   130        & MPIWrapperWait
   131  
   132  
   133      real(DP), intent(inout) :: xya_Data(:,:,:)
   134  
   135  
   136      ! 作業変数
   137      ! Work variables
   138      !
   139      real(DP), allocatable :: xyaa_SendBuf(:,:,:,:)
   140      real(DP), allocatable :: xyaa_RecvBuf(:,:,:,:)
   141  
   142      integer :: imaxLocal
   143      integer :: jmaxLocal
   144      integer :: kmaxLocal
   145  
   146      integer :: imaxBlock
   147  
   148      integer :: iLocal
   149  
   150      integer :: a_iReqSend(0:nprocs-1)
   151      integer :: a_iReqRecv(0:nprocs-1)
   152  
   153      integer:: i               ! 経度方向に回る DO ループ用作業変数
   154                                ! Work variables for DO loop in longitudinal direction
   155      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   156                                ! Work variables for DO loop in latitudinal direction
   157      integer:: n
   158  
   159  
   160      ! 実行文 ; Executable statement
   161      !
   162  
   163      imaxLocal = size( xya_Data, 1 )
   164      jmaxLocal = size( xya_Data, 2 )
   165      kmaxLocal = size( xya_Data, 3 )
   166  
   167      if ( mod( imaxLocal/2, nprocs ) /= 0 ) then
   168        call MessageNotify( 'E', module_name, 'nprocs value is inappropriate, nprocs = %d', i = (/ nprocs /) )
   169      end if
   170      if ( mod( imaxLocal/2/nprocs, 2 ) /= 0 ) then
   171        call MessageNotify( 'E', module_name, 'nprocs value is inappropriate, nprocs = %d', i = (/ nprocs /) )
   172      end if
   173  
   174  
   175  
   176      imaxBlock = imaxLocal / nprocs
   177  
   178      allocate( xyaa_SendBuf(1:imaxBlock,1:jmaxLocal,1:kmaxLocal,0:nprocs-1) )
   179      allocate( xyaa_RecvBuf(1:imaxBlock,1:jmaxLocal,1:kmaxLocal,0:nprocs-1) )
   180  
   181  
   182      ! pack data transfered to nth process
   183      do n = 0, nprocs-1
   184        iLocal = 1
   185        do i = n+1, imaxLocal, nprocs
   186          xyaa_SendBuf(iLocal,:,:,n) = xya_Data(i,:,:)
     .        if (xyaa_sendbuf.DSC.U3 + 1 - xyaa_sendbuf.DSC.L3 .gt. 0) then    
     .           j1 = and(xyaa_sendbuf.DSC.U3 + 1 - xyaa_sendbuf.DSC.L3,3)      
     .  !cdir    nodep                                                          
     .           do t266 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t268 = 1, xyaa_sendbuf.DSC.U2 + 1 - xyaa_sendbuf.DSC.L2  
     .                 xyaa_sendbuf(ilocal,t19+t268-1,t266-1+t21,n) = xya_data(i
     .       1            ,t268,t266)                                           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t266=j1+1,xyaa_sendbuf.DSC.U3+1-xyaa_sendbuf.DSC.L3,4       
     .  !cdir       nodep                                                       
     .              do t268 = 1, xyaa_sendbuf.DSC.U2 + 1 - xyaa_sendbuf.DSC.L2  
     .                 xyaa_sendbuf(ilocal,t19+t268-1,t266-1+t21,n) = xya_data(i
     .       1            ,t268,t266)                                           
     .                 xyaa_sendbuf(ilocal,t19+t268-1,t266+t21,n) = xya_data(i, 
     .       1            t268,t266+1)                                          
     .                 xyaa_sendbuf(ilocal,t19+t268-1,t266+1+t21,n) = xya_data(i
     .       1            ,t268,t266+2)                                         
     .                 xyaa_sendbuf(ilocal,t19+t268-1,t266+2+t21,n) = xya_data(i
     .       1            ,t268,t266+3)                                         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   187          iLocal = iLocal + 1
   188        end do
   189      end do
   190  
   191  
   192      do n = 0, nprocs-1
   193        xyaa_RecvBuf = xyaa_SendBuf
     .        if (xyaa_recvbuf.DSC.U2 + 1 - xyaa_recvbuf.DSC.L2 .gt. 0) then    
     .           j2 = and(xyaa_recvbuf.DSC.U2 + 1 - xyaa_recvbuf.DSC.L2,3)      
     .  !cdir    nodep                                                          
     .           do t278 = 1, j2                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaa_sendbuf,xyaa_recvbuf)                           
     .              do t280 = 1, xyaa_recvbuf.DSC.U1 + 1 - xyaa_recvbuf.DSC.L1  
     .                 xyaa_recvbuf(t3+t280-1,t278-1+t5,t276+t7,t274+           
     .       1            xyaa_recvbuf.DSC.L4) = xyaa_sendbuf(t17+t280-1,t278-1+
     .       2            t19,t276+t21,t274+xyaa_sendbuf.DSC.L4)                
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t278=j2+1,xyaa_recvbuf.DSC.U2+1-xyaa_recvbuf.DSC.L2,4       
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaa_sendbuf,xyaa_recvbuf)                           
     .              do t280 = 1, xyaa_recvbuf.DSC.U1 + 1 - xyaa_recvbuf.DSC.L1  
     .                 xyaa_recvbuf(t3+t280-1,t278-1+t5,t276+t7,t274+           
     .       1            xyaa_recvbuf.DSC.L4) = xyaa_sendbuf(t17+t280-1,t278-1+
     .       2            t19,t276+t21,t274+xyaa_sendbuf.DSC.L4)                
     .                 xyaa_recvbuf(t3+t280-1,t278+t5,t276+t7,t274+             
     .       1            xyaa_recvbuf.DSC.L4) = xyaa_sendbuf(t17+t280-1,t278+  
     .       2            t19,t276+t21,t274+xyaa_sendbuf.DSC.L4)                
     .                 xyaa_recvbuf(t3+t280-1,t278+1+t5,t276+t7,t274+           
     .       1            xyaa_recvbuf.DSC.L4) = xyaa_sendbuf(t17+t280-1,t278+1+
     .       2            t19,t276+t21,t274+xyaa_sendbuf.DSC.L4)                
     .                 xyaa_recvbuf(t3+t280-1,t278+2+t5,t276+t7,t274+           
     .       1            xyaa_recvbuf.DSC.L4) = xyaa_sendbuf(t17+t280-1,t278+2+
     .       2            t19,t276+t21,t274+xyaa_sendbuf.DSC.L4)                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   194      end do
   195  
   196      do n = 0, nprocs-1
   197        if ( n == myrank ) then
   198          xyaa_RecvBuf(:,:,:,n) = xyaa_SendBuf(:,:,:,n)
     .        if (xyaa_recvbuf.DSC.U2 - xyaa_recvbuf.DSC.L2 + 2 - min0(1,       
     .       1   xyaa_recvbuf.DSC.U2 - xyaa_recvbuf.DSC.L2 + 1) .gt. 0) then    
     .           j3 = and(xyaa_recvbuf.DSC.U2 - xyaa_recvbuf.DSC.L2 + 2 - min0(1
     .       1      ,xyaa_recvbuf.DSC.U2 - xyaa_recvbuf.DSC.L2 + 1),3)          
     .  !cdir    nodep                                                          
     .           do t300 = 1, j3                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaa_sendbuf)                                        
     .              do t302 = 1, xyaa_recvbuf.DSC.U1 - xyaa_recvbuf.DSC.L1 + 2  
     .       1          - min0(1,xyaa_recvbuf.DSC.U1 - xyaa_recvbuf.DSC.L1 + 1) 
     .                 xyaa_recvbuf(t3+t302-1,t300-1+t5,t298+t7,n) =            
     .       1            xyaa_sendbuf(t17+t302-1,t300-1+t19,t298+t21,n)        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t300 = j3 + 1, xyaa_recvbuf.DSC.U2 - xyaa_recvbuf.DSC.L2 + 2
     .       1       - min0(1,xyaa_recvbuf.DSC.U2 - xyaa_recvbuf.DSC.L2 + 1), 4 
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaa_sendbuf)                                        
     .              do t302 = 1, xyaa_recvbuf.DSC.U1 - xyaa_recvbuf.DSC.L1 + 2  
     .       1          - min0(1,xyaa_recvbuf.DSC.U1 - xyaa_recvbuf.DSC.L1 + 1) 
     .                 xyaa_recvbuf(t3+t302-1,t300-1+t5,t298+t7,n) =            
     .       1            xyaa_sendbuf(t17+t302-1,t300-1+t19,t298+t21,n)        
     .                 xyaa_recvbuf(t3+t302-1,t300+t5,t298+t7,n) = xyaa_sendbuf(
     .       1            t17+t302-1,t300+t19,t298+t21,n)                       
     .                 xyaa_recvbuf(t3+t302-1,t300+1+t5,t298+t7,n) =            
     .       1            xyaa_sendbuf(t17+t302-1,t300+1+t19,t298+t21,n)        
     .                 xyaa_recvbuf(t3+t302-1,t300+2+t5,t298+t7,n) =            
     .       1            xyaa_sendbuf(t17+t302-1,t300+2+t19,t298+t21,n)        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   199        else
   200          call MPIWrapperISend( n, imaxBlock, jmaxLocal, kmaxLocal, xyaa_SendBuf(:,:,:,n), a_iReqSend(n) )
   201          call MPIWrapperIRecv( n, imaxBlock, jmaxLocal, kmaxLocal, xyaa_RecvBuf(:,:,:,n), a_iReqRecv(n) )
   202        end if
   203      end do
   204      do n = 0, nprocs-1
   205        if ( n == myrank ) cycle
   206        call MPIWrapperWait( a_iReqSend(n) )
   207        call MPIWrapperWait( a_iReqRecv(n) )
   208      end do
   209  
   210  
   211      ! pack data transfered to nth process
   212      do n = 0, nprocs-1
   213        iLocal = 1
   214        do i = n+1, imaxLocal, nprocs
   215          xya_Data(i,:,:) = xyaa_RecvBuf(iLocal,:,:,n)
     .        if (xya_data.DSC.U3 .gt. 0) then                                  
     .           j4 = and(xya_data.DSC.U3,3)                                    
     .  !cdir    nodep                                                          
     .           do t290 = 1, j4                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaa_recvbuf)                                        
     .              do t292 = 1, xya_data.DSC.U2                                
     .                 xya_data(i,t292,t290) = xyaa_recvbuf(ilocal,t5+t292-1,   
     .       1            t290-1+t7,n)                                          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t290 = j4 + 1, xya_data.DSC.U3, 4                           
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaa_recvbuf)                                        
     .              do t292 = 1, xya_data.DSC.U2                                
     .                 xya_data(i,t292,t290) = xyaa_recvbuf(ilocal,t5+t292-1,   
     .       1            t290-1+t7,n)                                          
     .                 xya_data(i,t292,t290+1) = xyaa_recvbuf(ilocal,t5+t292-1, 
     .       1            t290+t7,n)                                            
     .                 xya_data(i,t292,t290+2) = xyaa_recvbuf(ilocal,t5+t292-1, 
     .       1            t290+1+t7,n)                                          
     .                 xya_data(i,t292,t290+3) = xyaa_recvbuf(ilocal,t5+t292-1, 
     .       1            t290+2+t7,n)                                          
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   216          iLocal = iLocal + 1
   217        end do
   218      end do
   219  
   220  
   221      deallocate( xyaa_SendBuf )
   222      deallocate( xyaa_RecvBuf )
   223  
   224  
   225  
   226    end subroutine RearrangeColumn
   227  
   228  
   229  
   230    !--------------------------------------------------------------------------------------
   231  
   232  end module rearrange_column
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: i.rearrange_column.F90
PROGRAM NAME: rearrange_column
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != Rearrangement of column
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rearrange_column.F90,v 1.1 2014/06/29 07:21:02 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rearrange_column
    13:               !
    14:               != 
    15:               !
    16:               != Rearrangement of column
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! Rearrange columns
    23:               !
    24:               !== Procedures List
    25:               !
    26:             !!$  ! IntLonLat_xy           :: 緯度経度積分
    27:             !!$  ! y_IntLon_xy, IntLon_x  :: 経度積分
    28:             !!$  ! ya_IntLon_xya          :: 経度積分 (多層用)
    29:             !!$  ! x_IntLat_xy, IntLat_y  :: 緯度積分
    30:             !!$  ! xa_IntLat_xya          :: 緯度積分 (多層用)
    31:             !!$  ! AvrLonLat_xy           :: 緯度経度平均
    32:             !!$  ! y_AvrLon_xy, AvrLon_x  :: 経度平均
    33:             !!$  ! ya_AvrLon_xya          :: 経度平均 (多層用)
    34:             !!$  ! x_AvrLat_xy, AvrLat_y  :: 緯度平均
    35:             !!$  ! xa_AvrLat_xya          :: 緯度平均 (多層用)
    36:               ! ---------------------  :: ---------------------
    37:             !!$  ! y_IntLon_xy, IntLon_x  :: Meridional integral
    38:             !!$  ! ya_IntLon_xya          :: Meridional integral (for multi layer)
    39:             !!$  ! x_IntLat_xy, IntLat_y  :: Zonal integral
    40:             !!$  ! xa_IntLat_xya          :: Zonal integral (for multi layer)
    41:             !!$  ! AvrLonLat_xy           :: Zonal and meridional average
    42:             !!$  ! y_AvrLon_xy, AvrLon_x  :: Meridional average
    43:             !!$  ! ya_AvrLon_xya          :: Meridional average (for multi layer)
    44:             !!$  ! x_AvrLat_xy, AvrLat_y  :: Zonal average
    45:             !!$  ! xa_AvrLat_xya          :: Zonal average (for multi layer)
    46:               !
    47:               !--
    48:               !== NAMELIST
    49:               !
    50:               ! NAMELIST#rearrange_column_nml
    51:               !++
    52:             
    53:               ! モジュール引用 ; USE statements
    54:               !
    55:             
    56:               ! 格子点設定
    57:               ! Grid points settings
    58:               !
    59:             !!$  use gridset, only: imax, & ! 経度格子点数. 
    60:             !!$                             ! Number of grid points in longitude
    61:             !!$    &                jmax, & ! 緯度格子点数. 
    62:             !!$                             ! Number of grid points in latitude
    63:             !!$    &                kmax    ! 鉛直層数. 
    64:             !!$                             ! Number of vertical level
    65:             
    66:               ! 種別型パラメタ
    67:               ! Kind type parameter
    68:               !
    69:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    70:                 &                 STRING     ! 文字列.       Strings. 
    71:             
    72:               ! メッセージ出力
    73:               ! Message output
    74:               !
    75:               use dc_message, only: MessageNotify
    76:             
    77:               ! 宣言文 ; Declaration statements
    78:               !
    79:               implicit none
    80:               private
    81:             
    82:               ! 公開手続き
    83:               ! Public procedure
    84:               !
    85:               public:: RearrangeColumn
    86:             
    87:             
    88:               ! 公開変数
    89:               ! Public variables
    90:               !
    91:               logical, save, public:: rearrange_column_inited = .false.
    92:                                           ! 初期設定フラグ. 
    93:                                           ! Initialization flag
    94:             
    95:             
    96:               ! 非公開変数
    97:               ! Private variables
    98:               !
    99:             
   100:               character(*), parameter:: module_name = 'rearrange_column'
   101:                                           ! モジュールの名称. 
   102:                                           ! Module name
   103:               character(*), parameter:: version = &
   104:                 & '$Name:  $' // &
   105:                 & '$Id: rearrange_column.F90,v 1.1 2014/06/29 07:21:02 yot Exp $'
   106:                                           ! モジュールのバージョン
   107:                                           ! Module version
   108:             
   109:               ! INTERFACE 文 ; INTERFACE statements
   110:               !
   111:             
   112:             contains
   113:             
   114:               !-------------------------------------------------------------------
   115:             
   116:             
   117:             
   118:               subroutine RearrangeColumn( &
   119:                 & xya_Data &
   120:                 & )
   121:                 !
   122:                 ! Rearrange columns
   123:                 !
   124:             
   125:                 ! MPI
   126:                 !
   127:                 use mpi_wrapper, only: nprocs, myrank, &
   128:                   & MPIWrapperISend, &
   129:                   & MPIWrapperIRecv, &
   130:                   & MPIWrapperWait
   131:             
   132:             
   133:                 real(DP), intent(inout) :: xya_Data(:,:,:)
   134:             
   135:             
   136:                 ! 作業変数
   137:                 ! Work variables
   138:                 !
   139:                 real(DP), allocatable :: xyaa_SendBuf(:,:,:,:)
   140:                 real(DP), allocatable :: xyaa_RecvBuf(:,:,:,:)
   141:             
   142:                 integer :: imaxLocal
   143:                 integer :: jmaxLocal
   144:                 integer :: kmaxLocal
   145:             
   146:                 integer :: imaxBlock
   147:             
   148:                 integer :: iLocal
   149:             
   150:                 integer :: a_iReqSend(0:nprocs-1)
   151:                 integer :: a_iReqRecv(0:nprocs-1)
   152:             
   153:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   154:                                           ! Work variables for DO loop in longitudinal direction
   155:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   156:                                           ! Work variables for DO loop in latitudinal direction
   157:                 integer:: n
   158:             
   159:             
   160:                 ! 実行文 ; Executable statement
   161:                 !
   162:             
   163:                 imaxLocal = size( xya_Data, 1 )
   164:                 jmaxLocal = size( xya_Data, 2 )
   165:                 kmaxLocal = size( xya_Data, 3 )
   166:             
   167:                 if ( mod( imaxLocal/2, nprocs ) /= 0 ) then
   168:                   call MessageNotify( 'E', module_name, 'nprocs value is inappropriate, nprocs = %d', i = (/ nprocs /) )
   169:                 end if
   170:                 if ( mod( imaxLocal/2/nprocs, 2 ) /= 0 ) then
   171:                   call MessageNotify( 'E', module_name, 'nprocs value is inappropriate, nprocs = %d', i = (/ nprocs /) )
   172:                 end if
   173:             
   174:             
   175:             
   176:                 imaxBlock = imaxLocal / nprocs
   177:             
   178:                 allocate( xyaa_SendBuf(1:imaxBlock,1:jmaxLocal,1:kmaxLocal,0:nprocs-1) )
   179:                 allocate( xyaa_RecvBuf(1:imaxBlock,1:jmaxLocal,1:kmaxLocal,0:nprocs-1) )
   180:             
   181:             
   182:                 ! pack data transfered to nth process
   183: +------>        do n = 0, nprocs-1
   184: |                 iLocal = 1
   185: |+----->          do i = n+1, imaxLocal, nprocs
   186: ||+V=== A           xyaa_SendBuf(iLocal,:,:,n) = xya_Data(i,:,:)
   187: ||                  iLocal = iLocal + 1
   188: |+-----           end do
   189: +------         end do
   190:             
   191:             
   192: +------>        do n = 0, nprocs-1
   193: |+++V== A         xyaa_RecvBuf = xyaa_SendBuf
   194: +------         end do
   195:             
   196: +------>        do n = 0, nprocs-1
   197: |                 if ( n == myrank ) then
   198: |++V=== A           xyaa_RecvBuf(:,:,:,n) = xyaa_SendBuf(:,:,:,n)
   199: |                 else
   200: |                   call MPIWrapperISend( n, imaxBlock, jmaxLocal, kmaxLocal, xyaa_SendBuf(:,:,:,n), a_iReqSend(n) )
   201: |                   call MPIWrapperIRecv( n, imaxBlock, jmaxLocal, kmaxLocal, xyaa_RecvBuf(:,:,:,n), a_iReqRecv(n) )
   202: |                 end if
   203: +------         end do
   204: +------>        do n = 0, nprocs-1
   205: |                 if ( n == myrank ) cycle
   206: |                 call MPIWrapperWait( a_iReqSend(n) )
   207: |                 call MPIWrapperWait( a_iReqRecv(n) )
   208: +------         end do
   209:             
   210:             
   211:                 ! pack data transfered to nth process
   212: +------>        do n = 0, nprocs-1
   213: |                 iLocal = 1
   214: |+----->          do i = n+1, imaxLocal, nprocs
   215: ||+V=== A           xya_Data(i,:,:) = xyaa_RecvBuf(iLocal,:,:,n)
   216: ||                  iLocal = iLocal + 1
   217: |+-----           end do
   218: +------         end do
   219:             
   220:             
   221:                 deallocate( xyaa_SendBuf )
   222:                 deallocate( xyaa_RecvBuf )
   223:             
   224:             
   225:             
   226:               end subroutine RearrangeColumn
   227:             
   228:             
   229:             
   230:               !--------------------------------------------------------------------------------------
   231:             
   232:             end module rearrange_column
