Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: intg_surftemp.f90
PROGRAM NAME: intg_surftemp
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   160  opt  (1593): Loop nest collapsed into one loop.
   160  vec  (   4): Vectorized array expression.
   160  vec  (  29): ADB is used for array.: xy_surftemp
   160  vec  (  29): ADB is used for array.: xy_dsurftempdt
   165  opt  (1593): Loop nest collapsed into one loop.
   165  vec  (   4): Vectorized array expression.
   165  vec  (  29): ADB is used for array.: xyz_soiltemp
   165  vec  (  29): ADB is used for array.: xyz_dsoiltempdt
   172  warn (  82): Name "k" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: intg_surftemp.f90
PROGRAM NAME: intg_surftemp
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地面温度, 土壌温度の時間積分
     2  !
     3  != Time integration of surface temperature and soil temperature
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6  ! Version::   $Id: intg_surftemp.f90,v 1.10 2011/07/08 03:55:20 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module intg_surftemp
    13    !
    14    != 地面温度, 土壌温度の時間積分
    15    !
    16    != Time integration of surface temperature and soil temperature
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 地面温度と土壌温度の時間積分を行います.
    21    !
    22    ! Time integration of surface temperature and soiltemperature
    23    !
    24    !== Procedures List
    25    !
    26    ! IntegralSurfTemp   :: 地面温度, 土壌温度の時間積分
    27    ! ---------------    :: ---------------
    28    ! IntegralSurfTemp   :: Time integration of surface temperature and soil temperature
    29    !
    30    !--
    31    !== NAMELIST
    32    !
    33    ! NAMELIST#intg_surftemp_nml
    34    !++
    35  
    36    ! モジュール引用 ; USE statements
    37    !
    38  
    39    ! 格子点設定
    40    ! Grid points settings
    41    !
    42    use gridset, only:   imax, & ! 経度格子点数.
    43                                 ! Number of grid points in longitude
    44      &                  jmax, & ! 緯度格子点数.
    45                                 ! Number of grid points in latitude
    46      &                  kmax, & ! 鉛直層数.
    47                                 ! Number of vertical level
    48      &                kslmax    ! 地下の鉛直層数.
    49                                 ! Number of subsurface vertical level
    50  
    51    ! 種別型パラメタ
    52    ! Kind type parameter
    53    !
    54    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    55      &                 STRING     ! 文字列.       Strings.
    56  
    57    ! メッセージ出力
    58    ! Message output
    59    !
    60    use dc_message, only: MessageNotify
    61  
    62    ! 宣言文 ; Declaration statements
    63    !
    64    implicit none
    65    private
    66  
    67    ! 公開手続き
    68    ! Public procedure
    69    !
    70    public :: IntegralSurfTemp
    71    public :: IntgSurfTempInit
    72  
    73    ! 公開変数
    74    ! Public variables
    75    !
    76  
    77    ! 非公開変数
    78    ! Private variables
    79    !
    80    logical, save :: intg_surftemp_inited = .false.
    81                                ! 初期設定フラグ.
    82                                ! Initialization flag
    83  
    84    character(*), parameter:: module_name = 'intg_surftemp'
    85                                ! モジュールの名称.
    86                                ! Module name
    87    character(*), parameter:: version = &
    88      & '$Name:  $' // &
    89      & '$Id: intg_surftemp.f90,v 1.10 2011/07/08 03:55:20 yot Exp $'
    90                                ! モジュールのバージョン
    91                                ! Module version
    92  
    93  contains
    94  
    95    !--------------------------------------------------------------------------------------
    96  
    97    subroutine IntegralSurfTemp(         &
    98      & xy_DSurfTempDt, xyz_DSoilTempDt, &          ! (in)
    99      & xy_SurfTemp   , xyz_SoilTemp     &          ! (inout)
   100      & )
   101      !
   102      ! 地面温度, 土壌温度の時間積分を行います.
   103      !
   104      ! Time integration of surface temperature and soil temperature
   105      !
   106      !
   107  
   108      ! モジュール引用 ; USE statements
   109      !
   110  
   111      ! 時刻管理
   112      ! Time control
   113      !
   114      use timeset, only: DelTime, &  ! $ \Delta t $
   115        & TimesetClockStart, TimesetClockStop
   116  
   117      ! 宣言文 ; Declaration statements
   118      !
   119      implicit none
   120      real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
   121                                ! 地表面温度変化率 (K s-1)
   122                                ! Surface temperature tendency (K s-1)
   123      real(DP), intent(in):: xyz_DSoilTempDt (0:imax-1, 1:jmax, 1:kslmax)
   124                                ! $ \DP{Tg}{t} $ . 土壌温度変化 (K s-1)
   125                                ! Temperature tendency (K s-1)
   126      real(DP), intent(inout):: xy_SurfTemp (0:imax-1, 1:jmax)
   127                                ! 地表面温度.
   128                                ! Surface temperature
   129      real(DP), intent(inout):: xyz_SoilTemp(0:imax-1, 1:jmax, 1:kslmax)
   130                                ! 土壌温度 (K)
   131                                ! Soil temperature (K)
   132  
   133  
   134      ! 作業変数
   135      ! Work variables
   136      !
   137      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   138                                ! Work variables for DO loop in vertical direction
   139  
   140  
   141      ! 実行文 ; Executable statement
   142      !
   143  
   144      ! 初期化確認
   145      ! Initialization check
   146      !
   147      if ( .not. intg_surftemp_inited ) then
   148        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   149      end if
   150  
   151  
   152      ! 計算時間計測開始
   153      ! Start measurement of computation time
   154      !
   155      call TimesetClockStart( module_name )
   156  
   157      ! 地表面温度時間積分
   158      ! Time integration of surface temperature
   159      !
   160      xy_SurfTemp = xy_SurfTemp + xy_DSurfTempDt * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t71 = 1, jmax*imax                                             
     .           xy_surftemp(t71-1,1) = xy_surftemp(t71-1,1) + xy_dsurftempdt(  
     .       1      t71-1,1)*deltime                                            
     .        enddo                                                             
   161  
   162      ! 土壌温度時間積分
   163      ! Time integration of subsurface temperature
   164      !
   165      xyz_SoilTemp = xyz_SoilTemp + xyz_DSoilTempDt * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t81 = 1, kslmax*jmax*imax                                      
     .           xyz_soiltemp(t81-1,1,1) = xyz_soiltemp(t81-1,1,1) +            
     .       1      xyz_dsoiltempdt(t81-1,1,1)*deltime                          
     .        enddo                                                             
   166  
   167      ! 計算時間計測一時停止
   168      ! Pause measurement of computation time
   169      !
   170      call TimesetClockStop( module_name )
   171  
   172    end subroutine IntegralSurfTemp
   173  
   174    !--------------------------------------------------------------------------------------
   175  
   176    subroutine IntgSurfTempInit
   177      !
   178      ! intg_surftemp モジュールの初期化を行います.
   179      ! NAMELIST#intg_surftemp_nml の読み込みはこの手続きで行われます.
   180      !
   181      ! "intg_surftemp" module is initialized.
   182      ! "NAMELIST#intg_surftemp_nml" is loaded in this procedure.
   183      !
   184  
   185      ! モジュール引用 ; USE statements
   186      !
   187  
   188      ! NAMELIST ファイル入力に関するユーティリティ
   189      ! Utilities for NAMELIST file input
   190      !
   191      use namelist_util, only: namelist_filename, NmlutilMsg
   192  
   193      ! ファイル入出力補助
   194      ! File I/O support
   195      !
   196      use dc_iounit, only: FileOpen
   197  
   198      ! 種別型パラメタ
   199      ! Kind type parameter
   200      !
   201      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   202  
   203      ! 文字列操作
   204      ! Character handling
   205      !
   206      use dc_string, only: StoA
   207  
   208      ! 宣言文 ; Declaration statements
   209      !
   210      implicit none
   211  
   212  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   213  !!$                              ! Unit number for NAMELIST file open
   214  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   215  !!$                              ! IOSTAT of NAMELIST read
   216  
   217      ! NAMELIST 変数群
   218      ! NAMELIST group name
   219      !
   220  !!$    namelist /intg_surftemp_nml/
   221            !
   222            ! デフォルト値については初期化手続 "intg_surftemp#IntgSurfTempInit"
   223            ! のソースコードを参照のこと.
   224            !
   225            ! Refer to source codes in the initialization procedure
   226            ! "intg_surftemp#IntgSurfTempInit" for the default values.
   227            !
   228  
   229      ! 実行文 ; Executable statement
   230      !
   231  
   232      if ( intg_surftemp_inited ) return
   233  
   234  
   235      ! デフォルト値の設定
   236      ! Default values settings
   237      !
   238  
   239  !!$    ! NAMELIST の読み込み
   240  !!$    ! NAMELIST is input
   241  !!$    !
   242  !!$    if ( trim(namelist_filename) /= '' ) then
   243  !!$      call FileOpen( unit_nml, &          ! (out)
   244  !!$        & namelist_filename, mode = 'r' ) ! (in)
   245  !!$
   246  !!$      rewind( unit_nml )
   247  !!$      read( unit_nml, &           ! (in)
   248  !!$        & nml = intg_surftemp_nml, &  ! (out)
   249  !!$        & iostat = iostat_nml )   ! (out)
   250  !!$      close( unit_nml )
   251  !!$
   252  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   253  !!$    end if
   254  
   255      ! 印字 ; Print
   256      !
   257      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   258      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   259  
   260      intg_surftemp_inited = .true.
   261  
   262    end subroutine IntgSurfTempInit
   263  
   264    !--------------------------------------------------------------------------------------
   265  
   266  end module intg_surftemp
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: intg_surftemp.f90
PROGRAM NAME: intg_surftemp
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地面温度, 土壌温度の時間積分
     2:             ! 
     3:             != Time integration of surface temperature and soil temperature
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6:             ! Version::   $Id: intg_surftemp.f90,v 1.10 2011/07/08 03:55:20 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module intg_surftemp
    13:               !
    14:               != 地面温度, 土壌温度の時間積分
    15:               ! 
    16:               != Time integration of surface temperature and soil temperature
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 地面温度と土壌温度の時間積分を行います. 
    21:               ! 
    22:               ! Time integration of surface temperature and soiltemperature
    23:               !
    24:               !== Procedures List
    25:               !
    26:               ! IntegralSurfTemp   :: 地面温度, 土壌温度の時間積分
    27:               ! ---------------    :: ---------------
    28:               ! IntegralSurfTemp   :: Time integration of surface temperature and soil temperature
    29:               !
    30:               !--
    31:               !== NAMELIST
    32:               !
    33:               ! NAMELIST#intg_surftemp_nml
    34:               !++
    35:             
    36:               ! モジュール引用 ; USE statements
    37:               !
    38:             
    39:               ! 格子点設定
    40:               ! Grid points settings
    41:               !
    42:               use gridset, only:   imax, & ! 経度格子点数. 
    43:                                            ! Number of grid points in longitude
    44:                 &                  jmax, & ! 緯度格子点数. 
    45:                                            ! Number of grid points in latitude
    46:                 &                  kmax, & ! 鉛直層数. 
    47:                                            ! Number of vertical level
    48:                 &                kslmax    ! 地下の鉛直層数. 
    49:                                            ! Number of subsurface vertical level
    50:             
    51:               ! 種別型パラメタ
    52:               ! Kind type parameter
    53:               !
    54:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    55:                 &                 STRING     ! 文字列.       Strings. 
    56:             
    57:               ! メッセージ出力
    58:               ! Message output
    59:               !
    60:               use dc_message, only: MessageNotify
    61:             
    62:               ! 宣言文 ; Declaration statements
    63:               !
    64:               implicit none
    65:               private
    66:             
    67:               ! 公開手続き
    68:               ! Public procedure
    69:               !
    70:               public :: IntegralSurfTemp
    71:               public :: IntgSurfTempInit
    72:             
    73:               ! 公開変数
    74:               ! Public variables
    75:               !
    76:             
    77:               ! 非公開変数
    78:               ! Private variables
    79:               !
    80:               logical, save :: intg_surftemp_inited = .false.
    81:                                           ! 初期設定フラグ. 
    82:                                           ! Initialization flag
    83:             
    84:               character(*), parameter:: module_name = 'intg_surftemp'
    85:                                           ! モジュールの名称. 
    86:                                           ! Module name
    87:               character(*), parameter:: version = &
    88:                 & '$Name:  $' // &
    89:                 & '$Id: intg_surftemp.f90,v 1.10 2011/07/08 03:55:20 yot Exp $'
    90:                                           ! モジュールのバージョン
    91:                                           ! Module version
    92:             
    93:             contains
    94:             
    95:               !--------------------------------------------------------------------------------------
    96:             
    97:               subroutine IntegralSurfTemp(         &
    98:                 & xy_DSurfTempDt, xyz_DSoilTempDt, &          ! (in)
    99:                 & xy_SurfTemp   , xyz_SoilTemp     &          ! (inout)
   100:                 & )
   101:                 !
   102:                 ! 地面温度, 土壌温度の時間積分を行います. 
   103:                 !
   104:                 ! Time integration of surface temperature and soil temperature
   105:                 !
   106:                 !
   107:             
   108:                 ! モジュール引用 ; USE statements
   109:                 !
   110:             
   111:                 ! 時刻管理
   112:                 ! Time control
   113:                 !
   114:                 use timeset, only: DelTime, &  ! $ \Delta t $
   115:                   & TimesetClockStart, TimesetClockStop
   116:             
   117:                 ! 宣言文 ; Declaration statements
   118:                 !
   119:                 implicit none
   120:                 real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
   121:                                           ! 地表面温度変化率 (K s-1)
   122:                                           ! Surface temperature tendency (K s-1)
   123:                 real(DP), intent(in):: xyz_DSoilTempDt (0:imax-1, 1:jmax, 1:kslmax)
   124:                                           ! $ \DP{Tg}{t} $ . 土壌温度変化 (K s-1)
   125:                                           ! Temperature tendency (K s-1)
   126:                 real(DP), intent(inout):: xy_SurfTemp (0:imax-1, 1:jmax)
   127:                                           ! 地表面温度. 
   128:                                           ! Surface temperature
   129:                 real(DP), intent(inout):: xyz_SoilTemp(0:imax-1, 1:jmax, 1:kslmax)
   130:                                           ! 土壌温度 (K)
   131:                                           ! Soil temperature (K)
   132:             
   133:             
   134:                 ! 作業変数
   135:                 ! Work variables
   136:                 !
   137:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   138:                                           ! Work variables for DO loop in vertical direction
   139:             
   140:             
   141:                 ! 実行文 ; Executable statement
   142:                 !
   143:             
   144:                 ! 初期化確認
   145:                 ! Initialization check
   146:                 !
   147:                 if ( .not. intg_surftemp_inited ) then
   148:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   149:                 end if
   150:             
   151:             
   152:                 ! 計算時間計測開始
   153:                 ! Start measurement of computation time
   154:                 !
   155:                 call TimesetClockStart( module_name )
   156:             
   157:                 ! 地表面温度時間積分
   158:                 ! Time integration of surface temperature
   159:                 !
   160: W*===== A       xy_SurfTemp = xy_SurfTemp + xy_DSurfTempDt * DelTime
   161:             
   162:                 ! 土壌温度時間積分
   163:                 ! Time integration of subsurface temperature
   164:                 !
   165: W**==== A       xyz_SoilTemp = xyz_SoilTemp + xyz_DSoilTempDt * DelTime
   166:             
   167:                 ! 計算時間計測一時停止
   168:                 ! Pause measurement of computation time
   169:                 !
   170:                 call TimesetClockStop( module_name )
   171:             
   172:               end subroutine IntegralSurfTemp
   173:             
   174:               !--------------------------------------------------------------------------------------
   175:             
   176:               subroutine IntgSurfTempInit
   177:                 !
   178:                 ! intg_surftemp モジュールの初期化を行います. 
   179:                 ! NAMELIST#intg_surftemp_nml の読み込みはこの手続きで行われます. 
   180:                 !
   181:                 ! "intg_surftemp" module is initialized. 
   182:                 ! "NAMELIST#intg_surftemp_nml" is loaded in this procedure. 
   183:                 !
   184:             
   185:                 ! モジュール引用 ; USE statements
   186:                 !
   187:             
   188:                 ! NAMELIST ファイル入力に関するユーティリティ
   189:                 ! Utilities for NAMELIST file input
   190:                 !
   191:                 use namelist_util, only: namelist_filename, NmlutilMsg
   192:             
   193:                 ! ファイル入出力補助
   194:                 ! File I/O support
   195:                 !
   196:                 use dc_iounit, only: FileOpen
   197:             
   198:                 ! 種別型パラメタ
   199:                 ! Kind type parameter
   200:                 !
   201:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   202:             
   203:                 ! 文字列操作
   204:                 ! Character handling
   205:                 !
   206:                 use dc_string, only: StoA
   207:             
   208:                 ! 宣言文 ; Declaration statements
   209:                 !
   210:                 implicit none
   211:             
   212:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   213:             !!$                              ! Unit number for NAMELIST file open
   214:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   215:             !!$                              ! IOSTAT of NAMELIST read
   216:             
   217:                 ! NAMELIST 変数群
   218:                 ! NAMELIST group name
   219:                 !
   220:             !!$    namelist /intg_surftemp_nml/
   221:                       !
   222:                       ! デフォルト値については初期化手続 "intg_surftemp#IntgSurfTempInit" 
   223:                       ! のソースコードを参照のこと. 
   224:                       !
   225:                       ! Refer to source codes in the initialization procedure
   226:                       ! "intg_surftemp#IntgSurfTempInit" for the default values. 
   227:                       !
   228:             
   229:                 ! 実行文 ; Executable statement
   230:                 !
   231:             
   232:                 if ( intg_surftemp_inited ) return
   233:             
   234:             
   235:                 ! デフォルト値の設定
   236:                 ! Default values settings
   237:                 !
   238:             
   239:             !!$    ! NAMELIST の読み込み
   240:             !!$    ! NAMELIST is input
   241:             !!$    !
   242:             !!$    if ( trim(namelist_filename) /= '' ) then
   243:             !!$      call FileOpen( unit_nml, &          ! (out)
   244:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   245:             !!$
   246:             !!$      rewind( unit_nml )
   247:             !!$      read( unit_nml, &           ! (in)
   248:             !!$        & nml = intg_surftemp_nml, &  ! (out)
   249:             !!$        & iostat = iostat_nml )   ! (out)
   250:             !!$      close( unit_nml )
   251:             !!$
   252:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   253:             !!$    end if
   254:             
   255:                 ! 印字 ; Print
   256:                 !
   257:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   258:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   259:             
   260:                 intg_surftemp_inited = .true.
   261:             
   262:               end subroutine IntgSurfTempInit
   263:             
   264:               !--------------------------------------------------------------------------------------
   265:             
   266:             end module intg_surftemp
