Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: timefilter_asselin1972.f90
PROGRAM NAME: timefilter_asselin1972
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   256  opt  (  11): Fused array assignments. :line 256 - 262
   256  opt  (1593): Loop nest collapsed into one loop.
   256  vec  (   4): Vectorized array expression.
   256  vec  (  29): ADB is used for array.: xyz_tempn
   256  vec  (  29): ADB is used for array.: xyz_tempa
   256  vec  (  29): ADB is used for array.: xyz_tempb
   256  vec  (  29): ADB is used for array.: xyz_vn
   256  vec  (  29): ADB is used for array.: xyz_va
   256  vec  (  29): ADB is used for array.: xyz_vb
   256  vec  (  29): ADB is used for array.: xyz_un
   256  vec  (  29): ADB is used for array.: xyz_ua
   256  vec  (  29): ADB is used for array.: xyz_ub
   265  opt  (1593): Loop nest collapsed into one loop.
   265  vec  (   4): Vectorized array expression.
   265  vec  (  29): ADB is used for array.: xy_psn
   265  vec  (  29): ADB is used for array.: xy_psa
   265  vec  (  29): ADB is used for array.: xy_psb
   268  opt  (1593): Loop nest collapsed into one loop.
   268  vec  (   4): Vectorized array expression.
   268  vec  (  29): ADB is used for array.: xyzf_qmixn
   268  vec  (  29): ADB is used for array.: xyzf_qmixa
   268  vec  (  29): ADB is used for array.: xyzf_qmixb
   374  opt  (  11): Fused array assignments. :line 374 - 382
   374  opt  (1593): Loop nest collapsed into one loop.
   374  vec  (   4): Vectorized array expression.
   374  vec  (  29): ADB is used for array.: xy_surfsnown
   374  vec  (  29): ADB is used for array.: xy_surfsnowa
   374  vec  (  29): ADB is used for array.: xy_surfsnowb
   374  vec  (  29): ADB is used for array.: xy_soilmoistn
   374  vec  (  29): ADB is used for array.: xy_soilmoista
   374  vec  (  29): ADB is used for array.: xy_soilmoistb
   374  vec  (  29): ADB is used for array.: xy_surfmajcompicen
   374  vec  (  29): ADB is used for array.: xy_surfmajcompicea
   374  vec  (  29): ADB is used for array.: xy_surfmajcompiceb
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: timefilter_asselin1972.f90
PROGRAM NAME: timefilter_asselin1972
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != タイムフィルター (Asselin, 1972)
     2  !
     3  != Time filter (Asselin, 1972)
     4  !
     5  ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: timefilter_asselin1972.f90,v 1.13 2014/05/07 09:39:24 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module timefilter_asselin1972
    13    !
    14    != タイムフィルター (Asselin, 1972)
    15    !
    16    != Time filter (Asselin, 1972)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 計算モードを抑えるためのタイムフィルター (Asselin, 1972)
    21    ! を適用するためのモジュールです.
    22    !
    23    ! すなわち
    24    ! \[
    25    !   \bar{A}^{t}
    26    !   = {A}^{t}
    27    !     + \epsilon_f
    28    !        \left(
    29    !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
    30    !        \right) \] \[
    31    !   \qquad
    32    !   = ( 1-2 \epsilon_f ) {A}^{t}
    33    !     + \epsilon_f
    34    !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    35    ! \]
    36    ! として $ \bar{A}^{t} $ を求めます. 添え字
    37    ! $ t-\Delta t, t, t+\Delta t $ はそれぞれ時間ステップを表し,
    38    ! タイムフィルターが適用された項には上線 ( $ \bar{\quad} $ )
    39    ! が付いています.
    40    !
    41    ! タイムフィルターの係数 $\epsilon_f$ は Create の際に設定します.
    42    !
    43    !--
    44    ! \[
    45    !   \bar{\mathscr A}^{t}
    46    !     = ( 1-2 \epsilon_f ) {\mathscr A}^{t}
    47    !     +  \epsilon_f
    48    !         \left( \bar{\mathscr A}^{t-\Delta t} + {\mathscr A}^{t+\Delta t} \right)
    49    ! \]
    50    ! として$\bar{\mathscr A}^{t}$を求めます. 添え字
    51    !++
    52    !
    53    ! Time filter (Asselin, 1972) for suppression of computational mode
    54    ! is applied.
    55    !
    56    ! Concretely, $ \bar{A}^{t} $ is derived as follows.
    57    ! \[
    58    !   \bar{A}^{t}
    59    !   = {A}^{t}
    60    !     + \epsilon_f
    61    !        \left(
    62    !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
    63    !        \right) \] \[
    64    !   \qquad
    65    !   = ( 1-2 \epsilon_f ) {A}^{t}
    66    !     + \epsilon_f
    67    !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right),
    68    ! \]
    69    ! where suffices $ t-\Delta t, t, t+\Delta t $ represent time step,
    70    ! and over-bar $ \bar{\quad} $ represents the terms applied
    71    ! time filter.
    72    !
    73    ! Time filter coefficient $ \epsilon_f $ is specified by "Create".
    74    !
    75    !== Procedures List
    76    !
    77    ! TimeFilter    :: タイムフィルターの適用
    78    ! ------------  :: ------------
    79    ! TimeFilter    :: Apply time filter
    80    !
    81    !== NAMELIST
    82    !
    83    ! NAMELIST#timefilter_asselin1972_nml
    84    !
    85    !== References
    86    !
    87    ! * Asselin, R. A., 1972:
    88    !   Frequency filter for time integrations.
    89    !   <i>Mon. Wea. Rev.</i>, <b>100</b>, 487--490.
    90    !
    91  
    92    ! モジュール引用 ; USE statements
    93    !
    94  
    95    ! 格子点設定
    96    ! Grid points settings
    97    !
    98    use gridset, only: imax, & ! 経度格子点数.
    99                               ! Number of grid points in longitude
   100      &                jmax, & ! 緯度格子点数.
   101                               ! Number of grid points in latitude
   102      &                kmax    ! 鉛直層数.
   103                               ! Number of vertical level
   104  
   105    use composition, only: ncmax  ! 微量成分の数
   106                                  ! Number of composition
   107  
   108    ! 種別型パラメタ
   109    ! Kind type parameter
   110    !
   111    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   112      &                 STRING     ! 文字列.       Strings.
   113  
   114  
   115    ! メッセージ出力
   116    ! Message output
   117    !
   118    use dc_message, only: MessageNotify
   119  
   120    ! 宣言文 ; Declaration statements
   121    !
   122    implicit none
   123    private
   124  
   125    ! 公開手続き
   126    ! Public procedure
   127    !
   128    public :: TimeFilter
   129    public :: TimeFilterSurfVars
   130    public :: TimeFiltInit
   131  
   132    ! 公開変数
   133    ! Public variables
   134    !
   135  
   136    ! 非公開変数
   137    ! Private variables
   138    !
   139    logical, save :: timefilter_asselin1972_inited = .false.
   140                                ! 初期設定フラグ.
   141                                ! Initialization flag
   142  
   143    real(DP), save:: FilterParameter
   144                                ! タイムフィルターの係数.
   145                                ! Time filter coefficient
   146  !!$  integer, save:: IntStep     ! タイムフィルターを適用するステップ間隔.
   147  !!$                              ! Step interval of time filter application
   148  !!$  integer, save:: CurStep     ! TimeFilter が呼ばれた回数.
   149  !!$                              ! Number of times that "TimeFilter" is called
   150  !!$  integer, save:: PrevStep    ! 前回タイムフィルターを適用したステップ数.
   151  !!$                              ! Step number that is filtered previously
   152  
   153    character(*), parameter:: module_name = 'timefilter_asselin1972'
   154                                ! モジュールの名称.
   155                                ! Module name
   156    character(*), parameter:: version = &
   157      & '$Name:  $' // &
   158      & '$Id: timefilter_asselin1972.f90,v 1.13 2014/05/07 09:39:24 murashin Exp $'
   159                                ! モジュールのバージョン
   160                                ! Module version
   161  
   162  contains
   163  
   164    !--------------------------------------------------------------------------------------
   165  
   166    subroutine TimeFilter( &
   167      & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
   168      & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, &   ! (inout)
   169      & xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA, xy_PsA  &   ! (in)
   170      & )
   171      !
   172      ! 予報変数にタイムフィルターを適用します.
   173      !
   174      ! Time filter is applied to predictional variables.
   175      !
   176  
   177      ! モジュール引用 ; USE statements
   178      !
   179  
   180      ! 時刻管理
   181      ! Time control
   182      !
   183      use timeset, only: &
   184        & TimesetClockStart, TimesetClockStop
   185  
   186      ! 宣言文 ; Declaration statements
   187      !
   188      implicit none
   189  
   190      real(DP), intent(in):: xyz_UB (0:imax-1, 1:jmax, 1:kmax)
   191                                ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
   192      real(DP), intent(in):: xyz_VB (0:imax-1, 1:jmax, 1:kmax)
   193                                ! $ v (t-\Delta t) $ .   南北風速. Northward wind
   194      real(DP), intent(in):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   195                                ! $ T (t-\Delta t) $ .   温度. Temperature
   196      real(DP), intent(in):: xyzf_QMixB (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   197                                ! $ q (t-\Delta t) $ .   混合比. Mass mixing ratio of constituents
   198      real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
   199                                ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   200      real(DP), intent(inout):: xyz_UN (0:imax-1, 1:jmax, 1:kmax)
   201                                ! $ u (t) $ .     東西風速. Eastward wind
   202      real(DP), intent(inout):: xyz_VN (0:imax-1, 1:jmax, 1:kmax)
   203                                ! $ v (t) $ .     南北風速. Northward wind
   204      real(DP), intent(inout):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
   205                                ! $ T (t) $ .     温度. Temperature
   206      real(DP), intent(inout):: xyzf_QMixN (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   207                                ! $ q (t) $ .     混合比. Mass mixing ratio of constituents
   208      real(DP), intent(inout):: xy_PsN (0:imax-1, 1:jmax)
   209                                ! $ p_s (t) $ .   地表面気圧. Surface pressure
   210      real(DP), intent(in):: xyz_UA (0:imax-1, 1:jmax, 1:kmax)
   211                                ! $ u (t+\Delta t) $ .   東西風速. Eastward wind
   212      real(DP), intent(in):: xyz_VA (0:imax-1, 1:jmax, 1:kmax)
   213                                ! $ v (t+\Delta t) $ .   南北風速. Northward wind
   214      real(DP), intent(in):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
   215                                ! $ T (t+\Delta t) $ .   温度. Temperature
   216      real(DP), intent(in):: xyzf_QMixA (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   217                                ! $ q (t+\Delta t) $ .   混合比. Mass mixing ratio of constituents
   218      real(DP), intent(in):: xy_PsA (0:imax-1, 1:jmax)
   219                                ! $ p_s (t+\Delta t) $ . 地表面気圧. Surface pressure
   220  
   221      ! 作業変数
   222      ! Work variables
   223      !
   224  
   225      ! 実行文 ; Executable statement
   226      !
   227  
   228      ! 初期化確認
   229      ! Initialization check
   230      !
   231      if ( .not. timefilter_asselin1972_inited ) then
   232        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   233      end if
   234  
   235      ! 計算時間計測開始
   236      ! Start measurement of computation time
   237      !
   238      call TimesetClockStart( module_name )
   239  
   240  
   241  !!$    ! ステップのチェック
   242  !!$    ! Check Step
   243  !!$    !
   244  !!$    CurStep = CurStep + 1
   245  !!$    if ( CurStep - PrevStep < IntStep ) return
   246  !!$    PrevStep = CurStep
   247  
   248      ! FilterParameter の有効性のチェック
   249      ! Check validity of "FilterParameter"
   250      !
   251      if ( FilterParameter == 0.0_DP ) return
   252  
   253      ! タイムフィルターを適用
   254      ! Apply time filter
   255      !
   256      xyz_UN     =  xyz_UN    &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t266 = 1, kmax*jmax*imax                                       
     .           xyz_un(t266-1,1,1) = xyz_un(t266-1,1,1) + filterparameter*(    
     .       1      xyz_ub(t266-1,1,1)-2.00000000000000e+000*xyz_un(t266-1,1,1)+
     .       2      xyz_ua(t266-1,1,1))                                         
     .           xyz_vn(t266-1,1,1) = xyz_vn(t266-1,1,1) + filterparameter*(    
     .       1      xyz_vb(t266-1,1,1)-2.00000000000000e+000*xyz_vn(t266-1,1,1)+
     .       2      xyz_va(t266-1,1,1))                                         
     .           xyz_tempn(t266-1,1,1) = xyz_tempn(t266-1,1,1) + filterparameter
     .       1      *(xyz_tempb(t266-1,1,1)-2.00000000000000e+000*xyz_tempn(t266
     .       2      -1,1,1)+xyz_tempa(t266-1,1,1))                              
     .        enddo                                                             
   257        & + FilterParameter * ( xyz_UB     - 2.0d0 * xyz_UN     + xyz_UA     )
   258  
   259      xyz_VN     =  xyz_VN    &
   260        & + FilterParameter * ( xyz_VB     - 2.0d0 * xyz_VN     + xyz_VA     )
   261  
   262      xyz_TempN  =  xyz_TempN &
   263        & + FilterParameter * ( xyz_TempB  - 2.0d0 * xyz_TempN  + xyz_TempA  )
   264  
   265      xy_PsN     =  xy_PsN    &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t317 = 1, jmax*imax                                            
     .           xy_psn(t317-1,1) = xy_psn(t317-1,1) + filterparameter*(xy_psb( 
     .       1      t317-1,1)-2.00000000000000e+000*xy_psn(t317-1,1)+xy_psa(t317
     .       2      -1,1))                                                      
     .        enddo                                                             
   266        & + FilterParameter * ( xy_PsB     - 2.0d0 * xy_PsN     + xy_PsA     )
   267  
   268      xyzf_QMixN = xyzf_QMixN &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t331 = 1, ncmax*kmax*jmax*imax                                 
     .           xyzf_qmixn(t331-1,1,1,1) = xyzf_qmixn(t331-1,1,1,1) +          
     .       1      filterparameter*(xyzf_qmixb(t331-1,1,1,1)-                  
     .       2      2.00000000000000e+000*xyzf_qmixn(t331-1,1,1,1)+xyzf_qmixa(  
     .       3      t331-1,1,1,1))                                              
     .        enddo                                                             
   269        & + FilterParameter * ( xyzf_QMixB - 2.0d0 * xyzf_QMixN + xyzf_QMixA )
   270  
   271  
   272      ! 計算時間計測一時停止
   273      ! Pause measurement of computation time
   274      !
   275      call TimesetClockStop( module_name )
   276  
   277    end subroutine TimeFilter
   278  
   279    !--------------------------------------------------------------------------------------
   280  
   281    subroutine TimeFilterSurfVars(                       &
   282      & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, &   ! (in)
   283      & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN, &   ! (inout)
   284      & xy_SurfMajCompIceA, xy_SoilMoistA, xy_SurfSnowA  &   ! (in)
   285      & )
   286      !
   287      ! 予報変数にタイムフィルターを適用します.
   288      !
   289      ! Time filter is applied to predictional variables.
   290      !
   291  
   292      ! モジュール引用 ; USE statements
   293      !
   294  
   295      ! 時刻管理
   296      ! Time control
   297      !
   298      use timeset, only: &
   299        & TimesetClockStart, TimesetClockStop
   300  
   301      ! 宣言文 ; Declaration statements
   302      !
   303      implicit none
   304  
   305      real(DP), intent(in   ):: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   306                                ! $ M_mcs (t-\Delta t) $ .
   307                                ! Surface major component ice amount
   308      real(DP), intent(in   ):: xy_SoilMoistB (0:imax-1, 1:jmax)
   309                                ! $ M_ws (t-\Delta t) $ . 地表水質量.
   310                                ! Soil moisture
   311      real(DP), intent(in   ):: xy_SurfSnowB  (0:imax-1, 1:jmax)
   312                                ! $ M_ss (t-\Delta t) $ . 積雪量.
   313                                ! Surface snow amount
   314      real(DP), intent(inout):: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
   315                                ! $ M_mcs (t) $ .
   316                                ! Surface major component ice amount
   317      real(DP), intent(inout):: xy_SoilMoistN (0:imax-1, 1:jmax)
   318                                ! $ M_ws (t-\Delta t) $ . 地表水質量.
   319                                ! Soil moisture
   320      real(DP), intent(inout):: xy_SurfSnowN  (0:imax-1, 1:jmax)
   321                                ! $ M_ss (t) $ . 積雪量.
   322                                ! Surface snow amount
   323      real(DP), intent(in   ):: xy_SurfMajCompIceA(0:imax-1, 1:jmax)
   324                                ! $ M_mcs (t+\Delta t) $ .
   325                                ! Surface major component ice amount
   326      real(DP), intent(in   ):: xy_SoilMoistA (0:imax-1, 1:jmax)
   327                                ! $ M_ws (t-\Delta t) $ . 地表水質量.
   328                                ! Soil moisture
   329      real(DP), intent(in   ):: xy_SurfSnowA  (0:imax-1, 1:jmax)
   330                                ! $ M_ss (t+\Delta t) $ . 積雪量.
   331                                ! Surface snow amount
   332  
   333      ! 作業変数
   334      ! Work variables
   335      !
   336  !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   337  !!$                              ! Work variables for DO loop in longitude
   338  !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   339  !!$                              ! Work variables for DO loop in latitude
   340  
   341  
   342      ! 実行文 ; Executable statement
   343      !
   344  
   345      ! 初期化確認
   346      ! Initialization check
   347      !
   348      if ( .not. timefilter_asselin1972_inited ) then
   349        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   350      end if
   351  
   352  
   353      ! 計算時間計測開始
   354      ! Start measurement of computation time
   355      !
   356      call TimesetClockStart( module_name )
   357  
   358  
   359  !!$    ! ステップのチェック
   360  !!$    ! Check Step
   361  !!$    !
   362  !!$    CurStep = CurStep + 1
   363  !!$    if ( CurStep - PrevStep < IntStep ) return
   364  !!$    PrevStep = CurStep
   365  
   366      ! FilterParameter の有効性のチェック
   367      ! Check validity of "FilterParameter"
   368      !
   369      if ( FilterParameter == 0.0_DP ) return
   370  
   371      ! タイムフィルターを適用
   372      ! Apply time filter
   373      !
   374      xy_SurfMajCompIceN = xy_SurfMajCompIceN                         &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t120 = 1, jmax*imax                                            
     .           xy_surfmajcompicen(t120-1,1) = xy_surfmajcompicen(t120-1,1) +  
     .       1      filterparameter*(xy_surfmajcompiceb(t120-1,1)-              
     .       2      2.00000000000000e+000*xy_surfmajcompicen(t120-1,1)+         
     .       3      xy_surfmajcompicea(t120-1,1))                               
     .           xy_soilmoistn(t120-1,1) = xy_soilmoistn(t120-1,1) +            
     .       1      filterparameter*(xy_soilmoistb(t120-1,1)-                   
     .       2      2.00000000000000e+000*xy_soilmoistn(t120-1,1)+xy_soilmoista(
     .       3      t120-1,1))                                                  
     .           xy_surfsnown(t120-1,1) = xy_surfsnown(t120-1,1) +              
     .       1      filterparameter*(xy_surfsnowb(t120-1,1)-                    
     .       2      2.00000000000000e+000*xy_surfsnown(t120-1,1)+xy_surfsnowa(  
     .       3      t120-1,1))                                                  
     .        enddo                                                             
   375        & + FilterParameter                                           &
   376        & * ( xy_SurfMajCompIceB - 2.0_DP * xy_SurfMajCompIceN + xy_SurfMajCompIceA )
   377  
   378      xy_SoilMoistN = xy_SoilMoistN                                   &
   379        & + FilterParameter                                           &
   380        & * ( xy_SoilMoistB - 2.0_DP * xy_SoilMoistN + xy_SoilMoistA )
   381  
   382      xy_SurfSnowN  = xy_SurfSnowN                                    &
   383        & + FilterParameter                                           &
   384        & * ( xy_SurfSnowB  - 2.0_DP * xy_SurfSnowN  + xy_SurfSnowA  )
   385  
   386      ! 計算時間計測一時停止
   387      ! Pause measurement of computation time
   388      !
   389      call TimesetClockStop( module_name )
   390  
   391    end subroutine TimeFilterSurfVars
   392  
   393    !--------------------------------------------------------------------------------------
   394  
   395    subroutine TimeFiltInit
   396      !
   397      ! timefilter_asselin1972 モジュールの初期化を行います.
   398      ! NAMELIST#timefilter_asselin1972_nml の読み込みはこの手続きで行われます.
   399      !
   400      ! "timefilter_asselin1972" module is initialized.
   401      ! "NAMELIST#timefilter_asselin1972_nml" is loaded in this procedure.
   402      !
   403  
   404      ! モジュール引用 ; USE statements
   405      !
   406  
   407      ! NAMELIST ファイル入力に関するユーティリティ
   408      ! Utilities for NAMELIST file input
   409      !
   410      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   411  
   412      ! ファイル入出力補助
   413      ! File I/O support
   414      !
   415      use dc_iounit, only: FileOpen
   416  
   417      ! 種別型パラメタ
   418      ! Kind type parameter
   419      !
   420      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   421  
   422      ! 宣言文 ; Declaration statements
   423      !
   424      implicit none
   425  
   426      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   427                                ! Unit number for NAMELIST file open
   428      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   429                                ! IOSTAT of NAMELIST read
   430  
   431      ! NAMELIST 変数群
   432      ! NAMELIST group name
   433      !
   434      namelist /timefilter_asselin1972_nml/ &
   435        & FilterParameter   !, IntStep
   436            !
   437            ! デフォルト値については初期化手続 "timefilter_asselin1972#Hs94Init"
   438            ! のソースコードを参照のこと.
   439            !
   440            ! Refer to source codes in the initialization procedure
   441            ! "timefilter_asselin1972#Hs94Init" for the default values.
   442            !
   443  
   444      ! 実行文 ; Executable statement
   445      !
   446  
   447      if ( timefilter_asselin1972_inited ) return
   448  
   449  
   450      ! デフォルト値の設定
   451      ! Default values settings
   452      !
   453      FilterParameter = 0.05_DP
   454  !!$    IntStep         = 1
   455  !!$    CurStep         = 0
   456  
   457      ! NAMELIST の読み込み
   458      ! NAMELIST is input
   459      !
   460      if ( trim(namelist_filename) /= '' ) then
   461        call FileOpen( unit_nml, &          ! (out)
   462          & namelist_filename, mode = 'r' ) ! (in)
   463  
   464        rewind( unit_nml )
   465        read( unit_nml, &                ! (in)
   466          & nml = timefilter_asselin1972_nml, &  ! (out)
   467          & iostat = iostat_nml )        ! (out)
   468        close( unit_nml )
   469  
   470        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   471        if ( iostat_nml == 0 ) write( STDOUT, nml = timefilter_asselin1972_nml )
   472      end if
   473  
   474  !!$    ! IntStep のチェック
   475  !!$    ! Check "IntStep"
   476  !!$    !
   477  !!$    if ( IntStep < 1 ) then
   478  !!$      call MessageNotify( 'E', module_name, &
   479  !!$        & 'IntStep=<%d> must be greater than 0', &
   480  !!$        & i = (/ IntStep /) )
   481  !!$    end if
   482  !!$
   483  !!$    ! PrevStep の設定
   484  !!$    ! Configure "PrevStep"
   485  !!$    !
   486  !!$    PrevStep = - IntStep
   487  
   488      ! 印字 ; Print
   489      !
   490      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   491      call MessageNotify( 'M', module_name, '  FilterParameter = %f', d = (/ FilterParameter /) )
   492  !!$    call MessageNotify( 'M', module_name, '  IntStep         = %d', i = (/ IntStep /) )
   493      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   494  
   495      timefilter_asselin1972_inited = .true.
   496  
   497    end subroutine TimeFiltInit
   498  
   499    !--------------------------------------------------------------------------------------
   500  
   501  end module timefilter_asselin1972
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: timefilter_asselin1972.f90
PROGRAM NAME: timefilter_asselin1972
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != タイムフィルター (Asselin, 1972)
     2:             !
     3:             != Time filter (Asselin, 1972)
     4:             !
     5:             ! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: timefilter_asselin1972.f90,v 1.13 2014/05/07 09:39:24 murashin Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module timefilter_asselin1972
    13:               !
    14:               != タイムフィルター (Asselin, 1972)
    15:               !
    16:               != Time filter (Asselin, 1972)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 計算モードを抑えるためのタイムフィルター (Asselin, 1972)
    21:               ! を適用するためのモジュールです.
    22:               !
    23:               ! すなわち
    24:               ! \[
    25:               !   \bar{A}^{t}
    26:               !   = {A}^{t}
    27:               !     + \epsilon_f
    28:               !        \left( 
    29:               !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
    30:               !        \right) \] \[
    31:               !   \qquad
    32:               !   = ( 1-2 \epsilon_f ) {A}^{t}
    33:               !     + \epsilon_f 
    34:               !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    35:               ! \]
    36:               ! として $ \bar{A}^{t} $ を求めます. 添え字
    37:               ! $ t-\Delta t, t, t+\Delta t $ はそれぞれ時間ステップを表し,
    38:               ! タイムフィルターが適用された項には上線 ( $ \bar{\quad} $ ) 
    39:               ! が付いています.
    40:               !
    41:               ! タイムフィルターの係数 $\epsilon_f$ は Create の際に設定します.
    42:               !
    43:               !--
    44:               ! \[
    45:               !   \bar{\mathscr A}^{t}
    46:               !     = ( 1-2 \epsilon_f ) {\mathscr A}^{t}
    47:               !     +  \epsilon_f 
    48:               !         \left( \bar{\mathscr A}^{t-\Delta t} + {\mathscr A}^{t+\Delta t} \right)
    49:               ! \]
    50:               ! として$\bar{\mathscr A}^{t}$を求めます. 添え字
    51:               !++
    52:               !
    53:               ! Time filter (Asselin, 1972) for suppression of computational mode 
    54:               ! is applied.
    55:               !
    56:               ! Concretely, $ \bar{A}^{t} $ is derived as follows.
    57:               ! \[
    58:               !   \bar{A}^{t}
    59:               !   = {A}^{t}
    60:               !     + \epsilon_f
    61:               !        \left( 
    62:               !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
    63:               !        \right) \] \[
    64:               !   \qquad
    65:               !   = ( 1-2 \epsilon_f ) {A}^{t}
    66:               !     + \epsilon_f 
    67:               !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right),
    68:               ! \]
    69:               ! where suffices $ t-\Delta t, t, t+\Delta t $ represent time step, 
    70:               ! and over-bar $ \bar{\quad} $ represents the terms applied 
    71:               ! time filter.
    72:               !
    73:               ! Time filter coefficient $ \epsilon_f $ is specified by "Create".
    74:               !
    75:               !== Procedures List
    76:               ! 
    77:               ! TimeFilter    :: タイムフィルターの適用
    78:               ! ------------  :: ------------
    79:               ! TimeFilter    :: Apply time filter
    80:               !
    81:               !== NAMELIST
    82:               !
    83:               ! NAMELIST#timefilter_asselin1972_nml
    84:               !
    85:               !== References
    86:               !
    87:               ! * Asselin, R. A., 1972: 
    88:               !   Frequency filter for time integrations.
    89:               !   <i>Mon. Wea. Rev.</i>, <b>100</b>, 487--490.
    90:               !
    91:             
    92:               ! モジュール引用 ; USE statements
    93:               !
    94:             
    95:               ! 格子点設定
    96:               ! Grid points settings
    97:               !
    98:               use gridset, only: imax, & ! 経度格子点数. 
    99:                                          ! Number of grid points in longitude
   100:                 &                jmax, & ! 緯度格子点数. 
   101:                                          ! Number of grid points in latitude
   102:                 &                kmax    ! 鉛直層数. 
   103:                                          ! Number of vertical level
   104:             
   105:               use composition, only: ncmax  ! 微量成分の数
   106:                                             ! Number of composition
   107:             
   108:               ! 種別型パラメタ
   109:               ! Kind type parameter
   110:               !
   111:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
   112:                 &                 STRING     ! 文字列.       Strings. 
   113:             
   114:             
   115:               ! メッセージ出力
   116:               ! Message output
   117:               !
   118:               use dc_message, only: MessageNotify
   119:             
   120:               ! 宣言文 ; Declaration statements
   121:               !
   122:               implicit none
   123:               private
   124:             
   125:               ! 公開手続き
   126:               ! Public procedure
   127:               !
   128:               public :: TimeFilter
   129:               public :: TimeFilterSurfVars
   130:               public :: TimeFiltInit
   131:             
   132:               ! 公開変数
   133:               ! Public variables
   134:               !
   135:             
   136:               ! 非公開変数
   137:               ! Private variables
   138:               !
   139:               logical, save :: timefilter_asselin1972_inited = .false.
   140:                                           ! 初期設定フラグ. 
   141:                                           ! Initialization flag
   142:             
   143:               real(DP), save:: FilterParameter
   144:                                           ! タイムフィルターの係数. 
   145:                                           ! Time filter coefficient
   146:             !!$  integer, save:: IntStep     ! タイムフィルターを適用するステップ間隔. 
   147:             !!$                              ! Step interval of time filter application
   148:             !!$  integer, save:: CurStep     ! TimeFilter が呼ばれた回数. 
   149:             !!$                              ! Number of times that "TimeFilter" is called
   150:             !!$  integer, save:: PrevStep    ! 前回タイムフィルターを適用したステップ数. 
   151:             !!$                              ! Step number that is filtered previously
   152:             
   153:               character(*), parameter:: module_name = 'timefilter_asselin1972'
   154:                                           ! モジュールの名称. 
   155:                                           ! Module name
   156:               character(*), parameter:: version = &
   157:                 & '$Name:  $' // &
   158:                 & '$Id: timefilter_asselin1972.f90,v 1.13 2014/05/07 09:39:24 murashin Exp $'
   159:                                           ! モジュールのバージョン
   160:                                           ! Module version
   161:             
   162:             contains
   163:             
   164:               !--------------------------------------------------------------------------------------
   165:             
   166:               subroutine TimeFilter( &
   167:                 & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
   168:                 & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, &   ! (inout)
   169:                 & xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA, xy_PsA  &   ! (in)
   170:                 & )
   171:                 !
   172:                 ! 予報変数にタイムフィルターを適用します. 
   173:                 !
   174:                 ! Time filter is applied to predictional variables.
   175:                 !
   176:             
   177:                 ! モジュール引用 ; USE statements
   178:                 !
   179:             
   180:                 ! 時刻管理
   181:                 ! Time control
   182:                 !
   183:                 use timeset, only: &
   184:                   & TimesetClockStart, TimesetClockStop
   185:             
   186:                 ! 宣言文 ; Declaration statements
   187:                 !
   188:                 implicit none
   189:             
   190:                 real(DP), intent(in):: xyz_UB (0:imax-1, 1:jmax, 1:kmax)
   191:                                           ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
   192:                 real(DP), intent(in):: xyz_VB (0:imax-1, 1:jmax, 1:kmax)
   193:                                           ! $ v (t-\Delta t) $ .   南北風速. Northward wind
   194:                 real(DP), intent(in):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   195:                                           ! $ T (t-\Delta t) $ .   温度. Temperature
   196:                 real(DP), intent(in):: xyzf_QMixB (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   197:                                           ! $ q (t-\Delta t) $ .   混合比. Mass mixing ratio of constituents
   198:                 real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
   199:                                           ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   200:                 real(DP), intent(inout):: xyz_UN (0:imax-1, 1:jmax, 1:kmax)
   201:                                           ! $ u (t) $ .     東西風速. Eastward wind
   202:                 real(DP), intent(inout):: xyz_VN (0:imax-1, 1:jmax, 1:kmax)
   203:                                           ! $ v (t) $ .     南北風速. Northward wind
   204:                 real(DP), intent(inout):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
   205:                                           ! $ T (t) $ .     温度. Temperature
   206:                 real(DP), intent(inout):: xyzf_QMixN (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   207:                                           ! $ q (t) $ .     混合比. Mass mixing ratio of constituents
   208:                 real(DP), intent(inout):: xy_PsN (0:imax-1, 1:jmax)
   209:                                           ! $ p_s (t) $ .   地表面気圧. Surface pressure
   210:                 real(DP), intent(in):: xyz_UA (0:imax-1, 1:jmax, 1:kmax)
   211:                                           ! $ u (t+\Delta t) $ .   東西風速. Eastward wind
   212:                 real(DP), intent(in):: xyz_VA (0:imax-1, 1:jmax, 1:kmax)
   213:                                           ! $ v (t+\Delta t) $ .   南北風速. Northward wind
   214:                 real(DP), intent(in):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
   215:                                           ! $ T (t+\Delta t) $ .   温度. Temperature
   216:                 real(DP), intent(in):: xyzf_QMixA (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   217:                                           ! $ q (t+\Delta t) $ .   混合比. Mass mixing ratio of constituents
   218:                 real(DP), intent(in):: xy_PsA (0:imax-1, 1:jmax)
   219:                                           ! $ p_s (t+\Delta t) $ . 地表面気圧. Surface pressure
   220:             
   221:                 ! 作業変数
   222:                 ! Work variables
   223:                 !
   224:             
   225:                 ! 実行文 ; Executable statement
   226:                 !
   227:             
   228:                 ! 初期化確認
   229:                 ! Initialization check
   230:                 !
   231:                 if ( .not. timefilter_asselin1972_inited ) then
   232:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   233:                 end if
   234:             
   235:                 ! 計算時間計測開始
   236:                 ! Start measurement of computation time
   237:                 !
   238:                 call TimesetClockStart( module_name )
   239:             
   240:             
   241:             !!$    ! ステップのチェック
   242:             !!$    ! Check Step
   243:             !!$    !
   244:             !!$    CurStep = CurStep + 1
   245:             !!$    if ( CurStep - PrevStep < IntStep ) return
   246:             !!$    PrevStep = CurStep
   247:             
   248:                 ! FilterParameter の有効性のチェック
   249:                 ! Check validity of "FilterParameter"
   250:                 !
   251:                 if ( FilterParameter == 0.0_DP ) return
   252:             
   253:                 ! タイムフィルターを適用
   254:                 ! Apply time filter
   255:                 !
   256: **W---->A       xyz_UN     =  xyz_UN    &
   257: |||               & + FilterParameter * ( xyz_UB     - 2.0d0 * xyz_UN     + xyz_UA     )
   258: |||         
   259: |||     A       xyz_VN     =  xyz_VN    &
   260: |||               & + FilterParameter * ( xyz_VB     - 2.0d0 * xyz_VN     + xyz_VA     )
   261: |||         
   262: **W---- A       xyz_TempN  =  xyz_TempN &
   263:                   & + FilterParameter * ( xyz_TempB  - 2.0d0 * xyz_TempN  + xyz_TempA  )
   264:             
   265: W*===== A       xy_PsN     =  xy_PsN    &
   266:                   & + FilterParameter * ( xy_PsB     - 2.0d0 * xy_PsN     + xy_PsA     )
   267:             
   268: W***=== A       xyzf_QMixN = xyzf_QMixN &
   269:                   & + FilterParameter * ( xyzf_QMixB - 2.0d0 * xyzf_QMixN + xyzf_QMixA )
   270:             
   271:             
   272:                 ! 計算時間計測一時停止
   273:                 ! Pause measurement of computation time
   274:                 !
   275:                 call TimesetClockStop( module_name )
   276:             
   277:               end subroutine TimeFilter
   278:             
   279:               !--------------------------------------------------------------------------------------
   280:             
   281:               subroutine TimeFilterSurfVars(                       &
   282:                 & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, &   ! (in)
   283:                 & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN, &   ! (inout)
   284:                 & xy_SurfMajCompIceA, xy_SoilMoistA, xy_SurfSnowA  &   ! (in)
   285:                 & )
   286:                 !
   287:                 ! 予報変数にタイムフィルターを適用します. 
   288:                 !
   289:                 ! Time filter is applied to predictional variables.
   290:                 !
   291:             
   292:                 ! モジュール引用 ; USE statements
   293:                 !
   294:             
   295:                 ! 時刻管理
   296:                 ! Time control
   297:                 !
   298:                 use timeset, only: &
   299:                   & TimesetClockStart, TimesetClockStop
   300:             
   301:                 ! 宣言文 ; Declaration statements
   302:                 !
   303:                 implicit none
   304:             
   305:                 real(DP), intent(in   ):: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   306:                                           ! $ M_mcs (t-\Delta t) $ . 
   307:                                           ! Surface major component ice amount
   308:                 real(DP), intent(in   ):: xy_SoilMoistB (0:imax-1, 1:jmax)
   309:                                           ! $ M_ws (t-\Delta t) $ . 地表水質量. 
   310:                                           ! Soil moisture
   311:                 real(DP), intent(in   ):: xy_SurfSnowB  (0:imax-1, 1:jmax)
   312:                                           ! $ M_ss (t-\Delta t) $ . 積雪量.
   313:                                           ! Surface snow amount
   314:                 real(DP), intent(inout):: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
   315:                                           ! $ M_mcs (t) $ . 
   316:                                           ! Surface major component ice amount
   317:                 real(DP), intent(inout):: xy_SoilMoistN (0:imax-1, 1:jmax)
   318:                                           ! $ M_ws (t-\Delta t) $ . 地表水質量. 
   319:                                           ! Soil moisture
   320:                 real(DP), intent(inout):: xy_SurfSnowN  (0:imax-1, 1:jmax)
   321:                                           ! $ M_ss (t) $ . 積雪量.
   322:                                           ! Surface snow amount
   323:                 real(DP), intent(in   ):: xy_SurfMajCompIceA(0:imax-1, 1:jmax)
   324:                                           ! $ M_mcs (t+\Delta t) $ . 
   325:                                           ! Surface major component ice amount
   326:                 real(DP), intent(in   ):: xy_SoilMoistA (0:imax-1, 1:jmax)
   327:                                           ! $ M_ws (t-\Delta t) $ . 地表水質量. 
   328:                                           ! Soil moisture
   329:                 real(DP), intent(in   ):: xy_SurfSnowA  (0:imax-1, 1:jmax)
   330:                                           ! $ M_ss (t+\Delta t) $ . 積雪量.
   331:                                           ! Surface snow amount
   332:             
   333:                 ! 作業変数
   334:                 ! Work variables
   335:                 !
   336:             !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
   337:             !!$                              ! Work variables for DO loop in longitude
   338:             !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
   339:             !!$                              ! Work variables for DO loop in latitude
   340:             
   341:             
   342:                 ! 実行文 ; Executable statement
   343:                 !
   344:             
   345:                 ! 初期化確認
   346:                 ! Initialization check
   347:                 !
   348:                 if ( .not. timefilter_asselin1972_inited ) then
   349:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   350:                 end if
   351:             
   352:             
   353:                 ! 計算時間計測開始
   354:                 ! Start measurement of computation time
   355:                 !
   356:                 call TimesetClockStart( module_name )
   357:             
   358:             
   359:             !!$    ! ステップのチェック
   360:             !!$    ! Check Step
   361:             !!$    !
   362:             !!$    CurStep = CurStep + 1
   363:             !!$    if ( CurStep - PrevStep < IntStep ) return
   364:             !!$    PrevStep = CurStep
   365:             
   366:                 ! FilterParameter の有効性のチェック
   367:                 ! Check validity of "FilterParameter"
   368:                 !
   369:                 if ( FilterParameter == 0.0_DP ) return
   370:             
   371:                 ! タイムフィルターを適用
   372:                 ! Apply time filter
   373:                 !
   374: *W----->A       xy_SurfMajCompIceN = xy_SurfMajCompIceN                         &
   375: ||                & + FilterParameter                                           &
   376: ||                & * ( xy_SurfMajCompIceB - 2.0_DP * xy_SurfMajCompIceN + xy_SurfMajCompIceA )
   377: ||          
   378: ||      A       xy_SoilMoistN = xy_SoilMoistN                                   &
   379: ||                & + FilterParameter                                           &
   380: ||                & * ( xy_SoilMoistB - 2.0_DP * xy_SoilMoistN + xy_SoilMoistA )
   381: ||          
   382: *W----- A       xy_SurfSnowN  = xy_SurfSnowN                                    &
   383:                   & + FilterParameter                                           &
   384:                   & * ( xy_SurfSnowB  - 2.0_DP * xy_SurfSnowN  + xy_SurfSnowA  )
   385:             
   386:                 ! 計算時間計測一時停止
   387:                 ! Pause measurement of computation time
   388:                 !
   389:                 call TimesetClockStop( module_name )
   390:             
   391:               end subroutine TimeFilterSurfVars
   392:             
   393:               !--------------------------------------------------------------------------------------
   394:             
   395:               subroutine TimeFiltInit
   396:                 !
   397:                 ! timefilter_asselin1972 モジュールの初期化を行います. 
   398:                 ! NAMELIST#timefilter_asselin1972_nml の読み込みはこの手続きで行われます. 
   399:                 !
   400:                 ! "timefilter_asselin1972" module is initialized. 
   401:                 ! "NAMELIST#timefilter_asselin1972_nml" is loaded in this procedure. 
   402:                 !
   403:             
   404:                 ! モジュール引用 ; USE statements
   405:                 !
   406:             
   407:                 ! NAMELIST ファイル入力に関するユーティリティ
   408:                 ! Utilities for NAMELIST file input
   409:                 !
   410:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   411:             
   412:                 ! ファイル入出力補助
   413:                 ! File I/O support
   414:                 !
   415:                 use dc_iounit, only: FileOpen
   416:             
   417:                 ! 種別型パラメタ
   418:                 ! Kind type parameter
   419:                 !
   420:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   421:             
   422:                 ! 宣言文 ; Declaration statements
   423:                 !
   424:                 implicit none
   425:             
   426:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   427:                                           ! Unit number for NAMELIST file open
   428:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   429:                                           ! IOSTAT of NAMELIST read
   430:             
   431:                 ! NAMELIST 変数群
   432:                 ! NAMELIST group name
   433:                 !
   434:                 namelist /timefilter_asselin1972_nml/ &
   435:                   & FilterParameter   !, IntStep
   436:                       !
   437:                       ! デフォルト値については初期化手続 "timefilter_asselin1972#Hs94Init" 
   438:                       ! のソースコードを参照のこと. 
   439:                       !
   440:                       ! Refer to source codes in the initialization procedure
   441:                       ! "timefilter_asselin1972#Hs94Init" for the default values. 
   442:                       !
   443:             
   444:                 ! 実行文 ; Executable statement
   445:                 !
   446:             
   447:                 if ( timefilter_asselin1972_inited ) return
   448:             
   449:             
   450:                 ! デフォルト値の設定
   451:                 ! Default values settings
   452:                 !
   453:                 FilterParameter = 0.05_DP
   454:             !!$    IntStep         = 1
   455:             !!$    CurStep         = 0
   456:             
   457:                 ! NAMELIST の読み込み
   458:                 ! NAMELIST is input
   459:                 !
   460:                 if ( trim(namelist_filename) /= '' ) then
   461:                   call FileOpen( unit_nml, &          ! (out)
   462:                     & namelist_filename, mode = 'r' ) ! (in)
   463:             
   464:                   rewind( unit_nml )
   465:                   read( unit_nml, &                ! (in)
   466:                     & nml = timefilter_asselin1972_nml, &  ! (out)
   467:                     & iostat = iostat_nml )        ! (out)
   468:                   close( unit_nml )
   469:             
   470:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   471:                   if ( iostat_nml == 0 ) write( STDOUT, nml = timefilter_asselin1972_nml )
   472:                 end if
   473:             
   474:             !!$    ! IntStep のチェック
   475:             !!$    ! Check "IntStep"
   476:             !!$    !
   477:             !!$    if ( IntStep < 1 ) then
   478:             !!$      call MessageNotify( 'E', module_name, &
   479:             !!$        & 'IntStep=<%d> must be greater than 0', &
   480:             !!$        & i = (/ IntStep /) )
   481:             !!$    end if
   482:             !!$
   483:             !!$    ! PrevStep の設定
   484:             !!$    ! Configure "PrevStep"
   485:             !!$    !
   486:             !!$    PrevStep = - IntStep
   487:             
   488:                 ! 印字 ; Print
   489:                 !
   490:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   491:                 call MessageNotify( 'M', module_name, '  FilterParameter = %f', d = (/ FilterParameter /) )
   492:             !!$    call MessageNotify( 'M', module_name, '  IntStep         = %d', i = (/ IntStep /) )
   493:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   494:             
   495:                 timefilter_asselin1972_inited = .true.
   496:             
   497:               end subroutine TimeFiltInit
   498:             
   499:               !--------------------------------------------------------------------------------------
   500:             
   501:             end module timefilter_asselin1972
