Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: timefilter_williams2009.f90
PROGRAM NAME: timefilter_williams2009
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   283  opt  (  11): Fused array assignments. :line 283 - 284
   283  opt  (1593): Loop nest collapsed into one loop.
   283  vec  (   4): Vectorized array expression.
   283  vec  (  29): ADB is used for array.: xy_psasave
   283  vec  (  29): ADB is used for array.: xy_psa
   283  vec  (  29): ADB is used for array.: xy_psnsave
   283  vec  (  29): ADB is used for array.: xy_psn
   285  opt  (  11): Fused array assignments. :line 285 - 286
   285  opt  (1593): Loop nest collapsed into one loop.
   285  vec  (   4): Vectorized array expression.
   285  vec  (  29): ADB is used for array.: xyzf_qmixasave
   285  vec  (  29): ADB is used for array.: xyzf_qmixa
   285  vec  (  29): ADB is used for array.: xyzf_qmixnsave
   285  vec  (  29): ADB is used for array.: xyzf_qmixn
   292  opt  (  11): Fused array assignments. :line 292 - 316
   292  opt  (1593): Loop nest collapsed into one loop.
   292  vec  (   4): Vectorized array expression.
   292  vec  (  29): ADB is used for array.: xyz_tempa
   292  vec  (  29): ADB is used for array.: xyz_tempn
   292  vec  (  29): ADB is used for array.: xyz_tempb
   292  vec  (  29): ADB is used for array.: xyz_va
   292  vec  (  29): ADB is used for array.: xyz_vn
   292  vec  (  29): ADB is used for array.: xyz_vb
   292  vec  (  29): ADB is used for array.: xyz_ua
   292  vec  (  29): ADB is used for array.: xyz_un
   292  vec  (  29): ADB is used for array.: xyz_ub
   319  opt  (  11): Fused array assignments. :line 319 - 325
   319  opt  (1593): Loop nest collapsed into one loop.
   319  vec  (   4): Vectorized array expression.
   319  vec  (  29): ADB is used for array.: xy_psa
   319  vec  (  29): ADB is used for array.: xy_psn
   319  vec  (  29): ADB is used for array.: xy_psb
   328  opt  (  11): Fused array assignments. :line 328 - 335
   328  opt  (1593): Loop nest collapsed into one loop.
   328  vec  (   4): Vectorized array expression.
   328  vec  (  29): ADB is used for array.: xyzf_qmixa
   328  vec  (  29): ADB is used for array.: xyzf_qmixn
   328  vec  (  29): ADB is used for array.: xyzf_qmixb
   491  opt  (  11): Fused array assignments. :line 491 - 498
   491  opt  (1593): Loop nest collapsed into one loop.
   491  vec  (   4): Vectorized array expression.
   491  vec  (  29): ADB is used for array.: xy_surfmajcompicea
   491  vec  (  29): ADB is used for array.: xy_surfmajcompicen
   491  vec  (  29): ADB is used for array.: xy_surfmajcompiceb
   507  opt  (1593): Loop nest collapsed into one loop.
   507  vec  (   1): Vectorized loop.
   507  vec  (  29): ADB is used for array.: xy_surfmajcompicea
   507  vec  (  29): ADB is used for array.: xy_psa
   517  opt  (  11): Fused array assignments. :line 517 - 533
   517  opt  (1593): Loop nest collapsed into one loop.
   517  vec  (   4): Vectorized array expression.
   517  vec  (  29): ADB is used for array.: xy_surfsnown
   517  vec  (  29): ADB is used for array.: xy_surfsnowa
   517  vec  (  29): ADB is used for array.: xy_surfsnowb
   517  vec  (  29): ADB is used for array.: xy_soilmoistn
   517  vec  (  29): ADB is used for array.: xy_soilmoista
   517  vec  (  29): ADB is used for array.: xy_soilmoistb
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: timefilter_williams2009.f90
PROGRAM NAME: timefilter_williams2009
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 時間フィルター (Williams, 2009)
     2  !
     3  != Time filter (Williams, 2009)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: timefilter_williams2009.f90,v 1.4 2015/01/29 12:09:04 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module timefilter_williams2009
    13    !
    14    != 時間フィルター (Williams, 2009)
    15    !
    16    != Time filter (Williams, 2009)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 計算モードを抑えるための時間フィルター (Williams, 2009)
    21    ! を適用するためのモジュールです.
    22    ! Time filter by Williams (2009) is the modified version of that
    23    ! by Asselin (1972).
    24    !
    25  !!$  ! すなわち
    26  !!$  ! \[
    27  !!$  !   \bar{A}^{t}
    28  !!$  !   = {A}^{t}
    29  !!$  !     + \epsilon_f
    30  !!$  !        \left(
    31  !!$  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
    32  !!$  !        \right) \] \[
    33  !!$  !   \qquad
    34  !!$  !   = ( 1-2 \epsilon_f ) {A}^{t}
    35  !!$  !     + \epsilon_f
    36  !!$  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    37  !!$  ! \]
    38  !!$  ! として $ \bar{A}^{t} $ を求めます. 添え字
    39  !!$  ! $ t-\Delta t, t, t+\Delta t $ はそれぞれ時間ステップを表し,
    40  !!$  ! タイムフィルターが適用された項には上線 ( $ \bar{\quad} $ )
    41  !!$  ! が付いています.
    42  !!$  !
    43  !!$  ! タイムフィルターの係数 $\epsilon_f$ は Create の際に設定します.
    44  !!$  !
    45  !!$  !--
    46  !!$  ! \[
    47  !!$  !   \bar{\mathscr A}^{t}
    48  !!$  !     = ( 1-2 \epsilon_f ) {\mathscr A}^{t}
    49  !!$  !     +  \epsilon_f
    50  !!$  !         \left( \bar{\mathscr A}^{t-\Delta t} + {\mathscr A}^{t+\Delta t} \right)
    51  !!$  ! \]
    52  !!$  ! として$\bar{\mathscr A}^{t}$を求めます. 添え字
    53  !!$  !++
    54  !!$  !
    55  !!$  ! Time filter (Asselin, 1972) for suppression of computational mode
    56  !!$  ! is applied.
    57  !!$  !
    58  !!$  ! Concretely, $ \bar{A}^{t} $ is derived as follows.
    59  !!$  ! \[
    60  !!$  !   \bar{A}^{t}
    61  !!$  !   = {A}^{t}
    62  !!$  !     + \epsilon_f
    63  !!$  !        \left(
    64  !!$  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
    65  !!$  !        \right) \] \[
    66  !!$  !   \qquad
    67  !!$  !   = ( 1-2 \epsilon_f ) {A}^{t}
    68  !!$  !     + \epsilon_f
    69  !!$  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right),
    70  !!$  ! \]
    71  !!$  ! where suffices $ t-\Delta t, t, t+\Delta t $ represent time step,
    72  !!$  ! and over-bar $ \bar{\quad} $ represents the terms applied
    73  !!$  ! time filter.
    74  !!$  !
    75  !!$  ! Time filter coefficient $ \epsilon_f $ is specified by "Create".
    76    !
    77    !== Procedures List
    78    !
    79    ! TimeFilterWilliams2009    :: 時間フィルターの適用
    80    ! ------------------------  :: ------------
    81    ! TimeFilterWilliams2009    :: Apply time filter
    82    !
    83    !== NAMELIST
    84    !
    85    ! NAMELIST#timefilter_williams2009_nml
    86    !
    87    !== References
    88    !
    89    ! * Williams, P. D., 2009:
    90    !   A proposed modification to the Robert-Asselin time filter,
    91    !   <i>Mon. Wea. Rev.</i>, <b>137</b>, 2538--2546.
    92    !
    93    ! * Asselin, R. A., 1972:
    94    !   Frequency filter for time integrations.
    95    !   <i>Mon. Wea. Rev.</i>, <b>100</b>, 487--490.
    96    !
    97  
    98    ! モジュール引用 ; USE statements
    99    !
   100  
   101    ! 格子点設定
   102    ! Grid points settings
   103    !
   104    use gridset, only: imax, & ! 経度格子点数.
   105                               ! Number of grid points in longitude
   106      &                jmax, & ! 緯度格子点数.
   107                               ! Number of grid points in latitude
   108      &                kmax    ! 鉛直層数.
   109                               ! Number of vertical level
   110  
   111    use composition, only: ncmax  ! 微量成分の数
   112                                  ! Number of composition
   113  
   114    ! 種別型パラメタ
   115    ! Kind type parameter
   116    !
   117    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   118      &                 STRING     ! 文字列.       Strings.
   119  
   120  
   121    ! メッセージ出力
   122    ! Message output
   123    !
   124    use dc_message, only: MessageNotify
   125  
   126    ! 宣言文 ; Declaration statements
   127    !
   128    implicit none
   129    private
   130  
   131    ! 公開手続き
   132    ! Public procedure
   133    !
   134    public :: TimeFilterWilliams2009
   135    public :: TimeFilterWilliams2009SurfVars
   136    public :: TimeFilterWilliams2009Init
   137  
   138    ! 公開変数
   139    ! Public variables
   140    !
   141  
   142    ! 非公開変数
   143    ! Private variables
   144    !
   145    logical, save :: timefilter_williams2009_inited = .false.
   146                                ! 初期設定フラグ.
   147                                ! Initialization flag
   148  
   149    real(DP), save :: FilterParameterRA
   150                                ! Robert-Asselin 時間フィルターの係数.
   151                                ! Time filter coefficient for Robert-Asselin filter
   152                                ! This is equal to nu/2 in Williams (2009).
   153    real(DP), save :: FilterParameterW
   154                                ! Williams 時間フィルターの係数.
   155                                ! Time filter coefficient for Williams filter
   156                                ! This is equal to alpha in Williams (2009).
   157  
   158    character(*), parameter:: module_name = 'timefilter_williams2009'
   159                                ! モジュールの名称.
   160                                ! Module name
   161    character(*), parameter:: version = &
   162      & '$Name:  $' // &
   163      & '$Id: timefilter_williams2009.f90,v 1.4 2015/01/29 12:09:04 yot Exp $'
   164                                ! モジュールのバージョン
   165                                ! Module version
   166  
   167  contains
   168  
   169    !--------------------------------------------------------------------------------------
   170  
   171    subroutine TimeFilterWilliams2009(                 &
   172      & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
   173      & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, &   ! (inout)
   174      & xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA, xy_PsA  &   ! (inout)
   175      & )
   176      !
   177      ! 予報変数にタイムフィルターを適用します.
   178      !
   179      ! Time filter is applied to predictional variables.
   180      !
   181  
   182      ! モジュール引用 ; USE statements
   183      !
   184  
   185      ! 時刻管理
   186      ! Time control
   187      !
   188      use timeset, only: &
   189        & TimesetClockStart, TimesetClockStop
   190  
   191      ! 組成に関わる配列の設定
   192      ! Settings of array for atmospheric composition
   193      !
   194      use composition, only: &
   195      &                    IndexH2OVap
   196  
   197      ! 質量の補正
   198      ! Mass fixer
   199      !
   200      use mass_fixer, only: MassFixer
   201  
   202      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   203      ! Interpolate temperature on half sigma level,
   204      ! and calculate pressure and height
   205      !
   206      use auxiliary, only: AuxVars
   207  
   208      ! 宣言文 ; Declaration statements
   209      !
   210      implicit none
   211  
   212      real(DP), intent(in):: xyz_UB (0:imax-1, 1:jmax, 1:kmax)
   213                                ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
   214      real(DP), intent(in):: xyz_VB (0:imax-1, 1:jmax, 1:kmax)
   215                                ! $ v (t-\Delta t) $ .   南北風速. Northward wind
   216      real(DP), intent(in):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   217                                ! $ T (t-\Delta t) $ .   温度. Temperature
   218      real(DP), intent(in):: xyzf_QMixB (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   219                                ! $ q (t-\Delta t) $ .   混合比. Mass mixing ratio of constituents
   220      real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
   221                                ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   222      real(DP), intent(inout):: xyz_UN (0:imax-1, 1:jmax, 1:kmax)
   223                                ! $ u (t) $ .     東西風速. Eastward wind
   224      real(DP), intent(inout):: xyz_VN (0:imax-1, 1:jmax, 1:kmax)
   225                                ! $ v (t) $ .     南北風速. Northward wind
   226      real(DP), intent(inout):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
   227                                ! $ T (t) $ .     温度. Temperature
   228      real(DP), intent(inout):: xyzf_QMixN (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   229                                ! $ q (t) $ .     混合比. Mass mixing ratio of constituents
   230      real(DP), intent(inout):: xy_PsN (0:imax-1, 1:jmax)
   231                                ! $ p_s (t) $ .   地表面気圧. Surface pressure
   232      real(DP), intent(inout):: xyz_UA (0:imax-1, 1:jmax, 1:kmax)
   233                                ! $ u (t+\Delta t) $ .   東西風速. Eastward wind
   234      real(DP), intent(inout):: xyz_VA (0:imax-1, 1:jmax, 1:kmax)
   235                                ! $ v (t+\Delta t) $ .   南北風速. Northward wind
   236      real(DP), intent(inout):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
   237                                ! $ T (t+\Delta t) $ .   温度. Temperature
   238      real(DP), intent(inout):: xyzf_QMixA (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   239                                ! $ q (t+\Delta t) $ .   混合比. Mass mixing ratio of constituents
   240      real(DP), intent(inout):: xy_PsA (0:imax-1, 1:jmax)
   241                                ! $ p_s (t+\Delta t) $ . 地表面気圧. Surface pressure
   242  
   243      ! 作業変数
   244      ! Work variables
   245      !
   246      real(DP) :: xy_Delta  (0:imax-1, 1:jmax)
   247      real(DP) :: xyz_Delta (0:imax-1, 1:jmax, 1:kmax)
   248      real(DP) :: xyzf_Delta(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   249  
   250      !   Variables for mass fix
   251      real(DP) :: xy_PsNSave    (0:imax-1, 1:jmax)
   252      real(DP) :: xy_PsASave    (0:imax-1, 1:jmax)
   253      real(DP) :: xyzf_QMixNSave(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   254      real(DP) :: xyzf_QMixASave(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   255      real(DP) :: xyr_PressNSave(0:imax-1, 1:jmax, 0:kmax)
   256      real(DP) :: xyr_PressASave(0:imax-1, 1:jmax, 0:kmax)
   257      real(DP) :: xyr_PressN    (0:imax-1, 1:jmax, 0:kmax)
   258      real(DP) :: xyr_PressA    (0:imax-1, 1:jmax, 0:kmax)
   259  
   260      ! 実行文 ; Executable statement
   261      !
   262  
   263      ! 初期化確認
   264      ! Initialization check
   265      !
   266      if ( .not. timefilter_williams2009_inited ) then
   267        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   268      end if
   269  
   270      ! 計算時間計測開始
   271      ! Start measurement of computation time
   272      !
   273      call TimesetClockStart( module_name )
   274  
   275  
   276      ! FilterParameterRA の有効性のチェック
   277      ! Check validity of "FilterParameterRA"
   278      !
   279      if ( FilterParameterRA == 0.0_DP ) return
   280  
   281  
   282      ! Variables are saved
   283      xy_PsNSave     = xy_PsN
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t500 = 1, xy_psnsave.DSC.U2*xy_psnsave.DSC.U1 +                
     .       1   xy_psnsave.DSC.U2                                              
     .           xy_psnsave(t500-1,1) = xy_psn(t500-1,1)                        
     .           xy_psasave(t500-1,1) = xy_psa(t500-1,1)                        
     .        enddo                                                             
   284      xy_PsASave     = xy_PsA
   285      xyzf_QMixNSave = xyzf_QMixN
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t512 = 1, xyzf_qmixnsave.DSC.U4*xyzf_qmixnsave.DSC.U3*         
     .       1   xyzf_qmixnsave.DSC.U2*(xyzf_qmixnsave.DSC.U1 + 1)              
     .           xyzf_qmixnsave(t512-1,1,1,1) = xyzf_qmixn(t512-1,1,1,1)        
     .           xyzf_qmixasave(t512-1,1,1,1) = xyzf_qmixa(t512-1,1,1,1)        
     .        enddo                                                             
   286      xyzf_QMixASave = xyzf_QMixA
   287  
   288  
   289      ! タイムフィルターを適用
   290      ! Apply time filter
   291      !
   292      xyz_Delta  =  &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t536 = 1, kmax*jmax*imax                                       
     .           xyz_delta1 = filterparameterra*(xyz_ub(t536-1,1,1)-            
     .       1      2.00000000000000e+000*xyz_un(t536-1,1,1)+xyz_ua(t536-1,1,1))
     .           xyz_un(t536-1,1,1) = xyz_un(t536-1,1,1) + filterparameterw*    
     .       1      xyz_delta1                                                  
     .           xyz_ua(t536-1,1,1) = xyz_ua(t536-1,1,1) - (                    
     .       1      1.00000000000000e+000 - filterparameterw)*xyz_delta1        
     .           xyz_delta1 = filterparameterra*(xyz_vb(t536-1,1,1)-            
     .       1      2.00000000000000e+000*xyz_vn(t536-1,1,1)+xyz_va(t536-1,1,1))
     .           xyz_vn(t536-1,1,1) = xyz_vn(t536-1,1,1) + filterparameterw*    
     .       1      xyz_delta1                                                  
     .           xyz_va(t536-1,1,1) = xyz_va(t536-1,1,1) - (                    
     .       1      1.00000000000000e+000 - filterparameterw)*xyz_delta1        
     .           xyz_delta1 = filterparameterra*(xyz_tempb(t536-1,1,1)-         
     .       1      2.00000000000000e+000*xyz_tempn(t536-1,1,1)+xyz_tempa(t536-1
     .       2      ,1,1))                                                      
     .           xyz_tempn(t536-1,1,1) = xyz_tempn(t536-1,1,1) +                
     .       1      filterparameterw*xyz_delta1                                 
     .           xyz_tempa(t536-1,1,1) = xyz_tempa(t536-1,1,1) - (              
     .       1      1.00000000000000e+000 - filterparameterw)*xyz_delta1        
     .        enddo                                                             
   293        & + FilterParameterRA * ( xyz_UB     - 2.0_DP * xyz_UN     + xyz_UA     )
   294      xyz_UN     =  xyz_UN    &
   295        & + FilterParameterW              * xyz_Delta
   296  !!$    xyz_UA     =  xyz_UA    &
   297  !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyz_Delta
   298      xyz_UA     =  xyz_UA    &
   299        & - ( 1.0_DP - FilterParameterW ) * xyz_Delta
   300  
   301      xyz_Delta  =  &
   302        & + FilterParameterRA * ( xyz_VB     - 2.0_DP * xyz_VN     + xyz_VA     )
   303      xyz_VN     =  xyz_VN    &
   304        & + FilterParameterW              * xyz_Delta
   305  !!$    xyz_VA     =  xyz_VA    &
   306  !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyz_Delta
   307      xyz_VA     =  xyz_VA    &
   308        & - ( 1.0_DP - FilterParameterW ) * xyz_Delta
   309  
   310      xyz_Delta  =  &
   311        & + FilterParameterRA * ( xyz_TempB  - 2.0_DP * xyz_TempN  + xyz_TempA  )
   312      xyz_TempN  =  xyz_TempN &
   313        & + FilterParameterW              * xyz_Delta
   314  !!$    xyz_TempA  =  xyz_TempA &
   315  !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyz_Delta
   316      xyz_TempA  =  xyz_TempA &
   317        & - ( 1.0_DP - FilterParameterW ) * xyz_Delta
   318  
   319      xy_Delta   =  &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t632 = 1, jmax*imax                                            
     .           xy_delta1 = filterparameterra*(xy_psb(t632-1,1)-               
     .       1      2.00000000000000e+000*xy_psn(t632-1,1)+xy_psa(t632-1,1))    
     .           xy_psn(t632-1,1) = xy_psn(t632-1,1) + filterparameterw*        
     .       1      xy_delta1                                                   
     .           xy_psa(t632-1,1) = xy_psa(t632-1,1) - (1.00000000000000e+000 - 
     .       1      filterparameterw)*xy_delta1                                 
     .        enddo                                                             
   320        & + FilterParameterRA * ( xy_PsB     - 2.0_DP * xy_PsN     + xy_PsA     )
   321      xy_PsN     =  xy_PsN    &
   322        & + FilterParameterW              * xy_Delta
   323  !!$    xy_PsA     =  xy_PsA    &
   324  !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
   325      xy_PsA     =  xy_PsA    &
   326        & - ( 1.0_DP - FilterParameterW ) * xy_Delta
   327  
   328      xyzf_Delta =  &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t656 = 1, ncmax*kmax*jmax*imax                                 
     .           xyzf_delta1 = filterparameterra*(xyzf_qmixb(t656-1,1,1,1)-     
     .       1      2.00000000000000e+000*xyzf_qmixn(t656-1,1,1,1)+xyzf_qmixa(  
     .       2      t656-1,1,1,1))                                              
     .           xyzf_qmixn(t656-1,1,1,1) = xyzf_qmixn(t656-1,1,1,1) +          
     .       1      filterparameterw*xyzf_delta1                                
     .           xyzf_qmixa(t656-1,1,1,1) = xyzf_qmixa(t656-1,1,1,1) - (        
     .       1      1.00000000000000e+000 - filterparameterw)*xyzf_delta1       
     .        enddo                                                             
   329        & + FilterParameterRA * ( xyzf_QMixB - 2.0_DP * xyzf_QMixN + xyzf_QMixA )
   330  !!$    xyzf_QMixN = xyzf_QMixN + xyzf_Delta
   331      xyzf_QMixN = xyzf_QMixN &
   332        & + FilterParameterW              * xyzf_Delta
   333  !    xyzf_QMixA = xyzf_QMixA &
   334  !      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyzf_Delta
   335      xyzf_QMixA = xyzf_QMixA &
   336        & - ( 1.0_DP - FilterParameterW ) * xyzf_Delta
   337      !
   338      ! Mass fix
   339      !   MEMO (1/2):
   340      !     If mass fixing below is commented out, filter behaves like
   341      !     Robert-Asselin filter.
   342      !   -----
   343      call AuxVars( &
   344        & xy_PsNSave, xyz_TempN, xyzf_QMixNSave(:,:,:,IndexH2OVap), & ! (in )
   345        & xyr_Press = xyr_PressNSave                                & ! (out) optiona
   346        & )
   347      call AuxVars( &
   348        & xy_PsN    , xyz_TempN, xyzf_QMixN    (:,:,:,IndexH2OVap), & ! (in )
   349        & xyr_Press = xyr_PressN                                    & ! (out) optiona
   350        & )
   351      call MassFixer(                    &
   352        & xyr_PressN,                    & ! (in)
   353        & xyzf_QMixN,                    & ! (inout)
   354        & xyr_PressRef = xyr_PressNSave, & ! (in) optional
   355        & xyzf_QMixRef = xyzf_QMixNSave  & ! (in) optional
   356        & )
   357      call AuxVars( &
   358        & xy_PsASave, xyz_TempA, xyzf_QMixASave(:,:,:,IndexH2OVap), & ! (in )
   359        & xyr_Press = xyr_PressASave                                & ! (out) optiona
   360        & )
   361      call AuxVars( &
   362        & xy_PsA    , xyz_TempA, xyzf_QMixA    (:,:,:,IndexH2OVap), & ! (in )
   363        & xyr_Press = xyr_PressA                                    & ! (out) optiona
   364        & )
   365      call MassFixer(                    &
   366        & xyr_PressA,                    & ! (in)
   367        & xyzf_QMixA,                    & ! (inout)
   368        & xyr_PressRef = xyr_PressASave, & ! (in) optional
   369        & xyzf_QMixRef = xyzf_QMixASave  & ! (in) optional
   370        & )
   371      !   -----
   372  
   373  
   374      ! 計算時間計測一時停止
   375      ! Pause measurement of computation time
   376      !
   377      call TimesetClockStop( module_name )
   378  
   379    end subroutine TimeFilterWilliams2009
   380  
   381    !--------------------------------------------------------------------------------------
   382  
   383    subroutine TimeFilterWilliams2009SurfVars(           &
   384      & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (in)
   385      & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN, & ! (inout)
   386      & xy_SurfMajCompIceA, xy_SoilMoistA, xy_SurfSnowA, & ! (inout)
   387      & xy_PsA                                           & ! (inout)
   388      & )
   389      !
   390      ! 予報変数にタイムフィルターを適用します.
   391      !
   392      ! Time filter is applied to predictional variables.
   393      !
   394  
   395      ! モジュール引用 ; USE statements
   396      !
   397  
   398      ! 時刻管理
   399      ! Time control
   400      !
   401      use timeset, only: &
   402        & TimesetClockStart, TimesetClockStop
   403  
   404      ! 物理定数設定
   405      ! Physical constants settings
   406      !
   407      use constants, only:  &
   408        & Grav
   409                                ! $ g $ [m s-2].
   410                                ! 重力加速度.
   411                                ! Gravitational acceleration
   412  
   413      ! 宣言文 ; Declaration statements
   414      !
   415      implicit none
   416  
   417      real(DP), intent(in   ):: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   418                                ! $ M_mcs (t-\Delta t) $ .
   419                                ! Surface major component ice amount
   420      real(DP), intent(in   ):: xy_SoilMoistB (0:imax-1, 1:jmax)
   421                                ! $ M_ws (t-\Delta t) $ . 地表水質量.
   422                                ! Soil moisture
   423      real(DP), intent(in   ):: xy_SurfSnowB  (0:imax-1, 1:jmax)
   424                                ! $ M_ss (t-\Delta t) $ . 積雪量.
   425                                ! Surface snow amount
   426  !!$    real(DP), intent(in   ):: xy_SOSeaIceMassB  (0:imax-1, 1:jmax)
   427  !!$                              ! $ M_si (t-\Delta t) $ .
   428  !!$                              ! Slab sea ice mass
   429      real(DP), intent(inout):: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
   430                                ! $ M_mcs (t) $ .
   431                                ! Surface major component ice amount
   432      real(DP), intent(inout):: xy_SoilMoistN (0:imax-1, 1:jmax)
   433                                ! $ M_ws (t-\Delta t) $ . 地表水質量.
   434                                ! Soil moisture
   435      real(DP), intent(inout):: xy_SurfSnowN  (0:imax-1, 1:jmax)
   436                                ! $ M_ss (t) $ . 積雪量.
   437                                ! Surface snow amount
   438  !!$    real(DP), intent(inout):: xy_SOSeaIceMassN  (0:imax-1, 1:jmax)
   439  !!$                              ! $ M_si (t) $ .
   440  !!$                              ! Slab sea ice mass
   441      real(DP), intent(inout):: xy_SurfMajCompIceA(0:imax-1, 1:jmax)
   442                                ! $ M_mcs (t+\Delta t) $ .
   443                                ! Surface major component ice amount
   444      real(DP), intent(inout):: xy_SoilMoistA (0:imax-1, 1:jmax)
   445                                ! $ M_ws (t-\Delta t) $ . 地表水質量.
   446                                ! Soil moisture
   447      real(DP), intent(inout):: xy_SurfSnowA  (0:imax-1, 1:jmax)
   448                                ! $ M_ss (t+\Delta t) $ . 積雪量.
   449                                ! Surface snow amount
   450  !!$    real(DP), intent(inout):: xy_SOSeaIceMassA  (0:imax-1, 1:jmax)
   451  !!$                              ! $ M_si (t+\Delta t) $ .
   452  !!$                              ! Slab sea ice mass
   453      real(DP), intent(inout):: xy_PsA (0:imax-1, 1:jmax)
   454                                ! $ p_s (t+\Delta t) $ . 地表面気圧. Surface pressure
   455  
   456      ! 作業変数
   457      ! Work variables
   458      !
   459      real(DP) :: xy_Delta  (0:imax-1, 1:jmax)
   460      integer:: i               ! 経度方向に回る DO ループ用作業変数
   461                                ! Work variables for DO loop in longitude
   462      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   463                                ! Work variables for DO loop in latitude
   464  
   465  
   466      ! 実行文 ; Executable statement
   467      !
   468  
   469      ! 初期化確認
   470      ! Initialization check
   471      !
   472      if ( .not. timefilter_williams2009_inited ) then
   473        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   474      end if
   475  
   476  
   477      ! 計算時間計測開始
   478      ! Start measurement of computation time
   479      !
   480      call TimesetClockStart( module_name )
   481  
   482  
   483      ! FilterParameterRA の有効性のチェック
   484      ! Check validity of "FilterParameterRA"
   485      !
   486      if ( FilterParameterRA == 0.0_DP ) return
   487  
   488      ! タイムフィルターを適用
   489      ! Apply time filter
   490      !
   491      xy_Delta   =  &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t192 = 1, jmax*imax                                            
     .           xy_delta(t192-1,1) = filterparameterra*(xy_surfmajcompiceb(t192
     .       1      -1,1)-2.00000000000000e+000*xy_surfmajcompicen(t192-1,1)+   
     .       2      xy_surfmajcompicea(t192-1,1))                               
     .           xy_surfmajcompicen(t192-1,1) = xy_surfmajcompicen(t192-1,1) +  
     .       1      filterparameterw*xy_delta(t192-1,1)                         
     .           xy_surfmajcompicea(t192-1,1) = xy_surfmajcompicea(t192-1,1) - (
     .       1      1.00000000000000e+000 - filterparameterw)*xy_delta(t192-1,1)
     .        enddo                                                             
   492        & + FilterParameterRA                                         &
   493        & * ( xy_SurfMajCompIceB - 2.0_DP * xy_SurfMajCompIceN + xy_SurfMajCompIceA )
   494      xy_SurfMajCompIceN = xy_SurfMajCompIceN                         &
   495        & + FilterParameterW              * xy_Delta
   496  !!$    xy_SurfMajCompIceA = xy_SurfMajCompIceA                         &
   497  !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
   498      xy_SurfMajCompIceA = xy_SurfMajCompIceA                         &
   499        & - ( 1.0_DP - FilterParameterW ) * xy_Delta
   500  !!$    xy_SurfMajCompIceN = max( xy_SurfMajCompIceN, 0.0_DP )
   501  !!$    xy_SurfMajCompIceA = max( xy_SurfMajCompIceA, 0.0_DP )
   502      ! Mass fix
   503      !   MEMO (2/2):
   504      !     If mass fixing below is commented out, filter behaves like
   505      !     Robert-Asselin filter.
   506      !   -----
   507      do j = 1, jmax
   508        do i = 0, imax-1
   509          if ( xy_SurfMajCompIceA(i,j) < 0.0_DP ) then
   510            xy_PsA(i,j) = xy_PsA(i,j) + xy_SurfMajCompIceA(i,j) * Grav
   511            xy_SurfMajCompIceA(i,j) = 0.0_DP
   512          end if
   513        end do
   514      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_surfmajcompicea(j-1,1) .lt. 0.0000000000000000e+000)    
     .       1      then                                                        
     .              xy_psa(j-1,1) = xy_psa(j-1,1) + xy_surfmajcompicea(j-1,1)*  
     .       1         grav                                                     
     .              xy_surfmajcompicea(j-1,1) = 0.0000000000000000e+000         
     .           endif                                                          
     .        enddo                                                             
   515      !   -----
   516  
   517      xy_Delta   =  &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t216 = 1, jmax*imax                                            
     .           xy_delta1 = filterparameterra*(xy_soilmoistb(t216-1,1)-        
     .       1      2.00000000000000e+000*xy_soilmoistn(t216-1,1)+xy_soilmoista(
     .       2      t216-1,1))                                                  
     .           xy_soilmoistn(t216-1,1) = xy_soilmoistn(t216-1,1) + xy_delta1  
     .           xy_delta1 = filterparameterra*(xy_surfsnowb(t216-1,1)-         
     .       1      2.00000000000000e+000*xy_surfsnown(t216-1,1)+xy_surfsnowa(  
     .       2      t216-1,1))                                                  
     .           xy_surfsnown(t216-1,1) = xy_surfsnown(t216-1,1) + xy_delta1    
     .        enddo                                                             
   518        & + FilterParameterRA                                         &
   519        & * ( xy_SoilMoistB - 2.0_DP * xy_SoilMoistN + xy_SoilMoistA )
   520      xy_SoilMoistN = xy_SoilMoistN + xy_Delta
   521  !!$    xy_SoilMoistN = xy_SoilMoistN                                   &
   522  !!$      & + FilterParameterW              * xy_Delta
   523  !!$!    xy_SoilMoistA = xy_SoilMoistA                                   &
   524  !!$!      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
   525  !!$    xy_SoilMoistA = xy_SoilMoistA                                   &
   526  !!$      & - ( 1.0_DP - FilterParameterW ) * xy_Delta
   527  !!$    xy_SoilMoistN = max( xy_SoilMoistN, 0.0_DP )
   528  !!$    xy_SoilMoistA = max( xy_SoilMoistA, 0.0_DP )
   529  
   530      xy_Delta   =  &
   531        & + FilterParameterRA                                         &
   532        & * ( xy_SurfSnowB  - 2.0_DP * xy_SurfSnowN  + xy_SurfSnowA  )
   533      xy_SurfSnowN  = xy_SurfSnowN + xy_Delta
   534  !!$    xy_SurfSnowN  = xy_SurfSnowN                                    &
   535  !!$      & + FilterParameterW              * xy_Delta
   536  !!$!    xy_SurfSnowA  = xy_SurfSnowA                                    &
   537  !!$!      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
   538  !!$    xy_SurfSnowA  = xy_SurfSnowA                                    &
   539  !!$      & - ( 1.0_DP - FilterParameterW ) * xy_Delta
   540  !!$    xy_SurfSnowN  = max( xy_SurfSnowN, 0.0_DP )
   541  !!$    xy_SurfSnowA  = max( xy_SurfSnowA, 0.0_DP )
   542  
   543  !!$    xy_Delta   =  &
   544  !!$      & + FilterParameterRA                                         &
   545  !!$      & * ( xy_SOSeaIceMassB  - 2.0_DP * xy_SOSeaIceMassN  + xy_SOSeaIceMassA  )
   546  !!$    xy_SOSeaIceMassN  = xy_SOSeaIceMassN + xy_Delta
   547  
   548  
   549      ! 計算時間計測一時停止
   550      ! Pause measurement of computation time
   551      !
   552      call TimesetClockStop( module_name )
   553  
   554    end subroutine TimeFilterWilliams2009SurfVars
   555  
   556    !--------------------------------------------------------------------------------------
   557  
   558    subroutine TimeFilterWilliams2009Init
   559      !
   560      ! timefilter_williams2009 モジュールの初期化を行います.
   561      ! NAMELIST#timefilter_williams2009_nml の読み込みはこの手続きで行われます.
   562      !
   563      ! "timefilter_williams2009" module is initialized.
   564      ! "NAMELIST#timefilter_williams2009_nml" is loaded in this procedure.
   565      !
   566  
   567      ! モジュール引用 ; USE statements
   568      !
   569  
   570      ! NAMELIST ファイル入力に関するユーティリティ
   571      ! Utilities for NAMELIST file input
   572      !
   573      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   574  
   575      ! ファイル入出力補助
   576      ! File I/O support
   577      !
   578      use dc_iounit, only: FileOpen
   579  
   580      ! 種別型パラメタ
   581      ! Kind type parameter
   582      !
   583      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   584  
   585      ! 質量の補正
   586      ! Mass fixer
   587      !
   588      use mass_fixer, only : MassFixerInit
   589  
   590      ! 宣言文 ; Declaration statements
   591      !
   592      implicit none
   593  
   594      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   595                                ! Unit number for NAMELIST file open
   596      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   597                                ! IOSTAT of NAMELIST read
   598  
   599      ! NAMELIST 変数群
   600      ! NAMELIST group name
   601      !
   602      namelist /timefilter_williams2009_nml/ &
   603        & FilterParameterRA, &
   604        & FilterParameterW
   605            !
   606            ! デフォルト値については初期化手続 "timefilter_asselin1972#Hs94Init"
   607            ! のソースコードを参照のこと.
   608            !
   609            ! Refer to source codes in the initialization procedure
   610            ! "timefilter_asselin1972#Hs94Init" for the default values.
   611            !
   612  
   613      ! 実行文 ; Executable statement
   614      !
   615  
   616      if ( timefilter_williams2009_inited ) return
   617  
   618  
   619      ! デフォルト値の設定
   620      ! Default values settings
   621      !
   622      FilterParameterRA = 0.05_DP
   623      FilterParameterW  = 0.53_DP
   624                      ! recommended value for alpha in Williams (2009)
   625  
   626      ! NAMELIST の読み込み
   627      ! NAMELIST is input
   628      !
   629      if ( trim(namelist_filename) /= '' ) then
   630        call FileOpen( unit_nml, &          ! (out)
   631          & namelist_filename, mode = 'r' ) ! (in)
   632  
   633        rewind( unit_nml )
   634        read( unit_nml, &                         ! (in)
   635          & nml = timefilter_williams2009_nml, &  ! (out)
   636          & iostat = iostat_nml )                 ! (out)
   637        close( unit_nml )
   638  
   639        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   640        if ( iostat_nml == 0 ) write( STDOUT, nml = timefilter_williams2009_nml )
   641      end if
   642  
   643  
   644      ! 質量の補正
   645      ! Mass fixer
   646      !
   647      call MassFixerInit
   648  
   649  
   650      ! 印字 ; Print
   651      !
   652      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   653      call MessageNotify( 'M', module_name, '  FilterParameterRA = %f', d = (/ FilterParameterRA /) )
   654      call MessageNotify( 'M', module_name, '  FilterParameterW  = %f', d = (/ FilterParameterW  /) )
   655      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   656  
   657      timefilter_williams2009_inited = .true.
   658  
   659    end subroutine TimeFilterWilliams2009Init
   660  
   661    !--------------------------------------------------------------------------------------
   662  
   663  end module timefilter_williams2009
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: timefilter_williams2009.f90
PROGRAM NAME: timefilter_williams2009
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 時間フィルター (Williams, 2009)
     2:             !
     3:             != Time filter (Williams, 2009)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: timefilter_williams2009.f90,v 1.4 2015/01/29 12:09:04 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module timefilter_williams2009
    13:               !
    14:               != 時間フィルター (Williams, 2009)
    15:               !
    16:               != Time filter (Williams, 2009)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 計算モードを抑えるための時間フィルター (Williams, 2009)
    21:               ! を適用するためのモジュールです.
    22:               ! Time filter by Williams (2009) is the modified version of that 
    23:               ! by Asselin (1972).
    24:               !
    25:             !!$  ! すなわち
    26:             !!$  ! \[
    27:             !!$  !   \bar{A}^{t}
    28:             !!$  !   = {A}^{t}
    29:             !!$  !     + \epsilon_f
    30:             !!$  !        \left( 
    31:             !!$  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
    32:             !!$  !        \right) \] \[
    33:             !!$  !   \qquad
    34:             !!$  !   = ( 1-2 \epsilon_f ) {A}^{t}
    35:             !!$  !     + \epsilon_f 
    36:             !!$  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    37:             !!$  ! \]
    38:             !!$  ! として $ \bar{A}^{t} $ を求めます. 添え字
    39:             !!$  ! $ t-\Delta t, t, t+\Delta t $ はそれぞれ時間ステップを表し,
    40:             !!$  ! タイムフィルターが適用された項には上線 ( $ \bar{\quad} $ ) 
    41:             !!$  ! が付いています.
    42:             !!$  !
    43:             !!$  ! タイムフィルターの係数 $\epsilon_f$ は Create の際に設定します.
    44:             !!$  !
    45:             !!$  !--
    46:             !!$  ! \[
    47:             !!$  !   \bar{\mathscr A}^{t}
    48:             !!$  !     = ( 1-2 \epsilon_f ) {\mathscr A}^{t}
    49:             !!$  !     +  \epsilon_f 
    50:             !!$  !         \left( \bar{\mathscr A}^{t-\Delta t} + {\mathscr A}^{t+\Delta t} \right)
    51:             !!$  ! \]
    52:             !!$  ! として$\bar{\mathscr A}^{t}$を求めます. 添え字
    53:             !!$  !++
    54:             !!$  !
    55:             !!$  ! Time filter (Asselin, 1972) for suppression of computational mode 
    56:             !!$  ! is applied.
    57:             !!$  !
    58:             !!$  ! Concretely, $ \bar{A}^{t} $ is derived as follows.
    59:             !!$  ! \[
    60:             !!$  !   \bar{A}^{t}
    61:             !!$  !   = {A}^{t}
    62:             !!$  !     + \epsilon_f
    63:             !!$  !        \left( 
    64:             !!$  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
    65:             !!$  !        \right) \] \[
    66:             !!$  !   \qquad
    67:             !!$  !   = ( 1-2 \epsilon_f ) {A}^{t}
    68:             !!$  !     + \epsilon_f 
    69:             !!$  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right),
    70:             !!$  ! \]
    71:             !!$  ! where suffices $ t-\Delta t, t, t+\Delta t $ represent time step, 
    72:             !!$  ! and over-bar $ \bar{\quad} $ represents the terms applied 
    73:             !!$  ! time filter.
    74:             !!$  !
    75:             !!$  ! Time filter coefficient $ \epsilon_f $ is specified by "Create".
    76:               !
    77:               !== Procedures List
    78:               ! 
    79:               ! TimeFilterWilliams2009    :: 時間フィルターの適用
    80:               ! ------------------------  :: ------------
    81:               ! TimeFilterWilliams2009    :: Apply time filter
    82:               !
    83:               !== NAMELIST
    84:               !
    85:               ! NAMELIST#timefilter_williams2009_nml
    86:               !
    87:               !== References
    88:               !
    89:               ! * Williams, P. D., 2009: 
    90:               !   A proposed modification to the Robert-Asselin time filter, 
    91:               !   <i>Mon. Wea. Rev.</i>, <b>137</b>, 2538--2546. 
    92:               !
    93:               ! * Asselin, R. A., 1972: 
    94:               !   Frequency filter for time integrations.
    95:               !   <i>Mon. Wea. Rev.</i>, <b>100</b>, 487--490.
    96:               !
    97:             
    98:               ! モジュール引用 ; USE statements
    99:               !
   100:             
   101:               ! 格子点設定
   102:               ! Grid points settings
   103:               !
   104:               use gridset, only: imax, & ! 経度格子点数. 
   105:                                          ! Number of grid points in longitude
   106:                 &                jmax, & ! 緯度格子点数. 
   107:                                          ! Number of grid points in latitude
   108:                 &                kmax    ! 鉛直層数. 
   109:                                          ! Number of vertical level
   110:             
   111:               use composition, only: ncmax  ! 微量成分の数
   112:                                             ! Number of composition
   113:             
   114:               ! 種別型パラメタ
   115:               ! Kind type parameter
   116:               !
   117:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
   118:                 &                 STRING     ! 文字列.       Strings. 
   119:             
   120:             
   121:               ! メッセージ出力
   122:               ! Message output
   123:               !
   124:               use dc_message, only: MessageNotify
   125:             
   126:               ! 宣言文 ; Declaration statements
   127:               !
   128:               implicit none
   129:               private
   130:             
   131:               ! 公開手続き
   132:               ! Public procedure
   133:               !
   134:               public :: TimeFilterWilliams2009
   135:               public :: TimeFilterWilliams2009SurfVars
   136:               public :: TimeFilterWilliams2009Init
   137:             
   138:               ! 公開変数
   139:               ! Public variables
   140:               !
   141:             
   142:               ! 非公開変数
   143:               ! Private variables
   144:               !
   145:               logical, save :: timefilter_williams2009_inited = .false.
   146:                                           ! 初期設定フラグ. 
   147:                                           ! Initialization flag
   148:             
   149:               real(DP), save :: FilterParameterRA
   150:                                           ! Robert-Asselin 時間フィルターの係数. 
   151:                                           ! Time filter coefficient for Robert-Asselin filter
   152:                                           ! This is equal to nu/2 in Williams (2009).
   153:               real(DP), save :: FilterParameterW
   154:                                           ! Williams 時間フィルターの係数. 
   155:                                           ! Time filter coefficient for Williams filter
   156:                                           ! This is equal to alpha in Williams (2009).
   157:             
   158:               character(*), parameter:: module_name = 'timefilter_williams2009'
   159:                                           ! モジュールの名称. 
   160:                                           ! Module name
   161:               character(*), parameter:: version = &
   162:                 & '$Name:  $' // &
   163:                 & '$Id: timefilter_williams2009.f90,v 1.4 2015/01/29 12:09:04 yot Exp $'
   164:                                           ! モジュールのバージョン
   165:                                           ! Module version
   166:             
   167:             contains
   168:             
   169:               !--------------------------------------------------------------------------------------
   170:             
   171:               subroutine TimeFilterWilliams2009(                 &
   172:                 & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
   173:                 & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, &   ! (inout)
   174:                 & xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA, xy_PsA  &   ! (inout)
   175:                 & )
   176:                 !
   177:                 ! 予報変数にタイムフィルターを適用します. 
   178:                 !
   179:                 ! Time filter is applied to predictional variables.
   180:                 !
   181:             
   182:                 ! モジュール引用 ; USE statements
   183:                 !
   184:             
   185:                 ! 時刻管理
   186:                 ! Time control
   187:                 !
   188:                 use timeset, only: &
   189:                   & TimesetClockStart, TimesetClockStop
   190:             
   191:                 ! 組成に関わる配列の設定
   192:                 ! Settings of array for atmospheric composition
   193:                 !
   194:                 use composition, only: &
   195:                 &                    IndexH2OVap
   196:             
   197:                 ! 質量の補正
   198:                 ! Mass fixer
   199:                 !
   200:                 use mass_fixer, only: MassFixer
   201:             
   202:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   203:                 ! Interpolate temperature on half sigma level,
   204:                 ! and calculate pressure and height
   205:                 !
   206:                 use auxiliary, only: AuxVars
   207:             
   208:                 ! 宣言文 ; Declaration statements
   209:                 !
   210:                 implicit none
   211:             
   212:                 real(DP), intent(in):: xyz_UB (0:imax-1, 1:jmax, 1:kmax)
   213:                                           ! $ u (t-\Delta t) $ .   東西風速. Eastward wind
   214:                 real(DP), intent(in):: xyz_VB (0:imax-1, 1:jmax, 1:kmax)
   215:                                           ! $ v (t-\Delta t) $ .   南北風速. Northward wind
   216:                 real(DP), intent(in):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   217:                                           ! $ T (t-\Delta t) $ .   温度. Temperature
   218:                 real(DP), intent(in):: xyzf_QMixB (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   219:                                           ! $ q (t-\Delta t) $ .   混合比. Mass mixing ratio of constituents
   220:                 real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
   221:                                           ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure
   222:                 real(DP), intent(inout):: xyz_UN (0:imax-1, 1:jmax, 1:kmax)
   223:                                           ! $ u (t) $ .     東西風速. Eastward wind
   224:                 real(DP), intent(inout):: xyz_VN (0:imax-1, 1:jmax, 1:kmax)
   225:                                           ! $ v (t) $ .     南北風速. Northward wind
   226:                 real(DP), intent(inout):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
   227:                                           ! $ T (t) $ .     温度. Temperature
   228:                 real(DP), intent(inout):: xyzf_QMixN (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   229:                                           ! $ q (t) $ .     混合比. Mass mixing ratio of constituents
   230:                 real(DP), intent(inout):: xy_PsN (0:imax-1, 1:jmax)
   231:                                           ! $ p_s (t) $ .   地表面気圧. Surface pressure
   232:                 real(DP), intent(inout):: xyz_UA (0:imax-1, 1:jmax, 1:kmax)
   233:                                           ! $ u (t+\Delta t) $ .   東西風速. Eastward wind
   234:                 real(DP), intent(inout):: xyz_VA (0:imax-1, 1:jmax, 1:kmax)
   235:                                           ! $ v (t+\Delta t) $ .   南北風速. Northward wind
   236:                 real(DP), intent(inout):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
   237:                                           ! $ T (t+\Delta t) $ .   温度. Temperature
   238:                 real(DP), intent(inout):: xyzf_QMixA (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   239:                                           ! $ q (t+\Delta t) $ .   混合比. Mass mixing ratio of constituents
   240:                 real(DP), intent(inout):: xy_PsA (0:imax-1, 1:jmax)
   241:                                           ! $ p_s (t+\Delta t) $ . 地表面気圧. Surface pressure
   242:             
   243:                 ! 作業変数
   244:                 ! Work variables
   245:                 !
   246:                 real(DP) :: xy_Delta  (0:imax-1, 1:jmax)
   247:                 real(DP) :: xyz_Delta (0:imax-1, 1:jmax, 1:kmax)
   248:                 real(DP) :: xyzf_Delta(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   249:             
   250:                 !   Variables for mass fix
   251:                 real(DP) :: xy_PsNSave    (0:imax-1, 1:jmax)
   252:                 real(DP) :: xy_PsASave    (0:imax-1, 1:jmax)
   253:                 real(DP) :: xyzf_QMixNSave(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   254:                 real(DP) :: xyzf_QMixASave(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   255:                 real(DP) :: xyr_PressNSave(0:imax-1, 1:jmax, 0:kmax)
   256:                 real(DP) :: xyr_PressASave(0:imax-1, 1:jmax, 0:kmax)
   257:                 real(DP) :: xyr_PressN    (0:imax-1, 1:jmax, 0:kmax)
   258:                 real(DP) :: xyr_PressA    (0:imax-1, 1:jmax, 0:kmax)
   259:             
   260:                 ! 実行文 ; Executable statement
   261:                 !
   262:             
   263:                 ! 初期化確認
   264:                 ! Initialization check
   265:                 !
   266:                 if ( .not. timefilter_williams2009_inited ) then
   267:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   268:                 end if
   269:             
   270:                 ! 計算時間計測開始
   271:                 ! Start measurement of computation time
   272:                 !
   273:                 call TimesetClockStart( module_name )
   274:             
   275:             
   276:                 ! FilterParameterRA の有効性のチェック
   277:                 ! Check validity of "FilterParameterRA"
   278:                 !
   279:                 if ( FilterParameterRA == 0.0_DP ) return
   280:             
   281:             
   282:                 ! Variables are saved
   283: *W----->A       xy_PsNSave     = xy_PsN
   284: *W----- A       xy_PsASave     = xy_PsA
   285: ***W--->A       xyzf_QMixNSave = xyzf_QMixN
   286: ***W--- A       xyzf_QMixASave = xyzf_QMixA
   287:             
   288:             
   289:                 ! タイムフィルターを適用
   290:                 ! Apply time filter
   291:                 !
   292: **W---->A       xyz_Delta  =  &
   293: |||               & + FilterParameterRA * ( xyz_UB     - 2.0_DP * xyz_UN     + xyz_UA     )
   294: |||     A       xyz_UN     =  xyz_UN    &
   295: |||               & + FilterParameterW              * xyz_Delta
   296: |||         !!$    xyz_UA     =  xyz_UA    &
   297: |||         !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyz_Delta
   298: |||     A       xyz_UA     =  xyz_UA    &
   299: |||               & - ( 1.0_DP - FilterParameterW ) * xyz_Delta
   300: |||         
   301: |||     A       xyz_Delta  =  &
   302: |||               & + FilterParameterRA * ( xyz_VB     - 2.0_DP * xyz_VN     + xyz_VA     )
   303: |||     A       xyz_VN     =  xyz_VN    &
   304: |||               & + FilterParameterW              * xyz_Delta
   305: |||         !!$    xyz_VA     =  xyz_VA    &
   306: |||         !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyz_Delta
   307: |||     A       xyz_VA     =  xyz_VA    &
   308: |||               & - ( 1.0_DP - FilterParameterW ) * xyz_Delta
   309: |||         
   310: |||     A       xyz_Delta  =  &
   311: |||               & + FilterParameterRA * ( xyz_TempB  - 2.0_DP * xyz_TempN  + xyz_TempA  )
   312: |||     A       xyz_TempN  =  xyz_TempN &
   313: |||               & + FilterParameterW              * xyz_Delta
   314: |||         !!$    xyz_TempA  =  xyz_TempA &
   315: |||         !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyz_Delta
   316: **W---- A       xyz_TempA  =  xyz_TempA &
   317:                   & - ( 1.0_DP - FilterParameterW ) * xyz_Delta
   318:             
   319: *W----->A       xy_Delta   =  &
   320: ||                & + FilterParameterRA * ( xy_PsB     - 2.0_DP * xy_PsN     + xy_PsA     )
   321: ||      A       xy_PsN     =  xy_PsN    &
   322: ||                & + FilterParameterW              * xy_Delta
   323: ||          !!$    xy_PsA     =  xy_PsA    &
   324: ||          !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
   325: *W----- A       xy_PsA     =  xy_PsA    &
   326:                   & - ( 1.0_DP - FilterParameterW ) * xy_Delta
   327:             
   328: ***W--->A       xyzf_Delta =  &
   329: ||||              & + FilterParameterRA * ( xyzf_QMixB - 2.0_DP * xyzf_QMixN + xyzf_QMixA )
   330: ||||        !!$    xyzf_QMixN = xyzf_QMixN + xyzf_Delta
   331: ||||    A       xyzf_QMixN = xyzf_QMixN &
   332: ||||              & + FilterParameterW              * xyzf_Delta
   333: ||||        !    xyzf_QMixA = xyzf_QMixA &
   334: ||||        !      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyzf_Delta
   335: ***W--- A       xyzf_QMixA = xyzf_QMixA &
   336:                   & - ( 1.0_DP - FilterParameterW ) * xyzf_Delta
   337:                 !
   338:                 ! Mass fix
   339:                 !   MEMO (1/2):
   340:                 !     If mass fixing below is commented out, filter behaves like 
   341:                 !     Robert-Asselin filter.
   342:                 !   -----
   343:                 call AuxVars( &
   344:                   & xy_PsNSave, xyz_TempN, xyzf_QMixNSave(:,:,:,IndexH2OVap), & ! (in )
   345:                   & xyr_Press = xyr_PressNSave                                & ! (out) optiona
   346:                   & )
   347:                 call AuxVars( &
   348:                   & xy_PsN    , xyz_TempN, xyzf_QMixN    (:,:,:,IndexH2OVap), & ! (in )
   349:                   & xyr_Press = xyr_PressN                                    & ! (out) optiona
   350:                   & )
   351:                 call MassFixer(                    &
   352:                   & xyr_PressN,                    & ! (in)
   353:                   & xyzf_QMixN,                    & ! (inout)
   354:                   & xyr_PressRef = xyr_PressNSave, & ! (in) optional
   355:                   & xyzf_QMixRef = xyzf_QMixNSave  & ! (in) optional
   356:                   & )
   357:                 call AuxVars( &
   358:                   & xy_PsASave, xyz_TempA, xyzf_QMixASave(:,:,:,IndexH2OVap), & ! (in )
   359:                   & xyr_Press = xyr_PressASave                                & ! (out) optiona
   360:                   & )
   361:                 call AuxVars( &
   362:                   & xy_PsA    , xyz_TempA, xyzf_QMixA    (:,:,:,IndexH2OVap), & ! (in )
   363:                   & xyr_Press = xyr_PressA                                    & ! (out) optiona
   364:                   & )
   365:                 call MassFixer(                    &
   366:                   & xyr_PressA,                    & ! (in)
   367:                   & xyzf_QMixA,                    & ! (inout)
   368:                   & xyr_PressRef = xyr_PressASave, & ! (in) optional
   369:                   & xyzf_QMixRef = xyzf_QMixASave  & ! (in) optional
   370:                   & )
   371:                 !   -----
   372:             
   373:             
   374:                 ! 計算時間計測一時停止
   375:                 ! Pause measurement of computation time
   376:                 !
   377:                 call TimesetClockStop( module_name )
   378:             
   379:               end subroutine TimeFilterWilliams2009
   380:             
   381:               !--------------------------------------------------------------------------------------
   382:             
   383:               subroutine TimeFilterWilliams2009SurfVars(           &
   384:                 & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (in)
   385:                 & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN, & ! (inout)
   386:                 & xy_SurfMajCompIceA, xy_SoilMoistA, xy_SurfSnowA, & ! (inout)
   387:                 & xy_PsA                                           & ! (inout)
   388:                 & )
   389:                 !
   390:                 ! 予報変数にタイムフィルターを適用します. 
   391:                 !
   392:                 ! Time filter is applied to predictional variables.
   393:                 !
   394:             
   395:                 ! モジュール引用 ; USE statements
   396:                 !
   397:             
   398:                 ! 時刻管理
   399:                 ! Time control
   400:                 !
   401:                 use timeset, only: &
   402:                   & TimesetClockStart, TimesetClockStop
   403:             
   404:                 ! 物理定数設定
   405:                 ! Physical constants settings
   406:                 !
   407:                 use constants, only:  &
   408:                   & Grav
   409:                                           ! $ g $ [m s-2].
   410:                                           ! 重力加速度.
   411:                                           ! Gravitational acceleration
   412:             
   413:                 ! 宣言文 ; Declaration statements
   414:                 !
   415:                 implicit none
   416:             
   417:                 real(DP), intent(in   ):: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
   418:                                           ! $ M_mcs (t-\Delta t) $ . 
   419:                                           ! Surface major component ice amount
   420:                 real(DP), intent(in   ):: xy_SoilMoistB (0:imax-1, 1:jmax)
   421:                                           ! $ M_ws (t-\Delta t) $ . 地表水質量. 
   422:                                           ! Soil moisture
   423:                 real(DP), intent(in   ):: xy_SurfSnowB  (0:imax-1, 1:jmax)
   424:                                           ! $ M_ss (t-\Delta t) $ . 積雪量.
   425:                                           ! Surface snow amount
   426:             !!$    real(DP), intent(in   ):: xy_SOSeaIceMassB  (0:imax-1, 1:jmax)
   427:             !!$                              ! $ M_si (t-\Delta t) $ . 
   428:             !!$                              ! Slab sea ice mass
   429:                 real(DP), intent(inout):: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
   430:                                           ! $ M_mcs (t) $ . 
   431:                                           ! Surface major component ice amount
   432:                 real(DP), intent(inout):: xy_SoilMoistN (0:imax-1, 1:jmax)
   433:                                           ! $ M_ws (t-\Delta t) $ . 地表水質量. 
   434:                                           ! Soil moisture
   435:                 real(DP), intent(inout):: xy_SurfSnowN  (0:imax-1, 1:jmax)
   436:                                           ! $ M_ss (t) $ . 積雪量.
   437:                                           ! Surface snow amount
   438:             !!$    real(DP), intent(inout):: xy_SOSeaIceMassN  (0:imax-1, 1:jmax)
   439:             !!$                              ! $ M_si (t) $ . 
   440:             !!$                              ! Slab sea ice mass
   441:                 real(DP), intent(inout):: xy_SurfMajCompIceA(0:imax-1, 1:jmax)
   442:                                           ! $ M_mcs (t+\Delta t) $ . 
   443:                                           ! Surface major component ice amount
   444:                 real(DP), intent(inout):: xy_SoilMoistA (0:imax-1, 1:jmax)
   445:                                           ! $ M_ws (t-\Delta t) $ . 地表水質量. 
   446:                                           ! Soil moisture
   447:                 real(DP), intent(inout):: xy_SurfSnowA  (0:imax-1, 1:jmax)
   448:                                           ! $ M_ss (t+\Delta t) $ . 積雪量.
   449:                                           ! Surface snow amount
   450:             !!$    real(DP), intent(inout):: xy_SOSeaIceMassA  (0:imax-1, 1:jmax)
   451:             !!$                              ! $ M_si (t+\Delta t) $ . 
   452:             !!$                              ! Slab sea ice mass
   453:                 real(DP), intent(inout):: xy_PsA (0:imax-1, 1:jmax)
   454:                                           ! $ p_s (t+\Delta t) $ . 地表面気圧. Surface pressure
   455:             
   456:                 ! 作業変数
   457:                 ! Work variables
   458:                 !
   459:                 real(DP) :: xy_Delta  (0:imax-1, 1:jmax)
   460:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   461:                                           ! Work variables for DO loop in longitude
   462:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   463:                                           ! Work variables for DO loop in latitude
   464:             
   465:             
   466:                 ! 実行文 ; Executable statement
   467:                 !
   468:             
   469:                 ! 初期化確認
   470:                 ! Initialization check
   471:                 !
   472:                 if ( .not. timefilter_williams2009_inited ) then
   473:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   474:                 end if
   475:             
   476:             
   477:                 ! 計算時間計測開始
   478:                 ! Start measurement of computation time
   479:                 !
   480:                 call TimesetClockStart( module_name )
   481:             
   482:             
   483:                 ! FilterParameterRA の有効性のチェック
   484:                 ! Check validity of "FilterParameterRA"
   485:                 !
   486:                 if ( FilterParameterRA == 0.0_DP ) return
   487:             
   488:                 ! タイムフィルターを適用
   489:                 ! Apply time filter
   490:                 !
   491: *W----->A       xy_Delta   =  &
   492: ||                & + FilterParameterRA                                         &
   493: ||                & * ( xy_SurfMajCompIceB - 2.0_DP * xy_SurfMajCompIceN + xy_SurfMajCompIceA )
   494: ||      A       xy_SurfMajCompIceN = xy_SurfMajCompIceN                         &
   495: ||                & + FilterParameterW              * xy_Delta
   496: ||          !!$    xy_SurfMajCompIceA = xy_SurfMajCompIceA                         &
   497: ||          !!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
   498: *W----- A       xy_SurfMajCompIceA = xy_SurfMajCompIceA                         &
   499:                   & - ( 1.0_DP - FilterParameterW ) * xy_Delta
   500:             !!$    xy_SurfMajCompIceN = max( xy_SurfMajCompIceN, 0.0_DP )
   501:             !!$    xy_SurfMajCompIceA = max( xy_SurfMajCompIceA, 0.0_DP )
   502:                 ! Mass fix
   503:                 !   MEMO (2/2):
   504:                 !     If mass fixing below is commented out, filter behaves like 
   505:                 !     Robert-Asselin filter.
   506:                 !   -----
   507: W------>        do j = 1, jmax
   508: |*----->          do i = 0, imax-1
   509: ||      A           if ( xy_SurfMajCompIceA(i,j) < 0.0_DP ) then
   510: ||      A             xy_PsA(i,j) = xy_PsA(i,j) + xy_SurfMajCompIceA(i,j) * Grav
   511: ||      A             xy_SurfMajCompIceA(i,j) = 0.0_DP
   512: ||                  end if
   513: |*-----           end do
   514: W------         end do
   515:                 !   -----
   516:             
   517: *W----->A       xy_Delta   =  &
   518: ||                & + FilterParameterRA                                         &
   519: ||                & * ( xy_SoilMoistB - 2.0_DP * xy_SoilMoistN + xy_SoilMoistA )
   520: ||      A       xy_SoilMoistN = xy_SoilMoistN + xy_Delta
   521: ||          !!$    xy_SoilMoistN = xy_SoilMoistN                                   &
   522: ||          !!$      & + FilterParameterW              * xy_Delta
   523: ||          !!$!    xy_SoilMoistA = xy_SoilMoistA                                   &
   524: ||          !!$!      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
   525: ||          !!$    xy_SoilMoistA = xy_SoilMoistA                                   &
   526: ||          !!$      & - ( 1.0_DP - FilterParameterW ) * xy_Delta
   527: ||          !!$    xy_SoilMoistN = max( xy_SoilMoistN, 0.0_DP )
   528: ||          !!$    xy_SoilMoistA = max( xy_SoilMoistA, 0.0_DP )
   529: ||          
   530: ||      A       xy_Delta   =  &
   531: ||                & + FilterParameterRA                                         &
   532: ||                & * ( xy_SurfSnowB  - 2.0_DP * xy_SurfSnowN  + xy_SurfSnowA  )
   533: *W----- A       xy_SurfSnowN  = xy_SurfSnowN + xy_Delta
   534:             !!$    xy_SurfSnowN  = xy_SurfSnowN                                    &
   535:             !!$      & + FilterParameterW              * xy_Delta
   536:             !!$!    xy_SurfSnowA  = xy_SurfSnowA                                    &
   537:             !!$!      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
   538:             !!$    xy_SurfSnowA  = xy_SurfSnowA                                    &
   539:             !!$      & - ( 1.0_DP - FilterParameterW ) * xy_Delta
   540:             !!$    xy_SurfSnowN  = max( xy_SurfSnowN, 0.0_DP )
   541:             !!$    xy_SurfSnowA  = max( xy_SurfSnowA, 0.0_DP )
   542:             
   543:             !!$    xy_Delta   =  &
   544:             !!$      & + FilterParameterRA                                         &
   545:             !!$      & * ( xy_SOSeaIceMassB  - 2.0_DP * xy_SOSeaIceMassN  + xy_SOSeaIceMassA  )
   546:             !!$    xy_SOSeaIceMassN  = xy_SOSeaIceMassN + xy_Delta
   547:             
   548:             
   549:                 ! 計算時間計測一時停止
   550:                 ! Pause measurement of computation time
   551:                 !
   552:                 call TimesetClockStop( module_name )
   553:             
   554:               end subroutine TimeFilterWilliams2009SurfVars
   555:             
   556:               !--------------------------------------------------------------------------------------
   557:             
   558:               subroutine TimeFilterWilliams2009Init
   559:                 !
   560:                 ! timefilter_williams2009 モジュールの初期化を行います. 
   561:                 ! NAMELIST#timefilter_williams2009_nml の読み込みはこの手続きで行われます. 
   562:                 !
   563:                 ! "timefilter_williams2009" module is initialized. 
   564:                 ! "NAMELIST#timefilter_williams2009_nml" is loaded in this procedure. 
   565:                 !
   566:             
   567:                 ! モジュール引用 ; USE statements
   568:                 !
   569:             
   570:                 ! NAMELIST ファイル入力に関するユーティリティ
   571:                 ! Utilities for NAMELIST file input
   572:                 !
   573:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   574:             
   575:                 ! ファイル入出力補助
   576:                 ! File I/O support
   577:                 !
   578:                 use dc_iounit, only: FileOpen
   579:             
   580:                 ! 種別型パラメタ
   581:                 ! Kind type parameter
   582:                 !
   583:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   584:             
   585:                 ! 質量の補正
   586:                 ! Mass fixer
   587:                 !
   588:                 use mass_fixer, only : MassFixerInit
   589:             
   590:                 ! 宣言文 ; Declaration statements
   591:                 !
   592:                 implicit none
   593:             
   594:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   595:                                           ! Unit number for NAMELIST file open
   596:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   597:                                           ! IOSTAT of NAMELIST read
   598:             
   599:                 ! NAMELIST 変数群
   600:                 ! NAMELIST group name
   601:                 !
   602:                 namelist /timefilter_williams2009_nml/ &
   603:                   & FilterParameterRA, &
   604:                   & FilterParameterW
   605:                       !
   606:                       ! デフォルト値については初期化手続 "timefilter_asselin1972#Hs94Init" 
   607:                       ! のソースコードを参照のこと. 
   608:                       !
   609:                       ! Refer to source codes in the initialization procedure
   610:                       ! "timefilter_asselin1972#Hs94Init" for the default values. 
   611:                       !
   612:             
   613:                 ! 実行文 ; Executable statement
   614:                 !
   615:             
   616:                 if ( timefilter_williams2009_inited ) return
   617:             
   618:             
   619:                 ! デフォルト値の設定
   620:                 ! Default values settings
   621:                 !
   622:                 FilterParameterRA = 0.05_DP
   623:                 FilterParameterW  = 0.53_DP
   624:                                 ! recommended value for alpha in Williams (2009)
   625:             
   626:                 ! NAMELIST の読み込み
   627:                 ! NAMELIST is input
   628:                 !
   629:                 if ( trim(namelist_filename) /= '' ) then
   630:                   call FileOpen( unit_nml, &          ! (out)
   631:                     & namelist_filename, mode = 'r' ) ! (in)
   632:             
   633:                   rewind( unit_nml )
   634:                   read( unit_nml, &                         ! (in)
   635:                     & nml = timefilter_williams2009_nml, &  ! (out)
   636:                     & iostat = iostat_nml )                 ! (out)
   637:                   close( unit_nml )
   638:             
   639:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   640:                   if ( iostat_nml == 0 ) write( STDOUT, nml = timefilter_williams2009_nml )
   641:                 end if
   642:             
   643:             
   644:                 ! 質量の補正
   645:                 ! Mass fixer
   646:                 !
   647:                 call MassFixerInit
   648:             
   649:             
   650:                 ! 印字 ; Print
   651:                 !
   652:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   653:                 call MessageNotify( 'M', module_name, '  FilterParameterRA = %f', d = (/ FilterParameterRA /) )
   654:                 call MessageNotify( 'M', module_name, '  FilterParameterW  = %f', d = (/ FilterParameterW  /) )
   655:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   656:             
   657:                 timefilter_williams2009_inited = .true.
   658:             
   659:               end subroutine TimeFilterWilliams2009Init
   660:             
   661:               !--------------------------------------------------------------------------------------
   662:             
   663:             end module timefilter_williams2009
