Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: vertical_filter.f90
PROGRAM NAME: vertical_filter
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   243  opt  (1593): Loop nest collapsed into one loop.
   243  vec  (   1): Vectorized loop.
   243  vec  (  29): ADB is used for array.: xyr_temp
   247  vec  (   3): Unvectorized loop.
   247  vec  (  13): Overhead of loop division is too large.
   248  opt  (1037): Feedback of array elements.
   248  opt  (1593): Loop nest collapsed into one loop.
   248  vec  (   4): Vectorized array expression.
   248  vec  (  29): ADB is used for array.: temp_corr
   250  opt  (1772): Loop nest fused with following nest(s).
   250  opt  (1036): Potential feedback - use directive if OK.
   250  opt  (1593): Loop nest collapsed into one loop.
   250  vec  (   4): Vectorized array expression.
   250  vec  (  29): ADB is used for array.: temp_corr
   250  vec  (  29): ADB is used for array.: xyr_press
   250  vec  (  29): ADB is used for array.: xyz_tempa
   254  opt  (1593): Loop nest collapsed into one loop.
   254  vec  (   4): Vectorized array expression.
   254  vec  (  29): ADB is used for array.: temp_corr
   254  vec  (  29): ADB is used for array.: xyr_press
   256  opt  (1772): Loop nest fused with following nest(s).
   256  opt  (1037): Feedback of array elements.
   256  opt  (1593): Loop nest collapsed into one loop.
   256  vec  (   4): Vectorized array expression.
   256  vec  (  29): ADB is used for array.: xyz_tempa
   256  vec  (  29): ADB is used for array.: temp_corr
   266  warn (  82): Name "i" is not used.
   266  warn (  82): Name "j" is not used.
   266  warn (  83): Dummy argument "xyz_ua" is not used.
   266  warn (  83): Dummy argument "xyz_va" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: vertical_filter.f90
PROGRAM NAME: vertical_filter
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 鉛直フィルター (Ishiwatari et al., 2002)
     2  !
     3  != Vertical filter (Ishiwatari et al., 2002)
     4  !
     5  ! Authors::   Satoshi Noda, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: vertical_filter.f90,v 1.2 2011/06/19 10:56:28 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module vertical_filter
    13    !
    14    != 鉛直フィルター (Ishiwatari et al., 2002)
    15    !
    16    != Vertical filter (Ishiwatari et al., 2002)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 鉛直モードを抑えるための鉛直フィルター (Ishiwatari et al., 2002)
    21    ! を適用するためのモジュールです.
    22    !
    23    ! すなわち
    24    ! \begin{align}
    25    !   T_{B,k} &\equiv \frac{T_{k+1/2} + T_{k-1/2}}{2} \\
    26    ! \end{align}
    27    ! と定義した上で,
    28    ! \begin{align}
    29    !   \bar{T}_{k-1} &= T_{k-1} + F_T
    30    !     ( T_{B, k-1} - T_{k-1} )
    31    !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
    32    !   \bar{T}_{k} &= T_{k} + F_T
    33    !     ( T_{B, k} - T_{k} )
    34    !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
    35    !   \bar{T}_{k+1} &= T_{k+1} + F_T
    36    !     ( T_{B, k+1} - T_{k+1} )
    37    !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}
    38    ! \end{align}
    39    ! という操作を下の層から順に適用することで $ \bar{T} $ を求めます.
    40    ! ここで添え字 $ k $ は層の番号です.
    41    ! 鉛直フィルターが適用された項には上線 ( $ \bar{\quad} $ )
    42    ! が付いています.
    43    !
    44    ! 鉛直フィルターの係数 $F_T$ は Create の際に設定します.
    45    !
    46    !++
    47    !
    48    ! Vertical filter (Ishiwatari et al., 2002) for suppression of vertical mode
    49    ! is applied.
    50    !
    51    ! Concretely, $ \bar{A}^{t} $ is derived as follows.
    52    ! Reference Temperature is defined as
    53    ! \begin{align}
    54    !   T_{B,k} &\equiv \frac{T_{k+1/2} + T_{k-1/2}}{2}.
    55    ! \end{align}
    56    ! Operations as follows are applied from lower layer to higher layer.
    57    ! \begin{align}
    58    !   \bar{T}_{k-1} &= T_{k-1} + F_T
    59    !     ( T_{B, k-1} - T_{k-1} )
    60    !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
    61    !   \bar{T}_{k} &= T_{k} + F_T
    62    !     ( T_{B, k} - T_{k} )
    63    !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
    64    !   \bar{T}_{k+1} &= T_{k+1} + F_T
    65    !     ( T_{B, k+1} - T_{k+1} )
    66    !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}
    67    ! \end{align}
    68    ! where a suffix $ k $ is the number of layer.
    69    ! Over-bar ( $ \bar{\quad} $ ) represents the terms
    70    ! applied vertical filter.
    71    !
    72    ! Vertical filter coefficient $ F_T $ is specified by "Create".
    73    !
    74    !== Procedures List
    75    !
    76    ! VerticalFilter    :: 鉛直フィルターの適用
    77    ! ----------------  :: ---------------------
    78    ! VerticalFilter    :: Apply vertical filter
    79    !
    80    !== NAMELIST
    81    !
    82    ! NAMELIST#vertical_filter_nml
    83    !
    84    !== References
    85    !
    86    ! * Ishiwatari, M., Takehiro S., Nakajima, K. and Hayashi, Y. -Y. 2002:
    87    !   A Numerical Study on Appearance of the Runaway Greenhouse State of a
    88    !   Three-Dimensional Gray Atmosphere.
    89    !   <i>J. Atmos. Sci.</i>, <b>59</b>, 3223--3238.
    90    !
    91  
    92    ! モジュール引用 ; USE statements
    93    !
    94  
    95    ! 格子点設定
    96    ! Grid points settings
    97    !
    98    use gridset, only: imax, & ! 経度格子点数.
    99                               ! Number of grid points in longitude
   100      &                jmax, & ! 緯度格子点数.
   101                               ! Number of grid points in latitude
   102      &                kmax    ! 鉛直層数.
   103                               ! Number of vertical level
   104  
   105    use composition, only: ncmax  ! 微量成分の数
   106                                  ! Number of composition
   107  
   108    ! 種別型パラメタ
   109    ! Kind type parameter
   110    !
   111    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
   112      &                 STRING     ! 文字列.       Strings.
   113  
   114  
   115    ! メッセージ出力
   116    ! Message output
   117    !
   118    use dc_message, only: MessageNotify
   119  
   120    ! 宣言文 ; Declaration statements
   121    !
   122    implicit none
   123    private
   124  
   125    ! 公開手続き
   126    ! Public procedure
   127    !
   128    public:: VerticalFilter
   129  
   130    ! 公開変数
   131    ! Public variables
   132    !
   133    logical, save, public:: vertical_filter_inited = .false.
   134                                ! 初期設定フラグ.
   135                                ! Initialization flag
   136  
   137    ! 非公開変数
   138    ! Private variables
   139    !
   140    real(DP), save:: FilterParameter
   141                                ! 鉛直フィルターの係数.
   142                                ! Vertical filter coefficient
   143  !!$  integer, save:: IntStep     ! 鉛直フィルターを適用するステップ間隔.
   144  !!$                              ! Step interval of vertical filter application
   145  !!$  integer, save:: CurStep     ! VerticalFilter が呼ばれた回数.
   146  !!$                              ! Number of times that "VerticalFilter" is called
   147  !!$  integer, save:: PrevStep    ! 前回鉛直フィルターを適用したステップ数.
   148  !!$                              ! Step number that is filtered previously
   149  
   150    character(*), parameter:: module_name = 'vertical_filter'
   151                                ! モジュールの名称.
   152                                ! Module name
   153    character(*), parameter:: version = &
   154      & '$Name:  $' // &
   155      & '$Id: vertical_filter.f90,v 1.2 2011/06/19 10:56:28 yot Exp $'
   156                                ! モジュールのバージョン
   157                                ! Module version
   158  
   159  contains
   160  
   161    !--------------------------------------------------------------------------------------
   162  
   163    subroutine VerticalFilter( &
   164      & xyz_UA, xyz_VA, xyz_TempA, &
   165      & xyr_Press, xyr_Temp &
   166      & )
   167      !
   168      ! 予報変数に鉛直フィルターを適用します.
   169      !
   170      ! Vertical filter is applied to predictional variables.
   171      !
   172  
   173      ! モジュール引用 ; USE statements
   174      !
   175  
   176      ! 時刻管理
   177      ! Time control
   178      !
   179      use timeset, only: &
   180        & TimesetClockStart, TimesetClockStop
   181  
   182      ! 宣言文 ; Declaration statements
   183      !
   184      implicit none
   185  
   186      real(DP), intent(inout):: xyz_UA (0:imax-1, 1:jmax, 1:kmax)
   187                                ! $ u (t+\Delta t) $ .   東西風速. Eastward wind
   188      real(DP), intent(inout):: xyz_VA (0:imax-1, 1:jmax, 1:kmax)
   189                                ! $ v (t+\Delta t) $ .   南北風速. Northward wind
   190      real(DP), intent(inout):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
   191                                ! $ T (t+\Delta t) $ .   温度. Temperature
   192  
   193      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   194                                ! $ p_{1/2} (t+\Delta t) $ .   気圧. Pressure
   195      real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
   196                                ! $ T_{1/2} (t+\Delta t) $ .   温度. Temperature
   197  
   198  
   199      ! 作業変数
   200      ! Work variables
   201      !
   202      integer:: i               ! 経度方向に回る DO ループ用作業変数
   203                                ! Work variables for DO loop in longitude
   204      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   205                                ! Work variables for DO loop in latitude
   206      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   207                                ! Work variables for DO loop in vertical direction
   208      integer:: k1              ! 鉛直方向に回る DO ループ用作業変数
   209                                ! Work variables for DO loop in vertical direction
   210  
   211      real(DP):: Temp_ref(0:imax-1, 1:jmax, 1:kmax), &
   212        & Temp_corr(0:imax-1, 1:jmax)
   213  
   214      ! 実行文 ; Executable statement
   215      !
   216  
   217      ! 計算時間計測開始
   218      ! Start measurement of computation time
   219      !
   220      call TimesetClockStart( module_name )
   221  
   222      ! 初期化
   223      ! Initialization
   224      !
   225      if ( .not. vertical_filter_inited ) call VerticalFilterInit
   226  
   227  !!$    ! ステップのチェック
   228  !!$    ! Check Step
   229  !!$    !
   230  !!$    CurStep = CurStep + 1
   231  !!$    if ( CurStep - PrevStep < IntStep ) return
   232  !!$    PrevStep = CurStep
   233  
   234      ! FilterParameter の有効性のチェック
   235      ! Check validity of "FilterParameter"
   236      !
   237      if ( FilterParameter == 0.0_DP ) return
   238  
   239      ! 鉛直フィルターを適用
   240      ! Apply vertical filter
   241      !
   242  
   243      do k=1,kmax
   244        Temp_ref(:,:,k)  = 0.5_DP * ( xyr_Temp(:,:,k-1) + xyr_Temp(:,:,k) )
   245      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           temp_ref(k-1,1,1) = 5.00000000000000e-001*(xyr_temp(k-1,1,0)+  
     .       1      xyr_temp(k-1,1,1))                                          
     .        enddo                                                             
   246  
   247      do k=2,kmax-1
   248        Temp_corr = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(temp_corr)                                                 
     .        do t212 = 1, temp_corr.DSC.U2*temp_corr.DSC.U1 + temp_corr.DSC.U2 
     .           temp_corr(t212-1,1) = 0.0000000000000000e+000                  
     .        enddo                                                             
   249        do k1=-1,1
   250          Temp_corr = Temp_corr + FilterParameter &
   251            & * ( Temp_ref(:,:,k+k1) - xyz_TempA(:,:,k+k1) ) &
   252            & * ( xyr_Press(:,:,k+k1-1) - xyr_Press(:,:,k+k1) )
   253        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(temp_corr)                                                 
     .        do t218 = 1, temp_corr.DSC.U2*temp_corr.DSC.U1 + temp_corr.DSC.U2 
     .           temp_corr(t218-1,1) = temp_corr(t218-1,1) + filterparameter*(  
     .       1      temp_ref(t218-1,1,k-1)-xyz_tempa(t218-1,1,k-1))*(xyr_press( 
     .       2      t218-1,1,k-2)-xyr_press(t218-1,1,k-1))                      
     .           temp_corr(t218-1,1) = temp_corr(t218-1,1) + filterparameter*(  
     .       1      temp_ref(t218-1,1,k)-xyz_tempa(t218-1,1,k))*(xyr_press(t218-
     .       2      1,1,k-1)-xyr_press(t218-1,1,k))                             
     .           temp_corr(t218-1,1) = temp_corr(t218-1,1) + filterparameter*(  
     .       1      temp_ref(t218-1,1,k+1)-xyz_tempa(t218-1,1,k+1))*(xyr_press( 
     .       2      t218-1,1,k)-xyr_press(t218-1,1,k+1))                        
     .        enddo                                                             
   254        Temp_corr = Temp_corr / ( xyr_Press(:,:,k-2) - xyr_Press(:,:,k+1) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(temp_corr)                                                 
     .        do t234 = 1, temp_corr.DSC.U2*temp_corr.DSC.U1 + temp_corr.DSC.U2 
     .           temp_corr(t234-1,1) = temp_corr(t234-1,1)/(xyr_press(t234-1,1,k
     .       1      -2)-xyr_press(t234-1,1,k+1))                                
     .        enddo                                                             
   255        do k1=-1,1
   256          xyz_TempA(:,:,k+k1) = xyz_TempA(:,:,k+k1) &
   257            & + FilterParameter * ( Temp_ref(:,:,k+k1) - xyz_TempA(:,:,k+k1) ) - Temp_corr
   258        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(temp_corr)                                                 
     .        do t246 = 1, jmax*imax                                            
     .           xyz_tempa(t246-1,1,k-1) = xyz_tempa(t246-1,1,k-1) +            
     .       1      filterparameter*(temp_ref(t246-1,1,k-1)-xyz_tempa(t246-1,1,k
     .       2      -1)) - temp_corr(t246-1,1)                                  
     .           xyz_tempa(t246-1,1,k) = xyz_tempa(t246-1,1,k) + filterparameter
     .       1      *(temp_ref(t246-1,1,k)-xyz_tempa(t246-1,1,k)) - temp_corr(  
     .       2      t246-1,1)                                                   
     .           xyz_tempa(t246-1,1,k+1) = xyz_tempa(t246-1,1,k+1) +            
     .       1      filterparameter*(temp_ref(t246-1,1,k+1)-xyz_tempa(t246-1,1,k
     .       2      +1)) - temp_corr(t246-1,1)                                  
     .        enddo                                                             
   259      end do
   260  
   261      ! 計算時間計測一時停止
   262      ! Pause measurement of computation time
   263      !
   264      call TimesetClockStop( module_name )
   265  
   266    end subroutine VerticalFilter
   267  
   268    !--------------------------------------------------------------------------------------
   269  
   270    subroutine VerticalFilterInit
   271      !
   272      ! vertical_filter モジュールの初期化を行います.
   273      ! NAMELIST#vertical_filter_nml の読み込みはこの手続きで行われます.
   274      !
   275      ! "vertical_filter" module is initialized.
   276      ! "NAMELIST#vertical_filter_nml" is loaded in this procedure.
   277      !
   278  
   279      ! モジュール引用 ; USE statements
   280      !
   281  
   282      ! NAMELIST ファイル入力に関するユーティリティ
   283      ! Utilities for NAMELIST file input
   284      !
   285      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   286  
   287      ! ファイル入出力補助
   288      ! File I/O support
   289      !
   290      use dc_iounit, only: FileOpen
   291  
   292      ! 種別型パラメタ
   293      ! Kind type parameter
   294      !
   295      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   296  
   297      ! 宣言文 ; Declaration statements
   298      !
   299      implicit none
   300  
   301      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   302                                ! Unit number for NAMELIST file open
   303      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   304                                ! IOSTAT of NAMELIST read
   305  
   306      ! NAMELIST 変数群
   307      ! NAMELIST group name
   308      !
   309      namelist /vertical_filter_nml/ &
   310        & FilterParameter   !, IntStep
   311            !
   312            ! デフォルト値については初期化手続 "vertical_filter#VerticalFilterInit"
   313            ! のソースコードを参照のこと.
   314            !
   315            ! Refer to source codes in the initialization procedure
   316            ! "vertical_filter#VerticalFilterInit" for the default values.
   317            !
   318  
   319      ! 実行文 ; Executable statement
   320      !
   321  
   322      if ( vertical_filter_inited ) return
   323  
   324  
   325      ! デフォルト値の設定
   326      ! Default values settings
   327      !
   328      FilterParameter = 0.1_DP
   329  !!$    IntStep         = 1
   330  !!$    CurStep         = 0
   331  
   332      ! NAMELIST の読み込み
   333      ! NAMELIST is input
   334      !
   335      if ( trim(namelist_filename) /= '' ) then
   336        call FileOpen( unit_nml, &          ! (out)
   337          & namelist_filename, mode = 'r' ) ! (in)
   338  
   339        rewind( unit_nml )
   340        read( unit_nml, &                ! (in)
   341          & nml = vertical_filter_nml, &  ! (out)
   342          & iostat = iostat_nml )        ! (out)
   343        close( unit_nml )
   344  
   345        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   346        if ( iostat_nml == 0 ) write( STDOUT, nml = vertical_filter_nml )
   347      end if
   348  
   349  !!$    ! IntStep のチェック
   350  !!$    ! Check "IntStep"
   351  !!$    !
   352  !!$    if ( IntStep < 1 ) then
   353  !!$      call MessageNotify( 'E', module_name, &
   354  !!$        & 'IntStep=<%d> must be greater than 0', &
   355  !!$        & i = (/ IntStep /) )
   356  !!$    end if
   357  !!$
   358  !!$    ! PrevStep の設定
   359  !!$    ! Configure "PrevStep"
   360  !!$    !
   361  !!$    PrevStep = - IntStep
   362  
   363      ! 印字 ; Print
   364      !
   365      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   366      call MessageNotify( 'M', module_name, '  FilterParameter = %f', d = (/ FilterParameter /) )
   367  !!$    call MessageNotify( 'M', module_name, '  IntStep         = %d', i = (/ IntStep /) )
   368      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   369  
   370      vertical_filter_inited = .true.
   371  
   372    end subroutine VerticalFilterInit
   373  
   374    !--------------------------------------------------------------------------------------
   375  
   376  end module vertical_filter
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: vertical_filter.f90
PROGRAM NAME: vertical_filter
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 鉛直フィルター (Ishiwatari et al., 2002)
     2:             !
     3:             != Vertical filter (Ishiwatari et al., 2002)
     4:             !
     5:             ! Authors::   Satoshi Noda, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: vertical_filter.f90,v 1.2 2011/06/19 10:56:28 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module vertical_filter
    13:               !
    14:               != 鉛直フィルター (Ishiwatari et al., 2002)
    15:               !
    16:               != Vertical filter (Ishiwatari et al., 2002)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 鉛直モードを抑えるための鉛直フィルター (Ishiwatari et al., 2002)
    21:               ! を適用するためのモジュールです.
    22:               !
    23:               ! すなわち
    24:               ! \begin{align}
    25:               !   T_{B,k} &\equiv \frac{T_{k+1/2} + T_{k-1/2}}{2} \\
    26:               ! \end{align}
    27:               ! と定義した上で, 
    28:               ! \begin{align}
    29:               !   \bar{T}_{k-1} &= T_{k-1} + F_T
    30:               !     ( T_{B, k-1} - T_{k-1} )
    31:               !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
    32:               !   \bar{T}_{k} &= T_{k} + F_T
    33:               !     ( T_{B, k} - T_{k} )
    34:               !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
    35:               !   \bar{T}_{k+1} &= T_{k+1} + F_T
    36:               !     ( T_{B, k+1} - T_{k+1} )
    37:               !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}
    38:               ! \end{align}
    39:               ! という操作を下の層から順に適用することで $ \bar{T} $ を求めます. 
    40:               ! ここで添え字 $ k $ は層の番号です.
    41:               ! 鉛直フィルターが適用された項には上線 ( $ \bar{\quad} $ )
    42:               ! が付いています.
    43:               !
    44:               ! 鉛直フィルターの係数 $F_T$ は Create の際に設定します.
    45:               !
    46:               !++
    47:               !
    48:               ! Vertical filter (Ishiwatari et al., 2002) for suppression of vertical mode 
    49:               ! is applied.
    50:               !
    51:               ! Concretely, $ \bar{A}^{t} $ is derived as follows.
    52:               ! Reference Temperature is defined as
    53:               ! \begin{align}
    54:               !   T_{B,k} &\equiv \frac{T_{k+1/2} + T_{k-1/2}}{2}.
    55:               ! \end{align}
    56:               ! Operations as follows are applied from lower layer to higher layer.
    57:               ! \begin{align}
    58:               !   \bar{T}_{k-1} &= T_{k-1} + F_T
    59:               !     ( T_{B, k-1} - T_{k-1} )
    60:               !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
    61:               !   \bar{T}_{k} &= T_{k} + F_T
    62:               !     ( T_{B, k} - T_{k} )
    63:               !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
    64:               !   \bar{T}_{k+1} &= T_{k+1} + F_T
    65:               !     ( T_{B, k+1} - T_{k+1} )
    66:               !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}
    67:               ! \end{align}
    68:               ! where a suffix $ k $ is the number of layer.
    69:               ! Over-bar ( $ \bar{\quad} $ ) represents the terms
    70:               ! applied vertical filter.
    71:               !
    72:               ! Vertical filter coefficient $ F_T $ is specified by "Create".
    73:               !
    74:               !== Procedures List
    75:               ! 
    76:               ! VerticalFilter    :: 鉛直フィルターの適用
    77:               ! ----------------  :: ---------------------
    78:               ! VerticalFilter    :: Apply vertical filter
    79:               !
    80:               !== NAMELIST
    81:               !
    82:               ! NAMELIST#vertical_filter_nml
    83:               !
    84:               !== References
    85:               !
    86:               ! * Ishiwatari, M., Takehiro S., Nakajima, K. and Hayashi, Y. -Y. 2002: 
    87:               !   A Numerical Study on Appearance of the Runaway Greenhouse State of a
    88:               !   Three-Dimensional Gray Atmosphere.
    89:               !   <i>J. Atmos. Sci.</i>, <b>59</b>, 3223--3238.
    90:               !
    91:             
    92:               ! モジュール引用 ; USE statements
    93:               !
    94:             
    95:               ! 格子点設定
    96:               ! Grid points settings
    97:               !
    98:               use gridset, only: imax, & ! 経度格子点数. 
    99:                                          ! Number of grid points in longitude
   100:                 &                jmax, & ! 緯度格子点数. 
   101:                                          ! Number of grid points in latitude
   102:                 &                kmax    ! 鉛直層数. 
   103:                                          ! Number of vertical level
   104:             
   105:               use composition, only: ncmax  ! 微量成分の数
   106:                                             ! Number of composition
   107:             
   108:               ! 種別型パラメタ
   109:               ! Kind type parameter
   110:               !
   111:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
   112:                 &                 STRING     ! 文字列.       Strings. 
   113:             
   114:             
   115:               ! メッセージ出力
   116:               ! Message output
   117:               !
   118:               use dc_message, only: MessageNotify
   119:             
   120:               ! 宣言文 ; Declaration statements
   121:               !
   122:               implicit none
   123:               private
   124:             
   125:               ! 公開手続き
   126:               ! Public procedure
   127:               !
   128:               public:: VerticalFilter
   129:             
   130:               ! 公開変数
   131:               ! Public variables
   132:               !
   133:               logical, save, public:: vertical_filter_inited = .false.
   134:                                           ! 初期設定フラグ. 
   135:                                           ! Initialization flag
   136:             
   137:               ! 非公開変数
   138:               ! Private variables
   139:               !
   140:               real(DP), save:: FilterParameter
   141:                                           ! 鉛直フィルターの係数. 
   142:                                           ! Vertical filter coefficient
   143:             !!$  integer, save:: IntStep     ! 鉛直フィルターを適用するステップ間隔. 
   144:             !!$                              ! Step interval of vertical filter application
   145:             !!$  integer, save:: CurStep     ! VerticalFilter が呼ばれた回数. 
   146:             !!$                              ! Number of times that "VerticalFilter" is called
   147:             !!$  integer, save:: PrevStep    ! 前回鉛直フィルターを適用したステップ数. 
   148:             !!$                              ! Step number that is filtered previously
   149:             
   150:               character(*), parameter:: module_name = 'vertical_filter'
   151:                                           ! モジュールの名称. 
   152:                                           ! Module name
   153:               character(*), parameter:: version = &
   154:                 & '$Name:  $' // &
   155:                 & '$Id: vertical_filter.f90,v 1.2 2011/06/19 10:56:28 yot Exp $'
   156:                                           ! モジュールのバージョン
   157:                                           ! Module version
   158:             
   159:             contains
   160:             
   161:               !--------------------------------------------------------------------------------------
   162:             
   163:               subroutine VerticalFilter( &
   164:                 & xyz_UA, xyz_VA, xyz_TempA, &
   165:                 & xyr_Press, xyr_Temp &
   166:                 & )
   167:                 !
   168:                 ! 予報変数に鉛直フィルターを適用します. 
   169:                 !
   170:                 ! Vertical filter is applied to predictional variables.
   171:                 !
   172:             
   173:                 ! モジュール引用 ; USE statements
   174:                 !
   175:             
   176:                 ! 時刻管理
   177:                 ! Time control
   178:                 !
   179:                 use timeset, only: &
   180:                   & TimesetClockStart, TimesetClockStop
   181:             
   182:                 ! 宣言文 ; Declaration statements
   183:                 !
   184:                 implicit none
   185:             
   186:                 real(DP), intent(inout):: xyz_UA (0:imax-1, 1:jmax, 1:kmax)
   187:                                           ! $ u (t+\Delta t) $ .   東西風速. Eastward wind
   188:                 real(DP), intent(inout):: xyz_VA (0:imax-1, 1:jmax, 1:kmax)
   189:                                           ! $ v (t+\Delta t) $ .   南北風速. Northward wind
   190:                 real(DP), intent(inout):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
   191:                                           ! $ T (t+\Delta t) $ .   温度. Temperature
   192:             
   193:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   194:                                           ! $ p_{1/2} (t+\Delta t) $ .   気圧. Pressure
   195:                 real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
   196:                                           ! $ T_{1/2} (t+\Delta t) $ .   温度. Temperature
   197:             
   198:             
   199:                 ! 作業変数
   200:                 ! Work variables
   201:                 !
   202:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   203:                                           ! Work variables for DO loop in longitude
   204:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   205:                                           ! Work variables for DO loop in latitude
   206:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   207:                                           ! Work variables for DO loop in vertical direction
   208:                 integer:: k1              ! 鉛直方向に回る DO ループ用作業変数
   209:                                           ! Work variables for DO loop in vertical direction
   210:             
   211:                 real(DP):: Temp_ref(0:imax-1, 1:jmax, 1:kmax), &
   212:                   & Temp_corr(0:imax-1, 1:jmax)
   213:             
   214:                 ! 実行文 ; Executable statement
   215:                 !
   216:             
   217:                 ! 計算時間計測開始
   218:                 ! Start measurement of computation time
   219:                 !
   220:                 call TimesetClockStart( module_name )
   221:             
   222:                 ! 初期化
   223:                 ! Initialization
   224:                 !
   225:                 if ( .not. vertical_filter_inited ) call VerticalFilterInit
   226:             
   227:             !!$    ! ステップのチェック
   228:             !!$    ! Check Step
   229:             !!$    !
   230:             !!$    CurStep = CurStep + 1
   231:             !!$    if ( CurStep - PrevStep < IntStep ) return
   232:             !!$    PrevStep = CurStep
   233:             
   234:                 ! FilterParameter の有効性のチェック
   235:                 ! Check validity of "FilterParameter"
   236:                 !
   237:                 if ( FilterParameter == 0.0_DP ) return
   238:             
   239:                 ! 鉛直フィルターを適用
   240:                 ! Apply vertical filter
   241:                 !
   242:             
   243: W------>        do k=1,kmax
   244: |**==== A         Temp_ref(:,:,k)  = 0.5_DP * ( xyr_Temp(:,:,k-1) + xyr_Temp(:,:,k) )
   245: W------         end do
   246:             
   247: +------>        do k=2,kmax-1
   248: |W*==== A         Temp_corr = 0.0_DP
   249: |*----->          do k1=-1,1
   250: ||W*=== A           Temp_corr = Temp_corr + FilterParameter &
   251: ||                    & * ( Temp_ref(:,:,k+k1) - xyz_TempA(:,:,k+k1) ) &
   252: ||                    & * ( xyr_Press(:,:,k+k1-1) - xyr_Press(:,:,k+k1) )
   253: |*-----           end do
   254: |W*==== A         Temp_corr = Temp_corr / ( xyr_Press(:,:,k-2) - xyr_Press(:,:,k+1) )
   255: |*----->          do k1=-1,1
   256: ||W*=== A           xyz_TempA(:,:,k+k1) = xyz_TempA(:,:,k+k1) &
   257: ||                    & + FilterParameter * ( Temp_ref(:,:,k+k1) - xyz_TempA(:,:,k+k1) ) - Temp_corr
   258: |*-----           end do
   259: +------         end do
   260:             
   261:                 ! 計算時間計測一時停止
   262:                 ! Pause measurement of computation time
   263:                 !
   264:                 call TimesetClockStop( module_name )
   265:             
   266:               end subroutine VerticalFilter
   267:             
   268:               !--------------------------------------------------------------------------------------
   269:             
   270:               subroutine VerticalFilterInit
   271:                 !
   272:                 ! vertical_filter モジュールの初期化を行います. 
   273:                 ! NAMELIST#vertical_filter_nml の読み込みはこの手続きで行われます. 
   274:                 !
   275:                 ! "vertical_filter" module is initialized. 
   276:                 ! "NAMELIST#vertical_filter_nml" is loaded in this procedure. 
   277:                 !
   278:             
   279:                 ! モジュール引用 ; USE statements
   280:                 !
   281:             
   282:                 ! NAMELIST ファイル入力に関するユーティリティ
   283:                 ! Utilities for NAMELIST file input
   284:                 !
   285:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   286:             
   287:                 ! ファイル入出力補助
   288:                 ! File I/O support
   289:                 !
   290:                 use dc_iounit, only: FileOpen
   291:             
   292:                 ! 種別型パラメタ
   293:                 ! Kind type parameter
   294:                 !
   295:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   296:             
   297:                 ! 宣言文 ; Declaration statements
   298:                 !
   299:                 implicit none
   300:             
   301:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   302:                                           ! Unit number for NAMELIST file open
   303:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   304:                                           ! IOSTAT of NAMELIST read
   305:             
   306:                 ! NAMELIST 変数群
   307:                 ! NAMELIST group name
   308:                 !
   309:                 namelist /vertical_filter_nml/ &
   310:                   & FilterParameter   !, IntStep
   311:                       !
   312:                       ! デフォルト値については初期化手続 "vertical_filter#VerticalFilterInit" 
   313:                       ! のソースコードを参照のこと. 
   314:                       !
   315:                       ! Refer to source codes in the initialization procedure
   316:                       ! "vertical_filter#VerticalFilterInit" for the default values. 
   317:                       !
   318:             
   319:                 ! 実行文 ; Executable statement
   320:                 !
   321:             
   322:                 if ( vertical_filter_inited ) return
   323:             
   324:             
   325:                 ! デフォルト値の設定
   326:                 ! Default values settings
   327:                 !
   328:                 FilterParameter = 0.1_DP
   329:             !!$    IntStep         = 1
   330:             !!$    CurStep         = 0
   331:             
   332:                 ! NAMELIST の読み込み
   333:                 ! NAMELIST is input
   334:                 !
   335:                 if ( trim(namelist_filename) /= '' ) then
   336:                   call FileOpen( unit_nml, &          ! (out)
   337:                     & namelist_filename, mode = 'r' ) ! (in)
   338:             
   339:                   rewind( unit_nml )
   340:                   read( unit_nml, &                ! (in)
   341:                     & nml = vertical_filter_nml, &  ! (out)
   342:                     & iostat = iostat_nml )        ! (out)
   343:                   close( unit_nml )
   344:             
   345:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   346:                   if ( iostat_nml == 0 ) write( STDOUT, nml = vertical_filter_nml )
   347:                 end if
   348:             
   349:             !!$    ! IntStep のチェック
   350:             !!$    ! Check "IntStep"
   351:             !!$    !
   352:             !!$    if ( IntStep < 1 ) then
   353:             !!$      call MessageNotify( 'E', module_name, &
   354:             !!$        & 'IntStep=<%d> must be greater than 0', &
   355:             !!$        & i = (/ IntStep /) )
   356:             !!$    end if
   357:             !!$
   358:             !!$    ! PrevStep の設定
   359:             !!$    ! Configure "PrevStep"
   360:             !!$    !
   361:             !!$    PrevStep = - IntStep
   362:             
   363:                 ! 印字 ; Print
   364:                 !
   365:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   366:                 call MessageNotify( 'M', module_name, '  FilterParameter = %f', d = (/ FilterParameter /) )
   367:             !!$    call MessageNotify( 'M', module_name, '  IntStep         = %d', i = (/ IntStep /) )
   368:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   369:             
   370:                 vertical_filter_inited = .true.
   371:             
   372:               end subroutine VerticalFilterInit
   373:             
   374:               !--------------------------------------------------------------------------------------
   375:             
   376:             end module vertical_filter
