Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:31 2016
FILE NAME: i.vdiffusion_jma_my_wrapper.F90
PROGRAM NAME: vdiffusion_jma_my_wrapper
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   358  warn (  82): Name "r_qmixdiffcoef" is not used.
   358  warn (  82): Name "z_delheight" is not used.
   358  warn (  82): Name "z_delheightinv" is not used.
   358  warn (  82): Name "r_temp" is not used.
   358  warn (  82): Name "r_tempdiffcoef" is not used.
   358  warn (  83): Dummy argument "xyr_heatflux" is not used.
   358  warn (  83): Dummy argument "xyr_height" is not used.
   358  warn (  82): Name "z_qh2oliq" is not used.
   358  warn (  82): Name "z_qh2osol" is not used.
   358  warn (  82): Name "z_qh2ovap" is not used.
   358  warn (  82): Name "r_momfluxx" is not used.
   358  warn (  82): Name "r_momfluxy" is not used.
   358  warn (  83): Dummy argument "xyz_turkinene" is not used.
   358  warn (  83): Dummy argument "xyz_press" is not used.
   358  warn (  82): Name "z_height" is not used.
   358  warn (  82): Name "r_delheightinv" is not used.
   358  warn (  82): Name "i" is not used.
   358  warn (  83): Dummy argument "xyz_height" is not used.
   358  warn (  82): Name "z_temp" is not used.
   358  warn (  82): Name "j" is not used.
   358  warn (  83): Dummy argument "xy_surfheatflux" is not used.
   358  warn (  83): Dummy argument "xy_surfheight" is not used.
   358  warn (  83): Dummy argument "xy_surfmolength" is not used.
   358  warn (  83): Dummy argument "xy_surfmomfluxx" is not used.
   358  warn (  83): Dummy argument "xy_surfmomfluxy" is not used.
   358  warn (  82): Name "n" is not used.
   358  warn (  82): Name "r_height" is not used.
   358  warn (  82): Name "r_lowweightfactf2h" is not used.
   358  warn (  82): Name "r_lowweightfacth2f" is not used.
   358  warn (  83): Dummy argument "xyr_momfluxx" is not used.
   358  warn (  83): Dummy argument "xyr_momfluxy" is not used.
   358  warn (  83): Dummy argument "xyr_press" is not used.
   358  warn (  82): Name "r_uppweightfactf2h" is not used.
   358  warn (  82): Name "r_uppweightfacth2f" is not used.
   358  warn (  82): Name "surfmolengthinv" is not used.
   358  warn (  82): Name "surfmomflux" is not used.
   358  warn (  82): Name "surfmomfluxx" is not used.
   358  warn (  82): Name "surfmomfluxy" is not used.
   358  warn (  83): Dummy argument "xyr_qmixdiffcoef" is not used.
   358  warn (  82): Name "z_u" is not used.
   358  warn (  83): Dummy argument "xyr_exner" is not used.
   358  warn (  83): Dummy argument "xyz_u" is not used.
   358  warn (  82): Name "z_press" is not used.
   358  warn (  83): Dummy argument "xyz_v" is not used.
   358  warn (  82): Name "z_dturkinenedt" is not used.
   358  warn (  82): Name "z_tsqa" is not used.
   358  warn (  83): Dummy argument "xyr_virtemp" is not used.
   358  warn (  83): Dummy argument "xyzf_qmix" is not used.
   358  warn (  82): Name "z_exner" is not used.
   358  warn (  82): Name "z_tsq" is not used.
   358  warn (  82): Name "z_v" is not used.
   358  warn (  82): Name "r_virtemp" is not used.
   358  warn (  83): Dummy argument "xyz_dturkinenedt" is not used.
   358  warn (  82): Name "r_heatflux" is not used.
   358  warn (  82): Name "surfqvapflux" is not used.
   358  warn (  83): Dummy argument "xyz_temp" is not used.
   358  warn (  82): Name "r_veldiffcoef" is not used.
   358  warn (  82): Name "z_qsq" is not used.
   358  warn (  82): Name "z_qsqa" is not used.
   358  warn (  82): Name "r_rho" is not used.
   358  warn (  82): Name "r_press" is not used.
   358  warn (  83): Dummy argument "xyz_exner" is not used.
   358  warn (  82): Name "z_pottemp" is not used.
   358  warn (  82): Name "z_qke" is not used.
   358  warn (  82): Name "r_exner" is not used.
   358  warn (  83): Dummy argument "xyrf_qmixflux" is not used.
   358  warn (  83): Dummy argument "xyz_virtemp" is not used.
   358  warn (  82): Name "z_virtemp" is not used.
   358  warn (  83): Dummy argument "xyr_temp" is not used.
   358  warn (  83): Dummy argument "xyr_tempdiffcoef" is not used.
   358  warn (  82): Name "z_turkinene" is not used.
   358  warn (  82): Name "rf_qmixflux" is not used.
   358  warn (  83): Dummy argument "xyf_surfqmixflux" is not used.
   358  warn (  82): Name "z_cova" is not used.
   358  warn (  82): Name "surfheatflux" is not used.
   358  warn (  82): Name "surfheight" is not used.
   358  warn (  83): Dummy argument "xyr_veldiffcoef" is not used.
   358  warn (  82): Name "z_cov" is not used.
   358  warn (  82): Name "z_qcldice" is not used.
   358  warn (  82): Name "z_qcldwat" is not used.
   609  warn (  82): Name "timestep" is not used.
   609  warn (  82): Name "iostat_nml" is not used.
   609  warn (  82): Name "pressref" is not used.
   609  warn (  82): Name "unit_nml" is not used.
   609  warn (  82): Name "surfemis" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:31 2016
FILE NAME: i.vdiffusion_jma_my_wrapper.F90
PROGRAM NAME: vdiffusion_jma_my_wrapper
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != JMA 乱流混合モジュール
     2  !
     3  != JMA turbulent mixing module
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: vdiffusion_jma_my_wrapper.F90,v 1.2 2015/02/11 11:53:55 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module vdiffusion_jma_my_wrapper
    13    !
    14    != 鉛直拡散フラックス (Mellor and Yamada, 1974, 1982)
    15    !
    16    != Vertical diffusion flux (Mellor and Yamada, 1974, 1982)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 鉛直拡散フラックスを計算します.
    21    !
    22    ! Vertical diffusion flux is calculated.
    23    !
    24    !== Procedures List
    25    !
    26    ! VDiffusion       :: 鉛直拡散フラックスの計算
    27    ! VDiffusionOutPut :: フラックスの出力
    28    ! ------------     :: ------------
    29    ! VDiffusion       :: Calculate vertical diffusion fluxes
    30    ! VDiffusionOutPut :: Output fluxes
    31    !
    32    !== NAMELIST
    33    !
    34    ! NAMELIST#vdiffusion_my_nml
    35    !
    36  
    37    ! モジュール引用 ; USE statements
    38    !
    39    !== References
    40    !
    41    ! * Mellor, G. L., and T. Yamada, 1974:
    42    !   A hierarchy of turbulence closure models for
    43    !   planetary boundary layers.
    44    !   <i>J. Atmos. Sci.</i>, <b>31</b>, 1791--1806.
    45    ! * Mellor, G. L., and T. Yamada, 1982:
    46    !   Development of a turbulence closure model for geophysical fluid problems,
    47    !   <i>Rev. Geophys. Space Phys.</i>, <b>20</b>, 851--875.
    48    ! * Galperin, B., L. H. Kantha, S. Hassid, and T. Rosati, 1988:
    49    !   A quasi-equilibrium turbulent energy model for geophysical flows,
    50    !   <i>J. Atmos. Sci.</i>, <b>45</b>, 55--62.
    51  
    52    ! 格子点設定
    53    ! Grid points settings
    54    !
    55    use gridset, only: imax, & ! 経度格子点数.
    56                               ! Number of grid points in longitude
    57      &                jmax, & ! 緯度格子点数.
    58                               ! Number of grid points in latitude
    59      &                kmax    ! 鉛直層数.
    60                               ! Number of vertical level
    61  
    62    ! 組成に関わる配列の設定
    63    ! Settings of array for atmospheric composition
    64    !
    65    use composition, only: ncmax, IndexH2OVap, IndexH2OLiq, IndexH2OSol
    66  
    67    ! 種別型パラメタ
    68    ! Kind type parameter
    69    !
    70    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    71      &                 STRING     ! 文字列.       Strings.
    72  
    73    ! メッセージ出力
    74    ! Message output
    75    !
    76    use dc_message, only: MessageNotify
    77  
    78    ! 宣言文 ; Declaration statements
    79    !
    80    implicit none
    81    private
    82  
    83    ! 公開手続き
    84    ! Public procedure
    85    !
    86    public :: VDiffusionJMAMYWrapper3D
    87    public :: VDiffusionJMAInit
    88  
    89    ! 公開変数
    90    ! Public variables
    91    !
    92  
    93    ! 非公開変数
    94    ! Private variables
    95    !
    96    logical, save :: vdiffusion_jma_my_wrap_inited = .false.
    97                                ! 初期設定フラグ.
    98                                ! Initialization flag
    99  
   100    integer, save :: LevelNum
   101  
   102  
   103    character(*), parameter:: module_name = 'vdiffusion_jma_my_wrapper'
   104                                ! モジュールの名称.
   105                                ! Module name
   106    character(*), parameter:: version = &
   107      & '$Name:  $' // &
   108      & '$Id: vdiffusion_jma_my_wrapper.F90,v 1.2 2015/02/11 11:53:55 yot Exp $'
   109                                ! モジュールのバージョン
   110                                ! Module version
   111  
   112  contains
   113  
   114    !--------------------------------------------------------------------------------------
   115  
   116    subroutine VDiffusionJMAMYWrapper3D(                          &
   117      & xyz_U, xyz_V, xyzf_QMix,                                   & ! (in)
   118      & xyz_Temp, xyr_Temp, xyz_VirTemp, xyr_VirTemp, &
   119      & xyz_Press, xyr_Press,   & ! (in)
   120      & xy_SurfHeight,                                             & ! (in)
   121      & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner,              & ! (in)
   122      & xy_SurfMOLength,                                           & ! (in)
   123      & xyz_TurKinEne,                                             & ! (in)
   124      & xy_SurfMomFluxX, xy_SurfMomFluxY,                          & ! (in)
   125      & xy_SurfHeatFlux, xyf_SurfQMixFlux,                         & ! (in)
   126      & xyr_MomFluxX,  xyr_MomFluxY,  xyr_HeatFlux, xyrf_QMixFlux, & ! (out)
   127      & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,       & ! (in)
   128      & xyz_DTurKinEneDt                                           & ! (out)
   129      & )
   130      !
   131      ! 鉛直拡散フラックスを計算します.
   132      !
   133      ! Vertical diffusion flux is calculated by use of MY2.5 model.
   134      !
   135  
   136      ! モジュール引用 ; USE statements
   137      !
   138  
   139      ! 物理定数設定
   140      ! Physical constants settings
   141      !
   142      use constants, only: &
   143        & GasRDry, &
   144                                ! $ R $ [J kg-1 K-1].
   145                                ! 乾燥大気の気体定数.
   146                                ! Gas constant of air
   147        & CpDry
   148                                ! $ C_p $ [J kg-1 K-1].
   149                                ! 乾燥大気の定圧比熱.
   150                                ! Specific heat of air at constant pressure
   151  
   152      ! 時刻管理
   153      ! Time control
   154      !
   155      use timeset, only: &
   156        & DelTime, &            ! $ \Delta t $ [s]
   157        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   158        & TimesetClockStart, TimesetClockStop
   159  
   160      ! ヒストリデータ出力
   161      ! History data output
   162      !
   163      use gtool_historyauto, only: HistoryAutoPut
   164  
   165  
   166  
   167      ! 宣言文 ; Declaration statements
   168      !
   169      implicit none
   170  
   171      real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   172                                ! $ u $ .   東西風速. Eastward wind
   173      real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   174                                ! $ v $ .   南北風速. Northward wind
   175      real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   176                                ! $ q $ .   質量混合比. Mass mixing ratio
   177      real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   178                                ! $ T $ .   温度. Temperature
   179      real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
   180                                ! $ \hat{T} $ . 温度 (半整数レベル).
   181                                ! Temperature (half level)
   182      real(DP), intent(in):: xyz_VirTemp (0:imax-1, 1:jmax, 1:kmax)
   183                                ! $ T_v $ .   仮温度. Virtual temperature
   184      real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   185                                ! $ \hat{T}_v $ . 仮温度 (半整数レベル).
   186                                ! Virtual temperature (half level)
   187      real(DP), intent(in):: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   188                                ! $ p $ . 気圧 (整数レベル).
   189                                ! Air pressure (full level)
   190      real(DP), intent(in):: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
   191                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   192                                ! Air pressure (half level)
   193      real(DP), intent(in):: xy_SurfHeight (0:imax-1,1:jmax)
   194                                ! $ z_s $ . 地表面高度.
   195                                ! Surface height.
   196      real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   197                                ! 高度 (整数レベル).
   198                                ! Height (full level)
   199      real(DP), intent(in):: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
   200                                ! 高度 (半整数レベル).
   201                                ! Height (half level)
   202      real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   203                                ! Exner 関数 (整数レベル).
   204                                ! Exner function (full level)
   205      real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   206                                ! Exner 関数 (半整数レベル).
   207                                ! Exner function (half level)
   208  
   209      real(DP), intent(in):: xy_SurfMOLength(0:imax-1, 1:jmax)
   210                                !
   211                                ! Turbulent kinetic energy (m2 s-2)
   212  
   213      real(DP), intent(in):: xyz_TurKinEne(0:imax-1, 1:jmax, 1:kmax)
   214                                !
   215                                ! Turbulent kinetic energy (m2 s-2)
   216      real(DP), intent(in):: xy_SurfMomFluxX (0:imax-1, 1:jmax)
   217                                !
   218                                ! Eastward momentum flux at surface
   219      real(DP), intent(in):: xy_SurfMomFluxY (0:imax-1, 1:jmax)
   220                                !
   221                                ! Northward momentum flux at surface
   222      real(DP), intent(in):: xy_SurfHeatFlux (0:imax-1, 1:jmax)
   223      real(DP), intent(in):: xyf_SurfQMixFlux(0:imax-1, 1:jmax, 1:ncmax)
   224  
   225      real(DP), intent(out):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
   226                                ! 東西方向運動量フラックス.
   227                                ! Eastward momentum flux
   228      real(DP), intent(out):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
   229                                ! 南北方向運動量フラックス.
   230                                ! Northward momentum flux
   231      real(DP), intent(out):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   232                                ! 熱フラックス.
   233                                ! Heat flux
   234      real(DP), intent(out):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   235                                ! 質量フラックス.
   236                                ! Mass flux of compositions
   237      real(DP), intent(out):: xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   238                                ! 拡散係数：運動量.
   239                                ! Diffusion coefficient: velocity
   240      real(DP), intent(out):: xyr_TempDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   241                                ! 拡散係数：温度.
   242                                ! Diffusion coefficient: temperature
   243      real(DP), intent(out):: xyr_QMixDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   244                                ! 拡散係数：比湿.
   245                                ! Diffusion coefficient: specific humidity
   246      real(DP), intent(out):: xyz_DTurKinEneDt (0:imax-1, 1:jmax, 1:kmax)
   247                                !
   248                                ! Tendency of turbulent kinetic energy
   249  
   250      ! 作業変数
   251      ! Work variables
   252      !
   253      real(DP) :: z_U (1:kmax)
   254      real(DP) :: z_V (1:kmax)
   255      real(DP) :: z_QH2OVap(1:kmax)
   256      real(DP) :: z_QH2OLiq(1:kmax)
   257      real(DP) :: z_QH2OSol(1:kmax)
   258      real(DP) :: z_Temp (1:kmax)
   259      real(DP) :: r_Temp (0:kmax)
   260      real(DP) :: z_VirTemp (1:kmax)
   261      real(DP) :: r_VirTemp (0:kmax)
   262      real(DP) :: z_Press  (1:kmax)
   263      real(DP) :: r_Press  (0:kmax)
   264      real(DP) :: SurfHeight
   265      real(DP) :: z_Height (1:kmax)
   266      real(DP) :: r_Height (0:kmax)
   267      real(DP) :: z_Exner (1:kmax)
   268      real(DP) :: r_Exner (0:kmax)
   269      real(DP) :: z_PotTemp(1:kmax)
   270      real(DP) :: z_QCldWat(1:kmax)
   271      real(DP) :: z_QCldIce(1:kmax)
   272      real(DP) :: z_TurKinEne(1:kmax)
   273      real(DP) :: SurfMomFluxX
   274      real(DP) :: SurfMomFluxY
   275      real(DP) :: SurfMomFlux
   276      real(DP) :: SurfHeatFlux
   277      real(DP) :: SurfQVapFlux
   278      real(DP) :: r_MomFluxX (0:kmax)
   279      real(DP) :: r_MomFluxY (0:kmax)
   280      real(DP) :: r_HeatFlux (0:kmax)
   281      real(DP) :: rf_QMixFlux(0:kmax, 1:ncmax)
   282      real(DP) :: r_VelDiffCoef (0:kmax)
   283      real(DP) :: r_TempDiffCoef(0:kmax)
   284      real(DP) :: r_QMixDiffCoef(0:kmax)
   285      real(DP) :: z_DTurKinEneDt (1:kmax)
   286                                !
   287                                ! Tendency of turbulent kinetic energy
   288  
   289      real(DP) :: r_Rho(0:kmax)
   290      real(DP) :: SurfMOLengthInv
   291  
   292      real(DP) :: z_DelHeight   (1:kmax-1)
   293      real(DP) :: z_DelHeightInv(1:kmax)
   294      real(DP) :: r_DelHeightInv(1:kmax-1)
   295  
   296      real(DP) :: r_LowWeightFactF2H(1:kmax-1)
   297      real(DP) :: r_UppWeightFactF2H(1:kmax-1)
   298      real(DP) :: r_LowWeightFactH2F(1:kmax-1)
   299      real(DP) :: r_UppWeightFactH2F(1:kmax-1)
   300  
   301      real(DP) :: z_QKE (1:kmax)
   302      real(DP) :: z_TSq (1:kmax)
   303      real(DP) :: z_QSq (1:kmax)
   304      real(DP) :: z_Cov (1:kmax)
   305      real(DP) :: z_TSqA(1:kmax)
   306      real(DP) :: z_QSqA(1:kmax)
   307      real(DP) :: z_CovA(1:kmax)
   308  
   309      integer:: i               ! 経度方向に回る DO ループ用作業変数
   310                                ! Work variables for DO loop in longitude
   311      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   312                                ! Work variables for DO loop in latitude
   313      integer:: n
   314  
   315  
   316      ! 実行文 ; Executable statement
   317      !
   318  
   319      ! 初期化確認
   320      ! Initialization check
   321      !
   322      if ( .not. vdiffusion_jma_my_wrap_inited ) then
   323        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   324      end if
   325  
   326  
   327  
   328  
   329      call MessageNotify( 'E', module_name, 'JMA MY library is not included.' )
   330  
   331  
   332  
   333  
   334      ! 拡散係数の出力
   335      ! Output diffusion coefficients
   336      !
   337  
   338      ! 拡散係数出力
   339      ! Diffusion coeffficients output
   340      !
   341  !!$    call HistoryAutoPut( TimeN, 'VelDiffCoef',  xyr_VelDiffCoef  )
   342  !!$    call HistoryAutoPut( TimeN, 'TempDiffCoef', xyr_TempDiffCoef )
   343  !!$    call HistoryAutoPut( TimeN, 'QVapDiffCoef', xyr_QMixDiffCoef )
   344  !!$
   345  !!$    call HistoryAutoPut( TimeN, 'TKEPShear', xyz_TurKinEneProShear )
   346  !!$    call HistoryAutoPut( TimeN, 'TKEPBuoy' , xyz_TurKinEneProBuoya )
   347  !!$    call HistoryAutoPut( TimeN, 'TKEDiss'  , xyz_TurKinEneDiss     )
   348  !!$
   349  !!$    call HistoryAutoPut( TimeN, 'MixLength' , xyz_MixLength )
   350  
   351  
   352  
   353      ! 計算時間計測一時停止
   354      ! Pause measurement of computation time
   355      !
   356      call TimesetClockStop( module_name )
   357  
   358    end subroutine VDiffusionJMAMYWrapper3D
   359  
   360    !--------------------------------------------------------------------------------------
   361  
   362    subroutine VDiffusionJMAInit
   363      !
   364      ! vdiffusion_my モジュールの初期化を行います.
   365      ! NAMELIST#vdiffusion_my_nml の読み込みはこの手続きで行われます.
   366      !
   367      ! "vdiffusion_my" module is initialized.
   368      ! "NAMELIST#vdiffusion_my_nml" is loaded in this procedure.
   369      !
   370  
   371      ! モジュール引用 ; USE statements
   372      !
   373  
   374      ! NAMELIST ファイル入力に関するユーティリティ
   375      ! Utilities for NAMELIST file input
   376      !
   377      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   378  
   379      ! ファイル入出力補助
   380      ! File I/O support
   381      !
   382      use dc_iounit, only: FileOpen
   383  
   384      ! 種別型パラメタ
   385      ! Kind type parameter
   386      !
   387      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   388  
   389      ! 文字列操作
   390      ! Character handling
   391      !
   392      use dc_string, only: StoA
   393  
   394      ! 時刻管理
   395      ! Time control
   396      !
   397      use timeset, only: &
   398        & DelTime            ! $ \Delta t $ [s]
   399  
   400      ! ヒストリデータ出力
   401      ! History data output
   402      !
   403      use gtool_historyauto, only: HistoryAutoAddVariable
   404  
   405      ! 補助的な変数を計算するサブルーチン・関数群
   406      ! Subroutines and functions for calculating auxiliary variables
   407      !
   408      use auxiliary, only : &
   409        & RefPressForPotTemp => RefPress, &
   410                                ! 基準気圧.
   411                                ! Reference air pressure
   412        & AuxVarsInit
   413  
   414  
   415  
   416      ! 座標データ設定
   417      ! Axes data settings
   418      !
   419      use axesset, only: &
   420        & AxnameX, &
   421        & AxnameY, &
   422        & AxnameZ, &
   423        & AxnameR, &
   424        & AxnameT
   425  
   426      ! 宣言文 ; Declaration statements
   427      !
   428      implicit none
   429  
   430      real(DP) :: PressRef
   431      real(DP) :: TimeStep
   432      real(DP) :: SurfEmis
   433  
   434      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   435                                ! Unit number for NAMELIST file open
   436      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   437                                ! IOSTAT of NAMELIST read
   438  
   439      ! NAMELIST 変数群
   440      ! NAMELIST group name
   441      !
   442  !!$    namelist /vdiffusion_my_nml/        &
   443  !!$      & FlagConstDiffCoef,              &
   444  !!$      & ConstDiffCoefM, ConstDiffCoefH, &
   445  !!$!
   446  !!$      & SquareVelMin, BulkRiNumMin,     &
   447  !!$!
   448  !!$      & MixLengthMax, ShMin, SmMin,      &
   449  !!$      & VelDiffCoefMin, TempDiffCoefMin, &
   450  !!$      & VelDiffCoefMax, TempDiffCoefMax, &
   451  !!$!
   452  !!$      & MYConstA1, MYConstB1, MYConstA2, MYConstB2, MYConstC1
   453            !
   454            ! デフォルト値については初期化手続 "vdiffusion_my#VDiffInit"
   455            ! のソースコードを参照のこと.
   456            !
   457            ! Refer to source codes in the initialization procedure
   458            ! "vdiffusion_my#VDiffInit" for the default values.
   459            !
   460  
   461      ! 実行文 ; Executable statement
   462      !
   463  
   464      if ( vdiffusion_jma_my_wrap_inited ) return
   465  
   466  
   467      ! デフォルト値の設定
   468      ! Default values settings
   469      !
   470  !!$    FlagConstDiffCoef = .false.
   471  !!$    ConstDiffCoefM    = 0.0_DP
   472  !!$    ConstDiffCoefH    = 0.0_DP
   473  !!$
   474  !!$    SquareVelMin    =     0.1_DP
   475  !!$    BulkRiNumMin    = - 100.0_DP
   476  !!$
   477  !!$    MixLengthMax    = 300.0_DP
   478  !!$    ShMin           =   0.0_DP
   479  !!$    SmMin           =   0.0_DP
   480  !!$    VelDiffCoefMin  =   0.1_DP
   481  !!$    TempDiffCoefMin =   0.1_DP
   482  !!$    VelDiffCoefMax  = 10000.0_DP
   483  !!$    TempDiffCoefMax = 10000.0_DP
   484  !!$
   485  !!$    ! Parameters proposed by Mellor and Yamada (1982).
   486  !!$    !
   487  !!$    MYConstA1 =  0.92_DP
   488  !!$    MYConstB1 = 16.6_DP
   489  !!$    MYConstA2 =  0.74_DP
   490  !!$    MYConstB2 = 10.1_DP
   491  !!$    MYConstC1 =  0.08_DP
   492  
   493  
   494      ! NAMELIST の読み込み
   495      ! NAMELIST is input
   496      !
   497  !!$    if ( trim(namelist_filename) /= '' ) then
   498  !!$      call FileOpen( unit_nml, &          ! (out)
   499  !!$        & namelist_filename, mode = 'r' ) ! (in)
   500  !!$
   501  !!$      rewind( unit_nml )
   502  !!$      read( unit_nml, &                   ! (in)
   503  !!$        & nml = vdiffusion_my_nml,     &  ! (out)
   504  !!$        & iostat = iostat_nml )           ! (out)
   505  !!$      close( unit_nml )
   506  !!$
   507  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   508  !!$      if ( iostat_nml == 0 ) write( STDOUT, nml = vdiffusion_my_nml )
   509  !!$    end if
   510  
   511  
   512      ! 補助的な変数を計算するサブルーチン・関数群
   513      ! Subroutines and functions for calculating auxiliary variables
   514      !
   515      call AuxVarsInit
   516  
   517  
   518  
   519  
   520      call MessageNotify( 'E', module_name, 'JMA MY library is not included.' )
   521  
   522  
   523  
   524  
   525      ! ヒストリデータ出力のためのへの変数登録
   526      ! Register of variables for history data output
   527      !
   528  !!$    call HistoryAutoAddVariable( 'VelDiffCoef', &
   529  !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   530  !!$      & 'diffusion coef. momentum', 'm2 s-1' )
   531  !!$    call HistoryAutoAddVariable( 'TempDiffCoef', &
   532  !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   533  !!$      & 'diffusion coef. heat    ', 'm2 s-1' )
   534  !!$    call HistoryAutoAddVariable( 'QVapDiffCoef', &
   535  !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   536  !!$      & 'diffusion coef. moisture', 'm2 s-1' )
   537  !!$
   538  !!$    call HistoryAutoAddVariable( 'MomFluxX', &
   539  !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   540  !!$      & 'eastward momentum flux', 'N m-2' )
   541  !!$    call HistoryAutoAddVariable( 'MomFluxY', &
   542  !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   543  !!$      & 'northward momentum flux', 'N m-2' )
   544  !!$    call HistoryAutoAddVariable( 'HeatFlux', &
   545  !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   546  !!$      & 'heat flux', 'W m-2' )
   547  !!$    call HistoryAutoAddVariable( 'QVapFlux', &
   548  !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   549  !!$      & 'moisture flux', 'W m-2' )
   550  !!$
   551  !!$    call HistoryAutoAddVariable( 'DUDtVDiff', &
   552  !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   553  !!$      & 'tendency of zonal wind by vertical diffusion', 'm s-2' )
   554  !!$    call HistoryAutoAddVariable( 'DVDtVDiff', &
   555  !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   556  !!$      & 'tendency of meridional wind by vertical diffusion', 'm s-2' )
   557  !!$    call HistoryAutoAddVariable( 'DTempDtVDiff', &
   558  !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   559  !!$      & 'tendency of temperature by vertical diffusion', 'K s-1' )
   560  !!$    call HistoryAutoAddVariable( 'DQVapDtVDiff', &
   561  !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   562  !!$      & 'tendency of specific humidity by vertical diffusion', 's-1' )
   563  !!$
   564  !!$    call HistoryAutoAddVariable( 'TurKinEne', &
   565  !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   566  !!$      & 'turbulent kinetic energy', 'm2 s-2' )
   567  !!$
   568  !!$    call HistoryAutoAddVariable( 'TKEPShear',  &
   569  !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   570  !!$      & 'turbulent kinetic energy production rate by shear', 'm2 s-3' )
   571  !!$    call HistoryAutoAddVariable( 'TKEPBuoy',   &
   572  !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   573  !!$      & 'turbulent kinetic energy production rate by buoyancy', 'm2 s-3' )
   574  !!$    call HistoryAutoAddVariable( 'TKEDiss',    &
   575  !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   576  !!$      & 'turbulent kinetic energy dissipation rate', 'm2 s-3' )
   577  !!$    call HistoryAutoAddVariable( 'MixLength',  &
   578  !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   579  !!$      & 'mixing length', 'm' )
   580  
   581      ! 印字 ; Print
   582      !
   583      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   584  
   585      call MessageNotify( 'M', module_name, '  %d is specified.', i = (/ LevelNum /) )
   586  !!$    call MessageNotify( 'M', module_name, 'For vertical diffusion flux:' )
   587  !!$    call MessageNotify( 'M', module_name, '  FlagConstDiffCoef = %b', l = (/ FlagConstDiffCoef /) )
   588  !!$    call MessageNotify( 'M', module_name, '  ConstDiffCoefM    = %f', d = (/ ConstDiffCoefM /) )
   589  !!$    call MessageNotify( 'M', module_name, '  ConstDiffCoefH    = %f', d = (/ ConstDiffCoefH /) )
   590  !!$    call MessageNotify( 'M', module_name, '  SquareVelMin = %f', d = (/ SquareVelMin /) )
   591  !!$    call MessageNotify( 'M', module_name, '  BulkRiNumMin = %f', d = (/ BulkRiNumMin /) )
   592  !!$    call MessageNotify( 'M', module_name, 'For diffusion coefficients:' )
   593  !!$    call MessageNotify( 'M', module_name, '  MixLengthMax      = %f', d = (/ MixLengthMax     /) )
   594  !!$    call MessageNotify( 'M', module_name, '  ShMin             = %f', d = (/ ShMin       /) )
   595  !!$    call MessageNotify( 'M', module_name, '  SmMin             = %f', d = (/ SmMin       /) )
   596  !!$    call MessageNotify( 'M', module_name, '  VelDiffCoefMin    = %f', d = (/ VelDiffCoefMin  /) )
   597  !!$    call MessageNotify( 'M', module_name, '  TempDiffCoefMin   = %f', d = (/ TempDiffCoefMin /) )
   598  !!$    call MessageNotify( 'M', module_name, '  VelDiffCoefMax    = %f', d = (/ VelDiffCoefMax  /) )
   599  !!$    call MessageNotify( 'M', module_name, '  TempDiffCoefMax   = %f', d = (/ TempDiffCoefMax /) )
   600  !!$    call MessageNotify( 'M', module_name, '  MYConstA1         = %f', d = (/ MYConstA1     /) )
   601  !!$    call MessageNotify( 'M', module_name, '  MYConstB1         = %f', d = (/ MYConstB1     /) )
   602  !!$    call MessageNotify( 'M', module_name, '  MYConstA2         = %f', d = (/ MYConstA2     /) )
   603  !!$    call MessageNotify( 'M', module_name, '  MYConstB2         = %f', d = (/ MYConstB2     /) )
   604  !!$    call MessageNotify( 'M', module_name, '  MYConstC1         = %f', d = (/ MYConstC1     /) )
   605      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   606  
   607      vdiffusion_jma_my_wrap_inited = .true.
   608  
   609    end subroutine VDiffusionJMAInit
   610  
   611    !--------------------------------------------------------------------------------------
   612  
   613  end module vdiffusion_jma_my_wrapper
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:31 2016
FILE NAME: i.vdiffusion_jma_my_wrapper.F90
PROGRAM NAME: vdiffusion_jma_my_wrapper
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != JMA 乱流混合モジュール
     2:             !
     3:             != JMA turbulent mixing module
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: vdiffusion_jma_my_wrapper.F90,v 1.2 2015/02/11 11:53:55 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module vdiffusion_jma_my_wrapper
    13:               !
    14:               != 鉛直拡散フラックス (Mellor and Yamada, 1974, 1982)
    15:               !
    16:               != Vertical diffusion flux (Mellor and Yamada, 1974, 1982)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 鉛直拡散フラックスを計算します. 
    21:               !
    22:               ! Vertical diffusion flux is calculated. 
    23:               !
    24:               !== Procedures List
    25:               ! 
    26:               ! VDiffusion       :: 鉛直拡散フラックスの計算
    27:               ! VDiffusionOutPut :: フラックスの出力
    28:               ! ------------     :: ------------
    29:               ! VDiffusion       :: Calculate vertical diffusion fluxes
    30:               ! VDiffusionOutPut :: Output fluxes
    31:               !
    32:               !== NAMELIST
    33:               !
    34:               ! NAMELIST#vdiffusion_my_nml
    35:               !
    36:             
    37:               ! モジュール引用 ; USE statements
    38:               !
    39:               !== References
    40:               !
    41:               ! * Mellor, G. L., and T. Yamada, 1974: 
    42:               !   A hierarchy of turbulence closure models for 
    43:               !   planetary boundary layers. 
    44:               !   <i>J. Atmos. Sci.</i>, <b>31</b>, 1791--1806.
    45:               ! * Mellor, G. L., and T. Yamada, 1982: 
    46:               !   Development of a turbulence closure model for geophysical fluid problems,
    47:               !   <i>Rev. Geophys. Space Phys.</i>, <b>20</b>, 851--875.
    48:               ! * Galperin, B., L. H. Kantha, S. Hassid, and T. Rosati, 1988:
    49:               !   A quasi-equilibrium turbulent energy model for geophysical flows,
    50:               !   <i>J. Atmos. Sci.</i>, <b>45</b>, 55--62.
    51:             
    52:               ! 格子点設定
    53:               ! Grid points settings
    54:               !
    55:               use gridset, only: imax, & ! 経度格子点数. 
    56:                                          ! Number of grid points in longitude
    57:                 &                jmax, & ! 緯度格子点数. 
    58:                                          ! Number of grid points in latitude
    59:                 &                kmax    ! 鉛直層数. 
    60:                                          ! Number of vertical level
    61:             
    62:               ! 組成に関わる配列の設定
    63:               ! Settings of array for atmospheric composition
    64:               !
    65:               use composition, only: ncmax, IndexH2OVap, IndexH2OLiq, IndexH2OSol
    66:             
    67:               ! 種別型パラメタ
    68:               ! Kind type parameter
    69:               !
    70:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    71:                 &                 STRING     ! 文字列.       Strings. 
    72:             
    73:               ! メッセージ出力
    74:               ! Message output
    75:               !
    76:               use dc_message, only: MessageNotify
    77:             
    78:               ! 宣言文 ; Declaration statements
    79:               !
    80:               implicit none
    81:               private
    82:             
    83:               ! 公開手続き
    84:               ! Public procedure
    85:               !
    86:               public :: VDiffusionJMAMYWrapper3D
    87:               public :: VDiffusionJMAInit
    88:             
    89:               ! 公開変数
    90:               ! Public variables
    91:               !
    92:             
    93:               ! 非公開変数
    94:               ! Private variables
    95:               !
    96:               logical, save :: vdiffusion_jma_my_wrap_inited = .false.
    97:                                           ! 初期設定フラグ. 
    98:                                           ! Initialization flag
    99:             
   100:               integer, save :: LevelNum
   101:             
   102:             
   103:               character(*), parameter:: module_name = 'vdiffusion_jma_my_wrapper'
   104:                                           ! モジュールの名称. 
   105:                                           ! Module name
   106:               character(*), parameter:: version = &
   107:                 & '$Name:  $' // &
   108:                 & '$Id: vdiffusion_jma_my_wrapper.F90,v 1.2 2015/02/11 11:53:55 yot Exp $'
   109:                                           ! モジュールのバージョン
   110:                                           ! Module version
   111:             
   112:             contains
   113:             
   114:               !--------------------------------------------------------------------------------------
   115:             
   116:               subroutine VDiffusionJMAMYWrapper3D(                          &
   117:                 & xyz_U, xyz_V, xyzf_QMix,                                   & ! (in)
   118:                 & xyz_Temp, xyr_Temp, xyz_VirTemp, xyr_VirTemp, &
   119:                 & xyz_Press, xyr_Press,   & ! (in)
   120:                 & xy_SurfHeight,                                             & ! (in)
   121:                 & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner,              & ! (in)
   122:                 & xy_SurfMOLength,                                           & ! (in)
   123:                 & xyz_TurKinEne,                                             & ! (in)
   124:                 & xy_SurfMomFluxX, xy_SurfMomFluxY,                          & ! (in)
   125:                 & xy_SurfHeatFlux, xyf_SurfQMixFlux,                         & ! (in)
   126:                 & xyr_MomFluxX,  xyr_MomFluxY,  xyr_HeatFlux, xyrf_QMixFlux, & ! (out)
   127:                 & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef,       & ! (in)
   128:                 & xyz_DTurKinEneDt                                           & ! (out)
   129:                 & )
   130:                 !
   131:                 ! 鉛直拡散フラックスを計算します. 
   132:                 !
   133:                 ! Vertical diffusion flux is calculated by use of MY2.5 model.
   134:                 !
   135:             
   136:                 ! モジュール引用 ; USE statements
   137:                 !
   138:             
   139:                 ! 物理定数設定
   140:                 ! Physical constants settings
   141:                 !
   142:                 use constants, only: &
   143:                   & GasRDry, &
   144:                                           ! $ R $ [J kg-1 K-1].
   145:                                           ! 乾燥大気の気体定数.
   146:                                           ! Gas constant of air
   147:                   & CpDry
   148:                                           ! $ C_p $ [J kg-1 K-1].
   149:                                           ! 乾燥大気の定圧比熱.
   150:                                           ! Specific heat of air at constant pressure
   151:             
   152:                 ! 時刻管理
   153:                 ! Time control
   154:                 !
   155:                 use timeset, only: &
   156:                   & DelTime, &            ! $ \Delta t $ [s]
   157:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   158:                   & TimesetClockStart, TimesetClockStop
   159:             
   160:                 ! ヒストリデータ出力
   161:                 ! History data output
   162:                 !
   163:                 use gtool_historyauto, only: HistoryAutoPut
   164:             
   165:             
   166:             
   167:                 ! 宣言文 ; Declaration statements
   168:                 !
   169:                 implicit none
   170:             
   171:                 real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
   172:                                           ! $ u $ .   東西風速. Eastward wind
   173:                 real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
   174:                                           ! $ v $ .   南北風速. Northward wind
   175:                 real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   176:                                           ! $ q $ .   質量混合比. Mass mixing ratio
   177:                 real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   178:                                           ! $ T $ .   温度. Temperature
   179:                 real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
   180:                                           ! $ \hat{T} $ . 温度 (半整数レベル). 
   181:                                           ! Temperature (half level)
   182:                 real(DP), intent(in):: xyz_VirTemp (0:imax-1, 1:jmax, 1:kmax)
   183:                                           ! $ T_v $ .   仮温度. Virtual temperature
   184:                 real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
   185:                                           ! $ \hat{T}_v $ . 仮温度 (半整数レベル). 
   186:                                           ! Virtual temperature (half level)
   187:                 real(DP), intent(in):: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   188:                                           ! $ p $ . 気圧 (整数レベル). 
   189:                                           ! Air pressure (full level)
   190:                 real(DP), intent(in):: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
   191:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   192:                                           ! Air pressure (half level)
   193:                 real(DP), intent(in):: xy_SurfHeight (0:imax-1,1:jmax)
   194:                                           ! $ z_s $ . 地表面高度. 
   195:                                           ! Surface height. 
   196:                 real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
   197:                                           ! 高度 (整数レベル). 
   198:                                           ! Height (full level)
   199:                 real(DP), intent(in):: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
   200:                                           ! 高度 (半整数レベル). 
   201:                                           ! Height (half level)
   202:                 real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
   203:                                           ! Exner 関数 (整数レベル). 
   204:                                           ! Exner function (full level)
   205:                 real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
   206:                                           ! Exner 関数 (半整数レベル). 
   207:                                           ! Exner function (half level)
   208:             
   209:                 real(DP), intent(in):: xy_SurfMOLength(0:imax-1, 1:jmax)
   210:                                           ! 
   211:                                           ! Turbulent kinetic energy (m2 s-2)
   212:             
   213:                 real(DP), intent(in):: xyz_TurKinEne(0:imax-1, 1:jmax, 1:kmax)
   214:                                           ! 
   215:                                           ! Turbulent kinetic energy (m2 s-2)
   216:                 real(DP), intent(in):: xy_SurfMomFluxX (0:imax-1, 1:jmax)
   217:                                           ! 
   218:                                           ! Eastward momentum flux at surface
   219:                 real(DP), intent(in):: xy_SurfMomFluxY (0:imax-1, 1:jmax)
   220:                                           ! 
   221:                                           ! Northward momentum flux at surface
   222:                 real(DP), intent(in):: xy_SurfHeatFlux (0:imax-1, 1:jmax)
   223:                 real(DP), intent(in):: xyf_SurfQMixFlux(0:imax-1, 1:jmax, 1:ncmax)
   224:             
   225:                 real(DP), intent(out):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
   226:                                           ! 東西方向運動量フラックス. 
   227:                                           ! Eastward momentum flux
   228:                 real(DP), intent(out):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
   229:                                           ! 南北方向運動量フラックス. 
   230:                                           ! Northward momentum flux
   231:                 real(DP), intent(out):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
   232:                                           ! 熱フラックス. 
   233:                                           ! Heat flux
   234:                 real(DP), intent(out):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   235:                                           ! 質量フラックス. 
   236:                                           ! Mass flux of compositions
   237:                 real(DP), intent(out):: xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   238:                                           ! 拡散係数：運動量. 
   239:                                           ! Diffusion coefficient: velocity
   240:                 real(DP), intent(out):: xyr_TempDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   241:                                           ! 拡散係数：温度. 
   242:                                           ! Diffusion coefficient: temperature
   243:                 real(DP), intent(out):: xyr_QMixDiffCoef (0:imax-1, 1:jmax, 0:kmax)
   244:                                           ! 拡散係数：比湿. 
   245:                                           ! Diffusion coefficient: specific humidity
   246:                 real(DP), intent(out):: xyz_DTurKinEneDt (0:imax-1, 1:jmax, 1:kmax)
   247:                                           !
   248:                                           ! Tendency of turbulent kinetic energy
   249:             
   250:                 ! 作業変数
   251:                 ! Work variables
   252:                 !
   253:                 real(DP) :: z_U (1:kmax)
   254:                 real(DP) :: z_V (1:kmax)
   255:                 real(DP) :: z_QH2OVap(1:kmax)
   256:                 real(DP) :: z_QH2OLiq(1:kmax)
   257:                 real(DP) :: z_QH2OSol(1:kmax)
   258:                 real(DP) :: z_Temp (1:kmax)
   259:                 real(DP) :: r_Temp (0:kmax)
   260:                 real(DP) :: z_VirTemp (1:kmax)
   261:                 real(DP) :: r_VirTemp (0:kmax)
   262:                 real(DP) :: z_Press  (1:kmax)
   263:                 real(DP) :: r_Press  (0:kmax)
   264:                 real(DP) :: SurfHeight
   265:                 real(DP) :: z_Height (1:kmax)
   266:                 real(DP) :: r_Height (0:kmax)
   267:                 real(DP) :: z_Exner (1:kmax)
   268:                 real(DP) :: r_Exner (0:kmax)
   269:                 real(DP) :: z_PotTemp(1:kmax)
   270:                 real(DP) :: z_QCldWat(1:kmax)
   271:                 real(DP) :: z_QCldIce(1:kmax)
   272:                 real(DP) :: z_TurKinEne(1:kmax)
   273:                 real(DP) :: SurfMomFluxX
   274:                 real(DP) :: SurfMomFluxY
   275:                 real(DP) :: SurfMomFlux
   276:                 real(DP) :: SurfHeatFlux
   277:                 real(DP) :: SurfQVapFlux
   278:                 real(DP) :: r_MomFluxX (0:kmax)
   279:                 real(DP) :: r_MomFluxY (0:kmax)
   280:                 real(DP) :: r_HeatFlux (0:kmax)
   281:                 real(DP) :: rf_QMixFlux(0:kmax, 1:ncmax)
   282:                 real(DP) :: r_VelDiffCoef (0:kmax)
   283:                 real(DP) :: r_TempDiffCoef(0:kmax)
   284:                 real(DP) :: r_QMixDiffCoef(0:kmax)
   285:                 real(DP) :: z_DTurKinEneDt (1:kmax)
   286:                                           !
   287:                                           ! Tendency of turbulent kinetic energy
   288:             
   289:                 real(DP) :: r_Rho(0:kmax)
   290:                 real(DP) :: SurfMOLengthInv
   291:             
   292:                 real(DP) :: z_DelHeight   (1:kmax-1)
   293:                 real(DP) :: z_DelHeightInv(1:kmax)
   294:                 real(DP) :: r_DelHeightInv(1:kmax-1)
   295:             
   296:                 real(DP) :: r_LowWeightFactF2H(1:kmax-1)
   297:                 real(DP) :: r_UppWeightFactF2H(1:kmax-1)
   298:                 real(DP) :: r_LowWeightFactH2F(1:kmax-1)
   299:                 real(DP) :: r_UppWeightFactH2F(1:kmax-1)
   300:             
   301:                 real(DP) :: z_QKE (1:kmax)
   302:                 real(DP) :: z_TSq (1:kmax)
   303:                 real(DP) :: z_QSq (1:kmax)
   304:                 real(DP) :: z_Cov (1:kmax)
   305:                 real(DP) :: z_TSqA(1:kmax)
   306:                 real(DP) :: z_QSqA(1:kmax)
   307:                 real(DP) :: z_CovA(1:kmax)
   308:             
   309:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   310:                                           ! Work variables for DO loop in longitude
   311:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   312:                                           ! Work variables for DO loop in latitude
   313:                 integer:: n
   314:             
   315:             
   316:                 ! 実行文 ; Executable statement
   317:                 !
   318:             
   319:                 ! 初期化確認
   320:                 ! Initialization check
   321:                 !
   322:                 if ( .not. vdiffusion_jma_my_wrap_inited ) then
   323:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   324:                 end if
   325:             
   326:             
   327:             
   328:             
   329:                 call MessageNotify( 'E', module_name, 'JMA MY library is not included.' )
   330:             
   331:             
   332:             
   333:             
   334:                 ! 拡散係数の出力
   335:                 ! Output diffusion coefficients
   336:                 !
   337:             
   338:                 ! 拡散係数出力
   339:                 ! Diffusion coeffficients output
   340:                 !
   341:             !!$    call HistoryAutoPut( TimeN, 'VelDiffCoef',  xyr_VelDiffCoef  )
   342:             !!$    call HistoryAutoPut( TimeN, 'TempDiffCoef', xyr_TempDiffCoef )
   343:             !!$    call HistoryAutoPut( TimeN, 'QVapDiffCoef', xyr_QMixDiffCoef )
   344:             !!$
   345:             !!$    call HistoryAutoPut( TimeN, 'TKEPShear', xyz_TurKinEneProShear )
   346:             !!$    call HistoryAutoPut( TimeN, 'TKEPBuoy' , xyz_TurKinEneProBuoya )
   347:             !!$    call HistoryAutoPut( TimeN, 'TKEDiss'  , xyz_TurKinEneDiss     )
   348:             !!$
   349:             !!$    call HistoryAutoPut( TimeN, 'MixLength' , xyz_MixLength )
   350:             
   351:             
   352:             
   353:                 ! 計算時間計測一時停止
   354:                 ! Pause measurement of computation time
   355:                 !
   356:                 call TimesetClockStop( module_name )
   357:             
   358:               end subroutine VDiffusionJMAMYWrapper3D
   359:             
   360:               !--------------------------------------------------------------------------------------
   361:             
   362:               subroutine VDiffusionJMAInit
   363:                 !
   364:                 ! vdiffusion_my モジュールの初期化を行います. 
   365:                 ! NAMELIST#vdiffusion_my_nml の読み込みはこの手続きで行われます. 
   366:                 !
   367:                 ! "vdiffusion_my" module is initialized. 
   368:                 ! "NAMELIST#vdiffusion_my_nml" is loaded in this procedure. 
   369:                 !
   370:             
   371:                 ! モジュール引用 ; USE statements
   372:                 !
   373:             
   374:                 ! NAMELIST ファイル入力に関するユーティリティ
   375:                 ! Utilities for NAMELIST file input
   376:                 !
   377:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   378:             
   379:                 ! ファイル入出力補助
   380:                 ! File I/O support
   381:                 !
   382:                 use dc_iounit, only: FileOpen
   383:             
   384:                 ! 種別型パラメタ
   385:                 ! Kind type parameter
   386:                 !
   387:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   388:             
   389:                 ! 文字列操作
   390:                 ! Character handling
   391:                 !
   392:                 use dc_string, only: StoA
   393:             
   394:                 ! 時刻管理
   395:                 ! Time control
   396:                 !
   397:                 use timeset, only: &
   398:                   & DelTime            ! $ \Delta t $ [s]
   399:             
   400:                 ! ヒストリデータ出力
   401:                 ! History data output
   402:                 !
   403:                 use gtool_historyauto, only: HistoryAutoAddVariable
   404:             
   405:                 ! 補助的な変数を計算するサブルーチン・関数群
   406:                 ! Subroutines and functions for calculating auxiliary variables
   407:                 !
   408:                 use auxiliary, only : &
   409:                   & RefPressForPotTemp => RefPress, &
   410:                                           ! 基準気圧. 
   411:                                           ! Reference air pressure
   412:                   & AuxVarsInit
   413:             
   414:             
   415:             
   416:                 ! 座標データ設定
   417:                 ! Axes data settings
   418:                 !
   419:                 use axesset, only: &
   420:                   & AxnameX, &
   421:                   & AxnameY, &
   422:                   & AxnameZ, &
   423:                   & AxnameR, &
   424:                   & AxnameT
   425:             
   426:                 ! 宣言文 ; Declaration statements
   427:                 !
   428:                 implicit none
   429:             
   430:                 real(DP) :: PressRef
   431:                 real(DP) :: TimeStep
   432:                 real(DP) :: SurfEmis
   433:             
   434:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   435:                                           ! Unit number for NAMELIST file open
   436:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   437:                                           ! IOSTAT of NAMELIST read
   438:             
   439:                 ! NAMELIST 変数群
   440:                 ! NAMELIST group name
   441:                 !
   442:             !!$    namelist /vdiffusion_my_nml/        &
   443:             !!$      & FlagConstDiffCoef,              &
   444:             !!$      & ConstDiffCoefM, ConstDiffCoefH, &
   445:             !!$!
   446:             !!$      & SquareVelMin, BulkRiNumMin,     &
   447:             !!$!
   448:             !!$      & MixLengthMax, ShMin, SmMin,      &
   449:             !!$      & VelDiffCoefMin, TempDiffCoefMin, &
   450:             !!$      & VelDiffCoefMax, TempDiffCoefMax, &
   451:             !!$!
   452:             !!$      & MYConstA1, MYConstB1, MYConstA2, MYConstB2, MYConstC1
   453:                       !
   454:                       ! デフォルト値については初期化手続 "vdiffusion_my#VDiffInit" 
   455:                       ! のソースコードを参照のこと. 
   456:                       !
   457:                       ! Refer to source codes in the initialization procedure
   458:                       ! "vdiffusion_my#VDiffInit" for the default values. 
   459:                       !
   460:             
   461:                 ! 実行文 ; Executable statement
   462:                 !
   463:             
   464:                 if ( vdiffusion_jma_my_wrap_inited ) return
   465:             
   466:             
   467:                 ! デフォルト値の設定
   468:                 ! Default values settings
   469:                 !
   470:             !!$    FlagConstDiffCoef = .false.
   471:             !!$    ConstDiffCoefM    = 0.0_DP
   472:             !!$    ConstDiffCoefH    = 0.0_DP
   473:             !!$
   474:             !!$    SquareVelMin    =     0.1_DP
   475:             !!$    BulkRiNumMin    = - 100.0_DP
   476:             !!$
   477:             !!$    MixLengthMax    = 300.0_DP
   478:             !!$    ShMin           =   0.0_DP
   479:             !!$    SmMin           =   0.0_DP
   480:             !!$    VelDiffCoefMin  =   0.1_DP
   481:             !!$    TempDiffCoefMin =   0.1_DP
   482:             !!$    VelDiffCoefMax  = 10000.0_DP
   483:             !!$    TempDiffCoefMax = 10000.0_DP
   484:             !!$
   485:             !!$    ! Parameters proposed by Mellor and Yamada (1982).
   486:             !!$    !
   487:             !!$    MYConstA1 =  0.92_DP
   488:             !!$    MYConstB1 = 16.6_DP
   489:             !!$    MYConstA2 =  0.74_DP
   490:             !!$    MYConstB2 = 10.1_DP
   491:             !!$    MYConstC1 =  0.08_DP
   492:             
   493:             
   494:                 ! NAMELIST の読み込み
   495:                 ! NAMELIST is input
   496:                 !
   497:             !!$    if ( trim(namelist_filename) /= '' ) then
   498:             !!$      call FileOpen( unit_nml, &          ! (out)
   499:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   500:             !!$
   501:             !!$      rewind( unit_nml )
   502:             !!$      read( unit_nml, &                   ! (in)
   503:             !!$        & nml = vdiffusion_my_nml,     &  ! (out)
   504:             !!$        & iostat = iostat_nml )           ! (out)
   505:             !!$      close( unit_nml )
   506:             !!$
   507:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   508:             !!$      if ( iostat_nml == 0 ) write( STDOUT, nml = vdiffusion_my_nml )
   509:             !!$    end if
   510:             
   511:             
   512:                 ! 補助的な変数を計算するサブルーチン・関数群
   513:                 ! Subroutines and functions for calculating auxiliary variables
   514:                 !
   515:                 call AuxVarsInit
   516:             
   517:             
   518:             
   519:             
   520:                 call MessageNotify( 'E', module_name, 'JMA MY library is not included.' )
   521:             
   522:             
   523:             
   524:             
   525:                 ! ヒストリデータ出力のためのへの変数登録
   526:                 ! Register of variables for history data output
   527:                 !
   528:             !!$    call HistoryAutoAddVariable( 'VelDiffCoef', &
   529:             !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   530:             !!$      & 'diffusion coef. momentum', 'm2 s-1' )
   531:             !!$    call HistoryAutoAddVariable( 'TempDiffCoef', &
   532:             !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   533:             !!$      & 'diffusion coef. heat    ', 'm2 s-1' )
   534:             !!$    call HistoryAutoAddVariable( 'QVapDiffCoef', &
   535:             !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   536:             !!$      & 'diffusion coef. moisture', 'm2 s-1' )
   537:             !!$
   538:             !!$    call HistoryAutoAddVariable( 'MomFluxX', &
   539:             !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   540:             !!$      & 'eastward momentum flux', 'N m-2' )
   541:             !!$    call HistoryAutoAddVariable( 'MomFluxY', &
   542:             !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   543:             !!$      & 'northward momentum flux', 'N m-2' )
   544:             !!$    call HistoryAutoAddVariable( 'HeatFlux', &
   545:             !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   546:             !!$      & 'heat flux', 'W m-2' )
   547:             !!$    call HistoryAutoAddVariable( 'QVapFlux', &
   548:             !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   549:             !!$      & 'moisture flux', 'W m-2' )
   550:             !!$
   551:             !!$    call HistoryAutoAddVariable( 'DUDtVDiff', &
   552:             !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   553:             !!$      & 'tendency of zonal wind by vertical diffusion', 'm s-2' )
   554:             !!$    call HistoryAutoAddVariable( 'DVDtVDiff', &
   555:             !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   556:             !!$      & 'tendency of meridional wind by vertical diffusion', 'm s-2' )
   557:             !!$    call HistoryAutoAddVariable( 'DTempDtVDiff', &
   558:             !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   559:             !!$      & 'tendency of temperature by vertical diffusion', 'K s-1' )
   560:             !!$    call HistoryAutoAddVariable( 'DQVapDtVDiff', &
   561:             !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   562:             !!$      & 'tendency of specific humidity by vertical diffusion', 's-1' )
   563:             !!$
   564:             !!$    call HistoryAutoAddVariable( 'TurKinEne', &
   565:             !!$      & (/ AxNameX, AxNameY, AxNameR, AxNameT /), &
   566:             !!$      & 'turbulent kinetic energy', 'm2 s-2' )
   567:             !!$
   568:             !!$    call HistoryAutoAddVariable( 'TKEPShear',  &
   569:             !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   570:             !!$      & 'turbulent kinetic energy production rate by shear', 'm2 s-3' )
   571:             !!$    call HistoryAutoAddVariable( 'TKEPBuoy',   &
   572:             !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   573:             !!$      & 'turbulent kinetic energy production rate by buoyancy', 'm2 s-3' )
   574:             !!$    call HistoryAutoAddVariable( 'TKEDiss',    &
   575:             !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   576:             !!$      & 'turbulent kinetic energy dissipation rate', 'm2 s-3' )
   577:             !!$    call HistoryAutoAddVariable( 'MixLength',  &
   578:             !!$      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &
   579:             !!$      & 'mixing length', 'm' )
   580:             
   581:                 ! 印字 ; Print
   582:                 !
   583:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   584:             
   585:                 call MessageNotify( 'M', module_name, '  %d is specified.', i = (/ LevelNum /) )
   586:             !!$    call MessageNotify( 'M', module_name, 'For vertical diffusion flux:' )
   587:             !!$    call MessageNotify( 'M', module_name, '  FlagConstDiffCoef = %b', l = (/ FlagConstDiffCoef /) )
   588:             !!$    call MessageNotify( 'M', module_name, '  ConstDiffCoefM    = %f', d = (/ ConstDiffCoefM /) )
   589:             !!$    call MessageNotify( 'M', module_name, '  ConstDiffCoefH    = %f', d = (/ ConstDiffCoefH /) )
   590:             !!$    call MessageNotify( 'M', module_name, '  SquareVelMin = %f', d = (/ SquareVelMin /) )
   591:             !!$    call MessageNotify( 'M', module_name, '  BulkRiNumMin = %f', d = (/ BulkRiNumMin /) )
   592:             !!$    call MessageNotify( 'M', module_name, 'For diffusion coefficients:' )
   593:             !!$    call MessageNotify( 'M', module_name, '  MixLengthMax      = %f', d = (/ MixLengthMax     /) )
   594:             !!$    call MessageNotify( 'M', module_name, '  ShMin             = %f', d = (/ ShMin       /) )
   595:             !!$    call MessageNotify( 'M', module_name, '  SmMin             = %f', d = (/ SmMin       /) )
   596:             !!$    call MessageNotify( 'M', module_name, '  VelDiffCoefMin    = %f', d = (/ VelDiffCoefMin  /) )
   597:             !!$    call MessageNotify( 'M', module_name, '  TempDiffCoefMin   = %f', d = (/ TempDiffCoefMin /) )
   598:             !!$    call MessageNotify( 'M', module_name, '  VelDiffCoefMax    = %f', d = (/ VelDiffCoefMax  /) )
   599:             !!$    call MessageNotify( 'M', module_name, '  TempDiffCoefMax   = %f', d = (/ TempDiffCoefMax /) )
   600:             !!$    call MessageNotify( 'M', module_name, '  MYConstA1         = %f', d = (/ MYConstA1     /) )
   601:             !!$    call MessageNotify( 'M', module_name, '  MYConstB1         = %f', d = (/ MYConstB1     /) )
   602:             !!$    call MessageNotify( 'M', module_name, '  MYConstA2         = %f', d = (/ MYConstA2     /) )
   603:             !!$    call MessageNotify( 'M', module_name, '  MYConstB2         = %f', d = (/ MYConstB2     /) )
   604:             !!$    call MessageNotify( 'M', module_name, '  MYConstC1         = %f', d = (/ MYConstC1     /) )
   605:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   606:             
   607:                 vdiffusion_jma_my_wrap_inited = .true.
   608:             
   609:               end subroutine VDiffusionJMAInit
   610:             
   611:               !--------------------------------------------------------------------------------------
   612:             
   613:             end module vdiffusion_jma_my_wrapper
