#! /usr/bin/ruby
# coding: utf-8


# DCPAM 描画スクリプト実行用スクリプト
#
# == 説明
# * fig_basic.rb などを実行するスクリプト
#   オプションを記録しておくものとして使うことを想定.
# * データファイル (*.nc) が存在するディレクトリ内に置いて
#   実行することを想定している.
#
# == 履歴
# 2019-07-25 石渡 作成


# スクリプト置場
SCRIPT_DIR = '/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script'
# 平均をとり始める時刻 (たいてい日単位)
START_TIME = 2556
# 平均をとり終る時刻 (たいてい日単位)
END_TIME = 3650
# 画像ファイル名につける接頭語
PREFIX = 'EarthExp_'
# 比湿の変数名
QVAP_NAME = 'QH2OVap'

# スクリプトその1 実行
system("#{SCRIPT_DIR}/fig_basic_3d.rb --time_start=#{START_TIME} --time_end=#{END_TIME} --qvap_name=#{QVAP_NAME} --range_cloud=0:1.0 --cint_cloud=0.025 --wsn=2 --prefix=#{PREFIX}")

# スクリプトその2 実行
system("#{SCRIPT_DIR}/fig_basic.rb --saturation_scheme=nha --time_start=#{START_TIME} --time_end=#{END_TIME} --range_stream=-5e11:5e11 --cint_stream=5.0e10 --wsn=2 --prefix=#{PREFIX}")

# スクリプトその3 実行
system("#{SCRIPT_DIR}/fig_SeasonalMean.rb --wsn=2 --prefix=#{PREFIX}")

# 質量流線関数
system("gpview MSF.nc@MSF,time=3286:3650 --mean lon,time --noshade --noannotate --wsn=2 && convert -rotate 90 dcl.pdf #{PREFIX}_MSF0-360_day3286-3650.png")


# 変数なんか使わないで直接オプション書いてしまう場合の書き方例
#
# スクリプトその1
#system("/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/fig_basic_3d.rb --time_start=2556 --time_end=3650 --qvap_name=QH2OVap --range_cloud=0:1.0 --cint_cloud=0.025 --wsn=2 --prefix=EarthExp_")

# スクリプトその1
#/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/fig_basic.rb --saturation_scheme=nha --time_start=2556 --time_end=3650 --range_stream=-5e11:5e11 --cint_stream=5.0e10 --wsn=2 --prefix=EarthExp_

# スクリプトその1
#/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/fig_SeasonalMean.rb --wsn=2 --prefix=EarthExp_

# 質量流線関数
#gpview MSF.nc@MSF,time=3286:3650 --mean lon,time --noshade --noannotate --wsn=2 && convert -rotate 90 dcl.pdf EarthExp_MSF0-360_day3286-3650.png

