#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# 陸惑星実験用描画スクリプト
# == 説明
# * このスクリプトは水平平均した P-E の時系列をかくものである.
# * 下にある omegas に描画する Omega の値のリストを設定する.
#
# == オプション
# --lon_start   経度の開始点
# --lon_end   経度の開始点
# --range      プロットする値の範囲. min:max という形式で指定する.
# --inclination      雲の消滅時間
# --wsn        出力先. pdf だったら --wsn=2
#
# == USAGE
#   % fig_lonmean_timeseries.rb --var SoilMoist --range=0:1000 --wsn 2
#
# == 履歴
# * 2013-6-19 石渡正樹 作成
# * 2014-04-22 石渡正樹 論文用の図の作成

require "./load_config.rb"

require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

DATA_HOME = "./"

TMPFILE = "dcl.pdf"

latent_heat = 2.5e6


## オプション解析
parser = GetoptLong.new
parser.set_options(
   ###    global option   ###
   ['--var',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--time_start',               GetoptLong::REQUIRED_ARGUMENT],
   ['--time_end',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--time_interval',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--lon_start',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--lon_end',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--lat_start',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--lat_end',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--inclination',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--range',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--exp_header',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--image_header',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT]
)
parser.each_option do |name, arg|
  eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||1)

exp_header = ($OPT_exp_header||'LP_16p_Omg1.0_I23.5_S1800_W20cm')
image_header = ($OPT_image_header||'LP_16p_Omg1.0_I23.5_S1800_W20cm')

#var = ($OPT_var||'Temp')
var_1 = 'PRCP'
var_2 = 'EvapU'

time_start = ($OPT_time_start||0).to_f
time_end = ($OPT_time_end||800).to_f

time_interval = ($OPT_time_interval||40).to_f

lon_start = ($OPT_lon_start||0).to_f
lon_end = ($OPT_lon_end||364).to_f

title = ''

range = ($OPT_range||'0:10000')
VAL_MIN =  range.split(':')[0].to_f
VAL_MAX =  range.split(':')[1].to_f

# 出力ファイル名
epsfn = "#{image_header}_#{var_1}-#{var_2}_y_lonmean-timemean#{time_start}-#{time_end}.eps"
pngfn = "#{image_header}_#{var_1}-#{var_2}_y_lonmean-timemean#{time_start}-#{time_end}.png"

gturls_1=[]
gturls_2=[]

nexpnum = EXPNUMS.size

for i in 0..EXPNUMS.size-1
  p i
  gturls_1.push( GPhys::IO.open_gturl("#{exp_header}_#{EXPNUMS[i]}/#{var_1}.nc@#{var_1},time=#{DATA_TIME_RANGE[i]}:#{time_interval}") )
  p gturls_1
  gturls_2.push( GPhys::IO.open_gturl("#{exp_header}_#{EXPNUMS[i]}/#{var_2}.nc@#{var_2},time=#{DATA_TIME_RANGE[i]}:#{time_interval}") )
  p gturls_2
end

gp_result_1 = GPhys.join(gturls_1)
gp_result_2 = GPhys.join(gturls_2)

# データの切り出し
gphys_1 = gp_result_1.cut('time'=>time_start..time_end).mean('time')
gphys_2 = gp_result_2.cut('time'=>time_start..time_end).mean('time')

if var_2 == 'EvapU' then
  gphys_2 = gphys_2 / latent_heat
end

gphys = gphys_1 - gphys_2

all = gphys.mean('lon')

#p all

# 描画
DCL.gropn(wsn)
    
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

#GGraph.set_axes('xtickint'=>730, 'xlabelint'=>3650)
GGraph.set_axes('ytickint'=>10, 'ylabelint'=>50)
vx0,vx1,vy0,vy1 = 0.15,0.85,0.2,0.55
GGraph.set_fig 'viewport'=>[vx0,vx1,vy0,vy1]
DCL.uscset('cyspos', 'B' )              # move unit y axis
DCL.udlset('LMSG', false)
#DCL::uxmttl('T', '', 0.0)  # title (large character)
#DCL.ugpset('LUMSG', false)   # no message

opt_line = {
   'min'=>VAL_MIN, 'max'=>VAL_MAX,  
   'title'=>'',
#   'nlev'=>nlev,
   'annotate'=>false,
   'exchange'=>false,
   'title'=>title
#   'interval'=>contour_interval
}

GGraph.line(all , true , opt_line)

DCL.grcls

# 画像ファイルの変換
if wsn == '2' then
  if File.exist?(TMPFILE) then
    puts("MESSAGE: post processing ... #{pngfn} will be generate.")
    `#{SCRIPT_DIR}/conv_image.rb #{pngfn}`
  end
end

