#!/usr/bin/ruby
# 2016-08-15 M. Ishiwatari ruby ˽񤭴. 
#                           ¸ǥ쥯ȥǼ¹Ԥ褦ѹ
# 2015-05-01 M. Ishiwatari 󥵥֥¸Ѥѹ

require "pp"
require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir="/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

GPVIEW_XY="#{script_dir}/gpview_xy"
GPVIEW_Y="#{script_dir}/gpview_y"

opt="--range 160:340 --int 5 --mean time --noannotate --wsn 2 --title ''"
PS2EPS="convert -rotate 90"

expnum="003"


## ץ
parser = GetoptLong.new
parser.set_options(
   ###    global option   ###
   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--range_stream',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--cint_stream',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--range_q',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--cint_q',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

time_start = ($OPT_time_start||1).to_s
time_end = ($OPT_time_end||9999).to_s
timerange = time_start + ':' + time_end

prefix = ($OPT_prefix||"DCPAM_EXP_").to_s


def rename_conv(name)
  if File.exist?("dcl.pdf")
    system("mv dcl.pdf #{name}.pdf")
    system("#{PS2EPS} #{name}.pdf #{name}.eps")
  end
end

def draw_timeseries(var,name,range,opt)
  unless File.exist?("#{name}.ps")
    system("#{GPVIEW_Y} #{var}.nc@#{var}#{range} #{opt}")
  end
end

var="Ps"
name="#{prefix}#{var}_timeseries-xmean"
#  opt="--range 96400:103600 --int 200 --clrmap 14 --mean lon --noannotate --wsn 2 --nocont --ex"
#  for Omega=0.67
opt="--range 91000:109000 --int 500 --clrmap 14 --mean lon --noannotate --wsn 2 --nocont --ex"
range=",time=#{timerange}"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="Rain"
name="#{prefix}#{var}_timeseries-xmean"
opt="--range 0:1000 --int 50 --mean lon --noannotate --wsn 2 --nocont --ex"
range=",time=#{timerange}"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="SurfTemp"
name="#{prefix}#{var}_timeseries-xmean"
opt="--range 160:335 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
range=",time=#{timerange}"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="SurfTemp"
name="#{prefix}#{var}_timeseries-x0-180mean"
opt="--range 160:335 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
range=",time=#{timerange},lon=0:180"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="SurfTemp"
name="#{prefix}#{var}_timeseries-x180-360mean"
range=",time=#{timerange},lon=180:360"
opt="--range 160:335 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="SurfTemp"
name="#{prefix}#{var}_timeseries-x180"
range=",time=#{timerange},lon=180"
opt="--range 160:335 --int 5 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="U"
name="#{prefix}#{var}_sigma0.2_timeseries-xmean"
range=",time=#{timerange},sig=0.2"
opt="--range -110:110 --int 5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="U"
name="#{prefix}#{var}_sigma0.2_timeseries-x0-180mean"
range=",time=#{timerange},sig=0.2,lon=0:180"
opt="--range -110:110 --int 5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="U"
name="#{prefix}#{var}_sigma0.2_timeseries-x180-360mean"
range=",time=#{timerange},sig=0.2,lon=180:360"
opt="--range -110:110 --int 5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="U"
name="#{prefix}#{var}_sigma0.2_timeseries-x90"
range=",time=#{timerange},sig=0.2,lon=90"
opt="--range -110:110 --int 5 --clrmap 14 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)


var="U"
name="#{prefix}#{var}_sigma0.8_timeseries-xmean"
range=",time=#{timerange},sig=0.8"
opt="--range -50:50 --int 2.5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="U"
name="#{prefix}#{var}_sigma0.8_timeseries-x0-180mean"
range=",time=#{timerange},sig=0.8,lon=0:180"
opt="--range -50:50 --int 2.5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="U"
name="#{prefix}#{var}_sigma0.8_timeseries-x180-360mean"
range=",time=#{timerange},sig=0.8,lon=180:360"
opt="--range -50:50 --int 2.5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="U"
name="#{prefix}#{var}_sigma0.8_timeseries-x180"
range=",time=#{timerange},sig=0.8,lon=180"
opt="--range -50:50 --int 2.5 --clrmap 14 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="Temp"
name="#{prefix}#{var}_sigma0.2_timeseries-xmean"
range=",time=#{timerange},sig=0.2"
opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="Temp"
name="#{prefix}#{var}_sigma0.2_timeseries-x0-180mean"
range=",time=#{timerange},sig=0.2,lon=0:180"
opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="Temp"
name="#{prefix}#{var}_sigma0.2_timeseries-x180-360mean"
range=",time=#{timerange},sig=0.2,lon=180:360"
opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="Temp"
name="#{prefix}#{var}_sigma0.8_timeseries-xmean"
range=",time=#{timerange},sig=0.8"
opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="Temp"
name="#{prefix}#{var}_sigma0.8_timeseries-x0-180mean"
range=",time=#{timerange},sig=0.8,lon=0:180"
opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="Temp"
name="#{prefix}#{var}_sigma0.8_timeseries-x180-360mean"
range=",time=#{timerange},sig=0.8,lon=180:360"
opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="Temp"
name="#{prefix}#{var}_sigma0.8_timeseries-x180"
range=",time=#{timerange},sig=0.8,lon=180"
opt="--range 240:320 --int 5 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="QVap"
name="#{prefix}#{var}_sigma0.8_timeseries-xmean"
range=",time=#{timerange},sig=0.8"
opt="--range 0:0.05 --int 0.001 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="QVap"
name="#{prefix}#{var}_sigma0.8_timeseries-x0-180mean"
range=",time=#{timerange},sig=0.8,lon=0:180"
opt="--range 0:0.05 --int 0.001 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="QVap"
name="#{prefix}#{var}_sigma0.8_timeseries-x180-360mean"
range=",time=#{timerange},sig=0.8,lon=180:360"
opt="--range 0:0.05 --int 0.001 --mean lon --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)

var="QVap"
name="#{prefix}#{var}_sigma0.8_timeseries-x180"
range=",time=#{timerange},sig=0.8,lon=180"
opt="--range 0:0.05 --int 0.001 --noannotate --wsn 2 --nocont --ex"
draw_timeseries(var,name,range,opt)
rename_conv(name)
