#!/bin/bash
# 2015-05-01 M. Ishiwatari ¸ǥ쥯ȥǼ¹Ԥ褦ѹ
# 2015-05-01 M. Ishiwatari 󥵥֥¸Ѥѹ

SCRIPT_DIR=/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script

GPVIEW_XY=${SCRIPT_DIR}/gpview_xy
GPVIEW_Y=${SCRIPT_DIR}/gpview_y

opt="--range 160:340 --int 5 --mean time --noannotate --wsn 2 --title ''"
PS2EPS='convert -rotate 90'

expnum="003"


rename_conv()
{
  if [ -e dcl.pdf ]; then
    mv dcl.pdf ${name}.pdf
    ${PS2EPS} ${name}.pdf ${name}.eps
#    dclpsrmcm ${name}.ps | dclpsrot | dclpsmargin \
#      | sed 's/%%BoundingBox: 17 25 676 42/%%BoundingBox: 0 25 750 42/' \
#      | sed 's/%%BoundingBox: 17 24 676 42/%%BoundingBox: 0 25 750 42/' \
#      > ${name}.eps
  fi
}

draw_timeseries()
{
  if [ ! -e ${name}.ps ]; then
    ${GPVIEW_Y} ${var}.nc@${var}${timerange} ${opt}
  fi
}

draw_xy()
{
  if [ ! -e ${name}.ps ]; then
    ${GPVIEW_XY} ${var}.nc@${var}${timerange} ${opt}
  fi
}




echo `pwd`

exit


for omega in 0.75; do
#  dir=101220_diff-DryAir-Vapor_T21L16_sr_Omega${omega}E_rndTemp_${expnum}

  var=Ps
  name=Omega${omega}E_${var}_timeseries-xmean_${expnum}
  timerange=',time=1000:2000'
#  default setting
#  opt="--range 96400:103600 --int 200 --clrmap 14 --mean lon --noannotate --wsn 2 --nocont --ex"
#  for Omega=0.67
  opt="--range 91000:109000 --int 500 --clrmap 14 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=Rain
  name=Omega${omega}E_${var}_timeseries-xmean_${expnum}
  timerange=',time=1000:2000'
  opt="--range 0:1000 --int 50 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=SurfTemp
  name=Omega${omega}E_${var}_timeseries-xmean_${expnum}
  timerange=',time=1000:2000'
  opt="--range 160:335 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=SurfTemp
  name=Omega${omega}E_${var}_timeseries-x0-180mean_${expnum}
  timerange=',time=1000:2000,lon=0:180'
  opt="--range 160:335 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=SurfTemp
  name=Omega${omega}E_${var}_timeseries-x180-360mean_${expnum}
  timerange=',time=1000:2000,lon=180:360'
  opt="--range 160:335 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=SurfTemp
  name=Omega${omega}E_${var}_timeseries-x180_${expnum}
  timerange=',time=1000:2000,lon=180'
  opt="--range 160:335 --int 5 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=U
  name=Omega${omega}E_${var}_sigma0.2_timeseries-xmean_${expnum}
  timerange=',time=1000:2000,sig=0.2'
  opt="--range -110:110 --int 5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=U
  name=Omega${omega}E_${var}_sigma0.2_timeseries-x0-180mean_${expnum}
  timerange=',time=1000:2000,sig=0.2,lon=0:180'
  opt="--range -110:110 --int 5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=U
  name=Omega${omega}E_${var}_sigma0.2_timeseries-x180-360mean_${expnum}
  timerange=',time=1000:2000,sig=0.2,lon=180:360'
  opt="--range -110:110 --int 5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=U
  name=Omega${omega}E_${var}_sigma0.2_timeseries-x90_${expnum}
  timerange=',time=1000:2000,sig=0.2,lon=90'
  opt="--range -110:110 --int 5 --clrmap 14 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv


  var=U
  name=Omega${omega}E_${var}_sigma0.8_timeseries-xmean_${expnum}
  timerange=',time=1000:2000,sig=0.8'
#  opt="--range -110:110 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range -50:50 --int 2.5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=U
  name=Omega${omega}E_${var}_sigma0.8_timeseries-x0-180mean_${expnum}
  timerange=',time=1000:2000,sig=0.8,lon=0:180'
#  opt="--range -110:110 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range -50:50 --int 2.5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=U
  name=Omega${omega}E_${var}_sigma0.8_timeseries-x180-360mean_${expnum}
  timerange=',time=1000:2000,sig=0.8,lon=180:360'
#  opt="--range -110:110 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range -50:50 --int 2.5 --mean lon --clrmap 14 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=U
  name=Omega${omega}E_${var}_sigma0.8_timeseries-x180_${expnum}
  timerange=',time=1000:2000,sig=0.8,lon=180'
#  opt="--range -110:110 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range -50:50 --int 2.5 --clrmap 14 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=Temp
  name=Omega${omega}E_${var}_sigma0.2_timeseries-xmean_${expnum}
  timerange=',time=1000:2000,sig=0.2'
#  opt="--range 200:330 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=Temp
  name=Omega${omega}E_${var}_sigma0.2_timeseries-x0-180mean_${expnum}
  timerange=',time=1000:2000,sig=0.2,lon=0:180'
#  opt="--range 200:330 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=Temp
  name=Omega${omega}E_${var}_sigma0.2_timeseries-x180-360mean_${expnum}
  timerange=',time=1000:2000,sig=0.2,lon=180:360'
#  opt="--range 200:330 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=Temp
  name=Omega${omega}E_${var}_sigma0.8_timeseries-xmean_${expnum}
  timerange=',time=1000:2000,sig=0.8'
#  opt="--range 200:330 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=Temp
  name=Omega${omega}E_${var}_sigma0.8_timeseries-x0-180mean_${expnum}
  timerange=',time=1000:2000,sig=0.8,lon=0:180'
#  opt="--range 200:330 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=Temp
  name=Omega${omega}E_${var}_sigma0.8_timeseries-x180-360mean_${expnum}
  timerange=',time=1000:2000,sig=0.8,lon=180:360'
#  opt="--range 200:330 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range 240:320 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=Temp
  name=Omega${omega}E_${var}_sigma0.8_timeseries-x180_${expnum}
  timerange=',time=1000:2000,sig=0.8,lon=180'
#  opt="--range 200:330 --int 5 --mean lon --noannotate --wsn 2 --nocont --ex"
  opt="--range 240:320 --int 5 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=QVap
  name=Omega${omega}E_${var}_sigma0.8_timeseries-xmean_${expnum}
  timerange=',time=1000:2000,sig=0.8'
  opt="--range 0:0.05 --int 0.001 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=QVap
  name=Omega${omega}E_${var}_sigma0.8_timeseries-x0-180mean_${expnum}
  timerange=',time=1000:2000,sig=0.8,lon=0:180'
  opt="--range 0:0.05 --int 0.001 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=QVap
  name=Omega${omega}E_${var}_sigma0.8_timeseries-x180-360mean_${expnum}
  timerange=',time=1000:2000,sig=0.8,lon=180:360'
  opt="--range 0:0.05 --int 0.001 --mean lon --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

  var=QVap
  name=Omega${omega}E_${var}_sigma0.8_timeseries-x180_${expnum}
  timerange=',time=1000:2000,sig=0.8,lon=180'
  opt="--range 0:0.05 --int 0.001 --noannotate --wsn 2 --nocont --ex"
  draw_timeseries
  rename_conv

done












