#! /usr/bin/ruby
#-*- coding: utf-8 -*-


# 
# == 
# * このスクリプトは同期回転惑星設定実験の結果の動画を作成するものである.
# * このスクリプトでは, gpview などのスクリプトが使われる.
#
# == オプション
# --time_start 開始時刻
# --time_end   終了時刻
# --wsn        出力先. ps だったら --wsn=2
# --prefix     生成する画像ファイルに付ける接頭詞
#
# == USAGE
#   % anim_SyncRot.rb --wsn=2 --time_start=1067 --time_end=1097 --prefix=EXPNAME_
#
# == 履歴
# * 2013-6-19 石渡正樹 作成

require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

## オプション解析
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end



wsn = ($OPT_wsn||4)

time_start = ($OPT_time_start||1).to_s
time_end = ($OPT_time_end||9999).to_s

prefix = ($OPT_prefix||EXP_).to_s

timespan = time_start + ':' + time_end

# 動画

unless File.exist?('anim/') then
  p 'making anim directory'
  system("mkdir anim")
end


if File.exist?('anim/' + prefix + 'anim-Ps.gif') then
  puts("MESSAGE: file exists. process skipped.")
else
#  system("gpview Ps.nc@Ps,time=#{timespan} --anim time  --range=0.96e5:1.02e5 --sint=300 --wsn=#{wsn} && mv dcl.ps anim/ && cd anim && #{script_dir}/make-anim.sh && mv anim.gif #{prefix}anim-Ps.gif && rm dcl* && cd ..")
  system("gpview Ps.nc@Ps,time=#{timespan} --anim time  --range=0.93e5:1.05e5 --sint=300 --wsn=#{wsn} && mv dcl.ps anim/ && cd anim && #{script_dir}/make-anim.sh && mv anim.gif #{prefix}anim-Ps.gif && rm dcl* && cd ..")
end

if File.exist?('anim/' + prefix + 'anim-SurfTemp.gif') then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{timespan} --anim time  --range=180:340 --sint=5 --wsn=#{wsn} && mv dcl.ps anim/ && cd anim && #{script_dir}/make-anim.sh && mv anim.gif #{prefix}anim-SurfTemp.gif && rm dcl* && cd ..")
end

# SyncRot バージョン
#system("gpview PRCP.nc@PRCP,time=#{timespan} --anim time  --range=0:5.0e-3 --sint=2.0e-4 --wsn=#{wsn} && mv dcl.ps anim/ && cd anim && #{script_dir}/make-anim.sh && mv anim.gif #{prefix}anim-PRCP.gif && rm dcl* && cd ..")

system("gpview PRCP.nc@PRCP,time=#{timespan} --anim time  --range=1e-10:3e-4 --sint=5.0e-6 --nocont --wsn=#{wsn} && mv dcl.ps anim/ && cd anim && #{script_dir}/make-anim.sh && mv anim.gif #{prefix}anim-PRCP.gif && rm dcl* && cd ..")






exit


system("#{script_dir}/anim_qvap-sigdot-uv.rb --xfact1 0.001 --yfact1 0.001 --uxunit 1 --uyunit 1 --wsn #{wsn} && mv dcl.ps #{$OPT_prefix}SigDot-Qvap.ps")






#system("#{script_dir}/anim_qvap-uv.rb --xfact1 0.001 --yfact1 0.001 --uxunit 1 --uyunit 1")

# 静止画

system("#{script_dir}/fig_uw.rb --xfact1 0.005 --yfact1 0.005 --uxunit 5 --uyunit 5 --wsn #{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}uw-qvap-sig0.1-0.01.ps && convert #{$OPT_prefix}uw-qvap-sig0.1-0.01.ps #{$OPT_prefix}uw-qvap-sig0.1-0.01.png")

# ホフメラー

system("gpview QVap.nc@QVap,lat=0,sig=0.1,time=731:831 --nocont --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}QVap-sig0.1-time731-831.ps && convert #{$OPT_prefix}QVap-sig0.1-time731-831.ps #{$OPT_prefix}QVap-sig0.1-time731-831.png")

#system("gpview QVap.nc@QVap,lat=0,sig=0.1,time=731:1096  --levels=1e-10,5e-10,1e-9,5e-9,1e-8,5e-8,1e-7,5e-7,1e-6,5e-6,1e-5,5e-5,1e-4,5e-4,1e-3")
#system("gpview QVap.nc@QVap,lat=0,sig=0.1,time=731:1096 --nocont")
#system("gpview QVap.nc@QVap,lat=0,sig=0.05,time=731:1096 --nocont")
#system("gpview QVap.nc@QVap,lat=0,sig=0.01,time=731:1096 --nocont")

# 対流圏界面付近 QVap

#system("gpview QVap.nc@QVap,lat=0,sig=0.01:0.2 --anim time --itr=2 --levels=1e-10,5e-10,1e-9,5e-9,1e-8,5e-8,1e-7,5e-7,1e-6,5e-6,1e-5,5e-5,1e-4,5e-4,1e-3")

