#! /usr/bin/ruby
# -*- coding: euc-jp -*-

# == ץ
#
# == USAGE
#   % calc_msf.rb
#
# == 
# * 2014-10-11  
# * 2018-11-27  ⤦ʤ? make_vertinteg.rb Ȥɤ?


require "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/dcpam.rb"

require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu


    # --------------------------------------------
    def calc_vertintH2OLiq_save(dir,var_qh2oliq,var_ps) # Ĺ߿̤η׻           
      gqv = gpopen dir + "#{var_qh2oliq}.nc"
      gps = gpopen dir + "#{var_ps}.nc"
      sigm = gpopen dir + "#{var_qh2oliq}.nc","sigm"

      return if gqv.nil? || gps.nil?

      data_name = 'VertIntH2OLiq' 
      ofile = NetCDF.create(dir + data_name + '.nc')
      GPhys::NetCDF_IO.each_along_dims_write([gqv,gps], ofile, 'time') { 
        |h2oliq,ps|  
        
        time = h2oliq.axis("time")    
        
        qc = ps.copy
        qc.units = 'kg.m-2'
#        qc.long_name = 'cloud water'
        qc.long_name = gqv.long_name
        qc.name = data_name
        qc[false] = 0
        
        alph = h2oliq * ps / Grav 
        kmax = h2oliq.axis("sig").length-1
        for i in 0..kmax
          k = kmax-i
          qc = qc + alph[false,k,true] * (sigm[k].val - sigm[k+1].val) 
        end
        [qc]
      }
      ofile.close
      print "[#{data_name}](#{dir}) is created\n"
    end
    # ---------------------------------------

## ץ
parser = GetoptLong.new
parser.set_options(
   ###    global option   ###
   ['--var_qh2oliq',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--var_ps',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

var_qh2oliq = ($OPT_var_qh2oliq||'QH2O')
var_ps = ($OPT_var_qh2oliq||'Ps')
    
calc_vertintH2OLiq_save("./",var_qh2oliq,var_ps)

