#! /usr/bin/ruby

# == USAGE
#   % display_spherical_plott.rb --wsn=2 --prefix=SR_CLT1500_Omega1.0_T42L26_

require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu


script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--saturation_scheme',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--cint_cloud',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--range_cloud',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--range_stream',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--cint_stream',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
#views=NArray.sfloat(72).indgen!(0,5) #
views=NArray.sfloat(36).indgen!(0,10) #

for v in views
  viewpoint=v.to_s
  viewpoint = sprintf("%03d", v)  

  #  print viewpoint
  #  print ' '

  system("#{script_dir}/fig_ts-uv_for-display_flow-vect.rb --xfact1 0.001 --yfact1 0.001 --uxunit 1 --uyunit 1 --loncnt #{viewpoint} --range_val 210:320 --wsn 2 && dclpsrot dcl.ps > #{$OPT_prefix}Ts-UV.ps && convert #{$OPT_prefix}Ts-UV.ps #{$OPT_prefix}Ts-UV_from#{viewpoint}.gif")

end

system("convert -delay 40 -loop 0 Ts-UV_from*.gif anim.gif")


