#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# == USAGE
#   % display_spherical_plott.rb --wsn=2 --prefix=SR_CLT1500_Omega1.0_T42L26_

# 2016-12-17 研究室説明会
#   % /GFD_Dennou_Work3/momoko/SyncRotEarthRad/script/display_spherical_plot_olr-uv-prcp.rb --itr 30 --range_olr 125:310 --wsn 2 --nomark


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu


script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

parser = GetoptLong.new
parser.set_options(
        ###    global option   ###
        ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lon_cnt',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lat_cnt',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--itr',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--cint_prcp',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--cint_cloud',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--range_cloud',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--range_stream',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--range_olr',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--cint_stream',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--nomap',                      GetoptLong::NO_ARGUMENT],
        ['--nomark',                      GetoptLong::NO_ARGUMENT],
        ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||'1')
itr = ($OPT_itr||'1')
val_min, val_max = ($OPT_range_olr||'0:400').split(':')

cint_prcp = ($OPT_cint_prcp||'1')

lon_cnt=($OPT_lon_cnt||'180')
lat_cnt=($OPT_lat_cnt||'0')


views=NArray.sfloat(72).indgen!(0,5) #
#views=NArray.sfloat(36).indgen!(0,10) #

for v in views
  viewpoint=v.to_s
  viewpoint = sprintf("%03d", v)  

  #  print viewpoint
  #  print ' '

# convert で直接 pdf から gif に変換すると透過gif になってしまう.
# ps を経由してみる.

#  system("#{script_dir}/fig_ts-uv_for-display_flow-vect_prcp.rb --loncnt #{viewpoint} --wsn #{wsn} --itr #{itr} --cint_prcp #{cint_prcp} --range_val #{val_min}:#{val_max} --nomap")

if($OPT_nomark)
#  system("#{script_dir}/fig_olr-uv_for-display_flow-vect_prcp.rb --loncnt #{viewpoint} --wsn #{wsn} --itr #{itr} --cint_prcp #{cint_prcp} --range_val #{val_min}:#{val_max} --nomap --nomark && convert -crop 380x450+120+150  -rotate 90 dcl.pdf #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.ps && convert #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.ps #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.gif")
    system("#{script_dir}/fig_olr-uv_for-display_flow-vect_prcp.rb --loncnt #{viewpoint} --wsn #{wsn} --itr #{itr} --cint_prcp #{cint_prcp} --range_val #{val_min}:#{val_max} --nomap --nomark && convert -crop 700x700+50+100 -rotate 90 dcl.pdf #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.ps && convert #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.ps #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.gif")
else
#  system("#{script_dir}/fig_olr-uv_for-display_flow-vect_prcp.rb --loncnt #{viewpoint} --wsn #{wsn} --itr #{itr} --cint_prcp #{cint_prcp} --range_val #{val_min}:#{val_max} --nomap && convert -crop 380x450+120+150  -rotate 90 dcl.pdf #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.ps && convert #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.ps #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.gif")
    system("#{script_dir}/fig_olr-uv_for-display_flow-vect_prcp.rb --loncnt #{viewpoint} --wsn #{wsn} --itr #{itr} --cint_prcp #{cint_prcp} --range_val #{val_min}:#{val_max} --nomap && convert -crop 700x700+50+100 -rotate 90 dcl.pdf #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.ps && convert #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.ps #{$OPT_prefix}OLR-UV-PRCP_from#{viewpoint}.gif")

end

end

if wsn == '2' then
#  system("convert -delay 40 -loop 0 Ts-UV-PRCP_from*.gif anim.gif")
  system("convert -delay 40 -loop 0 #{$OPT_prefix}OLR-UV-PRCP_from*.gif anim.gif")
end


