#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# == USAGE
#   % display_spherical_plott.rb --wsn=2 --prefix=SR_CLT1500_Omega1.0_T42L26_

require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu


script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

parser = GetoptLong.new
parser.set_options(
        ###    global option   ###
        ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--cint_cloud',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--range_cloud',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--range_stream',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--cint_stream',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||'1')

views=NArray.sfloat(72).indgen!(0,5) #
#views=NArray.sfloat(36).indgen!(0,10) #

for v in views
  viewpoint=v.to_s
  viewpoint = sprintf("%03d", v)  

  #  print viewpoint
  #  print ' '

# convert で直接 pdf から gif に変換すると透過gif になってしまう.
# ps を経由してみる.

  system("#{script_dir}/fig_ts-uv_for-display_flow-vect_h2oliq.rb --loncnt #{viewpoint} --wsn #{wsn} && convert -rotate 90 dcl.pdf #{$OPT_prefix}Ts-UV-H2OLiq_from#{viewpoint}.ps && convert #{$OPT_prefix}Ts-UV-H2OLiq_from#{viewpoint}.ps #{$OPT_prefix}Ts-UV-H2OLiq_from#{viewpoint}.gif")

#  system("#{script_dir}/fig_ts-uv_for-display_flow-vect_h2oliq.rb --loncnt #{viewpoint} --wsn #{wsn} && convert -rotate 90 dcl.pdf #{$OPT_prefix}Ts-UV-H2OLiq_from#{viewpoint}.png")

end
if wsn == '2' then
  system("convert -delay 40 -loop 0 Ts-UV-H2OLiq_from*.gif anim.gif")
#  system("convert -delay 40 -loop 0 Ts-UV-H2OLiq_from*.png anim.gif")
end


