#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# == USAGE
#   % display_spherical_plott.rb --wsn=2 --prefix=SR_CLT1500_Omega1.0_T42L26_

require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu


script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

parser = GetoptLong.new
parser.set_options(
        ###    global option   ###
        ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lon_cnt',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--lat_cnt',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--itr',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--cint_prcp',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--cint_cloud',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--range_cloud',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--range_temp',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--cint_stream',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
        ['--nomap',                      GetoptLong::NO_ARGUMENT],
        ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||'1')
itr = ($OPT_itr||'1')
val_min, val_max = ($OPT_range_temp||'-40:40').split(':')

cint_prcp = ($OPT_cint_prcp||'1')



lon_cnt=($OPT_lon_cnt||'180')
lat_cnt=($OPT_lat_cnt||'0')
time_start=($OPT_time_start||'100')
time_end=($OPT_time_end||'150')

if($OPT_nomap) then
  system("#{script_dir}/fig_ts-uv_for-display_flow-vect_prcp_timeseries.rb --loncnt #{lon_cnt} --latcnt #{lat_cnt} --wsn #{wsn} --itr #{itr} --cint_prcp #{cint_prcp} --range_time #{time_start}:#{time_end} --nomap --range_val #{val_min}:#{val_max}")
else
  system("#{script_dir}/fig_ts-uv_for-display_flow-vect_prcp_timeseries.rb --loncnt #{lon_cnt} --latcnt #{lat_cnt} --wsn #{wsn} --itr #{itr} --cint_prcp #{cint_prcp} --range_time #{time_start}:#{time_end} --range_val #{val_min}:#{val_max}")
end

  # convert で直接 pdf から gif に変換すると透過gif になってしまう.
  # ps を経由してみる.

#convert -rotate 90 dcl.pdf #{$OPT_prefix}Ts-UV-PRCP_from#{viewpoint}_#{time}.ps && convert #{$OPT_prefix}Ts-UV-PRCP_from#{viewpoint}.ps #{$OPT_prefix}Ts-UV-PRCP_from#{viewpoint}.gif")

#if wsn == '2' then
#  system("convert -delay 40 -loop 0 Ts-UV-PRCP_from*.gif anim.gif")
#end


