#!/bin/bash

RUBY=ruby
SRC=qvap-column_trnsprt_q.rb
#SRC=trnsprt_t.rb
CONVERT="convert -rotate 90"

OUTFILE_FOOT=`basename ${SRC} .rb`

WSN=2

FACT_MEAN=0.1      # Qu
FACT_DISTURB=2.0   # Qu
#FACT_MEAN=0.000005   # Tu
#FACT_DISTURB=0.002   # Tu

#UNIT_MEAN=0.03    # Qu
UNIT_MEAN=0.3    # Qu
UNIT_DISTURB=0.015  # Qu
#UNIT_MEAN=1e4   # Tu
#UNIT_DISTURB=15   # Tu

omegas="0.0 0.15 0.5 1.0"
#omegas="1.0"
#omegas="0.0 0.05 0.1 0.15 0.2 0.25 0.33 0.4 0.5 0.6 0.67 0.8 1.0"
#omegas="0.5"


### mean
t=1
for omega in ${omegas}; do
    ${RUBY} ${SRC} \
	--omega ${omega} \
	--xfact1 ${FACT_MEAN} --yfact1 ${FACT_MEAN} \
	--uxunit ${UNIT_MEAN} --uyunit ${UNIT_MEAN} \
	--type ${t} --wsn ${WSN}
    if [ -e dcl.ps ]; then
	name=Omega${omega}_${OUTFILE_FOOT}_all
	dclpsrmcm dcl.ps | dclpsrot | dclpsmargin > ${name}.eps
	convert ${name}.eps ${name}.png
    fi
    rm -f dcl.ps
done


rm -f dcl.ps
