#!/bin/bash

DATA_HOME=/GFD_Dennou_Work3/momoko/SyncRotEarthRad
SRC="wind-vector_geopot.rb"

WSN=2
#WSN=4


EDDY=0
#EDDY=1

sigma="0.2"
#sigma="0.8"

if [ "${EDDY}" == 0 ]; then
  if [ "${sigma}" == "0.2" ]; then
#    range="128000:148000"
    interval=500
  elif [ "${sigma}" == "0.8" ]; then
#    range="14000:17200"
    interval=200
  fi
else
#  range="-9000:6000"
  interval=500
fi


#for omega in 0.0 0.15 0.5 1.0; do
#for omega in 0.75; do
for omega in 0.15; do
  for sigma in  0.994997 0.9799879 0.9499499 0.8998809 0.8297704 0.7446762 0.6495416 0.549458  0.4544692 0.3694841 0.2945043 0.2295327 0.1745732 0.1244002 0.07398599 0.02074756; do

  dir=${DATA_HOME}/101220_diff-DryAir-Vapor_T21L16_sr_Omega${omega}_dt20m
#  ln -s ${dir}/Temp.nc .
#  ruby geopotential.rb --var Temp.nc@Temp --range_time 1000:2000

  if [ "${EDDY}" == 0 ]; then
      name=Omega${omega}E_wind_vector_geopot_sigma${sigma}
      ruby ${SRC} --wsn ${WSN} --omega ${omega} --sigma ${sigma} \
	--int ${interval}
    else
      name=Omega${omega}E_wind_vector_geopot_sigma${sigma}_eddy
      ruby ${SRC} --wsn ${WSN} --omega ${omega} --sigma ${sigma} \
	--int ${interval} --eddy
    fi

    if [ -e dcl.ps ]; then
      dclpsrmcm dcl.ps | dclpsrot | dclpsmargin > ${name}.eps
    fi

    rm -f *.nc dcl.ps
  done
done
