#! /usr/bin/ruby
# -*- coding: euc-jp -*-

require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

## ץ
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--time_start',            GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_end',              GetoptLong::REQUIRED_ARGUMENT],
                   ['--cint',                  GetoptLong::REQUIRED_ARGUMENT],
                   ['--wsn',                   GetoptLong::REQUIRED_ARGUMENT],
                   ['--prefix',                GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||4)
 
time_start = ($OPT_time_start||1).to_s
time_end = ($OPT_time_end||9999).to_s

timespan = time_start + ':' + time_end

#cint = ($OPT_cint||1e-6).to_f
cint = ($OPT_cint||1e-6)

p 'cint', cint


# itr=2
p "#{script_dir}/fig_DTempDtRadL.rb  --cint=#{cint} --itr=2 --lon=0:180 --lat=0 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadLBand_dayside_itr2.ps && convert #{$OPT_prefix}DTempDtRadLBand_dayside_itr2.ps #{$OPT_prefix}DTempDtRadLBand_dayside_itr2.png"

system("#{script_dir}/fig_DTempDtRadL.rb  --cint=#{cint} --itr=2 --lon=0:180 --lat=0 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadLBand_dayside_itr2.ps && convert #{$OPT_prefix}DTempDtRadLBand_dayside_itr2.ps #{$OPT_prefix}DTempDtRadLBand_dayside_itr2.png")

system("#{script_dir}/fig_DTempDtRadL.rb  --cint=#{cint} --itr=2 --lon=180:360 --lat=0 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadLBand_nightside_itr2.ps && convert #{$OPT_prefix}DTempDtRadLBand_nightside_itr2.ps #{$OPT_prefix}DTempDtRadLBand_nightside_itr2.png")

system("#{script_dir}/fig_DTempDtRadL.rb  --cint=#{cint} --itr=2 --lon=180 --lat=0 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadLBand_lon180_itr2.ps && convert #{$OPT_prefix}DTempDtRadLBand_lon180_itr2.ps #{$OPT_prefix}DTempDtRadLBand_lon180_itr2.png")

system("#{script_dir}/fig_DTempDtRadL.rb --cint=#{cint} --itr=2 --lon=90 --lat=0 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadLBand_lon90_itr2.ps && convert #{$OPT_prefix}DTempDtRadLBand_lon90_itr2.ps #{$OPT_prefix}DTempDtRadLBand_lon90_itr2.png")

system("gpview DTempDtRadL.nc@DTempDtRadL,lat=0 --mean time --cint=1e-5 --itr=2 --wsn=#{wsn}  --noannotate && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadL_lat0_itr2.ps && convert #{$OPT_prefix}DTempDtRadL_lat0_itr2.ps #{$OPT_prefix}DTempDtRadL_lat0_itr2.png")

system("gpview DTempDtRadL.nc@DTempDtRadL,lon=90 --mean time --cint=1e-5 --itr=2 --wsn=#{wsn}  --noannotate && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadL_lon90_itr2.ps && convert #{$OPT_prefix}DTempDtRadL_lon90_itr2.ps #{$OPT_prefix}DTempDtRadL_lon90_itr2.png")

system("gpview DTempDtRadL.nc@DTempDtRadL,lon=180 --mean time --cint=1e-5 --itr=2 --wsn=#{wsn}  --noannotate && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadL_lon180_itr2.ps && convert #{$OPT_prefix}DTempDtRadL_lon180_itr2.ps #{$OPT_prefix}DTempDtRadL_lon180_itr2.png")


# itr=1
system("#{script_dir}/fig_DTempDtRadL.rb  --cint=#{cint} --itr=1 --lon=0:180 --lat=0 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadLBand_dayside_itr1.ps && convert #{$OPT_prefix}DTempDtRadLBand_dayside_itr1.ps #{$OPT_prefix}DTempDtRadLBand_dayside_itr1.png")

system("#{script_dir}/fig_DTempDtRadL.rb  --cint=#{cint} --itr=1 --lon=180:360 --lat=0 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadLBand_nightside_itr1.ps && convert #{$OPT_prefix}DTempDtRadLBand_nightside_itr1.ps #{$OPT_prefix}DTempDtRadLBand_nightside_itr1.png")

system("#{script_dir}/fig_DTempDtRadL.rb  --cint=#{cint} --itr=1 --lon=180 --lat=0 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadLBand_lon180_itr1.ps && convert #{$OPT_prefix}DTempDtRadLBand_lon180_itr1.ps #{$OPT_prefix}DTempDtRadLBand_lon180_itr1.png")

system("#{script_dir}/fig_DTempDtRadL.rb --cint=#{cint} --itr=1 --lon=90 --lat=0 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadLBand_lon90_itr1.ps && convert #{$OPT_prefix}DTempDtRadLBand_lon90_itr1.ps #{$OPT_prefix}DTempDtRadLBand_lon90_itr1.png")

system("gpview DTempDtRadL.nc@DTempDtRadL,lat=0 --mean time --cint=1e-5 --itr=1 --wsn=#{wsn}  --noannotate && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadL_lat0_itr1.ps && convert #{$OPT_prefix}DTempDtRadL_lat0_itr1.ps #{$OPT_prefix}DTempDtRadL_lat0_itr1.png")

system("gpview DTempDtRadL.nc@DTempDtRadL,lon=90 --mean time --cint=1e-5 --itr=1 --wsn=#{wsn}  --noannotate && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadL_lon90_itr1.ps && convert #{$OPT_prefix}DTempDtRadL_lon90_itr1.ps #{$OPT_prefix}DTempDtRadL_lon90_itr1.png")

system("gpview DTempDtRadL.nc@DTempDtRadL,lon=180 --mean time --cint=1e-5 --itr=1 --wsn=#{wsn}  --noannotate && dclpsrot dcl.ps > #{$OPT_prefix}DTempDtRadL_lon180_itr1.ps && convert #{$OPT_prefix}DTempDtRadL_lon180_itr1.ps #{$OPT_prefix}DTempDtRadL_lon180_itr1.png")
