#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# 同期回転惑星計算用描画スクリプト
# == 説明
# * このスクリプトは dcpam 実験の結果の図を作成するもの.
#
# * 季節平均の図を作成する.
#   1 つの netCDF ファイルに 12 月から 11 月までのデータが格納
#   されている場合のみを想定している.
#   各季節の長さは決めうち:
#     冬 (DJF) : 12/01 に相当する日から 90 日(31 + 31 + 28)
#     春 (MAM) : 冬の次の日から 92 日(31 + 30 + 31)
#     夏 (JJA) : 春の次の日から 92 日(30 + 31 + 31)
#     秋 (SON) : 夏の次の日から 91 日(30+31+30)
#   冬の始まりの日 (12/01 に相当) をオプションで指定する.
#    
# * このスクリプトでは, gpview, fig_heatflux-lat-dependence.rb などの
#   スクリプトが使われる.
# * 使用する場合には, fig_heatflux-lat-dependence.rb などを格納した
#   ディレクトリを指定する必要がある.
#   そのために, script_dir を適宜書き換えねばならない.
#
# == オプション
# --djf_start  冬の始まりの日 (12/01 に相当)
#              例: 700 (2 年目の12月), 1065
# --wsn        出力先. ps だったら --wsn=2
# --prefix     生成する画像ファイルに付ける接頭詞
#
# == USAGE
#   % fig_SeasonalMean.rb --djf_start=700  --prefix=EXPNAME_ --wsn=2 
#
# == 履歴
# * 2013-07-14 石渡正樹 作成


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

## オプション解析
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
   ['--wsn',           GetoptLong::REQUIRED_ARGUMENT],
   ['--djf_start',     GetoptLong::REQUIRED_ARGUMENT],
   ['--range_stream',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--cint_stream',                      GetoptLong::REQUIRED_ARGUMENT],
   ['--prefix',        GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||1)
djf_start = ($OPT_djf_start||700).to_f

djf_end = djf_start + 89

mma_start = djf_end + 1
mma_end = mma_start + 91
 
jja_start = mma_end + 1
jja_end = jja_start + 91

son_start = jja_end + 1
son_end = son_start + 90

# 2 年目の 12 月から始める場合 (3 年計算)
#djf_start = 700
#djf_end = 789
#mma_start = 790
#mma_end = 881
#jja_start = 882
#jja_end = 973
#son_start = 974
#son_end = 1064

# 3 年目の 12 月から始める場合 (4 年計算)
#djf_start = 1065
#djf_end = 1154
#mma_start = 1155
#mma_end = 1246
#jja_start = 1247
#jja_end = 1338
#son_start = 1339
#son_end = 1429

range_stream = ($OPT_range_stream||'-9e10:9e10')
minval_stream = range_stream.split(':')[0].to_f
maxval_stream = range_stream.split(':')[1].to_f
cint_stream = ($OPT_cint_stream||1.5e10).to_f

# 質量流線関数
if File.exist?('MSF.nc') then
  puts("MESSAGE: file exists. process skipped.")
else
  exec("ruby #{script_dir}/calc_msf.rb")
end

# 土壌データ
if File.exist?("#{$OPT_prefix}SoilTemp_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SoilTemp.nc@SoilTemp,ssz=-0.88,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SoilTemp_DJF.png")
end  

if File.exist?("#{$OPT_prefix}SoilTemp_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SoilTemp.nc@SoilTemp,ssz=-0.88,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SoilTemp_MMA.png")
end

if File.exist?("#{$OPT_prefix}SoilTemp_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SoilTemp.nc@SoilTemp,ssz=-0.88,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SoilTemp_JJA.png")
end

if File.exist?("#{$OPT_prefix}SoilTemp_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SoilTemp.nc@SoilTemp,ssz=-0.88,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SoilTemp_SON.png")
end

if File.exist?("#{$OPT_prefix}SoilMoist_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SoilMoist.nc@SoilMoist,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SoilMoist_DJF.png")
end

if File.exist?("#{$OPT_prefix}SoilMoist_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SoilMoist.nc@SoilMoist,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SoilMoist_MMA.png")
end

if File.exist?("#{$OPT_prefix}SoilMoist_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SoilMoist.nc@SoilMoist,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SoilMoist_JJA.png")
end

if File.exist?("#{$OPT_prefix}SoilMoist_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SoilMoist.nc@SoilMoist,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SoilMoist_SON.png")
end

# 2 次元データ

if File.exist?("#{$OPT_prefix}SurfTemp_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{djf_start}:#{djf_end} --mean time --range=150:400 --wsn=#{wsn} --int=15 --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SurfTemp_DJF.png")
end

if File.exist?("#{$OPT_prefix}SurfTemp_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{mma_start}:#{mma_end} --mean time --range=150:400 --wsn=#{wsn} --int=15 --noannotate && #{script_dir}/conv_image.rb  #{$OPT_prefix}SurfTemp_MMA.png")
end

if File.exist?("#{$OPT_prefix}SurfTemp_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{jja_start}:#{jja_end} --mean time --range=150:400 --wsn=#{wsn} --int=15 --noannotate && #{script_dir}/conv_image.rb  #{$OPT_prefix}SurfTemp_JJA.png")
end

if File.exist?("#{$OPT_prefix}SurfTemp_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SurfTemp.nc@SurfTemp,time=#{son_start}:#{son_end} --mean time --range=150:400 --wsn=#{wsn} --int=15 --noannotate && #{script_dir}/conv_image.rb  #{$OPT_prefix}SurfTemp_SON.png")
end


if File.exist?("#{$OPT_prefix}OLRA_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview OLRA.nc@OLRA,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --noannotate --sint=10 --range=110:320 && #{script_dir}/conv_image.rb #{$OPT_prefix}OLRA_DJF.png")
end

if File.exist?("#{$OPT_prefix}OLRA_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview OLRA.nc@OLRA,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --noannotate --sint=10 --range=110:320 && #{script_dir}/conv_image.rb #{$OPT_prefix}OLRA_MMA.png")
end

if File.exist?("#{$OPT_prefix}OLRA_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview OLRA.nc@OLRA,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --noannotate --sint=10 --range=110:320 && #{script_dir}/conv_image.rb #{$OPT_prefix}OLRA_JJA.png")
end

if File.exist?("#{$OPT_prefix}OLRA_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview OLRA.nc@OLRA,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --noannotate --sint=10 --range=110:320 && #{script_dir}/conv_image.rb #{$OPT_prefix}OLRA_SON.png")
end

if File.exist?("#{$OPT_prefix}PRCP_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview PRCP.nc@PRCP,time=#{djf_start}:#{djf_end} --mean time --range=0:1e-6 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}PRCP_DJF.png")
end

if File.exist?("#{$OPT_prefix}PRCP_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview PRCP.nc@PRCP,time=#{mma_start}:#{mma_end} --mean time --range=0:1e-6 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}PRCP_MMA.png")
end

if File.exist?("#{$OPT_prefix}PRCP_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview PRCP.nc@PRCP,time=#{jja_start}:#{jja_end} --mean time --range=0:1e-6 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}PRCP_JJA.png")
end

if File.exist?("#{$OPT_prefix}PRCP_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview PRCP.nc@PRCP,time=#{son_start}:#{son_end} --mean time --range=0:1e-6 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}PRCP_SON.png")
end


if File.exist?("#{$OPT_prefix}SurfH2OVapFluxU_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SurfH2OVapFluxU.nc@SurfH2OVapFluxU,time=#{djf_start}:#{djf_end} --mean time --range=0:1e-4 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SurfH2OVapFluxU_DJF.png")
end

if File.exist?("#{$OPT_prefix}SurfH2OVapFluxU_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SurfH2OVapFluxU.nc@SurfH2OVapFluxU,time=#{mma_start}:#{mma_end} --mean time --range=0:1e-4 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SurfH2OVapFluxU_MMA.png")
end

if File.exist?("#{$OPT_prefix}SurfH2OVapFluxU_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SurfH2OVapFluxU.nc@SurfH2OVapFluxU,time=#{jja_start}:#{jja_end} --mean time --range=0:1e-4 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SurfH2OVapFluxU_JJA.png")
end

if File.exist?("#{$OPT_prefix}SurfH2OVapFluxU_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SurfH2OVapFluxU.nc@SurfH2OVapFluxU,time=#{son_start}:#{son_end} --mean time --range=0:1e-4 --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SurfH2OVapFluxU_SON.png")
end


if File.exist?("#{$OPT_prefix}EvapU_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview EvapU.nc@EvapU,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}EvapU_DJF.png")
end

if File.exist?("#{$OPT_prefix}EvapU_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview EvapU.nc@EvapU,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}EvapU_MMA.png")
end

if File.exist?("#{$OPT_prefix}EvapU_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview EvapU.nc@EvapU,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}EvapU_JJA.png")
end

if File.exist?("#{$OPT_prefix}EvapU_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview EvapU.nc@EvapU,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}EvapU_SON.png")
end


if File.exist?("#{$OPT_prefix}SensA_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SensA.nc@SensA,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SensA_DJF.png")
end

if File.exist?("#{$OPT_prefix}SensA_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SensA.nc@SensA,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SensA_MMA.png")
end

if File.exist?("#{$OPT_prefix}SensA_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SensA.nc@SensA,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SensA_JJA.png")
end

if File.exist?("#{$OPT_prefix}SensA_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SensA.nc@SensA,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SensA_SON.png")
end


if File.exist?("#{$OPT_prefix}OSRA_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview OSRA.nc@OSRA,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}OSRA_DJF.png")
end

if File.exist?("#{$OPT_prefix}OSRA_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview OSRA.nc@OSRA,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}OSRA_MMA.png")
end

if File.exist?("#{$OPT_prefix}OSRA_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview OSRA.nc@OSRA,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}OSRA_JJA.png")
end

if File.exist?("#{$OPT_prefix}OSRA_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview OSRA.nc@OSRA,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}OSRA_SON.png")
end


if File.exist?("#{$OPT_prefix}SSRA_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SSRA.nc@SSRA,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SSRA_DJF.png")
end

if File.exist?("#{$OPT_prefix}SSRA_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SSRA.nc@SSRA,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SSRA_MMA.png")
end

if File.exist?("#{$OPT_prefix}SSRA_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SSRA.nc@SSRA,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SSRA_JJA.png")
end

if File.exist?("#{$OPT_prefix}SSRA_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SSRA.nc@SSRA,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}SSRA_SON.png")
end


if File.exist?("#{$OPT_prefix}Ps_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Ps.nc@Ps,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}Ps_DJF.png")
end

if File.exist?("#{$OPT_prefix}Ps_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Ps.nc@Ps,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}Ps_MMA.png")
end

if File.exist?("#{$OPT_prefix}Ps_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Ps.nc@Ps,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}Ps_JJA.png")
end

if File.exist?("#{$OPT_prefix}Ps_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Ps.nc@Ps,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}Ps_SON.png")
end



# 相対湿度
if File.exist?("#{$OPT_prefix}RelHumid_mean0-360_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview RelHumid.nc@RelHumid,sig=1.0:0.0,time=#{djf_start}:#{djf_end} --mean lon,time --wsn=#{wsn} --noannotate --range=0:1.0 && #{script_dir}/conv_image.rb #{$OPT_prefix}RelHumid_mean0-360_DJF.png")
end

if File.exist?("#{$OPT_prefix}RelHumid_mean0-360_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview RelHumid.nc@RelHumid,sig=1.0:0.0,time=#{mma_start}:#{mma_end} --mean lon,time --wsn=#{wsn} --noannotate --range=0:1.0 && #{script_dir}/conv_image.rb #{$OPT_prefix}RelHumid_mean0-360_MMA.png")
end

if File.exist?("#{$OPT_prefix}RelHumid_mean0-360_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview RelHumid.nc@RelHumid,sig=1.0:0.0,time=#{jja_start}:#{jja_end} --mean lon,time --wsn=#{wsn} --noannotate --range=0:1.0 && #{script_dir}/conv_image.rb #{$OPT_prefix}RelHumid_mean0-360_JJA.png")
end

if File.exist?("#{$OPT_prefix}RelHumid_mean0-360_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview RelHumid.nc@RelHumid,sig=1.0:0.0,time=#{son_start}:#{son_end} --mean lon,time --wsn=#{wsn} --noannotate --range=0:1.0 && #{script_dir}/conv_image.rb #{$OPT_prefix}RelHumid_mean0-360_SON.png")
end




# 温度
if File.exist?("#{$OPT_prefix}Temp_mean0-360_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,time=#{djf_start}:#{djf_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-360_DJF.png")
end

if File.exist?("#{$OPT_prefix}Temp_mean0-360_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,time=#{mma_start}:#{mma_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-360_MMA.png")
end

if File.exist?("#{$OPT_prefix}Temp_mean0-360_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,time=#{jja_start}:#{jja_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-360_JJA.png")
end

if File.exist?("#{$OPT_prefix}Temp_mean0-360_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,time=#{son_start}:#{son_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-360_SON.png")
end



if File.exist?("#{$OPT_prefix}Temp_sig0.1_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.1,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_sig0.1_DJF.png")
end

if File.exist?("#{$OPT_prefix}Temp_sig0.1_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.1,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_sig0.1_MMA.png")
end

if File.exist?("#{$OPT_prefix}Temp_sig0.1_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.1,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_sig0.1_JJA.png")
end

if File.exist?("#{$OPT_prefix}Temp_sig0.1_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.1,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_sig0.1_SON.png")
end


if File.exist?("#{$OPT_prefix}Temp_sig0.077_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.077,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_sig0.077_DJF.png")
end

if File.exist?("#{$OPT_prefix}Temp_sig0.077_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.077,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_sig0.077_MMA.png")
end

if File.exist?("#{$OPT_prefix}Temp_sig0.077_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.077,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_sig0.077_JJA.png")
end

if File.exist?("#{$OPT_prefix}Temp_sig0.077_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,sig=0.077,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_sig0.077_SON.png")
end


if File.exist?("#{$OPT_prefix}Temp_lat0_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lat=0,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_lat0_DJF.png")
end

if File.exist?("#{$OPT_prefix}Temp_lat0_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lat=0,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_lat0_MMA.png")
end

if File.exist?("#{$OPT_prefix}Temp_lat0_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lat=0,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_lat0_JJA.png")
end

if File.exist?("#{$OPT_prefix}Temp_lat0_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lat=0,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_lat0_SON.png")
end


# 東西風
if File.exist?("#{$OPT_prefix}U_mean0-360_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,time=#{djf_start}:#{djf_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-360_DJF.png")
end

if File.exist?("#{$OPT_prefix}U_mean0-360_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,time=#{mma_start}:#{mma_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-360_MMA.png")
end

if File.exist?("#{$OPT_prefix}U_mean0-360_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,time=#{jja_start}:#{jja_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-360_JJA.png")
end

if File.exist?("#{$OPT_prefix}U_mean0-360_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,time=#{son_start}:#{son_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-360_SON.png")
end

if File.exist?("#{$OPT_prefix}U_sig0.1_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,sig=0.1,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_sig0.1_DJF.png")
end

if File.exist?("#{$OPT_prefix}U_sig0.1_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,sig=0.1,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_sig0.1_MMA.png")
end

if File.exist?("#{$OPT_prefix}U_sig0.1_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,sig=0.1,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_sig0.1_JJA.png")
end

if File.exist?("#{$OPT_prefix}U_sig0.1_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,sig=0.1,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_sig0.1_SON.png")
end


if File.exist?("#{$OPT_prefix}U_sig0.077_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,sig=0.077,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_sig0.077_DJF.png")
end

if File.exist?("#{$OPT_prefix}U_sig0.077_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,sig=0.077,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_sig0.077_MMA.png")
end

if File.exist?("#{$OPT_prefix}U_sig0.077_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,sig=0.077,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_sig0.077_JJA.png")
end

if File.exist?("#{$OPT_prefix}U_sig0.077_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,sig=0.077,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_sig0.077_SON.png")
end

if File.exist?("#{$OPT_prefix}U_lat0_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,lat=0,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_lat0_DJF.png")
end

if File.exist?("#{$OPT_prefix}U_lat0_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,lat=0,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb  #{$OPT_prefix}U_lat0_MMA.png")
end

if File.exist?("#{$OPT_prefix}U_lat0_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,lat=0,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb  #{$OPT_prefix}U_lat0_JJA.png")
end

if File.exist?("#{$OPT_prefix}U_lat0_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview U.nc@U,lat=0,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-60:100 && #{script_dir}/conv_image.rb  #{$OPT_prefix}U_lat0_SON.png")
end


# 南北風
if File.exist?("#{$OPT_prefix}V_mean0-360_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,time=#{djf_start}:#{djf_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-360_DJF.png")
end

if File.exist?("#{$OPT_prefix}V_mean0-360_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,time=#{mma_start}:#{mma_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-360_MMA.png")
end

if File.exist?("#{$OPT_prefix}V_mean0-360_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,time=#{jja_start}:#{jja_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-360_JJA.png")
end

if File.exist?("#{$OPT_prefix}V_mean0-360_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,time=#{son_start}:#{son_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-360_SON.png")
end


if File.exist?("#{$OPT_prefix}V_sig0.1_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.1,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_sig0.1_DJF.png")
end

if File.exist?("#{$OPT_prefix}V_sig0.1_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.1,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_sig0.1_MMA.png")
end

if File.exist?("#{$OPT_prefix}V_sig0.1_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.1,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_sig0.1_JJA.png")
end

if File.exist?("#{$OPT_prefix}V_sig0.1_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.1,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_sig0.1_SON.png")
end


if File.exist?("#{$OPT_prefix}V_sig0.077_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.077,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_sig0.077_DJF.png")
end

if File.exist?("#{$OPT_prefix}V_sig0.077_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.077,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_sig0.077_MMA.png")
end

if File.exist?("#{$OPT_prefix}V_sig0.077_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.077,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_sig0.077_JJA.png")
end

if File.exist?("#{$OPT_prefix}V_sig0.077_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview V.nc@V,sig=0.077,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_sig0.077_SON.png")
end

# 鉛直風
if File.exist?("#{$OPT_prefix}SigDot_mean0-360_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,time=#{djf_start}:#{djf_end},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean0-360_DJF.png")
end

if File.exist?("#{$OPT_prefix}SigDot_mean0-360_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,time=#{mma_start}:#{mma_end},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean0-360_MMA.png")
end

if File.exist?("#{$OPT_prefix}SigDot_mean0-360_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,time=#{jja_start}:#{jja_end},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean0-360_JJA.png")
end

if File.exist?("#{$OPT_prefix}SigDot_mean0-360_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,time=#{son_start}:#{son_end},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean0-360_SON.png")
end


if File.exist?("#{$OPT_prefix}SigDot_sig0.1_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.1,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_sig0.1_DJF.png")
end

if File.exist?("#{$OPT_prefix}SigDot_sig0.1_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.1,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb  #{$OPT_prefix}SigDot_sig0.1_MMA.png")
end

if File.exist?("#{$OPT_prefix}SigDot_sig0.1_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.1,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb  #{$OPT_prefix}SigDot_sig0.1_JJA.png")
end

if File.exist?("#{$OPT_prefix}SigDot_sig0.1_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.1,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb  #{$OPT_prefix}SigDot_sig0.1_SON.png")
end


if File.exist?("#{$OPT_prefix}SigDot_sig0.077_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.077,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_sig0.077_DJF.png")
end

if File.exist?("#{$OPT_prefix}SigDot_sig0.077_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.077,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_sig0.077_MMA.png")
end

if File.exist?("#{$OPT_prefix}SigDot_sig0.077_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.077,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_sig0.077_JJA.png")
end

if File.exist?("#{$OPT_prefix}SigDot_sig0.077_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,sigm=0.077,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate --range=-1e-6:1e-6 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_sig0.077_SON.png")
end


# 比湿
if File.exist?("#{$OPT_prefix}QVap_mean0-360_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=#{djf_start}:#{djf_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=1e-19:1e-2 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-360_DJF.png")
end

if File.exist?("#{$OPT_prefix}QVap_mean0-360_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=#{mma_start}:#{mma_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=1e-19:1e-2 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-360_MMA.png")
end

if File.exist?("#{$OPT_prefix}QVap_mean0-360_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=#{jja_start}:#{jja_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=1e-19:1e-2 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-360_JJA.png")
end

if File.exist?("#{$OPT_prefix}QVap_mean0-360_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,time=#{son_start}:#{son_end} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=1e-19:1e-2 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-360_SON.png")
end


if File.exist?("#{$OPT_prefix}QVap_sig0.1_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,sig=0.1,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_sig0.1_DJF.png")
end

if File.exist?("#{$OPT_prefix}QVap_sig0.1_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,sig=0.1,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_sig0.1_MMA.png")
end

if File.exist?("#{$OPT_prefix}QVap_sig0.1_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,sig=0.1,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_sig0.1_JJA.png")
end

if File.exist?("#{$OPT_prefix}QVap_sig0.1_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,sig=0.1,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_sig0.1_SON.png")
end


if File.exist?("#{$OPT_prefix}QVap_sig0.077_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,sig=0.077,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_sig0.077_DJF.png")
end

if File.exist?("#{$OPT_prefix}QVap_sig0.077_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,sig=0.077,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_sig0.077_MMA.png")
end

if File.exist?("#{$OPT_prefix}QVap_sig0.077_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,sig=0.077,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_sig0.077_JJA.png")
end

if File.exist?("#{$OPT_prefix}QVap_sig0.077_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,sig=0.077,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_sig0.077_SON.png")
end


if File.exist?("#{$OPT_prefix}QVap_lat0_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,lat=0,time=#{djf_start}:#{djf_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --range=1e-19:1e-2 && #{script_dir}/conv_image.rb  #{$OPT_prefix}QVap_lat0_DJF.png")
end

if File.exist?("#{$OPT_prefix}QVap_lat0_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,lat=0,time=#{mma_start}:#{mma_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --range=1e-19:1e-2 && #{script_dir}/conv_image.rb  #{$OPT_prefix}QVap_lat0_MMA.png")
end

if File.exist?("#{$OPT_prefix}QVap_lat0_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,lat=0,time=#{jja_start}:#{jja_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --range=1e-19:1e-2 && #{script_dir}/conv_image.rb  #{$OPT_prefix}QVap_lat0_JJA.png")
end

if File.exist?("#{$OPT_prefix}QVap_lat0_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview QVap.nc@QVap,lat=0,time=#{son_start}:#{son_end} --mean time --wsn=#{wsn} --itr=2 --noannotate --range=1e-19:1e-2 && #{script_dir}/conv_image.rb   #{$OPT_prefix}QVap_lat0_SON.png")
end


# 雲水
if File.exist?("#{$OPT_prefix}H2OLiq_sigmean_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{djf_start}:#{djf_end} --mean sig,time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_sigmean_DJF.png")
end

if File.exist?("#{$OPT_prefix}H2OLiq_sigmean_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{mma_start}:#{mma_end} --mean sig,time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_sigmean_MMA.png")
end

if File.exist?("#{$OPT_prefix}H2OLiq_sigmean_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{jja_start}:#{jja_end} --mean sig,time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_sigmean_JJA.png")
end

if File.exist?("#{$OPT_prefix}H2OLiq_sigmean_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{son_start}:#{son_end} --mean sig,time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_sigmean_SON.png")
end


if File.exist?("#{$OPT_prefix}H2OLiq_lat0_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{djf_start}:#{djf_end},lat=0 --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_lat0_DJF.png")
end

if File.exist?("#{$OPT_prefix}H2OLiq_lat0_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{mma_start}:#{mma_end},lat=0 --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_lat0_MMA.png")
end

if File.exist?("#{$OPT_prefix}H2OLiq_lat0_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{jja_start}:#{jja_end},lat=0 --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_lat0_JJA.png")
end

if File.exist?("#{$OPT_prefix}H2OLiq_lat0_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{son_start}:#{son_end},lat=0 --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_lat0_SON.png")
end


# フラックス (緯度分布)
if File.exist?("#{$OPT_prefix}fluxesA_lonmean_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("#{script_dir}/fig_heatfluxA-lat-dependence.rb --time_start=#{djf_start} --time_end=#{djf_end} --range=0:800 --lon=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxesA_lonmean_DJF.png")
end

if File.exist?("#{$OPT_prefix}fluxesA_lonmean_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("#{script_dir}/fig_heatfluxA-lat-dependence.rb --time_start=#{mma_start} --time_end=#{mma_end} --range=0:800 --lon=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxesA_lonmean_MMA.png")
end

if File.exist?("#{$OPT_prefix}fluxesA_lonmean_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("#{script_dir}/fig_heatfluxA-lat-dependence.rb --time_start=#{jja_start} --time_end=#{jja_end} --range=0:800 --lon=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxesA_lonmean_JJA.png")
end

if File.exist?("#{$OPT_prefix}fluxesA_lonmean_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("#{script_dir}/fig_heatfluxA-lat-dependence.rb --time_start=#{son_start} --time_end=#{son_end} --range=0:800 --lon=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxesA_lonmean_SON.png")
end

# 質量流線関数 (旧版)
if File.exist?("#{$OPT_prefix}MSF0-360_DJF.png") then
  puts("MESSAGE: #{$OPT_prefix}MSF0-360_DJF.png exists. process skipped.")
else
  system("gpview MSF.nc@MSF,time=#{djf_start}:#{djf_end} --mean lon,time --range=#{minval_stream}:#{maxval_stream} --sint=#{cint_stream} --noshade --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}MSF0-360_DJF.png")
end

if File.exist?("#{$OPT_prefix}MSF0-360_MMA.png") then
  puts("MESSAGE: #{$OPT_prefix}MSF0-360_MMA.png exists. process skipped.")
else
  system("gpview MSF.nc@MSF,time=#{mma_start}:#{mma_end} --mean lon,time --range=#{minval_stream}:#{maxval_stream} --sint=#{cint_stream} --noshade --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}MSF0-360_MMA.png")
end

if File.exist?("#{$OPT_prefix}MSF0-360_JJA.png") then
  puts("MESSAGE: #{$OPT_prefix}MSF0-360_JJA.png exists. process skipped.")
else
  system("gpview MSF.nc@MSF,time=#{jja_start}:#{jja_end} --mean lon,time --range=#{minval_stream}:#{maxval_stream} --sint=#{cint_stream} --noshade --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}MSF0-360_JJA.png")
end

if File.exist?("#{$OPT_prefix}MSF0-360_SON.png") then
  puts("MESSAGE: #{$OPT_prefix}MSF0-360_SON.png exists. process skipped.")
else
  system("gpview MSF.nc@MSF,time=#{son_start}:#{son_end} --mean lon,time --range=#{minval_stream}:#{maxval_stream} --int=#{cint_stream} --noshade --clrmap=14 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}MSF0-360_SON.png")
end

exit



# 質量流線関数 (旧版)
if File.exist?("#{$OPT_prefix}MSF0-360_DJF.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("#{script_dir}/mass_stream_func.rb V.nc V Ps.nc Ps --time_start=#{djf_start} --time_end=#{djf_end} --lon_start=0 --lon_end=360 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}StreamFunc0-360_DJF.png")
end

if File.exist?("#{$OPT_prefix}StreamFunc0-360_MMA.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("#{script_dir}/mass_stream_func.rb V.nc V Ps.nc Ps --time_start=#{mma_start} --time_end=#{mma_end} --lon_start=0 --lon_end=360 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}StreamFunc0-360_MMA.png")
end

if File.exist?("#{$OPT_prefix}StreamFunc0-360_JJA.png") then
  puts("MESSAGE: file exists. process skipped.")
eles
  system("#{script_dir}/mass_stream_func.rb V.nc V Ps.nc Ps --time_start=#{jja_start} --time_end=#{jja_end} --lon_start=0 --lon_end=360 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}StreamFunc0-360_JJA.png")
end

if File.exist?("#{$OPT_prefix}StreamFunc0-360_SON.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  system("#{script_dir}/mass_stream_func.rb V.nc V Ps.nc Ps --time_start=#{son_start} --time_end=#{son_end} --lon_start=0 --lon_end=360 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}StreamFunc0-360_SON.png")
end


