#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# 同期回転惑星計算用描画スクリプト
# == 説明
# * このスクリプトは同期回転惑星設定実験の結果の図を作成するものである.
# * このスクリプトでは, gpview, fig_heatflux-lat-dependence.rb などの
#   スクリプトが使われる.
# * 使用する場合には, fig_heatflux-lat-dependence.rb などを格納した
#   ディレクトリを指定する必要がある.
#   そのために, script_dir を適宜書き換えねばならない.
#
# == オプション
# --time_start 開始時刻
# --time_end   終了時刻
# --wsn        出力先. ps だったら --wsn=2
# --prefix     生成する画像ファイルに付ける接頭詞
#
# == USAGE
#   % fig_SyncRot.rb --saturation_scheme=nha --time_start=731 --time_end=1095 --wsn=2 --prefix=EXPNAME_
#
# == 履歴
# * 2013-6-19 石渡正樹 作成


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"


## オプション解析
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--saturation_scheme',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--range_stream',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--cint_stream',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

saturation_scheme = ($OPT_saturation_scheme||nha)

wsn = ($OPT_wsn||4)
 
time_start = ($OPT_time_start||1).to_s
time_end = ($OPT_time_end||9999).to_s

range_stream = ($OPT_range_stream||'-9e10:9e10')
minval_stream = range_stream.split(':')[0].to_f
maxval_stream = range_stream.split(':')[1].to_f

cint_stream = ($OPT_cint_stream||1.5e10).to_f

timespan = time_start + ':' + time_end

# dennou-h でメモリが足りなくなる場合は, 最後の 300 日だけにする.

#p time_end.class

value_time_start_newdata = time_end.to_i - 279
time_start_newdata = value_time_start_newdata.to_s




# 球面プロット

if File.exist?("#{$OPT_prefix}Ts-UV_from150.png") then
  puts("MESSAGE: #{$OPT_prefix}Ts-UV_from150.png exists. process skipped.")
else
  system("#{script_dir}/fig_ts-uv_for-display_flow-vect.rb --xfact1 0.001 --yfact1 0.001 --uxunit 1 --uyunit 1 --loncnt 150 --range_val 230:320 --wsn 2 && #{script_dir}/conv_image.rb #{$OPT_prefix}Ts-UV_from150.png")
end

# 相対湿度の計算 
# 本当は最所から最後までのデータ作りたいが, size が大きすぎると
# 怒られてしまう!! なんとかしたい.
if File.exist?('RelHumid.nc') then
  puts("MESSAGE: RelHumid.nc exists. process skipped.")
else
  system("#{script_dir}/make_RH.rb --saturation_scheme=#{saturation_scheme} --time_start=#{time_start} --time_end=#{time_end}") unless File.exist?('RelHumid.nc')
end




# 0 次元量の時間変化
if File.exist?($OPT_prefix + 'HeatFlux-east_timeseries.png') then
  puts("MESSAGE: #{$OPT_prefix}HeatFlux-east_timeseries.png exists. process skipped.")
else
  system("#{script_dir}/fig_timeseries-heat.rb --region=east --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}HeatFlux-east_timeseries.png")
end

if File.exist?($OPT_prefix + 'HeatFlux-west_timeseries.png') then
  puts("MESSAGE: #{$OPT_prefix}HeatFlux-west_timeseries.png exists. process skipped.")
else
  system("#{script_dir}/fig_timeseries-heat.rb --region=west --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}HeatFlux-west_timeseries.png")
end



# 雲水
if File.exist?("#{$OPT_prefix}H2OLiq_sigmean.png") then
  puts("MESSAGE: #{$OPT_prefix}H2OLiq_sigmean.png exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{timespan} --mean sig,time --wsn=#{wsn}  --cint=2.5e-6 --range=0:2.5e-5 --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_sigmean.png")
end

if File.exist?("#{$OPT_prefix}H2OLiq_lat0.png") then
  puts("MESSAGE: #{$OPT_prefix}H2OLiq_lat0.png exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{timespan},lat=0 --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_lat0.png")
end

if File.exist?("#{$OPT_prefix}H2OLiq_lon90.png") then
  puts("MESSAGE: #{$OPT_prefix}H2OLiq_lon90.png exists. process skipped.")
else
  system("gpview H2OLiq.nc@H2OLiq,time=#{timespan},lon=90 --mean time --wsn=#{wsn}  --noannotate && #{script_dir}/conv_image.rb #{$OPT_prefix}H2OLiq_lon90.png")
end



# 球面プロット
if File.exist?("#{$OPT_prefix}OLR-UV_from0.png") then
  puts("MESSAGE: #{$OPT_prefix}OLR-UV_from0.png exists. process skipped.")
else
  system("#{script_dir}/fig_olr-uv.rb --xfact1 0.001 --yfact1 0.001 --uxunit 1 --uyunit 1 --loncnt 0 --range_val 120:340 --wsn 2 && #{script_dir}/conv_image.rb #{$OPT_prefix}OLR-UV_from0.png")
end

if File.exist?("#{$OPT_prefix}OLR-UV_from90.png") then
  puts("MESSAGE: #{$OPT_prefix}OLR-UV_from90.png exists. process skipped.")
else
  system("#{script_dir}/fig_olr-uv.rb --xfact1 0.001 --yfact1 0.001 --uxunit 1 --uyunit 1 --loncnt 90 --range_val 120:340 --wsn 2 && #{script_dir}/conv_image.rb #{$OPT_prefix}OLR-UV_from90.png")
end

if File.exist?("#{$OPT_prefix}OLR-UV_from180.png") then
  puts("MESSAGE: #{$OPT_prefix}OLR-UV_from180.png exists. process skipped.")
else
  system("#{script_dir}/fig_olr-uv.rb --xfact1 0.001 --yfact1 0.001 --uxunit 1 --uyunit 1 --loncnt 180 --range_val 120:340 --wsn 2 && #{script_dir}/conv_image.rb #{$OPT_prefix}OLR-UV_from180.png")
end

if File.exist?("#{$OPT_prefix}OLR-UV_from270.png") then
  puts("MESSAGE: #{$OPT_prefix}OLR-UV_from270.png exists. process skipped.")
else
  system("#{script_dir}/fig_olr-uv.rb --xfact1 0.001 --yfact1 0.001 --uxunit 1 --uyunit 1 --loncnt 270 --range_val 120:340 --wsn 2 && #{script_dir}/conv_image.rb #{$OPT_prefix}OLR-UV_from270.png")
end



## 3 次元データ

# 温度
if File.exist?("#{$OPT_prefix}Temp_mean0-180_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}Temp_mean0-180_itr2.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lon=0:180,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-180_itr2.png")
end

if File.exist?("#{$OPT_prefix}Temp_mean180-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}Temp_mean180-360_itr2.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lon=180:360,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean180-360_itr2.png")
end

if File.exist?("#{$OPT_prefix}Temp_mean0-180_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}Temp_mean0-180_itr1.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lon=0:180,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean0-180_itr1.png")
end

if File.exist?("#{$OPT_prefix}Temp_mean180-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}Temp_mean180-360_itr1.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lon=180:360,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_mean180-360_itr1.png")
end

if File.exist?("#{$OPT_prefix}Temp_lat0_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}Temp_lat0_itr1.png exists. process skipped.")
else
  system("gpview Temp.nc@Temp,lat=0,time=#{timespan} --mean time --wsn=#{wsn} --itr=1 --noannotate --sint=10 --range=140:300 && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_lat0_itr1.png")
end

if File.exist?($OPT_prefix + 'Temp_daymean-latmean.png') then
  puts("MESSAGE: #{$OPT_prefix}Temp_daymean-latmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_Temp-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --range=140:320 --lon=0:180 --lat=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_daymean-latmean.png")
end

if File.exist?($OPT_prefix + 'Temp_nightmean-latmean.png') then
  puts("MESSAGE: #{$OPT_prefix}Temp_nightmean-latmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_Temp-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --range=140:320 --lon=180:360 --lat=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb  #{$OPT_prefix}Temp_nightmean-latmean.png")
end

if File.exist?($OPT_prefix + 'Temp_daymean-lat0.png') then
  puts("MESSAGE: #{$OPT_prefix}Temp_daymean-lat0.png exists. process skipped.")
else
  system("#{script_dir}/fig_Temp-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --range=140:320 --lon=0:180 --lat=0 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_daymean-lat0.png")
end

if File.exist?($OPT_prefix + 'Temp_nightmean-lat0.png') then
  puts("MESSAGE: #{$OPT_prefix}Temp_nightmean-lat0.png exists. process skipped.")
else
  system("#{script_dir}/fig_Temp-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --range=140:320 --lon=180:360 --lat=0 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}Temp_nightmean-lat0.png")
end



# 東西風
if File.exist?("#{$OPT_prefix}U_mean0-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}U_mean0-360_itr2.png exists. process skipped.")
else
  system("gpview U.nc@U,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --cint=15 --range=-70:110 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-360_itr2.png")
end

if File.exist?("#{$OPT_prefix}U_mean0-180_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}U_mean0-180_itr2.png exists. process skipped.")
else
  system("gpview U.nc@U,lon=0:180,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --cint=15 --range=-70:110 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-180_itr2.png")
end

if File.exist?("#{$OPT_prefix}U_mean180-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}U_mean180-360_itr2.png exists. process skipped.")
else
  system("gpview U.nc@U,lon=180:360,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --cint=15 --range=-70:110 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean180-360_itr2.png")
end

if File.exist?("#{$OPT_prefix}U_sig0.1.png") then
  puts("MESSAGE: #{$OPT_prefix}U_sig0.1.png exists. process skipped.")
else
#  system("gpview U.nc@U,sig=0.1,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --cint=15 --range=-70:1100:100 && dclpsrot dcl.ps > #{$OPT_prefix}U_sig0.1.ps && convert #{$OPT_prefix}U_sig0.1.ps #{$OPT_prefix}U_sig0.1.png")
  system("gpview U.nc@U,sig=0.1,time=#{timespan} --mean time --wsn=#{wsn}  --noannotate --cint=20 --range=-70:150 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_sig0.1.png")
end

if File.exist?("#{$OPT_prefix}U_lat0_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}U_lat0_itr2.png exists. process skipped.")
else
  system("gpview U.nc@U,lat=0,time=#{timespan} --mean time --wsn=#{wsn} --itr=2 --noannotate --cint=15 --range=-70:110 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_lat0_itr2.png")
end

# 東西風
if File.exist?("#{$OPT_prefix}U_mean0-180_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}U_mean0-180_itr1.png exists. process skipped.")
else
  system("gpview U.nc@U,lon=0:180,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --cint=15 --range=-70:110 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean0-180_itr1.png")
end

if File.exist?("#{$OPT_prefix}U_mean180-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}U_mean180-360_itr1.png exists. process skipped.")
else
  system("gpview U.nc@U,lon=180:360,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --cint=15 --range=-70:110 && #{script_dir}/conv_image.rb #{$OPT_prefix}U_mean180-360_itr1.png")
end


# 南北風
if File.exist?("#{$OPT_prefix}V_mean0-180_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}V_mean0-180_itr1.png exists. process skipped.")
else
  system("gpview V.nc@V,lon=0:180,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-180_itr1.png")
end

if File.exist?("#{$OPT_prefix}V_mean180-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}V_mean180-360_itr1.png exists. process skipped.")
else
  system("gpview V.nc@V,lon=180:360,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean180-360_itr1.png")
end

if File.exist?("#{$OPT_prefix}V_mean0-180_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}V_mean0-180_itr2.png exists. process skipped.")
else
  system("gpview V.nc@V,lon=0:180,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean0-180_itr2.png")
end

if File.exist?("#{$OPT_prefix}V_mean180-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}V_mean180-360_itr2.png exists. process skipped.")
else
  system("gpview V.nc@V,lon=180:360,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --sint=10 --range=-50:50 && #{script_dir}/conv_image.rb #{$OPT_prefix}V_mean180-360_itr2.png")
end

# 鉛直風
if File.exist?("#{$OPT_prefix}SigDot_mean0-180_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}SigDot_mean0-180_itr2.png exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,lon=0:180,time=#{timespan},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=-2e-6:2e-6 --cint=1e-7 --clrmap 14 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean0-180_itr2.png")
end

if File.exist?("#{$OPT_prefix}SigDot_mean180-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}SigDot_mean180-360_itr2.png exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,lon=180:360,time=#{timespan},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --range=-2e-6:2e-6 --cint=1e-7 --clrmap 14 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean180-360_itr2.png")
end


if File.exist?("#{$OPT_prefix}SigDot_mean0-180_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}SigDot_mean0-180_itr1.png exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,lon=0:180,time=#{timespan},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --range=-2e-6:2e-6 --cint=1e-7 --clrmap 14 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean0-180_itr1.png")
end

if File.exist?("#{$OPT_prefix}SigDot_mean180-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}SigDot_mean180-360_itr1.png exists. process skipped.")
else
  system("gpview SigDot.nc@SigDot,lon=180:360,time=#{timespan},sigm=1:0.0118 --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --range=-2e-6:2e-6 --cint=1e-7 --clrmap 14 && #{script_dir}/conv_image.rb #{$OPT_prefix}SigDot_mean180-360_itr1.png")
end

# 比湿
if File.exist?("#{$OPT_prefix}QVap_mean0-180_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}QVap_mean0-180_itr2.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,lon=0:180,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --cint=1e-3 --range=1e-19:5e-2 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-180_itr2.png")
end

if File.exist?("#{$OPT_prefix}QVap_mean180-360_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}QVap_mean180-360_itr2.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,lon=180:360,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=2 --noannotate --cint=1e-3 --range=1e-19:5e-2 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean180-360_itr2.png")
end

if File.exist?("#{$OPT_prefix}QVap_lat0_itr2.png") then
  puts("MESSAGE: #{$OPT_prefix}QVap_lat0_itr2.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,lat=0,time=#{timespan} --mean time --wsn=#{wsn} --itr=2 --noannotate --cint=1e-3 --range=1e-19:1e-2 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_lat0_itr2.png")
end

if File.exist?("#{$OPT_prefix}QVap_mean0-180_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}QVap_mean0-180_itr1.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,lon=0:180,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --cint=1e-3 --range=1e-19:1e-2 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean0-180_itr1.png")
end

if File.exist?("#{$OPT_prefix}QVap_mean180-360_itr1.png") then
  puts("MESSAGE: #{$OPT_prefix}QVap_mean180-360_itr1.png exists. process skipped.")
else
  system("gpview QVap.nc@QVap,lon=180:360,time=#{timespan} --mean lon,time --wsn=#{wsn} --itr=1 --noannotate --cint=1e-3 --range=1e-19:1e-2 && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_mean180-360_itr1.png")
end

if File.exist?($OPT_prefix + 'QVap_daymean-latmean.png') then
  puts("MESSAGE: #{$OPT_prefix}QVap_daymean-latmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_q-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --range=1e-9:1e-2 --lon=0:180 --lat=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}QVap_daymean-latmean.png")
end

if File.exist?($OPT_prefix + 'QVap_nightmean-latmean.png') then
  puts("MESSAGE: #{$OPT_prefix}QVap_nightmean-latmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_q-vertical.rb --time_start=#{time_start} --time_end=#{time_end} --range=1e-9:1e-2 --lon=180:360 --lat=mean --wsn=#{wsn} && #{script_dir}/conv_image.rb   #{$OPT_prefix}QVap_nightmean-latmean.png")
end



# 相対湿度
if File.exist?("#{$OPT_prefix}RelHumid_mean180-360.png") then
  puts("MESSAGE: #{$OPT_prefix}RelHumid_mean180-360.png exists. process skipped.")
else
  system("gpview RelHumid.nc@RelHumid,sig=1.0:0.0,lon=180:360,time=#{timespan} --mean lon,time --wsn=#{wsn} --noannotate --range=0:1.0 && #{script_dir}/conv_image.rb #{$OPT_prefix}RelHumid_mean180-360.png") if File.exist?('RelHumid.nc')
end

if File.exist?("#{$OPT_prefix}RelHumid_mean0-180.png") then
  puts("MESSAGE: #{$OPT_prefix}RelHumid_mean0-180.png exists. process skipped.")
else
  system("gpview RelHumid.nc@RelHumid,sig=1.0:0.0,lon=0:180,time=#{timespan} --mean lon,time --wsn=#{wsn} --noannotate --range=0:1.0 && #{script_dir}/conv_image.rb #{$OPT_prefix}RelHumid_mean0-180.png") if File.exist?('RelHumid.nc')
end

# フラックス (緯度分布)
if File.exist?("#{$OPT_prefix}fluxesA_daymean.png") then
  puts("MESSAGE: #{$OPT_prefix}fluxesA_daymean.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatfluxA-lat-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --range=0:800 --lon=0:180 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxesA_daymean.png")
end

if File.exist?("#{$OPT_prefix}fluxesA_nightmean.png") then
  puts("MESSAGE: #{$OPT_prefix}fluxesA_nightmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatfluxA-lat-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --range=0:800 --lon=180:360 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxesA_nightmean.png")
end

if File.exist?("#{$OPT_prefix}fluxes_daymean.png") then
  puts("MESSAGE: #{$OPT_prefix}fluxes_daymean.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatflux-lat-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --range=0:800 --lon=0:180 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxes_daymean.png")
end

if File.exist?("#{$OPT_prefix}fluxes_nightmean.png") then
  puts("MESSAGE: #{$OPT_prefix}fluxes_nightmean.png exists. process skipped.")
else
  system("#{script_dir}/fig_heatflux-lat-dependence.rb --time_start=#{time_start} --time_end=#{time_end} --range=0:800 --lon=180:360 --wsn=#{wsn} && #{script_dir}/conv_image.rb #{$OPT_prefix}fluxes_nightmean.png")
end

#-85.76059, -80.26878: 260K
#-74.74454, -69.21297, -63.67863, -58.14296 : 300K
#    -52.60653, -47.06964, -41.53246, -35.99508, -30.45755: 350K
# -24.91993,
#    -19.38223, -13.84448, -8.306703, -2.768903: 400K
# 2.768903, 8.306703, 13.84448,
#    19.38223, 24.91993: 450K
#    30.45755, 35.99508, 41.53246, 47.06964, 52.60653: 500K
#    58.14296, 63.67863, 69.21297, 74.74454, 80.26878: 550K 85.76059


# 質量流線関数
if File.exist?('MSF.nc') then
  puts("MESSAGE: file exists. process skipped.")
else
  exec("ruby #{script_dir}/calc_msf.rb")
end

if File.exist?("#{$OPT_prefix}MSF0-180.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  exec("gpview MSF.nc@MSF,time=#{timespan},lon=0:179.9 --mean lon,time --wsn=#{wsn} --noannotate --range=#{minval_stream}:#{maxval_stream} --cint=#{cint_stream} && #{script_dir}/conv_image.rb #{$OPT_prefix}MSF0-180.png")
end

if File.exist?("#{$OPT_prefix}MSF180-360.png") then
  puts("MESSAGE: file exists. process skipped.")
else
  exec("gpview MSF.nc@MSF,time=#{timespan},lon=180:360 --mean lon,time --wsn=#{wsn} --noannotate --range=#{minval_stream}:#{maxval_stream} --cint=#{cint_stream} && #{script_dir}/conv_image.rb #{$OPT_prefix}MSF180-360.png")
end

#if File.exist?($OPT_prefix + 'StreamFuncDay.png') then
#  puts("MESSAGE: file exists. process skipped.")
#else
#  system("ruby #{script_dir}/mass_stream_func.rb V.nc V Ps.nc Ps --time_start=#{time_start} --time_end=#{time_end} --lon_start=0 --lon_end=180 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}StreamFunc0-180.ps && convert #{$OPT_prefix}StreamFunc0-180.ps #{$OPT_prefix}StreamFuncDay.png")
#end

#if File.exist?($OPT_prefix + 'StreamFuncNight.png') then
#  puts("MESSAGE: file exists. process skipped.")
#else
#  system("ruby #{script_dir}/mass_stream_func.rb V.nc V Ps.nc Ps --time_start=#{time_start} --time_end=#{time_end} --lon_start=180 --lon_end=360 --wsn=#{wsn} && dclpsrot dcl.ps > #{$OPT_prefix}StreamFunc180-360.ps && convert #{$OPT_prefix}StreamFunc180-360.ps #{$OPT_prefix}StreamFuncNight.png")
#end
