#! /usr/bin/ruby
#
# = fig_Temp-vertical.rb
# == 説明
# * 温度の鉛直構造の図
#   緯度方向の平均は, 重みを使って正しく計算する.
#
# == オプション
# --lon        経度の指定. 経度の値か, 平均をする経度の範囲か, 
#                          mean (帯状平均) を指定する.
# --lat        緯度の指定. 緯度の値か, mean を指定する.
#              範囲指定はできない.
# --time_start 開始時刻
# --time_end   終了時刻
# --range      プロットする値の範囲. min:max という形式で指定する.
# --wsn        出力先. ps だったら --wsn=2
#
# == 使い方
# * 全球平均
#     % fig_Temp-vertical.rb --time_start=731 --time_end=1096 --ragne=1e-9:1e-2 --lon=mean --lat=mean --wsn=2
# * 赤道
#     % fig_Temp-vertical.rb --time_start=731 --time_end=1096 --ragne=1e-9:1e-2 --lat=0 --wsn=2
#
# == 履歴
#
# 2013/06/26 石渡正樹

require 'getoptlong'
require "numru/ggraph"
include NumRu

## 定数設定
latent_heat = 2.5e6

## オプション解析
parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--lon',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--lat',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--range',                      GetoptLong::REQUIRED_ARGUMENT],
                   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
  eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||4)

lat = ($OPT_lat||0).to_s
lon = ($OPT_lon||0).to_s

p lon

time_start = ($OPT_time_start||1).to_f
time_end = ($OPT_time_end||500).to_f

range = ($OPT_range||'200:400')
min = range.split(':')[0].to_f
max = range.split(':')[1].to_f

## データ読み込み, 加工
lat_weight = GPhys::IO.open('OLRA.nc', 'lat_weight').val
nlat = lat_weight.size

temp = GPhys::IO.open('Temp.nc', 'Temp')

temp = temp.cut('time'=>time_start..time_end).mean('time')


if lat == 'mean' then
  temp = 0.5 * (temp*lat_weight.reshape(1, nlat)).sum('lat')
else
  lat = lat.to_f
  temp = temp.cut('lat'=>lat)
end

if lon == 'mean' then
  temp = temp.mean('lon')
elsif lon.include?(':') 
  lon_start = lon.split(':')[0].to_f
  lon_end = lon.split(':')[1].to_f

  temp = temp.cut('lon'=>lon_start..lon_end).mean('lon')


  p lon_start, lon_end


else
  lon = lon.to_f
  temp = temp.cut('lon'=>lon)
end


## 作図
DCL.gropn($OPT_wsn||4)

DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_fig( 'itr'=> 2, 'viewport'=>[0.2,0.8,0.3,0.6] )

GGraph.line( temp, true, "min"=>min, "max"=>max, "index"=>855, "annotate"=>true, "exchange"=>true)



DCL.grcls

