#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# For ONE physical quantity
# 2015-03-10
# 3d data vertical mean, lat mean, lon mean : t-phys
# 2d data lat mean, lon mean : t-phys
# 3d data vertical mean, lon mean : t-y
# 2d data lat mean : t-y


# 日射吸収量の計算
# == 説明
# * このスクリプトは同期回転惑星設定実験の結果の図を作成するものである.
# * このスクリプトでは, gpview, fig_heatflux-lat-dependence.rb などの
#   スクリプトが使われる.
# * 使用する場合には, fig_heatflux-lat-dependence.rb などを格納した
#   ディレクトリを指定する必要がある.
#   そのために, script_dir を適宜書き換えねばならない.
#
# == オプション
# --time_start 開始時刻
# --time_end   終了時刻
# --wsn        出力先. ps だったら --wsn=2
# --prefix     生成する画像ファイルに付ける接頭詞
#
# == USAGE
#   % fig_SyncRot.rb --time_start=731 --time_end=1095 --wsn=2 --prefix=EXPNAME_
#
# == 履歴
# * 2013-6-19 石渡正樹 作成


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

## オプション解析
parser = GetoptLong.new
parser.set_options(
       ###    global option   ###
       ['--time_start',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--time_end',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--range',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT],
       ['--prefix',                      GetoptLong::REQUIRED_ARGUMENT]
                   )
parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

range = ($OPT_range||'0:400')

VAL_MIN =  range.split(':')[0].to_f
VAL_MAX =  range.split(':')[1].to_f

wsn = ($OPT_wsn||4)

LatentHeat = 2.5e6
SBcoeff = 5.67e-8



flux = Hash.new

flux_all = Hash.new


wsn = ($OPT_wsn||4)


time_start = ($OPT_time_start||1)
time_end = ($OPT_time_end||9999)

nomega = 1



## データ読み込み, 加工
var = 'OSRA'
file = var + '.nc'
gp_osr = GPhys::IO.open(file, var).cut('time'=>time_start..time_end)

var = 'OLRA'
file = var + '.nc'
gp_olr = GPhys::IO.open(file, var).cut('time'=>time_start..time_end)

var = 'SSRA'
file = var + '.nc'
gp_ssr = GPhys::IO.open(file, var).cut('time'=>time_start..time_end)

var = 'SurfTemp'
file = var + '.nc'
gp_surftemp = GPhys::IO.open(file, var).cut('time'=>time_start..time_end)

var = 'SurfAlbedo'
file = var + '.nc'
gp_surfalbedo = GPhys::IO.open(file, var).cut('time'=>time_start..time_end)

gp_sigma_t4 = SBcoeff * gp_surftemp*gp_surftemp*gp_surftemp*gp_surftemp

# 以下で EarthRad_CLT1500_Omega1.0_S1366_MS_T42L26 では, OLR とあう.
gp_absorb = - gp_osr 

# 以下が吸収量かと思ったけど違うみたい
#gp_absorb = - gp_osr -  (SBcoeff * gp_surftemp*gp_surftemp*gp_surftemp*gp_surftemp - gp_ssr) / (1 - gp_surfalbedo) - gp_ssr

  # 重みデータの読み込み
  na_lon = GPhys::IO.open(file, 'lon').val
  na_lat = GPhys::IO.open(file, 'lat').val
  na_lat_weight = GPhys::IO.open(file, 'lat_weight').val
  nlon = na_lon.size
  nlat = na_lat.size

  # 空間平均の計算
  gp_absorb = gp_absorb * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
  all = gp_absorb.mean('lon').sum('lat')


  # 空間平均の計算 (OLR)
  gp_olr_mean = gp_olr * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
  gp_olr_mean = gp_olr_mean.mean('lon').sum('lat')

  # 空間平均の計算 (SSR)
  gp_ssr_mean = - gp_ssr * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
  gp_ssr_mean = gp_ssr_mean.mean('lon').sum('lat')

  # 空間平均の計算 (sigma T^4)
  gp_sigma_t4_mean = gp_sigma_t4 * na_lat_weight.reshape(1, nlat) / na_lat_weight.sum
  gp_sigma_t4_mean = gp_sigma_t4_mean.mean('lon').sum('lat')


# 描画
## 描画準備

DCL.gropn(wsn)
    
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
GGraph.set_fig( 'itr'=> 1, 'viewport'=>[0.2,0.8,0.3,0.6] )

GGraph.line( all , true , 'index'=>885, 'max'=>VAL_MAX, 'min'=>VAL_MIN, 'annotate'=>false, 'title'=>'Heat flux')

# OLR は青
GGraph.line( gp_olr_mean , false , 'index'=>285, 'max'=>VAL_MAX, 'min'=>VAL_MIN, 'annotate'=>false, 'title'=>'Heat flux')

#GGraph.line( gp_ssr_mean , false , 'index'=>785, 'max'=>VAL_MAX, 'min'=>VAL_MIN, 'annotate'=>false, 'title'=>'Heat flux')

DCL.grcls

