#! /usr/bin/ruby
# -*- coding: utf-8 -*-

# 陸惑星実験用描画スクリプト
# == 説明
# * このスクリプトは水平平均した物理量の時系列をかくものである.
# * 下にある omegas に描画する Omega の値のリストを設定する.
#
# == オプション
# --lon_start   経度の開始点
# --lon_end   経度の開始点
# --range      プロットする値の範囲. min:max という形式で指定する.
# --inclination      雲の消滅時間
# --wsn        出力先. pdf だったら --wsn=2
#
# == USAGE
#   % fig_lonmean_timeseries.rb --var SoilMoist --range=0:1000 --wsn 2
#
# == 履歴
# * 2013-6-19 石渡正樹 作成
# * 2014-04-22 石渡正樹 論文用の図の作成


require "getoptlong"        # for option_parse
require "numru/ggraph"
include NumRu

script_dir = "/GFD_Dennou_Work3/momoko/SyncRotEarthRad/script"

DATA_HOME = "./"

TMPFILE = "dcl.pdf"

latent_heat = 2.5e6


## オプション解析
parser = GetoptLong.new
parser.set_options(
   ###    global option   ###
   ['--var',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--time_start',               GetoptLong::REQUIRED_ARGUMENT],
   ['--time_end',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--clrmap',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--nlev',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--interval',                 GetoptLong::REQUIRED_ARGUMENT],
   ['--lon_start',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--lon_end',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--lat',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--inclination',                   GetoptLong::REQUIRED_ARGUMENT],
   ['--range',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--header',                    GetoptLong::REQUIRED_ARGUMENT],
   ['--wsn',                      GetoptLong::REQUIRED_ARGUMENT]
)
parser.each_option do |name, arg|
  eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'"  # strage option value to $OPT_val
end

wsn = ($OPT_wsn||1)

header = ($OPT_header||'LP_32p_I23.5_S1366_W20cm')
var = ($OPT_var||'SoilMoist')

time_start = ($OPT_time_start||0).to_f
time_end = ($OPT_time_end||800).to_f

time_interval = ($OPT_interval||40).to_f

lat = ($OPT_lat||0).to_f

lon_start = ($OPT_lon_start||0).to_f
lon_end = ($OPT_lon_end||364).to_f

clrmap = ($OPT_clrmap||9).to_f
nlev = ($OPT_nlev||30).to_f

title = ''

range = ($OPT_range||'0:10000')
VAL_MIN =  range.split(':')[0].to_f
VAL_MAX =  range.split(':')[1].to_f


lux_all = Hash.new

# 出力ファイル名
epsfn = "#{header}_#{var}_y#{lat}_lonmean_lon#{lon_start}-#{lon_end}_timeseries#{time_start}-#{time_end}.eps"
pngfn = "#{header}_#{var}_y#{lat}_lonmean_lon#{lon_start}-#{lon_end}_timeseries#{time_start}-#{time_end}.png"

#time_interval = 40

file = var + '.nc'

gturls=[]

data=[]

latitudes=[0,70,80]

data_time_range=['0:250','251:500','501:800','801:1095','1096:1460',
        '1461:1825','1826:2190','2191:2555','2556:2920','2921:3285',
        '3286:3650','3651:4015','4016:4380','4381:4745','4746:5110',
        '5111:5475','5476:5840','5841:6205','6206:6570','6571:6935',
        '6936:7300','7301:7665','7666:8030','8031:8395','8396:8760',
        '8761:9125','9126:9490','9491:9855','9856:10220','10221:10585',
      '10586:10950','10951:11315','11316:11680','11681:12045','12046:12410',
      '12411:12775','12776:13140','13141:13505','13506:13870','13871:14235',
      '14236:14600','14601:14965','14966:15330','15331:15695','15696:16060',
      '16061:16425','16426:16790','16791:17155','17156:17520','17521:17885',
      '17886:18250','18251:18615','18616:18980','18981:19345','19346:19710',
      '19711:20075','20076:20440','20441:20805','20806:21170','21171:21535',
      '21536:21900','21901:22265','22266:22630','22631:22995','22996:23360',
      '23361:23725','23726:24090','24091:24455','24456:24820','24821:25185',
      '25186:25550','25551:25915','25916:26280','26281:26645','26646:27010',
      '27011:27375','27376:27740','27741:28105','28106:28470','28471:28835',
      '28836:29200','29201:29565','29566:29930','29931:30295','30296:30660',
      '30661:31025','31026:31390','31391:31755','31756:32120']

expnums=[     '01','02','03','04','05','06','07','08','09',
         '10','11','12','13','14','15','16','17','18','19',
         '20','21','22','23','24','25','26','27','28','29',
         '30','31','32','33','34','35','36','37','38','39',
         '40','41','42','43','44','45','46','47','48','49',
         '50','51','52','53','54','55','56','57','58','59',
         '60','61','62','63','64','65','66','67','68','69',
         '70','71'
        ]
#
#,
#
#,'72','73','74','75','76','77','78','79',
#'80','81','82','83','84','85','86','87','88','89']


nexpnum = expnums.size

for i in 0..expnums.size-1
  gturls.push( GPhys::IO.open_gturl("#{header}_#{expnums[i]}/#{var}.nc@#{var},time=#{data_time_range[i]}:#{time_interval}") )
end


#gturl_02 = "LP_32p_Mnoinv_02/#{var}.nc@#{var},time=#{data_time_range[1]}:#{time_interval}"
#gp_02 = GPhys::IO.open_gturl(gturl_02)
#gturls.push(gp_02)
#gp_result = GPhys.join([gp_01, gp_02, gp_03, gp_04])

gp_result = GPhys.join(gturls)

#if var == 'EvapU' then
#  gphys = gphys / latent_heat
#end

# データの切り出し
gphys = gp_result.cut('time'=>time_start..time_end).cut('lon'=>lon_start..lon_end).cut('lat'=>lat)
all = gphys.mean('lon')

p all

# トーンのカラーマップ
DCL.sgscmn(clrmap)   # colormap
#DCL.sgscmn(9)   # colormap: white-blue-black
#DCL.sgscmn(8)   # colormap: white-yellow-red-black
#DCL.sgscmn(2)   # colormap: black-red-yellow-white
#DCL.sgscmn(6)   # colormap: pastel_rainbow 薄すぎてダメ
#DCL.sgscmn(62)   # NCL:BlGrYeOrReVi200
#DCL.sgscmn(53)   # NCL:ncview_default
#DCL.sgscmn(55)   # NCL:rainbow
#DCL.sgscmn(54)   #   NCL:rainbow+white+gray


# 描画
DCL.gropn(wsn)
    
DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)

GGraph.set_axes('xtickint'=>200, 'xlabelint'=>1000)
GGraph.set_axes('ytickint'=>100, 'ylabelint'=>500)
vx0,vx1,vy0,vy1 = 0.15,0.85,0.2,0.55
GGraph.set_fig 'viewport'=>[vx0,vx1,vy0,vy1]
DCL.uscset('cyspos', 'B' )              # move unit y axis
DCL.udlset('LMSG', false)
#DCL::uxmttl('T', '', 0.0)  # title (large character)
#DCL.ugpset('LUMSG', false)   # no message

opt_line = {
   'min'=>VAL_MIN, 'max'=>VAL_MAX,  
   'title'=>'',
   'annotate'=>false,
#   'exchange'=>true,
   'title'=>title
#   'xintv'=>200,
#   'yintv'=>1
}

#GGraph.tone(all , true , opt_tone)
GGraph.line(all , true , opt_line)
#GGraph.color_bar('landscape'=>true)

DCL.grcls

# 画像ファイルの変換
if wsn == '2' then
  if File.exist?(TMPFILE) then
    puts("MESSAGE: post processing ... #{pngfn} will be generate.")
    `#{script_dir}/conv_image.rb #{pngfn}`
  end
end

